// Persistence Of Vision raytracer version 2.0 sample file.

// By David Buck

#declare TextProp1 =
texture {
   pigment {colour Clear}
   halo {
      linear
      max_value 1.0
      spherical_mapping
      emitting
      turbulence 0.5 
      colour_map {
	 [0.0 color rgbt <1.0,0.0,0.0,0.5> ]
	 [1.0 color rgbt <1.0,1.0,0.0,-1.0>]
      }
      samples 10
   }
}

#declare TextProp2 =
texture {
   pigment {colour Clear}
   halo {
      linear
      max_value 1.0
      spherical_mapping
      emitting
      turbulence 0.5 
      colour_map {
	 [0 color rgbt <1.0,0.0,0.0,1> ]
	 [0.02 color rgbt <1.0,0.0,0.0,0.5> ]
	 [1 color rgbt <1.0,1.0,0.0,-1.0>]
      }
      samples 10
   }
}

#declare Very_Dull =
finish {
	specular 0.5
	roughness 0.15
	}

#declare Sale =
pigment {
	gradient x
	color_map {
		[0.0  color Black filter 0.0]
		[1.0  color Black filter 1.0]
		}
	scale <2, 1, 1>
	translate <-1, 0, 0>
	turbulence 0.3
	}

#declare Sale2 =
pigment {
	gradient x
	color_map {
		[0.0  color Black filter 0.0]
		[0.25  color Black filter 0.0]
		[0.75  color Black filter 1.0]
		[1.0  color Black filter 1.0]
		}
	scale <2, 1, 1>
	translate <-1, 0, 0>
	turbulence 0.3
	}

#declare Ecrou5 =  //ecrou de 5cm hauteur 2.5
intersection {
	box {
		<-0.1 /4, 0, -0.05>
		<0.1 /4, 0.1 /4, 0.05>
		}
	box {
		<-0.1 /4, 0, -0.05>
		<0.1 /4, 0.1 /4, 0.05>
		rotate <0, 57, 0>
		}
	box {
		<-0.1 /4, 0, -0.05>
		<0.1 /4, 0.1 /4, 0.05>
		rotate <0, -57, 0>
		}

	texture {
		Polished_Chrome
		}
	}

#declare CouronneEcrou5 =
union {
	object {
		Ecrou5
		translate <0.1, 0, 0>
		}
	object {
		Ecrou5
		translate <0.1, 0, 0>
		rotate <0, 45, 0>
		}
	object {
		Ecrou5
		translate <0.1, 0, 0>
		rotate <0, 90, 0>
		}
	object {
		Ecrou5
		translate <0.1, 0, 0>
		rotate <0, 135, 0>
		}
	object {
		Ecrou5
		translate <0.1, 0, 0>
		rotate <0, 180, 0>
		}
	object {
		Ecrou5
		translate <0.1, 0, 0>
		rotate <0, 225, 0>
		}
	object {
		Ecrou5
		translate <0.1, 0, 0>
		rotate <0, 270, 0>
		}
	object {
		Ecrou5
		translate <0.1, 0, 0>
		rotate <0, 315, 0>
		}

	bounded_by {
		box {
			<-0.15, 0, -0.15>
			<0.15, 0.025, 0.15>
			}
		}
	}

#declare TubeLS =
intersection {
	box {
		<-0.05, 0, -0.1>
		<0.5, 0.3, 0.1>
		}
	torus {
		0.45
		0.05
		rotate <90, 0, 0>
		scale <1, 3/5, 1>
		}

	texture {
		T_Glass3
		}

	bounded_by {
		box {
			<-0.05, 0, -0.1>
			<0.5, 0.3, 0.1>
			}
		}
	}

#declare LaserSource =
union {
	difference {
		cylinder {
			<0,-0.05,0>,       // Center of one end
			<0, 0.4,0>,       // Center of other end
			0.15            // Radius
			}
		box {
			<-1, 0.1 - (0.1 / 4), -1>
			<1, 0.1 , 1>
			}
		box {
			<-1, 0.15 - (0.1 / 4), -1>
			<1, 0.15 , 1>
			}
		box {
			<-1, 0.2 - (0.1 / 4), -1>
			<1, 0.2 , 1>
			}
		}

	cylinder {
		<0,-0.05,0>,       // Center of one end
		<0, 0.3,0>,       // Center of other end
		0.1            // Radius
		}

	texture {
		Polished_Chrome
		}
	texture {
		pigment {
			Sale
			rotate <0, 0, 90>
			scale 0.3
			translate <0, 0.2, 0>
			}
		finish {        Very_Dull }
		}
	}

#declare LaserSocle =
cylinder {
	<0,-0.05,0>,       // Center of one end
	<0,0.1,0>,       // Center of other end
	0.15            // Radius

	texture {
		Polished_Chrome
		}
	texture {
		pigment {
			Sale
			rotate <0, 0, 90>
			scale 0.3
			translate <0.3, 0.2, 0>
			}
		finish {        Very_Dull }
		}
	}

#declare LaserSEns =
union {
	object {        LaserSource }
	object {
		TubeLS
		translate <0.15, 0.09, 0>
		}
	object {
		LaserSocle
		translate <0.6, 0, 0>
		}
	object {
		CouronneEcrou5
		translate <0, 0.4, 0>
		}
	object {
		CouronneEcrou5
		translate <0.6, 0.1, 0>
		}

	sphere {
		<0, 0.4, 0>,
		0.05
		texture {
			T_Glass3
			pigment { Red }
			}
		}

	bounded_by {
		box {
			<-0.15, -0.05, -0.15>
			<0.75, 0.5, 0.15>
			}
		}
	}

#declare CouronneLaser =
union {
	object {
		LaserSEns
		translate <0, 0.8, 0>
		}
	object {
		LaserSEns
		translate <0, 0.8, 0>
		rotate <45, 0, 0>
		}
	object {
		LaserSEns
		translate <0, 0.8, 0>
		rotate <90, 0, 0>
		}
	object {
		LaserSEns
		translate <0, 0.8, 0>
		rotate <135, 0, 0>
		}
	object {
		LaserSEns
		translate <0, 0.8, 0>
		rotate <180, 0, 0>
		}
	object {
		LaserSEns
		translate <0, 0.8, 0>
		rotate <225, 0, 0>
		}
	object {
		LaserSEns
		translate <0, 0.8, 0>
		rotate <270, 0, 0>
		}
	object {
		LaserSEns
		translate <0, 0.8, 0>
		rotate <315, 0, 0>
		}
	}

#declare PaleVectBout =
difference {
	box {
		<-0.2, 0.75, -0.2>
		<0.2, 0.85, 0.2>
		}
	cylinder {
		<-0.3, 0, 0>
		<0.3, 0, 0>
		0.8
		}
	box {
		<-1, 0, -1>
		<1, 1, 1>
		rotate <45, 0, 0>
		translate <0, 0.85, 0.15>
		}
	box {
		<-1, 0, -1>
		<1, 1, 1>
		rotate <-45, 0, 0>
		translate <0, 0.85, -0.15>
		}
	box {
		<-1, -1, -1>
		<0, 1, 1>
		rotate <0, 45, 0>
		translate <-0.3, 0, 0>
		}
	box {
		<-1, -1, -1>
		<0, 1, 1>
		rotate <0, -45, 0>
		translate <-0.3, 0, 0>
		}

	texture {
		pigment { color Gray50 }
		normal {bumps 0.01   scale 0.02}
		finish {
			Very_Dull
			}
		}
	}

#declare ReacteurEnv =
cylinder {
	<-0.6,0,0>,       // Center of one end
	<0.6,0,0>,       // Center of other end
	0.8            // Radius
	open           // Remove end caps

	texture { ReqNonPaint   }
	}

#declare ReacteurCentre =
intersection {
	difference {
		box {
			<-0.6, -2.0, -2.0>
			<0.6, 2.0, 2.0>
			}
		object {
			Ellipsoid
			scale <1.6, 0.8, 0.8>
			translate <-1.4, 0, 0>
			}

		}

		cylinder {
			<-0.7,0,0>,       // Center of one end
			<0.7,0,0>,       // Center of other end
			0.8            // Radius
			}

	texture { ReqNonPaint   }
	}

#declare Propultion1 =
union {
	object { ReacteurCentre }
	object { ReacteurEnv }
	object {
		CouronneLaser
		translate <-0.3, 0, 0>
		}

	object{
	   Sphere
	   hollow texture{ TextProp2 } 
	   rotate <180, 0, 10>
	   scale <2, 1, 1>
	   translate <0.7, 0 ,0>
	   }
	light_source { 
	   <2, 0, 0> 
	   color rgb <1.0, 0.5, 0> 
	   fade_distance 5.0
	   fade_power 2
	   }
	}

#declare Propultion2 =
union {
	object { ReacteurCentre }
	object { ReacteurEnv }
	object {
		CouronneLaser
		translate <-0.3, 0, 0>
		}

	object{
	   Sphere
	   hollow texture{ TextProp2 } 
	   scale <2, 1, 1>
	   translate <0.7, 0 ,0>
	   }
	light_source { 
	   <2, 0, 0> 
	   color rgb <1.0, 0.5, 0> 
	   fade_distance 5.0
	   fade_power 2
	   }
	}

