/***************************************************************************
  Scene fille for rendering Terrain Maker example heightfield

  Created by Eric Jorgensen (1994)
****************************************************************************/


#include "colors.inc"    // The include files contain
#include "shapes.inc"    // pre-defined scene elements
#include "textures.inc"  //  This file has the blue_sky3 texture
#include "glass.inc"
#include "stars.inc"

#include "reqtext.inc"
#include "propul.inc"
#include "requiem.inc"

#declare MilkyWay =
rgb <0.6, 0.6, 0.9>
//rgb <0.2, 0.2, 0.3>
#declare RedWay =
rgb <0.9, 0.6, 0.6>
//rgb <0.3, 0.2, 0.2>
#declare YellowWay =
rgb <0.9, 0.9, 0.6>
//rgb <0.3, 0.3, 0.2>
#declare Trans = -1
#declare YWay =
rgb <0.9, 0.9, 1>

camera {
   location <0, 1.5, -25>
   sky       <0, 1, 0> 
   up        <0, 1, 0>
   right     <4/3, 0, 0>
   look_at   < 0, 1.5, 0> 
}

light_source { 
   <0, 1.5, -25> 
   color White 
   fade_distance 25
   fade_power 2
   }
				    
#declare Textur =
texture {
   pigment {colour Clear}
   halo {
      emitting
      spherical_mapping
      linear
      turbulence .2
      colour_map {
	 [0.0000 color rgbt <0.0,0.0,0.0,1.0>]
	 [0.0500 color rgbt <0.0,0.0,0.0,1.0>]
	 [0.1500 color MilkyWay transmit Trans]
	 [0.2375 color MilkyWay transmit 0.8]
	 [0.3250 color MilkyWay transmit Trans]
	 [0.4125 color MilkyWay transmit 0.6]
	 [0.5875 color MilkyWay*2 transmit Trans]
	 [0.6500 color MilkyWay*2 transmit 0.4]
	 [0.7125 color MilkyWay*3 transmit Trans]
	 [0.7750 color MilkyWay*3 transmit 0.2]
	 [0.8250 color MilkyWay*3.5 transmit Trans]
	 [0.8750 color MilkyWay*3.5 transmit 0]
	 [1.0000 color MilkyWay*4 transmit Trans]
      }
      samples 25
      aa_level 4
      aa_threshold 0.2
   }
}

sphere { 
   <0, 0, 0>, 1
   scale <1.0, 0.1, 1.0>
   hollow 
   texture{ Textur } 
   scale <15000, 10000, 15000>
   rotate <-30, 0, 10>
   translate <-4000, 0, 20000>
   }

object {
   Requiem
   translate <clock, 0, 5.5>
   rotate <0, 80, 0>
	}


sky_sphere {
	pigment {
		bozo
		color_map {
			[ 0.25 color Black]
			[ 0.785 color Black]
			[ 0.80 color White*1.5]
			[ 0.815 color Black]
			[ 0.99975 color Black]
			[ 1.0000 color White*1.5]
			}
		turbulence 1
		sine_wave
		scale 0.005
		}
	}

light_source { 
   <0, 0, 0> 
   color MilkyWay*1.11 
   area_light <1000, 0, 0>, <0, 500, 0>, 5, 5
   rotate <-30, 0, 10>
   translate <-4000, 0, 20000> 
   }

