#declare EnveloppeLaser =
object
	{
	quadric
		{
		<1, 1, 1>, <0, 0, 0> <0, 0, 0>, -1
		scale< 2.0, 0.25, 0.25 >
		}
	}

#declare RequiemReacteurTrou =
object
	{
	union
		{
		intersection
			{
			quadric { <0, 1, 1>, <0, 0, 0>, <0, 0, 0>, -1 }
			box {   <0, -1, -1> <10, 1, 1> }
			}
		quadric { <1, 1, 1>, <0, 0, 0>, <0, 0, 0>, -0.99 }
		}
	}

#declare RequiemReacteur =
object
	{
	difference
		{
		quadric
			{
			<1, 1, 1>, <0, 0, 0>, <0, 0, 0>, -1
			scale<4, 1, 1>
			}
		object { RequiemReacteurTrou }
		}
	bounded_by
		{
		box { <-4, -1, -1> <0, 1, 1> }
		}
	}

#declare ReqProtectReact =
difference {
	union {
		quadric
			{
			<1, 1, 1>, <0, 0, 0>, <0, 0, 0>, -1
			scale<4, 1.01, 1.01>
			}
		difference {
			quadric
				{
				<1, 1, 1>, <0, 0, 0>, <0, 0, 0>, -1
				scale<4, 1.1, 1.1>
				}
			box { <-4, -1.1, -1.1> <-1, 1.1, 1.1> }
			}
		}
	box { <-0.75, -1.1, -1.1> <4, 1.1, 1.1> }
	bounded_by { box { <-4, -1.1, -1.1> <-0.75, 1.1, 1.1> } }
	}

#declare DirecReact =
difference {
	union {
		difference {
			cone { <0, 0.3, 0>,0.35 <0, 0, 0>, 0.5 }
			box { <-1, 0.1, -0.05> <1, 0.25, 0.05> }
			box {
				<-1, 0.1, -0.05> <1, 0.25, 0.05>
				rotate <0, 45, 0>
				}
			box {
				<-1, 0.1, -0.05> <1, 0.25, 0.05>
				rotate <0, 90, 0>
				}
			box {
				<-1, 0.1, -0.05> <1, 0.25, 0.05>
				rotate <0, 135, 0>
				}
			}
		cone { <0, 0.3, 0>,0.325 <0, 0, 0>, 0.475 }
		box { <-1, -0.5, -1> <1, 0, 1> }
		difference {
			box { <-1, -0.5, -1> <1, 0.05, 1> }
			box { <-0.95, -0.5, -0.95> <0.95, 0.1, 0.95> }
			}
		}
	cylinder { <0, 0.1, 0>, <0, 0.4, 0>, 0.25 }
	bounded_by { box { <-1.5, -0.5, -1.5> <1.5, 0.3, 1.5> } }
	}

#declare ReqBase =
object {
difference
	{
	union
		{
		intersection
			{
			quadric { < 0.5, 2, 2 >, < 0, 0, 0 >, < 0, 0, 0 >, -34 }
			quadric
				{
				< 0.5, 2, 2 >, < 0, 0, 0 >, < 0, 0, 0 >, -40
				translate <0, 3, 0>
				}
			}
		quadric
			{
			< 1, 1, 1 >, < 0, 0, 0 >, < 0, 0, 0 >, -1
			scale <6, 2.5, 3>
			translate <1, 3, 0>
			}
		quadric
			{
			< 1, 1, 1 >, < 0, 0, 0 >, < 0, 0, 0 >, -1
			scale <2.5, 2, 2.5>
			translate <-3, 3, 0>
			}
		scale< 1.0, 0.5, 1.0 >
		}
	box{ <-6, 1.75, -2.5> <-4, 2.25, 2.5> }
/*      object
		{
		EnveloppeLaser
		translate< -5, 1, -1.5 >
		}
	object
		{
		EnveloppeLaser
		translate< -5, 1, 1.5 >
		}*/
	object
		{
		RequiemReacteurTrou
		scale <1, 0.83, 1>
		translate< 7, 1, -1>
		}
	object
		{
		RequiemReacteurTrou
		scale <1, 0.83, 1>
		translate< 7, 1, 1>
		}
	}
}

#declare ReqRenfort =
object {
	intersection {
		cylinder {
			<0, -0.2, 0>, <0, 0.4, 0>, 7.6
			scale <1, 1, 0.5>
			}
		cone {
			<0, -0.2, 0>, 7.5 <0, 0.4, 0>, 8.1
			scale <1, 1, 0.5>
			}
		cone {
			<0, -0.2, 0>, 8.1 <0, 0.4, 0>, 7.5
			scale <1, 1, 0.5>
			}
		}
	translate <0, 0.45, 0>
	}

#declare ReqBA1 =
object {
	union {
		quadric {
			< 1, 1, 1 >, < 0, 0, 0 >, < 0, 0, 0 >, -1
			scale <1.5, 0.4, 0.4>
			clipped_by { box {<-1.5, -0.4, -0.4> <0, 0.4, 0.4>} }
			}
		quadric {
			< 1, 1, 1 >, < 0, 0, 0 >, < 0, 0, 0 >, -1
			scale <4.5, 0.4, 0.4>
			clipped_by { box {<0, -0.4, -0.4> <4.5, 0.4, 0.4>} }
			}
		}
	}

#declare ReqBA2 =
difference {
	object { ReqBA1 }
	box { <0.5, -0.05, -0.4> <3.5, 0.05, 0.4> }
	box {
		<0.5, -0.05, -0.4> <3.5, 0.05, 0.4>
		rotate <90, 0, 0>
		}
	box {
		<0.5, -0.05, -0.4> <3.5, 0.05, 0.4>
		rotate <45, 0, 0>
		}
	box {
		<0.5, -0.05, -0.4> <3.5, 0.05, 0.4>
		rotate <135, 0, 0>
		}
	box { <-0.05, -0.4, -0.4> <0.05, 0.4, 0.4> }
	}

#declare ReqBoutAile =
union {
	object { ReqBA2 }
	object {
		ReqBA1
		scale <1, 0.8, 0.8>
		}
	translate <-2.5, 0, 0>
	}

#declare ReqBaseAile =
object {
	difference {
		intersection {
			union {
				difference {
					cylinder {
						<0, -0.5, 0>, <0, 2, 0>, 2.8
						scale <1, 1, 1/6>
						}
					box { <-1, -0.5, -1> <1, 1.5, 1> }
					box {
						<0, -3, -1> <2, 0, 1>
						rotate <0, 0, -20>
						translate <-1, 1.5, 0>
						}
					}
				cylinder {
					<0, -0.5, 0>, <0, 2, 0>, 2.8
					scale <1, 1, 1/7>
					clipped_by { box { <-2, -0.5, -1> <3, 2, 1> } }
					}
				}
			union {
				cylinder {
					<0, -2, 0>, <0, 3, 0>, 2.8
					scale <1, 1, 1/4>
					rotate <0, 0, -20>
					translate <-0.05, 0, 0>
					}
				box { <-1, 0, -1> <3, 2, 1> }
				}
			}
		box { <2, 0, -0.5> <3, 0.25, 0.5> }
		box { <2, 0.5, -0.5> <3, 0.75, 0.5> }
		box { <2, 1, -0.5> <3, 1.25, 0.5> }
		box { <2, 1.5, -0.5> <3, 1.75, 0.5> }
		}
	bounded_by { box { <-3, -0.5, -1> <3, 2, 1> } }
	}

#declare ReqProtectHaut =
union {
	difference {
		cone {
			<0, -0.5, 0>, 6.35, <0, 0, 0>, 6.05
			scale <1, 1, 0.5>
			}
		box { <-7, -0.4, -0.15> <7, -0.1, 0.15> }
		box {
			<-7, -0.4, -0.15> <7, -0.1, 0.15>
			rotate <0, 30, 0>
			}
		box {
			<-7, -0.4, -0.15> <7, -0.1, 0.15>
			rotate <0, 45, 0>
			}
		box {
			<-7, -0.4, -0.15> <7, -0.1, 0.15>
			rotate <0, 60, 0>
			}
		box {
			<-7, -0.4, -0.15> <7, -0.1, 0.15>
			rotate <0, 75, 0>
			}
		box {
			<-7, -0.4, -0.15> <7, -0.1, 0.15>
			rotate <0, 90, 0>
			}
		box {
			<-7, -0.4, -0.15> <7, -0.1, 0.15>
			rotate <0, 105, 0>
			}
		box {
			<-7, -0.4, -0.15> <7, -0.1, 0.15>
			rotate <0, 120, 0>
			}
		box {
			<-7, -0.4, -0.15> <7, -0.1, 0.15>
			rotate <0, 135, 0>
			}
		box {
			<-7, -0.4, -0.15> <7, -0.1, 0.15>
			rotate <0, 150, 0>
			}
		}
	cone {
		<0, -0.5, 0>, 6.25, <0, 0, 0>, 5.95
		scale <1, 1, 0.5>
		}
	bounded_by {
		box { <-6.4, -0.5, -3.2> <6.4, 0, 3.2> }
		}
	}

#declare RequiemBody =
union {
object {
	ReqBase
	clipped_by {
		 cylinder { <0, -1, 0>, <0, 3, 0>, 7.5 }
		 scale <1, 1, 0.5>
		 }
	texture { RequiemTexture }
	bounded_by {
		box { <-8, -0.8, -4> <8, 2.75, 4> }
		//Le bas du Requiem est a (3-sqr20)/2
		}
	}
object {
	ReqRenfort
	texture { ReqNonPaintBump }
	}
object {
	ReqProtectHaut
	rotate <0, 0, -2>
	translate <1, 1.75, 0>
	texture { ReqNonPaint }
	}
}
/*
object
	{
	intersection
		{
		quadric
			{
			< 1, 1, 1 > < 0, 0, 0 > < 0, 0, 0 >, -1
			scale <2.5, 2, 2.5>
			translate <-3, 3, 0>
			}
		box{ <-6, 3.5, -2.5> <-4, 4.5, 2.5> }
		}
	texture { VitreTexture }
	scale< 1.0, 0.5, 1.0 >
	bounded_by
		{
		box{ <-6, 1.75, -2.5> <-4, 2.25, 2.5>}
		}
	}
*/

#declare ReqVitre =
difference {
	intersection {
		merge {
			cone {
				<-3, 2.1, 0>, 2.4
				<-3, 2.35, 0>, 2.2
				}
			cone {
				<-3, 2.35, 0>, 2.2
				<-3, 2.7, 0>, 1.65
				}
			}
		box { <-6, 2.1, -6> <-3, 2.7, 6> }
		}
	box { <-6, 2.2, -6> <-4.3, 2.6, 6> }
	texture { ReqNonPaint }
	}

#declare ReqGlass =
intersection {
	cone {
		<-3, 2.2, 0>, 2.3
		<-3, 2.6, 0>, 1.75
		}
	box { <-6, 2.2, -6> <-4.3, 2.6, 6> }
	texture { VitreTexture }
	}

#declare RequiemVitre =
union {
	object { ReqVitre }
	object { ReqGlass }
	}

#declare RequiemAile =
object
	{
	intersection
      {
      quartic
			{
	 < 1  0  0  6  0  0  0  0  0  
	   0  0  0  0  0  0  0  0  0  
	   0  0  0  0  0  0  0  1  0
	   0  0  0  0  0 1024 0  0 >
	 sturm
			rotate <0, 0, -15>
			}
		box {   <-6, 0, -0.5> <0, 8, 0.5> }
		}
	bounded_by
		{
		box{ <-6, 0, -0.5> <0, 8, 0.5> }
		}
	}

#declare ReqProtectAile =
difference {
	object { RequiemAile }
	box { <-6, 0, -0.5> <0, 3.5, 0.5> }
	box { <-6, 4.5, -0.5> <0, 7, 0.5> }
	box { <-4, 3.75, -0.5> <0, 4.25, 0.5> }
	box { <-3, 7.25, -0.5> <0, 7.75, 0.5> }
	scale <1.05, 1, 1.2>
	bounded_by { box { <-6.3, 0, -0.6> <0, 8, 0.6> } }
	}

#declare Requiem =
object
	{
	union
		{
		object
			{
			RequiemVitre
//                      scale <1, 1.2, 1>
			}
		object
			{
			RequiemBody
			scale <1, 1.2, 1>
			}
		object
			{
			RequiemAile
			translate <8, 1, 0>
			texture
				{
				material_map
					{
					<1, -1, 0>
					iff "code4.lbm"
					map_type 0
					once
					interpolate 2
					texture { RequiemTexture }
					texture
						{
						/*CodeTexture*/
						pigment { color red 1 green 0.1 blue 0.1 filter 0.5 }
						finish
							{
							phong 0.5
							ambient 0.2
							}
						}
					texture
						{
						/*CodeTexture*/
						pigment { color red 1 green 0.1 blue 0.1 filter 0.5}
						finish
							{
							phong 0.5
							ambient 0.2
							}
						}
					texture
						{
						/*CodeTexture*/
						pigment { color red 1 green 0.1 blue 0.1 filter 0.5 }
						finish
							{
							phong 0.5
							ambient 0.2
							}
						}
					}
					scale <2, 3, 1>
					translate <4.5, 5, 0>
				}
			}
		object {
			ReqBaseAile
			translate <5, 2.5, 0>
			texture { ReqNonPaint }
			}
		object {
			ReqBoutAile
			scale <0.8, 0.8, 1>
			translate <7, 9, 0>
			texture { ReqNonPaint }
			}
		object
			{
			RequiemAile
			rotate<110, 0, 0>
			translate <5, 1, 2>
			scale <1.25, 1.2, 1>
			texture { RequiemTexture }
			}
		object {
			ReqProtectAile
			rotate<110, 0, 0>
			translate <5.1, 1, 2>
			scale <1.25, 1.2, 1>
			texture { ReqNonPaint }
			}
		object {
			ReqBoutAile
			translate <5, -2.1, 9.6>
			texture { ReqNonPaint }
			}
		object
			{
			RequiemAile
			rotate<-110, 0, 0>
			translate <5, 1, -2>
			scale <1.25, 1.2, 1>
			texture { RequiemTexture }
			}
		object {
			ReqProtectAile
			rotate<-110, 0, 0>
			translate <5.1, 1, -2>
			scale <1.25, 1.2, 1>
			texture { ReqNonPaint }
			}
		object {
			ReqBoutAile
			translate <5, -2.1, -9.6>
			texture { ReqNonPaint }
			}
		object
			{
			RequiemReacteur
			translate <7, 1, -1.5>
			texture { RequiemTexture }
			}
		object
			{
			ReqProtectReact
			translate <7, 1, -1.5>
			texture { ReqNonPaint }
			}
		object
			{
//                      RequiemReacteurPost
			Propultion1
			translate <7.6, 1, -1.5>
			}
		object
			{
			RequiemReacteur
			translate <7, 1, 1.5>
			texture { RequiemTexture }
			}
		object
			{
			ReqProtectReact
			translate <7, 1, 1.5>
			texture { ReqNonPaint }
			}
		object
			{
//                      RequiemReacteurPost
			Propultion2
			translate <7.6, 1, 1.5>
			}
		}
	}
