/***************************************************************************
  Scene file for rendering a nice special car

  Created by Cedric Joulain (1996)
****************************************************************************/


#include "colors.inc"    // The include files contain
#include "shapes.inc"    // pre-defined scene elements
#include "textures.inc"  //  This file has the blue_sky3 texture
#include "glass.inc"
#include "skies.inc"

#declare Manta_Stop = 0.7
#declare Manta_Phare = 1
#declare MonAmbient = 0

#include "manta.inc"
#include "pneu.inc"

#version 3.0
global_settings { assumed_gamma 2.2 }

#declare EyePos = <-3, 0.7, -4>
camera {
	location EyePos
	sky       <0, 1, 0>
	up        <0, 1, 0>
	right     <4/3, 0, 0>
	look_at   <0, 0.5, -3/2>
	}

global_settings {
	radiosity {
		count 50
		error_bound 0.4
		}
	}


union { 
   object { Manta }
   object {
      Roue
		scale <0.2, 0.2, 0.1>
      translate <-1.7*Sc*5/3, 0, -1*Sc*5/3 +0.05>     
		}
   object {
		Roue
      scale <0.2, 0.2, 0.1>
      translate <-1.7*Sc*5/3, 0, 1*Sc*5/3 -0.05>     
      }
	object {
      Roue
      scale <0.225, 0.225, 0.15>
      translate <1.5*Sc*5/3, 0.025, -1*Sc*5/3 +0.1>     
      }
   object {
      Roue
		scale <0.225, 0.225, 0.15>
      translate <1.5*Sc*5/3, 0.025, 1*Sc*5/3 -0.1>     
		}
   translate <0, 0, -3/2>
	}


light_source {
	<0, 0, 10-0.2>
	color Flesh
	area_light 2*x, y, 5, 1
	adaptive 1
	jitter
	atmospheric_attenuation on

	rotate <-30,0,0>
	scale <1, 0.5, 1>
	translate <0*5, 0, -8>
	}
light_source {
	<0, 0, 10-0.2>
	color Flesh
	area_light 2*x, y, 5, 1
	adaptive 1
	jitter
	atmospheric_attenuation on
	
	rotate <-180+30,0,0>
	scale <1, 0.5, 1>
	translate <0*5, 0, -8>
	}

#declare Count=-1
#while (Count < 10)
cylinder {
	<-1, 0, 10-0.2>, <1, 0, 10-0.2>, 0.02
	no_shadow
	pigment { color Flesh }
	finish { ambient 1}
	rotate <-30,0,0>
	scale <1, 0.5, 1>
	translate <Count*5, 0, -8>
	}
#declare Count=Count +1
#end

#declare Count=-1
#while (Count < 10)
cylinder {
	<-1, 0, 10-0.2>, <1, 0, 10-0.2>, 0.02
	no_shadow
	pigment { color Flesh }
	finish { ambient 1}
	rotate <-180+30,0,0>
	scale <1, 0.5, 1>
	translate <Count*5, 0, -8>
	}
#declare Count=Count +1
#end

atmosphere {
  type 1
  samples 60             // Number of samples in first distance interval
  distance 24            // Atmosphere density, similar to fog
  scattering 0.05         // Reflectivity of atmosphere, determines brightness
  aa_level 8             // Level of binary subdivision in case of aa
  aa_threshold 0.1       // Threshold for aa to push in
  jitter 0.4             // Amount of sample jittering
  color rgbft <0.8, 0.8, 0.2, 0.3, 0.18>
}


#declare MyDull =
finish {
	specular 0.1
	roughness 0.05
	}

#declare BandeA =
pigment {
	gradient x
   pigment_map { 
      [0.0 rgb <0.2, 0.2, 0.3> ] 
		[0.75 rgb <0.2, 0.2, 0.3> ]
		[0.75 White ]
		[1.0 White ]
      }
   }

#declare BandeB =
pigment {
   gradient x
   pigment_map { 
		[0.0 rgb <0.2, 0.2, 0.3> ]
      [0.54 rgb <0.2, 0.2, 0.3> ] 
		[0.54 White ]
		[1.0 White ]
		}
	}

box {
   <-50000, 0, 0.05> <50000, 0.2, 0.15>
   pigment { Gray80 }
	normal {
      gradient x 
      slope_map {
	 [0 <0, 0>]
	 [0.02 <0,0>]
	 [1 <0.02, 0>]
	 }
		}
	}

plane {
   <0, -1, 0>, 0.2
   pigment {   
		gradient z
      pigment_map { 
	 [0.0 BandeB ] 
	 [0.05 BandeB ] 
	 [0.05 rgb <0.2, 0.2, 0.3> ] 
	 [0.5 rgb <0.2, 0.2, 0.3> ] 
	 [0.5 BandeA ] 
	 [0.55 BandeA ]
			[0.55 rgb <0.2, 0.2, 0.3> ]
	 [1.0 rgb <0.2, 0.2, 0.3> ]
	 }
      scale <12, 1, 5>
      translate <-50012, 0, 0>
      }
   finish {   
	 MyDull 
	 }
   normal {
      crackle
		scale <1/50, 1/20, 1/50>
      }
   hollow     
	}

/*
sky_sphere {
   pigment {
		bozo
		color_map {
	 [ 0.9999 color Black]
	 [ 1.0000 color White]
	 }
      scale <0.005, 0.005, 0.005>
		}
	}*/

object {
	cylinder { <-500, 0, 0>, <500, 0, 0>, 10 }
	scale <1, 1/2, 1>
	translate <0, 0, -8>
	pigment {
		bozo
		turbulence 0.2
		color_map {
			[0.0 White ]
			[1.0 Gray30 ]
			}
		//scale 10
		}
	finish { ambient 0 }
	hollow
	}
