#version 3

#include "colors.inc"
#include "metals.inc"

#declare TMAP = texture {
  pigment {
    image_map {
     gif "flymat.gif"
     map_type 2
    }
  }
  finish {
     ambient 0.1
     diffuse 0.4
     brilliance 2
     phong 3
     specular 0.3
     roughness 0.5
     crand 0.02
  } //finish
} //texture

#declare B_GLAS= texture {
   pigment { color rgbf<0.7, 0.8, 1.0, 1.0> }
   finish {
    ambient 0
    diffuse 0
    reflection 0.5
    refraction 1
    ior 1.5
    phong 0.3
    phong_size 60
   }
}


#declare WING=object {
 cone { <0,0,0>, 1, <0,1,0>, 0.5
        texture { TMAP }
        scale <0.5,1,0.1>
        matrix < 1, 1, 0,
             0, 1, 0,
             0, 0, 1,
             0, 0, 0 >
    }
}

#declare FUSELAGE=object {
 cone { <0,0,0>, 0.2, <1,0,0>, 0.35
        texture { TMAP rotate <0,0,90> scale <0.5,0.7,0.7> }
        scale <2,1,1>
    }
}

#declare NOSE=object {
 cone { <0,0,0>, 0, <1,0,0>, 0.2
        texture { TMAP }
        scale <0.8,1,1>
    }
}

#declare GUN=object {
 union {
  object { FUSELAGE  translate <-1,0,0>}
  object { NOSE  translate <-1.8,0,0>}
  scale <0.7,0.2,0.2>
 }
}

#declare DUSE=object {
 cone { <0,0,0>, 0.35, <1,0,0>, 0.3
        texture { TMAP }
        scale <0.3,1,1>
      }
}

#declare TALE=object {
 union {
  object { WING  rotate <0,0,-45> rotate <0,0,0> }
  object { WING  rotate <0,0,-45> rotate <180,0,0>}
  scale <1,0.8,0.5>
  rotate <90,0,0>
  translate <0.5,0,0>
 }
}

#declare COCKPIT=union {
 object { //CABINE
  sphere { 0, 1
   texture {B_GLAS}
   scale <0.5,0.1,0.3>
  }
 }
 object { //PILOT
  sphere { 0, 1
   texture { pigment {color rgb <0.4,0.4,0.4> } }
   scale <0.07,0.07,0.07>
   translate <0.1,0.1,0>
  }
 }
 disc { 0, <0,1,0>, 1
    texture { pigment {color rgb <0.2,0.3,0.6> } }
    scale <0.5,1,0.3>
 }
}

#declare FLAME=object {
cylinder { 0, <0,1.5,0>, 1
 hollow
 texture
 {
  pigment { color rgbt <1,1,1,1>}
  halo {
    emitting
    linear
    spherical_mapping
    color_map {
        [ 0 color rgbt <1, 0, 1, 1> ]
        [ 1 color rgbt <0.5, 1, 1, -0.5> ]
    }
    samples 10
    turbulence <0.4,2,0.5>
    scale <0.7, 0.9,  0.7>
  }//halo
 }//texture
}// cylinder
}

#declare FLAME1=object {
cylinder { 0, <0,1,0>, 1
 hollow
 texture
 {
  pigment { color rgbt <1,1,1,1>}
  halo {
    emitting
    linear
    cylindrical_mapping
    color_map {
        [ 0 color rgbt <1, 0, 1, 1> ]
        [ 1 color rgbt <0.5, 0.7, 1, -0.5> ]
    }
    samples 10
  }//halo
 }//texture
 scale <0.4,0.1,0.4>
}// cylinder
}

 #declare T  = clock
 #declare T1 = 0.3         // accelerate time = slowdown time
 #declare T2 = 0.75-T1*2   // constant fly time
 #declare A  = 360/(T1*(T2+T1))  //acceleration
 #declare VC = A*T1              //speed
 #declare S1 = A*T1*T1/2
 #declare S2 = S1+VC*T2

 #if (clock<=T1)
   #declare AC = A*T*T/2
 #else
   #if (clock<=T1+T2)
     #declare TC = T-T1
     #declare AC = S1+VC*TC
   #else
     #if (clock<=0.75)
      #declare TC = T-T2-T1
      #declare AC= -A*TC*TC/2+VC*TC +S2
     #else
      #declare AC=0
     #end
   #end
 #end

 #declare BC=AC/1.2


union {
  object { WING  rotate <0,0,-45> translate <0,0.2,0> }
  object { WING  rotate <0,0,-45> rotate <180,0,0> translate <0,-0.2,0> }
  object { FUSELAGE  translate <-1,0,0>}
  object { NOSE  translate <-1.8,0,0>}
  object { GUN  translate <0.5,-0.93,0>}
  object { GUN  translate <0.5,0.93,0>}
  object { DUSE translate <1,0,0> }
  object { TALE translate <0,0.93,0> }
  object { TALE translate <0,-0.93,0> }
  object { COCKPIT translate <-0.7,0,-0.12> }
  object { FLAME  scale <0.6,1.5,0.6> rotate <0,0,-90> translate <1.55,0,0> }
  object { FLAME1  rotate <0,0,-90> translate <1.3,0,0> }
  hollow
  rotate <30,-20,10>
  translate <X2, Y2, Z2>
}

light_source {
   <-0.77, -0.93, 0>
   color rgb <0.5, 0.9, 1>
   spotlight
   point_at <-3,-0.93,0>
   radius 2
   falloff 3
   fade_distance 3
   fade_power 5
   rotate <30,-20,10>
   translate <X2, Y2, Z2>
  }

sphere { <0,0,0>, 0.05
 texture { B_GLAS }
    hollow
    translate<-0.76, -0.93, 0>
    rotate <30,-20,10>
    translate <X2,Y2,Z2>
}

sphere { <0,0,0>, 1
 pigment { color rgbt <1, 1, 1, 1> }
 halo {
      emitting
      spherical_mapping
      linear
      color_map {
        [ 0 color rgbt <1, 0, 1, 1> ]
        [ 1 color rgbt <0, 0.7, 1, -1> ]
      }
      samples 7
    }
    hollow
    scale 0.05
    translate<-0.76, -0.93, 0>
    rotate <30,-20,10>
    translate <X2,Y2,Z2>
}

light_source {
   <-0.77, 0.93, 0>
   color rgb <0.5, 0.9, 1>
   spotlight
   point_at <-3,0.93,0>
   radius 2
   falloff 3
   fade_distance 3
   fade_power 5
   rotate <30,-20,10>
   translate <X2, Y2, Z2>
  }

sphere { <0,0,0>, 1
 pigment { color rgbt <1, 1, 1, 1> }
 halo {
      emitting
      spherical_mapping
      linear
      color_map { [ 0 color rgbt <1, 0, 1, 1> ][ 1 color rgbt <0, 0.7, 1, -1> ] }
      samples 7
    }
    hollow
    scale 0.05
    translate<-0.76, 0.93, 0>
    rotate <30,-20,10>
    translate <X2,Y2,Z2>
}
sphere { <0,0,0>, 0.05
 texture { B_GLAS }
    hollow
    translate<-0.76, 0.93, 0>
    rotate <30,-20,10>
    translate <X2,Y2,Z2>
}
