// Persistence of Vision Ray Tracer Scene Description File
// File: landfly.pov
// Vers: 3
// Desc: SciFi Landscape
// Date: 14.10.1996
// Auth: Alexei Semitchastnyi
//

#version 3

#include "colors.inc"

global_settings
{
  assumed_gamma 2.0
}

camera
{
  location  <75.0, 18, 0.0>
  right     4/3*x
  look_at   <75.0, 16.7, 5.0>
}

light_source
{
 <73, 17, 55> // light's position (translated below)
 color red 1.0  green 1.0  blue 1.0  // light's color
 fade_distance 280
 fade_power 2
 shadowless
}

light_source
{
 <73, 50, 5> // light's position (translated below)
 color red 1.0  green 1.0  blue 1.0  // light's color
 fade_distance 280
 fade_power 2
 shadowless
}

#declare LANDSCAPE=height_field {
  tga "land.tga"
  texture
  {
    pigment
    {
      image_map { tga "land_t.tga" map_type 0 once }
      rotate x*90 // lay X-Y image map down onto X-Z height field plane
    }
    finish { diffuse 0.7 ambient 0.6 }
    normal { bump_map {gif "land_t2.gif" use_color bump_size 5.0 }
             rotate x*90 scale <0.8,4,0.8>
           }
  }
  texture
  {
    pigment
    {
      image_map {gif "land_t2.gif" transmit all 0.87 }
      rotate x*90 // lay X-Y image map down onto X-Z height field plane
    }
    finish { diffuse 0.7 ambient 0.3 }
    scale <0.8,4,0.8>
  }
  smooth
  scale <150,8,150>
  translate <3,3,9>
 }

#declare SEA=plane { y, 0
    pigment { red 0.4 green 0.7 blue 1.0 filter 0.8 }
    finish { ambient 0 refraction 1.1 ior 1.1 reflection 0.9 caustics 1.0 fade_distance 0.7}
    normal { bumps 0.4 }
    scale <2,0.3,0.3>
    translate <0, 5.3, 0>
    rotate <2,0,0>
}

atmosphere {
    type 1          //5=HENYEY_GREENSTEIN_SCATTERING; 1=ISOTROPIC_SCATTERING
    samples 80
    distance 50
    scattering 0.4
    aa_level 4
    aa_threshold 0.3
    jitter 0.2
}

object { LANDSCAPE }
object { SEA }

#declare X1=10   #declare Y1=15   #declare Z1=0
#include "road.pov"

#declare X2=82  #declare Y2=19  #declare Z2=18
#include "flyer.pov"

#declare X3=73  #declare Y3=15.5  #declare Z3=6.5
#include "radar.pov"

