#version 3

#include "colors.inc"

#declare stang1 = cylinder { 0, <0,0,1>, 1
 texture { //blue grund
  pigment { /*color rgb <0.1,0.1,0.5>*/
    image_map
    {
      tga "mat1.tga" // the file to read (iff/gif/tga/png/sys)
      map_type 2 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
    } // image_map
    rotate <-90,0,90>
   }
   finish { phong 1 diffuse 0.6}
   scale 2
  }
  scale <0.2,0.2,2>
  translate <-1,0,0>
}//cylinder

#declare stang2 = object {
 stang1
 translate <2,0,0>
}

#declare big_stang = object {
  stang1
  translate <1,0,0>
  texture {
  pigment { /*color rgb <0.1,0.1,0.5>*/
    image_map
    {
      gif "mat2.gif" // the file to read (iff/gif/tga/png/sys)
      map_type 2 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
      transmit 0 1.0
    } // image_map
    rotate <-90,0,-90>
    scale 2
   }
  finish { ambient 1.0 }
 }
 scale <2,2,1>
 translate <0,1,0>
}

#declare col1 = cylinder { 0, <0,1,0>, 1
 pigment { color rgb <0.3,0.3,0.7> }
 finish { phong 2 diffuse 0.9}
 scale <0.05,1.4,0.05>
 translate <0,-1.3,0.3>
 rotate z*45
 translate <0,1,0>
}

#declare col2 = object {
  col1
  translate <0,-1,0.3>
  rotate z*-90
  translate <0,1,0>
}

#declare i = -4
#declare R = 70
#declare alf=asin(1/R)

// This loop creates the "Highway"-Sections
#while (i < 50)

 // create a regular point light source 
 light_source
 {
   0*x // light's position (translated below)
   color red 0.3  green 0.9  blue 0.9  // light's color
   translate <-1.1,1,0>
   rotate <0,-alf*360/pi*i,0>
   translate <R*cos(2*alf*i),0,R*sin(2*alf*i)>
   shadowless
   fade_distance 0.6
   fade_power 3
   translate <X1,Y1,Z1>
 } 
 union {
   object {stang1}
   object {stang2}
   object {big_stang}
   object {col1}
   object {col2}

   translate <0,0,-1>
   rotate <0,-alf*360/pi*i,0>
   translate <R*cos(2*alf*i),0,R*sin(2*alf*i)>
   //translate <-R,0,0>
   translate <X1,Y1,Z1>
 }

 #declare i = i+1 // increment our counter
#end


