//*************************************************************
//  FileName: crash.pov
//
//  Title: Irony Sucks!
//
//  Description:
//    Palm Tree on a desert island.  Escape crashed on the island
//    with the body of the pilot lying under the coconut palm.
//
//  History:    Author     Comment
//               SAG       Created
//
//  Orientation:
//
//        +y -z
//        | /
//        |/
//  +x ---|--- -x
//       /|
//      / |
//     +z -y
//
//  Tools Used:
//    Trees by Phil Drinkwater
//    Blob Modeller for Windows by Ronald Praver
//
//  Render Time: (Pentium Pro 200 64 MB)
//    800x600 AA 0.3    10 min 44 sec
//    640x480 AA 0.3     7 min 12 sec
//
//*************************************************************

#include "colors.inc"
#include "textures.inc"
#include "crash.inc"
#include "body.inc"

// setup a series of booleans to turn objects on and off
#declare DRAW_SKY = 1
#declare DRAW_SEA = 1
#declare DRAW_POD = 1
#declare DRAW_ISLAND = 1
#declare DRAW_BODY = 1
#declare DRAW_TREE = 1

// this one is for adding test objects
#declare DRAW_TEST = 0

camera
{
 location <-10, 340, 790>
 look_at <-84, 338, 1>
}

// extra bright light to simulate an unshaded sun
light_source
{
  <-3500, 8500, 2800>
  color red 1.5 green 1.5 blue 1.5
}

// draw the ocean as one big radial color_map
#declare ocean = object
{
  plane
  {
    y, -20
    texture
    {
      pigment
      {
        radial frequency 2
        turbulence 0.3
        color_map
        {
          [0.1   color NavyBlue]
          [0.5   color Blue filter 0.3]
          [0.75  color SkyBlue filter 0.4]
          [0.80  color PaleGreen filter 0.6]
          [0.85  color Tan filter 0.8]    //LimeGreen
          [0.90  color Tan filter 0.9]   //Green
          [1.0   color White]
        }
        scale 90
      }
      normal
      {
        bumps 0.15 scale 0.6
      }
      finish
      {
        Dull
        ambient 0.15
        reflection 0.4
      }
      scale 50
    }
    translate <50, 0, 0>
    rotate <0, 45, 0>
    translate <275, 0, 50>
  }
}

#declare pod_texture = texture
  {
    pigment
    {
      brick
      color Gray50,
      color Yellow
      brick_size <8, 6, 6.5>
      mortar 0.1
    }
    finish
    {
      phong 0.8
      phong_size 90
    }
    scale 12
  }

#declare pod_burn = texture
  {
    pigment
    {
      bozo
      color_map
      {
          [0.0, 0.1   color Gray20
                      color Gray30 filter 0.1]
          [0.1, 0.3   color Gray30 filter 0.2
                      color Gray60 filter 0.3]
          [0.3, 0.7   color Gray60 filter 0.4
                      color Yellow filter 0.6]
          [0.5, 1.001 color Yellow filter 0.8
                      color Yellow filter 1.0]
      }
      turbulence 0.80
    }
    //rotate <0, 15, 0>
    scale <60, 120, 70>
    translate <0, -50, 0>
  }

#declare escape_pod = union
{
  sphere
  {
    <0, 210, 0>, 110
    clipped_by
    {
      box
      {
        <-110, 100, -110>,
        < 110, 215,  110>
      }
    }
  }
  difference
  {
    difference
    {
      cylinder
      {
        <0, 210, 0>
        <0, 390, 0>, 110
      }
      cylinder
      {
        <0, 210, 0>
        <0, 390, 0>, 108
      }
    }
    box
    {
      < 145, 310,  30>,
      <   5, 365, -30>
    }
    rotate <0, -55, 0>
  }
  cone
  {
    <0, 390, 0>, 110
    <0, 450, 0>,  90
  }
  object
  {
    jet_cones
  }
  object
  {
    stern_railing
  }
  object
  {
    retros
  }
  object
  {
    hand_holds
  }
  texture
  {
    pod_texture
    translate <-10, 10, 0>
  }
  texture
  {
    pod_burn
  }
}

#declare interior_pod = union
{
  //*** interior light inside escape_pod
  light_source
  {
    <0, 300, 0>
    color White
  }
  difference
  {
    difference
    {
      cylinder
      {
        <0, 220, 0>
        <0, 390, 0>, 108
      }
      cylinder
      {
        <0, 220, 0>
        <0, 390, 0>, 106
      }
    }
    box
    {
      < 145, 265,  30>,
      <   5, 385, -30>
    }
    rotate <0, -55, 0>
    texture
    {
      pigment
      {
        White
      }
      normal
      {
        crackle 0.6
        scale 0.24
      }
      finish
      {
        phong 0.8
        phong_size 200
      }
      scale 5
    }
  }
  object
  {
    control_panel
    translate <0, 0, -100>
  }
}

#declare pod_door = union
{
  cylinder
  {
    <0, 285, 0>
    <0, 365, 0>, 110
    clipped_by
    {
      box
      {
        <120, 310,  30>,
        <105, 365, -30>
      }
    }
    texture
    {
      pod_texture
      finish
      {
        ambient 0.002
      }
      translate <10, 10, 0>
    }
    texture
    {
      pod_burn
      /*
      finish
      {
        ambient 0.102
      }
      */
      rotate <0, 25, 0>
      //translate <20, 0, 0>
      //scale 2
    }
  }
  box
  {
    <105, 310,  28>,
    <100, 365, -28>
    pigment
    {
      color White
    }
  }
  rotate <0, 0, 90>
  translate <150, -112, 0>
}


#declare island = difference
{
  union
  {
    sphere
    {
      <-15, -80, -15>, 105
      scale <6, 0.5, 4>
    }
    sphere
    {
      <0, -80, 0>, 100
      scale <6, 0.5, 4>
    }
    sphere
    {
      <-35, -50, -70>, 95
      scale <6, 0.5, 4>
    }
    object
    {
      crash_mound
    }
    sphere
    {
      <-15, -6000, -15>, 5980
    }
  }
  union
  {
    cylinder
    {
      < -90, 55, 0>
      <-700, 55, 0>, 132
      rotate <0, 25, 0>
    }
    cone
    {
      <   5, 0, 0>, 75
      <-700, 0, 0>, 175
      rotate <0, 25, 0>
    }
  }
  pigment
  {
    crackle
    color_map
    {
      [0.00, 0.45 color Khaki
                  color Salmon]
      [0.45, 0.50 color Salmon
                  color SeaGreen]
      [0.50, 0.60 color Salmon
                  color Brown]
      [0.60, 0.75 color Brown
                  color Tan]
      [0.75, 1.01 color Tan
                  color Khaki]
    }
    scale 5
  }
}

#if (DRAW_BODY)
object
  {
    dead_body
    // this was added
    //rotate <-90, 0, 0>
    //scale 5
    //***************
    rotate <0, 180, 0>
    scale 60
    translate <150, -3, -150>
    // this was added
    //rotate <70, 0, 0>
    //scale 5
    //translate <-750, -200, 0>
    //***************
  }
#end


#if (DRAW_POD)
object
{
  pod_door
}
#end

#if (DRAW_BODY)
  object
  {
    coconut
    translate <220, -3, -180>
  }
#end

// standard sky with a few modification to make it a blue shade closer to the ocean color
#if (DRAW_SKY)
  sky_sphere
  {
    S_Cloud1
  }
#end

#if (DRAW_SEA)
  object
  {
    ocean
  }
#end

#if (DRAW_POD)
  union
  {
    object
    {
      escape_pod
    }
    object
    {
      interior_pod
    }
    rotate <0, 0, 75>
    translate <135, -40, 50>
    rotate <0, 25, 0>
    translate <-110, 0, 0>
    translate <-50, 0, -300>
  }
#end

#if (DRAW_ISLAND)
  union
  {
    object
    {
      island
      translate <-110, 0, 0>
    }
    #if (DRAW_TREE)
      object
      {
        palm_tree
        scale 1.15
        rotate <0, 15, 0>
        translate <250, 0, 40>
      }
    #else
      sphere
      {
        <0, 0, 0>, 0.00001
        // This is here to avoid the CSG warning when NOT drawing the Tree
      }
    #end
    translate <-50, 0, -300>
  }
#end

#if (DRAW_TEST)
  sphere
  {
    <-35, -3000, -70>, 2990
    scale <6, 1, 4>
    texture
    {
      pigment
      {
        bozo
        frequency 2
        turbulence 0.3
        color_map
        {
          [0.00, 0.10  color White filter 0.2]
          [0.10, 0.30  color Blue filter 0.6]
          [0.30, 0.55  color SkyBlue filter 0.7]
          [0.55, 0.70  color White filter 0.8]
          [0.70, 0.75  color Green filter 1.0]
          [0.75, 0.80  color Gray50 filter 0.6]
          [0.80, 1.00  color White filter 0.2]
        }
      }
      normal
      {
        bumps 0.15 scale 1.6
      }
      finish
      {
        Dull
        ambient 0.15
        reflection 0.4
      }
      scale 90
    }
  }

#end



//*** EOF: palm.pov
