
// Persistence of Vision Ray Tracer Scene Description File
// File: ALIENS.pov
// Vers: 3.00e Watcom Win32
// Desc: Code for creating the alien creatures
// Date: Oct. 7/96
// Auth: Sonya Roberts
// Note:


// ==== Eyeball ====
#declare Eye=
union {
	object {
		difference {
			union {
				difference {
					sphere {<0,0,0>,1	pigment {color White}}
					sphere {<0,0,0>,.999}
				}
				difference {
					sphere {<0,0,0>,.9995}
					sphere {<0,0,0>,.8}
				}
				sphere {<0,0,0>,.801		pigment {color Black}}
			}
			sphere {<0,0,1.1>,.76}
		}
	}
	object {
		sphere {<0,0,0>,1.001}
		texture {T_Glass2}
	}
}


// ==== Prickly Ball Alien ====
#declare R2=seed(2)
#declare PricklyBall=
object {
	union {
		#declare X2=1
		#while (X2<=75)
			cone {
				#declare Hg=(rand(R2)*2)
				<0,0,0>,.075,<0,Hg,0>,.02
				texture {Stripy	scale <1,(.25*Hg),1>}
				rotate y*(rand(R2)*360)
				rotate x*(rand(R2)*360)
				rotate z*(rand(R2)*360)
			}
			#declare X2=X2+1
		#end
	}
}


// ==== Jellyfish ====
#declare Jellyfish=
union {
	object {
		blob {
			threshold .75
			// Main Body
			sphere {<0,0,0>,2,1}
			cylinder {<0,-.75,0>,<0,-.25,0>,1.25,.5}
			// Eye Stalks
			cylinder {<0,0,0>,<-.5,1.75,.75>,.15,1}
			cylinder {<0,0,0>,<.5,1.75,.75>,.15,1}
			// Big Bulges
			sphere {<0,-.5,.5>,.5,1		scale <.75,1,1.5>}
			sphere {<0,-.5,.5>,.5,1		scale <.75,1,1.5>	rotate y*72}
			sphere {<0,-.5,.5>,.5,1		scale <.75,1,1.5>	rotate y*144}
			sphere {<0,-.5,.5>,.5,1		scale <.75,1,1.5>	rotate y*216}
			sphere {<0,-.5,.5>,.5,1		scale <.75,1,1.5>	rotate y*288}
			// Small Bulges
			sphere {<0,-.5,.9>,.5,1		scale <.5,2,1>}
			sphere {<0,-.5,.9>,.5,1		scale <.5,2,1>		rotate y*72}
			sphere {<0,-.5,.9>,.5,1		scale <.5,2,1>		rotate y*144}
			sphere {<0,-.5,.9>,.5,1		scale <.5,2,1>		rotate y*216}
			sphere {<0,-.5,.9>,.5,1		scale <.5,2,1>		rotate y*288}
			// In-Between Bulges
			sphere {<0,0,.65>,.35,1		rotate y*36}
			sphere {<0,0,.65>,.35,1		rotate y*108}
			sphere {<0,0,.65>,.35,1		rotate y*180}
			sphere {<0,0,.65>,.35,1		rotate y*252}
			sphere {<0,0,.65>,.35,1		rotate y*324}
		}
		texture {Jelly_Fish	scale <.5,.5,.5>}
	}
	object {Eye	scale <.2,.2,.2>	translate <-.5,2,.8>}
	object {Eye	scale <.2,.2,.2>	translate <.5,2,.8>}
}

// ==== BigBug ====
#declare BugLeg1=
object {
	union {
		sphere {<0,0,0>,.25	pigment {color rgb <.89,.63,.15>}}
		cone {<0,0,0>,.25,<-2.5,2,0>,.2}
		sphere {<-2.5,2,0>,.2	pigment {color rgb <.89,.63,.15>}}
		cone {<-2.5,2,0>,.2,<-4.75,-1,0>.1}
		sphere {<-4.75,-1,0>,.075	pigment {color rgb <.89,.63,.15>}}
		cone {<-4.75,-1,0>,.075,<-5.625,-2.25,0>,.05}
		sphere {<-5.625,-2.25,0>,.06	pigment {color rgb <.89,.63,.15>}}
		cone {<-5.625,-2.25,0>,.055,<-6,-2.35,0>,.015}
	}
	texture {RoughStone	scale <.2,.2,.2>}
}

#declare BugLeg2=
object {
	union {
		sphere {<0,0,0>,.25	pigment {color rgb <.89,.63,.15>}}
		cone {<0,0,0>,.25,<-2.75,1.75,0>,.2}
		sphere {<-2.75,1.75,0>,.2	pigment {color rgb <.89,.63,.15>}}
		cone {<-2.75,1.75,0>,.2,<-5,-1,0>.1}
		sphere {<-5,-1,0>,.075	pigment {color rgb <.89,.63,.15>}}
		cone {<-5,-1,0>,.075,<-6.325,-2.25,0>,.05}
		sphere {<-6.325,-2.25,0>,.06	pigment {color rgb <.89,.63,.15>}}
		cone {<-6.325,-2.25,0>,.055,<-6.65,-2.35,0>,.015}
	}
	texture {RoughStone	scale <.2,.2,.2>}
}

#declare BugJaw=
object {
	difference {
		sphere {<0,0,0>,.5}
		cylinder {<.75,-.6,0>,<.75,.6,0>,1}
		sphere {<0,0,0>,.45}
		scale <1,.25,1>
	}
	pigment {color rgb <.92,.91,.82>}
	finish {
		ambient .2
		phong .3
	}
}

#declare BigBug=
object {
	union {
		sphere {<0,0,0>,1	scale <1.5,.65,1.5>}
		object {BugLeg1		translate <-1.5,0,0>	rotate y*-50}
		object {BugLeg2		translate <-1.5,0,0>	rotate y*-30}
		object {BugLeg1		translate <-1.5,0,0>	rotate y*-10}
		object {BugLeg1		translate <-1.5,0,0>	rotate y*10}
		object {BugLeg1		translate <-1.5,0,0>	rotate y*30}
		object {BugLeg1		translate <-1.5,0,0>	rotate y*50}
		object {BugLeg1		rotate y*180	translate <1.5,0,0>	rotate y*-50}
		object {BugLeg1		rotate y*180	translate <1.5,0,0>	rotate y*-30}
		object {BugLeg2		rotate y*180	translate <1.5,0,0>	rotate y*-10}
		object {BugLeg1		rotate y*180	translate <1.5,0,0>	rotate y*10}
		object {BugLeg1		rotate y*180	translate <1.5,0,0>	rotate y*30}
		object {BugLeg2		rotate y*180	translate <1.5,0,0>	rotate y*50}
		union {
			intersection {
				sphere {<0,0,0>,.5	scale <1.5,.65,1.5>}
				sphere {<0,0,-.25>,1.75	scale <1,.65,1>}
			}
			object {BugJaw	rotate y*5	rotate x*-10	translate <0,0,-.95>}
			object {BugJaw	rotate y*175	rotate x*-10	translate <0,0,-.95>}
			object {
				sphere {
					<0,0,0>,.2
					translate <0,.225,-.55>
					rotate y*-15
				}
				pigment {color Black}
				finish {
					phong .4
					reflection .6
				}
			}
			object {
				sphere {
					<0,0,0>,.2
					translate <0,.225,-.55>
					rotate y*15
				}
				pigment {color Black}
				finish {
					phong .4
					reflection .6
				}
			}
			rotate x*-15
			translate <0,.75,-1.75>
		}
	}
	texture {RoughStone	scale <.2,.2,.4>}
}


// ==== Cactus Thing ====
#declare Part=
object {
	union {
		cylinder {<0,0,.5>,<0,2,.5>,.5}
		sphere {<0,2,.5>,.5}
	}
	scale <.5,1,1.5>
}

#declare Pod=
union {
	object {Part}
	object {Part	rotate y*30}
	object {Part	rotate y*60}
	object {Part	rotate y*90}
	object {Part	rotate y*120}
	object {Part	rotate y*150}
	object {Part	rotate y*180}
	object {Part	rotate y*210}
	object {Part	rotate y*240}
	object {Part	rotate y*270}
	object {Part	rotate y*300}
	object {Part	rotate y*330}

	#declare PD1=seed(1)
	#declare PX=1
	#while (PX<=12)
		#declare PY=1
		#while (PY<=8)
			#declare PZ=1
			union {
				#while (PZ<=5)
					cone{
						<0,(.25*PY),1.24>,.06,
						<.25-(rand(PD1)*.5),((.25*PY)+.25)-(rand(PD1)*.5),2-(rand(PD1)*.25)>,.01
						pigment {color rgb <.92,.91,.82>}
					}
					#declare PZ=PZ+1
				#end
				rotate y*(30*PX)
			}
			#declare PY=PY+1
		#end
		#declare PX=PX+1
	#end
	texture {T_Stone1}
}

#declare Pot=
object {
	union {
		cone {<0,0,0>,.6,<0,.81,0>,1}
		cone {<0,.8,0>,1.05,<0,1,0>,1.1}
	}
	pigment {color OrangeRed}
}

#declare Cactus=
union {
	object {Pot}
	object {Pod	scale <.35,1,.35>	translate <0,1,0>}
}


// ==== Blobby Humanoids ====
#declare Blobette1=
union {
	object {
		blob {
			threshold .1
			sphere {<0,0,0>,.5,1		scale <1.25,.75,1>}	// Body - Hips to Shoulders
			cylinder {<0,0,0>,<-.5,2,.2>,.5,.75	scale <1.25,1,1>}
			cylinder {<0,0,0>,<.5,2,.2>,.5,.75	scale <1.25,1,1>}
			cylinder {<0,1,0>,<0,3.5,.5>,.5,1}
			sphere {<0,2.25,0>,.45,1	scale <3,1,2>}
			cylinder {<0,2,0>,<0,3,-.25>,.25,1}			// Neck and Head
			sphere {<-.25,3,-.25>,.25,1}
			sphere {<.25,3,-.25>,.25,1}
			sphere {<0,3.5,.5>,.75,1}
			sphere {<-.75,2,0>,.25,1}				// Right Arm
			cylinder {<-.75,2,0>,<-1.5,1,-1>,.2,1}
			sphere {<-1.5,1,-1>,.2,1}
			cylinder {<-1.5,1,-1>,<-1.25,1,-1.75>,.175,1}
			sphere {<-1.25,1,-1.75>,.15,1}
			cylinder {<-1.25,1,-1.75>,<-1,1,-2>,.15,1}
			sphere {<.75,2,0>,.25,1}				// Left Arm
			cylinder {<.75,2,0>,<1.5,1,-1>,.2,1}
			sphere {<1.5,1,-1>,.2,1}
			cylinder {<1.5,1,-1>,<1.25,1,-1.75>,.175,1}
			sphere {<1.25,1,-1.75>,.15,1}
			cylinder {<1.25,1,-1.75>,<1,1,-2>,.15,1}
			cylinder {<-.4,0,0>,<-.75,-.65,-1.5>,.4,1}		// Right Leg
			sphere {<-.75,-.65,-1.5>,.35,1}
			cylinder {<-.75,-.65,-1.5>,<-.6,-1.65,-1.25>,.3,1}
			sphere {<-.6,-1.65,-1.25>,.25,1}
			cylinder {<-.6,-1.65,-1.25>,<-.6,-2,-1.75>,.2,1}
			cylinder {<.4,0,0>,<.75,-.65,-1.5>,.4,1}		// Left Leg
			sphere {<.75,-.65,-1.5>,.35,1}
			cylinder {<.75,-.65,-1.5>,<.6,-1.65,-1.25>,.3,1}
			sphere {<.6,-1.65,-1.25>,.25,1}
			cylinder {<.6,-1.65,-1.25>,<.6,-2,-1.75>,.2,1}
		}
	}
	object {Eye	scale <.3,.3,.3>	rotate x*160	translate <0,3.45,0>	pigment {color rgb <.89,.77,.34>}}
}

#declare Blobette2=
union {
	object {
		blob {
			threshold .1
			sphere {<0,0,0>,.5,1		scale <1.25,.75,1>}	// Body - Hips to Shoulders
			cylinder {<0,0,0>,<-.5,2,.2>,.5,.75	scale <1.25,1,1>}
			cylinder {<0,0,0>,<.5,2,.2>,.5,.75	scale <1.25,1,1>}
			cylinder {<0,1,0>,<0,3.5,.5>,.5,1}
			sphere {<0,2.25,0>,.45,1	scale <3,1,2>}
			cylinder {<0,2,0>,<0,3,-.25>,.25,1}			// Neck and Head
			sphere {<-.25,3,-.25>,.25,1}
			sphere {<.25,3,-.25>,.25,1}
			sphere {<0,3.5,.5>,.75,1}
			sphere {<-.75,2,0>,.25,1}				// Right Arm
			cylinder {<-.75,2,0>,<-1.25,3.5,-.15>,.2,1}
			sphere {<-1.23,3.5,-.15>,.2,1}
			cylinder {<-1.25,3.5,-.15>,<-1.25,4.25,-.15>,.175,1}
			sphere {<-1.25,4.25,-.15>,.15,1}
			cylinder {<-1.25,4.25,-.25>,<-1.25,4.5,-.15>,.15,1}
			sphere {<.75,2,0>,.25,1}				// Left Arm
			cylinder {<.75,2,0>,<1.25,1,-1>,.2,1}
			sphere {<1.25,1,-1>,.2,1}
			cylinder {<1.25,1,-1>,<.75,0,-1.25>,.175,1}
			sphere {<.75,0,-1.25>,.15,1}
			cylinder {<.75,0,-1.25>,<.65,-.1,-1.5>,.15,1}
			cylinder {<-.4,0,0>,<-.75,-.65,-1.5>,.4,1}		// Right Leg
			sphere {<-.75,-.65,-1.5>,.35,1}
			cylinder {<-.75,-.65,-1.5>,<-.6,-1.65,-1.25>,.3,1}
			sphere {<-.6,-1.65,-1.25>,.25,1}
			cylinder {<-.6,-1.65,-1.25>,<-.6,-2,-1.75>,.2,1}
			cylinder {<.4,0,0>,<.75,-.65,-1.5>,.4,1}		// Left Leg
			sphere {<.75,-.65,-1.5>,.35,1}
			cylinder {<.75,-.65,-1.5>,<.6,-1.65,-1.25>,.3,1}
			sphere {<.6,-1.65,-1.25>,.25,1}
			cylinder {<.6,-1.65,-1.25>,<.6,-2,-1.75>,.2,1}
		}
	}
	object {Eye	scale <.3,.3,.3>	rotate x*173	rotate y*-10	translate <0,3.45,0>	pigment {color rgb <.89,.77,.34>}}
}
