
// Persistence of Vision Ray Tracer Scene Description File
// File: CLASS.pov
// Vers: 3.00e Watcom Win32
// Desc: "Science Fiction" Theme Image
// Date: Oct. 6/1996
// Auth: Sonya Roberts
// Note: Additional files needed for this image include:
//		- BACKDROP.POV
//			Background image of classroom


// ==== Standard Includes ====
#include "COLORS.inc"
#include "TEXTURES.inc"
#include "METALS.inc"
#include "SHAPES.inc"
#include "STONES.inc"
#include "STONES2.inc"
#include "WOODMAPS.inc"
#include "WOODS.inc"
#include "GLASS.inc"


// ==== Additional Includes ====
#include "SROBERTS.inc"
#include "BACKDROP.pov"
#include "ALIENS.pov"

// ==== Lights, Camera, Background ====
// Sky
object {
	sphere {<0,0,0>,3500	hollow}
	texture {MySky}
}

object {
	plane {<0,1,0>,-.1}
	pigment {color Green}
}

// Point Light
#declare Sun=
light_source {
	<-500,800,-500>,
	color rgb <.96,.95,.85>
	fade_distance 1
	fade_power .25
}

// Atmosphere
#declare Dusty=
atmosphere {
	type 1
	samples 30
	distance 60
	scattering 0.2
	jitter .2
}

// Camera
#declare Camera1=
camera {
	location	<1.25,5,34.5>
	up		<0,1,0>
	right		<1.33,0,0>
	look_at		<18.5,4.5,1.5>
}

#declare Camera2=
camera {
	location	<2.75,5,34.5>
	up		<0,1,0>
	right		<1.33,0,0>
	look_at		<16.5,0,1.5>
}

// ==== Assemble Scene Elements ====
camera {Camera2}
object {Sun}
object {LightGlobe	translate <11.25,0,8>}			// Classroom Lights
object {LightGlobe	translate <11.25,0,27>}			// Classroom Lights
light_source {							// Spotlight on Lectern
	<3.25,9,32>
	color Gray50
	spotlight
	point_at <3.25,0,32.5>
	radius 20
	falloff 40
	atmosphere off
}
atmosphere {Dusty}

object {Classroom}
// ==== Prickly Alien - Second Desk from Right, Front of Class
object {PricklyBall	translate <8.75,3,21.5>}
object {PricklyBall	rotate <50,185,82>	scale <.5,.5,.5>	translate <9,3.5,22>}
object {PricklyBall	rotate <196,82,87>	scale <.75,.75,.75>	translate <8.5,3.75,21>}
object {PricklyBall	rotate <95,284,117>	scale <.4,.4,.4>	translate <8.8,4,21.25>}

// ==== Jellyfish Alien - Front Right Desk, Left Desk Third Row, Second Desk Back Row
object {Jellyfish	translate <3.75,2.5,21.5>	pigment {color Blue}}
object {Jellyfish	rotate y*-40	translate <18.75,2.5,11.5>	pigment {color MediumForestGreen}}
object {Jellyfish	rotate y*-10	translate <8.75,2.5,1.5>	pigment {color Green}}

// ==== BigBug Alien - Third Desk, Front of Class
object {BigBug		rotate x*180	rotate y*-30	translate <13.75,7.66,9>}

// ==== Cactus Pod - Front Row Left Desk, Third Row Second Desk
object {Cactus		translate <18.75,1.85,21.5>}
object {Cactus		scale <1.25,1.5,1.25>	rotate y*135	translate <8.75,1.85,11.5>}

// ==== Blobette - Second Row First Desk, First Row Third Desk
object {
	Blobette1
	rotate y*180
	translate <3.75,2,16.5>
	texture {AlienFlesh}
}
object {
	Blobette2
	rotate y*150
	translate <13.75,2,21.5>
	texture {AlienFlesh}
}
