
//------------------------------------------------------------------->
//
// floor.inc
//
// "Easy POV Oven"
//
// Written By: Paul T. Dawson
//             ptdawson@voicenet.com
//             http://www.voicenet.com/~ptdawson
//
// All code and techniques are PUBLIC DOMAIN - have fun with it!
//
//------------------------------------------------------------------->
//
// This file builds the "Floor_Tile" object.

//------------------------------------------------------------------->
//
// Make the textures.

        #declare Tex_1 = texture { pigment { SteelBlue }
                finish { F_MetalC } }

        #declare Tex_2 = texture { pigment { Yellow }
                finish { F_MetalC } }

        #declare Tex_3 = texture { pigment { NewMidnightBlue }
                finish { F_MetalC } }

//------------------------------------------------------------------->
//
// Use two loops to make 12x12 squares for one tile.

        #declare Count_Temp = 0

        #declare Floor_Tile = mesh {

        #declare X = 0 #while ( X < 12 )
        #declare Z = 0 #while ( Z < 12 )

                // Four corners.
                        #declare T1 = < X, 0, Z >
                        #declare T2 = < X, 0, Z+1 >
                        #declare T3 = < X+1, 0, Z+1 >
                        #declare T4 = < X+1, 0, Z >

                // Center point.
                        #declare T5 = < X+0.5, 0.2, Z+0.5 >

                // Decide on a color.

                        #declare Kolor = 1

                        #if ( X= 0 ) #declare Kolor = 3 #end
                        #if ( Z=11 ) #declare Kolor = 3 #end

                        #if ( (X= 2) & (Z= 1) ) #declare Kolor = 2 #end
                        #if ( (X=10) & (Z= 1) ) #declare Kolor = 2 #end
                        #if ( (X= 2) & (Z= 9) ) #declare Kolor = 2 #end
                        #if ( (X=10) & (Z= 9) ) #declare Kolor = 2 #end

                // Four triangles.
                        #if ( Kolor = 1 )
                                triangle { T1,T2,T5 texture { Tex_1 } }
                                triangle { T2,T3,T5 texture { Tex_1 } }
                                triangle { T3,T4,T5 texture { Tex_1 } }
                                triangle { T4,T1,T5 texture { Tex_1 } }
                        #end
                        #if ( Kolor = 2 )
                                triangle { T1,T2,T5 texture { Tex_2 } }
                                triangle { T2,T3,T5 texture { Tex_2 } }
                                triangle { T3,T4,T5 texture { Tex_2 } }
                                triangle { T4,T1,T5 texture { Tex_2 } }
                        #end
                        #if ( Kolor = 3 )
                                triangle { T1,T2,T5 texture { Tex_3 } }
                                triangle { T2,T3,T5 texture { Tex_3 } }
                                triangle { T3,T4,T5 texture { Tex_3 } }
                                triangle { T4,T1,T5 texture { Tex_3 } }
                        #end

                        #declare Count_Temp = Count_Temp + 4

        #declare Z = Z + 1 #end
        #declare X = X + 1 #end

        } // End of mesh.

//------------------------------------------------------------------->
//
// End of this file.

