
//------------------------------------------------------------------->
//
// screen.inc
//
// "Easy POV Oven"
//
// Written By: Paul T. Dawson
//             ptdawson@voicenet.com
//             http://www.voicenet.com/~ptdawson
//
// All code and techniques are PUBLIC DOMAIN - have fun with it!
//
//------------------------------------------------------------------->
//
// This file builds the "Screen" object.
//
//------------------------------------------------------------------->
//
// Build it!

        #declare Screen = union {

        // Actual picture on screen.
                box { < 0, 0, 0 > < 1, 1, 0.1 >
                        pigment {
                        image_map { tga "test-1.tga" interpolate 2 } }
                        scale < 16, 12, 1 >
                        rotate x * 15
                        } // End of box.

        // Black box around that.
                box { < -1, -1, 0.1 > < 17, 13, 1.5 >
                        pigment { Gray20 }
                        normal { crackle 0.2 scale 0.05 }
                        rotate x * 15
                        } // End of box.

        // Little red lights at bottom of screen.
                sphere { < 10, -0.5, 0.1 >, 0.2 pigment { Red } rotate x * 15 }
                sphere { < 12, -0.5, 0.1 >, 0.2 pigment { Red } rotate x * 15 }
                sphere { < 14, -0.5, 0.1 >, 0.2 pigment { Red } rotate x * 15 }

        // Bottom part.
                box { < -1, -1, 0 > < 17, -3, -12 >
                        pigment { Gray20 }
                        normal { crackle 0.2 scale 0.05 }
                        } // End of box.

        // Goofy keys.
                #declare X = 0 #while ( X <= 15 )
                #declare Z = -9 #while ( Z <= -2 )

                        box { < X, -1, Z > < X+1, -0.5, Z+1 >
                                pigment { White } }

                #declare Z = Z + 1.5 #end
                #declare X = X + 1.5 #end

        // Move it all up so bottom is on y=0.
                translate y*3

        } // End of union.

//------------------------------------------------------------------->
//
// End of this file.

