
//------------------------------------------------------------------->
//
// table.inc
//
// "Easy POV Oven"
//
// Written By: Paul T. Dawson
//             ptdawson@voicenet.com
//             http://www.voicenet.com/~ptdawson
//
// All code and techniques are PUBLIC DOMAIN - have fun with it!
//
//------------------------------------------------------------------->
//
// This file builds the "Table" object.
//
//------------------------------------------------------------------->
//
// Make the two textures..

        #declare T_Board_1 =

                // Bottom texture.
                texture { T_Wood14 rotate y * 90 scale < 10, 1, 1 > }

                // Middle texture.
                texture {pigment { color rgbf < 1, 1, 1, 0.999 > }
                        finish { Shiny brilliance 4} }

                // Top texture.
                texture {pigment { color rgbf < 1, 1, 1, 0.999 > }
                        finish { Shiny brilliance 4} }

        #declare T_Board_2 =

                // Bottom texture.
                texture { T_Wood34 rotate y * 90 scale < 10, 1, 1 > }

                // Middle texture.
                texture {pigment { color rgbf < 1, 1, 1, 0.999 > }
                        finish { Shiny brilliance 4} }

                // Top texture.
                texture {pigment { color rgbf < 1, 1, 1, 0.999 > }
                        finish { Shiny brilliance 4} }

//------------------------------------------------------------------->
//
// Make two boards.

        #declare Board_1 = superellipsoid { < 0.05, 0.05 >

                scale < 3.5*12, 1, 1 >

                } // End of superellipsoid.

        #declare Board_2 = superellipsoid { < 0.05, 0.05 >

                scale < 3.5*12, 1, 1 >

                } // End of superellipsoid.

//------------------------------------------------------------------->
//
// Make one leg.

        #declare Table_Leg = cone { < 0,0,0>,1 <0,28,0>,1.3

                texture { T_Gold_1A }
                normal { crackle 0.1 scale 0.1 }

                } // End of cone.

//------------------------------------------------------------------->
//
// Build it!

        #declare Table = union {

                #declare Z = -2*12 #while ( Z < 2*12 )

                        object { Board_1
                                translate < 0, 29, Z >
                                texture { T_Board_1 translate x*(Z*30) } }

                        object { Board_2
                                translate < 0, 29, Z+2 >
                                texture { T_Board_2 translate x*(Z*30) } }

                #declare Z = Z + 4 #end

                object { Table_Leg translate < -3*12, 0, -1.7*12 > }
                object { Table_Leg translate < -3*12, 0,  1.7*12 > }
                object { Table_Leg translate <  3*12, 0, -1.7*12 > }
                object { Table_Leg translate <  3*12, 0,  1.7*12 > }

        } // End of union.

//------------------------------------------------------------------->
//
// End of this file.

