
//------------------------------------------------------------------->
//
// wires.inc
//
// "Easy POV Oven"
//
// Written By: Paul T. Dawson
//             ptdawson@voicenet.com
//             http://www.voicenet.com/~ptdawson
//
// All code and techniques are PUBLIC DOMAIN - have fun with it!
//
//------------------------------------------------------------------->
//
// This file builds the "Wires" object.
//
//------------------------------------------------------------------->
//
// Make a seed just for this object.

        #declare R99 = seed(327)

//------------------------------------------------------------------->
//
// Build it!

        // This controls how many DEGREES each wire segment covers.
        // Lower numbers = shorter segments = tons of memory use!
                #declare WIRE_INCR = 5

        #declare Wires = union {

        // Black plastic connector at starting side.
        box { < 12.2-0.4, -0.4, -0.4 > < 14.4+0.4, 0.4, 2 > pigment{Gray10} }

        #declare BUNCH = 1 #while ( BUNCH <= 12 )

        #if ( mod(BUNCH, 4) = 0 ) #declare This_Pig=pigment {Green } #end
        #if ( mod(BUNCH, 4) = 1 ) #declare This_Pig=pigment {Black } #end
        #if ( mod(BUNCH, 4) = 2 ) #declare This_Pig=pigment {Red   } #end
        #if ( mod(BUNCH, 4) = 3 ) #declare This_Pig=pigment {Yellow} #end

        // Starting point.
        #declare Base_Vec = < 12, 0, 0 > + < (0.2*BUNCH), 0, 0 >
        #declare Old_Vec = Base_Vec

        #declare A = WIRE_INCR #while ( A <= 170 )

                // Add some wobble to starting point..
                        #declare Base_Vec = Base_Vec +
                                < (rand(R99)*0.4)-0.2,
                                  (rand(R99)*0.4)-0.2, 0 >

                // Spin around in a [half] circle.
                        #declare New_Vec = vrotate ( Base_Vec, <0,A,0> )

                cylinder { New_Vec, Old_Vec, 0.1 pigment{This_Pig} }

                #declare Old_Vec = New_Vec

        #declare A = A + WIRE_INCR #end

        // Even them out at the end!
        #declare Final_Vec = < -12, 0, 0 > + < (-0.2*BUNCH), 0, 0 >
        cylinder { Old_Vec, Final_Vec, 0.1 pigment{This_Pig} }

        #declare BUNCH = BUNCH + 1 #end

        // Black plastic connector at end.
        box { < -12.2+0.4, -0.4, -0.4 > < -14.4-0.4, 0.4, 2 > pigment{Gray10} }

        } // End of union.

//------------------------------------------------------------------->
//
// End of this file.

