
// Persistence of Vision Ray Tracer Scene Description File
// File: Ezekiel.pov
// Vers: 3
// Desc: Overall Scene for Science Fiction Entry
// Date: October 28th, 1996
// Auth: Mick McMullin
//

#version 3

#declare my_clock = clock
#declare SWAY     = sin (my_clock)
#declare SMOKE    = 1.5 + SWAY
#declare EXTEND   = my_clock

#include "egghead.inc"
#include "eggy.inc"

global_settings
{
  assumed_gamma 1.0
}


// ----------------------------------------
camera
{
  location  <0.0, 0.0, -4.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}

atmosphere
{
    type 1
    samples 3
    distance 10
    scattering 0.05
    color rgbf <0,1,1,0.2>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color rgb 0 ] [0.5 color blue 0.4] [1.0 color rgb 1] }
  }
}

Main_Light_1
Subtle_Spotlight_1

// ----------------------------------------
plane { y, -2 pigment {color rgb <0, 0, 0.4>} hollow}

object { Spaceship rotate <-10 + SWAY, 10 - SWAY, 0>}
