#include "colors.inc"
#include "textures.inc"

#declare Location = <245, 880, -1380+clock>

// da camera!
camera {
    location <200, 900, -1300>
    right 6/8
    direction z
    look_at <800, 800, 0>
    //look_at Location
}

// da other one
light_source {
    <-2400.0, 3800.0, -1000.0> color red 1.0 green 1.0 blue 0.75
}

// sky sphere
sphere { <0.0, 0.0, 0.0>, 6000
        texture {
                pigment {
                        granite  
                        color_map {
                                [ 0.00  0.72 color Black  color Black ]  // No Stars in this area
                                [ 0.72  0.75 color Gray20 color Gray40 ] // Very Very Faint Stars
                                [ 0.75  0.78 color Gray40 color Gray60 ] // Very Faint Stars
                                [ 0.78  0.81 color Gray60 color Gray80 ] // Faint Stars
                                [ 0.81  0.85 color Gray80 color Gray95 ] // Medium White Stars
                                [ 0.85  0.91 color Gray95 color White  ] // White Stars 
                                [ 0.91  1.00 color Black  color Black ]  // No Stars in this area
                        }
                        scale 100
                }
                finish { ambient 0.5 diffuse 0.0 }
        }
        hollow
}

// nebula
sphere { <0.0, 0.0, 0.0>, 5999
        texture {
                pigment {
                        granite
                        turbulence 0.5
                        color_map {
                                [ 0.0 color rgbt <0, 0,   0, 1.0> ] 
                                [ 0.7 color rgbt <1, 1,   0, 0.5> ] 
                                [ 0.9 color rgbt <1, 1,   0, 0.2> ] 
                                [ 1.0 color rgbt <1, 1,   0, 0.1> ] 
                        }
                        scale 10000
                }
                finish { ambient 1.0 diffuse 0.0 }
        }
        hollow
}

// the planet
sphere {<0.0, 0.0, 0.0>, 1000.0
   texture {
      // water
    pigment {
                bozo
                turbulence 5.0
                color_map {
                        [0.0  color blue 1.0 ]
                        [1.0  color blue 0.5 ]
                }
    }
   scale <100.0, 100.0, 100.0>
   }
   // landform
 texture {
    pigment {
         //spotted
         agate
         //marble
         //crackle
         turbulence 5.5
         //radial
         //wood
         color_map {
                [0.0  color Clear ]
                [0.6  color Clear ]
                [0.6  color Yellow ]
                [0.63 color green 0.5 blue 0.1 ]
                [0.7  color green 0.3 ]
                [0.8  color green 0.2 ]
                [1.0  color green 0.1 ]
        }
    }
    normal {
        wrinkles 1.0
        turbulence 0.5
        //scale <10.0, 10.0, 10.0>
    }
    scale <2500.0, 2500.0, 2500.0>
   }
}

// clouds
sphere {<0.0, 0.0, 0.0>, 1000.1
   texture {
    pigment {
                bozo
                turbulence 6.0
                color_map {
                        [0.0  color rgbt <1, 1, 1, 0.0> ]
                        [0.2  color rgbt <1, 1, 1, 0.5> ]
                        [0.4  color rgbt <1, 1, 1, 1.0> ]
                        [1.0  color rgbt <1, 1, 1, 1.0> ]
                }
    }
   scale <400.0, 400.0, 400.0>
   }
   hollow
}

//atmosphere
sphere {<0.0, 0.0, 0.0>, 1100.0
        pigment {color Clear}
        hollow
                halo {
                        cubic
                        frequency 1
                        max_value 3
                        spherical_mapping
                        glowing
                        //emitting
                        colour_map {
                                [0.0   color rgbt <1.0, 1.0, 1.0, 1.0> ]
                                //[0.3   color rgbt <1.0, 1.0, 1.0, 0.9> ]
                                [1.0   color rgbt <1.0, 1.0, 1.0, 0.0> ]
                        }
                      