#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "enh_stil.inc"
#include "xicarus.inc"
#include "eros.inc"
#include "xfanian.inc"

camera {
  location < -2, 4, -173>
  direction <0,0,0.75>
  right <1.33,0,0>
  look_at < 0.05, 0.05, -80.05 >
}

sky_sphere{
    pigment {
        granite  
        color_map {
            [ 0.00  0.72 color Black  color Black ]  // No Stars in this area
            [ 0.72  0.75 color Gray20 color Gray40 ] // Very Very Faint Stars
            [ 0.75  0.78 color Gray40 color Gray60 ] // Very Faint Stars
            [ 0.78  0.81 color Gray60 color Gray80 ] // Faint Stars
            [ 0.81  0.85 color Gray80 color Gray95 ] // Medium White Stars
            [ 0.85  0.91 color Gray95 color White  ] // White Stars 
            [ 0.91  1.00 color Black  color Black ]  // No Stars in this area
        }
    scale .015
    }
}

object{
light_source{<0,0,-1900> color rgb < 0.5, 0.5, 0.5 > }
rotate < 0, 75, 0 >
}

object{
light_source{<0,0,-1900> color rgb < 1, 1, 1 > }
rotate < 0, -75, 0 >
translate < 0, 200, 0 >
}

//fore-ground action
object{ICARUS
      scale <0.25, 0.25, 0.25>
      rotate < 30, 0, 0 >
      translate < 0, 1, -130 >
      }

sphere{
   <0,0,0>,1
hollow
  texture {
    pigment { color rgbt<1,1,1,1> }
    halo {
      emitting
      spherical_mapping
      linear
      color_map {
        [ 0 color rgbt <1, 1, 0, 1> ]
        [ 1 color rgbt <1, 0, 0, 0> ]
      }
      turbulence 0.35
      samples 10
    }
  }
   scale < 20, 20, 20 >
   translate < 0, 0, -40>
   rotate < 30, 0, 0 >
   translate < 0, 1, -130 >
}

union{
object{STILLETO}

box{
<1,1,6>,<-1,-1,50>
  texture {BEAM}
hollow
translate < 0, -8, 0 >
}

box{
<1,1,6>,<-1,-1,100>
  texture {BEAM}
hollow
translate < 0, -8, 0 >
rotate < 0, 0, 120 >
}

box{
<1,1,6>,<-1,-1,150>
hollow
  texture {BEAM}
translate < 0, -8, 0 >
rotate < 0, 0, -120 >
}
      scale <0.25, 0.25, 0.25>
      translate < 0, 0, -170 >
}
object{FANIAN
      scale <64, 64, 64>
      translate <500, -102.7*3.5, 1500 >
      }

//mid level action
object{EROS
      scale <0.1, 0.1, 0.1>
      translate < -500, -100, 1000 >
      }

sphere{
   <0,0,0>,1
hollow
  texture {
    pigment { color rgbt<1,1,1,1> }
    halo {
      emitting
      spherical_mapping
      linear
      color_map {
        [ 0 color rgbt <1, 0, 0, 1> ]
        [ 1 color rgbt <1, 1, 1, 0> ]
      }
      turbulence 0.35
      samples 10
    }
  }
   scale < 35, 35, 35 >
   translate < -500, -90, 990 >
}

sphere{
   <0,0,0>,1
hollow
  texture {
    pigment { color rgbt<1,1,1,1> }
    halo {
      emitting
      spherical_mapping
      linear
      color_map {
        [ 0 color rgbt <1, 0, 0, 1> ]
        [ 1 color rgbt <1, 1, 1, 0> ]
      }
      turbulence 0.35
      samples 10
    }
  }
   scale < 40, 40, 40 >
   translate < -530, -120, 997 >
}

sphere{
   <0,0,0>,1
hollow
  texture {
    pigment { color rgbt<1,1,1,1> }
    halo {
      emitting
      spherical_mapping
      linear
      color_map {
        [ 0 color rgbt <1, 0, 0, 1> ]
        [ 1 color rgbt <1, 1, 1, 0> ]
      }
      turbulence 0.35
      samples 10
    }
  }
   scale < 45, 45, 45 >
   translate < -470, -75, 990 >
}

union{
object{STILLETO}

box{
<1,1,6>,<-1,-1,150>
  texture {BEAM}
hollow
translate < 0, -8, 0 >
}

box{
<1,1,6>,<-1,-1,300>
  texture {BEAM}
hollow
translate < 0, -8, 0 >
rotate < 0, 0, 120 >
}

box{
<1,1,6>,<-1,-1,450>
hollow
  texture {BEAM}
translate < 0, -8, 0 >
rotate < 0, 0, -120 >
}
      scale <0.5, 0.5, 0.5>
      translate < 0, 0, -100>
      rotate < 15, -60, 0 >
      translate < -470, -75, 990 >
}

union{
object{STILLETO}

box{
<1,1,6>,<-1,-1,480>
  texture {BEAM}
hollow
translate < 0, -8, 0 >
}

box{
<1,1,6>,<-1,-1,600>
  texture {BEAM}
hollow
translate < 0, -8, 0 >
rotate < 0, 0, 120 >
}

box{
<1,1,6>,<-1,-1,720>
hollow
  texture {BEAM}
translate < 0, -8, 0 >
rotate < 0, 0, -120 >
}
      scale <0.5, 0.5, 0.5>
      translate < 0, 0, -360>
      rotate < 15, 20, 0 >
      translate < -530, -120, 997 >
}

union{
object{STILLETO}

box{
<1,1,6>,<-1,-1,800>
  texture {BEAM}
hollow
translate < 0, -8, 0 >
}

box{
<1,1,6>,<-1,-1,1200>
  texture {BEAM}
hollow
translate < 0, -8, 0 >
rotate < 0, 0, 120 >
}

box{
<1,1,6>,<-1,-1,1600>
hollow
  texture {BEAM}
translate < 0, -8, 0 >
rotate < 0, 0, -120 >
}
      scale <0.5, 0.5, 0.5>
      translate < 0, 0, -800>
      rotate < -7, -15, 0 >
      translate < -500, -90, 990 >
}
