#include "colors.inc"
#include "FLTextur.inc"

global_settings {
    ambient_light color rgb 1}

camera {
    location <-1.3,1,-998.5>
    look_at <-1.2,.8,-997>
    aperture .022
    focal_point <0.0002,0.772,-997>
    blur_samples 70
    confidence 0.975
    variance 1/255
}

#include "mount.inc"
object {Mount
    scale <6400*1.7,1500,4800*1.7>
    translate <0,0,4000>
}
object {Mount2
    scale <6400*3.4,4500,1500*3>
    rotate <-2,0,0>
    translate <0,0,4000+4800*1.7>
}

#include "desert.inc"
object {Desert translate <3,.05,0>}

#include "stones"
object {Stones}

#include "street.inc"
object {Street}

#include "city2.inc"
object {City
    translate <100,0,-600>
    pigment {color rgb .05}
}

#include "flower.inc"
object {Flower
    translate <-1.5,.1,-997>
}

#include "sign.inc"
object {Sign
    rotate <20,40,20>
    translate <5,1.5,-983>
}

#include "lights.inc"

object {Sky}

object {Flare}

fog {
    distance 1000
    color rgb <.9,.7,.5>
    fog_type 2
    fog_offset 0
    fog_alt 15
    turbulence .1
    turb_depth .3
    omega 0.7
    lambda 2.5
    octaves 5
    up <0,1,0>
}

fog {
    distance 15000
    color rgbt <.7,.7,.9,.2>
    fog_type 2
    fog_offset 0
    fog_alt 1000
    up <0,1,0>
}