
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "woods.inc"
#include "metals.inc"
#include "benediti.map"
#include "marbteal.map"

global_settings
{
  assumed_gamma 1.2
}

camera {
    location <2.65,3.25,-12.>
    look_at <0,0,0>
    direction <0,0,1.0>
    up <0,1.2,0>
    right <1.,0,0>
}

light_source {
   <-10,5,-10> color Yellow
}

light_source {
   <10, 12, -10> color rgb <1,1,1>
}

light_source {
   <-10, 12, -10> color rgb <1,1,1>
}

#declare Length=5.3
#declare Heigth=6.5
#declare Depth=0.58


# declare Colomn =
union {
object {cylinder { <-Depth/2., 0.001, Depth/2.>, <-Depth/2.,3.,Depth/2.>, Depth/2.}
}
object { box{ <-Depth-0.001,3.0001,0.000001>, <0.0001,3.1,Depth> }
texture {T_Stone8}}
object { box{ <-Depth-0.05,3.10001,0.000001>, <0.05,3.2,Depth> }
texture {T_Stone8}}
object { box{ <-Depth-0.1,3.2001,0.000001>, <0.1,3.299999,Depth> }
texture {T_Stone8}}
}

#declare Colomn_0 =
union {
object {box{<-Depth,0.5,0.001> <0.001,0.8,Depth>} 
texture {T_Stone8}}		//texture {pigment{color rgb <0.9,0.9,0.9>}}}
object {Colomn translate <0,0.8,0> texture {T_Stone16}}
}

#declare Wall =
union {
difference {
object { box{<0,0,0> <Length,Heigth,Depth>
texture{
            pigment {
            crackle
            turbulence 0.8
            octaves 5
            lambda 2.25
            omega 0.707
            color_map { M_Benediti }
            phase 0.97
            scale 1.3
        }
        finish { specular 0.85 roughness 0.0015 }
    }
}}		//   texture {pigment {Salmon}} }}
object { box{<-0.00001,0.5,-0.001> <4., 0.8, Depth+0.001>} }
object { box{<-0.00001,0.79999,-0.0001> <4.8, 4.1, Depth+0.0001>}}
object { cylinder { <2., 3.8, -0.001>, <2.,3.8,Depth+0.001 >, 2.0 } }
}
object {Colomn translate <Depth+4.05, 0.8, 0> texture {T_Stone21}}
}

#declare Wall_0 =
union  {
 object {Wall}
 object {Colomn_0}}


object {Wall_0}


object {Wall_0 rotate <-90,180,0> translate <Length,-Depth,-Heigth>
texture {T_Stone21}}   // Bot

object {Wall rotate <0,90,0> translate <-Depth,0,0>  scale <1.,1.,1.226415>
texture {T_Stone21}}  // Left


object {Wall_0 rotate <90,180,0> translate <Length,Heigth+Depth,0>
texture {T_Stone21}}  //Top

#declare Wall1 =
object {Wall  
rotate <0,90,0> rotate <90,0,0> scale <1,0.6132075,1> texture{T_Stone21}}


object {Wall1 translate <Length,0,-Heigth>}	   //Right-Bottom
object {Wall1  rotate <-180,0,0> translate <Length,6.49999,0>}    //Right-Top


#declare r=4
#declare A=0.1
#declare B=0.9
#declare N=500
union { #while (N>=0)
#declare X=r*r*sin(A*N)*cos(B*N)
#declare Y=r*r*cos(A*N)*sin(B*N)
#declare Z=r*r*cos(A*N)
//#declare Z=r*exp(-A*N)
sphere {<X,Y,Z>, 1
texture {T_Gold_3A}	//texture {pigment {color rgb <0.5,0,0>}}
scale <0.4,0.2,2> translate <2,3,37>
}
#declare N=N-1
#end
}

#declare Pl1 =
union {
#declare r=4
#declare A=0.1
#declare B=0.2
#declare N=300
union { #while (N>=0)
#declare X=r*r*sin(A*N)*cos(B*N)
#declare Y=r*r*cos(A*N)*sin(B*N)
#declare Z=r*r*cos(A*N)*sin(A*N)
sphere {<X,Y,Z>, 1
texture {T_Silver_5C}	//texture {pigment {color rgb <0,0,0.5>}}
rotate <0,0,130> 
translate <12,12,10> 
scale <0.2,0.2,1.5> 
}
#declare N=N-1
#end
}

union {
#include "nig_tes.inc"
scale <0.3,0.6,0.5>
rotate <90,50,-30>
translate <2.,-3,0>
}
union {
#include "nig_tes.inc"
scale <0.3,0.4,0.5>
rotate <90,50,30>
translate <8,-1,0.5>
}
}
object {Pl1}

sphere {
   <0,0,0>,1
   texture {Starfield finish {diffuse 0 reflection 0}}
   scale 1000000
   hollow
   no_shadow
}
#declare Planet =
sphere {
<0,0,0>,1
texture { pigment {spotted
turbulence .5
color_map {
[0 color rgb <1,.8,.5>] [1 color rgb <1,1,.5>]}
      scale 1/10 }  
      finish {ambient 1 diffuse 0}
   }
   scale 4
   translate <5,30,45>
   hollow
}

object {Planet}
object {Planet translate <-27,-3.5,-3.5> scale 0.22}

plane {			//Top
   <0,0,-1>,0
   texture {
      pigment {
      marble
      color_map {
      [0 color Blue]
      [.3 color Clear]
        }
      scale 2
      turbulence .5
      }
      finish {ambient 1 diffuse 0}
      rotate <0,0,90>
      translate <0,-1,0>
   }
   clipped_by {
   plane {
   <0,1,0>,.8
      }
   plane {
   <0,-1,0>,.7
     }
  }
   hollow
   scale 20
   rotate <0,45,0>
   translate <10,5,0>
}

object {Colomn scale <0.9,1,1> rotate <90,30,0> translate <2.,-1.3,-2.7> 
texture {T_Stone16}}

union {
#include "surf.inc"
scale 1.2 rotate <90,0,0> translate <1.,-6,4.2>}
//object {Pl1 rotate <0,0,180> translate <2,4,4>}
// texture{pigment<color rgb<0,0.5,0.5>}}}

/*
#declare Con =
object {cone {<0,0,0>, 0.1 
<0,1.3,0>, 0. texture {T_Copper_5E}}}

object {Con  
translate <2.3,-2.3,-2.0>}

object {Con  
translate <1.4,-2.5,-2.5>}

object {Con  
translate <1.7,-2.2,0>}

object {Con  
translate <2.8,-2.5,-2.3>}

object {Con  
translate <3.,-2.,-1.0>}
*/