//**************************************************************************
// Title                : The Escape
// Author               : Gautam N. Lad
// E-Mail Address       : gautam@interlog.com
// Website              : http://www.interlog.com/~gautam
// Date Rendered        : October 29-30, 1996
// Total Rendering Time : 1 hours  2 minutes  18.0 seconds (3738 seconds)
// Renderer             : POV-Ray v3.0.msdos.wat-cwa
//**************************************************************************

#include "GNLESCPE.INC"

global_settings { assumed_gamma 1.0 }


camera {
    location <24.3407, 35.5038, 53.5859>
   direction <0, 0, 1.86603>
         sky <0, 1, 0>
          up <0, 1, 0>
       right <1.33333, 0, 0>
     look_at <7.56573, 5.84134, -5.03908>
}

//   Explosion of Star
sphere { 0, 32.5
    texture { EXPLOSION }
    translate <1, -24.5, -100>
    hollow
    scale 3.625
}


// Space
plane { z, -1
        translate<0,0,-375>
        texture { GNL_NightSky scale 195}
        hollow
        no_shadow
        }

// Red/orange light from explosion
light_source { <14,140, -900> color rgb <.153 0 0> }
light_source { <4, 144, -900> color rgb <.32 .16 0> }
light_source { <5, 146, -450> color rgb <.51 .26 0> }

light_source { <14,140, -900> color rgb <.278 0 0> shadowless }
light_source { <6, 60, -350> color rgb <.475 .475 .475> shadowless }
light_source { <0,1000,0> color rgb <.475 .475 .475> shadowless }



union {  // Layer name: LIGHTS
    sphere { <0.0, 0.0, 0.0>, 0.5
        texture { SHIPS_LIGHT }
        scale <0.5, 0.5, 0.5>
        rotate <.0, .0, -2.36747>
        translate <1.78412, -15.6438, -62>
        no_shadow
        hollow
    }
    sphere { <0.0, 0.0, 0.0>, 0.5
        texture { SHIPS_LIGHT }
        scale <0.625, 0.625, 0.625>
        rotate <.0, .0, -22.1663>
        translate <-27.6031, 0.5103747, -46.375>
        no_shadow
        hollow
    }
    sphere { <0.0, 0.0, 0.0>, 0.5
        texture { SHIPS_LIGHT }
        scale <0.8, 0.8, 0.8>
        rotate <.0, .0, -26.5651>
        translate <4.02603, -29.6008, -38.3>
        no_shadow
        hollow
    }
    sphere { <0.0, 0.0, 0.0>, 0.5
        texture { SHIPS_LIGHT }
        scale <0.5, 0.5, 0.5>
        rotate <.0, .0, -22.1663>
        translate <-12.5825, 0.4082998, -58.5>
        no_shadow
        hollow
    }
    sphere { <0.0, 0.0, 0.0>, 0.5
        texture { SHIPS_LIGHT }
        scale <0.75, 0.75, 0.75>
        rotate <.0, .0, -337.166>
        translate <20.1045, -30.6544, -68.625>
        no_shadow
        hollow
}
    sphere { <0.0, 0.0, 0.0>, 0.5
        texture { SHIPS_LIGHT }
        rotate <.0, .0, -26.5651>
        translate <-5.96746, -3.50106, -11>
        no_shadow
        hollow
    }
}

union {  // Layer name: ROCKETS
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 5, 0.0>, 0.25
        texture { SHINY_WHITE }
        scale <0.5, 0.5, 0.5>
        rotate <90, .0, .0>
        rotate <.0, .0, -2.36747>
        translate <6.02017, -16.0691, -63>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 1.5, 0
        texture { SHINY_RED }
        scale <0.5, 0.5, 0.5>
        rotate <360, .0, .0>
        rotate <.0, .0, -2.36747>
        translate <6.02017, -16.0691, -63>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 1.5, 0
        texture { SHINY_RED }
        scale <0.5, 0.5, 0.5>
        rotate <360, .0, .0>
        rotate <.0, .0, -272.367>
        rotate <.0, 270, .0>
        translate <6.02017, -16.0691, -63>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 2, 0.0>, 0
        texture { SHINY_RED }
        scale <0.5, 0.5, 0.5>
        rotate <90, .0, .0>
        rotate <.0, .0, -2.36747>
        translate <6.02017, -16.0691, -60.5>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.26, <0.0, 1.5, 0.0>, 0.26
        texture { SHINY_RED }
        scale <0.5, 0.5, 0.5>
        rotate <90, .0, .0>
        rotate <.0, .0, -2.36747>
        translate <6.02017, -16.0691, -61.75>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 0.125
        texture { SHINY_RED }
        scale <0.5, 0.5, 0.5>
        rotate <.0, .0, -2.36747>
        translate <5.82954, -16.0612, -61.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 0.125
        texture { SHINY_RED }
        scale <0.5, 0.5, 0.5>
        rotate <.0, .0, -2.36747>
        translate <-2.28195, -15.7259, -61.5>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.26, <0.0, 1.5, 0.0>, 0.26
        texture { SHINY_RED }
        scale <0.5, 0.5, 0.5>
        rotate <90, .0, .0>
        rotate <.0, .0, -2.36747>
        translate <-2.47258, -15.718, -61.75>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 2, 0.0>, 0
        texture { SHINY_RED }
        scale <0.5, 0.5, 0.5>
        rotate <90, .0, .0>
        rotate <.0, .0, -2.36747>
        translate <-2.47258, -15.718, -60.5>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 1.5, 0
        texture { SHINY_RED }
        scale <0.5, 0.5, 0.5>
        rotate <360, .0, .0>
        rotate <.0, .0, -272.367>
        rotate <.0, 270, .0>
        translate <-2.47258, -15.718, -63>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 1.5, 0
        texture { SHINY_RED }
        scale <0.5, 0.5, 0.5>
        rotate <360, .0, .0>
        rotate <.0, .0, -2.36747>
        translate <-2.47258, -15.718, -63>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 5, 0.0>, 0.25
        texture { SHINY_WHITE }
        scale <0.5, 0.5, 0.5>
        rotate <90, .0, .0>
        rotate <.0, .0, -2.36747>
        translate <-2.47258, -15.718, -63>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 5, 0.0>, 0.25
        texture { SHINY_WHITE }
        scale <0.625, 0.625, 0.625>
        rotate <90, .0, .0>
        rotate <.0, .0, -22.1663>
        translate <-22.8011, -1.78342, -47.625>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 1.5, 0
        texture { SHINY_RED }
        scale <0.625, 0.625, 0.625>
        rotate <360, .0, .0>
        rotate <.0, .0, -22.1663>
        translate <-22.8011, -1.78342, -47.625>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 1.5, 0
        texture { SHINY_RED }
        scale <0.625, 0.625, 0.625>
        rotate <360, .0, .0>
        rotate <.0, .0, -292.166>
        rotate <.0, 270, .0>
        translate <-22.8011, -1.78342, -47.625>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 2, 0.0>, 0
        texture { SHINY_RED }
        scale <0.625, 0.625, 0.625>
        rotate <90, .0, .0>
        rotate <.0, .0, -22.1663>
        translate <-22.8011, -1.78342, -44.5>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.26, <0.0, 1.5, 0.0>, 0.26
        texture { SHINY_RED }
        scale <0.625, 0.625, 0.625>
        rotate <90, .0, .0>
        rotate <.0, .0, -22.1663>
        translate <-22.8011, -1.78342, -46.0625>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 0.125
        texture { SHINY_RED }
        scale <0.625, 0.625, 0.625>
        rotate <.0, .0, -22.1663>
        translate <-23.022, -1.69344, -45.75>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 0.125
        texture { SHINY_RED }
        scale <0.625, 0.625, 0.625>
        rotate <.0, .0, -22.1663>
        translate <-32.42, 2.13538, -45.75>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.26, <0.0, 1.5, 0.0>, 0.26
        texture { SHINY_RED }
        scale <0.625, 0.625, 0.625>
        rotate <90, .0, .0>
        rotate <.0, .0, -22.1663>
        translate <-32.6408, 2.22536, -46.0625>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 2, 0.0>, 0
        texture { SHINY_RED }
        scale <0.625, 0.625, 0.625>
        rotate <90, .0, .0>
        rotate <.0, .0, -22.1663>
        translate <-32.6408, 2.22536, -44.5>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 1.5, 0
        texture { SHINY_RED }
        scale <0.625, 0.625, 0.625>
        rotate <360, .0, .0>
        rotate <.0, .0, -292.166>
        rotate <.0, 270, .0>
        translate <-32.6408, 2.22536, -47.625>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 1.5, 0
        texture { SHINY_RED }
        scale <0.625, 0.625, 0.625>
        rotate <360, .0, .0>
        rotate <.0, .0, -22.1663>
        translate <-32.6408, 2.22536, -47.625>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 5, 0.0>, 0.25
        texture { SHINY_WHITE }
        scale <0.625, 0.625, 0.625>
        rotate <90, .0, .0>
        rotate <.0, .0, -22.1663>
        translate <-32.6408, 2.22536, -47.625>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 5, 0.0>, 0.25
        texture { SHINY_WHITE }
        scale <0.8, 0.8, 0.8>
        rotate <90, .0, .0>
        rotate <.0, .0, -3.7314>
        translate <-2.78558, -29.5575, -39.9>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 1.5, 0
        texture { SHINY_RED }
        scale <0.8, 0.8, 0.8>
        rotate <360, .0, .0>
        rotate <.0, .0, -3.7314>
        translate <-2.78558, -29.5575, -39.9>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 1.5, 0
        texture { SHINY_RED }
        scale <0.8, 0.8, 0.8>
        rotate <360, .0, .0>
        rotate <.0, .0, -273.731>
        rotate <.0, 270, .0>
        translate <-2.78558, -29.5575, -39.9>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 2, 0.0>, 0
        texture { SHINY_RED }
        scale <0.8, 0.8, 0.8>
        rotate <90, .0, .0>
        rotate <.0, .0, -3.7314>
        translate <-2.78558, -29.5575, -35.9>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.26, <0.0, 1.5, 0.0>, 0.26
        texture { SHINY_RED }
        scale <0.8, 0.8, 0.8>
        rotate <90, .0, .0>
        rotate <.0, .0, -3.7314>
        translate <-2.78558, -29.5575, -37.9>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 0.125
        texture { SHINY_RED }
        scale <0.8, 0.8, 0.8>
        rotate <.0, .0, -3.7314>
        translate <-2.48097, -29.5773, -37.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 0.125
        texture { SHINY_RED }
        scale <0.8, 0.8, 0.8>
        rotate <.0, .0, -3.7314>
        translate <10.481, -30.4227, -37.5>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.26, <0.0, 1.5, 0.0>, 0.26
        texture { SHINY_RED }
        scale <0.8, 0.8, 0.8>
        rotate <90, .0, .0>
        rotate <.0, .0, -3.7314>
        translate <10.7856, -30.4425, -37.9>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 2, 0.0>, 0
        texture { SHINY_RED }
        scale <0.8, 0.8, 0.8>
        rotate <90, .0, .0>
        rotate <.0, .0, -3.7314>
        translate <10.7856, -30.4425, -35.9>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 1.5, 0
        texture { SHINY_RED }
        scale <0.8, 0.8, 0.8>
        rotate <360, .0, .0>
        rotate <.0, .0, -273.731>
        rotate <.0, 270, .0>
        translate <10.7856, -30.4425, -39.9>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 1.5, 0
        texture { SHINY_RED }
        scale <0.8, 0.8, 0.8>
        rotate <360, .0, .0>
        rotate <.0, .0, -3.7314>
        translate <10.7856, -30.4425, -39.9>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 5, 0.0>, 0.25
        texture { SHINY_WHITE }
        scale <0.8, 0.8, 0.8>
        rotate <90, .0, .0>
        rotate <.0, .0, -3.7314>
        translate <10.7856, -30.4425, -39.9>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 5, 0.0>, 0.25
        texture { SHINY_WHITE }
        scale <0.5, 0.5, 0.5>
        rotate <90, .0, .0>
        rotate <.0, .0, -22.1663>
        translate <-16.6127, 1.78029, -59.5>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 1.5, 0
        texture { SHINY_RED }
        scale <0.5, 0.5, 0.5>
        rotate <360, .0, .0>
        rotate <.0, .0, -22.1663>
        translate <-16.6127, 1.78029, -59.5>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 1.5, 0
        texture { SHINY_RED }
        scale <0.5, 0.5, 0.5>
        rotate <360, .0, .0>
        rotate <.0, .0, -292.166>
        rotate <.0, 270, .0>
        translate <-16.6127, 1.78029, -59.5>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 2, 0.0>, 0
        texture { SHINY_RED }
        scale <0.5, 0.5, 0.5>
        rotate <90, .0, .0>
        rotate <.0, .0, -22.1663>
        translate <-16.6127, 1.78029, -57>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.26, <0.0, 1.5, 0.0>, 0.26
        texture { SHINY_RED }
        scale <0.5, 0.5, 0.5>
        rotate <90, .0, .0>
        rotate <.0, .0, -22.1663>
        translate <-16.6127, 1.78029, -58.25>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 0.125
        texture { SHINY_RED }
        scale <0.5, 0.5, 0.5>
        rotate <.0, .0, -22.1663>
        translate <-16.436, 1.7083, -58>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 0.125
        texture { SHINY_RED }
        scale <0.5, 0.5, 0.5>
        rotate <.0, .0, -22.1663>
        translate <-8.91757, -1.35475, -58>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.26, <0.0, 1.5, 0.0>, 0.26
        texture { SHINY_RED }
        scale <0.5, 0.5, 0.5>
        rotate <90, .0, .0>
        rotate <.0, .0, -22.1663>
        translate <-8.74088, -1.42674, -58.25>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 2, 0.0>, 0
        texture { SHINY_RED }
        scale <0.5, 0.5, 0.5>
        rotate <90, .0, .0>
        rotate <.0, .0, -22.1663>
        translate <-8.74088, -1.42674, -57>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 1.5, 0
        texture { SHINY_RED }
        scale <0.5, 0.5, 0.5>
        rotate <360, .0, .0>
        rotate <.0, .0, -292.166>
        rotate <.0, 270, .0>
        translate <-8.74088, -1.42674, -59.5>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 1.5, 0
        texture { SHINY_RED }
        scale <0.5, 0.5, 0.5>
        rotate <360, .0, .0>
        rotate <.0, .0, -22.1663>
        translate <-8.74088, -1.42674, -59.5>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 5, 0.0>, 0.25
        texture { SHINY_WHITE }
        scale <0.5, 0.5, 0.5>
        rotate <90, .0, .0>
        rotate <.0, .0, -22.1663>
        translate <-8.74088, -1.42674, -59.5>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 5, 0.0>, 0.25
        texture { SHINY_WHITE }
        scale <0.75, 0.75, 0.75>
        rotate <90, .0, .0>
        rotate <.0, .0, -337.166>
        translate <14.3746, -33.4739, -70.125>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 1.5, 0
        texture { SHINY_RED }
        scale <0.75, 0.75, 0.75>
        rotate <360, .0, .0>
        rotate <.0, .0, -337.166>
        translate <14.3746, -33.4739, -70.125>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 1.5, 0
        texture { SHINY_RED }
        scale <0.75, 0.75, 0.75>
        rotate <360, .0, .0>
        rotate <.0, .0, -247.166>
        rotate <.0, 270, .0>
        translate <14.3746, -33.4739, -70.125>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 2, 0.0>, 0
        texture { SHINY_RED }
        scale <0.75, 0.75, 0.75>
        rotate <90, .0, .0>
        rotate <.0, .0, -337.166>
        translate <14.3746, -33.4739, -66.375>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.26, <0.0, 1.5, 0.0>, 0.26
        texture { SHINY_RED }
        scale <0.75, 0.75, 0.75>
        rotate <90, .0, .0>
        rotate <.0, .0, -337.166>
        translate <14.3746, -33.4739, -68.25>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 0.125
        texture { SHINY_RED }
        scale <0.75, 0.75, 0.75>
        rotate <.0, .0, -337.166>
        translate <14.6383, -33.3628, -67.875>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 0.125
        texture { SHINY_RED }
        scale <0.75, 0.75, 0.75>
        rotate <.0, .0, -337.166>
        translate <25.8617, -28.6372, -67.875>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.26, <0.0, 1.5, 0.0>, 0.26
        texture { SHINY_RED }
        scale <0.75, 0.75, 0.75>
        rotate <90, .0, .0>
        rotate <.0, .0, -337.166>
        translate <26.1254, -28.5261, -68.25>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 2, 0.0>, 0
        texture { SHINY_RED }
        scale <0.75, 0.75, 0.75>
        rotate <90, .0, .0>
        rotate <.0, .0, -337.166>
        translate <26.1254, -28.5261, -66.375>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 1.5, 0
        texture { SHINY_RED }
        scale <0.75, 0.75, 0.75>
        rotate <360, .0, .0>
        rotate <.0, .0, -247.166>
        rotate <.0, 270, .0>
        translate <26.1254, -28.5261, -70.125>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 1.5, 0
        texture { SHINY_RED }
        scale <0.75, 0.75, 0.75>
        rotate <360, .0, .0>
        rotate <.0, .0, -337.166>
        translate <26.1254, -28.5261, -70.125>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 5, 0.0>, 0.25
        texture { SHINY_WHITE }
        scale <0.75, 0.75, 0.75>
        rotate <90, .0, .0>
        rotate <.0, .0, -337.166>
        translate <26.1254, -28.5261, -70.125>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 5, 0.0>, 0.25
        texture { SHINY_WHITE }
        rotate <90, .0, .0>
        rotate <.0, .0, -3.7314>
        translate <2.48198, -4.55317, -13>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 1.5, 0
        texture { SHINY_RED }
        rotate <360, .0, .0>
        rotate <.0, .0, -3.7314>
        translate <2.48198, -4.55317, -13>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 1.5, 0
        texture { SHINY_RED }
        rotate <360, .0, .0>
        rotate <.0, .0, -273.731>
        rotate <.0, 270, .0>
        translate <2.48198, -4.55317, -13>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 2, 0.0>, 0
        texture { SHINY_RED }
        rotate <90, .0, .0>
        rotate <.0, .0, -3.7314>
        translate <2.48198, -4.55317, -8>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.26, <0.0, 1.5, 0.0>, 0.26
        texture { SHINY_RED }
        rotate <90, .0, .0>
        rotate <.0, .0, -3.7314>
        translate <2.48198, -4.55317, -10.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 0.125
        texture { SHINY_RED }
        rotate <.0, .0, -3.7314>
        translate <2.10121, -4.52834, -10>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 0.125
        texture { SHINY_RED }
        rotate <.0, .0, -3.7314>
        translate <-14.1012, -3.47166, -10>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.26, <0.0, 1.5, 0.0>, 0.26
        texture { SHINY_RED }
        rotate <90, .0, .0>
        rotate <.0, .0, -3.7314>
        translate <-14.482, -3.44683, -10.5>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 2, 0.0>, 0
        texture { SHINY_RED }
        rotate <90, .0, .0>
        rotate <.0, .0, -3.7314>
        translate <-14.482, -3.44683, -8>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 1.5, 0
        texture { SHINY_RED }
        rotate <360, .0, .0>
        rotate <.0, .0, -273.731>
        rotate <.0, 270, .0>
        translate <-14.482, -3.44683, -13>
        no_shadow
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 1.5, 0
        texture { SHINY_RED }
        rotate <360, .0, .0>
        rotate <.0, .0, -3.7314>
        translate <-14.482, -3.44683, -13>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 5, 0.0>, 0.25
        texture { SHINY_WHITE }
        rotate <90, .0, .0>
        rotate <.0, .0, -3.7314>
        translate <-14.482, -3.44683, -13>
        no_shadow
    }
}

difference {  // Layer name: CUTS
    sphere { <0.0, 0.0, 0.0>, 8
        texture { SHIP }
        scale <0.5, 0.0625, 0.5>
        rotate <.0, .0, -2.36747>
        translate <1.7738, -15.8936, -61.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 6
        texture { SHIP }
        scale <0.5, 0.25, 0.5>
        rotate <.0, .0, -2.36747>
        translate <1.7738, -15.8936, -62.75>
        no_shadow
    }
}
difference {
    sphere { <0.0, 0.0, 0.0>, 8
        texture { SHIP }
        scale <0.625, 0.078125, 0.625>
        rotate <.0, .0, -22.1663>
        translate <-27.721, 0.2209709, -45.75>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 6
        texture { SHIP }
        scale <0.625, 0.3125, 0.625>
        rotate <.0, .0, -22.1663>
        translate <-27.721, 0.2209709, -47.3125>
        no_shadow
    }
}
difference {

    sphere { <0.0, 0.0, 0.0>, 8
        texture { SHIP }
        scale <0.8, 0.1, 0.8>
        rotate <.0, .0, -3.7314>
        translate <4, -30, -37.5>
        no_shadow
    }

    sphere { <0.0, 0.0, 0.0>, 6
        texture { SHIP }
        scale <0.8, 0.4, 0.8>
        rotate <.0, .0, -3.7314>
        translate <4, -30, -39.5>
        no_shadow
    }
}
difference {
    sphere { <0.0, 0.0, 0.0>, 8
        texture { SHIP }
        scale <0.5, 0.0625, 0.5>
        rotate <.0, .0, -22.1663>
        translate <-12.6768, 0.1767767, -58>
        no_shadow
    }

    sphere { <0.0, 0.0, 0.0>, 6
        texture { SHIP }
        scale <0.5, 0.25, 0.5>
        rotate <.0, .0, -22.1663>
        translate <-12.6768, 0.1767767, -59.25>
        no_shadow
    }
}
difference {
    sphere { <0.0, 0.0, 0.0>, 8
        texture { SHIP }
        scale <0.75, 0.09375, 0.75>
        rotate <.0, .0, -337.166>
        translate <20.25, -31, -67.875>
        no_shadow
    }

    sphere { <0.0, 0.0, 0.0>, 6
        texture { SHIP }
        scale <0.75, 0.375, 0.75>
        rotate <.0, .0, -337.166>
        translate <20.25, -31, -69.75>
        no_shadow
    }
}
difference {
    sphere { <0.0, 0.0, 0.0>, 8
        texture { SHIP }
        scale <1, 0.125, 1>
        rotate <.0, .0, -3.7314>
        translate <-6, -4, -10>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 6
        texture { SHIP }
        scale <1, 0.5, 1>
        rotate <.0, .0, -3.7314>
        translate <-6, -4, -12.5>
        no_shadow
    }
}

union {  // Layer name: MAIN
    sphere { <0.0, 0.0, 0.0>, 0.25
        texture { DARK_BLUE }
        scale <0.5, 0.5, 0.5>
        rotate <.0, .0, -25.2011>
        translate <1.7738, -15.8936, -53>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.125, <0.0, 3, 0.0>, 0
        texture { SHINY_RED }
        scale <0.5, 0.5, 0.5>
        rotate <90, .0, .0>
        rotate <.0, .0, -25.2011>
        translate <1.7738, -15.8936, -53>
        no_shadow
    }
    torus { 1.5, 0.5 sturm
        texture { SHIP }
        scale <0.375, 2.5, 0.125>
        rotate <270, .0, .0>
        rotate <.0, .0, -2.36747>
        translate <-0.9945116, -16.2795, -60>
        no_shadow
    }
    torus { 1.5, 0.5 sturm
        texture { SHIP }
        scale <0.375, 2.5, 0.125>
        rotate <270, .0, .0>
        rotate <.0, .0, -2.36747>
        translate <4.50079, -16.5067, -60>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 1.75
        texture { GNL_SILVER }
        scale <0.5, 0.25, 0.75>
        rotate <.0, .0, -2.36747>
        translate <1.78412, -15.6438, -55.25>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3
        texture { SHIP }
        scale <0.325, 0.0625, 0.5>
        rotate <.0, .0, -2.36747>
        translate <1.7738, -15.8936, -54.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3
        texture { SHIP }
        scale <0.5, 0.0625, 0.5>
        rotate <.0, .0, -2.36747>
        translate <1.7738, -15.8936, -57>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 3.5, <0.0, 9, 0.0>, 3
        texture { DARK_BLUE }
        scale <0.5, 0.5, 0.06175>
        rotate <90, .0, .0>
        rotate <.0, .0, -2.36747>
        translate <1.7738, -15.8936, -62>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3.75
        texture { DARK_BLUE }
        scale <0.0625, 0.06, 0.5>
        rotate <.0, .0, -2.36747>
        translate <1.7738, -15.8936, -62>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3.75
        texture { DARK_BLUE }
        scale <0.0625, 0.06, 0.5>
        rotate <.0, .0, -2.36747>
        translate <1.7738, -15.8936, -62>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3.5
        texture { SHINY_WHITE }
        scale <0.5, 0.0625, 0.5>
        rotate <.0, .0, -2.36747>
        translate <1.7738, -15.8936, -62>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3
        texture { SHIP }
        scale <0.375, 0.0625, 0.5>
        rotate <.0, .0, -2.36747>
        translate <1.7738, -15.8936, -55.25>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3
        texture { SHIP }
        scale <0.5, 0.0625, 0.5>
        rotate <.0, .0, -2.36747>
        translate <1.7738, -15.8936, -57.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 0.25
        texture { DARK_BLUE }
        scale <0.625, 0.625, 0.625>
        rotate <.0, .0, -45>
        translate <-27.721, 0.2209709, -35.125>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.125, <0.0, 3, 0.0>, 0
        texture { SHINY_RED }
        scale <0.625, 0.625, 0.625>
        rotate <90, .0, .0>
        rotate <.0, .0, -45>
        translate <-27.721, 0.2209709, -35.125>
        no_shadow
    }
    torus { 1.5, 0.5 sturm
        texture { SHIP }
        scale <0.46875, 3.125, 0.15625>
        rotate <270, .0, .0>
        rotate <.0, .0, -22.1663>
        translate <-31.1402, 0.9391212, -43.875>
        no_shadow
    }
    torus { 1.5, 0.5 sturm
        texture { SHIP }
        scale <0.46875, 3.125, 0.15625>
        rotate <270, .0, .0>
        rotate <.0, .0, -22.1663>
        translate <-24.7733, -1.65479, -43.875>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 1.75
        texture { GNL_SILVER }
        scale <0.625, 0.3125, 0.9375>
        rotate <.0, .0, -22.1663>
        translate <-27.6031, 0.5103747, -37.9375>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3
        texture { SHIP }
        scale <0.40625, 0.078125, 0.625>
        rotate <.0, .0, -22.1663>
        translate <-27.721, 0.2209709, -37>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3
        texture { SHIP }
        scale <0.625, 0.078125, 0.625>
        rotate <.0, .0, -22.1663>
        translate <-27.721, 0.2209709, -40.125>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 3.5, <0.0, 9, 0.0>, 3
        texture { DARK_BLUE }
        scale <0.625, 0.625, 0.0771875>
        rotate <90, .0, .0>
        rotate <.0, .0, -22.1663>
        translate <-27.721, 0.2209709, -46.375>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3.75
        texture { DARK_BLUE }
        scale <0.078125, 0.075, 0.625>
        rotate <.0, .0, -22.1663>
        translate <-27.721, 0.2209709, -46.375>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3.75
        texture { DARK_BLUE }
        scale <0.078125, 0.075, 0.625>
        rotate <.0, .0, -22.1663>
        translate <-27.721, 0.2209709, -46.375>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3.5
        texture { SHINY_WHITE }
        scale <0.625, 0.078125, 0.625>
        rotate <.0, .0, -22.1663>
        translate <-27.721, 0.2209709, -46.375>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3
        texture { SHIP }
        scale <0.46875, 0.078125, 0.625>
        rotate <.0, .0, -22.1663>
        translate <-27.721, 0.2209709, -37.9375>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3
        texture { SHIP }
        scale <0.625, 0.078125, 0.625>
        rotate <.0, .0, -22.1663>
        translate <-27.721, 0.2209709, -40.75>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3
        texture { SHIP }
        scale <0.8, 0.1, 0.8>
        rotate <.0, .0, -3.7314>
        translate <4, -30, -31.1>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3
        texture { SHIP }
        scale <0.6, 0.1, 0.8>
        rotate <.0, .0, -3.7314>
        translate <4, -30, -27.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3.5
        texture { SHINY_WHITE }
        scale <0.8, 0.1, 0.8>
        rotate <.0, .0, -3.7314>
        translate <4, -30, -38.3>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3.75
        texture { DARK_BLUE }
        scale <0.1, 0.096, 0.8>
        rotate <.0, .0, -3.7314>
        translate <4, -30, -38.3>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3.75
        texture { DARK_BLUE }
        scale <0.1, 0.096, 0.8>
        rotate <.0, .0, -3.7314>
        translate <4, -30, -38.3>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 3.5, <0.0, 9, 0.0>, 3
        texture { DARK_BLUE }
        scale <0.8, 0.8, 0.0988>
        rotate <90, .0, .0>
        rotate <.0, .0, -3.7314>
        translate <4, -30, -38.3>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3
        texture { SHIP }
        scale <0.8, 0.1, 0.8>
        rotate <.0, .0, -3.7314>
        translate <4, -30, -30.3>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3
        texture { SHIP }
        scale <0.52, 0.1, 0.8>
        rotate <.0, .0, -3.7314>
        translate <4, -30, -26.3>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 1.75
        texture { GNL_SILVER }
        scale <0.8, 0.4, 1.2>
        rotate <.0, .0, -3.7314>
        translate <4.02603, -29.6008, -27.5>
        no_shadow
    }
    torus { 1.5, 0.5 sturm
        texture { SHIP }
        scale <0.6, 4, 0.2>
        rotate <270, .0, .0>
        rotate <.0, .0, -3.7314>
        translate <8.33861, -31.0847, -35.1>
        no_shadow
    }
    torus { 1.5, 0.5 sturm
        texture { SHIP }
        scale <0.6, 4, 0.2>
        rotate <270, .0, .0>
        rotate <.0, .0, -3.7314>
        translate <-0.4427358, -30.512, -35.1>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.125, <0.0, 3, 0.0>, 0
        texture { SHINY_RED }
        scale <0.8, 0.8, 0.8>
        rotate <90, .0, .0>
        rotate <.0, .0, -26.5651>
        translate <4, -30, -23.9>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 0.25
        texture { DARK_BLUE }
        scale <0.8, 0.8, 0.8>
        rotate <.0, .0, -26.5651>
        translate <4, -30, -23.9>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3
        texture { SHIP }
        scale <0.5, 0.0625, 0.5>
        rotate <.0, .0, -22.1663>
        translate <-12.6768, 0.1767767, -54>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3
        texture { SHIP }
        scale <0.375, 0.0625, 0.5>
        rotate <.0, .0, -22.1663>
        translate <-12.6768, 0.1767767, -51.75>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3.5
        texture { SHINY_WHITE }
        scale <0.5, 0.0625, 0.5>
        rotate <.0, .0, -22.1663>
        translate <-12.6768, 0.1767767, -58.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3.75
        texture { DARK_BLUE }
        scale <0.0625, 0.06, 0.5>
        rotate <.0, .0, -22.1663>
        translate <-12.6768, 0.1767767, -58.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3.75
        texture { DARK_BLUE }
        scale <0.0625, 0.06, 0.5>
        rotate <.0, .0, -22.1663>
        translate <-12.6768, 0.1767767, -58.5>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 3.5, <0.0, 9, 0.0>, 3
        texture { DARK_BLUE }
        scale <0.5, 0.5, 0.06175>
        rotate <90, .0, .0>
        rotate <.0, .0, -22.1663>
        translate <-12.6768, 0.1767767, -58.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3
        texture { SHIP }
        scale <0.5, 0.0625, 0.5>
        rotate <.0, .0, -22.1663>
        translate <-12.6768, 0.1767767, -53.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3
        texture { SHIP }
        scale <0.325, 0.0625, 0.5>
        rotate <.0, .0, -22.1663>
        translate <-12.6768, 0.1767767, -51>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 1.75
        texture { GNL_SILVER }
        scale <0.5, 0.25, 0.75>
        rotate <.0, .0, -22.1663>
        translate <-12.5825, 0.4082998, -51.75>
        no_shadow
    }
    torus { 1.5, 0.5 sturm
        texture { SHIP }
        scale <0.375, 2.5, 0.125>
        rotate <270, .0, .0>
        rotate <.0, .0, -22.1663>
        translate <-10.3187, -1.32384, -56.5>
        no_shadow
    }
    torus { 1.5, 0.5 sturm
        texture { SHIP }
        scale <0.375, 2.5, 0.125>
        rotate <270, .0, .0>
        rotate <.0, .0, -22.1663>
        translate <-15.4122, 0.751297, -56.5>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.125, <0.0, 3, 0.0>, 0
        texture { SHINY_RED }
        scale <0.5, 0.5, 0.5>
        rotate <90, .0, .0>
        rotate <.0, .0, -45>
        translate <-12.6768, 0.1767767, -49.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 0.25
        texture { DARK_BLUE }
        scale <0.5, 0.5, 0.5>
        rotate <.0, .0, -45>
        translate <-12.6768, 0.1767767, -49.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3
        texture { SHIP }
        scale <0.75, 0.09375, 0.75>
        rotate <.0, .0, -337.166>
        translate <20.25, -31, -61.875>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3
        texture { SHIP }
        scale <0.5625, 0.09375, 0.75>
        rotate <.0, .0, -337.166>
        translate <20.25, -31, -58.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3.5
        texture { SHINY_WHITE }
        scale <0.75, 0.09375, 0.75>
        rotate <.0, .0, -337.166>
        translate <20.25, -31, -68.625>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3.75
        texture { DARK_BLUE }
        scale <0.09375, 0.09, 0.75>
        rotate <.0, .0, -337.166>
        translate <20.25, -31, -68.625>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3.75
        texture { DARK_BLUE }
        scale <0.09375, 0.09, 0.75>
        rotate <.0, .0, -337.166>
        translate <20.25, -31, -68.625>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 3.5, <0.0, 9, 0.0>, 3
        texture { DARK_BLUE }
        scale <0.75, 0.75, 0.092625>
        rotate <90, .0, .0>
        rotate <.0, .0, -337.166>
        translate <20.25, -31, -68.625>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3
        texture { SHIP }
        scale <0.75, 0.09375, 0.75>
        rotate <.0, .0, -337.166>
        translate <20.25, -31, -61.125>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3
        texture { SHIP }
        scale <0.4875, 0.09375, 0.75>
        rotate <.0, .0, -337.166>
        translate <20.25, -31, -57.375>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 1.75
        texture { GNL_SILVER }
        scale <0.75, 0.375, 1.125>
        rotate <.0, .0, -337.166>
        translate <20.1045, -30.6544, -58.5>
        no_shadow
    }
    torus { 1.5, 0.5 sturm
        texture { SHIP }
        scale <0.5625, 3.75, 0.1875>
        rotate <270, .0, .0>
        rotate <.0, .0, -337.166>
        translate <24.3428, -30.0905, -65.625>
        no_shadow
    }
    torus { 1.5, 0.5 sturm
        texture { SHIP }
        scale <0.5625, 3.75, 0.1875>
        rotate <270, .0, .0>
        rotate <.0, .0, -337.166>
        translate <16.7393, -33.292, -65.625>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.125, <0.0, 3, 0.0>, 0
        texture { SHINY_RED }
        scale <0.75, 0.75, 0.75>
        rotate <90, .0, .0>
        translate <20.25, -31, -55.125>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 0.25
        texture { DARK_BLUE }
        scale <0.75, 0.75, 0.75>
        translate <20.25, -31, -55.125>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 0.25
        texture { DARK_BLUE }
        rotate <.0, .0, -26.5651>
        translate <-6, -4, 7>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 0.125, <0.0, 3, 0.0>, 0
        texture { SHINY_RED }
        rotate <90, .0, .0>
        rotate <.0, .0, -26.5651>
        translate <-6, -4, 7>
        no_shadow
    }
    torus { 1.5, 0.5 sturm
        texture { SHIP }
        scale <0.75, 5, 0.25>
        rotate <270, .0, .0>
        rotate <.0, .0, -3.7314>
        translate <-11.5534, -4.63994, -7>
        no_shadow
    }
    torus { 1.5, 0.5 sturm
        texture { SHIP }
        scale <0.75, 5, 0.25>
        rotate <270, .0, .0>
        rotate <.0, .0, -3.7314>
        translate <-0.5767386, -5.35582, -7>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 1.75
        texture { GNL_SILVER }
        scale <1, 0.5, 1.5>
        rotate <.0, .0, -3.7314>
        translate <-5.96746, -3.50106, 2.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3
        texture { SHIP }
        scale <0.65, 0.125, 1>
        rotate <.0, .0, -3.7314>
        translate <-6, -4, 4>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3
        texture { SHIP }
        scale <1, 0.125, 1>
        rotate <.0, .0, -3.7314>
        translate <-6, -4, -1>
        no_shadow
    }
    cone { <0.0, 0.0, 0.0>, 3.5, <0.0, 9, 0.0>, 3
        texture { DARK_BLUE }
        scale <1, 1, 0.1235>
        rotate <90, .0, .0>
        rotate <.0, .0, -3.7314>
        translate <-6, -4, -11>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3.75
        texture { DARK_BLUE }
        scale <0.125, 0.12, 1>
        rotate <.0, .0, -3.7314>
        translate <-6, -4, -11>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3.75
        texture { DARK_BLUE }
        scale <0.125, 0.12, 1>
        rotate <.0, .0, -3.7314>
        translate <-6, -4, -11>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3.5
        texture { SHINY_WHITE }
        scale <1, 0.125, 1>
        rotate <.0, .0, -3.7314>
        translate <-6, -4, -11>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3
        texture { SHIP }
        scale <0.75, 0.125, 1>
        rotate <.0, .0, -3.7314>
        translate <-6, -4, 2.5>
        no_shadow
    }
    sphere { <0.0, 0.0, 0.0>, 3
        texture { SHIP }
        scale <1, 0.125, 1>
        rotate <.0, .0, -3.7314>
        translate <-6, -4, -2>
        no_shadow
    }
}

/*---------------------------------------------------------------------------
The Escape -- Copyright (C) 1996, Gautam N. Lad.  All Rights Reserved.

NOTE:  If YOU wish to use this image/file for ANY purpose, you MUST first
       contact me at my e-mail address to get my premission.
       Visit my website to find software/graphics/links, etc. at:
       http://www.interlog.com/~gautam
----------------------------------------------------------------------------*/
