
// Persistence of Vision Ray Tracer Scene Description File
// File: InOrbit.pov
// Vers: 3.00e Watcom Win32
// Desc: A Space Station In Orbit
// Date: October 12, 1996
// Auth: Sonya Roberts
// Note: Uses several different #include files of objects.  These are:
//

// ==== Standard Includes ====
#include "COLORS.inc"
#include "TEXTURES.inc"
#include "METALS.inc"
#include "SHAPES.inc"
#include "STONES.inc"
#include "STONES2.inc"
#include "WOODMAPS.inc"
#include "WOODS.inc"
#include "GLASS.inc"


// ==== Declare Expressions
#declare True = 1
#declare False = 0


// ==== Include Texture and Object Files ====
#include "InOrbit.inc"
#include "Cloudy.inc"

#declare InsertStarrySky=True
#declare InsertPlanet=True
#declare InsertCloudLayer=True
#declare InsertFullMoon=True
#include "BACKDROP.pov"

#declare InsertMainModule=True
#declare InsertCARM1=True
#declare InsertCARM2=True
#include "Station.pov"

// ==== Lights & Cameras ====
light_source {
	<50,50,-500>,
	color White
}

light_source {
	<0,2000,0>,
	color White
}

camera {
	location	<0,0,-100>
	up		<0,1,0>
	right		<1.33,0,0>
	look_at		<0,0,0>
}


// ==== Assemble Scene ====
// BACKDROP
#if (InsertStarrySky=True)	object {StarrySky}					#end
#if (InsertPlanet=True)		object {Planet		translate <-2000,-6500,3000>}	#end
#if (InsertCloudLayer=True)	object {CloudLayer	translate <-2000,-6500,3000>}	#end
#if (InsertFullMoon=True)	object {FullMoon	translate <3500,2500,8000>}	#end

// STATION
#if (InsertMainModule=True)
	object {
		MainModule
		scale <2,2,2>
		rotate x*-70
		rotate y*30
		translate <100,-20,600>
	}
#end
#if (InsertCARM1=True)
	object {
		CARM1
		rotate y*35
		rotate x*-15
		translate <-60,-6,0>
	}
#end
#if (InsertCARM2=True)
	object {
		CARM2
		rotate y*-90
		rotate x*-15
		translate <153.5,321,0>
		rotate x*-70
		rotate y*30
		translate <90,40,650>
	}
#end
