//***********************

//*  File:  Island.POV  *

//***********************



//*********************************************************

//*  Project Name:  Island                                *

//*  Artist:  Hugh                                        *

//*  E-Mail Address:  hue@earthlink.net                   *

//*  Project Started On:  10/01/1996                      *

//*  Project Ended On:  10/31/1996                        *

//*  Inspiration:  A Picture in a Card                    *

//*  Equipment:  Macintosh '030/25MHz/4MB RAM, no FPU     *

//*  Tools Used:  POV-Ray 3.0,                            *

//*               GraphicConverter(Island.GIF, TGA->JPG)  *

//*********************************************************







/* Included Files */

#include "Def.INC"







/* Light, Camera, and Action! */

light_source {

  <0.000, 0.000, 0.000>

  color rgb <0.188, 0.188, 0.188>

  translate <135.000, 51.200, 110.000>

  shadowless

}

light_source {

  <0.000, 0.000, 0.000>

  color rgb <0.188, 0.188, 0.188>

  translate <225, 67.000, 190.000>

  shadowless

}

light_source {

  <0.000, 0.000, 0.000>

  color rgb <1.000, 1.000, 1.000>

  translate <-512.000, 256.000, 128.000>

}

camera {

  location  <236.000, 40.000,  20.000>

  look_at   <100.000, 10.000, 220.000>

}







/* Texture of The Island */

//Reddish Wood+Gold Metal+Cyan-Thingie

#declare Wood_And_Gold = texture {

  wood

  turbulence 0.667

  texture_map {

    [0.000 pigment {

             color rgb <0.273, 0.222, 0.050>	//dark brown

           }

           finish { Wood_Finish }

    ]

    [0.375 Gold_Metal_Tex]

    [0.633 pigment {

             color rgb <0.472, 0.138, 0.127>	//dark red

           }

           finish { Wood_Finish }

    ]

    [0.813 pigment {

             color rgb <0.453, 1.000, 1.000>	//cyan

           }

           finish { Wood_Finish }

    ]

  }

  scale 0.25

}

//River of Static, etc.

#declare Isnd_Tex = texture {

  granite

  texture_map {

    [0.000 pigment {

             Static_Pigm

             scale 1/256

           }

           finish { Ocean_Finish }

    ]

    [0.255 pigment {

             Static_Pigm

             scale 1/256

           }

           finish { Ocean_Finish }

    ]

    [0.355 Wood_And_Gold]

    [0.985 Wood_And_Gold]

  }

}







/* Sky of Fire */

sphere {

  <0.000, 0.000, 0.000>, 8192.000

  texture {

    pigment {

      bozo

      color_map {

        [0.0 color rgb <0.000, 0.000, 0.000>]

        [0.2 color rgb <0.000, 0.000, 0.000>]

        [0.4 color rgb <1.000, 0.000, 0.000>]

        [0.6 color rgb <1.000, 1.000, 0.000>]

        [0.8 color rgb <1.000, 1.000, 1.000>]

      }

      scale 512.000

    }

    finish {

      ambient 1.000

      diffuse 0.000

    }

  }

  texture {

    pigment {

      gradient y

      color_map {

         [0.000 color rgb  <0.000, 0.000, 0.000>]

         [0.100 color rgbf <1.000, 1.000, 1.000, 1.000>]

         [1.000 color rgbf <1.000, 1.000, 1.000, 1.000>]

      }

      scale 8192.000

    }

  }

  hollow

}







/* Ocean of Static */

plane {

  y, 4.499

  texture {

    pigment {

      Static_Pigm

    }

    normal {

      ripples 1.000

      scale <8.000, 16.000, 8.000>

      translate <210.000, 0.000, 150.000>

    }

    finish { Ocean_Finish }

  }

  texture {

    pigment {

      gradient z

      color_map {

        [0.000 color rgbf <1.000, 1.000, 1.000, 1.000>]

        [0.100 color rgb  <0.150, 0.150, 0.150>]

        [1.000 color rgb  <0.150, 0.150, 0.150>]

      }

    }

    scale 8192.000

  }

}









/* The Island */

height_field {

  gif "IslandHF.GIF"

  texture { Isnd_Tex }

  scale <256.000, 128.000, 256.000>		//make it a bit bigger :)

}









/* Spider */

#include "Spider.INC"

object {

  Spider

  texture { pigment { color rgb <0.000, 1.000, 1.000> } }

  texture {

    pigment {

      marble

      turbulence 0.755

      color_map {

         [0.000 color rgbf <1.000, 1.000, 1.000, 1.000>]

         [0.400 color rgbf <1.000, 1.000, 1.000, 1.000>]

         [0.405 color rgb  <0.850, 0.850, 0.166>]

         [0.795 color rgb  <0.850, 0.850, 0.166>]

         [0.805 color rgbf <1.000, 1.000, 1.000, 1.000>]

      }

      rotate 45.000*z

    }

    finish { Marble_Finish }

  }

  texture {

    pigment {

      gradient y

      color_map {

        [0.000 color rgb  <1.000, 0.000, 0.000>]

        [0.150 color rgb  <1.000, 0.000, 0.000>]

        [1.000 color rgbf <1.000, 1.000, 1.000, 1.000>]

      }

      scale 3.000

      translate -1.366*y

    }

    finish { Marble_Finish }

  }

  scale 4.000

  bounded_by {

    box {

      < 16.000,  6.500,  16.000>

      <-16.000, -6.000, -16.000>

    }

  }

  rotate 30.000*y

  translate <196.000,  9.964, 75.000>

}









/* Tower */

#include "PowPlant.INC"

object { Tower rotate -45.000*y translate <145.000, 4.5001,  72.000> }

object { Tower rotate  90.000*y translate <156.000, 4.5002, 107.000> }

object { Tower rotate  30.000*y translate <158.000, 4.5003, 143.000> }

object { Tower translate <184.000, 4.5004, 106.000> }

object { Tower translate <230.000, 4.5005, 106.000> }







/* The Dome */

sphere {

  <-512.000, 0.000, 512.000>, 128.000

  texture {

    pigment {

      color rgbf <0.750, 1.000, 1.000, 0.500>

    }

    finish {

      specular 1.000

      roughness 0.001

      reflection 0.225

    }

  }

}



