// jcMaya5.pov Scene file  Joel R. Cheves 1996
// Persistence Of Vision raytracer version 3.0

#version 3.0
global_settings { assumed_gamma 2.2 }
#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "stones.inc"
#include "maya2.inc"
#include "greytop.inc"
#include "tan.inc"
#include "jag.inc"
#include "mayastr4.inc"
#include "base.inc"

camera {
   location <27, -6, -19.5>
   up <0,1,0>
   right <4/3, 0, 0>
   direction <0, 0, 1>
   look_at <15, -5, 0>
}

light_source { <250, 50, -100> color red 0.9 green 0.9 blue 0.9 atmosphere off }
light_source { <-20, 40, 200>
   color red 0.9 green 0.9 blue 0.9  atmosphere off }
light_source { <-40, 50, 165> color Orange*.25 atmosphere off}

atmosphere {
    color rgbf <1, .7, .30, 0.25>
    type 4
    samples 60
    distance 5000
    scattering .75
    aa_level 8
    aa_threshold 0.2
    jitter 0.05
}

light_source { <800, 1000, -100>
      White * .35
    spotlight
    cylinder
    radius  10
    falloff 20
    point_at <20, -15, 3>
}
// cap
light_source { <750, 1000, -100>
      White *.5
    spotlight
    cylinder
    radius  25
    falloff 35
    point_at <-35, 50, 170>
}

light_source {<-100, 90, 200>
    color White *.5  atmosphere off}
light_source {<-40, 49.5, 153>
    color Orange *.5 atmosphere off} 

light_source {  //from eye-globe
    <7, 4.1, -3>
    color Red *.55
    spotlight
    cylinder
    radius 3
    falloff 6
    point_at <27, -15, -14>
}
light_source {  //at eye
    <9, 3.3, -8>
    color Orange *.5
   spotlight
    point_at <7.5, 4.1, -4.15>
    radius 1
    falloff 60
    tightness 1
  atmosphere off
}

fog{
   color rgbf<.6,.35,.17, .05>
    fog_type 2
    fog_alt 2
    fog_offset 0
    distance 150
    turbulence <1.5,3,1.5>
    omega 0.40
    lambda 1.25
    octaves 5
}

union {
 object {
  pyramid
 }

 object {
   stair1 
   translate <0, 0, -.05>
 }
   scale 27.5
   translate <-40, -15, 170>
} //end union

 object {
  mayastr
  rotate <0, -90, 0>
   scale 50 //25
   translate <-165, -15, -14.4>
}

//difference {
object {
  Jag
 clipped_by {
  plane {y,0
  rotate <0.0, -48.0, 90.0>
  rotate <0, -90, 0>
  translate <0.28, 1.087, -2.4>
   }
 }
    translate <0, 0, -.3>
}

 object {
   vertex
   scale .75
   translate <24, -13, 5>
 }

  sphere { <0,0,0>, 1
   texture {
    pigment { color rgbf <0.9, 0.1, 0.2, 0.8> }
    finish {
        ambient 0.1
        diffuse 0.1
        reflection .25
        refraction 1
        ior 1.5
        specular 1
        roughness .001
    }
}
   translate <7, 4.1, -3>
 }

plane {y,-15 //ball yard
      texture { pigment { bozo color_map {
         [ 0.0 colour rgb <0.7,0.5,0.3> ]
         [ 0.2 colour rgb <0.6,0.6,0.6> ]
         [ 0.25 colour rgb <0.6,0.6,0.6> ]
         [ 0.25 colour rgb <0.2,0.2,0.2> ]
         [ 0.275 colour rgb <0.2,0.2,0.2> ]
         [ 0.275 colour rgb <0.6,0.4,0.2> ]
         [ 0.4 colour rgb <0.6,0.4,0.2> ]
         [ 0.6 colour rgb <0.95,0.75,0.55> ]
         [ 0.8 colour rgb <0.7,0.5,0.3> ] } scale 0.0001 }
       normal { 
          crackle 1.75
          turbulence 0.5
          scale <1,5,1> } //2,10,2
       scale <1,2,1> }
}



