// Kithrup model -- Fin_Arm
// Steve Sloan 27-Oct-96
// A dolphin work harness' arm, used with FinSled.INC
// This code may be used for any purpose, provided the source is acknowledged

#include "colors.inc"
#include "textures.inc"

#declare gripper = union {
    prism {
        linear_sweep
        linear_spline
        -.01, .01,
        6,
        <0, 0>, <.06, .04>, <.11, .04>, <.15, .02>, <.15, 0>, <0, 0>
        rotate -(gripper_open / 2)*y
    }

    prism {
        linear_sweep
        linear_spline
        -.01, .01,
        6,
        <0, 0>, <.06, -.04>, <.11, -.04>, <.15, -.02>, <.15, 0>, <0, 0>
        rotate (gripper_open / 2)*y
    }
    texture {Soft_Silver}
    rotate -90*y
}

#declare forearm = union {
    object {
        gripper
        translate .4*z
    }
    sphere {
        <0, 0, .4>, .04
        texture {New_Penny}
    }
    cylinder {
        <0, 0, 0>,     // Center of one end
        <0, 0, .4>,    // Center of other end
        0.02           // Radius
        texture {Soft_Silver}
    }

}

#declare fin_arm = union {
    object {
        forearm
        rotate elbow_h*y
        rotate -elbow_v*x
        translate .4*z
    }

    sphere {
        <0, 0, .4>, .04
        texture {New_Penny}
    }
    sphere {
        0, .06
        texture {New_Penny}
    }
    cylinder {
        <0, 0, 0>,     // Center of one end
        <0, 0, .4>,    // Center of other end
        0.03           // Radius
        texture {Soft_Silver}
    }
    rotate shoulder_h*y
    rotate shoulder_v*x
}
