//Lightsaber rendering by Michael Guslick (michaelg@alpha2.csd.uwm.edu)

//Warning - You might go insane if you try to read this source!
//It's not exactly the most readable...

#version 3.0
global_settings { assumed_gamma 2.2 }

#include "debug.inc"
#include "colors.inc"
#include "finish.inc"
#include "metals.inc"
#include "woods.inc"
#include "stones1.inc"
#include "stones2.inc"
// #include "golds.inc"
#include "textures.inc"
#include "glass.inc"

camera {
   location  <33, 7,-16>    
//   direction <0, 0,  1>
//   up        <0, 1,  0>
//   right   <4/3, 0,  0>
     look_at   <21, -4, 0>
}

 light_source {<10, 20, -30> color White}

 light_source {<40,30,-5> color White}

 sky_sphere { pigment { Gray25 } }

//superellipsoid {<0.5,0.1> translate <8,-1,-6>
//  pigment {Gray05}
//  finish {F_MetalC} }

#declare Grout = object {
// Grout used to be at y -2.8
plane { y,-2.45
//   texture {T_Stone41}
   finish {Dull}
//
     pigment {Gray85}
   normal { bumps 0.1 scale 3 } }
  }


#declare Tile = 
superellipsoid {<0.01,0.01> scale <34.8,1,34.8> translate <0,-3.35,0>
  pigment {Gray05}
  finish {F_MetalC}
  normal { bumps 0.1 scale 3 } }

#declare row = union {
  object {Tile translate <-201,0,0>}
  object {Tile translate <-140,0,0>}
  object {Tile translate <70,0,0>}
  object {Tile}
  object {Tile translate <-70,0,0>}
  object {Tile translate <-140,0,0>}
  object {Tile translate <-210,0,0>} }

#declare Tilez = union {
  object {row translate <0,0,-210>}
  object {row translate <0,0,-140>}
  object {row translate <0,0,-70>}
  object {row}
  object {row translate <0,0,70>}
  object {row translate <0,0,140>}
  object {row translate <0,0,210>} }

//#declare Floures = light_source {
//  <0,300,0>
//  color Gray25
//  looks_like {
//  cylinder {<-100,0,0>,<100,0,0>,4}
//  texture { pigment { color rgb <.25,.25,.25>} finish {ambient.8 diffuse.6}}
//  } }

#declare Floures = object {cylinder {<-100,300,0>,<100,300,0>,4 pigment {SkyBlue}}}

#declare FlouresRow = union {
  object {Floures translate <-400,0,0>}
  object {Floures translate <-200,0,0>}
  object {Floures}
  object {Floures translate <200,0,0>}
  }
//floor was <18,0,28>

#declare Floor = union {
object {Tilez translate <-35,0,35> rotate <0,30,0> translate <20,0,-8>}
object {Grout}
//object {FlouresRow translate <0,0,-400> rotate <0,30,0>}
//object {FlouresRow translate <0,0,-200> rotate <0,30,0>}
//object {FlouresRow rotate <0,30,0>}
//object {FlouresRow translate <0,0,200> rotate <0,30,0>}
//object {FlouresRow translate <0,0,400> rotate <0,30,0>}
//object {FlouresRow translate <0,0,600> rotate <0,30,0>}
//object {FlouresRow translate <0,0,800> rotate <0,30,0>}
}

#declare blade_container = union {
  cylinder {<0,16.8,0>,<0,28.7,0>,1.25}
  cone {<0,28.7,0>,1.25 <0,128.7,0>,.75}
  sphere {<0,128.7,0>,.75}
  }

#declare blade = object { blade_container
  pigment { color rgbt <1,1,1,1>}
  halo {
    emitting
    cylindrical_mapping
    linear
    color_map { [ 0 color rgbt <0,0,.75,0.75> ]
                [ 1 color rgbt <0,0,1,0> ]}
    samples 10}
  hollow
  rotate <0,0,-90>
}

#declare D_Ring = object {
torus {1.75,.25 translate <.25,0,0> texture {T_Brass_2E}}}

#declare Torx_Tool = intersection {
  plane {x, .1}
  plane {x, .1  rotate <0,120,0>}
  plane {x, .1  rotate <0,240,0>}
  plane {-y, .15}
  plane {y, 8}
  texture {T_Chrome_2A}
  }

#declare Torx_Tool2 = union {
  object {Torx_Tool}
  object {Torx_Tool rotate <0,180,0>}
  }

#declare Screw = difference {
  merge {
    cone {<0,.05,0>,.3 <0,.1,0>,.25}
    cylinder {<0,.05,0>,<0,0,0>,.3}
    cone {<0,0,0>,.3 <0,-.25,0>,.2} }
  object {Torx_Tool2}
  texture {T_Chrome_2A}
  }

#declare Copper_Stud = union {
  cylinder {<0,0,0>,<0,.3,0>,.3}
  cylinder {<.5,0,0>,<.5,.3,0>,.3}
  box {<0,0,-.3>,<.5,.3,.3>}
  translate <29.3,1.2,0>  
  texture {T_Copper_3A} }

#declare Stud_Ring = union {
  object {Copper_Stud}
  object {Copper_Stud rotate <60,0,0>}
  object {Copper_Stud rotate <120,0,0>}
  object {Copper_Stud rotate <180,0,0>}
  object {Copper_Stud rotate <240,0,0>}
  object {Copper_Stud rotate <300,0,0>} }

#declare Back_Rib_Blank = prism {
  linear_sweep
  linear_spline
  0,9.6,5,
  <0,.4>,<-.55,.3>,<-.55,-.3>,<0,-.4>,<0,.4>}

#declare Fwd_Rib_Blank = difference {
  prism {
    linear_sweep
    linear_spline
    0,7.3,5,
    <0,.4>,<-.45,.3>,<-.45,-.3>,<0,-.4>,<0,.4>}
  cylinder {<1.9,0,0>,<1.9,10,0>,2}
  }

#declare Fwd_Rib_Bottom = union {
  difference {
    intersection {
      object { Fwd_Rib_Blank rotate <180,0,90> translate <19.7,-1.9,0>}
      plane {-x,0 rotate <0,0,45> translate <19.7,-2,0>}
      plane {x,0 rotate <0,0,-45> translate <26.6,-2,0>} }
    union {
      cone {<20.3,-2.3501,0>,.3 <20.3,-2,1>,.2}
      cone {<20.9,-2.3501,0>,.3 <20.9,-2.1>,.2}
      cone {<26,-2.3501,0>,.3 <26,-2.1>,.2} }
    texture {Bright_Bronze}
    }
  object {Screw rotate <180,0,0> translate <20.3,-2.35,0>}
  object {Screw rotate <180,0,0> translate <20.9,-2.35,0>}
  object {Screw rotate <180,0,0> translate <26,-2.35,0>}
  }

#declare Fwd_Ribs = union {
  object {Fwd_Rib_Bottom}
  object {Fwd_Rib_Bottom rotate <120,0,0>}
  object {Fwd_Rib_Bottom rotate <240,0,0>}
  }

#declare Back_Rib_Angle = difference {
  object { Back_Rib_Blank }
  union {
    box {<-1.5,-1.5,-.5>,<0,0,.5> rotate <0,0,-30>}
    box {<-1.5,-1.5,-.5>,<0,2,.5> rotate <0,0,-30> translate <0,9.1,0>}
    cylinder {<1.9,0,0>,<1.9,10,0>,2}
  }}

#declare Back_Rib_Top = union {
  union {
    object {Screw translate <1.3,2.45,0>}
    object {Screw translate <5.5,2.45,0>}
    object {Screw translate <8.3,2.45,0>}
    }
  difference { 
    object {
      Back_Rib_Angle
      rotate <0,0,-90>
      translate <.5,1.9,0>} 
    union {
      cone {<1.3,2.4501,0>,.3 <1.3,2.2,0>,.2}
      cone {<5.5,2.4501,0>,.3 <5.5,2.2,0>,.2}
      cone {<8.3,2.4501,0>,.3 <8.3,2.2,0>,.2} }
    }
  }


#declare Back_Ribs = union {
  object {Back_Rib_Top}
  object {Back_Rib_Top rotate <60,0,0>}
  object {Back_Rib_Top rotate <120,0,0>}
  object {Back_Rib_Top rotate <180,0,0>}
  object {Back_Rib_Top rotate <240,0,0>}
  object {Back_Rib_Top rotate <300,0,0>}
  texture {Bright_Bronze}
}

#declare Center_Grip_Section = prism {
  linear_sweep
  linear_spline
  0,5,7,
  <0,.5>,<-.2,.3>,<-.2,-.3>,<0,-.5>,<2,-.5>,<2,.5>,<0,.5>
//  texture {Brushed_Aluminum}
  rotate <0,0,-90>
  translate <10.8,1.8,0>
}

#declare Center_Grip_No_Bevel = union {
  object { Center_Grip_Section }
  object { Center_Grip_Section rotate <30,0,0> }
  object { Center_Grip_Section rotate <60,0,0> }
  object { Center_Grip_Section rotate <90,0,0> }
  object { Center_Grip_Section rotate <120,0,0> }
  object { Center_Grip_Section rotate <150,0,0> }
  object { Center_Grip_Section rotate <180,0,0> }
  object { Center_Grip_Section rotate <210,0,0> }
  object { Center_Grip_Section rotate <240,0,0> }
  object { Center_Grip_Section rotate <270,0,0> }
  object { Center_Grip_Section rotate <300,0,0> }
  object { Center_Grip_Section rotate <330,0,0> }
}

#declare Center_Grip_Bevel_Tool = union {
  cone {<10.8,0,0>,1.8 <11.2,0,0>,2.2}
  cylinder {<11.2,0,0>,<15.4,0,0>,2.2}
  cone {<15.4,0,0>,2.2 <15.8,0,0>,1.8}
  }

#declare Center_Grip = intersection {
  object {Center_Grip_No_Bevel}
  object {Center_Grip_Bevel_Tool}
  texture {T_Wood22}
  }

#declare Slot_Tool = union {
  cylinder {<0,0,0>,<0,-3,0>,.2}
  box {<0,-3,-.2>,<3.7,0,.2>}
  cylinder {<3.7,0,0>,<3.7,-3,0>,.2}}

#declare Cavity_Tool = union {
  object { Slot_Tool }
  object { Slot_Tool rotate <120,0,0> }
  object { Slot_Tool rotate <240,0,0> }
  cylinder {<-.7,0,0>,<6,0,0>,1.5}
  translate <17.2,0,0>}

#declare End_Cap_Tool =  union {
  difference {
    intersection {
      cylinder {<-.0001,0,0>,<.5,0,0>,2.0001}
      plane {-y,.25} }
    cylinder {<0,0,0>,<.5,0,0>,1.5} }
  cylinder {<.25,0,3>,<.25,0,-3>,.25} }

#declare Filler_Plates = intersection {
  difference {
    cylinder {<17.2,0,0>,<20.9,0,0>,2.2}
    cylinder {<17.1,0,0>,<21,0,0>,2} }
  plane {y,0}
  plane {z,0 rotate <30,0,0>} 
  texture {Aluminum}
  }

#declare Main_Saber_Body = difference {
  union {
    object {D_Ring}
    object {Back_Ribs}
    difference { 
      cylinder {<0,0,0>,<2,0,0>,2}
      object {End_Cap_Tool} }
    cylinder {<2,0,0>,<5,0,0>,1.75 texture {T_Chrome_3A}}
    cylinder {<5,0,0>,<6,0,0>,2}
    cylinder {<6,0,0>,<8,0,0>,1.75 texture {T_Chrome_3A}}
    cylinder {<8,0,0>,<10.1,0,0>,2}
    cone {<10.1,0,0>,2 <10.3,0,0>,1.8 }
    cone {<10.3,0,0>,1.8 <10.5,0,0>,2 texture {T_Chrome_4C}}
    cylinder {<10.5,0,0>,<10.6,0,0>,2 pigment {Black}}
    cone {<10.6,0,0>,2 <10.8,0,0>,1.8 texture {T_Chrome_4C}}
    Center_Grip
    cone {<15.8,0,0>,1.8 <16,0,0>,2 texture {T_Chrome_4C}}
    cylinder {<16,0,0>,<16.1,0,0>,2 pigment {Black}}
    cone {<16.1,0,0>,2 <16.3,0,0>,1.8 texture {T_Chrome_4C}}
    cone {<16.3,0,0>,1.8 <16.5,0,0>,2}
    cylinder {<16.5,0,0>,<22,0,0>,2 texture {
      T_Silver_5B normal {bumps 0.1 scale 0.05}}}
    cone {<22,0,0>,2 <22.3,0,0>,1.7}
    object {Filler_Plates}
    object {Filler_Plates rotate <-120,0,0>}
    object {Stud_Ring translate <-7.8,0,0>}
    texture {T_Silver_2E} }
  object { Cavity_Tool } }

#declare Button = intersection {
  box {<17,1.7,-.8>,<19,3.05,.8>}
  plane {y,0 rotate <0,0,20> translate <19,3.05,0>}
  pigment {Gray20}
  finish {Dull}
  }

#declare Button_Housing_Block = difference {
  difference {
    intersection {
      box {<17,0,-.95>,<21,3.05,.95>}
      plane {y,0 rotate <0,0,20> translate <19,3.05,0>} 
      plane {y,0 rotate <0,0,-45> translate <20.8,3.05,0>}
      plane {y,0 rotate <45,0,0> translate <0,3.05,.75>}
      plane {y,0 rotate <-45,0,0> translate <0,3.05,-.75>} }
    cylinder {<16.9999,0,0>,<21.0001,0,0>,2}}
  box {<16.9999,0,-.8>,<19,3.0501,.8>}
  }

#declare Jack_Block = union {
  box {<20,2.15,-.6>,<21.0001,2.65,.6>}
  intersection {
    plane {x,21.0001}
    plane {y,0 rotate <0,0,45> translate <21,2.75,0>}
    plane {-y,0 rotate <0,0,-45> translate <21,2.05,0>}
    plane {-z,0 rotate <0,45,0> translate <21,0,-.7>}
    plane {z,0 rotate <0,-45,0> translate <21,0,.7>}
    }
  }

#declare Charge_Pins = union {
  cylinder {<20,2.4,-.4>,<20.8,2.4,-.4>,.05}
  cylinder {<20,2.4,-.2>,<20.8,2.4,-.2>,.05}
  cylinder {<20,2.4,.2>,<20.8,2.4,.2>,.05}
  cylinder {<20,2.4,.4>,<20.8,2.4,.4>,.05}
  texture {T_Gold_5A} }

#declare Button_Housing_Jack = union {
  difference {
    object { Button_Housing_Block }
    union {
      object { Jack_Block }
      box {<19.2,2.95,.05>,<19.6,3.15,.65>}
      box {<20.1,2.95,.05>,<20.5,3.15,.65>} }
    pigment {DarkSlateGray} }
  object {Charge_Pins}
  object {Button}
  box {<19.2,2.95,.35>,<19.6,3.15,.65> pigment {Gray10}}
  box {<20.1,2.95,.35>,<20.5,3.15,.65> pigment {Gray10}}
}
  
#declare Cone_Notcher = union {
  cylinder {<29.2,2,0>,<30.5,2,0>,.25}
  cylinder {<29.2,2,0>,<30.5,2,0>,.25 rotate <-30,0,0>}
  cylinder {<29.2,2,0>,<30.5,2,0>,.25 rotate <-60,0,0>}
  cylinder {<29.2,2,0>,<30.5,2,0>,.25 rotate <-90,0,0>}
  cylinder {<29.2,2,0>,<30.5,2,0>,.25 rotate <-120,0,0>}
  cylinder {<29.2,2,0>,<30.5,2,0>,.25 rotate <-150,0,0>}
  cylinder {<29.2,2,0>,<30.5,2,0>,.25 rotate <-180,0,0>}
  cylinder {<29.2,2,0>,<30.5,2,0>,.25 rotate <-210,0,0>}
  cylinder {<29.2,2,0>,<30.5,2,0>,.25 rotate <-240,0,0>}
  cylinder {<29.2,2,0>,<30.5,2,0>,.25 rotate <-270,0,0>}
  cylinder {<29.2,2,0>,<30.5,2,0>,.25 rotate <-300,0,0>}
  cylinder {<29.2,2,0>,<30.5,2,0>,.25 rotate <-330,0,0>}
  }

#declare Cyl_Notcher = union {
  box {<27.6,1.9,-.1>,<28.3,2,.1>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <10,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <20,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <30,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <40,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <50,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <60,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <70,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <80,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <90,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <100,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <110,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <120,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <130,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <140,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <150,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <160,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <170,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <180,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <190,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <200,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <210,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <220,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <230,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <240,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <250,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <260,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <270,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <280,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <290,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <300,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <310,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <320,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <330,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <340,0,0>}
  box {<27.6,1.9,-.1>,<28.3,2,.1> rotate <350,0,0>}
  }

#declare Cyl_Perf = union {
  sphere {<27.2,2.2,0>,.1}
  sphere {<27.2,2.2,0>,.1 rotate <10,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <20,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <30,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <40,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <50,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <60,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <70,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <80,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <90,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <100,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <110,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <120,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <130,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <140,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <150,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <160,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <170,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <180,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <190,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <200,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <210,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <220,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <230,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <240,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <250,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <260,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <270,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <280,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <290,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <300,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <310,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <320,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <330,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <340,0,0>}
  sphere {<27.2,2.2,0>,.1 rotate <350,0,0>}
  texture {T_Copper_3C}
  }

#declare Focus_Head_No_Hole = union {
  cylinder {<25.1,0,0>,<26.8,0,0>,2}
  cone {<26.8,0,0>,2 <27,0,0>,2.2 texture {T_Copper_3C}}
  difference {
    cylinder {<27,0,0>,<27.4,0,0>,2.2 texture {T_Copper_3C}}
    object {Cyl_Perf} }
  cone {<27.4,0,0>,2.2 <27.6,0,0>,2 texture {T_Copper_3C}}
  difference {
    cylinder {<27.6,0,0>,<28.3,0,0>,2}
    object {Cyl_Notcher} }
  cone {<28.3,0,0>,2 <28.5,0,0>,2.2 texture {T_Copper_3C}}
  difference {
    cylinder {<28.5,0,0>,<28.9,0,0>,2.2 texture {T_Copper_3C}}
    object {Cyl_Perf translate <1.5,0,0>} }
  cone {<28.9,0,0>,2.2 <29.1,0,0>,2 texture {T_Copper_3C}}
  difference {
    cone {<29.1,0,0>,2 <30.1,0,0>,1.7}
    object {Cone_Notcher} }
  texture {T_Chrome_3C normal {bumps 0.1 scale 0.05}}
  }

#declare Focus_Head_Tool = union {
  cone {<25.0999,0,0>,2 <25.6,0,0>,1.5}
  cylinder {<25.6,0,0>,<30.1001,0,0>,1.5}
  }

#declare Focus_Head_No_Studs = union {
  difference {
    object {Focus_Head_No_Hole}
    object {Focus_Head_Tool} }
  object {Fwd_Ribs} }

#declare Lens = intersection {
  sphere {<0,0,0>,4}
  sphere {<7,0,0>,4}
  cylinder {<0,0,0>,<7,0,0>,1.5}
  texture {T_Orange_Glass}
  translate <-3.5,0,0> }

#declare Green_Led = intersection {
  plane {x,.2}
  plane {x,.2 rotate <0,120,0>}
  plane {x,.2 rotate <0,240,0>}
  plane {-y,0}
  plane {y,.1} 
  pigment { color rgbt <1,1,1,1> }
  halo {
    emitting
    planar_mapping
    linear
    color_map {
      [ 0 color rgbt <0,1,0,0> ]
      [ 1 color rgbt <0,1,0,0> ] }
    samples 10 }
  hollow
  }


#declare Yellow_Led = intersection {
  plane {x,.05}
  plane {-x,.05}
  plane {z,.25}
  plane {-z,.25}
  plane {-y,0}
  plane {y,.1} 
  pigment { color rgbt <1,1,1,1> }
  halo {
    emitting
    planar_mapping
    linear
    color_map {
      [ 0 color rgbt <1,1,0,0> ]
      [ 1 color rgbt <1,1,0,0> ] }
    samples 10 }
  hollow
  }

#declare Red_Led = intersection {
  plane {x,.1}
  plane {-x,.1}
  plane {z,.25}
  plane {-z,.25}
  plane {-y,0}
  plane {y,.1} 
  pigment { color rgbt <1,1,1,1> }
  halo {
    emitting
    planar_mapping
    linear
    color_map {
      [ 0 color rgbt <1,.25,.25,0> ]
      [ 1 color rgbt <1,.25,.25,0> ] }
    samples 10 }
  hollow
  }

declare Led_Module = union {
  object {Green_Led translate <19.35,2.95,-.4>}
  object {Green_Led rotate <0,180,0> translate <20.35,2.95,-.4>}
  object {Yellow_Led translate <19.65,2.95,-.4>}
  object {Yellow_Led translate <20.05,2.95,-.4>}
  object {Red_Led translate <19.85,2.95,-.4>}
  }

#declare Button_Mod = union {
  difference {
    object { Button_Housing_Jack }
    object { Led_Module translate <0,.0001,0>} }
  object { Led_Module } }

#declare Saber_Body = union {
  object { Lens translate <20.9,0,0> }
  object { Main_Saber_Body }
  object {blade}
  object {Button_Mod}
  }


#declare Focus_Head = union {
  object {Focus_Head_No_Studs}
  object {Stud_Ring}
  object { Lens translate <28.7,0,0> }
  object { Lens translate <27.2,0,0> } }



//Final object declarations
 
Floor

#declare Light_Saber = union {
  object {Saber_Body}
  object {Focus_Head} }


object {Light_Saber rotate <-30,0,-.2>}

