//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 3 lights, 11 textures and 92 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE V2.02.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 10/01/1996    (01.10.1996)
//

#max_trace_level 5

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//





camera {  //  Camera StdCam
  location  <14.200, -154.600, 7.800>
  direction <0.0,     0.0,  1.0943>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0.600, -148.000, 1.500>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <0.000, -0.100, 0.000>
  direction <0.0,     0.0,  0.3248>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0.000, 0.000, 0.000>
}

*/

/*
camera {  //  Camera SpotCam002
  location  <0.000, -0.100, 0.000>
  direction <0.0,     0.0,  0.3248>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0.000, 0.000, 0.000>
}

*/

/*
camera {  //  Camera SpotCam003
  location  <0.000, -0.100, 0.000>
  direction <0.0,     0.0,  0.6176>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0.000, 0.000, 0.000>
}

*/

// *******  L I G H T S *******
light_source { // AreaL001
  <0.100, -154.200, 25.300>
  color  rgb<0.455, 0.447, 0.455>
  area_light <498.297, 0.000, 43.595>, <0.000, 500.200, 0.000>, 3, 3
  adaptive 1
  jitter
}


light_source {   // Light003
  <-4.300, -147.600, 1.900>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Light1
  <2.700, -154.300, 21.500>
  color rgb <1.000, 1.000, 1.000>
}


// ********  TEXTURES  *******
//

#include "lunar.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******



#declare CSG001 = difference {
  box { // Cockpit
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cockpit_Shine
    }
    scale <1.5, 1.5, 1.1>
    translate  <2.9, 2.5, 2.9>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cockpit_Shine
    }
    scale <0.1, 1.4, 1.1>
    translate  <4.4, 2.5, 2.8>
  }
}
#declare Radar_Dish = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.971214, -2.000000, 0.993486>, <-0.991454, -2.000000, 1.009772>, <0.000538, -1.999172, 0.993486>, <0.988121, -2.000000, 0.993486>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.016287>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <-2.000000, 1.000000, 1.026059>, <-1.000000, 1.000000, 1.009772>, <0.000000, 1.000000, 0.993486>, <1.000000, 1.000000, 0.993486>
    }
  }
  texture {
    Gold_Metal1
  }
  scale <0.4, 1.0, 1.4>
  rotate <-180.0, -90.0, 0.0>
  translate  <-4.7, 3.0, 7.4>
}
#declare Left_Light = difference {
  sphere { // Left_Light
    <0,0,0>,1
    texture {
      Protection_Bar
    }
    scale 0.5
    translate  <6.8, 7.2, 0.8>
  }
  cone { // Left_Light_Cut
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Protection_Bar
    }
    rotate <180.0, 50.0, -180.0>
    translate  <6.6, 7.2, 0.9>
  }
}
#declare Right_Light = difference {
  sphere { // Rigth_Light
    <0,0,0>,1
    texture {
      Protection_Bar
    }
    scale 0.5
    translate  <6.8, -2.2, 0.8>
  }
  cone { // Right_Light_Con
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Protection_Bar
    }
    rotate <180.0, 50.0, -180.0>
    translate  <6.6, -2.2, 0.9>
  }
}
#declare Scoop = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.820284, -1.205322, 1.144420>, <-1.796250, -1.205322, 0.057221>, <-0.678207, -1.485796, 0.457768>, <1.087861, -1.462424, 0.371937>, 
      <-2.016728, -1.000000, 1.158726>, <-2.019503, -0.976627, 0.000000>, <-1.573578, -1.000000, -0.972757>, <1.000000, -1.000000, 0.000000>, 
      <-2.003437, 0.046746, 1.115810>, <-2.023333, 0.046746, -0.014305>, <-1.573578, 0.000000, -1.001368>, <1.000000, 0.000000, 0.000000>, 
      <-1.759233, 0.345559, 1.187336>, <-1.741287, 0.298813, 1.187336>, <-0.617941, 0.485796, 0.443463>, <1.107404, 0.485796, 0.371937>
    }
  }
  texture {
    Protection_Bar
  }
  scale 0.4
  rotate -5.0*z
  translate  <11.3, -0.2, 0.8>
}
union { // Rover
  object { CSG001 }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    texture {
      Solar_Panel
    }
    scale <0.2, 0.2, 4.0>
    rotate -90.0*x
    translate  <-4.7, 7.0, 2.7>
  }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    texture {
      Solar_Panel
    }
    scale <0.2, 0.2, 4.0>
    rotate -90.0*x
    translate  <-4.7, -6.0, 2.7>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Solar_Panel
    }
    scale <2.5, 2.0, 0.00001>
    translate  <-7.2, -4.0, 2.9>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Solar_Panel
    }
    scale <2.5, 2.0, 0.00001>
    translate  <-2.2, -4.0, 2.5>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Solar_Panel
    }
    scale <2.5, 2.0, 0.0001>
    translate  <-7.2, 9.0, 2.9>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Solar_Panel
    }
    scale <2.5, 2.0, 0.00001>
    translate  <-2.2, 9.0, 2.5>
  }
  cylinder { // Solar_Cylin2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.2, 0.2, 3.0>
    rotate -90.0*x
    translate  <-4.7, -2.0, 2.7>
  }
  cylinder { // Solar_Cylin
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.2, 0.2, 3.0>
    rotate -90.0*x
    translate  <-4.7, 4.0, 2.7>
  }
  torus { // Handle
    1.5, 0.25  rotate -x*90
    texture {
      Protection_Bar
    }
    scale 0.2
    rotate -90.0*y
    translate  <-3.8, 2.2, 3.8>
  }
  box { // Storage
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Silver4
    }
    scale <1.2, 0.1, 1.0>
    rotate <-90.0, 0.0, 0.0>
    translate  <-4.7, 2.2, 3.8>
  }
  sphere { // Headlight_Main
    <0,0,0>,1
    texture {
      Headlight_Blue
    }
    no_shadow
    scale <0.3, 0.5, 0.7>
    translate  <6.3, 3.3, 0.8>
  }
  cylinder { // Hook_Arm2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 3.0>
    rotate <-175.65387, 80.874626, 179.356979>
    translate  <8.4, 4.1, 2.3>
  }
  sphere { // Hand
    <0,0,0>,1
    texture {
      Protection_Bar
    }
    scale 0.2
    translate  <11.4, 3.8, 1.8>
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.05, 0.05, 0.5>
    rotate <-180.0, 55.0, 180.0>
    translate  <11.4, 3.8, 1.7>
  }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.05, 0.05, 0.5>
    rotate <-1.357391, 54.764347, -39.685307>
    translate  <11.4, 3.7, 1.9>
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.05, 0.05, 0.5>
    rotate <-16.653767, 76.961708, 13.198341>
    translate  <11.4, 3.9, 1.9>
  }
  sphere { // Sphere003
    <0,0,0>,1
    texture {
      Protection_Bar
    }
    scale 0.1
    translate  <11.8, 3.8, 1.4>
  }
  sphere { // Sphere004
    <0,0,0>,1
    texture {
      Protection_Bar
    }
    scale 0.1
    translate  <11.8, 4.1, 2.0>
  }
  sphere { // Sphere005
    <0,0,0>,1
    texture {
      Protection_Bar
    }
    scale 0.1
    translate  <11.7, 3.4, 2.2>
  }
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.05, 0.05, 0.5>
    rotate <13.497317, 65.081879, -1.6397>
    translate  <11.8, 3.8, 1.4>
  }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.05, 0.05, 0.5>
    rotate <-148.35582, 75.251778, 176.5401>
    translate  <11.8, 4.1, 2.0>
  }
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.05, 0.05, 0.5>
    rotate <162.159454, 35.43642, -176.597565>
    translate  <11.7, 3.4, 2.2>
  }
  sphere { // Radar_Light
    <0,0,0>,1
    texture {
      Top_Light_Red
    }
    scale 0.1
    translate  <-4.5, 3.5, 7.8>
  }
  torus { // Torus001
    1.5, 0.5  rotate -x*90
    texture {
      Tire_Black
    }
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
    translate  <4.3, -0.5, 0.0>
  }
  torus { // Torus002
    1.5, 0.5  rotate -x*90
    texture {
      Tire_Black
    }
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
    translate  <4.3, 5.5, 0.0>
  }
  torus { // Torus003
    1.5, 0.5  rotate -x*90
    texture {
      Tire_Black
    }
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
    translate  <-4.4, 5.5, 0.0>
  }
  torus { // Torus004
    1.5, 0.5  rotate -x*90
    texture {
      Tire_Black
    }
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
    translate  <-4.4, -0.5, 0.0>
  }
  disc { // Disc001
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Silver4
    }
    scale <1.5, 1.5, 1.0>
    rotate -90.0*x
    translate  <-4.4, 6.5, 0.0>
  }
  disc { // Disc002
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Silver4
    }
    scale <1.5, 1.5, 1.0>
    rotate -90.0*x
    translate  <4.3, 6.5, 0.0>
  }
  disc { // Disc003
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Silver4
    }
    scale <1.5, 1.5, 1.0>
    rotate -90.0*x
    translate  <-4.4, -1.5, 0.0>
  }
  disc { // Disc004
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Silver4
    }
    scale <1.5, 1.5, 1.0>
    rotate -90.0*x
    translate  <4.3, -1.5, 0.0>
  }
  box { // Chassis
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Gold_Metal1
    }
    scale <6.4, 1.8, 1.0>
    translate  <-0.1, 2.5, 0.8>
  }
  cylinder { // Radar
    <0,0,1>, <0,0,0>, 1 
    texture {
      Gold_Metal1
    }
    scale <0.1, 0.1, 5.0>
    translate  <-4.5, 3.5, 2.8>
  }
  object { Radar_Dish }
  box { // Rear_Storage
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Gold_Metal1
    }
    scale <1.6, 1.6, 1.0>
    translate  <-4.7, 2.5, 2.8>
  }
  sphere { // Atmosphere
    <0,0,0>,1
    texture {
      Atmosphere_Color
    }
    no_shadow
    scale 1.7
    translate  <-1.1, 2.5, 1.8>
  }
  torus { // Torus005
    1.5, 0.5  rotate -x*90
    texture {
      Silver4
    }
    scale 0.1
    translate  <-4.5, 3.5, 5.4>
  }
  torus { // Torus006
    1.5, 0.5  rotate -x*90
    texture {
      Silver4
    }
    scale 0.1
    translate  <-4.5, 3.5, 5.0>
  }
  torus { // Torus007
    1.5, 0.5  rotate -x*90
    texture {
      Silver4
    }
    scale 0.1
    translate  <-4.5, 3.5, 5.2>
  }
  box { // Cockpit_front
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cockpit_Shine
    }
    scale <1.3, 1.5, 0.1>
    rotate 50.0*y
    translate  <5.2, 2.5, 2.8>
  }
  box { // Side_door
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cockpit_Shine
    }
    scale <1.5, 0.1, 1.1>
    rotate <0.0, 50.0, 0.0>
    translate  <4.3, 1.1, 2.1>
  }
  box { // Side_door2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cockpit_Shine
    }
    scale <1.5, 0.1, 1.1>
    rotate <0.0, 50.0, 0.0>
    translate  <4.3, 3.9, 2.1>
  }
  cylinder { // Cockpit_Guard
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 3.0>
    rotate -90.0*x
    translate  <6.1, 1.0, 1.8>
  }
  cylinder { // Cockpit_Guard2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 3.0>
    rotate <-90.0, 0.0, 0.0>
    translate  <4.4, 1.0, 3.9>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 2.2>
    translate  <1.4, 4.0, 1.8>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 2.2>
    translate  <4.4, 4.0, 1.8>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 2.2>
    translate  <4.4, 1.0, 1.8>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 2.2>
    translate  <1.4, 1.0, 1.8>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 3.0>
    rotate -90.0*x
    translate  <4.4, 1.0, 4.0>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 3.0>
    rotate -90.0*x
    translate  <1.4, 1.0, 4.0>
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 3.0>
    rotate -90.0*y
    translate  <4.4, 1.0, 4.0>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 3.0>
    rotate -90.0*y
    translate  <4.4, 4.0, 4.0>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 2.8>
    rotate <0.0, -37.0, 0.0>
    translate  <6.1, 1.0, 1.7>
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 2.8>
    rotate <0.0, -37.0, 0.0>
    translate  <6.1, 4.0, 1.7>
  }
  cylinder { // Side_Light
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 3.0>
    rotate -90.0*x
    translate  <1.4, -2.3, 0.8>
  }
  cylinder { // Side_Light2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 3.0>
    rotate -90.0*x
    translate  <1.4, 4.3, 0.8>
  }
  cylinder { // Side_Light3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 5.0>
    rotate -90.0*y
    translate  <6.4, -2.2, 0.8>
  }
  cylinder { // Side_Light4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 5.0>
    rotate -90.0*y
    translate  <6.4, 7.2, 0.8>
  }
  sphere { // Sphere001
    <0,0,0>,1
    texture {
      Protection_Bar
    }
    scale 0.2
    translate  <1.4, 7.2, 0.8>
  }
  sphere { // Sphere002
    <0,0,0>,1
    texture {
      Protection_Bar
    }
    scale 0.2
    translate  <1.4, -2.2, 0.8>
  }
  object { Left_Light }
  object { Right_Light }
  sphere { // Light_Shine1
    <0,0,0>,1
    texture {
      Headlight_Blue
    }
    no_shadow
    scale 0.4
    translate  <6.8, 7.2, 0.8>
  }
  sphere { // Light_Shine2
    <0,0,0>,1
    texture {
      Headlight_Blue
    }
    no_shadow
    scale 0.4
    translate  <6.8, -2.2, 0.8>
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 2.0>
    translate  <-3.1, 0.9, 1.8>
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 3.2>
    rotate -90.0*x
    translate  <-3.1, 0.9, 3.8>
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 3.2>
    rotate -90.0*x
    translate  <-6.3, 0.9, 3.8>
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 2.0>
    translate  <-6.3, 0.9, 1.8>
  }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 3.2>
    rotate -90.0*y
    translate  <-3.1, 0.9, 3.8>
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 3.2>
    rotate -90.0*y
    translate  <-3.1, 4.1, 3.8>
  }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 2.0>
    translate  <-3.1, 4.1, 1.8>
  }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 2.0>
    translate  <-6.3, 4.1, 1.8>
  }
  sphere { // Front_Swivel
    <0,0,0>,1
    texture {
      Protection_Bar
    }
    scale 0.4
    translate  <6.3, 1.8, 0.8>
  }
  cylinder { // Scoop_Arm1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 3.0>
    rotate <31.528507, 41.974239, -3.91304>
    translate  <6.5, 1.6, 0.9>
  }
  cylinder { // Scoop_Arm2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 3.0>
    rotate <-175.387802, 56.74765, 179.659607>
    translate  <8.1, -0.1, 2.8>
  }
  sphere { // Scoop_Swivel2
    <0,0,0>,1
    texture {
      Protection_Bar
    }
    scale 0.2
    translate  <8.1, -0.1, 2.8>
  }
  object { Scoop }
  cylinder { // Laser_Arm1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 4.0>
    rotate <0.0, 65.0, 0.0>
    translate  <6.3, 1.8, 0.6>
  }
  cylinder { // Hook_Arm1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 3.0>
    rotate <179.647385, -64.339661, -132.111404>
    translate  <8.3, 4.0, 2.2>
  }
  sphere { // Laser_Hinge
    <0,0,0>,1
    texture {
      Protection_Bar
    }
    scale 0.3
    translate  <10.1, 1.8, 2.4>
  }
  cylinder { // Laser
    <0,0,1>, <0,0,0>, 1 
    texture {
      Protection_Bar
    }
    scale <0.1, 0.1, 1.0>
    rotate <13.0, -25.0, 3.0>
    translate  <10.5, 2.1, 1.5>
  }
  cylinder { // Laser_Beam
    <0,0,1>, <0,0,0>, 1 
    texture {
      Atmosphere_Color
    }
    scale <0.05, 0.05, 20.0>
    rotate <13.0, -25.0, 3.0>
    translate  <18.0, 6.73, -15.1>
  }
  sphere { // Hook_Joint
    <0,0,0>,1
    texture {
      Protection_Bar
    }
    scale 0.2
    translate  <8.4, 4.1, 2.3>
  }
  translate  <-3.2, -150.100002, 0.0>
}


object {   // Landscape
  height_field {
    tga "C:\POVRAY2\SCENES\SCAPE.TGA"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    Rust1
  }
  scale <244.0, 218.900009, 9.3>
  translate  <-0.3, 0.0, -2.6>
}


plane { // Sky
  z,0
  texture {
    Blood_Sky1
  }
  rotate -5.0*y
  translate  <0.1, 2.4, 26.3>
}


