// Persistence Of Vision raytracer version 3.0 sample file.
// Render this file to create CRAT_DAT.TGA and then render CRATER.POV
// Use special 16-bit gray output

#version 3.0
global_settings { assumed_gamma 2.2 hf_gray_16 }

camera {
   location <0,2,-10>
   look_at <0,1,2>
}

#include "colors.inc"

// a wrinkle colored plane

plane {z,10 
 pigment{wrinkles
  color_map{
   [0 White*0.3]
   [1 White]
  }
 }
}

// Main spotlight creates crater mountain
light_source {0 color 1  spotlight point_at z*10
  radius 7 falloff 11
}

// Dim spotlight softens outer edges further
light_source {0 color .25  spotlight point_at z*10
  radius 2 falloff 15
}

// Narrow spotlight creates central peak
light_source {0 color .1  spotlight point_at z*10
  radius 0 falloff 1.3
}

// Negative spotlight cuts out crater insides
light_source {0 color -0.9  spotlight point_at z*10
  radius 5 falloff 9.5
}

// Dim negative spotlight counteracts dim positive light in center
light_source {0 color -.25  spotlight point_at z*10
  radius 3 falloff 8
}




// Main spotlight creates crater mountain
light_source {<4,1,0> color 1  spotlight point_at <4,1,10>
  radius 4 falloff 11
}

// Dim spotlight softens outer edges further
light_source {<4,1,0> color .25  spotlight point_at <4,1,10>
  radius 1 falloff 15
}

// Negative spotlight cuts out crater insides
light_source {<4,1,0> color -0.9  spotlight point_at <4,1,10>
  radius 3 falloff 9.5
}


// Main spotlight creates crater mountain
light_source {<3,-8,3> color 1  spotlight point_at <3,-8,10>
  radius 4 falloff 6
}

// Dim spotlight softens outer edges further
light_source {<3,-8,3> color .25  spotlight point_at <3,-8,10>
  radius 1 falloff 12 
}

// Negative spotlight cuts out crater insides
light_source {<3,-8,3> color -0.9  spotlight point_at <3,-8,10>
  radius 3 falloff 5.2
}


// Main spotlight creates crater mountain
light_source {<-10,8,-13> color 1  spotlight point_at <-10,8,10>
  radius 10 falloff 26
}

// Dim spotlight softens outer edges further
light_source {<-10,8,-13> color .25  spotlight point_at <-10,8,10>
  radius 11 falloff 15
}

// Negative spotlight cuts out crater insides
light_source {<-10,8,-13> color -0.9  spotlight point_at <-10,8,10>
  radius 6 falloff 5.2
}


