#declare rivit = cylinder { <0,0,0> <0,.12,0> .04 
   translate <0.8,0,0>
}

#declare RIV_ROT = 45

#declare stand = union {
   cylinder { <0,0,0> <0,1,0> .3 }
   cone { <0,0,0> 1 <0,.2,0> .2 }
   object { rivit }
   object { rivit rotate y*RIV_ROT }
   object { rivit rotate y*2*RIV_ROT }
   object { rivit rotate y*3*RIV_ROT }
   object { rivit rotate y*4*RIV_ROT }
   object { rivit rotate y*5*RIV_ROT }
   object { rivit rotate y*6*RIV_ROT }
   object { rivit rotate y*7*RIV_ROT }
   scale 2
   translate <0,-4.5,0>
   finish { Shiny }
   pigment { Blue }
}

#declare button = sphere { <.1,1,0> .1
   pigment { Green }
}

#declare console = union {
   cylinder { <1,1,.5> <1,1.2,.5> .2
      finish { Shiny }
      pigment { Red }
   }
   object { button }
   object { button translate <0,0,-.25> }
   object { button translate <0,0,.25> }
   object { button translate <0,0,.5> }
   box { <-1.4,-1,-0.5> <1.4,1,1>
      finish { Shiny }
      pigment { Blue }
   }
   polygon { 4 
      <-1.3,1.1,-.4> <0,1.1,-.4> <0,1.1,.8> <-1.3,1.1,.8>
      texture {
         finish { ambient 1 diffuse 0 }
         pigment { image_map { gif "guncam.gif" } }
         rotate x*90
         translate <-.07,0,-.35>
         scale 1.2
      }
   }
}

#declare crosshair = union {
   cylinder { <0,2,0> <0,4.3,0> .04 }
   cylinder { <-.42,3.8,0> <.42,3.8,0> .04 }
   torus { .4 .04
      rotate <90,0,0>
      translate <0,3.8,0>
   }
   translate <0,-.4,0>
   pigment { Blue }
   finish { Shiny }
} 

#declare gunwheel = union {
   cylinder { <0,0,-.7> <.5,0,-.7> .1 }
   sphere { <.5,0,-.7> .2 }
   torus { .7 .2
      rotate <90,90,0>
   }
   translate <1.5,-1,-4>
   finish { Shiny }
   pigment { Blue }
}

// #declare cannon  =
union {
   union {
      difference {
         blob {
            sphere { <0,0,0> 4 4 }
            cylinder { <0,0,3.5> <0,0,20> 3 3 }
            cylinder { <0,0,4> <0,0,40> 2 2 }
            cylinder { <0,0,3> <0,0,60> 1.5 1.5 }
            sphere { <0,0,60> 2 2 }
            finish { Shiny }
            pigment { Blue }
         }
         box { <-3,-3,60> <3,3,63> }
      }
      sphere { <0,0,0> 2.95
         pigment {
            image_map {
               gif "acme.gif"
               once
            }
            rotate y*-50
            scale 2
         }
      }
      difference {
         object { console 
            rotate <-30,0,0>
         }
         box { <-2,-3,-1> <2,0,2> 
         }
         translate <0,-1,-4>
      }
      object { crosshair }
      object { gunwheel }
       rotate <-11,0,0>
   }
   object { stand }
   finish { Shiny }
   pigment { Blue }
   rotate <0,2,0>
//   scale .9
   translate <-7.5,-.5,19>
}
