#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "metals.inc"
#include "ship.inc"
#include "gun.inc"
#include "sky.inc"
#include "sign.inc"
#include "mars.inc"

light_source {
   <2,8,-10>
   color White  // Light Color
}

background {
   color red .01 green .01 blue .053
}

camera {
    location <0,0,-16>
//    location <0,40,0>
   direction <0, 0, 2>          // Which way we are looking <X Y Z>
   up <0, 1, 0>                 // Which direction is   +up <X Y X>
   right <4/3, 0, 0>            // Which way is      +right <X Y Z>
   look_at <0, 0, 10>  // Point camera at this point(center of view)
}

#declare visor = difference {

   sphere { <0,0,0> 1.1}
   union {
      box { <-2,0,-2> <2,-2,2> }
      box { <-2,0,-2> <2,2,2>
         rotate <30,0,0>
      }
      sphere { <0,0,0> 1}
   }
   pigment { DarkOliveGreen }
   finish { Shiny }
   rotate <15,0,0>
}

#declare hair = difference {
   torus { 1, .1 
      rotate <90,90,0> 
      translate <0,0,1>
   }
   union { 
      box {<-4,-4,-4> <4,0,4> }
      box {<-4,-4,1> <4,4,4> }
   }
}

#declare row = union {
   object { hair translate <0,1.24,0> }
   object { hair translate <-.2,1.24,0> 
      rotate <0,-20,0>
   }
   object { hair translate <.2,1.24,0> 
      rotate <0,20,0>
   }
   object { hair translate <-.4,1.24,0>
      rotate <0,-50,0>
   }
   object { hair translate <.4,1.24,0>
      rotate <0,50,0>
   }
}

#declare ROW_TRANS =.5

#declare rows = union {
   object { row translate z*ROW_TRANS }
   object { row translate z*2*ROW_TRANS }
   object { row translate z*3*ROW_TRANS }
   object { row translate z*4*ROW_TRANS }
   object { row translate z*5*ROW_TRANS }
   object { row }
   object { row rotate y*180 }
   object { row rotate y*180
      translate z*-1*ROW_TRANS
   }
   object { row rotate y*180
      translate z*-2*ROW_TRANS
   }
   object { row rotate y*180
      translate z*-3*ROW_TRANS
   }
   object { row rotate y*180
      translate z*-4*ROW_TRANS
   }
   object { row rotate y*180
      translate z*-5*ROW_TRANS
   }
   pigment { Gold }
   finish { Shiny }
   scale .4
}

#declare frill = union {
   cylinder { <0,1,0> <0,1.2,0> .1 }
   box { <-.2,1.2,-1> <.2,1.25,1> }
   object { rows translate <0,.8,0> }
   pigment { Gold }
   finish { Shiny }
   rotate <30,0,0>
}

#declare bottombit = difference {
   sphere { <0,-1,0> .9 }
   union {
      sphere { <0,-.1,0> 1 }
      sphere { <0,0,0> .8 }
      sphere { <0,-1.4,0> 1 }
      cone  { <0,-1,0> .5 <0,-1,-1> .8 }
   }
   translate <0,.05,0>
   scale <.95,.9,1.2>
   pigment { DarkOliveGreen }
   finish { Shiny }
}

#declare base = difference {
   union {
      sphere { <0,0,0> 1 }
      sphere { <-1,0,0> .2 }
      sphere { <1,0,0> .2 }
   }
   union {
      sphere { <0,0,0> .9 }
      cone { <0,0,0> .001 <0,-.3,-1> 1.5
         scale <1.5,1,1>
      }
      cone { <0,0,0> .001 <0,-1,0> 1.2}
   }
   pigment { DarkOliveGreen }
   finish { Shiny }
}

#declare eye = union {
   sphere { <0,0,0> .1
      pigment {White}
      finish {Shiny}
   }
   sphere { <0,-.03,-.1> .04
      pigment {Black}
      finish {Shiny}
   }
   scale <1.5,2,.5>
}

#declare head =union {
   object { frill }
   object { base 
      scale <.8,1,1>
   }
   object { visor 
      scale <.8,1,1>
   }
   sphere { <0,0,0> .75
      pigment { Black }
   }
   object { bottombit 
      scale <.8,1,1>
   }
   union {
      object { eye translate <-.2,-.1,-.7> }
      object { eye translate < .2,-.1,-.7> }
   }
}

#declare body = blob {
   threshold 0.6
// chest 
   cylinder { <0,-1.2,0> <0,-1.8,0> .5 1 }
   cylinder { <0,-1.9,0> <0,-2.8,0> 1 1 }
// left arm
   cylinder { <.7,-2,0> <1.8,-2.6,.5> .4 1 }
   cylinder { <1.8,-2.6,.5> <2.5,-2,-.5> .4 1 }
// right arm
   cylinder { <-.7,-2,0> <-1.8,-2.6,.5> .4 1 }
   cylinder { <-1.8,-2.8,.5> <-1.9,-3.5,.6> .4 1 }
// butt
   sphere { <0,-3.5,1> .5 1 }
// left leg
   cylinder { <0,-3.5,1> <.8,-4.5,.2> .4 1 }
   cylinder { <.9,-4.6,.2> <.9,-5.6,.6> .4 1 }
// right leg
   cylinder { <0, -3.5,1> <-.8,-4.5,.2> .4 1 }
   cylinder { <-.9,-4.6,.2> <-.9,-5.6,.6> .4 1 }

   sphere { <1.8,-2.6,.5> .4, -1 }
   sphere { <0,-2.8,0> 2, 1}
   scale <.5,.7,.5>
   rotate <10,0,0>
   translate <0,-.1,.1>
   pigment { Red }
   finish { Shiny }
}

#declare lfinger1 =
blob {
   threshold 0.6
   sphere { <0,.5,2> .5 1 }
   cylinder { <-.1,.5,2> <1.1,.5,2> .5 1 }
   cylinder { <1.48,.5,2> <1.48,.5,1> .5 1 }
}

#declare rfinger1 =
blob {
   threshold 0.6
   sphere { <0,.5,2> .5 1 }
   cylinder { <.1,.5,2> <-1.1,.5,2> .5 1 }
   cylinder { <-1.48,.5,2> <-1.48,.5,1> .5 1 }
}

#declare lfinger2 =
blob {
   threshold 0.6
   sphere { <0,0,2> .5 1 }
   cylinder { <-.2,0,2> <1.3,0,2> .5 1 }
   cylinder { <1.68,0,2> <1.68,0,.5> .5 1 }
}

#declare rfinger2 =
blob {
   threshold 0.6
   sphere { <0,0,2> .5 1 }
   cylinder { <.2,0,2> <-1.3,0,2> .5 1 }
   cylinder { <-1.68,0,2> <-1.68,0,.5> .5 1 }
}

#declare lfinger3 =
blob {
   threshold 0.6
   sphere { <0,-.5,2> .5 1 }
   cylinder { <0,-.5,2> <1,-.5,2> .5 1}
   cylinder { <1.38,-.5,2> <1.38,-.5,1> .5 1}
}

#declare rfinger3 =
blob {
   threshold 0.6
   sphere { <0,-.5,2> .5 1 }
   cylinder { <0,-.5,2> <-1,-.5,2> .5 1}
   cylinder { <-1.38,-.5,2> <-1.38,-.5,1> .5 1}
}

#declare lthumb = blob {
   threshold 0.6
   sphere { <1,.8,.5> .5 1}
   sphere { <1.5,.8,.5> .5 1 }
   cylinder { <0,.5,0> <1,.8,.5> .5 1}
}

#declare rthumb = blob {
   threshold 0.6
   sphere { <-1,.8,.5> .5 1}
   sphere { <-1.5,.8,.5> .5 1 }
   cylinder { <0,.5,0> <-1,.8,.5> .5 1}
}

#declare palm =    blob {
   threshold 0.6
   cylinder { <0,0,0> <0,.5,2> .5 .9 }
   sphere { <0,.5,2> .4 .8 }
   cylinder { <0,0,0> <0,0,2> .5 .9 }
   sphere { <-.1,0,2> .5 .8 }
   cylinder { <0,0,0> <0,-0.5,2> .5 .9 }
   sphere { <0,-.5,2> .4 .8 }
   cylinder { <0,-0.5,2> <0,.5,2> .3 .9 }
}


#declare left_hand =  
union {
   object { palm }
   object { lfinger1 }
   object { lfinger2 }
   object { lfinger3 }
   object { lthumb }
   pigment { White }
   finish { Shiny }
   rotate <0,190,0>
   scale .3
}

#declare right_hand =
union {
   object { palm }
   object { rfinger1 }
   object { rfinger2 }
   object { rfinger3 }
    object { rthumb }
   pigment { White }
   finish { Shiny }
   rotate <0,190,0>
   scale .3
}

#declare fin = cone { <0,0,.1> .01 <0,0,1> .1
   scale <1,4,1>
}

#declare waist = difference {
   cylinder { <0,0,0> <0,.1,0> 1 }
   union {
     object { fin }
     object { fin 
       rotate <0,45,0>
     }
     object { fin 
       rotate <0,90,0>
     }
     object { fin 
       rotate <0,135,0>
     }
     object { fin 
       rotate <0,180,0>
     }
     object { fin 
       rotate <0,225,0>
     }
     object { fin 
       rotate <0,270,0>
     }
     object { fin 
       rotate <0,315,0>
     }
   }
   finish { Shiny }
   pigment {DarkOliveGreen }
   rotate <-30,0,0>
   translate <0,-2.6,0>
}

#declare shoe = union {
   difference {
      union {
         cone { <0,0,0> .4 <2,0,0> .6 }
	 sphere { <0,0,0> .4 }
         sphere { <2,0,0> .6 }
      }
      box { <-5,-5,-5> <5,0,5> }
      pigment { White }
      finish { Shiny }
   }
   sphere { <0,.15,0> .2 
      scale <1,1,2.2>
      pigment { LimeGreen }
      finish { Shiny }
   }
   scale .7
}

#declare staff = union {
   union {
      cone { <0,2,0> .1 <0,2.3,0> .01 }
      cylinder { <0,2,0>  <0,1.8,0> .02 }
      finish { Shiny }
      pigment { Silver }
   }
   cylinder { <0,1.8,0> <0,-1,0> .02 
      texture {
         pigment {
            Tom_Wood
            color_map {
               [0.0 color DarkTan]
               [0.9 color DarkBrown]
               [1.0 color VeryDarkBrown]
            }
            turbulence 0.05
            rotate <0, 90, 0>
            scale <0.2, 0.3, 1>
         }
      }
   }
   scale 2.4
}

// #declare marvin = 
union {
   object { head 
      scale 1.5
      translate <0,.2,0>
   }
   object { body }
   object { waist }
   object { staff translate <1.6,-2.1,-0.7> }
   object { left_hand 
      rotate <0,-75,0>
      translate <1.3,-1.3,-.5> 
   }
   object { right_hand
      rotate <0,0,-90>
      rotate <-100,0,0>
      translate <-.9,-2.7,0>
   }
   object { shoe 
      rotate <0,45,0>
      translate <.35, -4.2,-.2>
   }
   object { shoe 
      rotate <0,90,0>
      translate <-.5,-4.2,-.2>
   }
   rotate <0,-30,0>
   translate <-4,-1.6,15>
   scale .8
}
