#include "shipwing.inc"

#declare mold = 
union {
   box { <-1,-1,-.1> <1,1,0> }
   cylinder { <-.8,-.8,0> <-.8,-.8,.1> .15 }
   cylinder { <.8,.8,0>  <.8,.8,.1> .15 }
   cylinder { <-.8,.8,0> <-.8,.8,.1> .15 }
   cylinder { <.8,-.8,0> <.8,-.8,.1> .15 }
   scale 1.3
}

#declare handle =
union {
   object { mold
      scale <.5,.2,.5>
      translate <0,0,-.2>
   }
   difference {
      torus { 1, .1 
         translate <-1,0,0>
      }
      box { <-1,-2,-2> <-5,2,2> }
   }
   cylinder { <-1,0,1> <-11,0,1> .1 }
}

#declare ladder= 
union {
   object { handle }
   object { handle 
      translate <0,2,0>
   }
   cylinder { <-1,0,1> <-1,2,1> .1 }
   cylinder { <-2,0,1> <-2,2,1> .1 }
   cylinder { <-3,0,1> <-3,2,1> .1 }
   cylinder { <-4,0,1> <-4,2,1> .1 }
   cylinder { <-5,0,1> <-5,2,1> .1 }
   cylinder { <-6,0,1> <-6,2,1> .1 }
   cylinder { <-7,0,1> <-7,2,1> .1 }
   cylinder { <-8,0,1> <-8,2,1> .1 }
   cylinder { <-9,0,1> <-9,2,1> .1 }
   cylinder { <-10,0,1> <-10,2,1> .1 }


   texture { T_Silver_3A }
   rotate <-180,0,90>
}

#declare hull=
union {
   cone { <0,2.75,0> .38 <0,3.7,0> .1 }
   sphere { <0,0,0> 1 
      scale <1,3,1>
   }
   pigment { Orange }
   finish { Shiny }
}

#declare door =
union {
   sphere { <0,0,0> .3
      scale <1,3,.3>
      translate <0,0,-1>
   }
   torus { .3 .05
      rotate <90,0,0>
      scale <1,3,.3>
      translate <0,0,-1>
   }
   torus { .2 .05 
      rotate <90,0,0>
      translate <0,0,-1.2>
   }
   cylinder { <-.2,0,-1.2> <.2,0,-1.2> .05 }
   cylinder { <0,0,-1.2> <0,0,0> .05 }
   texture { T_Silver_3A }
}

#declare jet = union {
   cylinder { <0,1,0> <0,-.5,0> .3 }
   cone { <0,-.5,0> .3 <0,-1.5,0> .7 }
   cylinder { <0,-.8,0> <0,-.85,0> 1.2 }
   texture { T_Silver_3A }
   scale .2
}

// #declare ship =
union {
   object { door 
      translate <0,-.2,0>
   }
   object { hull }
   object { ladder 
      translate <-1,-6.5,-4.8>
      scale .2
   }
   object { ship_wing rotate <0,-10,0> }
   object { ship_wing rotate <0,110,0> }
   object { ship_wing rotate <0,230,0> }
   object { jet translate <0,-3,0> }
   rotate <0,70,0>
   translate <2.7,2.4,5>
//    translate <1,2.8,2>
   scale 4.0
}
