/********************************************
 * mcbcrash.pov
 * Matthew Corey Brown
 * mbrown@spry.com
 * My entry for the IRTC Sept/Oct 96 Topic Sci-Fi
 * A building of the Office for Alien Technology (OAT)
 * with a huge crashed spaceship reflecteded in the windows
 */


#version 3.0
global_settings { assumed_gamma 2.2 max_trace_level 10}

#include "colors.inc"
#include "textures.inc"

#declare ExternalPlanet=0
//#include "space.inc"

#declare T_BWindow=texture{
	pigment{rgb<0.22,0.45,0.375>}
	finish{
		diffuse 0.2
		ambient 0.2
		reflection 0.7
		phong 1
		phong_size 50
	}
}

#declare T_BStone=texture{
    pigment{
		agate
		agate_turb 0.8
		color_map{
			[0 Orange*0.4 blue 0.12]
			[1 Orange*0.46 blue 0.2]
		}
	}
	finish{ Dull crand 0.15 ambient 0.5}
	scale 1/10
}
texture{
    pigment{
		bozo
        turbulence 0.6
        octaves 4
        lambda 2.2
		color_map{
			[0 rgbf<1,1,1,1>]
			[1 rgbf<0.7,0.7,0.75,0.9>]
		}
    }

	finish{ crand 0.15}
	scale 1/8
}


#declare T_BSteel=texture{
	pigment{rgb<0.14,0.14,0.25>}
	finish{Metal}
}

#declare N_B1A=
normal{
       gradient z
       slope_map{
                 [0.15 <1,0>]
                 [0.16 <0.6, -1>]
                 [0.2  <0,0>]
       }
       triangle_wave
}


#declare T_Building1A=texture{
	gradient z
	texture_map{
		[0.15 T_BStone]
		[0.15 T_BWindow]
	}
	triangle_wave
}

#declare T_Building1B=texture{
	gradient x
	texture_map{
		[0.15 T_Building1A]
		[0.15 T_BWindow]
	}
	triangle_wave
}

#declare T_Building1=texture{
	gradient y
	texture_map{
		[0.2 T_BStone ]
		[0.2 T_Building1B ]
	}
	triangle_wave

}
#declare N_B2=
  normal {
    quilted -1
    control0 0
    control1 2
  }



#declare T_Building2A=texture{
	gradient z
	texture_map{
		[0.08 T_BSteel ]
		[0.08 T_BWindow]
	}
	triangle_wave
}

#declare T_Building2B=texture{
	gradient x
	texture_map{
		[0.08 T_Building2A]
		[0.08 T_BWindow]
	}
	triangle_wave
}

#declare T_Building2=texture{
	gradient y
	texture_map{
		[0.08 T_BSteel normal {N_B2 rotate x*90}]
		[0.08 T_Building2B]
	}
	triangle_wave

}

#declare DW=0.4

#declare Door=union{
	box {<-(DW/2),0.02,-0.019>,<(DW/2),0.78,0.02> texture{T_BWindow}}
	cylinder{<-(DW/2),0.02,0>,<-(DW/2),0.78,0>,0.02}
	cylinder{<(DW/2),0.02,0>,<(DW/2),0.78,0>,0.02}
	cylinder{<(DW/2),0.78,0>,<-(DW/2),0.78,0>,0.02}
	cylinder{<(DW/2),0.02,0>,<-(DW/2),0.02,0>,0.02}
	sphere{<-(DW/2),0.78,0>,0.02}
	sphere{<-(DW/2),0.02,0>,0.02}
	sphere{<(DW/2),0.78,0>,0.02}
	sphere{<(DW/2),0.02,0>,0.02}
	cylinder{<(DW/2),0.4,-0.06>,<-(DW/2),0.4,-0.06>,0.02}
	cylinder{<(DW/2),0.4,-0.06>,<(DW/2),0.4,0>,0.02}
	cylinder{<-(DW/2),0.4,-0.06>,<-(DW/2),0.4,0>,0.02}
	sphere{<(DW/2),0.4,-0.06>,0.02}
    sphere{<-(DW/2),0.4,-0.06>,0.02}
	texture{T_BSteel}
}


#declare BDoors=union{
	box{<-0.1,0,0>,<1.5,1,0.2> texture{ T_BStone}}
	object{Door translate (0.707-(DW/1.65))*x}
	object{Door translate (0.707+(DW/1.65))*x}
	rotate -45*y
	translate -z
}

#declare P_GMarble=pigment{
	marble
	lambda 02.33
	octaves 4
	turbulence 0.2
	pigment_map{
		[0 Jade ]
		[0.9 Jade scale 1/2]
		[1.0 White*0.6]
	}
	scale 1/3
}

#declare P_BMarble=pigment{
	marble
	lambda 02.33
	octaves 4
	turbulence 0.9
	pigment_map{
		[0.2 White_Marble scale 1/3]
		[0.6 Black]
	}
	scale 1/2
}

#declare Facade=union{
	box {<-0.5,-1,-0.05>,<0.5,1,0> pigment{P_GMarble}}
	box {<-0.4,-0.9,-0.07>,<0.4,0.9,0> pigment{P_BMarble}}
	scale 1/11
	finish {Shiny}
}


#declare T_Path=texture{
         pigment{
                 bozo
                 turbulence 0.5
                 lambda 2.5
                 color_map{
                           [0  rgb<0.6,0.7,0.65>]
                           [1  White*0.75]
                 }
         }
         finish{diffuse 0.9 ambient 0.3 crand 0.12}
         scale 1/90
}


#declare T_Grass=
texture{
        pigment{
                wrinkles
                turbulence 0.6
                omega 0.6
                octaves 6
                lambda 2.5
                color_map{
                          [0 HuntersGreen]
                          [0.2 Yellow*0.7]
                          [1 Green]
                }
                scale 1/5
        }
        normal{ wrinkles 0.2 }
}

#declare T_LampGlass=texture{
         pigment{rgb<0.9,0.95,0.85>}
         normal{ leopard -0.5 scale 1/500 }
         finish{diffuse 0.7 ambient 0.2 phong 0.03 reflection 0.3}
}

#declare T_LampPost=texture{
         pigment{rgb<0.5,0.55,0.45>}
         finish{Metal crand 0.05}
}

#declare Lamp=union{
         box{<-0.08,-0.2,-0.08>,<0.08,0,0.08> texture {T_Path}}
         cone{0,0.078,0.08*y,0.03}
         cylinder{0.08*y,1.2*y,0.02}
         cone{1.2*y,0.025,1.25*y,0.07}
         sphere{1.35*y,0.07}
         cylinder{1.25*y,1.35*y,0.068 texture{T_LampGlass}}
         texture{T_LampPost}
}


#declare Path=union{
         cylinder{0,-0.2*y,6}
         box{<-0.5,-0.2,-18>,<0.5,0,0>}
         intersection{
                      cylinder{0,0.3*y,6}
                      cone{0,5.8,0.31*y,5.6 inverse}
                      box{<-0.5,0,-6.5>,<0.5,0.31,0> inverse }
         }
         object {Lamp translate <-0.58,0,-11>}
         object {Lamp translate <0.58,0,-11>}
         object {Lamp translate <-0.58,0,-7>}
         object {Lamp translate <0.58,0,-7>}
         object {Lamp translate <-0.58,0,-13>}
         object {Lamp translate <0.58,0,-13>}
         object {Lamp translate <-0.58,0,-9>}
         object {Lamp translate <0.58,0,-9>}
         texture{T_Path}
}

#declare Grass=sphere{
         0,1
         scale <15,0.2,15>
         translate -0.2*y
         texture{T_Grass}
}
#declare SW=2.5
#declare SH=0.3
#declare Letters=intersection{
         box{<0,-0.3,0>,<SW,SH,0.2>}
         text
             {
             ttf          // font type (only TrueType format for now)
             "timrom.ttf",  // Microsoft Windows-format TrueType font file name
             "Office of Alien Technology",   // the string to create
             1,           // the extrusion depth
             0            // offset
             scale 1/4.8
             translate <0.1,0.09,-0.1>
             inverse
         }
         texture{T_Path}
}

#declare SignLight=union{
         sphere{0,0.09 texture{T_LampGlass}}
         intersection{
                      sphere{0,0.1}
                      intersection{
                                   sphere{<0,0.1,0.05>,0.1}
                                   sphere{<0,0.1,-0.05>,0.1}
                                   inverse
                      }
                      texture{T_LampPost}
         }
}

#declare Sign=
         object{Letters translate -(SW/2)*x }


#declare Building=union{
	box{<-3,-0.1,0>,<6,2,3>}
	box{<-3,-0.1,-3>,<0,2,0>}
	box{<-3,2,0>,<6,6,3> texture{T_Building2}}
	box{<-3,2,-3>,<0,6,0> texture{T_Building2}}
	box{<0,1,-1>,<2,4,0>}
	box{<0,2,-2>,<1,4,-1>}
	object {Facade rotate -90*y translate <0,1,-2>}
	object {Facade rotate -90*y translate <6,1,1>}
	object {Facade rotate -90*y translate <6,1,2>}
	object {Facade translate <3,1,0>}
	object {Facade translate <4,1,0>}
	object {Facade translate <5,1,0>}
	object {Facade translate <-1,1,-3>}
	object {Facade translate <-2,1,-3>}
	object{BDoors}
    texture{T_Building1}
    rotate y*45
}

#declare T_SSteel=texture{
	pigment {rgb<0.08,0.1,0.13>*9}
	finish {Metal}
	normal{
		average
		normal_map{
			[1 dents 0.06 scale 0.002]
			[1 crackle 0.26 scale 0.3 turbulence 1]
		}
	}
}

#declare PPH=sin(radians(20))
#declare PPR=cos(radians(20))

#declare Hull_Half=intersection{
	box{<-1.001,0,-1.001>,<1.001,1.001,1.001>}
	sphere {0,1}
	sphere {0,1 scale <0.99,0.3,0.99> inverse}
	intersection{
		box{<-PPR,-0.009,0>,<PPR,0.009,PPR>}
		torus {PPR,0.009}
		translate y*PPH
		texture {Silver_Texture}
		inverse
	}
	scale <1,0.3,1>*2
}

#declare Engine=union{
	intersection{
                union{
			cylinder{0,-0.3*z,0.1}
			sphere{0,0.105 scale <1,1,0.05> translate -0.177*z}
			sphere{0,0.11 scale <1,1,0.05> translate -0.217*z}
			sphere{0,0.115 scale <1,1,0.05> translate -0.257*z}
			sphere{0,0.12 scale <1,1,0.05> translate -0.297*z}
		}
		sphere {-0.3*z,0.099 inverse}
		torus{0.085,0.007 rotate x*90 translate -0.25*z inverse}
	}
#declare CC=0
#declare NOC=int(radians(180)*0.085/0.005)
    light_source{ -0.25*z color rgb<1,0.9,0.5> fade_distance 30 fade_power 2 atmosphere off}
	sphere{-0.22*z,0.07 no_shadow}
	sphere{0,0.073 scale <1,1,0.05> translate -0.22*z no_shadow}
#while (CC<NOC)
	sphere{<0,0.085,-0.25>,0.0049 rotate z*360*CC/NOC
		texture{Silver_Texture}}
#declare CC=CC+1
#end
	scale 1.5

}







#declare ship=union{
	cylinder {-0.1*y,0.1*y,0.8 texture{Gold_Texture}}
	sphere {0,1 scale <2,0.05,2>}
	box{<-0.1,-0.7,-2><0.1,0.7,0>}
	object {Hull_Half translate 0.1*y}
	object {Hull_Half translate 0.1*y scale <1,-1,1>}
	object {Engine
		translate<-1.6*sin(radians(10)),0,-1.7*cos(radians(10))>}
	object {Engine
		translate<1.6*sin(radians(10)),0,-1.7*cos(radians(10))>}
	object {Engine
		translate<-1.6*sin(radians(25)),0,-1.75*cos(radians(25))>}
	object {Engine
		translate<1.6*sin(radians(25)),0,-1.75*cos(radians(25))>}
	texture{T_SSteel}
	rotate 160*y
	rotate 15*x
}
#declare C_Sky=rgb<0.6,0.55,0.8>

#declare P_SkyA=pigment{
         bozo
         color_map{
                   [0.3 C_Sky]
                   [0.6 rgb<0.9,0.9,0.92>]
                   [1.0 White]
         }
         scale 1/3
}
#declare P_SkyB=pigment{
         wrinkles
         color_map{
                   [0.0 C_Sky]
                   [0.05 rgb<0.5,0.49,0.52>]
                   [0.8 White]
                   [1.0 rgb<0.9,0.9,0.92>]
         }
         scale 1/4
}


#declare P_Sky=pigment{
         wrinkles
         turbulence <0.6,0.5,0.7>
         lambda 2.1
         octaves 7
         pigment_map{
                     [0.4 C_Sky]
                     [0.5 P_SkyA]
                     [0.6 P_SkyB]
         }
         scale <1/6,1/30,1/10>
}

#declare Sky=sphere{
         0,1
         no_shadow
         hollow
         pigment{P_Sky}
         finish{ambient 1 diffuse 0 crand 0.02}
         scale 200000
         translate -190000*y
}


#declare T_Rocks=texture{
         pigment{
                 gradient y
                 turbulence 0.12
                 color_map{
                           [0.2 rgb<0.9,0.85,0.5>]
//                           [0.4 Yellow*0.3]
                           [0.6 NewTan]
                           [0.8 NewTan]
                           [1.0 rgb<0.9,0.85,0.5>]
                 }
         }
         finish{crand 0.08}
}

#declare T_Hills=texture{
         bozo
         turbulence 0.2
         texture_map{
                     [0.6 T_Grass scale 1/20]
                     [0.7 T_Rocks scale 1/5]
         }
         scale 1/20
 }
/*
// Removed for distributation casue the HFs were too huge

#declare Hills=height_field
{
  pot               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "mcrasha.pot"     // the file name to read
  texture{T_Hills}
  translate <0.1,-0.85,-0.5>
  scale <400,30,500>
  translate z*30
  rotate y*5
  scale 100

}
#declare Cliffs=height_field
{
  pot               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "mcrashb.pot"     // the file name to read
  texture{T_Rocks scale 1/8}
  translate <-0.5,-0.15,-0.5>
  scale <800,80,-500>
  translate z*-500

}
*/

#declare T_Sea=texture{
         pigment{
                 color rgb <0.94, 0.93, 0.80>
         }
         normal {
            average
            normal_map {
                [ ripples 0.15 frequency 3 scale 0.008 translate <0, 0, 10> ]
                [ wrinkles 0.25 scale 0.01  ]
            }
         }
         finish {
                ambient 0.25
                brilliance 4
                diffuse 0.5
                metallic
                specular 0.80
                roughness 1/80
                reflection 0.5
         }
         scale 80
}

#declare Sea=box{
         <-4000,-5,-10000>,<4000,-4,10>
         texture {T_Sea}
}


#declare Fog=  fog {
    fog_type 2 // 1=constant, 2=ground_fog
    distance 2000
    color Gray
 turbulence 0.3
 turb_depth 100
 fog_offset -40
 fog_alt 10
  }


#declare ShuttleShape=union{
         sphere{0,1}
         cylinder{0,-z,1}
         sphere{0,1 scale <1,1,1/10> translate -z}
         scale<1,1/5,1>
}

#declare ShuttleEngine=union{
         union{intersection{
                      object{ShuttleShape}
                      box{<-1.001,0,-1.101>,<1.001,0.201,1.001>}
                      translate 0.1*y
         }
         intersection{
                      object{ShuttleShape}
                      box{<-1.001,0,-1.101>,<1.001,0.201,1.001>}
                      translate 0.1*y
                      scale <1,-1,1>
         }
         object{ShuttleShape scale <1,0.1,1>}
         object{ShuttleShape scale 0.95 pigment{rgb<0.5,0.7,0.9>} finish {diffuse 0 ambient 1}}
         scale<0.1,0.2,0.5>*1.5}
         cylinder{0,<0,0.4,0.5>,0.08 scale <0.5,1,1>}
}

#declare ShuttleCanopy=object{
         ShuttleShape
         scale <1/4,1/3,1/3>
         translate <0,0.15,0.5>
         pigment{rgb<0.5,0.8,0.3>}
         finish{diffuse 0.3 ambient 0.3 reflection 0.5}
}


#declare Shuttle=union{
         object{ShuttleShape}
         object{ShuttleCanopy translate 0.3*x}
         object{ShuttleCanopy translate -0.3*x}
         object{ShuttleEngine scale <1,-1,1> translate <0,0.4,-0.7>}
         object{ShuttleEngine translate <0.5,-0.3,-0.6>}
         object{ShuttleEngine translate <-0.5,-0.3,-0.6>}
         pigment{rgb<0.7,0.73,0.6>}
         finish{Metal}

}






//fog{Fog}
object {Sea}
//object {Cliffs}
//object {Hills}
object {Sky}
object {Path}
object {Grass}
object {Sign translate <-3,-0.05,-10>}
object {SignLight rotate x*30 rotate y*30 translate <-4,-0.05,-11>}
object {SignLight rotate x*20 rotate y*-30 translate <-2,-0.05,-11>}
object {ship scale 30 rotate <-20,0,-7> translate <0,-1,-200> rotate y*70 scale 10}
object {Shuttle scale 3 translate <0, 40, -200> rotate y*68}
object {Shuttle scale 3 translate <0, 250, -1500> rotate y*63 translate <-40,-30,-60>}
object {Shuttle scale 3 translate <0, 250, -1500> rotate y*63 translate <-4,30,60>}
object {Shuttle scale 3 translate <0, 250, -1500> rotate y*63}
object{ Building }


light_source { <20000,0,0> color White
               area_light <0, 900, 0> <0, 0, 900> 8, 8 adaptive 1 jitter
               rotate z*40
               rotate y*90
              atmosphere off}

//light_source { <2000,300,2000> color White*0.15 shadowless atmosphere off }
//light_source { <2000,300,-2000> color White*0.15 shadowless atmosphere off }


#declare CS=0.05
camera {
   location <-5, 0.8, -18>
   up    CS*y
   right (CS*4/3)*x
   look_at <2,1.5,0>
   angle 35
   translate y/2
//   rotate -135*y
}







