// ***************************************************************
// ************ ** ** ************         Mrakan Scene          *
// ************* * * *************           made by             *
// ************* * * *************        Miroslav Hundak        *
// ** *  *  *** ***** ** *  *  ***            alias              *
// *** ** ** *** *** **** ** ** **         Dran Draggore         *
// *** ** ** **** ** **** ** ** ** - - - - - - - - - - - - - - - *
// *** * ** ******  **** ** ** ***  e-mail : dran@fly.cc.fer.hr  *
// *** ************ **************                               *
// *** ************ **************  http://fly.cc.fer.hr/~dran   *
// *** ************ **********************************************
// *** *********** ***************** **** **** **** **** **** ****
// *** *********** **************** * ** * ** * ** * ** * ** * ***
// ** *********** ****************** **** **** **** **** **** ****
// ***************************************************************


// NOTE :   I have excluded the height-field image maps, because they together have more than 350 KB,
//          so if you would render this scene there would be no mountains in background as there are
//          on the rendered image. I did however leave the height_field objects (line 717), but they
//          are deactivated by /* and */ .


#include "colors.inc"
#include "skies.inc"

#include "toranj.inc"
#include "toranj2.inc"
#include "zid.inc"

#declare kontrola1 = 1
#declare kontrola2 = 0

// * CAMERA
camera {
    location <-50, 15, -45>  // <-60, 15, -105>
    direction <0, 0, 1>     // <0, 0, 2>
    look_at <-15, 25, 0>    // <-20, 25, 0>
}

// * LIGHTS
light_source { <-5000, 5000, -5000> color rgb <1, 1, 1>
    area_light <0, 500, 0>, <0, 0, 500>, 5, 5
    adaptive 1
}
light_source { <-5000, 5000, -5000> color rgb <0.6, 0.6, 0.6>
    area_light <0, 500, 0>, <0, 0, 500>, 5, 5
    adaptive 1
}

// * OBJECTS

sky_sphere {
    pigment { gradient y
    pigment_map {
    [ 0.3
        gradient y
        pigment_map {
            [0.01 rgb <0.6, 0.3, 0.3> ] // horizon
            [0.35 P_Cloud2 scale 0.25 rotate z*5]
            [0.60 P_Cloud3 scale <0.25, 0.15, 0.25> rotate z*10]
        }
    ]
    [ 0.85
        granite
        color_map {
            [ 0.000  0.270 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.270  0.280 color rgb <.5,.5,.4> color rgb <.8,.8,.4> ]
            [ 0.280  0.470 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.470  0.480 color rgb <.4,.4,.5> color rgb <.4,.4,.8> ]
            [ 0.480  0.680 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.680  0.690 color rgb <.5,.4,.4> color rgb <.8,.4,.4> ]
            [ 0.690  0.880 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.880  0.890 color rgb <.5,.5,.5> color rgb < 1, 1, 1> ]
            [ 0.890  1.000 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
        }
    turbulence 1
    sine_wave
    scale .5
    ]
    }
    }
}

object { Toranj_O scale 7 translate <400, 0, 300> }
object { Zid rotate <0, 90, 0> scale 7 translate <400, 0, 300> }
object { Zid rotate <0, 90, 0> scale 7 translate <400, 0, 258> }
object { Zid rotate <0, 90, 0> scale 7 translate <400, 0, 216> }
object { Zid_O rotate <0, 90, 0> scale 7 translate <400, 0, 174> }
object { Zid rotate <0, 90, 0> scale 7 translate <400, 0, 132> }
object { Zid rotate <0, 90, 0> scale 7 translate <400, 0, 90> }
object { Zid_O rotate <0, 90, 0> scale 7 translate <400, 0, 48> }
object { Zid rotate <0, 90, 0> scale 7 translate <400, 0, 6> }
object { Zid rotate <0, 90, 0> scale 7 translate <400, 0, -36> }
object { Toranj_O scale 7 translate <400, 0, -36> }
object { Toranj_Kplus scale 7 translate <450, 0, 900> }

#if (kontrola1 = 0)

#declare laserlight = 0
#declare gunfire = 0
#include "skeleton.inc"
object { bot }

#else

// * * * BOT 1 * * *

// * spine movement in XY plane
#declare angle_XY_1 = radians(30)
#declare angle_XY_2 = radians(-5)
#declare angle_XY_3 = radians(-5)
#declare angle_XY_4 = radians(-10)
#declare angle_XY_5 = radians(-10)
#declare angle_XY_6 = radians(-8)
#declare angle_XY_7 = radians(-8)
#declare angle_XY_8 = radians(-5)
#declare angle_XY_9 = radians(-5)
#declare angle_XY_10 = radians(-2)
#declare angle_XY_11 = radians(-2)
#declare angle_XY_12 = radians(-2)
#declare angle_XY_13 = radians(-2)
#declare angle_XY_14 = radians(0)
#declare angle_XY_15 = radians(0)
#declare angle_XY_16 = radians(0)
#declare angle_XY_17 = radians(0)
#declare angle_XY_18 = radians(0)
#declare angle_XY_19 = radians(0)
#declare angle_XY_20 = radians(0)
#declare angle_XY_21 = radians(5)
#declare angle_XY_22 = radians(5)
#declare angle_XY_23 = radians(5)
#declare angle_XY_24 = radians(5)
#declare angle_XY_25 = radians(5)
#declare angle_XY_26 = radians(3)
#declare angle_XY_27 = radians(3)
#declare angle_XY_28 = radians(3)
#declare angle_XY_29 = radians(2)
#declare angle_XY_30 = radians(2)
#declare angle_XY_31 = radians(2)
#declare angle_XY_32 = radians(2)
#declare angle_XY_33 = radians(1)
#declare angle_XY_34 = radians(1)
#declare angle_XY_35 = radians(1)
#declare angle_XY_36 = radians(1)
#declare angle_XY_37 = radians(0)
#declare angle_XY_38 = radians(0)
#declare angle_XY_39 = radians(0)
#declare angle_XY_40 = radians(0)

// * spine movement in ZX plane
#declare angle_Z_1 = radians(-45)
#declare angle_Z_2 = radians(5)
#declare angle_Z_3 = radians(5)
#declare angle_Z_4 = radians(5)
#declare angle_Z_5 = radians(5)
#declare angle_Z_6 = radians(5)
#declare angle_Z_7 = radians(5)
#declare angle_Z_8 = radians(5)
#declare angle_Z_9 = radians(5)
#declare angle_Z_10 = radians(5)
#declare angle_Z_11 = radians(0)
#declare angle_Z_12 = radians(0)
#declare angle_Z_13 = radians(0)
#declare angle_Z_14 = radians(0)
#declare angle_Z_15 = radians(0)
#declare angle_Z_16 = radians(0)
#declare angle_Z_17 = radians(0)
#declare angle_Z_18 = radians(0)
#declare angle_Z_19 = radians(0)
#declare angle_Z_20 = radians(0)
#declare angle_Z_21 = radians(0)
#declare angle_Z_22 = radians(0)
#declare angle_Z_23 = radians(0)
#declare angle_Z_24 = radians(0)
#declare angle_Z_25 = radians(0)
#declare angle_Z_26 = radians(0)
#declare angle_Z_27 = radians(0)
#declare angle_Z_28 = radians(0)
#declare angle_Z_29 = radians(0)
#declare angle_Z_30 = radians(0)
#declare angle_Z_31 = radians(2)
#declare angle_Z_32 = radians(2)
#declare angle_Z_33 = radians(2)
#declare angle_Z_34 = radians(2)
#declare angle_Z_35 = radians(2)
#declare angle_Z_36 = radians(2)
#declare angle_Z_37 = radians(2)
#declare angle_Z_38 = radians(2)
#declare angle_Z_39 = radians(2)
#declare angle_Z_40 = radians(2)

// * rotations of each spine element around it's axis
#declare angle_R_1 = radians(-30)
#declare angle_R_2 = radians(5)
#declare angle_R_3 = radians(5)
#declare angle_R_4 = radians(5)
#declare angle_R_5 = radians(5)
#declare angle_R_6 = radians(5)
#declare angle_R_7 = radians(5)
#declare angle_R_8 = radians(0)
#declare angle_R_9 = radians(0)
#declare angle_R_10 = radians(0)
#declare angle_R_11 = radians(0)
#declare angle_R_12 = radians(0)
#declare angle_R_13 = radians(0)
#declare angle_R_14 = radians(0)
#declare angle_R_15 = radians(0)
#declare angle_R_16 = radians(0)
#declare angle_R_17 = radians(0)
#declare angle_R_18 = radians(0)
#declare angle_R_19 = radians(0)
#declare angle_R_20 = radians(0)
#declare angle_R_21 = radians(0)
#declare angle_R_22 = radians(0)
#declare angle_R_23 = radians(0)
#declare angle_R_24 = radians(0)
#declare angle_R_25 = radians(0)
#declare angle_R_26 = radians(0)
#declare angle_R_27 = radians(0)
#declare angle_R_28 = radians(0)
#declare angle_R_29 = radians(0)
#declare angle_R_30 = radians(0)
#declare angle_R_31 = radians(0)
#declare angle_R_32 = radians(0)
#declare angle_R_33 = radians(0)
#declare angle_R_34 = radians(0)
#declare angle_R_35 = radians(0)
#declare angle_R_36 = radians(0)
#declare angle_R_37 = radians(0)
#declare angle_R_38 = radians(0)
#declare angle_R_39 = radians(0)
#declare angle_R_40 = radians(0)

// * sizes of spine elements
#declare size1 = 2

// * head's rotations
#declare headrot1 = -10           // X
#declare headrot2 = -10           // Y
#declare headrot3 = 15           // Z

// * bigger left arm's rotations
#declare hang1 = angle_XY_1+angle_XY_2+angle_XY_3+angle_XY_4+angle_XY_5+angle_XY_6+angle_XY_7+angle_XY_8+angle_XY_9
#declare armrot_bl_a_1 = 10 - degrees(hang1)   // Z arm will always hang down regardless of spine bendings, unless it is set otherwise
#declare armrot_bl_a_2 = 20                     // X
#declare armrot_bl_a_3 = 0                     // Y
#declare armrot_bl_b_1 = 0                     // Y
#declare armrot_bl_c_1 = 0                     // Y
#declare armrot_bl_c_2 = -75                     // Z

// * bigger right arm's rotations
#declare armrot_br_a_1 = 0 - degrees(hang1)     // arm will always hang down regardless of spine bendings, unless it is set otherwise
#declare armrot_br_a_2 = -20
#declare armrot_br_a_3 = -45  // -45
#declare armrot_br_b_1 = 0
#declare armrot_br_c_1 = 0
#declare armrot_br_c_2 = -80

// * smaller left arm's rotations
#declare armrot_sl_a_1 = 30 - degrees(hang1)     // arm will always hang down regardless of spine bendings, unless it is set otherwise
#declare armrot_sl_a_2 = 20
#declare armrot_sl_a_3 = 0
#declare armrot_sl_b_1 = 0
#declare armrot_sl_c_1 = 0
#declare armrot_sl_c_2 = -60
#declare armrot_sl_d_1 = 0
// * fingers
#declare armrot_sl_e_1 = -30
#declare armrot_sl_e_2 = -30
#declare armrot_sl_e_3 = 20

// * smaller right arm's rotations
#declare armrot_sr_a_1 = 30 - degrees(hang1)     // arm will always hang down regardless of spine bendings, unless it is set otherwise
#declare armrot_sr_a_2 = -20
#declare armrot_sr_a_3 = 0
#declare armrot_sr_b_1 = 0
#declare armrot_sr_c_1 = 0
#declare armrot_sr_c_2 = -70
#declare armrot_sr_d_1 = 0
// * fingers
#declare armrot_sr_e_1 = -20
#declare armrot_sr_e_2 = -20
#declare armrot_sr_e_3 = 15

// * left leg's rotations
#declare hang2 = hang1+angle_XY_10+angle_XY_11+angle_XY_12+angle_XY_13+angle_XY_14+angle_XY_15+angle_XY_16+angle_XY_17+angle_XY_18+angle_XY_19
#declare legrot_l_a_1 = -45 - degrees(hang2)
#declare legrot_l_b_1 = 90
#declare legrot_l_c_1 = -75
#declare legrot_l_d_1 = 0 - (legrot_l_a_1+legrot_l_b_1+legrot_l_c_1) - degrees(hang2)

// * right leg's rotations
#declare legrot_r_a_1 = -60 - degrees(hang2)
#declare legrot_r_b_1 = 120
#declare legrot_r_c_1 = -85
#declare legrot_r_d_1 = 30 - (legrot_r_a_1+legrot_r_b_1+legrot_r_c_1) - degrees(hang2)

// * rocket launcher's rotations
#declare rocrot1 = 0 - (degrees(hang1 - angle_XY_9))
#declare rocrot2 = 0

#declare laserlight = 0
#declare gunfire = 0
#include "skeleton.inc"
object { bot }


// * * * BOT 2 * * *

// * spine movement in XY plane
#declare angle_XY_1 = radians(0)
#declare angle_XY_2 = radians(10)
#declare angle_XY_3 = radians(10)
#declare angle_XY_4 = radians(-10)
#declare angle_XY_5 = radians(-10)
#declare angle_XY_6 = radians(-8)
#declare angle_XY_7 = radians(-8)
#declare angle_XY_8 = radians(-5)
#declare angle_XY_9 = radians(-5)
#declare angle_XY_10 = radians(-2)
#declare angle_XY_11 = radians(-2)
#declare angle_XY_12 = radians(-2)
#declare angle_XY_13 = radians(-2)
#declare angle_XY_14 = radians(0)
#declare angle_XY_15 = radians(0)
#declare angle_XY_16 = radians(0)
#declare angle_XY_17 = radians(0)
#declare angle_XY_18 = radians(0)
#declare angle_XY_19 = radians(0)
#declare angle_XY_20 = radians(0)
#declare angle_XY_21 = radians(5)
#declare angle_XY_22 = radians(5)
#declare angle_XY_23 = radians(5)
#declare angle_XY_24 = radians(5)
#declare angle_XY_25 = radians(5)
#declare angle_XY_26 = radians(5)
#declare angle_XY_27 = radians(5)
#declare angle_XY_28 = radians(5)
#declare angle_XY_29 = radians(5)
#declare angle_XY_30 = radians(3)
#declare angle_XY_31 = radians(3)
#declare angle_XY_32 = radians(3)
#declare angle_XY_33 = radians(3)
#declare angle_XY_34 = radians(2)
#declare angle_XY_35 = radians(2)
#declare angle_XY_36 = radians(2)
#declare angle_XY_37 = radians(1)
#declare angle_XY_38 = radians(1)
#declare angle_XY_39 = radians(1)
#declare angle_XY_40 = radians(1)

// * spine movement in Z-XY plane
#declare angle_Z_1 = radians(0)
#declare angle_Z_2 = radians(0)
#declare angle_Z_3 = radians(0)
#declare angle_Z_4 = radians(0)
#declare angle_Z_5 = radians(0)
#declare angle_Z_6 = radians(0)
#declare angle_Z_7 = radians(0)
#declare angle_Z_8 = radians(0)
#declare angle_Z_9 = radians(0)
#declare angle_Z_10 = radians(0)
#declare angle_Z_11 = radians(0)
#declare angle_Z_12 = radians(0)
#declare angle_Z_13 = radians(0)
#declare angle_Z_14 = radians(0)
#declare angle_Z_15 = radians(0)
#declare angle_Z_16 = radians(0)
#declare angle_Z_17 = radians(0)
#declare angle_Z_18 = radians(0)
#declare angle_Z_19 = radians(0)
#declare angle_Z_20 = radians(0)
#declare angle_Z_21 = radians(0)
#declare angle_Z_22 = radians(0)
#declare angle_Z_23 = radians(0)
#declare angle_Z_24 = radians(0)
#declare angle_Z_25 = radians(0)
#declare angle_Z_26 = radians(0)
#declare angle_Z_27 = radians(0)
#declare angle_Z_28 = radians(0)
#declare angle_Z_29 = radians(0)
#declare angle_Z_30 = radians(0)
#declare angle_Z_31 = radians(0)
#declare angle_Z_32 = radians(0)
#declare angle_Z_33 = radians(0)
#declare angle_Z_34 = radians(0)
#declare angle_Z_35 = radians(0)
#declare angle_Z_36 = radians(0)
#declare angle_Z_37 = radians(0)
#declare angle_Z_38 = radians(0)
#declare angle_Z_39 = radians(0)
#declare angle_Z_40 = radians(0)

// * rotations of each spine element around it's axis
#declare angle_R_1 = radians(0)
#declare angle_R_2 = radians(0)
#declare angle_R_3 = radians(0)
#declare angle_R_4 = radians(0)
#declare angle_R_5 = radians(0)
#declare angle_R_6 = radians(0)
#declare angle_R_7 = radians(0)
#declare angle_R_8 = radians(0)
#declare angle_R_9 = radians(0)
#declare angle_R_10 = radians(0)
#declare angle_R_11 = radians(0)
#declare angle_R_12 = radians(0)
#declare angle_R_13 = radians(0)
#declare angle_R_14 = radians(0)
#declare angle_R_15 = radians(0)
#declare angle_R_16 = radians(0)
#declare angle_R_17 = radians(0)
#declare angle_R_18 = radians(0)
#declare angle_R_19 = radians(0)
#declare angle_R_20 = radians(0)
#declare angle_R_21 = radians(0)
#declare angle_R_22 = radians(0)
#declare angle_R_23 = radians(0)
#declare angle_R_24 = radians(0)
#declare angle_R_25 = radians(0)
#declare angle_R_26 = radians(0)
#declare angle_R_27 = radians(0)
#declare angle_R_28 = radians(0)
#declare angle_R_29 = radians(0)
#declare angle_R_30 = radians(0)
#declare angle_R_31 = radians(0)
#declare angle_R_32 = radians(0)
#declare angle_R_33 = radians(0)
#declare angle_R_34 = radians(0)
#declare angle_R_35 = radians(0)
#declare angle_R_36 = radians(0)
#declare angle_R_37 = radians(0)
#declare angle_R_38 = radians(0)
#declare angle_R_39 = radians(0)
#declare angle_R_40 = radians(0)

// * sizes of spine elements
#declare size1 = 2

// * head's rotations
#declare headrot1 = 0           // X
#declare headrot2 = 0           // Y
#declare headrot3 = 0           // Z

// * bigger left arm's rotations
#declare hang1 = angle_XY_1+angle_XY_2+angle_XY_3+angle_XY_4+angle_XY_5+angle_XY_6+angle_XY_7+angle_XY_8+angle_XY_9
#declare armrot_bl_a_1 = 0 - degrees(hang1)   // Z arm will always hang down regardless of spine bendings, unless it is set otherwise
#declare armrot_bl_a_2 = 20                     // X
#declare armrot_bl_a_3 = 0                     // Y
#declare armrot_bl_b_1 = 0                     // Y
#declare armrot_bl_c_1 = 0                     // Y
#declare armrot_bl_c_2 = -90                     // Z

// * bigger right arm's rotations
#declare armrot_br_a_1 = 0 - degrees(hang1)     // arm will always hang down regardless of spine bendings, unless it is set otherwise
#declare armrot_br_a_2 = -20
#declare armrot_br_a_3 = 0
#declare armrot_br_b_1 = 0
#declare armrot_br_c_1 = 0
#declare armrot_br_c_2 = -45

// * smaller left arm's rotations
#declare armrot_sl_a_1 = 20 - degrees(hang1)     // arm will always hang down regardless of spine bendings, unless it is set otherwise
#declare armrot_sl_a_2 = 20
#declare armrot_sl_a_3 = 0
#declare armrot_sl_b_1 = 0
#declare armrot_sl_c_1 = 0
#declare armrot_sl_c_2 = -50
#declare armrot_sl_d_1 = 0
// * fingers
#declare armrot_sl_e_1 = -20
#declare armrot_sl_e_2 = -20
#declare armrot_sl_e_3 = 15

// * smaller right arm's rotations
#declare armrot_sr_a_1 = 20 - degrees(hang1)     // arm will always hang down regardless of spine bendings, unless it is set otherwise
#declare armrot_sr_a_2 = -20
#declare armrot_sr_a_3 = 0
#declare armrot_sr_b_1 = 0
#declare armrot_sr_c_1 = 0
#declare armrot_sr_c_2 = -50
#declare armrot_sr_d_1 = 0
// * fingers
#declare armrot_sr_e_1 = -20
#declare armrot_sr_e_2 = -20
#declare armrot_sr_e_3 = 15

// * left leg's rotations
#declare hang2 = hang1+angle_XY_10+angle_XY_11+angle_XY_12+angle_XY_13+angle_XY_14+angle_XY_15+angle_XY_16+angle_XY_17+angle_XY_18+angle_XY_19
#declare legrot_l_a_1 = -40 - degrees(hang2)
#declare legrot_l_b_1 = 105
#declare legrot_l_c_1 = -75
#declare legrot_l_d_1 = 10 - (legrot_l_a_1+legrot_l_b_1+legrot_l_c_1) - degrees(hang2)

// * right leg's rotations
#declare legrot_r_a_1 = -45 - degrees(hang2)
#declare legrot_r_b_1 = 90
#declare legrot_r_c_1 = -75
#declare legrot_r_d_1 = 0 - (legrot_r_a_1+legrot_r_b_1+legrot_r_c_1) - degrees(hang2)

// * rocket launcher's rotations
#declare rocrot1 = 0 - (degrees(hang1 - angle_XY_9))
#declare rocrot2 = 0

#declare laserlight = 0
#declare gunfire = 1
#include "skeleton.inc"
object { bot translate <60, 4, 200> }


// * * * BOT 3 * * *

// * spine movement in XY plane
#declare angle_XY_1 = radians(0)
#declare angle_XY_2 = radians(10)
#declare angle_XY_3 = radians(10)
#declare angle_XY_4 = radians(-10)
#declare angle_XY_5 = radians(-10)
#declare angle_XY_6 = radians(-8)
#declare angle_XY_7 = radians(-8)
#declare angle_XY_8 = radians(-5)
#declare angle_XY_9 = radians(-5)
#declare angle_XY_10 = radians(-2)
#declare angle_XY_11 = radians(-2)
#declare angle_XY_12 = radians(-2)
#declare angle_XY_13 = radians(-2)
#declare angle_XY_14 = radians(0)
#declare angle_XY_15 = radians(0)
#declare angle_XY_16 = radians(0)
#declare angle_XY_17 = radians(0)
#declare angle_XY_18 = radians(0)
#declare angle_XY_19 = radians(0)
#declare angle_XY_20 = radians(0)
#declare angle_XY_21 = radians(5)
#declare angle_XY_22 = radians(5)
#declare angle_XY_23 = radians(5)
#declare angle_XY_24 = radians(5)
#declare angle_XY_25 = radians(3)
#declare angle_XY_26 = radians(3)
#declare angle_XY_27 = radians(2)
#declare angle_XY_28 = radians(2)
#declare angle_XY_29 = radians(1)
#declare angle_XY_30 = radians(1)
#declare angle_XY_31 = radians(1)
#declare angle_XY_32 = radians(0)
#declare angle_XY_33 = radians(0)
#declare angle_XY_34 = radians(0)
#declare angle_XY_35 = radians(0)
#declare angle_XY_36 = radians(0)
#declare angle_XY_37 = radians(0)
#declare angle_XY_38 = radians(0)
#declare angle_XY_39 = radians(0)
#declare angle_XY_40 = radians(0)

// * spine movement in Z-XY plane
#declare angle_Z_1 = radians(0)
#declare angle_Z_2 = radians(0)
#declare angle_Z_3 = radians(0)
#declare angle_Z_4 = radians(0)
#declare angle_Z_5 = radians(0)
#declare angle_Z_6 = radians(0)
#declare angle_Z_7 = radians(0)
#declare angle_Z_8 = radians(0)
#declare angle_Z_9 = radians(0)
#declare angle_Z_10 = radians(0)
#declare angle_Z_11 = radians(0)
#declare angle_Z_12 = radians(0)
#declare angle_Z_13 = radians(0)
#declare angle_Z_14 = radians(0)
#declare angle_Z_15 = radians(0)
#declare angle_Z_16 = radians(0)
#declare angle_Z_17 = radians(0)
#declare angle_Z_18 = radians(0)
#declare angle_Z_19 = radians(0)
#declare angle_Z_20 = radians(0)
#declare angle_Z_21 = radians(0)
#declare angle_Z_22 = radians(0)
#declare angle_Z_23 = radians(0)
#declare angle_Z_24 = radians(0)
#declare angle_Z_25 = radians(0)
#declare angle_Z_26 = radians(0)
#declare angle_Z_27 = radians(0)
#declare angle_Z_28 = radians(0)
#declare angle_Z_29 = radians(0)
#declare angle_Z_30 = radians(0)
#declare angle_Z_31 = radians(0)
#declare angle_Z_32 = radians(0)
#declare angle_Z_33 = radians(0)
#declare angle_Z_34 = radians(0)
#declare angle_Z_35 = radians(0)
#declare angle_Z_36 = radians(0)
#declare angle_Z_37 = radians(0)
#declare angle_Z_38 = radians(0)
#declare angle_Z_39 = radians(0)
#declare angle_Z_40 = radians(0)

// * rotations of each spine element around it's axis
#declare angle_R_1 = radians(0)
#declare angle_R_2 = radians(0)
#declare angle_R_3 = radians(0)
#declare angle_R_4 = radians(0)
#declare angle_R_5 = radians(0)
#declare angle_R_6 = radians(0)
#declare angle_R_7 = radians(0)
#declare angle_R_8 = radians(0)
#declare angle_R_9 = radians(0)
#declare angle_R_10 = radians(0)
#declare angle_R_11 = radians(0)
#declare angle_R_12 = radians(0)
#declare angle_R_13 = radians(0)
#declare angle_R_14 = radians(0)
#declare angle_R_15 = radians(0)
#declare angle_R_16 = radians(0)
#declare angle_R_17 = radians(0)
#declare angle_R_18 = radians(0)
#declare angle_R_19 = radians(0)
#declare angle_R_20 = radians(0)
#declare angle_R_21 = radians(0)
#declare angle_R_22 = radians(0)
#declare angle_R_23 = radians(0)
#declare angle_R_24 = radians(0)
#declare angle_R_25 = radians(0)
#declare angle_R_26 = radians(0)
#declare angle_R_27 = radians(0)
#declare angle_R_28 = radians(0)
#declare angle_R_29 = radians(0)
#declare angle_R_30 = radians(0)
#declare angle_R_31 = radians(0)
#declare angle_R_32 = radians(0)
#declare angle_R_33 = radians(0)
#declare angle_R_34 = radians(0)
#declare angle_R_35 = radians(0)
#declare angle_R_36 = radians(0)
#declare angle_R_37 = radians(0)
#declare angle_R_38 = radians(0)
#declare angle_R_39 = radians(0)
#declare angle_R_40 = radians(0)

// * sizes of spine elements
#declare size1 = 2

// * head's rotations
#declare headrot1 = 0           // X
#declare headrot2 = 0           // Y
#declare headrot3 = 0           // Z

// * bigger left arm's rotations
#declare hang1 = angle_XY_1+angle_XY_2+angle_XY_3+angle_XY_4+angle_XY_5+angle_XY_6+angle_XY_7+angle_XY_8+angle_XY_9
#declare armrot_bl_a_1 = 0 - degrees(hang1)   // Z arm will always hang down regardless of spine bendings, unless it is set otherwise
#declare armrot_bl_a_2 = 20                     // X
#declare armrot_bl_a_3 = 0                     // Y
#declare armrot_bl_b_1 = 0                     // Y
#declare armrot_bl_c_1 = 0                     // Y
#declare armrot_bl_c_2 = -45                     // Z

// * bigger right arm's rotations
#declare armrot_br_a_1 = 0 - degrees(hang1)     // arm will always hang down regardless of spine bendings, unless it is set otherwise
#declare armrot_br_a_2 = -20
#declare armrot_br_a_3 = 0
#declare armrot_br_b_1 = 0
#declare armrot_br_c_1 = 0
#declare armrot_br_c_2 = -90

// * smaller left arm's rotations
#declare armrot_sl_a_1 = 20 - degrees(hang1)     // arm will always hang down regardless of spine bendings, unless it is set otherwise
#declare armrot_sl_a_2 = 20
#declare armrot_sl_a_3 = 0
#declare armrot_sl_b_1 = 0
#declare armrot_sl_c_1 = 0
#declare armrot_sl_c_2 = -50
#declare armrot_sl_d_1 = 0
// * fingers
#declare armrot_sl_e_1 = -20
#declare armrot_sl_e_2 = -20
#declare armrot_sl_e_3 = 15

// * smaller right arm's rotations
#declare armrot_sr_a_1 = 20 - degrees(hang1)     // arm will always hang down regardless of spine bendings, unless it is set otherwise
#declare armrot_sr_a_2 = -20
#declare armrot_sr_a_3 = 0
#declare armrot_sr_b_1 = 0
#declare armrot_sr_c_1 = 0
#declare armrot_sr_c_2 = -50
#declare armrot_sr_d_1 = 0
// * fingers
#declare armrot_sr_e_1 = -20
#declare armrot_sr_e_2 = -20
#declare armrot_sr_e_3 = 15

// * left leg's rotations
#declare hang2 = hang1+angle_XY_10+angle_XY_11+angle_XY_12+angle_XY_13+angle_XY_14+angle_XY_15+angle_XY_16+angle_XY_17+angle_XY_18+angle_XY_19
#declare legrot_l_a_1 = -40 - degrees(hang2)
#declare legrot_l_b_1 = 80
#declare legrot_l_c_1 = -60
#declare legrot_l_d_1 = 0 - (legrot_l_a_1+legrot_l_b_1+legrot_l_c_1) - degrees(hang2)

// * right leg's rotations
#declare legrot_r_a_1 = -60 - degrees(hang2)
#declare legrot_r_b_1 = 90
#declare legrot_r_c_1 = -90
#declare legrot_r_d_1 = 30 - (legrot_r_a_1+legrot_r_b_1+legrot_r_c_1) - degrees(hang2)

// * rocket launcher's rotations
#declare rocrot1 = 0 - (degrees(hang1 - angle_XY_9))
#declare rocrot2 = 0

#declare laserlight = 1
#declare gunfire = 0
#include "skeleton.inc"
object { bot translate <25, 1, 240> }

#end

// ----------- * - * -*--*-*-*-*-*-*-

/*
height_field { gif "mrak2.gif"
    smooth
    texture {
        pigment { gradient y
            pigment_map {
                [ 0.1
                    crackle
                    color_map {
                [ 0 color rgb <0.9, 0.2, 0.1> ]       // <0.6, 0.6, 0>
                [ 0.03 color rgb <0.3, 0.5, 0.5> ]     // <0.5, 0.8, 0>
                [ 0.95 color rgb <0.8, 0.5, 0.2> ]     // <0.6, 0.6, 0.1>
                    }
                    turbulence <0.5, 0.6, 0.3>
                    scale (10/10000)
                ]
                [ 0.4
                    crackle
                    color_map {
                [ 0 color rgb <0.3, 0.3, 0.3> ]       // <0.6, 0.6, 0>
                [ 0.1 color rgb <0.7, 0.7, 0.7> ]     // <0.5, 0.8, 0>
                [ 0.95 color rgb <0.9, 0.9, 1> ]     // <0.6, 0.6, 0.1>
                    }
                    turbulence <0.5, 0.6, 0.3>
                    scale (10/10000)
                ]
            }
        }
        normal { crackle turbulence <0.25, 0.2, 0.3> scale (10/10000) }
    }
    scale <10000, 1000, 10000>
    translate <-100, -10, -3000>
}

height_field { gif "mrak3.gif"
    smooth
    texture {
        pigment { gradient y
            pigment_map {
                [ 0.1
                    crackle
                    color_map {
                [ 0 color rgb <0.9, 0.2, 0.1> ]       // <0.6, 0.6, 0>
                [ 0.03 color rgb <0.3, 0.5, 0.5> ]     // <0.5, 0.8, 0>
                [ 0.95 color rgb <0.8, 0.5, 0.2> ]     // <0.6, 0.6, 0.1>
                    }
                    turbulence <0.5, 0.6, 0.3>
                    scale (10/10000)
                ]
                [ 0.4
                    crackle
                    color_map {
                [ 0 color rgb <0.3, 0.3, 0.3> ]       // <0.6, 0.6, 0>
                [ 0.1 color rgb <0.7, 0.7, 0.7> ]     // <0.5, 0.8, 0>
                [ 0.95 color rgb <0.9, 0.9, 1> ]     // <0.6, 0.6, 0.1>
                    }
                    turbulence <0.5, 0.6, 0.3>
                    scale (10/10000)
                ]
            }
        }
        normal { crackle turbulence <0.25, 0.2, 0.3> scale (10/10000) }
    }
    scale <10000, 1000, 10000>
    translate <-10100, -10, -3000>
}
*/

plane { y, 0
    texture {
        pigment {
            crackle
            color_map {
                [ 0 color rgb <0.9, 0.2, 0.1> ]       // <0.6, 0.6, 0>
                [ 0.03 color rgb <0.3, 0.5, 0.5> ]     // <0.5, 0.8, 0>
                [ 0.95 color rgb <0.8, 0.5, 0.2> ]     // <0.6, 0.6, 0.1>
            }
            turbulence <0.5, 0.6, 0.3>
            scale 10
        }
    }
}
