/*
******************************************************
*        Osmatracnica za Kockasti toranj i zid       *
*               V1.0 za PovRay-3.0                   *
*                                                    *
*                by Dran Draggore                    *
******************************************************
syntax: object { Osmatracnica ...modifiers... }
*/

// *** proizvoljne varijable

#declare visina3 = 8            // visina sredine
#declare broj_br = 10           // broj brana na vrhu
#declare vel_br = 0.42          // relativna velicina pojedine brane
#declare broj_dr = 8            // broj drzaca na dnu
#declare vel_dol = 0.5          // relativna velicina doljnjeg pojedinog dijela


// *** TEXTURE

#declare Kameni_Zid =
texture {
    pigment {
        crackle
        color_map {
            [0 color rgb <0.2, 0.2, 0.3>]
            [1 color rgb <0.5, 0.5, 0.5>]
        }
        turbulence <0.3, 0.2, 0.2>
    }
    normal {
        quilted 0.5
        control0 0
        control1 1
        turbulence <0.3, 0.1, 0.2>
        scale <2, 1.3, 1.3>
    }
    finish {
        phong 0.5 phong_size 40
        brilliance 0.3
    }
}

// *** NEGATIVI

// *** negatvi gornjeg dijela
#declare q_brane =
object {
    union {
        #declare i = 0
        #while ( i < broj_br )
            box { <-vel_br, 0, 0>, <vel_br, 2, -4>  rotate <0, ((180/broj_br)+((360/broj_br)*i)), 0> }
        #declare i = (i+1)
        #end
        cylinder { <0, 2, 0>, <0, -2, 0>, 2 }
    }
}


// *** POZITIVI

// *** pozitiv gornjeg dijela
#declare w_gore =
object {
    difference {
        cylinder { <0, 0, 0>, <0, 3, 0>, 3 }
        object { q_brane  translate <0, 2, 0> }
    }
}

// *** pozitiv srednjeg dijela
#declare w_sredina =
object {
    union {
        cylinder { <0, 0, 0>, <0, visina3, 0>, 3 }
        torus { 3, 0.3  translate <0, visina3, 0> }
    }
}

// *** pozitiv doljnjeg dijela - pojedini
#declare w_dolje1 =
object {
    union {
        box { <-vel_dol, 4, 0>, <vel_dol, 5, -4> }
        difference {
            box { <-vel_dol, 1, 0>, <vel_dol, 4, -4> }
            cylinder { <-5, 1, -4>, <5, 1, -4>, 3 }
        }
    }
}

// *** pozitiv doljnjeg dijela - cijeli
#declare w_doljeS =
object {
    union {
        #declare i = 0
        #while ( i < broj_dr )
            object { w_dolje1  rotate <0, ((360/broj_dr)*i), 0> }
        #declare i = (i+1)
        #end
        sphere { <0, 1, 0>, 1 }
        sphere { <0, 0, 0>, 3  scale <1, 0.5, 1>  translate <0, 5, 0> }
    }
}


// *** FINAL
#declare Osmatracnica =
object {
    union {
        object { w_sredina }
        object { w_gore  translate <0, visina3, 0> }
        object { w_doljeS  translate <0, -5, 0> }
    }
        texture { Kameni_Zid }
}
