/*
******************************************************
*        Okrugli toranj V1.0 za PovRay-3.0           *
*                                                    *
*                by Dran Draggore                    *
******************************************************
syntax: object { Toranj_O  ...modifiers... }
*/

// *** proizvoljne varijable

#declare visina1 = 30        // visina doljnjeg dijela tornja
#declare br_ud = 24         // broj udubina na srednjem dijelu
#declare rad_ud = 0.5         // relativna velicina udubina
#declare br_st = 12          // broj drvenih stangi
#declare br_br = 16         // broj brana na vrhu tornja
#declare rad_br = 1.5         // relativna velicina brana na vrhu tornja
#declare pr_x = 1           // sirina prozora
#declare pr_y = 6           // visina prozora


// *** TEXTURE

// *** textura cijelog tornja
#declare Kameni_Zid =
texture {
    pigment {
        crackle
        color_map {
            [0 color rgb <0.2, 0.2, 0.3>]
            [1 color rgb <0.5, 0.5, 0.5>]
        }
        turbulence <0.3, 0.2, 0.2>
    }
    normal {
        quilted 1
        control0 0
        control1 1
        turbulence <0.3, 0.1, 0.2>
        scale <3, 1.5, 1.5>
    }
    finish {
        phong 0.5 phong_size 40
        brilliance 0.3
    }
}

// *** textura drvenih stangi
#declare Drvo =
texture {
    pigment { color rgb <0.2, 0.2, 0.2> }
    finish {
        phong 1 phong_size 80
        reflection 1
    }
}


// *** NEGATIVI

// *** pozitiv brane
#declare brana =
object {
    intersection {
        cylinder { <-(rad_br/2), 0, 0.5>, <-(rad_br/2), 0, -1.5>, rad_br }
        cylinder { <(rad_br/2), 0, 0.5>, <(rad_br/2), 0, -1.5>, rad_br }
    }
}

// *** negativ krune na vrhu tornja
#declare n_kruna =
object {
    union {
        difference {
            cylinder { <0, 0, 0>, <0, 3, 0>, 7 }
            union {
                #declare i = 0
                #while ( i < br_br )
                    object { brana  translate <0, 0, -5>  rotate <0, ((360/br_br)*i), 0> }
                #declare i = (i+1)
                #end
            }

        }
        cylinder { <0, -2, 0>, <0, 2, 0>, 5 }
    }
}

// *** negativ srednjeg dijela
#declare n_sredina =
object {
    union {
        #declare i = 0
        #while ( i < br_ud )
            cylinder { <0, 0, -0.2>, <0, 0, 2>, rad_ud
                scale <1, 2, 1>  translate <0, 0, 5>  rotate <0, ((360/br_ud)*i), 0> }
        #declare i = (i+1)
        #end
        torus { 6, 1 }
    }
}

// *** negativ prozora
#declare n_prozor =
object {
    union {
        difference {
            box { <-2, -2, 0>, <2, 2, 1> }
            union {
                box { <-2, -2, 0>, <0, 2, 2>  rotate <0, 45, 0>  translate <-2, 0, 0> }
                box { <-2, -2, 0>, <0, 2, 2>  rotate <0, 45, 0>  rotate <0, 0, 90>  translate <0, -2, 0> }
                box { <-2, -2, 0>, <0, 2, 2>  rotate <0, 45, 0>  rotate <0, 0, 180>  translate <2, 0, 0> }
                box { <-2, -2, 0>, <0, 2, 2>  rotate <0, 45, 0>  rotate <0, 0, 270>  translate <0, 2, 0> }
            }
        }
        box { <-1, -1, 1>, <1, 1, 3> }
    }
    scale <(pr_x/4), (pr_y/4), 1>
}


// *** POZITIVI

// *** gornji dio
#declare gornji_dio =
object {
    difference {
        cylinder { <0, 0, 0>, <0, 5.5, 0>, 6 }
        object { n_kruna  translate <0, 3, 0> }
    }
}

// *** srednji dio
#declare srednji_dio =
object {
    difference {
        cylinder { <0, 0, 0>, <0, 2, 0>, 6 }
        object { n_sredina  scale <1, 2, 1> }
    }
}

// *** doljnji dio
#declare doljnji_dio =
object {
    union {
        difference {
            difference {
                cylinder { <0, 0, 0>, <0, visina1, 0>, 5 }
                cylinder { <0, 0, 0>, <0, visina1, 0>, 4 }
            }
            union {
                    object { n_prozor  translate <0, (visina1-8), -5>  rotate <0, 0, 0> }
                    object { n_prozor  translate <0, (visina1-8), -5>  rotate <0, 90, 0> }
                    object { n_prozor  translate <0, (visina1-8), -5>  rotate <0, 180, 0> }
                    object { n_prozor  translate <0, (visina1-8), -5>  rotate <0, 270, 0> }
             }
        }
        torus { 5, 0.2  translate <0, (visina1-0.2), 0> }
    }
}


// *** FINAL -- cijeli toranj sa drvljem
#declare Toranj_O =
object {
    union {
        object { union {
            object { doljnji_dio }
            object { srednji_dio  translate <0, visina1, 0> }
            object { gornji_dio  translate <0, (visina1+2), 0> }
            }
            texture { Kameni_Zid }
        }
        object { union {
            #declare i = 0
            #while ( i < br_st )
                cylinder { <0, 0, 0.5>, <0, 0, -1>, 0.3  translate <0, (visina1+2.9), -6>  rotate <0, ((360/br_st)*i), 0> }
            #declare i = (i+1)
            #end
            }
            texture { Drvo }
        }
    }
}
