/*
******************************************************
*                 Kockasti toranj                    *
*                        i                           *
*          Kockasti toranj s osmatracnicom           *
*               V1.0 za PovRay-3.0                   *
*                                                    *
*                by Dran Draggore                    *
******************************************************
syntax: object { Toranj_K ...modifiers... }
syntax: object { Toranj_Kplus ...modifiers... }
*/

#include "osmatrac.inc"     // include osmatracnicu

// *** proizvoljne varijable

#declare visina2 = 30        // visina doljnjeg dijela tornja
#declare ur_rad = 0.5        // relativna velicina udubina u srednjem dijelu
#declare pr_x = 1           // sirina prozora
#declare pr_y = 6           // visina prozora


// *** TEXTURE

// *** textura cijelog tornja
#declare Kameni_Zid =
texture {
    pigment {
        crackle
        color_map {
            [0 color rgb <0.2, 0.2, 0.3>]
            [1 color rgb <0.5, 0.5, 0.5>]
        }
        turbulence <0.3, 0.2, 0.2>
    }
    normal {
        quilted 0.5
        control0 0
        control1 1
        turbulence <0.3, 0.1, 0.2>
        scale <2, 1.3, 1.3>
    }
    finish {
        phong 0.5 phong_size 40
        brilliance 0.3
    }
}

// *** textura drvenih stangi
#declare Drvo =
texture {
    pigment { color rgb <0.2, 0.2, 0.2> }
    finish {
        phong 1 phong_size 80
        reflection 1
    }
}

// *** NEGATIVI

// *** negativ srednjeg dijela
#declare m_sredina =
object {
    union {
        #declare i = 0
        #while ( i < 4 )
            cylinder { <-8, 0, -6>, <8, 0, -6>, 1  rotate <0, (90*i), 0> }
            #declare j = 0
            #while ( j < 5 )
                cylinder { <0, 0, 0.2>, <0, 0, -2>, ur_rad  scale <1, 2, 1> translate <(-4+(j*2)), 0, 7>
                    rotate <0, (90*i), 0> }
            #declare j = (j+1)
            #end
        #declare i = (i+1)
        #end
    }
    scale <1, 2, 1>
}

// *** negativ udubine prozora
#declare n_prozor =
object {
    union {
        difference {
            box { <-2, -2, -1>, <2, 2, 1> }
            union {
                box { <-2, -2, 0>, <0, 2, 2>  rotate <0, 45, 0>  translate <-2, 0, 0> }
                box { <-2, -2, 0>, <0, 2, 2>  rotate <0, 45, 0>  rotate <0, 0, 90>  translate <0, -2, 0> }
                box { <-2, -2, 0>, <0, 2, 2>  rotate <0, 45, 0>  rotate <0, 0, 180>  translate <2, 0, 0> }
                box { <-2, -2, 0>, <0, 2, 2>  rotate <0, 45, 0>  rotate <0, 0, 270>  translate <0, 2, 0> }
            }
        }
        box { <-1, -1, 1>, <1, 1, 3> }
    }
    scale <(pr_x/4), (pr_y/4), 1>
}


// *** POZITIVI

// *** pozitiv gornjeg dijela
#declare p_gore =
object {
    difference {
        union {
            box { <-6, 0, -6>, <6, 3, 6> }
            #declare i = 0
            #while ( i < 2 )
                #declare j = 0
                #while ( j < 4 )
                    box { <-6, 3, -6>, <-4.5, 4.5, -4.5>
                        translate <(j*3), 0, 0>  rotate <0, (180*i), 0> }
                #declare j = (j+1)
                #end
            #declare i = (i+1)
            #end
            #declare i = 0
            #while ( i < 2 )
                #declare j = 0
                #while ( j < 4 )
                    box { <-6, 3, -6>, <-4.5, 4.5, -4.5>
                        translate <(1.5+(j*3)), 0, 0>  rotate <0, (90+(180*i)), 0> }
                #declare j = (j+1)
                #end
            #declare i = (i+1)
            #end
        }
        box { <-5, 1, -5>, <5, 6, 5> }
    }
}

// *** pozitiv srednjeg dijela
#declare p_sredina =
object {
    difference {
        box { <-6, 0, -6>, <6, 2, 6> }
        object { m_sredina }
    }
}

// *** pozitiv necega ispod prozora
#declare p_nesto =
object {
    difference {
        box { <-1, 0, -1>, <1, 3, 0> }
        union {
            cylinder { <0, 0, 0.1>, <0, 0, -2>, 0.1  scale <9, 28, 1>  translate <-1, 0, 0> }
            cylinder { <0, 0, 0.1>, <0, 0, -2>, 0.1  scale <9, 28, 1>  translate <1, 0, 0> }
            cylinder { <-2, 0, 0>, <2, 0, 0>, 0.1  scale <1, 28, 9>  translate <0, 0, -1> }
        }
    }
}

// *** pozitiv doljnjeg dijela
#declare p_dolje =
object {
    union {
        difference {
            box { <-5, 0, -5>, <5, visina2, 5> }
            union {
                box { <-4, 0, -4>, <4, visina2, 4> }
                #declare i = 0
                #while ( i < 4 )
                    object { n_prozor  translate <0, (visina2-8), -5>  rotate <0, (90*i), 0> }
                #declare i = (i+1)
                #end
            }
        }
        #declare i = 0
        #while ( i < 4 )
            cylinder { <-5.2, -0.2, -5>, <5.2, -0.2, -5>, 0.2  translate <0, (visina2-0), 0>  rotate <0, (90*i), 0> }
        #declare i = (i+1)
        #end
    }
}


// *** FINAL -- cijeli toranj, plus drvlje
#declare Toranj_K =
object {
    union {
        object { union {
            object { p_gore  translate <0, (visina2+2), 0> }
            object { p_sredina  translate <0, visina2, 0> }
            object { p_dolje }
            }
            texture { Kameni_Zid }
        }
        object { union {
            #declare i = 0
            #while ( i < 4 )
                #declare j = 0
                #while ( j < 3 )
                    cylinder { <-4, 0, -6>, <-4, 0, -7>, 0.3  translate <(j*4), (visina2+3), 0>  rotate <0, (90*i), 0> }
                #declare j = (j+1)
                #end
            #declare i = (i+1)
            #end
            }
            texture { Drvo }
        }
    }
}

// *** FINAL -- cijeli toranj, plus drvlje, plus osmatracnica
#declare Toranj_Kplus =
object {
    union {
        object { Toranj_K }
        object { Osmatracnica  translate <5, visina2, -5> }
    }
}
