/*
******************************************************
*             Zid V1.0 za PovRay-3.0                 *
*                                                    *
*                by Dran Draggore                    *
******************************************************
syntax: object { Zid  ...modifiers... }
syntax: object { Zid_O  ...modifiers... }
*/

#include "osmatrac.inc"

// *** proizvoljne varijable
#declare visina4 = 23       // visina zida
#declare s_b = 0.5          // relativna velicina brana
#declare s_u = 0.5          // relativna velicina udubina
#declare pr_x = 1           // sirina prozora
#declare pr_y = 6           // visina prozora


// *** TEXTURE

// *** textura cijelog tornja
/* #declare Kameni_Zid =
texture {
    T_Grnt9  scale 5
}
*/


// *** NEGATIVI

// *** negativ prozora
#declare prozor =
object {
    union {
        difference {
            box { <-2, -2, -1>, <2, 2, 1> }
            union {
                box { <-2, -2, 0>, <0, 2, 2>  rotate <0, 45, 0>  translate <-2, 0, 0> }
                box { <-2, -2, 0>, <0, 2, 2>  rotate <0, 45, 0>  rotate <0, 0, 90>  translate <0, -2, 0> }
                box { <-2, -2, 0>, <0, 2, 2>  rotate <0, 45, 0>  rotate <0, 0, 180>  translate <2, 0, 0> }
                box { <-2, -2, 0>, <0, 2, 2>  rotate <0, 45, 0>  rotate <0, 0, 270>  translate <0, 2, 0> }
            }
        }
        box { <-1, -1, 1>, <1, 1, 3> }
    }
    scale <(pr_x/4), (pr_y/4), 1>
}

// *** negativ udubina na sredini
#declare d_sredina =
object {
    union {
            cylinder { <-4, 0, -1>, <4, 0, -1>, 1 }
            #declare i = 0
            #while ( i < 3 )
                cylinder { <0, 0, 0.2>, <0, 0, -2>, s_u  scale <1, 2, 1> translate <(-2+(i*2)), 0, 0> }
            #declare i = (i+1)
            #end
    }
    scale <1, 2, 1>
}


// *** POZITIVI

// *** pozitiv gornjeg dijela
#declare z_gore =
object {
    union {
        box { <-3, 0, -1>, <3, 3, 0.5> }
        box { <-3, 4.5, -1>, <-1.5, 3, 0.5> }
        box { <0, 4.5, -1>, <1.5, 3, 0.5> }
        box { <-3, 0, 0>, <3, 1, 5> }
    }
}

// *** pozitiv sredine
#declare z_sred =
object {
    difference {
        box { <-3, 0, -1>, <3, 2, 5> }
        object { d_sredina }
    }
}

// *** pozitiv doljnjeg dijela
#declare z_dolje =
object {
    union {
        difference {
            box { <-3, 0, 0>, <3, visina4, 5> }
            union {
                box { <-2, 0, 1>, <2, (visina4-2), 4> }
                object { prozor  translate <0, (visina4-8), 0> }
            }
        }
        cylinder { <-3, (visina4-0.2), 0>, <3, (visina4-0.2), 0>, 0.2 }
    }
}


// *** FINAL
#declare Zid =
object {
    union {
        object { z_gore  translate <0, visina4+2, 0> }
        object { z_sred  translate <0, visina4, 0> }
        object { z_dolje }
    }
    texture { Kameni_Zid }
}

#declare Zid_O =
object {
    union {
        object { Zid  translate <-3, 0, 0> }
        object { Zid  translate <3, 0, 0> }
        object { Osmatracnica  translate <0, visina4, 0> }
    }
    texture { Kameni_Zid }
}



