// Persistence of Vision Raytracer
// Shape Test file

#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"

camera {
   location <0.0, 3,  10.0>
   //direction <0.0, 1.0,  0.0>
  // up  <0.0,  0.0,  1.0>
   //right <1.33333, 0.0, 0.0>
   look_at <0,0,0>

}
light_source { <0,100,0> color White }
light_source { < 0, 0, 100 > color White }
//HEAD
#declare Head =
sphere
   {
   0,4
   pigment { NavyBlue }
   texture { Spun_Brass scale .2 }
   }
//HORNS
#declare Horns = difference {
 torus { 2,.3
   texture { Chrome_Metal }
   //pigment { White }
       }
 sphere {
   < 0,0,1.143>1.5
   }
}

//EYES
#declare Eye = merge {
  sphere
     {
     <0,0,0>1
     hollow
     pigment { White }
     }
  sphere
     {
     <0,0,.72>.35
    pigment { rgbf <1,0,0,.385> }
    scale <2,2,1>
     }
 sphere { <0,0,1>.1 pigment { Black } scale <1,4,1> }
 finish { Glass_Finish }
 }
//mouth
#declare Mouth = difference {
 torus { 2,.3
   texture { Chrome_Metal }
   //pigment { White }
       }
 sphere {
   < 0,0,1.43>1
   }
}
//BODY
//arms
//legs
//wings



object {  Eye  translate <0,2.3,0> } 
object {  Eye  translate <2,0,-1.30> }
object {  Eye  translate <-2,0,-1.30> }
object {  Mouth translate <0,-2.3,0> }
object {  Mouth scale .83 translate <0,-2.3,-.20> }
object {  Mouth scale .63 translate <0,-2.3,-.40> }
object {  Head scale <1,1,.5> translate <0,0,-3.1> }
object {  Horns scale 1.3 rotate x*-90 translate <0,2.3,-2.0> }


sky_sphere
  {
  pigment
    {
    gradient y
    color_map
      {
         [ 0 color Red ]
         [0.5 color Violet]
         [ 1 color Blue ]
      }
    scale 1.2
    translate -1
    rotate x*20
    }
  }

#declare Brick_Texture = texture
	{
	pigment 
		{
         brick Gray70, Tan
      }
    	normal 
		{
        	brick 0.75
      }
    	finish 
		{
        	crand 0.003
        	diffuse 0.6 ambient 0.20
      }
      scale <0.001, 0.001, 0.005>
    	translate <0.25, 0.30, 0.25>
	}

                         

text
     {
     ttf
     "gizmo.ttf",
     "Mutins:", 2, 0
     texture
          {
          Orange_Glass
          }
     scale <1, 1, .031>
     translate <-4.85,3.85,3>
     rotate y*140
     }
text
     {
     ttf
     "gizmo.ttf",
     "  Our Hero", 1, 0
     texture
          {
          Green_Glass
          }
     scale <1.32, 1.32, .31>
     translate <-4.5,-5.5,1>
     rotate y*180
     }
text
     {
     ttf
     "gizmo.ttf",
     " Returns!", 1, 0
     texture
          {
          Green_Glass
          }
     scale <1.72, 1.72, .31>
     translate <-5.2,-6.3,0>
     rotate y*180
     }
