// new02k.pov   gjpateman   11/11/95  alias: Planet Nursery
// planet located at <0,2,0> in sphere w/radius=1
// hut has radius=8 outside and 7.6 inside

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "planet.inc"
#include "portacam.inc"

#default{finish{ambient .4 diffuse 1}}

#declare PinkAlab = // modified from original in TEXTURES.INC
texture{
  pigment{bozo turbulence .2
    color_map{
      [0, 1 color red .9 green .75 blue .75 
             color red .6 green .6 blue .6]
    }
    scale .5
  }
  finish{ambient .25} // was .3
}
texture{
  pigment{granite
    color_map{
      [0, .9 color DustyRose filter 1 color DustyRose filter .5]
      [.9, 1 color DarkSlateGray color DarkSlateGray]
    }
    scale 2
  }
  finish{
    specular 1 roughness .001 phong .25 phong_size 75
    brilliance 4  ambient .25 // was .3
  }
}

#declare Tex1 = texture{PinkAlab scale .35}
#declare Tex2 = texture{Sapphire_Agate scale .35}

#declare d = 12
#declare r = 8

#declare Window =
intersection{
  sphere{<0,0,0>,r + 1} // bounding shape
  plane{y,0}
  plane{y,1 rotate x * 100} 
  plane{y,1 rotate x * -100}
  box{<-10,-10,-.1>,<10,1,.1> inverse} // vertical column
  box{<-10,-2.0,-1>,<10,-1.9,1> inverse} // horizontal col.
  box{<-10,-1.6,-1>,<10,-1.5,1> inverse} //     "        "
  box{<-10,-1.2,-1>,<10,-1.1,1> inverse} //     "        "
}

#declare Foot =
intersection{
  box{<-.6,-.4,-1>,<.6,1.6,1>}
  cylinder{<-1,.6,1>,<1,.6, 1>,.5 inverse}
  cylinder{<-1,.6,-1>,<1,.6,-1>,.5 inverse}
  cylinder{<-.6,.6,1>,<-.6,.6,-1>,.5 inverse}
  cylinder{<.6,.6,1>,<.6,.6,-1>,.5 inverse}
  plane{y,.6}
  plane{y,0 inverse}

  // holes
  box{<-.04,.2,-2>,<.04,.45,2> inverse}
  box{<-2,.2,-.04>,<2,.45,.04> inverse}
  box{<-2,.2,-.16>,<2,.45,-.24> inverse}
  box{<-2,.2,-.36>,<2,.45,-.44> inverse}
  box{<-2,.2,-.04>,<2,.45,.04> inverse}
  box{<-2,.2,.16>,<2,.45,.24> inverse}
  box{<-2,.2,.36>,<2,.45,.44> inverse}
  texture{Tex1}
  scale<2.5,1.2,1.2>
}

#declare Structure =
union{
  // upper rings: major radius = x = r * cos(angle), y = r * sin(angle)
  torus{r * .5,.2 translate y * r * .866025} // 60 deg
  torus{r * .64278,.2 translate y * r * .766044} // 50 deg
  intersection{
    // main dome .4 units thick
    sphere{<0,0,0>,r}
    sphere{<0,0,0>,r - .4 inverse}
    // cut out arches
    sphere{<d,0,0>,r inverse}
    sphere{<-d,0,0>,r inverse}  
    sphere{<0,0,d>,r inverse}  
    sphere{<0,0,-d>,r inverse}  
    // cut out windows
    object{Window inverse rotate z * 40 rotate y * 45}
    object{Window inverse rotate z * 40 rotate y * -45}
    object{Window inverse rotate z * -40 rotate y * 45}
    object{Window inverse rotate z * -40 rotate y * -45}
  }
  // vertical rings
  torus{r,.05 rotate x * 90 rotate y * 45}
  torus{r,.05 rotate x * 90 rotate y * -45}
  object{Foot translate x * (r - .2) rotate y * 45}
  object{Foot translate x * (r - .2) rotate y * 135}
  object{Foot translate x * (r - .2) rotate y * 225}
  object{Foot translate x * (r - .2) rotate y * 315}
}

#declare SpotLamp =
light_source{<0,7.1,0> color red 1 green .698039 blue .296078 // gold
  spotlight point_at<0,1,0> tightness 50 radius 15 falloff 25 
}

#declare CenterPiece = // sphere containing globe & support structure
union{
  object{Planet scale .3}
  intersection{
    sphere{<0,0,0>,.99 pigment{Clear} inverse} // hollows union
    union{
      sphere{<0,0,0>,1 texture{Glass3}} // outer wall
      intersection{
        cone{<0,0,0>,0,<0,-6,0>,6}
        cone{<0,0,0>,0,<4.24,-4.24,0>,.5 inverse}
        cone{<0,0,0>,0,<4.24,-4.24,0>,.5 inverse rotate y * 30}
        cone{<0,0,0>,0,<4.24,-4.24,0>,.5 inverse rotate y * 60}
        cone{<0,0,0>,0,<4.24,-4.24,0>,.5 inverse rotate y * 90}
        cone{<0,0,0>,0,<4.24,-4.24,0>,.5 inverse rotate y * 120}
        cone{<0,0,0>,0,<4.24,-4.24,0>,.5 inverse rotate y * 150}
        cone{<0,0,0>,0,<4.24,-4.24,0>,.5 inverse rotate y * 180}
        cone{<0,0,0>,0,<4.24,-4.24,0>,.5 inverse rotate y * 210}
        cone{<0,0,0>,0,<4.24,-4.24,0>,.5 inverse rotate y * 240}
        cone{<0,0,0>,0,<4.24,-4.24,0>,.5 inverse rotate y * 270}
        cone{<0,0,0>,0,<4.24,-4.24,0>,.5 inverse rotate y * 300}
        cone{<0,0,0>,0,<4.24,-4.24,0>,.5 inverse rotate y * 330}
        torus{ 1.50, .05 translate y * -1.5 inverse}
        torus{ 1.25, .05 translate y * -1.25 inverse}
        torus{ 1.00, .05 translate y * -1 inverse}
        torus{ 0.75, .05 translate y * -.75 inverse}
      }
    }
  }
  intersection{ // tubes running from the sphere to the ground
    sphere{<0,0,0>,1 pigment{Clear} inverse} // clips tops
    union{
      cone{<0,0,0>,0,<6,-6,0>,.2 rotate y * 30}
      cone{<0,0,0>,0,<6,-6,0>,.2 rotate y * 60}
      cone{<0,0,0>,0,<6,-6,0>,.2 rotate y * 90}
      cone{<0,0,0>,0,<6,-6,0>,.2 rotate y * 120}
      cone{<0,0,0>,0,<6,-6,0>,.2 rotate y * 150}
      cone{<0,0,0>,0,<6,-6,0>,.2 rotate y * 180}
      cone{<0,0,0>,0,<6,-6,0>,.2 rotate y * 210}
      cone{<0,0,0>,0,<6,-6,0>,.2 rotate y * 240}
      cone{<0,0,0>,0,<6,-6,0>,.2 rotate y * 270}
      cone{<0,0,0>,0,<6,-6,0>,.2 rotate y * 300}
      cone{<0,0,0>,0,<6,-6,0>,.2 rotate y * 330}
    }
  }
  sphere{<0,0,0>,1 texture{Glass3}} // outer wall
  translate y * 2
}

#declare Base =
union{
  cone{<0,-6,0>,20,<0,.2,0>, 12} 
  //cone{<0,0,0>,9,<0,.2,0>, 9} 
  // pairs of concentric rings raised slightly from the floor's surface
  torus{3.,.05 translate y * .154}
  torus{3.1,.05 translate y * .154}
  torus{5.,.05 translate y * .154}
  torus{5.1,.05 translate y * .154}
  torus{7.,.05 translate y * .154}
  torus{7.1,.05 translate y * .154}
}

#declare Hut =
union{
  object{SpotLamp}
  object{Structure texture{Tex1}}
  object{CenterPiece texture{Tex1} }
  object{Base texture{Tex1}}
}

light_source{<-4000,200,-1500> color White} // sun

plane{y,-1 texture{Stone18 scale 32 finish{reflection .2}}} // floor
plane{y,500 texture{ Blue_Sky3 scale 10000} } // sky

object{Hut rotate y * -10 }

object{Hut rotate y * 40 translate z * 60 rotate y * -25}
object{Hut rotate y * 15 translate z * 120 rotate y * 30}
object{Hut rotate y * 30 translate z * 180 rotate y * -5}
object{Hut rotate y * 30 translate z * 200 rotate y * 20}

object{ Portacam scale .2 translate x * -2 
  rotate z * -15 rotate y * 20 translate y * 2 }

object{ Portacam scale .2 translate x * -2 
  rotate z * -20 rotate y * -130 translate y * 2 }

object{ Portacam scale .2 translate x * -2 
  rotate z * 15 rotate y * -35 translate y * 2 }

fog{color Gray20 distance 5000}

camera{right<4/3,0,0>
  up<0,1,0> 
  
  direction<0,0,2>
  location<0,1.5,-11>
  look_at<0,1.5,0>
  rotate y * -15

//  direction<0,0,1>  view1.tga
//  location<0,2,-4>  view1.tga
//  look_at<0,2.0,0>  view1.tga
//  rotate y * 20     view1.tga

}

