// portacam.inc - a video camera for the STAINxx.POV proj.
// Main .POV file should include COLORS.INC & TEXTURES.INC before this file
// Uncomment the Panel (see the last line) ONLY when the back of the 
//   Portacam is visible: it significantly increases rendering time!

#declare Pushbutton = // square, raised w/square washer & spher. indentation
union{
  intersection{
    plane{z,0}
    plane{z,-.25 inverse}
    plane{x, 1 rotate y * 45}
    plane{x,-1 inverse rotate y * -45}
    plane{y, 1 rotate x * -45}
    plane{y,-1 inverse rotate x * 45}
    sphere{<0,0,-5>,4.85 inverse}
  }
  box{<-1.5,-1.5,-.1>,<1.5, 1.5,.1> pigment{Gray40}}
  pigment{Gray90} finish{Shiny}
}

#declare Pushbutton2 = // simple, round, chrome, push on/off type
union{
  intersection{
    cylinder{<0,0,.2>,<0,0,0>,1}
    cylinder{<0,0,1>,<0,0,-1>,.8 inverse pigment{Black}}
  }
  cylinder{<0,0,.2>,<0,0,-.2>,.7}
  texture{Chrome_Metal}
  scale .025
  translate z * -.01
}

#declare LedOnFin = finish{ambient .95 diffuse .51 phong 1 phong_size 20}
#declare LedOffFin = finish{ambient .05 diffuse .05 phong 1 phong_size 20}

#declare LEDrad = .025
#declare RoundLedRedOn = 
union{
  sphere{<0,0,0>,LEDrad pigment{Red} finish{LedOnFin}}
  torus{LEDrad,.01 rotate x * 90 pigment{Black} finish{Shiny}}
  scale<1,1,.15>
}

#declare RoundLedRedOff = 
union{
  sphere{<0,0,0>,LEDrad pigment{Red} finish{LedOffFin}}
  torus{LEDrad,.01 rotate x * 90 pigment{Black} finish{Shiny}}
  scale<1,1,.15>
}

#declare RoundLedBlueOn = 
union{
  sphere{<0,0,0>,LEDrad pigment{Blue} finish{LedOnFin}}
  torus{LEDrad,.01 rotate x * 90 pigment{Black} finish{Shiny}}
  scale<1,1,.15>
}

#declare RoundLedBlueOff = 
union{
  sphere{<0,0,0>,LEDrad pigment{Blue} finish{LedOffFin}}
  torus{LEDrad,.01 rotate x * 90 pigment{Black} finish{Shiny}}
  scale<1,1,.15>
}

#declare RLhigh = .05

#declare RectLedRedOn =
box{<-.1,-.035,-RLhigh>,<.1,.035,RLhigh> pigment{Red} finish{LedOnFin}}

#declare RectLedRedOff =
box{<-.1,-.035,-RLhigh>,<.1,.035,RLhigh> pigment{Red} finish{LedOffFin}}

#declare RectLedGreenOn =
box{<-.1,-.035,-RLhigh>,<.1,.035,RLhigh> pigment{Green} finish{LedOnFin}}

#declare RectLedGreenOff =
box{<-.1,-.035,-RLhigh>,<.1,.035,RLhigh> pigment{Green} finish{LedOffFin}}

#declare RectLedOrangeOn =
box{<-.1,-.035,-RLhigh>,<.1,.035,RLhigh> pigment{Orange} finish{LedOnFin}}

#declare RectLedOrangeOff =
box{<-.1,-.035,-RLhigh>,<.1,.035,RLhigh> pigment{Orange} finish{LedOffFin}}


#declare LEDBarGreen =
union{
  box{<-.14,-.775,0>,<.14,.775,.1> pigment{Gray20}}
  object{RectLedGreenOff translate y * .7}
  object{RectLedGreenOn translate y * .6}
  object{RectLedGreenOn translate y * .5}
  object{RectLedGreenOn translate y * .4}
  object{RectLedGreenOn translate y * .3}
  object{RectLedGreenOn translate y * .2}
  object{RectLedGreenOn translate y * .1}
  object{RectLedGreenOn}
  object{RectLedGreenOn translate y * -.1}
  object{RectLedGreenOn translate y * -.2}
  object{RectLedGreenOn translate y * -.3}
  object{RectLedGreenOn translate y * -.4}
  object{RectLedGreenOn translate y * -.5}
  object{RectLedGreenOn translate y * -.6}
  object{RectLedGreenOn translate y * -.7}
  translate z * -.01
}

#declare LEDBarRed =
union{
  box{<-.14,-.775,0>,<.14,.775,.1> pigment{Gray20}}
  object{RectLedRedOff translate y * .7}
  object{RectLedRedOff translate y * .6}
  object{RectLedRedOff translate y * .5}
  object{RectLedRedOff translate y * .4}
  object{RectLedRedOff translate y * .3}
  object{RectLedRedOff translate y * .2}
  object{RectLedRedOn translate y * .1}
  object{RectLedRedOn}
  object{RectLedRedOn translate y * -.1}
  object{RectLedRedOn translate y * -.2}
  object{RectLedRedOn translate y * -.3}
  object{RectLedRedOn translate y * -.4}
  object{RectLedRedOn translate y * -.5}
  object{RectLedRedOn translate y * -.6}
  object{RectLedRedOn translate y * -.7}
  translate z * -.01
}

#declare LEDBarOrange =
union{
  box{<-.14,-.775,0>,<.14,.775,.1> pigment{Gray20}}
  object{RectLedOrangeOff translate y * .7}
  object{RectLedOrangeOff translate y * .6}
  object{RectLedOrangeOff translate y * .5}
  object{RectLedOrangeOn translate y * .4}
  object{RectLedOrangeOn translate y * .3}
  object{RectLedOrangeOn translate y * .2}
  object{RectLedOrangeOn translate y * .1}
  object{RectLedOrangeOn}
  object{RectLedOrangeOn translate y * -.1}
  object{RectLedOrangeOn translate y * -.2}
  object{RectLedOrangeOn translate y * -.3}
  object{RectLedOrangeOn translate y * -.4}
  object{RectLedOrangeOn translate y * -.5}
  object{RectLedOrangeOn translate y * -.6}
  object{RectLedOrangeOn translate y * -.7}
  translate z * -.01
}

#declare Panel =
union{
  box{<-2,-1,0>,<2,1,.2> // main panel plane
    pigment{Gray10}
  } 
  object{Pushbutton2 translate<-1.6,.7,0>}
  object{Pushbutton2 translate<-1.4,.7,0>}
  object{Pushbutton2 translate<-1.2,.7,0>}
  object{Pushbutton2 translate<-1.0,.7,0>}

  object{Pushbutton2 translate<-1.6,.6,0>}
  object{Pushbutton2 translate<-1.4,.6,0>}
  object{Pushbutton2 translate<-1.2,.6,0>}
  object{Pushbutton2 translate<-1.0,.6,0>}

  object{RoundLedRedOn  translate<-1.6,.45,0>}
  object{RoundLedBlueOn translate<-1.4,.45,0>}
  object{RoundLedRedOff translate<-1.2,.45,0>}
  object{RoundLedBlueOn translate<-1.0,.45,0>}
          
  object{Pushbutton2 translate<-1.6,-.6,0>}
  object{Pushbutton2 translate<-1.4,-.6,0>}
  object{Pushbutton2 translate<-1.2,-.6,0>}
  object{Pushbutton2 translate<-1.0,-.6,0>}

  object{LEDBarGreen translate<-.6,0,0>}
  object{LEDBarGreen translate<-.3,0,0>}
  object{LEDBarOrange translate<0,0,0>}
  object{LEDBarRed translate<.3,0,0>}
  object{LEDBarRed translate<.6,0,0>}

  object{Pushbutton scale .05 translate<-1,.30,0>}
  object{Pushbutton scale .05 translate<-1,.15,0>}
  object{Pushbutton scale .05 translate<-1,0,0>}
  object{Pushbutton scale .05 translate<-1,-.15,0>}
  object{Pushbutton scale .05 translate<-1,-.30,0>}

  object{Pushbutton scale .05 translate<-1.2,.30,0>}
  object{Pushbutton scale .05 translate<-1.2,.15,0>}
  object{Pushbutton scale .05 translate<-1.2,0,0>}
  object{Pushbutton scale .05 translate<-1.2,-.15,0>}
  object{Pushbutton scale .05 translate<-1.2,-.30,0>}
  
  object{Pushbutton scale .05 translate<-1.4,.30,0>}
  object{Pushbutton scale .05 translate<-1.4,.15,0>}
  object{Pushbutton scale .05 translate<-1.4,0,0>}
  object{Pushbutton scale .05 translate<-1.4,-.15,0>}
  object{Pushbutton scale .05 translate<-1.4,-.30,0>}

  object{Pushbutton scale .05 translate<-1.6,.30,0>}
  object{Pushbutton scale .05 translate<-1.6,.15,0>}
  object{Pushbutton scale .05 translate<-1.6,0,0>}
  object{Pushbutton scale .05 translate<-1.6,-.15,0>}
  object{Pushbutton scale .05 translate<-1.6,-.30,0>}

  object{RoundLedRedOff translate<1.5,.6,0>}
  object{RoundLedRedOn translate<1.5,.4,0>}
  object{RoundLedRedOn translate<1.5,.2,0>}
  object{RoundLedRedOn translate<1.5,0,0>}
  object{RoundLedRedOn translate<1.5,-.2,0>}
  object{RoundLedRedOff translate<1.5,-.4,0>}
  object{RoundLedRedOn translate<1.5,-.6,0>}

  object{RoundLedRedOn translate<1.7,.6,0>}
  object{RoundLedRedOff translate<1.7,.4,0>}
  object{RoundLedRedOff translate<1.7,.2,0>}
  object{RoundLedRedOn translate<1.7,0,0>}
  object{RoundLedRedOn translate<1.7,-.2,0>}
  object{RoundLedRedOff translate<1.7,-.4,0>}
  object{RoundLedRedOn translate<1.7,-.6,0>}

  object{RoundLedBlueOff translate<1.3,.6,0>}
  object{RoundLedBlueOff translate<1.3,.4,0>}
  object{RoundLedBlueOn translate<1.3,.2,0>}
  object{RoundLedBlueOn translate<1.3,0,0>}
  object{RoundLedBlueOn translate<1.3,-.2,0>}
  object{RoundLedBlueOn translate<1.3,-.4,0>}
  object{RoundLedBlueOn translate<1.3,-.6,0>}

  object{RoundLedBlueOn translate<1.1,.6,0>}
  object{RoundLedBlueOn translate<1.1,.4,0>}
  object{RoundLedBlueOn translate<1.1,.2,0>}
  object{RoundLedBlueOff translate<1.1,0,0>}
  object{RoundLedBlueOn translate<1.1,-.2,0>}
  object{RoundLedBlueOn translate<1.1,-.4,0>}
  object{RoundLedBlueOff translate<1.1,-.6,0>}

  object{RoundLedBlueOn translate<.9,.6,0>}
  object{RoundLedBlueOn translate<.9,.4,0>}
  object{RoundLedBlueOff translate<.9,.2,0>}
  object{RoundLedBlueOff translate<.9,0,0>}
  object{RoundLedBlueOn translate<.9,-.2,0>}
  object{RoundLedBlueOn translate<.9,-.4,0>}
  object{RoundLedBlueOn translate<.9,-.6,0>}
}

// Change values in ARMDECLS.INC to move PortaCam's flash arm angles
// Note: flash at end of arm remains pointed in same direction as arm moves
#include "armdecls.inc"  // Vax Vay Vaz Vbx Vby Vbz Vcx Vcy Vcz La Lb Lc

//#declare Jtex = texture{Polished_Chrome pigment{Gray40}} // joints
#declare Jtex = texture{Chrome_Metal pigment{Gray40}} // joints
//#declare Ltex = texture{Polished_Chrome pigment{Gray20}} // limbs
#declare Ltex = texture{Chrome_Metal pigment{Gray20}} // limbs

#declare Flash = // Camera flash unit points in the -z direction
union{
  sphere{<0,0,0>, .7 texture{Ltex}}
  cylinder{<0,0,.5>,<0,0,-.6>,.5 texture{Ltex}}
  cylinder{<0,0,-.6>,<0,0,-.8>,.48
    texture{Glass3 finish{Luminous} pigment{White}}
  }
  light_source { <0,0,-.81> color red 1 green 1 blue 1
    spotlight
    point_at<0,0,-5>
    tightness 5
    radius 30
    falloff 50
  }
}

#declare Hand =        
union{
  cylinder{<0,0,0>,<La,0,0>,.15 texture{Ltex}}
  cylinder{<0,.3,0>,<La,.1,0>,.10 texture{Ltex}}
  cylinder{<0,.3,0>,<La,.1,0>,.10 texture{Ltex} rotate x *  120}
  cylinder{<0,.3,0>,<La,.1,0>,.10 texture{Ltex} rotate x * -120}
}

#declare Wrist = 
intersection{
  sphere{<0,0,0>,.55 texture{Jtex}}
  torus{.55,.01 inverse rotate z * 90 texture{Ltex}}
}

#declare ForeArm =     
union{
  cylinder{<0,0,0>,<Lb,0,0>,.20 texture{Ltex}}
  cylinder{<0,.4,0>,<Lb,.2,0>,.15 texture{Ltex}}
  cylinder{<0,.4,0>,<Lb,.2,0>,.15 texture{Ltex} rotate x *  120}
  cylinder{<0,.4,0>,<Lb,.2,0>,.15 texture{Ltex} rotate x * -120}
}

#declare Elbow = 
intersection{
  sphere{<0,0,0>,.77 texture{Jtex}}
  torus{.77,.01 inverse rotate z * 90 texture{Ltex}}
}

#declare UpperArm =   
union{
  cylinder{<0,0,0>,<Lc,0,0>,.25 texture{Ltex}}
  cylinder{<0,.6,0>,<Lc,.4,0>,.20 texture{Ltex}}
  cylinder{<0,.6,0>,<Lc,.4,0>,.20 texture{Ltex} rotate x *  120}
  cylinder{<0,.6,0>,<Lc,.4,0>,.20 texture{Ltex} rotate x * -120}
}

#declare Shoulder = 
intersection{
  sphere{<0,0,0>, 1 texture{Jtex}}
  torus{1,.01 inverse rotate z * 90 texture{Ltex}}
}

#declare RSectionA =
union{
  union{
    object{ 
      Flash rotate FlashVector 
      // counter-rotate to maintain correct orientation
      rotate z * -Vcz rotate y * -Vcy rotate x * -Vcx  
      rotate z * -Vbz rotate y * -Vby rotate x * -Vbx  
      rotate z * -Vaz rotate y * -Vay rotate x * -Vax  
      translate x * La 
    }
    object{Hand}
    rotate<Vax,Vay,Vaz>
  }
  object{Wrist rotate<Vax / 2,Vay / 2,Vaz / 2 >}
}

#declare RSectionB =
union{ 
  union{
    object{RSectionA translate x * Lb}
    object{ForeArm}
    rotate<Vbx,Vby,Vbz>
  }
  object{Elbow rotate<Vbx / 2, Vby / 2, Vbz / 2>}
}

#declare RightArm =
union{
  union{
    object{RSectionB translate x * Lc} // Wrist, ForeArm & Elbow
    object{UpperArm}
    rotate<Vcx,Vcy,Vcz>
  }
  object{Shoulder rotate<Vcx / 2, Vcy / 2, Vcz / 2>}
  cone{<-1,0,0>,1.2,<0,0,0>,1 texture{Ltex}}
}

// To make the left arm move, reverse all translates & y and z rotations

#declare LSectionA =
union{
  union{
    object{ 
      Flash rotate FlashVector 
      // counter-rotate to maintain correct orientation
      rotate z * Vcz rotate y * Vcy rotate x * -Vcx  
      rotate z * Vbz rotate y * Vby rotate x * -Vbx  
      rotate z * Vaz rotate y * Vay rotate x * -Vax  
      translate x * -La 
    }
    object{Hand rotate x * 180 rotate z * 180}
    rotate<Vax,-Vay,-Vaz>
  }
  object{Wrist rotate<Vax / 2, -Vay / 2, -Vaz / 2>}
}

#declare LSectionB =
union{ 
  union{
    object{LSectionA translate x * -Lb}
    object{ForeArm rotate x * 180 rotate z * 180}
    rotate<Vbx,-Vby,-Vbz>
  }
  object{Elbow rotate<Vbx / 2, -Vby / 2, -Vbz / 2>}
}

#declare LeftArm =
union{
  union{
    object{LSectionB translate x * -Lc} // Wrist, ForeArm & Elbow
    object{UpperArm rotate x * 180 rotate z * 180}
    rotate<Vcx,-Vcy,-Vcz>
  }
  object{Shoulder rotate<Vcx / 2, -Vcy / 2, -Vcz / 2>}
  cone{<1,0,0>,1.2,<0,0,0>,1 texture{Ltex}}
}

#declare Chrome05 = texture{Chrome_Metal pigment{Gray05}}
#declare Chrome10 = texture{Chrome_Metal pigment{Gray10}}
#declare Chrome25 = texture{Chrome_Metal pigment{Gray25}}
#declare Chrome40 = texture{Chrome_Metal pigment{Gray40}}

#declare LensAssy =
union{
  union{ // glass parts
    // "UV filter"
    disc{<-.150,0,0>,<1,0,0>,.39 texture{Glass3}}
    disc{<-.152,0,0>,<1,0,0>,.39 texture{Glass3}}

    // 3 curved glass lens "elements"
    union{  
      intersection{
        cylinder{<-1.1,0,0>,<0,0,0>,.389 pigment{Clear}}
        sphere{<-10,0,0>,9.75}
        sphere{<-10,0,0>,9.72 inverse}
      }
      intersection{
        cylinder{<-1.1,0,0>,<0,0,0>,.388 pigment{Clear}}
        sphere{<-10,0,0>,9.65}
        sphere{<-10,0,0>,9.62 inverse}
      }
      intersection{
        cylinder{<-1.1,0,0>,<0,0,0>,.387 pigment{Clear}}
        sphere{<-10,0,0>,9.55}
        sphere{<-10,0,0>,9.52 inverse}
      }
      texture{Glass3}
    }
  }

  union{ // focus ring
    intersection{ // outer, front
      cylinder{<-.15,0,0>,<-.10,0,0>,.535}
      cylinder{<-1,0,0>,<1,0,0>, .52  inverse}
    }
    intersection{ // outer, rear
      cylinder{<-.40,0,0>,<-.35,0,0>,.535}
      cylinder{<-1,0,0>,<1,0,0>, .52 inverse}
    }
    intersection{ // inner
      cylinder{<-.5,0,0>,<0,0,0>,.5285}
      cylinder{<-1,0,0>,<1,0,0>,.50 inverse}
      cone{<.001,0,0>,.51425,<-1,0,0>,1}  // bevelled front edge
      cone{<-.501,0,0>,.51425,<.5,0,0>,1} // bevelled rear edge
    }
    texture{ pigment{Gray05} finish{Dull}}
  }

  intersection{ // sloping outer sleeve
    cylinder{<-1,0,0>,<-.05,0,0>,.5}
    cylinder{<-2,0,0>,<1,0,0>,.46 inverse}
    cone{<-.049,0,0>,.50,<-.1,0,0>,.45 inverse}
    texture{Chrome10}
  }

  intersection{ // sloping inner sleeve
    cylinder{<-1,0,0>,<-.1,0,0>,.45}
    cylinder{<-2,0,0>,<1,0,0>,.39 inverse}
    cone{<-.099,0,0>,.449,<-.14,0,0>,.39 inverse}
    texture{Chrome05}
  }

  // reducers - attach lens to camera body
  intersection{
    union{
      cylinder{<-.8,0,0>,<-1.1,0,0>,.550}
      cylinder{<-.6,0,0>,<-0.8,0,0>,.535}
      texture{Chrome25}
    }
    cylinder{<-2,0,0>,<-.3,0,0>,.39 inverse pigment{Clear}}
  }
}

// camera housing body w/ ridge around y axis & 2 around z axis

#declare CamBody = 
intersection{
  sphere{<0,0,0>,1.2 texture{Chrome40}}
  torus{1.2,.01 inverse texture{Chrome10}}
  torus{1.175,.01 inverse texture{Chrome10} rotate x * 90 translate z * .25}
  torus{1.175,.01 inverse texture{Chrome10} rotate x * 90 translate z * -.25}
  intersection{
    union{
      cylinder{<-1,-.5,-.5>,<1,-.5,-.5>,.5}
      cylinder{<-1,-.5, .5>,<1,-.5, .5>,.5}
      cylinder{<-1, .5,-.5>,<1, .5,-.5>,.5}
      cylinder{<-1, .5, .5>,<1, .5, .5>,.5}
      box{<-1,-1,-.5>,<1,1,.5>}
      box{<-1,-.5,-1>,<1,.5,1>}
    }
    union{
      cylinder{<-1,-.5,-.5>,<1,-.5,-.5>,.5}
      cylinder{<-1,-.5, .5>,<1,-.5, .5>,.5}
      cylinder{<-1, .5,-.5>,<1, .5,-.5>,.5}
      cylinder{<-1, .5, .5>,<1, .5, .5>,.5}
      box{<-1,-1,-.5>,<1,1,.5>}
      box{<-1,-.5,-1>,<1,.5,1>}
      rotate y * 90
    }
  }
}

#declare CameraLenses =
union{
  // big ones
  object{LensAssy scale .5 translate<1.5,0,-.65>}
  object{LensAssy scale .5 translate<1.5,0,.65>}
  // medium ones
  object{LensAssy scale .25 translate<1.2,.25,-.25>}
  object{LensAssy scale .25 translate<1.2,.25, .25>}
  // smallest ones
  object{LensAssy scale .15 translate<1.15,-.2,-.10>}
  object{LensAssy scale .15 translate<1.15,-.2,.10>}
  object{LensAssy scale .15 translate<1.15,0,-.10>}
  object{LensAssy scale .15 translate<1.15,0,.10>}
}

#declare Antigrav = // "Antigrav" device on bottom
union{
  torus{.4,.1}
  torus{.3,.1}
  torus{.2,.1}
  cone{<0,0,0>,.3,<0,-.1,0>,.1}
  cylinder{<-.4,0,0>,<.4,0,0>,.09}
  cylinder{<-.4,0,0>,<.4,0,0>,.09 rotate y * 60}
  cylinder{<-.4,0,0>,<.4,0,0>,.09 rotate y * 120}
  pigment{White} finish{Luminous}
}

#declare MainBody =
union{
  object{CamBody scale<1,.70,1.6> texture{Chrome10}}
  object{CamBody scale<.95,.65,1.65> texture{Chrome10}}
  object{CamBody rotate x * 90 scale<.90,.72,1.5> texture{Chrome10}}
  object{CamBody rotate y * 90 scale<1.02,.68,1.5> texture{Chrome10}}
  object{Antigrav translate y * -.67}
  cone{<0,.74,0>,.3,<0,.64,0>,.5 texture{Chrome10} } // "crown" on top
  // Uncomment the next line ONLY when the back of the Portacam is visible
  object{Panel scale .3 rotate y * 90 translate x * -1.055}
}

#declare Portacam =
union{
  object{CameraLenses}
  object{MainBody}
  object{LeftArm scale .3 rotate y * -90 translate z * -1.775}
  object{RightArm scale .3 rotate y * -90 translate z * 1.775}
}

