//  PlanetX.pov  Lorenzo Quintana  21-10-1996

  #include "Texturas.inc"

// -- Fondo --
  background { color <0,0,0> } 

  sky_sphere { pigment { granite
  color_map {
  [ 0.000  0.800 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
  [ 0.800  0.805 color rgb < 1, 1, 1> color rgb < 1, 1, 1> ] 
  [ 0.805  0.815 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
  [ 0.815  0.820 color rgb < 0.6, 0.8, 1> color rgb < 0.6, 0.8, 0.1> ]
  [ 0.820  0.830 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ] 
  [ 0.830  0.835 color rgb < 0.0, 0.7, 0.9> color rgb < 0.0, 0.7, 0.9> ]
  [ 0.835  0.845 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
  [ 0.845  0.850 color rgb < 1, 0.8, 0.7> color rgb < 1, 0.8, 0.7> ]
  [ 0.850  1.000 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ] }
  scale 0.01 translate -1 } }

// -- Niebla--
  fog { distance 220 colour rgb <0.8,0.8,0.8>
  fog_type 2 fog_offset 3 fog_alt 6 
  turbulence 0.2 turb_depth 0.3 }

// -- Camara --
  camera { location <0, 4.4, -7> look_at   <-0.03, 5, 0>  angle 58 }

// -- Luces --

  light_source { <95, 968, -1000> color rgb <1,1,1> }
  
  light_source { <-6.52,3.6,17> 
  color rgb <1,0.69,0.47>
  cylinder
  point_at <-6.52,2,17>
  radius 180
  falloff 185 
  tightness 10 }

// -- Objetos --

// -- Suelo --
#declare Suelo = height_field {
  gif "Crater.gif"
  texture { TexPiedra }
  water_level 0.05
  scale <28, 5, 28> }

// -- Estrella--
  #declare Estrella = object { disc { <0,0,0>, <0,0,1>, 1.0
  texture { TexEstrella } } }

// -- Planeta --
  #declare Planeta =union { 
  disc { <0,0,0>, <0,0,1>, 1.0, 0.5
  texture { TexAnillos }
  scale <2.5, 2.5, 1.0> }
  sphere {  <0,0,0>,1 texture { TexPlaneta } }
  scale 100.0
  rotate <-111.5,0,-15> }

// -- Monstruo --

 #declare Diente1 = union { 
  object {
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
  <-0.398047, -0.024113, 0.000000>, <-0.398047, -0.571282, 0.000000>, <0.826611, -0.535113, 0.000000>, <0.826611, 0.012056, 0.000000>, 
  <-0.204966, -0.024113, 1.687563>, <-0.204966, -0.571282, 1.687563>, <1.019692, -0.535113, 1.687563>, <1.019692, 0.012056, 1.687563>, 
  <-0.017504, -0.024113, 4.000000>, <-0.017504, -0.571282, 4.000000>, <1.082179, -0.535113, 3.968756>, <1.082179, 0.012056, 3.968756>, 
  <0.156217, 0.000000, 5.156668>, <0.156217, -0.000002, 5.156668>, <0.156221, -0.000002, 5.156668>, <0.156221, 0.000000, 5.156668>
    } }
  object {
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
  <0.826611, 0.012056, 0.000000>, <0.826611, 0.559226, 0.000000>, <-0.398047, 0.523057, 0.000000>, <-0.398047, -0.024113, 0.000000>, 
  <1.019692, 0.012056, 1.687563>, <1.019692, 0.559226, 1.687563>, <-0.204966, 0.523057, 1.687563>, <-0.204966, -0.024113, 1.687563>, 
  <1.082179, 0.012056, 3.968756>, <1.082179, 0.559226, 3.968756>, <-0.017504, 0.523057, 4.000000>, <-0.017504, -0.024113, 4.000000>, 
  <0.156221, 0.000000, 5.156668>, <0.156221, 0.000002, 5.156668>, <0.156217, 0.000002, 5.156668>, <0.156217, 0.000000, 5.156668>
    } }
  texture { tDientes }
  scale <0.3, 0.3, 0.2>
  rotate <-8.397917, 23.113613, 152.444016>
  translate  <-3.2, 1.1, -2.5> }

 #declare Diente6 = object {
  object { // Diente6->Diente1
  Diente1
  rotate <-169.348785, -24.839014, -1.904147>
  translate  <-0.25, 1.6, -1.0> } }

 #declare Diente8 = object {
  object { 
    Diente6
    scale <1.0, 1.0, 1.3>
    rotate <2.401186, 2.854753, -30.743454>
    translate  <0.0, -0.95, -0.1> } }

 #declare UnaA = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.398047, -0.024113, 0.000000>, <-0.398047, -0.571282, 0.000000>, <0.826611, -0.535113, 0.000000>, <0.826611, 0.012056, 0.000000>, 
      <0.513639, -0.024113, 2.000000>, <0.513639, -0.571282, 2.000000>, <1.738297, -0.535113, 2.000000>, <1.738297, 0.012056, 2.000000>, 
      <0.513639, -0.024113, 4.000000>, <0.513639, -0.571282, 4.000000>, <1.738297, -0.535113, 4.000000>, <1.738297, 0.012056, 4.000000>, 
      <-0.000002, 0.000000, 4.844231>, <-0.000002, -0.000002, 4.844231>, <0.000002, -0.000002, 4.844231>, <0.000002, 0.000000, 4.844231>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.826611, 0.012056, 0.000000>, <0.826611, 0.559226, 0.000000>, <-0.398047, 0.523057, 0.000000>, <-0.398047, -0.024113, 0.000000>, 
      <1.738297, 0.012056, 2.000000>, <1.738297, 0.559226, 2.000000>, <0.513639, 0.523057, 2.000000>, <0.513639, -0.024113, 2.000000>, 
      <1.738297, 0.012056, 4.000000>, <1.738297, 0.559226, 4.000000>, <0.513639, 0.523057, 4.000000>, <0.513639, -0.024113, 4.000000>, 
      <0.000002, 0.000000, 4.844231>, <0.000002, 0.000002, 4.844231>, <-0.000002, 0.000002, 4.844231>, <-0.000002, 0.000000, 4.844231>
    }
  }
  texture {
    tUna
  }
  scale <0.8, 0.8, 0.5>
}
#declare Una = union {
  object { UnaA }
  torus { // UnaB
    0.4475, 0.1075  rotate -x*90
    texture {
      tPiel
    }
    scale <1.5, 1.0, 1.5>
    rotate <0.0, 60.0, 0.0>
    translate  <0.4, 0.0, 0.5>
  }
  scale <0.8, 0.8, 1.0>
  rotate <-78.698395, -3.995159, 130.007584>
  translate  <-4.3, 6.1, -3.85>
}
#declare Una2 = object {
  object { // Una2->Una
    Una
    scale 0.8
    rotate <26.054541, 38.991848, -1.397328>
    translate  <0.1, -0.6, -4.15>
  }
}
#declare Una3 = object {
  object { // Una3->Una
    Una
    rotate <91.297165, -4.829218, -15.054701>
    translate  <1.6, -9.7, -13.05> } }

#declare Cuerpo1 = blob {
  threshold 0.6
  component 1.0, 1.315446, <-0.592324, 0.025753, 0.118671>
  component 1.0, 1.332152, <0.643831, 0.008439, 0.109705>
  component 1.0, 1.001078, <0.548523, 0.734177, -0.548523>
  component 1.0, 1.001078, <-0.49789, 0.751055, -0.548523>
  component 1.0, 1.050361, <0.540612, 1.223629, -1.384494>
  component 1.0, 1.036507, <-0.487869, 1.223629, -1.384494>
  component 1.0, 1.659547, <0.643831, -0.919831, 0.43038>
  component 1.0, 1.553311, <-0.592324, -0.919831, 0.413502>
  component 1.0, 1.210767, <1.279009, 0.396624, -1.147152>
  component 1.0, 1.164478, <-1.158895, 0.180273, -1.156118>
  component 1.0, 0.782318, <1.828479, -0.158228, -1.714135>
  component 1.0, 0.782318, <-1.595464, -0.527426, -1.318565>
  component 1.0, 0.62489, <1.961366, -0.474684, -2.162447>
  component 1.0, 0.62489, <-1.776973, -0.949367, -1.476793>
  component 1.0, 0.95887, <1.998451, -0.685654, -2.82173>
  component 1.0, 0.392768, <2.039656, -0.540612, -3.415085>
  component 1.0, 0.392768, <2.039656, -1.041667, -3.335971>
  component 1.0, 0.392768, <1.951477, -0.472574, -3.729958>
  component 1.0, 0.392768, <1.909283, -1.147679, -3.628692>
  component 1.0, 0.392768, <1.719409, -0.118671, -3.045886>
  component 1.0, 0.392768, <1.508439, 0.067511, -3.291139>
  component 1.0, 0.392768, <1.729958, -0.405063, -3.890295>
  component 1.0, 0.392768, <1.740507, -1.21519, -3.93249>
  component 1.0, 0.794336, <-1.890295, -1.476793, -1.704641>
  component 1.0, 0.392768, <-1.527426, -1.696203, -2.059072>
  component 1.0, 0.392768, <-1.341772, -1.881857, -2.329114>
  component 1.0, 0.392768, <-1.951477, -1.661392, -2.14346>
  component 1.0, 0.392768, <-1.949367, -1.662447, -2.447258>
  component 1.0, 0.392768, <-2.303798, -1.696203, -1.890296>
  component 1.0, 0.392768, <-2.523207, -1.594937, -2.177215>
  component 1.0, 0.392768, <-2.624473, -1.814346, -2.481013>
  component 1.0, 0.392768, <-1.966245, -1.831224, -2.767933>
  component 1.0, 2.57162, <0.092827, -2.0, 0.642801>
  texture { tPiel }
  scale 2.8
  rotate <91.172417, 1.829787, 84.927399>
  translate  <5.9, 0.0, -2.7> }

#declare MaxInf = blob {
  threshold 0.6
  component 1.0, 0.439721, <-0.261603, 0.0, -0.616034>
  component 1.0, 0.439721, <0.194093, 0.0, -0.767932>
  component 1.0, 0.439721, <0.683544, 0.0, -0.599156>
  component 1.0, 0.439721, <-0.565401, 0.0, -0.261603>
  component 1.0, 0.439721, <-0.599156, 0.0, 0.160338>
  component 1.0, 0.439721, <0.970464, 0.0, -0.244726>
  component 1.0, 0.439721, <1.037975, 0.0, 0.177215>
  texture { tBoca }
  scale 5.0
  rotate <-80.0, 0.0, 0.0>
  translate  <-0.9, 0.6, -3.0> }

#declare MaxSup = blob {
  threshold 0.6
  component 1.0, 0.439721, <-0.21097, 0.0, -0.78481>
  component 1.0, 0.439721, <0.227848, 0.0, -0.78481>
  component 1.0, 0.439721, <0.632911, 0.0, -0.565401>
  component 1.0, 0.439721, <-0.599156, 0.0, -0.548523>
  component 1.0, 0.439721, <-0.78481, 0.0, -0.14346>
  component 1.0, 0.439721, <0.902954, 0.0, -0.177215>
  component 1.0, 0.439721, <1.004219, 0.0, 0.244726>
  component 1.0, 0.439721, <-0.869198, 0.0, 0.278481>
  texture { tBoca }
  scale 5.0
  rotate <-110.0, 0.0, 0.0>
  translate  <0.0, 0.1, 2.3> }

#declare Dientes = union {
  object { Diente1 }
  object { // Diente2->Diente1
    Diente1
    rotate <0.0, 0.0, 40.0>
    translate  <-0.1, 1.3, 0.0>
  }
  object { // Diente3->Diente1
    Diente1
    rotate <0.0, 0.0, 15.0>
    translate  <-0.2, 0.3, -0.1>
  }
  object { // Diente4->Diente1
    Diente1
    rotate <0.0, 0.0, -25.0>
    translate  <-0.1, -1.0, 0.2>
  }
  object { // Diente5->Diente1
    Diente1
    rotate <0.0, 0.0, 35.0>
    translate  <0.8, 0.7, 0.2>
  }
  object { Diente6 }
  object { // Diente7->Diente6
    Diente6
    rotate <-9.079467, -4.208542, -24.665693>
    translate  <-0.5, -0.9, 0.3>
  }
  object { Diente8 }
  object { // Diente9->Diente8
    Diente8
    rotate <-16.639757, -2.424134, 24.922197>
    translate  <0.15, 0.09, 0.44> }
  scale <2.5, 5.0, 2.5>
  rotate <0.0, 15.0, 90.0>
  translate  <3.0, 6.99027, 0.973972> }

#declare Dentadura = union {
  object { MaxInf }
  object { MaxSup }
  object { Dientes }
}
#declare CabezaA = blob {
  threshold 0.6
  component 1.0, 0.439721, <-0.126582, 0.78481, -0.801688>
  component 1.0, 0.439721, <0.244726, 0.801688, -0.816878>
  component 1.0, 0.439721, <0.616034, 0.649789, -0.582278>
  component 1.0, 0.439721, <-0.479325, 0.649789, -0.546835>
  component 1.0, 0.502744, <-0.734177, 0.379747, -0.14346>
  component 1.0, 0.508989, <0.886076, 0.396624, -0.177215>
  component 1.259312, 0.404593, <1.004219, 0.042194, 0.244726>
  component 1.0, 0.439721, <-0.835443, 0.059072, 0.278481>
  component 1.0, 0.449667, <0.919831, -0.616034, 0.008439>
  component 1.0, 0.449667, <1.004219, -0.278481, 0.295359>
  component 1.0, 0.449667, <0.7173, -0.852321, -0.362869>
  component 1.0, 0.455252, <0.464135, -0.987342, -0.666667>
  component 1.0, 0.478267, <-0.506329, -0.818565, -0.479325>
  component 1.0, 0.449667, <-0.109705, -1.004219, -0.835443>
  component 1.0, 0.463507, <-0.683544, -0.683544, 0.008439>
  component 1.0, 0.483523, <-0.835443, -0.278481, 0.109705>
  component 1.0, 0.35012, <-0.330802, -0.936709, -0.668354>
  component 1.0, 0.664116, <-0.43038, -0.953587, 0.042194>
  component 1.0, 0.640875, <0.616034, -1.07173, 0.092827>
  component 1.0, 0.747382, <0.075949, -1.156118, -0.329114>
  component 1.0, 0.747382, <0.936709, -0.700422, 0.632911>
  component 1.0, 0.747382, <-0.683544, -0.632911, 0.632911>
  component 1.0, 0.826856, <0.126582, -0.734177, 0.582278>
  component 1.0, 1.03338, <1.088608, -0.278481, 0.683544>
  component 1.0, 1.06648, <-0.869198, -0.295359, 0.649789>
  component 1.0, 0.449667, <0.194093, -1.004219, -0.835443>
  component 1.0, 1.03338, <0.818565, 0.531646, 0.683544>
  component 1.0, 1.03338, <-0.666667, 0.548523, 0.683544>
  component 1.0, 1.03338, <0.092827, 1.019409, -0.047257>
  component 1.0, 1.545988, <0.092827, 0.533333, 1.451477>
  component 1.0, 1.6092, <0.067511, -0.118671, 2.175633>
  texture { tPiel }
  scale <7.2, 5.8, 5.9>
  rotate <80.0, 0.0, -180.0>
  translate  <1.0, 1.4, 1.3> }

#declare Lengua = blob {
  threshold 0.6
  component 1.0, 1.102029, <-0.008439, 0.0, 0.734177>
  component 0.854965, 0.675437, <-0.008439, 0.0, 0.109705>
  component 1.0, 0.432476, <-0.008439, 0.0, -0.329114>
  component 1.0, 0.305807, <-0.025316, -0.599156, 0.379747>
  component 1.0, 0.305807, <-0.025316, -0.78481, 0.565401>
  component 1.0, 0.305807, <-0.025316, -0.666667, 0.801688>
  texture { tLengua }
  scale <10.0, 2.5, 7.0>
  rotate <80.0, 0.0, -180.0>
  translate  <0.45, 0.82, -1.26> }

#declare Ojo = union {
  torus { // OjoA
    0.6, 0.2  rotate -x*90
    texture {
      tPiel
    }
    scale <1.0, 0.9, 1.0>
    rotate <-90.0, 0.0, 30.0>
    translate  <-2.1, 1.9, 1.4>
  }
  sphere { // OjoB
    <0,0,0>,1
    texture {
      tOjo2
      scale <2.0, 2.0, 1.0>
      rotate <90.0, 0.0, 90.0>
  translate <-1.100000, -1.000000, -1.000000>
    }
    scale 0.4
    rotate <3.616441, -19.683498, -10.627584>
    translate  <-2.2, 2.0, 1.4>
  }
  sphere { // OjoC
    <0,0,0>,1
    texture {
      tOjo1
      scale <2.0, 2.0, 1.0>
      rotate <90.0, 0.0, 90.0>
  translate <-1.100000, -1.000000, -1.000000>
    }
    scale 0.359
    rotate <3.6, -18.0, -25.0>
    translate  <-2.2, 2.0, 1.4>
  }
  scale <3.0, 6.0, 3.0>
  rotate <0.0, 15.0, 90.0>
  translate  <2.5, 8.563923, -2.812334>
}
#declare Ojo2 = blob {
  threshold 0.6
  component 1.0, 1.28027, <0.008439, 0.0, -0.008439>
  component -31.835683, 0.534424, <0.548523, -0.042194, -0.329114>
  component 1.0, 0.270736, <0.649789, 0.514768, 0.194093>
  component 1.0, 0.213296, <0.582278, 0.683544, -0.464135>
  component 1.0, 0.213296, <0.43038, -0.599156, -0.413502>
  component 1.0, 0.140081, <0.912743, 0.545485, 0.21097>
  texture {
    tOjo1
  }
  scale <3.5, 2.0, 3.0>
  rotate <-20.310242, -13.080012, -7.16225>
  translate  <9.13, 3.57, 3.4>
}

#declare Cabeza = union {
  object { Dentadura }
  object { CabezaA }
  object { Lengua }
  object { Ojo }
  object { Ojo2 }
  scale <0.2, 0.4, 0.4>
  rotate <20.0, 10.0, -90.0>
  translate  <-2.56, 0.82, -1.21>
}
#declare Unas = union {
  object { Una }
  object { // Una1->Una
    Una
    rotate <1.790109, -15.14187, 9.38334>
    translate  <-0.4, 0.4, -1.3>
  }
  object { Una2 }
  object { Una3 }
  object { // Una6->Una3
    Una3
    rotate <0.0, 0.0, 10.0>
    translate  <-0.5, -1.6, -0.1>
  }
  object { // Una4->Una2
    Una2
    rotate <52.119099, -13.704545, -88.067673>
    translate  <-6.1, -6.8, -9.5>
  }
}

#declare Sangre2 = blob {
  threshold 0.6
  component 1.0, 0.818407, <0.008439, 0.0, -0.008439>

  component 1.0, 0.213296, <0.008439, 0.514768, 0.008439>

  component 1.0, 0.213296, <-0.025316, 0.78481, 0.008439>

  component 1.0, 0.312322, <-0.160338, 0.396624, 0.312236>

  component 1.0, 0.238742, <-0.295359, 0.535764, 0.464135>

  component 1.0, 0.162797, <-0.432068, 0.682667, 0.464135>

  component 1.0, 0.175054, <-0.57897, 0.812287, 0.565401>

  component 1.0, 0.248845, <-0.760439, 0.941907, 0.666667>

  component 1.0, 0.328128, <-0.928945, 1.110414, 0.818565>

  component 1.0, 0.241912, <-0.077772, -0.328371, -0.43038>

  component 1.0, 0.2394, <-0.278481, -0.440709, -0.565401>

  component 1.0, 0.209065, <-1.274262, 0.950549, 0.244726>

  component 1.0, 0.13651, <-1.100422, 0.853333, 0.155274>

  component 1.0, 0.280096, <-0.523882, -0.57789, -0.681857>

  component -1.953505, 0.352082, <-0.278481, 0.008439, -0.177215>

  texture {
    tSangre2
  }
  scale <1.25, 1.125, 1.125>
   rotate <65.761894, -1.385891, 69.394783>
  translate  <-1.71, -1.64, 0.11>
}
#declare Monstruo = union { // Monstruo
  object { Cuerpo1 }
  object { Cabeza }
  object { Unas }
  object { Sangre2 }
  scale 4.0
  rotate 110.0*z
  translate  <-29.3, 23.17, 31.1>
}

// ---- NAVE Y ASTRONAUTAS ----

#declare Tronco1 = union {
  cylinder { // TroncoA
    <0,0,1>, <0,0,0>, 1 
    scale <2.8, 2.0, 4.9>
    translate  <-4.6, 2.4, 12.8>
  }
  sphere { // TroncoB
    <0,0,0>,1 
    scale <2.8, 2.0, 1.3>
    translate  <-4.6, 2.4, 17.7>
  }
  sphere { // TroncoC
    <0,0,0>,1
    scale <2.8, 2.0, 1.3>
    translate  <-4.6, 2.4, 12.8>
  }
}
#declare Casco = union {
  sphere { // CascoC
    <0,0,0>,1
    texture {
      tCrisCasco
    }
    scale <1.0, 0.8, 1.0>
    translate  <-1.7, 0.45, 10.5>
  }
  sphere { // CascoA
    <0,0,0>,1
    scale <1.1, 1.2, 1.1>
    translate  <-1.7, 0.9, 10.5>
  }
  cylinder { // CascoB
    <0,0,1>, <0,0,0>, 1 
    scale <0.9, 0.8, 2.0>
    translate  <-1.7, 0.9, 8.6>
  }
  cylinder { // CascoD
    <0,0,1>, <0,0,0>, 1 
    texture {
      tPlasBlanco
    }
    scale <1.15, 1.15, 0.7>
    rotate -90.0*y
    translate  <-1.37, 1.0, 10.51>
  }
  cone { // CascoE
    <0,0,0>, 0.35, <0,0,1>, 0.45
    texture {
      tPlasBlanco
    }
    scale <1.0, 1.0, 0.2>
    rotate <0.0, 90.0, 0.0>
    translate  <-2.85, 0.89, 10.5>
  }
  cone { // CascoF
    <0,0,0>, 0.35, <0,0,1>, 0.45
  texture { tPlasBlanco }
  scale <1.0, 1.0, 0.2>
  rotate <-180.0, 90.0, 0.0>
  translate  <-0.54, 0.89, 10.5> }
  texture { tPlasBlanco }
  scale 2.0
  translate  <-1.0, 0.6, -0.4> }

#declare Mochila1 = object {
  superellipsoid { <.2, .2>
  texture { tPlasBlanco }
  scale <2.0, 1.0, 3.0>
  translate  <-4.62, 5.08, 15.76> } }

#declare Puerta3 = object {
  box { // Puerta3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.3, 0.4>
    translate  <13.8, 15.59, 30.299999>
  }
}
#declare PataA = union {
  torus { // Pat1
    2.6, 0.4  rotate -x*90
    translate  <-12.0, 0.0, -12.0>
  }
  disc { // Pat2
    <0,0,0>, <0,0,1>, 1.0
    scale <2.5, 2.5, 1.0>
    translate  <-12.0, 0.0, -12.3>
  }
  cone { // Pat3
    <0,0,0>, 0.5, <0,0,1>, 1.0
    rotate <-180.0, 0.0, -180.0>
    translate  <-12.0, 0.0, -11.3>
  }
  cylinder { // Pat4
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 15.5>
    rotate 20.0*y
    translate  <-12.1, 0.0, -11.5>
  }
  cylinder { // Pat5A
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 12.0>
    rotate <-40.0, 90.0, 0.0>
    translate  <-9.2, 0.1, -3.4>
  }
  cylinder { // Pat5B
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 12.0>
    rotate <40.0, 90.0, 0.0>
    translate  <-9.2, 0.1, -3.4>
  }
  cone { // Pat6A
    <0,0,0>, 0.5, <0,0,1>, 1.0
    texture {
      tPlasNegro
    }
    scale <1.0, 1.0, 9.0>
    rotate <-16.0, 82.049576, 23.881979>
    translate  <-7.0, 0.0, 2.7>
  }
  cone { // Pat6B
    <0,0,0>, 0.5, <0,0,1>, 1.0
    texture {
      tPlasNegro
    }
    scale <1.0, 1.0, 9.0>
    rotate <50.0, 80.800003, 11.427329>
    translate  <-7.0, 0.0, 2.7>
  }
  box { // Base1
    <-1, -1, -1>, <1, 1, 1>
 //   texture { tOro scale 4 }
    scale <5.1, 8.5, 4.5>
    translate  <4.4, 0.1, 0.4>
  }
  cylinder { // Pat7
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 9.0>
    rotate -50.0*y
    translate  <-0.1, 0.0, -3.2>
  }
  texture {
    tOro
  }
  translate  -19.8*z
}
#declare Parte1 = object {
  superellipsoid { <.1, .1>
  scale <5.0, 7.0, 3.5>
  translate  <1.7, 0.0, 18.8> } }

#declare ToberaB = union {
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      tPlasNegro
    }
    scale <1.0, 1.0, 0.5>
    translate  -0.5*z
  }
  sphere { // Sphere001
    <0,0,0>,1
    texture {
      tNave
    }
    scale <0.7, 0.7, 1.0>
  }
}
#declare Tobera1 = difference {
  sphere { // ToberaA
    <0,0,0>,1
    texture {
      tTobera
      scale <0.9, 1.0, 1.1>
  translate <0.000000, 0.000000, -0.100000>
    }
    scale <0.8, 0.8, 1.0>
    translate  0.1*z
  }
  object { ToberaB }
  scale <6.0, 6.0, 7.0>
  translate  <1.7, -12.9, 11.5>
}
#declare Motor1 = union {
  sphere { // Sphere002
    <0,0,0>,1
    scale 5.5
    translate  <1.7, -12.9, 24.5>
  }
  torus { // Torus3
    2.5, 0.5  rotate -x*90
    translate  <1.7, -12.9, 19.3>
  }
  torus { // Torus002
    2.5, 0.5  rotate -x*90
    translate  <1.7, -12.9, 18.4>
  }
  object { Tobera1 }


  sphere { // Fuego
    <0,0,0>,1
    pigment { color rgbt <1, 1, 1, 1> }
   halo {
     emitting
     spherical_mapping
     linear
     color_map {
       [ 0 color rgbt <1, 0, 0, 1> ]
       [ 1 color rgbt <1, 1, 0, 0> ]
     }
     samples 20
   }
   hollow
    scale <3.8, 3.8, 11.0>
    translate  <1.7, -12.9, 10.13>
  }


  texture {
    tNave
  }
  translate  <4.6, -1.0, -34.800001>
}
#declare Esca1 = object {
  cylinder { // Esca1
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 0.0>
    translate  <-10.2, -2.4, -7.0>
  }
}
#declare Brazo1 = union {
  cylinder { // PiezaA
    <0,0,1>, <0,0,0>, 1 
    scale <1.08, 1.08, 12.0>
    translate  <45.279999, -10.5, 23.609999>
  }
  cylinder { // PiezaA1
    <0,0,1>, <0,0,0>, 1 
    scale <1.08, 1.08, 10.0>
    rotate <-61.238392, -19.143375, 35.817444>
    translate  <51.359999, -15.02, 29.109999>
  }
  cylinder { // PiezaA2
    <0,0,1>, <0,0,0>, 1 
    scale <1.08, 1.08, 10.0>
    rotate <-113.859756, -8.145547, 48.638123>
    translate  <51.359999, -15.02, 27.999999>
  }
  texture {
    tNave
  }
  rotate <0.0, 0.0, -40.0>
  translate  <-26.145166, 31.350386, -38.92>
}
#declare Adorno2 = object {
  cylinder { // Adorno2
    <0,0,1>, <0,0,0>, 1 
    texture {
      tMetal
    }
    scale <0.8, 0.8, 1.0>
    rotate <0.0, -90.0, 0.0>
    translate  <-2.5, -1.94, -0.92>
  }
}
#declare BarandaA1 = object {
  cylinder { // BarandaA1
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 6.5>
    rotate <0.0, 75.0, 39.5>
    translate  <32.729999, -9.27, 23.749999>
  }
}
#declare BarandaA2 = object {
  cylinder { // BarandaA2
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 1.5>
    translate  <37.489999, -5.35, 23.899999> } }

#declare PiernaIzq2A = union {
  cone { // MusloIzq2
    <0,0,0>, 1.0, <0,0,1>, 1.5
    scale <1.1, 1.2, 3.5>
    translate  <-6.0, 1.8, 5.3>
  }
  sphere { // GluIzq2
    <0,0,0>,1
    scale <1.6, 1.9, 1.8>
    translate  <-6.0, 1.9, 8.8>
  }
  rotate -5.5*x
  translate  <6.0, -0.5, 0.0>
}
#declare PiernaIzq2B = union {
  cylinder { // PiDe2B
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.2, 2.2>
    rotate 90.0*x
    translate  <0.0, -3.0, 1.8>
  }
  sphere { // RodillaIzq2
    <0,0,0>,1
    scale <1.1, 1.2, 1.1>
    rotate 90.0*x
    translate  <0.0, -5.2, 1.8>
  }
  rotate <-55.0, 0.0, 0.0>
  translate  <0.0, 3.3, -0.2>
}
#declare BaseBotaIzq2 = union {
  sphere { // Esfera5
    <0,0,0>,1
    rotate -90.0*x
    translate  <0.0, 2.0, 0.0>
  }
  cylinder { // Cilindro4
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
  }
  sphere { // Esfera6
    <0,0,0>,1
    scale <1.0, 1.0, 1.5>
    rotate -90.0*x
  }
}
#declare BotaIzq2A = difference {
  object { BaseBotaIzq2 }
  box { // SuelaIzq2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      tSuela
    }
    scale <1.1, 2.3, 0.5>
    translate  <0.0, 0.7, -0.6>
  }
  scale 0.65
  rotate <15.0, 0.0, -90.0>
  translate  <11.536178, -14.0, 3.394207>
}
#declare BotaIzq2 = union {
  object { BotaIzq2A }
  cone { // BotaIzq2B
    <0,0,0>, 1.0, <0,0,1>, 1.2
    scale <0.585, 0.65, 1.95>
    rotate <15.0, 0.0, -90.0>
    translate  <12.666311, -14.0, 3.697025>
  }
  texture {
    tPlasBlanco
  }
  scale 1.538462
  rotate <0.0, -20.0, 90.0>
  translate  <-21.538462, -11.591653, -11.177102>
}
#declare PiernaIzq2 = union {
  object { PiernaIzq2A }
  object { PiernaIzq2B }
  object { BotaIzq2 }
  rotate <-20.0, 0.0, 0.0>
  translate  <-3.2, -2.7, 5.2>
}
#declare PiernaDer2A = union {
  cylinder { // Pierna_derA
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.2, 2.2>
    rotate 90.0*x
    translate  <0.0, -3.0, 1.8>
  }
  sphere { // RodillaDer2
    <0,0,0>,1
    scale <1.1, 1.2, 1.1>
    rotate 90.0*x
    translate  <0.0, -5.2, 1.8>
  }
  rotate <25.0, 0.0, 0.0>
  translate  <0.0, 7.2, 5.7>
}
#declare PiernaDer2B = union {
  cone { // MusloDer2
    <0,0,0>, 1.0, <0,0,1>, 1.5
    scale <1.1, 1.2, 3.5>
    translate  <-6.0, 1.8, 5.3>
  }
  sphere { // GluDer2
    <0,0,0>,1
    scale <1.6, 1.9, 1.8>
    translate  <-6.0, 1.9, 8.8>
  }
  rotate -5.5*x
  translate  <6.0, -0.5, 0.0>
}
#declare BaseBotaDer2 = union {
  sphere { // Esfera7
    <0,0,0>,1
    rotate -90.0*x
    translate  <0.0, 2.0, 0.0>
  }
  cylinder { // Cilindro5
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
  }
  sphere { // Esfera8
    <0,0,0>,1
    scale <1.0, 1.0, 1.5>
    rotate -90.0*x
  }
}
#declare BotaDer2A = difference {
  object { BaseBotaDer2 }
  box { // SuelaDer2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      tSuela
    }
    scale <1.1, 2.3, 0.5>
    translate  <0.0, 0.7, -0.6>
  }
  scale 0.65
  rotate <45.0, 0.0, -90.0>
  translate  <12.112215, -12.18, 5.279423>
}
#declare BotaDer2 = union {
  object { BotaDer2A }
  cone { // BotaDer2B
    <0,0,0>, 1.0, <0,0,1>, 1.2
    scale <0.585, 0.65, 1.95>
    rotate <45.0, 0.0, -90.0>
    translate  <12.93953, -12.18, 6.106738>
  }
  texture {
    tPlasBlanco
  }
  scale 1.538462
  rotate <0.0, -70.0, 90.0>
  translate  <-18.738462, 8.459098, -14.588352>
}
#declare PiernaDer2 = union {
  object { PiernaDer2A }
  object { PiernaDer2B }
  object { BotaDer2 }
  rotate <-70.0, 0.0, 0.0>
  translate  <-6.0, -6.6, 11.6>
}
#declare ManoDer2 = union {
  sphere { // ManoDer2A
    <0,0,0>,1
    scale <0.26, 0.65, 0.65>
    rotate <47.089241, -58.292778, -31.569599>
    translate  <8.72, -14.0, 10.1>
  }
  sphere { // ManoDer2B
    <0,0,0>,1
    scale <0.52, 0.195, 0.52>
    rotate <54.468655, 30.642344, -3.947609>
    translate  <8.46, -14.52, 10.1>
  }
  scale 0.769231
  rotate <18.960274, -57.200775, 48.821678>
  translate  <-7.01862, 3.695359, -1.024439>
}
#declare BrazoDer2 = union {
  sphere { // BrazoDer2A
    <0,0,0>,1
    scale <0.5, 0.6, 0.5>
    translate  <1.7, -3.8, 10.1>
  }
  cone { // BrazoDer2B
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <0.5, 0.6, 1.7>
    translate  <1.7, -3.8, 8.4>
  }
  sphere { // BrazoDer2C
    <0,0,0>,1
    scale <0.4, 0.5, 0.5>
    translate  <1.7, -3.8, 8.4>
  }
  cone { // BrazoDer2D
    <0,0,0>, 0.8, <0,0,1>, 0.6
    scale <0.5, 0.6, 1.8>
    rotate <142.373611, -5.327133, 45.45763>
    translate  <1.7, -3.8, 8.4>
  }
  object { ManoDer2 }
  scale 2.0
  rotate <-57.759895, 16.192215, 21.801254>
  translate  <-9.5, -13.7, 1.8>
}
#declare ManoIzq2 = union {
  sphere { // ManoIzq2A
    <0,0,0>,1
    scale <0.39, 0.65, 0.52>
    rotate <-159.671432, -3.960639, -75.161934>
    translate  <11.503446, -15.322051, 9.586741>
  }
  sphere { // ManoIzq2B
    <0,0,0>,1
    scale <0.26, 0.65, 0.52>
    rotate <2.849428, 6.969313, -134.975189>
    translate  <10.995389, -15.243415, 9.435103>
  }
  cylinder { // Dedo
    <0,0,1>, <0,0,0>, 1 
    scale <0.156, 0.156, 0.975>
    rotate <-79.920212, -27.326674, 33.975586>
    translate  <10.93, -15.3, 9.71>
  }
  scale 0.769231
  rotate <18.653084, 27.560738, 103.682892>
  translate  <-9.134071, -17.967899, 10.041956>
}
#declare BrazoIzq2 = union {
  sphere { // BrazoIzq2A
    <0,0,0>,1
    scale <0.5, 0.6, 0.5>
    translate  <1.7, -3.8, 10.1>
  }
  cone { // BrazoIzq2B
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <0.5, 0.6, 1.7>
    translate  <1.7, -3.8, 8.4>
  }
  sphere { // BrazoIzq2C
    <0,0,0>,1
    scale <0.4, 0.5, 0.5>
    translate  <1.7, -3.8, 8.4>
  }
  cone { // BrazoIzq2D
    <0,0,0>, 0.8, <0,0,1>, 0.6
    scale <0.5, 0.6, 1.7>
    rotate <75.532562, -5.882967, 2.086404>
    translate  <1.7, -3.8, 8.4>
  }
  object { ManoIzq2 }
  scale 2.0
  rotate <30.844622, -11.950186, -12.377403>
  translate  <1.3, 19.0, 3.6>
}
#declare Arma = union {
  cylinder { // Mango
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.11, 0.7>
    rotate <0.0, -20.0, 0.0>
    translate  <0.95, 0.0, -0.7>
  }
  sphere { // ArmaC
    <0,0,0>,1
    scale <0.2, 0.11, 0.2>
    translate  <0.7, 0.0, -0.05>
  }
  sphere { // ArmaB
    <0,0,0>,1
    scale <0.2, 0.11, 0.2>
    translate  <-0.9, 0.0, -0.05>
  }
  cylinder { // ArmaA
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.11, 1.6>
    rotate <0.0, -90.0, 0.0>
    translate  <0.7, 0.0, -0.05>
  }
  cylinder { // Canon
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate <0.0, -90.0, 0.0>
    translate  -0.2*x
  }
  sphere { // Gatillo
    <0,0,0>,1
    scale <0.25, 0.04, 0.2>
    translate  <0.53, 0.01, -0.29>
  }
  cylinder { // Laser
    <0,0,1>, <0,0,0>, 1 
pigment { color rgbt <1, 1, 1, 1> }
   halo {
   emitting
   cylindrical_mapping
   linear
     color_map {
       [ 0 color rgbt <0, 0, 1, 1> ]
       [ 1 color rgbt <1, 1, 1, 0> ]
     }
     samples 20 }
   hollow
   no_shadow
   scale <0.2, 0.2, 22>
   rotate <0,-90,180>  // *****
   translate <-19,0,0> // *****
  }
  texture {
    tPlasNegro
  }
  scale 3.4
  rotate <-1.3, 10.0, 75.0>
  translate  <-2.2, -2.6, 15.0> }

 #declare Astro2 = union {
  object { PiernaIzq2 }
  object { PiernaDer2 }
  object { BrazoDer2 }
  object { BrazoIzq2 }
  object { Arma }
  object { // Casco2->Casco
    Casco
    rotate <0.0, 0.0, 0.0>
    translate  <-0.118462, -0.015385, 0.031538>
   }
   object { // Tronco2->Tronco1
    Tronco1
    rotate <0.0, 0.0, -170.0>
    translate  <-9.47, 3.7, 0.1> }
   object { // Mochila2->Mochila1
   Mochila1
   rotate <0.0, 0.0, 0.0>
   translate  <0.124615, -0.38077, 0.161538> }
   texture { tRopa translate <0.5,0.5,0.5> }
   scale 0.65
   rotate <0.0, 0.0, -125.0>
   translate  <31.709999, -1.46, 0.88> }

 #declare Tela = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-0.548173, -2.000000, 1.077297>, <0.741361, -2.000000, -0.955618>, <1.995623, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-0.548173, -1.000000, 1.077297>, <0.741361, -1.000000, -0.955618>, <1.995623, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-0.548173, 0.000000, 1.077297>, <0.741361, 0.000000, -0.955618>, <1.995623, 0.000000, 0.000000>, 
      <-2.000000, 1.000000, 0.000000>, <-0.548173, 1.000000, 1.077297>, <0.741361, 1.000000, -0.955618>, <1.995623, 1.000000, 0.000000>
    }
  }
  texture { tBandera
  scale <4.0, 3.0, 1.0>
  translate <-2.000000, -2.000000, 0.000000> }
  scale <1.2, 1.0, 1.0>
  translate  <0.4, 0.0, -0.1> }
#declare Bandera = union {
  object { Tela }
  cylinder { // Palo
    <0,0,1>, <0,0,0>, 1 
    texture {
      tPlasBlanco
    }
    scale <0.07, 0.07, 10.15>
    rotate -90.0*x
    translate  <-2.01, -9.08, -0.11>
  }
  scale 2.2
  rotate <89.119553, 9.961557, 84.923264>
  translate  <-7.39, 5.35, 27.519999>
}
#declare PiernaDerA = union {
  cylinder { // PiDeA
    <0,0,1>, <0,0,0>, 1 
    texture {
      tRopa
    }
    scale <1.1, 1.2, 2.2>
    rotate 90.0*x
    translate  <0.0, -3.0, 1.8>
  }
  sphere { // RodillaDer
    <0,0,0>,1
    texture {
      tRopa
    }
    scale <1.1, 1.2, 1.1>
    rotate 90.0*x
    translate  <0.0, -5.2, 1.8>
  }
  rotate <-30.0, 0.0, 0.0>
  translate  <0.0, 5.2, 0.6>
}
#declare PiernaDerB = union {
  cone { // MusloDer
    <0,0,0>, 1.0, <0,0,1>, 1.5
    texture {
      tRopa
    }
    scale <1.1, 1.2, 3.5>
    translate  <-6.0, 1.8, 5.3>
  }
  sphere { // GluDer
    <0,0,0>,1
    texture {
      tRopa
    }
    scale <1.6, 1.9, 1.8>
    translate  <-6.0, 1.9, 8.8>
  }
  rotate -5.5*x
  translate  <6.0, -0.5, 0.0>
}
#declare BaseBotaDer = union {
  sphere { // Esfera1
    <0,0,0>,1
    rotate -90.0*x
    translate  <0.0, 2.0, 0.0>
  }
  cylinder { // Cilindro2
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
  }
  sphere { // Esfera2
    <0,0,0>,1
    scale <1.0, 1.0, 1.5>
    rotate -90.0*x
  }
}
#declare BotaDerA = difference {
  object { BaseBotaDer }
  box { // SuelaDer
    <-1, -1, -1>, <1, 1, 1>
    texture {
      tSuela
    }
    scale <1.1, 2.3, 0.5>
    translate  <0.0, 0.7, -0.6>
  }
  scale 0.5
  rotate <110.0, 0.0, 0.0>
  translate  <-2.5, 4.991435, 4.734552>
}

#declare BotaDer = union {
  object { BotaDerA }
  cone { // BotaDerB
    <0,0,0>, 1.0, <0,0,1>, 1.2
    scale <0.45, 0.5, 1.5>
    rotate <110.0, 0.0, 0.0>
    translate  <-2.5, 4.683616, 5.580275>
  }
  texture {
    tPlasBlanco
  }
  scale 2.0
  rotate -50.0*x
  translate  <5.0, -8.470619, 2.160699>
}
#declare PiernaDer = union {
  object { PiernaDerA }
  object { PiernaDerB }
  object { BotaDer }
  rotate 50.0*x
  translate  <-6.0, 7.7, 4.7>
}
#declare PiernaIzqA = union {
  cylinder { // PiDeB
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.2, 2.2>
    rotate 90.0*x
    translate  <0.0, -3.0, 1.8>
  }
  sphere { // RodillaIzq
    <0,0,0>,1
    scale <1.1, 1.2, 1.1>
    rotate 90.0*x
    translate  <0.0, -5.2, 1.8>
  }
  rotate <-35.0, 0.0, 0.0>
  translate  <0.0, 5.0, 0.6>
}
#declare PiernaIzqB = union {
  cone { // MusloIzq
    <0,0,0>, 1.0, <0,0,1>, 1.5
    scale <1.1, 1.2, 3.5>
    translate  <-6.0, 1.8, 5.3>
  }
  sphere { // GluIzq
    <0,0,0>,1
    scale <1.6, 1.9, 1.8>
    translate  <-6.0, 1.9, 8.8>
  }
  rotate -5.5*x
  translate  <6.0, -0.5, 0.0>
}
#declare BaseBotaIzq = union {
  sphere { // Esfera3
    <0,0,0>,1
    rotate -90.0*x
    translate  <0.0, 2.0, 0.0>
  }
  cylinder { // Cilindro3
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
  }
  sphere { // Esfera4
    <0,0,0>,1
    scale <1.0, 1.0, 1.5>
    rotate -90.0*x
  }
}
#declare BotaIzqA = difference {
  object { BaseBotaIzq }
  box { // SuelaIzq
    <-1, -1, -1>, <1, 1, 1>
    texture {
      tSuela
    }
    scale <1.1, 2.3, 0.5>
    translate  <0.0, 0.7, -0.6>
  }
  scale 0.5
  rotate <-20.0, 0.0, 0.0>
  translate  <-1.1, -2.663175, 3.912831>
}
#declare BotaIzq = union {
  object { BotaIzqA }
  cone { // BotaIzqB
    <0,0,0>, 1.0, <0,0,1>, 1.2
    scale <0.45, 0.5, 1.5>
    rotate <-20.0, 0.0, 0.0>
    translate  <-1.1, -1.817451, 3.605013>
  }
  texture {
    tPlasBlanco
  }
  scale 2.0
  rotate 75.0*x
  translate  <2.2, 13.93757, 3.719428>
}
#declare PiernaIzq = union {
  object { PiernaIzqA }
  object { PiernaIzqB }
  object { BotaIzq }
  rotate <-75.0, 0.0, 0.0>
  translate  <-3.2, -6.6, 12.1>
}
#declare BrazoDerD = union {
  sphere { // ManoDerA
    <0,0,0>,1
    scale <0.3, 0.5, 0.48>
    rotate <7.367919, -7.978267, -5.262405>
    translate  <-3.92, -0.48, 6.27>
  }
  sphere { // ManoDerB
    <0,0,0>,1
    scale <0.2, 0.5, 0.4>
    rotate <18.972126, -37.026497, 7.640275>
    translate  <-3.91, -0.67, 6.12>
  }
  cone { // BrazoDerE
    <0,0,0>, 0.8, <0,0,1>, 0.6
    scale <0.5, 0.6, 1.7>
    rotate <126.134743, 15.028263, 5.548641>
    translate  <-3.629553, 1.158018, 7.386035>
  }
  rotate <-43.377895, -17.968187, 10.356843>
  translate  <7.549139, -8.758807, 5.163818>
}
#declare BrazoDer = union {
  sphere { // BrazoDerA
    <0,0,0>,1
    scale <0.5, 0.6, 0.5>
    translate  <1.7, -3.8, 10.1>
  }
  cone { // BrazoDerB
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <0.5, 0.6, 1.7>
    translate  <1.7, -3.8, 8.4>
  }
  sphere { // BrazoDerC
    <0,0,0>,1
    scale <0.4, 0.5, 0.5>
    translate  <1.7, -3.8, 8.4>
  }
  object { BrazoDerD }
  scale 2.0
  rotate <10.627584, 19.683498, 3.616441>
  translate  <-17.2, 12.94, 1.29>
}
#declare BrazoIzqD = union {
  sphere { // ManoIzqA
    <0,0,0>,1
    scale <0.3, 0.5, 0.4>
    rotate <10.0, 0.0, 0.0>
    translate  <-3.9, -0.473637, 6.273821>
  }
  sphere { // ManoIzqB
    <0,0,0>,1
    scale <0.2, 0.5, 0.4>
    rotate <11.508393, -29.498703, -5.725105>
    translate  <-3.9, -0.653234, 6.14061>
  }
  cone { // BrazoIzqE
    <0,0,0>, 0.8, <0,0,1>, 0.6
    scale <0.5, 0.6, 1.7>
    rotate <126.134743, 15.028263, 5.548641>
    translate  <-3.629553, 1.158018, 7.386035>
  }
  rotate <164.533173, -22.205, 161.620087>
  translate  <-0.039068, -6.594383, 16.016333>
}
#declare BrazoIzq = union {
  sphere { // BrazoIzqA
    <0,0,0>,1
    scale <0.5, 0.6, 0.5>
    translate  <1.7, -3.8, 10.1>
  }
  cone { // BrazoIzqB

    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <0.5, 0.6, 1.7>
    translate  <1.7, -3.8, 8.4>
  }
  sphere { // BrazoIzqC
    <0,0,0>,1
    scale <0.4, 0.5, 0.5>
    translate  <1.7, -3.8, 8.4>
  }
  object { BrazoIzqD }
  scale 2.0
  rotate <8.478468, -15.252625, 3.529336>
  translate  <-0.95, 12.94, -1.51>
}
#declare Astro1 = union {
  object { Tronco1 }
  object { Bandera }
  object { Casco }
  object { PiernaDer }
  object { PiernaIzq }
  object { BrazoDer }
  object { BrazoIzq }
  object { Mochila1 }
  texture { tRopa rotate <0,90,0>}
  scale 0.65
  rotate <0, 0, 65>
  translate  <-6.9, 27, -19.8> }

#declare Astros = union {
  object { Astro2 }
  object { Astro1 }

  translate  <-43.349, 0.0, -5.93> }
#declare Hueco = union {
  cylinder { // HuecoA
    <0,0,1>, <0,0,0>, 1 
    scale <1.7, 0.5, 1.0>
    rotate -90.0*x
    translate  <7.6, -2.2, -4.3>
  }
  box { // HuecoB
    <-1, -1, -1>, <1, 1, 1>
    scale <1.7, 0.5, 1.0>
    translate  <7.6, -1.7, -5.3>
  }
  scale <2.0, 4.0, 3.5>
  rotate -90.0*z
  translate  <-10.5, 0.0, 27.4>
}
#declare HuecoPuerta = difference {
  box { // Entrada
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 5.0, 6.0>
    rotate <0.0, -10.0, 0.0>
    translate  <-14.6, -15.3, 10.4>
  }
  object { Hueco }
  translate  0.8*x
}
#declare PuertaA = union {
  cylinder { // PomoB2
    <0,0,1>, <0,0,0>, 1 
    texture {
      tMetal
    }
    scale <0.1, 0.1, 1.7>
    rotate <-45.0, 0.0, 0.0>
    translate  <13.18, 14.73, 27.999999>
  }
  cylinder { // PomoB1
    <0,0,1>, <0,0,0>, 1 
    texture {
      tMetal
    }
    scale <0.1, 0.1, 1.7>
    rotate <45.0, 0.0, 0.0>
    translate  <13.18, 15.92, 27.999999>
  }
  cylinder { // PomoB
    <0,0,1>, <0,0,0>, 1 
    texture {
      tPlasNegro
    }
    scale <0.3, 0.3, 1.0>
    rotate <0.0, -90.0, 0.0>
    translate  <13.9, 15.31, 28.599999>
  }
  torus { // Pomo
    0.95, 0.15  rotate -x*90
    texture {
      tPlasNegro
    }
    rotate <0.0, -90.0, 0.0>
    translate  <13.17, 15.32, 28.599999>
  }
  object { Puerta3 }
  box { // Puerta1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 2.4, 2.6>
    translate  <13.8, 15.3, 28.6>
  }
  object { // Puerta4->Puerta3
    Puerta3
    translate  -3.45*z
  }
  scale 1.2
  rotate 0.0*z
  translate  <-31.2, -33.579999, -24.609999>
}
#declare Puerta = union {
  object { HuecoPuerta }
  object { PuertaA }
  texture {
    tNave
  }
  translate  <15.8, 15.3, -19.8>
}
#declare Grupo = union {
  object { Parte1 }
  object { // Parte2->Parte1
    Parte1
    rotate -60.0*z
    translate  <7.3, 12.3, 0.0>
  }
  object { // Parte3->Parte1
    Parte1
    rotate -120.0*z
    translate  <9.0, -9.4, 0.0>
  }
  object { // Parte4->Parte1
    Parte1
    rotate 120.0*z
    translate  <21.5, -12.3, 0.0>
  }
  object { // Parte5->Parte1
    Parte1
    rotate 60.0*z
    translate  <19.8, 9.4, 0.0>
  }
  object { // Parte6->Parte1
    Parte1
    rotate 0.0*z
    translate  25.3*x
  }
  translate  <-41.7, 0.0, 23.1>
}
#declare Cuerpo = union {
  cylinder { // Cilindro
    <0,0,1>, <0,0,0>, 1 
    scale <16.0, 16.0, 8.5>
    translate  <-27.319999, -0.12, 38.399999>
  }
  cone { // TechoA
    <0,0,0>, 16.0, <0,0,1>, 14.0
    scale <1.0, 1.0, 2.0>
    translate  <-27.3, -0.1, 46.900001>
  }
  cylinder { // Cilindro1
    <0,0,1>, <0,0,0>, 1 
    scale <13.0, 13.0, 12.0>
    translate  <-27.3, 0.0, 28.0>
  }
  object { Grupo }
  box { // Parte7
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 5.0, 6.0>
    rotate <0.0, 10.0, -60.0>
    translate  <-21.0, -10.6, 33.5>
  }
  cone { // TechoA1
    <0,0,0>, 10.0, <0,0,1>, 7.5
    scale <1.0, 1.0, 2.6>
    translate  <-27.299999, -0.1, 48.879999>
  }
  texture {
    tNave
  }
  translate  <41.7, 0.0, -42.9>
}
#declare Escalera = union {
  object { Esca1 }
  box { // EscA
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 6.0>
    translate  <-10.2, 2.6, -1.9>
  }
  box { // EscA1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 6.0>
    translate  <-10.2, -2.4, -1.9>
  }
  object { // Esca2->Esca1
    Esca1
    rotate <0.0, 0.0, 0.0>
    translate  9.3*z
  }
  object { // Esca3->Esca1
    Esca1
    rotate <0.0, 0.0, 0.0>
    translate  4.6*z
  }
  object { // Esca4->Esca1
    Esca1
    rotate <0.0, 0.0, 0.0>
    translate  2.3*z
  }
  object { // Esca5->Esca1
    Esca1
    rotate <0.0, 0.0, 0.0>
    translate  6.9*z
  }
  texture {
    tMetal
  }
  rotate 21.0*y
  translate  <0.8, 0.0, -23.9>
}
#declare CsgAnt = difference {
  cone { // AntenaA
    <0,0,0>, 0.5, <0,0,1>, 3.0
    scale <1.5, 1.5, 2.0>
    rotate -90.0*y
    translate  <52.989999, -17.99, 45.049999>
  }
  cone { // AntenaB
    <0,0,0>, 0.5, <0,0,1>, 3.0
    scale <1.5, 1.5, 2.0>
    rotate -90.0*y
    translate  <52.899999, -17.99, 45.049999>
  }
  translate  <0.0, 0.92, -0.07>
}
#declare Antena = union {
  cylinder { // Ant1
    <0,0,1>, <0,0,0>, 1 
    texture {
      tPlasNegro
    }
    scale <0.4, 0.4, 8.0>
    rotate <70.0, 0.0, 0.0>
    translate  <53.049999, -9.61, 42.249999>
  }
  cylinder { // Ant2
    <0,0,1>, <0,0,0>, 1 
    texture {
      tPlasNegro
    }
    scale <0.4, 0.4, 8.0>
    rotate <40.0, 0.0, 0.0>
    translate  <53.049999, -12.02, 38.889999>
  }
  object { CsgAnt }
  cylinder { // Ant3
    <0,0,1>, <0,0,0>, 1 
    scale <0.35, 0.35, 4.0>
    rotate -90.0*y
    translate  <53.049999, -17.08, 44.979999>
  }
  cylinder { // Ant4
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.2>
    rotate -90.0*y
    translate  <49.449999, -17.09, 44.979999>
  }
  texture {
    tNave
  }
  rotate <0.0, 0.0, -12.0>
  translate  <-42.779999, 7.96, -37.019999>
}
#declare Baranda = union {
  object { BarandaA1 }
  object { BarandaA2 }
  object { // BarandaB1->BarandaA1
    BarandaA1
    translate  <4.1, -4.87, 0.0>
  }
  object { // BarandaB2->BarandaA2
    BarandaA2
    rotate 0.0*z
    translate  <4.1, -4.87, 0.0>
  }
  object { // BarandaB3->BarandaA2
    BarandaA2
    rotate 0.0*z
    translate  <-4.67, -3.85, -1.55>
  }
  object { // BarandaB4->BarandaA2
    BarandaA2
    rotate 0.0*z
    translate  <-0.57, -8.72, -1.53>
  }
  texture {
    tMetal
  }
  rotate <0.0, 0.0, -40.0>
  translate  <-26.145166, 31.350386, -38.92>
}
#declare Nave = union {
  box { // Plataforma
    <-1, -1, -1>, <1, 1, 1>
    texture {
      tPlata
    }
    scale <3.6, 3.6, 0.2>
    rotate -15.0*y
    translate  <-3.9, 0.0, -15.6>
  }
  object { Puerta }
  object { PataA }
  object { // PataB->PataA
    PataA
    rotate 120.0*z
    translate  <21.7, -12.4, 0.0>
  }
  object { // PataC->PataA
    PataA
    rotate -120.0*z
    translate  <21.5, 12.6, 0.0>
  }
  object { Cuerpo }
  object { // Motor2->Motor1
    Motor1
    translate  <0.1, 27.9, 0.0>
  }
  object { // Motor3->Motor1
    Motor1
    translate  <23.64, 18.47, 0.0>
  }
  object { Motor1 }
  object { Escalera }
  box { // Cartel
    <-1, -1, -1>, <1, 1, 1>
    texture {
      tCartel
      scale <2.0, 2.0, 1.0>
  translate <-1.000000, -1.000000, 0.000000>
    }
    scale <3.0, 2.5, 0.1>
    rotate <90.0, 0.000001, 150.0>
    translate  <3.36, -13.88, -1.17>
  }
  object { Brazo1 }
  cone { // Antena1
    <0,0,0>, 0.2, <0,0,1>, 0.1
    texture {
      tNave
    }
    scale <1.5, 1.5, 7>
    rotate <0.0, 0.0, -40.0>
    translate  <9.72, 8.2, 6.2>
  }
  cone { // Antena2
    <0,0,0>, 0.4, <0,0,1>, 0.1
    texture {
      tMetal
    }
    scale <1,1,4>
    rotate <-90.0, 0.0, 90.0>
    translate  <-3.066375, -4.867828, 0.519999>
  }
  sphere { // Adorno
    <0,0,0>,1
    texture {
      tNave
    }
    scale <2.0, 0.5, 2.0>
    rotate <0.0, 0.0, -90.0>
    translate  <-3.19, 1.71, -0.9>
  }
  object { Adorno2 }
  box { // PiezaB1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      tNave
    }
    scale <3.0, 3.0, 2.5>
    rotate <0.0, 0.0, -30.0>
    translate  <1.495029, 7.413426, -0.990001>
  }
  box { // PiezaB2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      tNave
    }
    scale <3.0, 3.0, 2.5>
    rotate <0.0, 0.0, 15.0>
    translate  <13.546437, -15.452735, -0.990001>
  }
  box { // PiezaB
    <-1, -1, -1>, <1, 1, 1>
    texture {
      tNave
    }
    scale <3.0, 3.0, 2.5>
    rotate <0.0, 0.0, -60.0>
    translate  <1.497328, -7.378767, -0.990001>
  }
  object { Antena }
  object { // Brazo2->Brazo1
    Brazo1
    rotate <-180.0, -0.000001, -4.999992>
    translate  <-0.54, 0.21, -20.21>
  }
  object { // Adorno3->Adorno2
    Adorno2
    rotate <0.0, 0.0, 0.0>
    translate  <0.01, 7.12, 0.0>
  }
  object { Baranda }
  translate  19.8*z }

#declare Nave_Astro = union { // NayAs
  object { Astros }
  object { Nave }
  rotate 40.0*z
  translate  <40.179999, -7.21, 19.12> }

// --- ESCENA ----

// -- Estrellas --
  object { Estrella translate <200,170,600>}    
  object { Estrella translate <-300,300,600>}
 
// -- Monstruo --
  object { Monstruo rotate <-90,-170,0> scale 0.15 translate <-0.8,2,8> }

// -- Nave y Astronautas
  object { Nave_Astro rotate <-90,190,0> scale 0.15 translate <1.5,2.1,11.4> }
 
// -- Planeta --
  object {Planeta translate <5,152,500>  }

// -- Asteroide --
  sphere {  <225,208,535>,16 texture { tAsteroide } }

// -- Agua -- 
  plane { <0, 1, 0> ,+1.2 texture { TexAgua } }

// -- Suelo --

 object { Suelo translate < -13,    0, 1.5> }
 object { Suelo translate < -30, 0, 7  > scale <2,2.5,2> }