//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 3 lights, 21 textures and 65 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE V2.02.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 10/21/1996    (21.10.1996)
//

#max_trace_level 5

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//

#include "pool1.mrc"




camera {  //  Camera StdCam
  location  <17.200, -45.000, 3.700>
  direction <0.0,     0.0,  2.2210>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <3.300, -11.300, -0.800>
}

// *******  L I G H T S *******
light_source { // AreaL002
  <0.000, 3.300, 14.100>
  color  rgb<0.588, 0.588, 0.588>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
}


light_source {   // Light006
  <131.500, 28.300, 15.700>
  color rgb <0.165, 0.165, 0.165>
}

light_source { // AreaL001
  <0.000, 1.000, 11.700>
  color  rgb<0.576, 0.576, 0.576>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 5, 5
  adaptive 3
  jitter
}



// ********  TEXTURES  *******
//

#include "pool1.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******

/*
cone { // SunStuff
  <0,0,0>, 0.0, <0,0,1>, 1.0
  texture {
    SunText
  }
  scale <0.2, 0.6, 4.0>
  rotate <-65.0, 90.0, 0.0>
  translate  <5.0, -26.2, 0.0>
}
*/


box { // Strap1
  <-1, -1, -1>, <1, 1, 1>
  scale <0.1, 0.6, 1.0>
  rotate -45.0*z
  translate  <-19.7, 39.700001, -1.6>
  texture {
    DMFWood6
  }
}


box { // Strap
  <-1, -1, -1>, <1, 1, 1>
  scale <0.1, 0.6, 1.0>
  translate  <-20.1, 0.0, -1.6>
  texture {
    DMFWood6
  }
}


box { // Wall2
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallTX
  }
  scale <50.0, 1.0, 40.0>
  rotate <90.0, 0.0, 90.0>
  translate  <7.2, 18.9, 39.000001>
}


#declare CompleteSun = union {
  sphere { // Sun
    <0,0,0>,1
    texture {
      SunText
    }
    no_shadow
    translate  <9.7, -28.9, 0.0>
  }
  translate  <-0.7, 3.3, 0.0>
}
#declare Saturn = union {
  sphere { // Saturn_Body
    <0,0,0>,1
    texture {
      Candy_Cane1
    }
  }
  cylinder { // Saturn_Rings
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rings
    }
    scale <2.0, 2.0, 0.1>
    translate  -0.05*z
  }
  rotate <24.113173, -10.131329, 25.803518>
  translate  <3.9, -9.6, 0.0>
}
union { // Balls
  object { CompleteSun }
  object { Saturn }
  sphere { // Jupiter
    <0,0,0>,1
    texture {
      Candy_Cane2
    }
    translate  <12.7, -16.9, 0.0>
  }
  sphere { // Mars
    <0,0,0>,1
    texture {
      MarsTx
    }
    translate  <13.2, -25.4, 0.0>
  }
  sphere { // Venus
    <0,0,0>,1
    texture {
      Candy_Cane1
    }
    translate  <12.8, -34.600001, 0.0>
  }
  sphere { // Planet
    <0,0,0>,1
    texture {
      Cork1
    }
    translate  <14.2, -31.3, 0.0>
  }
  translate  <-1.3, 3.1, 0.0>
}






#declare LampShade = difference {
  box { // OuterLamp
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Felt
    }
  }
  box { // InnerLamp
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MarsTx
    }
    scale 0.9
    translate  -0.2*z
  }
  scale <2.6, 4.6, 3.3>
  translate  0.2*y
}
union { // Lamp
  object { LampShade }
  translate  <0.0, 0.9, 14.3>
}


box { // Wall1
  <-1, -1, -1>, <1, 1, 1>
  scale <50.0, 1.0, 40.0>
  rotate 90.0*z
  translate  <-32.4, 18.9, 0.0>
  texture {
    WallTX
  }
}


cylinder { // Tack
  <0,0,1>, <0,0,0>, 1 
  texture {
    BlackHole
  }
  scale <0.2, 0.2, 0.4>
  rotate 90.0*x
  translate  <-12.1, 67.300001, 8.8>
}


box { // Cube002
  <-1, -1, -1>, <1, 1, 1>
  texture {
    PaperTX
  }
  scale <2.1, 0.2, 2.3>
  translate  <-12.2, 67.700001, 7.2>
}


difference { // PoolTable
  box { // PoolTableTop
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Felt
    }
    scale <20.0, 40.0, 1.0>
    translate  -2.0*z
  }
  cylinder { // HolePunch
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 4.2>
    translate  <-18.0, 38.0, -2.1>
    texture {
      DMFWood6
    }
  }
  cylinder { // HolePunch1
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 4.2>
    translate  <18.0, 38.0, -2.1>
    texture {
      DMFWood6
    }
  }
  cylinder { // HolePunch2
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 4.2>
    translate  <18.0, 0.0, -2.1>
    texture {
      DMFWood6
    }
  }
  cylinder { // HolePunch3
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood6
    }
    scale <3.0, 3.0, 4.2>
    translate  <18.0, -38.0, -2.1>
  }
  cylinder { // HolePunch4
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFWood6
    }
    scale <3.0, 3.0, 4.2>
    translate  <-18.0, -38.0, -2.1>
  }
  cylinder { // HolePunch5
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 4.2>
    translate  <-18.0, 0.0, -2.1>
    texture {
      DMFWood6
    }
  }
}


box { // Cube001
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Jade1
  }
  scale <8.0, 1.0, 6.0>
  translate  <-10.4, 68.600001, 7.8>
}


//
// Include file contains 'PoolQ'
//
#include "pool1.in1"
#declare PoolQ = object {
  PoolQ_Raw
  texture {
    Rosewood2
  }
  scale <0.2, 0.2, 4.0>
}
//
// Include file contains 'PoolTip2'
//
#include "pool1.in2"
#declare PoolTip2 = object {
  PoolTip2_Raw
  texture {
    Felt2
  }
  scale <0.18, 0.18, 0.2>
  translate  -2.2*z
}
union { // PoolQObj
  object { PoolQ }
  object { PoolTip2 }
  cylinder { // PoolQTip
    <0,0,1>, <0,0,0>, 1 
    texture {
      PoolTip1
    }
    scale <0.27, 0.27, 1.0>
    translate  -2.2*z
  }
  rotate <74.660194, 48.973537, 143.307922>
  translate  <10.2, -18.3, 1.1>
}


box { // Wall
  <-1, -1, -1>, <1, 1, 1>
  scale <50.0, 1.0, 40.0>
  translate  <-10.7, 69.700001, 0.0>
  texture {
    WallTX
  }
}


// Include contains 'Side3'
#include "pool1.in3"

object {
  Side3_Raw
  texture {
    Felt
  }
  scale <1.0, 1.0, 40.0>
  rotate <90.0, 0.0, 90.0>
  translate  <-20.0, -39.0, 0.0>
}


// Include contains 'Side2'
#include "pool1.in4"

object {
  Side2_Raw
  texture {
    Felt
  }
  scale <1.0, 1.0, 40.0>
  rotate <90.0, 0.0, -90.0>
  translate  <20.0, 39.0, 0.0>
}


// Include contains 'Side1'
#include "pool1.in5"

object {
  Side1_Raw
  texture {
    Felt
  }
  scale <1.0, 1.0, 80.0>
  rotate <90.0, 0.0, -180.0>
  translate  <19.0, -40.0, 0.0>
}


// Include contains 'Side'
#include "pool1.in6"

object {
  Side_Raw
  texture {
    Felt
  }
  scale <1.0, 1.0, 80.0>
  rotate 90.0*x
  translate  <-19.0, 40.0, 0.0>
}


#declare PoolQRack = difference {
  box { // Top
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 1.0>
    translate  6.0*z
    texture {
      DMFLightOak1
    }
  }
  cylinder { // Holes
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 10.0>
    translate  <-6.5, 0.0, -0.7>
    texture {
      DMFLightOak1
    }
  }
  cylinder { // Holes1
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFLightOak1
    }
    scale <0.7, 0.7, 10.0>
    translate  <-4.0, 0.0, -0.7>
  }
  cylinder { // Holes2
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFLightOak1
    }
    scale <0.7, 0.7, 10.0>
    translate  <-1.5, 0.0, -0.7>
  }
  cylinder { // Holes3
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFLightOak1
    }
    scale <0.7, 0.7, 10.0>
    translate  <1.5, 0.0, -0.7>
  }
  cylinder { // Holes4
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFLightOak1
    }
    scale <0.7, 0.7, 10.0>
    translate  <4.0, 0.0, -0.7>
  }
  cylinder { // Holes5
    <0,0,1>, <0,0,0>, 1 
    texture {
      DMFLightOak1
    }
    scale <0.7, 0.7, 10.0>
    translate  <6.5, 0.0, -0.7>
  }
}
//
// Include file contains 'PoolQ1'
//
#include "pool1.in7"
#declare PoolQ1 = object {
  PoolQ1_Raw
  scale <0.2, 0.2, 4.0>
  texture {
    Rosewood1
  }
}
//
// Include file contains 'PoolTip3'
//
#include "pool1.in8"
#declare PoolTip3 = object {
  PoolTip3_Raw
  texture {
    Felt1
  }
  scale <0.18, 0.18, 0.2>
  translate  -2.2*z
}
#declare PoolQObj1 = union {
  object { PoolQ1 }
  object { PoolTip3 }
  cylinder { // PoolQTip1
    <0,0,1>, <0,0,0>, 1 
    texture {
      PoolTip
    }
    scale <0.27, 0.27, 1.0>
    translate  -2.2*z
  }
  scale <1.0, 1.0, 0.5>
  translate  <-4.0, 0.0, 0.7>
}
//
// Include file contains 'PoolQ2'
//
#include "pool1.in9"
#declare PoolQ2 = object {
  PoolQ2_Raw
  scale <0.2, 0.2, 4.0>
  texture {
    Rosewood1
  }
}
//
// Include file contains 'PoolTip4'
//
#include "pool1.i10"
#declare PoolTip4 = object {
  PoolTip4_Raw
  texture {
    Felt1
  }
  scale <0.18, 0.18, 0.2>
  translate  -2.2*z
}
#declare PoolQObj2 = union {
  object { PoolQ2 }
  object { PoolTip4 }
  cylinder { // PoolQTip2
    <0,0,1>, <0,0,0>, 1 
    texture {
      PoolTip
    }
    scale <0.27, 0.27, 1.0>
    translate  -2.2*z
  }
  scale <1.0, 1.0, 0.5>
  translate  <-1.5, 0.0, 0.7>
}
//
// Include file contains 'PoolQ3'
//
#include "pool1.i11"
#declare PoolQ3 = object {
  PoolQ3_Raw
  scale <0.2, 0.2, 4.0>
  texture {
    Rosewood1
  }
}
//
// Include file contains 'PoolTip5'
//
#include "pool1.i12"
#declare PoolTip5 = object {
  PoolTip5_Raw
  texture {
    Felt1
  }
  scale <0.18, 0.18, 0.2>
  translate  -2.2*z
}
#declare PoolQObj3 = union {
  object { PoolQ3 }
  object { PoolTip5 }
  cylinder { // PoolQTip3
    <0,0,1>, <0,0,0>, 1 
    texture {
      PoolTip
    }
    scale <0.27, 0.27, 1.0>
    translate  -2.2*z
  }
  scale <1.0, 1.0, 0.5>
  translate  <1.4, 0.0, 0.7>
}
//
// Include file contains 'PoolQ4'
//
#include "pool1.i13"
#declare PoolQ4 = object {
  PoolQ4_Raw
  scale <0.2, 0.2, 4.0>
  texture {
    Rosewood1
  }
}
//
// Include file contains 'PoolTip6'
//
#include "pool1.i14"
#declare PoolTip6 = object {
  PoolTip6_Raw
  texture {
    Felt1
  }
  scale <0.18, 0.18, 0.2>
  translate  -2.2*z
}
#declare PoolQObj4 = union {
  object { PoolQ4 }
  object { PoolTip6 }
  cylinder { // PoolQTip4
    <0,0,1>, <0,0,0>, 1 
    texture {
      PoolTip
    }
    scale <0.27, 0.27, 1.0>
    translate  -2.2*z
  }
  scale <1.0, 1.0, 0.5>
  translate  <4.1, 0.0, 0.7>
}
//
// Include file contains 'PoolQ5'
//
#include "pool1.i15"
#declare PoolQ5 = object {
  PoolQ5_Raw
  scale <0.2, 0.2, 4.0>
  texture {
    Rosewood1
  }
}
//
// Include file contains 'PoolTip7'
//
#include "pool1.i16"
#declare PoolTip7 = object {
  PoolTip7_Raw
  texture {
    Felt1
  }
  scale <0.18, 0.18, 0.2>
  translate  -2.2*z
}
#declare PoolQObj5 = union {
  object { PoolQ5 }
  object { PoolTip7 }
  cylinder { // PoolQTip5
    <0,0,1>, <0,0,0>, 1 
    texture {
      PoolTip
    }
    scale <0.27, 0.27, 1.0>
    translate  -2.2*z
  }
  scale <1.0, 1.0, 0.5>
  translate  <6.5, 0.0, 0.7>
}
//
// Include file contains 'PoolQ6'
//
#include "pool1.i17"
#declare PoolQ6 = object {
  PoolQ6_Raw
  scale <0.2, 0.2, 4.0>
  texture {
    Rosewood1
  }
}
//
// Include file contains 'PoolTip8'
//
#include "pool1.i18"
#declare PoolTip8 = object {
  PoolTip8_Raw
  texture {
    Felt1
  }
  scale <0.18, 0.18, 0.2>
  translate  -2.2*z
}
#declare PoolQObj6 = union {
  object { PoolQ6 }
  object { PoolTip8 }
  cylinder { // PoolQTip6
    <0,0,1>, <0,0,0>, 1 
    texture {
      PoolTip
    }
    scale <0.27, 0.27, 1.0>
    translate  -2.2*z
  }
  scale <1.0, 1.0, 0.5>
  translate  <-6.5, 0.0, 0.7>
}
#declare AllPoolQ = union {
  object { PoolQObj1 }
  object { PoolQObj2 }
  object { PoolQObj3 }
  object { PoolQObj4 }
  object { PoolQObj5 }
  object { PoolQObj6 }
  rotate <180.0, 0.0, 180.0>
  translate  16.1*z
}
union { // Rack
  box { // BottomBase
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.0, 0.3>
    translate  -0.9*z
    texture {
      DMFLightOak1
    }
  }
  object { PoolQRack }
  object { AllPoolQ }
  scale 0.8
  rotate 90.0*z
  translate  <-30.5, 22.5, -1.3>
}


#declare Frame = difference {
  box { // FrameBase
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 1.0, 1.1>
    translate  -0.1*y
    texture {
      DMFWood6
    }
  }
  box { // FrameHole
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.2, 1.0>
    texture {
      DMFWood6
    }
  }
}
union { // Mirror
  object { Frame }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Silver_Textur1
    }
    rotate 90.0*x
  }
  scale <3.0, 0.1, 3.0>
  rotate 90.0*z
  translate  <-31.3, 43.900001, 6.5>
}


