/*
	Basic Ringworld Geometry - units are gigameters and seconds.

	Most of these numbers were taken from "Ringworld", by Larry
	Niven.  I translated them from miles, days, etc. into gigameters
	and seconds.  A few numbers were calculated.

	RW - Ringworld parameters
	SS - Shadow Squares (which aren't square...)
	SUN - Ringworld Sun parameters

	The Sun is at location (0, 0, 0) with the axis along the Z axis.
	The ring lies in the XY plane, centered on Z = 0.

	Items for which I could find no reference, or which I haven't
	yet calculated are marked UNKNOWN and any value given is just
	a placeholder.

	Copyright, James W. Williams, April 1995

 */

#define RW_radius		1.53000e2
#define RW_airRadius		1.52999e2	/* Just inside the ring */
#define RW_width		1.60000
#define RW_airWidth		1.60000
#define RW_rimHeight		1.60000e-3
#define RW_rimThickness		0.10000		/* UNKNOWN */

#define SUN_radius		RW_width/2

/* The Shadow Squares */
#define SS_radius		3.85000e1	/* Distance from Sun */
#define SS_length		4.03000
#define SS_width		RW_width
#define SS_thickness		.001		/* UNKNOWN */
#define SS_number		20

/* Motion Parameters */
#define RW_period		810000		/* sec */
#define RW_angularVelocity	7.75000e-6	/* rad/sec */
#define SS_period		1.0		/* UNKNOWN */
#define SS_angularVelocity	1.0		/* UNKNOWN */

