//  Persistance of Vision Raytracer V2.0
//  RWSEXPLORER.pov  ---  The spaceship "Explorer"

#include "CONSTS.inc"
#include "COLORS.inc"
#include "TEXTURES.inc"
#include "SHAPES.inc"
#include "SHAPES2.INC"

// #declare DEBUG= 1


global_settings {
   max_trace_level 16
}


// ***  C A M E R A  ***
#ifdef (DEBUG)
   // Debug Camera
   camera {
      location  < 0, 150, 0 >
      direction < 0, 0, 1.5 >
      sky       < 1, 0, 0 >
      up        < 1, 0, 0 >
      right     < 0, 0, 1.3333 >
      look_at   < 0, 0, 0 >
   }
#else
   // Normal Camera
   camera {
      location  < 0, 150, 0 >
      direction < 0, 0, 1.5 >
      sky       < 1, 0, 0 >
      up        < 1, 0, 0 >
      right     < 0, 0, 1.3333 >
      look_at   < 0, 0, 0 >
   }
#end


// ***  L I G H T S  ***

object {
   light_source {
      <-30, 200, -20>
      color rgb <2.0, 0.9, 0.8>
      looks_like {
         sphere { <0,0,0>, 2 }
         pigment { color rgb <2.0, 0.9, 0.8> }
         finish { Luminous }
      }
   }
}

object {
   light_source {
      <70, 200, 50>
      color rgb <0.5, 0.4, 0.2>
      looks_like {
         sphere { <0,0,0>, 2 }
         pigment { color rgb <0.5, 0.4, 0.2> }
         finish { Luminous }
      }
   }
}


// ***  B A C K G R O U N D  ***
#declare Starfield1 =
texture {
    pigment {
        granite
        color_map {
            [ 0.000 0.260  color rgb < 0,   0,   0>   color rgb < 0,   0,   0>   ]
            [ 0.260 0.300  color rgb < 6,   6,   5>   color rgb < 8,   8,   6>   ]
            [ 0.300 0.460  color rgb < 0,   0,   0>   color rgb < 0,   0,   0>   ]
            [ 0.460 0.500  color rgb < 5,   5,   7>   color rgb < 6,   6,   8>   ]
            [ 0.500 0.660  color rgb < 0,   0,   0>   color rgb < 0,   0,   0>   ]
            [ 0.660 0.700  color rgb < 6,   4,   4>   color rgb < 8,   4,   4>   ]
            [ 0.700 0.840  color rgb < 0,   0,   0>   color rgb < 0,   0,   0>   ]
            [ 0.840 0.900  color rgb < 8,   8,   8>   color rgb <10,  10,  10>   ]
            [ 0.900 1.000  color rgb < 0,   0,   0>   color rgb < 0,   0,   0>   ]
        }
    turbulence 0.2
    sine_wave
    }
    finish { diffuse 0 ambient 1 }
}

#declare Starfield2 =
texture {
    pigment {
        granite
        color_map {
            [ 0.000 0.240  color rgb < 0,   0,   0>   color rgb < 0,   0,   0>   ]
            [ 0.240 0.300  color rgb < 4,   4,   3>   color rgb < 6,   6,   4>   ]
            [ 0.300 0.440  color rgb < 0,   0,   0>   color rgb < 0,   0,   0>   ]
            [ 0.440 0.500  color rgb < 3,   3,   4>   color rgb < 3,   3,   6>   ]
            [ 0.500 0.540  color rgb < 0,   0,   0>   color rgb < 0,   0,   0>   ]
            [ 0.540 0.590  color rgb < 0.5, 0.5, 0.5> color rgb < 0.3, 0.3, 0.3> ]
            [ 0.590 0.640  color rgb < 0,   0,   0>   color rgb < 0,   0,   0>   ]
            [ 0.640 0.700  color rgb < 4,   3,   3>   color rgb < 6,   3,   3>   ]
            [ 0.700 0.810  color rgb < 0,   0,   0>   color rgb < 0,   0,   0>   ]
            [ 0.810 0.900  color rgb < 6,   6,   6>   color rgb <10,  10,  10>   ]
            [ 0.900 1.000  color rgb < 0,   0,   0>   color rgb < 0,   0,   0>   ]
        }
    turbulence 0.2
    sine_wave
    }
    finish { diffuse 0 ambient 1 }
}

#declare SkySparse = texture {
   Starfield1 scale 0.5
}
#declare SkyDense = texture {
   Starfield2 scale 0.25
}

#declare Sky = object {
   sphere { <0,0,0>, 0.95 hollow }
   texture {
      gradient x
      turbulence 0.5
      octaves 8
      lambda 4
      texture_map {
         [ 0.0  SkySparse ]
         [ 0.03 SkyDense ]
         [ 0.07 SkyDense ]
         [ 0.1  SkySparse ]
         [ 0.9  SkySparse ]
         [ 0.93 SkyDense ]
         [ 0.97 SkyDense ]
         [ 1.0  SkySparse ]
      }
   }

   rotate <0, -30, -10>
   scale 750
}


// ***  O B J E C T S ***

// ***  The New Star and its surrounding nebula
#declare NewPosition = < 40, -180, -95 >
#declare NewColor = color rgb <0.5, 0.8, 4.0>

#declare NewStar = object {
   light_source {
      NewPosition
      color NewColor
      fade_distance 200
      fade_power 2

      looks_like {
         sphere { <0,0,0>, 1 }
         pigment { color NewColor }
         finish { Luminous }
      }
   }
   no_shadow
}

// ***  The Nebulae around the New Star
#declare Nebula = union {
   sphere { 0, 1
      hollow
      pigment { Clear }

      halo {
         dust
         dust_type 4
         linear
         max_value 1.0
         spherical_mapping

         turbulence 0.1
         octaves 3
         samples 12
         color_map {
            [ 0.0  color rgbft <1.0, 0.7, 1.0, 0.0, 1.0> ]
            [ 0.15 color rgbft <0.6, 0.4, 1.0, 0.1, 0.7> ]
            [ 0.2  color rgbft <0.4, 0.3, 1.0, 0.3, 0.5> ]
            [ 0.3  color rgbft <0.4, 0.3, 1.0, 0.3, 0.5> ]
            [ 0.35 color rgbft <0.6, 0.4, 1.0, 0.0, 1.0> ]
            [ 0.4  color rgbft <0.4, 0.3, 1.0, 0.1, 0.7> ]
            [ 0.45 color rgbft <0.2, 0.2, 1.0, 0.5, 0.3> ]
            [ 0.5  color rgbft <0.2, 0.2, 1.0, 0.5, 0.3> ]
            [ 0.55 color rgbft <0.6, 0.5, 1.0, 0.0, 1.0> ]
            [ 0.75 color rgbft <0.6, 0.5, 1.0, 0.0, 1.0> ]
            [ 0.8  color rgbft <0.2, 0.2, 1.0, 0.5, 0.0> ]
            [ 1.0  color rgbft <0.2, 0.2, 1.0, 0.5,-1.0> ]
         }
         scale 0.07
      }
   }

   sphere { 0, 1
      hollow
      pigment { Clear }

      halo {
         dust
         dust_type 4
         linear
         spherical_mapping
         frequency 2
         turbulence 1.5
         octaves 8
         samples 8
         color_map {
            [ 0.0  color rgbft <0.8, 0.6, 0.7, 0.0, 1.0> ]
            [ 0.1  color rgbft <0.8, 0.7, 0.7, 0.2, 0.7> ]
            [ 0.2  color rgbft <1.0, 0.8, 0.9, 0.3, 0.6> ]
            [ 0.25 color rgbft <1.0, 0.8, 0.7, 0.3, 0.6> ]
            [ 0.3  color rgbft <1.0, 0.7, 0.8, 0.3, 0.6> ]
            [ 0.4  color rgbft <0.9, 0.8, 0.8, 0.2, 0.7> ]
            [ 0.5  color rgbft <0.8, 0.5, 0.7, 0.0, 1.0> ]
         }
         scale 0.5
      }
      scale < 0.9, 4, 3 >
   }

   scale 400
   rotate <0,60,-30>
   translate NewPosition
}

// ***  The Red Giant & Black Hole
#declare RedPosition = < -60, -125, 95 >

#declare RedColor = color rgb <2.0, 0.6, 0.2>

#declare TheRedStar = union {
   sphere { <0,0,0>, 1
      texture {
         pigment { Clear }
         finish { ambient 0 diffuse 0 }
         halo {
            emitting
            linear
            spherical_mapping
            frequency 10
            turbulence 0.5
            octaves 8
            samples 12
            color_map {
               [ 0.3  color rgbt <1.0, 0.2, 0.2, 1.0> ]
               [ 0.4  color rgbt <1.0, 0.2, 0.2,-1.0> ]
               [ 0.5  color rgbt <1.0, 0.5, 0.5,-2.0> ]
               [ 0.6  color rgbt <1.0, 1.0, 0.5,-1.0> ]
               [ 0.7  color rgbt <1.0, 1.0, 0.5, 1.0> ]
            }
         }
         scale 1.2
      }
      hollow
   }

   sphere { <0,0,0>, 0.8
      texture {
         finish { Luminous }
         pigment {
            crackle
            color_map {
               [ 0.3  color rgb <1.0, 0.2, 0.2> ]
               [ 0.7  color rgb <1.0, 1.0, 0.5> ]
               [ 1.0  color rgb <1.0, 1.0, 0.5> ]
            }
         }
         scale 0.01
      }
   }
   scale 22

   no_shadow
}

#declare TheBlackHole = union {
   box { < 0,0,-0.02>, < 1,1,0.02 >
      texture {
         pigment {
            image_map {
               gif "Spiral1.gif"
               once
               filter  0  1.0
               filter  1  0.9
               filter  2  0.8
               filter  3  0.7
               filter  4  0.6
               filter  5  0.5
               filter  6  0.4
               filter  7  0.3
               filter  8  0.2
               filter  9  0.1
            }
         }
         finish { Luminous }
      }
      hollow

      translate < -0.625, -0.5, 0 >
      scale < 40, 30, 1 >
   }
   sphere { < 0, 0, 0 >, 0.8
      texture { pigment { Black } finish { ambient 0 diffuse 0 } }
   }
   no_shadow
}

#declare RedStar = union {
   light_source {
      < 0,0,0 >
      color RedColor
   }
   object {
      TheRedStar
   }
   object {
      TheBlackHole
      translate < 36, 5, 0 >
      rotate < 45, 30, 10 >
   }
   translate RedPosition
}


// ***  S H I P   O B J E C T ***

#declare FMSize = 0.3
#declare FBSize = 0.15

#declare FrameMain = union {
  cylinder { < 1, 1, 0>, < 1, 1, 8>, FMSize }
  cylinder { < 1,-1, 0>, < 1,-1, 8>, FMSize }
  cylinder { <-1, 1, 0>, <-1, 1, 8>, FMSize }
  cylinder { <-1,-1, 0>, <-1,-1, 8>, FMSize }
}
#declare FrameBrace1 = union {
  cylinder { < 1, 1, 0>, < 1,-1, 4>, FBSize }
  cylinder { <-1,-1, 0>, < 1,-1, 4>, FBSize }
  cylinder { <-1,-1, 0>, <-1, 1, 4>, FBSize }
  cylinder { < 1, 1, 0>, <-1, 1, 4>, FBSize }
}
#declare FrameBrace2 = union {
  cylinder { < 1,-1, 0>, < 1, 1, 4>, FBSize }
  cylinder { < 1,-1, 0>, <-1,-1, 4>, FBSize }
  cylinder { <-1, 1, 0>, <-1,-1, 4>, FBSize }
  cylinder { <-1, 1, 0>, < 1, 1, 4>, FBSize }
}

#declare FrameEnd = union {
  cylinder { < 1, 1, 0>, < 1,-1, 0>, FMSize }
  cylinder { < 1,-1, 0>, <-1,-1, 0>, FMSize }
  cylinder { <-1,-1, 0>, <-1, 1, 0>, FMSize }
  cylinder { <-1, 1, 0>, < 1, 1, 0>, FMSize }
}
#declare FrameBrace3 = union {
  cylinder { < 1,-1, 0>, <-1, 1, 0>, FBSize }
  cylinder { < 1, 1, 0>, <-1,-1, 0>, FBSize }
}


#declare FrameUnit = union {
   object { FrameMain }

   object { FrameBrace1 }
   object { FrameEnd }
   object { FrameBrace3 }

   object { FrameBrace2 translate < 0, 0, 4 > }
   object { FrameEnd    translate < 0, 0, 4 > }
   object { FrameBrace3 translate < 0, 0, 4 > }
}


// ***  Fuel system declarations
#declare PipeTexture =
texture {
   pigment { rgb <1.0, 0.3, 0.3> }
   normal { crackle 0.5 turbulence 0.5 }
   finish {
      // metallic
      ambient 0.5
      diffuse 0.5
      specular 0.1
      roughness 0.1
      reflection 0.1
      brilliance 1.0
   }
}

#declare FFSize = 0.5
#declare FESize = 0.3

// ***  Exhaust
#declare Exhaust = object {
   intersection {
      union {
         object {
            Paraboloid_Z
         }
         cone {
            <  0,  0, 0 >, 3.0,
            <  0,  0, 25 >, 0.0
            open
         }
      }
      // a bounding box to prevent repeated gradient
      box { <-100,-100,0>, <100,100,1000> }
   }
   texture {
      pigment {
         gradient z
         color_map {
            [ 0.0  color rgbf <0.90, 0.95, 1.5, 0.92> ]
            [ 0.05 color rgbf <0.95, 0.97, 1.2, 0.96> ]
            [ 0.25 color rgbf <0.97, 0.99, 1.1, 0.98> ]
            [ 0.5  color rgbf <0.99, 0.99, 1.1, 1.0> ]
            [ 1.0  color rgbf <1,    1,    1,   1> ]
         }
         scale < 1, 1, 1000 >
         quick_color Blue
      }
      finish { Luminous }
   }
   scale < 1, 1, -1 >
   translate -12 * z
}

#declare ExhaustModule = union {

   // The Exhaust for each engine, combined into a single shape
   object { Exhaust translate < 4, 0,-6 > }
   object { Exhaust translate <-4, 0,-6 > }
   object { Exhaust translate < 0, 4,-6 > }
   object { Exhaust translate < 0,-4,-6 > }
}

// ***  The engines
#declare Nozzle = union {
   cone {
      <  0,  0, -13 >, 3.2,
      <  0,  0, -12 >, 3.0
      open
   }
   cone {
      <  0,  0, -12.1 >, 3.0,
      <  0,  0, -11 >, 2.6
      open
   }
   cone {
      <  0,  0, -11.1 >, 2.6,
      <  0,  0, -10 >, 2.0
      open
   }
   cone {
      <  0,  0, -10.1 >, 2.0,
      <  0,  0, -9 >, 1.0
      open
   }
   cylinder {
      <  0,  0, -9.1 >,
      <  0,  0,  1 >, 1.0
      open
   }
   sphere {
      <  0,  0,  1 >, 1.0
   }
   texture {
      pigment {
         color Gray30
         quick_color Gray30
      }
      finish {
         ambient 0.5 diffuse 0.5
      }
   }
}

#declare Reactor = union {

   cylinder { < 0, 0, -0.7 >, < 0, 0, -0.3 >, 2.0 }
   cylinder { < 0, 0, -2.5 >, < 0, 0, -2.0 >, 2.1 }
   cylinder { < 0, 0, -4.3 >, < 0, 0, -3.7 >, 2.2 }
   cylinder { < 0, 0, -6.1 >, < 0, 0, -5.4 >, 2.3 }
   cylinder { < 0, 0, -7.9 >, < 0, 0, -7.1 >, 2.4 }
   cylinder { < 0, 0, -9.7 >, < 0, 0, -8.8 >, 2.5 }

   texture {
      Gold_Metal
      pigment { quick_color Gold }
   }
}


#declare Engine = union {
   object { Reactor }
   object { Nozzle }

   // Engine Fuel
   cylinder { < 0, 0,-1 >, < 0, 0, 6 >, FESize
      texture { PipeTexture }
   }
}

#declare EngineModule = union {

   // The Engines
   object { Engine translate < 4, 0,-6 > }
   object { Engine translate <-4, 0,-6 > }
   object { Engine translate < 0, 4,-6 > }
   object { Engine translate < 0,-4,-6 > }

   // Box Members
   object { FrameEnd }

   cylinder { < 4, 0,-5 >, < 0, 4,-5 >, FMSize }
   cylinder { < 4, 0,-5 >, < 0,-4,-5 >, FMSize }
   cylinder { <-4, 0,-5 >, < 0, 4,-5 >, FMSize }
   cylinder { <-4, 0,-5 >, < 0,-4,-5 >, FMSize }

   // Cross Bracing
   cylinder { < 4, 0,-5 >, <-4, 0,-5 >, FBSize }
   cylinder { < 0, 4,-5 >, < 0,-4,-5 >, FBSize }

   // Main Diagonals
   cylinder { < 4, 0,-5 >, < 1, 1, 0 >, FMSize }
   cylinder { < 4, 0,-5 >, < 1,-1, 0 >, FMSize }
   cylinder { <-4, 0,-5 >, <-1, 1, 0 >, FMSize }
   cylinder { <-4, 0,-5 >, <-1,-1, 0 >, FMSize }

   cylinder { < 0, 4,-5 >, < 1, 1, 0 >, FMSize }
   cylinder { < 0, 4,-5 >, <-1, 1, 0 >, FMSize }
   cylinder { < 0,-4,-5 >, < 1,-1, 0 >, FMSize }
   cylinder { < 0,-4,-5 >, <-1,-1, 0 >, FMSize }
}

// ***  Inject Module
#declare Injector = union {
   // Feed pipe to reactors
   cylinder { < 0, 0, 0 >, < 0, 0, 4 >, FESize }

   // Injector
   cone     { < 0, 0, 0 >,  1, < 0, 0, 1 >, 2 }
   cylinder { < 0, 0, 0.9>,    < 0, 0, 2 >, 2 }
   cone     { < 0, 0, 1.9>, 2, < 0, 0, 3 >, 1 }

   texture { PipeTexture }
}

#declare InjectModule = union {

   object { FrameUnit }

   // Feed pipes and Injectors
   object { Injector translate < 4, 0, 0 > }
   object { Injector translate <-4, 0, 0 > }
   object { Injector translate < 0, 4, 0 > }
   object { Injector translate < 0,-4, 0 > }

   union {
      // The curved feed pipes
      object {
         intersection {
            box { <-5,-5, 0 >, < 5, 5, 4 > }
            union {
               object { torus { 4, FESize } }
               object { torus { 4, FESize } rotate 90*z }
            }
         }
         translate < 0, 0, 4 >
      }
      // The main pipe and a coupling
      cylinder { < 0, 0, 7 >,< 0, 0, 8 >, FFSize }
      cylinder { < 0, 0, 7.9 >,< 0, 0, 8.1 >, FFSize+0.2 }

      texture { PipeTexture }
   }
}

// ***  Pump Module
#declare PumpModule = union {

   object { FrameUnit }

   // The main pipe and two couplings
   union {
      cylinder { < 0, 0, 0 >,< 0, 0, 8 >, FFSize }
      cylinder { < 0, 0, 3.9 >,< 0, 0, 4.1 >, FFSize+0.2 }
      cylinder { < 0, 0, 7.9 >,< 0, 0, 8.1 >, FFSize+0.2 }
      texture { PipeTexture }
   }
}

// ***  Tank Module
#declare TankModule = union {

   object { FrameUnit }

   sphere { <-5.5, 0, 4 >, 4 }
   sphere { < 5.5, 0, 4 >, 4 }
   sphere { < 0,-5.5, 4 >, 4 }
   sphere { < 0, 5.5, 4 >, 4 }

   union {
      cylinder { < 0,-5.5, 4 >, < 0, 5.5, 4 >, FESize }
      cylinder { <-5.5, 0, 4 >, < 5.5, 0, 4 >, FESize }

      cylinder { < 0, 0, 3.5 >, < 0, 0, 4.5 >, FFSize+0.3 }
      cylinder { < 0, 0,-0.1 >, < 0, 0, 0.1 >, FFSize+0.2 }
      cylinder { < 0, 0, 4 >,   < 0, 0,-4 >,   FFSize }

      texture { PipeTexture }
   }
}


// ***  Instrument Module
#declare InstruSize = 4.0

// Main Communications dish
#declare Dish = intersection {

   cylinder { <0,0,0>, <0,0,2.5>, 1 }
   difference {
      object { Paraboloid_Z }
      object { Paraboloid_Z translate 0.025*z }
   }

   texture {
      Gold_Metal
      pigment { quick_color Gold }
      // Polished, highly reflective
      finish {
         metallic
         ambient 0.5
         diffuse 0.5
         brilliance 6.0
         reflection 0.5
         phong 0.8
         phong_size 120
      }
   }
   scale < 10, 10, -4 >
}
#declare Support = union {

   cylinder { <0,0, 0.00+0.5>, <1,0,-0.04+0.5>, 0.5 }
   cylinder { <1,0,-0.04+0.5>, <2,0,-0.16+0.5>, 0.5 }
   cylinder { <2,0,-0.16+0.5>, <3,0,-0.36+0.4>, 0.4 }
   cylinder { <3,0,-0.36+0.4>, <4,0,-0.64+0.4>, 0.4 }
   cylinder { <4,0,-0.64+0.4>, <5,0,-1.00+0.3>, 0.3 }
   cylinder { <5,0,-1.00+0.3>, <6,0,-1.44+0.3>, 0.3 }
   cylinder { <6,0,-1.44+0.3>, <7,0,-1.96+0.2>, 0.2 }
   cylinder { <7,0,-1.96+0.2>, <8,0,-2.56+0.2>, 0.2 }
   cylinder { <8,0,-2.56+0.2>, <9,0,-3.24+0.1>, 0.1 }
   cylinder { <9,0,-3.24+0.1>,<10,0,-4.00+0.1>, 0.1 }
}


#declare DishModule = object {

   union {
      object { FrameUnit translate -8*z }
      object { FrameUnit translate -16*z }

      box { < -1.2, -1.2, -17.2 >, < 1.2, 1.2, -16 > }
      cylinder { < -1.2, 0, -17.2 >, < 1.2, 0, -17.2 >, 1.2 }

      union {
         object { Dish }
         object { Support }
         object { Support rotate  60*z }
         object { Support rotate 120*z }
         object { Support rotate 180*z }
         object { Support rotate 240*z }
         object { Support rotate 300*z }

         translate -1.7*z
         rotate -90*y translate -18*z
      }
   }

   rotate 90*y
   translate < -InstruSize,0,0 >
}

// Remote Scanning Module
#declare Antenna = cone { <0,0,0.5>, 0.5, <-10,0,0.5>, 0.2 }
#declare Array = union {
   object { Antenna }
   object { Antenna rotate 45*z }
   object { Antenna rotate 90*z }
   object { Antenna rotate 135*z }
   object { Antenna rotate 180*z }
   object { Antenna rotate 225*z }
   object { Antenna rotate 270*z }
   object { Antenna rotate 315*z }

   scale < 1, 1, .5 >
}
#declare ScanModule = object {

   union {
      object { FrameUnit translate -8*z }
      object { FrameUnit translate -16*z }
      object { FrameUnit translate -24*z }
      box { < -1.2, -1.2, -25.2 >, < 1.2, 1.2, -24 > }
      sphere { < 0, 0, -26.4 >, 1.2 }
      object { Array translate -26.4*z }
   }

   rotate -90*y
   translate < InstruSize,0,0 >
}

// Declare the Instrument pod
#declare InstruPod = intersection {
   box { <-InstruSize,-InstruSize,-InstruSize>, <InstruSize,InstruSize,InstruSize> }
   box { <-InstruSize,-InstruSize,-InstruSize>, <InstruSize,InstruSize,InstruSize> rotate 45*z }
   sphere { <0,0,0>, 1.2*InstruSize }
}

// Now declare the combination of the instrument pod, dish, array, and frame
#declare InstruModule = union {
   object { FrameUnit }
   object { FrameUnit  translate 8*z }

   object { InstruPod  translate 8*z }
   object { DishModule translate 8*z }
   object { ScanModule translate 8*z }
}


// ***  Command module
#declare CmdSize = 10
#declare CmdOffset = 1

#declare CommandModule = union {
   union {
      sphere { < 0, 0, 0 >, CmdSize }
      intersection {
         sphere { < 0, 0, 0 >, CmdSize + 0.2 }
         box { <-CmdSize-0.5,-1,-1>, <CmdSize+0.5,1,1> rotate 18*z}
         box { <-CmdSize-0.5,-1,-1>, <CmdSize+0.5,1,1> rotate 54*z }
         box { <-CmdSize-0.5,-1,-1>, <CmdSize+0.5,1,1> rotate 90*z }
         box { <-CmdSize-0.5,-1,-1>, <CmdSize+0.5,1,1> rotate 136*z }
         box { <-CmdSize-0.5,-1,-1>, <CmdSize+0.5,1,1> rotate 162*z }
      }

      texture {
         pigment {
            image_map {
               gif "command.gif"
               map_type Sphere_Map
            }
            scale < -1, 1, 1 >
            rotate 90*x
         }
         finish { Shiny ambient 0.5 diffuse 0.5 }
      }
      translate < 0, 0, CmdSize + CmdOffset >
   }

   box { < -1.2, -1.2, 0 >, < 1.2, 1.2, CmdOffset > }
}


// ***  Assemble the Ship
#declare Ship = union {

   object { ExhaustModule translate -40*z }
   object { EngineModule translate -40*z }

   object { InjectModule translate -40*z }
   object { PumpModule translate -32*z }

   // Three tanks and the main feed pipe for them
   object { TankModule translate -24*z }
   object { TankModule translate -16*z }
   object { TankModule translate -8*z }

   object { InstruModule }

   object { CommandModule translate 16*z }
}


// ***  S C E N E  ***

// ***  Assemble The Scene
#ifndef (DEBUG)
   object { Sky }
#end

   object { Nebula }
   // object { GasShell }
   object { NewStar }

   object { RedStar }

#ifndef (DEBUG)
   // The ship
   object {
      object { Ship }
      texture {
         pigment { color Gray80 }
         finish { Shiny ambient 0.5 diffuse 0.5 }
      }
      // no_shadow
      // translate < 0, 0, -100+200*clock >
      rotate < 205, 55, -30 >
   }
#end

