// Buildings.inc - Assorted Background Buildings
// For Traffic, October 1996 POVRAY competition
// By The Butter-Fingered Juggler


// All the buildings are very light in colour
// This is so that they remain in the background of the picture
// and the traffic jam remains more obvious to the eyes


// Rough texture to stop buildings looking flat
#declare Build_Surface = texture {
	pigment {color White}
	finish {crand 0.15}
}

// ---------------------------------------------
#declare Aerial1a = union {
cylinder {<0, 0, 0>, <5, 55, 0>, 0.5}
cylinder {<10, 0, 0>, <5, 55, 0>, 0.5}
cylinder {<0, 0, 0>, <8.3, 20, 0>, 0.5}
cylinder {<8.3, 20, 0>, <3.5, 40, 0>, 0.5}
cylinder {<3.5, 40, 0>, <6, 45, 0>, 0.5}
texture {Silver_Metal}
} // end union

#declare Aerial1 = union {
object {Aerial1a
	rotate <0, 0, 0>}
object {Aerial1a
	rotate <0, -60, 0>}
object {Aerial1a
	rotate <0, -120, 0>
	translate <10, 0, 0>}
} // union

#declare Gantry = union {
// main beams
cylinder {<-1, 15, -1.5>, <11, 15, -1.5>, 0.2}
cylinder {<-1, 15, 1.5>, <11, 15, 1.5>, 0.2}
cylinder {<-1, 12, -1.5>, <11, 12, -1.5>, 0.2}
cylinder {<-1, 12, 1.5>, <11, 12, 1.5>, 0.2}

// x-pieces
cylinder {<-1, 15, 1.5>, <2, 12, 1.5>, 0.2}
cylinder {<-1, 12, 1.5>, <2, 15, 1.5>, 0.2}
cylinder {<2, 12, 1.5>, <5, 15, 1.5>, 0.2}
cylinder {<2, 15, 1.5>, <5, 12, 1.5>, 0.2}
cylinder {<5, 15, 1.5>, <8, 12, 1.5>, 0.2}
cylinder {<5, 12, 1.5>, <8, 15, 1.5>, 0.2}
cylinder {<8, 12, 1.5>, <11, 15, 1.5>, 0.2}
cylinder {<8, 15, 1.5>, <11, 12, 1.5>, 0.2}

cylinder {<-1, 15, -1.5>, <2, 12, -1.5>, 0.2}
cylinder {<-1, 12, -1.5>, <2, 15, -1.5>, 0.2}
cylinder {<2, 12, -1.5>, <5, 15, -1.5>, 0.2}
cylinder {<2, 15, -1.5>, <5, 12, -1.5>, 0.2}
cylinder {<5, 15, -1.5>, <8, 12, -1.5>, 0.2}
cylinder {<5, 12, -1.5>, <8, 15, -1.5>, 0.2}
cylinder {<8, 12, -1.5>, <11, 15, -1.5>, 0.2}
cylinder {<8, 15, -1.5>, <11, 12, -1.5>, 0.2}

cylinder {<-1, 15, 1.5>, <2, 15, -1.5>, 0.2}
cylinder {<-1, 12, 1.5>, <2, 12, -1.5>, 0.2}
cylinder {<2, 15, 1.5>, <5, 15, -1.5>, 0.2}
cylinder {<2, 12, 1.5>, <5, 12, -1.5>, 0.2}
cylinder {<5, 15, 1.5>, <8, 15, -1.5>, 0.2}
cylinder {<5, 12, 1.5>, <8, 12, -1.5>, 0.2}
cylinder {<8, 15, 1.5>, <11, 15, -1.5>, 0.2}
cylinder {<8, 12, 1.5>, <11, 12, -1.5>, 0.2}

cylinder {<-1, 15, -1.5>, <2, 15, 1.5>, 0.2}
cylinder {<-1, 12, -1.5>, <2, 12, 1.5>, 0.2}
cylinder {<2, 15, -1.5>, <5, 15, 1.5>, 0.2}
cylinder {<2, 12, -1.5>, <5, 12, 1.5>, 0.2}
cylinder {<5, 15, -1.5>, <8, 15, 1.5>, 0.2}
cylinder {<5, 12, -1.5>, <8, 12, 1.5>, 0.2}
cylinder {<8, 15, -1.5>, <11, 15, 1.5>, 0.2}
cylinder {<8, 12, -1.5>, <11, 12, 1.5>, 0.2}

texture {Chrome_Metal}
} // end gantry union

#declare Build7_Block = union {
box {<0, 0, 0>, <30, 15, 30>}
cylinder {<-10, 2, -10>, <-10, 15, -10>, 3}
cylinder {<-10, 0, -10>, <-10, 2, -10>, 2}
cylinder {<40, 2, -10>, <40, 15, -10>, 3}
cylinder {<-10, 2, 40>, <-10, 15, 40>, 3}
cylinder {<-10, 0, 40>, <-10, 2, 40>, 2}
cylinder {<40, 2, 40>, <40, 15, 40>, 3}
object {Gantry
	rotate <0, -45, 0>
	translate <-7, 0, -7> }
object {Gantry
	rotate <0, -45, 0>
	translate <30, 0, 30> }
object {Gantry
	rotate <0, 45, 0>
	translate <30, 0, 0> }
object {Gantry
	rotate <0, 45, 0>
	translate <-7, 0, 37> }

texture {
	pigment {color Gray90}
}
} // end build7_block union

#declare Building7 = union {
object {Build7_Block
	translate <90, 0, 60>}
object {Build7_Block
	translate <90, -15, 60>}
object {Build7_Block
	translate <90, -30, 60>}
object {Build7_Block
	translate <90, -45, 60>}
object {Build7_Block
	translate <90, -60, 60>}
object {Build7_Block
	translate <90, -75, 60>}
object {Build7_Block
	translate <90, -90, 60>}
object {Build7_Block
	translate <90, -105, 60>}
object {Build7_Block
	translate <90, -120, 60>}

} // end building7 union


// --------------------------------------------------
// Building6 RHS in foreground

#declare Building6 = union {

box { <10, -20, -42>, <45, -110, -80> }
//edges
box { <8, -18, -40>, <47, -20, -44> pigment {color Gray80} }
box { <8, -18, -40>, <12, -20, -80> pigment {color Gray80} }
//bits in middle of roof
box { <20, -16, -50>, <25, -20, -60> pigment {color red 0.75 green 0.7 blue 0.8}}
box { <25, -17, -50>, <35, -20, -60> pigment {color red 0.75 green 0.7 blue 0.8}}

texture {Build_Surface pigment {color Gray80} }
} // end building 6 union


// --------------------------------------------------
// Building 5 - lhs foreground

#declare Building5 = union {
box { <-10, -20, -50>, <-50, -110, -90> }
cylinder {<-10, -20, -50>, <-50, -20, -50>, 2}
sphere {<-10, -20, -50>, 2}
cylinder {<-50, -20, -50>, <-50, -20, -90>, 2}
sphere {<-50, -20, -50>, 2}
cylinder {<-10, -20, -50>, <-10, -20, -90>, 2}

box {<-30, -20, -65>, <-35, -18, -60> pigment {color Gray80}}
texture {Build_Surface
	pigment {color Gray80} 
}

} // end Building5 union


// -------------------------------------------------
// Building 4 - round tower

#declare Build4_Block = union {
difference {
	cylinder {<0, 0, 0>, <0, 8, 0>, 15 }
	box {<-2, 7, -15>, <2, 4, -13>
		pigment {color Black}} 
	box {<-2, 7, -15>, <2, 4, -13>
		rotate <0, 45, 0>
		pigment {color Black}} 
	box {<-2, 7, -15>, <2, 4, -13>
		rotate <0, -45, 0>
		pigment {color Black}} 

} // end diff
cylinder {<0, 8, 0>, <0, 11, 0>, 13 }
pigment {color red 0.95 green 0.95 blue 0.85}

} // end Build4_block union

#declare Building4 = union {
object {Build4_Block
	translate <10, 0, 45>}
object {Build4_Block
	translate <10, -11, 45>}
object {Build4_Block
	translate <10, -22, 45>}
object {Build4_Block
	translate <10, -33, 45>}
object {Build4_Block
	translate <10, -44, 45>}
object {Build4_Block
	translate <10, -55, 45>}
object {Build4_Block
	translate <10, -66, 45>}
object {Build4_Block
	translate <10, -77, 45>}
object {Build4_Block
	translate <10, -88, 45>}
object {Build4_Block
	translate <10, -99, 45>}
object {Build4_Block
	translate <10, -110, 45>}

} // end Building 4 union


// ---------------------------------------------------
// building 3 - back building
#declare Building3 = union {
box {<0, 5, 0>, <45, -100, 45> }
sphere {<22.5, 5, 22.5>, 22
	scale <1, 0.5, 1>
	clipped_by {plane {y, 5 inverse} }
}
cone {<0, 0, 0>, 0
  <0, 5, 0>, 2}
cone {<0, 5, 0>, 2
  <0, 15, 0>, 0}
cone {<0, 0, 45>, 0
  <0, 5, 45>, 2}
cone {<0, 5, 45>, 2
  <0, 15, 45>, 0}
cone {<45, 0, 0>, 0
  <45, 5, 0>, 2}
cone {<45, 5, 0>, 2
  <45, 15, 0>, 0}
cone {<45, 0, 45>, 0
  <45, 5, 45>, 2}
cone {<45, 5, 45>, 2
  <45, 15, 45>, 0}

texture {
     pigment {color Gray85}
	finish {crand 0.05}
}

} // end building 3 union


// --------------------------------------------------
// Building 2 - left tower
#declare Build2_Block = union {
box { <-1, 0, -1>, <16, -2, 31> }
box { <0, 0, 0>, <15, -10, 30> }
cylinder {<7.5, -5, 1>, <7.5, -5, -2>, 2 }
cylinder {<0, 0, 0>, <0, -10, 0>, 1}
cylinder {<0, 0, 30>, <0, -10, 30>, 1}
cylinder {<15, 0, 0>, <15, -10, 0>, 1}
box { <1, -2, 27>, <-1, -9, 20>
    texture {CanopyGlass} }
box { <1, -2, 19>, <-1, -9, 11>
    texture {CanopyGlass} }
box { <1, -2, 10>, <-1, -9, 3>
    texture {CanopyGlass} }

texture {Build_Surface
pigment {color red 0.98 green 0.98 blue 0.9} } 

} // end build2_block union

#declare Build2_Roof = union {
box {<-1, 0, -1>, <16, 2, 1>}
box {<-1, 0, -1>, <1, 2, 31>}
box {<1, 0, 31>, <16, 2, 29>}
box {<16, 0, 31>, <14, 2, -1>}

object {Aerial1
	scale 0.25
	translate <5, 0, 5>
}

object {Aerial1
	scale 0.25
	translate <5, 0, 25>
}

texture {Build_Surface
pigment {color red 0.98 green 0.98 blue 0.9} } 

} // end Build2_Roof union

#declare Building2 = union {
object {Build2_Roof
	rotate <0, -60, 0>
	translate <-35, 0, -10>
}

object {Build2_Block
    rotate <0, -60, 0>
    translate <-35, 0, -10> }
object {Build2_Block
	rotate <0, -60, 0>
	translate <-35, -10, -10> }
object {Build2_Block
	rotate <0, -60, 0> 
	translate <-35, -20, -10> }
object {Build2_Block
	rotate <0, -60, 0> 
	translate <-35, -30, -10> }
object {Build2_Block
	rotate <0, -60, 0>
	translate <-35, -40, -10> }
object {Build2_Block
	rotate <0, -60, 0>
	translate <-35, -50, -10> }
object {Build2_Block
	rotate <0, -60, 0>
	translate <-35, -60, -10> }
object {Build2_Block
	rotate <0, -60, 0>
	translate <-35, -70, -10> }
} // end Building2 union


// ---------------------------------------
// Central Building

#declare Build1_Block = difference {

box { <0, 0, 0>, <30, -15, 30>
	texture {
	      pigment {color red 0.98 green 0.88 blue 0.88} 
		finish {crand 0.1}
	}	
}
// rhs
box { <3, -2, -1>, <7, -4, 1>
      pigment {color Gray95} }
box { <8, -2, -1>, <12, -4, 1>
      pigment {color Gray95} }
box { <13, -2, -1>, <17, -4, 1>
      pigment {color Gray95} }
box { <18, -2, -1>, <22, -4, 1>
      pigment {color Gray95} }
box { <23, -2, -1>, <27, -4, 1>
      pigment {color Gray95} }

box { <5, -7, -1>, <12, -15, 1>
      texture {CanopyGlass} }
box { <18, -7, -1>, <25, -15, 1>
      texture {CanopyGlass} }
// lhs
box { <-1, -2, 3>, <1, -4, 7>
      pigment {color Gray95} }
box { <-1, -2, 8>, <1, -4, 12>
      pigment {color Gray95} }
box { <-1, -2, 13>, <1, -4, 17>
      pigment {color Gray95} }
box { <-1, -2, 18>, <1, -4, 22>
      pigment {color Gray95} }
box { <-1, -2, 23>, <1, -4, 27>
      pigment {color Gray95} }

box { <-1, -7, 5>, <1, -15, 12>
      texture {CanopyGlass} }
box { <-1, -7, 18>, <1, -15, 25>
      texture {CanopyGlass} }
} // end difference

#declare Build1_Roof = intersection {
box { <0, 0, 0>, <30, 2.5, 30>
      pigment {color red 0.98 green 0.88 blue 0.88} } 
cone { <15, 0, 15>, 15
       <15, 2.5, 15>, 20
       pigment {color red 0.98 green 0.88 blue 0.88} }
} // end intersection

#declare Building1 = union {
object {Build1_Roof
        rotate <0, -60, 0> }
object {Build1_Block
        rotate <0, -60, 0> }
object {Build1_Block
        rotate <0, -60, 0>
        translate <0, -15, 0>}
object {Build1_Block
        rotate <0, -60, 0>
        translate <0, -30, 0>}
object {Build1_Block
        rotate <0, -60, 0>
        translate <0, -45, 0>}
object {Build1_Block
        rotate <0, -60, 0>
        translate <0, -60, 0> }
object {Build1_Block
        rotate <0, -60, 0>
        translate <0, -75, 0> }
object {Build1_Block
        rotate <0, -60, 0>
        translate <0, -90, 0> }
object {Build1_Block
        rotate <0, -60, 0>
        translate <0, -105, 0> }
object {Build1_Block
        rotate <0, -60, 0>
        translate <0, -120, 0> }
} // end building union


