// Ufo.inc Include file for Traffic
// October 1996 POVray competition
// By The Butter-Fingered Juggler


// ------------------------------------------
// Textures

// glass
#declare CanopyGlass = 
 texture
   {pigment {color Gray70 filter 0.9}
    finish 
     {ambient 0.2
      diffuse 0
      reflection 0.5
      refraction 0
      ior 1.5
      phong 0.3
      phong_size 60
     }
   }

// Not so Shiny Metal 
#declare Traffic_Metal = 
finish {
	metallic
	ambient 0.2
	diffuse 0.8
	brilliance 5
	reflection 0.1
	phong 0.5
	phong_size 100
}



// -----------------------------------------------
// The show stoppers !

#declare Sign = union {
box {<-1, 0, 0.1>,<25, 19, 1>
	pigment {color White} }
object {char_O
	translate <2, 2, 0> 
	pigment {color Black} }
object {char_R
	translate <7, 2, 0> 
	pigment {color Black} }
object {char_D
	translate <12, 2, 0> 
	pigment {color Black} }
object {char_E
	translate <17, 2, 0> 
	pigment {color Black} }
object {char_R
	translate <22, 2, 0> 
	pigment {color Black} }
object {char_O
	translate <9, 7, 0> 
	pigment {color Black} }
object {char_F
	translate <14, 7, 0> 
	pigment {color Black} }
object {char_O
	translate <7, 12, 0> 
	pigment {color Black} }
object {char_U
	translate <12, 12, 0> 
	pigment {color Black} }
object {char_T
	translate <17, 12, 0> 
	pigment {color Black} }
torus {12, 0.5
	rotate <-10, 0, 0>
	translate <4, 19.5, 12> 
	pigment {color Gray95}
}

} // end sign union



#declare Traffic_Light = union { 
box { <0, 0, 0>, <10, 25, 10 > }
cone { <5, 5, 5>, 5
	<5, -2.5, 5>, 10 }
sphere { <5, 25, 5>, 5 }

// lights
sphere { <5, 4, 0>, 3
	texture {
	pigment {
		hexagon color green 0.5 color green 0.4 color green 0.3
		scale 0.25 }
	finish {ambient 0.5}
	}
} 

sphere { <5, 12, 0>, 3
	texture {
	pigment {hexagon
		color red 0.5 green 0.2
		color red 0.4 green 0.2
		color red 0.4 green 0.2
		scale 0.25}
	finish {ambient 0.5}
	}
} 

sphere { <5, 20, 0>, 3
	texture {
	pigment {
		hexagon color Red color red 0.9 color red 0.8
		scale 0.25 }
	finish {ambient 0.7 diffuse 0.8}
	}
} 
object {Sign
	scale 0.5
	rotate <0, 0, -10>
	rotate <0, -45, 0>
	translate <7.1, 15, -3>
}

texture {
	pigment {Black}
	finish {Traffic_Metal}
}

} // end union

// --------------------------------------------
// The various cars etc

#declare Ufo1_a = union {
// body

cone {<0, 0, 0>, 15
      <0, 2, 0>, 10}
cylinder {<0, 0, 0>, <0, -1, 0>, 15 }
difference {
	cylinder {<0, -1, 0>, <0, -4, 0>, 13}
	torus {15, 5
		translate <0, -7, 0>}
} // end diff 
difference {
	cylinder {<0, -4, 0>, <0, -6, 0>, 8}
	torus {11, 5
		translate <0, -9, 0>}
} // end diff 

// lights 
torus { 15, 0.5
	translate <0, -0.5, 0>
	texture {
		pigment {
		gradient x
		color_map {
			[0.0, 0.1 color Black color Black]
			[0.1, 0.4 color Red color Red]
			[0.4, 0.5 color Black color Black]
			[0.5, 0.8 color Green color Green]
			[0.8, 0.9 color Black color Black]
			[0.9, 1.0 color Silver color Silver] } 
		scale 5
		}
	}
} //end torus

// Legs ? Anti-static straps ?
cone {<-6, -4, -5>, 1
      <-13, -9, -7>, 0.2 }
sphere {<-13, -9, -7>, 1}
cone {<-6, -4, 5>, 1
      <-13, -9, 7>, 0.2 }
sphere {<-13, -9, 7>, 1}

} // end union


#declare Ufo1 = union {
//canopy
sphere { <0, 2, 0>, 8.5
	texture {CanopyGlass }}

// cockpit cutout
difference { 
	object {Ufo1_a}
	sphere {<0, 2, 0>, 8}
}
object {Alien1
	scale 1.5
        texture {
           pigment {
            bozo
            turbulence 0.5
            color_map {
             [0.3 color red 0.8 green 1.0 blue 0.27 ]
             [0.6 color red 0.6 green 1.0 blue 0.1 ]
             [0.8 color Sienna ] }
           }
        scale 0.5
        }
}

texture {Chrome_Metal}

} // end union


// ---------------------------------------
// Bus

#declare Ufo2 = union {
difference {
	cylinder {<0, 0, 0>, <45, 0, 0>, 8
		open}
	box { <2, 6, 9>, <11, -4, -9> pigment {color Clear}}
	box { <13, 6, 9>, <22, -4, -9> pigment {color Clear}}
	box { <24, 6, 9>, <33, -4, -9> pigment {color Clear}}
	box { <35, 6, 9>, <44, -4, -9> pigment {color Clear}}
	cylinder {<0, 8, 0>, <45, 8, 0>, 0.5}
	cylinder {<0, 8, -1.5>, <45, 8, -1.5>, 0.5}	
	cylinder {<0, 8, 1.5>, <45, 8, 1.5>, 0.5}
	cylinder {<0, 7.5, -3>, <45, 7.5, -3>, 0.5}
	cylinder {<0, 7.5, 3>, <45, 7.5, 3>, 0.5}
} // end diff

box {<9, 7, -2>, <13, 8, 2>}
box {<20, 7, -2>, <24, 8, 2>}
box {<31, 7, -2>, <35, 8, 2>}

// door open buttons
box {<33.5, 2, -8>, <34.5, 0, -6>
	pigment {color White} }
sphere {<34, 1.5, -8>, 0.3
	pigment {color IndianRed} }
sphere {<34, 0.5, -8>, 0.3
	pigment {color Pink} }

box {<22.5, 2, -8>, <23.5, 0, -6>
	pigment {color White} }
sphere {<23, 1.5, -8>, 0.3
	pigment {color IndianRed} }
sphere {<23, 0.5, -8>, 0.3
	pigment {color Pink} }

box {<11.5, 2, -8>, <12.5, 0, -6>
	pigment {color White} }
sphere {<12, 1.5, -8>, 0.3
	pigment {color IndianRed} }
sphere {<12, 0.5, -8>, 0.3
	pigment {color Pink} }

// horns
cone {<36, 8.5, -2>, 0
	<43, 9, -2>, 1
	open
	texture {Polished_Chrome} }
cone {<36, 8.5, 2>, 0
	<43, 9, 2>, 1
	open
	texture {Polished_Chrome} }
box {<35, 8, -2.4>, <36.5, 9, 2.4>
	texture {Polished_Chrome} }

// glass for windows
merge {
	cylinder {<0, 0, 0>, <45, 0, 0>, 7.8 }
	sphere {<45, 0, 0>, 7.8 }

texture {CanopyGlass}
}

// door cracks
torus {7.8, 0.1
	rotate <0, 0, 90>
	translate <6.5, 0, 0>
	pigment {color Black}
	clipped_by {plane {y, 6} }
	clipped_by {plane {y, -4 inverse} }
}
torus {7.8, 0.1
	rotate <0, 0, 90>
	translate <17.5, 0, 0>
	pigment {color Black}
	clipped_by {plane {y, 6} }
	clipped_by {plane {y, -4 inverse} }
}
torus {7.8, 0.1
	rotate <0, 0, 90>
	translate <28.5, 0, 0>
	pigment {color Black}
	clipped_by {plane {y, 6} }
	clipped_by {plane {y, -4 inverse} }
}
torus {7.8, 0.1
	rotate <0, 0, 90>
	translate <39.5, 0, 0>
	pigment {color Black}
	clipped_by {plane {y, 6} }
	clipped_by {plane {y, -4 inverse} }
}

// passengers

object {Zoot
	scale 0.3
	translate <44, 3, 0>
}

object {Bowba
	scale 0.25
	translate <25, -3, 0>
}

texture {
	pigment {color Yellow}
	finish {Metal}
}
} // end bus union

// -------------------------------------------------------------
// Speedster

#declare Speed_Engine = union {
cylinder {<0, 0, 0>, <25, 0, 0>, 2}
cone {<25, 1.5, 0>, 0.5
	<30, 0, 0>, 0
  pigment {color Maroon}}
cone {<25, -1.5, 0>, 0.5
	<30, 0, 0>, 0
  pigment {color Maroon}}
cone {<25, 0, 1.5>, 0.5
	<30, 0, 0>, 0
  pigment {color Maroon}}
cone {<25, 0, -1.5>, 0.5
	<30, 0, 0>, 0
  pigment {color Maroon}}
cone {<25, 1.2, 1.2>, 0.5
	<30, 0, 0>, 0
  pigment {color Maroon}}
cone {<25, 1.2, -1.2>, 0.5
	<30, 0, 0>, 0
  pigment {color Maroon}}
cone {<25, -1.2, 1.2>, 0.5
	<30, 0, 0>, 0
  pigment {color Maroon}}
cone {<25, -1.2, -1.2>, 0.5
	<30, 0, 0>, 0
  pigment {color Maroon}}
}

#declare Ufo3 = union {
torus { 15, 4
	scale <1.5, 1, 0.66>
	translate <25, 0, 0>
}

//cockpit
difference {
torus { 12, 8
	scale <1.5, 1, 0.66>
	translate <20, 4, 0>
}
sphere {<18, 25, 0>, 25 pigment {color Black}}
} //end diff


// canopy
sphere {<18, 10, 0>, 25
	scale <1, 0.5, 0.5>
	texture { CanopyGlass }
	clipped_by {plane {y, 4 inverse} }
}
object {Alien2
	translate <18, 5, 0>
	texture {
		pigment {
		marble
		turbulence 0.3
		color_map {
			[0.0, 0.6 color Yellow color DarkBrown]
			[0.6, 1.0 color Brown color Black]}
		scale 3
		}
		finish {crand 5}
	}
}

// Tail fin
cone { <-4, 4, 0>, 7
	<-45, 2, 0>, 0 
}
bicubic_patch {
   type 1
   flatness 0.01
   u_steps 4
   v_steps 4
   <-45, 2, 0>, <-30, 4, 2>, <-15, 5, 2>, <-4, 11, 0>
   <-46, 6, 0>, <-30, 6, 2>, <-15, 6, 4>, <-4, 11, 0>,
   <-49, 9, 0>, <-30, 9, 0>, <-15, 7, 0>, <-4, 11, 0>,
   <-54, 12, 1>, <-30, 12, 1>, <-15, 7, 0>, <-4, 11, 0>
}
bicubic_patch {
   type 1
   flatness 0.01
   u_steps 4
   v_steps 4
   <-45, 2, 0>, <-30, 4, -2>, <-15, 5, -2>, <-4, 11, 0>
   <-46, 6, 0>, <-30, 6, -2>, <-15, 6, -4>, <-4, 11, 0>,
   <-49, 9, 0>, <-30, 9, 0>, <-15, 7, 0>, <-4, 11, 0>,
   <-54, 12, 1>, <-30, 12, 1>, <-15, 7, 0>, <-4, 11, 0>
}
object {Speed_Engine
	translate <-55, 12, 0>}

// wings
bicubic_patch {
   type 1
   flatness 0.01
   u_steps 4
   v_steps 4
   <-45, 2, 0>, <-30, 1, 0>, <-15, 0, 0>, <0, -2, 0>
   <-46, 0, -5>, <-30, 0, -5>, <-15, -2, -3>, <0, -3, 0>,
   <-49, -2, -10>, <-30, -2, -10>, <-15, -2, -5>, <0, -3, 0>,
   <-54, -4, -15>, <-30, -4, -15>, <-15, -3, -10>, <0, -3, 0>
}

object {Speed_Engine
	translate <-54, -4, -15>}
bicubic_patch {
   type 1
   flatness 0.01
   u_steps 4
   v_steps 4
   <-45, 2, 0>, <-30, 1, 0>, <-15, 0, 0>, <0, -2, 0>
   <-46, 0, 5>, <-30, 0, 5>, <-15, -2, 3>, <0, -3, 0>,
   <-49, -2, 10>, <-30, -2, 10>, <-15, -2, 5>, <0, -3, 0>,
   <-54, -4, 15>, <-30, -4, 15>, <-15, -3, 10>, <0, -3, 0>
}
object {Speed_Engine
	translate <-54, -4, 15> }

texture {
	pigment { color SteelBlue }
  finish {Metal}
}

} // end spedster union

