camera
{
    location < 3.00, 0.00, 1.20>
    look_at  < 0.00, 0.00,-1.30>
}

light_source
{
    < 35.00, 75.00, 45.00>
    colour rgb<1.00, 1.00, 1.00>
}

#declare Sky =
sphere
{
    < 0.00, 0.00, 0.00>, 100.00
    texture
    {
        pigment
        {
            bozo
            colour_map
            {
                [ 0.00 colour rgb< 0.00, 0.55, 0.30>]
                [ 0.50 colour rgb< 0.00, 0.35, 0.10>]
                [ 0.60 colour rgb< 0.30, 0.00, 0.30>]
                [ 0.70 colour rgb< 0.40, 0.00, 0.40>]
                [ 0.80 colour rgb< 0.60, 0.00, 0.60>]
                [ 1.00 colour rgb< 0.75, 0.00, 0.75>]
            }
            turbulence 0.75 
              octaves  6
              omega    0.2
              lambda   3
            scale 35
        }
        finish
        {
            ambient 1.00
            phong 0.00
        }
    }
}


#declare Water =
plane
{
    y, -0.60
    texture
    {
        pigment
        {
            colour rgb<0.10,0.60,1.00> filter 0.50
        }
        normal
        {
            waves 0.40
            frequency 10
        }
        finish
        {
            ambient 0.30
            diffuse 0.30
            reflection 0.50
            phong 0.40
            refraction 1.00
            ior 1.65
        }
    }
}

#declare UnderWater =
plane
{
    y, -2.00
    texture
    {
        pigment
        {
            colour rgb<0.10,0.60,1.00>
        }
        finish
        {
            ambient 0.30
            diffuse 0.30
        }
    }
}

#declare Alien =
union
{
    sphere
    {
        < 0.00, 0.00, 0.00>, 0.10
    }
    sphere
    {
        < 0.00, 0.00, 0.00>, 0.02
        translate< 0.00, 0.00, 0.10>
        rotate< 0, 45, 0>
        pigment { colour rgb<1.00,1.00,1.00> }
    }
    sphere
    {
        < 0.00, 0.00, 0.00>, 0.02
        translate< 0.00, 0.00, 0.10>
        rotate< 0,-45, 0>
        pigment { colour rgb<1.00,1.00,1.00> }
    }
    union
    {
        cylinder
        {
            < 0.00, 0.00, 0.00>,
            < 0.00, 0.05, 0.00>, 0.01
        }    
        sphere
        {
            < 0.00, 0.08, 0.00>, 0.03
        }
        translate< 0.00, 0.10, 0.00>
        rotate< 0, 0, 15>
    }
    union
    {
        cylinder
        {
            < 0.00, 0.00, 0.00>,
            < 0.00, 0.05, 0.00>, 0.01
        }    
        sphere
        {
            < 0.00, 0.08, 0.00>, 0.03
        }
        translate< 0.00, 0.10, 0.00>
        rotate< 0, 0,-15>
    }
    scale 0.50
    texture
    {
        pigment
        {
            colour rgb< 0.00, 0.90, 0.40>
        }
        finish
        {
            ambient 0.20
            diffuse 0.30
        }
    }
}

#declare Ship =
union
{
    difference
    {
        sphere
        {
            < 0.00, 0.00, 0.00>, 1.00
        }
        box
        {
            <-0.48, 0.50, 0.30>,
            < 0.48, 0.20, 1.00>
        }
        scale < 1.00, 0.60, 1.00>
    }
    difference
    {
        sphere
        {
            < 0.00, 0.00, 0.00>, 0.99
        }
        sphere
        {
            < 0.00, 0.00, 0.00>, 0.95
        }
        scale < 1.00, 0.60, 1.00>
        texture
        {
            pigment
            {
                colour rgb<1.00,1.00,1.00> filter 1.00
            }
            finish
            {
                ambient 0.20
                diffuse 0.20
                reflection 0.10
                refraction 1.00
                ior 1.33
                phong 0.40
                phong_size 50
            }
        }
    }
    torus
    {
        1.00, 0.10
    }
    light_source
    {
        < 0.00, 0.25, 0.50>
        colour rgb<0.80, 0.80, 0.80>
    }
}

#declare Leg =
merge
{
    cylinder
    {
        < 0.00, 0.00, 0.00>,
        < 0.40,-0.50, 0.00>, 0.05
    }
    cylinder
    {
        < 0.40,-0.48, 0.00>,
        < 0.40,-0.50, 0.00>, 0.20
    }
}

#declare Jet =
merge
{
    difference
    {
        cone
        {
            < 0.00, 0.00, 0.00>, 0.40,
            < 0.00,-0.20, 0.00>, 0.20
        }
        cone
        {
            < 0.00,-0.01, 0.00>, 0.35
            < 0.00,-0.21, 0.00>, 0.15
            pigment
            {
                colour rgb<1.00,1.00,1.00>
            }
        }
    }
    light_source
    {
        < 0.00,-0.05,0.00>
        colour rgb<1.00,0.63,0.00>
    }
}

#declare CutOut=
difference
{
    box
    {
        <-1.00,-0.15,-1.00>,
        < 1.00,-1.10, 1.00>
    }
    difference
    {
        sphere
        {
            < 0.00, 0.00, 0.00>, 1.00
            scale<1.00,0.60,1.00>
        }
        box
        {
            <-1.00,-0.25,-1.00>,
            < 1.00,-1.10, 1.00>
        }
        sphere
        {
            < 0.00, 0.00, 0.00>, 0.85
            scale<1.00,0.60,1.00>
        }
    }
}

#declare UFO =
merge
{
    difference
    {
        object
        {
            Ship
        }
        object
        {
            CutOut
        }
    }
    object
    {
        Jet
        translate<0,-0.15,0>
    }
    object
    {
        Leg
        translate< 0.30,0,0>
        rotate<0,90,0>
    }
    object
    {
        Leg
        translate< 0.30,0,0>
        rotate<0,210,0>
    }
    object
    {
        Leg
        translate< 0.30,0,0>
        rotate<0,330,0>
    }
    object
    {
        Alien
        translate< 0.15, 0.15, 0.75>
    }
    object
    {
        Alien
        translate<-0.15, 0.15, 0.75>
    }
    texture
    {
        pigment
        {
            colour rgb<0.85,0.85,0.10>
        }
        finish
        {
            ambient 0.30
            diffuse 0.40
            reflection 0.30
            phong 0.30
        }
    }
}

#declare LPad =
merge
{
    box
    {
        <-1.30,-0.50,-1.30>,
        < 1.30,-0.52, 1.30>
        texture
        {
            pigment
            {
                image_map
                {
                    gif "lpad.gif"
                    interpolate 2
                }
                translate<-0.50,-0.50,0.00>
                rotate<90,0,0>
                scale 3
            }
            normal
            {
                bumps 0.7
                scale 0.3
            }
            finish
            {
                ambient    0.30
                diffuse    0.40
                reflection 0.30
            }
        }
    }
    cylinder
    {
        <-1.25,-0.60,-1.25>,
        < 1.25,-0.60,-1.25>, 0.08
    }
    sphere
    {
        < 1.25,-0.60,-1.25>, 0.08
    }
    cylinder
    {
        < 1.25,-0.60,-1.25>,
        < 1.25,-0.60, 1.25>, 0.08
    }
    sphere
    {
        < 1.25,-0.60, 1.25>, 0.08
    }
    cylinder
    {
        < 1.25,-0.60, 1.25>,
        <-1.25,-0.60, 1.25>, 0.08
    }
    sphere
    {
        <-1.25,-0.60, 1.25>, 0.08
    }
    cylinder
    {
        <-1.25,-0.60, 1.25>,
        <-1.25,-0.60,-1.25>, 0.08
    }
    sphere
    {
        <-1.25,-0.60,-1.25>, 0.08
    }
    texture
    {
        pigment
        {
            colour rgb<0.00,0.60,0.00>
        }
        finish
        {
            ambient    0.20
            diffuse    0.50
            reflection 0.20
            phong      0.30
            phong_size  45
        }
    }
}

#declare Bridge=
union
{
    difference
    {
        cylinder
        {
            < 0.00,-0.60,-1.30>,
            < 0.00, 0.50,-1.30>, 0.30
        }
        box
        {
            <-0.20,-0.50,-0.90>,
            < 0.20,-0.10,-1.30>
        }
    }
    sphere
    {
        < 0.00, 0.50,-1.30>, 0.30
    }
    cylinder
    {
        < 0.00, 0.50,-1.30>,
        < 3.00, 0.50,-3.00>, 0.30
    }
    sphere
    {
        < 3.00, 0.50,-3.00>, 0.30
    }
    cylinder
    {
        < 3.00, 0.50,-3.00>,
        < 3.00, 0.00,-3.00>, 0.30
    }
    sphere
    {
        < 3.00, 0.00,-3.00>, 0.30
    }
    cylinder
    {
        < 0.00, 0.50,-1.30>,
        <-3.00, 0.50,-3.00>, 0.30
    }
    sphere
    {
        <-3.00, 0.50,-3.00>, 0.30
    }
    cylinder
    {
        <-3.00, 0.50,-3.00>,
        <-3.00, 0.00,-3.00>, 0.30
    }
    sphere
    {
        <-3.00, 0.00,-3.00>, 0.30
    }
    texture
    {
        pigment
        {
            colour rgb<0.60,0.00,0.00>
        }
        finish
        {
            ambient    0.30
            diffuse    0.50
            reflection 0.20
            metallic
            phong      0.75
            phong_size  100
        }
    }
}

#declare Home =
union
{
    sphere
    {
        < 0.00,-0.60, 0.00>, 0.60
    }
    sphere
    {
        < 0.80,-0.60,-0.90>, 0.80
    }
    sphere
    {
        <-0.80,-0.60,-0.90>, 0.80
    }
    sphere
    {
        < 0.00,-0.60,-3.00>, 1.70
    }
    texture
    {
        pigment
        {
            colour rgb<0.60,0.60,0.60>
        }
        finish
        {
            ambient    0.40
            diffuse    0.50
            metallic
            phong      0.75
            phong_size  100
        }
    }
}

object { Sky }
object { Water }
object { UnderWater }

merge
{
    object { LPad }
    object { Bridge }
    object
    {
        Home
        translate < 3.00, 0.00,-3.00>
    }
    object
    {
        Home
        translate <-3.00, 0.00,-3.00>
    }
    object
    {
        UFO
        rotate <0,60,0>
    }
}
