/* IMPORTANT INFORMATION !
 * This file was created using an interactive text editor created specifically
 * for POVRAY and AUTOCAD. It allows the direct input of AUTOCAD information,
 * while inside the drawing construct, into the text file. It also supports a
 * series of macro add-on functions such as versions of WORM, CTDS, LATHE objects
 * SOR objects.
 * (C) Nathan G B O'Brien 1996
 */

#include "fship.col"

#declare Balloon =
union {
	torus {3000,2000 scale <1.8,1,1>
	pigment {hexagon pigment{Ballc1} pigment{Ballc2} pigment{Ballc3}rotate<90,0,0> scale 300}
	finish {phong .5 reflection .05}}
	torus {3000,2000 scale <1.8,1,1>
	finish {phong .5 reflection .05}
	pigment {hexagon pigment{Ballc4} pigment{Ballc5} pigment{Ballc6}rotate<90,0,0> scale 300}
	rotate <30,0,0>}
	torus {3000,2000 scale <1.8,1,1>
	finish {phong .5 reflection .05}
	pigment {hexagon pigment{Ballc1} pigment{Ballc2} pigment{Ballc3}rotate<90,0,0> scale 300}
	rotate <60,0,0>}
	torus {3000,2000 scale <1.8,1,1>
	finish {phong .5 reflection .05}
	pigment {hexagon pigment{Ballc4} pigment{Ballc5} pigment{Ballc6}rotate<90,0,0> scale 300}
	rotate <90,0,0>}
	torus {3000,2000 scale <1.8,1,1>
	finish {phong .5 reflection .05}
	pigment {hexagon pigment{Ballc1} pigment{Ballc2} pigment{Ballc3}rotate<90,0,0> scale 300}
	rotate <120,0,0>}
	torus {3000,2000 scale <1.8,1,1>
	finish {phong .5 reflection .05}
	pigment {hexagon pigment{Ballc4} pigment{Ballc5} pigment{Ballc6}rotate<90,0,0> scale 300}
	rotate <150,0,0>}
}

#declare Boat_base =
difference {
	intersection {
		intersection {
			cylinder {<-1046.79,0,-10613.64><-1046.79,-5500,-10613.64>,14651.08}
			cylinder {<-1046.79,100,10613.64><-1046.79,-6000,10613.64>,14651.08}
		}
		intersection {
			sphere {<-3582.58,7286.46,7079.44>,14651.08}
			sphere {<-3582.58,7286.46,-7079.44>,14651.08}
		}
	}
box {<-8500,5000,10000><-20000,-10000,-10000>}
box {<0,5000,10000><-10000,-10000,-10000> rotate <0,0,30> translate <-9500,0,0>}
}


#declare Shipp =
cylinder {<0,-600,0><0,-300,0>,150 texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}

#declare Ship_part =
union {
difference {
	object {Boat_base texture{Shipta} finish{phong 1 reflection .05 ambient .5}}
	object {Boat_base scale <.95,1,.9> translate <0,100,0> texture{Shipta} finish{phong 1 reflection .05 ambient .5}}
	box {<1500,-300,10000><-2000,-600,-10000> texture{Shipta} finish{phong 1 reflection .05 ambient .5}}
	box {<1500,100,10000><-2000,-200,-10000> texture{Shipta} finish{phong 1 reflection .05 ambient .5}}
}
difference {
	intersection {
		box {<10000,-700,10000><-10000,-800,-10000> texture{Shiptb} finish{phong 1 reflection .05 ambient .5}}
		object {Boat_base scale <.95,1,.9> translate <0,100,0> texture{Shiptb} finish{phong 1 reflection .05 ambient .5}}
	}
	box {<-2100,-2000,1000><-10000,2000,-1000> texture{Shiptb} finish{phong 1 reflection .05 ambient .5}}
}

object {Shipp translate <0,0,-3800>}
object {Shipp translate <600,0,-3800>}
object {Shipp translate <1200,0,-3800>}
object {Shipp translate <-600,0,-3800>}
object {Shipp translate <-1200,0,-3800>}
object {Shipp translate <-1800,0,-3800>}
object {Shipp translate <0,0,3800>}
object {Shipp translate <600,0,3800>}
object {Shipp translate <1200,0,3800>}
object {Shipp translate <-600,0,3800>}
object {Shipp translate <-1200,0,3800>}
object {Shipp translate <-1800,0,3800>}
}

#declare Cabin_door =
box {<0,400,800><50,-2000,-800> pigment {color <0.52,0.24,0.00,.65>}}

#declare Smokes =
sphere { 0, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 1.5
      color_map {
        [ 0.0 color rgbt <.7, .7, .7,  1> ]
        [ 0.5 color rgbt <1, 1, 1, -1> ]
        [ 1.0 color rgbt <.7, .7, .7,  1> ]
      }
      frequency 2
      samples 20
      scale 0.5
    }
    hollow
    scale 1.5
}

#declare Funnel =
union {
	cylinder {<0,0,0><0,500,0>,500 pigment{Gray50}finish{phong 1 metallic reflection .25}}
	difference {
		cylinder {<0,1300,800><0,1300,900>,500 pigment{Gray50}finish{phong 1 metallic reflection .25}}
		cylinder {<0,1300,700><0,1300,1000>,450 pigment{Gray50}finish{phong 1 metallic reflection .25}}
	}
	difference {
		cylinder {<0,1300,1200><0,1300,1300>,600 pigment{Gray50}finish{phong 1 metallic reflection .25}}
		cylinder {<0,1300,700><0,1300,1400>,550 pigment{Gray50}finish{phong 1 metallic reflection .25}}
	}
	difference {
		cone {<0,1300,900>,500<0,1300,1200>,600 pigment{Gray50}finish{phong 1 metallic reflection .25}}
		cone {<0,1300,899>,450<0,1300,1201>,550 pigment{Gray50}finish{phong 1 metallic reflection .25}}
	}
	difference {
		torus {800,500 rotate <0,0,90> translate <0,500,800> pigment{Gray60}finish{phong 1 metallic reflection .2}}
		box {<1000,-7000,51000><-1000,5000,800>pigment{Gray50}}
		box {<1000,-7000,1000><-1000,500,-1000>pigment{Gray50}}
	}
	difference {
		object {Smokes scale <600,600,1200> translate <0,1300,1200>}
		box {<1000,0,-5000><-1000,5000,1200> pigment {color rgbf <1,1,1,1>}}
	}
}

#declare Ship_cabin =
union {
difference {
	intersection {
		box {<-3500,-1000,5000><-10000,800,-5000>texture{Shipta} finish{phong 1 reflection .05 ambient .5}}
		cylinder {<-1046.79,-1300,-10613.64><-1046.79,5500,-10613.64>,15500 texture{Shipta} finish{phong 1 reflection .05 ambient .5}}
		cylinder {<-1046.79,-1300,10613.64><-1046.79,5500,10613.64>,15500 texture{Shipta} finish{phong 1 reflection .05 ambient .5}}
	}
	box {<-8500,5000,10000><-20000,-10000,-10000> texture{Shipta} finish{phong 1 reflection .05 ambient .5}}
	box {<0,600,1000><-3800,-1200,-1000> texture{Shipta} finish{phong 1 reflection .05 ambient .5}}
	box {<-4000,-800,10000><-5000,600,-10000> texture{Shipta} finish{phong 1 reflection .05 ambient .5}}
	box {<-5200,-800,10000><-6200,600,-10000> texture{Shipta} finish{phong 1 reflection .05 ambient .5}}
	box {<-6400,-800,10000><-7400,600,-10000> texture{Shipta} finish{phong 1 reflection .05 ambient .5}}
}
object {Cabin_door translate <-3800,0,0>}
object {Funnel translate <-6500,800,1200>}
object {Funnel scale<1,1,-1> translate <-6500,800,-1200>}
difference {
	intersection {
		union {
			box {<-3500,600,10000><-3300,-1500,-10000> texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
			box {<-3300,400,10000><-3100,-1500,-10000> texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
			box {<-3100,200,10000><-2900,-1500,-10000> texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
			box {<-2900,0,10000><-2700,-1500,-10000> texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
			box {<-2700,-200,10000><-2500,-1500,-10000> texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
			box {<-2500,-400,10000><-2300,-1500,-10000> texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
			box {<-2300,-600,10000><-2100,-1500,-10000> texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
		}
	cylinder {<-1046.79,-1000,-10613.64><-1046.79,5500,-10613.64>,14000 texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
	cylinder {<-1046.79,-1000,10613.64><-1046.79,5500,10613.64>,14000 texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
	}
	box {<0,-800,1000><-10000,800,-1000> texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
}
}

#declare Ship_ribs =
union {
difference {
	intersection {
		box {<-3600,-1000,5000><-10000,-1400,-5000>texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
		cylinder {<-1046.79,-3000,-10613.64><-1046.79,5500,-10613.64>,15300 texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
		cylinder {<-1046.79,-3000,10613.64><-1046.79,5500,10613.64>,15300 texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
	}
	box {<-4000,5000,10000><-20000,-10000,-10000> texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
}
difference {
	intersection {
		box {<-3600,-1400,5000><-10000,-1600,-5000>texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
		cylinder {<-1046.79,-3000,-10613.64><-1046.79,5500,-10613.64>,15000 texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
		cylinder {<-1046.79,-3000,10613.64><-1046.79,5500,10613.64>,15000 texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
	}
	box {<-4000,5000,10000><-20000,-10000,-10000> texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
}
difference {
	intersection {
		box {<-4700,-1000,5000><-10000,-1400,-5000>texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
		cylinder {<-1046.79,-3000,-10613.64><-1046.79,5500,-10613.64>,15300 texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
		cylinder {<-1046.79,-3000,10613.64><-1046.79,5500,10613.64>,15300 texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
	}
	box {<-5000,5000,10000><-20000,-10000,-10000> texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
}
difference {
	intersection {
		box {<-4700,-1400,5000><-10000,-1600,-5000>texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
		cylinder {<-1046.79,-3000,-10613.64><-1046.79,5500,-10613.64>,15000 texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
		cylinder {<-1046.79,-3000,10613.64><-1046.79,5500,10613.64>,15000 texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
	}
	box {<-5000,5000,10000><-20000,-10000,-10000> texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
}
}

#declare Ship_cabinrail =
union {
difference {
difference {
	intersection {
		box {<-3500,1000,5000><-10000,1200,-5000>texture{Shipta} finish{phong 1 reflection .05 ambient .5}}
		cylinder {<-1046.79,-1000,-10613.64><-1046.79,5500,-10613.64>,15500 texture{Shipta} finish{phong 1 reflection .05 ambient .5}}
		cylinder {<-1046.79,-1000,10613.64><-1046.79,5500,10613.64>,15500 texture{Shipta} finish{phong 1 reflection .05 ambient .5}}
	}
	box {<-8500,5000,10000><-20000,-10000,-10000> texture{Shipta} finish{phong 1 reflection .05 ambient .5}}
}
difference {
	intersection {
		box {<-3500,1000,5000><-10000,1500,-5000>texture{Shipta} finish{phong 1 reflection .05 ambient .5}}
		cylinder {<-1046.79,-1000,-10613.64><-1046.79,5500,-10613.64>,15000 texture{Shipta} finish{phong 1 reflection .05 ambient .5}}
		cylinder {<-1046.79,-1000,10613.64><-1046.79,5500,10613.64>,15000 texture{Shipta} finish{phong 1 reflection .05 ambient .5}}
	}
	box {<-8000,5000,10000><-20000,-10000,-10000> texture{Shipta} finish{phong 1 reflection .05 ambient .5}}
}
box {<0,0,1000><-5000,5000,3400> texture{Shipta} finish{phong 1 reflection .05 ambient .5}}
box {<0,0,-1000><-5000,5000,-3400> texture{Shipta} finish{phong 1 reflection .05 ambient .5}}
}

object {Shipp translate <-3650,1400,0>}
object {Shipp translate <-3650,1400,750>}
object {Shipp translate <-3650,1400,3550>}
object {Shipp translate <-3650,1400,4300>}
object {Shipp translate <-3650,1400,-750>}
object {Shipp translate <-3650,1400,-3550>}
object {Shipp translate <-3650,1400,-4300>}

object {Shipp translate <-7700,1400,0>}
object {Shipp translate <-7700,1400,750>}
object {Shipp translate <-7700,1400,1500>}
object {Shipp translate <-7700,1400,2250>}
object {Shipp translate <-7700,1400,3000>}
object {Shipp translate <-7700,1400,-750>}
object {Shipp translate <-7700,1400,-1500>}
object {Shipp translate <-7700,1400,-2250>}
object {Shipp translate <-7700,1400,-3000>}

object {Shipp translate <-4400,1400,4400>}
object {Shipp translate <-5150,1400,4300>}
object {Shipp translate <-5900,1400,3900>}
object {Shipp translate <-6650,1400,3600>}
object {Shipp translate <-7400,1400,3300>}
object {Shipp translate <-4400,1400,-4400>}
object {Shipp translate <-5150,1400,-4300>}
object {Shipp translate <-5900,1400,-3900>}
object {Shipp translate <-6650,1400,-3600>}
object {Shipp translate <-7400,1400,-3300>}
}

#declare Ship_windows =
union {
difference {
intersection {
	intersection {
		box {<-3500,-1000,5000><-10000,800,-5000>pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
		cylinder {<-1046.79,-1300,-10613.64><-1046.79,5500,-10613.64>,15450 pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
		cylinder {<-1046.79,-1300,10613.64><-1046.79,5500,10613.64>,15450 pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
	}
	box {<-4000,-800,10000><-5000,600,-10000> pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
}
box {<-4100,-700,10000><-4450,-100,-10000> pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
box {<-4100,0,10000><-4450,500,-10000> pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
box {<-4550,-700,10000><-4900,-100,-10000> pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
box {<-4550,0,10000><-4900,500,-10000> pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
}
difference {
intersection {
	intersection {
		box {<-3500,-1000,5000><-10000,800,-5000>pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
		cylinder {<-1046.79,-1300,-10613.64><-1046.79,5500,-10613.64>,15450 pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
		cylinder {<-1046.79,-1300,10613.64><-1046.79,5500,10613.64>,15450 pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
	}
	box {<-5200,-800,10000><-6200,600,-10000> pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
}
box {<-5300,-700,10000><-5650,-100,-10000> pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
box {<-5300,0,10000><-5650,500,-10000> pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
box {<-5750,-700,10000><-6100,-100,-10000> pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
box {<-5750,0,10000><-6100,500,-10000> pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
}
difference {
intersection {
	intersection {
		box {<-3500,-1000,5000><-10000,800,-5000>pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
		cylinder {<-1046.79,-1300,-10613.64><-1046.79,5500,-10613.64>,15450 pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
		cylinder {<-1046.79,-1300,10613.64><-1046.79,5500,10613.64>,15450 pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
	}
	box {<-6400,-800,10000><-7400,600,-10000> pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
}
box {<-6500,-700,10000><-6850,-100,-10000> pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
box {<-6500,0,10000><-6850,500,-10000> pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
box {<-6950,-700,10000><-7300,-100,-10000> pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
box {<-6950,0,10000><-7300,500,-10000> pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
}
intersection {
	intersection {
		box {<-3500,-1000,5000><-10000,800,-5000>pigment{color<0.2,0.2,0.20>} finish{phong 1 reflection .35}}
		cylinder {<-1046.79,-1300,-10613.64><-1046.79,5500,-10613.64>,15400 pigment{color<0.2,0.2,0.2>} finish{phong 1 reflection .35}}
		cylinder {<-1046.79,-1300,10613.64><-1046.79,5500,10613.64>,15400 pigment{color<0.2,0.2,0.2>} finish{phong 1 reflection .35}}
	}
	box {<-4000,-800,10000><-7400,600,-10000> pigment{color<0.2,0.2,0.2>} finish{phong 1 reflection .35}}
}
}

#declare Deck_hatch =
union {
	box {<3500,0,0><1000,50,50> pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
	box {<3500,50,0><3450,1600,50> pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
	box {<1000,50,0><1050,1600,50> pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
	box {<3500,1600,0><1000,1550,50> pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
	box {<3500,775,0><1000,825,50> pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}

	box {<3000,50,0><3050,1600,50> pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
	box {<2500,50,0><2550,1600,50> pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
	box {<2000,50,0><2050,1600,50> pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
	box {<1500,50,0><1550,1600,50> pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}

	box {<3500,0,0><1000,1600,10> pigment {Gray50} finish{phong 1 reflection .25}}
}

#declare Furn_pipe =
union {
	cylinder {<0,-900,0><0,900,0>,50 pigment{Gray60}finish{phong 1 metallic reflection .2}}
	cylinder {<0,1000,100><0,1000,400>,50 pigment{Gray60}finish{phong 1 metallic reflection .2}}
	difference {
		torus {100,50 rotate <0,0,90> translate <0,900,100> pigment{Gray60}finish{phong 1 metallic reflection .2}}
		box {<100,0,100><-100,1000,500>pigment{Gray60}}
		box {<100,0,100><-100,900,-100>pigment{Gray60}}
	}
}

#declare Flames =
sphere { 0, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 1.5
      color_map {
        [ 0.0 color rgbt <1, 0, 0,  1> ]
        [ 0.5 color rgbt <1, 1, 0, -1> ]
        [ 1.0 color rgbt <1, 0, 0,  1> ]
      }
      frequency 2
      samples 20
      scale 0.5
    }
    hollow
    scale 1.5
}

#declare Deck_cargo =
union {
box {<3500,0,1500><-1000,500,-1500> texture{Shipta} finish{phong 1 reflection .05 ambient .5}}
object {Deck_hatch rotate <70,0,0> translate <0,500,-1500>}
object {Deck_hatch rotate <-70,0,0> translate <0,500,1500>}
difference {
	box {<3500,500,-1500><1000,1000,1500> texture{Shipta} finish{phong 1 reflection .05 ambient .5}}
	box {<5000,0,5000><-5000,5000,-5000> rotate <-20,0,0> translate <0,500,-1500>pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
	box {<5000,0,5000><-5000,5000,-5000> rotate <20,0,0> translate <0,500,1500>pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
}

box {<900,500,1400><-900,1200,-1400> pigment{Gray40} finish{phong 1 metallic reflection .2}}
object {Furn_pipe translate <0,0,-1800>}
object {Furn_pipe translate <200,-50,-1800>}
object {Furn_pipe translate <400,-100,-1800>}
object {Furn_pipe translate <600,-150,-1800>}
object {Furn_pipe translate <800,-200,-1800>}
object {Furn_pipe translate <-200,-50,-1800>}
object {Furn_pipe translate <-400,-100,-1800>}
object {Furn_pipe translate <-600,-150,-1800>}
object {Furn_pipe translate <-800,-200,-1800>}

object {Furn_pipe scale<1,1,-1>translate <0,0,1800>}
object {Furn_pipe scale<1,1,-1>translate <200,-50,1800>}
object {Furn_pipe scale<1,1,-1>translate <400,-100,1800>}
object {Furn_pipe scale<1,1,-1>translate <600,-150,1800>}
object {Furn_pipe scale<1,1,-1>translate <800,-200,1800>}
object {Furn_pipe scale<1,1,-1>translate <-200,-50,1800>}
object {Furn_pipe scale<1,1,-1>translate <-400,-100,1800>}
object {Furn_pipe scale<1,1,-1>translate <-600,-150,1800>}
object {Furn_pipe scale<1,1,-1>translate <-800,-200,1800>}

difference {
	union {
		cylinder {<0,1200,0><0,1300,0>,500 pigment {color <1.00,0.79,0.29>} finish{phong 1 metallic reflection .3}}
		cone {<0,1300,0>,500<0,1600,0>,1000 pigment {color <1.00,0.79,0.29>} finish{phong 1 metallic reflection .3}}
		cylinder {<0,1600,0><0,1700,0>,1000 pigment {color <1.00,0.79,0.29>} finish{phong 1 metallic reflection .3}}
	}
	cylinder {<0,1000,0><0,1301,0>,450 pigment {color <1.00,0.79,0.29>} finish{phong 1 metallic reflection .3}}
	cone {<0,1299,0>,450<0,1601,0>,950 pigment {color <1.00,0.79,0.29>} finish{phong 1 metallic reflection .3}}
	cylinder {<0,1599,0><0,1750,0>,950 pigment {color <1.00,0.79,0.29>} finish{phong 1 metallic reflection .3}}
}

torus {1200,25 pigment {color <1.00,0.79,0.29>} finish{phong 1 metallic reflection .3} translate<0,2600,0>}
torus {1200,25 pigment {color <1.00,0.79,0.29>} finish{phong 1 metallic reflection .3} translate<0,3000,0>}
torus {1200,25 pigment {color <1.00,0.79,0.29>} finish{phong 1 metallic reflection .3} translate<0,3400,0>}
torus {1200,25 pigment {color <1.00,0.79,0.29>} finish{phong 1 metallic reflection .3} translate<0,3800,0>}

difference {
	object {Flames scale <950,2000,950> translate <0,1600,0>}
	box {<2000,-2000,2000><-2000,1600,-2000>pigment {colour rgbf<1,1,1,1>}}
}

cylinder {<0,2800,0><0,5000,0>,600 pigment{Ballc4} translate <600,0,0>}
cylinder {<0,2800,0><0,5000,0>,600 pigment{Ballc5} translate <600,0,0> rotate<0,30,0>}
cylinder {<0,2800,0><0,5000,0>,600 pigment{Ballc6} translate <600,0,0> rotate<0,60,0>}
cylinder {<0,2800,0><0,5000,0>,600 pigment{Ballc4} translate <600,0,0> rotate<0,90,0>}
cylinder {<0,2800,0><0,5000,0>,600 pigment{Ballc5} translate <600,0,0> rotate<0,120,0>}
cylinder {<0,2800,0><0,5000,0>,600 pigment{Ballc6} translate <600,0,0> rotate<0,150,0>}
cylinder {<0,2800,0><0,5000,0>,600 pigment{Ballc4} translate <600,0,0> rotate<0,180,0>}
cylinder {<0,2800,0><0,5000,0>,600 pigment{Ballc5} translate <600,0,0> rotate<0,210,0>}
cylinder {<0,2800,0><0,5000,0>,600 pigment{Ballc6} translate <600,0,0> rotate<0,240,0>}
cylinder {<0,2800,0><0,5000,0>,600 pigment{Ballc4} translate <600,0,0> rotate<0,270,0>}
cylinder {<0,2800,0><0,5000,0>,600 pigment{Ballc5} translate <600,0,0> rotate<0,300,0>}
cylinder {<0,2800,0><0,5000,0>,600 pigment{Ballc6} translate <600,0,0> rotate<0,330,0>}

}

#declare Rigangle1 = 6.5
#declare Rigangle2 = 10
#declare Rigangle3 = 60
#declare Rigset = 5100
#declare Rigset2 = 7800

#declare Rope_hook =
union {
	cylinder {<0,0,0><0,0,-1000>,100 texture{T_Wood32}finish{phong 1 reflection .05 ambient .5}}
	cylinder {<0,0,0><0,0,100>,70 pigment{color<0.82,0.42,0.20>} finish{phong 1 reflection .05}}
}

#declare Rope1 =
union {
	cylinder {<0,0,0><0,-8100,0>,40 texture{Ropetex2}finish{phong 1}}
	cylinder {<0,0,0><0,0,-500>,40 texture{Ropetex2}finish{phong 1}}
	object {Rope_hook rotate<-6.5,0,0> translate <0,-8100,100>}
	object {Rope_hook rotate<-6.5,0,0> translate <0,0,100>}
}

#declare Rope2 =
union {
	cylinder {<3000,-500,0><-1500,-500,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<3000,-1000,0><-1500,-1000,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<3000,-1500,0><-1500,-1500,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<3000,-2000,0><-1500,-2000,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<3000,-2500,0><-1500,-2500,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<3000,-3000,0><-1500,-3000,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<3000,-3500,0><-1500,-3500,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<3000,-4000,0><-1500,-4000,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<3000,-4500,0><-1500,-4500,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<3000,-5000,0><-1500,-5000,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<3000,-5500,0><-1500,-5500,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<3000,-6000,0><-1500,-6000,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<3000,-6500,0><-1500,-6500,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<3000,-7000,0><-1500,-7000,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<3000,-7500,0><-1500,-7500,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
}

#declare Rope3 =
union {
	cylinder {<0,-500,0><1000,-500,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<0,-1000,0><1000,-1000,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<0,-1500,0><1000,-1500,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<0,-2000,0><1000,-2000,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<0,-2500,0><1000,-2500,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<0,-3000,0><1000,-3000,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<0,-3500,0><1000,-3500,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<0,-4000,0><1000,-4000,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<0,-4500,0><1000,-4500,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<0,-5000,0><1000,-5000,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<0,-5500,0><1000,-5500,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<0,-6000,0><1000,-6000,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<0,-6500,0><1000,-6500,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<0,-7000,0><1000,-7000,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
	cylinder {<0,-7500,0><1000,-7500,0>,20 texture{Ropetex}finish{phong 1 ambient .4}}
}


#declare Rigging1 =
union {
	object {Rope1 rotate <Rigangle1,0,0> translate<0,0,Rigset> }
	object {Rope1 rotate <Rigangle1,0,0> translate<-500,0,Rigset> }
	object {Rope1 rotate <Rigangle1,0,0> translate<-1000,0,Rigset> }
	object {Rope1 rotate <Rigangle1,0,0> translate<-1500,0,Rigset> }
	object {Rope1 rotate <Rigangle1,0,0> translate<500,0,Rigset> }
	object {Rope1 rotate <Rigangle1,0,0> translate<1000,0,Rigset> }
	object {Rope1 rotate <Rigangle1,0,0> translate<1500,0,Rigset> }
	object {Rope1 rotate <Rigangle1,0,0> translate<2000,0,Rigset> }
	object {Rope1 rotate <Rigangle1,0,0> translate<2500,0,Rigset> }
	object {Rope1 rotate <Rigangle1,0,0> translate<3000,0,Rigset> }
	object {Rope2 rotate <Rigangle1,0,0> translate<0,0,Rigset> }
}

#declare Rigging2 =
union {
	object {Rope1 rotate <Rigangle2,0,0> translate<0,0,Rigset2> rotate<0,Rigangle3,0>}
	object {Rope1 rotate <Rigangle2,0,0> translate<500,0,Rigset2> rotate<0,Rigangle3,0>}
	object {Rope1 rotate <Rigangle2,0,0> translate<1000,0,Rigset2> rotate<0,Rigangle3,0>}
	object {Rope3 rotate <Rigangle2,0,0> translate<0,0,Rigset2> rotate<0,Rigangle3,0>}
}

#declare Binding =
union {
	torus {300,40 texture{Ropetex2}finish{phong 1} rotate <0,0,90> translate <150,700,0>}
	torus {400,40 texture{Ropetex2}finish{phong 1} rotate <0,0,90> translate <150,0,0>}
	cylinder {<0,0,400><0,800,400>,40 texture{Ropetex2}finish{phong 1 ambient .4} rotate<-6.6,0,0> translate<150,0,0>}
	cylinder {<0,0,-400><0,800,-400>,40 texture{Ropetex2}finish{phong 1 ambient .4} rotate<6.6,0,0> translate<150,0,0>}
}

#declare Binding_cap =
union {
	torus {400,40 pigment{Gray50} finish{phong 1 reflection .25} rotate <0,0,90>}
	torus {400,40 pigment{Gray50} finish{phong 1 reflection .25} rotate <0,0,90> translate<200,0,0>}
	difference {
		cylinder {<0,0,0><200,0,0>,440 pigment{Gray50} finish{phong 1 reflection .25}}
		cylinder {<-100,0,0><300,0,0>,360 pigment{Gray50} finish{phong 1 reflection .25}}
	}
	cylinder {<100,0,460><100,0,-460>,20 pigment{Gray70} finish{phong 1}}
	cylinder {<100,0,460><100,0,-460>,20 pigment{Gray70} finish{phong 1} rotate<30,0,0>}
	cylinder {<100,0,460><100,0,-460>,20 pigment{Gray70} finish{phong 1} rotate<60,0,0>}
	cylinder {<100,0,460><100,0,-460>,20 pigment{Gray70} finish{phong 1} rotate<90,0,0>}
	cylinder {<100,0,460><100,0,-460>,20 pigment{Gray70} finish{phong 1} rotate<120,0,0>}
	cylinder {<100,0,460><100,0,-460>,20 pigment{Gray70} finish{phong 1} rotate<150,0,0>}
}

#declare Binding_rope =
union { 
	torus {100,40 texture{Ropetex2}finish{phong 1} rotate<0,0,90>}
	cylinder {<0,0,100><0,7100,100>,40 texture{Ropetex2}finish{phong 1} rotate<25,0,0>}
	cylinder {<0,0,-100><0,7100,-100>,40 texture{Ropetex2}finish{phong 1} rotate<-25,0,0>}
}

#declare Binding_ring =
union {
	cylinder {<50,0,0><-50,0,0>,150 pigment{Gray70} finish{phong 1 reflection .25}}
	cylinder {<0,0,0><0,700,0>,40 pigment{Gray70} finish{phong 1 reflection .25}}
	cylinder {<75,700,0><-75,700,0>,310 pigment{Gray70} finish{phong 1 reflection .25}}
	torus {120,30 pigment{Gray70} finish{phong 1 reflection .25} rotate<90,0,0> translate <0,1100,0>}
	object {Binding_rope rotate<0,0,-15> translate <0,1180,0>}
}

#declare Mast =
union {
	cylinder {<1000,0,0><-4000,0,0>,400 texture{T_Wood31m}}
	cylinder {<-3000,700,0><10000,700,0>,300 texture{T_Wood31m translate<2000,0,0>}}
	cylinder {<1000,0,0><3000,0,0>,100 pigment{Gray60} finish{phong 1 reflection .25}}
	object {Binding}	
	object {Binding translate<80,0,0>}
	object {Binding translate<170,0,0>}
	object {Binding translate<260,0,0>}
	object {Binding translate<350,0,0>}
	object {Binding translate<440,0,0>}
	object {Binding translate<530,0,0>}
	object {Binding_cap translate <850,0,0>}
	object {Binding_ring translate <1500,0,0>}
}

#declare Flyship =
union {
object {Ship_part translate <0,-7500,0>}
object {Balloon translate <-1000,0,0>}
object {Ship_cabin translate <0,-7500,0>}
object {Ship_ribs translate <0,-7500,0>}
object {Ship_cabinrail translate <0,-7500,0>}
object {Ship_windows translate <0,-7500,0>}
object {Deck_cargo translate <0,-8200,0>}
object {Rigging1 translate <-1000,0,0>}
object {Rigging1 translate <-1000,0,0> scale<1,1,-1>}
object {Rigging2 translate <-1000,0,0>}
object {Rigging2 translate <-1000,0,0> scale<1,1,-1>}
object {Mast rotate<0,0,27> translate <6800,-8000,0>}
}




