// BUS

/*
Things to make:
Bumpers - need to come up with texture
Tires - need to come up with texture
wheels  done
headlights  done
clearence lamps
windows  done
destination signs
mirrors  done


*/

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "glass.inc"
#include "metals.inc"
#include "brushed.inc"

#declare notfullwrap = 1  // 1=off  0=on


#declare busbodytex = texture{    //pigment{color White} finish{metallic}}//texture { T_Chrome_3B }
   material_map {
      gif "busside.gif" // "busside.gif"
     texture{ pigment{color White} finish{metallic ambient 0.3}}

     texture{ pigment{color Blue} finish{metallic ambient 0.3}}
     texture { T_Chrome_3B finish{ambient 0.3}}

    } scale <5,1.12,1> translate<0,0.02,0> // this is stndard for side <4.8,1.12,1>
}


#declare busfronttex = texture {busbodytex}
#declare busssidetex = texture {busbodytex}
#declare buscsidetex = texture {busbodytex}
#declare busbacktex = texture {busbodytex}
#declare busrooftex = texture {busbodytex}
#declare busfloortex = texture {pigment{color White}}


#declare winframetex = texture{
  pigment {color Black}
}


// CAMERA POSITION
camera {
 right      < 1.33, 0, 0 >
 up         < 0, 1, 0 >
 direction  < 0, 0, 1 >
 location   < 7, 3.5, -3.5>
 look_at    < 2, 0.2, 0.5 >
}

light_source { < 0, 10, -70 > color White }

light_source { < 100, 20, -20 > color White }

light_source { < 0, 30, -34 > color White }  //switched z to neg

#declare wheelcutout = object {
union {
  cylinder{<0,0.21,-0.24>,<0,0.21,0.24>,0.21 }
  box{<-0.21,0,-0.24>,<0.21,0.21,0.24>}
  }
}

#declare dooropening = object {
  box{<0,0,-1>,<0.42,0.85,1> texture{pigment{color Black}}}
}


#declare doorglass = object{
  box{<0.02,0.06,0.0055>,<0.195,0.425,0.006> texture {T_Glass1}}
}


#declare doortex = texture{pigment{color Black}}


//need to create black trim ??
#declare doorpanel = object {
  union{
    difference {
      box{<0.005,0.01,0.005>,<0.21,0.84,0.02>}
      box{<0.025,0.07,0>,<0.19,0.42,0.1> pigment {color Black}}
      box{<0.025,0.46,0>,<0.19,0.81,0.1> pigment {color Black}}
      #if (notfullwrap)
        texture{doortex}
      #end
    }
    object {doorglass}
    object {doorglass translate <0,0.39,0>}
  }
}


#declare smallwindowcutout = object {
  union {
    cylinder{<0.03,0.03,1>,<0.03,0.03,-1>,0.03 }
    cylinder{<0.39,0.03,1>,<0.39,0.03,-1>,0.03 }
    cylinder{<0.03,0.43,1>,<0.03,0.43,-1>,0.03 }
    cylinder{<0.39,0.43,1>,<0.39,0.43,-1>,0.03 }
    box{<0.03,0,-1>,<0.39,0.46,1>}
    box{<0,0.03,-1>,<0.42,0.43,1>}
  } texture {pigment{color Black}}
}


#declare smallwindowframe = object {
  difference{
    union {
      cylinder{<0.03,0.03,-0.0025>,<0.03,0.03,0.0225>,0.035 }
      cylinder{<0.39,0.03,-0.0025>,<0.39,0.03,0.0225>,0.035 }
      cylinder{<0.03,0.43,-0.0025>,<0.03,0.43,0.0225>,0.035 }
      cylinder{<0.39,0.43,-0.0025>,<0.39,0.43,0.0225>,0.035 }
      box{<0.03,-0.005,-0.0025>,<0.39,0.465,0.0225>}
      box{<-0.005,0.03,-0.0025>,<0.425,0.43,0.0225>}
    }
    union {
      cylinder{<0.03,0.03,1>,<0.03,0.03,-1>,0.02 }
      cylinder{<0.39,0.03,1>,<0.39,0.03,-1>,0.02 }
      cylinder{<0.03,0.43,1>,<0.03,0.43,-1>,0.02 }
      cylinder{<0.39,0.43,1>,<0.39,0.43,-1>,0.02 }
      box{<0.03,0.01,-1>,<0.39,0.45,1>}
      box{<0.01,0.03,-1>,<0.41,0.43,1>}
    }
  }//difference
  #if (notfullwrap)
    texture {winframetex}
  #end
}


#declare smallwindow = object {
  union{
    object {smallwindowframe}
    box{<0,0.0025,0.0025>,<0.40,0.365,0.005>
    #if (notfullwrap)
      texture {T_Glass1}
    #end
    }
  }//union
}



#declare sidesigncutout = object {
  union {
    cylinder{<0.03,0.03,1>,<0.03,0.03,-1>,0.03 }
    cylinder{<0.53,0.03,1>,<0.53,0.03,-1>,0.03 }
    cylinder{<0.03,0.10,1>,<0.03,0.10,-1>,0.03 }
    cylinder{<0.53,0.10,1>,<0.53,0.10,-1>,0.03 }
    box{<0.03,0,-1>,<0.53,0.13,1>}
    box{<0,0.03,-1>,<0.56,0.10,1>}
  }
  texture {pigment{color Black}}
}


#declare tallwindowcutout = object {
  union {
    cylinder{<0.03,0.03,1>,<0.03,0.03,-1>,0.03 }
    cylinder{<0.53,0.03,1>,<0.53,0.03,-1>,0.03 }
    cylinder{<0.03,0.43,1>,<0.03,0.43,-1>,0.03 }
    cylinder{<0.53,0.43,1>,<0.53,0.43,-1>,0.03 }
    box{<0.03,0,-1>,<0.53,0.46,1>}
    box{<0,0.03,-1>,<0.56,0.43,1>}
  }
  texture {pigment{color Black}}
}


#declare tallwindowframe = object {
  union{
    difference{
      union {
        cylinder{<0.03,0.03,-0.0025>,<0.03,0.03,0.0225>,0.035 }
        cylinder{<0.53,0.03,-0.0025>,<0.53,0.03,0.0225>,0.035 }
        cylinder{<0.03,0.43,-0.0025>,<0.03,0.43,0.0225>,0.035 }
        cylinder{<0.53,0.43,-0.0025>,<0.53,0.43,0.0225>,0.035 }
        box{<0.03,-0.005,-0.0025>,<0.53,0.465,0.0225>}
        box{<-0.005,0.03,-0.0025>,<0.565,0.43,0.0225>}
      }
      union {
        cylinder{<0.03,0.03,1>,<0.03,0.03,-1>,0.02 }
        cylinder{<0.53,0.03,1>,<0.53,0.03,-1>,0.02 }
        cylinder{<0.03,0.43,1>,<0.03,0.43,-1>,0.02 }
        cylinder{<0.53,0.43,1>,<0.53,0.43,-1>,0.02 }
        box{<0.03,0.01,-1>,<0.53,0.45,1>}
        box{<0.01,0.03,-1>,<0.55,0.43,1>}
      }
    }//end difference
    box{<0,0.36,-0.002>,<0.54,0.3675,0.015>}
    box{<0,0.44,0>,<0.54,0.445,0.0075>}
    box{<0,0.361,0>,<0.01,0.445,0.0075>}
    box{<0.54,0.361,0>,<0.551,0.445,0.0075>}
  }//end union
  #if (notfullwrap)
    texture {winframetex}
  #end
}//end tallwindowframe


#declare topwinglass= object{
  union{
    difference{
      box{<0,0,-0.0035>,<0.54,0.095,0.0035>}
      box{<0.005,0.0025,-0.005>,<0.535,0.09,0.005>}
      #if (notfullwrap)
        texture {winframetex}
      #end
    }// end difference
    box{<0,0.0025,-0.0025>,<0.54,0.0925,0.0025>
    #if (notfullwrap)
      texture {T_Glass1}
    #end
    }
  }//end union
}//end topwinglass


#declare tallwindow = object {
  union{
    object {tallwindowframe}
    box{<0,0.0025,0.0025>,<0.55,0.365,0.005>
    #if (notfullwrap)
      texture {T_Glass1}
    #end
    }
    object {topwinglass rotate <40,0,0> translate <0,0.36,0.01>}
  }//end union
}//end tallwindow


#declare shortwindowcutout = object {
  union {
    cylinder{<0.03,0.03,1>,<0.03,0.03,-1>,0.03 }
    cylinder{<0.53,0.03,1>,<0.53,0.03,-1>,0.03 }
    cylinder{<0.03,0.33,1>,<0.03,0.33,-1>,0.03 }
    cylinder{<0.53,0.33,1>,<0.53,0.33,-1>,0.03 }
    box{<0.03,0,-1>,<0.53,0.36,1>}
    box{<0,0.03,-1>,<0.56,0.33,1>}
  }
  texture {pigment {color Black}}
}// end shortwindowcutout


#declare shortwindowframe = object {
  union{
    difference{
      union {
        cylinder{<0.03,0.03,-0.0025>,<0.03,0.03,0.0225>,0.035 }
        cylinder{<0.53,0.03,-0.0025>,<0.53,0.03,0.0225>,0.035 }
        cylinder{<0.03,0.33,-0.0025>,<0.03,0.33,0.0225>,0.035 }
        cylinder{<0.53,0.33,-0.0025>,<0.53,0.33,0.0225>,0.035 }
        box{<0.03,-0.005,-0.0025>,<0.53,0.365,0.0225>}
        box{<-0.005,0.03,-0.0025>,<0.565,0.33,0.0225>}
      }
      union {
        cylinder{<0.03,0.03,1>,<0.03,0.03,-1>,0.02 }
        cylinder{<0.53,0.03,1>,<0.53,0.03,-1>,0.02 }
        cylinder{<0.03,0.33,1>,<0.03,0.33,-1>,0.02 }
        cylinder{<0.53,0.33,1>,<0.53,0.33,-1>,0.02 }
        box{<0.03,0.01,-1>,<0.53,0.35,1>}
        box{<0.01,0.03,-1>,<0.55,0.33,1>}
      }
    }//end difference
    box{<0,0.26,-0.002>,<0.54,0.2675,0.015>}
    box{<0,0.34,0>,<0.54,0.345,0.0075>}
    box{<0,0.261,0>,<0.01,0.345,0.0075>}
    box{<0.54,0.261,0>,<0.551,0.345,0.0075>}
  }//end union
  #if (notfullwrap)
    texture {winframetex}
  #end
}// end shortwindowframe


#declare shortwindow = object {
  union{
    object {shortwindowframe}
    box{<0,0.0025,0.0025>,<0.55,0.265,0.005>
    #if (notfullwrap)
      texture {T_Glass1}
    #end
    }
    object {topwinglass rotate <40,0,0> translate <0,0.26,0.01>}
  }//end union
}//end shortwindow


#declare curbside = object{
  difference {
    union {
      box{<0,0.1,0>,<4.77,1.11,0.02>}
      cylinder{<0,0,0.08>, <4.77,0,0.08>,0.08 scale <1,0.2,1> translate <0,1.11,0>}
    }
    object {wheelcutout translate <1.09,0,0>}
    object {wheelcutout translate <4.02,0,0>}
    box{<-10,-0.1,-1>,<0,0,1> rotate <0,0,-10> translate<0.6,0.095,0>} //slope in back
    object {dooropening translate<4.32,0.11,0>} //door cut
    object {dooropening translate<1.75,0.11,0>} //door cut
    object {tallwindowcutout translate <2.33,0.475,0>}
    object {tallwindowcutout translate <3.01,0.475,0>}
    object {tallwindowcutout translate <3.69,0.475,0>}
    object {sidesigncutout translate <3.69, 0.96, 0>}
    object {shortwindowcutout translate <0.4,0.575,0>}
    object {shortwindowcutout translate <1.08,0.575,0>}
  }// end difference
  texture {buscsidetex}
} //end curbside


#declare driverwindowframe = union{
  //driver window built in place
  box{<4.29,0.495,0.9975>,<4.31,0.905,1.0225>} //back
  box{<4.29,0.895,0.9975>,<4.615,0.905,1.0225>} //top
  box{<4.29,0.495,0.9975>,<4.755,0.505,1.0225>} //bottom
  box{<-0.005,0,0.9975>,<0.005,0.425,1.0225> rotate  <0,0,18> translate<4.75,0.5,0>} //front
  box{<4.31,0.595,0.9975>,<4.725,0.605,1.0225>} //cross piece
  texture{winframetex}
}//end driverwindowframe


#declare dswsstuff = union{
  box{<4.775,0.90,1.01>,<4.63,0.925,0.51> pigment {color White}} //abovelws
  box{<-0.005,0,1.00>,<0.005,0.425,1.02> rotate  <0,0,18> translate<4.77,0.5,0> pigment {color White}} //front
  texture {busssidetex}
}//end driverwsstuff


#declare frontbadge = object{
  text { ttf "stopn.ttf" "BOB BUS" 0.5, 0
    texture {Brushed rotate<0,0,30> scale 0.01}
  scale 0.05 rotate<0,-90,0> translate<4.852 ,0.44,0.405>}
}//end frontbadge


#declare driverwindowglass = object{
  difference {
    box{<0,0.00,-0.00125>,<0.465,0.40,0.00125> texture {T_Glass1}}
    box{<0,0.0,-0.0025>,<0.12,0.50,0.0025> rotate <0,0,18> translate<0.465,0,0> pigment {color Black}}
  } translate<4.305,0.5,1.01>
}//end driverwindowglass


#declare driverwindow = object{
  union{
    object{driverwindowframe}
    object{driverwindowglass}
  }
}//end driverwindow


#declare streetside = object{
  difference {
    union {
      box{<0,0.1,0>,<4.77,1.11,0.02>}
      cylinder{<0,0,-0.06>, <4.77,0,-0.06>,0.08 scale <1,0.2,1> translate <0,1.11,0>}
    }
    object {wheelcutout translate <1.09,0,0>}
    object {wheelcutout translate <4.02,0,0>}
    box{<-10,-0.1,-1>,<0,0,1> rotate <0,0,-10> translate<0.6,0.095,0>} //slope in back
    box{<4.315,0.5,-0.01>,<4.8,0.9,0.03>}// drivers window
    object {smallwindowcutout translate<1.75,0.475,0>}
    object {tallwindowcutout translate <2.33,0.475,0>}
    object {tallwindowcutout translate <3.01,0.475,0>}
    object {tallwindowcutout translate <3.69,0.475,0>}
    object {shortwindowcutout translate <0.4,0.575,0>}
    object {shortwindowcutout translate <1.08,0.575,0>}
  }
  texture {busssidetex}
} //end streetside


#declare frontturnsignal=union{
  difference{ //reflector
    box{<0.0399,-0.021,-0.021><0,0.021,0.021>}
    intersection{
      sphere{<0,0,0>,0.035 scale<3,0.8,0.8> translate <0.1,0,0>}
      box{<0.04,-0.02,-0.02><0,0.02,0.02>}
    } texture{ pigment{color White} finish {reflection 0.9 ambient 0.6}}
  }
  merge{ //lens
    box{<0.04,-0.02,-0.02><0.042,0.02,0.02>}
    cylinder{<0.042,0.019,0.019>,<0.042,-0.019,0.019> 0.0005}
    cylinder{<0.042,0.019,0.015>,<0.042,-0.019,0.015> 0.0005}
    cylinder{<0.042,0.019,0.011>,<0.042,-0.019,0.011> 0.0005}
    cylinder{<0.042,0.019,0.008>,<0.042,-0.019,0.008> 0.0005}
    cylinder{<0.042,0.019,0.003>,<0.042,-0.019,0.003> 0.0005}
    cylinder{<0.042,0.019,-0.019>,<0.042,-0.019,-0.019> 0.0005}
    cylinder{<0.042,0.019,-0.015>,<0.042,-0.019,-0.015> 0.0005}
    cylinder{<0.042,0.019,-0.011>,<0.042,-0.019,-0.011> 0.0005}
    cylinder{<0.042,0.019,-0.008>,<0.042,-0.019,-0.008> 0.0005}
    cylinder{<0.042,0.019,-0.003>,<0.042,-0.019,-0.003> 0.0005}
    texture{T_Orange_Glass}
  } // end merge
} //end frontturnsignal union


#declare headlight=union{
  difference{ //reflector
    box{<0.0399,-0.021,-0.031><0,0.021,0.031>}
    intersection{
      sphere{<0,0,0>,0.035 scale<3,0.8,1.2> translate <0.1,0,0>}
      box{<0.04,-0.02,-0.03><0,0.02,0.03>}
    } texture{ pigment{color White} finish {reflection 0.9 ambient 0.6}}
  }
  merge{ //lens
    box{<0.04,-0.02,-0.03><0.042,0.02,0.03>}
    cylinder{<0.042,0.019,0.027>,<0.042,-0.019,0.027> 0.0005}
    cylinder{<0.042,0.019,0.023>,<0.042,-0.019,0.023> 0.0005}
    cylinder{<0.042,0.019,0.019>,<0.042,-0.019,0.019> 0.0005}
    cylinder{<0.042,0.019,0.015>,<0.042,-0.019,0.015> 0.0005}
    cylinder{<0.042,0.019,0.011>,<0.042,-0.019,0.011> 0.0005}
    cylinder{<0.042,0.019,0.008>,<0.042,-0.019,0.008> 0.0005}
    cylinder{<0.042,0.019,0.003>,<0.042,-0.019,0.003> 0.0005}
    cylinder{<0.042,0.019,-0.027>,<0.042,-0.019,-0.027> 0.0005}
    cylinder{<0.042,0.019,-0.023>,<0.042,-0.019,-0.023> 0.0005}
    cylinder{<0.042,0.019,-0.019>,<0.042,-0.019,-0.019> 0.0005}
    cylinder{<0.042,0.019,-0.015>,<0.042,-0.019,-0.015> 0.0005}
    cylinder{<0.042,0.019,-0.011>,<0.042,-0.019,-0.011> 0.0005}
    cylinder{<0.042,0.019,-0.008>,<0.042,-0.019,-0.008> 0.0005}
    cylinder{<0.042,0.019,-0.003>,<0.042,-0.019,-0.003> 0.0005}
    texture{T_Glass1}
  } // end merge
} //end headlight


#declare front = object{
  difference {
    union {
      box{<0,0.1,0.08>,<0.08,1.11,0.94>}
      cylinder{<0,0.1,0.08>,<0,1.11,0.08>,0.08}
      cylinder{<0,0.1,0.94>,<0,1.11,0.94>,0.08}
      sphere{<0,0,0.08>,0.08 scale <1,0.2,1> translate <0,1.11,0>}
      sphere{<0,0,0.94>,0.08 scale <1,0.2,1> translate <0,1.11,0>}
      cylinder{<0,0,0.08>, <0,0,0.94>,0.08 scale <1,0.2,1> translate <0,1.11,0>}
    }
    cylinder{<0,0.21,0.08>,<0,0.9,0.08>,0.07}
    cylinder{<0,0.21,0.94>,<0,0.9,0.94>,0.07}
    box{<-0.1,0,-0.02>,<0,1.2,1.04>}
    box{<-0.1,0.21,0.08>,<0.07,0.9,0.94>}
    box{<0.01,0.5,-0.02>,<1,0.9,0.505>}
    box{<-0.01,0.5,0.515>,<1,0.9,1.04>}
    cylinder{<0.01,0.96,0.12>,<0.1,0.96,0.12>,0.03}
    cylinder{<0.01,1.06,0.12>,<0.1,1.06,0.12>,0.03}
    cylinder{<0.01,0.96,0.91>,<0.1,0.96,0.91>,0.03}
    cylinder{<0.01,1.06,0.91>,<0.1,1.06,0.91>,0.03}
    box{<0.01,0.96,0.09>,<0.1,1.06,0.94>}
    box{<0.01,0.93,0.12>,<0.1,1.09,0.91>}
    box{<0.025,0,-0.1>,<0.1,0.205,1.1>}
    box{<0.05,-0.02,-0.02><0,0.02,0.02> translate <0.04,0.25,0.10>} //turnsignal hole
    box{<0.05,-0.02,-0.03><0,0.02,0.03> translate <0.04,0.25,0.155>} //headlight hole
    box{<0.05,-0.02,-0.03><0,0.02,0.03> translate <0.04,0.25,0.22>} //headlight hole
    box{<0.05,-0.02,-0.02><0,0.02,0.02> translate <0.04,0.25,0.92>} //turnsignal hole
    box{<0.05,-0.02,-0.03><0,0.02,0.03> translate <0.04,0.25,0.865>} //headlight hole
    box{<0.05,-0.02,-0.03><0,0.02,0.03> translate <0.04,0.25,0.8>} //headlight hole
  }
  texture {busfronttex}
} //end front


#declare wspiler = object{
  intersection {
    box{<-0.06,0.5,0.505>,<0.08,0.9,0.515>}
    box{<0.07,0,0.50>,<2,0.5,0.52> rotate <0,0,18> translate <0,0.5,0>}
  }
  texture {busfronttex}
} //end wspiler


#declare rightws = object {
  merge {
    box{<0.075,0.5,0.08>,<0.0775,0.9,0.505>}
    intersection {
      difference {
        cylinder{<0,0.5,0.08>,<0,0.9,0.08>,0.0775 }
        cylinder{<0,0.45,0.08>,<0,0.95,0.08>,0.075}
      }
      box{<0,0.4,0>,<0.08,1.0,0.08>}
    }
  texture {T_Glass1}}
}//end rightws


#declare leftws = object {
  merge {
    box{<0.075,0.5,0.515>,<0.0775,0.95,0.94>}
    intersection {
      difference {
        cylinder{<0,0.5,0.94>,<0,0.95,0.94>,0.0775 }
        cylinder{<0,0.45,0.94>,<0,1.0,0.94>,0.075}
      }
      box{<0,0.4,1.04>,<0.08,1.5,0.94>}
    }
  texture {T_Glass1}}
}//end leftws



#declare frontdestsign = object{
  box{<0,0,0.08>,<0.01,0.18,0.95>
    texture {
      pigment {
        image_map {
          gif "destsign.gif"
        }
        rotate<0,-90,0>
        scale <1,0.18,0.87>
        translate<0,0,0.08>
      }
      finish{
        ambient 1
      }
    }
  }
}

#declare frontdestglass = object{
  //front destination sign glass and frame
  union {
    difference {
      union {
        cylinder{<0,0.96,0.12>,<0.01,0.96,0.12>,0.0325}
        cylinder{<0,1.06,0.12>,<0.01,1.06,0.12>,0.0325}
        cylinder{<0,0.96,0.91>,<0.01,0.96,0.91>,0.0325}
        cylinder{<0,1.06,0.91>,<0.01,1.06,0.91>,0.0325}
        box{<0,0.96,0.0875>,<0.01,1.06,0.9425>}
        box{<0,0.9275,0.12>,<0.01,1.0925,0.91>}
      }
      cylinder{<-0.1,0.96,0.12>,<0.02,0.96,0.12>,0.0275}
      cylinder{<-0.1,1.06,0.12>,<0.02,1.06,0.12>,0.0275}
      cylinder{<-0.1,0.96,0.91>,<0.02,0.96,0.91>,0.0275}
      cylinder{<-0.1,1.06,0.91>,<0.02,1.06,0.91>,0.0275}
      box{<-0.1,0.96,0.0925>,<0.02,1.06,0.9375>}
      box{<-0.1,0.9325,0.12>,<0.02,1.0875,0.91>}
    texture{pigment{color Black}}
    }
    box{<0.0025,0.91,0.0775>,<0.005,1.09,0.95> texture {T_Glass1}}
  }
}//end frontdestglass

#declare sidedestglass = object{
  //side destination sign glass and frame
  union {
    difference {
      union {
        cylinder{<0.03,0.03,-0.0025>,<0.03,0.03,0.01>,0.0325 }
        cylinder{<0.53,0.03,-0.0025>,<0.53,0.03,0.01>,0.0325 }
        cylinder{<0.03,0.10,-0.0025>,<0.03,0.10,0.01>,0.0325 }
        cylinder{<0.53,0.10,-0.0025>,<0.53,0.10,0.01>,0.0325 }
        box{<0.03,-0.0025,-0.0025>,<0.53,0.1325,0.01>}
        box{<-0.0025,0.0275,-0.0025>,<0.5625,0.10,0.01>}
      }
      cylinder{<0.03,0.03,-0.0025>,<0.03,0.03,0.01>,0.0275 }
      cylinder{<0.53,0.03,-0.0025>,<0.53,0.03,0.01>,0.0275 }
      cylinder{<0.03,0.10,-0.0025>,<0.03,0.10,0.01>,0.0275 }
      cylinder{<0.53,0.10,-0.0025>,<0.53,0.10,0.01>,0.0275 }
      box{<0.03,0.0075,-0.2>,<0.53,0.1275,0.1>}
      box{<0.0075,0.03,-0.2>,<0.5575,0.10,0.1>}
    texture{pigment{color Black}}
    }
    box{<0,0,0.0025>,<0.565,0.13,0.005> texture {T_Glass1}}
  }
}//end sidedestglass



#declare sidedestsign = object{
  box{<0,0,0>,<0.56,0.13,0.01>
    texture {
      pigment {
        image_map {
          gif "sidesign.gif"
        }
        scale <0.56,0.13,1>
      }
      finish{
        ambient 1
      }
    }
  }
}






#declare roof= object {
  box {<0,1.11,0.08><4.77,1.126,0.94> texture {busrooftex}}
}


#declare wheelwell = object {
union {
  cylinder{<0,0.21,0.01>,<0,0.21,0.25>,0.22 }
  box{<-0.22,0.10,0.01>,<0.22,0.21,0.25>}
  }
}//end wheelwell


#declare busfloor= object {
  difference {
    union {
      box {<0.6,0.10,0.01><4.77,0.11,1.01>}
      object {wheelwell translate <1.09,0,0>}
      object {wheelwell translate <4.02,0,0>}
      object {wheelwell translate <1.09,0,0.77>}
      object {wheelwell translate <4.02,0,0.77>}
      box {<0,0.10,0.01><1.7,0.23,1.01>}
    }//end union
    object {wheelcutout translate <1.09,0,0>}
    object {wheelcutout translate <4.02,0,0>}
    object {wheelcutout translate <1.09,0,1.021>}
    object {wheelcutout translate <4.02,0,1.021>}
    box {<-0.01,0,0><0.60,0.19,1.02>}
  }//end difference
  texture {busfloortex}
}


#declare back = object{
  difference {
    union {
      box{<0,0.2,0.08>,<-0.08,1.11,0.94>}
      cylinder{<0,0.2,0.08>,<0,1.11,0.08>,0.08}
      cylinder{<0,0.2,0.94>,<0,1.11,0.94>,0.08}
      sphere{<0,0,0.08>,0.08 scale <1,0.2,1> translate <0,1.11,0>}
      sphere{<0,0,0.94>,0.08 scale <1,0.2,1> translate <0,1.11,0>}
      cylinder{<0,0,0.08>, <0,0,0.94>,0.08 scale <1,0.2,1> translate <0,1.11,0>}
    }
    box{<-0.1,0.7,0.10>,<-0.07,0.91,0.94>}
    box{<-0.1,0.6715,-0.1>,<-0.01,0.672,1.04>}
    box{<-0.015,0.3,-0.1>,<-0.01,0.672,1.04>}
    box{<-0.1,0.3,-0.1>,<-0.01,0.305,1.04>}
    box{<-0.1,0.32,0.5>,<-0.01,0.34,0.54>}
    cylinder{<0.1,0.96,0.12>,<-0.1,0.96,0.12>,0.03}
    cylinder{<0.1,1.06,0.12>,<-0.1,1.06,0.12>,0.03}
    cylinder{<0.1,0.96,0.32>,<-0.1,0.96,0.32>,0.03}
    cylinder{<0.1,1.06,0.32>,<-0.1,1.06,0.32>,0.03}
    box{<0.1,0.96,0.09>,<-0.1,1.06,0.35>}
    box{<0.1,0.93,0.12>,<-0.1,1.09,0.32>}
  }
  texture {busbacktex}
} //end back


#declare bumper = object{
  union{
    box{<0,0,-0.50>,<0.07,0.10,0.50>}
    cylinder{<0.05,0,-0.50>,<0.05,0.1,-0.50>,0.02}
    cylinder{<0.05,0,0.50>,<0.05,0.1,0.50>,0.02}
    box{<0,0,-0.52>,<0.05,0.10,0.52>}
    box{<0,0,-0.50>,<0.075,0.02,0.50>}
    cylinder{<0.05,0,-0.50>,<0.05,0.02,-0.50>,0.025}
    cylinder{<0.05,0,0.50>,<0.05,0.02,0.50>,0.025}
    box{<0,0,-0.525>,<0.05,0.02,0.525>}
    box{<0,0.08,-0.50>,<0.075,0.10,0.50>}
    cylinder{<0.05,0.08,-0.50>,<0.05,0.1,-0.50>,0.025}
    cylinder{<0.05,0.08,0.50>,<0.05,0.1,0.50>,0.025}
    box{<0,0.08,-0.525>,<0.05,0.10,0.525>}
  }
  texture{ pigment {color rgb <0.07, 0.07, 0.07>} finish {diffuse 2.0 brilliance 0.05}}
}


#declare rim = object{
  union{
    difference {
      cylinder{<0,0,-0.04>,<0,0,0.04>,0.11 }
      cylinder{<0,0,-0.05>,<0,0,0.05>,0.10 }
    }
    difference{
      union{
        cone{<0,0,-0.04>,0.101,<0,0,-0.055>,0.05 }
        cylinder{<0,0,-0.04>,<0,0,-0.056>,0.065 }
      }
      #declare Count=0
      #while (Count < 10)
        cylinder{<0,0.08,0.05>,<0,0.08,-0.06>,0.01 rotate <0,0,36*Count+18>}
        #declare Count=Count+1
      #end
      cylinder{<0,0,0.04>,<0,0,-0.06>,0.035 }
    }
  }  texture{pigment {color Blue}}
}//end rim


#declare lugnut = object{
  union{
    intersection{
      sphere{<0,0,0>0.011}
      box{<-0.015,-0.0075,0>,<0.015,0.0075,-0.0079>}
      box{<-0.015,-0.0075,0>,<0.015,0.0075,-0.00791> rotate <0,0,120>}
      box{<-0.015,-0.0075,0>,<0.015,0.0075,-0.00792> rotate <0,0,240>}
    }
    sphere{<0,0,-0.0079>0.0075}
  }  texture{pigment {color Red}}
}//end lugnut


#declare tire = object {
  intersection {
    torus {
      0.15, 0.05
      sturm
      rotate <90,0,0>
    }
    cylinder{ <0,0,-0.2>,<0,0,0.2>,0.18 }
  }
  texture{ pigment {color rgb <0.07, 0.07, 0.07>} finish {diffuse 2.0 brilliance 0.05}}
}//end tire


#declare frontwheel = object {
  union {
    object {rim texture{T_Chrome_3D}}
    #declare Count=0
    #while (Count < 10)
      object {lugnut translate <0,0.05,-0.054> rotate <0,0,36*Count> texture{T_Chrome_3D}}
    #declare Count=Count+1
    #end
    object {tire}
  }
}//end frontwheel


#declare rearwheel = object {
  union {
    object {rim texture{T_Chrome_3D} rotate<0,180,0>}
    #declare Count=0
    #while (Count < 10)
      object {lugnut translate <0,0.05,0.034> rotate <0,0,36*Count> texture{T_Chrome_3D}}
    #declare Count=Count+1
    #end
    object {tire}
    object {frontwheel translate<0,0,0.11>}
  }
}//end rearwheel


#declare sideturnsig = object{
  union{
    difference{
      cylinder{<0,-0.01,0>,<0,0.01,0>,0.04 scale<0.8,1,0.5> pigment{color White}}
      box{<-0.05,-0.0075,-0.05>,<0.05,0.0075,-0.0025> pigment{color White}}
      box{<-0.05,-0.0075,0.0025>,<0.05,0.0075,0.05> pigment{color White}}
    }//end difference
    cylinder{<0,-0.009,0>,<0,0.009,0>,0.0025
      texture{
        pigment{color Orange}
        finish{ambient 10}
      }
    }
    cylinder{<0,-0.009,0>,<0,0.009,0>,0.019
      texture{T_Orange_Glass} finish{ambient 0.8}
    }
  }//end union
}//end sideturnsig


#declare headlightframe = object{
  difference{
    union{
      sphere{<0,-0.0225,0>,0.005}
      sphere{<0,-0.0225,0.18>,0.005}
      sphere{<0,0.0225,0>,0.005}
      sphere{<0,0.0225,0.18>,0.005}
      cylinder{<0,-0.0225,0>,<0,-0.0225,0.18>,0.005}
      cylinder{<0,0.0225,0>,<0,0.0225,0.18>,0.005}
      cylinder{<0,-0.0225,0.18>,<0,0.0225,0.18>,0.005}
      cylinder{<0,-0.0225,0>,<0,0.0225,0>,0.005}
    }
    box{<-0.01,-0.0225,0>,<0.01,0.0225,0.18>}
  }
  texture{T_Chrome_3D}
}// end headlightframe


#declare cushiontex=texture{pigment{color Blue}}


#declare stantiontex = texture{T_Chrome_3D}


#declare seat=object{
  union{
    box{<0,0,0>,<0.18,0.02,0.18> texture{cushiontex}}
    box{<0,0,0>,<0.18,0.02,0.18> texture{cushiontex} rotate<0,0,100>}
    union{
      cylinder{<0.21,0.01,0.01>,<0.21,0.01,0.17>,0.005}
      sphere{<0.21,0.01,0.01>,0.005}
      sphere{<0.21,0.01,0.17>,0.005}
      cylinder{<0.21,0.01,0.01>,<0.18,0.01,0.01>,0.005}
      cylinder{<0.21,0.01,0.17>,<0.18,0.01,0.17>,0.005}
      rotate<0,0,100>
      texture{stantiontex}
    }
  }
}//end seat


#declare mirrorbacktex = texture{pigment {color Gray20}}


#declare flatm = object{
  union{
    difference{ //mirror frame
      union{
        cylinder{<-0.0025,-0.04,-0.04>,<0.0025,-0.04,-0.04>,0.005}
        cylinder{<-0.0025,0.04,-0.04>,<0.0025,0.04,-0.04>,0.005}
        cylinder{<-0.0025,0.04,0.04>,<0.0025,0.04,0.04>,0.005}
        cylinder{<-0.0025,-0.04,0.04>,<0.0025,-0.04,0.04>,0.005}
        box{<-0.0025,-0.04,-0.045>,<0.0025,0.04,0.045>}
        box{<-0.0025,-0.045,-0.04>,<0.0025,0.045,0.04>}
        intersection {
          cylinder{<0,0,0>,<-1,0,0>,0.045}
          sphere{<0.195,0,0>,0.20}
        }
        cylinder{<0,0,0>,<-0.01,0,0>,0.0025}
      }
      union{
        cylinder{<-0.001,-0.04,-0.04>,<0.005,-0.04,-0.04>,0.0025}
        cylinder{<-0.001,0.04,-0.04>,<0.005,0.04,-0.04>,0.0025}
        cylinder{<-0.001,0.04,0.04>,<0.005,0.04,0.04>,0.0025}
        cylinder{<-0.001,-0.04,0.04>,<0.005,-0.04,0.04>,0.0025}
        box{<-0.001,-0.04,-0.0425>,<0.005,0.04,0.0425>}
        box{<-0.001,-0.0425,-0.04>,<0.005,0.0425,0.04>}
      }
      texture {mirrorbacktex}
    }//end difference - mirror frame
    union{  //mirror
      cylinder{<0,-0.04,-0.04>,<0.001,-0.04,-0.04>,0.0025}
      cylinder{<0,0.04,-0.04>,<0.001,0.04,-0.04>,0.0025}
      cylinder{<0,0.04,0.04>,<0.001,0.04,0.04>,0.0025}
      cylinder{<0,-0.04,0.04>,<0.001,-0.04,0.04>,0.0025}
      box{<0,-0.04,-0.0425>,<0.001,0.04,0.0425>}
      box{<0,-0.0425,-0.04>,<0.001,0.0425,0.04>}
      texture {pigment {color Black} finish {reflection 1.0}}
    }//end mirror
  }
}// end flatm


#declare convexm = object {
  union{
    union{
      difference{
        cylinder{<-0.0025,0,0>,<0.0025,0,0>,0.0475}
        cylinder{<0,0,0>,<1,0,0>,0.045}
      }  //difference
      intersection {
        cylinder{<0,0,0>,<-1,0,0>,0.045}
        sphere{<0.195,0,0>,0.20}
      }  //intersection
      cylinder{<0,0,0>,<-0.01,0,0>,0.0025}
      texture {mirrorbacktex}
    }  //union
    intersection {
      cylinder{<0,0,0>,<1,0,0>,0.045}
      sphere{<-0.195,0,0>,0.20}
      texture {pigment {color Black} finish {reflection 1.0}}
    }  //intesection
  }  //union
} //convem


#declare mirrorbracket = object{
  union{
    cylinder{<0,-0.015,0>,<0,0.015,0>,0.01}
    cylinder{<0,0,0>,<0.08,0,0>,0.005}
    cylinder{<0.10,-0.02,0>,<0.10,-0.165,0>,0.005}
    intersection {
      torus{0.02, 0.005 rotate<90,0,0> translate<0.08,-0.02,0>}
      box{<0.12,-0.02,-0.01>,<0.08,0.02,0.01>}
    }
    texture {mirrorbacktex}
  }
}


#declare mirrorasembly = union{
  object {mirrorbracket}
  object {flatm rotate <0,180,0> translate<0.08,-0.065,0>}
  object {convexm rotate <0,180,0> translate<0.08,-0.16,0>}
}




//seats y=31 on low y=43 else
object{seat translate<0.40,0.43,0.79>}
object{seat translate<0.40,0.43,0.60>}
object{seat translate<0.40,0.43,0.41>}
object{seat translate<0.40,0.43,0.22>}
object{seat translate<0.40,0.43,0.03>}

object{seat rotate<0,90,0> translate<0.80,0.43,0.90>}
object{seat rotate<0,90,0> translate<1.0,0.43,0.90>}
object{seat rotate<0,90,0> translate<3.61,0.31,0.90>}

object{seat rotate<0,-90,0> translate<0.99,0.43,0.10>}
object{seat rotate<0,-90,0> translate<1.19,0.43,0.10>}
object{seat rotate<0,-90,0> translate<3.8,0.31,0.10>}

object{seat translate<1.25,0.43,0.79>}
object{seat translate<1.25,0.43,0.60>}
object{seat translate<1.25,0.43,0.22>}
object{seat translate<1.25,0.43,0.03>}

object{seat translate<1.65,0.31,0.79>}
object{seat translate<2.05,0.31,0.79>}
object{seat translate<2.45,0.31,0.79>}
object{seat translate<2.85,0.31,0.79>}
object{seat translate<3.25,0.31,0.79>}
object{seat translate<1.65,0.31,0.60>}
object{seat translate<2.05,0.31,0.60>}
object{seat translate<2.45,0.31,0.60>}
object{seat translate<2.85,0.31,0.60>}
object{seat translate<3.25,0.31,0.60>}

object{seat translate<2.45,0.31,0.03>}
object{seat translate<2.85,0.31,0.03>}
object{seat translate<3.25,0.31,0.03>}

object{seat translate<2.45,0.31,0.22>}
object{seat translate<2.85,0.31,0.22>}

object{seat translate<3.25,0.31,0.22>}


//side turn signals
object {sideturnsig translate <3.75,0.36,0>}
object {sideturnsig translate <1.36,0.36,0>}
//object {sideturnsig translate <3.75,0.36,1.02>}
//object {sideturnsig translate <1.36,0.36,1.02>}

object{frontturnsignal translate <4.815,0.25,0.10>}
object{headlight translate <4.815,0.25,0.155>}
object{headlight translate <4.815,0.25,0.22>}
object{frontturnsignal translate <4.815,0.25,0.92>}
object{headlight translate <4.815,0.25,0.865>}
object{headlight translate <4.815,0.25,0.8>}
object{headlightframe translate <4.8525,0.25,0.0775>}
object{headlightframe translate <4.8525,0.25,0.7625>}


object {bumper translate<4.81, 0.1,0.52>}


object {bumper rotate<0,180,0> translate<-0.03, 0.18,0.52>}

object {frontwheel translate <4.02,0.18,0.05>}

object {rearwheel translate <1.09,0.18,0.05>}

object {frontwheel rotate<0,180,0> translate <4.02,0.18,0.97>}
object {rearwheel rotate<0,180,0> translate <1.09,0.18,0.97>}


object {frontbadge}

object {front translate<4.77,0,0>}

object {rightws translate<4.77,0,0>}
object {leftws translate<-0.08,-0.5,0> rotate <0,0,18> translate<4.85,0.5,0>}
object {dswsstuff}
object {wspiler translate<4.77,0,0>}


object {streetside translate<0,0,1>}

object {tallwindow rotate<0,180,0> translate <2.89,0.475,1.02>}
object {tallwindow rotate<0,180,0> translate <3.57,0.475,1.02>}
object {tallwindow rotate<0,180,0> translate <4.25,0.475,1.02>}
object {shortwindow rotate<0,180,0> translate <0.96,0.575,1.02>}
object {shortwindow rotate<0,180,0> translate <1.64,0.575,1.02>}


object {smallwindow rotate<0,180,0> translate<2.16,0.475,1.02>}

#if (notfullwrap)
  object {curbside}
  object {tallwindow translate <3.69,0.475,0>}
  object {tallwindow translate <2.33,0.475,0>}
  object {tallwindow translate <3.01,0.475,0>}
  object {shortwindow translate <0.4,0.575,0>}
  object {shortwindow translate <1.08,0.575,0>}
#else
  union{
    object {curbside}
    object {tallwindow translate <3.69,0.475,0>}
    object {tallwindow translate <2.33,0.475,0>}
    object {tallwindow translate <3.01,0.475,0>}
    object {shortwindow translate <0.4,0.575,0>}
    object {shortwindow translate <1.08,0.575,0>}
    texture {buscsidetex}
  }
#end

object {mirrorasembly rotate<0,30,0> translate<4.83,0.92,0.02>}
object {mirrorasembly rotate<0,-30,0> translate<4.83,0.92,1.00>}

object {driverwindow}


object {back}
object {roof}
object {busfloor}

object {frontdestglass translate<4.84,0,0>}  //leave out to speed tests
object {frontdestsign translate<4.82,0.92,0>}

object {sidedestglass translate <3.69, 0.96, 0>}
object {sidedestsign translate <3.69, 0.96, 0.01>}


object {doorpanel translate<4.32,0.11,0>}
object {doorpanel translate<4.53,0.11,0>}
object {doorpanel translate<1.75,0.11,0>}
object {doorpanel translate<1.96,0.11,0>}



//plane { <0, 1, 0>, 0 pigment {checker color White, color Gray}}





// Object converted to POVRay V2.2 by WCVT2POV V2.6b
#declare _ICP8_Black = texture { T_Chrome_3B finish{ambient 0.3}}
#declare _ICP9_Red = texture { T_Chrome_3B finish{ambient 0.3}}
#declare _ICP10_Yellow = texture { T_Chrome_3B finish{ambient 0.3}}
#declare _ICP23_Blue = texture { T_Chrome_3B finish{ambient 0.3}}
#declare _ICP24_Cyan = texture { T_Chrome_3B finish{ambient 0.3}}
#declare _ICP25_Green = texture { T_Chrome_3B finish{ambient 0.3}}
#declare _ICP26_Yellow = texture{ pigment{color Blue} finish{metallic ambient 0.3}}
#declare _ICP26_Red = texture{ pigment{color White} finish{metallic ambient 0.3}}



// This object has the following minimum and maximum values:
// xmin=-1.947583, xmax=1.947582
// ymin=-0.665031, ymax=0.665006
// zmin=-6.446676, zmax=6.446677


#declare wings = object {
	union {
		// _ICP9_Red
		union {
			triangle {
				< 1.065859, 0.165653, -0.722996>,
				< 1.325567, 0.201483, -1.582541>,
				< 1.747483, 0.165561, -0.721687>
			}
			triangle {
				< 1.325567, 0.201483, -1.582541>,
				< 1.065859, 0.165653, -0.722996>,
				< 0.785018, 0.199164, -1.537718>
			}
			triangle {
				< 0.974011, 0.250680, -2.236634>,
				< 1.325567, 0.201483, -1.582541>,
				< 0.785018, 0.199164, -1.537718>
			}
			triangle {
				< 0.785018, 0.199164, -1.537718>,
				< 0.564031, 0.250564, -2.234670>,
				< 0.974011, 0.250680, -2.236634>
			}
			triangle {
				< -0.539331, 0.242532, -2.081242>,
				< -0.754367, 0.293187, -2.791855>,
				< -0.206077, 0.248364, -2.192316>
			}
			triangle {
				< -0.754367, 0.293187, -2.791855>,
				< -0.453852, 0.296667, -2.858106>,
				< -0.206077, 0.248364, -2.192316>
			}
			triangle {
				< 0.202414, 0.300744, -2.936145>,
				< 0.552065, 0.305236, -3.021742>,
				< 0.564031, 0.250564, -2.234670>
			}
			triangle {
				< 0.552065, 0.305236, -3.021742>,
				< 0.974011, 0.250680, -2.236634>,
				< 0.564031, 0.250564, -2.234670>
			}
			triangle {
				< 0.270778, 0.344731, -3.545000>,
				< 0.552065, 0.305236, -3.021742>,
				< 0.202414, 0.300744, -2.936145>
			}
			triangle {
				< 0.202414, 0.300744, -2.936145>,
				< -0.126820, 0.344524, -3.540981>,
				< 0.270778, 0.344731, -3.545000>
			}
			triangle {
				< -0.126820, 0.344524, -3.540981>,
				< -0.080809, 0.389880, -4.199272>,
				< 0.270778, 0.344731, -3.545000>
			}
			triangle {
				< -0.126820, 0.344524, -3.540981>,
				< -0.349535, 0.386102, -4.127425>,
				< -0.080809, 0.389880, -4.199272>
			}
			triangle {
				< -0.432425, 0.433928, -4.853602>,
				< -0.080809, 0.389880, -4.199272>,
				< -0.349535, 0.386102, -4.127425>
			}
			triangle {
				< -0.612311, 0.431965, -4.816102>,
				< -0.432425, 0.433928, -4.853602>,
				< -0.349535, 0.386102, -4.127425>
			}
			triangle {
				< -0.969137, 0.478007, -5.526328>,
				< -0.784042, 0.477024, -5.507993>,
				< -0.612311, 0.431965, -4.816102>
			}
			triangle {
				< -0.784042, 0.477024, -5.507993>,
				< -0.432425, 0.433928, -4.853602>,
				< -0.612311, 0.431965, -4.816102>
			}
			triangle {
				< -1.135658, 0.519258, -6.162443>,
				< -0.784042, 0.477024, -5.507993>,
				< -0.969137, 0.478007, -5.526328>
			}
			triangle {
				< -0.969137, 0.478007, -5.526328>,
				< -1.311407, 0.519527, -6.167413>,
				< -1.135658, 0.519258, -6.162443>
			}
			triangle {
				< -1.743650, 0.513961, -6.061398>,
				< -1.829663, 0.535985, -6.345574>,
				< -1.623915, 0.515421, -6.089406>
			}
			triangle {
				< -1.467661, 0.518157, -6.141401>,
				< -1.623915, 0.515421, -6.089406>,
				< -1.829663, 0.535985, -6.345574>
			}
			triangle {
				< -1.829663, 0.535985, -6.345574>,
				< -1.542068, 0.537056, -6.366437>,
				< -1.467661, 0.518157, -6.141401>
			}
			triangle {
				< -1.542068, 0.537056, -6.366437>,
				< -1.326288, 0.534347, -6.314412>,
				< -1.467661, 0.518157, -6.141401>
			}
			triangle {
				< -1.467661, 0.518157, -6.141401>,
				< -1.326288, 0.534347, -6.314412>,
				< -1.311407, 0.519527, -6.167413>
			}
			triangle {
				< -1.326288, 0.534347, -6.314412>,
				< -1.135658, 0.519258, -6.162443>,
				< -1.311407, 0.519527, -6.167413>
			}
			triangle {
				< 0.410009, 0.197529, -1.506526>,
				< 1.065859, 0.165653, -0.722996>,
				< 0.567365, 0.165655, -0.722995>
			}
			triangle {
				< 0.785018, 0.199164, -1.537718>,
				< 1.065859, 0.165653, -0.722996>,
				< 0.410009, 0.197529, -1.506526>
			}
			triangle {
				< 0.410009, 0.197529, -1.506526>,
				< 0.567365, 0.165655, -0.722995>,
				< -0.057650, 0.165658, -0.722994>
			}
			triangle {
				< 0.410009, 0.197529, -1.506526>,
				< -0.057650, 0.165658, -0.722994>,
				< -0.112325, 0.197532, -1.506526>
			}
			triangle {
				< 0.410009, 0.197529, -1.506526>,
				< -0.112325, 0.197532, -1.506526>,
				< 0.168930, 0.249167, -2.207912>
			}
			triangle {
				< 0.410009, 0.197529, -1.506526>,
				< 0.168930, 0.249167, -2.207912>,
				< 0.785018, 0.199164, -1.537718>
			}
			triangle {
				< 0.168930, 0.249167, -2.207912>,
				< 0.564031, 0.250564, -2.234670>,
				< 0.785018, 0.199164, -1.537718>
			}
			triangle {
				< -0.112325, 0.197532, -1.506526>,
				< -0.206077, 0.248364, -2.192316>,
				< 0.168930, 0.249167, -2.207912>
			}
			triangle {
				< -0.206077, 0.248364, -2.192316>,
				< -0.132416, 0.298305, -2.889329>,
				< 0.168930, 0.249167, -2.207912>
			}
			triangle {
				< -0.206077, 0.248364, -2.192316>,
				< -0.453852, 0.296667, -2.858106>,
				< -0.132416, 0.298305, -2.889329>
			}
			triangle {
				< 0.168930, 0.249167, -2.207912>,
				< -0.132416, 0.298305, -2.889329>,
				< 0.564031, 0.250564, -2.234670>
			}
			triangle {
				< -0.132416, 0.298305, -2.889329>,
				< 0.202414, 0.300744, -2.936145>,
				< 0.564031, 0.250564, -2.234670>
			}
			triangle {
				< 0.202414, 0.300744, -2.936145>,
				< -0.132416, 0.298305, -2.889329>,
				< -0.414805, 0.342294, -3.498628>
			}
			triangle {
				< -0.453852, 0.296667, -2.858106>,
				< -0.414805, 0.342294, -3.498628>,
				< -0.132416, 0.298305, -2.889329>
			}
			triangle {
				< -0.453852, 0.296667, -2.858106>,
				< -0.729515, 0.340419, -3.462943>,
				< -0.414805, 0.342294, -3.498628>
			}
			triangle {
				< 0.202414, 0.300744, -2.936145>,
				< -0.414805, 0.342294, -3.498628>,
				< -0.126820, 0.344524, -3.540981>
			}
			triangle {
				< -0.414805, 0.342294, -3.498628>,
				< -0.729515, 0.340419, -3.462943>,
				< -0.644989, 0.383870, -4.084923>
			}
			triangle {
				< -0.729515, 0.340419, -3.462943>,
				< -0.875530, 0.379825, -4.007658>,
				< -0.644989, 0.383870, -4.084923>
			}
			triangle {
				< -0.126820, 0.344524, -3.540981>,
				< -0.414805, 0.342294, -3.498628>,
				< -0.644989, 0.383870, -4.084923>
			}
			triangle {
				< -0.126820, 0.344524, -3.540981>,
				< -0.644989, 0.383870, -4.084923>,
				< -0.349535, 0.386102, -4.127425>
			}
			triangle {
				< -0.349535, 0.386102, -4.127425>,
				< -0.644989, 0.383870, -4.084923>,
				< -0.882526, 0.428515, -4.750146>
			}
			triangle {
				< -0.875530, 0.379825, -4.007658>,
				< -0.882526, 0.428515, -4.750146>,
				< -0.644989, 0.383870, -4.084923>
			}
			triangle {
				< -0.875530, 0.379825, -4.007658>,
				< -1.102918, 0.425866, -4.699223>,
				< -0.882526, 0.428515, -4.750146>
			}
			triangle {
				< -0.882526, 0.428515, -4.750146>,
				< -0.612311, 0.431965, -4.816102>,
				< -0.349535, 0.386102, -4.127425>
			}
			triangle {
				< -0.882526, 0.428515, -4.750146>,
				< -1.102918, 0.425866, -4.699223>,
				< -1.147742, 0.475419, -5.476951>
			}
			triangle {
				< -0.612311, 0.431965, -4.816102>,
				< -0.882526, 0.428515, -4.750146>,
				< -1.147742, 0.475419, -5.476951>
			}
			triangle {
				< -0.612311, 0.431965, -4.816102>,
				< -1.147742, 0.475419, -5.476951>,
				< -0.969137, 0.478007, -5.526328>
			}
			triangle {
				< -1.102918, 0.425866, -4.699223>,
				< -1.386140, 0.471044, -5.393437>,
				< -1.147742, 0.475419, -5.476951>
			}
			triangle {
				< -1.386140, 0.471044, -5.393437>,
				< -1.467661, 0.518157, -6.141401>,
				< -1.147742, 0.475419, -5.476951>
			}
			triangle {
				< -1.386140, 0.471044, -5.393437>,
				< -1.623915, 0.515421, -6.089406>,
				< -1.467661, 0.518157, -6.141401>
			}
			triangle {
				< -1.147742, 0.475419, -5.476951>,
				< -1.467661, 0.518157, -6.141401>,
				< -0.969137, 0.478007, -5.526328>
			}
			triangle {
				< -1.467661, 0.518157, -6.141401>,
				< -1.311407, 0.519527, -6.167413>,
				< -0.969137, 0.478007, -5.526328>
			}
			triangle {
				< -0.533853, 0.165956, -0.722965>,
				< -0.537574, 0.197592, -1.507626>,
				< -0.057650, 0.165658, -0.722994>
			}
			triangle {
				< -0.112325, 0.197532, -1.506526>,
				< -0.057650, 0.165658, -0.722994>,
				< -0.537574, 0.197592, -1.507626>
			}
			triangle {
				< -0.112325, 0.197532, -1.506526>,
				< -0.537574, 0.197592, -1.507626>,
				< -0.539331, 0.242532, -2.081242>
			}
			triangle {
				< -0.112325, 0.197532, -1.506526>,
				< -0.539331, 0.242532, -2.081242>,
				< -0.206077, 0.248364, -2.192316>
			}
			triangle {
				< -0.754367, 0.293187, -2.791855>,
				< -0.926425, 0.335062, -3.360292>,
				< -0.453852, 0.296667, -2.858106>
			}
			triangle {
				< -0.453852, 0.296667, -2.858106>,
				< -0.926425, 0.335062, -3.360292>,
				< -0.729515, 0.340419, -3.462943>
			}
			triangle {
				< -1.098482, 0.375718, -3.928787>,
				< -0.875530, 0.379825, -4.007658>,
				< -0.729515, 0.340419, -3.462943>
			}
			triangle {
				< -0.926425, 0.335062, -3.360292>,
				< -1.098482, 0.375718, -3.928787>,
				< -0.729515, 0.340419, -3.462943>
			}
			triangle {
				< -1.313519, 0.422742, -4.639609>,
				< -1.102918, 0.425866, -4.699223>,
				< -0.875530, 0.379825, -4.007658>
			}
			triangle {
				< -0.875530, 0.379825, -4.007658>,
				< -1.098482, 0.375718, -3.928787>,
				< -1.313519, 0.422742, -4.639609>
			}
			triangle {
				< -1.102918, 0.425866, -4.699223>,
				< -1.313519, 0.422742, -4.639609>,
				< -1.528583, 0.468783, -5.350489>
			}
			triangle {
				< -1.102918, 0.425866, -4.699223>,
				< -1.528583, 0.468783, -5.350489>,
				< -1.386140, 0.471044, -5.393437>
			}
			triangle {
				< -1.743650, 0.513961, -6.061398>,
				< -1.623915, 0.515421, -6.089406>,
				< -1.386140, 0.471044, -5.393437>
			}
			triangle {
				< -1.386140, 0.471044, -5.393437>,
				< -1.528583, 0.468783, -5.350489>,
				< -1.743650, 0.513961, -6.061398>
			}
			triangle {
				< 1.498042, 0.347201, -1.519564>,
				< 1.928976, 0.308539, -0.781571>,
				< 1.747483, 0.165561, -0.721687>
			}
			triangle {
				< 1.325567, 0.201483, -1.582541>,
				< 1.498042, 0.347201, -1.519564>,
				< 1.747483, 0.165561, -0.721687>
			}
			triangle {
				< 1.146426, 0.381517, -2.174432>,
				< 1.498042, 0.347201, -1.519564>,
				< 1.325567, 0.201483, -1.582541>
			}
			triangle {
				< 0.974011, 0.250680, -2.236634>,
				< 1.146426, 0.381517, -2.174432>,
				< 1.325567, 0.201483, -1.582541>
			}
			triangle {
				< 0.724541, 0.422708, -2.960225>,
				< 1.146426, 0.381517, -2.174432>,
				< 0.974011, 0.250680, -2.236634>
			}
			triangle {
				< 0.552065, 0.305236, -3.021742>,
				< 0.724541, 0.422708, -2.960225>,
				< 0.974011, 0.250680, -2.236634>
			}
			triangle {
				< 0.443252, 0.450179, -3.484105>,
				< 0.724541, 0.422708, -2.960225>,
				< 0.552065, 0.305236, -3.021742>
			}
			triangle {
				< 0.270778, 0.344731, -3.545000>,
				< 0.443252, 0.450179, -3.484105>,
				< 0.552065, 0.305236, -3.021742>
			}
			triangle {
				< 0.091667, 0.484496, -4.138972>,
				< 0.443252, 0.450179, -3.484105>,
				< 0.270778, 0.344731, -3.545000>
			}
			triangle {
				< -0.080809, 0.389880, -4.199272>,
				< 0.091667, 0.484496, -4.138972>,
				< 0.270778, 0.344731, -3.545000>
			}
			triangle {
				< -0.259951, 0.518812, -4.793810>,
				< 0.091667, 0.484496, -4.138972>,
				< -0.080809, 0.389880, -4.199272>
			}
			triangle {
				< -0.432425, 0.433928, -4.853602>,
				< -0.259951, 0.518812, -4.793810>,
				< -0.080809, 0.389880, -4.199272>
			}
			triangle {
				< -0.611567, 0.553128, -5.448648>,
				< -0.259951, 0.518812, -4.793810>,
				< -0.432425, 0.433928, -4.853602>
			}
			triangle {
				< -0.784042, 0.477024, -5.507993>,
				< -0.611567, 0.553128, -5.448648>,
				< -0.432425, 0.433928, -4.853602>
			}
			triangle {
				< -0.963184, 0.587444, -6.103515>,
				< -0.611567, 0.553128, -5.448648>,
				< -0.784042, 0.477024, -5.507993>
			}
			triangle {
				< -1.135658, 0.519258, -6.162443>,
				< -0.963184, 0.587444, -6.103515>,
				< -0.784042, 0.477024, -5.507993>
			}
			triangle {
				< -1.315128, 0.603842, -6.416349>,
				< -0.963184, 0.587444, -6.103515>,
				< -1.135658, 0.519258, -6.162443>
			}
			triangle {
				< -1.326288, 0.534347, -6.314412>,
				< -1.315128, 0.603842, -6.416349>,
				< -1.135658, 0.519258, -6.162443>
			}
			triangle {
				< -1.530907, 0.605421, -6.446676>,
				< -1.315128, 0.603842, -6.416349>,
				< -1.326288, 0.534347, -6.314412>
			}
			triangle {
				< -1.542068, 0.537056, -6.366437>,
				< -1.530907, 0.605421, -6.446676>,
				< -1.326288, 0.534347, -6.314412>
			}
			triangle {
				< -1.947583, 0.602239, -6.385990>,
				< -1.530907, 0.605421, -6.446676>,
				< -1.542068, 0.537056, -6.366437>
			}
			triangle {
				< -1.829663, 0.535985, -6.345574>,
				< -1.947583, 0.602239, -6.385990>,
				< -1.542068, 0.537056, -6.366437>
			}
			triangle {
				< -1.872759, 0.588905, -6.131282>,
				< -1.947583, 0.602239, -6.385990>,
				< -1.829663, 0.535985, -6.345574>
			}
			triangle {
				< -1.743650, 0.513961, -6.061398>,
				< -1.872759, 0.588905, -6.131282>,
				< -1.829663, 0.535985, -6.345574>
			}
			triangle {
				< -1.657694, 0.551613, -5.419954>,
				< -1.872759, 0.588905, -6.131282>,
				< -1.743650, 0.513961, -6.061398>
			}
			triangle {
				< -1.528583, 0.468783, -5.350489>,
				< -1.657694, 0.551613, -5.419954>,
				< -1.743650, 0.513961, -6.061398>
			}
			triangle {
				< -1.442658, 0.514352, -4.708627>,
				< -1.657694, 0.551613, -5.419954>,
				< -1.528583, 0.468783, -5.350489>
			}
			triangle {
				< -1.313519, 0.422742, -4.639609>,
				< -1.442658, 0.514352, -4.708627>,
				< -1.528583, 0.468783, -5.350489>
			}
			triangle {
				< -1.227594, 0.477060, -3.997301>,
				< -1.442658, 0.514352, -4.708627>,
				< -1.313519, 0.422742, -4.639609>
			}
			triangle {
				< -1.098482, 0.375718, -3.928787>,
				< -1.227594, 0.477060, -3.997301>,
				< -1.313519, 0.422742, -4.639609>
			}
			triangle {
				< -1.055534, 0.447239, -3.428238>,
				< -1.227594, 0.477060, -3.997301>,
				< -1.098482, 0.375718, -3.928787>
			}
			triangle {
				< -0.926425, 0.335062, -3.360292>,
				< -1.055534, 0.447239, -3.428238>,
				< -1.098482, 0.375718, -3.928787>
			}
			triangle {
				< -0.883506, 0.417417, -2.859178>,
				< -1.055534, 0.447239, -3.428238>,
				< -0.926425, 0.335062, -3.360292>
			}
			triangle {
				< -0.754367, 0.293187, -2.791855>,
				< -0.883506, 0.417417, -2.859178>,
				< -0.926425, 0.335062, -3.360292>
			}
			triangle {
				< -0.668439, 0.380156, -2.147851>,
				< -0.883506, 0.417417, -2.859178>,
				< -0.754367, 0.293187, -2.791855>
			}
			triangle {
				< -0.539331, 0.242532, -2.081242>,
				< -0.668439, 0.380156, -2.147851>,
				< -0.754367, 0.293187, -2.791855>
			}
			triangle {
				< -0.666683, 0.350038, -1.573461>,
				< -0.668439, 0.380156, -2.147851>,
				< -0.539331, 0.242532, -2.081242>
			}
			triangle {
				< -0.537574, 0.197592, -1.507626>,
				< -0.666683, 0.350038, -1.573461>,
				< -0.539331, 0.242532, -2.081242>
			}
			triangle {
				< -0.660343, 0.308848, -0.781568>,
				< -0.666683, 0.350038, -1.573461>,
				< -0.537574, 0.197592, -1.507626>
			}
			triangle {
				< -0.533853, 0.165956, -0.722965>,
				< -0.660343, 0.308848, -0.781568>,
				< -0.537574, 0.197592, -1.507626>
			}
			triangle {
				< -0.057650, 0.308994, -0.790229>,
				< -0.660343, 0.308848, -0.781568>,
				< -0.533853, 0.165956, -0.722965>
			}
			triangle {
				< -0.057650, 0.165658, -0.722994>,
				< -0.057650, 0.308994, -0.790229>,
				< -0.533853, 0.165956, -0.722965>
			}
			triangle {
				< 0.567365, 0.308992, -0.790229>,
				< -0.057650, 0.308994, -0.790229>,
				< -0.057650, 0.165658, -0.722994>
			}
			triangle {
				< 0.567365, 0.165655, -0.722995>,
				< 0.567365, 0.308992, -0.790229>,
				< -0.057650, 0.165658, -0.722994>
			}
			triangle {
				< 1.065860, 0.308990, -0.790230>,
				< 0.567365, 0.308992, -0.790229>,
				< 0.567365, 0.165655, -0.722995>
			}
			triangle {
				< 1.065859, 0.165653, -0.722996>,
				< 1.065860, 0.308990, -0.790230>,
				< 0.567365, 0.165655, -0.722995>
			}
			triangle {
				< 1.928976, 0.308539, -0.781571>,
				< 1.065860, 0.308990, -0.790230>,
				< 1.065859, 0.165653, -0.722996>
			}
			triangle {
				< 1.747483, 0.165561, -0.721687>,
				< 1.928976, 0.308539, -0.781571>,
				< 1.065859, 0.165653, -0.722996>
			}
			triangle {
				< 1.325569, 0.498723, -1.566977>,
				< 1.747484, 0.457532, -0.781153>,
				< 1.928976, 0.308539, -0.781571>
			}
			triangle {
				< 1.498042, 0.347201, -1.519564>,
				< 1.325569, 0.498723, -1.566977>,
				< 1.928976, 0.308539, -0.781571>
			}
			triangle {
				< 0.974012, 0.518188, -2.222616>,
				< 1.325569, 0.498723, -1.566977>,
				< 1.498042, 0.347201, -1.519564>
			}
			triangle {
				< 1.146426, 0.381517, -2.174432>,
				< 0.974012, 0.518188, -2.222616>,
				< 1.498042, 0.347201, -1.519564>
			}
			triangle {
				< 0.552066, 0.545986, -3.009124>,
				< 0.974012, 0.518188, -2.222616>,
				< 1.146426, 0.381517, -2.174432>
			}
			triangle {
				< 0.724541, 0.422708, -2.960225>,
				< 0.552066, 0.545986, -3.009124>,
				< 1.146426, 0.381517, -2.174432>
			}
			triangle {
				< 0.270779, 0.561403, -3.533631>,
				< 0.552066, 0.545986, -3.009124>,
				< 0.724541, 0.422708, -2.960225>
			}
			triangle {
				< 0.443252, 0.450179, -3.484105>,
				< 0.270779, 0.561403, -3.533631>,
				< 0.724541, 0.422708, -2.960225>
			}
			triangle {
				< -0.080809, 0.584885, -4.189063>,
				< 0.270779, 0.561403, -3.533631>,
				< 0.443252, 0.450179, -3.484105>
			}
			triangle {
				< 0.091667, 0.484496, -4.138972>,
				< -0.080809, 0.584885, -4.189063>,
				< 0.443252, 0.450179, -3.484105>
			}
			triangle {
				< -0.432424, 0.609439, -4.844407>,
				< -0.080809, 0.584885, -4.189063>,
				< 0.091667, 0.484496, -4.138972>
			}
			triangle {
				< -0.259951, 0.518812, -4.793810>,
				< -0.432424, 0.609439, -4.844407>,
				< 0.091667, 0.484496, -4.138972>
			}
			triangle {
				< -0.784042, 0.635004, -5.499719>,
				< -0.432424, 0.609439, -4.844407>,
				< -0.259951, 0.518812, -4.793810>
			}
			triangle {
				< -0.611567, 0.553128, -5.448648>,
				< -0.784042, 0.635004, -5.499719>,
				< -0.259951, 0.518812, -4.793810>
			}
			triangle {
				< -1.135657, 0.661403, -6.154973>,
				< -0.784042, 0.635004, -5.499719>,
				< -0.611567, 0.553128, -5.448648>
			}
			triangle {
				< -0.963184, 0.587444, -6.103515>,
				< -1.135657, 0.661403, -6.154973>,
				< -0.611567, 0.553128, -5.448648>
			}
			triangle {
				< -1.326287, 0.662297, -6.307715>,
				< -1.135657, 0.661403, -6.154973>,
				< -0.963184, 0.587444, -6.103515>
			}
			triangle {
				< -1.315128, 0.603842, -6.416349>,
				< -1.326287, 0.662297, -6.307715>,
				< -0.963184, 0.587444, -6.103515>
			}
			triangle {
				< -1.542068, 0.665006, -6.359710>,
				< -1.326287, 0.662297, -6.307715>,
				< -1.315128, 0.603842, -6.416349>
			}
			triangle {
				< -1.530907, 0.605421, -6.446676>,
				< -1.542068, 0.665006, -6.359710>,
				< -1.315128, 0.603842, -6.416349>
			}
			triangle {
				< -1.829663, 0.663907, -6.338875>,
				< -1.542068, 0.665006, -6.359710>,
				< -1.530907, 0.605421, -6.446676>
			}
			triangle {
				< -1.947583, 0.602239, -6.385990>,
				< -1.829663, 0.663907, -6.338875>,
				< -1.530907, 0.605421, -6.446676>
			}
			triangle {
				< -1.743650, 0.656108, -6.053959>,
				< -1.829663, 0.663907, -6.338875>,
				< -1.947583, 0.602239, -6.385990>
			}
			triangle {
				< -1.872759, 0.588905, -6.131282>,
				< -1.743650, 0.656108, -6.053959>,
				< -1.947583, 0.602239, -6.385990>
			}
			triangle {
				< -1.528582, 0.626733, -5.342215>,
				< -1.743650, 0.656108, -6.053959>,
				< -1.872759, 0.588905, -6.131282>
			}
			triangle {
				< -1.657694, 0.551613, -5.419954>,
				< -1.528582, 0.626733, -5.342215>,
				< -1.872759, 0.588905, -6.131282>
			}
			triangle {
				< -1.313518, 0.598223, -4.630412>,
				< -1.528582, 0.626733, -5.342215>,
				< -1.657694, 0.551613, -5.419954>
			}
			triangle {
				< -1.442658, 0.514352, -4.708627>,
				< -1.313518, 0.598223, -4.630412>,
				< -1.657694, 0.551613, -5.419954>
			}
			triangle {
				< -1.098481, 0.570723, -3.918579>,
				< -1.313518, 0.598223, -4.630412>,
				< -1.442658, 0.514352, -4.708627>
			}
			triangle {
				< -1.227594, 0.477060, -3.997301>,
				< -1.098481, 0.570723, -3.918579>,
				< -1.442658, 0.514352, -4.708627>
			}
			triangle {
				< -0.926424, 0.551736, -3.348952>,
				< -1.098481, 0.570723, -3.918579>,
				< -1.227594, 0.477060, -3.997301>
			}
			triangle {
				< -1.055534, 0.447239, -3.428238>,
				< -0.926424, 0.551736, -3.348952>,
				< -1.227594, 0.477060, -3.997301>
			}
			triangle {
				< -0.754366, 0.533938, -2.779236>,
				< -0.926424, 0.551736, -3.348952>,
				< -1.055534, 0.447239, -3.428238>
			}
			triangle {
				< -0.883506, 0.417417, -2.859178>,
				< -0.754366, 0.533938, -2.779236>,
				< -1.055534, 0.447239, -3.428238>
			}
			triangle {
				< -0.539329, 0.510040, -2.067225>,
				< -0.754366, 0.533938, -2.779236>,
				< -0.883506, 0.417417, -2.859178>
			}
			triangle {
				< -0.668439, 0.380156, -2.147851>,
				< -0.539329, 0.510040, -2.067225>,
				< -0.883506, 0.417417, -2.859178>
			}
			triangle {
				< -0.537572, 0.494801, -1.492061>,
				< -0.539329, 0.510040, -2.067225>,
				< -0.668439, 0.380156, -2.147851>
			}
			triangle {
				< -0.666683, 0.350038, -1.573461>,
				< -0.537572, 0.494801, -1.492061>,
				< -0.668439, 0.380156, -2.147851>
			}
			triangle {
				< -0.533852, 0.457898, -0.782429>,
				< -0.537572, 0.494801, -1.492061>,
				< -0.666683, 0.350038, -1.573461>
			}
			triangle {
				< -0.660343, 0.308848, -0.781568>,
				< -0.533852, 0.457898, -0.782429>,
				< -0.666683, 0.350038, -1.573461>
			}
			triangle {
				< -0.057649, 0.457600, -0.782460>,
				< -0.533852, 0.457898, -0.782429>,
				< -0.660343, 0.308848, -0.781568>
			}
			triangle {
				< -0.057650, 0.308994, -0.790229>,
				< -0.057649, 0.457600, -0.782460>,
				< -0.660343, 0.308848, -0.781568>
			}
			triangle {
				< 0.567366, 0.457597, -0.782461>,
				< -0.057649, 0.457600, -0.782460>,
				< -0.057650, 0.308994, -0.790229>
			}
			triangle {
				< 0.567365, 0.308992, -0.790229>,
				< 0.567366, 0.457597, -0.782461>,
				< -0.057650, 0.308994, -0.790229>
			}
			triangle {
				< 1.065860, 0.457595, -0.782462>,
				< 0.567366, 0.457597, -0.782461>,
				< 0.567365, 0.308992, -0.790229>
			}
			triangle {
				< 1.065860, 0.308990, -0.790230>,
				< 1.065860, 0.457595, -0.782462>,
				< 0.567365, 0.308992, -0.790229>
			}
			triangle {
				< 1.747484, 0.457532, -0.781153>,
				< 1.065860, 0.457595, -0.782462>,
				< 1.065860, 0.308990, -0.790230>
			}
			triangle {
				< 1.928976, 0.308539, -0.781571>,
				< 1.747484, 0.457532, -0.781153>,
				< 1.065860, 0.308990, -0.790230>
			}
			triangle {
				< -0.539329, 0.510040, -2.067225>,
				< -0.206076, 0.515842, -2.178299>,
				< -0.754366, 0.533938, -2.779236>
			}
			triangle {
				< -0.206076, 0.515842, -2.178299>,
				< -0.453851, 0.537418, -2.845518>,
				< -0.754366, 0.533938, -2.779236>
			}
			triangle {
				< -1.743650, 0.656108, -6.053959>,
				< -1.623914, 0.657596, -6.081936>,
				< -1.829663, 0.663907, -6.338875>
			}
			triangle {
				< -1.829663, 0.663907, -6.338875>,
				< -1.623914, 0.657596, -6.081936>,
				< -1.467660, 0.660304, -6.133960>
			}
			triangle {
				< -1.467660, 0.660304, -6.133960>,
				< -1.542068, 0.665006, -6.359710>,
				< -1.829663, 0.663907, -6.338875>
			}
			triangle {
				< -1.326287, 0.662297, -6.307715>,
				< -1.311406, 0.661672, -6.159975>,
				< -1.135657, 0.661403, -6.154973>
			}
			triangle {
				< 1.065860, 0.457595, -0.782462>,
				< 0.410010, 0.494739, -1.490931>,
				< 0.567366, 0.457597, -0.782461>
			}
			triangle {
				< 1.065860, 0.457595, -0.782462>,
				< 0.785020, 0.496374, -1.522154>,
				< 0.410010, 0.494739, -1.490931>
			}
			triangle {
				< 0.567366, 0.457597, -0.782461>,
				< 0.410010, 0.494739, -1.490931>,
				< -0.057649, 0.457600, -0.782460>
			}
			triangle {
				< 0.410010, 0.494739, -1.490931>,
				< -0.112324, 0.494741, -1.490931>,
				< -0.057649, 0.457600, -0.782460>
			}
			triangle {
				< 0.168931, 0.516673, -2.193895>,
				< -0.112324, 0.494741, -1.490931>,
				< 0.410010, 0.494739, -1.490931>
			}
			triangle {
				< 0.785020, 0.496374, -1.522154>,
				< 0.168931, 0.516673, -2.193895>,
				< 0.410010, 0.494739, -1.490931>
			}
			triangle {
				< 0.785020, 0.496374, -1.522154>,
				< 0.564032, 0.518070, -2.220653>,
				< 0.168931, 0.516673, -2.193895>
			}
			triangle {
				< 0.168931, 0.516673, -2.193895>,
				< -0.206076, 0.515842, -2.178299>,
				< -0.112324, 0.494741, -1.490931>
			}
			triangle {
				< 0.168931, 0.516673, -2.193895>,
				< -0.132415, 0.539054, -2.876710>,
				< -0.206076, 0.515842, -2.178299>
			}
			triangle {
				< -0.132415, 0.539054, -2.876710>,
				< -0.453851, 0.537418, -2.845518>,
				< -0.206076, 0.515842, -2.178299>
			}
			triangle {
				< 0.564032, 0.518070, -2.220653>,
				< -0.132415, 0.539054, -2.876710>,
				< 0.168931, 0.516673, -2.193895>
			}
			triangle {
				< 0.564032, 0.518070, -2.220653>,
				< 0.202415, 0.541493, -2.923526>,
				< -0.132415, 0.539054, -2.876710>
			}
			triangle {
				< -0.414804, 0.558966, -3.487260>,
				< -0.132415, 0.539054, -2.876710>,
				< 0.202415, 0.541493, -2.923526>
			}
			triangle {
				< -0.132415, 0.539054, -2.876710>,
				< -0.414804, 0.558966, -3.487260>,
				< -0.453851, 0.537418, -2.845518>
			}
			triangle {
				< -0.414804, 0.558966, -3.487260>,
				< -0.729514, 0.557091, -3.451604>,
				< -0.453851, 0.537418, -2.845518>
			}
			triangle {
				< -0.126819, 0.561196, -3.529614>,
				< -0.414804, 0.558966, -3.487260>,
				< 0.202415, 0.541493, -2.923526>
			}
			triangle {
				< -0.644988, 0.578906, -4.074714>,
				< -0.729514, 0.557091, -3.451604>,
				< -0.414804, 0.558966, -3.487260>
			}
			triangle {
				< -0.644988, 0.578906, -4.074714>,
				< -0.875529, 0.574828, -3.997450>,
				< -0.729514, 0.557091, -3.451604>
			}
			triangle {
				< -0.644988, 0.578906, -4.074714>,
				< -0.414804, 0.558966, -3.487260>,
				< -0.126819, 0.561196, -3.529614>
			}
			triangle {
				< -0.349535, 0.581106, -4.117216>,
				< -0.644988, 0.578906, -4.074714>,
				< -0.126819, 0.561196, -3.529614>
			}
			triangle {
				< -0.882525, 0.604023, -4.740951>,
				< -0.644988, 0.578906, -4.074714>,
				< -0.349535, 0.581106, -4.117216>
			}
			triangle {
				< -0.644988, 0.578906, -4.074714>,
				< -0.882525, 0.604023, -4.740951>,
				< -0.875529, 0.574828, -3.997450>
			}
			triangle {
				< -0.882525, 0.604023, -4.740951>,
				< -1.102917, 0.601346, -4.690056>,
				< -0.875529, 0.574828, -3.997450>
			}
			triangle {
				< -0.349535, 0.581106, -4.117216>,
				< -0.612311, 0.607474, -4.806906>,
				< -0.882525, 0.604023, -4.740951>
			}
			triangle {
				< -1.147742, 0.633369, -5.468676>,
				< -1.102917, 0.601346, -4.690056>,
				< -0.882525, 0.604023, -4.740951>
			}
			triangle {
				< -1.147742, 0.633369, -5.468676>,
				< -0.882525, 0.604023, -4.740951>,
				< -0.612311, 0.607474, -4.806906>
			}
			triangle {
				< -0.969137, 0.635957, -5.518052>,
				< -1.147742, 0.633369, -5.468676>,
				< -0.612311, 0.607474, -4.806906>
			}
			triangle {
				< -1.147742, 0.633369, -5.468676>,
				< -1.386139, 0.628994, -5.385162>,
				< -1.102917, 0.601346, -4.690056>
			}
			triangle {
				< -1.147742, 0.633369, -5.468676>,
				< -1.467660, 0.660304, -6.133960>,
				< -1.386139, 0.628994, -5.385162>
			}
			triangle {
				< -1.467660, 0.660304, -6.133960>,
				< -1.623914, 0.657596, -6.081936>,
				< -1.386139, 0.628994, -5.385162>
			}
			triangle {
				< -0.969137, 0.635957, -5.518052>,
				< -1.467660, 0.660304, -6.133960>,
				< -1.147742, 0.633369, -5.468676>
			}
			triangle {
				< -0.969137, 0.635957, -5.518052>,
				< -1.311406, 0.661672, -6.159975>,
				< -1.467660, 0.660304, -6.133960>
			}
			triangle {
				< -0.057649, 0.457600, -0.782460>,
				< -0.537572, 0.494801, -1.492061>,
				< -0.533852, 0.457898, -0.782429>
			}
			triangle {
				< -0.057649, 0.457600, -0.782460>,
				< -0.112324, 0.494741, -1.490931>,
				< -0.537572, 0.494801, -1.492061>
			}
			triangle {
				< -0.537572, 0.494801, -1.492061>,
				< -0.112324, 0.494741, -1.490931>,
				< -0.539329, 0.510040, -2.067225>
			}
			triangle {
				< -0.112324, 0.494741, -1.490931>,
				< -0.206076, 0.515842, -2.178299>,
				< -0.539329, 0.510040, -2.067225>
			}
			triangle {
				< -0.754366, 0.533938, -2.779236>,
				< -0.453851, 0.537418, -2.845518>,
				< -0.926424, 0.551736, -3.348952>
			}
			triangle {
				< -0.453851, 0.537418, -2.845518>,
				< -0.729514, 0.557091, -3.451604>,
				< -0.926424, 0.551736, -3.348952>
			}
			triangle {
				< -0.729514, 0.557091, -3.451604>,
				< -0.875529, 0.574828, -3.997450>,
				< -1.098481, 0.570723, -3.918579>
			}
			triangle {
				< -0.729514, 0.557091, -3.451604>,
				< -1.098481, 0.570723, -3.918579>,
				< -0.926424, 0.551736, -3.348952>
			}
			triangle {
				< -0.875529, 0.574828, -3.997450>,
				< -1.102917, 0.601346, -4.690056>,
				< -1.313518, 0.598223, -4.630412>
			}
			triangle {
				< -1.313518, 0.598223, -4.630412>,
				< -1.098481, 0.570723, -3.918579>,
				< -0.875529, 0.574828, -3.997450>
			}
			triangle {
				< -1.313518, 0.598223, -4.630412>,
				< -1.102917, 0.601346, -4.690056>,
				< -1.528582, 0.626733, -5.342215>
			}
			triangle {
				< -1.102917, 0.601346, -4.690056>,
				< -1.386139, 0.628994, -5.385162>,
				< -1.528582, 0.626733, -5.342215>
			}
			triangle {
				< -1.386139, 0.628994, -5.385162>,
				< -1.623914, 0.657596, -6.081936>,
				< -1.743650, 0.656108, -6.053959>
			}
			triangle {
				< -1.743650, 0.656108, -6.053959>,
				< -1.528582, 0.626733, -5.342215>,
				< -1.386139, 0.628994, -5.385162>
			}
			triangle {
				< 1.747484, 0.457532, -0.781153>,
				< 1.325569, 0.498723, -1.566977>,
				< 0.785020, 0.496374, -1.522154>
			}
			triangle {
				< 1.747484, 0.457532, -0.781153>,
				< 0.785020, 0.496374, -1.522154>,
				< 1.065860, 0.457595, -0.782462>
			}
			triangle {
				< 0.974012, 0.518188, -2.222616>,
				< 0.564032, 0.518070, -2.220653>,
				< 1.325569, 0.498723, -1.566977>
			}
			triangle {
				< 1.325569, 0.498723, -1.566977>,
				< 0.564032, 0.518070, -2.220653>,
				< 0.785020, 0.496374, -1.522154>
			}
			triangle {
				< 0.974012, 0.518188, -2.222616>,
				< 0.552066, 0.545986, -3.009124>,
				< 0.202415, 0.541493, -2.923526>
			}
			triangle {
				< 0.974012, 0.518188, -2.222616>,
				< 0.202415, 0.541493, -2.923526>,
				< 0.564032, 0.518070, -2.220653>
			}
			triangle {
				< 0.270779, 0.561403, -3.533631>,
				< -0.126819, 0.561196, -3.529614>,
				< 0.552066, 0.545986, -3.009124>
			}
			triangle {
				< 0.552066, 0.545986, -3.009124>,
				< -0.126819, 0.561196, -3.529614>,
				< 0.202415, 0.541493, -2.923526>
			}
			triangle {
				< 0.270779, 0.561403, -3.533631>,
				< -0.080809, 0.584885, -4.189063>,
				< -0.349535, 0.581106, -4.117216>
			}
			triangle {
				< 0.270779, 0.561403, -3.533631>,
				< -0.349535, 0.581106, -4.117216>,
				< -0.126819, 0.561196, -3.529614>
			}
			triangle {
				< -0.612311, 0.607474, -4.806906>,
				< -0.080809, 0.584885, -4.189063>,
				< -0.432424, 0.609439, -4.844407>
			}
			triangle {
				< -0.080809, 0.584885, -4.189063>,
				< -0.612311, 0.607474, -4.806906>,
				< -0.349535, 0.581106, -4.117216>
			}
			triangle {
				< -0.432424, 0.609439, -4.844407>,
				< -0.784042, 0.635004, -5.499719>,
				< -0.969137, 0.635957, -5.518052>
			}
			triangle {
				< -0.432424, 0.609439, -4.844407>,
				< -0.969137, 0.635957, -5.518052>,
				< -0.612311, 0.607474, -4.806906>
			}
			triangle {
				< -1.311406, 0.661672, -6.159975>,
				< -0.784042, 0.635004, -5.499719>,
				< -1.135657, 0.661403, -6.154973>
			}
			triangle {
				< -0.784042, 0.635004, -5.499719>,
				< -1.311406, 0.661672, -6.159975>,
				< -0.969137, 0.635957, -5.518052>
			}
			triangle {
				< -1.467660, 0.660304, -6.133960>,
				< -1.311406, 0.661672, -6.159975>,
				< -1.542068, 0.665006, -6.359710>
			}
			triangle {
				< -1.542068, 0.665006, -6.359710>,
				< -1.311406, 0.661672, -6.159975>,
				< -1.326287, 0.662297, -6.307715>
			}
			triangle {
				< 1.065862, 0.455128, 0.782457>,
				< 1.325573, 0.496291, 1.566968>,
				< 1.747486, 0.455067, 0.781175>
			}
			triangle {
				< 1.325573, 0.496291, 1.566968>,
				< 1.065862, 0.455128, 0.782457>,
				< 0.785024, 0.493941, 1.522147>
			}
			triangle {
				< 0.974018, 0.515818, 2.222611>,
				< 1.325573, 0.496291, 1.566968>,
				< 0.785024, 0.493941, 1.522147>
			}
			triangle {
				< 0.785024, 0.493941, 1.522147>,
				< 0.564038, 0.515700, 2.220646>,
				< 0.974018, 0.515818, 2.222611>
			}
			triangle {
				< -0.539324, 0.507670, 2.067222>,
				< -0.754358, 0.531601, 2.779264>,
				< -0.206070, 0.513472, 2.178296>
			}
			triangle {
				< -0.754358, 0.531601, 2.779264>,
				< -0.453843, 0.535082, 2.845514>,
				< -0.206070, 0.513472, 2.178296>
			}
			triangle {
				< 0.202422, 0.539188, 2.923521>,
				< 0.552074, 0.543651, 3.009118>,
				< 0.564038, 0.515700, 2.220646>
			}
			triangle {
				< 0.552074, 0.543651, 3.009118>,
				< 0.974018, 0.515818, 2.222611>,
				< 0.564038, 0.515700, 2.220646>
			}
			triangle {
				< 0.270788, 0.559130, 3.533627>,
				< 0.552074, 0.543651, 3.009118>,
				< 0.202422, 0.539188, 2.923521>
			}
			triangle {
				< 0.202422, 0.539188, 2.923521>,
				< -0.126810, 0.558894, 3.529609>,
				< 0.270788, 0.559130, 3.533627>
			}
			triangle {
				< -0.126810, 0.558894, 3.529609>,
				< -0.080797, 0.582645, 4.189060>,
				< 0.270788, 0.559130, 3.533627>
			}
			triangle {
				< -0.126810, 0.558894, 3.529609>,
				< -0.349524, 0.578866, 4.117213>,
				< -0.080797, 0.582645, 4.189060>
			}
			triangle {
				< -0.432411, 0.607261, 4.844404>,
				< -0.080797, 0.582645, 4.189060>,
				< -0.349524, 0.578866, 4.117213>
			}
			triangle {
				< -0.612298, 0.605299, 4.806903>,
				< -0.432411, 0.607261, 4.844404>,
				< -0.349524, 0.578866, 4.117213>
			}
			triangle {
				< -0.969122, 0.633813, 5.518051>,
				< -0.784027, 0.632832, 5.499718>,
				< -0.612298, 0.605299, 4.806903>
			}
			triangle {
				< -0.784027, 0.632832, 5.499718>,
				< -0.432411, 0.607261, 4.844404>,
				< -0.612298, 0.605299, 4.806903>
			}
			triangle {
				< -1.135641, 0.659294, 6.154973>,
				< -0.784027, 0.632832, 5.499718>,
				< -0.969122, 0.633813, 5.518051>
			}
			triangle {
				< -0.969122, 0.633813, 5.518051>,
				< -1.311390, 0.659562, 6.159973>,
				< -1.135641, 0.659294, 6.154973>
			}
			triangle {
				< -1.743634, 0.653998, 6.053960>,
				< -1.829647, 0.661827, 6.338877>,
				< -1.623898, 0.655486, 6.081965>
			}
			triangle {
				< -1.467644, 0.658192, 6.133961>,
				< -1.623898, 0.655486, 6.081965>,
				< -1.829647, 0.661827, 6.338877>
			}
			triangle {
				< -1.829647, 0.661827, 6.338877>,
				< -1.542051, 0.662926, 6.359742>,
				< -1.467644, 0.658192, 6.133961>
			}
			triangle {
				< -1.542051, 0.662926, 6.359742>,
				< -1.326270, 0.660188, 6.307715>,
				< -1.467644, 0.658192, 6.133961>
			}
			triangle {
				< -1.467644, 0.658192, 6.133961>,
				< -1.326270, 0.660188, 6.307715>,
				< -1.311390, 0.659562, 6.159973>
			}
			triangle {
				< -1.326270, 0.660188, 6.307715>,
				< -1.135641, 0.659294, 6.154973>,
				< -1.311390, 0.659562, 6.159973>
			}
			triangle {
				< 0.410014, 0.492306, 1.490956>,
				< 1.065862, 0.455128, 0.782457>,
				< 0.567368, 0.455130, 0.782457>
			}
			triangle {
				< 0.785024, 0.493941, 1.522147>,
				< 1.065862, 0.455128, 0.782457>,
				< 0.410014, 0.492306, 1.490956>
			}
			triangle {
				< 0.410014, 0.492306, 1.490956>,
				< 0.567368, 0.455130, 0.782457>,
				< -0.057647, 0.455133, 0.782458>
			}
			triangle {
				< 0.410014, 0.492306, 1.490956>,
				< -0.057647, 0.455133, 0.782458>,
				< -0.112320, 0.492308, 1.490957>
			}
			triangle {
				< 0.410014, 0.492306, 1.490956>,
				< -0.112320, 0.492308, 1.490957>,
				< 0.168937, 0.514303, 2.193892>
			}
			triangle {
				< 0.410014, 0.492306, 1.490956>,
				< 0.168937, 0.514303, 2.193892>,
				< 0.785024, 0.493941, 1.522147>
			}
			triangle {
				< 0.168937, 0.514303, 2.193892>,
				< 0.564038, 0.515700, 2.220646>,
				< 0.785024, 0.493941, 1.522147>
			}
			triangle {
				< -0.112320, 0.492308, 1.490957>,
				< -0.206070, 0.513472, 2.178296>,
				< 0.168937, 0.514303, 2.193892>
			}
			triangle {
				< -0.206070, 0.513472, 2.178296>,
				< -0.132407, 0.536718, 2.876706>,
				< 0.168937, 0.514303, 2.193892>
			}
			triangle {
				< -0.206070, 0.513472, 2.178296>,
				< -0.453843, 0.535082, 2.845514>,
				< -0.132407, 0.536718, 2.876706>
			}
			triangle {
				< 0.168937, 0.514303, 2.193892>,
				< -0.132407, 0.536718, 2.876706>,
				< 0.564038, 0.515700, 2.220646>
			}
			triangle {
				< -0.132407, 0.536718, 2.876706>,
				< 0.202422, 0.539188, 2.923521>,
				< 0.564038, 0.515700, 2.220646>
			}
			triangle {
				< 0.202422, 0.539188, 2.923521>,
				< -0.132407, 0.536718, 2.876706>,
				< -0.414795, 0.556692, 3.487256>
			}
			triangle {
				< -0.453843, 0.535082, 2.845514>,
				< -0.414795, 0.556692, 3.487256>,
				< -0.132407, 0.536718, 2.876706>
			}
			triangle {
				< -0.453843, 0.535082, 2.845514>,
				< -0.729505, 0.554817, 3.451602>,
				< -0.414795, 0.556692, 3.487256>
			}
			triangle {
				< 0.202422, 0.539188, 2.923521>,
				< -0.414795, 0.556692, 3.487256>,
				< -0.126810, 0.558894, 3.529609>
			}
			triangle {
				< -0.414795, 0.556692, 3.487256>,
				< -0.729505, 0.554817, 3.451602>,
				< -0.644977, 0.576635, 4.074713>
			}
			triangle {
				< -0.729505, 0.554817, 3.451602>,
				< -0.875519, 0.572587, 3.997449>,
				< -0.644977, 0.576635, 4.074713>
			}
			triangle {
				< -0.126810, 0.558894, 3.529609>,
				< -0.414795, 0.556692, 3.487256>,
				< -0.644977, 0.576635, 4.074713>
			}
			triangle {
				< -0.126810, 0.558894, 3.529609>,
				< -0.644977, 0.576635, 4.074713>,
				< -0.349524, 0.578866, 4.117213>
			}
			triangle {
				< -0.349524, 0.578866, 4.117213>,
				< -0.644977, 0.576635, 4.074713>,
				< -0.882513, 0.601817, 4.740948>
			}
			triangle {
				< -0.875519, 0.572587, 3.997449>,
				< -0.882513, 0.601817, 4.740948>,
				< -0.644977, 0.576635, 4.074713>
			}
			triangle {
				< -0.875519, 0.572587, 3.997449>,
				< -1.102905, 0.599168, 4.690056>,
				< -0.882513, 0.601817, 4.740948>
			}
			triangle {
				< -0.882513, 0.601817, 4.740948>,
				< -0.612298, 0.605299, 4.806903>,
				< -0.349524, 0.578866, 4.117213>
			}
			triangle {
				< -0.882513, 0.601817, 4.740948>,
				< -1.102905, 0.599168, 4.690056>,
				< -1.147727, 0.631225, 5.468675>
			}
			triangle {
				< -0.612298, 0.605299, 4.806903>,
				< -0.882513, 0.601817, 4.740948>,
				< -1.147727, 0.631225, 5.468675>
			}
			triangle {
				< -0.612298, 0.605299, 4.806903>,
				< -1.147727, 0.631225, 5.468675>,
				< -0.969122, 0.633813, 5.518051>
			}
			triangle {
				< -1.102905, 0.599168, 4.690056>,
				< -1.386125, 0.626822, 5.385162>,
				< -1.147727, 0.631225, 5.468675>
			}
			triangle {
				< -1.386125, 0.626822, 5.385162>,
				< -1.467644, 0.658192, 6.133961>,
				< -1.147727, 0.631225, 5.468675>
			}
			triangle {
				< -1.386125, 0.626822, 5.385162>,
				< -1.623898, 0.655486, 6.081965>,
				< -1.467644, 0.658192, 6.133961>
			}
			triangle {
				< -1.147727, 0.631225, 5.468675>,
				< -1.467644, 0.658192, 6.133961>,
				< -0.969122, 0.633813, 5.518051>
			}
			triangle {
				< -1.467644, 0.658192, 6.133961>,
				< -1.311390, 0.659562, 6.159973>,
				< -0.969122, 0.633813, 5.518051>
			}
			triangle {
				< -0.533850, 0.454836, 0.782487>,
				< -0.537568, 0.492369, 1.492058>,
				< -0.057647, 0.455133, 0.782458>
			}
			triangle {
				< -0.112320, 0.492308, 1.490957>,
				< -0.057647, 0.455133, 0.782458>,
				< -0.537568, 0.492369, 1.492058>
			}
			triangle {
				< -0.112320, 0.492308, 1.490957>,
				< -0.537568, 0.492369, 1.492058>,
				< -0.539324, 0.507670, 2.067222>
			}
			triangle {
				< -0.112320, 0.492308, 1.490957>,
				< -0.539324, 0.507670, 2.067222>,
				< -0.206070, 0.513472, 2.178296>
			}
			triangle {
				< -0.754358, 0.531601, 2.779264>,
				< -0.926415, 0.549431, 3.348950>,
				< -0.453843, 0.535082, 2.845514>
			}
			triangle {
				< -0.453843, 0.535082, 2.845514>,
				< -0.926415, 0.549431, 3.348950>,
				< -0.729505, 0.554817, 3.451602>
			}
			triangle {
				< -1.098471, 0.568452, 3.918577>,
				< -0.875519, 0.572587, 3.997449>,
				< -0.729505, 0.554817, 3.451602>
			}
			triangle {
				< -0.926415, 0.549431, 3.348950>,
				< -1.098471, 0.568452, 3.918577>,
				< -0.729505, 0.554817, 3.451602>
			}
			triangle {
				< -1.313506, 0.596016, 4.630412>,
				< -1.102905, 0.599168, 4.690056>,
				< -0.875519, 0.572587, 3.997449>
			}
			triangle {
				< -0.875519, 0.572587, 3.997449>,
				< -1.098471, 0.568452, 3.918577>,
				< -1.313506, 0.596016, 4.630412>
			}
			triangle {
				< -1.102905, 0.599168, 4.690056>,
				< -1.313506, 0.596016, 4.630412>,
				< -1.528568, 0.624589, 5.342215>
			}
			triangle {
				< -1.102905, 0.599168, 4.690056>,
				< -1.528568, 0.624589, 5.342215>,
				< -1.386125, 0.626822, 5.385162>
			}
			triangle {
				< -1.743634, 0.653998, 6.053960>,
				< -1.623898, 0.655486, 6.081965>,
				< -1.386125, 0.626822, 5.385162>
			}
			triangle {
				< -1.386125, 0.626822, 5.385162>,
				< -1.528568, 0.624589, 5.342215>,
				< -1.743634, 0.653998, 6.053960>
			}
			triangle {
				< 1.498046, 0.344799, 1.519586>,
				< 1.928978, 0.306073, 0.781593>,
				< 1.747486, 0.455067, 0.781175>
			}
			triangle {
				< 1.325573, 0.496291, 1.566968>,
				< 1.498046, 0.344799, 1.519586>,
				< 1.747486, 0.455067, 0.781175>
			}
			triangle {
				< 1.146432, 0.379147, 2.174425>,
				< 1.498046, 0.344799, 1.519586>,
				< 1.325573, 0.496291, 1.566968>
			}
			triangle {
				< 0.974018, 0.515818, 2.222611>,
				< 1.146432, 0.379147, 2.174425>,
				< 1.325573, 0.496291, 1.566968>
			}
			triangle {
				< 0.724549, 0.420403, 2.960249>,
				< 1.146432, 0.379147, 2.174425>,
				< 0.974018, 0.515818, 2.222611>
			}
			triangle {
				< 0.552074, 0.543651, 3.009118>,
				< 0.724549, 0.420403, 2.960249>,
				< 0.974018, 0.515818, 2.222611>
			}
			triangle {
				< 0.443261, 0.447875, 3.484131>,
				< 0.724549, 0.420403, 2.960249>,
				< 0.552074, 0.543651, 3.009118>
			}
			triangle {
				< 0.270788, 0.559130, 3.533627>,
				< 0.443261, 0.447875, 3.484131>,
				< 0.552074, 0.543651, 3.009118>
			}
			triangle {
				< 0.091678, 0.482256, 4.138969>,
				< 0.443261, 0.447875, 3.484131>,
				< 0.270788, 0.559130, 3.533627>
			}
			triangle {
				< -0.080797, 0.582645, 4.189060>,
				< 0.091678, 0.482256, 4.138969>,
				< 0.270788, 0.559130, 3.533627>
			}
			triangle {
				< -0.259938, 0.516604, 4.793836>,
				< 0.091678, 0.482256, 4.138969>,
				< -0.080797, 0.582645, 4.189060>
			}
			triangle {
				< -0.432411, 0.607261, 4.844404>,
				< -0.259938, 0.516604, 4.793836>,
				< -0.080797, 0.582645, 4.189060>
			}
			triangle {
				< -0.611552, 0.550954, 5.448675>,
				< -0.259938, 0.516604, 4.793836>,
				< -0.432411, 0.607261, 4.844404>
			}
			triangle {
				< -0.784027, 0.632832, 5.499718>,
				< -0.611552, 0.550954, 5.448675>,
				< -0.432411, 0.607261, 4.844404>
			}
			triangle {
				< -0.963168, 0.585332, 6.103514>,
				< -0.611552, 0.550954, 5.448675>,
				< -0.784027, 0.632832, 5.499718>
			}
			triangle {
				< -1.135641, 0.659294, 6.154973>,
				< -0.963168, 0.585332, 6.103514>,
				< -0.784027, 0.632832, 5.499718>
			}
			triangle {
				< -1.315111, 0.601734, 6.416347>,
				< -0.963168, 0.585332, 6.103514>,
				< -1.135641, 0.659294, 6.154973>
			}
			triangle {
				< -1.326270, 0.660188, 6.307715>,
				< -1.315111, 0.601734, 6.416347>,
				< -1.135641, 0.659294, 6.154973>
			}
			triangle {
				< -1.530890, 0.603341, 6.446677>,
				< -1.315111, 0.601734, 6.416347>,
				< -1.326270, 0.660188, 6.307715>
			}
			triangle {
				< -1.542051, 0.662926, 6.359742>,
				< -1.530890, 0.603341, 6.446677>,
				< -1.326270, 0.660188, 6.307715>
			}
			triangle {
				< -1.947566, 0.600159, 6.385991>,
				< -1.530890, 0.603341, 6.446677>,
				< -1.542051, 0.662926, 6.359742>
			}
			triangle {
				< -1.829647, 0.661827, 6.338877>,
				< -1.947566, 0.600159, 6.385991>,
				< -1.542051, 0.662926, 6.359742>
			}
			triangle {
				< -1.872743, 0.586794, 6.131311>,
				< -1.947566, 0.600159, 6.385991>,
				< -1.829647, 0.661827, 6.338877>
			}
			triangle {
				< -1.743634, 0.653998, 6.053960>,
				< -1.872743, 0.586794, 6.131311>,
				< -1.829647, 0.661827, 6.338877>
			}
			triangle {
				< -1.657680, 0.549469, 5.419984>,
				< -1.872743, 0.586794, 6.131311>,
				< -1.743634, 0.653998, 6.053960>
			}
			triangle {
				< -1.528568, 0.624589, 5.342215>,
				< -1.657680, 0.549469, 5.419984>,
				< -1.743634, 0.653998, 6.053960>
			}
			triangle {
				< -1.442646, 0.512143, 4.708657>,
				< -1.657680, 0.549469, 5.419984>,
				< -1.528568, 0.624589, 5.342215>
			}
			triangle {
				< -1.313506, 0.596016, 4.630412>,
				< -1.442646, 0.512143, 4.708657>,
				< -1.528568, 0.624589, 5.342215>
			}
			triangle {
				< -1.227583, 0.474819, 3.997302>,
				< -1.442646, 0.512143, 4.708657>,
				< -1.313506, 0.596016, 4.630412>
			}
			triangle {
				< -1.098471, 0.568452, 3.918577>,
				< -1.227583, 0.474819, 3.997302>,
				< -1.313506, 0.596016, 4.630412>
			}
			triangle {
				< -1.055524, 0.444965, 3.428239>,
				< -1.227583, 0.474819, 3.997302>,
				< -1.098471, 0.568452, 3.918577>
			}
			triangle {
				< -0.926415, 0.549431, 3.348950>,
				< -1.055524, 0.444965, 3.428239>,
				< -1.098471, 0.568452, 3.918577>
			}
			triangle {
				< -0.883498, 0.415112, 2.859176>,
				< -1.055524, 0.444965, 3.428239>,
				< -0.926415, 0.549431, 3.348950>
			}
			triangle {
				< -0.754358, 0.531601, 2.779264>,
				< -0.883498, 0.415112, 2.859176>,
				< -0.926415, 0.549431, 3.348950>
			}
			triangle {
				< -0.668434, 0.377785, 2.147849>,
				< -0.883498, 0.415112, 2.859176>,
				< -0.754358, 0.531601, 2.779264>
			}
			triangle {
				< -0.539324, 0.507670, 2.067222>,
				< -0.668434, 0.377785, 2.147849>,
				< -0.754358, 0.531601, 2.779264>
			}
			triangle {
				< -0.666678, 0.347634, 1.573491>,
				< -0.668434, 0.377785, 2.147849>,
				< -0.539324, 0.507670, 2.067222>
			}
			triangle {
				< -0.537568, 0.492369, 1.492058>,
				< -0.666678, 0.347634, 1.573491>,
				< -0.539324, 0.507670, 2.067222>
			}
			triangle {
				< -0.660341, 0.305786, 0.781597>,
				< -0.666678, 0.347634, 1.573491>,
				< -0.537568, 0.492369, 1.492058>
			}
			triangle {
				< -0.533850, 0.454836, 0.782487>,
				< -0.660341, 0.305786, 0.781597>,
				< -0.537568, 0.492369, 1.492058>
			}
			triangle {
				< -0.057648, 0.306527, 0.790256>,
				< -0.660341, 0.305786, 0.781597>,
				< -0.533850, 0.454836, 0.782487>
			}
			triangle {
				< -0.057647, 0.455133, 0.782458>,
				< -0.057648, 0.306527, 0.790256>,
				< -0.533850, 0.454836, 0.782487>
			}
			triangle {
				< 0.567367, 0.306525, 0.790255>,
				< -0.057648, 0.306527, 0.790256>,
				< -0.057647, 0.455133, 0.782458>
			}
			triangle {
				< 0.567368, 0.455130, 0.782457>,
				< 0.567367, 0.306525, 0.790255>,
				< -0.057647, 0.455133, 0.782458>
			}
			triangle {
				< 1.065862, 0.306523, 0.790254>,
				< 0.567367, 0.306525, 0.790255>,
				< 0.567368, 0.455130, 0.782457>
			}
			triangle {
				< 1.065862, 0.455128, 0.782457>,
				< 1.065862, 0.306523, 0.790254>,
				< 0.567368, 0.455130, 0.782457>
			}
			triangle {
				< 1.928978, 0.306073, 0.781593>,
				< 1.065862, 0.306523, 0.790254>,
				< 1.065862, 0.455128, 0.782457>
			}
			triangle {
				< 1.747486, 0.455067, 0.781175>,
				< 1.928978, 0.306073, 0.781593>,
				< 1.065862, 0.455128, 0.782457>
			}
			triangle {
				< 1.325572, 0.199081, 1.582565>,
				< 1.747485, 0.157500, 0.719180>,
				< 1.928978, 0.306073, 0.781593>
			}
			triangle {
				< 1.498046, 0.344799, 1.519586>,
				< 1.325572, 0.199081, 1.582565>,
				< 1.928978, 0.306073, 0.781593>
			}
			triangle {
				< 0.974017, 0.248312, 2.236658>,
				< 1.325572, 0.199081, 1.582565>,
				< 1.498046, 0.344799, 1.519586>
			}
			triangle {
				< 1.146432, 0.379147, 2.174425>,
				< 0.974017, 0.248312, 2.236658>,
				< 1.498046, 0.344799, 1.519586>
			}
			triangle {
				< 0.552073, 0.302931, 3.021768>,
				< 0.974017, 0.248312, 2.236658>,
				< 1.146432, 0.379147, 2.174425>
			}
			triangle {
				< 0.724549, 0.420403, 2.960249>,
				< 0.552073, 0.302931, 3.021768>,
				< 1.146432, 0.379147, 2.174425>
			}
			triangle {
				< 0.270787, 0.342458, 3.544996>,
				< 0.552073, 0.302931, 3.021768>,
				< 0.724549, 0.420403, 2.960249>
			}
			triangle {
				< 0.443261, 0.447875, 3.484131>,
				< 0.270787, 0.342458, 3.544996>,
				< 0.724549, 0.420403, 2.960249>
			}
			triangle {
				< -0.080798, 0.387640, 4.199298>,
				< 0.270787, 0.342458, 3.544996>,
				< 0.443261, 0.447875, 3.484131>
			}
			triangle {
				< 0.091678, 0.482256, 4.138969>,
				< -0.080798, 0.387640, 4.199298>,
				< 0.443261, 0.447875, 3.484131>
			}
			triangle {
				< -0.432412, 0.431750, 4.853631>,
				< -0.080798, 0.387640, 4.199298>,
				< 0.091678, 0.482256, 4.138969>
			}
			triangle {
				< -0.259938, 0.516604, 4.793836>,
				< -0.432412, 0.431750, 4.853631>,
				< 0.091678, 0.482256, 4.138969>
			}
			triangle {
				< -0.784028, 0.474880, 5.508023>,
				< -0.432412, 0.431750, 4.853631>,
				< -0.259938, 0.516604, 4.793836>
			}
			triangle {
				< -0.611552, 0.550954, 5.448675>,
				< -0.784028, 0.474880, 5.508023>,
				< -0.259938, 0.516604, 4.793836>
			}
			triangle {
				< -1.135642, 0.517147, 6.162444>,
				< -0.784028, 0.474880, 5.508023>,
				< -0.611552, 0.550954, 5.448675>
			}
			triangle {
				< -0.963168, 0.585332, 6.103514>,
				< -1.135642, 0.517147, 6.162444>,
				< -0.611552, 0.550954, 5.448675>
			}
			triangle {
				< -1.326271, 0.532238, 6.314412>,
				< -1.135642, 0.517147, 6.162444>,
				< -0.963168, 0.585332, 6.103514>
			}
			triangle {
				< -1.315111, 0.601734, 6.416347>,
				< -1.326271, 0.532238, 6.314412>,
				< -0.963168, 0.585332, 6.103514>
			}
			triangle {
				< -1.542051, 0.534976, 6.366435>,
				< -1.326271, 0.532238, 6.314412>,
				< -1.315111, 0.601734, 6.416347>
			}
			triangle {
				< -1.530890, 0.603341, 6.446677>,
				< -1.542051, 0.534976, 6.366435>,
				< -1.315111, 0.601734, 6.416347>
			}
			triangle {
				< -1.829647, 0.533877, 6.345573>,
				< -1.542051, 0.534976, 6.366435>,
				< -1.530890, 0.603341, 6.446677>
			}
			triangle {
				< -1.947566, 0.600159, 6.385991>,
				< -1.829647, 0.533877, 6.345573>,
				< -1.530890, 0.603341, 6.446677>
			}
			triangle {
				< -1.743634, 0.511851, 6.061430>,
				< -1.829647, 0.533877, 6.345573>,
				< -1.947566, 0.600159, 6.385991>
			}
			triangle {
				< -1.872743, 0.586794, 6.131311>,
				< -1.743634, 0.511851, 6.061430>,
				< -1.947566, 0.600159, 6.385991>
			}
			triangle {
				< -1.528569, 0.466609, 5.350491>,
				< -1.743634, 0.511851, 6.061430>,
				< -1.872743, 0.586794, 6.131311>
			}
			triangle {
				< -1.657680, 0.549469, 5.419984>,
				< -1.528569, 0.466609, 5.350491>,
				< -1.872743, 0.586794, 6.131311>
			}
			triangle {
				< -1.313506, 0.420533, 4.639638>,
				< -1.528569, 0.466609, 5.350491>,
				< -1.657680, 0.549469, 5.419984>
			}
			triangle {
				< -1.442646, 0.512143, 4.708657>,
				< -1.313506, 0.420533, 4.639638>,
				< -1.657680, 0.549469, 5.419984>
			}
			triangle {
				< -1.098472, 0.373447, 3.928817>,
				< -1.313506, 0.420533, 4.639638>,
				< -1.442646, 0.512143, 4.708657>
			}
			triangle {
				< -1.227583, 0.474819, 3.997302>,
				< -1.098472, 0.373447, 3.928817>,
				< -1.442646, 0.512143, 4.708657>
			}
			triangle {
				< -0.926416, 0.332759, 3.360321>,
				< -1.098472, 0.373447, 3.928817>,
				< -1.227583, 0.474819, 3.997302>
			}
			triangle {
				< -1.055524, 0.444965, 3.428239>,
				< -0.926416, 0.332759, 3.360321>,
				< -1.227583, 0.474819, 3.997302>
			}
			triangle {
				< -0.754359, 0.290850, 2.791883>,
				< -0.926416, 0.332759, 3.360321>,
				< -1.055524, 0.444965, 3.428239>
			}
			triangle {
				< -0.883498, 0.415112, 2.859176>,
				< -0.754359, 0.290850, 2.791883>,
				< -1.055524, 0.444965, 3.428239>
			}
			triangle {
				< -0.539325, 0.240162, 2.081241>,
				< -0.754359, 0.290850, 2.791883>,
				< -0.883498, 0.415112, 2.859176>
			}
			triangle {
				< -0.668434, 0.377785, 2.147849>,
				< -0.539325, 0.240162, 2.081241>,
				< -0.883498, 0.415112, 2.859176>
			}
			triangle {
				< -0.537570, 0.195160, 1.507654>,
				< -0.539325, 0.240162, 2.081241>,
				< -0.668434, 0.377785, 2.147849>
			}
			triangle {
				< -0.666678, 0.347634, 1.573491>,
				< -0.537570, 0.195160, 1.507654>,
				< -0.668434, 0.377785, 2.147849>
			}
			triangle {
				< -0.533851, 0.157269, 0.720493>,
				< -0.537570, 0.195160, 1.507654>,
				< -0.666678, 0.347634, 1.573491>
			}
			triangle {
				< -0.660341, 0.305786, 0.781597>,
				< -0.533851, 0.157269, 0.720493>,
				< -0.666678, 0.347634, 1.573491>
			}
			triangle {
				< -0.057649, 0.157566, 0.720464>,
				< -0.533851, 0.157269, 0.720493>,
				< -0.660341, 0.305786, 0.781597>
			}
			triangle {
				< -0.057648, 0.306527, 0.790256>,
				< -0.057649, 0.157566, 0.720464>,
				< -0.660341, 0.305786, 0.781597>
			}
			triangle {
				< 0.567367, 0.157564, 0.720463>,
				< -0.057649, 0.157566, 0.720464>,
				< -0.057648, 0.306527, 0.790256>
			}
			triangle {
				< 0.567367, 0.306525, 0.790255>,
				< 0.567367, 0.157564, 0.720463>,
				< -0.057648, 0.306527, 0.790256>
			}
			triangle {
				< 1.065861, 0.157562, 0.720462>,
				< 0.567367, 0.157564, 0.720463>,
				< 0.567367, 0.306525, 0.790255>
			}
			triangle {
				< 1.065862, 0.306523, 0.790254>,
				< 1.065861, 0.157562, 0.720462>,
				< 0.567367, 0.306525, 0.790255>
			}
			triangle {
				< 1.747485, 0.157500, 0.719180>,
				< 1.065861, 0.157562, 0.720462>,
				< 1.065862, 0.306523, 0.790254>
			}
			triangle {
				< 1.928978, 0.306073, 0.781593>,
				< 1.747485, 0.157500, 0.719180>,
				< 1.065862, 0.306523, 0.790254>
			}
			triangle {
				< 1.747485, 0.157500, 0.719180>,
				< 1.325572, 0.199081, 1.582565>,
				< 1.065861, 0.157562, 0.720462>
			}
			triangle {
				< 1.325572, 0.199081, 1.582565>,
				< 0.785022, 0.196732, 1.537744>,
				< 1.065861, 0.157562, 0.720462>
			}
			triangle {
				< 0.785022, 0.196732, 1.537744>,
				< 1.325572, 0.199081, 1.582565>,
				< 0.974017, 0.248312, 2.236658>
			}
			triangle {
				< 0.974017, 0.248312, 2.236658>,
				< 0.564037, 0.248194, 2.234696>,
				< 0.785022, 0.196732, 1.537744>
			}
			triangle {
				< -0.539325, 0.240162, 2.081241>,
				< -0.206071, 0.245994, 2.192344>,
				< -0.754359, 0.290850, 2.791883>
			}
			triangle {
				< -0.206071, 0.245994, 2.192344>,
				< -0.453844, 0.294333, 2.858134>,
				< -0.754359, 0.290850, 2.791883>
			}
			triangle {
				< 0.552073, 0.302931, 3.021768>,
				< 0.202421, 0.298437, 2.936171>,
				< 0.564037, 0.248194, 2.234696>
			}
			triangle {
				< 0.552073, 0.302931, 3.021768>,
				< 0.564037, 0.248194, 2.234696>,
				< 0.974017, 0.248312, 2.236658>
			}
			triangle {
				< 0.202421, 0.298437, 2.936171>,
				< 0.552073, 0.302931, 3.021768>,
				< 0.270787, 0.342458, 3.544996>
			}
			triangle {
				< 0.270787, 0.342458, 3.544996>,
				< -0.126811, 0.342222, 3.540978>,
				< 0.202421, 0.298437, 2.936171>
			}
			triangle {
				< 0.270787, 0.342458, 3.544996>,
				< -0.080798, 0.387640, 4.199298>,
				< -0.126811, 0.342222, 3.540978>
			}
			triangle {
				< -0.080798, 0.387640, 4.199298>,
				< -0.349525, 0.383860, 4.127451>,
				< -0.126811, 0.342222, 3.540978>
			}
			triangle {
				< -0.349525, 0.383860, 4.127451>,
				< -0.080798, 0.387640, 4.199298>,
				< -0.432412, 0.431750, 4.853631>
			}
			triangle {
				< -0.612299, 0.429788, 4.816129>,
				< -0.349525, 0.383860, 4.127451>,
				< -0.432412, 0.431750, 4.853631>
			}
			triangle {
				< -0.784028, 0.474880, 5.508023>,
				< -0.969123, 0.475833, 5.526356>,
				< -0.612299, 0.429788, 4.816129>
			}
			triangle {
				< -0.784028, 0.474880, 5.508023>,
				< -0.612299, 0.429788, 4.816129>,
				< -0.432412, 0.431750, 4.853631>
			}
			triangle {
				< -0.969123, 0.475833, 5.526356>,
				< -0.784028, 0.474880, 5.508023>,
				< -1.135642, 0.517147, 6.162444>
			}
			triangle {
				< -1.135642, 0.517147, 6.162444>,
				< -1.311390, 0.517416, 6.167414>,
				< -0.969123, 0.475833, 5.526356>
			}
			triangle {
				< -1.743634, 0.511851, 6.061430>,
				< -1.623899, 0.513309, 6.089407>,
				< -1.829647, 0.533877, 6.345573>
			}
			triangle {
				< -1.829647, 0.533877, 6.345573>,
				< -1.623899, 0.513309, 6.089407>,
				< -1.467644, 0.516047, 6.141431>
			}
			triangle {
				< -1.467644, 0.516047, 6.141431>,
				< -1.542051, 0.534976, 6.366435>,
				< -1.829647, 0.533877, 6.345573>
			}
			triangle {
				< -1.542051, 0.534976, 6.366435>,
				< -1.467644, 0.516047, 6.141431>,
				< -1.326271, 0.532238, 6.314412>
			}
			triangle {
				< -1.467644, 0.516047, 6.141431>,
				< -1.311390, 0.517416, 6.167414>,
				< -1.326271, 0.532238, 6.314412>
			}
			triangle {
				< -1.326271, 0.532238, 6.314412>,
				< -1.311390, 0.517416, 6.167414>,
				< -1.135642, 0.517147, 6.162444>
			}
			triangle {
				< 1.065861, 0.157562, 0.720462>,
				< 0.410013, 0.195097, 1.506553>,
				< 0.567367, 0.157564, 0.720463>
			}
			triangle {
				< 1.065861, 0.157562, 0.720462>,
				< 0.785022, 0.196732, 1.537744>,
				< 0.410013, 0.195097, 1.506553>
			}
			triangle {
				< 0.567367, 0.157564, 0.720463>,
				< 0.410013, 0.195097, 1.506553>,
				< -0.057649, 0.157566, 0.720464>
			}
			triangle {
				< 0.410013, 0.195097, 1.506553>,
				< -0.112321, 0.195099, 1.506554>,
				< -0.057649, 0.157566, 0.720464>
			}
			triangle {
				< 0.168936, 0.246797, 2.207939>,
				< -0.112321, 0.195099, 1.506554>,
				< 0.410013, 0.195097, 1.506553>
			}
			triangle {
				< 0.785022, 0.196732, 1.537744>,
				< 0.168936, 0.246797, 2.207939>,
				< 0.410013, 0.195097, 1.506553>
			}
			triangle {
				< 0.785022, 0.196732, 1.537744>,
				< 0.564037, 0.248194, 2.234696>,
				< 0.168936, 0.246797, 2.207939>
			}
			triangle {
				< 0.168936, 0.246797, 2.207939>,
				< -0.206071, 0.245994, 2.192344>,
				< -0.112321, 0.195099, 1.506554>
			}
			triangle {
				< 0.168936, 0.246797, 2.207939>,
				< -0.132408, 0.295969, 2.889356>,
				< -0.206071, 0.245994, 2.192344>
			}
			triangle {
				< -0.132408, 0.295969, 2.889356>,
				< -0.453844, 0.294333, 2.858134>,
				< -0.206071, 0.245994, 2.192344>
			}
			triangle {
				< 0.564037, 0.248194, 2.234696>,
				< -0.132408, 0.295969, 2.889356>,
				< 0.168936, 0.246797, 2.207939>
			}
			triangle {
				< 0.564037, 0.248194, 2.234696>,
				< 0.202421, 0.298437, 2.936171>,
				< -0.132408, 0.295969, 2.889356>
			}
			triangle {
				< -0.414796, 0.340020, 3.498627>,
				< -0.132408, 0.295969, 2.889356>,
				< 0.202421, 0.298437, 2.936171>
			}
			triangle {
				< -0.132408, 0.295969, 2.889356>,
				< -0.414796, 0.340020, 3.498627>,
				< -0.453844, 0.294333, 2.858134>
			}
			triangle {
				< -0.414796, 0.340020, 3.498627>,
				< -0.729506, 0.338145, 3.462971>,
				< -0.453844, 0.294333, 2.858134>
			}
			triangle {
				< -0.126811, 0.342222, 3.540978>,
				< -0.414796, 0.340020, 3.498627>,
				< 0.202421, 0.298437, 2.936171>
			}
			triangle {
				< -0.644978, 0.381630, 4.084951>,
				< -0.729506, 0.338145, 3.462971>,
				< -0.414796, 0.340020, 3.498627>
			}
			triangle {
				< -0.644978, 0.381630, 4.084951>,
				< -0.875520, 0.377584, 4.007658>,
				< -0.729506, 0.338145, 3.462971>
			}
			triangle {
				< -0.644978, 0.381630, 4.084951>,
				< -0.414796, 0.340020, 3.498627>,
				< -0.126811, 0.342222, 3.540978>
			}
			triangle {
				< -0.349525, 0.383860, 4.127451>,
				< -0.644978, 0.381630, 4.084951>,
				< -0.126811, 0.342222, 3.540978>
			}
			triangle {
				< -0.882513, 0.426337, 4.750175>,
				< -0.644978, 0.381630, 4.084951>,
				< -0.349525, 0.383860, 4.127451>
			}
			triangle {
				< -0.644978, 0.381630, 4.084951>,
				< -0.882513, 0.426337, 4.750175>,
				< -0.875520, 0.377584, 4.007658>
			}
			triangle {
				< -0.882513, 0.426337, 4.750175>,
				< -1.102905, 0.423659, 4.699252>,
				< -0.875520, 0.377584, 4.007658>
			}
			triangle {
				< -0.349525, 0.383860, 4.127451>,
				< -0.612299, 0.429788, 4.816129>,
				< -0.882513, 0.426337, 4.750175>
			}
			triangle {
				< -1.147728, 0.473245, 5.476980>,
				< -1.102905, 0.423659, 4.699252>,
				< -0.882513, 0.426337, 4.750175>
			}
			triangle {
				< -1.147728, 0.473245, 5.476980>,
				< -0.882513, 0.426337, 4.750175>,
				< -0.612299, 0.429788, 4.816129>
			}
			triangle {
				< -0.969123, 0.475833, 5.526356>,
				< -1.147728, 0.473245, 5.476980>,
				< -0.612299, 0.429788, 4.816129>
			}
			triangle {
				< -1.147728, 0.473245, 5.476980>,
				< -1.386126, 0.468870, 5.393467>,
				< -1.102905, 0.423659, 4.699252>
			}
			triangle {
				< -1.147728, 0.473245, 5.476980>,
				< -1.467644, 0.516047, 6.141431>,
				< -1.386126, 0.468870, 5.393467>
			}
			triangle {
				< -1.467644, 0.516047, 6.141431>,
				< -1.623899, 0.513309, 6.089407>,
				< -1.386126, 0.468870, 5.393467>
			}
			triangle {
				< -0.969123, 0.475833, 5.526356>,
				< -1.467644, 0.516047, 6.141431>,
				< -1.147728, 0.473245, 5.476980>
			}
			triangle {
				< -0.969123, 0.475833, 5.526356>,
				< -1.311390, 0.517416, 6.167414>,
				< -1.467644, 0.516047, 6.141431>
			}
			triangle {
				< -0.057649, 0.157566, 0.720464>,
				< -0.537570, 0.195160, 1.507654>,
				< -0.533851, 0.157269, 0.720493>
			}
			triangle {
				< -0.057649, 0.157566, 0.720464>,
				< -0.112321, 0.195099, 1.506554>,
				< -0.537570, 0.195160, 1.507654>
			}
			triangle {
				< -0.537570, 0.195160, 1.507654>,
				< -0.112321, 0.195099, 1.506554>,
				< -0.539325, 0.240162, 2.081241>
			}
			triangle {
				< -0.112321, 0.195099, 1.506554>,
				< -0.206071, 0.245994, 2.192344>,
				< -0.539325, 0.240162, 2.081241>
			}
			triangle {
				< -0.754359, 0.290850, 2.791883>,
				< -0.453844, 0.294333, 2.858134>,
				< -0.926416, 0.332759, 3.360321>
			}
			triangle {
				< -0.453844, 0.294333, 2.858134>,
				< -0.729506, 0.338145, 3.462971>,
				< -0.926416, 0.332759, 3.360321>
			}
			triangle {
				< -0.729506, 0.338145, 3.462971>,
				< -0.875520, 0.377584, 4.007658>,
				< -1.098472, 0.373447, 3.928817>
			}
			triangle {
				< -0.729506, 0.338145, 3.462971>,
				< -1.098472, 0.373447, 3.928817>,
				< -0.926416, 0.332759, 3.360321>
			}
			triangle {
				< -0.875520, 0.377584, 4.007658>,
				< -1.102905, 0.423659, 4.699252>,
				< -1.313506, 0.420533, 4.639638>
			}
			triangle {
				< -1.313506, 0.420533, 4.639638>,
				< -1.098472, 0.373447, 3.928817>,
				< -0.875520, 0.377584, 4.007658>
			}
			triangle {
				< -1.313506, 0.420533, 4.639638>,
				< -1.102905, 0.423659, 4.699252>,
				< -1.528569, 0.466609, 5.350491>
			}
			triangle {
				< -1.102905, 0.423659, 4.699252>,
				< -1.386126, 0.468870, 5.393467>,
				< -1.528569, 0.466609, 5.350491>
			}
			triangle {
				< -1.386126, 0.468870, 5.393467>,
				< -1.623899, 0.513309, 6.089407>,
				< -1.743634, 0.511851, 6.061430>
			}
			triangle {
				< -1.743634, 0.511851, 6.061430>,
				< -1.528569, 0.466609, 5.350491>,
				< -1.386126, 0.468870, 5.393467>
			}
			texture{_ICP9_Red}
		}
		// _ICP10_Yellow
		union {
			triangle {
				< -0.967648, 0.472234, -4.707854>,
				< -1.324797, 0.472236, -4.529277>,
				< -1.801001, 0.323425, -4.707853>
			}
			triangle {
				< -1.801001, 0.323425, -4.707853>,
				< -1.324798, 0.472235, -4.886429>,
				< -0.967648, 0.472234, -4.707854>
			}
			triangle {
				< -1.801001, 0.323425, -4.707853>,
				< -1.324797, 0.472236, -4.529277>,
				< -1.324798, 0.472235, -4.886429>
			}
			triangle {
				< -0.967648, 0.472234, -4.707854>,
				< -1.324798, 0.472235, -4.886429>,
				< -1.324797, 0.472236, -4.529277>
			}
			triangle {
				< -0.543498, 0.376759, -3.388357>,
				< -0.900678, 0.376761, -3.209782>,
				< -1.376881, 0.227950, -3.388356>
			}
			triangle {
				< -1.376881, 0.227950, -3.388356>,
				< -0.900679, 0.376760, -3.566933>,
				< -0.543498, 0.376759, -3.388357>
			}
			triangle {
				< -1.376881, 0.227950, -3.388356>,
				< -0.900678, 0.376761, -3.209782>,
				< -0.900679, 0.376760, -3.566933>
			}
			triangle {
				< -0.543498, 0.376759, -3.388357>,
				< -0.900679, 0.376760, -3.566933>,
				< -0.900678, 0.376761, -3.209782>
			}
			triangle {
				< -0.283074, 0.324675, -2.563695>,
				< -0.640225, 0.324677, -2.385118>,
				< -1.116459, 0.175866, -2.563694>
			}
			triangle {
				< -1.116459, 0.175866, -2.563694>,
				< -0.640226, 0.324676, -2.742270>,
				< -0.283074, 0.324675, -2.563695>
			}
			triangle {
				< -1.116459, 0.175866, -2.563694>,
				< -0.640225, 0.324677, -2.385118>,
				< -0.640226, 0.324676, -2.742270>
			}
			triangle {
				< -0.283074, 0.324675, -2.563695>,
				< -0.640226, 0.324676, -2.742270>,
				< -0.640225, 0.324677, -2.385118>
			}
			triangle {
				< -0.357474, 0.324838, 2.870426>,
				< -0.714625, 0.324840, 3.049004>,
				< -1.190857, 0.176029, 2.870428>
			}
			triangle {
				< -1.190857, 0.176029, 2.870428>,
				< -0.714626, 0.324811, 2.691852>,
				< -0.357474, 0.324838, 2.870426>
			}
			triangle {
				< -1.190857, 0.176029, 2.870428>,
				< -0.714625, 0.324840, 3.049004>,
				< -0.714626, 0.324811, 2.691852>
			}
			triangle {
				< -0.357474, 0.324838, 2.870426>,
				< -0.714626, 0.324811, 2.691852>,
				< -0.714625, 0.324840, 3.049004>
			}
			triangle {
				< -0.640217, 0.388534, 3.669048>,
				< -0.997399, 0.388567, 3.847623>,
				< -1.473602, 0.239725, 3.669049>
			}
			triangle {
				< -1.473602, 0.239725, 3.669049>,
				< -0.997400, 0.388535, 3.490472>,
				< -0.640217, 0.388534, 3.669048>
			}
			triangle {
				< -1.473602, 0.239725, 3.669049>,
				< -0.997399, 0.388567, 3.847623>,
				< -0.997400, 0.388535, 3.490472>
			}
			triangle {
				< -0.640217, 0.388534, 3.669048>,
				< -0.997400, 0.388535, 3.490472>,
				< -0.997399, 0.388567, 3.847623>
			}
			triangle {
				< -1.012278, 0.469643, 5.005897>,
				< -1.369430, 0.469645, 5.184474>,
				< -1.845633, 0.320832, 5.005898>
			}
			triangle {
				< -1.845633, 0.320832, 5.005898>,
				< -1.369430, 0.469644, 4.827322>,
				< -1.012278, 0.469643, 5.005897>
			}
			triangle {
				< -1.845633, 0.320832, 5.005898>,
				< -1.369430, 0.469645, 5.184474>,
				< -1.369430, 0.469644, 4.827322>
			}
			triangle {
				< -1.012278, 0.469643, 5.005897>,
				< -1.369430, 0.469644, 4.827322>,
				< -1.369430, 0.469645, 5.184474>
			}
			texture{_ICP10_Yellow}
		}
		// _ICP23_Blue
		union {
			triangle {
				< 0.408072, 0.029338, -2.537444>,
				< 0.617215, 0.060380, -2.385476>,
				< 0.617215, 0.108386, -2.533278>
			}
			triangle {
				< 0.408072, 0.029338, -2.537444>,
				< 0.408072, -0.006020, -2.428602>,
				< 0.617215, 0.060380, -2.385476>
			}
			triangle {
				< 0.408072, -0.006020, -2.428602>,
				< 0.617215, -0.055098, -2.281515>,
				< 0.617215, 0.060380, -2.385476>
			}
			triangle {
				< 0.408072, -0.006020, -2.428602>,
				< 0.408072, -0.091053, -2.352052>,
				< 0.617215, -0.055098, -2.281515>
			}
			triangle {
				< 0.408072, -0.091053, -2.352052>,
				< 0.617214, -0.207127, -2.249193>,
				< 0.617215, -0.055098, -2.281515>
			}
			triangle {
				< 0.408072, -0.091053, -2.352052>,
				< 0.408071, -0.202958, -2.328272>,
				< 0.617214, -0.207127, -2.249193>
			}
			triangle {
				< 0.408071, -0.202958, -2.328272>,
				< 0.617214, -0.354899, -2.297230>,
				< 0.617214, -0.207127, -2.249193>
			}
			triangle {
				< 0.408071, -0.202958, -2.328272>,
				< 0.408071, -0.311771, -2.363629>,
				< 0.617214, -0.354899, -2.297230>
			}
			triangle {
				< 0.408071, -0.311771, -2.363629>,
				< 0.617213, -0.458890, -2.412709>,
				< 0.617214, -0.354899, -2.297230>
			}
			triangle {
				< 0.408071, -0.311771, -2.363629>,
				< 0.408070, -0.388352, -2.448662>,
				< 0.617213, -0.458890, -2.412709>
			}
			triangle {
				< 0.408070, -0.388352, -2.448662>,
				< 0.617213, -0.491212, -2.564705>,
				< 0.617213, -0.458890, -2.412709>
			}
			triangle {
				< 0.408070, -0.388352, -2.448662>,
				< 0.408070, -0.412132, -2.560570>,
				< 0.617213, -0.491212, -2.564705>
			}
			triangle {
				< 0.408070, -0.412132, -2.560570>,
				< 0.617213, -0.443175, -2.712507>,
				< 0.617213, -0.491212, -2.564705>
			}
			triangle {
				< 0.408070, -0.412132, -2.560570>,
				< 0.408070, -0.376775, -2.669380>,
				< 0.617213, -0.443175, -2.712507>
			}
			triangle {
				< 0.408070, -0.376775, -2.669380>,
				< 0.617213, -0.327696, -2.816498>,
				< 0.617213, -0.443175, -2.712507>
			}
			triangle {
				< 0.408070, -0.376775, -2.669380>,
				< 0.408070, -0.291742, -2.745930>,
				< 0.617213, -0.327696, -2.816498>
			}
			triangle {
				< 0.408070, -0.291742, -2.745930>,
				< 0.617214, -0.175700, -2.848791>,
				< 0.617213, -0.327696, -2.816498>
			}
			triangle {
				< 0.408070, -0.291742, -2.745930>,
				< 0.408071, -0.179835, -2.769711>,
				< 0.617214, -0.175700, -2.848791>
			}
			triangle {
				< 0.408071, -0.179835, -2.769711>,
				< 0.617214, -0.027898, -2.800784>,
				< 0.617214, -0.175700, -2.848791>
			}
			triangle {
				< 0.408071, -0.179835, -2.769711>,
				< 0.408071, -0.071023, -2.734353>,
				< 0.617214, -0.027898, -2.800784>
			}
			triangle {
				< 0.408071, -0.071023, -2.734353>,
				< 0.617215, 0.076093, -2.685305>,
				< 0.617214, -0.027898, -2.800784>
			}
			triangle {
				< 0.408071, -0.071023, -2.734353>,
				< 0.408072, 0.005528, -2.649352>,
				< 0.617215, 0.076093, -2.685305>
			}
			triangle {
				< 0.617215, 0.108386, -2.533278>,
				< 0.617215, 0.076093, -2.685305>,
				< 0.408072, 0.005528, -2.649352>
			}
			triangle {
				< 0.617215, 0.108386, -2.533278>,
				< 0.408072, 0.005528, -2.649352>,
				< 0.408072, 0.029338, -2.537444>
			}
			triangle {
				< 0.260063, -0.040038, -2.541076>,
				< 0.408072, -0.006020, -2.428602>,
				< 0.408072, 0.029338, -2.537444>
			}
			triangle {
				< 0.260063, -0.040038, -2.541076>,
				< 0.260063, -0.064295, -2.466459>,
				< 0.408072, -0.006020, -2.428602>
			}
			triangle {
				< 0.260063, -0.064295, -2.466459>,
				< 0.408072, -0.091053, -2.352052>,
				< 0.408072, -0.006020, -2.428602>
			}
			triangle {
				< 0.260063, -0.064295, -2.466459>,
				< 0.260063, -0.122599, -2.413958>,
				< 0.408072, -0.091053, -2.352052>
			}
			triangle {
				< 0.260063, -0.122599, -2.413958>,
				< 0.408071, -0.202958, -2.328272>,
				< 0.408072, -0.091053, -2.352052>
			}
			triangle {
				< 0.260063, -0.122599, -2.413958>,
				< 0.260062, -0.199327, -2.397647>,
				< 0.408071, -0.202958, -2.328272>
			}
			triangle {
				< 0.260062, -0.199327, -2.397647>,
				< 0.408071, -0.311771, -2.363629>,
				< 0.408071, -0.202958, -2.328272>
			}
			triangle {
				< 0.260062, -0.199327, -2.397647>,
				< 0.260062, -0.273942, -2.421874>,
				< 0.408071, -0.311771, -2.363629>
			}
			triangle {
				< 0.260062, -0.273942, -2.421874>,
				< 0.408070, -0.388352, -2.448662>,
				< 0.408071, -0.311771, -2.363629>
			}
			triangle {
				< 0.260062, -0.273942, -2.421874>,
				< 0.260062, -0.326445, -2.480180>,
				< 0.408070, -0.388352, -2.448662>
			}
			triangle {
				< 0.260062, -0.326445, -2.480180>,
				< 0.408070, -0.412132, -2.560570>,
				< 0.408070, -0.388352, -2.448662>
			}
			triangle {
				< 0.260062, -0.326445, -2.480180>,
				< 0.260062, -0.342754, -2.556937>,
				< 0.408070, -0.412132, -2.560570>
			}
			triangle {
				< 0.260062, -0.342754, -2.556937>,
				< 0.408070, -0.376775, -2.669380>,
				< 0.408070, -0.412132, -2.560570>
			}
			triangle {
				< 0.260062, -0.342754, -2.556937>,
				< 0.260062, -0.318527, -2.631554>,
				< 0.408070, -0.376775, -2.669380>
			}
			triangle {
				< 0.260062, -0.318527, -2.631554>,
				< 0.408070, -0.291742, -2.745930>,
				< 0.408070, -0.376775, -2.669380>
			}
			triangle {
				< 0.260062, -0.318527, -2.631554>,
				< 0.260062, -0.260223, -2.684024>,
				< 0.408070, -0.291742, -2.745930>
			}
			triangle {
				< 0.260062, -0.260223, -2.684024>,
				< 0.408071, -0.179835, -2.769711>,
				< 0.408070, -0.291742, -2.745930>
			}
			triangle {
				< 0.260062, -0.260223, -2.684024>,
				< 0.260062, -0.183464, -2.700363>,
				< 0.408071, -0.179835, -2.769711>
			}
			triangle {
				< 0.260062, -0.183464, -2.700363>,
				< 0.408071, -0.071023, -2.734353>,
				< 0.408071, -0.179835, -2.769711>
			}
			triangle {
				< 0.260062, -0.183464, -2.700363>,
				< 0.260062, -0.108850, -2.676108>,
				< 0.408071, -0.071023, -2.734353>
			}
			triangle {
				< 0.260062, -0.108850, -2.676108>,
				< 0.408072, 0.005528, -2.649352>,
				< 0.408071, -0.071023, -2.734353>
			}
			triangle {
				< 0.260062, -0.108850, -2.676108>,
				< 0.260063, -0.056349, -2.617804>,
				< 0.408072, 0.005528, -2.649352>
			}
			triangle {
				< 0.408072, 0.029338, -2.537444>,
				< 0.408072, 0.005528, -2.649352>,
				< 0.260063, -0.056349, -2.617804>
			}
			triangle {
				< 0.408072, 0.029338, -2.537444>,
				< 0.260063, -0.056349, -2.617804>,
				< 0.260063, -0.040038, -2.541076>
			}
			triangle {
				< 0.408072, 0.008296, -2.538546>,
				< 0.260063, -0.064295, -2.466459>,
				< 0.260063, -0.040038, -2.541076>
			}
			triangle {
				< 0.408072, 0.008296, -2.538546>,
				< 0.408072, -0.023699, -2.440091>,
				< 0.260063, -0.064295, -2.466459>
			}
			triangle {
				< 0.408072, -0.023699, -2.440091>,
				< 0.260063, -0.122599, -2.413958>,
				< 0.260063, -0.064295, -2.466459>
			}
			triangle {
				< 0.408072, -0.023699, -2.440091>,
				< 0.408072, -0.100606, -2.370804>,
				< 0.260063, -0.122599, -2.413958>
			}
			triangle {
				< 0.408072, -0.100606, -2.370804>,
				< 0.260062, -0.199327, -2.397647>,
				< 0.260063, -0.122599, -2.413958>
			}
			triangle {
				< 0.408072, -0.100606, -2.370804>,
				< 0.408071, -0.201858, -2.349285>,
				< 0.260062, -0.199327, -2.397647>
			}
			triangle {
				< 0.408071, -0.201858, -2.349285>,
				< 0.260062, -0.273942, -2.421874>,
				< 0.260062, -0.199327, -2.397647>
			}
			triangle {
				< 0.408071, -0.201858, -2.349285>,
				< 0.408071, -0.300314, -2.381280>,
				< 0.260062, -0.273942, -2.421874>
			}
			triangle {
				< 0.408071, -0.300314, -2.381280>,
				< 0.260062, -0.326445, -2.480180>,
				< 0.260062, -0.273942, -2.421874>
			}
			triangle {
				< 0.408071, -0.300314, -2.381280>,
				< 0.408070, -0.369570, -2.458215>,
				< 0.260062, -0.326445, -2.480180>
			}
			triangle {
				< 0.408070, -0.369570, -2.458215>,
				< 0.260062, -0.342754, -2.556937>,
				< 0.260062, -0.326445, -2.480180>
			}
			triangle {
				< 0.408070, -0.369570, -2.458215>,
				< 0.408070, -0.391119, -2.559467>,
				< 0.260062, -0.342754, -2.556937>
			}
			triangle {
				< 0.408070, -0.391119, -2.559467>,
				< 0.260062, -0.318527, -2.631554>,
				< 0.260062, -0.342754, -2.556937>
			}
			triangle {
				< 0.408070, -0.391119, -2.559467>,
				< 0.408070, -0.359124, -2.657923>,
				< 0.260062, -0.318527, -2.631554>
			}
			triangle {
				< 0.408070, -0.359124, -2.657923>,
				< 0.260062, -0.260223, -2.684024>,
				< 0.260062, -0.318527, -2.631554>
			}
			triangle {
				< 0.408070, -0.359124, -2.657923>,
				< 0.408070, -0.282189, -2.727181>,
				< 0.260062, -0.260223, -2.684024>
			}
			triangle {
				< 0.408070, -0.282189, -2.727181>,
				< 0.260062, -0.183464, -2.700363>,
				< 0.260062, -0.260223, -2.684024>
			}
			triangle {
				< 0.408070, -0.282189, -2.727181>,
				< 0.408071, -0.180935, -2.748698>,
				< 0.260062, -0.183464, -2.700363>
			}
			triangle {
				< 0.408071, -0.180935, -2.748698>,
				< 0.260062, -0.108850, -2.676108>,
				< 0.260062, -0.183464, -2.700363>
			}
			triangle {
				< 0.408071, -0.180935, -2.748698>,
				< 0.408071, -0.082481, -2.716705>,
				< 0.260062, -0.108850, -2.676108>
			}
			triangle {
				< 0.408071, -0.082481, -2.716705>,
				< 0.260063, -0.056349, -2.617804>,
				< 0.260062, -0.108850, -2.676108>
			}
			triangle {
				< 0.408071, -0.082481, -2.716705>,
				< 0.408072, -0.013223, -2.639798>,
				< 0.260063, -0.056349, -2.617804>
			}
			triangle {
				< 0.260063, -0.040038, -2.541076>,
				< 0.260063, -0.056349, -2.617804>,
				< 0.408072, -0.013223, -2.639798>
			}
			triangle {
				< 0.260063, -0.040038, -2.541076>,
				< 0.408072, -0.013223, -2.639798>,
				< 0.408072, 0.008296, -2.538546>
			}
			triangle {
				< 0.617215, 0.060618, -2.535777>,
				< 0.408072, -0.023699, -2.440091>,
				< 0.408072, 0.008296, -2.538546>
			}
			triangle {
				< 0.617215, 0.060618, -2.535777>,
				< 0.617215, 0.020231, -2.411549>,
				< 0.408072, -0.023699, -2.440091>
			}
			triangle {
				< 0.617215, 0.020231, -2.411549>,
				< 0.408072, -0.100606, -2.370804>,
				< 0.408072, -0.023699, -2.440091>
			}
			triangle {
				< 0.617215, 0.020231, -2.411549>,
				< 0.617215, -0.076826, -2.324136>,
				< 0.408072, -0.100606, -2.370804>
			}
			triangle {
				< 0.617215, -0.076826, -2.324136>,
				< 0.408071, -0.201858, -2.349285>,
				< 0.408072, -0.100606, -2.370804>
			}
			triangle {
				< 0.617215, -0.076826, -2.324136>,
				< 0.617214, -0.204598, -2.296991>,
				< 0.408071, -0.201858, -2.349285>
			}
			triangle {
				< 0.617214, -0.204598, -2.296991>,
				< 0.408071, -0.300314, -2.381280>,
				< 0.408071, -0.201858, -2.349285>
			}
			triangle {
				< 0.617214, -0.204598, -2.296991>,
				< 0.617214, -0.328856, -2.337350>,
				< 0.408071, -0.300314, -2.381280>
			}
			triangle {
				< 0.617214, -0.328856, -2.337350>,
				< 0.408070, -0.369570, -2.458215>,
				< 0.408071, -0.300314, -2.381280>
			}
			triangle {
				< 0.617214, -0.328856, -2.337350>,
				< 0.617213, -0.416269, -2.434435>,
				< 0.408070, -0.369570, -2.458215>
			}
			triangle {
				< 0.617213, -0.416269, -2.434435>,
				< 0.408070, -0.391119, -2.559467>,
				< 0.408070, -0.369570, -2.458215>
			}
			triangle {
				< 0.617213, -0.416269, -2.434435>,
				< 0.617213, -0.443412, -2.562206>,
				< 0.408070, -0.391119, -2.559467>
			}
			triangle {
				< 0.617213, -0.443412, -2.562206>,
				< 0.408070, -0.359124, -2.657923>,
				< 0.408070, -0.391119, -2.559467>
			}
			triangle {
				< 0.617213, -0.443412, -2.562206>,
				< 0.617213, -0.403056, -2.686434>,
				< 0.408070, -0.359124, -2.657923>
			}
			triangle {
				< 0.617213, -0.403056, -2.686434>,
				< 0.408070, -0.282189, -2.727181>,
				< 0.408070, -0.359124, -2.657923>
			}
			triangle {
				< 0.617213, -0.403056, -2.686434>,
				< 0.617213, -0.305970, -2.773849>,
				< 0.408070, -0.282189, -2.727181>
			}
			triangle {
				< 0.617213, -0.305970, -2.773849>,
				< 0.408071, -0.180935, -2.748698>,
				< 0.408070, -0.282189, -2.727181>
			}
			triangle {
				< 0.617213, -0.305970, -2.773849>,
				< 0.617214, -0.178199, -2.801023>,
				< 0.408071, -0.180935, -2.748698>
			}
			triangle {
				< 0.617214, -0.178199, -2.801023>,
				< 0.408071, -0.082481, -2.716705>,
				< 0.408071, -0.180935, -2.748698>
			}
			triangle {
				< 0.617214, -0.178199, -2.801023>,
				< 0.617214, -0.053969, -2.760633>,
				< 0.408071, -0.082481, -2.716705>
			}
			triangle {
				< 0.617214, -0.053969, -2.760633>,
				< 0.408072, -0.013223, -2.639798>,
				< 0.408071, -0.082481, -2.716705>
			}
			triangle {
				< 0.617214, -0.053969, -2.760633>,
				< 0.617215, 0.033444, -2.663579>,
				< 0.408072, -0.013223, -2.639798>
			}
			triangle {
				< 0.408072, 0.008296, -2.538546>,
				< 0.408072, -0.013223, -2.639798>,
				< 0.617215, 0.033444, -2.663579>
			}
			triangle {
				< 0.408072, 0.008296, -2.538546>,
				< 0.617215, 0.033444, -2.663579>,
				< 0.617215, 0.060618, -2.535777>
			}
			triangle {
				< 0.408079, 0.045989, 2.852718>,
				< 0.617223, 0.092776, 3.000579>,
				< 0.617223, 0.125068, 2.848550>
			}
			triangle {
				< 0.408079, 0.045989, 2.852718>,
				< 0.408079, 0.022209, 2.964624>,
				< 0.617223, 0.092776, 3.000579>
			}
			triangle {
				< 0.408079, 0.022209, 2.964624>,
				< 0.617222, -0.011214, 3.116058>,
				< 0.617223, 0.092776, 3.000579>
			}
			triangle {
				< 0.408079, 0.022209, 2.964624>,
				< 0.408079, -0.054340, 3.049657>,
				< 0.617222, -0.011214, 3.116058>
			}
			triangle {
				< 0.408079, -0.054340, 3.049657>,
				< 0.617222, -0.158986, 3.164095>,
				< 0.617222, -0.011214, 3.116058>
			}
			triangle {
				< 0.408079, -0.054340, 3.049657>,
				< 0.408079, -0.163151, 3.085015>,
				< 0.617222, -0.158986, 3.164095>
			}
			triangle {
				< 0.408079, -0.163151, 3.085015>,
				< 0.617221, -0.311015, 3.131803>,
				< 0.617222, -0.158986, 3.164095>
			}
			triangle {
				< 0.408079, -0.163151, 3.085015>,
				< 0.408078, -0.275059, 3.061235>,
				< 0.617221, -0.311015, 3.131803>
			}
			triangle {
				< 0.408078, -0.275059, 3.061235>,
				< 0.617221, -0.426494, 3.027812>,
				< 0.617221, -0.311015, 3.131803>
			}
			triangle {
				< 0.408078, -0.275059, 3.061235>,
				< 0.408078, -0.360092, 2.984686>,
				< 0.617221, -0.426494, 3.027812>
			}
			triangle {
				< 0.408078, -0.360092, 2.984686>,
				< 0.617220, -0.474530, 2.880011>,
				< 0.617221, -0.426494, 3.027812>
			}
			triangle {
				< 0.408078, -0.360092, 2.984686>,
				< 0.408077, -0.395450, 2.875875>,
				< 0.617220, -0.474530, 2.880011>
			}
			triangle {
				< 0.408077, -0.395450, 2.875875>,
				< 0.617220, -0.442239, 2.728012>,
				< 0.617220, -0.474530, 2.880011>
			}
			triangle {
				< 0.408077, -0.395450, 2.875875>,
				< 0.408077, -0.371670, 2.763965>,
				< 0.617220, -0.442239, 2.728012>
			}
			triangle {
				< 0.408077, -0.371670, 2.763965>,
				< 0.617220, -0.338248, 2.612533>,
				< 0.617220, -0.442239, 2.728012>
			}
			triangle {
				< 0.408077, -0.371670, 2.763965>,
				< 0.408078, -0.295121, 2.678934>,
				< 0.617220, -0.338248, 2.612533>
			}
			triangle {
				< 0.408078, -0.295121, 2.678934>,
				< 0.617221, -0.190447, 2.564497>,
				< 0.617220, -0.338248, 2.612533>
			}
			triangle {
				< 0.408078, -0.295121, 2.678934>,
				< 0.408078, -0.186308, 2.643576>,
				< 0.617221, -0.190447, 2.564497>
			}
			triangle {
				< 0.408078, -0.186308, 2.643576>,
				< 0.617222, -0.038448, 2.596788>,
				< 0.617221, -0.190447, 2.564497>
			}
			triangle {
				< 0.408078, -0.186308, 2.643576>,
				< 0.408078, -0.074402, 2.667356>,
				< 0.617222, -0.038448, 2.596788>
			}
			triangle {
				< 0.408078, -0.074402, 2.667356>,
				< 0.617222, 0.077031, 2.700779>,
				< 0.617222, -0.038448, 2.596788>
			}
			triangle {
				< 0.408078, -0.074402, 2.667356>,
				< 0.408079, 0.010631, 2.743906>,
				< 0.617222, 0.077031, 2.700779>
			}
			triangle {
				< 0.617223, 0.125068, 2.848550>,
				< 0.617222, 0.077031, 2.700779>,
				< 0.408079, 0.010631, 2.743906>
			}
			triangle {
				< 0.617223, 0.125068, 2.848550>,
				< 0.408079, 0.010631, 2.743906>,
				< 0.408079, 0.045989, 2.852718>
			}
			triangle {
				< 0.260070, -0.023358, 2.856349>,
				< 0.408079, 0.022209, 2.964624>,
				< 0.408079, 0.045989, 2.852718>
			}
			triangle {
				< 0.260070, -0.023358, 2.856349>,
				< 0.260070, -0.039666, 2.933078>,
				< 0.408079, 0.022209, 2.964624>
			}
			triangle {
				< 0.260070, -0.039666, 2.933078>,
				< 0.408079, -0.054340, 3.049657>,
				< 0.408079, 0.022209, 2.964624>
			}
			triangle {
				< 0.260070, -0.039666, 2.933078>,
				< 0.260070, -0.092169, 2.991412>,
				< 0.408079, -0.054340, 3.049657>
			}
			triangle {
				< 0.260070, -0.092169, 2.991412>,
				< 0.408079, -0.163151, 3.085015>,
				< 0.408079, -0.054340, 3.049657>
			}
			triangle {
				< 0.260070, -0.092169, 2.991412>,
				< 0.260070, -0.166783, 3.015640>,
				< 0.408079, -0.163151, 3.085015>
			}
			triangle {
				< 0.260070, -0.166783, 3.015640>,
				< 0.408078, -0.275059, 3.061235>,
				< 0.408079, -0.163151, 3.085015>
			}
			triangle {
				< 0.260070, -0.166783, 3.015640>,
				< 0.260069, -0.243511, 2.999329>,
				< 0.408078, -0.275059, 3.061235>
			}
			triangle {
				< 0.260069, -0.243511, 2.999329>,
				< 0.408078, -0.360092, 2.984686>,
				< 0.408078, -0.275059, 3.061235>
			}
			triangle {
				< 0.260069, -0.243511, 2.999329>,
				< 0.260069, -0.301816, 2.946857>,
				< 0.408078, -0.360092, 2.984686>
			}
			triangle {
				< 0.260069, -0.301816, 2.946857>,
				< 0.408077, -0.395450, 2.875875>,
				< 0.408078, -0.360092, 2.984686>
			}
			triangle {
				< 0.260069, -0.301816, 2.946857>,
				< 0.260069, -0.326074, 2.872242>,
				< 0.408077, -0.395450, 2.875875>
			}
			triangle {
				< 0.260069, -0.326074, 2.872242>,
				< 0.408077, -0.371670, 2.763965>,
				< 0.408077, -0.395450, 2.875875>
			}
			triangle {
				< 0.260069, -0.326074, 2.872242>,
				< 0.260069, -0.309763, 2.795486>,
				< 0.408077, -0.371670, 2.763965>
			}
			triangle {
				< 0.260069, -0.309763, 2.795486>,
				< 0.408078, -0.295121, 2.678934>,
				< 0.408077, -0.371670, 2.763965>
			}
			triangle {
				< 0.260069, -0.309763, 2.795486>,
				< 0.260069, -0.257293, 2.737180>,
				< 0.408078, -0.295121, 2.678934>
			}
			triangle {
				< 0.260069, -0.257293, 2.737180>,
				< 0.408078, -0.186308, 2.643576>,
				< 0.408078, -0.295121, 2.678934>
			}
			triangle {
				< 0.260069, -0.257293, 2.737180>,
				< 0.260069, -0.182676, 2.712924>,
				< 0.408078, -0.186308, 2.643576>
			}
			triangle {
				< 0.260069, -0.182676, 2.712924>,
				< 0.408078, -0.074402, 2.667356>,
				< 0.408078, -0.186308, 2.643576>
			}
			triangle {
				< 0.260069, -0.182676, 2.712924>,
				< 0.260070, -0.105920, 2.729232>,
				< 0.408078, -0.074402, 2.667356>
			}
			triangle {
				< 0.260070, -0.105920, 2.729232>,
				< 0.408079, 0.010631, 2.743906>,
				< 0.408078, -0.074402, 2.667356>
			}
			triangle {
				< 0.260070, -0.105920, 2.729232>,
				< 0.260070, -0.047613, 2.781733>,
				< 0.408079, 0.010631, 2.743906>
			}
			triangle {
				< 0.408079, 0.045989, 2.852718>,
				< 0.408079, 0.010631, 2.743906>,
				< 0.260070, -0.047613, 2.781733>
			}
			triangle {
				< 0.408079, 0.045989, 2.852718>,
				< 0.260070, -0.047613, 2.781733>,
				< 0.260070, -0.023358, 2.856349>
			}
			triangle {
				< 0.408079, 0.024976, 2.853819>,
				< 0.260070, -0.039666, 2.933078>,
				< 0.260070, -0.023358, 2.856349>
			}
			triangle {
				< 0.408079, 0.024976, 2.853819>,
				< 0.408079, 0.003458, 2.955071>,
				< 0.260070, -0.039666, 2.933078>
			}
			triangle {
				< 0.408079, 0.003458, 2.955071>,
				< 0.260070, -0.092169, 2.991412>,
				< 0.260070, -0.039666, 2.933078>
			}
			triangle {
				< 0.408079, 0.003458, 2.955071>,
				< 0.408079, -0.065798, 3.032009>,
				< 0.260070, -0.092169, 2.991412>
			}
			triangle {
				< 0.408079, -0.065798, 3.032009>,
				< 0.260070, -0.166783, 3.015640>,
				< 0.260070, -0.092169, 2.991412>
			}
			triangle {
				< 0.408079, -0.065798, 3.032009>,
				< 0.408079, -0.164254, 3.064002>,
				< 0.260070, -0.166783, 3.015640>
			}
			triangle {
				< 0.408079, -0.164254, 3.064002>,
				< 0.260069, -0.243511, 2.999329>,
				< 0.260070, -0.166783, 3.015640>
			}
			triangle {
				< 0.408079, -0.164254, 3.064002>,
				< 0.408078, -0.265506, 3.042484>,
				< 0.260069, -0.243511, 2.999329>
			}
			triangle {
				< 0.408078, -0.265506, 3.042484>,
				< 0.260069, -0.301816, 2.946857>,
				< 0.260069, -0.243511, 2.999329>
			}
			triangle {
				< 0.408078, -0.265506, 3.042484>,
				< 0.408078, -0.342443, 2.973228>,
				< 0.260069, -0.301816, 2.946857>
			}
			triangle {
				< 0.408078, -0.342443, 2.973228>,
				< 0.260069, -0.326074, 2.872242>,
				< 0.260069, -0.301816, 2.946857>
			}
			triangle {
				< 0.408078, -0.342443, 2.973228>,
				< 0.408077, -0.374437, 2.874772>,
				< 0.260069, -0.326074, 2.872242>
			}
			triangle {
				< 0.408077, -0.374437, 2.874772>,
				< 0.260069, -0.309763, 2.795486>,
				< 0.260069, -0.326074, 2.872242>
			}
			triangle {
				< 0.408077, -0.374437, 2.874772>,
				< 0.408077, -0.352919, 2.773521>,
				< 0.260069, -0.309763, 2.795486>
			}
			triangle {
				< 0.408077, -0.352919, 2.773521>,
				< 0.260069, -0.257293, 2.737180>,
				< 0.260069, -0.309763, 2.795486>
			}
			triangle {
				< 0.408077, -0.352919, 2.773521>,
				< 0.408078, -0.283663, 2.696583>,
				< 0.260069, -0.257293, 2.737180>
			}
			triangle {
				< 0.408078, -0.283663, 2.696583>,
				< 0.260069, -0.182676, 2.712924>,
				< 0.260069, -0.257293, 2.737180>
			}
			triangle {
				< 0.408078, -0.283663, 2.696583>,
				< 0.408078, -0.185207, 2.664589>,
				< 0.260069, -0.182676, 2.712924>
			}
			triangle {
				< 0.408078, -0.185207, 2.664589>,
				< 0.260070, -0.105920, 2.729232>,
				< 0.260069, -0.182676, 2.712924>
			}
			triangle {
				< 0.408078, -0.185207, 2.664589>,
				< 0.408078, -0.083955, 2.686108>,
				< 0.260070, -0.105920, 2.729232>
			}
			triangle {
				< 0.408078, -0.083955, 2.686108>,
				< 0.260070, -0.047613, 2.781733>,
				< 0.260070, -0.105920, 2.729232>
			}
			triangle {
				< 0.408078, -0.083955, 2.686108>,
				< 0.408079, -0.007018, 2.755363>,
				< 0.260070, -0.047613, 2.781733>
			}
			triangle {
				< 0.260070, -0.023358, 2.856349>,
				< 0.260070, -0.047613, 2.781733>,
				< 0.408079, -0.007018, 2.755363>
			}
			triangle {
				< 0.260070, -0.023358, 2.856349>,
				< 0.408079, -0.007018, 2.755363>,
				< 0.408079, 0.024976, 2.853819>
			}
			triangle {
				< 0.617222, 0.077300, 2.851080>,
				< 0.408079, 0.003458, 2.955071>,
				< 0.408079, 0.024976, 2.853819>
			}
			triangle {
				< 0.617222, 0.077300, 2.851080>,
				< 0.617222, 0.050127, 2.978851>,
				< 0.408079, 0.003458, 2.955071>
			}
			triangle {
				< 0.617222, 0.050127, 2.978851>,
				< 0.408079, -0.065798, 3.032009>,
				< 0.408079, 0.003458, 2.955071>
			}
			triangle {
				< 0.617222, 0.050127, 2.978851>,
				< 0.617222, -0.037257, 3.075937>,
				< 0.408079, -0.065798, 3.032009>
			}
			triangle {
				< 0.617222, -0.037257, 3.075937>,
				< 0.408079, -0.164254, 3.064002>,
				< 0.408079, -0.065798, 3.032009>
			}
			triangle {
				< 0.617222, -0.037257, 3.075937>,
				< 0.617222, -0.161516, 3.116296>,
				< 0.408079, -0.164254, 3.064002>
			}
			triangle {
				< 0.617222, -0.161516, 3.116296>,
				< 0.408078, -0.265506, 3.042484>,
				< 0.408079, -0.164254, 3.064002>
			}
			triangle {
				< 0.617222, -0.161516, 3.116296>,
				< 0.617221, -0.289287, 3.089154>,
				< 0.408078, -0.265506, 3.042484>
			}
			triangle {
				< 0.617221, -0.289287, 3.089154>,
				< 0.408078, -0.342443, 2.973228>,
				< 0.408078, -0.265506, 3.042484>
			}
			triangle {
				< 0.617221, -0.289287, 3.089154>,
				< 0.617221, -0.386372, 3.001739>,
				< 0.408078, -0.342443, 2.973228>
			}
			triangle {
				< 0.617221, -0.386372, 3.001739>,
				< 0.408077, -0.374437, 2.874772>,
				< 0.408078, -0.342443, 2.973228>
			}
			triangle {
				< 0.617221, -0.386372, 3.001739>,
				< 0.617220, -0.426732, 2.877511>,
				< 0.408077, -0.374437, 2.874772>
			}
			triangle {
				< 0.617220, -0.426732, 2.877511>,
				< 0.408077, -0.352919, 2.773521>,
				< 0.408077, -0.374437, 2.874772>
			}
			triangle {
				< 0.617220, -0.426732, 2.877511>,
				< 0.617220, -0.399587, 2.749740>,
				< 0.408077, -0.352919, 2.773521>
			}
			triangle {
				< 0.617220, -0.399587, 2.749740>,
				< 0.408078, -0.283663, 2.696583>,
				< 0.408077, -0.352919, 2.773521>
			}
			triangle {
				< 0.617220, -0.399587, 2.749740>,
				< 0.617221, -0.312175, 2.652654>,
				< 0.408078, -0.283663, 2.696583>
			}
			triangle {
				< 0.617221, -0.312175, 2.652654>,
				< 0.408078, -0.185207, 2.664589>,
				< 0.408078, -0.283663, 2.696583>
			}
			triangle {
				< 0.617221, -0.312175, 2.652654>,
				< 0.617221, -0.187947, 2.612265>,
				< 0.408078, -0.185207, 2.664589>
			}
			triangle {
				< 0.617221, -0.187947, 2.612265>,
				< 0.408078, -0.083955, 2.686108>,
				< 0.408078, -0.185207, 2.664589>
			}
			triangle {
				< 0.617221, -0.187947, 2.612265>,
				< 0.617221, -0.060176, 2.639440>,
				< 0.408078, -0.083955, 2.686108>
			}
			triangle {
				< 0.617221, -0.060176, 2.639440>,
				< 0.408079, -0.007018, 2.755363>,
				< 0.408078, -0.083955, 2.686108>
			}
			triangle {
				< 0.617221, -0.060176, 2.639440>,
				< 0.617222, 0.036910, 2.726821>,
				< 0.408079, -0.007018, 2.755363>
			}
			triangle {
				< 0.408079, 0.024976, 2.853819>,
				< 0.408079, -0.007018, 2.755363>,
				< 0.617222, 0.036910, 2.726821>
			}
			triangle {
				< 0.408079, 0.024976, 2.853819>,
				< 0.617222, 0.036910, 2.726821>,
				< 0.617222, 0.077300, 2.851080>
			}
			texture{_ICP23_Blue}
		}
		// _ICP24_Cyan
		union {
			triangle {
				< 0.102113, -0.122183, -2.545361>,
				< 0.269437, -0.092717, -2.484914>,
				< 0.269437, -0.073879, -2.542830>
			}
			triangle {
				< 0.102113, -0.122183, -2.545361>,
				< 0.102113, -0.133283, -2.511252>,
				< 0.269437, -0.092717, -2.484914>
			}
			triangle {
				< 0.102113, -0.133283, -2.511252>,
				< 0.269437, -0.137988, -2.444139>,
				< 0.269437, -0.092717, -2.484914>
			}
			triangle {
				< 0.102113, -0.133283, -2.511252>,
				< 0.102113, -0.159922, -2.487234>,
				< 0.269437, -0.137988, -2.444139>
			}
			triangle {
				< 0.102113, -0.159922, -2.487234>,
				< 0.269437, -0.197571, -2.431458>,
				< 0.269437, -0.137988, -2.444139>
			}
			triangle {
				< 0.102113, -0.159922, -2.487234>,
				< 0.102113, -0.195041, -2.479764>,
				< 0.269437, -0.197571, -2.431458>
			}
			triangle {
				< 0.102113, -0.195041, -2.479764>,
				< 0.269437, -0.255489, -2.450299>,
				< 0.269437, -0.197571, -2.431458>
			}
			triangle {
				< 0.102113, -0.195041, -2.479764>,
				< 0.102113, -0.229150, -2.490865>,
				< 0.269437, -0.255489, -2.450299>
			}
			triangle {
				< 0.102113, -0.229150, -2.490865>,
				< 0.269436, -0.296265, -2.495567>,
				< 0.269437, -0.255489, -2.450299>
			}
			triangle {
				< 0.102113, -0.229150, -2.490865>,
				< 0.102112, -0.253168, -2.517532>,
				< 0.269436, -0.296265, -2.495567>
			}
			triangle {
				< 0.102112, -0.253168, -2.517532>,
				< 0.269436, -0.308914, -2.555152>,
				< 0.269436, -0.296265, -2.495567>
			}
			triangle {
				< 0.102112, -0.253168, -2.517532>,
				< 0.102112, -0.260610, -2.552622>,
				< 0.269436, -0.308914, -2.555152>
			}
			triangle {
				< 0.102112, -0.260610, -2.552622>,
				< 0.269436, -0.290105, -2.613099>,
				< 0.269436, -0.308914, -2.555152>
			}
			triangle {
				< 0.102112, -0.260610, -2.552622>,
				< 0.102112, -0.249538, -2.586760>,
				< 0.269436, -0.290105, -2.613099>
			}
			triangle {
				< 0.102112, -0.249538, -2.586760>,
				< 0.269437, -0.244836, -2.653846>,
				< 0.269436, -0.290105, -2.613099>
			}
			triangle {
				< 0.102112, -0.249538, -2.586760>,
				< 0.102112, -0.222870, -2.610750>,
				< 0.269437, -0.244836, -2.653846>
			}
			triangle {
				< 0.102112, -0.222870, -2.610750>,
				< 0.269437, -0.185251, -2.666524>,
				< 0.269437, -0.244836, -2.653846>
			}
			triangle {
				< 0.102112, -0.222870, -2.610750>,
				< 0.102113, -0.187780, -2.618220>,
				< 0.269437, -0.185251, -2.666524>
			}
			triangle {
				< 0.102113, -0.187780, -2.618220>,
				< 0.269437, -0.127302, -2.647684>,
				< 0.269437, -0.185251, -2.666524>
			}
			triangle {
				< 0.102113, -0.187780, -2.618220>,
				< 0.102113, -0.153642, -2.607117>,
				< 0.269437, -0.127302, -2.647684>
			}
			triangle {
				< 0.102113, -0.153642, -2.607117>,
				< 0.269437, -0.086557, -2.602416>,
				< 0.269437, -0.127302, -2.647684>
			}
			triangle {
				< 0.102113, -0.153642, -2.607117>,
				< 0.102113, -0.129653, -2.580450>,
				< 0.269437, -0.086557, -2.602416>
			}
			triangle {
				< 0.269437, -0.073879, -2.542830>,
				< 0.269437, -0.086557, -2.602416>,
				< 0.102113, -0.129653, -2.580450>
			}
			triangle {
				< 0.269437, -0.073879, -2.542830>,
				< 0.102113, -0.129653, -2.580450>,
				< 0.102113, -0.122183, -2.545361>
			}
			triangle {
				< -0.016284, -0.153432, -2.546998>,
				< 0.102113, -0.133283, -2.511252>,
				< 0.102113, -0.122183, -2.545361>
			}
			triangle {
				< -0.016284, -0.153432, -2.546998>,
				< -0.016284, -0.159503, -2.528277>,
				< 0.102113, -0.133283, -2.511252>
			}
			triangle {
				< -0.016284, -0.159503, -2.528277>,
				< 0.102113, -0.159922, -2.487234>,
				< 0.102113, -0.133283, -2.511252>
			}
			triangle {
				< -0.016284, -0.159503, -2.528277>,
				< -0.016284, -0.174147, -2.515122>,
				< 0.102113, -0.159922, -2.487234>
			}
			triangle {
				< -0.016284, -0.174147, -2.515122>,
				< 0.102113, -0.195041, -2.479764>,
				< 0.102113, -0.159922, -2.487234>
			}
			triangle {
				< -0.016284, -0.174147, -2.515122>,
				< -0.016284, -0.193404, -2.511014>,
				< 0.102113, -0.195041, -2.479764>
			}
			triangle {
				< -0.016284, -0.193404, -2.511014>,
				< 0.102113, -0.229150, -2.490865>,
				< 0.102113, -0.195041, -2.479764>
			}
			triangle {
				< -0.016284, -0.193404, -2.511014>,
				< -0.016284, -0.212124, -2.517116>,
				< 0.102113, -0.229150, -2.490865>
			}
			triangle {
				< -0.016284, -0.212124, -2.517116>,
				< 0.102112, -0.253168, -2.517532>,
				< 0.102113, -0.229150, -2.490865>
			}
			triangle {
				< -0.016284, -0.212124, -2.517116>,
				< -0.016284, -0.225279, -2.531729>,
				< 0.102112, -0.253168, -2.517532>
			}
			triangle {
				< -0.016284, -0.225279, -2.531729>,
				< 0.102112, -0.260610, -2.552622>,
				< 0.102112, -0.253168, -2.517532>
			}
			triangle {
				< -0.016284, -0.225279, -2.531729>,
				< -0.016284, -0.229387, -2.550986>,
				< 0.102112, -0.260610, -2.552622>
			}
			triangle {
				< -0.016284, -0.229387, -2.550986>,
				< 0.102112, -0.249538, -2.586760>,
				< 0.102112, -0.260610, -2.552622>
			}
			triangle {
				< -0.016284, -0.229387, -2.550986>,
				< -0.016284, -0.223286, -2.569706>,
				< 0.102112, -0.249538, -2.586760>
			}
			triangle {
				< -0.016284, -0.223286, -2.569706>,
				< 0.102112, -0.222870, -2.610750>,
				< 0.102112, -0.249538, -2.586760>
			}
			triangle {
				< -0.016284, -0.223286, -2.569706>,
				< -0.016284, -0.208673, -2.582861>,
				< 0.102112, -0.222870, -2.610750>
			}
			triangle {
				< -0.016284, -0.208673, -2.582861>,
				< 0.102113, -0.187780, -2.618220>,
				< 0.102112, -0.222870, -2.610750>
			}
			triangle {
				< -0.016284, -0.208673, -2.582861>,
				< -0.016284, -0.189416, -2.586969>,
				< 0.102113, -0.187780, -2.618220>
			}
			triangle {
				< -0.016284, -0.189416, -2.586969>,
				< 0.102113, -0.153642, -2.607117>,
				< 0.102113, -0.187780, -2.618220>
			}
			triangle {
				< -0.016284, -0.189416, -2.586969>,
				< -0.016284, -0.170695, -2.580896>,
				< 0.102113, -0.153642, -2.607117>
			}
			triangle {
				< -0.016284, -0.170695, -2.580896>,
				< 0.102113, -0.129653, -2.580450>,
				< 0.102113, -0.153642, -2.607117>
			}
			triangle {
				< -0.016284, -0.170695, -2.580896>,
				< -0.016284, -0.157510, -2.566255>,
				< 0.102113, -0.129653, -2.580450>
			}
			triangle {
				< 0.102113, -0.122183, -2.545361>,
				< 0.102113, -0.129653, -2.580450>,
				< -0.016284, -0.157510, -2.566255>
			}
			triangle {
				< 0.102113, -0.122183, -2.545361>,
				< -0.016284, -0.157510, -2.566255>,
				< -0.016284, -0.153432, -2.546998>
			}
			triangle {
				< 0.102120, -0.105500, 2.860664>,
				< 0.269445, -0.069875, 2.917719>,
				< 0.269445, -0.057197, 2.858134>
			}
			triangle {
				< 0.102120, -0.105500, 2.860664>,
				< 0.102120, -0.112972, 2.895754>,
				< 0.269445, -0.069875, 2.917719>
			}
			triangle {
				< 0.102120, -0.112972, 2.895754>,
				< 0.269444, -0.110622, 2.962988>,
				< 0.269445, -0.069875, 2.917719>
			}
			triangle {
				< 0.102120, -0.112972, 2.895754>,
				< 0.102120, -0.136960, 2.922422>,
				< 0.269444, -0.110622, 2.962988>
			}
			triangle {
				< 0.102120, -0.136960, 2.922422>,
				< 0.269444, -0.168568, 2.981829>,
				< 0.269444, -0.110622, 2.962988>
			}
			triangle {
				< 0.102120, -0.136960, 2.922422>,
				< 0.102120, -0.171098, 2.933525>,
				< 0.269444, -0.168568, 2.981829>
			}
			triangle {
				< 0.102120, -0.171098, 2.933525>,
				< 0.269444, -0.228153, 2.969151>,
				< 0.269444, -0.168568, 2.981829>
			}
			triangle {
				< 0.102120, -0.171098, 2.933525>,
				< 0.102120, -0.206188, 2.926053>,
				< 0.269444, -0.228153, 2.969151>
			}
			triangle {
				< 0.102120, -0.206188, 2.926053>,
				< 0.269444, -0.273422, 2.928404>,
				< 0.269444, -0.228153, 2.969151>
			}
			triangle {
				< 0.102120, -0.206188, 2.926053>,
				< 0.102120, -0.232855, 2.902035>,
				< 0.269444, -0.273422, 2.928404>
			}
			triangle {
				< 0.102120, -0.232855, 2.902035>,
				< 0.269444, -0.292232, 2.870458>,
				< 0.269444, -0.273422, 2.928404>
			}
			triangle {
				< 0.102120, -0.232855, 2.902035>,
				< 0.102120, -0.243958, 2.867927>,
				< 0.269444, -0.292232, 2.870458>
			}
			triangle {
				< 0.102120, -0.243958, 2.867927>,
				< 0.269444, -0.279583, 2.810872>,
				< 0.269444, -0.292232, 2.870458>
			}
			triangle {
				< 0.102120, -0.243958, 2.867927>,
				< 0.102120, -0.236486, 2.832837>,
				< 0.269444, -0.279583, 2.810872>
			}
			triangle {
				< 0.102120, -0.236486, 2.832837>,
				< 0.269444, -0.238838, 2.765604>,
				< 0.269444, -0.279583, 2.810872>
			}
			triangle {
				< 0.102120, -0.236486, 2.832837>,
				< 0.102120, -0.212468, 2.806170>,
				< 0.269444, -0.238838, 2.765604>
			}
			triangle {
				< 0.102120, -0.212468, 2.806170>,
				< 0.269444, -0.180891, 2.746763>,
				< 0.269444, -0.238838, 2.765604>
			}
			triangle {
				< 0.102120, -0.212468, 2.806170>,
				< 0.102120, -0.178361, 2.795069>,
				< 0.269444, -0.180891, 2.746763>
			}
			triangle {
				< 0.102120, -0.178361, 2.795069>,
				< 0.269444, -0.121306, 2.759443>,
				< 0.269444, -0.180891, 2.746763>
			}
			triangle {
				< 0.102120, -0.178361, 2.795069>,
				< 0.102120, -0.143271, 2.802539>,
				< 0.269444, -0.121306, 2.759443>
			}
			triangle {
				< 0.102120, -0.143271, 2.802539>,
				< 0.269444, -0.076038, 2.800188>,
				< 0.269444, -0.121306, 2.759443>
			}
			triangle {
				< 0.102120, -0.143271, 2.802539>,
				< 0.102120, -0.116603, 2.826527>,
				< 0.269444, -0.076038, 2.800188>
			}
			triangle {
				< 0.269445, -0.057197, 2.858134>,
				< 0.269444, -0.076038, 2.800188>,
				< 0.102120, -0.116603, 2.826527>
			}
			triangle {
				< 0.269445, -0.057197, 2.858134>,
				< 0.102120, -0.116603, 2.826527>,
				< 0.102120, -0.105500, 2.860664>
			}
			triangle {
				< -0.016277, -0.136752, 2.862301>,
				< 0.102120, -0.112972, 2.895754>,
				< 0.102120, -0.105500, 2.860664>
			}
			triangle {
				< -0.016277, -0.136752, 2.862301>,
				< -0.016277, -0.140829, 2.881558>,
				< 0.102120, -0.112972, 2.895754>
			}
			triangle {
				< -0.016277, -0.140829, 2.881558>,
				< 0.102120, -0.136960, 2.922422>,
				< 0.102120, -0.112972, 2.895754>
			}
			triangle {
				< -0.016277, -0.140829, 2.881558>,
				< -0.016277, -0.154013, 2.896171>,
				< 0.102120, -0.136960, 2.922422>
			}
			triangle {
				< -0.016277, -0.154013, 2.896171>,
				< 0.102120, -0.171098, 2.933525>,
				< 0.102120, -0.136960, 2.922422>
			}
			triangle {
				< -0.016277, -0.154013, 2.896171>,
				< -0.016277, -0.172734, 2.902273>,
				< 0.102120, -0.171098, 2.933525>
			}
			triangle {
				< -0.016277, -0.172734, 2.902273>,
				< 0.102120, -0.206188, 2.926053>,
				< 0.102120, -0.171098, 2.933525>
			}
			triangle {
				< -0.016277, -0.172734, 2.902273>,
				< -0.016277, -0.191990, 2.898167>,
				< 0.102120, -0.206188, 2.926053>
			}
			triangle {
				< -0.016277, -0.191990, 2.898167>,
				< 0.102120, -0.232855, 2.902035>,
				< 0.102120, -0.206188, 2.926053>
			}
			triangle {
				< -0.016277, -0.191990, 2.898167>,
				< -0.016277, -0.206605, 2.885012>,
				< 0.102120, -0.232855, 2.902035>
			}
			triangle {
				< -0.016277, -0.206605, 2.885012>,
				< 0.102120, -0.243958, 2.867927>,
				< 0.102120, -0.232855, 2.902035>
			}
			triangle {
				< -0.016277, -0.206605, 2.885012>,
				< -0.016277, -0.212705, 2.866291>,
				< 0.102120, -0.243958, 2.867927>
			}
			triangle {
				< -0.016277, -0.212705, 2.866291>,
				< 0.102120, -0.236486, 2.832837>,
				< 0.102120, -0.243958, 2.867927>
			}
			triangle {
				< -0.016277, -0.212705, 2.866291>,
				< -0.016277, -0.208600, 2.847035>,
				< 0.102120, -0.236486, 2.832837>
			}
			triangle {
				< -0.016277, -0.208600, 2.847035>,
				< 0.102120, -0.212468, 2.806170>,
				< 0.102120, -0.236486, 2.832837>
			}
			triangle {
				< -0.016277, -0.208600, 2.847035>,
				< -0.016277, -0.195444, 2.832391>,
				< 0.102120, -0.212468, 2.806170>
			}
			triangle {
				< -0.016277, -0.195444, 2.832391>,
				< 0.102120, -0.178361, 2.795069>,
				< 0.102120, -0.212468, 2.806170>
			}
			triangle {
				< -0.016277, -0.195444, 2.832391>,
				< -0.016277, -0.176724, 2.826320>,
				< 0.102120, -0.178361, 2.795069>
			}
			triangle {
				< -0.016277, -0.176724, 2.826320>,
				< 0.102120, -0.143271, 2.802539>,
				< 0.102120, -0.178361, 2.795069>
			}
			triangle {
				< -0.016277, -0.176724, 2.826320>,
				< -0.016277, -0.157467, 2.830397>,
				< 0.102120, -0.143271, 2.802539>
			}
			triangle {
				< -0.016277, -0.157467, 2.830397>,
				< 0.102120, -0.116603, 2.826527>,
				< 0.102120, -0.143271, 2.802539>
			}
			triangle {
				< -0.016277, -0.157467, 2.830397>,
				< -0.016277, -0.142824, 2.843581>,
				< 0.102120, -0.116603, 2.826527>
			}
			triangle {
				< 0.102120, -0.105500, 2.860664>,
				< 0.102120, -0.116603, 2.826527>,
				< -0.016277, -0.142824, 2.843581>
			}
			triangle {
				< 0.102120, -0.105500, 2.860664>,
				< -0.016277, -0.142824, 2.843581>,
				< -0.016277, -0.136752, 2.862301>
			}
			texture{_ICP24_Cyan}
		}
		// _ICP25_Green
		union {
			triangle {
				< 1.699563, 0.268386, -2.638789>,
				< 1.699562, 0.155467, -2.644712>,
				< 0.489236, 0.484258, -2.627477>
			}
			triangle {
				< -0.547486, 0.028657, -2.710036>,
				< -0.552455, 0.484263, -2.627475>,
				< 0.489236, 0.484258, -2.627477>
			}
			triangle {
				< 1.699562, 0.155467, -2.644712>,
				< -0.547486, 0.028657, -2.710036>,
				< 0.489236, 0.484258, -2.627477>
			}
			triangle {
				< 0.489237, 0.474915, -2.449139>,
				< 1.699563, 0.259042, -2.460450>,
				< 1.699563, 0.268386, -2.638789>
			}
			triangle {
				< 0.489236, 0.484258, -2.627477>,
				< 0.489237, 0.474915, -2.449139>,
				< 1.699563, 0.268386, -2.638789>
			}
			triangle {
				< -0.552455, 0.474919, -2.449138>,
				< 0.489237, 0.474915, -2.449139>,
				< 0.489236, 0.484258, -2.627477>
			}
			triangle {
				< -0.552455, 0.484263, -2.627475>,
				< -0.552455, 0.474919, -2.449138>,
				< 0.489236, 0.484258, -2.627477>
			}
			triangle {
				< -0.547486, 0.013092, -2.412826>,
				< -0.552455, 0.474919, -2.449138>,
				< -0.552455, 0.484263, -2.627475>
			}
			triangle {
				< -0.547486, 0.028657, -2.710036>,
				< -0.547486, 0.013092, -2.412826>,
				< -0.552455, 0.484263, -2.627475>
			}
			triangle {
				< 1.699562, 0.146121, -2.466373>,
				< -0.547486, 0.013092, -2.412826>,
				< -0.547486, 0.028657, -2.710036>
			}
			triangle {
				< 1.699562, 0.155467, -2.644712>,
				< 1.699562, 0.146121, -2.466373>,
				< -0.547486, 0.028657, -2.710036>
			}
			triangle {
				< 1.699563, 0.268386, -2.638789>,
				< 1.699563, 0.259042, -2.460450>,
				< 1.699562, 0.146121, -2.466373>
			}
			triangle {
				< 1.699563, 0.268386, -2.638789>,
				< 1.699562, 0.146121, -2.466373>,
				< 1.699562, 0.155467, -2.644712>
			}
			triangle {
				< 0.489237, 0.474915, -2.449139>,
				< 1.699562, 0.146121, -2.466373>,
				< 1.699563, 0.259042, -2.460450>
			}
			triangle {
				< 0.489237, 0.474915, -2.449139>,
				< -0.552455, 0.474919, -2.449138>,
				< -0.547486, 0.013092, -2.412826>
			}
			triangle {
				< 0.489237, 0.474915, -2.449139>,
				< -0.547486, 0.013092, -2.412826>,
				< 1.699562, 0.146121, -2.466373>
			}
			triangle {
				< 1.699570, 0.275901, 2.772327>,
				< 1.699569, 0.162951, 2.778250>,
				< 0.489243, 0.491745, 2.761017>
			}
			triangle {
				< -0.547479, 0.030011, 2.726555>,
				< -0.552448, 0.491749, 2.761018>,
				< 0.489243, 0.491745, 2.761017>
			}
			triangle {
				< 1.699569, 0.162951, 2.778250>,
				< -0.547479, 0.030011, 2.726555>,
				< 0.489243, 0.491745, 2.761017>
			}
			triangle {
				< 0.489244, 0.501089, 2.939356>,
				< 1.699570, 0.285247, 2.950665>,
				< 1.699570, 0.275901, 2.772327>
			}
			triangle {
				< 0.489243, 0.491745, 2.761017>,
				< 0.489244, 0.501089, 2.939356>,
				< 1.699570, 0.275901, 2.772327>
			}
			triangle {
				< -0.552448, 0.501093, 2.939358>,
				< 0.489244, 0.501089, 2.939356>,
				< 0.489243, 0.491745, 2.761017>
			}
			triangle {
				< -0.552448, 0.491749, 2.761018>,
				< -0.552448, 0.501093, 2.939358>,
				< 0.489243, 0.491745, 2.761017>
			}
			triangle {
				< -0.547479, 0.045606, 3.023764>,
				< -0.552448, 0.501093, 2.939358>,
				< -0.552448, 0.491749, 2.761018>
			}
			triangle {
				< -0.547479, 0.030011, 2.726555>,
				< -0.547479, 0.045606, 3.023764>,
				< -0.552448, 0.491749, 2.761018>
			}
			triangle {
				< 1.699570, 0.172298, 2.956588>,
				< -0.547479, 0.045606, 3.023764>,
				< -0.547479, 0.030011, 2.726555>
			}
			triangle {
				< 1.699569, 0.162951, 2.778250>,
				< 1.699570, 0.172298, 2.956588>,
				< -0.547479, 0.030011, 2.726555>
			}
			triangle {
				< 1.699570, 0.275901, 2.772327>,
				< 1.699570, 0.285247, 2.950665>,
				< 1.699570, 0.172298, 2.956588>
			}
			triangle {
				< 1.699570, 0.275901, 2.772327>,
				< 1.699570, 0.172298, 2.956588>,
				< 1.699569, 0.162951, 2.778250>
			}
			triangle {
				< 0.489244, 0.501089, 2.939356>,
				< 1.699570, 0.172298, 2.956588>,
				< 1.699570, 0.285247, 2.950665>
			}
			triangle {
				< 0.489244, 0.501089, 2.939356>,
				< -0.552448, 0.501093, 2.939358>,
				< -0.547479, 0.045606, 3.023764>
			}
			triangle {
				< 0.489244, 0.501089, 2.939356>,
				< -0.547479, 0.045606, 3.023764>,
				< 1.699570, 0.172298, 2.956588>
			}
			texture{_ICP25_Green}
		}
		// _ICP26_Yellow
		union {
			triangle {
				< 1.881650, 0.246540, -2.526047>,
				< 1.947574, 0.158888, -2.321519>,
				< 1.947574, 0.225677, -2.527150>
			}
			triangle {
				< 1.881650, 0.246540, -2.526047>,
				< 1.881650, 0.176389, -2.310149>,
				< 1.947574, 0.158888, -2.321519>
			}
			triangle {
				< 1.881650, 0.176389, -2.310149>,
				< 1.947574, -0.001798, -2.176842>,
				< 1.947574, 0.158888, -2.321519>
			}
			triangle {
				< 1.881650, 0.176389, -2.310149>,
				< 1.881650, 0.007696, -2.158241>,
				< 1.947574, -0.001798, -2.176842>
			}
			triangle {
				< 1.881650, 0.007696, -2.158241>,
				< 1.947573, -0.213262, -2.131900>,
				< 1.947574, -0.001798, -2.176842>
			}
			triangle {
				< 1.881650, 0.007696, -2.158241>,
				< 1.881649, -0.214364, -2.111037>,
				< 1.947573, -0.213262, -2.131900>
			}
			triangle {
				< 1.881649, -0.214364, -2.111037>,
				< 1.947572, -0.418893, -2.198717>,
				< 1.947573, -0.213262, -2.131900>
			}
			triangle {
				< 1.881649, -0.214364, -2.111037>,
				< 1.881648, -0.430261, -2.181186>,
				< 1.947572, -0.418893, -2.198717>
			}
			triangle {
				< 1.881648, -0.430261, -2.181186>,
				< 1.947571, -0.563540, -2.359375>,
				< 1.947572, -0.418893, -2.198717>
			}
			triangle {
				< 1.881648, -0.430261, -2.181186>,
				< 1.881647, -0.582171, -2.349911>,
				< 1.947571, -0.563540, -2.359375>
			}
			triangle {
				< 1.881647, -0.582171, -2.349911>,
				< 1.947571, -0.608512, -2.570869>,
				< 1.947571, -0.563540, -2.359375>
			}
			triangle {
				< 1.881647, -0.582171, -2.349911>,
				< 1.881647, -0.629346, -2.571939>,
				< 1.947571, -0.608512, -2.570869>
			}
			triangle {
				< 1.881647, -0.629346, -2.571939>,
				< 1.947571, -0.541695, -2.776469>,
				< 1.947571, -0.608512, -2.570869>
			}
			triangle {
				< 1.881647, -0.629346, -2.571939>,
				< 1.881646, -0.559195, -2.787838>,
				< 1.947571, -0.541695, -2.776469>
			}
			triangle {
				< 1.881646, -0.559195, -2.787838>,
				< 1.947571, -0.381037, -2.921144>,
				< 1.947571, -0.541695, -2.776469>
			}
			triangle {
				< 1.881646, -0.559195, -2.787838>,
				< 1.881647, -0.390501, -2.939747>,
				< 1.947571, -0.381037, -2.921144>
			}
			triangle {
				< 1.881647, -0.390501, -2.939747>,
				< 1.947572, -0.169543, -2.966087>,
				< 1.947571, -0.381037, -2.921144>
			}
			triangle {
				< 1.881647, -0.390501, -2.939747>,
				< 1.881648, -0.168473, -2.986952>,
				< 1.947572, -0.169543, -2.966087>
			}
			triangle {
				< 1.881648, -0.168473, -2.986952>,
				< 1.947573, 0.036057, -2.899272>,
				< 1.947572, -0.169543, -2.966087>
			}
			triangle {
				< 1.881648, -0.168473, -2.986952>,
				< 1.881649, 0.047426, -2.916800>,
				< 1.947573, 0.036057, -2.899272>
			}
			triangle {
				< 1.881649, 0.047426, -2.916800>,
				< 1.947574, 0.180735, -2.738612>,
				< 1.947573, 0.036057, -2.899272>
			}
			triangle {
				< 1.881649, 0.047426, -2.916800>,
				< 1.881650, 0.199336, -2.748106>,
				< 1.947574, 0.180735, -2.738612>
			}
			triangle {
				< 1.947574, 0.225677, -2.527150>,
				< 1.947574, 0.180735, -2.738612>,
				< 1.881650, 0.199336, -2.748106>
			}
			triangle {
				< 1.947574, 0.225677, -2.527150>,
				< 1.881650, 0.199336, -2.748106>,
				< 1.881650, 0.246540, -2.526047>
			}
			triangle {
				< 1.828524, 0.282196, -2.524173>,
				< 1.881650, 0.176389, -2.310149>,
				< 1.881650, 0.246540, -2.526047>
			}
			triangle {
				< 1.828524, 0.282196, -2.524173>,
				< 1.828524, 0.206332, -2.290685>,
				< 1.881650, 0.176389, -2.310149>
			}
			triangle {
				< 1.828524, 0.206332, -2.290685>,
				< 1.881650, 0.007696, -2.158241>,
				< 1.881650, 0.176389, -2.310149>
			}
			triangle {
				< 1.828524, 0.206332, -2.290685>,
				< 1.828524, 0.023916, -2.126424>,
				< 1.881650, 0.007696, -2.158241>
			}
			triangle {
				< 1.828524, 0.023916, -2.126424>,
				< 1.881649, -0.214364, -2.111037>,
				< 1.881650, 0.007696, -2.158241>
			}
			triangle {
				< 1.828524, 0.023916, -2.126424>,
				< 1.828523, -0.216238, -2.075380>,
				< 1.881649, -0.214364, -2.111037>
			}
			triangle {
				< 1.828523, -0.216238, -2.075380>,
				< 1.881648, -0.430261, -2.181186>,
				< 1.881649, -0.214364, -2.111037>
			}
			triangle {
				< 1.828523, -0.216238, -2.075380>,
				< 1.828522, -0.449696, -2.151245>,
				< 1.881648, -0.430261, -2.181186>
			}
			triangle {
				< 1.828522, -0.449696, -2.151245>,
				< 1.881647, -0.582171, -2.349911>,
				< 1.881648, -0.430261, -2.181186>
			}
			triangle {
				< 1.828522, -0.449696, -2.151245>,
				< 1.828521, -0.613987, -2.333690>,
				< 1.881647, -0.582171, -2.349911>
			}
			triangle {
				< 1.828521, -0.613987, -2.333690>,
				< 1.881647, -0.629346, -2.571939>,
				< 1.881647, -0.582171, -2.349911>
			}
			triangle {
				< 1.828521, -0.613987, -2.333690>,
				< 1.828521, -0.665031, -2.573815>,
				< 1.881647, -0.629346, -2.571939>
			}
			triangle {
				< 1.828521, -0.665031, -2.573815>,
				< 1.881646, -0.559195, -2.787838>,
				< 1.881647, -0.629346, -2.571939>
			}
			triangle {
				< 1.828521, -0.665031, -2.573815>,
				< 1.828520, -0.589167, -2.807303>,
				< 1.881646, -0.559195, -2.787838>
			}
			triangle {
				< 1.828520, -0.589167, -2.807303>,
				< 1.881647, -0.390501, -2.939747>,
				< 1.881646, -0.559195, -2.787838>
			}
			triangle {
				< 1.828520, -0.589167, -2.807303>,
				< 1.828521, -0.406722, -2.971562>,
				< 1.881647, -0.390501, -2.939747>
			}
			triangle {
				< 1.828521, -0.406722, -2.971562>,
				< 1.881648, -0.168473, -2.986952>,
				< 1.881647, -0.390501, -2.939747>
			}
			triangle {
				< 1.828521, -0.406722, -2.971562>,
				< 1.828522, -0.166596, -3.022606>,
				< 1.881648, -0.168473, -2.986952>
			}
			triangle {
				< 1.828522, -0.166596, -3.022606>,
				< 1.881649, 0.047426, -2.916800>,
				< 1.881648, -0.168473, -2.986952>
			}
			triangle {
				< 1.828522, -0.166596, -3.022606>,
				< 1.828522, 0.066892, -2.946741>,
				< 1.881649, 0.047426, -2.916800>
			}
			triangle {
				< 1.828522, 0.066892, -2.946741>,
				< 1.881650, 0.199336, -2.748106>,
				< 1.881649, 0.047426, -2.916800>
			}
			triangle {
				< 1.828522, 0.066892, -2.946741>,
				< 1.828524, 0.231153, -2.764297>,
				< 1.881650, 0.199336, -2.748106>
			}
			triangle {
				< 1.881650, 0.246540, -2.526047>,
				< 1.881650, 0.199336, -2.748106>,
				< 1.828524, 0.231153, -2.764297>
			}
			triangle {
				< 1.881650, 0.246540, -2.526047>,
				< 1.828524, 0.231153, -2.764297>,
				< 1.828524, 0.282196, -2.524173>
			}
			triangle {
				< 1.881650, 0.204843, -2.528220>,
				< 1.828524, 0.142937, -2.331876>,
				< 1.828524, 0.206717, -2.528131>
			}
			triangle {
				< 1.881650, 0.204843, -2.528220>,
				< 1.881650, 0.141360, -2.332888>,
				< 1.828524, 0.142937, -2.331876>
			}
			triangle {
				< 1.881650, 0.141360, -2.332888>,
				< 1.828523, -0.010429, -2.193778>,
				< 1.828524, 0.142937, -2.331876>
			}
			triangle {
				< 1.881650, 0.141360, -2.332888>,
				< 1.881650, -0.011264, -2.195473>,
				< 1.828523, -0.010429, -2.193778>
			}
			triangle {
				< 1.881650, -0.011264, -2.195473>,
				< 1.828523, -0.212281, -2.150888>,
				< 1.828523, -0.010429, -2.193778>
			}
			triangle {
				< 1.881650, -0.011264, -2.195473>,
				< 1.881649, -0.212161, -2.152764>,
				< 1.828523, -0.212281, -2.150888>
			}
			triangle {
				< 1.881649, -0.212161, -2.152764>,
				< 1.828522, -0.408535, -2.214640>,
				< 1.828523, -0.212281, -2.150888>
			}
			triangle {
				< 1.881649, -0.212161, -2.152764>,
				< 1.881648, -0.407524, -2.216218>,
				< 1.828522, -0.408535, -2.214640>
			}
			triangle {
				< 1.881648, -0.407524, -2.216218>,
				< 1.828521, -0.546605, -2.368006>,
				< 1.828522, -0.408535, -2.214640>
			}
			triangle {
				< 1.881648, -0.407524, -2.216218>,
				< 1.881647, -0.544938, -2.368869>,
				< 1.828521, -0.546605, -2.368006>
			}
			triangle {
				< 1.881647, -0.544938, -2.368869>,
				< 1.828521, -0.589523, -2.569856>,
				< 1.828521, -0.546605, -2.368006>
			}
			triangle {
				< 1.881647, -0.544938, -2.368869>,
				< 1.881647, -0.587647, -2.569767>,
				< 1.828521, -0.589523, -2.569856>
			}
			triangle {
				< 1.881647, -0.587647, -2.569767>,
				< 1.828521, -0.525742, -2.766112>,
				< 1.828521, -0.589523, -2.569856>
			}
			triangle {
				< 1.881647, -0.587647, -2.569767>,
				< 1.881647, -0.524194, -2.765099>,
				< 1.828521, -0.525742, -2.766112>
			}
			triangle {
				< 1.881647, -0.524194, -2.765099>,
				< 1.828521, -0.372405, -2.904211>,
				< 1.828521, -0.525742, -2.766112>
			}
			triangle {
				< 1.881647, -0.524194, -2.765099>,
				< 1.881648, -0.371542, -2.902544>,
				< 1.828521, -0.372405, -2.904211>
			}
			triangle {
				< 1.881648, -0.371542, -2.902544>,
				< 1.828522, -0.170556, -2.947128>,
				< 1.828521, -0.372405, -2.904211>
			}
			triangle {
				< 1.881648, -0.371542, -2.902544>,
				< 1.881648, -0.170645, -2.945224>,
				< 1.828522, -0.170556, -2.947128>
			}
			triangle {
				< 1.881648, -0.170645, -2.945224>,
				< 1.828523, 0.025731, -2.883347>,
				< 1.828522, -0.170556, -2.947128>
			}
			triangle {
				< 1.881648, -0.170645, -2.945224>,
				< 1.881649, 0.024687, -2.881769>,
				< 1.828523, 0.025731, -2.883347>
			}
			triangle {
				< 1.881649, 0.024687, -2.881769>,
				< 1.828523, 0.163799, -2.729980>,
				< 1.828523, 0.025731, -2.883347>
			}
			triangle {
				< 1.881649, 0.024687, -2.881769>,
				< 1.881650, 0.162132, -2.729148>,
				< 1.828523, 0.163799, -2.729980>
			}
			triangle {
				< 1.828524, 0.206717, -2.528131>,
				< 1.828523, 0.163799, -2.729980>,
				< 1.881650, 0.162132, -2.729148>
			}
			triangle {
				< 1.828524, 0.206717, -2.528131>,
				< 1.881650, 0.162132, -2.729148>,
				< 1.881650, 0.204843, -2.528220>
			}
			triangle {
				< 1.947574, 0.225677, -2.527150>,
				< 1.881650, 0.141360, -2.332888>,
				< 1.881650, 0.204843, -2.528220>
			}
			triangle {
				< 1.947574, 0.225677, -2.527150>,
				< 1.947574, 0.158888, -2.321519>,
				< 1.881650, 0.141360, -2.332888>
			}
			triangle {
				< 1.947574, 0.158888, -2.321519>,
				< 1.881650, -0.011264, -2.195473>,
				< 1.881650, 0.141360, -2.332888>
			}
			triangle {
				< 1.947574, 0.158888, -2.321519>,
				< 1.947574, -0.001798, -2.176842>,
				< 1.881650, -0.011264, -2.195473>
			}
			triangle {
				< 1.947574, -0.001798, -2.176842>,
				< 1.881649, -0.212161, -2.152764>,
				< 1.881650, -0.011264, -2.195473>
			}
			triangle {
				< 1.947574, -0.001798, -2.176842>,
				< 1.947573, -0.213262, -2.131900>,
				< 1.881649, -0.212161, -2.152764>
			}
			triangle {
				< 1.947573, -0.213262, -2.131900>,
				< 1.881648, -0.407524, -2.216218>,
				< 1.881649, -0.212161, -2.152764>
			}
			triangle {
				< 1.947573, -0.213262, -2.131900>,
				< 1.947572, -0.418893, -2.198717>,
				< 1.881648, -0.407524, -2.216218>
			}
			triangle {
				< 1.947572, -0.418893, -2.198717>,
				< 1.881647, -0.544938, -2.368869>,
				< 1.881648, -0.407524, -2.216218>
			}
			triangle {
				< 1.947572, -0.418893, -2.198717>,
				< 1.947571, -0.563540, -2.359375>,
				< 1.881647, -0.544938, -2.368869>
			}
			triangle {
				< 1.947571, -0.563540, -2.359375>,
				< 1.881647, -0.587647, -2.569767>,
				< 1.881647, -0.544938, -2.368869>
			}
			triangle {
				< 1.947571, -0.563540, -2.359375>,
				< 1.947571, -0.608512, -2.570869>,
				< 1.881647, -0.587647, -2.569767>
			}
			triangle {
				< 1.947571, -0.608512, -2.570869>,
				< 1.881647, -0.524194, -2.765099>,
				< 1.881647, -0.587647, -2.569767>
			}
			triangle {
				< 1.947571, -0.608512, -2.570869>,
				< 1.947571, -0.541695, -2.776469>,
				< 1.881647, -0.524194, -2.765099>
			}
			triangle {
				< 1.947571, -0.541695, -2.776469>,
				< 1.881648, -0.371542, -2.902544>,
				< 1.881647, -0.524194, -2.765099>
			}
			triangle {
				< 1.947571, -0.541695, -2.776469>,
				< 1.947571, -0.381037, -2.921144>,
				< 1.881648, -0.371542, -2.902544>
			}
			triangle {
				< 1.947571, -0.381037, -2.921144>,
				< 1.881648, -0.170645, -2.945224>,
				< 1.881648, -0.371542, -2.902544>
			}
			triangle {
				< 1.947571, -0.381037, -2.921144>,
				< 1.947572, -0.169543, -2.966087>,
				< 1.881648, -0.170645, -2.945224>
			}
			triangle {
				< 1.947572, -0.169543, -2.966087>,
				< 1.881649, 0.024687, -2.881769>,
				< 1.881648, -0.170645, -2.945224>
			}
			triangle {
				< 1.947572, -0.169543, -2.966087>,
				< 1.947573, 0.036057, -2.899272>,
				< 1.881649, 0.024687, -2.881769>
			}
			triangle {
				< 1.947573, 0.036057, -2.899272>,
				< 1.881650, 0.162132, -2.729148>,
				< 1.881649, 0.024687, -2.881769>
			}
			triangle {
				< 1.947573, 0.036057, -2.899272>,
				< 1.947574, 0.180735, -2.738612>,
				< 1.881650, 0.162132, -2.729148>
			}
			triangle {
				< 1.881650, 0.204843, -2.528220>,
				< 1.881650, 0.162132, -2.729148>,
				< 1.947574, 0.180735, -2.738612>
			}
			triangle {
				< 1.881650, 0.204843, -2.528220>,
				< 1.947574, 0.180735, -2.738612>,
				< 1.947574, 0.225677, -2.527150>
			}
			triangle {
				< 1.881658, 0.263222, 2.841317>,
				< 1.947581, 0.197416, 3.053882>,
				< 1.947582, 0.242357, 2.842418>
			}
			triangle {
				< 1.881658, 0.263222, 2.841317>,
				< 1.881657, 0.216019, 3.063376>,
				< 1.947581, 0.197416, 3.053882>
			}
			triangle {
				< 1.881657, 0.216019, 3.063376>,
				< 1.947581, 0.052770, 3.214569>,
				< 1.947581, 0.197416, 3.053882>
			}
			triangle {
				< 1.881657, 0.216019, 3.063376>,
				< 1.881657, 0.064141, 3.232071>,
				< 1.947581, 0.052770, 3.214569>
			}
			triangle {
				< 1.881657, 0.064141, 3.232071>,
				< 1.947581, -0.152860, 3.281387>,
				< 1.947581, 0.052770, 3.214569>
			}
			triangle {
				< 1.881657, 0.064141, 3.232071>,
				< 1.881656, -0.151758, 3.302252>,
				< 1.947581, -0.152860, 3.281387>
			}
			triangle {
				< 1.881656, -0.151758, 3.302252>,
				< 1.947580, -0.364322, 3.236446>,
				< 1.947581, -0.152860, 3.281387>
			}
			triangle {
				< 1.881656, -0.151758, 3.302252>,
				< 1.881656, -0.373817, 3.255047>,
				< 1.947580, -0.364322, 3.236446>
			}
			triangle {
				< 1.881656, -0.373817, 3.255047>,
				< 1.947579, -0.525012, 3.091800>,
				< 1.947580, -0.364322, 3.236446>
			}
			triangle {
				< 1.881656, -0.373817, 3.255047>,
				< 1.881654, -0.542512, 3.103171>,
				< 1.947579, -0.525012, 3.091800>
			}
			triangle {
				< 1.881654, -0.542512, 3.103171>,
				< 1.947578, -0.591830, 2.886170>,
				< 1.947579, -0.525012, 3.091800>
			}
			triangle {
				< 1.881654, -0.542512, 3.103171>,
				< 1.881654, -0.612664, 2.887272>,
				< 1.947578, -0.591830, 2.886170>
			}
			triangle {
				< 1.881654, -0.612664, 2.887272>,
				< 1.947578, -0.546889, 2.674708>,
				< 1.947578, -0.591830, 2.886170>
			}
			triangle {
				< 1.881654, -0.612664, 2.887272>,
				< 1.881654, -0.565491, 2.665214>,
				< 1.947578, -0.546889, 2.674708>
			}
			triangle {
				< 1.881654, -0.565491, 2.665214>,
				< 1.947578, -0.402243, 2.514019>,
				< 1.947578, -0.546889, 2.674708>
			}
			triangle {
				< 1.881654, -0.565491, 2.665214>,
				< 1.881654, -0.413613, 2.496518>,
				< 1.947578, -0.402243, 2.514019>
			}
			triangle {
				< 1.881654, -0.413613, 2.496518>,
				< 1.947579, -0.196613, 2.447201>,
				< 1.947578, -0.402243, 2.514019>
			}
			triangle {
				< 1.881654, -0.413613, 2.496518>,
				< 1.881655, -0.197715, 2.426336>,
				< 1.947579, -0.196613, 2.447201>
			}
			triangle {
				< 1.881655, -0.197715, 2.426336>,
				< 1.947580, 0.014851, 2.492141>,
				< 1.947579, -0.196613, 2.447201>
			}
			triangle {
				< 1.881655, -0.197715, 2.426336>,
				< 1.881656, 0.024346, 2.473539>,
				< 1.947580, 0.014851, 2.492141>
			}
			triangle {
				< 1.881656, 0.024346, 2.473539>,
				< 1.947581, 0.175541, 2.636787>,
				< 1.947580, 0.014851, 2.492141>
			}
			triangle {
				< 1.881656, 0.024346, 2.473539>,
				< 1.881657, 0.193041, 2.625417>,
				< 1.947581, 0.175541, 2.636787>
			}
			triangle {
				< 1.947582, 0.242357, 2.842418>,
				< 1.947581, 0.175541, 2.636787>,
				< 1.881657, 0.193041, 2.625417>
			}
			triangle {
				< 1.947582, 0.242357, 2.842418>,
				< 1.881657, 0.193041, 2.625417>,
				< 1.881658, 0.263222, 2.841317>
			}
			triangle {
				< 1.828531, 0.298877, 2.839441>,
				< 1.881657, 0.216019, 3.063376>,
				< 1.881658, 0.263222, 2.841317>
			}
			triangle {
				< 1.828531, 0.298877, 2.839441>,
				< 1.828532, 0.247864, 3.079567>,
				< 1.881657, 0.216019, 3.063376>
			}
			triangle {
				< 1.828532, 0.247864, 3.079567>,
				< 1.881657, 0.064141, 3.232071>,
				< 1.881657, 0.216019, 3.063376>
			}
			triangle {
				< 1.828532, 0.247864, 3.079567>,
				< 1.828531, 0.083605, 3.262012>,
				< 1.881657, 0.064141, 3.232071>
			}
			triangle {
				< 1.828531, 0.083605, 3.262012>,
				< 1.881656, -0.151758, 3.302252>,
				< 1.881657, 0.064141, 3.232071>
			}
			triangle {
				< 1.828531, 0.083605, 3.262012>,
				< 1.828530, -0.149883, 3.337907>,
				< 1.881656, -0.151758, 3.302252>
			}
			triangle {
				< 1.828530, -0.149883, 3.337907>,
				< 1.881656, -0.373817, 3.255047>,
				< 1.881656, -0.151758, 3.302252>
			}
			triangle {
				< 1.828530, -0.149883, 3.337907>,
				< 1.828529, -0.390009, 3.286864>,
				< 1.881656, -0.373817, 3.255047>
			}
			triangle {
				< 1.828529, -0.390009, 3.286864>,
				< 1.881654, -0.542512, 3.103171>,
				< 1.881656, -0.373817, 3.255047>
			}
			triangle {
				< 1.828529, -0.390009, 3.286864>,
				< 1.828528, -0.572454, 3.122604>,
				< 1.881654, -0.542512, 3.103171>
			}
			triangle {
				< 1.828528, -0.572454, 3.122604>,
				< 1.881654, -0.612664, 2.887272>,
				< 1.881654, -0.542512, 3.103171>
			}
			triangle {
				< 1.828528, -0.572454, 3.122604>,
				< 1.828528, -0.648348, 2.889147>,
				< 1.881654, -0.612664, 2.887272>
			}
			triangle {
				< 1.828528, -0.648348, 2.889147>,
				< 1.881654, -0.565491, 2.665214>,
				< 1.881654, -0.612664, 2.887272>
			}
			triangle {
				< 1.828528, -0.648348, 2.889147>,
				< 1.828528, -0.597306, 2.648993>,
				< 1.881654, -0.565491, 2.665214>
			}
			triangle {
				< 1.828528, -0.597306, 2.648993>,
				< 1.881654, -0.413613, 2.496518>,
				< 1.881654, -0.565491, 2.665214>
			}
			triangle {
				< 1.828528, -0.597306, 2.648993>,
				< 1.828528, -0.433046, 2.466547>,
				< 1.881654, -0.413613, 2.496518>
			}
			triangle {
				< 1.828528, -0.433046, 2.466547>,
				< 1.881655, -0.197715, 2.426336>,
				< 1.881654, -0.413613, 2.496518>
			}
			triangle {
				< 1.828528, -0.433046, 2.466547>,
				< 1.828529, -0.199589, 2.390681>,
				< 1.881655, -0.197715, 2.426336>
			}
			triangle {
				< 1.828529, -0.199589, 2.390681>,
				< 1.881656, 0.024346, 2.473539>,
				< 1.881655, -0.197715, 2.426336>
			}
			triangle {
				< 1.828529, -0.199589, 2.390681>,
				< 1.828530, 0.040565, 2.441693>,
				< 1.881656, 0.024346, 2.473539>
			}
			triangle {
				< 1.828530, 0.040565, 2.441693>,
				< 1.881657, 0.193041, 2.625417>,
				< 1.881656, 0.024346, 2.473539>
			}
			triangle {
				< 1.828530, 0.040565, 2.441693>,
				< 1.828530, 0.223011, 2.605953>,
				< 1.881657, 0.193041, 2.625417>
			}
			triangle {
				< 1.881658, 0.263222, 2.841317>,
				< 1.881657, 0.193041, 2.625417>,
				< 1.828530, 0.223011, 2.605953>
			}
			triangle {
				< 1.881658, 0.263222, 2.841317>,
				< 1.828530, 0.223011, 2.605953>,
				< 1.828531, 0.298877, 2.839441>
			}
			triangle {
				< 1.881657, 0.221494, 2.843490>,
				< 1.828531, 0.180482, 3.045251>,
				< 1.828531, 0.223399, 2.843398>
			}
			triangle {
				< 1.881657, 0.221494, 2.843490>,
				< 1.881657, 0.178815, 3.044416>,
				< 1.828531, 0.180482, 3.045251>
			}
			triangle {
				< 1.881657, 0.178815, 3.044416>,
				< 1.828531, 0.042413, 3.198618>,
				< 1.828531, 0.180482, 3.045251>
			}
			triangle {
				< 1.881657, 0.178815, 3.044416>,
				< 1.881657, 0.041402, 3.197040>,
				< 1.828531, 0.042413, 3.198618>
			}
			triangle {
				< 1.881657, 0.041402, 3.197040>,
				< 1.828530, -0.153841, 3.262399>,
				< 1.828531, 0.042413, 3.198618>
			}
			triangle {
				< 1.881657, 0.041402, 3.197040>,
				< 1.881656, -0.153930, 3.260524>,
				< 1.828530, -0.153841, 3.262399>
			}
			triangle {
				< 1.881656, -0.153930, 3.260524>,
				< 1.828529, -0.355693, 3.219512>,
				< 1.828530, -0.153841, 3.262399>
			}
			triangle {
				< 1.881656, -0.153930, 3.260524>,
				< 1.881656, -0.354858, 3.217845>,
				< 1.828529, -0.355693, 3.219512>
			}
			triangle {
				< 1.881656, -0.354858, 3.217845>,
				< 1.828529, -0.509060, 3.081443>,
				< 1.828529, -0.355693, 3.219512>
			}
			triangle {
				< 1.881656, -0.354858, 3.217845>,
				< 1.881655, -0.507483, 3.080401>,
				< 1.828529, -0.509060, 3.081443>
			}
			triangle {
				< 1.881655, -0.507483, 3.080401>,
				< 1.828528, -0.572841, 2.885189>,
				< 1.828529, -0.509060, 3.081443>
			}
			triangle {
				< 1.881655, -0.507483, 3.080401>,
				< 1.881654, -0.570967, 2.885069>,
				< 1.828528, -0.572841, 2.885189>
			}
			triangle {
				< 1.881654, -0.570967, 2.885069>,
				< 1.828528, -0.529955, 2.683337>,
				< 1.828528, -0.572841, 2.885189>
			}
			triangle {
				< 1.881654, -0.570967, 2.885069>,
				< 1.881654, -0.528288, 2.684172>,
				< 1.828528, -0.529955, 2.683337>
			}
			triangle {
				< 1.881654, -0.528288, 2.684172>,
				< 1.828528, -0.391885, 2.529970>,
				< 1.828528, -0.529955, 2.683337>
			}
			triangle {
				< 1.881654, -0.528288, 2.684172>,
				< 1.881654, -0.390844, 2.531519>,
				< 1.828528, -0.391885, 2.529970>
			}
			triangle {
				< 1.881654, -0.390844, 2.531519>,
				< 1.828529, -0.195631, 2.466190>,
				< 1.828528, -0.391885, 2.529970>
			}
			triangle {
				< 1.881654, -0.390844, 2.531519>,
				< 1.881655, -0.195512, 2.468063>,
				< 1.828529, -0.195631, 2.466190>
			}
			triangle {
				< 1.881655, -0.195512, 2.468063>,
				< 1.828530, 0.006249, 2.509076>,
				< 1.828529, -0.195631, 2.466190>
			}
			triangle {
				< 1.881655, -0.195512, 2.468063>,
				< 1.881656, 0.005386, 2.510743>,
				< 1.828530, 0.006249, 2.509076>
			}
			triangle {
				< 1.881656, 0.005386, 2.510743>,
				< 1.828531, 0.159616, 2.647145>,
				< 1.828530, 0.006249, 2.509076>
			}
			triangle {
				< 1.881656, 0.005386, 2.510743>,
				< 1.881657, 0.158039, 2.648156>,
				< 1.828531, 0.159616, 2.647145>
			}
			triangle {
				< 1.828531, 0.223399, 2.843398>,
				< 1.828531, 0.159616, 2.647145>,
				< 1.881657, 0.158039, 2.648156>
			}
			triangle {
				< 1.828531, 0.223399, 2.843398>,
				< 1.881657, 0.158039, 2.648156>,
				< 1.881657, 0.221494, 2.843490>
			}
			triangle {
				< 1.947582, 0.242357, 2.842418>,
				< 1.881657, 0.178815, 3.044416>,
				< 1.881657, 0.221494, 2.843490>
			}
			triangle {
				< 1.947582, 0.242357, 2.842418>,
				< 1.947581, 0.197416, 3.053882>,
				< 1.881657, 0.178815, 3.044416>
			}
			triangle {
				< 1.947581, 0.197416, 3.053882>,
				< 1.881657, 0.041402, 3.197040>,
				< 1.881657, 0.178815, 3.044416>
			}
			triangle {
				< 1.947581, 0.197416, 3.053882>,
				< 1.947581, 0.052770, 3.214569>,
				< 1.881657, 0.041402, 3.197040>
			}
			triangle {
				< 1.947581, 0.052770, 3.214569>,
				< 1.881656, -0.153930, 3.260524>,
				< 1.881657, 0.041402, 3.197040>
			}
			triangle {
				< 1.947581, 0.052770, 3.214569>,
				< 1.947581, -0.152860, 3.281387>,
				< 1.881656, -0.153930, 3.260524>
			}
			triangle {
				< 1.947581, -0.152860, 3.281387>,
				< 1.881656, -0.354858, 3.217845>,
				< 1.881656, -0.153930, 3.260524>
			}
			triangle {
				< 1.947581, -0.152860, 3.281387>,
				< 1.947580, -0.364322, 3.236446>,
				< 1.881656, -0.354858, 3.217845>
			}
			triangle {
				< 1.947580, -0.364322, 3.236446>,
				< 1.881655, -0.507483, 3.080401>,
				< 1.881656, -0.354858, 3.217845>
			}
			triangle {
				< 1.947580, -0.364322, 3.236446>,
				< 1.947579, -0.525012, 3.091800>,
				< 1.881655, -0.507483, 3.080401>
			}
			triangle {
				< 1.947579, -0.525012, 3.091800>,
				< 1.881654, -0.570967, 2.885069>,
				< 1.881655, -0.507483, 3.080401>
			}
			triangle {
				< 1.947579, -0.525012, 3.091800>,
				< 1.947578, -0.591830, 2.886170>,
				< 1.881654, -0.570967, 2.885069>
			}
			triangle {
				< 1.947578, -0.591830, 2.886170>,
				< 1.881654, -0.528288, 2.684172>,
				< 1.881654, -0.570967, 2.885069>
			}
			triangle {
				< 1.947578, -0.591830, 2.886170>,
				< 1.947578, -0.546889, 2.674708>,
				< 1.881654, -0.528288, 2.684172>
			}
			triangle {
				< 1.947578, -0.546889, 2.674708>,
				< 1.881654, -0.390844, 2.531519>,
				< 1.881654, -0.528288, 2.684172>
			}
			triangle {
				< 1.947578, -0.546889, 2.674708>,
				< 1.947578, -0.402243, 2.514019>,
				< 1.881654, -0.390844, 2.531519>
			}
			triangle {
				< 1.947578, -0.402243, 2.514019>,
				< 1.881655, -0.195512, 2.468063>,
				< 1.881654, -0.390844, 2.531519>
			}
			triangle {
				< 1.947578, -0.402243, 2.514019>,
				< 1.947579, -0.196613, 2.447201>,
				< 1.881655, -0.195512, 2.468063>
			}
			triangle {
				< 1.947579, -0.196613, 2.447201>,
				< 1.881656, 0.005386, 2.510743>,
				< 1.881655, -0.195512, 2.468063>
			}
			triangle {
				< 1.947579, -0.196613, 2.447201>,
				< 1.947580, 0.014851, 2.492141>,
				< 1.881656, 0.005386, 2.510743>
			}
			triangle {
				< 1.947580, 0.014851, 2.492141>,
				< 1.881657, 0.158039, 2.648156>,
				< 1.881656, 0.005386, 2.510743>
			}
			triangle {
				< 1.947580, 0.014851, 2.492141>,
				< 1.947581, 0.175541, 2.636787>,
				< 1.881657, 0.158039, 2.648156>
			}
			triangle {
				< 1.881657, 0.221494, 2.843490>,
				< 1.881657, 0.158039, 2.648156>,
				< 1.947581, 0.175541, 2.636787>
			}
			triangle {
				< 1.881657, 0.221494, 2.843490>,
				< 1.947581, 0.175541, 2.636787>,
				< 1.947582, 0.242357, 2.842418>
			}
			texture{_ICP26_Yellow}
		}
		// _ICP26_Red
		union {
			triangle {
				< 1.292797, 0.267405, -2.524946>,
				< 1.828524, 0.206332, -2.290685>,
				< 1.828524, 0.282196, -2.524173>
			}
			triangle {
				< 1.292797, 0.267405, -2.524946>,
				< 1.292797, 0.193922, -2.298780>,
				< 1.828524, 0.206332, -2.290685>
			}
			triangle {
				< 1.292797, 0.193922, -2.298780>,
				< 1.828524, 0.023916, -2.126424>,
				< 1.828524, 0.206332, -2.290685>
			}
			triangle {
				< 1.292797, 0.193922, -2.298780>,
				< 1.292797, 0.017163, -2.139638>,
				< 1.828524, 0.023916, -2.126424>
			}
			triangle {
				< 1.292797, 0.017163, -2.139638>,
				< 1.828523, -0.216238, -2.075380>,
				< 1.828524, 0.023916, -2.126424>
			}
			triangle {
				< 1.292797, 0.017163, -2.139638>,
				< 1.292796, -0.215462, -2.090202>,
				< 1.828523, -0.216238, -2.075380>
			}
			triangle {
				< 1.292796, -0.215462, -2.090202>,
				< 1.828522, -0.449696, -2.151245>,
				< 1.828523, -0.216238, -2.075380>
			}
			triangle {
				< 1.292796, -0.215462, -2.090202>,
				< 1.292795, -0.441629, -2.163685>,
				< 1.828522, -0.449696, -2.151245>
			}
			triangle {
				< 1.292795, -0.441629, -2.163685>,
				< 1.828521, -0.613987, -2.333690>,
				< 1.828522, -0.449696, -2.151245>
			}
			triangle {
				< 1.292795, -0.441629, -2.163685>,
				< 1.292794, -0.600769, -2.340416>,
				< 1.828521, -0.613987, -2.333690>
			}
			triangle {
				< 1.292794, -0.600769, -2.340416>,
				< 1.828521, -0.665031, -2.573815>,
				< 1.828521, -0.613987, -2.333690>
			}
			triangle {
				< 1.292794, -0.600769, -2.340416>,
				< 1.292793, -0.650207, -2.573041>,
				< 1.828521, -0.665031, -2.573815>
			}
			triangle {
				< 1.292793, -0.650207, -2.573041>,
				< 1.828520, -0.589167, -2.807303>,
				< 1.828521, -0.665031, -2.573815>
			}
			triangle {
				< 1.292793, -0.650207, -2.573041>,
				< 1.292793, -0.576724, -2.799207>,
				< 1.828520, -0.589167, -2.807303>
			}
			triangle {
				< 1.292793, -0.576724, -2.799207>,
				< 1.828521, -0.406722, -2.971562>,
				< 1.828520, -0.589167, -2.807303>
			}
			triangle {
				< 1.292793, -0.576724, -2.799207>,
				< 1.292794, -0.399993, -2.958348>,
				< 1.828521, -0.406722, -2.971562>
			}
			triangle {
				< 1.292794, -0.399993, -2.958348>,
				< 1.828522, -0.166596, -3.022606>,
				< 1.828521, -0.406722, -2.971562>
			}
			triangle {
				< 1.292794, -0.399993, -2.958348>,
				< 1.292795, -0.167368, -3.007814>,
				< 1.828522, -0.166596, -3.022606>
			}
			triangle {
				< 1.292795, -0.167368, -3.007814>,
				< 1.828522, 0.066892, -2.946741>,
				< 1.828522, -0.166596, -3.022606>
			}
			triangle {
				< 1.292795, -0.167368, -3.007814>,
				< 1.292796, 0.058827, -2.934300>,
				< 1.828522, 0.066892, -2.946741>
			}
			triangle {
				< 1.292796, 0.058827, -2.934300>,
				< 1.828524, 0.231153, -2.764297>,
				< 1.828522, 0.066892, -2.946741>
			}
			triangle {
				< 1.292796, 0.058827, -2.934300>,
				< 1.292797, 0.217939, -2.757571>,
				< 1.828524, 0.231153, -2.764297>
			}
			triangle {
				< 1.828524, 0.282196, -2.524173>,
				< 1.828524, 0.231153, -2.764297>,
				< 1.292797, 0.217939, -2.757571>
			}
			triangle {
				< 1.828524, 0.282196, -2.524173>,
				< 1.292797, 0.217939, -2.757571>,
				< 1.292797, 0.267405, -2.524946>
			}
			triangle {
				< 1.024964, 0.236870, -2.526552>,
				< 1.292797, 0.193922, -2.298780>,
				< 1.292797, 0.267405, -2.524946>
			}
			triangle {
				< 1.024964, 0.236870, -2.526552>,
				< 1.024964, 0.168268, -2.315417>,
				< 1.292797, 0.193922, -2.298780>
			}
			triangle {
				< 1.024964, 0.168268, -2.315417>,
				< 1.292797, 0.017163, -2.139638>,
				< 1.292797, 0.193922, -2.298780>
			}
			triangle {
				< 1.024964, 0.168268, -2.315417>,
				< 1.024964, 0.003294, -2.166871>,
				< 1.292797, 0.017163, -2.139638>
			}
			triangle {
				< 1.024964, 0.003294, -2.166871>,
				< 1.292796, -0.215462, -2.090202>,
				< 1.292797, 0.017163, -2.139638>
			}
			triangle {
				< 1.024964, 0.003294, -2.166871>,
				< 1.024963, -0.213853, -2.120709>,
				< 1.292796, -0.215462, -2.090202>
			}
			triangle {
				< 1.024963, -0.213853, -2.120709>,
				< 1.292795, -0.441629, -2.163685>,
				< 1.292796, -0.215462, -2.090202>
			}
			triangle {
				< 1.024963, -0.213853, -2.120709>,
				< 1.024962, -0.424991, -2.189311>,
				< 1.292795, -0.441629, -2.163685>
			}
			triangle {
				< 1.024962, -0.424991, -2.189311>,
				< 1.292794, -0.600769, -2.340416>,
				< 1.292795, -0.441629, -2.163685>
			}
			triangle {
				< 1.024962, -0.424991, -2.189311>,
				< 1.024961, -0.573536, -2.354283>,
				< 1.292794, -0.600769, -2.340416>
			}
			triangle {
				< 1.024961, -0.573536, -2.354283>,
				< 1.292793, -0.650207, -2.573041>,
				< 1.292794, -0.600769, -2.340416>
			}
			triangle {
				< 1.024961, -0.573536, -2.354283>,
				< 1.024961, -0.619698, -2.571433>,
				< 1.292793, -0.650207, -2.573041>
			}
			triangle {
				< 1.024961, -0.619698, -2.571433>,
				< 1.292793, -0.576724, -2.799207>,
				< 1.292793, -0.650207, -2.573041>
			}
			triangle {
				< 1.024961, -0.619698, -2.571433>,
				< 1.024961, -0.551096, -2.782568>,
				< 1.292793, -0.576724, -2.799207>
			}
			triangle {
				< 1.024961, -0.551096, -2.782568>,
				< 1.292794, -0.399993, -2.958348>,
				< 1.292793, -0.576724, -2.799207>
			}
			triangle {
				< 1.024961, -0.551096, -2.782568>,
				< 1.024961, -0.386122, -2.931115>,
				< 1.292794, -0.399993, -2.958348>
			}
			triangle {
				< 1.024961, -0.386122, -2.931115>,
				< 1.292795, -0.167368, -3.007814>,
				< 1.292794, -0.399993, -2.958348>
			}
			triangle {
				< 1.024961, -0.386122, -2.931115>,
				< 1.024962, -0.168975, -2.977278>,
				< 1.292795, -0.167368, -3.007814>
			}
			triangle {
				< 1.024962, -0.168975, -2.977278>,
				< 1.292796, 0.058827, -2.934300>,
				< 1.292795, -0.167368, -3.007814>
			}
			triangle {
				< 1.024962, -0.168975, -2.977278>,
				< 1.024963, 0.042162, -2.908674>,
				< 1.292796, 0.058827, -2.934300>
			}
			triangle {
				< 1.024963, 0.042162, -2.908674>,
				< 1.292797, 0.217939, -2.757571>,
				< 1.292796, 0.058827, -2.934300>
			}
			triangle {
				< 1.024963, 0.042162, -2.908674>,
				< 1.024964, 0.190738, -2.743701>,
				< 1.292797, 0.217939, -2.757571>
			}
			triangle {
				< 1.292797, 0.267405, -2.524946>,
				< 1.292797, 0.217939, -2.757571>,
				< 1.024964, 0.190738, -2.743701>
			}
			triangle {
				< 1.292797, 0.267405, -2.524946>,
				< 1.024964, 0.190738, -2.743701>,
				< 1.024964, 0.236870, -2.526552>
			}
			triangle {
				< 0.763529, 0.202764, -2.528338>,
				< 1.024964, 0.168268, -2.315417>,
				< 1.024964, 0.236870, -2.526552>
			}
			triangle {
				< 0.763529, 0.202764, -2.528338>,
				< 0.763529, 0.139608, -2.334017>,
				< 1.024964, 0.168268, -2.315417>
			}
			triangle {
				< 0.763529, 0.139608, -2.334017>,
				< 1.024964, 0.003294, -2.166871>,
				< 1.024964, 0.168268, -2.315417>
			}
			triangle {
				< 0.763529, 0.139608, -2.334017>,
				< 0.763529, -0.012212, -2.197317>,
				< 1.024964, 0.003294, -2.166871>
			}
			triangle {
				< 0.763529, -0.012212, -2.197317>,
				< 1.024963, -0.213853, -2.120709>,
				< 1.024964, 0.003294, -2.166871>
			}
			triangle {
				< 0.763529, -0.012212, -2.197317>,
				< 0.763528, -0.212068, -2.154846>,
				< 1.024963, -0.213853, -2.120709>
			}
			triangle {
				< 0.763528, -0.212068, -2.154846>,
				< 1.024962, -0.424991, -2.189311>,
				< 1.024963, -0.213853, -2.120709>
			}
			triangle {
				< 0.763528, -0.212068, -2.154846>,
				< 0.763527, -0.406358, -2.217972>,
				< 1.024962, -0.424991, -2.189311>
			}
			triangle {
				< 0.763527, -0.406358, -2.217972>,
				< 1.024961, -0.573536, -2.354283>,
				< 1.024962, -0.424991, -2.189311>
			}
			triangle {
				< 0.763527, -0.406358, -2.217972>,
				< 0.763526, -0.543088, -2.369820>,
				< 1.024961, -0.573536, -2.354283>
			}
			triangle {
				< 0.763526, -0.543088, -2.369820>,
				< 1.024961, -0.619698, -2.571433>,
				< 1.024961, -0.573536, -2.354283>
			}
			triangle {
				< 0.763526, -0.543088, -2.369820>,
				< 0.763526, -0.585559, -2.569645>,
				< 1.024961, -0.619698, -2.571433>
			}
			triangle {
				< 0.763526, -0.585559, -2.569645>,
				< 1.024961, -0.551096, -2.782568>,
				< 1.024961, -0.619698, -2.571433>
			}
			triangle {
				< 0.763526, -0.585559, -2.569645>,
				< 0.763526, -0.522434, -2.763966>,
				< 1.024961, -0.551096, -2.782568>
			}
			triangle {
				< 0.763526, -0.522434, -2.763966>,
				< 1.024961, -0.386122, -2.931115>,
				< 1.024961, -0.551096, -2.782568>
			}
			triangle {
				< 0.763526, -0.522434, -2.763966>,
				< 0.763526, -0.370586, -2.900666>,
				< 1.024961, -0.386122, -2.931115>
			}
			triangle {
				< 0.763526, -0.370586, -2.900666>,
				< 1.024962, -0.168975, -2.977278>,
				< 1.024961, -0.386122, -2.931115>
			}
			triangle {
				< 0.763526, -0.370586, -2.900666>,
				< 0.763527, -0.170758, -2.943139>,
				< 1.024962, -0.168975, -2.977278>
			}
			triangle {
				< 0.763527, -0.170758, -2.943139>,
				< 1.024963, 0.042162, -2.908674>,
				< 1.024962, -0.168975, -2.977278>
			}
			triangle {
				< 0.763527, -0.170758, -2.943139>,
				< 0.763528, 0.023563, -2.880013>,
				< 1.024963, 0.042162, -2.908674>
			}
			triangle {
				< 0.763528, 0.023563, -2.880013>,
				< 1.024964, 0.190738, -2.743701>,
				< 1.024963, 0.042162, -2.908674>
			}
			triangle {
				< 0.763528, 0.023563, -2.880013>,
				< 0.763529, 0.160262, -2.728194>,
				< 1.024964, 0.190738, -2.743701>
			}
			triangle {
				< 1.024964, 0.236870, -2.526552>,
				< 1.024964, 0.190738, -2.743701>,
				< 0.763529, 0.160262, -2.728194>
			}
			triangle {
				< 1.024964, 0.236870, -2.526552>,
				< 0.763529, 0.160262, -2.728194>,
				< 0.763529, 0.202764, -2.528338>
			}
			triangle {
				< 0.578524, 0.146453, -2.531284>,
				< 0.763529, 0.139608, -2.334017>,
				< 0.763529, 0.202764, -2.528338>
			}
			triangle {
				< 0.578524, 0.146453, -2.531284>,
				< 0.578523, 0.092315, -2.364733>,
				< 0.763529, 0.139608, -2.334017>
			}
			triangle {
				< 0.578523, 0.092315, -2.364733>,
				< 0.763529, -0.012212, -2.197317>,
				< 0.763529, 0.139608, -2.334017>
			}
			triangle {
				< 0.578523, 0.092315, -2.364733>,
				< 0.578523, -0.037807, -2.247556>,
				< 0.763529, -0.012212, -2.197317>
			}
			triangle {
				< 0.578523, -0.037807, -2.247556>,
				< 0.763528, -0.212068, -2.154846>,
				< 0.763529, -0.012212, -2.197317>
			}
			triangle {
				< 0.578523, -0.037807, -2.247556>,
				< 0.578522, -0.209121, -2.211156>,
				< 0.763528, -0.212068, -2.154846>
			}
			triangle {
				< 0.578522, -0.209121, -2.211156>,
				< 0.763527, -0.406358, -2.217972>,
				< 0.763528, -0.212068, -2.154846>
			}
			triangle {
				< 0.578522, -0.209121, -2.211156>,
				< 0.578522, -0.375672, -2.265265>,
				< 0.763527, -0.406358, -2.217972>
			}
			triangle {
				< 0.578522, -0.375672, -2.265265>,
				< 0.763526, -0.543088, -2.369820>,
				< 0.763527, -0.406358, -2.217972>
			}
			triangle {
				< 0.578522, -0.375672, -2.265265>,
				< 0.578521, -0.492848, -2.395416>,
				< 0.763526, -0.543088, -2.369820>
			}
			triangle {
				< 0.578521, -0.492848, -2.395416>,
				< 0.763526, -0.585559, -2.569645>,
				< 0.763526, -0.543088, -2.369820>
			}
			triangle {
				< 0.578521, -0.492848, -2.395416>,
				< 0.578521, -0.529249, -2.566699>,
				< 0.763526, -0.585559, -2.569645>
			}
			triangle {
				< 0.578521, -0.529249, -2.566699>,
				< 0.763526, -0.522434, -2.763966>,
				< 0.763526, -0.585559, -2.569645>
			}
			triangle {
				< 0.578521, -0.529249, -2.566699>,
				< 0.578521, -0.475140, -2.733252>,
				< 0.763526, -0.522434, -2.763966>
			}
			triangle {
				< 0.578521, -0.475140, -2.733252>,
				< 0.763526, -0.370586, -2.900666>,
				< 0.763526, -0.522434, -2.763966>
			}
			triangle {
				< 0.578521, -0.475140, -2.733252>,
				< 0.578521, -0.344989, -2.850427>,
				< 0.763526, -0.370586, -2.900666>
			}
			triangle {
				< 0.578521, -0.344989, -2.850427>,
				< 0.763527, -0.170758, -2.943139>,
				< 0.763526, -0.370586, -2.900666>
			}
			triangle {
				< 0.578521, -0.344989, -2.850427>,
				< 0.578522, -0.173704, -2.886858>,
				< 0.763527, -0.170758, -2.943139>
			}
			triangle {
				< 0.578522, -0.173704, -2.886858>,
				< 0.763528, 0.023563, -2.880013>,
				< 0.763527, -0.170758, -2.943139>
			}
			triangle {
				< 0.578522, -0.173704, -2.886858>,
				< 0.578523, -0.007153, -2.832720>,
				< 0.763528, 0.023563, -2.880013>
			}
			triangle {
				< 0.578523, -0.007153, -2.832720>,
				< 0.763529, 0.160262, -2.728194>,
				< 0.763528, 0.023563, -2.880013>
			}
			triangle {
				< 0.578523, -0.007153, -2.832720>,
				< 0.578523, 0.110024, -2.702598>,
				< 0.763529, 0.160262, -2.728194>
			}
			triangle {
				< 0.763529, 0.202764, -2.528338>,
				< 0.763529, 0.160262, -2.728194>,
				< 0.578523, 0.110024, -2.702598>
			}
			triangle {
				< 0.763529, 0.202764, -2.528338>,
				< 0.578523, 0.110024, -2.702598>,
				< 0.578524, 0.146453, -2.531284>
			}
			triangle {
				< 0.763529, 0.165203, -2.530301>,
				< 0.578523, 0.092315, -2.364733>,
				< 0.578524, 0.146453, -2.531284>
			}
			triangle {
				< 0.763529, 0.165203, -2.530301>,
				< 0.763529, 0.108089, -2.354494>,
				< 0.578523, 0.092315, -2.364733>
			}
			triangle {
				< 0.763529, 0.108089, -2.354494>,
				< 0.578523, -0.037807, -2.247556>,
				< 0.578523, 0.092315, -2.364733>
			}
			triangle {
				< 0.763529, 0.108089, -2.354494>,
				< 0.763528, -0.029296, -2.230802>,
				< 0.578523, -0.037807, -2.247556>
			}
			triangle {
				< 0.763528, -0.029296, -2.230802>,
				< 0.578522, -0.209121, -2.211156>,
				< 0.578523, -0.037807, -2.247556>
			}
			triangle {
				< 0.763528, -0.029296, -2.230802>,
				< 0.763528, -0.210104, -2.192377>,
				< 0.578522, -0.209121, -2.211156>
			}
			triangle {
				< 0.763528, -0.210104, -2.192377>,
				< 0.578522, -0.375672, -2.265265>,
				< 0.578522, -0.209121, -2.211156>
			}
			triangle {
				< 0.763528, -0.210104, -2.192377>,
				< 0.763527, -0.385912, -2.249491>,
				< 0.578522, -0.375672, -2.265265>
			}
			triangle {
				< 0.763527, -0.385912, -2.249491>,
				< 0.578521, -0.492848, -2.395416>,
				< 0.578522, -0.375672, -2.265265>
			}
			triangle {
				< 0.763527, -0.385912, -2.249491>,
				< 0.763526, -0.509576, -2.386874>,
				< 0.578521, -0.492848, -2.395416>
			}
			triangle {
				< 0.763526, -0.509576, -2.386874>,
				< 0.578521, -0.529249, -2.566699>,
				< 0.578521, -0.492848, -2.395416>
			}
			triangle {
				< 0.763526, -0.509576, -2.386874>,
				< 0.763526, -0.548029, -2.567682>,
				< 0.578521, -0.529249, -2.566699>
			}
			triangle {
				< 0.763526, -0.548029, -2.567682>,
				< 0.578521, -0.475140, -2.733252>,
				< 0.578521, -0.529249, -2.566699>
			}
			triangle {
				< 0.763526, -0.548029, -2.567682>,
				< 0.763526, -0.490885, -2.743490>,
				< 0.578521, -0.475140, -2.733252>
			}
			triangle {
				< 0.763526, -0.490885, -2.743490>,
				< 0.578521, -0.344989, -2.850427>,
				< 0.578521, -0.475140, -2.733252>
			}
			triangle {
				< 0.763526, -0.490885, -2.743490>,
				< 0.763526, -0.353532, -2.867184>,
				< 0.578521, -0.344989, -2.850427>
			}
			triangle {
				< 0.763526, -0.353532, -2.867184>,
				< 0.578522, -0.173704, -2.886858>,
				< 0.578521, -0.344989, -2.850427>
			}
			triangle {
				< 0.763526, -0.353532, -2.867184>,
				< 0.763527, -0.172724, -2.905609>,
				< 0.578522, -0.173704, -2.886858>
			}
			triangle {
				< 0.763527, -0.172724, -2.905609>,
				< 0.578523, -0.007153, -2.832720>,
				< 0.578522, -0.173704, -2.886858>
			}
			triangle {
				< 0.763527, -0.172724, -2.905609>,
				< 0.763528, 0.003086, -2.848495>,
				< 0.578523, -0.007153, -2.832720>
			}
			triangle {
				< 0.763528, 0.003086, -2.848495>,
				< 0.578523, 0.110024, -2.702598>,
				< 0.578523, -0.007153, -2.832720>
			}
			triangle {
				< 0.763528, 0.003086, -2.848495>,
				< 0.763528, 0.126778, -2.711110>,
				< 0.578523, 0.110024, -2.702598>
			}
			triangle {
				< 0.578524, 0.146453, -2.531284>,
				< 0.578523, 0.110024, -2.702598>,
				< 0.763528, 0.126778, -2.711110>
			}
			triangle {
				< 0.578524, 0.146453, -2.531284>,
				< 0.763528, 0.126778, -2.711110>,
				< 0.763529, 0.165203, -2.530301>
			}
			triangle {
				< 1.024964, 0.168625, -2.530123>,
				< 0.763529, 0.108089, -2.354494>,
				< 0.763529, 0.165203, -2.530301>
			}
			triangle {
				< 1.024964, 0.168625, -2.530123>,
				< 1.024964, 0.110945, -2.352649>,
				< 0.763529, 0.108089, -2.354494>
			}
			triangle {
				< 1.024964, 0.110945, -2.352649>,
				< 0.763528, -0.029296, -2.230802>,
				< 0.763529, 0.108089, -2.354494>
			}
			triangle {
				< 1.024964, 0.110945, -2.352649>,
				< 1.024964, -0.027748, -2.227765>,
				< 0.763528, -0.029296, -2.230802>
			}
			triangle {
				< 1.024964, -0.027748, -2.227765>,
				< 0.763528, -0.210104, -2.192377>,
				< 0.763528, -0.029296, -2.230802>
			}
			triangle {
				< 1.024964, -0.027748, -2.227765>,
				< 1.024963, -0.210282, -2.188982>,
				< 0.763528, -0.210104, -2.192377>
			}
			triangle {
				< 1.024963, -0.210282, -2.188982>,
				< 0.763527, -0.385912, -2.249491>,
				< 0.763528, -0.210104, -2.192377>
			}
			triangle {
				< 1.024963, -0.210282, -2.188982>,
				< 1.024962, -0.387759, -2.246634>,
				< 0.763527, -0.385912, -2.249491>
			}
			triangle {
				< 1.024962, -0.387759, -2.246634>,
				< 0.763526, -0.509576, -2.386874>,
				< 0.763527, -0.385912, -2.249491>
			}
			triangle {
				< 1.024962, -0.387759, -2.246634>,
				< 1.024961, -0.512613, -2.385327>,
				< 0.763526, -0.509576, -2.386874>
			}
			triangle {
				< 1.024961, -0.512613, -2.385327>,
				< 0.763526, -0.548029, -2.567682>,
				< 0.763526, -0.509576, -2.386874>
			}
			triangle {
				< 1.024961, -0.512613, -2.385327>,
				< 1.024961, -0.551423, -2.567861>,
				< 0.763526, -0.548029, -2.567682>
			}
			triangle {
				< 1.024961, -0.551423, -2.567861>,
				< 0.763526, -0.490885, -2.743490>,
				< 0.763526, -0.548029, -2.567682>
			}
			triangle {
				< 1.024961, -0.551423, -2.567861>,
				< 1.024961, -0.493745, -2.745336>,
				< 0.763526, -0.490885, -2.743490>
			}
			triangle {
				< 1.024961, -0.493745, -2.745336>,
				< 0.763526, -0.353532, -2.867184>,
				< 0.763526, -0.490885, -2.743490>
			}
			triangle {
				< 1.024961, -0.493745, -2.745336>,
				< 1.024961, -0.355080, -2.870220>,
				< 0.763526, -0.353532, -2.867184>
			}
			triangle {
				< 1.024961, -0.355080, -2.870220>,
				< 0.763527, -0.172724, -2.905609>,
				< 0.763526, -0.353532, -2.867184>
			}
			triangle {
				< 1.024961, -0.355080, -2.870220>,
				< 1.024962, -0.172546, -2.909030>,
				< 0.763527, -0.172724, -2.905609>
			}
			triangle {
				< 1.024962, -0.172546, -2.909030>,
				< 0.763528, 0.003086, -2.848495>,
				< 0.763527, -0.172724, -2.905609>
			}
			triangle {
				< 1.024962, -0.172546, -2.909030>,
				< 1.024963, 0.004928, -2.851352>,
				< 0.763528, 0.003086, -2.848495>
			}
			triangle {
				< 1.024963, 0.004928, -2.851352>,
				< 0.763528, 0.126778, -2.711110>,
				< 0.763528, 0.003086, -2.848495>
			}
			triangle {
				< 1.024963, 0.004928, -2.851352>,
				< 1.024964, 0.129813, -2.712658>,
				< 0.763528, 0.126778, -2.711110>
			}
			triangle {
				< 0.763529, 0.165203, -2.530301>,
				< 0.763528, 0.126778, -2.711110>,
				< 1.024964, 0.129813, -2.712658>
			}
			triangle {
				< 0.763529, 0.165203, -2.530301>,
				< 1.024964, 0.129813, -2.712658>,
				< 1.024964, 0.168625, -2.530123>
			}
			triangle {
				< 1.292797, 0.183980, -2.529322>,
				< 1.024964, 0.110945, -2.352649>,
				< 1.024964, 0.168625, -2.530123>
			}
			triangle {
				< 1.292797, 0.183980, -2.529322>,
				< 1.292797, 0.123862, -2.344257>,
				< 1.024964, 0.110945, -2.352649>
			}
			triangle {
				< 1.292797, 0.123862, -2.344257>,
				< 1.024964, -0.027748, -2.227765>,
				< 1.024964, 0.110945, -2.352649>
			}
			triangle {
				< 1.292797, 0.123862, -2.344257>,
				< 1.292797, -0.020756, -2.214074>,
				< 1.024964, -0.027748, -2.227765>
			}
			triangle {
				< 1.292797, -0.020756, -2.214074>,
				< 1.024963, -0.210282, -2.188982>,
				< 1.024964, -0.027748, -2.227765>
			}
			triangle {
				< 1.292797, -0.020756, -2.214074>,
				< 1.292796, -0.211087, -2.173627>,
				< 1.024963, -0.210282, -2.188982>
			}
			triangle {
				< 1.292796, -0.211087, -2.173627>,
				< 1.024962, -0.387759, -2.246634>,
				< 1.024963, -0.210282, -2.188982>
			}
			triangle {
				< 1.292796, -0.211087, -2.173627>,
				< 1.292795, -0.396123, -2.233748>,
				< 1.024962, -0.387759, -2.246634>
			}
			triangle {
				< 1.292795, -0.396123, -2.233748>,
				< 1.024961, -0.512613, -2.385327>,
				< 1.024962, -0.387759, -2.246634>
			}
			triangle {
				< 1.292795, -0.396123, -2.233748>,
				< 1.292794, -0.526333, -2.378333>,
				< 1.024961, -0.512613, -2.385327>
			}
			triangle {
				< 1.292794, -0.526333, -2.378333>,
				< 1.024961, -0.551423, -2.567861>,
				< 1.024961, -0.512613, -2.385327>
			}
			triangle {
				< 1.292794, -0.526333, -2.378333>,
				< 1.292794, -0.566782, -2.568666>,
				< 1.024961, -0.551423, -2.567861>
			}
			triangle {
				< 1.292794, -0.566782, -2.568666>,
				< 1.024961, -0.493745, -2.745336>,
				< 1.024961, -0.551423, -2.567861>
			}
			triangle {
				< 1.292794, -0.566782, -2.568666>,
				< 1.292794, -0.506661, -2.753730>,
				< 1.024961, -0.493745, -2.745336>
			}
			triangle {
				< 1.292794, -0.506661, -2.753730>,
				< 1.024961, -0.355080, -2.870220>,
				< 1.024961, -0.493745, -2.745336>
			}
			triangle {
				< 1.292794, -0.506661, -2.753730>,
				< 1.292794, -0.362074, -2.883912>,
				< 1.024961, -0.355080, -2.870220>
			}
			triangle {
				< 1.292794, -0.362074, -2.883912>,
				< 1.024962, -0.172546, -2.909030>,
				< 1.024961, -0.355080, -2.870220>
			}
			triangle {
				< 1.292794, -0.362074, -2.883912>,
				< 1.292795, -0.171743, -2.924389>,
				< 1.024962, -0.172546, -2.909030>
			}
			triangle {
				< 1.292795, -0.171743, -2.924389>,
				< 1.024963, 0.004928, -2.851352>,
				< 1.024962, -0.172546, -2.909030>
			}
			triangle {
				< 1.292795, -0.171743, -2.924389>,
				< 1.292796, 0.013321, -2.864270>,
				< 1.024963, 0.004928, -2.851352>
			}
			triangle {
				< 1.292796, 0.013321, -2.864270>,
				< 1.024964, 0.129813, -2.712658>,
				< 1.024963, 0.004928, -2.851352>
			}
			triangle {
				< 1.292796, 0.013321, -2.864270>,
				< 1.292797, 0.143533, -2.719653>,
				< 1.024964, 0.129813, -2.712658>
			}
			triangle {
				< 1.024964, 0.168625, -2.530123>,
				< 1.024964, 0.129813, -2.712658>,
				< 1.292797, 0.143533, -2.719653>
			}
			triangle {
				< 1.024964, 0.168625, -2.530123>,
				< 1.292797, 0.143533, -2.719653>,
				< 1.292797, 0.183980, -2.529322>
			}
			triangle {
				< 1.828524, 0.206717, -2.528131>,
				< 1.292797, 0.123862, -2.344257>,
				< 1.292797, 0.183980, -2.529322>
			}
			triangle {
				< 1.828524, 0.206717, -2.528131>,
				< 1.828524, 0.142937, -2.331876>,
				< 1.292797, 0.123862, -2.344257>
			}
			triangle {
				< 1.828524, 0.142937, -2.331876>,
				< 1.292797, -0.020756, -2.214074>,
				< 1.292797, 0.123862, -2.344257>
			}
			triangle {
				< 1.828524, 0.142937, -2.331876>,
				< 1.828523, -0.010429, -2.193778>,
				< 1.292797, -0.020756, -2.214074>
			}
			triangle {
				< 1.828523, -0.010429, -2.193778>,
				< 1.292796, -0.211087, -2.173627>,
				< 1.292797, -0.020756, -2.214074>
			}
			triangle {
				< 1.828523, -0.010429, -2.193778>,
				< 1.828523, -0.212281, -2.150888>,
				< 1.292796, -0.211087, -2.173627>
			}
			triangle {
				< 1.828523, -0.212281, -2.150888>,
				< 1.292795, -0.396123, -2.233748>,
				< 1.292796, -0.211087, -2.173627>
			}
			triangle {
				< 1.828523, -0.212281, -2.150888>,
				< 1.828522, -0.408535, -2.214640>,
				< 1.292795, -0.396123, -2.233748>
			}
			triangle {
				< 1.828522, -0.408535, -2.214640>,
				< 1.292794, -0.526333, -2.378333>,
				< 1.292795, -0.396123, -2.233748>
			}
			triangle {
				< 1.828522, -0.408535, -2.214640>,
				< 1.828521, -0.546605, -2.368006>,
				< 1.292794, -0.526333, -2.378333>
			}
			triangle {
				< 1.828521, -0.546605, -2.368006>,
				< 1.292794, -0.566782, -2.568666>,
				< 1.292794, -0.526333, -2.378333>
			}
			triangle {
				< 1.828521, -0.546605, -2.368006>,
				< 1.828521, -0.589523, -2.569856>,
				< 1.292794, -0.566782, -2.568666>
			}
			triangle {
				< 1.828521, -0.589523, -2.569856>,
				< 1.292794, -0.506661, -2.753730>,
				< 1.292794, -0.566782, -2.568666>
			}
			triangle {
				< 1.828521, -0.589523, -2.569856>,
				< 1.828521, -0.525742, -2.766112>,
				< 1.292794, -0.506661, -2.753730>
			}
			triangle {
				< 1.828521, -0.525742, -2.766112>,
				< 1.292794, -0.362074, -2.883912>,
				< 1.292794, -0.506661, -2.753730>
			}
			triangle {
				< 1.828521, -0.525742, -2.766112>,
				< 1.828521, -0.372405, -2.904211>,
				< 1.292794, -0.362074, -2.883912>
			}
			triangle {
				< 1.828521, -0.372405, -2.904211>,
				< 1.292795, -0.171743, -2.924389>,
				< 1.292794, -0.362074, -2.883912>
			}
			triangle {
				< 1.828521, -0.372405, -2.904211>,
				< 1.828522, -0.170556, -2.947128>,
				< 1.292795, -0.171743, -2.924389>
			}
			triangle {
				< 1.828522, -0.170556, -2.947128>,
				< 1.292796, 0.013321, -2.864270>,
				< 1.292795, -0.171743, -2.924389>
			}
			triangle {
				< 1.828522, -0.170556, -2.947128>,
				< 1.828523, 0.025731, -2.883347>,
				< 1.292796, 0.013321, -2.864270>
			}
			triangle {
				< 1.828523, 0.025731, -2.883347>,
				< 1.292797, 0.143533, -2.719653>,
				< 1.292796, 0.013321, -2.864270>
			}
			triangle {
				< 1.828523, 0.025731, -2.883347>,
				< 1.828523, 0.163799, -2.729980>,
				< 1.292797, 0.143533, -2.719653>
			}
			triangle {
				< 1.292797, 0.183980, -2.529322>,
				< 1.292797, 0.143533, -2.719653>,
				< 1.828523, 0.163799, -2.729980>
			}
			triangle {
				< 1.292797, 0.183980, -2.529322>,
				< 1.828523, 0.163799, -2.729980>,
				< 1.828524, 0.206717, -2.528131>
			}
			triangle {
				< 1.292804, 0.284087, 2.840215>,
				< 1.828532, 0.247864, 3.079567>,
				< 1.828531, 0.298877, 2.839441>
			}
			triangle {
				< 1.292804, 0.284087, 2.840215>,
				< 1.292804, 0.234653, 3.072840>,
				< 1.828532, 0.247864, 3.079567>
			}
			triangle {
				< 1.292804, 0.234653, 3.072840>,
				< 1.828531, 0.083605, 3.262012>,
				< 1.828532, 0.247864, 3.079567>
			}
			triangle {
				< 1.292804, 0.234653, 3.072840>,
				< 1.292804, 0.075511, 3.249601>,
				< 1.828531, 0.083605, 3.262012>
			}
			triangle {
				< 1.292804, 0.075511, 3.249601>,
				< 1.828530, -0.149883, 3.337907>,
				< 1.828531, 0.083605, 3.262012>
			}
			triangle {
				< 1.292804, 0.075511, 3.249601>,
				< 1.292803, -0.150655, 3.323085>,
				< 1.828530, -0.149883, 3.337907>
			}
			triangle {
				< 1.292803, -0.150655, 3.323085>,
				< 1.828529, -0.390009, 3.286864>,
				< 1.828530, -0.149883, 3.337907>
			}
			triangle {
				< 1.292803, -0.150655, 3.323085>,
				< 1.292802, -0.383280, 3.273650>,
				< 1.828529, -0.390009, 3.286864>
			}
			triangle {
				< 1.292802, -0.383280, 3.273650>,
				< 1.828528, -0.572454, 3.122604>,
				< 1.828529, -0.390009, 3.286864>
			}
			triangle {
				< 1.292802, -0.383280, 3.273650>,
				< 1.292801, -0.560040, 3.114540>,
				< 1.828528, -0.572454, 3.122604>
			}
			triangle {
				< 1.292801, -0.560040, 3.114540>,
				< 1.828528, -0.648348, 2.889147>,
				< 1.828528, -0.572454, 3.122604>
			}
			triangle {
				< 1.292801, -0.560040, 3.114540>,
				< 1.292801, -0.633524, 2.888374>,
				< 1.828528, -0.648348, 2.889147>
			}
			triangle {
				< 1.292801, -0.633524, 2.888374>,
				< 1.828528, -0.597306, 2.648993>,
				< 1.828528, -0.648348, 2.889147>
			}
			triangle {
				< 1.292801, -0.633524, 2.888374>,
				< 1.292801, -0.584090, 2.655748>,
				< 1.828528, -0.597306, 2.648993>
			}
			triangle {
				< 1.292801, -0.584090, 2.655748>,
				< 1.828528, -0.433046, 2.466547>,
				< 1.828528, -0.597306, 2.648993>
			}
			triangle {
				< 1.292801, -0.584090, 2.655748>,
				< 1.292801, -0.424979, 2.478988>,
				< 1.828528, -0.433046, 2.466547>
			}
			triangle {
				< 1.292801, -0.424979, 2.478988>,
				< 1.828529, -0.199589, 2.390681>,
				< 1.828528, -0.433046, 2.466547>
			}
			triangle {
				< 1.292801, -0.424979, 2.478988>,
				< 1.292802, -0.198813, 2.405474>,
				< 1.828529, -0.199589, 2.390681>
			}
			triangle {
				< 1.292802, -0.198813, 2.405474>,
				< 1.828530, 0.040565, 2.441693>,
				< 1.828529, -0.199589, 2.390681>
			}
			triangle {
				< 1.292802, -0.198813, 2.405474>,
				< 1.292803, 0.033812, 2.454908>,
				< 1.828530, 0.040565, 2.441693>
			}
			triangle {
				< 1.292803, 0.033812, 2.454908>,
				< 1.828530, 0.223011, 2.605953>,
				< 1.828530, 0.040565, 2.441693>
			}
			triangle {
				< 1.292803, 0.033812, 2.454908>,
				< 1.292804, 0.210572, 2.614049>,
				< 1.828530, 0.223011, 2.605953>
			}
			triangle {
				< 1.828531, 0.298877, 2.839441>,
				< 1.828530, 0.223011, 2.605953>,
				< 1.292804, 0.210572, 2.614049>
			}
			triangle {
				< 1.828531, 0.298877, 2.839441>,
				< 1.292804, 0.210572, 2.614049>,
				< 1.292804, 0.284087, 2.840215>
			}
			triangle {
				< 1.024971, 0.253552, 2.841824>,
				< 1.292804, 0.234653, 3.072840>,
				< 1.292804, 0.284087, 2.840215>
			}
			triangle {
				< 1.024971, 0.253552, 2.841824>,
				< 1.024972, 0.207419, 3.058971>,
				< 1.292804, 0.234653, 3.072840>
			}
			triangle {
				< 1.024972, 0.207419, 3.058971>,
				< 1.292804, 0.075511, 3.249601>,
				< 1.292804, 0.234653, 3.072840>
			}
			triangle {
				< 1.024972, 0.207419, 3.058971>,
				< 1.024971, 0.058875, 3.223975>,
				< 1.292804, 0.075511, 3.249601>
			}
			triangle {
				< 1.024971, 0.058875, 3.223975>,
				< 1.292803, -0.150655, 3.323085>,
				< 1.292804, 0.075511, 3.249601>
			}
			triangle {
				< 1.024971, 0.058875, 3.223975>,
				< 1.024970, -0.152260, 3.292580>,
				< 1.292803, -0.150655, 3.323085>
			}
			triangle {
				< 1.024970, -0.152260, 3.292580>,
				< 1.292802, -0.383280, 3.273650>,
				< 1.292803, -0.150655, 3.323085>
			}
			triangle {
				< 1.024970, -0.152260, 3.292580>,
				< 1.024969, -0.369409, 3.246449>,
				< 1.292802, -0.383280, 3.273650>
			}
			triangle {
				< 1.024969, -0.369409, 3.246449>,
				< 1.292801, -0.560040, 3.114540>,
				< 1.292802, -0.383280, 3.273650>
			}
			triangle {
				< 1.024969, -0.369409, 3.246449>,
				< 1.024969, -0.534384, 3.097903>,
				< 1.292801, -0.560040, 3.114540>
			}
			triangle {
				< 1.024969, -0.534384, 3.097903>,
				< 1.292801, -0.633524, 2.888374>,
				< 1.292801, -0.560040, 3.114540>
			}
			triangle {
				< 1.024969, -0.534384, 3.097903>,
				< 1.024968, -0.603018, 2.886766>,
				< 1.292801, -0.633524, 2.888374>
			}
			triangle {
				< 1.024968, -0.603018, 2.886766>,
				< 1.292801, -0.584090, 2.655748>,
				< 1.292801, -0.633524, 2.888374>
			}
			triangle {
				< 1.024968, -0.603018, 2.886766>,
				< 1.024968, -0.556885, 2.669619>,
				< 1.292801, -0.584090, 2.655748>
			}
			triangle {
				< 1.024968, -0.556885, 2.669619>,
				< 1.292801, -0.424979, 2.478988>,
				< 1.292801, -0.584090, 2.655748>
			}
			triangle {
				< 1.024968, -0.556885, 2.669619>,
				< 1.024968, -0.408341, 2.504615>,
				< 1.292801, -0.424979, 2.478988>
			}
			triangle {
				< 1.024968, -0.408341, 2.504615>,
				< 1.292802, -0.198813, 2.405474>,
				< 1.292801, -0.424979, 2.478988>
			}
			triangle {
				< 1.024968, -0.408341, 2.504615>,
				< 1.024969, -0.197204, 2.436010>,
				< 1.292802, -0.198813, 2.405474>
			}
			triangle {
				< 1.024969, -0.197204, 2.436010>,
				< 1.292803, 0.033812, 2.454908>,
				< 1.292802, -0.198813, 2.405474>
			}
			triangle {
				< 1.024969, -0.197204, 2.436010>,
				< 1.024970, 0.019943, 2.482143>,
				< 1.292803, 0.033812, 2.454908>
			}
			triangle {
				< 1.024970, 0.019943, 2.482143>,
				< 1.292804, 0.210572, 2.614049>,
				< 1.292803, 0.033812, 2.454908>
			}
			triangle {
				< 1.024970, 0.019943, 2.482143>,
				< 1.024971, 0.184947, 2.630687>,
				< 1.292804, 0.210572, 2.614049>
			}
			triangle {
				< 1.292804, 0.284087, 2.840215>,
				< 1.292804, 0.210572, 2.614049>,
				< 1.024971, 0.184947, 2.630687>
			}
			triangle {
				< 1.292804, 0.284087, 2.840215>,
				< 1.024971, 0.184947, 2.630687>,
				< 1.024971, 0.253552, 2.841824>
			}
			triangle {
				< 0.763536, 0.219416, 2.843609>,
				< 1.024972, 0.207419, 3.058971>,
				< 1.024971, 0.253552, 2.841824>
			}
			triangle {
				< 0.763536, 0.219416, 2.843609>,
				< 0.763536, 0.176974, 3.043465>,
				< 1.024972, 0.207419, 3.058971>
			}
			triangle {
				< 0.763536, 0.176974, 3.043465>,
				< 1.024971, 0.058875, 3.223975>,
				< 1.024972, 0.207419, 3.058971>
			}
			triangle {
				< 0.763536, 0.176974, 3.043465>,
				< 0.763536, 0.040275, 3.195285>,
				< 1.024971, 0.058875, 3.223975>
			}
			triangle {
				< 0.763536, 0.040275, 3.195285>,
				< 1.024970, -0.152260, 3.292580>,
				< 1.024971, 0.058875, 3.223975>
			}
			triangle {
				< 0.763536, 0.040275, 3.195285>,
				< 0.763535, -0.154046, 3.258443>,
				< 1.024970, -0.152260, 3.292580>
			}
			triangle {
				< 0.763535, -0.154046, 3.258443>,
				< 1.024969, -0.369409, 3.246449>,
				< 1.024970, -0.152260, 3.292580>
			}
			triangle {
				< 0.763535, -0.154046, 3.258443>,
				< 0.763534, -0.353902, 3.215970>,
				< 1.024969, -0.369409, 3.246449>
			}
			triangle {
				< 0.763534, -0.353902, 3.215970>,
				< 1.024969, -0.534384, 3.097903>,
				< 1.024969, -0.369409, 3.246449>
			}
			triangle {
				< 0.763534, -0.353902, 3.215970>,
				< 0.763534, -0.505722, 3.079272>,
				< 1.024969, -0.534384, 3.097903>
			}
			triangle {
				< 0.763534, -0.505722, 3.079272>,
				< 1.024968, -0.603018, 2.886766>,
				< 1.024969, -0.534384, 3.097903>
			}
			triangle {
				< 0.763534, -0.505722, 3.079272>,
				< 0.763533, -0.568879, 2.884982>,
				< 1.024968, -0.603018, 2.886766>
			}
			triangle {
				< 0.763533, -0.568879, 2.884982>,
				< 1.024968, -0.556885, 2.669619>,
				< 1.024968, -0.603018, 2.886766>
			}
			triangle {
				< 0.763533, -0.568879, 2.884982>,
				< 0.763533, -0.526407, 2.685125>,
				< 1.024968, -0.556885, 2.669619>
			}
			triangle {
				< 0.763533, -0.526407, 2.685125>,
				< 1.024968, -0.408341, 2.504615>,
				< 1.024968, -0.556885, 2.669619>
			}
			triangle {
				< 0.763533, -0.526407, 2.685125>,
				< 0.763533, -0.389708, 2.533277>,
				< 1.024968, -0.408341, 2.504615>
			}
			triangle {
				< 0.763533, -0.389708, 2.533277>,
				< 1.024969, -0.197204, 2.436010>,
				< 1.024968, -0.408341, 2.504615>
			}
			triangle {
				< 0.763533, -0.389708, 2.533277>,
				< 0.763534, -0.195418, 2.470148>,
				< 1.024969, -0.197204, 2.436010>
			}
			triangle {
				< 0.763534, -0.195418, 2.470148>,
				< 1.024970, 0.019943, 2.482143>,
				< 1.024969, -0.197204, 2.436010>
			}
			triangle {
				< 0.763534, -0.195418, 2.470148>,
				< 0.763535, 0.004438, 2.512620>,
				< 1.024970, 0.019943, 2.482143>
			}
			triangle {
				< 0.763535, 0.004438, 2.512620>,
				< 1.024971, 0.184947, 2.630687>,
				< 1.024970, 0.019943, 2.482143>
			}
			triangle {
				< 0.763535, 0.004438, 2.512620>,
				< 0.763536, 0.156289, 2.649319>,
				< 1.024971, 0.184947, 2.630687>
			}
			triangle {
				< 1.024971, 0.253552, 2.841824>,
				< 1.024971, 0.184947, 2.630687>,
				< 0.763536, 0.156289, 2.649319>
			}
			triangle {
				< 1.024971, 0.253552, 2.841824>,
				< 0.763536, 0.156289, 2.649319>,
				< 0.763536, 0.219416, 2.843609>
			}
			triangle {
				< 0.578531, 0.163104, 2.846556>,
				< 0.763536, 0.176974, 3.043465>,
				< 0.763536, 0.219416, 2.843609>
			}
			triangle {
				< 0.578531, 0.163104, 2.846556>,
				< 0.578531, 0.126705, 3.017870>,
				< 0.763536, 0.176974, 3.043465>
			}
			triangle {
				< 0.578531, 0.126705, 3.017870>,
				< 0.763536, 0.040275, 3.195285>,
				< 0.763536, 0.176974, 3.043465>
			}
			triangle {
				< 0.578531, 0.126705, 3.017870>,
				< 0.578530, 0.009559, 3.148023>,
				< 0.763536, 0.040275, 3.195285>
			}
			triangle {
				< 0.578530, 0.009559, 3.148023>,
				< 0.763535, -0.154046, 3.258443>,
				< 0.763536, 0.040275, 3.195285>
			}
			triangle {
				< 0.578530, 0.009559, 3.148023>,
				< 0.578530, -0.156991, 3.202131>,
				< 0.763535, -0.154046, 3.258443>
			}
			triangle {
				< 0.578530, -0.156991, 3.202131>,
				< 0.763534, -0.353902, 3.215970>,
				< 0.763535, -0.154046, 3.258443>
			}
			triangle {
				< 0.578530, -0.156991, 3.202131>,
				< 0.578529, -0.328305, 3.165731>,
				< 0.763534, -0.353902, 3.215970>
			}
			triangle {
				< 0.578529, -0.328305, 3.165731>,
				< 0.763534, -0.505722, 3.079272>,
				< 0.763534, -0.353902, 3.215970>
			}
			triangle {
				< 0.578529, -0.328305, 3.165731>,
				< 0.578529, -0.458457, 3.048557>,
				< 0.763534, -0.505722, 3.079272>
			}
			triangle {
				< 0.578529, -0.458457, 3.048557>,
				< 0.763533, -0.568879, 2.884982>,
				< 0.763534, -0.505722, 3.079272>
			}
			triangle {
				< 0.578529, -0.458457, 3.048557>,
				< 0.578528, -0.512566, 2.882005>,
				< 0.763533, -0.568879, 2.884982>
			}
			triangle {
				< 0.578528, -0.512566, 2.882005>,
				< 0.763533, -0.526407, 2.685125>,
				< 0.763533, -0.568879, 2.884982>
			}
			triangle {
				< 0.578528, -0.512566, 2.882005>,
				< 0.578528, -0.476167, 2.710721>,
				< 0.763533, -0.526407, 2.685125>
			}
			triangle {
				< 0.578528, -0.476167, 2.710721>,
				< 0.763533, -0.389708, 2.533277>,
				< 0.763533, -0.526407, 2.685125>
			}
			triangle {
				< 0.578528, -0.476167, 2.710721>,
				< 0.578528, -0.358993, 2.580570>,
				< 0.763533, -0.389708, 2.533277>
			}
			triangle {
				< 0.578528, -0.358993, 2.580570>,
				< 0.763534, -0.195418, 2.470148>,
				< 0.763533, -0.389708, 2.533277>
			}
			triangle {
				< 0.578528, -0.358993, 2.580570>,
				< 0.578529, -0.192440, 2.526461>,
				< 0.763534, -0.195418, 2.470148>
			}
			triangle {
				< 0.578529, -0.192440, 2.526461>,
				< 0.763535, 0.004438, 2.512620>,
				< 0.763534, -0.195418, 2.470148>
			}
			triangle {
				< 0.578529, -0.192440, 2.526461>,
				< 0.578530, -0.021157, 2.562860>,
				< 0.763535, 0.004438, 2.512620>
			}
			triangle {
				< 0.578530, -0.021157, 2.562860>,
				< 0.763536, 0.156289, 2.649319>,
				< 0.763535, 0.004438, 2.512620>
			}
			triangle {
				< 0.578530, -0.021157, 2.562860>,
				< 0.578530, 0.108997, 2.680005>,
				< 0.763536, 0.156289, 2.649319>
			}
			triangle {
				< 0.763536, 0.219416, 2.843609>,
				< 0.763536, 0.156289, 2.649319>,
				< 0.578530, 0.108997, 2.680005>
			}
			triangle {
				< 0.763536, 0.219416, 2.843609>,
				< 0.578530, 0.108997, 2.680005>,
				< 0.578531, 0.163104, 2.846556>
			}
			triangle {
				< 0.763536, 0.181885, 2.845573>,
				< 0.578531, 0.126705, 3.017870>,
				< 0.578531, 0.163104, 2.846556>
			}
			triangle {
				< 0.763536, 0.181885, 2.845573>,
				< 0.763536, 0.143462, 3.026381>,
				< 0.578531, 0.126705, 3.017870>
			}
			triangle {
				< 0.763536, 0.143462, 3.026381>,
				< 0.578530, 0.009559, 3.148023>,
				< 0.578531, 0.126705, 3.017870>
			}
			triangle {
				< 0.763536, 0.143462, 3.026381>,
				< 0.763536, 0.019798, 3.163767>,
				< 0.578530, 0.009559, 3.148023>
			}
			triangle {
				< 0.763536, 0.019798, 3.163767>,
				< 0.578530, -0.156991, 3.202131>,
				< 0.578530, 0.009559, 3.148023>
			}
			triangle {
				< 0.763536, 0.019798, 3.163767>,
				< 0.763535, -0.156009, 3.220912>,
				< 0.578530, -0.156991, 3.202131>
			}
			triangle {
				< 0.763535, -0.156009, 3.220912>,
				< 0.578529, -0.328305, 3.165731>,
				< 0.578530, -0.156991, 3.202131>
			}
			triangle {
				< 0.763535, -0.156009, 3.220912>,
				< 0.763534, -0.336818, 3.182488>,
				< 0.578529, -0.328305, 3.165731>
			}
			triangle {
				< 0.763534, -0.336818, 3.182488>,
				< 0.578529, -0.458457, 3.048557>,
				< 0.578529, -0.328305, 3.165731>
			}
			triangle {
				< 0.763534, -0.336818, 3.182488>,
				< 0.763534, -0.474203, 3.058795>,
				< 0.578529, -0.458457, 3.048557>
			}
			triangle {
				< 0.763534, -0.474203, 3.058795>,
				< 0.578528, -0.512566, 2.882005>,
				< 0.578529, -0.458457, 3.048557>
			}
			triangle {
				< 0.763534, -0.474203, 3.058795>,
				< 0.763533, -0.531346, 2.883016>,
				< 0.578528, -0.512566, 2.882005>
			}
			triangle {
				< 0.763533, -0.531346, 2.883016>,
				< 0.578528, -0.476167, 2.710721>,
				< 0.578528, -0.512566, 2.882005>
			}
			triangle {
				< 0.763533, -0.531346, 2.883016>,
				< 0.763533, -0.492925, 2.702179>,
				< 0.578528, -0.476167, 2.710721>
			}
			triangle {
				< 0.763533, -0.492925, 2.702179>,
				< 0.578528, -0.358993, 2.580570>,
				< 0.578528, -0.476167, 2.710721>
			}
			triangle {
				< 0.763533, -0.492925, 2.702179>,
				< 0.763533, -0.369231, 2.564824>,
				< 0.578528, -0.358993, 2.580570>
			}
			triangle {
				< 0.763533, -0.369231, 2.564824>,
				< 0.578529, -0.192440, 2.526461>,
				< 0.578528, -0.358993, 2.580570>
			}
			triangle {
				< 0.763533, -0.369231, 2.564824>,
				< 0.763534, -0.193424, 2.507679>,
				< 0.578529, -0.192440, 2.526461>
			}
			triangle {
				< 0.763534, -0.193424, 2.507679>,
				< 0.578530, -0.021157, 2.562860>,
				< 0.578529, -0.192440, 2.526461>
			}
			triangle {
				< 0.763534, -0.193424, 2.507679>,
				< 0.763535, -0.012616, 2.546102>,
				< 0.578530, -0.021157, 2.562860>
			}
			triangle {
				< 0.763535, -0.012616, 2.546102>,
				< 0.578530, 0.108997, 2.680005>,
				< 0.578530, -0.021157, 2.562860>
			}
			triangle {
				< 0.763535, -0.012616, 2.546102>,
				< 0.763536, 0.124768, 2.669765>,
				< 0.578530, 0.108997, 2.680005>
			}
			triangle {
				< 0.578531, 0.163104, 2.846556>,
				< 0.578530, 0.108997, 2.680005>,
				< 0.763536, 0.124768, 2.669765>
			}
			triangle {
				< 0.578531, 0.163104, 2.846556>,
				< 0.763536, 0.124768, 2.669765>,
				< 0.763536, 0.181885, 2.845573>
			}
			triangle {
				< 1.024971, 0.185277, 2.845396>,
				< 0.763536, 0.143462, 3.026381>,
				< 0.763536, 0.181885, 2.845573>
			}
			triangle {
				< 1.024971, 0.185277, 2.845396>,
				< 1.024971, 0.146496, 3.027930>,
				< 0.763536, 0.143462, 3.026381>
			}
			triangle {
				< 1.024971, 0.146496, 3.027930>,
				< 0.763536, 0.019798, 3.163767>,
				< 0.763536, 0.143462, 3.026381>
			}
			triangle {
				< 1.024971, 0.146496, 3.027930>,
				< 1.024971, 0.021643, 3.166623>,
				< 0.763536, 0.019798, 3.163767>
			}
			triangle {
				< 1.024971, 0.021643, 3.166623>,
				< 0.763535, -0.156009, 3.220912>,
				< 0.763536, 0.019798, 3.163767>
			}
			triangle {
				< 1.024971, 0.021643, 3.166623>,
				< 1.024970, -0.155832, 3.224304>,
				< 0.763535, -0.156009, 3.220912>
			}
			triangle {
				< 1.024970, -0.155832, 3.224304>,
				< 0.763534, -0.336818, 3.182488>,
				< 0.763535, -0.156009, 3.220912>
			}
			triangle {
				< 1.024970, -0.155832, 3.224304>,
				< 1.024970, -0.338368, 3.185524>,
				< 0.763534, -0.336818, 3.182488>
			}
			triangle {
				< 1.024970, -0.338368, 3.185524>,
				< 0.763534, -0.474203, 3.058795>,
				< 0.763534, -0.336818, 3.182488>
			}
			triangle {
				< 1.024970, -0.338368, 3.185524>,
				< 1.024969, -0.477061, 3.060670>,
				< 0.763534, -0.474203, 3.058795>
			}
			triangle {
				< 1.024969, -0.477061, 3.060670>,
				< 0.763533, -0.531346, 2.883016>,
				< 0.763534, -0.474203, 3.058795>
			}
			triangle {
				< 1.024969, -0.477061, 3.060670>,
				< 1.024968, -0.534743, 2.883196>,
				< 0.763533, -0.531346, 2.883016>
			}
			triangle {
				< 1.024968, -0.534743, 2.883196>,
				< 0.763533, -0.492925, 2.702179>,
				< 0.763533, -0.531346, 2.883016>
			}
			triangle {
				< 1.024968, -0.534743, 2.883196>,
				< 1.024968, -0.495962, 2.700631>,
				< 0.763533, -0.492925, 2.702179>
			}
			triangle {
				< 1.024968, -0.495962, 2.700631>,
				< 0.763533, -0.369231, 2.564824>,
				< 0.763533, -0.492925, 2.702179>
			}
			triangle {
				< 1.024968, -0.495962, 2.700631>,
				< 1.024969, -0.371106, 2.561936>,
				< 0.763533, -0.369231, 2.564824>
			}
			triangle {
				< 1.024969, -0.371106, 2.561936>,
				< 0.763534, -0.193424, 2.507679>,
				< 0.763533, -0.369231, 2.564824>
			}
			triangle {
				< 1.024969, -0.371106, 2.561936>,
				< 1.024969, -0.193604, 2.504285>,
				< 0.763534, -0.193424, 2.507679>
			}
			triangle {
				< 1.024969, -0.193604, 2.504285>,
				< 0.763535, -0.012616, 2.546102>,
				< 0.763534, -0.193424, 2.507679>
			}
			triangle {
				< 1.024969, -0.193604, 2.504285>,
				< 1.024970, -0.011069, 2.543066>,
				< 0.763535, -0.012616, 2.546102>
			}
			triangle {
				< 1.024970, -0.011069, 2.543066>,
				< 0.763536, 0.124768, 2.669765>,
				< 0.763535, -0.012616, 2.546102>
			}
			triangle {
				< 1.024970, -0.011069, 2.543066>,
				< 1.024971, 0.127626, 2.667919>,
				< 0.763536, 0.124768, 2.669765>
			}
			triangle {
				< 0.763536, 0.181885, 2.845573>,
				< 0.763536, 0.124768, 2.669765>,
				< 1.024971, 0.127626, 2.667919>
			}
			triangle {
				< 0.763536, 0.181885, 2.845573>,
				< 1.024971, 0.127626, 2.667919>,
				< 1.024971, 0.185277, 2.845396>
			}
			triangle {
				< 1.292804, 0.200662, 2.844591>,
				< 1.024971, 0.146496, 3.027930>,
				< 1.024971, 0.185277, 2.845396>
			}
			triangle {
				< 1.292804, 0.200662, 2.844591>,
				< 1.292804, 0.160215, 3.034922>,
				< 1.024971, 0.146496, 3.027930>
			}
			triangle {
				< 1.292804, 0.160215, 3.034922>,
				< 1.024971, 0.021643, 3.166623>,
				< 1.024971, 0.146496, 3.027930>
			}
			triangle {
				< 1.292804, 0.160215, 3.034922>,
				< 1.292804, 0.030033, 3.179541>,
				< 1.024971, 0.021643, 3.166623>
			}
			triangle {
				< 1.292804, 0.030033, 3.179541>,
				< 1.024970, -0.155832, 3.224304>,
				< 1.024971, 0.021643, 3.166623>
			}
			triangle {
				< 1.292804, 0.030033, 3.179541>,
				< 1.292803, -0.155031, 3.239660>,
				< 1.024970, -0.155832, 3.224304>
			}
			triangle {
				< 1.292803, -0.155031, 3.239660>,
				< 1.024970, -0.338368, 3.185524>,
				< 1.024970, -0.155832, 3.224304>
			}
			triangle {
				< 1.292803, -0.155031, 3.239660>,
				< 1.292802, -0.345362, 3.199243>,
				< 1.024970, -0.338368, 3.185524>
			}
			triangle {
				< 1.292802, -0.345362, 3.199243>,
				< 1.024969, -0.477061, 3.060670>,
				< 1.024970, -0.338368, 3.185524>
			}
			triangle {
				< 1.292802, -0.345362, 3.199243>,
				< 1.292801, -0.489980, 3.069032>,
				< 1.024969, -0.477061, 3.060670>
			}
			triangle {
				< 1.292801, -0.489980, 3.069032>,
				< 1.024968, -0.534743, 2.883196>,
				< 1.024969, -0.477061, 3.060670>
			}
			triangle {
				< 1.292801, -0.489980, 3.069032>,
				< 1.292801, -0.550100, 2.883998>,
				< 1.024968, -0.534743, 2.883196>
			}
			triangle {
				< 1.292801, -0.550100, 2.883998>,
				< 1.024968, -0.495962, 2.700631>,
				< 1.024968, -0.534743, 2.883196>
			}
			triangle {
				< 1.292801, -0.550100, 2.883998>,
				< 1.292801, -0.509682, 2.693667>,
				< 1.024968, -0.495962, 2.700631>
			}
			triangle {
				< 1.292801, -0.509682, 2.693667>,
				< 1.024969, -0.371106, 2.561936>,
				< 1.024968, -0.495962, 2.700631>
			}
			triangle {
				< 1.292801, -0.509682, 2.693667>,
				< 1.292801, -0.379473, 2.549048>,
				< 1.024969, -0.371106, 2.561936>
			}
			triangle {
				< 1.292801, -0.379473, 2.549048>,
				< 1.024969, -0.193604, 2.504285>,
				< 1.024969, -0.371106, 2.561936>
			}
			triangle {
				< 1.292801, -0.379473, 2.549048>,
				< 1.292802, -0.194437, 2.488898>,
				< 1.024969, -0.193604, 2.504285>
			}
			triangle {
				< 1.292802, -0.194437, 2.488898>,
				< 1.024970, -0.011069, 2.543066>,
				< 1.024969, -0.193604, 2.504285>
			}
			triangle {
				< 1.292802, -0.194437, 2.488898>,
				< 1.292803, -0.004106, 2.529346>,
				< 1.024970, -0.011069, 2.543066>
			}
			triangle {
				< 1.292803, -0.004106, 2.529346>,
				< 1.024971, 0.127626, 2.667919>,
				< 1.024970, -0.011069, 2.543066>
			}
			triangle {
				< 1.292803, -0.004106, 2.529346>,
				< 1.292804, 0.140512, 2.659527>,
				< 1.024971, 0.127626, 2.667919>
			}
			triangle {
				< 1.024971, 0.185277, 2.845396>,
				< 1.024971, 0.127626, 2.667919>,
				< 1.292804, 0.140512, 2.659527>
			}
			triangle {
				< 1.024971, 0.185277, 2.845396>,
				< 1.292804, 0.140512, 2.659527>,
				< 1.292804, 0.200662, 2.844591>
			}
			triangle {
				< 1.828531, 0.223399, 2.843398>,
				< 1.292804, 0.160215, 3.034922>,
				< 1.292804, 0.200662, 2.844591>
			}
			triangle {
				< 1.828531, 0.223399, 2.843398>,
				< 1.828531, 0.180482, 3.045251>,
				< 1.292804, 0.160215, 3.034922>
			}
			triangle {
				< 1.828531, 0.180482, 3.045251>,
				< 1.292804, 0.030033, 3.179541>,
				< 1.292804, 0.160215, 3.034922>
			}
			triangle {
				< 1.828531, 0.180482, 3.045251>,
				< 1.828531, 0.042413, 3.198618>,
				< 1.292804, 0.030033, 3.179541>
			}
			triangle {
				< 1.828531, 0.042413, 3.198618>,
				< 1.292803, -0.155031, 3.239660>,
				< 1.292804, 0.030033, 3.179541>
			}
			triangle {
				< 1.828531, 0.042413, 3.198618>,
				< 1.828530, -0.153841, 3.262399>,
				< 1.292803, -0.155031, 3.239660>
			}
			triangle {
				< 1.828530, -0.153841, 3.262399>,
				< 1.292802, -0.345362, 3.199243>,
				< 1.292803, -0.155031, 3.239660>
			}
			triangle {
				< 1.828530, -0.153841, 3.262399>,
				< 1.828529, -0.355693, 3.219512>,
				< 1.292802, -0.345362, 3.199243>
			}
			triangle {
				< 1.828529, -0.355693, 3.219512>,
				< 1.292801, -0.489980, 3.069032>,
				< 1.292802, -0.345362, 3.199243>
			}
			triangle {
				< 1.828529, -0.355693, 3.219512>,
				< 1.828529, -0.509060, 3.081443>,
				< 1.292801, -0.489980, 3.069032>
			}
			triangle {
				< 1.828529, -0.509060, 3.081443>,
				< 1.292801, -0.550100, 2.883998>,
				< 1.292801, -0.489980, 3.069032>
			}
			triangle {
				< 1.828529, -0.509060, 3.081443>,
				< 1.828528, -0.572841, 2.885189>,
				< 1.292801, -0.550100, 2.883998>
			}
			triangle {
				< 1.828528, -0.572841, 2.885189>,
				< 1.292801, -0.509682, 2.693667>,
				< 1.292801, -0.550100, 2.883998>
			}
			triangle {
				< 1.828528, -0.572841, 2.885189>,
				< 1.828528, -0.529955, 2.683337>,
				< 1.292801, -0.509682, 2.693667>
			}
			triangle {
				< 1.828528, -0.529955, 2.683337>,
				< 1.292801, -0.379473, 2.549048>,
				< 1.292801, -0.509682, 2.693667>
			}
			triangle {
				< 1.828528, -0.529955, 2.683337>,
				< 1.828528, -0.391885, 2.529970>,
				< 1.292801, -0.379473, 2.549048>
			}
			triangle {
				< 1.828528, -0.391885, 2.529970>,
				< 1.292802, -0.194437, 2.488898>,
				< 1.292801, -0.379473, 2.549048>
			}
			triangle {
				< 1.828528, -0.391885, 2.529970>,
				< 1.828529, -0.195631, 2.466190>,
				< 1.292802, -0.194437, 2.488898>
			}
			triangle {
				< 1.828529, -0.195631, 2.466190>,
				< 1.292803, -0.004106, 2.529346>,
				< 1.292802, -0.194437, 2.488898>
			}
			triangle {
				< 1.828529, -0.195631, 2.466190>,
				< 1.828530, 0.006249, 2.509076>,
				< 1.292803, -0.004106, 2.529346>
			}
			triangle {
				< 1.828530, 0.006249, 2.509076>,
				< 1.292804, 0.140512, 2.659527>,
				< 1.292803, -0.004106, 2.529346>
			}
			triangle {
				< 1.828530, 0.006249, 2.509076>,
				< 1.828531, 0.159616, 2.647145>,
				< 1.292804, 0.140512, 2.659527>
			}
			triangle {
				< 1.292804, 0.200662, 2.844591>,
				< 1.292804, 0.140512, 2.659527>,
				< 1.828531, 0.159616, 2.647145>
			}
			triangle {
				< 1.292804, 0.200662, 2.844591>,
				< 1.828531, 0.159616, 2.647145>,
				< 1.828531, 0.223399, 2.843398>
			}
			texture{_ICP26_Red}
		}
	}
}



// This object has the following minimum and maximum values:
// xmin=-1.947583, xmax=1.947582
// ymin=-0.665031, ymax=0.665006
// zmin=-6.446676, zmax=6.446677

// Object converted to POVRay V2.2 by WCVT2POV V2.6b
#declare _ICP14_Magenta = texture{ pigment{color Blue} finish{metallic ambient 0.3}}


#declare vtail = object {
// This object has the following minimum and maximum values:
// xmin=-0.073839, xmax=0.073841
// ymin=-1.168629, ymax=1.168629
// zmin=-1.660341, zmax=1.660341
	// _ICP14_Magenta
	union {
		smooth_triangle {
			<-0.007836, -1.160873, -1.589326>, <0.069226, -0.010930, 0.004706>,
			<-0.015565, -1.153626, -0.762923>, <0.097668, -0.000008, 0.001269>,
			<-0.015566, -0.853741, -0.761008>, <0.170845, -0.014045, 0.007857>
		}
		smooth_triangle {
			<-0.015566, -0.853741, -0.761008>, <0.170845, -0.014045, 0.007857>,
			<-0.015565, -1.153626, -0.762923>, <0.097668, -0.000008, 0.001269>,
			<-0.025282, -1.146885, -0.246537>, <0.250367, 0.005399, 0.012201>
		}
		smooth_triangle {
			<-0.015566, -0.853741, -0.761008>, <0.170845, -0.014045, 0.007857>,
			<-0.025282, -1.146885, -0.246537>, <0.250367, 0.005399, 0.012201>,
			<-0.025283, -0.662279, -0.246537>, <0.212585, -0.024497, 0.034864>
		}
		smooth_triangle {
			<-0.025283, -0.662279, -0.246537>, <0.212585, -0.024497, 0.034864>,
			<-0.025282, -1.146885, -0.246537>, <0.250367, 0.005399, 0.012201>,
			<-0.073838, -0.662279, 0.215038>, <0.437503, 0.004528, 0.015615>
		}
		smooth_triangle {
			<-0.025282, -1.146885, -0.246537>, <0.250367, 0.005399, 0.012201>,
			<-0.064121, -1.153625, 0.581414>, <0.285500, 0.007264, -0.001092>,
			<-0.073838, -0.662279, 0.215038>, <0.437503, 0.004528, 0.015615>
		}
		smooth_triangle {
			<-0.073838, -0.662279, 0.215038>, <0.437503, 0.004528, 0.015615>,
			<-0.064121, -1.153625, 0.581414>, <0.285500, 0.007264, -0.001092>,
			<-0.064122, -0.669017, 0.777583>, <0.400700, 0.005409, -0.013077>
		}
		smooth_triangle {
			<-0.073839, 0.017574, 0.431400>, <0.194151, -0.031503, 0.042320>,
			<-0.025283, -0.662279, -0.246537>, <0.212585, -0.024497, 0.034864>,
			<-0.073838, -0.662279, 0.215038>, <0.437503, 0.004528, 0.015615>
		}
		smooth_triangle {
			<-0.073839, 0.017575, 0.728539>, <0.322473, 0.002768, -0.004664>,
			<-0.073839, 0.017574, 0.431400>, <0.194151, -0.031503, 0.042320>,
			<-0.073838, -0.662279, 0.215038>, <0.437503, 0.004528, 0.015615>
		}
		smooth_triangle {
			<-0.073838, -0.662279, 0.215038>, <0.437503, 0.004528, 0.015615>,
			<-0.064122, -0.669017, 0.777583>, <0.400700, 0.005409, -0.013077>,
			<-0.073839, 0.017575, 0.728539>, <0.322473, 0.002768, -0.004664>
		}
		smooth_triangle {
			<-0.064122, -0.669017, 0.777583>, <0.400700, 0.005409, -0.013077>,
			<-0.064122, 0.017575, 1.077605>, <0.272046, 0.005333, -0.013505>,
			<-0.073839, 0.017575, 0.728539>, <0.322473, 0.002768, -0.004664>
		}
		smooth_triangle {
			<-0.073839, 0.017575, 0.728539>, <0.322473, 0.002768, -0.004664>,
			<-0.073839, 0.630131, 0.916053>, <0.113162, -0.022369, 0.029292>,
			<-0.073839, 0.017574, 0.431400>, <0.194151, -0.031503, 0.042320>
		}
		smooth_triangle {
			<-0.073839, 0.630131, 1.089144>, <0.162226, 0.001904, -0.004061>,
			<-0.064122, 0.017575, 1.077605>, <0.272046, 0.005333, -0.013505>,
			<-0.064123, 0.630132, 1.325701>, <0.156233, 0.003235, -0.011365>
		}
		smooth_triangle {
			<-0.073839, 1.128240, 1.288197>, <0.103888, -0.016774, 0.003874>,
			<-0.073839, 0.630131, 0.916053>, <0.113162, -0.022369, 0.029292>,
			<-0.073839, 0.630131, 1.089144>, <0.162226, 0.001904, -0.004061>
		}
		smooth_triangle {
			<-0.064123, 0.630132, 1.325701>, <0.156233, 0.003235, -0.011365>,
			<-0.073839, 1.128240, 1.288197>, <0.103888, -0.016774, 0.003874>,
			<-0.073839, 0.630131, 1.089144>, <0.162226, 0.001904, -0.004061>
		}
		smooth_triangle {
			<-0.064123, 0.630132, 1.325701>, <0.156233, 0.003235, -0.011365>,
			<-0.044714, 0.630132, 1.518985>, <0.115246, 0.006824, -0.029711>,
			<-0.044715, 1.128241, 1.622839>, <0.075852, -0.000350, -0.019142>
		}
		smooth_triangle {
			<-0.044715, 1.128241, 1.622839>, <0.075852, -0.000350, -0.019142>,
			<-0.073839, 1.128240, 1.288197>, <0.103888, -0.016774, 0.003874>,
			<-0.064123, 0.630132, 1.325701>, <0.156233, 0.003235, -0.011365>
		}
		smooth_triangle {
			<-0.044713, -0.662277, 1.242042>, <0.213615, 0.006467, -0.028634>,
			<-0.064121, -1.153625, 0.581414>, <0.285500, 0.007264, -0.001092>,
			<-0.044712, -1.153624, 1.141073>, <0.071514, 0.001741, -0.008472>
		}
		smooth_triangle {
			<-0.064121, -1.153625, 0.581414>, <0.285500, 0.007264, -0.001092>,
			<-0.044713, -0.662277, 1.242042>, <0.213615, 0.006467, -0.028634>,
			<-0.064122, -0.669017, 0.777583>, <0.400700, 0.005409, -0.013077>
		}
		smooth_triangle {
			<-0.044713, -0.662277, 1.242042>, <0.213615, 0.006467, -0.028634>,
			<-0.044713, 0.017576, 1.389168>, <0.193853, 0.008032, -0.034037>,
			<-0.064122, -0.669017, 0.777583>, <0.400700, 0.005409, -0.013077>
		}
		smooth_triangle {
			<-0.064122, 0.017575, 1.077605>, <0.272046, 0.005333, -0.013505>,
			<-0.064122, -0.669017, 0.777583>, <0.400700, 0.005409, -0.013077>,
			<-0.044713, 0.017576, 1.389168>, <0.193853, 0.008032, -0.034037>
		}
		smooth_triangle {
			<-0.044713, 0.017576, 1.389168>, <0.193853, 0.008032, -0.034037>,
			<-0.044714, 0.630132, 1.518985>, <0.115246, 0.006824, -0.029711>,
			<-0.064122, 0.017575, 1.077605>, <0.272046, 0.005333, -0.013505>
		}
		smooth_triangle {
			<-0.064123, 0.630132, 1.325701>, <0.156233, 0.003235, -0.011365>,
			<-0.064122, 0.017575, 1.077605>, <0.272046, 0.005333, -0.013505>,
			<-0.044714, 0.630132, 1.518985>, <0.115246, 0.006824, -0.029711>
		}
		smooth_triangle {
			<-0.073839, 0.630131, 1.089144>, <0.162226, 0.001904, -0.004061>,
			<-0.073839, 0.017575, 0.728539>, <0.322473, 0.002768, -0.004664>,
			<-0.064122, 0.017575, 1.077605>, <0.272046, 0.005333, -0.013505>
		}
		smooth_triangle {
			<-0.073839, 0.630131, 1.089144>, <0.162226, 0.001904, -0.004061>,
			<-0.073839, 0.630131, 0.916053>, <0.113162, -0.022369, 0.029292>,
			<-0.073839, 0.017575, 0.728539>, <0.322473, 0.002768, -0.004664>
		}
		smooth_triangle {
			<0.013927, -0.834702, -0.777117>, <0.012226, -0.014527, 0.005580>,
			<0.015797, -1.168629, -1.660341>, <0.004090, -0.005031, 0.001911>,
			<-0.007836, -1.160873, -1.589326>, <0.069226, -0.010930, 0.004706>
		}
		smooth_triangle {
			<-0.015566, -0.853741, -0.761008>, <0.170845, -0.014045, 0.007857>,
			<0.013927, -0.834702, -0.777117>, <0.012226, -0.014527, 0.005580>,
			<-0.007836, -1.160873, -1.589326>, <0.069226, -0.010930, 0.004706>
		}
		smooth_triangle {
			<0.011597, -0.635347, -0.272500>, <0.016127, -0.013953, 0.009190>,
			<0.013927, -0.834702, -0.777117>, <0.012226, -0.014527, 0.005580>,
			<-0.015566, -0.853741, -0.761008>, <0.170845, -0.014045, 0.007857>
		}
		smooth_triangle {
			<-0.025283, -0.662279, -0.246537>, <0.212585, -0.024497, 0.034864>,
			<0.011597, -0.635347, -0.272500>, <0.016127, -0.013953, 0.009190>,
			<-0.015566, -0.853741, -0.761008>, <0.170845, -0.014045, 0.007857>
		}
		smooth_triangle {
			<-0.000011, 0.024315, 0.385244>, <0.000271, -0.055363, 0.063185>,
			<0.011597, -0.635347, -0.272500>, <0.016127, -0.013953, 0.009190>,
			<-0.025283, -0.662279, -0.246537>, <0.212585, -0.024497, 0.034864>
		}
		smooth_triangle {
			<-0.073839, 0.017574, 0.431400>, <0.194151, -0.031503, 0.042320>,
			<-0.000011, 0.024315, 0.385244>, <0.000271, -0.055363, 0.063185>,
			<-0.025283, -0.662279, -0.246537>, <0.212585, -0.024497, 0.034864>
		}
		smooth_triangle {
			<-0.000012, 0.643586, 0.869896>, <0.000868, -0.046760, 0.060883>,
			<-0.000011, 0.024315, 0.385244>, <0.000271, -0.055363, 0.063185>,
			<-0.073839, 0.017574, 0.431400>, <0.194151, -0.031503, 0.042320>
		}
		smooth_triangle {
			<-0.073839, 0.630131, 0.916053>, <0.113162, -0.022369, 0.029292>,
			<-0.000012, 0.643586, 0.869896>, <0.000868, -0.046760, 0.060883>,
			<-0.073839, 0.017574, 0.431400>, <0.194151, -0.031503, 0.042320>
		}
		smooth_triangle {
			<-0.000012, 1.168628, 1.262234>, <0.003513, -0.039037, 0.027579>,
			<-0.000012, 0.643586, 0.869896>, <0.000868, -0.046760, 0.060883>,
			<-0.073839, 0.630131, 0.916053>, <0.113162, -0.022369, 0.029292>
		}
		smooth_triangle {
			<-0.073839, 1.128240, 1.288197>, <0.103888, -0.016774, 0.003874>,
			<-0.000012, 1.168628, 1.262234>, <0.003513, -0.039037, 0.027579>,
			<-0.073839, 0.630131, 0.916053>, <0.113162, -0.022369, 0.029292>
		}
		smooth_triangle {
			<0.006959, 1.168629, 1.660341>, <0.007178, -0.011103, -0.000354>,
			<-0.000012, 1.168628, 1.262234>, <0.003513, -0.039037, 0.027579>,
			<-0.073839, 1.128240, 1.288197>, <0.103888, -0.016774, 0.003874>
		}
		smooth_triangle {
			<-0.044715, 1.128241, 1.622839>, <0.075852, -0.000350, -0.019142>,
			<0.006959, 1.168629, 1.660341>, <0.007178, -0.011103, -0.000354>,
			<-0.073839, 1.128240, 1.288197>, <0.103888, -0.016774, 0.003874>
		}
		smooth_triangle {
			<0.006960, 0.630132, 1.559373>, <0.014790, 0.004194, -0.020671>,
			<0.006959, 1.168629, 1.660341>, <0.007178, -0.011103, -0.000354>,
			<-0.044715, 1.128241, 1.622839>, <0.075852, -0.000350, -0.019142>
		}
		smooth_triangle {
			<-0.044714, 0.630132, 1.518985>, <0.115246, 0.006824, -0.029711>,
			<0.006960, 0.630132, 1.559373>, <0.014790, 0.004194, -0.020671>,
			<-0.044715, 1.128241, 1.622839>, <0.075852, -0.000350, -0.019142>
		}
		smooth_triangle {
			<0.006960, 0.017576, 1.429556>, <0.018662, 0.005098, -0.023877>,
			<0.006960, 0.630132, 1.559373>, <0.014790, 0.004194, -0.020671>,
			<-0.044714, 0.630132, 1.518985>, <0.115246, 0.006824, -0.029711>
		}
		smooth_triangle {
			<-0.044713, 0.017576, 1.389168>, <0.193853, 0.008032, -0.034037>,
			<0.006960, 0.017576, 1.429556>, <0.018662, 0.005098, -0.023877>,
			<-0.044714, 0.630132, 1.518985>, <0.115246, 0.006824, -0.029711>
		}
		smooth_triangle {
			<0.006961, -0.662277, 1.282430>, <0.018134, 0.004954, -0.023201>,
			<0.006960, 0.017576, 1.429556>, <0.018662, 0.005098, -0.023877>,
			<-0.044713, 0.017576, 1.389168>, <0.193853, 0.008032, -0.034037>
		}
		smooth_triangle {
			<-0.044713, -0.662277, 1.242042>, <0.213615, 0.006467, -0.028634>,
			<0.006961, -0.662277, 1.282430>, <0.018134, 0.004954, -0.023201>,
			<-0.044713, 0.017576, 1.389168>, <0.193853, 0.008032, -0.034037>
		}
		smooth_triangle {
			<0.006961, -1.153624, 1.181461>, <0.009627, 0.002531, -0.012317>,
			<0.006961, -0.662277, 1.282430>, <0.018134, 0.004954, -0.023201>,
			<-0.044713, -0.662277, 1.242042>, <0.213615, 0.006467, -0.028634>
		}
		smooth_triangle {
			<-0.044712, -1.153624, 1.141073>, <0.071514, 0.001741, -0.008472>,
			<0.006961, -1.153624, 1.181461>, <0.009627, 0.002531, -0.012317>,
			<-0.044713, -0.662277, 1.242042>, <0.213615, 0.006467, -0.028634>
		}
		smooth_triangle {
			<0.002299, -1.153625, 0.581414>, <-0.000000, 0.060269, 0.000278>,
			<0.006961, -1.153624, 1.181461>, <0.009627, 0.002531, -0.012317>,
			<-0.044712, -1.153624, 1.141073>, <0.071514, 0.001741, -0.008472>
		}
		smooth_triangle {
			<-0.064121, -1.153625, 0.581414>, <0.285500, 0.007264, -0.001092>,
			<0.002299, -1.153625, 0.581414>, <-0.000000, 0.060269, 0.000278>,
			<-0.044712, -1.153624, 1.141073>, <0.071514, 0.001741, -0.008472>
		}
		smooth_triangle {
			<0.011598, -1.146885, -0.246537>, <-0.000000, 0.041106, 0.000060>,
			<0.002299, -1.153625, 0.581414>, <-0.000000, 0.060269, 0.000278>,
			<-0.064121, -1.153625, 0.581414>, <0.285500, 0.007264, -0.001092>
		}
		smooth_triangle {
			<-0.025282, -1.146885, -0.246537>, <0.250367, 0.005399, 0.012201>,
			<0.011598, -1.146885, -0.246537>, <-0.000000, 0.041106, 0.000060>,
			<-0.064121, -1.153625, 0.581414>, <0.285500, 0.007264, -0.001092>
		}
		smooth_triangle {
			<0.013927, -1.153626, -0.762923>, <-0.001430, 0.029532, -0.000406>,
			<0.011598, -1.146885, -0.246537>, <-0.000000, 0.041106, 0.000060>,
			<-0.025282, -1.146885, -0.246537>, <0.250367, 0.005399, 0.012201>
		}
		smooth_triangle {
			<-0.015565, -1.153626, -0.762923>, <0.097668, -0.000008, 0.001269>,
			<0.013927, -1.153626, -0.762923>, <-0.001430, 0.029532, -0.000406>,
			<-0.025282, -1.146885, -0.246537>, <0.250367, 0.005399, 0.012201>
		}
		smooth_triangle {
			<0.015797, -1.168629, -1.660341>, <0.004090, -0.005031, 0.001911>,
			<0.013927, -1.153626, -0.762923>, <-0.001430, 0.029532, -0.000406>,
			<-0.015565, -1.153626, -0.762923>, <0.097668, -0.000008, 0.001269>
		}
		smooth_triangle {
			<-0.007836, -1.160873, -1.589326>, <0.069226, -0.010930, 0.004706>,
			<0.015797, -1.168629, -1.660341>, <0.004090, -0.005031, 0.001911>,
			<-0.015565, -1.153626, -0.762923>, <0.097668, -0.000008, 0.001269>
		}
		smooth_triangle {
			<0.043468, -0.853741, -0.761008>, <-0.170383, -0.014686, 0.006788>,
			<0.039429, -1.160873, -1.589326>, <-0.063842, -0.004681, 0.002047>,
			<0.015797, -1.168629, -1.660341>, <0.004090, -0.005031, 0.001911>
		}
		smooth_triangle {
			<0.013927, -0.834702, -0.777117>, <0.012226, -0.014527, 0.005580>,
			<0.043468, -0.853741, -0.761008>, <-0.170383, -0.014686, 0.006788>,
			<0.015797, -1.168629, -1.660341>, <0.004090, -0.005031, 0.001911>
		}
		smooth_triangle {
			<0.048523, -0.662279, -0.246537>, <-0.207234, -0.015443, 0.017166>,
			<0.043468, -0.853741, -0.761008>, <-0.170383, -0.014686, 0.006788>,
			<0.013927, -0.834702, -0.777117>, <0.012226, -0.014527, 0.005580>
		}
		smooth_triangle {
			<0.011597, -0.635347, -0.272500>, <0.016127, -0.013953, 0.009190>,
			<0.048523, -0.662279, -0.246537>, <-0.207234, -0.015443, 0.017166>,
			<0.013927, -0.834702, -0.777117>, <0.012226, -0.014527, 0.005580>
		}
		smooth_triangle {
			<0.073840, 0.017575, 0.431400>, <-0.194087, -0.027836, 0.033201>,
			<0.048523, -0.662279, -0.246537>, <-0.207234, -0.015443, 0.017166>,
			<0.011597, -0.635347, -0.272500>, <0.016127, -0.013953, 0.009190>
		}
		smooth_triangle {
			<-0.000011, 0.024315, 0.385244>, <0.000271, -0.055363, 0.063185>,
			<0.073840, 0.017575, 0.431400>, <-0.194087, -0.027836, 0.033201>,
			<0.011597, -0.635347, -0.272500>, <0.016127, -0.013953, 0.009190>
		}
		smooth_triangle {
			<0.073840, 0.630131, 0.916053>, <-0.113738, -0.024030, 0.030989>,
			<0.073840, 0.017575, 0.431400>, <-0.194087, -0.027836, 0.033201>,
			<-0.000011, 0.024315, 0.385244>, <0.000271, -0.055363, 0.063185>
		}
		smooth_triangle {
			<-0.000012, 0.643586, 0.869896>, <0.000868, -0.046760, 0.060883>,
			<0.073840, 0.630131, 0.916053>, <-0.113738, -0.024030, 0.030989>,
			<-0.000011, 0.024315, 0.385244>, <0.000271, -0.055363, 0.063185>
		}
		smooth_triangle {
			<0.073840, 1.128241, 1.288196>, <-0.107146, -0.019266, 0.015732>,
			<0.073840, 0.630131, 0.916053>, <-0.113738, -0.024030, 0.030989>,
			<-0.000012, 0.643586, 0.869896>, <0.000868, -0.046760, 0.060883>
		}
		smooth_triangle {
			<-0.000012, 1.168628, 1.262234>, <0.003513, -0.039037, 0.027579>,
			<0.073840, 1.128241, 1.288196>, <-0.107146, -0.019266, 0.015732>,
			<-0.000012, 0.643586, 0.869896>, <0.000868, -0.046760, 0.060883>
		}
		smooth_triangle {
			<0.058655, 1.128241, 1.622839>, <-0.070964, -0.010617, -0.003137>,
			<0.073840, 1.128241, 1.288196>, <-0.107146, -0.019266, 0.015732>,
			<-0.000012, 1.168628, 1.262234>, <0.003513, -0.039037, 0.027579>
		}
		smooth_triangle {
			<0.006959, 1.168629, 1.660341>, <0.007178, -0.011103, -0.000354>,
			<0.058655, 1.128241, 1.622839>, <-0.070964, -0.010617, -0.003137>,
			<-0.000012, 1.168628, 1.262234>, <0.003513, -0.039037, 0.027579>
		}
		smooth_triangle {
			<0.058655, 0.630132, 1.518985>, <-0.113154, 0.005377, -0.024905>,
			<0.058655, 1.128241, 1.622839>, <-0.070964, -0.010617, -0.003137>,
			<0.006959, 1.168629, 1.660341>, <0.007178, -0.011103, -0.000354>
		}
		smooth_triangle {
			<0.006960, 0.630132, 1.559373>, <0.014790, 0.004194, -0.020671>,
			<0.058655, 0.630132, 1.518985>, <-0.113154, 0.005377, -0.024905>,
			<0.006959, 1.168629, 1.660341>, <0.007178, -0.011103, -0.000354>
		}
		smooth_triangle {
			<0.058656, 0.017576, 1.389168>, <-0.193194, 0.006515, -0.028740>,
			<0.058655, 0.630132, 1.518985>, <-0.113154, 0.005377, -0.024905>,
			<0.006960, 0.630132, 1.559373>, <0.014790, 0.004194, -0.020671>
		}
		smooth_triangle {
			<0.006960, 0.017576, 1.429556>, <0.018662, 0.005098, -0.023877>,
			<0.058656, 0.017576, 1.389168>, <-0.193194, 0.006515, -0.028740>,
			<0.006960, 0.630132, 1.559373>, <0.014790, 0.004194, -0.020671>
		}
		smooth_triangle {
			<0.058656, -0.662277, 1.242042>, <-0.215462, 0.006045, -0.027271>,
			<0.058656, 0.017576, 1.389168>, <-0.193194, 0.006515, -0.028740>,
			<0.006960, 0.017576, 1.429556>, <0.018662, 0.005098, -0.023877>
		}
		smooth_triangle {
			<0.006961, -0.662277, 1.282430>, <0.018134, 0.004954, -0.023201>,
			<0.058656, -0.662277, 1.242042>, <-0.215462, 0.006045, -0.027271>,
			<0.006960, 0.017576, 1.429556>, <0.018662, 0.005098, -0.023877>
		}
		smooth_triangle {
			<0.058657, -1.153624, 1.141073>, <-0.076328, 0.002780, -0.013527>,
			<0.058656, -0.662277, 1.242042>, <-0.215462, 0.006045, -0.027271>,
			<0.006961, -0.662277, 1.282430>, <0.018134, 0.004954, -0.023201>
		}
		smooth_triangle {
			<0.006961, -1.153624, 1.181461>, <0.009627, 0.002531, -0.012317>,
			<0.058657, -1.153624, 1.141073>, <-0.076328, 0.002780, -0.013527>,
			<0.006961, -0.662277, 1.282430>, <0.018134, 0.004954, -0.023201>
		}
		smooth_triangle {
			<0.068766, -1.153624, 0.581414>, <-0.000000, 0.029941, 0.000109>,
			<0.058657, -1.153624, 1.141073>, <-0.076328, 0.002780, -0.013527>,
			<0.006961, -1.153624, 1.181461>, <0.009627, 0.002531, -0.012317>
		}
		smooth_triangle {
			<0.002299, -1.153625, 0.581414>, <-0.000000, 0.060269, 0.000278>,
			<0.068766, -1.153624, 0.581414>, <-0.000000, 0.029941, 0.000109>,
			<0.006961, -1.153624, 1.181461>, <0.009627, 0.002531, -0.012317>
		}
		smooth_triangle {
			<0.048524, -1.146885, -0.246537>, <-0.000000, 0.025389, 0.000109>,
			<0.068766, -1.153624, 0.581414>, <-0.000000, 0.029941, 0.000109>,
			<0.002299, -1.153625, 0.581414>, <-0.000000, 0.060269, 0.000278>
		}
		smooth_triangle {
			<0.011598, -1.146885, -0.246537>, <-0.000000, 0.041106, 0.000060>,
			<0.048524, -1.146885, -0.246537>, <-0.000000, 0.025389, 0.000109>,
			<0.002299, -1.153625, 0.581414>, <-0.000000, 0.060269, 0.000278>
		}
		smooth_triangle {
			<0.043469, -1.153626, -0.762923>, <-0.000000, 0.014247, -0.000161>,
			<0.048524, -1.146885, -0.246537>, <-0.000000, 0.025389, 0.000109>,
			<0.011598, -1.146885, -0.246537>, <-0.000000, 0.041106, 0.000060>
		}
		smooth_triangle {
			<0.013927, -1.153626, -0.762923>, <-0.001430, 0.029532, -0.000406>,
			<0.043469, -1.153626, -0.762923>, <-0.000000, 0.014247, -0.000161>,
			<0.011598, -1.146885, -0.246537>, <-0.000000, 0.041106, 0.000060>
		}
		smooth_triangle {
			<0.039429, -1.160873, -1.589326>, <-0.063842, -0.004681, 0.002047>,
			<0.043469, -1.153626, -0.762923>, <-0.000000, 0.014247, -0.000161>,
			<0.013927, -1.153626, -0.762923>, <-0.001430, 0.029532, -0.000406>
		}
		smooth_triangle {
			<0.015797, -1.168629, -1.660341>, <0.004090, -0.005031, 0.001911>,
			<0.039429, -1.160873, -1.589326>, <-0.063842, -0.004681, 0.002047>,
			<0.013927, -1.153626, -0.762923>, <-0.001430, 0.029532, -0.000406>
		}
		smooth_triangle {
			<0.043468, -0.853741, -0.761008>, <-0.170383, -0.014686, 0.006788>,
			<0.043469, -1.153626, -0.762923>, <-0.000000, 0.014247, -0.000161>,
			<0.039429, -1.160873, -1.589326>, <-0.063842, -0.004681, 0.002047>
		}
		smooth_triangle {
			<0.048524, -1.146885, -0.246537>, <-0.000000, 0.025389, 0.000109>,
			<0.043469, -1.153626, -0.762923>, <-0.000000, 0.014247, -0.000161>,
			<0.043468, -0.853741, -0.761008>, <-0.170383, -0.014686, 0.006788>
		}
		smooth_triangle {
			<0.048523, -0.662279, -0.246537>, <-0.207234, -0.015443, 0.017166>,
			<0.048524, -1.146885, -0.246537>, <-0.000000, 0.025389, 0.000109>,
			<0.043468, -0.853741, -0.761008>, <-0.170383, -0.014686, 0.006788>
		}
		smooth_triangle {
			<0.048523, -0.662279, -0.246537>, <-0.207234, -0.015443, 0.017166>,
			<0.073841, -0.662278, 0.215038>, <-0.437503, 0.002363, 0.008138>,
			<0.048524, -1.146885, -0.246537>, <-0.000000, 0.025389, 0.000109>
		}
		smooth_triangle {
			<0.048524, -1.146885, -0.246537>, <-0.000000, 0.025389, 0.000109>,
			<0.073841, -0.662278, 0.215038>, <-0.437503, 0.002363, 0.008138>,
			<0.068766, -1.153624, 0.581414>, <-0.000000, 0.029941, 0.000109>
		}
		smooth_triangle {
			<0.073841, -0.662278, 0.215038>, <-0.437503, 0.002363, 0.008138>,
			<0.068765, -0.669016, 0.777583>, <-0.400700, 0.002820, -0.006818>,
			<0.068766, -1.153624, 0.581414>, <-0.000000, 0.029941, 0.000109>
		}
		smooth_triangle {
			<0.073840, 0.017575, 0.431400>, <-0.194087, -0.027836, 0.033201>,
			<0.073841, -0.662278, 0.215038>, <-0.437503, 0.002363, 0.008138>,
			<0.048523, -0.662279, -0.246537>, <-0.207234, -0.015443, 0.017166>
		}
		smooth_triangle {
			<0.073840, 0.017575, 0.431400>, <-0.194087, -0.027836, 0.033201>,
			<0.073841, 0.017575, 0.728539>, <-0.322473, 0.001445, -0.002436>,
			<0.073841, -0.662278, 0.215038>, <-0.437503, 0.002363, 0.008138>
		}
		smooth_triangle {
			<0.073841, 0.017575, 0.728539>, <-0.322473, 0.001445, -0.002436>,
			<0.068765, -0.669016, 0.777583>, <-0.400700, 0.002820, -0.006818>,
			<0.073841, -0.662278, 0.215038>, <-0.437503, 0.002363, 0.008138>
		}
		smooth_triangle {
			<0.073841, 0.017575, 0.728539>, <-0.322473, 0.001445, -0.002436>,
			<0.068765, 0.017576, 1.077605>, <-0.272046, 0.002781, -0.007041>,
			<0.068765, -0.669016, 0.777583>, <-0.400700, 0.002820, -0.006818>
		}
		smooth_triangle {
			<0.073840, 0.017575, 0.431400>, <-0.194087, -0.027836, 0.033201>,
			<0.073840, 0.630131, 0.916053>, <-0.113738, -0.024030, 0.030989>,
			<0.073841, 0.017575, 0.728539>, <-0.322473, 0.001445, -0.002436>
		}
		smooth_triangle {
			<0.068764, 0.630132, 1.325701>, <-0.156233, 0.001687, -0.005926>,
			<0.068765, 0.017576, 1.077605>, <-0.272046, 0.002781, -0.007041>,
			<0.073840, 0.630131, 1.089143>, <-0.162226, 0.000994, -0.002122>
		}
		smooth_triangle {
			<0.073840, 1.128241, 1.288196>, <-0.107146, -0.019266, 0.015732>,
			<0.073840, 0.630131, 1.089143>, <-0.162226, 0.000994, -0.002122>,
			<0.073840, 0.630131, 0.916053>, <-0.113738, -0.024030, 0.030989>
		}
		smooth_triangle {
			<0.068764, 0.630132, 1.325701>, <-0.156233, 0.001687, -0.005926>,
			<0.073840, 0.630131, 1.089143>, <-0.162226, 0.000994, -0.002122>,
			<0.073840, 1.128241, 1.288196>, <-0.107146, -0.019266, 0.015732>
		}
		smooth_triangle {
			<0.058655, 0.630132, 1.518985>, <-0.113154, 0.005377, -0.024905>,
			<0.068764, 0.630132, 1.325701>, <-0.156233, 0.001687, -0.005926>,
			<0.058655, 1.128241, 1.622839>, <-0.070964, -0.010617, -0.003137>
		}
		smooth_triangle {
			<0.068764, 0.630132, 1.325701>, <-0.156233, 0.001687, -0.005926>,
			<0.073840, 1.128241, 1.288196>, <-0.107146, -0.019266, 0.015732>,
			<0.058655, 1.128241, 1.622839>, <-0.070964, -0.010617, -0.003137>
		}
		smooth_triangle {
			<0.058657, -1.153624, 1.141073>, <-0.076328, 0.002780, -0.013527>,
			<0.068766, -1.153624, 0.581414>, <-0.000000, 0.029941, 0.000109>,
			<0.058656, -0.662277, 1.242042>, <-0.215462, 0.006045, -0.027271>
		}
		smooth_triangle {
			<0.068766, -1.153624, 0.581414>, <-0.000000, 0.029941, 0.000109>,
			<0.068765, -0.669016, 0.777583>, <-0.400700, 0.002820, -0.006818>,
			<0.058656, -0.662277, 1.242042>, <-0.215462, 0.006045, -0.027271>
		}
		smooth_triangle {
			<0.058656, -0.662277, 1.242042>, <-0.215462, 0.006045, -0.027271>,
			<0.068765, -0.669016, 0.777583>, <-0.400700, 0.002820, -0.006818>,
			<0.058656, 0.017576, 1.389168>, <-0.193194, 0.006515, -0.028740>
		}
		smooth_triangle {
			<0.058656, 0.017576, 1.389168>, <-0.193194, 0.006515, -0.028740>,
			<0.068765, -0.669016, 0.777583>, <-0.400700, 0.002820, -0.006818>,
			<0.068765, 0.017576, 1.077605>, <-0.272046, 0.002781, -0.007041>
		}
		smooth_triangle {
			<0.058656, 0.017576, 1.389168>, <-0.193194, 0.006515, -0.028740>,
			<0.068765, 0.017576, 1.077605>, <-0.272046, 0.002781, -0.007041>,
			<0.058655, 0.630132, 1.518985>, <-0.113154, 0.005377, -0.024905>
		}
		smooth_triangle {
			<0.058655, 0.630132, 1.518985>, <-0.113154, 0.005377, -0.024905>,
			<0.068765, 0.017576, 1.077605>, <-0.272046, 0.002781, -0.007041>,
			<0.068764, 0.630132, 1.325701>, <-0.156233, 0.001687, -0.005926>
		}
		smooth_triangle {
			<0.068765, 0.017576, 1.077605>, <-0.272046, 0.002781, -0.007041>,
			<0.073841, 0.017575, 0.728539>, <-0.322473, 0.001445, -0.002436>,
			<0.073840, 0.630131, 1.089143>, <-0.162226, 0.000994, -0.002122>
		}
		smooth_triangle {
			<0.073840, 0.630131, 1.089143>, <-0.162226, 0.000994, -0.002122>,
			<0.073841, 0.017575, 0.728539>, <-0.322473, 0.001445, -0.002436>,
			<0.073840, 0.630131, 0.916053>, <-0.113738, -0.024030, 0.030989>
		}
		texture{_ICP14_Magenta}
	}
}

#declare htail = object {
// This object has the following minimum and maximum values:
// xmin=-3.676283, xmax=3.676292
// ymin=-0.538667, ymax=0.538673
// zmin=-9.976610, zmax=9.976605
	// _ICP8_Black
	union {
		triangle {
			< -0.826721, 0.026530, -0.717454>,
			< 3.398511, 0.065539, -1.461582>,
			< -2.005842, 0.500548, -9.761515>
		}
		triangle {
			< -0.826721, 0.026530, -0.717454>,
			< -2.005842, 0.500548, -9.761515>,
			< -3.381496, 0.500550, -9.761517>
		}
		triangle {
			< -1.858447, 0.228461, -9.976610>,
			< -3.676283, 0.223945, -9.890834>,
			< -3.381496, 0.500550, -9.761517>
		}
		triangle {
			< -2.005842, 0.500548, -9.761515>,
			< -1.858447, 0.228461, -9.976610>,
			< -3.381496, 0.500550, -9.761517>
		}
		triangle {
			< -0.826721, 0.026530, -0.717454>,
			< -1.072376, -0.253708, -0.732196>,
			< 3.644167, -0.212542, -1.562301>
		}
		triangle {
			< -0.826721, 0.026530, -0.717454>,
			< 3.644167, -0.212542, -1.562301>,
			< 3.398511, 0.065539, -1.461582>
		}
		triangle {
			< 3.398511, 0.065539, -1.461582>,
			< 3.644167, -0.212542, -1.562301>,
			< -1.858447, 0.228461, -9.976610>
		}
		triangle {
			< 3.398511, 0.065539, -1.461582>,
			< -1.858447, 0.228461, -9.976610>,
			< -2.005842, 0.500548, -9.761515>
		}
		triangle {
			< -3.676283, 0.223945, -9.890834>,
			< -1.072376, -0.253708, -0.732196>,
			< -0.826721, 0.026530, -0.717454>
		}
		triangle {
			< -3.381496, 0.500550, -9.761517>,
			< -3.676283, 0.223945, -9.890834>,
			< -0.826721, 0.026530, -0.717454>
		}
		triangle {
			< -2.005843, -0.064649, -9.791097>,
			< -3.381497, -0.064647, -9.791099>,
			< -3.676283, 0.223945, -9.890834>
		}
		triangle {
			< -1.858447, 0.228461, -9.976610>,
			< -2.005843, -0.064649, -9.791097>,
			< -3.676283, 0.223945, -9.890834>
		}
		triangle {
			< -1.072376, -0.253708, -0.732196>,
			< -0.826721, -0.538667, -0.747131>,
			< 3.398510, -0.499658, -1.491258>
		}
		triangle {
			< -1.072376, -0.253708, -0.732196>,
			< 3.398510, -0.499658, -1.491258>,
			< 3.644167, -0.212542, -1.562301>
		}
		triangle {
			< 3.644167, -0.212542, -1.562301>,
			< 3.398510, -0.499658, -1.491258>,
			< -2.005843, -0.064649, -9.791097>
		}
		triangle {
			< 3.644167, -0.212542, -1.562301>,
			< -2.005843, -0.064649, -9.791097>,
			< -1.858447, 0.228461, -9.976610>
		}
		triangle {
			< -3.381497, -0.064647, -9.791099>,
			< -0.826721, -0.538667, -0.747131>,
			< -1.072376, -0.253708, -0.732196>
		}
		triangle {
			< -3.676283, 0.223945, -9.890834>,
			< -3.381497, -0.064647, -9.791099>,
			< -1.072376, -0.253708, -0.732196>
		}
		triangle {
			< -2.005843, -0.064649, -9.791097>,
			< 3.398510, -0.499658, -1.491258>,
			< -0.826721, -0.538667, -0.747131>
		}
		triangle {
			< -3.381497, -0.064647, -9.791099>,
			< -2.005843, -0.064649, -9.791097>,
			< -0.826721, -0.538667, -0.747131>
		}
		triangle {
			< -0.696327, -0.501034, 0.747129>,
			< 3.430643, -0.464974, 1.433979>,
			< -1.875480, -0.026526, 9.791085>
		}
		triangle {
			< -0.696327, -0.501034, 0.747129>,
			< -1.875480, -0.026526, 9.791085>,
			< -3.251134, -0.026525, 9.791083>
		}
		triangle {
			< -1.728084, 0.266583, 9.976605>,
			< -3.545920, 0.262067, 9.890724>,
			< -3.251134, -0.026525, 9.791083>
		}
		triangle {
			< -1.875480, -0.026526, 9.791085>,
			< -1.728084, 0.266583, 9.976605>,
			< -3.251134, -0.026525, 9.791083>
		}
		triangle {
			< -0.696327, -0.501034, 0.747129>,
			< -0.941981, -0.220694, 0.732387>,
			< 3.676292, -0.177858, 1.505023>
		}
		triangle {
			< -0.696327, -0.501034, 0.747129>,
			< 3.676292, -0.177858, 1.505023>,
			< 3.430643, -0.464974, 1.433979>
		}
		triangle {
			< 3.430643, -0.464974, 1.433979>,
			< 3.676292, -0.177858, 1.505023>,
			< -1.728084, 0.266583, 9.976605>
		}
		triangle {
			< 3.430643, -0.464974, 1.433979>,
			< -1.728084, 0.266583, 9.976605>,
			< -1.875480, -0.026526, 9.791085>
		}
		triangle {
			< -3.545920, 0.262067, 9.890724>,
			< -0.941981, -0.220694, 0.732387>,
			< -0.696327, -0.501034, 0.747129>
		}
		triangle {
			< -3.251134, -0.026525, 9.791083>,
			< -3.545920, 0.262067, 9.890724>,
			< -0.696327, -0.501034, 0.747129>
		}
		triangle {
			< -1.875479, 0.538671, 9.761416>,
			< -3.251133, 0.538673, 9.761414>,
			< -3.545920, 0.262067, 9.890724>
		}
		triangle {
			< -1.728084, 0.266583, 9.976605>,
			< -1.875479, 0.538671, 9.761416>,
			< -3.545920, 0.262067, 9.890724>
		}
		triangle {
			< -0.941981, -0.220694, 0.732387>,
			< -0.696326, 0.064264, 0.717452>,
			< 3.430644, 0.100223, 1.404404>
		}
		triangle {
			< -0.941981, -0.220694, 0.732387>,
			< 3.430644, 0.100223, 1.404404>,
			< 3.676292, -0.177858, 1.505023>
		}
		triangle {
			< 3.676292, -0.177858, 1.505023>,
			< 3.430644, 0.100223, 1.404404>,
			< -1.875479, 0.538671, 9.761416>
		}
		triangle {
			< 3.676292, -0.177858, 1.505023>,
			< -1.875479, 0.538671, 9.761416>,
			< -1.728084, 0.266583, 9.976605>
		}
		triangle {
			< -3.251133, 0.538673, 9.761414>,
			< -0.696326, 0.064264, 0.717452>,
			< -0.941981, -0.220694, 0.732387>
		}
		triangle {
			< -3.545920, 0.262067, 9.890724>,
			< -3.251133, 0.538673, 9.761414>,
			< -0.941981, -0.220694, 0.732387>
		}
		triangle {
			< -1.875479, 0.538671, 9.761416>,
			< 3.430644, 0.100223, 1.404404>,
			< -0.696326, 0.064264, 0.717452>
		}
		triangle {
			< -3.251133, 0.538673, 9.761414>,
			< -1.875479, 0.538671, 9.761416>,
			< -0.696326, 0.064264, 0.717452>
		}
		texture{_ICP8_Black}
	}
}



object{htail rotate <0,0,0> scale 0.15 translate<-1,1.2,0.51>}

object{vtail rotate <0,-90,0> scale 0.5 translate<-0.8,1.8,0.51>}
object{wings translate <0,0.7,0> scale 0.5 translate<2.4,-0.2,0.51>}


sphere{<0,0,0.51>,0.3 scale<5,0.8,1> translate<0,1.1,0> texture{ pigment{color White} finish{metallic ambient 0.3}}}


//sphere{<5,1,4.5>,3 texture{T_Chrome_3D}}

// A cloud texture by: Jussi Kantola
#declare CloudColors = color_map {
    [0.0 0.1 color SkyBlue color SkyBlue]
   [0.70 color rgb <4/5, 4/5, 5/6>]
   [1.0 color White]
}

#declare CloudTexture = texture {
   pigment{
      bozo
      turbulence 0.5
      octaves 3
      lambda 6
      color_map { CloudColors }
   }
   finish { ambient 1 diffuse 0 }
   scale 1/6
}

sphere {
   <0, 0, 0>, 1
   texture { CloudTexture }
   scale <1000.000000, 100.000000, 1000.000000>
}


#declare ConColors = color_map {
    [0.0 0.1 color rgbt <0,0,0,1> color rgbt <0,0,0,1>]
   [0.20 color rgbt <1, 1, 1, 1>]
   [0.8 1.0 color White color White]
}

#declare ConTexture = texture {
   pigment{
      bozo
      turbulence 0.5
      octaves 3
      lambda 6
      color_map { ConColors }
   }
   finish { ambient 1 diffuse 0 }
   scale <0.5,1,1>
}


#declare contrail=union{
  sphere{<0,0,0>,0.4 scale<5,0.8,1>}
  cylinder{<-100,0,0>,<0,0,0> 0.4}
  texture { ConTexture }
}


object{contrail translate <-2,0,1.95>}
object{contrail translate <-2,0,-0.76>}




