//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 1 lights, 31 textures and 340 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 12/22/1996    (22.12.1996)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <-27.690, -24.415, 1.465>
  direction <0.0,     0.0,  1.9067>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-1.175, 0.050, 0.515>
}

// *******  L I G H T S *******
light_source {   // Light001
  <-7.900, -6.265, 5.475>
  color rgb <1.000, 1.000, 1.000>
}


// ********  TEXTURES  *******
//

#include "airship2.inc"



// ********  REFERENCED OBJECTS  *******

#declare White_line = object {
  box { // White_line
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 0.5, 0.02>
    translate  <0.0, 0.02, -3.05>
  }
}


#declare Strut1 = object {
  cylinder { // Strut1
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 0.525>
    translate  <1.96, -0.97, 0.0>
  }
}
#declare Part_Wall = merge {
  box { // Cube19
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Wall_text1
    }
    no_shadow
    scale <0.2, 0.2, 2.88>
    translate  <6.99, 5.395, -0.425>
  }
  box { // Cube18
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Wall_text2
    }
    no_shadow
    scale <0.2, 0.2, 2.88>
    translate  <7.19, 4.995, -0.425>
  }
  no_shadow
}
#declare Wall = union {
  object { Part_Wall }
  object { // Part_Wall1->Part_Wall
    Part_Wall
    translate  -0.8*y
  }
  object { // Part_Wall2->Part_Wall
    Part_Wall
    translate  -1.6*y
  }
  object { // Part_Wall3->Part_Wall
    Part_Wall
    translate  -2.4*y
  }
  object { // Part_Wall4->Part_Wall
    Part_Wall
    translate  -3.2*y
  }
  object { // Part_Wall5->Part_Wall
    Part_Wall
    translate  -4.0*y
  }
  object { // Part_Wall6->Part_Wall
    Part_Wall
    translate  -4.8*y
  }
  object { // Part_Wall7->Part_Wall
    Part_Wall
    translate  -5.6*y
  }
  object { // Part_Wall8->Part_Wall
    Part_Wall
    translate  -6.4*y
  }
  object { // Part_Wall9->Part_Wall
    Part_Wall
    translate  -7.2*y
  }
  object { // Part_Wall10->Part_Wall
    Part_Wall
    translate  -8.0*y
  }
  object { // Part_Wall11->Part_Wall
    Part_Wall
    translate  -8.8*y
  }
  object { // Part_Wall12->Part_Wall
    Part_Wall
    translate  -9.6*y
  }
  object { // Part_Wall13->Part_Wall
    Part_Wall
    translate  -10.4*y
  }
  object { // Part_Wall14->Part_Wall
    Part_Wall
    translate  -11.2*y
  }
  object { // Part_Wall15->Part_Wall
    Part_Wall
    translate  -12.0*y
  }
  object { // Part_Wall16->Part_Wall
    Part_Wall
    translate  -12.8*y
  }
  object { // Part_Wall17->Part_Wall
    Part_Wall
    translate  -13.6*y
  }
  object { // Part_Wall18->Part_Wall
    Part_Wall
    translate  -14.4*y
  }
  object { // Part_Wall19->Part_Wall
    Part_Wall
    translate  -15.2*y
  }
  object { // Part_Wall20->Part_Wall
    Part_Wall
    translate  -16.0*y
  }
  object { // Part_Wall21->Part_Wall
    Part_Wall
    translate  -16.8*y
  }
  no_shadow
}


#declare rf2 = difference {
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1 open
    no_shadow
    scale <0.05, 0.05, 2.0>
  }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1 open
    no_shadow
    scale <0.05, 0.05, 2.05>
    rotate 180.0*x
    translate  <0.0, 0.005, 2.035>
  }
  no_shadow
  rotate 180.0*x
  translate  <0.1, 0.0, 2.0>
}
#declare rf1 = difference {
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1 open
    no_shadow
    scale <0.05, 0.05, 2.0>
  }
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1 open
    no_shadow
    scale <0.05, 0.05, 2.05>
    rotate 0.0*x
    translate  <0.0, 0.005, -0.035>
  }
  no_shadow
}
#declare rof2 = merge {
  object { rf2 }
  object { rf1 }
  no_shadow
  translate  -2.11*x
}






// ********  OBJECTS  *******

union { // Road_Markings2
  box { // White_line42
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 0.5, 0.02>
    translate  <0.0, 0.02, -3.05>
  }
  object { // White_line43->White_line
    White_line
    translate  2.0*y
  }
  object { // White_line44->White_line
    White_line
    translate  4.0*y
  }
  object { // White_line45->White_line
    White_line
    translate  6.0*y
  }
  object { // White_line46->White_line
    White_line
    translate  8.0*y
  }
  object { // White_line47->White_line
    White_line
    translate  10.0*y
  }
  object { // White_line48->White_line
    White_line
    translate  12.0*y
  }
  object { // White_line49->White_line
    White_line
    translate  14.0*y
  }
  texture {
    White_marks
  }
  rotate -90.0*z
  translate  <-9.77, -2.855, 0.0>
}


union { // Road_Markings1
  box { // White_line21
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 0.5, 0.02>
    translate  <0.0, 0.02, -3.05>
  }
  object { // White_line22->White_line
    White_line
    translate  2.0*y
  }
  object { // White_line23->White_line
    White_line
    translate  4.0*y
  }
  object { // White_line24->White_line
    White_line
    translate  6.0*y
  }
  object { // White_line25->White_line
    White_line
    translate  8.0*y
  }
  object { // White_line26->White_line
    White_line
    translate  10.0*y
  }
  object { // White_line27->White_line
    White_line
    translate  12.0*y
  }
  object { // White_line28->White_line
    White_line
    translate  14.0*y
  }
  object { // White_line29->White_line
    White_line
    translate  16.0*y
  }
  object { // White_line30->White_line
    White_line
    translate  18.0*y
  }
  object { // White_line31->White_line
    White_line
    translate  20.0*y
  }
  object { // White_line32->White_line
    White_line
    translate  22.0*y
  }
  object { // White_line33->White_line
    White_line
    translate  24.0*y
  }
  object { // White_line34->White_line
    White_line
    translate  26.0*y
  }
  object { // White_line35->White_line
    White_line
    translate  28.0*y
  }
  object { // White_line36->White_line
    White_line
    translate  30.0*y
  }
  object { // White_line37->White_line
    White_line
    translate  32.0*y
  }
  object { // White_line38->White_line
    White_line
    translate  34.0*y
  }
  object { // White_line39->White_line
    White_line
    translate  36.0*y
  }
  object { // White_line40->White_line
    White_line
    translate  38.0*y
  }
  object { // White_line41->White_line
    White_line
    translate  40.0*y
  }
  texture {
    White_marks
  }
  translate  <9.565, -7.955, 0.0>
}


union { // Road_Markings
  object { White_line }
  object { // White_line1->White_line
    White_line
    translate  2.0*y
  }
  object { // White_line2->White_line
    White_line
    translate  4.0*y
  }
  object { // White_line3->White_line
    White_line
    translate  6.0*y
  }
  object { // White_line4->White_line
    White_line
    translate  8.0*y
  }
  object { // White_line5->White_line
    White_line
    translate  10.0*y
  }
  object { // White_line6->White_line
    White_line
    translate  12.0*y
  }
  object { // White_line7->White_line
    White_line
    translate  14.0*y
  }
  object { // White_line8->White_line
    White_line
    translate  16.0*y
  }
  object { // White_line9->White_line
    White_line
    translate  18.0*y
  }
  object { // White_line10->White_line
    White_line
    translate  20.0*y
  }
  object { // White_line11->White_line
    White_line
    translate  22.0*y
  }
  object { // White_line12->White_line
    White_line
    translate  24.0*y
  }
  object { // White_line13->White_line
    White_line
    translate  26.0*y
  }
  object { // White_line14->White_line
    White_line
    translate  28.0*y
  }
  object { // White_line15->White_line
    White_line
    translate  30.0*y
  }
  object { // White_line16->White_line
    White_line
    translate  32.0*y
  }
  object { // White_line17->White_line
    White_line
    translate  34.0*y
  }
  object { // White_line18->White_line
    White_line
    translate  36.0*y
  }
  object { // White_line19->White_line
    White_line
    translate  38.0*y
  }
  object { // White_line20->White_line
    White_line
    translate  40.0*y
  }
  texture {
    White_marks
  }
  translate  -20.0*y
}


#declare Eng_back3 = difference {
  superellipsoid { // Eng_body3
    <1.0, 2.0>
    scale <0.7, 0.7, 2.465>
    rotate -90.0*x
    translate  -0.535*y
  }
  box { // Cube23
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 1.3, 1.2>
    translate  <-0.015, -1.995, 0.02>
  }
}
union { // Airship_eng_w3
  box { // Prop8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.002, 1.65>
    rotate -90.0*y
    translate  <0.015, -0.86, 0.0>
  }
  superellipsoid { // Air_engine3
    <1.0, 0.1>
    scale <0.6, 0.6, 0.07>
    rotate -90.0*x
    translate  <-0.01, -0.76, 0.0>
  }
  box { // Prop9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.002, 1.65>
    translate  <0.015, -0.85, 0.0>
  }
  superellipsoid { // SuprQ4
    <1.0, 2.0>
    scale 0.35
    rotate -90.0*x
    translate  <-0.01, -0.805, 0.0>
  }
  sphere { // Joint3
    <0,0,0>,1
    scale 0.285
    translate  <0.005, -0.015, 0.525>
  }
  cylinder { // Air_eng_arm3
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 2.5>
    rotate 54.684998*y
    translate  <0.005, -0.005, 0.585>
  }
  object { Eng_back3 }
  texture {
    Air_eng_text
  }
  scale 0.12
  rotate <-5.0, 0.0, -180.0>
  translate  <0.7, 2.11, -1.02>
}


#declare Eng_back2 = difference {
  superellipsoid { // Eng_body2
    <1.0, 2.0>
    scale <0.7, 0.7, 2.465>
    rotate -90.0*x
    translate  -0.535*y
  }
  box { // Cube22
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 1.3, 1.2>
    translate  <-0.015, -1.995, 0.02>
  }
}
union { // Airship_eng_w2
  box { // Prop6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.002, 1.65>
    rotate -90.0*y
    translate  <0.015, -0.86, 0.0>
  }
  superellipsoid { // Air_engine2
    <1.0, 0.1>
    scale <0.6, 0.6, 0.07>
    rotate -90.0*x
    translate  <-0.01, -0.76, 0.0>
  }
  box { // Prop7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.002, 1.65>
    translate  <0.015, -0.85, 0.0>
  }
  superellipsoid { // SuprQ3
    <1.0, 2.0>
    scale 0.35
    rotate -90.0*x
    translate  <-0.01, -0.805, 0.0>
  }
  sphere { // Joint2
    <0,0,0>,1
    scale 0.285
    translate  <0.005, -0.015, 0.525>
  }
  cylinder { // Air_eng_arm2
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 2.5>
    rotate -54.684998*y
    translate  <0.005, -0.005, 0.585>
  }
  object { Eng_back2 }
  texture {
    Air_eng_text
  }
  scale 0.12
  rotate <-5.0, 0.0, -180.0>
  translate  <-0.62, 2.105, -1.025>
}


#declare Struts3 = union {
  cylinder { // Strut8
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 0.525>
    translate  <1.96, -0.97, 0.0>
  }
  object { // Strut10->Strut1
    Strut1
    translate  -2.435*x
  }
  object { // Strut13->Strut1
    Strut1
    translate  -3.95*x
  }
  object { // Strut14->Strut1
    Strut1
    translate  -1.5*x
  }
  translate  0.555*y
}
#declare Struts4 = union {
  cylinder { // Strut2
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 0.525>
    translate  <1.96, -0.97, 0.0>
  }
  object { // Strut5->Strut1
    Strut1
    translate  -2.435*x
  }
  object { // Strut15->Strut1
    Strut1
    translate  -3.95*x
  }
  object { // Strut16->Strut1
    Strut1
    translate  -1.5*x
  }
}
#declare Windscren1 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 1.820046>, <1.000000, -1.000000, 1.820046>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.820046>, <1.000000, 0.000000, 1.820046>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  texture {
    Glass3
  }
  scale 0.11
  rotate <0.0, 0.0, 90.0>
  translate  <-0.055, -0.765457, 0.230654>
}
union { // Bi_Plane1
  cylinder { // Leg4
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 0.2>
    translate  <-0.005, 1.345, -0.435>
  }
  cylinder { // Wheel4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Wheel_text
    }
    scale 0.09
    rotate -90.0*y
    translate  <-0.02, 1.33, -0.44>
  }
  box { // Prop2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Chrome_Textur1
    }
    scale <0.545, 0.015, 0.055>
    rotate -45.0*y
    translate  -1.645*y
  }
  cylinder { // Engine1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal1
    }
    scale <0.305, 0.305, 0.075>
    rotate -90.0*x
    translate  <-0.005, -1.585, -0.02>
  }
  sphere { // Sphere3
    <0,0,0>,1
    scale <0.025, 0.335, 0.7>
    rotate -90.0*y
    translate  <0.01, 1.155, 0.005>
  }
  sphere { // Sphere4
    <0,0,0>,1
    scale <0.025, 0.28, 0.4>
    translate  <0.01, 1.18, 0.15>
  }
  cylinder { // Wheel5
    <0,0,1>, <0,0,0>, 1 
    texture {
      Wheel_text
    }
    scale 0.09
    rotate -90.0*y
    translate  <0.455, -0.745, -0.61>
  }
  cylinder { // Wheel6
    <0,0,1>, <0,0,0>, 1 
    texture {
      Wheel_text
    }
    scale 0.09
    rotate -90.0*y
    translate  <-0.385, -0.745, -0.61>
  }
  cylinder { // Leg5
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 0.5>
    rotate -31.785*y
    translate  <0.365, -0.74, -0.63>
  }
  cylinder { // Leg6
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 0.5>
    rotate 31.785*y
    translate  <-0.39, -0.74, -0.625>
  }
  object { Struts3 }
  object { Struts4 }
  box { // Top_Wing2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Wing_text
    }
    scale <2.0, 0.3, 0.01>
    translate  <0.0, -0.685, 0.52>
  }
  box { // Top_Wing3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Wing_text
    }
    scale <2.0, 0.3, 0.01>
    translate  -0.685*y
  }
  superellipsoid { // PLane_Body1
    <0.1, 0.1>
    scale <0.25, 1.5, 0.25>
  }
  superellipsoid { // Nose_cone1
    <1.0, 2.0>
    scale 0.2
    rotate -90.0*x
    translate  <0.0, -1.592944, -0.025058>
  }
  object { Windscren1 }
  texture {
    Plane_text
  }
  scale 0.5
  rotate <31.136127, 1.61101, 3.788424>
  translate  <-6.815, 6.6, 4.135>
}


object { // Wall1->Wall
  Wall
  translate  <5.22, 0.0, 0.085>
}


union { // All_runway
  box { // Runway
    <-1, -1, -1>, <1, 1, 1>
    no_shadow
    scale <3.6, 25.0, 0.115>
    translate  <0.0, 0.15, -3.155>
  }
  box { // Runway1
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 11.0, 0.115>
    rotate -90.0*z
    translate  <0.0, -2.785, -3.155>
  }
  box { // Runway2
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 25.0, 0.115>
    translate  <9.585, 11.365, -3.16>
  }
  texture {
    Gray_road
  }
}


#declare Bit7 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.234559, -2.000000, 0.982076>, <-0.234559, -2.000000, 0.982076>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, 
      <-1.234559, -1.000000, 0.982076>, <-0.234559, -1.000000, 0.982076>, <0.000000, -1.000000, 0.000000>, <-0.343133, -1.000000, 0.722115>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <-0.343133, 0.000000, 0.722115>, 
      <-1.826693, 1.000000, -0.664345>, <-0.826693, 1.000000, -0.664345>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  scale 0.14
  rotate <8.495001, -40.310001, -19.134998>
  translate  <0.27, 0.15, -2.045>
}
#declare Bit6 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.234559, -2.000000, 0.982076>, <-0.234559, -2.000000, 0.982076>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, 
      <-1.234559, -1.000000, 0.982076>, <-0.234559, -1.000000, 0.982076>, <0.000000, -1.000000, 0.000000>, <-0.343133, -1.000000, 0.722115>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <-0.343133, 0.000000, 0.722115>, 
      <-1.826693, 1.000000, -0.664345>, <-0.826693, 1.000000, -0.664345>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  scale 0.14
  rotate <0.0, 76.545006, 92.499992>
  translate  <0.13, 0.0, -3.36>
}
#declare Bit5 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.234559, -2.000000, 0.982076>, <-0.234559, -2.000000, 0.982076>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, 
      <-1.234559, -1.000000, 0.982076>, <-0.234559, -1.000000, 0.982076>, <0.000000, -1.000000, 0.000000>, <-0.343133, -1.000000, 0.722115>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <-0.343133, 0.000000, 0.722115>, 
      <-1.826693, 1.000000, -0.664345>, <-0.826693, 1.000000, -0.664345>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  scale 0.14
  rotate <0.0, 0.0, -177.74501>
  translate  <-0.21, 0.0, -3.915>
}
#declare Bit4 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.234559, -2.000000, 0.982076>, <-0.234559, -2.000000, 0.982076>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, 
      <-1.234559, -1.000000, 0.982076>, <-0.234559, -1.000000, 0.982076>, <0.000000, -1.000000, 0.000000>, <-0.343133, -1.000000, 0.722115>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <-0.343133, 0.000000, 0.722115>, 
      <-1.826693, 1.000000, -0.664345>, <-0.826693, 1.000000, -0.664345>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  scale 0.14
  rotate 75.319992*y
  translate  <0.065, -0.56, -3.87>
}
#declare Bit3 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.234559, -2.000000, 0.982076>, <-0.234559, -2.000000, 0.982076>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, 
      <-1.234559, -1.000000, 0.982076>, <-0.234559, -1.000000, 0.982076>, <0.000000, -1.000000, 0.000000>, <-0.343133, -1.000000, 0.722115>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <-0.343133, 0.000000, 0.722115>, 
      <-1.826693, 1.000000, -0.664345>, <-0.826693, 1.000000, -0.664345>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  scale 0.14
  rotate -27.224997*x
  translate  <0.06, 0.755, -3.75>
}
#declare Bit2 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.234559, -2.000000, 0.982076>, <-0.234559, -2.000000, 0.982076>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, 
      <-1.234559, -1.000000, 0.982076>, <-0.234559, -1.000000, 0.982076>, <0.000000, -1.000000, 0.000000>, <-0.343133, -1.000000, 0.722115>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <-0.343133, 0.000000, 0.722115>, 
      <-1.826693, 1.000000, -0.664345>, <-0.826693, 1.000000, -0.664345>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  scale 0.14
  rotate <-180.0, -88.349998, -180.0>
  translate  <0.05, 0.0, -3.685>
}
#declare Bit1 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.234559, -2.000000, 0.982076>, <-0.234559, -2.000000, 0.982076>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, 
      <-1.234559, -1.000000, 0.982076>, <-0.234559, -1.000000, 0.982076>, <0.000000, -1.000000, 0.000000>, <-0.343133, -1.000000, 0.722115>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <-0.343133, 0.000000, 0.722115>, 
      <-1.826693, 1.000000, -0.664345>, <-0.826693, 1.000000, -0.664345>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  scale 0.14
  translate  <0.44, 0.0, -3.9>
}
union { // Bits
  object { Bit7 }
  object { Bit6 }
  object { Bit5 }
  object { Bit4 }
  object { Bit3 }
  object { Bit2 }
  object { Bit1 }
  texture {
    Airship_Grey
  }
  translate  <-0.065, 0.0, 1.04>
}


difference { // Hanger
  object { Wall }
  box { // Cut_Door
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Hnger
    }
    scale <0.317625, 2.38125, 2.1573>
    translate  <7.095799, -2.84875, -1.0727>
  }
  no_shadow
}


#declare gond2 = difference {
  box { // Cube12
    <-1, -1, -1>, <1, 1, 1>
    scale <0.35625, 1.075, 0.475>
    translate  <0.03375, -4.66, -0.535>
  }
  box { // Cube13
    <-1, -1, -1>, <1, 1, 1>
    scale <0.34, 1.06, 0.43>
    translate  <0.035, -4.66, -0.565>
  }
  scale <1.333333, 1.0, 1.0>
  rotate 0.0*x
  translate  <0.0, 1.12, -0.18>
}
#declare gon_fnt2 = difference {
  box { // Cube14
    <-1, -1, -1>, <1, 1, 1>
    scale <0.35625, 0.475, 0.475>
    rotate 20.0*x
    translate  <0.03375, -5.46, -0.405>
  }
  box { // Cube15
    <-1, -1, -1>, <1, 1, 1>
    scale <0.33, 0.45, 0.45>
    rotate 20.0*x
    translate  <0.045, -5.46, -0.405>
  }
  scale <1.333333, 1.0, 1.0>
  rotate 0.0*x
  translate  <0.0, 1.12, -0.18>
}
#declare gond_bck2 = difference {
  box { // Cube16
    <-1, -1, -1>, <1, 1, 1>
    scale <0.35625, 0.475, 0.475>
    rotate 20.0*x
    translate  <0.03375, -3.315, -0.395>
  }
  box { // Cube17
    <-1, -1, -1>, <1, 1, 1>
    scale <0.33, 0.45, 0.45>
    rotate 20.0*x
    translate  <0.045, -3.32, -0.395>
  }
  scale <1.333333, 1.0, 1.0>
  rotate 0.0*x
  translate  <0.0, 1.12, -0.18>
}
#declare gondala2 = union {
  object { gond2 }
  object { gon_fnt2 }
  object { gond_bck2 }
  scale <0.75, 1.0, 1.0>
  translate  <0.0, -1.12, 0.18>
}
#declare windows2 = difference {
  object { gondala2 }
  box { // window6
    <-1, -1, -1>, <1, 1, 1>
    scale 0.09
    translate  <-0.305, -4.905, -0.81>
  }
  box { // window7
    <-1, -1, -1>, <1, 1, 1>
    scale 0.09
    translate  <-0.305, -4.07, -0.81>
  }
  box { // window8
    <-1, -1, -1>, <1, 1, 1>
    scale 0.09
    translate  <-0.305, -5.595, -0.81>
  }
  translate  <2.065, 0.0, -0.01>
}
merge { // Airship_tot2
  sphere { // Airship2
    <0,0,0>,1
    scale <1.0, 7.535, 0.895>
    translate  <2.105, 0.145, -0.01>
  }
  sphere { // Top_Fin4
    <0,0,0>,1
    scale <0.025, 1.0, 1.88>
    translate  <2.105, 5.835, -0.06>
  }
  sphere { // Top_Fin5
    <0,0,0>,1
    scale <0.05, 1.0, 2.0>
    rotate -90.0*y
    translate  <2.105, 6.09, -0.055>
  }
  sphere { // Rib22
    <0,0,0>,1
    scale <1.0, 7.7, 0.02>
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib23
    <0,0,0>,1
    scale <1.0, 7.7, 0.02>
    rotate -20.0*y
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib24
    <0,0,0>,1
    scale <1.0, 7.7, 0.02>
    rotate -40.0*y
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib25
    <0,0,0>,1
    scale <1.0, 7.7, 0.02>
    rotate -60.0*y
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib26
    <0,0,0>,1
    scale <1.0, 7.7, 0.02>
    rotate -80.0*y
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib27
    <0,0,0>,1
    scale <1.0, 7.7, 0.02>
    rotate <180.0, -80.0, 180.0>
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib28
    <0,0,0>,1
    scale <1.0, 7.7, 0.02>
    rotate <180.0, -60.0, 180.0>
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib29
    <0,0,0>,1
    scale <1.0, 7.7, 0.02>
    rotate <180.0, -40.0, 180.0>
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib30
    <0,0,0>,1
    scale <1.0, 7.7, 0.02>
    rotate <180.0, -20.0, 180.0>
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib31
    <0,0,0>,1
    scale <1.0, 7.7, 0.02>
    rotate <180.0, 0.0, 180.0>
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib32
    <0,0,0>,1
    scale <1.0, 7.7, 0.02>
    rotate <180.0, 20.0, 180.0>
    translate  <2.105, 0.155, 0.0>
  }
  object { windows2 }
  texture {
    Airship_Grey
  }
  translate  <7.635, -3.535, -1.35>
}


sphere { // Sky_sphere
  <0,0,0>,1
  texture {
    Blue_Sky4
  }
  no_shadow
  hollow
  scale 32.434998
  translate  -10.365*x
}


#declare Wind_Sock_Main = union {
  cone { // Cone001
    <0,0,0>, 0.1, <0,0,1>, 0.5
    texture {
      winsock_text
      scale <0.5, 0.5, 0.95>
    }
    no_shadow
    hollow
    scale <1.0, 1.0, 1.95>
    rotate <0.0, 0.0, 0.0>
    translate  <5.9, 5.25, 1.8>
  }
  cylinder { // string3
    <0,0,1>, <0,0,0>, 1 
    no_shadow
    scale <0.008, 0.008, 1.0>
    rotate -20.0*y
    translate  <6.4, 5.3, 3.75>
  }
  cylinder { // string2
    <0,0,1>, <0,0,0>, 1 
    no_shadow
    scale <0.008, 0.008, 1.0>
    rotate 20.0*y
    translate  <5.4, 5.3, 3.75>
  }
  cylinder { // string1
    <0,0,1>, <0,0,0>, 1 
    no_shadow
    scale <0.008, 0.008, 1.0>
    rotate 20.0*x
    translate  <5.9, 5.8, 3.75>
  }
  cylinder { // string
    <0,0,1>, <0,0,0>, 1 
    no_shadow
    scale <0.008, 0.008, 1.0>
    rotate -20.0*x
    translate  <5.9, 4.8, 3.75>
  }
  texture {
    Grnd
  }
  no_shadow
  rotate 75.0*x
  translate  <0.0, 6.5, -3.5>
}
union { // Wind_sock_whole
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    texture {
      Pole_text
    }
    no_shadow
    scale <0.1, 0.1, 6.25>
    translate  <5.9, 3.35, -3.25>
  }
  object { Wind_Sock_Main }
  no_shadow
  scale 0.51
  translate  <0.0, 10.41, -1.455>
}


plane { // Ground
  z,0
  texture {
    Grnd
  }
  no_shadow
  translate  <6.78, 0.0, -3.18>
}


#declare gond1 = difference {
  box { // Cube6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.35625, 1.075, 0.475>
    translate  <0.03375, -4.66, -0.535>
  }
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.34, 1.06, 0.43>
    translate  <0.035, -4.66, -0.565>
  }
  scale <1.333333, 1.0, 1.0>
  rotate 0.0*x
  translate  <0.0, 1.12, -0.18>
}
#declare gon_fnt1 = difference {
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.35625, 0.475, 0.475>
    rotate 20.0*x
    translate  <0.03375, -5.46, -0.405>
  }
  box { // Cube9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.33, 0.45, 0.45>
    rotate 20.0*x
    translate  <0.045, -5.46, -0.405>
  }
  scale <1.333333, 1.0, 1.0>
  rotate 0.0*x
  translate  <0.0, 1.12, -0.18>
}
#declare gond_bck1 = difference {
  box { // Cube10
    <-1, -1, -1>, <1, 1, 1>
    scale <0.35625, 0.475, 0.475>
    rotate 20.0*x
    translate  <0.03375, -3.315, -0.395>
  }
  box { // Cube11
    <-1, -1, -1>, <1, 1, 1>
    scale <0.33, 0.45, 0.45>
    rotate 20.0*x
    translate  <0.045, -3.32, -0.395>
  }
  scale <1.333333, 1.0, 1.0>
  rotate 0.0*x
  translate  <0.0, 1.12, -0.18>
}
#declare gondala1 = union {
  object { gond1 }
  object { gon_fnt1 }
  object { gond_bck1 }
  scale <0.75, 1.0, 1.0>
  translate  <0.0, -1.12, 0.18>
}
#declare windows1 = difference {
  object { gondala1 }
  box { // window3
    <-1, -1, -1>, <1, 1, 1>
    scale 0.09
    translate  <-0.305, -4.93, -0.84>
  }
  box { // window4
    <-1, -1, -1>, <1, 1, 1>
    scale 0.09
    translate  <-0.305, -3.915, -0.85>
  }
  box { // window5
    <-1, -1, -1>, <1, 1, 1>
    scale 0.09
    translate  <-0.305, -5.505, -0.82>
  }
  box { // window9
    <-1, -1, -1>, <1, 1, 1>
    scale 0.09
    translate  <-0.305, -5.215, -0.825>
  }
  box { // window10
    <-1, -1, -1>, <1, 1, 1>
    scale 0.09
    translate  <-0.305, -4.61, -0.835>
  }
  box { // window11
    <-1, -1, -1>, <1, 1, 1>
    scale 0.09
    translate  <-0.305, -4.27, -0.845>
  }
  translate  <2.065, 0.0, -0.01>
}
#declare Airship_tot1 = merge {
  sphere { // Airship1
    <0,0,0>,1
    hollow
    scale <1.0, 7.55, 0.895>
    translate  <2.105, 0.095, 0.0>
  }
  sphere { // Top_Fin2
    <0,0,0>,1
    hollow
    scale <0.025, 1.0, 1.88>
    translate  <2.105, 5.835, -0.06>
  }
  sphere { // Top_Fin3
    <0,0,0>,1
    hollow
    scale <0.05, 1.0, 2.0>
    rotate -90.0*y
    translate  <2.105, 6.09, -0.055>
  }
  sphere { // Rib11
    <0,0,0>,1
    hollow
    scale <1.0, 7.6, 0.02>
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib12
    <0,0,0>,1
    hollow
    scale <1.0, 7.6, 0.02>
    rotate -20.0*y
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib13
    <0,0,0>,1
    hollow
    scale <1.0, 7.6, 0.02>
    rotate -40.0*y
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib14
    <0,0,0>,1
    hollow
    scale <1.0, 7.6, 0.02>
    rotate -60.0*y
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib15
    <0,0,0>,1
    hollow
    scale <0.92, 7.6, 0.02>
    rotate -80.0*y
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib16
    <0,0,0>,1
    hollow
    scale <1.0, 7.6, 0.02>
    rotate <180.0, -80.0, 180.0>
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib17
    <0,0,0>,1
    hollow
    scale <1.0, 7.6, 0.02>
    rotate <180.0, -60.0, 180.0>
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib18
    <0,0,0>,1
    hollow
    scale <1.0, 7.6, 0.02>
    rotate <180.0, -40.0, 180.0>
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib19
    <0,0,0>,1
    hollow
    scale <1.0, 7.6, 0.02>
    rotate <180.0, -20.0, 180.0>
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib20
    <0,0,0>,1
    hollow
    scale <1.0, 7.6, 0.02>
    rotate <180.0, 0.0, 180.0>
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib21
    <0,0,0>,1
    hollow
    scale <1.0, 7.6, 0.02>
    rotate <180.0, 20.0, 180.0>
    translate  <2.105, 0.155, 0.0>
  }
  object { windows1 }
  hollow
  translate  <-2.065, 0.0, 0.01>
}
#declare HgtFld2 = object { 
  height_field {
    gif "D:\RAY\UTILS\MORAY25\MAPS\PLASMA2.GIF"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <1.0, 1.0, 0.5>
  rotate <90.0, -90.0, 0.0>
  translate  <0.0, 0.38, -0.025>
}
#declare Font_air_tot = difference {
  object { Airship_tot1 }
  box { // Cut_back
    <-1, -1, -1>, <1, 1, 1>
    scale <2.21, 3.8, 2.21>
    translate  <0.0, 4.78, 0.035>
  }
  object { HgtFld2 }
  hollow
  rotate -15.0*x
  translate  <0.0, -1.085, 0.45>
}
#declare gond = difference {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <0.35625, 1.075, 0.475>
    translate  <0.03375, -4.66, -0.535>
  }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.34, 1.06, 0.43>
    translate  <0.035, -4.66, -0.565>
  }
  scale <1.333333, 1.0, 1.0>
  rotate 0.0*x
  translate  <0.0, 1.12, -0.18>
}
#declare gon_fnt = difference {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <0.35625, 0.475, 0.475>
    rotate 20.0*x
    translate  <0.03375, -5.46, -0.405>
  }
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.33, 0.45, 0.45>
    rotate 20.0*x
    translate  <0.045, -5.46, -0.405>
  }
  scale <1.333333, 1.0, 1.0>
  rotate 0.0*x
  translate  <0.0, 1.12, -0.18>
}
#declare gond_bck = difference {
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.35625, 0.475, 0.475>
    rotate 20.0*x
    translate  <0.03375, -3.315, -0.395>
  }
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.33, 0.45, 0.45>
    rotate 20.0*x
    translate  <0.045, -3.32, -0.395>
  }
  scale <1.333333, 1.0, 1.0>
  rotate 0.0*x
  translate  <0.0, 1.12, -0.18>
}
#declare gondala = union {
  object { gond }
  object { gon_fnt }
  object { gond_bck }
  scale <0.75, 1.0, 1.0>
  translate  <0.0, -1.12, 0.18>
}
#declare windows = difference {
  object { gondala }
  box { // window
    <-1, -1, -1>, <1, 1, 1>
    scale 0.09
    translate  <-0.305, -4.905, -0.81>
  }
  box { // window1
    <-1, -1, -1>, <1, 1, 1>
    scale 0.09
    translate  <-0.305, -4.07, -0.81>
  }
  box { // window2
    <-1, -1, -1>, <1, 1, 1>
    scale 0.09
    translate  <-0.305, -5.595, -0.81>
  }
  translate  <2.065, 0.0, -0.01>
}
#declare Airship_tot = merge {
  sphere { // Airship
    <0,0,0>,1
    hollow
    scale <1.01, 7.665, 0.88>
    translate  <2.105, 0.145, -0.01>
  }
  sphere { // Top_Fin
    <0,0,0>,1
    hollow
    scale <0.025, 1.0, 1.88>
    translate  <2.105, 5.835, -0.06>
  }
  sphere { // Top_Fin1
    <0,0,0>,1
    hollow
    scale <0.05, 1.0, 2.0>
    rotate -90.0*y
    translate  <2.105, 6.09, -0.055>
  }
  sphere { // Rib
    <0,0,0>,1
    hollow
    scale <1.0, 7.7, 0.02>
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib1
    <0,0,0>,1
    hollow
    scale <1.0, 7.7, 0.02>
    rotate -20.0*y
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib2
    <0,0,0>,1
    hollow
    scale <1.0, 7.7, 0.02>
    rotate -40.0*y
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib3
    <0,0,0>,1
    hollow
    scale <1.0, 7.7, 0.02>
    rotate -60.0*y
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib4
    <0,0,0>,1
    hollow
    scale <1.0, 7.7, 0.02>
    rotate -80.0*y
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib5
    <0,0,0>,1
    hollow
    scale <1.0, 7.7, 0.02>
    rotate <180.0, -80.0, 180.0>
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib6
    <0,0,0>,1
    hollow
    scale <1.0, 7.7, 0.02>
    rotate <180.0, -60.0, 180.0>
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib7
    <0,0,0>,1
    hollow
    scale <1.0, 7.7, 0.02>
    rotate <180.0, -40.0, 180.0>
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib8
    <0,0,0>,1
    hollow
    scale <1.0, 7.7, 0.02>
    rotate <180.0, -20.0, 180.0>
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib9
    <0,0,0>,1
    hollow
    scale <1.0, 7.7, 0.02>
    rotate <180.0, 0.0, 180.0>
    translate  <2.105, 0.155, 0.0>
  }
  sphere { // Rib10
    <0,0,0>,1
    hollow
    scale <1.0, 7.7, 0.02>
    rotate <180.0, 20.0, 180.0>
    translate  <2.105, 0.155, 0.0>
  }
  object { windows }
  hollow
  translate  <-2.065, 0.0, 0.01>
}
#declare HgtFld001 = object { 
  height_field {
    gif "D:\RAY\UTILS\MORAY25\MAPS\PLASMA.GIF"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  hollow
  rotate -90.0*x
  translate  <0.0, 1.835, 0.035>
}
#declare Back_air_tot = difference {
  object { Airship_tot }
  box { // Cut_Front
    <-1, -1, -1>, <1, 1, 1>
    scale <2.38, 4.625, 2.225>
    translate  <0.015, -4.115, -0.095>
  }
  object { HgtFld001 }
  hollow
  rotate 15.0*x
  translate  <0.0, -0.55, 0.05>
}
union { // AirShip_Total
  object { Font_air_tot }
  object { Back_air_tot }
  texture {
    Airship_Grey
  }
  no_shadow
  hollow
  rotate -10.0*x
  translate  <0.0, 0.37, -0.52>
}


merge { // roof1
  object { rof2 }
  object { // rof3->rof2
    rof2
    translate  0.2*x
  }
  object { // rof4->rof2
    rof2
    translate  0.4*x
  }
  object { // rof5->rof2
    rof2
    translate  0.6*x
  }
  object { // rof6->rof2
    rof2
    translate  0.8*x
  }
  object { // rof7->rof2
    rof2
    translate  1.0*x
  }
  object { // rof8->rof2
    rof2
    translate  1.2*x
  }
  object { // rof9->rof2
    rof2
    translate  1.4*x
  }
  object { // rof10->rof2
    rof2
    translate  1.6*x
  }
  object { // rof11->rof2
    rof2
    translate  1.8*x
  }
  object { // rof12->rof2
    rof2
    translate  2.0*x
  }
  object { // rof13->rof2
    rof2
    translate  2.2*x
  }
  object { // rof14->rof2
    rof2
    translate  2.4*x
  }
  object { // rof15->rof2
    rof2
    translate  2.6*x
  }
  object { // rof16->rof2
    rof2
    translate  2.8*x
  }
  object { // rof17->rof2
    rof2
    translate  3.0*x
  }
  object { // rof18->rof2
    rof2
    translate  3.2*x
  }
  object { // rof19->rof2
    rof2
    translate  3.4*x
  }
  object { // rof20->rof2
    rof2
    translate  3.6*x
  }
  object { // rof21->rof2
    rof2
    translate  3.8*x
  }
  object { // rof22->rof2
    rof2
    translate  4.0*x
  }
  object { // rof23->rof2
    rof2
    translate  4.2*x
  }
  object { // rof24->rof2
    rof2
    translate  4.4*x
  }
  object { // rof25->rof2
    rof2
    translate  4.6*x
  }
  object { // rof26->rof2
    rof2
    translate  4.8*x
  }
  object { // rof27->rof2
    rof2
    translate  5.0*x
  }
  object { // rof28->rof2
    rof2
    translate  5.2*x
  }
  object { // rof29->rof2
    rof2
    translate  5.4*x
  }
  object { // rof30->rof2
    rof2
    translate  5.6*x
  }
  object { // rof31->rof2
    rof2
    translate  5.8*x
  }
  object { // rof32->rof2
    rof2
    translate  6.0*x
  }
  object { // rof33->rof2
    rof2
    translate  6.2*x
  }
  object { // rof34->rof2
    rof2
    translate  6.4*x
  }
  object { // rof35->rof2
    rof2
    translate  6.6*x
  }
  object { // rof36->rof2
    rof2
    translate  6.8*x
  }
  object { // rof37->rof2
    rof2
    translate  7.0*x
  }
  object { // rof38->rof2
    rof2
    translate  7.2*x
  }
  object { // rof39->rof2
    rof2
    translate  7.4*x
  }
  object { // rof40->rof2
    rof2
    translate  7.6*x
  }
  object { // rof41->rof2
    rof2
    translate  7.8*x
  }
  object { // rof42->rof2
    rof2
    translate  8.0*x
  }
  object { // rof43->rof2
    rof2
    translate  8.2*x
  }
  object { // rof44->rof2
    rof2
    translate  8.4*x
  }
  object { // rof45->rof2
    rof2
    translate  8.6*x
  }
  object { // rof46->rof2
    rof2
    translate  8.8*x
  }
  object { // rof47->rof2
    rof2
    translate  9.0*x
  }
  object { // rof48->rof2
    rof2
    translate  9.2*x
  }
  object { // rof49->rof2
    rof2
    translate  9.4*x
  }
  object { // rof50->rof2
    rof2
    translate  9.6*x
  }
  object { // rof51->rof2
    rof2
    translate  9.8*x
  }
  object { // rof52->rof2
    rof2
    translate  10.0*x
  }
  object { // rof53->rof2
    rof2
    translate  10.2*x
  }
  object { // rof54->rof2
    rof2
    translate  10.4*x
  }
  object { // rof55->rof2
    rof2
    translate  10.6*x
  }
  object { // rof56->rof2
    rof2
    translate  10.8*x
  }
  object { // rof57->rof2
    rof2
    translate  11.0*x
  }
  object { // rof58->rof2
    rof2
    translate  11.2*x
  }
  object { // rof59->rof2
    rof2
    translate  11.4*x
  }
  object { // rof60->rof2
    rof2
    translate  11.6*x
  }
  object { // rof61->rof2
    rof2
    translate  11.8*x
  }
  object { // rof62->rof2
    rof2
    translate  12.0*x
  }
  object { // rof63->rof2
    rof2
    translate  12.2*x
  }
  object { // rof64->rof2
    rof2
    translate  12.4*x
  }
  object { // rof65->rof2
    rof2
    translate  12.6*x
  }
  object { // rof66->rof2
    rof2
    translate  12.8*x
  }
  object { // rof67->rof2
    rof2
    translate  13.0*x
  }
  object { // rof68->rof2
    rof2
    translate  13.2*x
  }
  object { // rof69->rof2
    rof2
    translate  13.4*x
  }
  object { // rof70->rof2
    rof2
    translate  13.6*x
  }
  object { // rof71->rof2
    rof2
    translate  13.8*x
  }
  object { // rof72->rof2
    rof2
    translate  14.0*x
  }
  object { // rof73->rof2
    rof2
    translate  14.2*x
  }
  object { // rof74->rof2
    rof2
    translate  14.4*x
  }
  object { // rof75->rof2
    rof2
    translate  14.6*x
  }
  object { // rof76->rof2
    rof2
    translate  14.8*x
  }
  object { // rof77->rof2
    rof2
    translate  15.0*x
  }
  object { // rof78->rof2
    rof2
    translate  15.2*x
  }
  object { // rof79->rof2
    rof2
    translate  15.4*x
  }
  object { // rof80->rof2
    rof2
    translate  15.6*x
  }
  object { // rof81->rof2
    rof2
    translate  15.8*x
  }
  object { // rof82->rof2
    rof2
    translate  16.0*x
  }
  object { // rof83->rof2
    rof2
    translate  16.2*x
  }
  object { // rof84->rof2
    rof2
    translate  16.4*x
  }
  object { // rof85->rof2
    rof2
    translate  16.6*x
  }
  object { // rof86->rof2
    rof2
    translate  16.8*x
  }
  object { // rof87->rof2
    rof2
    translate  17.0*x
  }
  object { // rof88->rof2
    rof2
    translate  17.2*x
  }
  object { // rof89->rof2
    rof2
    translate  17.4*x
  }
  object { // rof90->rof2
    rof2
    translate  17.6*x
  }
  texture {
    roof_text
  }
  no_shadow
  scale <1.0, 0.745, 2.0>
  rotate <-45.0, 0.0, -90.0>
  translate  <6.63, 3.495, 2.36>
}




#declare Struts2 = union {
  cylinder { // Strut7
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 0.525>
    translate  <1.96, -0.97, 0.0>
  }
  object { // Strut9->Strut1
    Strut1
    translate  -2.435*x
  }
  object { // Strut11->Strut1
    Strut1
    translate  -3.95*x
  }
  object { // Strut12->Strut1
    Strut1
    translate  -1.5*x
  }
  translate  0.555*y
}
#declare Struts1 = union {
  object { Strut1 }
  object { // Strut4->Strut1
    Strut1
    translate  -2.435*x
  }
  object { // Strut6->Strut1
    Strut1
    translate  -3.95*x
  }
  object { // Strut3->Strut1
    Strut1
    translate  -1.5*x
  }
}
#declare Windscren = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 1.820046>, <1.000000, -1.000000, 1.820046>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 1.820046>, <1.000000, 0.000000, 1.820046>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  texture {
    Glass3
  }
  scale 0.11
  rotate <0.0, 0.0, 90.0>
  translate  <-0.055, -0.765457, 0.230654>
}
union { // Bi_Plane
  cylinder { // Leg3
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 0.2>
    translate  <-0.005, 1.345, -0.435>
  }
  cylinder { // Wheel3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Wheel_text
    }
    scale 0.09
    rotate -90.0*y
    translate  <-0.02, 1.33, -0.44>
  }
  box { // Prop1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Chrome_Textur1
    }
    scale <0.545, 0.015, 0.055>
    rotate -45.0*y
    translate  -1.645*y
  }
  cylinder { // Engine
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal1
    }
    scale <0.305, 0.305, 0.075>
    rotate -90.0*x
    translate  <-0.005, -1.585, -0.02>
  }
  sphere { // Sphere2
    <0,0,0>,1
    scale <0.025, 0.335, 0.7>
    rotate -90.0*y
    translate  <0.01, 1.155, 0.005>
  }
  sphere { // Sphere001
    <0,0,0>,1
    scale <0.025, 0.28, 0.4>
    translate  <0.01, 1.18, 0.15>
  }
  cylinder { // Wheel2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Wheel_text
    }
    scale 0.09
    rotate -90.0*y
    translate  <0.455, -0.745, -0.61>
  }
  cylinder { // Wheel1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Wheel_text
    }
    scale 0.09
    rotate -90.0*y
    translate  <-0.385, -0.745, -0.61>
  }
  cylinder { // Leg2
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 0.5>
    rotate -31.785*y
    translate  <0.365, -0.74, -0.63>
  }
  cylinder { // Leg1
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 0.5>
    rotate 31.785*y
    translate  <-0.39, -0.74, -0.625>
  }
  object { Struts2 }
  object { Struts1 }
  box { // Top_Wing1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Wing_text
    }
    scale <2.0, 0.3, 0.01>
    translate  <0.0, -0.685, 0.52>
  }
  box { // Top_Wing
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Wing_text
    }
    scale <2.0, 0.3, 0.01>
    translate  -0.685*y
  }
  superellipsoid { // PLane_Body
    <0.1, 0.1>
    scale <0.25, 1.5, 0.25>
  }
  superellipsoid { // Nose_cone
    <1.0, 2.0>
    scale 0.2
    rotate -90.0*x
    translate  <0.0, -1.592944, -0.025058>
  }
  object { Windscren }
  texture {
    Plane_text
  }
  scale 0.5
  rotate -4.5*x
  translate  <0.0, -10.91, -2.73>
}


#declare Eng_back = difference {
  superellipsoid { // Eng_body
    <1.0, 2.0>
    scale <0.7, 0.7, 2.465>
    rotate -90.0*x
    translate  -0.535*y
  }
  box { // Cube20
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 1.3, 1.2>
    translate  <-0.015, -1.995, 0.02>
  }
}
union { // Airship_eng_whl
  box { // Prop3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.002, 1.65>
    rotate -90.0*y
    translate  <0.015, -0.86, 0.0>
  }
  superellipsoid { // Air_engine
    <1.0, 0.1>
    scale <0.6, 0.6, 0.07>
    rotate -90.0*x
    translate  <-0.01, -0.76, 0.0>
  }
  box { // Prop
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.002, 1.65>
    translate  <0.015, -0.85, 0.0>
  }
  superellipsoid { // SuprQ001
    <1.0, 2.0>
    scale 0.35
    rotate -90.0*x
    translate  <-0.01, -0.805, 0.0>
  }
  sphere { // Joint
    <0,0,0>,1
    scale 0.285
    translate  <0.005, -0.015, 0.525>
  }
  cylinder { // Air_eng_arm
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 2.5>
    rotate -54.684998*y
    translate  <0.005, -0.005, 0.585>
  }
  object { Eng_back }
  texture {
    Air_eng_text
  }
  scale 0.12
  rotate <27.0, 0.0, -180.0>
  translate  <-0.85, -2.565, 0.0>
}


#declare Eng_back1 = difference {
  superellipsoid { // Eng_body1
    <1.0, 2.0>
    scale <0.7, 0.7, 2.465>
    rotate -90.0*x
    translate  -0.535*y
  }
  box { // Cube21
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 1.3, 1.2>
    translate  <-0.015, -1.995, 0.02>
  }
}
union { // Airship_eng_w1
  box { // Prop4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.002, 1.65>
    rotate -90.0*y
    translate  <0.015, -0.86, 0.0>
  }
  superellipsoid { // Air_engine1
    <1.0, 0.1>
    scale <0.6, 0.6, 0.07>
    rotate -90.0*x
    translate  <-0.01, -0.76, 0.0>
  }
  box { // Prop5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.002, 1.65>
    translate  <0.015, -0.85, 0.0>
  }
  superellipsoid { // SuprQ2
    <1.0, 2.0>
    scale 0.35
    rotate -90.0*x
    translate  <-0.01, -0.805, 0.0>
  }
  sphere { // Joint1
    <0,0,0>,1
    scale 0.285
    translate  <0.005, -0.015, 0.525>
  }
  cylinder { // Air_eng_arm1
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 2.5>
    rotate 54.684998*y
    translate  <0.005, -0.005, 0.585>
  }
  object { Eng_back1 }
  texture {
    Air_eng_text
  }
  scale 0.12
  rotate <27.0, 0.0, -180.0>
  translate  <0.93, -2.565, 0.015>
}



sphere { 0, 0.95
  pigment { color rgbt <1, 1, 1, 1> }
  halo {
    emitting
    spherical_mapping
    linear
    turbulence 1.5
    color_map {
      [ 0.0 color rgbt <1, 1, 0,  1.0> ]
      [ 0.3 color rgbt <1, 1, 0,  1.0> ]
      [ 0.6 color rgbt <1, 0, 0,  1.0> ]
      [ 0.8 color rgbt <1, 0, 0, -1.0> ]
      [ 1.0 color rgbt <1, 0, 0, -1.0> ]
    } 
    samples 10
    scale 0.5
  }
  hollow
  scale 3
}               

sphere { 0, 1
  pigment { color rgbt <1, 1, 1, 1> }
  halo {
    emitting
    spherical_mapping
    linear
    turbulence 1.5
    color_map {
      [ 0.0 color rgbt <1, 0, 0,  1.0> ]
      [ 0.5 color rgbt <1, 1, 0, -1.0> ]
      [ 1.0 color rgbt <1, 0, 0, -1.0> ]
    } 
    frequency 2
    samples 20
    scale 0.5
  }
  hollow
  scale 3
}









