// Persistence of Vision Ray Tracer Scene Description File
// File: alovac.pov
// Vers: 3.0
// Copyright(C)1996 Anto Matkovic
// All Rights Reserved.
// Desc: My vision of stealth fighter.
// Email: anto.matkovic@zg.tel.hr
// Date: 12 07 96
// Auth: Anto Matkovic
#version 3.0 global_settings { assumed_gamma 2.3 }
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"


camera
{  location  <-96, 91, 42>
   direction <0.0, 2.0, 0.0>
   sky       <0.0, 0.0, 1.0>
   up        <0.0, 0.0, 1.0>
   right     <1.3333, 0.0, 0.0>
   look_at   <36, -44, -25>
   angle 28
}

light_source
{
  0*x
  colour rgb 1.0
  area_light
  <0, 0, 0> <0, 0, 0>
  4, 4
  adaptive 0
  jitter
  translate <-36, -40, 480>

}
light_source{<86.00, -71.42, -16.7> colour rgb <0.9, 0.6, 0.4>
fade_distance 60 fade_power 2}

#declare Textur =
texture {
   pigment {colour Clear}
   halo {
      linear
      max_value 0.4
      spherical_mapping
      emitting
      turbulence 0.5
      omega 0.2
      jitter 1
      colour_map {
         [0 colour rgbt <1,0.8,0.6,1>]
         [1 colour rgbt <1,1,1,0>]
   }
      samples 5
   }
}

object {Sphere hollow texture{ Textur } scale<11.0, 0.8, 0.8>
       rotate    <0.0, -30, 0.0>
       translate <86.00, -71.42, -16.7>}

object{Sphere hollow texture{ Textur } scale<25.0, 2.2, 2.2>
       rotate    <0.0, -30, 0.0>
       translate <72.37, -71.42, -24.63>}

sky_sphere {
    pigment {
        wrinkles
        turbulence 0.2
        omega 0.4
        octaves 5
        colour_map {
            [0.2 colour red 1.0 green 0.96 blue 0.90]
            [0.6 colour red 0.2 green 0.2 blue 0.9]
            [1.0 colour red 0.1 green 0.1 blue 0.7]}
        scale <0.5, 0.5, 0.5>
        rotate <45, 6, 0>
}
}
//  Object:  pokazivac la
object
{   union{
   smooth_triangle{ <57.857498,-76.110298,-13.137600>, <-0.171341,-0.320565,0.931601>
 <57.942299,-76.572098,-13.280900>, <-0.171338,-0.320548,0.931607>
 <59.370899,-76.408600,-12.961900>, <-0.171341,-0.320565,0.931601>
}
   smooth_triangle{ <57.857498,-76.110298,-13.137600>, <0.171341,0.320565,-0.931601>
 <59.370899,-76.408600,-12.961900>, <0.171341,0.320565,-0.931601>
 <57.942299,-76.572098,-13.280900>, <0.171338,0.320548,-0.931607>
}
   smooth_triangle{ <57.857498,-76.110298,-13.137600>, <-0.171341,-0.320565,0.931601>
 <59.370899,-76.408600,-12.961900>, <-0.171341,-0.320565,0.931601>
 <59.285999,-75.946800,-12.818600>, <-0.171344,-0.320582,0.931595>
}
   smooth_triangle{ <57.857498,-76.110298,-13.137600>, <0.171341,0.320565,-0.931601>
 <59.285999,-75.946800,-12.818600>, <0.171344,0.320582,-0.931595>
 <59.370899,-76.408600,-12.961900>, <0.171341,0.320565,-0.931601>
}
   smooth_triangle{ <57.942299,-76.572098,-13.280900>, <0.172847,-0.940693,-0.291925>
 <58.026402,-76.414703,-13.738300>, <0.172848,-0.940695,-0.291918>
 <59.455002,-76.251198,-13.419300>, <0.172847,-0.940693,-0.291925>
}
   smooth_triangle{ <57.942299,-76.572098,-13.280900>, <0.172847,-0.940693,-0.291925>
 <59.455002,-76.251198,-13.419300>, <0.172847,-0.940693,-0.291925>
 <59.370899,-76.408600,-12.961900>, <0.172846,-0.940691,-0.291932>
}
   smooth_triangle{ <58.026402,-76.414703,-13.738300>, <0.171339,0.320565,-0.931601>
 <57.941601,-75.952904,-13.595000>, <0.171348,0.320549,-0.931605>
 <59.370098,-75.789398,-13.276000>, <0.171339,0.320565,-0.931601>
}
   smooth_triangle{ <58.026402,-76.414703,-13.738300>, <0.171339,0.320565,-0.931601>
 <59.370098,-75.789398,-13.276000>, <0.171339,0.320565,-0.931601>
 <59.455002,-76.251198,-13.419300>, <0.171331,0.320582,-0.931597>
}
   smooth_triangle{ <57.941601,-75.952904,-13.595000>, <-0.172859,0.940692,0.291923>
 <57.857498,-76.110298,-13.137600>, <-0.172855,0.940695,0.291916>
 <59.285999,-75.946800,-12.818600>, <-0.172859,0.940692,0.291923>
}
   smooth_triangle{ <57.941601,-75.952904,-13.595000>, <0.172859,-0.940692,-0.291923>
 <59.285999,-75.946800,-12.818600>, <0.172859,-0.940692,-0.291923>
 <57.857498,-76.110298,-13.137600>, <0.172855,-0.940695,-0.291916>
}
   smooth_triangle{ <57.941601,-75.952904,-13.595000>, <-0.172859,0.940692,0.291923>
 <59.285999,-75.946800,-12.818600>, <-0.172859,0.940692,0.291923>
 <59.370098,-75.789398,-13.276000>, <-0.172862,0.940689,0.291930>
}
   smooth_triangle{ <57.941601,-75.952904,-13.595000>, <0.172859,-0.940692,-0.291923>
 <59.370098,-75.789398,-13.276000>, <0.172862,-0.940689,-0.291930>
 <59.285999,-75.946800,-12.818600>, <0.172859,-0.940692,-0.291923>
}
   smooth_triangle{ <58.026402,-76.414703,-13.738300>, <-0.969956,-0.110927,-0.216517>
 <57.857498,-76.110298,-13.137600>, <-0.969956,-0.110927,-0.216517>
 <57.941601,-75.952904,-13.595000>, <-0.969956,-0.110927,-0.216517>
}
   smooth_triangle{ <58.026402,-76.414703,-13.738300>, <0.969956,0.110927,0.216517>
 <57.941601,-75.952904,-13.595000>, <0.969956,0.110927,0.216517>
 <57.857498,-76.110298,-13.137600>, <0.969956,0.110927,0.216517>
}
   smooth_triangle{ <57.942299,-76.572098,-13.280900>, <-0.969956,-0.110927,-0.216517>
 <57.857498,-76.110298,-13.137600>, <-0.969956,-0.110927,-0.216517>
 <58.026402,-76.414703,-13.738300>, <-0.969956,-0.110927,-0.216517>
}
   smooth_triangle{ <57.942299,-76.572098,-13.280900>, <0.969956,0.110927,0.216517>
 <58.026402,-76.414703,-13.738300>, <0.969956,0.110927,0.216517>
 <57.857498,-76.110298,-13.137600>, <0.969956,0.110927,0.216517>
}
   smooth_triangle{ <59.455002,-76.251198,-13.419300>, <0.969922,0.111116,0.216574>
 <59.370098,-75.789398,-13.276000>, <0.969922,0.111120,0.216571>
 <59.285999,-75.946800,-12.818600>, <0.969922,0.111116,0.216574>
}
   smooth_triangle{ <59.370899,-76.408600,-12.961900>, <0.969922,0.111111,0.216576>
 <59.455002,-76.251198,-13.419300>, <0.969922,0.111116,0.216574>
 <59.285999,-75.946800,-12.818600>, <0.969922,0.111116,0.216574>
}
   smooth_triangle{ <57.862801,-76.782997,-12.817000>, <-0.171324,-0.320530,0.931616>
 <57.947701,-77.244904,-12.960300>, <-0.171322,-0.320512,0.931623>
 <59.376301,-77.081299,-12.641300>, <-0.171324,-0.320530,0.931616>
}
   smooth_triangle{ <57.862801,-76.782997,-12.817000>, <0.171324,0.320530,-0.931616>
 <59.376301,-77.081299,-12.641300>, <0.171324,0.320530,-0.931616>
 <57.947701,-77.244904,-12.960300>, <0.171322,0.320512,-0.931623>
}
   smooth_triangle{ <57.862801,-76.782997,-12.817000>, <-0.171324,-0.320530,0.931616>
 <59.376301,-77.081299,-12.641300>, <-0.171324,-0.320530,0.931616>
 <59.291500,-76.619499,-12.498000>, <-0.171327,-0.320547,0.931610>
}
   smooth_triangle{ <57.862801,-76.782997,-12.817000>, <0.171324,0.320530,-0.931616>
 <59.291500,-76.619499,-12.498000>, <0.171327,0.320547,-0.931610>
 <59.376301,-77.081299,-12.641300>, <0.171324,0.320530,-0.931616>
}
   smooth_triangle{ <57.947701,-77.244904,-12.960300>, <0.172898,-0.940656,-0.292015>
 <58.031799,-77.087402,-13.417700>, <0.172883,-0.940629,-0.292110>
 <59.460400,-76.923897,-13.098700>, <0.172898,-0.940656,-0.292015>
}
   smooth_triangle{ <57.947701,-77.244904,-12.960300>, <0.172898,-0.940656,-0.292015>
 <59.460400,-76.923897,-13.098700>, <0.172898,-0.940656,-0.292015>
 <59.376301,-77.081299,-12.641300>, <0.172912,-0.940683,-0.291919>
}
   smooth_triangle{ <58.031799,-77.087402,-13.417700>, <0.171337,0.320547,-0.931608>
 <57.946999,-76.625603,-13.274400>, <0.171336,0.320548,-0.931608>
 <59.375599,-76.462097,-12.955400>, <0.171337,0.320547,-0.931608>
}
   smooth_triangle{ <58.031799,-77.087402,-13.417700>, <0.171337,0.320547,-0.931608>
 <59.375599,-76.462097,-12.955400>, <0.171337,0.320547,-0.931608>
 <59.460400,-76.923897,-13.098700>, <0.171337,0.320546,-0.931608>
}
   smooth_triangle{ <57.946999,-76.625603,-13.274400>, <-0.172838,0.940699,0.291911>
 <57.862801,-76.782997,-12.817000>, <-0.172826,0.940708,0.291890>
 <59.291500,-76.619499,-12.498000>, <-0.172838,0.940699,0.291911>
}
   smooth_triangle{ <57.946999,-76.625603,-13.274400>, <0.172838,-0.940699,-0.291911>
 <59.291500,-76.619499,-12.498000>, <0.172838,-0.940699,-0.291911>
 <57.862801,-76.782997,-12.817000>, <0.172826,-0.940708,-0.291890>
}
   smooth_triangle{ <57.946999,-76.625603,-13.274400>, <-0.172838,0.940699,0.291911>
 <59.291500,-76.619499,-12.498000>, <-0.172838,0.940699,0.291911>
 <59.375599,-76.462097,-12.955400>, <-0.172851,0.940690,0.291933>
}
   smooth_triangle{ <57.946999,-76.625603,-13.274400>, <0.172838,-0.940699,-0.291911>
 <59.375599,-76.462097,-12.955400>, <0.172851,-0.940690,-0.291933>
 <59.291500,-76.619499,-12.498000>, <0.172838,-0.940699,-0.291911>
}
   smooth_triangle{ <58.031799,-77.087402,-13.417700>, <-0.969924,-0.110975,-0.216638>
 <57.862801,-76.782997,-12.817000>, <-0.969924,-0.110975,-0.216638>
 <57.946999,-76.625603,-13.274400>, <-0.969924,-0.110866,-0.216693>
}
   smooth_triangle{ <58.031799,-77.087402,-13.417700>, <0.969924,0.110975,0.216638>
 <57.946999,-76.625603,-13.274400>, <0.969924,0.110866,0.216693>
 <57.862801,-76.782997,-12.817000>, <0.969924,0.110975,0.216638>
}
   smooth_triangle{ <57.947701,-77.244904,-12.960300>, <-0.969924,-0.111083,-0.216584>
 <57.862801,-76.782997,-12.817000>, <-0.969924,-0.110975,-0.216638>
 <58.031799,-77.087402,-13.417700>, <-0.969924,-0.110975,-0.216638>
}
   smooth_triangle{ <57.947701,-77.244904,-12.960300>, <0.969924,0.111083,0.216584>
 <58.031799,-77.087402,-13.417700>, <0.969924,0.110975,0.216638>
 <57.862801,-76.782997,-12.817000>, <0.969924,0.110975,0.216638>
}
   smooth_triangle{ <59.460400,-76.923897,-13.098700>, <0.969957,0.110929,0.216512>
 <59.375599,-76.462097,-12.955400>, <0.969957,0.110929,0.216512>
 <59.291500,-76.619499,-12.498000>, <0.969957,0.110929,0.216512>
}
   smooth_triangle{ <59.376301,-77.081299,-12.641300>, <0.969957,0.110929,0.216512>
 <59.460400,-76.923897,-13.098700>, <0.969957,0.110929,0.216512>
 <59.291500,-76.619499,-12.498000>, <0.969957,0.110929,0.216512>
}
   smooth_triangle{ <58.046700,-77.139999,-13.457200>, <-0.171350,-0.320626,0.931578>
 <58.131500,-77.601898,-13.600500>, <-0.171329,-0.320485,0.931631>
 <59.560101,-77.438301,-13.281500>, <-0.171350,-0.320626,0.931578>
}
   smooth_triangle{ <58.046700,-77.139999,-13.457200>, <0.171350,0.320626,-0.931578>
 <59.560101,-77.438301,-13.281500>, <0.171350,0.320626,-0.931578>
 <58.131500,-77.601898,-13.600500>, <0.171329,0.320485,-0.931631>
}
   smooth_triangle{ <58.046700,-77.139999,-13.457200>, <-0.171350,-0.320626,0.931578>
 <59.560101,-77.438301,-13.281500>, <-0.171350,-0.320626,0.931578>
 <59.475201,-76.976501,-13.138100>, <-0.171372,-0.320768,0.931525>
}
   smooth_triangle{ <58.046700,-77.139999,-13.457200>, <0.171350,0.320626,-0.931578>
 <59.475201,-76.976501,-13.138100>, <0.171372,0.320768,-0.931525>
 <59.560101,-77.438301,-13.281500>, <0.171350,0.320626,-0.931578>
}
   smooth_triangle{ <58.131500,-77.601898,-13.600500>, <0.172868,-0.940715,-0.291841>
 <58.215599,-77.444504,-14.057900>, <0.172856,-0.940694,-0.291917>
 <59.644299,-77.280998,-13.738800>, <0.172868,-0.940715,-0.291841>
}
   smooth_triangle{ <58.131500,-77.601898,-13.600500>, <0.172868,-0.940715,-0.291841>
 <59.644299,-77.280998,-13.738800>, <0.172868,-0.940715,-0.291841>
 <59.560101,-77.438301,-13.281500>, <0.172879,-0.940737,-0.291766>
}
   smooth_triangle{ <58.215599,-77.444504,-14.057900>, <0.171339,0.320623,-0.931582>
 <58.130798,-76.982697,-13.914500>, <0.171285,0.320720,-0.931558>
 <59.559399,-76.819099,-13.595500>, <0.171339,0.320623,-0.931582>
}
   smooth_triangle{ <58.215599,-77.444504,-14.057900>, <0.171339,0.320623,-0.931582>
 <59.559399,-76.819099,-13.595500>, <0.171339,0.320623,-0.931582>
 <59.644299,-77.280998,-13.738800>, <0.171392,0.320525,-0.931605>
}
   smooth_triangle{ <58.130798,-76.982697,-13.914500>, <-0.172878,0.940712,0.291846>
 <58.046700,-77.139999,-13.457200>, <-0.172854,0.940729,0.291805>
 <59.475201,-76.976501,-13.138100>, <-0.172878,0.940712,0.291846>
}
   smooth_triangle{ <58.130798,-76.982697,-13.914500>, <0.172878,-0.940712,-0.291846>
 <59.475201,-76.976501,-13.138100>, <0.172878,-0.940712,-0.291846>
 <58.046700,-77.139999,-13.457200>, <0.172854,-0.940729,-0.291805>
}
   smooth_triangle{ <58.130798,-76.982697,-13.914500>, <-0.172878,0.940712,0.291846>
 <59.475201,-76.976501,-13.138100>, <-0.172878,0.940712,0.291846>
 <59.559399,-76.819099,-13.595500>, <-0.172901,0.940695,0.291887>
}
   smooth_triangle{ <58.130798,-76.982697,-13.914500>, <0.172878,-0.940712,-0.291846>
 <59.559399,-76.819099,-13.595500>, <0.172901,-0.940695,-0.291887>
 <59.475201,-76.976501,-13.138100>, <0.172878,-0.940712,-0.291846>
}
   smooth_triangle{ <58.215599,-77.444504,-14.057900>, <-0.969962,-0.110893,-0.216511>
 <58.046700,-77.139999,-13.457200>, <-0.969962,-0.110893,-0.216511>
 <58.130798,-76.982697,-13.914500>, <-0.969962,-0.110879,-0.216519>
}
   smooth_triangle{ <58.215599,-77.444504,-14.057900>, <0.969962,0.110893,0.216511>
 <58.130798,-76.982697,-13.914500>, <0.969962,0.110879,0.216519>
 <58.046700,-77.139999,-13.457200>, <0.969962,0.110893,0.216511>
}
   smooth_triangle{ <58.131500,-77.601898,-13.600500>, <-0.969962,-0.110908,-0.216504>
 <58.046700,-77.139999,-13.457200>, <-0.969962,-0.110893,-0.216511>
 <58.215599,-77.444504,-14.057900>, <-0.969962,-0.110893,-0.216511>
}
   smooth_triangle{ <58.131500,-77.601898,-13.600500>, <0.969962,0.110908,0.216504>
 <58.215599,-77.444504,-14.057900>, <0.969962,0.110893,0.216511>
 <58.046700,-77.139999,-13.457200>, <0.969962,0.110893,0.216511>
}
   smooth_triangle{ <59.644299,-77.280998,-13.738800>, <0.969894,0.111016,0.216752>
 <59.559399,-76.819099,-13.595500>, <0.969894,0.111029,0.216745>
 <59.475201,-76.976501,-13.138100>, <0.969894,0.111016,0.216752>
}
   smooth_triangle{ <59.560101,-77.438301,-13.281500>, <0.969894,0.111002,0.216759>
 <59.644299,-77.280998,-13.738800>, <0.969894,0.111016,0.216752>
 <59.475201,-76.976501,-13.138100>, <0.969894,0.111016,0.216752>
}
texture
      {
      pigment
     {colour rgb <0.8, 0.6, 0.3>}
     finish
     {ambient 0.5 diffuse 0.4 }
}
}
}
//  Object:  iza kabine la
object
{   union{
   smooth_triangle{ <48.717999,-77.220398,-18.507401>, <0.470066,0.339265,-0.814823>
 <48.957199,-78.527100,-18.913500>, <0.470037,0.339279,-0.814834>
 <48.216599,-77.886101,-19.073799>, <0.470019,0.339279,-0.814844>
}
   smooth_triangle{ <48.717999,-77.220398,-18.507401>, <0.470066,0.339265,-0.814823>
 <49.856800,-78.516197,-18.389999>, <0.470084,0.339308,-0.814795>
 <48.957199,-78.527100,-18.913500>, <0.470037,0.339279,-0.814834>
}
   smooth_triangle{ <48.717999,-77.220398,-18.507401>, <0.470066,0.339265,-0.814823>
 <50.200199,-77.862000,-17.919399>, <0.470095,0.339252,-0.814812>
 <49.856800,-78.516197,-18.389999>, <0.470084,0.339308,-0.814795>
}
   smooth_triangle{ <48.717999,-77.220398,-18.507401>, <0.470066,0.339265,-0.814823>
 <49.623402,-77.217300,-17.983801>, <0.470077,0.339167,-0.814858>
 <50.200199,-77.862000,-17.919399>, <0.470095,0.339252,-0.814812>
}
   smooth_triangle{ <48.394600,-75.460403,-17.961300>, <0.470129,0.339215,-0.814808>
 <48.633801,-76.767197,-18.367300>, <0.470151,0.339204,-0.814800>
 <47.893299,-76.126099,-18.527700>, <0.470163,0.339204,-0.814793>
}
   smooth_triangle{ <48.394600,-75.460403,-17.961300>, <0.470129,0.339215,-0.814808>
 <49.533401,-76.756302,-17.843700>, <0.470115,0.339181,-0.814830>
 <48.633801,-76.767197,-18.367300>, <0.470151,0.339204,-0.814800>
}
   smooth_triangle{ <48.394600,-75.460403,-17.961300>, <0.470129,0.339215,-0.814808>
 <49.876900,-76.101997,-17.373199>, <0.470107,0.339226,-0.814816>
 <49.533401,-76.756302,-17.843700>, <0.470115,0.339181,-0.814830>
}
   smooth_triangle{ <48.394600,-75.460403,-17.961300>, <0.470129,0.339215,-0.814808>
 <49.299999,-75.457298,-17.437599>, <0.470121,0.339292,-0.814780>
 <49.876900,-76.101997,-17.373199>, <0.470107,0.339226,-0.814816>
}
   smooth_triangle{ <50.200199,-77.862000,-17.919399>, <0.865658,0.003003,0.500627>
 <49.623402,-77.217300,-17.983801>, <0.362353,0.767626,0.528632>
 <49.767601,-78.174202,-17.169500>, <0.881423,-0.140750,0.450869>
}
   smooth_triangle{ <49.623402,-77.217300,-17.983801>, <0.362353,0.767626,0.528632>
 <49.167599,-77.546204,-17.193800>, <0.086429,0.901042,0.425033>
 <49.767601,-78.174202,-17.169500>, <0.881423,-0.140750,0.450869>
}
   smooth_triangle{ <50.200199,-77.862000,-17.919399>, <0.865658,0.003003,0.500627>
 <49.767601,-78.174202,-17.169500>, <0.881423,-0.140750,0.450869>
 <49.856800,-78.516197,-18.389999>, <0.604578,-0.796361,0.017162>
}
   smooth_triangle{ <49.623402,-77.217300,-17.983801>, <0.362353,0.767626,0.528632>
 <48.717999,-77.220398,-18.507401>, <-0.486794,0.869726,0.081289>
 <49.167599,-77.546204,-17.193800>, <0.086429,0.901042,0.425033>
}
   smooth_triangle{ <48.717999,-77.220398,-18.507401>, <-0.486794,0.869726,0.081289>
 <48.262501,-77.549103,-17.718100>, <-0.486821,0.869715,0.081254>
 <49.167599,-77.546204,-17.193800>, <0.086429,0.901042,0.425033>
}
   smooth_triangle{ <48.216599,-77.886101,-19.073799>, <-0.729031,0.669655,-0.141694>
 <47.785198,-78.197502,-18.325899>, <-0.729030,0.669639,-0.141772>
 <48.717999,-77.220398,-18.507401>, <-0.486794,0.869726,0.081289>
}
   smooth_triangle{ <48.216599,-77.886101,-19.073799>, <0.729031,-0.669655,0.141694>
 <48.717999,-77.220398,-18.507401>, <0.729030,-0.669639,0.141772>
 <47.785198,-78.197502,-18.325899>, <0.729030,-0.669639,0.141772>
}
   smooth_triangle{ <47.785198,-78.197502,-18.325899>, <-0.729030,0.669639,-0.141772>
 <48.262501,-77.549103,-17.718100>, <-0.486821,0.869715,0.081254>
 <48.717999,-77.220398,-18.507401>, <-0.486794,0.869726,0.081289>
}
   smooth_triangle{ <47.785198,-78.197502,-18.325899>, <0.729030,-0.669639,0.141772>
 <48.717999,-77.220398,-18.507401>, <0.729030,-0.669639,0.141772>
 <48.262501,-77.549103,-17.718100>, <0.729029,-0.669624,0.141850>
}
   smooth_triangle{ <48.216599,-77.886101,-19.073799>, <-0.471468,-0.683914,-0.556758>
 <48.957199,-78.527100,-18.913500>, <-0.040293,-0.913943,-0.403838>
 <48.600700,-78.784401,-18.295601>, <-0.471260,-0.683631,-0.557281>
}
   smooth_triangle{ <48.216599,-77.886101,-19.073799>, <0.471468,0.683914,0.556758>
 <48.600700,-78.784401,-18.295601>, <0.471260,0.683631,0.557281>
 <48.957199,-78.527100,-18.913500>, <0.040293,0.913943,0.403838>
}
   smooth_triangle{ <48.216599,-77.886101,-19.073799>, <-0.471468,-0.683914,-0.556758>
 <48.600700,-78.784401,-18.295601>, <-0.471260,-0.683631,-0.557281>
 <47.785198,-78.197502,-18.325899>, <-0.471176,-0.683487,-0.557529>
}
   smooth_triangle{ <48.216599,-77.886101,-19.073799>, <0.471468,0.683914,0.556758>
 <47.785198,-78.197502,-18.325899>, <0.471176,0.683487,0.557529>
 <48.600700,-78.784401,-18.295601>, <0.471260,0.683631,0.557281>
}
   smooth_triangle{ <47.785198,-78.197502,-18.325899>, <-0.471176,-0.683487,-0.557529>
 <48.600700,-78.784401,-18.295601>, <-0.471260,-0.683631,-0.557281>
 <47.805801,-78.214401,-18.322599>, <-0.470843,-0.683065,-0.558328>
}
   smooth_triangle{ <47.785198,-78.197502,-18.325899>, <0.471176,0.683487,0.557529>
 <47.805801,-78.214401,-18.322599>, <0.470843,0.683065,0.558328>
 <48.600700,-78.784401,-18.295601>, <0.471260,0.683631,0.557281>
}
   smooth_triangle{ <48.957199,-78.527100,-18.913500>, <-0.040293,-0.913943,-0.403838>
 <49.856800,-78.516197,-18.389999>, <0.604578,-0.796361,0.017162>
 <49.219898,-78.777802,-17.932400>, <-0.046261,-0.989785,0.134856>
}
   smooth_triangle{ <48.957199,-78.527100,-18.913500>, <0.040293,0.913943,0.403838>
 <49.219898,-78.777802,-17.932400>, <0.046261,0.989785,-0.134856>
 <49.856800,-78.516197,-18.389999>, <-0.179190,0.940614,0.288335>
}
   smooth_triangle{ <49.856800,-78.516197,-18.389999>, <0.604578,-0.796361,0.017162>
 <49.511299,-78.765602,-17.791100>, <0.282056,-0.922450,0.263686>
 <49.219898,-78.777802,-17.932400>, <-0.046261,-0.989785,0.134856>
}
   smooth_triangle{ <49.856800,-78.516197,-18.389999>, <-0.179190,0.940614,0.288335>
 <49.219898,-78.777802,-17.932400>, <0.046261,0.989785,-0.134856>
 <49.511299,-78.765602,-17.791100>, <0.077502,0.966848,-0.243306>
}
   smooth_triangle{ <48.957199,-78.527100,-18.913500>, <-0.040293,-0.913943,-0.403838>
 <49.219898,-78.777802,-17.932400>, <-0.046261,-0.989785,0.134856>
 <48.600700,-78.784401,-18.295601>, <-0.318948,-0.767377,0.556242>
}
   smooth_triangle{ <48.957199,-78.527100,-18.913500>, <0.040293,0.913943,0.403838>
 <48.600700,-78.784401,-18.295601>, <0.318948,0.767377,-0.556242>
 <49.219898,-78.777802,-17.932400>, <0.046261,0.989785,-0.134856>
}
   smooth_triangle{ <49.856800,-78.516197,-18.389999>, <0.604578,-0.796361,0.017162>
 <49.767601,-78.174202,-17.169500>, <0.881423,-0.140750,0.450869>
 <49.621101,-78.498299,-17.488300>, <0.149840,-0.744340,0.650774>
}
   smooth_triangle{ <49.856800,-78.516197,-18.389999>, <0.604578,-0.796361,0.017162>
 <49.621101,-78.498299,-17.488300>, <0.149840,-0.744340,0.650774>
 <49.511299,-78.765602,-17.791100>, <0.282056,-0.922450,0.263686>
}
   smooth_triangle{ <49.621101,-78.498299,-17.488300>, <0.149840,-0.744340,0.650774>
 <49.767601,-78.174202,-17.169500>, <0.881423,-0.140750,0.450869>
 <49.742699,-78.223801,-17.209400>, <0.789044,-0.573447,0.220382>
}
   smooth_triangle{ <49.299999,-75.457298,-17.437599>, <0.227359,0.845475,0.483198>
 <48.962700,-75.700699,-16.853001>, <-0.169911,0.477916,0.861816>
 <49.876900,-76.101997,-17.373199>, <0.712524,0.398933,0.577201>
}
   smooth_triangle{ <49.876900,-76.101997,-17.373199>, <0.712524,0.398933,0.577201>
 <48.962700,-75.700699,-16.853001>, <-0.169911,0.477916,0.861816>
 <49.234501,-76.115997,-16.710800>, <-0.148858,0.217485,0.964646>
}
   smooth_triangle{ <49.876900,-76.101997,-17.373199>, <0.712524,0.398933,0.577201>
 <49.234501,-76.115997,-16.710800>, <-0.148858,0.217485,0.964646>
 <49.437801,-76.402702,-16.628401>, <0.578117,0.579234,0.574690>
}
   smooth_triangle{ <49.446301,-76.412697,-16.626801>, <0.881358,-0.229688,0.412857>
 <49.876900,-76.101997,-17.373199>, <0.712524,0.398933,0.577201>
 <49.437801,-76.402702,-16.628401>, <0.578117,0.579234,0.574690>
}
   smooth_triangle{ <49.876900,-76.101997,-17.373199>, <0.712524,0.398933,0.577201>
 <49.446301,-76.412697,-16.626801>, <0.881358,-0.229688,0.412857>
 <49.533401,-76.756302,-17.843700>, <0.644301,-0.762853,0.054150>
}
   smooth_triangle{ <49.299999,-75.457298,-17.437599>, <0.227359,0.845475,0.483198>
 <48.394600,-75.460403,-17.961300>, <-0.383065,0.910111,0.157983>
 <48.962700,-75.700699,-16.853001>, <-0.169911,0.477916,0.861816>
}
   smooth_triangle{ <48.394600,-75.460403,-17.961300>, <-0.383065,0.910111,0.157983>
 <48.042999,-75.714203,-17.351900>, <-0.581696,0.813400,0.003136>
 <48.962700,-75.700699,-16.853001>, <-0.169911,0.477916,0.861816>
}
   smooth_triangle{ <48.394600,-75.460403,-17.961300>, <-0.383065,0.910111,0.157983>
 <47.893299,-76.126099,-18.527700>, <-0.728331,0.670565,-0.140982>
 <48.042999,-75.714203,-17.351900>, <-0.581696,0.813400,0.003136>
}
   smooth_triangle{ <48.394600,-75.460403,-17.961300>, <0.729050,-0.669621,0.141754>
 <48.042999,-75.714203,-17.351900>, <0.729043,-0.669628,0.141758>
 <47.893299,-76.126099,-18.527700>, <0.728331,-0.670565,0.140982>
}
   smooth_triangle{ <48.042999,-75.714203,-17.351900>, <-0.581696,0.813400,0.003136>
 <47.893299,-76.126099,-18.527700>, <-0.728331,0.670565,-0.140982>
 <47.468498,-76.429298,-17.775299>, <-0.727971,0.671037,-0.140596>
}
   smooth_triangle{ <48.042999,-75.714203,-17.351900>, <0.729043,-0.669628,0.141758>
 <47.468498,-76.429298,-17.775299>, <0.727971,-0.671037,0.140596>
 <47.893299,-76.126099,-18.527700>, <0.728331,-0.670565,0.140982>
}
   smooth_triangle{ <47.893299,-76.126099,-18.527700>, <-0.728331,0.670565,-0.140982>
 <47.462601,-76.436897,-17.781200>, <-0.726904,0.672436,-0.139430>
 <47.468498,-76.429298,-17.775299>, <-0.727971,0.671037,-0.140596>
}
   smooth_triangle{ <47.893299,-76.126099,-18.527700>, <0.728331,-0.670565,0.140982>
 <47.468498,-76.429298,-17.775299>, <0.727971,-0.671037,0.140596>
 <47.462601,-76.436897,-17.781200>, <0.726904,-0.672436,0.139430>
}
   smooth_triangle{ <48.633801,-76.767197,-18.367300>, <-0.040326,-0.913975,-0.403763>
 <48.179501,-77.095001,-17.579901>, <-0.272144,-0.822495,-0.499439>
 <47.893299,-76.126099,-18.527700>, <-0.471488,-0.683902,-0.556756>
}
   smooth_triangle{ <48.633801,-76.767197,-18.367300>, <0.040326,0.913975,0.403763>
 <47.893299,-76.126099,-18.527700>, <0.471488,0.683902,0.556756>
 <48.179501,-77.095001,-17.579901>, <0.272144,0.822495,0.499439>
}
   smooth_triangle{ <47.893299,-76.126099,-18.527700>, <-0.471488,-0.683902,-0.556756>
 <48.179501,-77.095001,-17.579901>, <-0.272144,-0.822495,-0.499439>
 <47.462601,-76.436897,-17.781200>, <-0.471480,-0.683904,-0.556761>
}
   smooth_triangle{ <47.893299,-76.126099,-18.527700>, <0.471488,0.683902,0.556756>
 <47.462601,-76.436897,-17.781200>, <0.471480,0.683904,0.556761>
 <48.179501,-77.095001,-17.579901>, <0.272144,0.822495,0.499439>
}
   smooth_triangle{ <48.633801,-76.767197,-18.367300>, <-0.040326,-0.913975,-0.403763>
 <49.533401,-76.756302,-17.843700>, <0.644301,-0.762853,0.054150>
 <49.079102,-77.084099,-17.056299>, <0.420490,-0.897770,-0.131141>
}
   smooth_triangle{ <48.633801,-76.767197,-18.367300>, <0.040326,0.913975,0.403763>
 <49.079102,-77.084099,-17.056299>, <-0.179158,0.940651,0.288233>
 <49.533401,-76.756302,-17.843700>, <-0.179153,0.940652,0.288231>
}
   smooth_triangle{ <48.633801,-76.767197,-18.367300>, <-0.040326,-0.913975,-0.403763>
 <49.079102,-77.084099,-17.056299>, <0.420490,-0.897770,-0.131141>
 <48.179501,-77.095001,-17.579901>, <-0.272144,-0.822495,-0.499439>
}
   smooth_triangle{ <48.633801,-76.767197,-18.367300>, <0.040326,0.913975,0.403763>
 <48.179501,-77.095001,-17.579901>, <0.272144,0.822495,0.499439>
 <49.079102,-77.084099,-17.056299>, <-0.179158,0.940651,0.288233>
}
   smooth_triangle{ <49.079102,-77.084099,-17.056299>, <0.420490,-0.897770,-0.131141>
 <49.533401,-76.756302,-17.843700>, <0.644301,-0.762853,0.054150>
 <49.446301,-76.412697,-16.626801>, <0.881358,-0.229688,0.412857>
}
   smooth_triangle{ <48.132198,-78.217598,-18.134701>, <-0.442498,-0.468970,0.764371>
 <49.767601,-78.174202,-17.169500>, <-0.456354,-0.406516,0.791508>
 <49.167599,-77.546204,-17.193800>, <-0.457860,-0.404078,0.791887>
}
   smooth_triangle{ <48.132198,-78.217598,-18.134701>, <0.442498,0.468970,-0.764371>
 <49.167599,-77.546204,-17.193800>, <0.457860,0.404078,-0.791887>
 <49.767601,-78.174202,-17.169500>, <0.456354,0.406516,-0.791508>
}
   smooth_triangle{ <48.132198,-78.217598,-18.134701>, <-0.442498,-0.468970,0.764371>
 <49.167599,-77.546204,-17.193800>, <-0.457860,-0.404078,0.791887>
 <47.785198,-78.197502,-18.325899>, <-0.458689,-0.403991,0.791451>
}
   smooth_triangle{ <48.132198,-78.217598,-18.134701>, <0.442498,0.468970,-0.764371>
 <47.785198,-78.197502,-18.325899>, <0.458689,0.403991,-0.791451>
 <49.167599,-77.546204,-17.193800>, <0.457860,0.404078,-0.791887>
}
   smooth_triangle{ <49.167599,-77.546204,-17.193800>, <-0.457860,-0.404078,0.791887>
 <48.262501,-77.549103,-17.718100>, <-0.457234,-0.405419,0.791564>
 <47.785198,-78.197502,-18.325899>, <-0.458689,-0.403991,0.791451>
}
   smooth_triangle{ <49.167599,-77.546204,-17.193800>, <0.457860,0.404078,-0.791887>
 <47.785198,-78.197502,-18.325899>, <0.458689,0.403991,-0.791451>
 <48.262501,-77.549103,-17.718100>, <0.457234,0.405419,-0.791564>
}
   smooth_triangle{ <48.132198,-78.217598,-18.134701>, <-0.442498,-0.468970,0.764371>
 <47.805801,-78.214401,-18.322599>, <-0.441143,-0.480233,0.758135>
 <48.600700,-78.784401,-18.295601>, <-0.318948,-0.767377,0.556242>
}
   smooth_triangle{ <48.132198,-78.217598,-18.134701>, <0.442498,0.468970,-0.764371>
 <48.600700,-78.784401,-18.295601>, <0.318948,0.767377,-0.556242>
 <47.805801,-78.214401,-18.322599>, <0.441143,0.480233,-0.758135>
}
   smooth_triangle{ <47.805801,-78.214401,-18.322599>, <-0.441143,-0.480233,0.758135>
 <48.132198,-78.217598,-18.134701>, <-0.442498,-0.468970,0.764371>
 <47.785198,-78.197502,-18.325899>, <-0.458689,-0.403991,0.791451>
}
   smooth_triangle{ <47.805801,-78.214401,-18.322599>, <0.441143,0.480233,-0.758135>
 <47.785198,-78.197502,-18.325899>, <0.458689,0.403991,-0.791451>
 <48.132198,-78.217598,-18.134701>, <0.442498,0.468970,-0.764371>
}
   smooth_triangle{ <48.600700,-78.784401,-18.295601>, <-0.318948,-0.767377,0.556242>
 <49.621101,-78.498299,-17.488300>, <0.149840,-0.744340,0.650774>
 <48.132198,-78.217598,-18.134701>, <-0.442498,-0.468970,0.764371>
}
   smooth_triangle{ <48.600700,-78.784401,-18.295601>, <0.318948,0.767377,-0.556242>
 <48.132198,-78.217598,-18.134701>, <0.442498,0.468970,-0.764371>
 <49.621101,-78.498299,-17.488300>, <0.391157,0.577478,-0.716600>
}
   smooth_triangle{ <49.621101,-78.498299,-17.488300>, <0.149840,-0.744340,0.650774>
 <48.600700,-78.784401,-18.295601>, <-0.318948,-0.767377,0.556242>
 <49.219898,-78.777802,-17.932400>, <-0.046261,-0.989785,0.134856>
}
   smooth_triangle{ <49.621101,-78.498299,-17.488300>, <0.391157,0.577478,-0.716600>
 <49.219898,-78.777802,-17.932400>, <0.046261,0.989785,-0.134856>
 <48.600700,-78.784401,-18.295601>, <0.318948,0.767377,-0.556242>
}
   smooth_triangle{ <49.742699,-78.223801,-17.209400>, <-0.438354,-0.480246,0.759743>
 <48.132198,-78.217598,-18.134701>, <-0.442498,-0.468970,0.764371>
 <49.621101,-78.498299,-17.488300>, <0.149840,-0.744340,0.650774>
}
   smooth_triangle{ <49.742699,-78.223801,-17.209400>, <0.438354,0.480246,-0.759743>
 <49.621101,-78.498299,-17.488300>, <0.391157,0.577478,-0.716600>
 <48.132198,-78.217598,-18.134701>, <0.442498,0.468970,-0.764371>
}
   smooth_triangle{ <48.132198,-78.217598,-18.134701>, <-0.442498,-0.468970,0.764371>
 <49.742699,-78.223801,-17.209400>, <-0.438354,-0.480246,0.759743>
 <49.767601,-78.174202,-17.169500>, <-0.456354,-0.406516,0.791508>
}
   smooth_triangle{ <48.132198,-78.217598,-18.134701>, <0.442498,0.468970,-0.764371>
 <49.767601,-78.174202,-17.169500>, <0.456354,0.406516,-0.791508>
 <49.742699,-78.223801,-17.209400>, <0.438354,0.480246,-0.759743>
}
   smooth_triangle{ <49.621101,-78.498299,-17.488300>, <0.149840,-0.744340,0.650774>
 <49.219898,-78.777802,-17.932400>, <-0.046261,-0.989785,0.134856>
 <49.511299,-78.765602,-17.791100>, <0.282056,-0.922450,0.263686>
}
   smooth_triangle{ <49.621101,-78.498299,-17.488300>, <0.391157,0.577478,-0.716600>
 <49.511299,-78.765602,-17.791100>, <0.077502,0.966848,-0.243306>
 <49.219898,-78.777802,-17.932400>, <0.046261,0.989785,-0.134856>
}
   smooth_triangle{ <49.437801,-76.402702,-16.628401>, <-0.491515,-0.191640,0.849522>
 <47.800098,-76.423798,-17.580700>, <-0.490545,-0.193335,0.849699>
 <49.446301,-76.412697,-16.626801>, <-0.480975,-0.272767,0.833223>
}
   smooth_triangle{ <49.437801,-76.402702,-16.628401>, <0.480590,0.275375,-0.832587>
 <49.446301,-76.412697,-16.626801>, <0.480975,0.272767,-0.833223>
 <47.800098,-76.423798,-17.580700>, <0.482230,0.271990,-0.832752>
}
   smooth_triangle{ <47.800098,-76.423798,-17.580700>, <-0.490545,-0.193335,0.849699>
 <49.437801,-76.402702,-16.628401>, <-0.491515,-0.191640,0.849522>
 <49.234501,-76.115997,-16.710800>, <-0.148858,0.217485,0.964646>
}
   smooth_triangle{ <47.800098,-76.423798,-17.580700>, <-0.490545,-0.193335,0.849699>
 <49.234501,-76.115997,-16.710800>, <-0.148858,0.217485,0.964646>
 <48.962700,-75.700699,-16.853001>, <-0.169911,0.477916,0.861816>
}
   smooth_triangle{ <47.800098,-76.423798,-17.580700>, <-0.490545,-0.193335,0.849699>
 <48.962700,-75.700699,-16.853001>, <-0.169911,0.477916,0.861816>
 <48.042999,-75.714203,-17.351900>, <-0.471034,0.294052,0.831661>
}
   smooth_triangle{ <48.605202,-75.712601,-17.025600>, <-0.435289,0.023277,0.899990>
 <49.234501,-76.115997,-16.710800>, <-0.148858,0.217485,0.964646>
 <48.962700,-75.700699,-16.853001>, <-0.169911,0.477916,0.861816>
}
   smooth_triangle{ <49.234501,-76.115997,-16.710800>, <0.435289,-0.023277,-0.899990>
 <48.605202,-75.712601,-17.025600>, <0.435289,-0.023277,-0.899990>
 <48.962700,-75.700699,-16.853001>, <0.435289,-0.023277,-0.899990>
}
   smooth_triangle{ <49.234501,-76.115997,-16.710800>, <-0.148858,0.217485,0.964646>
 <48.962700,-75.700699,-16.853001>, <-0.169911,0.477916,0.861816>
 <48.605202,-75.712601,-17.025600>, <-0.435289,0.023277,0.899990>
}
   smooth_triangle{ <47.800098,-76.423798,-17.580700>, <-0.490545,-0.193335,0.849699>
 <47.468498,-76.429298,-17.775299>, <-0.494728,-0.188518,0.848354>
 <47.462601,-76.436897,-17.781200>, <-0.483743,-0.271558,0.832015>
}
   smooth_triangle{ <47.800098,-76.423798,-17.580700>, <0.482230,0.271990,-0.832752>
 <47.462601,-76.436897,-17.781200>, <0.483743,0.271558,-0.832015>
 <47.468498,-76.429298,-17.775299>, <0.483883,0.270747,-0.832198>
}
   smooth_triangle{ <47.468498,-76.429298,-17.775299>, <-0.494728,-0.188518,0.848354>
 <47.800098,-76.423798,-17.580700>, <-0.490545,-0.193335,0.849699>
 <48.042999,-75.714203,-17.351900>, <-0.471034,0.294052,0.831661>
}
   smooth_triangle{ <48.179501,-77.095001,-17.579901>, <-0.482657,-0.271834,0.832555>
 <47.800098,-76.423798,-17.580700>, <-0.490545,-0.193335,0.849699>
 <47.462601,-76.436897,-17.781200>, <-0.483743,-0.271558,0.832015>
}
   smooth_triangle{ <48.179501,-77.095001,-17.579901>, <0.482657,0.271834,-0.832555>
 <47.462601,-76.436897,-17.781200>, <0.483743,0.271558,-0.832015>
 <47.800098,-76.423798,-17.580700>, <0.482230,0.271990,-0.832752>
}
   smooth_triangle{ <49.079102,-77.084099,-17.056299>, <-0.481535,-0.270728,0.833565>
 <49.446301,-76.412697,-16.626801>, <-0.480975,-0.272767,0.833223>
 <47.800098,-76.423798,-17.580700>, <-0.490545,-0.193335,0.849699>
}
   smooth_triangle{ <49.079102,-77.084099,-17.056299>, <0.481535,0.270728,-0.833565>
 <47.800098,-76.423798,-17.580700>, <0.482230,0.271990,-0.832752>
 <49.446301,-76.412697,-16.626801>, <0.480975,0.272767,-0.833223>
}
   smooth_triangle{ <49.079102,-77.084099,-17.056299>, <-0.481535,-0.270728,0.833565>
 <47.800098,-76.423798,-17.580700>, <-0.490545,-0.193335,0.849699>
 <48.179501,-77.095001,-17.579901>, <-0.482657,-0.271834,0.832555>
}
   smooth_triangle{ <49.079102,-77.084099,-17.056299>, <0.481535,0.270728,-0.833565>
 <48.179501,-77.095001,-17.579901>, <0.482657,0.271834,-0.832555>
 <47.800098,-76.423798,-17.580700>, <0.482230,0.271990,-0.832752>
}
 texture
      {
      pigment
     {      colour rgb<0.5, 0.5, 0.5>}}
      finish
     {ambient 0.4 diffuse 0.5
     specular 0.2 roughness 0.1
}
}
 no_shadow
}
//  Object:  prednje krilo la1
object
{   union{
   smooth_triangle{ <49.613701,-84.061302,-24.255301>, <-0.494886,-0.369930,0.786282>
 <48.780602,-84.449303,-24.962200>, <-0.488946,-0.373686,0.788220>
 <49.423100,-84.458702,-24.551600>, <-0.512743,-0.341929,0.787514>
}
   smooth_triangle{ <49.613701,-84.061302,-24.255301>, <0.476318,0.377622,-0.794055>
 <49.423100,-84.458702,-24.551600>, <0.469905,0.364684,-0.803862>
 <48.780602,-84.449303,-24.962200>, <0.488946,0.373686,-0.788220>
}
   smooth_triangle{ <49.613701,-84.061302,-24.255301>, <-0.494886,-0.369930,0.786282>
 <48.936600,-84.057503,-24.668600>, <-0.472104,-0.405487,0.782751>
 <48.780602,-84.449303,-24.962200>, <-0.488946,-0.373686,0.788220>
}
   smooth_triangle{ <49.613701,-84.061302,-24.255301>, <0.476318,0.377622,-0.794055>
 <48.780602,-84.449303,-24.962200>, <0.488946,0.373686,-0.788220>
 <48.936600,-84.057503,-24.668600>, <0.472104,0.405487,-0.782751>
}
   smooth_triangle{ <48.936600,-84.057503,-24.668600>, <-0.472104,-0.405487,0.782751>
 <47.924301,-84.446602,-25.478100>, <-0.467892,-0.399378,0.788400>
 <48.780602,-84.449303,-24.962200>, <-0.488946,-0.373686,0.788220>
}
   smooth_triangle{ <48.936600,-84.057503,-24.668600>, <0.472104,0.405487,-0.782751>
 <48.780602,-84.449303,-24.962200>, <0.488946,0.373686,-0.788220>
 <47.924301,-84.446602,-25.478100>, <0.467892,0.399378,-0.788400>
}
   smooth_triangle{ <48.936600,-84.057503,-24.668600>, <-0.472104,-0.405487,0.782751>
 <48.040901,-84.057503,-25.198900>, <-0.458281,-0.425163,0.780522>
 <47.924301,-84.446602,-25.478100>, <-0.467892,-0.399378,0.788400>
}
   smooth_triangle{ <48.936600,-84.057503,-24.668600>, <0.472104,0.405487,-0.782751>
 <47.924301,-84.446602,-25.478100>, <0.467892,0.399378,-0.788400>
 <48.040901,-84.057503,-25.198900>, <0.458281,0.425163,-0.780522>
}
   smooth_triangle{ <48.040901,-84.057503,-25.198900>, <-0.458281,-0.425163,0.780522>
 <46.981800,-84.447899,-26.031700>, <-0.459269,-0.408148,0.788978>
 <47.924301,-84.446602,-25.478100>, <-0.467892,-0.399378,0.788400>
}
   smooth_triangle{ <48.040901,-84.057503,-25.198900>, <0.458281,0.425163,-0.780522>
 <47.924301,-84.446602,-25.478100>, <0.467892,0.399378,-0.788400>
 <46.981800,-84.447899,-26.031700>, <0.459269,0.408148,-0.788978>
}
   smooth_triangle{ <48.040901,-84.057503,-25.198900>, <-0.458281,-0.425163,0.780522>
 <47.058201,-84.059898,-25.772900>, <-0.452778,-0.431492,0.780261>
 <46.981800,-84.447899,-26.031700>, <-0.459269,-0.408148,0.788978>
}
   smooth_triangle{ <48.040901,-84.057503,-25.198900>, <0.458281,0.425163,-0.780522>
 <46.981800,-84.447899,-26.031700>, <0.459269,0.408148,-0.788978>
 <47.058201,-84.059898,-25.772900>, <0.452778,0.431492,-0.780261>
}
   smooth_triangle{ <47.058201,-84.059898,-25.772900>, <-0.452778,-0.431492,0.780261>
 <46.080799,-84.450996,-26.555300>, <-0.453944,-0.409835,0.791183>
 <46.981800,-84.447899,-26.031700>, <-0.459269,-0.408148,0.788978>
}
   smooth_triangle{ <47.058201,-84.059898,-25.772900>, <0.452778,0.431492,-0.780261>
 <46.981800,-84.447899,-26.031700>, <0.459269,0.408148,-0.788978>
 <46.080799,-84.450996,-26.555300>, <0.453944,0.409835,-0.791183>
}
   smooth_triangle{ <47.058201,-84.059898,-25.772900>, <-0.452778,-0.431492,0.780261>
 <46.119900,-84.063202,-26.317900>, <-0.449150,-0.431341,0.782438>
 <46.080799,-84.450996,-26.555300>, <-0.453944,-0.409835,0.791183>
}
   smooth_triangle{ <47.058201,-84.059898,-25.772900>, <0.452778,0.431492,-0.780261>
 <46.080799,-84.450996,-26.555300>, <0.453944,0.409835,-0.791183>
 <46.119900,-84.063202,-26.317900>, <0.449150,0.431341,-0.782438>
}
   smooth_triangle{ <46.119900,-84.063202,-26.317900>, <-0.449150,-0.431341,0.782438>
 <45.300098,-84.455704,-27.002399>, <-0.444746,-0.407206,0.797737>
 <46.080799,-84.450996,-26.555300>, <-0.453944,-0.409835,0.791183>
}
   smooth_triangle{ <46.119900,-84.063202,-26.317900>, <0.449150,0.431341,-0.782438>
 <46.080799,-84.450996,-26.555300>, <0.453944,0.409835,-0.791183>
 <45.300098,-84.455704,-27.002399>, <0.444746,0.407206,-0.797737>
}
   smooth_triangle{ <46.119900,-84.063202,-26.317900>, <-0.449150,-0.431341,0.782438>
 <45.308300,-84.067101,-26.785801>, <-0.443294,-0.423357,0.790101>
 <45.300098,-84.455704,-27.002399>, <-0.444746,-0.407206,0.797737>
}
   smooth_triangle{ <46.119900,-84.063202,-26.317900>, <0.449150,0.431341,-0.782438>
 <45.300098,-84.455704,-27.002399>, <0.444746,0.407206,-0.797737>
 <45.308300,-84.067101,-26.785801>, <0.443294,0.423357,-0.790101>
}
   smooth_triangle{ <45.308300,-84.067101,-26.785801>, <-0.443294,-0.423357,0.790101>
 <44.554100,-84.464600,-27.415300>, <-0.434280,-0.394834,0.809634>
 <45.300098,-84.455704,-27.002399>, <-0.444746,-0.407206,0.797737>
}
   smooth_triangle{ <45.308300,-84.067101,-26.785801>, <0.443294,0.423357,-0.790101>
 <45.300098,-84.455704,-27.002399>, <0.444746,0.407206,-0.797737>
 <44.554100,-84.464600,-27.415300>, <0.434280,0.394834,-0.809634>
}
   smooth_triangle{ <45.308300,-84.067101,-26.785801>, <-0.443294,-0.423357,0.790101>
 <44.535999,-84.073196,-27.223301>, <-0.439255,-0.400355,0.804221>
 <44.554100,-84.464600,-27.415300>, <-0.434280,-0.394834,0.809634>
}
   smooth_triangle{ <45.308300,-84.067101,-26.785801>, <0.443294,0.423357,-0.790101>
 <44.554100,-84.464600,-27.415300>, <0.434280,0.394834,-0.809634>
 <44.535999,-84.073196,-27.223301>, <0.439255,0.400355,-0.804221>
}
   smooth_triangle{ <44.535999,-84.073196,-27.223301>, <-0.439255,-0.400355,0.804221>
 <43.724098,-84.479500,-27.858801>, <-0.429157,-0.367339,0.825158>
 <44.554100,-84.464600,-27.415300>, <-0.434280,-0.394834,0.809634>
}
   smooth_triangle{ <44.535999,-84.073196,-27.223301>, <0.439255,0.400355,-0.804221>
 <44.554100,-84.464600,-27.415300>, <0.434280,0.394834,-0.809634>
 <43.724098,-84.479500,-27.858801>, <0.429157,0.367339,-0.825158>
}
   smooth_triangle{ <44.535999,-84.073196,-27.223301>, <-0.439255,-0.400355,0.804221>
 <43.680099,-84.082703,-27.699499>, <-0.441241,-0.356875,0.823375>
 <43.724098,-84.479500,-27.858801>, <-0.429157,-0.367339,0.825158>
}
   smooth_triangle{ <44.535999,-84.073196,-27.223301>, <0.439255,0.400355,-0.804221>
 <43.724098,-84.479500,-27.858801>, <0.429157,0.367339,-0.825158>
 <43.680099,-84.082703,-27.699499>, <0.441241,0.356875,-0.823375>
}
   smooth_triangle{ <43.680099,-84.082703,-27.699499>, <-0.441241,-0.356875,0.823375>
 <42.691200,-84.502098,-28.397800>, <-0.436246,-0.338935,0.833554>
 <43.724098,-84.479500,-27.858801>, <-0.429157,-0.367339,0.825158>
}
   smooth_triangle{ <43.680099,-84.082703,-27.699499>, <0.441241,0.356875,-0.823375>
 <43.724098,-84.479500,-27.858801>, <0.429157,0.367339,-0.825158>
 <42.691200,-84.502098,-28.397800>, <0.471497,0.327411,-0.818836>
}
   smooth_triangle{ <43.680099,-84.082703,-27.699499>, <-0.441241,-0.356875,0.823375>
 <42.617699,-84.096703,-28.283600>, <-0.453739,-0.316892,0.832886>
 <42.691200,-84.502098,-28.397800>, <-0.436246,-0.338935,0.833554>
}
   smooth_triangle{ <43.680099,-84.082703,-27.699499>, <0.441241,0.356875,-0.823375>
 <42.691200,-84.502098,-28.397800>, <0.471497,0.327411,-0.818836>
 <42.617699,-84.096703,-28.283600>, <0.484554,0.305094,-0.819833>
}
   smooth_triangle{ <42.617699,-84.096703,-28.283600>, <0.484554,0.305094,-0.819833>
 <43.587898,-84.510498,-27.839399>, <0.501525,0.297335,-0.812444>
 <42.691200,-84.502098,-28.397800>, <0.471497,0.327411,-0.818836>
}
   smooth_triangle{ <42.617699,-84.096703,-28.283600>, <0.484554,0.305094,-0.819833>
 <43.559700,-84.099701,-27.716299>, <0.497801,0.272060,-0.823516>
 <43.587898,-84.510498,-27.839399>, <0.501525,0.297335,-0.812444>
}
   smooth_triangle{ <43.559700,-84.099701,-27.716299>, <0.497801,0.272060,-0.823516>
 <44.403099,-84.515404,-27.341101>, <0.494998,0.279651,-0.822661>
 <43.587898,-84.510498,-27.839399>, <0.501525,0.297335,-0.812444>
}
   smooth_triangle{ <43.559700,-84.099701,-27.716299>, <0.497801,0.272060,-0.823516>
 <44.413799,-84.100800,-27.206800>, <0.493429,0.252976,-0.832184>
 <44.403099,-84.515404,-27.341101>, <0.494998,0.279651,-0.822661>
}
   smooth_triangle{ <44.413799,-84.100800,-27.206800>, <0.493429,0.252976,-0.832184>
 <45.188801,-84.515999,-26.874100>, <0.483947,0.274176,-0.831037>
 <44.403099,-84.515404,-27.341101>, <0.494998,0.279651,-0.822661>
}
   smooth_triangle{ <44.413799,-84.100800,-27.206800>, <0.493429,0.252976,-0.832184>
 <45.234299,-84.099701,-26.724600>, <0.485335,0.249361,-0.838015>
 <45.188801,-84.515999,-26.874100>, <0.483947,0.274176,-0.831037>
}
   smooth_triangle{ <45.234299,-84.099701,-26.724600>, <0.485335,0.249361,-0.838015>
 <45.996899,-84.511803,-26.409201>, <0.471081,0.281415,-0.835995>
 <45.188801,-84.515999,-26.874100>, <0.483947,0.274176,-0.831037>
}
   smooth_triangle{ <45.234299,-84.099701,-26.724600>, <0.485335,0.249361,-0.838015>
 <46.074799,-84.096001,-26.239000>, <0.475601,0.261718,-0.839826>
 <45.996899,-84.511803,-26.409201>, <0.471081,0.281415,-0.835995>
}
   smooth_triangle{ <46.074799,-84.096001,-26.239000>, <0.475601,0.261718,-0.839826>
 <46.903702,-84.502403,-25.902500>, <0.458910,0.300479,-0.836131>
 <45.996899,-84.511803,-26.409201>, <0.471081,0.281415,-0.835995>
}
   smooth_triangle{ <46.074799,-84.096001,-26.239000>, <0.475601,0.261718,-0.839826>
 <47.014702,-84.089302,-25.703899>, <0.465712,0.288275,-0.836666>
 <46.903702,-84.502403,-25.902500>, <0.458910,0.300479,-0.836131>
}
   smooth_triangle{ <47.014702,-84.089302,-25.703899>, <0.465712,0.288275,-0.836666>
 <47.854500,-84.489197,-25.381800>, <0.446366,0.328911,-0.832211>
 <46.903702,-84.502403,-25.902500>, <0.458910,0.300479,-0.836131>
}
   smooth_triangle{ <47.014702,-84.089302,-25.703899>, <0.465712,0.288275,-0.836666>
 <47.997898,-84.080498,-25.150000>, <0.454178,0.325097,-0.829478>
 <47.854500,-84.489197,-25.381800>, <0.446366,0.328911,-0.832211>
}
   smooth_triangle{ <47.997898,-84.080498,-25.150000>, <0.454178,0.325097,-0.829478>
 <48.733101,-84.474098,-24.910500>, <0.429651,0.364949,-0.825962>
 <47.854500,-84.489197,-25.381800>, <0.446366,0.328911,-0.832211>
}
   smooth_triangle{ <47.997898,-84.080498,-25.150000>, <0.454178,0.325097,-0.829478>
 <48.904301,-84.070801,-24.644699>, <0.438463,0.369191,-0.819420>
 <48.733101,-84.474098,-24.910500>, <0.429651,0.364949,-0.825962>
}
   smooth_triangle{ <48.904301,-84.070801,-24.644699>, <0.438463,0.369191,-0.819420>
 <49.423100,-84.458702,-24.551600>, <0.469905,0.364684,-0.803862>
 <48.733101,-84.474098,-24.910500>, <0.429651,0.364949,-0.825962>
}
   smooth_triangle{ <48.904301,-84.070801,-24.644699>, <0.438463,0.369191,-0.819420>
 <49.613701,-84.061302,-24.255301>, <0.476318,0.377622,-0.794055>
 <49.423100,-84.458702,-24.551600>, <0.469905,0.364684,-0.803862>
}
   smooth_triangle{ <49.423100,-84.458702,-24.551600>, <-0.512743,-0.341929,0.787514>
 <48.618698,-84.845497,-25.245199>, <-0.503689,-0.336079,0.795832>
 <49.230801,-84.857300,-24.844801>, <-0.524807,-0.312028,0.791970>
}
   smooth_triangle{ <49.423100,-84.458702,-24.551600>, <0.469905,0.364684,-0.803862>
 <49.230801,-84.857300,-24.844801>, <0.468303,0.352169,-0.810352>
 <48.618698,-84.845497,-25.245199>, <0.503689,0.336079,-0.795832>
}
   smooth_triangle{ <49.423100,-84.458702,-24.551600>, <-0.512743,-0.341929,0.787514>
 <48.780602,-84.449303,-24.962200>, <-0.488946,-0.373686,0.788220>
 <48.618698,-84.845497,-25.245199>, <-0.503689,-0.336079,0.795832>
}
   smooth_triangle{ <49.423100,-84.458702,-24.551600>, <0.469905,0.364684,-0.803862>
 <48.618698,-84.845497,-25.245199>, <0.503689,0.336079,-0.795832>
 <48.780602,-84.449303,-24.962200>, <0.488946,0.373686,-0.788220>
}
   smooth_triangle{ <48.780602,-84.449303,-24.962200>, <-0.488946,-0.373686,0.788220>
 <47.799500,-84.841698,-25.742800>, <-0.479158,-0.356973,0.801859>
 <48.618698,-84.845497,-25.245199>, <-0.503689,-0.336079,0.795832>
}
   smooth_triangle{ <48.780602,-84.449303,-24.962200>, <0.488946,0.373686,-0.788220>
 <48.618698,-84.845497,-25.245199>, <0.503689,0.336079,-0.795832>
 <47.799500,-84.841698,-25.742800>, <0.479158,0.356973,-0.801859>
}
   smooth_triangle{ <48.780602,-84.449303,-24.962200>, <-0.488946,-0.373686,0.788220>
 <47.924301,-84.446602,-25.478100>, <-0.467892,-0.399378,0.788400>
 <47.799500,-84.841698,-25.742800>, <-0.479158,-0.356973,0.801859>
}
   smooth_triangle{ <48.780602,-84.449303,-24.962200>, <0.488946,0.373686,-0.788220>
 <47.799500,-84.841698,-25.742800>, <0.479158,0.356973,-0.801859>
 <47.924301,-84.446602,-25.478100>, <0.467892,0.399378,-0.788400>
}
   smooth_triangle{ <47.924301,-84.446602,-25.478100>, <-0.467892,-0.399378,0.788400>
 <46.896099,-84.842796,-26.274000>, <-0.468875,-0.364078,0.804738>
 <47.799500,-84.841698,-25.742800>, <-0.479158,-0.356973,0.801859>
}
   smooth_triangle{ <47.924301,-84.446602,-25.478100>, <0.467892,0.399378,-0.788400>
 <47.799500,-84.841698,-25.742800>, <0.479158,0.356973,-0.801859>
 <46.896099,-84.842796,-26.274000>, <0.468875,0.364078,-0.804738>
}
   smooth_triangle{ <47.924301,-84.446602,-25.478100>, <-0.467892,-0.399378,0.788400>
 <46.981800,-84.447899,-26.031700>, <-0.459269,-0.408148,0.788978>
 <46.896099,-84.842796,-26.274000>, <-0.468875,-0.364078,0.804738>
}
   smooth_triangle{ <47.924301,-84.446602,-25.478100>, <0.467892,0.399378,-0.788400>
 <46.896099,-84.842796,-26.274000>, <0.468875,0.364078,-0.804738>
 <46.981800,-84.447899,-26.031700>, <0.459269,0.408148,-0.788978>
}
   smooth_triangle{ <46.981800,-84.447899,-26.031700>, <-0.459269,-0.408148,0.788978>
 <46.031799,-84.846100,-26.775101>, <-0.462218,-0.366117,0.807659>
 <46.896099,-84.842796,-26.274000>, <-0.468875,-0.364078,0.804738>
}
   smooth_triangle{ <46.981800,-84.447899,-26.031700>, <0.459269,0.408148,-0.788978>
 <46.896099,-84.842796,-26.274000>, <0.468875,0.364078,-0.804738>
 <46.031799,-84.846100,-26.775101>, <0.462218,0.366117,-0.807659>
}
   smooth_triangle{ <46.981800,-84.447899,-26.031700>, <-0.459269,-0.408148,0.788978>
 <46.080799,-84.450996,-26.555300>, <-0.453944,-0.409835,0.791183>
 <46.031799,-84.846100,-26.775101>, <-0.462218,-0.366117,0.807659>
}
   smooth_triangle{ <46.981800,-84.447899,-26.031700>, <0.459269,0.408148,-0.788978>
 <46.031799,-84.846100,-26.775101>, <0.462218,0.366117,-0.807659>
 <46.080799,-84.450996,-26.555300>, <0.453944,0.409835,-0.791183>
}
   smooth_triangle{ <46.080799,-84.450996,-26.555300>, <-0.453944,-0.409835,0.791183>
 <45.282101,-84.851402,-27.202000>, <-0.449871,-0.367364,0.814039>
 <46.031799,-84.846100,-26.775101>, <-0.462218,-0.366117,0.807659>
}
   smooth_triangle{ <46.080799,-84.450996,-26.555300>, <0.453944,0.409835,-0.791183>
 <46.031799,-84.846100,-26.775101>, <0.462218,0.366117,-0.807659>
 <45.282101,-84.851402,-27.202000>, <0.449871,0.367364,-0.814039>
}
   smooth_triangle{ <46.080799,-84.450996,-26.555300>, <-0.453944,-0.409835,0.791183>
 <45.300098,-84.455704,-27.002399>, <-0.444746,-0.407206,0.797737>
 <45.282101,-84.851402,-27.202000>, <-0.449871,-0.367364,0.814039>
}
   smooth_triangle{ <46.080799,-84.450996,-26.555300>, <0.453944,0.409835,-0.791183>
 <45.282101,-84.851402,-27.202000>, <0.449871,0.367364,-0.814039>
 <45.300098,-84.455704,-27.002399>, <0.444746,0.407206,-0.797737>
}
   smooth_triangle{ <45.300098,-84.455704,-27.002399>, <-0.444746,-0.407206,0.797737>
 <44.564201,-84.861900,-27.593201>, <-0.433292,-0.365262,0.823918>
 <45.282101,-84.851402,-27.202000>, <-0.449871,-0.367364,0.814039>
}
   smooth_triangle{ <45.300098,-84.455704,-27.002399>, <0.444746,0.407206,-0.797737>
 <45.282101,-84.851402,-27.202000>, <0.449871,0.367364,-0.814039>
 <44.564201,-84.861900,-27.593201>, <0.433292,0.365262,-0.823918>
}
   smooth_triangle{ <45.300098,-84.455704,-27.002399>, <-0.444746,-0.407206,0.797737>
 <44.554100,-84.464600,-27.415300>, <-0.434280,-0.394834,0.809634>
 <44.564201,-84.861900,-27.593201>, <-0.433292,-0.365262,0.823918>
}
   smooth_triangle{ <45.300098,-84.455704,-27.002399>, <0.444746,0.407206,-0.797737>
 <44.564201,-84.861900,-27.593201>, <0.433292,0.365262,-0.823918>
 <44.554100,-84.464600,-27.415300>, <0.434280,0.394834,-0.809634>
}
   smooth_triangle{ <44.554100,-84.464600,-27.415300>, <-0.434280,-0.394834,0.809634>
 <43.763599,-84.879601,-28.010099>, <-0.420917,-0.355839,0.834391>
 <44.564201,-84.861900,-27.593201>, <-0.433292,-0.365262,0.823918>
}
   smooth_triangle{ <44.554100,-84.464600,-27.415300>, <0.434280,0.394834,-0.809634>
 <44.564201,-84.861900,-27.593201>, <0.433292,0.365262,-0.823918>
 <43.763599,-84.879601,-28.010099>, <0.420917,0.355839,-0.834391>
}
   smooth_triangle{ <44.554100,-84.464600,-27.415300>, <-0.434280,-0.394834,0.809634>
 <43.724098,-84.479500,-27.858801>, <-0.429157,-0.367339,0.825158>
 <43.763599,-84.879601,-28.010099>, <-0.420917,-0.355839,0.834391>
}
   smooth_triangle{ <44.554100,-84.464600,-27.415300>, <0.434280,0.394834,-0.809634>
 <43.763599,-84.879601,-28.010099>, <0.420917,0.355839,-0.834391>
 <43.724098,-84.479500,-27.858801>, <0.429157,0.367339,-0.825158>
}
   smooth_triangle{ <43.724098,-84.479500,-27.858801>, <-0.429157,-0.367339,0.825158>
 <42.765800,-84.906601,-28.514000>, <-0.420563,-0.341312,0.840614>
 <43.763599,-84.879601,-28.010099>, <-0.420917,-0.355839,0.834391>
}
   smooth_triangle{ <43.724098,-84.479500,-27.858801>, <0.429157,0.367339,-0.825158>
 <43.763599,-84.879601,-28.010099>, <0.420917,0.355839,-0.834391>
 <42.765800,-84.906601,-28.514000>, <0.464267,0.339923,-0.817868>
}
   smooth_triangle{ <43.724098,-84.479500,-27.858801>, <-0.429157,-0.367339,0.825158>
 <42.691200,-84.502098,-28.397800>, <-0.436246,-0.338935,0.833554>
 <42.765800,-84.906601,-28.514000>, <-0.420563,-0.341312,0.840614>
}
   smooth_triangle{ <43.724098,-84.479500,-27.858801>, <0.429157,0.367339,-0.825158>
 <42.765800,-84.906601,-28.514000>, <0.464267,0.339923,-0.817868>
 <42.691200,-84.502098,-28.397800>, <0.471497,0.327411,-0.818836>
}
   smooth_triangle{ <42.691200,-84.502098,-28.397800>, <0.471497,0.327411,-0.818836>
 <43.621700,-84.917397,-27.972200>, <0.502619,0.327558,-0.800050>
 <42.765800,-84.906601,-28.514000>, <0.464267,0.339923,-0.817868>
}
   smooth_triangle{ <42.691200,-84.502098,-28.397800>, <0.471497,0.327411,-0.818836>
 <43.587898,-84.510498,-27.839399>, <0.501525,0.297335,-0.812444>
 <43.621700,-84.917397,-27.972200>, <0.502619,0.327558,-0.800050>
}
   smooth_triangle{ <43.587898,-84.510498,-27.839399>, <0.501525,0.297335,-0.812444>
 <44.400902,-84.923798,-27.490400>, <0.492050,0.321904,-0.808866>
 <43.621700,-84.917397,-27.972200>, <0.502619,0.327558,-0.800050>
}
   smooth_triangle{ <43.587898,-84.510498,-27.839399>, <0.501525,0.297335,-0.812444>
 <44.403099,-84.515404,-27.341101>, <0.494998,0.279651,-0.822661>
 <44.400902,-84.923798,-27.490400>, <0.492050,0.321904,-0.808866>
}
   smooth_triangle{ <44.403099,-84.515404,-27.341101>, <0.494998,0.279651,-0.822661>
 <45.153301,-84.924896,-27.041201>, <0.476977,0.322294,-0.817692>
 <44.400902,-84.923798,-27.490400>, <0.492050,0.321904,-0.808866>
}
   smooth_triangle{ <44.403099,-84.515404,-27.341101>, <0.494998,0.279651,-0.822661>
 <45.188801,-84.515999,-26.874100>, <0.483947,0.274176,-0.831037>
 <45.153301,-84.924896,-27.041201>, <0.476977,0.322294,-0.817692>
}
   smooth_triangle{ <45.188801,-84.515999,-26.874100>, <0.483947,0.274176,-0.831037>
 <45.929001,-84.920197,-26.597000>, <0.460668,0.328539,-0.824528>
 <45.153301,-84.924896,-27.041201>, <0.476977,0.322294,-0.817692>
}
   smooth_triangle{ <45.188801,-84.515999,-26.874100>, <0.483947,0.274176,-0.831037>
 <45.996899,-84.511803,-26.409201>, <0.471081,0.281415,-0.835995>
 <45.929001,-84.920197,-26.597000>, <0.460668,0.328539,-0.824528>
}
   smooth_triangle{ <45.996899,-84.511803,-26.409201>, <0.471081,0.281415,-0.835995>
 <46.801201,-84.909302,-26.115900>, <0.446617,0.339547,-0.827793>
 <45.929001,-84.920197,-26.597000>, <0.460668,0.328539,-0.824528>
}
   smooth_triangle{ <45.996899,-84.511803,-26.409201>, <0.471081,0.281415,-0.835995>
 <46.903702,-84.502403,-25.902500>, <0.458910,0.300479,-0.836131>
 <46.801201,-84.909302,-26.115900>, <0.446617,0.339547,-0.827793>
}
   smooth_triangle{ <46.903702,-84.502403,-25.902500>, <0.458910,0.300479,-0.836131>
 <47.716900,-84.893700,-25.623800>, <0.433894,0.354682,-0.828213>
 <46.801201,-84.909302,-26.115900>, <0.446617,0.339547,-0.827793>
}
   smooth_triangle{ <46.903702,-84.502403,-25.902500>, <0.458910,0.300479,-0.836131>
 <47.854500,-84.489197,-25.381800>, <0.446366,0.328911,-0.832211>
 <47.716900,-84.893700,-25.623800>, <0.433894,0.354682,-0.828213>
}
   smooth_triangle{ <47.854500,-84.489197,-25.381800>, <0.446366,0.328911,-0.832211>
 <48.564098,-84.875702,-25.180201>, <0.417372,0.374894,-0.827802>
 <47.716900,-84.893700,-25.623800>, <0.433894,0.354682,-0.828213>
}
   smooth_triangle{ <47.854500,-84.489197,-25.381800>, <0.446366,0.328911,-0.832211>
 <48.733101,-84.474098,-24.910500>, <0.429651,0.364949,-0.825962>
 <48.564098,-84.875702,-25.180201>, <0.417372,0.374894,-0.827802>
}
   smooth_triangle{ <48.733101,-84.474098,-24.910500>, <0.429651,0.364949,-0.825962>
 <49.230801,-84.857300,-24.844801>, <0.468303,0.352169,-0.810352>
 <48.564098,-84.875702,-25.180201>, <0.417372,0.374894,-0.827802>
}
   smooth_triangle{ <48.733101,-84.474098,-24.910500>, <0.429651,0.364949,-0.825962>
 <49.423100,-84.458702,-24.551600>, <0.469905,0.364684,-0.803862>
 <49.230801,-84.857300,-24.844801>, <0.468303,0.352169,-0.810352>
}
   smooth_triangle{ <49.230801,-84.857300,-24.844801>, <-0.524807,-0.312028,0.791970>
 <48.448101,-85.248001,-25.513300>, <-0.509386,-0.315297,0.800696>
 <49.033199,-85.259697,-25.129101>, <-0.526285,-0.302823,0.794558>
}
   smooth_triangle{ <49.230801,-84.857300,-24.844801>, <0.468303,0.352169,-0.810352>
 <49.033199,-85.259697,-25.129101>, <0.466898,0.345426,-0.814056>
 <48.448101,-85.248001,-25.513300>, <0.509386,0.315297,-0.800696>
}
   smooth_triangle{ <49.230801,-84.857300,-24.844801>, <-0.524807,-0.312028,0.791970>
 <48.618698,-84.845497,-25.245199>, <-0.503689,-0.336079,0.795832>
 <48.448101,-85.248001,-25.513300>, <-0.509386,-0.315297,0.800696>
}
   smooth_triangle{ <49.230801,-84.857300,-24.844801>, <0.468303,0.352169,-0.810352>
 <48.448101,-85.248001,-25.513300>, <0.509386,0.315297,-0.800696>
 <48.618698,-84.845497,-25.245199>, <0.503689,0.336079,-0.795832>
}
   smooth_triangle{ <48.618698,-84.845497,-25.245199>, <-0.503689,-0.336079,0.795832>
 <47.664299,-85.244102,-25.990000>, <-0.484406,-0.332820,0.809062>
 <48.448101,-85.248001,-25.513300>, <-0.509386,-0.315297,0.800696>
}
   smooth_triangle{ <48.618698,-84.845497,-25.245199>, <0.503689,0.336079,-0.795832>
 <48.448101,-85.248001,-25.513300>, <0.509386,0.315297,-0.800696>
 <47.664299,-85.244102,-25.990000>, <0.484406,0.332820,-0.809062>
}
   smooth_triangle{ <48.618698,-84.845497,-25.245199>, <-0.503689,-0.336079,0.795832>
 <47.799500,-84.841698,-25.742800>, <-0.479158,-0.356973,0.801859>
 <47.664299,-85.244102,-25.990000>, <-0.484406,-0.332820,0.809062>
}
   smooth_triangle{ <48.618698,-84.845497,-25.245199>, <0.503689,0.336079,-0.795832>
 <47.664299,-85.244102,-25.990000>, <0.484406,0.332820,-0.809062>
 <47.799500,-84.841698,-25.742800>, <0.479158,0.356973,-0.801859>
}
   smooth_triangle{ <47.799500,-84.841698,-25.742800>, <-0.479158,-0.356973,0.801859>
 <46.799999,-85.245102,-26.498501>, <-0.473688,-0.339822,0.812490>
 <47.664299,-85.244102,-25.990000>, <-0.484406,-0.332820,0.809062>
}
   smooth_triangle{ <47.799500,-84.841698,-25.742800>, <0.479158,0.356973,-0.801859>
 <47.664299,-85.244102,-25.990000>, <0.484406,0.332820,-0.809062>
 <46.799999,-85.245102,-26.498501>, <0.473688,0.339822,-0.812490>
}
   smooth_triangle{ <47.799500,-84.841698,-25.742800>, <-0.479158,-0.356973,0.801859>
 <46.896099,-84.842796,-26.274000>, <-0.468875,-0.364078,0.804738>
 <46.799999,-85.245102,-26.498501>, <-0.473688,-0.339822,0.812490>
}
   smooth_triangle{ <47.799500,-84.841698,-25.742800>, <0.479158,0.356973,-0.801859>
 <46.799999,-85.245102,-26.498501>, <0.473688,0.339822,-0.812490>
 <46.896099,-84.842796,-26.274000>, <0.468875,0.364078,-0.804738>
}
   smooth_triangle{ <46.896099,-84.842796,-26.274000>, <-0.468875,-0.364078,0.804738>
 <45.972900,-85.248199,-26.978100>, <-0.466242,-0.344558,0.814800>
 <46.799999,-85.245102,-26.498501>, <-0.473688,-0.339822,0.812490>
}
   smooth_triangle{ <46.896099,-84.842796,-26.274000>, <0.468875,0.364078,-0.804738>
 <46.799999,-85.245102,-26.498501>, <0.473688,0.339822,-0.812490>
 <45.972900,-85.248199,-26.978100>, <0.466242,0.344558,-0.814800>
}
   smooth_triangle{ <46.896099,-84.842796,-26.274000>, <-0.468875,-0.364078,0.804738>
 <46.031799,-84.846100,-26.775101>, <-0.462218,-0.366117,0.807659>
 <45.972900,-85.248199,-26.978100>, <-0.466242,-0.344558,0.814800>
}
   smooth_triangle{ <46.896099,-84.842796,-26.274000>, <0.468875,0.364078,-0.804738>
 <45.972900,-85.248199,-26.978100>, <0.466242,0.344558,-0.814800>
 <46.031799,-84.846100,-26.775101>, <0.462218,0.366117,-0.807659>
}
   smooth_triangle{ <46.031799,-84.846100,-26.775101>, <-0.462218,-0.366117,0.807659>
 <45.255299,-85.253304,-27.386400>, <-0.452244,-0.352960,0.819081>
 <45.972900,-85.248199,-26.978100>, <-0.466242,-0.344558,0.814800>
}
   smooth_triangle{ <46.031799,-84.846100,-26.775101>, <0.462218,0.366117,-0.807659>
 <45.972900,-85.248199,-26.978100>, <0.466242,0.344558,-0.814800>
 <45.255299,-85.253304,-27.386400>, <0.452244,0.352960,-0.819081>
}
   smooth_triangle{ <46.031799,-84.846100,-26.775101>, <-0.462218,-0.366117,0.807659>
 <45.282101,-84.851402,-27.202000>, <-0.449871,-0.367364,0.814039>
 <45.255299,-85.253304,-27.386400>, <-0.452244,-0.352960,0.819081>
}
   smooth_triangle{ <46.031799,-84.846100,-26.775101>, <0.462218,0.366117,-0.807659>
 <45.255299,-85.253304,-27.386400>, <0.452244,0.352960,-0.819081>
 <45.282101,-84.851402,-27.202000>, <0.449871,0.367364,-0.814039>
}
   smooth_triangle{ <45.282101,-84.851402,-27.202000>, <-0.449871,-0.367364,0.814039>
 <44.568001,-85.263603,-27.760300>, <-0.432390,-0.363632,0.825112>
 <45.255299,-85.253304,-27.386400>, <-0.452244,-0.352960,0.819081>
}
   smooth_triangle{ <45.282101,-84.851402,-27.202000>, <0.449871,0.367364,-0.814039>
 <45.255299,-85.253304,-27.386400>, <0.452244,0.352960,-0.819081>
 <44.568001,-85.263603,-27.760300>, <0.432390,0.363632,-0.825112>
}
   smooth_triangle{ <45.282101,-84.851402,-27.202000>, <-0.449871,-0.367364,0.814039>
 <44.564201,-84.861900,-27.593201>, <-0.433292,-0.365262,0.823918>
 <44.568001,-85.263603,-27.760300>, <-0.432390,-0.363632,0.825112>
}
   smooth_triangle{ <45.282101,-84.851402,-27.202000>, <0.449871,0.367364,-0.814039>
 <44.568001,-85.263603,-27.760300>, <0.432390,0.363632,-0.825112>
 <44.564201,-84.861900,-27.593201>, <0.433292,0.365262,-0.823918>
}
   smooth_triangle{ <44.564201,-84.861900,-27.593201>, <-0.433292,-0.365262,0.823918>
 <43.801201,-85.280998,-28.158300>, <-0.415688,-0.371810,0.830037>
 <44.568001,-85.263603,-27.760300>, <-0.432390,-0.363632,0.825112>
}
   smooth_triangle{ <44.564201,-84.861900,-27.593201>, <0.433292,0.365262,-0.823918>
 <44.568001,-85.263603,-27.760300>, <0.432390,0.363632,-0.825112>
 <43.801201,-85.280998,-28.158300>, <0.415688,0.371810,-0.830037>
}
   smooth_triangle{ <44.564201,-84.861900,-27.593201>, <-0.433292,-0.365262,0.823918>
 <43.763599,-84.879601,-28.010099>, <-0.420917,-0.355839,0.834391>
 <43.801201,-85.280998,-28.158300>, <-0.415688,-0.371810,0.830037>
}
   smooth_triangle{ <44.564201,-84.861900,-27.593201>, <0.433292,0.365262,-0.823918>
 <43.801201,-85.280998,-28.158300>, <0.415688,0.371810,-0.830037>
 <43.763599,-84.879601,-28.010099>, <0.420917,0.355839,-0.834391>
}
   smooth_triangle{ <43.763599,-84.879601,-28.010099>, <-0.420917,-0.355839,0.834391>
 <42.845402,-85.307503,-28.638800>, <-0.410585,-0.365309,0.835445>
 <43.801201,-85.280998,-28.158300>, <-0.415688,-0.371810,0.830037>
}
   smooth_triangle{ <43.763599,-84.879601,-28.010099>, <0.420917,0.355839,-0.834391>
 <43.801201,-85.280998,-28.158300>, <0.415688,0.371810,-0.830037>
 <42.845402,-85.307503,-28.638800>, <0.460741,0.344854,-0.817798>
}
   smooth_triangle{ <43.763599,-84.879601,-28.010099>, <-0.420917,-0.355839,0.834391>
 <42.765800,-84.906601,-28.514000>, <-0.420563,-0.341312,0.840614>
 <42.845402,-85.307503,-28.638800>, <-0.410585,-0.365309,0.835445>
}
   smooth_triangle{ <43.763599,-84.879601,-28.010099>, <0.420917,0.355839,-0.834391>
 <42.845402,-85.307503,-28.638800>, <0.460741,0.344854,-0.817798>
 <42.765800,-84.906601,-28.514000>, <0.464267,0.339923,-0.817868>
}
   smooth_triangle{ <42.765800,-84.906601,-28.514000>, <0.464267,0.339923,-0.817868>
 <43.663898,-85.318298,-28.119301>, <0.503250,0.332331,-0.797682>
 <42.845402,-85.307503,-28.638800>, <0.460741,0.344854,-0.817798>
}
   smooth_triangle{ <42.765800,-84.906601,-28.514000>, <0.464267,0.339923,-0.817868>
 <43.621700,-84.917397,-27.972200>, <0.502619,0.327558,-0.800050>
 <43.663898,-85.318298,-28.119301>, <0.503250,0.332331,-0.797682>
}
   smooth_triangle{ <43.621700,-84.917397,-27.972200>, <0.502619,0.327558,-0.800050>
 <44.409100,-85.324699,-27.657499>, <0.490027,0.339135,-0.803032>
 <43.663898,-85.318298,-28.119301>, <0.503250,0.332331,-0.797682>
}
   smooth_triangle{ <43.621700,-84.917397,-27.972200>, <0.502619,0.327558,-0.800050>
 <44.400902,-84.923798,-27.490400>, <0.492050,0.321904,-0.808866>
 <44.409100,-85.324699,-27.657499>, <0.490027,0.339135,-0.803032>
}
   smooth_triangle{ <44.400902,-84.923798,-27.490400>, <0.492050,0.321904,-0.808866>
 <45.129101,-85.325897,-27.227301>, <0.472671,0.348218,-0.809522>
 <44.409100,-85.324699,-27.657499>, <0.490027,0.339135,-0.803032>
}
   smooth_triangle{ <44.400902,-84.923798,-27.490400>, <0.492050,0.321904,-0.808866>
 <45.153301,-84.924896,-27.041201>, <0.476977,0.322294,-0.817692>
 <45.129101,-85.325897,-27.227301>, <0.472671,0.348218,-0.809522>
}
   smooth_triangle{ <45.153301,-84.924896,-27.041201>, <0.476977,0.322294,-0.817692>
 <45.871399,-85.321297,-26.802401>, <0.454919,0.357537,-0.815608>
 <45.129101,-85.325897,-27.227301>, <0.472671,0.348218,-0.809522>
}
   smooth_triangle{ <45.153301,-84.924896,-27.041201>, <0.476977,0.322294,-0.817692>
 <45.929001,-84.920197,-26.597000>, <0.460668,0.328539,-0.824528>
 <45.871399,-85.321297,-26.802401>, <0.454919,0.357537,-0.815608>
}
   smooth_triangle{ <45.929001,-84.920197,-26.597000>, <0.460668,0.328539,-0.824528>
 <46.706402,-85.310600,-26.342501>, <0.440706,0.365084,-0.820056>
 <45.871399,-85.321297,-26.802401>, <0.454919,0.357537,-0.815608>
}
   smooth_triangle{ <45.929001,-84.920197,-26.597000>, <0.460668,0.328539,-0.824528>
 <46.801201,-84.909302,-26.115900>, <0.446617,0.339547,-0.827793>
 <46.706402,-85.310600,-26.342501>, <0.440706,0.365084,-0.820056>
}
   smooth_triangle{ <46.801201,-84.909302,-26.115900>, <0.446617,0.339547,-0.827793>
 <47.583199,-85.295502,-25.872400>, <0.429012,0.371704,-0.823277>
 <46.706402,-85.310600,-26.342501>, <0.440706,0.365084,-0.820056>
}
   smooth_triangle{ <46.801201,-84.909302,-26.115900>, <0.446617,0.339547,-0.827793>
 <47.716900,-84.893700,-25.623800>, <0.433894,0.354682,-0.828213>
 <47.583199,-85.295502,-25.872400>, <0.429012,0.371704,-0.823277>
}
   smooth_triangle{ <47.716900,-84.893700,-25.623800>, <0.433894,0.354682,-0.828213>
 <48.394501,-85.277802,-25.448900>, <0.414223,0.380608,-0.826775>
 <47.583199,-85.295502,-25.872400>, <0.429012,0.371704,-0.823277>
}
   smooth_triangle{ <47.716900,-84.893700,-25.623800>, <0.433894,0.354682,-0.828213>
 <48.564098,-84.875702,-25.180201>, <0.417372,0.374894,-0.827802>
 <48.394501,-85.277802,-25.448900>, <0.414223,0.380608,-0.826775>
}
   smooth_triangle{ <48.564098,-84.875702,-25.180201>, <0.417372,0.374894,-0.827802>
 <49.033199,-85.259697,-25.129101>, <0.466898,0.345426,-0.814056>
 <48.394501,-85.277802,-25.448900>, <0.414223,0.380608,-0.826775>
}
   smooth_triangle{ <48.564098,-84.875702,-25.180201>, <0.417372,0.374894,-0.827802>
 <49.230801,-84.857300,-24.844801>, <0.468303,0.352169,-0.810352>
 <49.033199,-85.259697,-25.129101>, <0.466898,0.345426,-0.814056>
}
   smooth_triangle{ <49.033199,-85.259697,-25.129101>, <-0.526285,-0.302823,0.794558>
 <48.007000,-86.112999,-26.133400>, <-0.507756,-0.316183,0.801381>
 <48.609100,-86.124100,-25.741100>, <-0.522312,-0.306822,0.795645>
}
   smooth_triangle{ <49.033199,-85.259697,-25.129101>, <0.466898,0.345426,-0.814056>
 <48.609100,-86.124100,-25.741100>, <0.465541,0.348330,-0.813596>
 <48.007000,-86.112999,-26.133400>, <0.507756,0.316183,-0.801381>
}
   smooth_triangle{ <49.033199,-85.259697,-25.129101>, <-0.526285,-0.302823,0.794558>
 <48.448101,-85.248001,-25.513300>, <-0.509386,-0.315297,0.800696>
 <48.007000,-86.112999,-26.133400>, <-0.507756,-0.316183,0.801381>
}
   smooth_triangle{ <49.033199,-85.259697,-25.129101>, <0.466898,0.345426,-0.814056>
 <48.007000,-86.112999,-26.133400>, <0.507756,0.316183,-0.801381>
 <48.448101,-85.248001,-25.513300>, <0.509386,0.315297,-0.800696>
}
   smooth_triangle{ <48.448101,-85.248001,-25.513300>, <-0.509386,-0.315297,0.800696>
 <47.201599,-86.109497,-26.621599>, <-0.483870,-0.332588,0.809478>
 <48.007000,-86.112999,-26.133400>, <-0.507756,-0.316183,0.801381>
}
   smooth_triangle{ <48.448101,-85.248001,-25.513300>, <0.509386,0.315297,-0.800696>
 <48.007000,-86.112999,-26.133400>, <0.507756,0.316183,-0.801381>
 <47.201599,-86.109497,-26.621599>, <0.483870,0.332588,-0.809478>
}
   smooth_triangle{ <48.448101,-85.248001,-25.513300>, <-0.509386,-0.315297,0.800696>
 <47.664299,-85.244102,-25.990000>, <-0.484406,-0.332820,0.809062>
 <47.201599,-86.109497,-26.621599>, <-0.483870,-0.332588,0.809478>
}
   smooth_triangle{ <48.448101,-85.248001,-25.513300>, <0.509386,0.315297,-0.800696>
 <47.201599,-86.109497,-26.621599>, <0.483870,0.332588,-0.809478>
 <47.664299,-85.244102,-25.990000>, <0.484406,0.332820,-0.809062>
}
   smooth_triangle{ <47.664299,-85.244102,-25.990000>, <-0.484406,-0.332820,0.809062>
 <46.313702,-86.110703,-27.143400>, <-0.473582,-0.339760,0.812578>
 <47.201599,-86.109497,-26.621599>, <-0.483870,-0.332588,0.809478>
}
   smooth_triangle{ <47.664299,-85.244102,-25.990000>, <0.484406,0.332820,-0.809062>
 <47.201599,-86.109497,-26.621599>, <0.483870,0.332588,-0.809478>
 <46.313702,-86.110703,-27.143400>, <0.473582,0.339760,-0.812578>
}
   smooth_triangle{ <47.664299,-85.244102,-25.990000>, <-0.484406,-0.332820,0.809062>
 <46.799999,-85.245102,-26.498501>, <-0.473688,-0.339822,0.812490>
 <46.313702,-86.110703,-27.143400>, <-0.473582,-0.339760,0.812578>
}
   smooth_triangle{ <47.664299,-85.244102,-25.990000>, <0.484406,0.332820,-0.809062>
 <46.313702,-86.110703,-27.143400>, <0.473582,0.339760,-0.812578>
 <46.799999,-85.245102,-26.498501>, <0.473688,0.339822,-0.812490>
}
   smooth_triangle{ <46.799999,-85.245102,-26.498501>, <-0.473688,-0.339822,0.812490>
 <45.464401,-86.113899,-27.635900>, <-0.466344,-0.345282,0.814434>
 <46.313702,-86.110703,-27.143400>, <-0.473582,-0.339760,0.812578>
}
   smooth_triangle{ <46.799999,-85.245102,-26.498501>, <0.473688,0.339822,-0.812490>
 <46.313702,-86.110703,-27.143400>, <0.473582,0.339760,-0.812578>
 <45.464401,-86.113899,-27.635900>, <0.466344,0.345282,-0.814434>
}
   smooth_triangle{ <46.799999,-85.245102,-26.498501>, <-0.473688,-0.339822,0.812490>
 <45.972900,-85.248199,-26.978100>, <-0.466242,-0.344558,0.814800>
 <45.464401,-86.113899,-27.635900>, <-0.466344,-0.345282,0.814434>
}
   smooth_triangle{ <46.799999,-85.245102,-26.498501>, <0.473688,0.339822,-0.812490>
 <45.464401,-86.113899,-27.635900>, <0.466344,0.345282,-0.814434>
 <45.972900,-85.248199,-26.978100>, <0.466242,0.344558,-0.814800>
}
   smooth_triangle{ <45.972900,-85.248199,-26.978100>, <-0.466242,-0.344558,0.814800>
 <44.727901,-86.119102,-28.055500>, <-0.452462,-0.356581,0.817391>
 <45.464401,-86.113899,-27.635900>, <-0.466344,-0.345282,0.814434>
}
   smooth_triangle{ <45.972900,-85.248199,-26.978100>, <0.466242,0.344558,-0.814800>
 <45.464401,-86.113899,-27.635900>, <0.466344,0.345282,-0.814434>
 <44.727901,-86.119102,-28.055500>, <0.452462,0.356581,-0.817391>
}
   smooth_triangle{ <45.972900,-85.248199,-26.978100>, <-0.466242,-0.344558,0.814800>
 <45.255299,-85.253304,-27.386400>, <-0.452244,-0.352960,0.819081>
 <44.727901,-86.119102,-28.055500>, <-0.452462,-0.356581,0.817391>
}
   smooth_triangle{ <45.972900,-85.248199,-26.978100>, <0.466242,0.344558,-0.814800>
 <44.727901,-86.119102,-28.055500>, <0.452462,0.356581,-0.817391>
 <45.255299,-85.253304,-27.386400>, <0.452244,0.352960,-0.819081>
}
   smooth_triangle{ <45.255299,-85.253304,-27.386400>, <-0.452244,-0.352960,0.819081>
 <44.022800,-86.129097,-28.440500>, <-0.432193,-0.373624,0.820740>
 <44.727901,-86.119102,-28.055500>, <-0.452462,-0.356581,0.817391>
}
   smooth_triangle{ <45.255299,-85.253304,-27.386400>, <0.452244,0.352960,-0.819081>
 <44.727901,-86.119102,-28.055500>, <0.452462,0.356581,-0.817391>
 <44.022800,-86.129097,-28.440500>, <0.432193,0.373624,-0.820740>
}
   smooth_triangle{ <45.255299,-85.253304,-27.386400>, <-0.452244,-0.352960,0.819081>
 <44.568001,-85.263603,-27.760300>, <-0.432390,-0.363632,0.825112>
 <44.022800,-86.129097,-28.440500>, <-0.432193,-0.373624,0.820740>
}
   smooth_triangle{ <45.255299,-85.253304,-27.386400>, <0.452244,0.352960,-0.819081>
 <44.022800,-86.129097,-28.440500>, <0.432193,0.373624,-0.820740>
 <44.568001,-85.263603,-27.760300>, <0.432390,0.363632,-0.825112>
}
   smooth_triangle{ <44.568001,-85.263603,-27.760300>, <-0.432390,-0.363632,0.825112>
 <43.236698,-86.146004,-28.851400>, <-0.414568,-0.389635,0.822386>
 <44.022800,-86.129097,-28.440500>, <-0.432193,-0.373624,0.820740>
}
   smooth_triangle{ <44.568001,-85.263603,-27.760300>, <0.432390,0.363632,-0.825112>
 <44.022800,-86.129097,-28.440500>, <0.432193,0.373624,-0.820740>
 <43.236698,-86.146004,-28.851400>, <0.414568,0.389635,-0.822386>
}
   smooth_triangle{ <44.568001,-85.263603,-27.760300>, <-0.432390,-0.363632,0.825112>
 <43.801201,-85.280998,-28.158300>, <-0.415688,-0.371810,0.830037>
 <43.236698,-86.146004,-28.851400>, <-0.414568,-0.389635,0.822386>
}
   smooth_triangle{ <44.568001,-85.263603,-27.760300>, <0.432390,0.363632,-0.825112>
 <43.236698,-86.146004,-28.851400>, <0.414568,0.389635,-0.822386>
 <43.801201,-85.280998,-28.158300>, <0.415688,0.371810,-0.830037>
}
   smooth_triangle{ <43.801201,-85.280998,-28.158300>, <-0.415688,-0.371810,0.830037>
 <42.257301,-86.171700,-29.348499>, <-0.405523,-0.398632,0.822584>
 <43.236698,-86.146004,-28.851400>, <-0.414568,-0.389635,0.822386>
}
   smooth_triangle{ <43.801201,-85.280998,-28.158300>, <0.415688,0.371810,-0.830037>
 <43.236698,-86.146004,-28.851400>, <0.414568,0.389635,-0.822386>
 <42.257301,-86.171700,-29.348499>, <0.458013,0.357593,-0.813850>
}
   smooth_triangle{ <43.801201,-85.280998,-28.158300>, <-0.415688,-0.371810,0.830037>
 <42.845402,-85.307503,-28.638800>, <-0.410585,-0.365309,0.835445>
 <42.257301,-86.171700,-29.348499>, <-0.405523,-0.398632,0.822584>
}
   smooth_triangle{ <43.801201,-85.280998,-28.158300>, <0.415688,0.371810,-0.830037>
 <42.257301,-86.171700,-29.348499>, <0.458013,0.357593,-0.813850>
 <42.845402,-85.307503,-28.638800>, <0.460741,0.344854,-0.817798>
}
   smooth_triangle{ <42.845402,-85.307503,-28.638800>, <0.460741,0.344854,-0.817798>
 <43.099098,-86.181999,-28.817200>, <0.503922,0.320146,-0.802228>
 <42.257301,-86.171700,-29.348499>, <0.458013,0.357593,-0.813850>
}
   smooth_triangle{ <42.845402,-85.307503,-28.638800>, <0.460741,0.344854,-0.817798>
 <43.663898,-85.318298,-28.119301>, <0.503250,0.332331,-0.797682>
 <43.099098,-86.181999,-28.817200>, <0.503922,0.320146,-0.802228>
}
   smooth_triangle{ <43.663898,-85.318298,-28.119301>, <0.503250,0.332331,-0.797682>
 <43.865101,-86.187897,-28.344500>, <0.490198,0.333554,-0.805263>
 <43.099098,-86.181999,-28.817200>, <0.503922,0.320146,-0.802228>
}
   smooth_triangle{ <43.663898,-85.318298,-28.119301>, <0.503250,0.332331,-0.797682>
 <44.409100,-85.324699,-27.657499>, <0.490027,0.339135,-0.803032>
 <43.865101,-86.187897,-28.344500>, <0.490198,0.333554,-0.805263>
}
   smooth_triangle{ <44.409100,-85.324699,-27.657499>, <0.490027,0.339135,-0.803032>
 <44.604698,-86.188904,-27.903500>, <0.472508,0.348710,-0.809406>
 <43.865101,-86.187897,-28.344500>, <0.490198,0.333554,-0.805263>
}
   smooth_triangle{ <44.409100,-85.324699,-27.657499>, <0.490027,0.339135,-0.803032>
 <45.129101,-85.325897,-27.227301>, <0.472671,0.348218,-0.809522>
 <44.604698,-86.188904,-27.903500>, <0.472508,0.348710,-0.809406>
}
   smooth_triangle{ <45.129101,-85.325897,-27.227301>, <0.472671,0.348218,-0.809522>
 <45.366901,-86.184303,-27.466900>, <0.454750,0.362199,-0.813643>
 <44.604698,-86.188904,-27.903500>, <0.472508,0.348710,-0.809406>
}
   smooth_triangle{ <45.129101,-85.325897,-27.227301>, <0.472671,0.348218,-0.809522>
 <45.871399,-85.321297,-26.802401>, <0.454919,0.357537,-0.815608>
 <45.366901,-86.184303,-27.466900>, <0.454750,0.362199,-0.813643>
}
   smooth_triangle{ <45.871399,-85.321297,-26.802401>, <0.454919,0.357537,-0.815608>
 <46.223598,-86.173798,-26.993500>, <0.440798,0.371206,-0.817254>
 <45.366901,-86.184303,-27.466900>, <0.454750,0.362199,-0.813643>
}
   smooth_triangle{ <45.871399,-85.321297,-26.802401>, <0.454919,0.357537,-0.815608>
 <46.706402,-85.310600,-26.342501>, <0.440706,0.365084,-0.820056>
 <46.223598,-86.173798,-26.993500>, <0.440798,0.371206,-0.817254>
}
   smooth_triangle{ <46.706402,-85.310600,-26.342501>, <0.440706,0.365084,-0.820056>
 <47.122799,-86.158897,-26.509001>, <0.429736,0.376969,-0.820501>
 <46.223598,-86.173798,-26.993500>, <0.440798,0.371206,-0.817254>
}
   smooth_triangle{ <46.706402,-85.310600,-26.342501>, <0.440706,0.365084,-0.820056>
 <47.583199,-85.295502,-25.872400>, <0.429012,0.371704,-0.823277>
 <47.122799,-86.158897,-26.509001>, <0.429736,0.376969,-0.820501>
}
   smooth_triangle{ <47.583199,-85.295502,-25.872400>, <0.429012,0.371704,-0.823277>
 <47.954700,-86.141701,-26.072001>, <0.416132,0.383615,-0.824423>
 <47.122799,-86.158897,-26.509001>, <0.429736,0.376969,-0.820501>
}
   smooth_triangle{ <47.583199,-85.295502,-25.872400>, <0.429012,0.371704,-0.823277>
 <48.394501,-85.277802,-25.448900>, <0.414223,0.380608,-0.826775>
 <47.954700,-86.141701,-26.072001>, <0.416132,0.383615,-0.824423>
}
   smooth_triangle{ <48.394501,-85.277802,-25.448900>, <0.414223,0.380608,-0.826775>
 <48.609100,-86.124100,-25.741100>, <0.465541,0.348330,-0.813596>
 <47.954700,-86.141701,-26.072001>, <0.416132,0.383615,-0.824423>
}
   smooth_triangle{ <48.394501,-85.277802,-25.448900>, <0.414223,0.380608,-0.826775>
 <49.033199,-85.259697,-25.129101>, <0.466898,0.345426,-0.814056>
 <48.609100,-86.124100,-25.741100>, <0.465541,0.348330,-0.813596>
}
   smooth_triangle{ <48.609100,-86.124100,-25.741100>, <-0.522312,-0.306822,0.795645>
 <47.566299,-86.977898,-26.754101>, <-0.504796,-0.318992,0.802138>
 <48.185600,-86.988098,-26.354200>, <-0.517879,-0.310948,0.796939>
}
   smooth_triangle{ <48.609100,-86.124100,-25.741100>, <0.465541,0.348330,-0.813596>
 <48.185600,-86.988098,-26.354200>, <0.465283,0.349464,-0.813257>
 <47.566299,-86.977898,-26.754101>, <0.504796,0.318992,-0.802138>
}
   smooth_triangle{ <48.609100,-86.124100,-25.741100>, <-0.522312,-0.306822,0.795645>
 <48.007000,-86.112999,-26.133400>, <-0.507756,-0.316183,0.801381>
 <47.566299,-86.977898,-26.754101>, <-0.504796,-0.318992,0.802138>
}
   smooth_triangle{ <48.609100,-86.124100,-25.741100>, <0.465541,0.348330,-0.813596>
 <47.566299,-86.977898,-26.754101>, <0.504796,0.318992,-0.802138>
 <48.007000,-86.112999,-26.133400>, <0.507756,0.316183,-0.801381>
}
   smooth_triangle{ <48.007000,-86.112999,-26.133400>, <-0.507756,-0.316183,0.801381>
 <46.738998,-86.974800,-27.253799>, <-0.482708,-0.333806,0.809671>
 <47.566299,-86.977898,-26.754101>, <-0.504796,-0.318992,0.802138>
}
   smooth_triangle{ <48.007000,-86.112999,-26.133400>, <0.507756,0.316183,-0.801381>
 <47.566299,-86.977898,-26.754101>, <0.504796,0.318992,-0.802138>
 <46.738998,-86.974800,-27.253799>, <0.482708,0.333806,-0.809671>
}
   smooth_triangle{ <48.007000,-86.112999,-26.133400>, <-0.507756,-0.316183,0.801381>
 <47.201599,-86.109497,-26.621599>, <-0.483870,-0.332588,0.809478>
 <46.738998,-86.974800,-27.253799>, <-0.482708,-0.333806,0.809671>
}
   smooth_triangle{ <48.007000,-86.112999,-26.133400>, <0.507756,0.316183,-0.801381>
 <46.738998,-86.974800,-27.253799>, <0.482708,0.333806,-0.809671>
 <47.201599,-86.109497,-26.621599>, <0.483870,0.332588,-0.809478>
}
   smooth_triangle{ <47.201599,-86.109497,-26.621599>, <-0.483870,-0.332588,0.809478>
 <45.827702,-86.976196,-27.788799>, <-0.473257,-0.340249,0.812563>
 <46.738998,-86.974800,-27.253799>, <-0.482708,-0.333806,0.809671>
}
   smooth_triangle{ <47.201599,-86.109497,-26.621599>, <0.483870,0.332588,-0.809478>
 <46.738998,-86.974800,-27.253799>, <0.482708,0.333806,-0.809671>
 <45.827702,-86.976196,-27.788799>, <0.473257,0.340249,-0.812563>
}
   smooth_triangle{ <47.201599,-86.109497,-26.621599>, <-0.483870,-0.332588,0.809478>
 <46.313702,-86.110703,-27.143400>, <-0.473582,-0.339760,0.812578>
 <45.827702,-86.976196,-27.788799>, <-0.473257,-0.340249,0.812563>
}
   smooth_triangle{ <47.201599,-86.109497,-26.621599>, <0.483870,0.332588,-0.809478>
 <45.827702,-86.976196,-27.788799>, <0.473257,0.340249,-0.812563>
 <46.313702,-86.110703,-27.143400>, <0.473582,0.339760,-0.812578>
}
   smooth_triangle{ <46.313702,-86.110703,-27.143400>, <-0.473582,-0.339760,0.812578>
 <44.956200,-86.979500,-28.294100>, <-0.466523,-0.345397,0.814283>
 <45.827702,-86.976196,-27.788799>, <-0.473257,-0.340249,0.812563>
}
   smooth_triangle{ <46.313702,-86.110703,-27.143400>, <0.473582,0.339760,-0.812578>
 <45.827702,-86.976196,-27.788799>, <0.473257,0.340249,-0.812563>
 <44.956200,-86.979500,-28.294100>, <0.466523,0.345397,-0.814283>
}
   smooth_triangle{ <46.313702,-86.110703,-27.143400>, <-0.473582,-0.339760,0.812578>
 <45.464401,-86.113899,-27.635900>, <-0.466344,-0.345282,0.814434>
 <44.956200,-86.979500,-28.294100>, <-0.466523,-0.345397,0.814283>
}
   smooth_triangle{ <46.313702,-86.110703,-27.143400>, <0.473582,0.339760,-0.812578>
 <44.956200,-86.979500,-28.294100>, <0.466523,0.345397,-0.814283>
 <45.464401,-86.113899,-27.635900>, <0.466344,0.345282,-0.814434>
}
   smooth_triangle{ <45.464401,-86.113899,-27.635900>, <-0.466344,-0.345282,0.814434>
 <44.200600,-86.984703,-28.725000>, <-0.453749,-0.355870,0.816987>
 <44.956200,-86.979500,-28.294100>, <-0.466523,-0.345397,0.814283>
}
   smooth_triangle{ <45.464401,-86.113899,-27.635900>, <0.466344,0.345282,-0.814434>
 <44.956200,-86.979500,-28.294100>, <0.466523,0.345397,-0.814283>
 <44.200600,-86.984703,-28.725000>, <0.453749,0.355870,-0.816987>
}
   smooth_triangle{ <45.464401,-86.113899,-27.635900>, <-0.466344,-0.345282,0.814434>
 <44.727901,-86.119102,-28.055500>, <-0.452462,-0.356581,0.817391>
 <44.200600,-86.984703,-28.725000>, <-0.453749,-0.355870,0.816987>
}
   smooth_triangle{ <45.464401,-86.113899,-27.635900>, <0.466344,0.345282,-0.814434>
 <44.200600,-86.984703,-28.725000>, <0.453749,0.355870,-0.816987>
 <44.727901,-86.119102,-28.055500>, <0.452462,0.356581,-0.817391>
}
   smooth_triangle{ <44.727901,-86.119102,-28.055500>, <-0.452462,-0.356581,0.817391>
 <43.477901,-86.994400,-29.121500>, <-0.435002,-0.371981,0.820002>
 <44.200600,-86.984703,-28.725000>, <-0.453749,-0.355870,0.816987>
}
   smooth_triangle{ <44.727901,-86.119102,-28.055500>, <0.452462,0.356581,-0.817391>
 <44.200600,-86.984703,-28.725000>, <0.453749,0.355870,-0.816987>
 <43.477901,-86.994400,-29.121500>, <0.435002,0.371981,-0.820002>
}
   smooth_triangle{ <44.727901,-86.119102,-28.055500>, <-0.452462,-0.356581,0.817391>
 <44.022800,-86.129097,-28.440500>, <-0.432193,-0.373624,0.820740>
 <43.477901,-86.994400,-29.121500>, <-0.435002,-0.371981,0.820002>
}
   smooth_triangle{ <44.727901,-86.119102,-28.055500>, <0.452462,0.356581,-0.817391>
 <43.477901,-86.994400,-29.121500>, <0.435002,0.371981,-0.820002>
 <44.022800,-86.129097,-28.440500>, <0.432193,0.373624,-0.820740>
}
   smooth_triangle{ <44.022800,-86.129097,-28.440500>, <-0.432193,-0.373624,0.820740>
 <42.672798,-87.010696,-29.545700>, <-0.418538,-0.387569,0.821350>
 <43.477901,-86.994400,-29.121500>, <-0.435002,-0.371981,0.820002>
}
   smooth_triangle{ <44.022800,-86.129097,-28.440500>, <0.432193,0.373624,-0.820740>
 <43.477901,-86.994400,-29.121500>, <0.435002,0.371981,-0.820002>
 <42.672798,-87.010696,-29.545700>, <0.418538,0.387569,-0.821350>
}
   smooth_triangle{ <44.022800,-86.129097,-28.440500>, <-0.432193,-0.373624,0.820740>
 <43.236698,-86.146004,-28.851400>, <-0.414568,-0.389635,0.822386>
 <42.672798,-87.010696,-29.545700>, <-0.418538,-0.387569,0.821350>
}
   smooth_triangle{ <44.022800,-86.129097,-28.440500>, <0.432193,0.373624,-0.820740>
 <42.672798,-87.010696,-29.545700>, <0.418538,0.387569,-0.821350>
 <43.236698,-86.146004,-28.851400>, <0.414568,0.389635,-0.822386>
}
   smooth_triangle{ <43.236698,-86.146004,-28.851400>, <-0.414568,-0.389635,0.822386>
 <41.670101,-87.035400,-30.059900>, <-0.409792,-0.396733,0.821385>
 <42.672798,-87.010696,-29.545700>, <-0.418538,-0.387569,0.821350>
}
   smooth_triangle{ <43.236698,-86.146004,-28.851400>, <0.414568,0.389635,-0.822386>
 <42.672798,-87.010696,-29.545700>, <0.418538,0.387569,-0.821350>
 <41.670101,-87.035400,-30.059900>, <0.458181,0.359015,-0.813129>
}
   smooth_triangle{ <43.236698,-86.146004,-28.851400>, <-0.414568,-0.389635,0.822386>
 <42.257301,-86.171700,-29.348499>, <-0.405523,-0.398632,0.822584>
 <41.670101,-87.035400,-30.059900>, <-0.409792,-0.396733,0.821385>
}
   smooth_triangle{ <43.236698,-86.146004,-28.851400>, <0.414568,0.389635,-0.822386>
 <41.670101,-87.035400,-30.059900>, <0.458181,0.359015,-0.813129>
 <42.257301,-86.171700,-29.348499>, <0.458013,0.357593,-0.813850>
}
   smooth_triangle{ <42.257301,-86.171700,-29.348499>, <0.458013,0.357593,-0.813850>
 <42.535400,-87.044701,-29.517300>, <0.500780,0.324995,-0.802245>
 <41.670101,-87.035400,-30.059900>, <0.458181,0.359015,-0.813129>
}
   smooth_triangle{ <42.257301,-86.171700,-29.348499>, <0.458013,0.357593,-0.813850>
 <43.099098,-86.181999,-28.817200>, <0.503922,0.320146,-0.802228>
 <42.535400,-87.044701,-29.517300>, <0.500780,0.324995,-0.802245>
}
   smooth_triangle{ <43.099098,-86.181999,-28.817200>, <0.503922,0.320146,-0.802228>
 <43.322498,-87.050102,-29.034000>, <0.488031,0.337780,-0.804817>
 <42.535400,-87.044701,-29.517300>, <0.500780,0.324995,-0.802245>
}
   smooth_triangle{ <43.099098,-86.181999,-28.817200>, <0.503922,0.320146,-0.802228>
 <43.865101,-86.187897,-28.344500>, <0.490198,0.333554,-0.805263>
 <43.322498,-87.050102,-29.034000>, <0.488031,0.337780,-0.804817>
}
   smooth_triangle{ <43.865101,-86.187897,-28.344500>, <0.490198,0.333554,-0.805263>
 <44.081902,-87.050797,-28.582199>, <0.471604,0.351929,-0.808539>
 <43.322498,-87.050102,-29.034000>, <0.488031,0.337780,-0.804817>
}
   smooth_triangle{ <43.865101,-86.187897,-28.344500>, <0.490198,0.333554,-0.805263>
 <44.604698,-86.188904,-27.903500>, <0.472508,0.348710,-0.809406>
 <44.081902,-87.050797,-28.582199>, <0.471604,0.351929,-0.808539>
}
   smooth_triangle{ <44.604698,-86.188904,-27.903500>, <0.472508,0.348710,-0.809406>
 <44.863800,-87.046204,-28.134001>, <0.455226,0.364325,-0.812426>
 <44.081902,-87.050797,-28.582199>, <0.471604,0.351929,-0.808539>
}
   smooth_triangle{ <44.604698,-86.188904,-27.903500>, <0.472508,0.348710,-0.809406>
 <45.366901,-86.184303,-27.466900>, <0.454750,0.362199,-0.813643>
 <44.863800,-87.046204,-28.134001>, <0.455226,0.364325,-0.812426>
}
   smooth_triangle{ <45.366901,-86.184303,-27.466900>, <0.454750,0.362199,-0.813643>
 <45.742100,-87.036003,-27.646799>, <0.442426,0.372331,-0.815861>
 <44.863800,-87.046204,-28.134001>, <0.455226,0.364325,-0.812426>
}
   smooth_triangle{ <45.366901,-86.184303,-27.466900>, <0.454750,0.362199,-0.813643>
 <46.223598,-86.173798,-26.993500>, <0.440798,0.371206,-0.817254>
 <45.742100,-87.036003,-27.646799>, <0.442426,0.372331,-0.815861>
}
   smooth_triangle{ <46.223598,-86.173798,-26.993500>, <0.440798,0.371206,-0.817254>
 <46.663601,-87.021599,-27.147499>, <0.432275,0.377120,-0.819096>
 <45.742100,-87.036003,-27.646799>, <0.442426,0.372331,-0.815861>
}
   smooth_triangle{ <46.223598,-86.173798,-26.993500>, <0.440798,0.371206,-0.817254>
 <47.122799,-86.158897,-26.509001>, <0.429736,0.376969,-0.820501>
 <46.663601,-87.021599,-27.147499>, <0.432275,0.377120,-0.819096>
}
   smooth_triangle{ <47.122799,-86.158897,-26.509001>, <0.429736,0.376969,-0.820501>
 <47.515701,-87.004997,-26.696501>, <0.419840,0.382564,-0.823031>
 <46.663601,-87.021599,-27.147499>, <0.432275,0.377120,-0.819096>
}
   smooth_triangle{ <47.122799,-86.158897,-26.509001>, <0.429736,0.376969,-0.820501>
 <47.954700,-86.141701,-26.072001>, <0.416132,0.383615,-0.824423>
 <47.515701,-87.004997,-26.696501>, <0.419840,0.382564,-0.823031>
}
   smooth_triangle{ <47.954700,-86.141701,-26.072001>, <0.416132,0.383615,-0.824423>
 <48.185600,-86.988098,-26.354200>, <0.465283,0.349464,-0.813257>
 <47.515701,-87.004997,-26.696501>, <0.419840,0.382564,-0.823031>
}
   smooth_triangle{ <47.954700,-86.141701,-26.072001>, <0.416132,0.383615,-0.824423>
 <48.609100,-86.124100,-25.741100>, <0.465541,0.348330,-0.813596>
 <48.185600,-86.988098,-26.354200>, <0.465283,0.349464,-0.813257>
}
   smooth_triangle{ <48.185600,-86.988098,-26.354200>, <-0.517879,-0.310948,0.796939>
 <47.125702,-87.842499,-27.375200>, <-0.501637,-0.321527,0.803107>
 <47.762501,-87.851898,-26.968000>, <-0.513114,-0.314945,0.798450>
}
   smooth_triangle{ <48.185600,-86.988098,-26.354200>, <0.465283,0.349464,-0.813257>
 <47.762501,-87.851898,-26.968000>, <0.465155,0.350198,-0.813014>
 <47.125702,-87.842499,-27.375200>, <0.501637,0.321527,-0.803107>
}
   smooth_triangle{ <48.185600,-86.988098,-26.354200>, <-0.517879,-0.310948,0.796939>
 <47.566299,-86.977898,-26.754101>, <-0.504796,-0.318992,0.802138>
 <47.125702,-87.842499,-27.375200>, <-0.501637,-0.321527,0.803107>
}
   smooth_triangle{ <48.185600,-86.988098,-26.354200>, <0.465283,0.349464,-0.813257>
 <47.125702,-87.842499,-27.375200>, <0.501637,0.321527,-0.803107>
 <47.566299,-86.977898,-26.754101>, <0.504796,0.318992,-0.802138>
}
   smooth_triangle{ <47.566299,-86.977898,-26.754101>, <-0.504796,-0.318992,0.802138>
 <46.276600,-87.839996,-27.886200>, <-0.481511,-0.334666,0.810028>
 <47.125702,-87.842499,-27.375200>, <-0.501637,-0.321527,0.803107>
}
   smooth_triangle{ <47.566299,-86.977898,-26.754101>, <0.504796,0.318992,-0.802138>
 <47.125702,-87.842499,-27.375200>, <0.501637,0.321527,-0.803107>
 <46.276600,-87.839996,-27.886200>, <0.481511,0.334666,-0.810028>
}
   smooth_triangle{ <47.566299,-86.977898,-26.754101>, <-0.504796,-0.318992,0.802138>
 <46.738998,-86.974800,-27.253799>, <-0.482708,-0.333806,0.809671>
 <46.276600,-87.839996,-27.886200>, <-0.481511,-0.334666,0.810028>
}
   smooth_triangle{ <47.566299,-86.977898,-26.754101>, <0.504796,0.318992,-0.802138>
 <46.276600,-87.839996,-27.886200>, <0.481511,0.334666,-0.810028>
 <46.738998,-86.974800,-27.253799>, <0.482708,0.333806,-0.809671>
}
   smooth_triangle{ <46.738998,-86.974800,-27.253799>, <-0.482708,-0.333806,0.809671>
 <45.341801,-87.841698,-28.434099>, <-0.472917,-0.340366,0.812712>
 <46.276600,-87.839996,-27.886200>, <-0.481511,-0.334666,0.810028>
}
   smooth_triangle{ <46.738998,-86.974800,-27.253799>, <0.482708,0.333806,-0.809671>
 <46.276600,-87.839996,-27.886200>, <0.481511,0.334666,-0.810028>
 <45.341801,-87.841698,-28.434099>, <0.472917,0.340366,-0.812712>
}
   smooth_triangle{ <46.738998,-86.974800,-27.253799>, <-0.482708,-0.333806,0.809671>
 <45.827702,-86.976196,-27.788799>, <-0.473257,-0.340249,0.812563>
 <45.341801,-87.841698,-28.434099>, <-0.472917,-0.340366,0.812712>
}
   smooth_triangle{ <46.738998,-86.974800,-27.253799>, <0.482708,0.333806,-0.809671>
 <45.341801,-87.841698,-28.434099>, <0.472917,0.340366,-0.812712>
 <45.827702,-86.976196,-27.788799>, <0.473257,0.340249,-0.812563>
}
   smooth_triangle{ <45.827702,-86.976196,-27.788799>, <-0.473257,-0.340249,0.812563>
 <44.448002,-87.845100,-28.952299>, <-0.466891,-0.344927,0.814272>
 <45.341801,-87.841698,-28.434099>, <-0.472917,-0.340366,0.812712>
}
   smooth_triangle{ <45.827702,-86.976196,-27.788799>, <0.473257,0.340249,-0.812563>
 <45.341801,-87.841698,-28.434099>, <0.472917,0.340366,-0.812712>
 <44.448002,-87.845100,-28.952299>, <0.466891,0.344927,-0.814272>
}
   smooth_triangle{ <45.827702,-86.976196,-27.788799>, <-0.473257,-0.340249,0.812563>
 <44.956200,-86.979500,-28.294100>, <-0.466523,-0.345397,0.814283>
 <44.448002,-87.845100,-28.952299>, <-0.466891,-0.344927,0.814272>
}
   smooth_triangle{ <45.827702,-86.976196,-27.788799>, <0.473257,0.340249,-0.812563>
 <44.448002,-87.845100,-28.952299>, <0.466891,0.344927,-0.814272>
 <44.956200,-86.979500,-28.294100>, <0.466523,0.345397,-0.814283>
}
   smooth_triangle{ <44.956200,-86.979500,-28.294100>, <-0.466523,-0.345397,0.814283>
 <43.673401,-87.850197,-29.394600>, <-0.455200,-0.354708,0.816686>
 <44.448002,-87.845100,-28.952299>, <-0.466891,-0.344927,0.814272>
}
   smooth_triangle{ <44.956200,-86.979500,-28.294100>, <0.466523,0.345397,-0.814283>
 <44.448002,-87.845100,-28.952299>, <0.466891,0.344927,-0.814272>
 <43.673401,-87.850197,-29.394600>, <0.455200,0.354708,-0.816686>
}
   smooth_triangle{ <44.956200,-86.979500,-28.294100>, <-0.466523,-0.345397,0.814283>
 <44.200600,-86.984703,-28.725000>, <-0.453749,-0.355870,0.816987>
 <43.673401,-87.850197,-29.394600>, <-0.455200,-0.354708,0.816686>
}
   smooth_triangle{ <44.956200,-86.979500,-28.294100>, <0.466523,0.345397,-0.814283>
 <43.673401,-87.850197,-29.394600>, <0.455200,0.354708,-0.816686>
 <44.200600,-86.984703,-28.725000>, <0.453749,0.355870,-0.816987>
}
   smooth_triangle{ <44.200600,-86.984703,-28.725000>, <-0.453749,-0.355870,0.816987>
 <42.933201,-87.859497,-29.802700>, <-0.438210,-0.369669,0.819339>
 <43.673401,-87.850197,-29.394600>, <-0.455200,-0.354708,0.816686>
}
   smooth_triangle{ <44.200600,-86.984703,-28.725000>, <0.453749,0.355870,-0.816987>
 <43.673401,-87.850197,-29.394600>, <0.455200,0.354708,-0.816686>
 <42.933201,-87.859497,-29.802700>, <0.438210,0.369669,-0.819339>
}
   smooth_triangle{ <44.200600,-86.984703,-28.725000>, <-0.453749,-0.355870,0.816987>
 <43.477901,-86.994400,-29.121500>, <-0.435002,-0.371981,0.820002>
 <42.933201,-87.859497,-29.802700>, <-0.438210,-0.369669,0.819339>
}
   smooth_triangle{ <44.200600,-86.984703,-28.725000>, <0.453749,0.355870,-0.816987>
 <42.933201,-87.859497,-29.802700>, <0.438210,0.369669,-0.819339>
 <43.477901,-86.994400,-29.121500>, <0.435002,0.371981,-0.820002>
}
   smooth_triangle{ <43.477901,-86.994400,-29.121500>, <-0.435002,-0.371981,0.820002>
 <42.109299,-87.875000,-30.240700>, <-0.423102,-0.384691,0.820365>
 <42.933201,-87.859497,-29.802700>, <-0.438210,-0.369669,0.819339>
}
   smooth_triangle{ <43.477901,-86.994400,-29.121500>, <0.435002,0.371981,-0.820002>
 <42.933201,-87.859497,-29.802700>, <0.438210,0.369669,-0.819339>
 <42.109299,-87.875000,-30.240700>, <0.423102,0.384691,-0.820365>
}
   smooth_triangle{ <43.477901,-86.994400,-29.121500>, <-0.435002,-0.371981,0.820002>
 <42.672798,-87.010696,-29.545700>, <-0.418538,-0.387569,0.821350>
 <42.109299,-87.875000,-30.240700>, <-0.423102,-0.384691,0.820365>
}
   smooth_triangle{ <43.477901,-86.994400,-29.121500>, <0.435002,0.371981,-0.820002>
 <42.109299,-87.875000,-30.240700>, <0.423102,0.384691,-0.820365>
 <42.672798,-87.010696,-29.545700>, <0.418538,0.387569,-0.821350>
}
   smooth_triangle{ <42.672798,-87.010696,-29.545700>, <-0.418538,-0.387569,0.821350>
 <41.083801,-87.898399,-30.772600>, <-0.414587,-0.394167,0.820213>
 <42.109299,-87.875000,-30.240700>, <-0.423102,-0.384691,0.820365>
}
   smooth_triangle{ <42.672798,-87.010696,-29.545700>, <0.418538,0.387569,-0.821350>
 <42.109299,-87.875000,-30.240700>, <0.423102,0.384691,-0.820365>
 <41.083801,-87.898399,-30.772600>, <0.458476,0.360102,-0.812481>
}
   smooth_triangle{ <42.672798,-87.010696,-29.545700>, <-0.418538,-0.387569,0.821350>
 <41.670101,-87.035400,-30.059900>, <-0.409792,-0.396733,0.821385>
 <41.083801,-87.898399,-30.772600>, <-0.414587,-0.394167,0.820213>
}
   smooth_triangle{ <42.672798,-87.010696,-29.545700>, <0.418538,0.387569,-0.821350>
 <41.083801,-87.898399,-30.772600>, <0.458476,0.360102,-0.812481>
 <41.670101,-87.035400,-30.059900>, <0.458181,0.359015,-0.813129>
}
   smooth_triangle{ <41.670101,-87.035400,-30.059900>, <0.458181,0.359015,-0.813129>
 <41.972900,-87.906799,-30.219200>, <0.497351,0.329774,-0.802428>
 <41.083801,-87.898399,-30.772600>, <0.458476,0.360102,-0.812481>
}
   smooth_triangle{ <41.670101,-87.035400,-30.059900>, <0.458181,0.359015,-0.813129>
 <42.535400,-87.044701,-29.517300>, <0.500780,0.324995,-0.802245>
 <41.972900,-87.906799,-30.219200>, <0.497351,0.329774,-0.802428>
}
   smooth_triangle{ <42.535400,-87.044701,-29.517300>, <0.500780,0.324995,-0.802245>
 <42.781200,-87.911400,-29.725599>, <0.485703,0.341842,-0.804510>
 <41.972900,-87.906799,-30.219200>, <0.497351,0.329774,-0.802428>
}
   smooth_triangle{ <42.535400,-87.044701,-29.517300>, <0.500780,0.324995,-0.802245>
 <43.322498,-87.050102,-29.034000>, <0.488031,0.337780,-0.804817>
 <42.781200,-87.911400,-29.725599>, <0.485703,0.341842,-0.804510>
}
   smooth_triangle{ <43.322498,-87.050102,-29.034000>, <0.488031,0.337780,-0.804817>
 <43.560299,-87.911797,-29.263100>, <0.470749,0.354892,-0.807742>
 <42.781200,-87.911400,-29.725599>, <0.485703,0.341842,-0.804510>
}
   smooth_triangle{ <43.322498,-87.050102,-29.034000>, <0.488031,0.337780,-0.804817>
 <44.081902,-87.050797,-28.582199>, <0.471604,0.351929,-0.808539>
 <43.560299,-87.911797,-29.263100>, <0.470749,0.354892,-0.807742>
}
   smooth_triangle{ <44.081902,-87.050797,-28.582199>, <0.471604,0.351929,-0.808539>
 <44.362000,-87.907204,-28.803200>, <0.455823,0.366067,-0.811308>
 <43.560299,-87.911797,-29.263100>, <0.470749,0.354892,-0.807742>
}
   smooth_triangle{ <44.081902,-87.050797,-28.582199>, <0.471604,0.351929,-0.808539>
 <44.863800,-87.046204,-28.134001>, <0.455226,0.364325,-0.812426>
 <44.362000,-87.907204,-28.803200>, <0.455823,0.366067,-0.811308>
}
   smooth_triangle{ <44.863800,-87.046204,-28.134001>, <0.455226,0.364325,-0.812426>
 <45.261700,-87.897301,-28.302200>, <0.444302,0.372973,-0.814547>
 <44.362000,-87.907204,-28.803200>, <0.455823,0.366067,-0.811308>
}
   smooth_triangle{ <44.863800,-87.046204,-28.134001>, <0.455226,0.364325,-0.812426>
 <45.742100,-87.036003,-27.646799>, <0.442426,0.372331,-0.815861>
 <45.261700,-87.897301,-28.302200>, <0.444302,0.372973,-0.814547>
}
   smooth_triangle{ <45.742100,-87.036003,-27.646799>, <0.442426,0.372331,-0.815861>
 <46.205399,-87.883598,-27.787701>, <0.435237,0.376756,-0.817694>
 <45.261700,-87.897301,-28.302200>, <0.444302,0.372973,-0.814547>
}
   smooth_triangle{ <45.742100,-87.036003,-27.646799>, <0.442426,0.372331,-0.815861>
 <46.663601,-87.021599,-27.147499>, <0.432275,0.377120,-0.819096>
 <46.205399,-87.883598,-27.787701>, <0.435237,0.376756,-0.817694>
}
   smooth_triangle{ <46.663601,-87.021599,-27.147499>, <0.432275,0.377120,-0.819096>
 <47.077400,-87.867798,-27.322201>, <0.424143,0.380931,-0.821581>
 <46.205399,-87.883598,-27.787701>, <0.435237,0.376756,-0.817694>
}
   smooth_triangle{ <46.663601,-87.021599,-27.147499>, <0.432275,0.377120,-0.819096>
 <47.515701,-87.004997,-26.696501>, <0.419840,0.382564,-0.823031>
 <47.077400,-87.867798,-27.322201>, <0.424143,0.380931,-0.821581>
}
   smooth_triangle{ <47.515701,-87.004997,-26.696501>, <0.419840,0.382564,-0.823031>
 <47.762501,-87.851898,-26.968000>, <0.465155,0.350198,-0.813014>
 <47.077400,-87.867798,-27.322201>, <0.424143,0.380931,-0.821581>
}
   smooth_triangle{ <47.515701,-87.004997,-26.696501>, <0.419840,0.382564,-0.823031>
 <48.185600,-86.988098,-26.354200>, <0.465283,0.349464,-0.813257>
 <47.762501,-87.851898,-26.968000>, <0.465155,0.350198,-0.813014>
}
   smooth_triangle{ <47.762501,-87.851898,-26.968000>, <-0.513114,-0.314945,0.798450>
 <46.685101,-88.707199,-27.996300>, <-0.498338,-0.326578,0.803123>
 <47.339699,-88.715401,-27.582300>, <-0.511169,-0.318963,0.798103>
}
   smooth_triangle{ <47.762501,-87.851898,-26.968000>, <0.465155,0.350198,-0.813014>
 <47.339699,-88.715401,-27.582300>, <0.466803,0.350665,-0.811868>
 <46.685101,-88.707199,-27.996300>, <0.498338,0.326578,-0.803123>
}
   smooth_triangle{ <47.762501,-87.851898,-26.968000>, <-0.513114,-0.314945,0.798450>
 <47.125702,-87.842499,-27.375200>, <-0.501637,-0.321527,0.803107>
 <46.685101,-88.707199,-27.996300>, <-0.498338,-0.326578,0.803123>
}
   smooth_triangle{ <47.762501,-87.851898,-26.968000>, <0.465155,0.350198,-0.813014>
 <46.685101,-88.707199,-27.996300>, <0.498338,0.326578,-0.803123>
 <47.125702,-87.842499,-27.375200>, <0.501637,0.321527,-0.803107>
}
   smooth_triangle{ <47.125702,-87.842499,-27.375200>, <-0.501637,-0.321527,0.803107>
 <45.813999,-88.705299,-28.518200>, <-0.480149,-0.337189,0.809790>
 <46.685101,-88.707199,-27.996300>, <-0.498338,-0.326578,0.803123>
}
   smooth_triangle{ <47.125702,-87.842499,-27.375200>, <0.501637,0.321527,-0.803107>
 <46.685101,-88.707199,-27.996300>, <0.498338,0.326578,-0.803123>
 <45.813999,-88.705299,-28.518200>, <0.480149,0.337189,-0.809790>
}
   smooth_triangle{ <47.125702,-87.842499,-27.375200>, <-0.501637,-0.321527,0.803107>
 <46.276600,-87.839996,-27.886200>, <-0.481511,-0.334666,0.810028>
 <45.813999,-88.705299,-28.518200>, <-0.480149,-0.337189,0.809790>
}
   smooth_triangle{ <47.125702,-87.842499,-27.375200>, <0.501637,0.321527,-0.803107>
 <45.813999,-88.705299,-28.518200>, <0.480149,0.337189,-0.809790>
 <46.276600,-87.839996,-27.886200>, <0.481511,0.334666,-0.810028>
}
   smooth_triangle{ <46.276600,-87.839996,-27.886200>, <-0.481511,-0.334666,0.810028>
 <44.855598,-88.707298,-29.079201>, <-0.472489,-0.340896,0.812739>
 <45.813999,-88.705299,-28.518200>, <-0.480149,-0.337189,0.809790>
}
   smooth_triangle{ <46.276600,-87.839996,-27.886200>, <0.481511,0.334666,-0.810028>
 <45.813999,-88.705299,-28.518200>, <0.480149,0.337189,-0.809790>
 <44.855598,-88.707298,-29.079201>, <0.472489,0.340896,-0.812739>
}
   smooth_triangle{ <46.276600,-87.839996,-27.886200>, <-0.481511,-0.334666,0.810028>
 <45.341801,-87.841698,-28.434099>, <-0.472917,-0.340366,0.812712>
 <44.855598,-88.707298,-29.079201>, <-0.472489,-0.340896,0.812739>
}
   smooth_triangle{ <46.276600,-87.839996,-27.886200>, <0.481511,0.334666,-0.810028>
 <44.855598,-88.707298,-29.079201>, <0.472489,0.340896,-0.812739>
 <45.341801,-87.841698,-28.434099>, <0.472917,0.340366,-0.812712>
}
   smooth_triangle{ <45.341801,-87.841698,-28.434099>, <-0.472917,-0.340366,0.812712>
 <43.939602,-88.710899,-29.610100>, <-0.467462,-0.342312,0.815047>
 <44.855598,-88.707298,-29.079201>, <-0.472489,-0.340896,0.812739>
}
   smooth_triangle{ <45.341801,-87.841698,-28.434099>, <0.472917,0.340366,-0.812712>
 <44.855598,-88.707298,-29.079201>, <0.472489,0.340896,-0.812739>
 <43.939602,-88.710899,-29.610100>, <0.467462,0.342312,-0.815047>
}
   smooth_triangle{ <45.341801,-87.841698,-28.434099>, <-0.472917,-0.340366,0.812712>
 <44.448002,-87.845100,-28.952299>, <-0.466891,-0.344927,0.814272>
 <43.939602,-88.710899,-29.610100>, <-0.467462,-0.342312,0.815047>
}
   smooth_triangle{ <45.341801,-87.841698,-28.434099>, <0.472917,0.340366,-0.812712>
 <43.939602,-88.710899,-29.610100>, <0.467462,0.342312,-0.815047>
 <44.448002,-87.845100,-28.952299>, <0.466891,0.344927,-0.814272>
}
   smooth_triangle{ <44.448002,-87.845100,-28.952299>, <-0.466891,-0.344927,0.814272>
 <43.146099,-88.715797,-30.063999>, <-0.457927,-0.343564,0.819919>
 <43.939602,-88.710899,-29.610100>, <-0.467462,-0.342312,0.815047>
}
   smooth_triangle{ <44.448002,-87.845100,-28.952299>, <0.466891,0.344927,-0.814272>
 <43.939602,-88.710899,-29.610100>, <0.467462,0.342312,-0.815047>
 <43.146099,-88.715797,-30.063999>, <0.457927,0.343564,-0.819919>
}
   smooth_triangle{ <44.448002,-87.845100,-28.952299>, <-0.466891,-0.344927,0.814272>
 <43.673401,-87.850197,-29.394600>, <-0.455200,-0.354708,0.816686>
 <43.146099,-88.715797,-30.063999>, <-0.457927,-0.343564,0.819919>
}
   smooth_triangle{ <44.448002,-87.845100,-28.952299>, <0.466891,0.344927,-0.814272>
 <43.146099,-88.715797,-30.063999>, <0.457927,0.343564,-0.819919>
 <43.673401,-87.850197,-29.394600>, <0.455200,0.354708,-0.816686>
}
   smooth_triangle{ <43.673401,-87.850197,-29.394600>, <-0.455200,-0.354708,0.816686>
 <42.388500,-88.724701,-30.483900>, <-0.444482,-0.345290,0.826566>
 <43.146099,-88.715797,-30.063999>, <-0.457927,-0.343564,0.819919>
}
   smooth_triangle{ <43.673401,-87.850197,-29.394600>, <0.455200,0.354708,-0.816686>
 <43.146099,-88.715797,-30.063999>, <0.457927,0.343564,-0.819919>
 <42.388500,-88.724701,-30.483900>, <0.444482,0.345290,-0.826566>
}
   smooth_triangle{ <43.673401,-87.850197,-29.394600>, <-0.455200,-0.354708,0.816686>
 <42.933201,-87.859497,-29.802700>, <-0.438210,-0.369669,0.819339>
 <42.388500,-88.724701,-30.483900>, <-0.444482,-0.345290,0.826566>
}
   smooth_triangle{ <43.673401,-87.850197,-29.394600>, <0.455200,0.354708,-0.816686>
 <42.388500,-88.724701,-30.483900>, <0.444482,0.345290,-0.826566>
 <42.933201,-87.859497,-29.802700>, <0.438210,0.369669,-0.819339>
}
   smooth_triangle{ <42.933201,-87.859497,-29.802700>, <-0.438210,-0.369669,0.819339>
 <41.546101,-88.739197,-30.936100>, <-0.433282,-0.346311,0.832067>
 <42.388500,-88.724701,-30.483900>, <-0.444482,-0.345290,0.826566>
}
   smooth_triangle{ <42.933201,-87.859497,-29.802700>, <0.438210,0.369669,-0.819339>
 <42.388500,-88.724701,-30.483900>, <0.444482,0.345290,-0.826566>
 <41.546101,-88.739197,-30.936100>, <0.433282,0.346311,-0.832067>
}
   smooth_triangle{ <42.933201,-87.859497,-29.802700>, <-0.438210,-0.369669,0.819339>
 <42.109299,-87.875000,-30.240700>, <-0.423102,-0.384691,0.820365>
 <41.546101,-88.739197,-30.936100>, <-0.433282,-0.346311,0.832067>
}
   smooth_triangle{ <42.933201,-87.859497,-29.802700>, <0.438210,0.369669,-0.819339>
 <41.546101,-88.739197,-30.936100>, <0.433282,0.346311,-0.832067>
 <42.109299,-87.875000,-30.240700>, <0.423102,0.384691,-0.820365>
}
   smooth_triangle{ <42.109299,-87.875000,-30.240700>, <-0.423102,-0.384691,0.820365>
 <40.498199,-88.760902,-31.486601>, <-0.425729,-0.363311,0.828710>
 <41.546101,-88.739197,-30.936100>, <-0.433282,-0.346311,0.832067>
}
   smooth_triangle{ <42.109299,-87.875000,-30.240700>, <0.423102,0.384691,-0.820365>
 <41.546101,-88.739197,-30.936100>, <0.433282,0.346311,-0.832067>
 <40.498199,-88.760902,-31.486601>, <0.459289,0.365348,-0.809676>
}
   smooth_triangle{ <42.109299,-87.875000,-30.240700>, <-0.423102,-0.384691,0.820365>
 <41.083801,-87.898399,-30.772600>, <-0.414587,-0.394167,0.820213>
 <40.498199,-88.760902,-31.486601>, <-0.425729,-0.363311,0.828710>
}
   smooth_triangle{ <42.109299,-87.875000,-30.240700>, <0.423102,0.384691,-0.820365>
 <40.498199,-88.760902,-31.486601>, <0.459289,0.365348,-0.809676>
 <41.083801,-87.898399,-30.772600>, <0.458476,0.360102,-0.812481>
}
   smooth_triangle{ <41.083801,-87.898399,-30.772600>, <0.458476,0.360102,-0.812481>
 <41.411201,-88.768097,-30.922701>, <0.490850,0.354793,-0.795731>
 <40.498199,-88.760902,-31.486601>, <0.459289,0.365348,-0.809676>
}
   smooth_triangle{ <41.083801,-87.898399,-30.772600>, <0.458476,0.360102,-0.812481>
 <41.972900,-87.906799,-30.219200>, <0.497351,0.329774,-0.802428>
 <41.411201,-88.768097,-30.922701>, <0.490850,0.354793,-0.795731>
}
   smooth_triangle{ <41.972900,-87.906799,-30.219200>, <0.497351,0.329774,-0.802428>
 <42.240898,-88.772003,-30.419100>, <0.481648,0.355897,-0.800845>
 <41.411201,-88.768097,-30.922701>, <0.490850,0.354793,-0.795731>
}
   smooth_triangle{ <41.972900,-87.906799,-30.219200>, <0.497351,0.329774,-0.802428>
 <42.781200,-87.911400,-29.725599>, <0.485703,0.341842,-0.804510>
 <42.240898,-88.772003,-30.419100>, <0.481648,0.355897,-0.800845>
}
   smooth_triangle{ <42.781200,-87.911400,-29.725599>, <0.485703,0.341842,-0.804510>
 <43.039902,-88.771896,-29.946199>, <0.469480,0.358795,-0.806755>
 <42.240898,-88.772003,-30.419100>, <0.481648,0.355897,-0.800845>
}
   smooth_triangle{ <42.781200,-87.911400,-29.725599>, <0.485703,0.341842,-0.804510>
 <43.560299,-87.911797,-29.263100>, <0.470749,0.354892,-0.807742>
 <43.039902,-88.771896,-29.946199>, <0.469480,0.358795,-0.806755>
}
   smooth_triangle{ <43.560299,-87.911797,-29.263100>, <0.470749,0.354892,-0.807742>
 <43.861401,-88.767303,-29.474501>, <0.456829,0.363121,-0.812066>
 <43.039902,-88.771896,-29.946199>, <0.469480,0.358795,-0.806755>
}
   smooth_triangle{ <43.560299,-87.911797,-29.263100>, <0.470749,0.354892,-0.807742>
 <44.362000,-87.907204,-28.803200>, <0.455823,0.366067,-0.811308>
 <43.861401,-88.767303,-29.474501>, <0.456829,0.363121,-0.812066>
}
   smooth_triangle{ <44.362000,-87.907204,-28.803200>, <0.455823,0.366067,-0.811308>
 <44.782501,-88.757896,-28.959299>, <0.446639,0.367477,-0.815766>
 <43.861401,-88.767303,-29.474501>, <0.456829,0.363121,-0.812066>
}
   smooth_triangle{ <44.362000,-87.907204,-28.803200>, <0.455823,0.366067,-0.811308>
 <45.261700,-87.897301,-28.302200>, <0.444302,0.372973,-0.814547>
 <44.782501,-88.757896,-28.959299>, <0.446639,0.367477,-0.815766>
}
   smooth_triangle{ <45.261700,-87.897301,-28.302200>, <0.444302,0.372973,-0.814547>
 <45.748001,-88.745003,-28.429399>, <0.438060,0.371608,-0.818542>
 <44.782501,-88.757896,-28.959299>, <0.446639,0.367477,-0.815766>
}
   smooth_triangle{ <45.261700,-87.897301,-28.302200>, <0.444302,0.372973,-0.814547>
 <46.205399,-87.883598,-27.787701>, <0.435237,0.376756,-0.817694>
 <45.748001,-88.745003,-28.429399>, <0.438060,0.371608,-0.818542>
}
   smooth_triangle{ <46.205399,-87.883598,-27.787701>, <0.435237,0.376756,-0.817694>
 <46.639702,-88.730202,-27.948999>, <0.427320,0.377550,-0.821495>
 <45.748001,-88.745003,-28.429399>, <0.438060,0.371608,-0.818542>
}
   smooth_triangle{ <46.205399,-87.883598,-27.787701>, <0.435237,0.376756,-0.817694>
 <47.077400,-87.867798,-27.322201>, <0.424143,0.380931,-0.821581>
 <46.639702,-88.730202,-27.948999>, <0.427320,0.377550,-0.821495>
}
   smooth_triangle{ <47.077400,-87.867798,-27.322201>, <0.424143,0.380931,-0.821581>
 <47.339699,-88.715401,-27.582300>, <0.466803,0.350665,-0.811868>
 <46.639702,-88.730202,-27.948999>, <0.427320,0.377550,-0.821495>
}
   smooth_triangle{ <47.077400,-87.867798,-27.322201>, <0.424143,0.380931,-0.821581>
 <47.762501,-87.851898,-26.968000>, <0.465155,0.350198,-0.813014>
 <47.339699,-88.715401,-27.582300>, <0.466803,0.350665,-0.811868>
}
   smooth_triangle{ <47.339699,-88.715401,-27.582300>, <-0.511169,-0.318963,0.798103>
 <46.360001,-89.709900,-28.608900>, <-0.500498,-0.326442,0.801834>
 <46.849300,-89.717300,-28.295500>, <-0.517928,-0.314021,0.795702>
}
   smooth_triangle{ <47.339699,-88.715401,-27.582300>, <0.466803,0.350665,-0.811868>
 <46.849300,-89.717300,-28.295500>, <0.469350,0.347736,-0.811659>
 <46.360001,-89.709900,-28.608900>, <0.500498,0.326442,-0.801834>
}
   smooth_triangle{ <47.339699,-88.715401,-27.582300>, <-0.511169,-0.318963,0.798103>
 <46.685101,-88.707199,-27.996300>, <-0.498338,-0.326578,0.803123>
 <46.360001,-89.709900,-28.608900>, <-0.500498,-0.326442,0.801834>
}
   smooth_triangle{ <47.339699,-88.715401,-27.582300>, <0.466803,0.350665,-0.811868>
 <46.360001,-89.709900,-28.608900>, <0.500498,0.326442,-0.801834>
 <46.685101,-88.707199,-27.996300>, <0.498338,0.326578,-0.803123>
}
   smooth_triangle{ <46.685101,-88.707199,-27.996300>, <-0.498338,-0.326578,0.803123>
 <45.707500,-89.707901,-29.001801>, <-0.480791,-0.337928,0.809101>
 <46.360001,-89.709900,-28.608900>, <-0.500498,-0.326442,0.801834>
}
   smooth_triangle{ <46.685101,-88.707199,-27.996300>, <0.498338,0.326578,-0.803123>
 <46.360001,-89.709900,-28.608900>, <0.500498,0.326442,-0.801834>
 <45.707500,-89.707901,-29.001801>, <0.480791,0.337928,-0.809101>
}
   smooth_triangle{ <46.685101,-88.707199,-27.996300>, <-0.498338,-0.326578,0.803123>
 <45.813999,-88.705299,-28.518200>, <-0.480149,-0.337189,0.809790>
 <45.707500,-89.707901,-29.001801>, <-0.480791,-0.337928,0.809101>
}
   smooth_triangle{ <46.685101,-88.707199,-27.996300>, <0.498338,0.326578,-0.803123>
 <45.707500,-89.707901,-29.001801>, <0.480791,0.337928,-0.809101>
 <45.813999,-88.705299,-28.518200>, <0.480149,0.337189,-0.809790>
}
   smooth_triangle{ <45.813999,-88.705299,-28.518200>, <-0.480149,-0.337189,0.809790>
 <44.988998,-89.709099,-29.423100>, <-0.472737,-0.340688,0.812682>
 <45.707500,-89.707901,-29.001801>, <-0.480791,-0.337928,0.809101>
}
   smooth_triangle{ <45.813999,-88.705299,-28.518200>, <0.480149,0.337189,-0.809790>
 <45.707500,-89.707901,-29.001801>, <0.480791,0.337928,-0.809101>
 <44.988998,-89.709099,-29.423100>, <0.472737,0.340688,-0.812682>
}
   smooth_triangle{ <45.813999,-88.705299,-28.518200>, <-0.480149,-0.337189,0.809790>
 <44.855598,-88.707298,-29.079201>, <-0.472489,-0.340896,0.812739>
 <44.988998,-89.709099,-29.423100>, <-0.472737,-0.340688,0.812682>
}
   smooth_triangle{ <45.813999,-88.705299,-28.518200>, <0.480149,0.337189,-0.809790>
 <44.988998,-89.709099,-29.423100>, <0.472737,0.340688,-0.812682>
 <44.855598,-88.707298,-29.079201>, <0.472489,0.340896,-0.812739>
}
   smooth_triangle{ <44.855598,-88.707298,-29.079201>, <-0.472489,-0.340896,0.812739>
 <44.301998,-89.711800,-29.821301>, <-0.467398,-0.340248,0.815948>
 <44.988998,-89.709099,-29.423100>, <-0.472737,-0.340688,0.812682>
}
   smooth_triangle{ <44.855598,-88.707298,-29.079201>, <0.472489,0.340896,-0.812739>
 <44.988998,-89.709099,-29.423100>, <0.472737,0.340688,-0.812682>
 <44.301998,-89.711800,-29.821301>, <0.467398,0.340248,-0.815948>
}
   smooth_triangle{ <44.855598,-88.707298,-29.079201>, <-0.472489,-0.340896,0.812739>
 <43.939602,-88.710899,-29.610100>, <-0.467462,-0.342312,0.815047>
 <44.301998,-89.711800,-29.821301>, <-0.467398,-0.340248,0.815948>
}
   smooth_triangle{ <44.855598,-88.707298,-29.079201>, <0.472489,0.340896,-0.812739>
 <44.301998,-89.711800,-29.821301>, <0.467398,0.340248,-0.815948>
 <43.939602,-88.710899,-29.610100>, <0.467462,0.342312,-0.815047>
}
   smooth_triangle{ <43.939602,-88.710899,-29.610100>, <-0.467462,-0.342312,0.815047>
 <43.706699,-89.715698,-30.161301>, <-0.457912,-0.335615,0.823213>
 <44.301998,-89.711800,-29.821301>, <-0.467398,-0.340248,0.815948>
}
   smooth_triangle{ <43.939602,-88.710899,-29.610100>, <0.467462,0.342312,-0.815047>
 <44.301998,-89.711800,-29.821301>, <0.467398,0.340248,-0.815948>
 <43.706699,-89.715698,-30.161301>, <0.457912,0.335615,-0.823213>
}
   smooth_triangle{ <43.939602,-88.710899,-29.610100>, <-0.467462,-0.342312,0.815047>
 <43.146099,-88.715797,-30.063999>, <-0.457927,-0.343564,0.819919>
 <43.706699,-89.715698,-30.161301>, <-0.457912,-0.335615,0.823213>
}
   smooth_triangle{ <43.939602,-88.710899,-29.610100>, <0.467462,0.342312,-0.815047>
 <43.706699,-89.715698,-30.161301>, <0.457912,0.335615,-0.823213>
 <43.146099,-88.715797,-30.063999>, <0.457927,0.343564,-0.819919>
}
   smooth_triangle{ <43.146099,-88.715797,-30.063999>, <-0.457927,-0.343564,0.819919>
 <43.137600,-89.723000,-30.474800>, <-0.445047,-0.325437,0.834280>
 <43.706699,-89.715698,-30.161301>, <-0.457912,-0.335615,0.823213>
}
   smooth_triangle{ <43.146099,-88.715797,-30.063999>, <0.457927,0.343564,-0.819919>
 <43.706699,-89.715698,-30.161301>, <0.457912,0.335615,-0.823213>
 <43.137600,-89.723000,-30.474800>, <0.445047,0.325437,-0.834280>
}
   smooth_triangle{ <43.146099,-88.715797,-30.063999>, <-0.457927,-0.343564,0.819919>
 <42.388500,-88.724701,-30.483900>, <-0.444482,-0.345290,0.826566>
 <43.137600,-89.723000,-30.474800>, <-0.445047,-0.325437,0.834280>
}
   smooth_triangle{ <43.146099,-88.715797,-30.063999>, <0.457927,0.343564,-0.819919>
 <43.137600,-89.723000,-30.474800>, <0.445047,0.325437,-0.834280>
 <42.388500,-88.724701,-30.483900>, <0.444482,0.345290,-0.826566>
}
   smooth_triangle{ <42.388500,-88.724701,-30.483900>, <-0.444482,-0.345290,0.826566>
 <42.504101,-89.735100,-30.811001>, <-0.435208,-0.312380,0.844401>
 <43.137600,-89.723000,-30.474800>, <-0.445047,-0.325437,0.834280>
}
   smooth_triangle{ <42.388500,-88.724701,-30.483900>, <0.444482,0.345290,-0.826566>
 <43.137600,-89.723000,-30.474800>, <0.445047,0.325437,-0.834280>
 <42.504101,-89.735100,-30.811001>, <0.435208,0.312380,-0.844401>
}
   smooth_triangle{ <42.388500,-88.724701,-30.483900>, <-0.444482,-0.345290,0.826566>
 <41.546101,-88.739197,-30.936100>, <-0.433282,-0.346311,0.832067>
 <42.504101,-89.735100,-30.811001>, <-0.435208,-0.312380,0.844401>
}
   smooth_triangle{ <42.388500,-88.724701,-30.483900>, <0.444482,0.345290,-0.826566>
 <42.504101,-89.735100,-30.811001>, <0.435208,0.312380,-0.844401>
 <41.546101,-88.739197,-30.936100>, <0.433282,0.346311,-0.832067>
}
   smooth_triangle{ <41.546101,-88.739197,-30.936100>, <-0.433282,-0.346311,0.832067>
 <41.715500,-89.753304,-31.219200>, <-0.433792,-0.307074,0.847072>
 <42.504101,-89.735100,-30.811001>, <-0.435208,-0.312380,0.844401>
}
   smooth_triangle{ <41.546101,-88.739197,-30.936100>, <0.433282,0.346311,-0.832067>
 <42.504101,-89.735100,-30.811001>, <0.435208,0.312380,-0.844401>
 <41.715500,-89.753304,-31.219200>, <0.463294,0.350649,-0.813882>
}
   smooth_triangle{ <41.546101,-88.739197,-30.936100>, <-0.433282,-0.346311,0.832067>
 <40.498199,-88.760902,-31.486601>, <-0.425729,-0.363311,0.828710>
 <41.715500,-89.753304,-31.219200>, <-0.433792,-0.307074,0.847072>
}
   smooth_triangle{ <41.546101,-88.739197,-30.936100>, <0.433282,0.346311,-0.832067>
 <41.715500,-89.753304,-31.219200>, <0.463294,0.350649,-0.813882>
 <40.498199,-88.760902,-31.486601>, <0.459289,0.365348,-0.809676>
}
   smooth_triangle{ <40.498199,-88.760902,-31.486601>, <0.459289,0.365348,-0.809676>
 <42.398602,-89.759903,-30.793501>, <0.487103,0.384663,-0.784069>
 <41.715500,-89.753304,-31.219200>, <0.463294,0.350649,-0.813882>
}
   smooth_triangle{ <40.498199,-88.760902,-31.486601>, <0.459289,0.365348,-0.809676>
 <41.411201,-88.768097,-30.922701>, <0.490850,0.354793,-0.795731>
 <42.398602,-89.759903,-30.793501>, <0.487103,0.384663,-0.784069>
}
   smooth_triangle{ <41.411201,-88.768097,-30.922701>, <0.490850,0.354793,-0.795731>
 <43.019699,-89.763603,-30.413700>, <0.479222,0.374478,-0.793796>
 <42.398602,-89.759903,-30.793501>, <0.487103,0.384663,-0.784069>
}
   smooth_triangle{ <41.411201,-88.768097,-30.922701>, <0.490850,0.354793,-0.795731>
 <42.240898,-88.772003,-30.419100>, <0.481648,0.355897,-0.800845>
 <43.019699,-89.763603,-30.413700>, <0.479222,0.374478,-0.793796>
}
   smooth_triangle{ <42.240898,-88.772003,-30.419100>, <0.481648,0.355897,-0.800845>
 <43.618599,-89.763901,-30.058201>, <0.467960,0.366234,-0.804293>
 <43.019699,-89.763603,-30.413700>, <0.479222,0.374478,-0.793796>
}
   smooth_triangle{ <42.240898,-88.772003,-30.419100>, <0.481648,0.355897,-0.800845>
 <43.039902,-88.771896,-29.946199>, <0.469480,0.358795,-0.806755>
 <43.618599,-89.763901,-30.058201>, <0.467960,0.366234,-0.804293>
}
   smooth_triangle{ <43.039902,-88.771896,-29.946199>, <0.469480,0.358795,-0.806755>
 <44.234798,-89.760399,-29.704800>, <0.455765,0.362211,-0.813069>
 <43.618599,-89.763901,-30.058201>, <0.467960,0.366234,-0.804293>
}
   smooth_triangle{ <43.039902,-88.771896,-29.946199>, <0.469480,0.358795,-0.806755>
 <43.861401,-88.767303,-29.474501>, <0.456829,0.363121,-0.812066>
 <44.234798,-89.760399,-29.704800>, <0.455765,0.362211,-0.813069>
}
   smooth_triangle{ <43.861401,-88.767303,-29.474501>, <0.456829,0.363121,-0.812066>
 <44.926498,-89.752701,-29.319901>, <0.445391,0.362945,-0.818473>
 <44.234798,-89.760399,-29.704800>, <0.455765,0.362211,-0.813069>
}
   smooth_triangle{ <43.861401,-88.767303,-29.474501>, <0.456829,0.363121,-0.812066>
 <44.782501,-88.757896,-28.959299>, <0.446639,0.367477,-0.815766>
 <44.926498,-89.752701,-29.319901>, <0.445391,0.362945,-0.818473>
}
   smooth_triangle{ <44.782501,-88.757896,-28.959299>, <0.446639,0.367477,-0.815766>
 <45.651901,-89.741997,-28.924700>, <0.435932,0.367428,-0.821560>
 <44.926498,-89.752701,-29.319901>, <0.445391,0.362945,-0.818473>
}
   smooth_triangle{ <44.782501,-88.757896,-28.959299>, <0.446639,0.367477,-0.815766>
 <45.748001,-88.745003,-28.429399>, <0.438060,0.371608,-0.818542>
 <45.651901,-89.741997,-28.924700>, <0.435932,0.367428,-0.821560>
}
   smooth_triangle{ <45.748001,-88.745003,-28.429399>, <0.438060,0.371608,-0.818542>
 <46.322399,-89.729698,-28.567400>, <0.423449,0.375984,-0.824213>
 <45.651901,-89.741997,-28.924700>, <0.435932,0.367428,-0.821560>
}
   smooth_triangle{ <45.748001,-88.745003,-28.429399>, <0.438060,0.371608,-0.818542>
 <46.639702,-88.730202,-27.948999>, <0.427320,0.377550,-0.821495>
 <46.322399,-89.729698,-28.567400>, <0.423449,0.375984,-0.824213>
}
   smooth_triangle{ <46.639702,-88.730202,-27.948999>, <0.427320,0.377550,-0.821495>
 <46.849300,-89.717300,-28.295500>, <0.469350,0.347736,-0.811659>
 <46.322399,-89.729698,-28.567400>, <0.423449,0.375984,-0.824213>
}
   smooth_triangle{ <46.639702,-88.730202,-27.948999>, <0.427320,0.377550,-0.821495>
 <47.339699,-88.715401,-27.582300>, <0.466803,0.350665,-0.811868>
 <46.849300,-89.717300,-28.295500>, <0.469350,0.347736,-0.811659>
}
   smooth_triangle{ <46.849300,-89.717300,-28.295500>, <-0.517928,-0.314021,0.795702>
 <46.034302,-90.713097,-29.220400>, <-0.506682,-0.321114,0.800099>
 <46.358799,-90.719200,-29.008699>, <-0.528829,-0.305242,0.791939>
}
   smooth_triangle{ <46.849300,-89.717300,-28.295500>, <0.469350,0.347736,-0.811659>
 <46.358799,-90.719200,-29.008699>, <0.470789,0.346234,-0.811468>
 <46.034302,-90.713097,-29.220400>, <0.506682,0.321114,-0.800099>
}
   smooth_triangle{ <46.849300,-89.717300,-28.295500>, <-0.517928,-0.314021,0.795702>
 <46.360001,-89.709900,-28.608900>, <-0.500498,-0.326442,0.801834>
 <46.034302,-90.713097,-29.220400>, <-0.506682,-0.321114,0.800099>
}
   smooth_triangle{ <46.849300,-89.717300,-28.295500>, <0.469350,0.347736,-0.811659>
 <46.034302,-90.713097,-29.220400>, <0.506682,0.321114,-0.800099>
 <46.360001,-89.709900,-28.608900>, <0.500498,0.326442,-0.801834>
}
   smooth_triangle{ <46.360001,-89.709900,-28.608900>, <-0.500498,-0.326442,0.801834>
 <45.600101,-90.711197,-29.483801>, <-0.483373,-0.334551,0.808967>
 <46.034302,-90.713097,-29.220400>, <-0.506682,-0.321114,0.800099>
}
   smooth_triangle{ <46.360001,-89.709900,-28.608900>, <0.500498,0.326442,-0.801834>
 <46.034302,-90.713097,-29.220400>, <0.506682,0.321114,-0.800099>
 <45.600101,-90.711197,-29.483801>, <0.483373,0.334551,-0.808967>
}
   smooth_triangle{ <46.360001,-89.709900,-28.608900>, <-0.500498,-0.326442,0.801834>
 <45.707500,-89.707901,-29.001801>, <-0.480791,-0.337928,0.809101>
 <45.600101,-90.711197,-29.483801>, <-0.483373,-0.334551,0.808967>
}
   smooth_triangle{ <46.360001,-89.709900,-28.608900>, <0.500498,0.326442,-0.801834>
 <45.600101,-90.711197,-29.483801>, <0.483373,0.334551,-0.808967>
 <45.707500,-89.707901,-29.001801>, <0.480791,0.337928,-0.809101>
}
   smooth_triangle{ <45.707500,-89.707901,-29.001801>, <-0.480791,-0.337928,0.809101>
 <45.121399,-90.711800,-29.765200>, <-0.473888,-0.337704,0.813257>
 <45.600101,-90.711197,-29.483801>, <-0.483373,-0.334551,0.808967>
}
   smooth_triangle{ <45.707500,-89.707901,-29.001801>, <0.480791,0.337928,-0.809101>
 <45.600101,-90.711197,-29.483801>, <0.483373,0.334551,-0.808967>
 <45.121399,-90.711800,-29.765200>, <0.473888,0.337704,-0.813257>
}
   smooth_triangle{ <45.707500,-89.707901,-29.001801>, <-0.480791,-0.337928,0.809101>
 <44.988998,-89.709099,-29.423100>, <-0.472737,-0.340688,0.812682>
 <45.121399,-90.711800,-29.765200>, <-0.473888,-0.337704,0.813257>
}
   smooth_triangle{ <45.707500,-89.707901,-29.001801>, <0.480791,0.337928,-0.809101>
 <45.121399,-90.711800,-29.765200>, <0.473888,0.337704,-0.813257>
 <44.988998,-89.709099,-29.423100>, <0.472737,0.340688,-0.812682>
}
   smooth_triangle{ <44.988998,-89.709099,-29.423100>, <-0.472737,-0.340688,0.812682>
 <44.663502,-90.713501,-30.030800>, <-0.467323,-0.337158,0.817272>
 <45.121399,-90.711800,-29.765200>, <-0.473888,-0.337704,0.813257>
}
   smooth_triangle{ <44.988998,-89.709099,-29.423100>, <0.472737,0.340688,-0.812682>
 <45.121399,-90.711800,-29.765200>, <0.473888,0.337704,-0.813257>
 <44.663502,-90.713501,-30.030800>, <0.467323,0.337158,-0.817272>
}
   smooth_triangle{ <44.988998,-89.709099,-29.423100>, <-0.472737,-0.340688,0.812682>
 <44.301998,-89.711800,-29.821301>, <-0.467398,-0.340248,0.815948>
 <44.663502,-90.713501,-30.030800>, <-0.467323,-0.337158,0.817272>
}
   smooth_triangle{ <44.988998,-89.709099,-29.423100>, <0.472737,0.340688,-0.812682>
 <44.663502,-90.713501,-30.030800>, <0.467323,0.337158,-0.817272>
 <44.301998,-89.711800,-29.821301>, <0.467398,0.340248,-0.815948>
}
   smooth_triangle{ <44.301998,-89.711800,-29.821301>, <-0.467398,-0.340248,0.815948>
 <44.266300,-90.716301,-30.256901>, <-0.455766,-0.331672,0.825997>
 <44.663502,-90.713501,-30.030800>, <-0.467323,-0.337158,0.817272>
}
   smooth_triangle{ <44.301998,-89.711800,-29.821301>, <0.467398,0.340248,-0.815948>
 <44.663502,-90.713501,-30.030800>, <0.467323,0.337158,-0.817272>
 <44.266300,-90.716301,-30.256901>, <0.455766,0.331672,-0.825997>
}
   smooth_triangle{ <44.301998,-89.711800,-29.821301>, <-0.467398,-0.340248,0.815948>
 <43.706699,-89.715698,-30.161301>, <-0.457912,-0.335615,0.823213>
 <44.266300,-90.716301,-30.256901>, <-0.455766,-0.331672,0.825997>
}
   smooth_triangle{ <44.301998,-89.711800,-29.821301>, <0.467398,0.340248,-0.815948>
 <44.266300,-90.716301,-30.256901>, <0.455766,0.331672,-0.825997>
 <43.706699,-89.715698,-30.161301>, <0.457912,0.335615,-0.823213>
}
   smooth_triangle{ <43.706699,-89.715698,-30.161301>, <-0.457912,-0.335615,0.823213>
 <43.886101,-90.721802,-30.464500>, <-0.440365,-0.319689,0.838975>
 <44.266300,-90.716301,-30.256901>, <-0.455766,-0.331672,0.825997>
}
   smooth_triangle{ <43.706699,-89.715698,-30.161301>, <0.457912,0.335615,-0.823213>
 <44.266300,-90.716301,-30.256901>, <0.455766,0.331672,-0.825997>
 <43.886101,-90.721802,-30.464500>, <0.440365,0.319689,-0.838975>
}
   smooth_triangle{ <43.706699,-89.715698,-30.161301>, <-0.457912,-0.335615,0.823213>
 <43.137600,-89.723000,-30.474800>, <-0.445047,-0.325437,0.834280>
 <43.886101,-90.721802,-30.464500>, <-0.440365,-0.319689,0.838975>
}
   smooth_triangle{ <43.706699,-89.715698,-30.161301>, <0.457912,0.335615,-0.823213>
 <43.886101,-90.721802,-30.464500>, <0.440365,0.319689,-0.838975>
 <43.137600,-89.723000,-30.474800>, <0.445047,0.325437,-0.834280>
}
   smooth_triangle{ <43.137600,-89.723000,-30.474800>, <-0.445047,-0.325437,0.834280>
 <43.462101,-90.731003,-30.685699>, <-0.428266,-0.304495,0.850806>
 <43.886101,-90.721802,-30.464500>, <-0.440365,-0.319689,0.838975>
}
   smooth_triangle{ <43.137600,-89.723000,-30.474800>, <0.445047,0.325437,-0.834280>
 <43.886101,-90.721802,-30.464500>, <0.440365,0.319689,-0.838975>
 <43.462101,-90.731003,-30.685699>, <0.428266,0.304495,-0.850806>
}
   smooth_triangle{ <43.137600,-89.723000,-30.474800>, <-0.445047,-0.325437,0.834280>
 <42.504101,-89.735100,-30.811001>, <-0.435208,-0.312380,0.844401>
 <43.462101,-90.731003,-30.685699>, <-0.428266,-0.304495,0.850806>
}
   smooth_triangle{ <43.137600,-89.723000,-30.474800>, <0.445047,0.325437,-0.834280>
 <43.462101,-90.731003,-30.685699>, <0.428266,0.304495,-0.850806>
 <42.504101,-89.735100,-30.811001>, <0.435208,0.312380,-0.844401>
}
   smooth_triangle{ <42.504101,-89.735100,-30.811001>, <-0.435208,-0.312380,0.844401>
 <42.933701,-90.745003,-30.953400>, <-0.427523,-0.300110,0.852735>
 <43.462101,-90.731003,-30.685699>, <-0.428266,-0.304495,0.850806>
}
   smooth_triangle{ <42.504101,-89.735100,-30.811001>, <0.435208,0.312380,-0.844401>
 <43.462101,-90.731003,-30.685699>, <0.428266,0.304495,-0.850806>
 <42.933701,-90.745003,-30.953400>, <0.462899,0.352622,-0.813255>
}
   smooth_triangle{ <42.504101,-89.735100,-30.811001>, <-0.435208,-0.312380,0.844401>
 <41.715500,-89.753304,-31.219200>, <-0.433792,-0.307074,0.847072>
 <42.933701,-90.745003,-30.953400>, <-0.427523,-0.300110,0.852735>
}
   smooth_triangle{ <42.504101,-89.735100,-30.811001>, <0.435208,0.312380,-0.844401>
 <42.933701,-90.745003,-30.953400>, <0.462899,0.352622,-0.813255>
 <41.715500,-89.753304,-31.219200>, <0.463294,0.350649,-0.813882>
}
   smooth_triangle{ <41.715500,-89.753304,-31.219200>, <0.463294,0.350649,-0.813882>
 <43.387501,-90.750702,-30.666599>, <0.490459,0.392732,-0.777953>
 <42.933701,-90.745003,-30.953400>, <0.462899,0.352622,-0.813255>
}
   smooth_triangle{ <41.715500,-89.753304,-31.219200>, <0.463294,0.350649,-0.813882>
 <42.398602,-89.759903,-30.793501>, <0.487103,0.384663,-0.784069>
 <43.387501,-90.750702,-30.666599>, <0.490459,0.392732,-0.777953>
}
   smooth_triangle{ <42.398602,-89.759903,-30.793501>, <0.487103,0.384663,-0.784069>
 <43.800400,-90.753899,-30.411600>, <0.480950,0.380805,-0.789731>
 <43.387501,-90.750702,-30.666599>, <0.490459,0.392732,-0.777953>
}
   smooth_triangle{ <42.398602,-89.759903,-30.793501>, <0.487103,0.384663,-0.784069>
 <43.019699,-89.763603,-30.413700>, <0.479222,0.374478,-0.793796>
 <43.800400,-90.753899,-30.411600>, <0.480950,0.380805,-0.789731>
}
   smooth_triangle{ <43.019699,-89.763603,-30.413700>, <0.479222,0.374478,-0.793796>
 <44.199200,-90.754501,-30.173800>, <0.467402,0.371085,-0.802391>
 <43.800400,-90.753899,-30.411600>, <0.480950,0.380805,-0.789731>
}
   smooth_triangle{ <43.019699,-89.763603,-30.413700>, <0.479222,0.374478,-0.793796>
 <43.618599,-89.763901,-30.058201>, <0.467960,0.366234,-0.804293>
 <44.199200,-90.754501,-30.173800>, <0.467402,0.371085,-0.802391>
}
   smooth_triangle{ <43.618599,-89.763901,-30.058201>, <0.467960,0.366234,-0.804293>
 <44.610199,-90.751999,-29.938400>, <0.452846,0.366251,-0.812890>
 <44.199200,-90.754501,-30.173800>, <0.467402,0.371085,-0.802391>
}
   smooth_triangle{ <43.618599,-89.763901,-30.058201>, <0.467960,0.366234,-0.804293>
 <44.234798,-89.760399,-29.704800>, <0.455765,0.362211,-0.813069>
 <44.610199,-90.751999,-29.938400>, <0.452846,0.366251,-0.812890>
}
   smooth_triangle{ <44.234798,-89.760399,-29.704800>, <0.455765,0.362211,-0.813069>
 <45.072201,-90.746300,-29.683201>, <0.440369,0.366815,-0.819464>
 <44.610199,-90.751999,-29.938400>, <0.452846,0.366251,-0.812890>
}
   smooth_triangle{ <44.234798,-89.760399,-29.704800>, <0.455765,0.362211,-0.813069>
 <44.926498,-89.752701,-29.319901>, <0.445391,0.362945,-0.818473>
 <45.072201,-90.746300,-29.683201>, <0.440369,0.366815,-0.819464>
}
   smooth_triangle{ <44.926498,-89.752701,-29.319901>, <0.445391,0.362945,-0.818473>
 <45.557098,-90.738197,-29.422199>, <0.429118,0.371744,-0.823203>
 <45.072201,-90.746300,-29.683201>, <0.440369,0.366815,-0.819464>
}
   smooth_triangle{ <44.926498,-89.752701,-29.319901>, <0.445391,0.362945,-0.818473>
 <45.651901,-89.741997,-28.924700>, <0.435932,0.367428,-0.821560>
 <45.557098,-90.738197,-29.422199>, <0.429118,0.371744,-0.823203>
}
   smooth_triangle{ <45.651901,-89.741997,-28.924700>, <0.435932,0.367428,-0.821560>
 <46.005798,-90.728798,-29.186800>, <0.414051,0.381516,-0.826442>
 <45.557098,-90.738197,-29.422199>, <0.429118,0.371744,-0.823203>
}
   smooth_triangle{ <45.651901,-89.741997,-28.924700>, <0.435932,0.367428,-0.821560>
 <46.322399,-89.729698,-28.567400>, <0.423449,0.375984,-0.824213>
 <46.005798,-90.728798,-29.186800>, <0.414051,0.381516,-0.826442>
}
   smooth_triangle{ <46.322399,-89.729698,-28.567400>, <0.423449,0.375984,-0.824213>
 <46.358799,-90.719200,-29.008699>, <0.470789,0.346234,-0.811468>
 <46.005798,-90.728798,-29.186800>, <0.414051,0.381516,-0.826442>
}
   smooth_triangle{ <46.322399,-89.729698,-28.567400>, <0.423449,0.375984,-0.824213>
 <46.849300,-89.717300,-28.295500>, <0.469350,0.347736,-0.811659>
 <46.358799,-90.719200,-29.008699>, <0.470789,0.346234,-0.811468>
}
   smooth_triangle{ <46.358799,-90.719200,-29.008699>, <-0.528829,-0.305242,0.791939>
 <45.707100,-91.717300,-29.829500>, <-0.519591,-0.309035,0.796569>
 <45.867901,-91.721497,-29.721100>, <-0.539373,-0.295051,0.788684>
}
   smooth_triangle{ <46.358799,-90.719200,-29.008699>, <0.470789,0.346234,-0.811468>
 <45.867901,-91.721497,-29.721100>, <0.454542,0.355420,-0.816743>
 <45.707100,-91.717300,-29.829500>, <0.519591,0.309035,-0.796569>
}
   smooth_triangle{ <46.358799,-90.719200,-29.008699>, <-0.528829,-0.305242,0.791939>
 <46.034302,-90.713097,-29.220400>, <-0.506682,-0.321114,0.800099>
 <45.707100,-91.717300,-29.829500>, <-0.519591,-0.309035,0.796569>
}
   smooth_triangle{ <46.358799,-90.719200,-29.008699>, <0.470789,0.346234,-0.811468>
 <45.707100,-91.717300,-29.829500>, <0.519591,0.309035,-0.796569>
 <46.034302,-90.713097,-29.220400>, <0.506682,0.321114,-0.800099>
}
   smooth_triangle{ <46.034302,-90.713097,-29.220400>, <-0.506682,-0.321114,0.800099>
 <45.490799,-91.715797,-29.962500>, <-0.489160,-0.326622,0.808728>
 <45.707100,-91.717300,-29.829500>, <-0.519591,-0.309035,0.796569>
}
   smooth_triangle{ <46.034302,-90.713097,-29.220400>, <0.506682,0.321114,-0.800099>
 <45.707100,-91.717300,-29.829500>, <0.519591,0.309035,-0.796569>
 <45.490799,-91.715797,-29.962500>, <0.489160,0.326622,-0.808728>
}
   smooth_triangle{ <46.034302,-90.713097,-29.220400>, <-0.506682,-0.321114,0.800099>
 <45.600101,-90.711197,-29.483801>, <-0.483373,-0.334551,0.808967>
 <45.490799,-91.715797,-29.962500>, <-0.489160,-0.326622,0.808728>
}
   smooth_triangle{ <46.034302,-90.713097,-29.220400>, <0.506682,0.321114,-0.800099>
 <45.490799,-91.715797,-29.962500>, <0.489160,0.326622,-0.808728>
 <45.600101,-90.711197,-29.483801>, <0.483373,0.334551,-0.808967>
}
   smooth_triangle{ <45.600101,-90.711197,-29.483801>, <-0.483373,-0.334551,0.808967>
 <45.251701,-91.715897,-30.103701>, <-0.476638,-0.330837,0.814471>
 <45.490799,-91.715797,-29.962500>, <-0.489160,-0.326622,0.808728>
}
   smooth_triangle{ <45.600101,-90.711197,-29.483801>, <0.483373,0.334551,-0.808967>
 <45.490799,-91.715797,-29.962500>, <0.489160,0.326622,-0.808728>
 <45.251701,-91.715897,-30.103701>, <0.476638,0.330837,-0.814471>
}
   smooth_triangle{ <45.600101,-90.711197,-29.483801>, <-0.483373,-0.334551,0.808967>
 <45.121399,-90.711800,-29.765200>, <-0.473888,-0.337704,0.813257>
 <45.251701,-91.715897,-30.103701>, <-0.476638,-0.330837,0.814471>
}
   smooth_triangle{ <45.600101,-90.711197,-29.483801>, <0.483373,0.334551,-0.808967>
 <45.251701,-91.715897,-30.103701>, <0.476638,0.330837,-0.814471>
 <45.121399,-90.711800,-29.765200>, <0.473888,0.337704,-0.813257>
}
   smooth_triangle{ <45.121399,-90.711800,-29.765200>, <-0.473888,-0.337704,0.813257>
 <45.022800,-91.716797,-30.236601>, <-0.469000,-0.330498,0.819030>
 <45.251701,-91.715897,-30.103701>, <-0.476638,-0.330837,0.814471>
}
   smooth_triangle{ <45.121399,-90.711800,-29.765200>, <0.473888,0.337704,-0.813257>
 <45.251701,-91.715897,-30.103701>, <0.476638,0.330837,-0.814471>
 <45.022800,-91.716797,-30.236601>, <0.469000,0.330498,-0.819030>
}
   smooth_triangle{ <45.121399,-90.711800,-29.765200>, <-0.473888,-0.337704,0.813257>
 <44.663502,-90.713501,-30.030800>, <-0.467323,-0.337158,0.817272>
 <45.022800,-91.716797,-30.236601>, <-0.469000,-0.330498,0.819030>
}
   smooth_triangle{ <45.121399,-90.711800,-29.765200>, <0.473888,0.337704,-0.813257>
 <45.022800,-91.716797,-30.236601>, <0.469000,0.330498,-0.819030>
 <44.663502,-90.713501,-30.030800>, <0.467323,0.337158,-0.817272>
}
   smooth_triangle{ <44.663502,-90.713501,-30.030800>, <-0.467323,-0.337158,0.817272>
 <44.824001,-91.718300,-30.349199>, <-0.455967,-0.325260,0.828432>
 <45.022800,-91.716797,-30.236601>, <-0.469000,-0.330498,0.819030>
}
   smooth_triangle{ <44.663502,-90.713501,-30.030800>, <0.467323,0.337158,-0.817272>
 <45.022800,-91.716797,-30.236601>, <0.469000,0.330498,-0.819030>
 <44.824001,-91.718300,-30.349199>, <0.455967,0.325260,-0.828432>
}
   smooth_triangle{ <44.663502,-90.713501,-30.030800>, <-0.467323,-0.337158,0.817272>
 <44.266300,-90.716301,-30.256901>, <-0.455766,-0.331672,0.825997>
 <44.824001,-91.718300,-30.349199>, <-0.455967,-0.325260,0.828432>
}
   smooth_triangle{ <44.663502,-90.713501,-30.030800>, <0.467323,0.337158,-0.817272>
 <44.824001,-91.718300,-30.349199>, <0.455967,0.325260,-0.828432>
 <44.266300,-90.716301,-30.256901>, <0.455766,0.331672,-0.825997>
}
   smooth_triangle{ <44.266300,-90.716301,-30.256901>, <-0.455766,-0.331672,0.825997>
 <44.633099,-91.721603,-30.451599>, <-0.437252,-0.312819,0.843181>
 <44.824001,-91.718300,-30.349199>, <-0.455967,-0.325260,0.828432>
}
   smooth_triangle{ <44.266300,-90.716301,-30.256901>, <0.455766,0.331672,-0.825997>
 <44.824001,-91.718300,-30.349199>, <0.455967,0.325260,-0.828432>
 <44.633099,-91.721603,-30.451599>, <0.437252,0.312819,-0.843181>
}
   smooth_triangle{ <44.266300,-90.716301,-30.256901>, <-0.455766,-0.331672,0.825997>
 <43.886101,-90.721802,-30.464500>, <-0.440365,-0.319689,0.838975>
 <44.633099,-91.721603,-30.451599>, <-0.437252,-0.312819,0.843181>
}
   smooth_triangle{ <44.266300,-90.716301,-30.256901>, <0.455766,0.331672,-0.825997>
 <44.633099,-91.721603,-30.451599>, <0.437252,0.312819,-0.843181>
 <43.886101,-90.721802,-30.464500>, <0.440365,0.319689,-0.838975>
}
   smooth_triangle{ <43.886101,-90.721802,-30.464500>, <-0.440365,-0.319689,0.838975>
 <44.419601,-91.727303,-30.559700>, <-0.421344,-0.296601,0.857028>
 <44.633099,-91.721603,-30.451599>, <-0.437252,-0.312819,0.843181>
}
   smooth_triangle{ <43.886101,-90.721802,-30.464500>, <0.440365,0.319689,-0.838975>
 <44.633099,-91.721603,-30.451599>, <0.437252,0.312819,-0.843181>
 <44.419601,-91.727303,-30.559700>, <0.421344,0.296601,-0.857028>
}
   smooth_triangle{ <43.886101,-90.721802,-30.464500>, <-0.440365,-0.319689,0.838975>
 <43.462101,-90.731003,-30.685699>, <-0.428266,-0.304495,0.850806>
 <44.419601,-91.727303,-30.559700>, <-0.421344,-0.296601,0.857028>
}
   smooth_triangle{ <43.886101,-90.721802,-30.464500>, <0.440365,0.319689,-0.838975>
 <44.419601,-91.727303,-30.559700>, <0.421344,0.296601,-0.857028>
 <43.462101,-90.731003,-30.685699>, <0.428266,0.304495,-0.850806>
}
   smooth_triangle{ <43.462101,-90.731003,-30.685699>, <-0.428266,-0.304495,0.850806>
 <44.153000,-91.736099,-30.689400>, <-0.416347,-0.288385,0.862258>
 <44.419601,-91.727303,-30.559700>, <-0.421344,-0.296601,0.857028>
}
   smooth_triangle{ <43.462101,-90.731003,-30.685699>, <0.428266,0.304495,-0.850806>
 <44.419601,-91.727303,-30.559700>, <0.421344,0.296601,-0.857028>
 <44.153000,-91.736099,-30.689400>, <0.451315,0.340505,-0.824846>
}
   smooth_triangle{ <43.462101,-90.731003,-30.685699>, <-0.428266,-0.304495,0.850806>
 <42.933701,-90.745003,-30.953400>, <-0.427523,-0.300110,0.852735>
 <44.153000,-91.736099,-30.689400>, <-0.416347,-0.288385,0.862258>
}
   smooth_triangle{ <43.462101,-90.731003,-30.685699>, <0.428266,0.304495,-0.850806>
 <44.153000,-91.736099,-30.689400>, <0.451315,0.340505,-0.824846>
 <42.933701,-90.745003,-30.953400>, <0.462899,0.352622,-0.813255>
}
   smooth_triangle{ <42.933701,-90.745003,-30.953400>, <0.462899,0.352622,-0.813255>
 <44.378399,-91.739899,-30.543501>, <0.494812,0.406713,-0.767949>
 <44.153000,-91.736099,-30.689400>, <0.451315,0.340505,-0.824846>
}
   smooth_triangle{ <42.933701,-90.745003,-30.953400>, <0.462899,0.352622,-0.813255>
 <43.387501,-90.750702,-30.666599>, <0.490459,0.392732,-0.777953>
 <44.378399,-91.739899,-30.543501>, <0.494812,0.406713,-0.767949>
}
   smooth_triangle{ <43.387501,-90.750702,-30.666599>, <0.490459,0.392732,-0.777953>
 <44.583900,-91.742302,-30.414200>, <0.484111,0.393854,-0.781355>
 <44.378399,-91.739899,-30.543501>, <0.494812,0.406713,-0.767949>
}
   smooth_triangle{ <43.387501,-90.750702,-30.666599>, <0.490459,0.392732,-0.777953>
 <43.800400,-90.753899,-30.411600>, <0.480950,0.380805,-0.789731>
 <44.583900,-91.742302,-30.414200>, <0.484111,0.393854,-0.781355>
}
   smooth_triangle{ <43.800400,-90.753899,-30.411600>, <0.480950,0.380805,-0.789731>
 <44.782799,-91.742897,-30.294500>, <0.468215,0.382119,-0.796718>
 <44.583900,-91.742302,-30.414200>, <0.484111,0.393854,-0.781355>
}
   smooth_triangle{ <43.800400,-90.753899,-30.411600>, <0.480950,0.380805,-0.789731>
 <44.199200,-90.754501,-30.173800>, <0.467402,0.371085,-0.802391>
 <44.782799,-91.742897,-30.294500>, <0.468215,0.382119,-0.796718>
}
   smooth_triangle{ <44.199200,-90.754501,-30.173800>, <0.467402,0.371085,-0.802391>
 <44.988499,-91.741600,-30.177099>, <0.450609,0.375186,-0.810054>
 <44.782799,-91.742897,-30.294500>, <0.468215,0.382119,-0.796718>
}
   smooth_triangle{ <44.199200,-90.754501,-30.173800>, <0.467402,0.371085,-0.802391>
 <44.610199,-90.751999,-29.938400>, <0.452846,0.366251,-0.812890>
 <44.988499,-91.741600,-30.177099>, <0.450609,0.375186,-0.810054>
}
   smooth_triangle{ <44.610199,-90.751999,-29.938400>, <0.452846,0.366251,-0.812890>
 <45.220200,-91.738098,-30.050800>, <0.435333,0.374160,-0.818834>
 <44.988499,-91.741600,-30.177099>, <0.450609,0.375186,-0.810054>
}
   smooth_triangle{ <44.610199,-90.751999,-29.938400>, <0.452846,0.366251,-0.812890>
 <45.072201,-90.746300,-29.683201>, <0.440369,0.366815,-0.819464>
 <45.220200,-91.738098,-30.050800>, <0.435333,0.374160,-0.818834>
}
   smooth_triangle{ <45.072201,-90.746300,-29.683201>, <0.440369,0.366815,-0.819464>
 <45.463902,-91.733200,-29.922400>, <0.422145,0.377916,-0.823998>
 <45.220200,-91.738098,-30.050800>, <0.435333,0.374160,-0.818834>
}
   smooth_triangle{ <45.072201,-90.746300,-29.683201>, <0.440369,0.366815,-0.819464>
 <45.557098,-90.738197,-29.422199>, <0.429118,0.371744,-0.823203>
 <45.463902,-91.733200,-29.922400>, <0.422145,0.377916,-0.823998>
}
   smooth_triangle{ <45.557098,-90.738197,-29.422199>, <0.429118,0.371744,-0.823203>
 <45.689701,-91.727402,-29.807301>, <0.405266,0.386841,-0.828319>
 <45.463902,-91.733200,-29.922400>, <0.422145,0.377916,-0.823998>
}
   smooth_triangle{ <45.557098,-90.738197,-29.422199>, <0.429118,0.371744,-0.823203>
 <46.005798,-90.728798,-29.186800>, <0.414051,0.381516,-0.826442>
 <45.689701,-91.727402,-29.807301>, <0.405266,0.386841,-0.828319>
}
   smooth_triangle{ <46.005798,-90.728798,-29.186800>, <0.414051,0.381516,-0.826442>
 <45.867901,-91.721497,-29.721100>, <0.454542,0.355420,-0.816743>
 <45.689701,-91.727402,-29.807301>, <0.405266,0.386841,-0.828319>
}
   smooth_triangle{ <46.005798,-90.728798,-29.186800>, <0.414051,0.381516,-0.826442>
 <46.358799,-90.719200,-29.008699>, <0.470789,0.346234,-0.811468>
 <45.867901,-91.721497,-29.721100>, <0.454542,0.355420,-0.816743>
}
   smooth_triangle{ <45.867901,-91.721497,-29.721100>, <-0.539373,-0.295051,0.788684>
 <45.707100,-91.717300,-29.829500>, <-0.519591,-0.309035,0.796569>
 <45.375702,-92.724701,-30.431299>, <-0.467945,-0.309694,0.827718>
}
   smooth_triangle{ <45.867901,-91.721497,-29.721100>, <0.454542,0.355420,-0.816743>
 <45.375702,-92.724701,-30.431299>, <0.458414,0.352914,-0.815664>
 <45.707100,-91.717300,-29.829500>, <0.519591,0.309035,-0.796569>
}
   smooth_triangle{ <45.707100,-91.717300,-29.829500>, <-0.519591,-0.309035,0.796569>
 <45.490799,-91.715797,-29.962500>, <-0.489160,-0.326622,0.808728>
 <45.375702,-92.724701,-30.431299>, <-0.467945,-0.309694,0.827718>
}
   smooth_triangle{ <45.707100,-91.717300,-29.829500>, <0.519591,0.309035,-0.796569>
 <45.375702,-92.724701,-30.431299>, <0.458414,0.352914,-0.815664>
 <45.490799,-91.715797,-29.962500>, <0.489160,0.326622,-0.808728>
}
   smooth_triangle{ <45.490799,-91.715797,-29.962500>, <-0.489160,-0.326622,0.808728>
 <45.251701,-91.715897,-30.103701>, <-0.476638,-0.330837,0.814471>
 <45.375702,-92.724701,-30.431299>, <-0.467945,-0.309694,0.827718>
}
   smooth_triangle{ <45.490799,-91.715797,-29.962500>, <0.489160,0.326622,-0.808728>
 <45.375702,-92.724701,-30.431299>, <0.458414,0.352914,-0.815664>
 <45.251701,-91.715897,-30.103701>, <0.476638,0.330837,-0.814471>
}
   smooth_triangle{ <45.251701,-91.715897,-30.103701>, <-0.476638,-0.330837,0.814471>
 <45.022800,-91.716797,-30.236601>, <-0.469000,-0.330498,0.819030>
 <45.375702,-92.724701,-30.431299>, <-0.467945,-0.309694,0.827718>
}
   smooth_triangle{ <45.251701,-91.715897,-30.103701>, <0.476638,0.330837,-0.814471>
 <45.375702,-92.724701,-30.431299>, <0.458414,0.352914,-0.815664>
 <45.022800,-91.716797,-30.236601>, <0.469000,0.330498,-0.819030>
}
   smooth_triangle{ <45.022800,-91.716797,-30.236601>, <-0.469000,-0.330498,0.819030>
 <44.824001,-91.718300,-30.349199>, <-0.455967,-0.325260,0.828432>
 <45.375702,-92.724701,-30.431299>, <-0.467945,-0.309694,0.827718>
}
   smooth_triangle{ <45.022800,-91.716797,-30.236601>, <0.469000,0.330498,-0.819030>
 <45.375702,-92.724701,-30.431299>, <0.458414,0.352914,-0.815664>
 <44.824001,-91.718300,-30.349199>, <0.455967,0.325260,-0.828432>
}
   smooth_triangle{ <44.824001,-91.718300,-30.349199>, <-0.455967,-0.325260,0.828432>
 <44.633099,-91.721603,-30.451599>, <-0.437252,-0.312819,0.843181>
 <45.375702,-92.724701,-30.431299>, <-0.467945,-0.309694,0.827718>
}
   smooth_triangle{ <44.824001,-91.718300,-30.349199>, <0.455967,0.325260,-0.828432>
 <45.375702,-92.724701,-30.431299>, <0.458414,0.352914,-0.815664>
 <44.633099,-91.721603,-30.451599>, <0.437252,0.312819,-0.843181>
}
   smooth_triangle{ <44.633099,-91.721603,-30.451599>, <-0.437252,-0.312819,0.843181>
 <44.419601,-91.727303,-30.559700>, <-0.421344,-0.296601,0.857028>
 <45.375702,-92.724701,-30.431299>, <-0.467945,-0.309694,0.827718>
}
   smooth_triangle{ <44.633099,-91.721603,-30.451599>, <0.437252,0.312819,-0.843181>
 <45.375702,-92.724701,-30.431299>, <0.458414,0.352914,-0.815664>
 <44.419601,-91.727303,-30.559700>, <0.421344,0.296601,-0.857028>
}
   smooth_triangle{ <44.419601,-91.727303,-30.559700>, <-0.421344,-0.296601,0.857028>
 <44.153000,-91.736099,-30.689400>, <-0.416347,-0.288385,0.862258>
 <45.375702,-92.724701,-30.431299>, <-0.467945,-0.309694,0.827718>
}
   smooth_triangle{ <44.419601,-91.727303,-30.559700>, <0.421344,0.296601,-0.857028>
 <45.375702,-92.724701,-30.431299>, <0.458414,0.352914,-0.815664>
 <44.153000,-91.736099,-30.689400>, <0.451315,0.340505,-0.824846>
}
   smooth_triangle{ <44.153000,-91.736099,-30.689400>, <0.451315,0.340505,-0.824846>
 <44.378399,-91.739899,-30.543501>, <0.494812,0.406713,-0.767949>
 <45.375702,-92.724701,-30.431299>, <0.458414,0.352914,-0.815664>
}
   smooth_triangle{ <44.378399,-91.739899,-30.543501>, <0.494812,0.406713,-0.767949>
 <44.583900,-91.742302,-30.414200>, <0.484111,0.393854,-0.781355>
 <45.375702,-92.724701,-30.431299>, <0.458414,0.352914,-0.815664>
}
   smooth_triangle{ <44.583900,-91.742302,-30.414200>, <0.484111,0.393854,-0.781355>
 <44.782799,-91.742897,-30.294500>, <0.468215,0.382119,-0.796718>
 <45.375702,-92.724701,-30.431299>, <0.458414,0.352914,-0.815664>
}
   smooth_triangle{ <44.782799,-91.742897,-30.294500>, <0.468215,0.382119,-0.796718>
 <44.988499,-91.741600,-30.177099>, <0.450609,0.375186,-0.810054>
 <45.375702,-92.724701,-30.431299>, <0.458414,0.352914,-0.815664>
}
   smooth_triangle{ <44.988499,-91.741600,-30.177099>, <0.450609,0.375186,-0.810054>
 <45.220200,-91.738098,-30.050800>, <0.435333,0.374160,-0.818834>
 <45.375702,-92.724701,-30.431299>, <0.458414,0.352914,-0.815664>
}
   smooth_triangle{ <45.220200,-91.738098,-30.050800>, <0.435333,0.374160,-0.818834>
 <45.463902,-91.733200,-29.922400>, <0.422145,0.377916,-0.823998>
 <45.375702,-92.724701,-30.431299>, <0.458414,0.352914,-0.815664>
}
   smooth_triangle{ <45.463902,-91.733200,-29.922400>, <0.422145,0.377916,-0.823998>
 <45.689701,-91.727402,-29.807301>, <0.405266,0.386841,-0.828319>
 <45.375702,-92.724701,-30.431299>, <0.458414,0.352914,-0.815664>
}
   smooth_triangle{ <45.689701,-91.727402,-29.807301>, <0.405266,0.386841,-0.828319>
 <45.867901,-91.721497,-29.721100>, <0.454542,0.355420,-0.816743>
 <45.375702,-92.724701,-30.431299>, <0.458414,0.352914,-0.815664>
}
}
texture
      { pigment{bozo colour_map{[0.2 red 0.74 green 0.74 blue 0.75][0.8 red 0.4 green 0.4 blue 0.5]}
     scale 4.5
}
      }
      finish
     {ambient 0.4 diffuse 0.5
     specular 0.2 roughness 0.1}
     }
//  Object: prednje krilo lal2
object
{   union{
   smooth_triangle{ <46.678699,-68.087402,-19.298201>, <0.490521,0.300473,-0.817988>
 <45.697800,-67.671402,-19.755600>, <0.501750,0.304209,-0.809756>
 <46.340302,-67.680801,-19.344999>, <0.479348,0.313363,-0.819774>
}
   smooth_triangle{ <46.678699,-68.087402,-19.298201>, <0.490521,0.300473,-0.817988>
 <46.001598,-68.083504,-19.711599>, <0.496780,0.271473,-0.824325>
 <45.697800,-67.671402,-19.755600>, <0.501750,0.304209,-0.809756>
}
   smooth_triangle{ <46.001598,-68.083504,-19.711599>, <0.496780,0.271473,-0.824325>
 <44.841499,-67.668602,-20.271601>, <0.490248,0.277738,-0.826147>
 <45.697800,-67.671402,-19.755600>, <0.501750,0.304209,-0.809756>
}
   smooth_triangle{ <46.001598,-68.083504,-19.711599>, <0.496780,0.271473,-0.824325>
 <45.105900,-68.083603,-20.241800>, <0.490394,0.250227,-0.834805>
 <44.841499,-67.668602,-20.271601>, <0.490248,0.277738,-0.826147>
}
   smooth_triangle{ <45.105900,-68.083603,-20.241800>, <0.490394,0.250227,-0.834805>
 <43.899101,-67.669998,-20.825199>, <0.484960,0.268445,-0.832317>
 <44.841499,-67.668602,-20.271601>, <0.490248,0.277738,-0.826147>
}
   smooth_triangle{ <45.105900,-68.083603,-20.241800>, <0.490394,0.250227,-0.834805>
 <44.123100,-68.085999,-20.815901>, <0.487319,0.243541,-0.838575>
 <43.899101,-67.669998,-20.825199>, <0.484960,0.268445,-0.832317>
}
   smooth_triangle{ <44.123100,-68.085999,-20.815901>, <0.487319,0.243541,-0.838575>
 <42.998001,-67.673103,-21.348801>, <0.480273,0.266573,-0.835630>
 <43.899101,-67.669998,-20.825199>, <0.484960,0.268445,-0.832317>
}
   smooth_triangle{ <44.123100,-68.085999,-20.815901>, <0.487319,0.243541,-0.838575>
 <43.184898,-68.089302,-21.360901>, <0.483674,0.243831,-0.840599>
 <42.998001,-67.673103,-21.348801>, <0.480273,0.266573,-0.835630>
}
   smooth_triangle{ <43.184898,-68.089302,-21.360901>, <0.483674,0.243831,-0.840599>
 <42.217300,-67.677803,-21.796000>, <0.470131,0.269342,-0.840495>
 <42.998001,-67.673103,-21.348801>, <0.480273,0.266573,-0.835630>
}
   smooth_triangle{ <43.184898,-68.089302,-21.360901>, <0.483674,0.243831,-0.840599>
 <42.373299,-68.093201,-21.828899>, <0.474739,0.252188,-0.843223>
 <42.217300,-67.677803,-21.796000>, <0.470131,0.269342,-0.840495>
}
   smooth_triangle{ <42.373299,-68.093201,-21.828899>, <0.474739,0.252188,-0.843223>
 <41.471298,-67.686699,-22.208900>, <0.455015,0.281866,-0.844697>
 <42.217300,-67.677803,-21.796000>, <0.470131,0.269342,-0.840495>
}
   smooth_triangle{ <42.373299,-68.093201,-21.828899>, <0.474739,0.252188,-0.843223>
 <41.600899,-68.099403,-22.266399>, <0.462040,0.276247,-0.842737>
 <41.471298,-67.686699,-22.208900>, <0.455015,0.281866,-0.844697>
}
   smooth_triangle{ <41.600899,-68.099403,-22.266399>, <0.462040,0.276247,-0.842737>
 <40.641300,-67.701599,-22.652399>, <0.439718,0.309874,-0.842987>
 <41.471298,-67.686699,-22.208900>, <0.455015,0.281866,-0.844697>
}
   smooth_triangle{ <41.600899,-68.099403,-22.266399>, <0.462040,0.276247,-0.842737>
 <40.744999,-68.108803,-22.742599>, <0.447831,0.320947,-0.834530>
 <40.641300,-67.701599,-22.652399>, <0.439718,0.309874,-0.842987>
}
   smooth_triangle{ <40.744999,-68.108803,-22.742599>, <0.447831,0.320947,-0.834530>
 <39.608398,-67.724098,-23.191299>, <0.467190,0.350872,-0.811555>
 <40.641300,-67.701599,-22.652399>, <0.439718,0.309874,-0.842987>
}
   smooth_triangle{ <40.744999,-68.108803,-22.742599>, <0.447831,0.320947,-0.834530>
 <39.682701,-68.122803,-23.326599>, <0.472078,0.372977,-0.798768>
 <39.608398,-67.724098,-23.191299>, <0.467190,0.350872,-0.811555>
}
   smooth_triangle{ <39.682701,-68.122803,-23.326599>, <-0.485097,-0.378772,0.788170>
 <40.505199,-67.732697,-22.632900>, <-0.486254,-0.380386,0.786679>
 <39.608398,-67.724098,-23.191299>, <-0.497354,-0.362550,0.788160>
}
   smooth_triangle{ <39.682701,-68.122803,-23.326599>, <0.472078,0.372977,-0.798768>
 <39.608398,-67.724098,-23.191299>, <0.467190,0.350872,-0.811555>
 <40.505199,-67.732697,-22.632900>, <0.486254,0.380386,-0.786679>
}
   smooth_triangle{ <39.682701,-68.122803,-23.326599>, <-0.485097,-0.378772,0.788170>
 <40.624599,-68.125702,-22.759300>, <-0.473375,-0.404757,0.782360>
 <40.505199,-67.732697,-22.632900>, <-0.486254,-0.380386,0.786679>
}
   smooth_triangle{ <39.682701,-68.122803,-23.326599>, <0.472078,0.372977,-0.798768>
 <40.505199,-67.732697,-22.632900>, <0.486254,0.380386,-0.786679>
 <40.624599,-68.125702,-22.759300>, <0.473375,0.404757,-0.782360>
}
   smooth_triangle{ <40.624599,-68.125702,-22.759300>, <-0.473375,-0.404757,0.782360>
 <41.320301,-67.737503,-22.134701>, <-0.473318,-0.397566,0.786073>
 <40.505199,-67.732697,-22.632900>, <-0.486254,-0.380386,0.786679>
}
   smooth_triangle{ <40.624599,-68.125702,-22.759300>, <0.473375,0.404757,-0.782360>
 <40.505199,-67.732697,-22.632900>, <0.486254,0.380386,-0.786679>
 <41.320301,-67.737503,-22.134701>, <0.473318,0.397566,-0.786073>
}
   smooth_triangle{ <40.624599,-68.125702,-22.759300>, <-0.473375,-0.404757,0.782360>
 <41.478802,-68.126900,-22.249901>, <-0.462251,-0.422790,0.779469>
 <41.320301,-67.737503,-22.134701>, <-0.473318,-0.397566,0.786073>
}
   smooth_triangle{ <40.624599,-68.125702,-22.759300>, <0.473375,0.404757,-0.782360>
 <41.320301,-67.737503,-22.134701>, <0.473318,0.397566,-0.786073>
 <41.478802,-68.126900,-22.249901>, <0.462251,0.422790,-0.779469>
}
   smooth_triangle{ <41.478802,-68.126900,-22.249901>, <-0.462251,-0.422790,0.779469>
 <42.105999,-67.737999,-21.667601>, <-0.460336,-0.402720,0.791143>
 <41.320301,-67.737503,-22.134701>, <-0.473318,-0.397566,0.786073>
}
   smooth_triangle{ <41.478802,-68.126900,-22.249901>, <0.462251,0.422790,-0.779469>
 <41.320301,-67.737503,-22.134701>, <0.473318,0.397566,-0.786073>
 <42.105999,-67.737999,-21.667601>, <0.460336,0.402720,-0.791143>
}
   smooth_triangle{ <41.478802,-68.126900,-22.249901>, <-0.462251,-0.422790,0.779469>
 <42.299198,-68.125801,-21.767599>, <-0.452951,-0.425942,0.783205>
 <42.105999,-67.737999,-21.667601>, <-0.460336,-0.402720,0.791143>
}
   smooth_triangle{ <41.478802,-68.126900,-22.249901>, <0.462251,0.422790,-0.779469>
 <42.105999,-67.737999,-21.667601>, <0.460336,0.402720,-0.791143>
 <42.299198,-68.125801,-21.767599>, <0.452951,0.425942,-0.783205>
}
   smooth_triangle{ <42.299198,-68.125801,-21.767599>, <-0.452951,-0.425942,0.783205>
 <42.914200,-67.733803,-21.202700>, <-0.450134,-0.395567,0.800566>
 <42.105999,-67.737999,-21.667601>, <-0.460336,-0.402720,0.791143>
}
   smooth_triangle{ <42.299198,-68.125801,-21.767599>, <0.452951,0.425942,-0.783205>
 <42.105999,-67.737999,-21.667601>, <0.460336,0.402720,-0.791143>
 <42.914200,-67.733803,-21.202700>, <0.450134,0.395567,-0.800566>
}
   smooth_triangle{ <42.299198,-68.125801,-21.767599>, <-0.452951,-0.425942,0.783205>
 <43.139702,-68.122101,-21.281900>, <-0.447618,-0.414154,0.792537>
 <42.914200,-67.733803,-21.202700>, <-0.450134,-0.395567,0.800566>
}
   smooth_triangle{ <42.299198,-68.125801,-21.767599>, <0.452951,0.425942,-0.783205>
 <42.914200,-67.733803,-21.202700>, <0.450134,0.395567,-0.800566>
 <43.139702,-68.122101,-21.281900>, <0.447618,0.414154,-0.792537>
}
   smooth_triangle{ <43.139702,-68.122101,-21.281900>, <-0.447618,-0.414154,0.792537>
 <43.820999,-67.724503,-20.695999>, <-0.444833,-0.377076,0.812366>
 <42.914200,-67.733803,-21.202700>, <-0.450134,-0.395567,0.800566>
}
   smooth_triangle{ <43.139702,-68.122101,-21.281900>, <0.447618,0.414154,-0.792537>
 <42.914200,-67.733803,-21.202700>, <0.450134,0.395567,-0.800566>
 <43.820999,-67.724503,-20.695999>, <0.444833,0.377076,-0.812366>
}
   smooth_triangle{ <43.139702,-68.122101,-21.281900>, <-0.447618,-0.414154,0.792537>
 <44.079601,-68.115402,-20.746901>, <-0.447211,-0.388894,0.805459>
 <43.820999,-67.724503,-20.695999>, <-0.444833,-0.377076,0.812366>
}
   smooth_triangle{ <43.139702,-68.122101,-21.281900>, <0.447618,0.414154,-0.792537>
 <43.820999,-67.724503,-20.695999>, <0.444833,0.377076,-0.812366>
 <44.079601,-68.115402,-20.746901>, <0.447211,0.388894,-0.805459>
}
   smooth_triangle{ <44.079601,-68.115402,-20.746901>, <-0.447211,-0.388894,0.805459>
 <44.771702,-67.711403,-20.175400>, <-0.442707,-0.348919,0.825994>
 <43.820999,-67.724503,-20.695999>, <-0.444833,-0.377076,0.812366>
}
   smooth_triangle{ <44.079601,-68.115402,-20.746901>, <0.447211,0.388894,-0.805459>
 <43.820999,-67.724503,-20.695999>, <0.444833,0.377076,-0.812366>
 <44.771702,-67.711403,-20.175400>, <0.442707,0.348919,-0.825994>
}
   smooth_triangle{ <44.079601,-68.115402,-20.746901>, <-0.447211,-0.388894,0.805459>
 <45.062801,-68.106697,-20.193001>, <-0.449129,-0.352854,0.820840>
 <44.771702,-67.711403,-20.175400>, <-0.442707,-0.348919,0.825994>
}
   smooth_triangle{ <44.079601,-68.115402,-20.746901>, <0.447211,0.388894,-0.805459>
 <44.771702,-67.711403,-20.175400>, <0.442707,0.348919,-0.825994>
 <45.062801,-68.106697,-20.193001>, <0.449129,0.352854,-0.820840>
}
   smooth_triangle{ <45.062801,-68.106697,-20.193001>, <-0.449129,-0.352854,0.820840>
 <45.650200,-67.696198,-19.704000>, <-0.439390,-0.312198,0.842300>
 <44.771702,-67.711403,-20.175400>, <-0.442707,-0.348919,0.825994>
}
   smooth_triangle{ <45.062801,-68.106697,-20.193001>, <0.449129,0.352854,-0.820840>
 <44.771702,-67.711403,-20.175400>, <0.442707,0.348919,-0.825994>
 <45.650200,-67.696198,-19.704000>, <0.439390,0.312198,-0.842300>
}
   smooth_triangle{ <45.062801,-68.106697,-20.193001>, <-0.449129,-0.352854,0.820840>
 <45.969200,-68.096901,-19.687599>, <-0.449652,-0.308360,0.838288>
 <45.650200,-67.696198,-19.704000>, <-0.439390,-0.312198,0.842300>
}
   smooth_triangle{ <45.062801,-68.106697,-20.193001>, <0.449129,0.352854,-0.820840>
 <45.650200,-67.696198,-19.704000>, <0.439390,0.312198,-0.842300>
 <45.969200,-68.096901,-19.687599>, <0.449652,0.308360,-0.838288>
}
   smooth_triangle{ <45.969200,-68.096901,-19.687599>, <-0.449652,-0.308360,0.838288>
 <46.340302,-67.680801,-19.344999>, <-0.443547,-0.290124,0.847994>
 <45.650200,-67.696198,-19.704000>, <-0.439390,-0.312198,0.842300>
}
   smooth_triangle{ <45.969200,-68.096901,-19.687599>, <0.449652,0.308360,-0.838288>
 <45.650200,-67.696198,-19.704000>, <0.439390,0.312198,-0.842300>
 <46.340302,-67.680801,-19.344999>, <0.479348,0.313363,-0.819774>
}
   smooth_triangle{ <45.969200,-68.096901,-19.687599>, <-0.449652,-0.308360,0.838288>
 <46.678699,-68.087402,-19.298201>, <-0.458319,-0.284527,0.842015>
 <46.340302,-67.680801,-19.344999>, <-0.443547,-0.290124,0.847994>
}
   smooth_triangle{ <45.969200,-68.096901,-19.687599>, <0.449652,0.308360,-0.838288>
 <46.340302,-67.680801,-19.344999>, <0.479348,0.313363,-0.819774>
 <46.678699,-68.087402,-19.298201>, <0.490521,0.300473,-0.817988>
}
   smooth_triangle{ <46.340302,-67.680801,-19.344999>, <0.479348,0.313363,-0.819774>
 <45.388302,-67.263603,-19.789301>, <0.502596,0.341980,-0.794006>
 <46.000301,-67.275398,-19.388901>, <0.473113,0.326110,-0.818423>
}
   smooth_triangle{ <46.340302,-67.680801,-19.344999>, <0.479348,0.313363,-0.819774>
 <45.697800,-67.671402,-19.755600>, <0.501750,0.304209,-0.809756>
 <45.388302,-67.263603,-19.789301>, <0.502596,0.341980,-0.794006>
}
   smooth_triangle{ <45.697800,-67.671402,-19.755600>, <0.501750,0.304209,-0.809756>
 <44.569000,-67.259697,-20.286800>, <0.485672,0.321239,-0.812975>
 <45.388302,-67.263603,-19.789301>, <0.502596,0.341980,-0.794006>
}
   smooth_triangle{ <45.697800,-67.671402,-19.755600>, <0.501750,0.304209,-0.809756>
 <44.841499,-67.668602,-20.271601>, <0.490248,0.277738,-0.826147>
 <44.569000,-67.259697,-20.286800>, <0.485672,0.321239,-0.812975>
}
   smooth_triangle{ <44.841499,-67.668602,-20.271601>, <0.490248,0.277738,-0.826147>
 <43.665600,-67.260902,-20.817900>, <0.478075,0.314217,-0.820190>
 <44.569000,-67.259697,-20.286800>, <0.485672,0.321239,-0.812975>
}
   smooth_triangle{ <44.841499,-67.668602,-20.271601>, <0.490248,0.277738,-0.826147>
 <43.899101,-67.669998,-20.825199>, <0.484960,0.268445,-0.832317>
 <43.665600,-67.260902,-20.817900>, <0.478075,0.314217,-0.820190>
}
   smooth_triangle{ <43.899101,-67.669998,-20.825199>, <0.484960,0.268445,-0.832317>
 <42.801300,-67.264099,-21.319201>, <0.472186,0.312008,-0.824434>
 <43.665600,-67.260902,-20.817900>, <0.478075,0.314217,-0.820190>
}
   smooth_triangle{ <43.899101,-67.669998,-20.825199>, <0.484960,0.268445,-0.832317>
 <42.998001,-67.673103,-21.348801>, <0.480273,0.266573,-0.835630>
 <42.801300,-67.264099,-21.319201>, <0.472186,0.312008,-0.824434>
}
   smooth_triangle{ <42.998001,-67.673103,-21.348801>, <0.480273,0.266573,-0.835630>
 <42.051601,-67.269402,-21.746000>, <0.460330,0.310517,-0.831670>
 <42.801300,-67.264099,-21.319201>, <0.472186,0.312008,-0.824434>
}
   smooth_triangle{ <42.998001,-67.673103,-21.348801>, <0.480273,0.266573,-0.835630>
 <42.217300,-67.677803,-21.796000>, <0.470131,0.269342,-0.840495>
 <42.051601,-67.269402,-21.746000>, <0.460330,0.310517,-0.831670>
}
   smooth_triangle{ <42.217300,-67.677803,-21.796000>, <0.470131,0.269342,-0.840495>
 <41.333698,-67.279900,-22.137300>, <0.443037,0.312249,-0.840368>
 <42.051601,-67.269402,-21.746000>, <0.460330,0.310517,-0.831670>
}
   smooth_triangle{ <42.217300,-67.677803,-21.796000>, <0.470131,0.269342,-0.840495>
 <41.471298,-67.686699,-22.208900>, <0.455015,0.281866,-0.844697>
 <41.333698,-67.279900,-22.137300>, <0.443037,0.312249,-0.840368>
}
   smooth_triangle{ <41.471298,-67.686699,-22.208900>, <0.455015,0.281866,-0.844697>
 <40.533100,-67.297699,-22.554199>, <0.427308,0.321233,-0.845114>
 <41.333698,-67.279900,-22.137300>, <0.443037,0.312249,-0.840368>
}
   smooth_triangle{ <41.471298,-67.686699,-22.208900>, <0.455015,0.281866,-0.844697>
 <40.641300,-67.701599,-22.652399>, <0.439718,0.309874,-0.842987>
 <40.533100,-67.297699,-22.554199>, <0.427308,0.321233,-0.845114>
}
   smooth_triangle{ <40.641300,-67.701599,-22.652399>, <0.439718,0.309874,-0.842987>
 <39.535400,-67.324600,-23.058100>, <0.464621,0.338378,-0.818307>
 <40.533100,-67.297699,-22.554199>, <0.427308,0.321233,-0.845114>
}
   smooth_triangle{ <40.641300,-67.701599,-22.652399>, <0.439718,0.309874,-0.842987>
 <39.608398,-67.724098,-23.191299>, <0.467190,0.350872,-0.811555>
 <39.535400,-67.324600,-23.058100>, <0.464621,0.338378,-0.818307>
}
   smooth_triangle{ <39.608398,-67.724098,-23.191299>, <-0.497354,-0.362550,0.788160>
 <40.391300,-67.335503,-22.516199>, <-0.498414,-0.350622,0.792873>
 <39.535400,-67.324600,-23.058100>, <-0.506464,-0.340359,0.792244>
}
   smooth_triangle{ <39.608398,-67.724098,-23.191299>, <0.467190,0.350872,-0.811555>
 <39.535400,-67.324600,-23.058100>, <0.464621,0.338378,-0.818307>
 <40.391300,-67.335503,-22.516199>, <0.498414,0.350622,-0.792873>
}
   smooth_triangle{ <39.608398,-67.724098,-23.191299>, <-0.497354,-0.362550,0.788160>
 <40.505199,-67.732697,-22.632900>, <-0.486254,-0.380386,0.786679>
 <40.391300,-67.335503,-22.516199>, <-0.498414,-0.350622,0.792873>
}
   smooth_triangle{ <39.608398,-67.724098,-23.191299>, <0.467190,0.350872,-0.811555>
 <40.391300,-67.335503,-22.516199>, <0.498414,0.350622,-0.792873>
 <40.505199,-67.732697,-22.632900>, <0.486254,0.380386,-0.786679>
}
   smooth_triangle{ <40.505199,-67.732697,-22.632900>, <-0.486254,-0.380386,0.786679>
 <41.170399,-67.341797,-22.034401>, <-0.485722,-0.356457,0.798130>
 <40.391300,-67.335503,-22.516199>, <-0.498414,-0.350622,0.792873>
}
   smooth_triangle{ <40.505199,-67.732697,-22.632900>, <0.486254,0.380386,-0.786679>
 <40.391300,-67.335503,-22.516199>, <0.498414,0.350622,-0.792873>
 <41.170399,-67.341797,-22.034401>, <0.485722,0.356457,-0.798130>
}
   smooth_triangle{ <40.505199,-67.732697,-22.632900>, <-0.486254,-0.380386,0.786679>
 <41.320301,-67.737503,-22.134701>, <-0.473318,-0.397566,0.786073>
 <41.170399,-67.341797,-22.034401>, <-0.485722,-0.356457,0.798130>
}
   smooth_triangle{ <40.505199,-67.732697,-22.632900>, <0.486254,0.380386,-0.786679>
 <41.170399,-67.341797,-22.034401>, <0.485722,0.356457,-0.798130>
 <41.320301,-67.737503,-22.134701>, <0.473318,0.397566,-0.786073>
}
   smooth_triangle{ <41.320301,-67.737503,-22.134701>, <-0.473318,-0.397566,0.786073>
 <41.922798,-67.343002,-21.585199>, <-0.470738,-0.356161,0.807190>
 <41.170399,-67.341797,-22.034401>, <-0.485722,-0.356457,0.798130>
}
   smooth_triangle{ <41.320301,-67.737503,-22.134701>, <0.473318,0.397566,-0.786073>
 <41.170399,-67.341797,-22.034401>, <0.485722,0.356457,-0.798130>
 <41.922798,-67.343002,-21.585199>, <0.470738,0.356161,-0.807190>
}
   smooth_triangle{ <41.320301,-67.737503,-22.134701>, <-0.473318,-0.397566,0.786073>
 <42.105999,-67.737999,-21.667601>, <-0.460336,-0.402720,0.791143>
 <41.922798,-67.343002,-21.585199>, <-0.470738,-0.356161,0.807190>
}
   smooth_triangle{ <41.320301,-67.737503,-22.134701>, <0.473318,0.397566,-0.786073>
 <41.922798,-67.343002,-21.585199>, <0.470738,0.356161,-0.807190>
 <42.105999,-67.737999,-21.667601>, <0.460336,0.402720,-0.791143>
}
   smooth_triangle{ <42.105999,-67.737999,-21.667601>, <-0.460336,-0.402720,0.791143>
 <42.698502,-67.338303,-21.141100>, <-0.456758,-0.349774,0.817942>
 <41.922798,-67.343002,-21.585199>, <-0.470738,-0.356161,0.807190>
}
   smooth_triangle{ <42.105999,-67.737999,-21.667601>, <0.460336,0.402720,-0.791143>
 <41.922798,-67.343002,-21.585199>, <0.470738,0.356161,-0.807190>
 <42.698502,-67.338303,-21.141100>, <0.456758,0.349774,-0.817942>
}
   smooth_triangle{ <42.105999,-67.737999,-21.667601>, <-0.460336,-0.402720,0.791143>
 <42.914200,-67.733803,-21.202700>, <-0.450134,-0.395567,0.800566>
 <42.698502,-67.338303,-21.141100>, <-0.456758,-0.349774,0.817942>
}
   smooth_triangle{ <42.105999,-67.737999,-21.667601>, <0.460336,0.402720,-0.791143>
 <42.698502,-67.338303,-21.141100>, <0.456758,0.349774,-0.817942>
 <42.914200,-67.733803,-21.202700>, <0.450134,0.395567,-0.800566>
}
   smooth_triangle{ <42.914200,-67.733803,-21.202700>, <-0.450134,-0.395567,0.800566>
 <43.570599,-67.327301,-20.659901>, <-0.446845,-0.338539,0.828083>
 <42.698502,-67.338303,-21.141100>, <-0.456758,-0.349774,0.817942>
}
   smooth_triangle{ <42.914200,-67.733803,-21.202700>, <0.450134,0.395567,-0.800566>
 <42.698502,-67.338303,-21.141100>, <0.456758,0.349774,-0.817942>
 <43.570599,-67.327301,-20.659901>, <0.446845,0.338539,-0.828083>
}
   smooth_triangle{ <42.914200,-67.733803,-21.202700>, <-0.450134,-0.395567,0.800566>
 <43.820999,-67.724503,-20.695999>, <-0.444833,-0.377076,0.812366>
 <43.570599,-67.327301,-20.659901>, <-0.446845,-0.338539,0.828083>
}
   smooth_triangle{ <42.914200,-67.733803,-21.202700>, <0.450134,0.395567,-0.800566>
 <43.570599,-67.327301,-20.659901>, <0.446845,0.338539,-0.828083>
 <43.820999,-67.724503,-20.695999>, <0.444833,0.377076,-0.812366>
}
   smooth_triangle{ <43.820999,-67.724503,-20.695999>, <-0.444833,-0.377076,0.812366>
 <44.486401,-67.311798,-20.167801>, <-0.439664,-0.323007,0.838070>
 <43.570599,-67.327301,-20.659901>, <-0.446845,-0.338539,0.828083>
}
   smooth_triangle{ <43.820999,-67.724503,-20.695999>, <0.444833,0.377076,-0.812366>
 <43.570599,-67.327301,-20.659901>, <0.446845,0.338539,-0.828083>
 <44.486401,-67.311798,-20.167801>, <0.439664,0.323007,-0.838070>
}
   smooth_triangle{ <43.820999,-67.724503,-20.695999>, <-0.444833,-0.377076,0.812366>
 <44.771702,-67.711403,-20.175400>, <-0.442707,-0.348919,0.825994>
 <44.486401,-67.311798,-20.167801>, <-0.439664,-0.323007,0.838070>
}
   smooth_triangle{ <43.820999,-67.724503,-20.695999>, <0.444833,0.377076,-0.812366>
 <44.486401,-67.311798,-20.167801>, <0.439664,0.323007,-0.838070>
 <44.771702,-67.711403,-20.175400>, <0.442707,0.348919,-0.825994>
}
   smooth_triangle{ <44.771702,-67.711403,-20.175400>, <-0.442707,-0.348919,0.825994>
 <45.333599,-67.293800,-19.724300>, <-0.430798,-0.301693,0.850526>
 <44.486401,-67.311798,-20.167801>, <-0.439664,-0.323007,0.838070>
}
   smooth_triangle{ <44.771702,-67.711403,-20.175400>, <0.442707,0.348919,-0.825994>
 <44.486401,-67.311798,-20.167801>, <0.439664,0.323007,-0.838070>
 <45.333599,-67.293800,-19.724300>, <0.430798,0.301693,-0.850526>
}
   smooth_triangle{ <44.771702,-67.711403,-20.175400>, <-0.442707,-0.348919,0.825994>
 <45.650200,-67.696198,-19.704000>, <-0.439390,-0.312198,0.842300>
 <45.333599,-67.293800,-19.724300>, <-0.430798,-0.301693,0.850526>
}
   smooth_triangle{ <44.771702,-67.711403,-20.175400>, <0.442707,0.348919,-0.825994>
 <45.333599,-67.293800,-19.724300>, <0.430798,0.301693,-0.850526>
 <45.650200,-67.696198,-19.704000>, <0.439390,0.312198,-0.842300>
}
   smooth_triangle{ <45.650200,-67.696198,-19.704000>, <-0.439390,-0.312198,0.842300>
 <46.000301,-67.275398,-19.388901>, <-0.428754,-0.285160,0.857236>
 <45.333599,-67.293800,-19.724300>, <-0.430798,-0.301693,0.850526>
}
   smooth_triangle{ <45.650200,-67.696198,-19.704000>, <0.439390,0.312198,-0.842300>
 <45.333599,-67.293800,-19.724300>, <0.430798,0.301693,-0.850526>
 <46.000301,-67.275398,-19.388901>, <0.473113,0.326110,-0.818423>
}
   smooth_triangle{ <45.650200,-67.696198,-19.704000>, <-0.439390,-0.312198,0.842300>
 <46.340302,-67.680801,-19.344999>, <-0.443547,-0.290124,0.847994>
 <46.000301,-67.275398,-19.388901>, <-0.428754,-0.285160,0.857236>
}
   smooth_triangle{ <45.650200,-67.696198,-19.704000>, <0.439390,0.312198,-0.842300>
 <46.000301,-67.275398,-19.388901>, <0.473113,0.326110,-0.818423>
 <46.340302,-67.680801,-19.344999>, <0.479348,0.313363,-0.819774>
}
   smooth_triangle{ <46.000301,-67.275398,-19.388901>, <0.473113,0.326110,-0.818423>
 <45.069901,-66.862000,-19.807800>, <0.500687,0.362765,-0.785948>
 <45.654900,-66.873703,-19.423700>, <0.469149,0.333063,-0.817905>
}
   smooth_triangle{ <46.000301,-67.275398,-19.388901>, <0.473113,0.326110,-0.818423>
 <45.388302,-67.263603,-19.789301>, <0.502596,0.341980,-0.794006>
 <45.069901,-66.862000,-19.807800>, <0.500687,0.362765,-0.785948>
}
   smooth_triangle{ <45.388302,-67.263603,-19.789301>, <0.502596,0.341980,-0.794006>
 <44.286098,-66.858101,-20.284500>, <0.482025,0.345606,-0.805114>
 <45.069901,-66.862000,-19.807800>, <0.500687,0.362765,-0.785948>
}
   smooth_triangle{ <45.388302,-67.263603,-19.789301>, <0.502596,0.341980,-0.794006>
 <44.569000,-67.259697,-20.286800>, <0.485672,0.321239,-0.812975>
 <44.286098,-66.858101,-20.284500>, <0.482025,0.345606,-0.805114>
}
   smooth_triangle{ <44.569000,-67.259697,-20.286800>, <0.485672,0.321239,-0.812975>
 <43.421700,-66.859100,-20.792999>, <0.473902,0.338561,-0.812892>
 <44.286098,-66.858101,-20.284500>, <0.482025,0.345606,-0.805114>
}
   smooth_triangle{ <44.569000,-67.259697,-20.286800>, <0.485672,0.321239,-0.812975>
 <43.665600,-67.260902,-20.817900>, <0.478075,0.314217,-0.820190>
 <43.421700,-66.859100,-20.792999>, <0.473902,0.338561,-0.812892>
}
   smooth_triangle{ <43.665600,-67.260902,-20.817900>, <0.478075,0.314217,-0.820190>
 <42.594601,-66.862198,-21.272699>, <0.468261,0.333925,-0.818062>
 <43.421700,-66.859100,-20.792999>, <0.473902,0.338561,-0.812892>
}
   smooth_triangle{ <43.665600,-67.260902,-20.817900>, <0.478075,0.314217,-0.820190>
 <42.801300,-67.264099,-21.319201>, <0.472186,0.312008,-0.824434>
 <42.594601,-66.862198,-21.272699>, <0.468261,0.333925,-0.818062>
}
   smooth_triangle{ <42.801300,-67.264099,-21.319201>, <0.472186,0.312008,-0.824434>
 <41.877102,-66.867401,-21.681000>, <0.457353,0.325181,-0.827699>
 <42.594601,-66.862198,-21.272699>, <0.468261,0.333925,-0.818062>
}
   smooth_triangle{ <42.801300,-67.264099,-21.319201>, <0.472186,0.312008,-0.824434>
 <42.051601,-67.269402,-21.746000>, <0.460330,0.310517,-0.831670>
 <41.877102,-66.867401,-21.681000>, <0.457353,0.325181,-0.827699>
}
   smooth_triangle{ <42.051601,-67.269402,-21.746000>, <0.460330,0.310517,-0.831670>
 <41.189800,-66.877701,-22.054899>, <0.441531,0.313779,-0.840591>
 <41.877102,-66.867401,-21.681000>, <0.457353,0.325181,-0.827699>
}
   smooth_triangle{ <42.051601,-67.269402,-21.746000>, <0.460330,0.310517,-0.831670>
 <41.333698,-67.279900,-22.137300>, <0.443037,0.312249,-0.840368>
 <41.189800,-66.877701,-22.054899>, <0.441531,0.313779,-0.840591>
}
   smooth_triangle{ <41.333698,-67.279900,-22.137300>, <0.443037,0.312249,-0.840368>
 <40.423000,-66.895103,-22.452801>, <0.427981,0.304866,-0.850817>
 <41.189800,-66.877701,-22.054899>, <0.441531,0.313779,-0.840591>
}
   smooth_triangle{ <41.333698,-67.279900,-22.137300>, <0.443037,0.312249,-0.840368>
 <40.533100,-67.297699,-22.554199>, <0.427308,0.321233,-0.845114>
 <40.423000,-66.895103,-22.452801>, <0.427981,0.304866,-0.850817>
}
   smooth_triangle{ <40.533100,-67.297699,-22.554199>, <0.427308,0.321233,-0.845114>
 <39.467300,-66.921501,-22.933399>, <0.462903,0.333620,-0.821230>
 <40.423000,-66.895103,-22.452801>, <0.427981,0.304866,-0.850817>
}
   smooth_triangle{ <40.533100,-67.297699,-22.554199>, <0.427308,0.321233,-0.845114>
 <39.535400,-67.324600,-23.058100>, <0.464621,0.338378,-0.818307>
 <39.467300,-66.921501,-22.933399>, <0.462903,0.333620,-0.821230>
}
   smooth_triangle{ <39.535400,-67.324600,-23.058100>, <-0.506464,-0.340359,0.792244>
 <40.285702,-66.932404,-22.413799>, <-0.500792,-0.345924,0.793438>
 <39.467300,-66.921501,-22.933399>, <-0.503674,-0.354858,0.787647>
}
   smooth_triangle{ <39.535400,-67.324600,-23.058100>, <0.464621,0.338378,-0.818307>
 <39.467300,-66.921501,-22.933399>, <0.462903,0.333620,-0.821230>
 <40.285702,-66.932404,-22.413799>, <0.500792,0.345924,-0.793438>
}
   smooth_triangle{ <39.535400,-67.324600,-23.058100>, <-0.506464,-0.340359,0.792244>
 <40.391300,-67.335503,-22.516199>, <-0.498414,-0.350622,0.792873>
 <40.285702,-66.932404,-22.413799>, <-0.500792,-0.345924,0.793438>
}
   smooth_triangle{ <39.535400,-67.324600,-23.058100>, <0.464621,0.338378,-0.818307>
 <40.285702,-66.932404,-22.413799>, <0.500792,0.345924,-0.793438>
 <40.391300,-67.335503,-22.516199>, <0.498414,0.350622,-0.792873>
}
   smooth_triangle{ <40.391300,-67.335503,-22.516199>, <-0.498414,-0.350622,0.792873>
 <41.030899,-66.938698,-21.952000>, <-0.490015,-0.339268,0.802983>
 <40.285702,-66.932404,-22.413799>, <-0.500792,-0.345924,0.793438>
}
   smooth_triangle{ <40.391300,-67.335503,-22.516199>, <0.498414,0.350622,-0.792873>
 <40.285702,-66.932404,-22.413799>, <0.500792,0.345924,-0.793438>
 <41.030899,-66.938698,-21.952000>, <0.490015,0.339268,-0.802983>
}
   smooth_triangle{ <40.391300,-67.335503,-22.516199>, <-0.498414,-0.350622,0.792873>
 <41.170399,-67.341797,-22.034401>, <-0.485722,-0.356457,0.798130>
 <41.030899,-66.938698,-21.952000>, <-0.490015,-0.339268,0.802983>
}
   smooth_triangle{ <40.391300,-67.335503,-22.516199>, <0.498414,0.350622,-0.792873>
 <41.030899,-66.938698,-21.952000>, <0.490015,0.339268,-0.802983>
 <41.170399,-67.341797,-22.034401>, <0.485722,0.356457,-0.798130>
}
   smooth_triangle{ <41.170399,-67.341797,-22.034401>, <-0.485722,-0.356457,0.798130>
 <41.750801,-66.940002,-21.521799>, <-0.476008,-0.330195,0.815100>
 <41.030899,-66.938698,-21.952000>, <-0.490015,-0.339268,0.802983>
}
   smooth_triangle{ <41.170399,-67.341797,-22.034401>, <0.485722,0.356457,-0.798130>
 <41.030899,-66.938698,-21.952000>, <0.490015,0.339268,-0.802983>
 <41.750801,-66.940002,-21.521799>, <0.476008,0.330195,-0.815100>
}
   smooth_triangle{ <41.170399,-67.341797,-22.034401>, <-0.485722,-0.356457,0.798130>
 <41.922798,-67.343002,-21.585199>, <-0.470738,-0.356161,0.807190>
 <41.750801,-66.940002,-21.521799>, <-0.476008,-0.330195,0.815100>
}
   smooth_triangle{ <41.170399,-67.341797,-22.034401>, <0.485722,0.356457,-0.798130>
 <41.750801,-66.940002,-21.521799>, <0.476008,0.330195,-0.815100>
 <41.922798,-67.343002,-21.585199>, <0.470738,0.356161,-0.807190>
}
   smooth_triangle{ <41.922798,-67.343002,-21.585199>, <-0.470738,-0.356161,0.807190>
 <42.493198,-66.935402,-21.096901>, <-0.461674,-0.320648,0.827068>
 <41.750801,-66.940002,-21.521799>, <-0.476008,-0.330195,0.815100>
}
   smooth_triangle{ <41.922798,-67.343002,-21.585199>, <0.470738,0.356161,-0.807190>
 <41.750801,-66.940002,-21.521799>, <0.476008,0.330195,-0.815100>
 <42.493198,-66.935402,-21.096901>, <0.461674,0.320648,-0.827068>
}
   smooth_triangle{ <41.922798,-67.343002,-21.585199>, <-0.470738,-0.356161,0.807190>
 <42.698502,-67.338303,-21.141100>, <-0.456758,-0.349774,0.817942>
 <42.493198,-66.935402,-21.096901>, <-0.461674,-0.320648,0.827068>
}
   smooth_triangle{ <41.922798,-67.343002,-21.585199>, <0.470738,0.356161,-0.807190>
 <42.493198,-66.935402,-21.096901>, <0.461674,0.320648,-0.827068>
 <42.698502,-67.338303,-21.141100>, <0.456758,0.349774,-0.817942>
}
   smooth_triangle{ <42.698502,-67.338303,-21.141100>, <-0.456758,-0.349774,0.817942>
 <43.328201,-66.924698,-20.636999>, <-0.450390,-0.312667,0.836294>
 <42.493198,-66.935402,-21.096901>, <-0.461674,-0.320648,0.827068>
}
   smooth_triangle{ <42.698502,-67.338303,-21.141100>, <0.456758,0.349774,-0.817942>
 <42.493198,-66.935402,-21.096901>, <0.461674,0.320648,-0.827068>
 <43.328201,-66.924698,-20.636999>, <0.450390,0.312667,-0.836294>
}
   smooth_triangle{ <42.698502,-67.338303,-21.141100>, <-0.456758,-0.349774,0.817942>
 <43.570599,-67.327301,-20.659901>, <-0.446845,-0.338539,0.828083>
 <43.328201,-66.924698,-20.636999>, <-0.450390,-0.312667,0.836294>
}
   smooth_triangle{ <42.698502,-67.338303,-21.141100>, <0.456758,0.349774,-0.817942>
 <43.328201,-66.924698,-20.636999>, <0.450390,0.312667,-0.836294>
 <43.570599,-67.327301,-20.659901>, <0.446845,0.338539,-0.828083>
}
   smooth_triangle{ <43.570599,-67.327301,-20.659901>, <-0.446845,-0.338539,0.828083>
 <44.204899,-66.909500,-20.166800>, <-0.441152,-0.305550,0.843815>
 <43.328201,-66.924698,-20.636999>, <-0.450390,-0.312667,0.836294>
}
   smooth_triangle{ <43.570599,-67.327301,-20.659901>, <0.446845,0.338539,-0.828083>
 <43.328201,-66.924698,-20.636999>, <0.450390,0.312667,-0.836294>
 <44.204899,-66.909500,-20.166800>, <0.441152,0.305550,-0.843815>
}
   smooth_triangle{ <43.570599,-67.327301,-20.659901>, <-0.446845,-0.338539,0.828083>
 <44.486401,-67.311798,-20.167801>, <-0.439664,-0.323007,0.838070>
 <44.204899,-66.909500,-20.166800>, <-0.441152,-0.305550,0.843815>
}
   smooth_triangle{ <43.570599,-67.327301,-20.659901>, <0.446845,0.338539,-0.828083>
 <44.204899,-66.909500,-20.166800>, <0.441152,0.305550,-0.843815>
 <44.486401,-67.311798,-20.167801>, <0.439664,0.323007,-0.838070>
}
   smooth_triangle{ <44.486401,-67.311798,-20.167801>, <-0.439664,-0.323007,0.838070>
 <45.016300,-66.891800,-19.743401>, <-0.429735,-0.295836,0.853117>
 <44.204899,-66.909500,-20.166800>, <-0.441152,-0.305550,0.843815>
}
   smooth_triangle{ <44.486401,-67.311798,-20.167801>, <0.439664,0.323007,-0.838070>
 <44.204899,-66.909500,-20.166800>, <0.441152,0.305550,-0.843815>
 <45.016300,-66.891800,-19.743401>, <0.429735,0.295836,-0.853117>
}
   smooth_triangle{ <44.486401,-67.311798,-20.167801>, <-0.439664,-0.323007,0.838070>
 <45.333599,-67.293800,-19.724300>, <-0.430798,-0.301693,0.850526>
 <45.016300,-66.891800,-19.743401>, <-0.429735,-0.295836,0.853117>
}
   smooth_triangle{ <44.486401,-67.311798,-20.167801>, <0.439664,0.323007,-0.838070>
 <45.016300,-66.891800,-19.743401>, <0.429735,0.295836,-0.853117>
 <45.333599,-67.293800,-19.724300>, <0.430798,0.301693,-0.850526>
}
   smooth_triangle{ <45.333599,-67.293800,-19.724300>, <-0.430798,-0.301693,0.850526>
 <45.654900,-66.873703,-19.423700>, <-0.422499,-0.289751,0.858801>
 <45.016300,-66.891800,-19.743401>, <-0.429735,-0.295836,0.853117>
}
   smooth_triangle{ <45.333599,-67.293800,-19.724300>, <0.430798,0.301693,-0.850526>
 <45.016300,-66.891800,-19.743401>, <0.429735,0.295836,-0.853117>
 <45.654900,-66.873703,-19.423700>, <0.469149,0.333063,-0.817905>
}
   smooth_triangle{ <45.333599,-67.293800,-19.724300>, <-0.430798,-0.301693,0.850526>
 <46.000301,-67.275398,-19.388901>, <-0.428754,-0.285160,0.857236>
 <45.654900,-66.873703,-19.423700>, <-0.422499,-0.289751,0.858801>
}
   smooth_triangle{ <45.333599,-67.293800,-19.724300>, <0.430798,0.301693,-0.850526>
 <45.654900,-66.873703,-19.423700>, <0.469149,0.333063,-0.817905>
 <46.000301,-67.275398,-19.388901>, <0.473113,0.326110,-0.818423>
}
   smooth_triangle{ <45.654900,-66.873703,-19.423700>, <0.469149,0.333063,-0.817905>
 <44.311199,-65.998901,-19.891600>, <0.499413,0.361933,-0.787141>
 <44.913300,-66.010101,-19.499300>, <0.468906,0.330101,-0.819244>
}
   smooth_triangle{ <45.654900,-66.873703,-19.423700>, <0.469149,0.333063,-0.817905>
 <45.069901,-66.862000,-19.807800>, <0.500687,0.362765,-0.785948>
 <44.311199,-65.998901,-19.891600>, <0.499413,0.361933,-0.787141>
}
   smooth_triangle{ <45.069901,-66.862000,-19.807800>, <0.500687,0.362765,-0.785948>
 <43.505798,-65.995399,-20.379999>, <0.481441,0.345936,-0.805322>
 <44.311199,-65.998901,-19.891600>, <0.499413,0.361933,-0.787141>
}
   smooth_triangle{ <45.069901,-66.862000,-19.807800>, <0.500687,0.362765,-0.785948>
 <44.286098,-66.858101,-20.284500>, <0.482025,0.345606,-0.805114>
 <43.505798,-65.995399,-20.379999>, <0.481441,0.345936,-0.805322>
}
   smooth_triangle{ <44.286098,-66.858101,-20.284500>, <0.482025,0.345606,-0.805114>
 <42.618000,-65.996597,-20.901699>, <0.473750,0.338695,-0.812925>
 <43.505798,-65.995399,-20.379999>, <0.481441,0.345936,-0.805322>
}
   smooth_triangle{ <44.286098,-66.858101,-20.284500>, <0.482025,0.345606,-0.805114>
 <43.421700,-66.859100,-20.792999>, <0.473902,0.338561,-0.812892>
 <42.618000,-65.996597,-20.901699>, <0.473750,0.338695,-0.812925>
}
   smooth_triangle{ <43.421700,-66.859100,-20.792999>, <0.473902,0.338561,-0.812892>
 <41.768600,-65.999901,-21.394199>, <0.468582,0.333138,-0.818199>
 <42.618000,-65.996597,-20.901699>, <0.473750,0.338695,-0.812925>
}
   smooth_triangle{ <43.421700,-66.859100,-20.792999>, <0.473902,0.338561,-0.812892>
 <42.594601,-66.862198,-21.272699>, <0.468261,0.333925,-0.818062>
 <41.768600,-65.999901,-21.394199>, <0.468582,0.333138,-0.818199>
}
   smooth_triangle{ <42.594601,-66.862198,-21.272699>, <0.468261,0.333925,-0.818062>
 <41.032101,-66.004997,-21.813801>, <0.458929,0.321619,-0.828218>
 <41.768600,-65.999901,-21.394199>, <0.468582,0.333138,-0.818199>
}
   smooth_triangle{ <42.594601,-66.862198,-21.272699>, <0.468261,0.333925,-0.818062>
 <41.877102,-66.867401,-21.681000>, <0.457353,0.325181,-0.827699>
 <41.032101,-66.004997,-21.813801>, <0.458929,0.321619,-0.828218>
}
   smooth_triangle{ <41.877102,-66.867401,-21.681000>, <0.457353,0.325181,-0.827699>
 <40.327000,-66.014999,-22.198900>, <0.445064,0.303717,-0.842421>
 <41.032101,-66.004997,-21.813801>, <0.458929,0.321619,-0.828218>
}
   smooth_triangle{ <41.877102,-66.867401,-21.681000>, <0.457353,0.325181,-0.827699>
 <41.189800,-66.877701,-22.054899>, <0.441531,0.313779,-0.840591>
 <40.327000,-66.014999,-22.198900>, <0.445064,0.303717,-0.842421>
}
   smooth_triangle{ <41.189800,-66.877701,-22.054899>, <0.441531,0.313779,-0.840591>
 <39.541100,-66.031998,-22.609699>, <0.433474,0.286400,-0.854444>
 <40.327000,-66.014999,-22.198900>, <0.445064,0.303717,-0.842421>
}
   smooth_triangle{ <41.189800,-66.877701,-22.054899>, <0.441531,0.313779,-0.840591>
 <40.423000,-66.895103,-22.452801>, <0.427981,0.304866,-0.850817>
 <39.541100,-66.031998,-22.609699>, <0.433474,0.286400,-0.854444>
}
   smooth_triangle{ <40.423000,-66.895103,-22.452801>, <0.427981,0.304866,-0.850817>
 <38.561600,-66.057701,-23.106701>, <0.464791,0.320604,-0.825338>
 <39.541100,-66.031998,-22.609699>, <0.433474,0.286400,-0.854444>
}
   smooth_triangle{ <40.423000,-66.895103,-22.452801>, <0.427981,0.304866,-0.850817>
 <39.467300,-66.921501,-22.933399>, <0.462903,0.333620,-0.821230>
 <38.561600,-66.057701,-23.106701>, <0.464791,0.320604,-0.825338>
}
   smooth_triangle{ <39.467300,-66.921501,-22.933399>, <-0.503674,-0.354858,0.787647>
 <39.403400,-66.067902,-22.575399>, <-0.496953,-0.357991,0.790494>
 <38.561600,-66.057701,-23.106701>, <-0.499587,-0.363037,0.786522>
}
   smooth_triangle{ <39.467300,-66.921501,-22.933399>, <0.462903,0.333620,-0.821230>
 <38.561600,-66.057701,-23.106701>, <0.464791,0.320604,-0.825338>
 <39.403400,-66.067902,-22.575399>, <0.496953,0.357991,-0.790494>
}
   smooth_triangle{ <39.467300,-66.921501,-22.933399>, <-0.503674,-0.354858,0.787647>
 <40.285702,-66.932404,-22.413799>, <-0.500792,-0.345924,0.793438>
 <39.403400,-66.067902,-22.575399>, <-0.496953,-0.357991,0.790494>
}
   smooth_triangle{ <39.467300,-66.921501,-22.933399>, <0.462903,0.333620,-0.821230>
 <39.403400,-66.067902,-22.575399>, <0.496953,0.357991,-0.790494>
 <40.285702,-66.932404,-22.413799>, <0.500792,0.345924,-0.793438>
}
   smooth_triangle{ <40.285702,-66.932404,-22.413799>, <-0.500792,-0.345924,0.793438>
 <40.169399,-66.073799,-22.102800>, <-0.488089,-0.344837,0.801783>
 <39.403400,-66.067902,-22.575399>, <-0.496953,-0.357991,0.790494>
}
   smooth_triangle{ <40.285702,-66.932404,-22.413799>, <0.500792,0.345924,-0.793438>
 <39.403400,-66.067902,-22.575399>, <0.496953,0.357991,-0.790494>
 <40.169399,-66.073799,-22.102800>, <0.488089,0.344837,-0.801783>
}
   smooth_triangle{ <40.285702,-66.932404,-22.413799>, <-0.500792,-0.345924,0.793438>
 <41.030899,-66.938698,-21.952000>, <-0.490015,-0.339268,0.802983>
 <40.169399,-66.073799,-22.102800>, <-0.488089,-0.344837,0.801783>
}
   smooth_triangle{ <40.285702,-66.932404,-22.413799>, <0.500792,0.345924,-0.793438>
 <40.169399,-66.073799,-22.102800>, <0.488089,0.344837,-0.801783>
 <41.030899,-66.938698,-21.952000>, <0.490015,0.339268,-0.802983>
}
   smooth_triangle{ <41.030899,-66.938698,-21.952000>, <-0.490015,-0.339268,0.802983>
 <40.909000,-66.074699,-21.661800>, <-0.476014,-0.329724,0.815287>
 <40.169399,-66.073799,-22.102800>, <-0.488089,-0.344837,0.801783>
}
   smooth_triangle{ <41.030899,-66.938698,-21.952000>, <0.490015,0.339268,-0.802983>
 <40.169399,-66.073799,-22.102800>, <0.488089,0.344837,-0.801783>
 <40.909000,-66.074699,-21.661800>, <0.476014,0.329724,-0.815287>
}
   smooth_triangle{ <41.030899,-66.938698,-21.952000>, <-0.490015,-0.339268,0.802983>
 <41.750801,-66.940002,-21.521799>, <-0.476008,-0.330195,0.815100>
 <40.909000,-66.074699,-21.661800>, <-0.476014,-0.329724,0.815287>
}
   smooth_triangle{ <41.030899,-66.938698,-21.952000>, <0.490015,0.339268,-0.802983>
 <40.909000,-66.074699,-21.661800>, <0.476014,0.329724,-0.815287>
 <41.750801,-66.940002,-21.521799>, <0.476008,0.330195,-0.815100>
}
   smooth_triangle{ <41.750801,-66.940002,-21.521799>, <-0.476008,-0.330195,0.815100>
 <41.671200,-66.070198,-21.225201>, <-0.463274,-0.315878,0.828009>
 <40.909000,-66.074699,-21.661800>, <-0.476014,-0.329724,0.815287>
}
   smooth_triangle{ <41.750801,-66.940002,-21.521799>, <0.476008,0.330195,-0.815100>
 <40.909000,-66.074699,-21.661800>, <0.476014,0.329724,-0.815287>
 <41.671200,-66.070198,-21.225201>, <0.463274,0.315878,-0.828009>
}
   smooth_triangle{ <41.750801,-66.940002,-21.521799>, <-0.476008,-0.330195,0.815100>
 <42.493198,-66.935402,-21.096901>, <-0.461674,-0.320648,0.827068>
 <41.671200,-66.070198,-21.225201>, <-0.463274,-0.315878,0.828009>
}
   smooth_triangle{ <41.750801,-66.940002,-21.521799>, <0.476008,0.330195,-0.815100>
 <41.671200,-66.070198,-21.225201>, <0.463274,0.315878,-0.828009>
 <42.493198,-66.935402,-21.096901>, <0.461674,0.320648,-0.827068>
}
   smooth_triangle{ <42.493198,-66.935402,-21.096901>, <-0.461674,-0.320648,0.827068>
 <42.527802,-66.059700,-20.751801>, <-0.452747,-0.306411,0.837337>
 <41.671200,-66.070198,-21.225201>, <-0.463274,-0.315878,0.828009>
}
   smooth_triangle{ <42.493198,-66.935402,-21.096901>, <0.461674,0.320648,-0.827068>
 <41.671200,-66.070198,-21.225201>, <0.463274,0.315878,-0.828009>
 <42.527802,-66.059700,-20.751801>, <0.452747,0.306411,-0.837337>
}
   smooth_triangle{ <42.493198,-66.935402,-21.096901>, <-0.461674,-0.320648,0.827068>
 <43.328201,-66.924698,-20.636999>, <-0.450390,-0.312667,0.836294>
 <42.527802,-66.059700,-20.751801>, <-0.452747,-0.306411,0.837337>
}
   smooth_triangle{ <42.493198,-66.935402,-21.096901>, <0.461674,0.320648,-0.827068>
 <42.527802,-66.059700,-20.751801>, <0.452747,0.306411,-0.837337>
 <43.328201,-66.924698,-20.636999>, <0.450390,0.312667,-0.836294>
}
   smooth_triangle{ <43.328201,-66.924698,-20.636999>, <-0.450390,-0.312667,0.836294>
 <43.426998,-66.044800,-20.267200>, <-0.443893,-0.300157,0.844313>
 <42.527802,-66.059700,-20.751801>, <-0.452747,-0.306411,0.837337>
}
   smooth_triangle{ <43.328201,-66.924698,-20.636999>, <0.450390,0.312667,-0.836294>
 <42.527802,-66.059700,-20.751801>, <0.452747,0.306411,-0.837337>
 <43.426998,-66.044800,-20.267200>, <0.443893,0.300157,-0.844313>
}
   smooth_triangle{ <43.328201,-66.924698,-20.636999>, <-0.450390,-0.312667,0.836294>
 <44.204899,-66.909500,-20.166800>, <-0.441152,-0.305550,0.843815>
 <43.426998,-66.044800,-20.267200>, <-0.443893,-0.300157,0.844313>
}
   smooth_triangle{ <43.328201,-66.924698,-20.636999>, <0.450390,0.312667,-0.836294>
 <43.426998,-66.044800,-20.267200>, <0.443893,0.300157,-0.844313>
 <44.204899,-66.909500,-20.166800>, <0.441152,0.305550,-0.843815>
}
   smooth_triangle{ <44.204899,-66.909500,-20.166800>, <-0.441152,-0.305550,0.843815>
 <44.258900,-66.027603,-19.830200>, <-0.432809,-0.292764,0.852623>
 <43.426998,-66.044800,-20.267200>, <-0.443893,-0.300157,0.844313>
}
   smooth_triangle{ <44.204899,-66.909500,-20.166800>, <0.441152,0.305550,-0.843815>
 <43.426998,-66.044800,-20.267200>, <0.443893,0.300157,-0.844313>
 <44.258900,-66.027603,-19.830200>, <0.432809,0.292764,-0.852623>
}
   smooth_triangle{ <44.204899,-66.909500,-20.166800>, <-0.441152,-0.305550,0.843815>
 <45.016300,-66.891800,-19.743401>, <-0.429735,-0.295836,0.853117>
 <44.258900,-66.027603,-19.830200>, <-0.432809,-0.292764,0.852623>
}
   smooth_triangle{ <44.204899,-66.909500,-20.166800>, <0.441152,0.305550,-0.843815>
 <44.258900,-66.027603,-19.830200>, <0.432809,0.292764,-0.852623>
 <45.016300,-66.891800,-19.743401>, <0.429735,0.295836,-0.853117>
}
   smooth_triangle{ <45.016300,-66.891800,-19.743401>, <-0.429735,-0.295836,0.853117>
 <44.913300,-66.010101,-19.499300>, <-0.424736,-0.287821,0.858346>
 <44.258900,-66.027603,-19.830200>, <-0.432809,-0.292764,0.852623>
}
   smooth_triangle{ <45.016300,-66.891800,-19.743401>, <0.429735,0.295836,-0.853117>
 <44.258900,-66.027603,-19.830200>, <0.432809,0.292764,-0.852623>
 <44.913300,-66.010101,-19.499300>, <0.468906,0.330101,-0.819244>
}
   smooth_triangle{ <45.016300,-66.891800,-19.743401>, <-0.429735,-0.295836,0.853117>
 <45.654900,-66.873703,-19.423700>, <-0.422499,-0.289751,0.858801>
 <44.913300,-66.010101,-19.499300>, <-0.424736,-0.287821,0.858346>
}
   smooth_triangle{ <45.016300,-66.891800,-19.743401>, <0.429735,0.295836,-0.853117>
 <44.913300,-66.010101,-19.499300>, <0.468906,0.330101,-0.819244>
 <45.654900,-66.873703,-19.423700>, <0.469149,0.333063,-0.817905>
}
   smooth_triangle{ <44.913300,-66.010101,-19.499300>, <0.468906,0.330101,-0.819244>
 <43.552898,-65.135597,-19.976101>, <0.497424,0.359132,-0.789680>
 <44.172298,-65.145897,-19.576200>, <0.469045,0.328893,-0.819650>
}
   smooth_triangle{ <44.913300,-66.010101,-19.499300>, <0.468906,0.330101,-0.819244>
 <44.311199,-65.998901,-19.891600>, <0.499413,0.361933,-0.787141>
 <43.552898,-65.135597,-19.976101>, <0.497424,0.359132,-0.789680>
}
   smooth_triangle{ <44.311199,-65.998901,-19.891600>, <0.499413,0.361933,-0.787141>
 <42.725700,-65.132500,-20.475800>, <0.480721,0.344747,-0.806261>
 <43.552898,-65.135597,-19.976101>, <0.497424,0.359132,-0.789680>
}
   smooth_triangle{ <44.311199,-65.998901,-19.891600>, <0.499413,0.361933,-0.787141>
 <43.505798,-65.995399,-20.379999>, <0.481441,0.345936,-0.805322>
 <42.725700,-65.132500,-20.475800>, <0.480721,0.344747,-0.806261>
}
   smooth_triangle{ <43.505798,-65.995399,-20.379999>, <0.481441,0.345936,-0.805322>
 <41.814400,-65.134003,-21.010700>, <0.473600,0.338255,-0.813196>
 <42.725700,-65.132500,-20.475800>, <0.480721,0.344747,-0.806261>
}
   smooth_triangle{ <43.505798,-65.995399,-20.379999>, <0.481441,0.345936,-0.805322>
 <42.618000,-65.996597,-20.901699>, <0.473750,0.338695,-0.812925>
 <41.814400,-65.134003,-21.010700>, <0.473600,0.338255,-0.813196>
}
   smooth_triangle{ <42.618000,-65.996597,-20.901699>, <0.473750,0.338695,-0.812925>
 <40.942902,-65.137299,-21.516100>, <0.468818,0.333107,-0.818077>
 <41.814400,-65.134003,-21.010700>, <0.473600,0.338255,-0.813196>
}
   smooth_triangle{ <42.618000,-65.996597,-20.901699>, <0.473750,0.338695,-0.812925>
 <41.768600,-65.999901,-21.394199>, <0.468582,0.333138,-0.818199>
 <40.942902,-65.137299,-21.516100>, <0.468818,0.333107,-0.818077>
}
   smooth_triangle{ <41.768600,-65.999901,-21.394199>, <0.468582,0.333138,-0.818199>
 <40.187302,-65.142403,-21.947001>, <0.459939,0.322314,-0.827387>
 <40.942902,-65.137299,-21.516100>, <0.468818,0.333107,-0.818077>
}
   smooth_triangle{ <41.768600,-65.999901,-21.394199>, <0.468582,0.333138,-0.818199>
 <41.032101,-66.004997,-21.813801>, <0.458929,0.321619,-0.828218>
 <40.187302,-65.142403,-21.947001>, <0.459939,0.322314,-0.827387>
}
   smooth_triangle{ <41.032101,-66.004997,-21.813801>, <0.458929,0.321619,-0.828218>
 <39.464600,-65.152100,-22.343500>, <0.447238,0.305497,-0.840624>
 <40.187302,-65.142403,-21.947001>, <0.459939,0.322314,-0.827387>
}
   smooth_triangle{ <41.032101,-66.004997,-21.813801>, <0.458929,0.321619,-0.828218>
 <40.327000,-66.014999,-22.198900>, <0.445064,0.303717,-0.842421>
 <39.464600,-65.152100,-22.343500>, <0.447238,0.305497,-0.840624>
}
   smooth_triangle{ <40.327000,-66.014999,-22.198900>, <0.445064,0.303717,-0.842421>
 <38.659599,-65.168404,-22.767700>, <0.436691,0.288892,-0.851964>
 <39.464600,-65.152100,-22.343500>, <0.447238,0.305497,-0.840624>
}
   smooth_triangle{ <40.327000,-66.014999,-22.198900>, <0.445064,0.303717,-0.842421>
 <39.541100,-66.031998,-22.609699>, <0.433474,0.286400,-0.854444>
 <38.659599,-65.168404,-22.767700>, <0.436691,0.288892,-0.851964>
}
   smooth_triangle{ <39.541100,-66.031998,-22.609699>, <0.433474,0.286400,-0.854444>
 <37.656898,-65.193100,-23.281900>, <0.465515,0.319184,-0.825480>
 <38.659599,-65.168404,-22.767700>, <0.436691,0.288892,-0.851964>
}
   smooth_triangle{ <39.541100,-66.031998,-22.609699>, <0.433474,0.286400,-0.854444>
 <38.561600,-66.057701,-23.106701>, <0.464791,0.320604,-0.825338>
 <37.656898,-65.193100,-23.281900>, <0.465515,0.319184,-0.825480>
}
   smooth_triangle{ <38.561600,-66.057701,-23.106701>, <-0.499587,-0.363037,0.786522>
 <38.522202,-65.202499,-22.739300>, <-0.495569,-0.353251,0.793489>
 <37.656898,-65.193100,-23.281900>, <-0.497828,-0.358265,0.789819>
}
   smooth_triangle{ <38.561600,-66.057701,-23.106701>, <0.464791,0.320604,-0.825338>
 <37.656898,-65.193100,-23.281900>, <0.465515,0.319184,-0.825480>
 <38.522202,-65.202499,-22.739300>, <0.495569,0.353251,-0.793489>
}
   smooth_triangle{ <38.561600,-66.057701,-23.106701>, <-0.499587,-0.363037,0.786522>
 <39.403400,-66.067902,-22.575399>, <-0.496953,-0.357991,0.790494>
 <38.522202,-65.202499,-22.739300>, <-0.495569,-0.353251,0.793489>
}
   smooth_triangle{ <38.561600,-66.057701,-23.106701>, <0.464791,0.320604,-0.825338>
 <38.522202,-65.202499,-22.739300>, <0.495569,0.353251,-0.793489>
 <39.403400,-66.067902,-22.575399>, <0.496953,0.357991,-0.790494>
}
   smooth_triangle{ <39.403400,-66.067902,-22.575399>, <-0.496953,-0.357991,0.790494>
 <39.309299,-65.207802,-22.256001>, <-0.487483,-0.340662,0.803934>
 <38.522202,-65.202499,-22.739300>, <-0.495569,-0.353251,0.793489>
}
   smooth_triangle{ <39.403400,-66.067902,-22.575399>, <0.496953,0.357991,-0.790494>
 <38.522202,-65.202499,-22.739300>, <0.495569,0.353251,-0.793489>
 <39.309299,-65.207802,-22.256001>, <0.487483,0.340662,-0.803934>
}
   smooth_triangle{ <39.403400,-66.067902,-22.575399>, <-0.496953,-0.357991,0.790494>
 <40.169399,-66.073799,-22.102800>, <-0.488089,-0.344837,0.801783>
 <39.309299,-65.207802,-22.256001>, <-0.487483,-0.340662,0.803934>
}
   smooth_triangle{ <39.403400,-66.067902,-22.575399>, <0.496953,0.357991,-0.790494>
 <39.309299,-65.207802,-22.256001>, <0.487483,0.340662,-0.803934>
 <40.169399,-66.073799,-22.102800>, <0.488089,0.344837,-0.801783>
}
   smooth_triangle{ <40.169399,-66.073799,-22.102800>, <-0.488089,-0.344837,0.801783>
 <40.068600,-65.208504,-21.804199>, <-0.476305,-0.326523,0.816404>
 <39.309299,-65.207802,-22.256001>, <-0.487483,-0.340662,0.803934>
}
   smooth_triangle{ <40.169399,-66.073799,-22.102800>, <0.488089,0.344837,-0.801783>
 <39.309299,-65.207802,-22.256001>, <0.487483,0.340662,-0.803934>
 <40.068600,-65.208504,-21.804199>, <0.476305,0.326523,-0.816404>
}
   smooth_triangle{ <40.169399,-66.073799,-22.102800>, <-0.488089,-0.344837,0.801783>
 <40.909000,-66.074699,-21.661800>, <-0.476014,-0.329724,0.815287>
 <40.068600,-65.208504,-21.804199>, <-0.476305,-0.326523,0.816404>
}
   smooth_triangle{ <40.169399,-66.073799,-22.102800>, <0.488089,0.344837,-0.801783>
 <40.068600,-65.208504,-21.804199>, <0.476305,0.326523,-0.816404>
 <40.909000,-66.074699,-21.661800>, <0.476014,0.329724,-0.815287>
}
   smooth_triangle{ <40.909000,-66.074699,-21.661800>, <-0.476014,-0.329724,0.815287>
 <40.850498,-65.204002,-21.356001>, <-0.464516,-0.313802,0.828102>
 <40.068600,-65.208504,-21.804199>, <-0.476305,-0.326523,0.816404>
}
   smooth_triangle{ <40.909000,-66.074699,-21.661800>, <0.476014,0.329724,-0.815287>
 <40.068600,-65.208504,-21.804199>, <0.476305,0.326523,-0.816404>
 <40.850498,-65.204002,-21.356001>, <0.464516,0.313802,-0.828102>
}
   smooth_triangle{ <40.909000,-66.074699,-21.661800>, <-0.476014,-0.329724,0.815287>
 <41.671200,-66.070198,-21.225201>, <-0.463274,-0.315878,0.828009>
 <40.850498,-65.204002,-21.356001>, <-0.464516,-0.313802,0.828102>
}
   smooth_triangle{ <40.909000,-66.074699,-21.661800>, <0.476014,0.329724,-0.815287>
 <40.850498,-65.204002,-21.356001>, <0.464516,0.313802,-0.828102>
 <41.671200,-66.070198,-21.225201>, <0.463274,0.315878,-0.828009>
}
   smooth_triangle{ <41.671200,-66.070198,-21.225201>, <-0.463274,-0.315878,0.828009>
 <41.728802,-65.193703,-20.868799>, <-0.454747,-0.305354,0.836639>
 <40.850498,-65.204002,-21.356001>, <-0.464516,-0.313802,0.828102>
}
   smooth_triangle{ <41.671200,-66.070198,-21.225201>, <0.463274,0.315878,-0.828009>
 <40.850498,-65.204002,-21.356001>, <0.464516,0.313802,-0.828102>
 <41.728802,-65.193703,-20.868799>, <0.454747,0.305354,-0.836639>
}
   smooth_triangle{ <41.671200,-66.070198,-21.225201>, <-0.463274,-0.315878,0.828009>
 <42.527802,-66.059700,-20.751801>, <-0.452747,-0.306411,0.837337>
 <41.728802,-65.193703,-20.868799>, <-0.454747,-0.305354,0.836639>
}
   smooth_triangle{ <41.671200,-66.070198,-21.225201>, <0.463274,0.315878,-0.828009>
 <41.728802,-65.193703,-20.868799>, <0.454747,0.305354,-0.836639>
 <42.527802,-66.059700,-20.751801>, <0.452747,0.306411,-0.837337>
}
   smooth_triangle{ <42.527802,-66.059700,-20.751801>, <-0.452747,-0.306411,0.837337>
 <42.650299,-65.179398,-20.369499>, <-0.446459,-0.300128,0.842969>
 <41.728802,-65.193703,-20.868799>, <-0.454747,-0.305354,0.836639>
}
   smooth_triangle{ <42.527802,-66.059700,-20.751801>, <0.452747,0.306411,-0.837337>
 <41.728802,-65.193703,-20.868799>, <0.454747,0.305354,-0.836639>
 <42.650299,-65.179398,-20.369499>, <0.446459,0.300128,-0.842969>
}
   smooth_triangle{ <42.527802,-66.059700,-20.751801>, <-0.452747,-0.306411,0.837337>
 <43.426998,-66.044800,-20.267200>, <-0.443893,-0.300157,0.844313>
 <42.650299,-65.179398,-20.369499>, <-0.446459,-0.300128,0.842969>
}
   smooth_triangle{ <42.527802,-66.059700,-20.751801>, <0.452747,0.306411,-0.837337>
 <42.650299,-65.179398,-20.369499>, <0.446459,0.300128,-0.842969>
 <43.426998,-66.044800,-20.267200>, <0.443893,0.300157,-0.844313>
}
   smooth_triangle{ <43.426998,-66.044800,-20.267200>, <-0.443893,-0.300157,0.844313>
 <43.502300,-65.162804,-19.918501>, <-0.436105,-0.294019,0.850509>
 <42.650299,-65.179398,-20.369499>, <-0.446459,-0.300128,0.842969>
}
   smooth_triangle{ <43.426998,-66.044800,-20.267200>, <0.443893,0.300157,-0.844313>
 <42.650299,-65.179398,-20.369499>, <0.446459,0.300128,-0.842969>
 <43.502300,-65.162804,-19.918501>, <0.436105,0.294019,-0.850509>
}
   smooth_triangle{ <43.426998,-66.044800,-20.267200>, <-0.443893,-0.300157,0.844313>
 <44.258900,-66.027603,-19.830200>, <-0.432809,-0.292764,0.852623>
 <43.502300,-65.162804,-19.918501>, <-0.436105,-0.294019,0.850509>
}
   smooth_triangle{ <43.426998,-66.044800,-20.267200>, <0.443893,0.300157,-0.844313>
 <43.502300,-65.162804,-19.918501>, <0.436105,0.294019,-0.850509>
 <44.258900,-66.027603,-19.830200>, <0.432809,0.292764,-0.852623>
}
   smooth_triangle{ <44.258900,-66.027603,-19.830200>, <-0.432809,-0.292764,0.852623>
 <44.172298,-65.145897,-19.576200>, <-0.428349,-0.289606,0.855947>
 <43.502300,-65.162804,-19.918501>, <-0.436105,-0.294019,0.850509>
}
   smooth_triangle{ <44.258900,-66.027603,-19.830200>, <0.432809,0.292764,-0.852623>
 <43.502300,-65.162804,-19.918501>, <0.436105,0.294019,-0.850509>
 <44.172298,-65.145897,-19.576200>, <0.469045,0.328893,-0.819650>
}
   smooth_triangle{ <44.258900,-66.027603,-19.830200>, <-0.432809,-0.292764,0.852623>
 <44.913300,-66.010101,-19.499300>, <-0.424736,-0.287821,0.858346>
 <44.172298,-65.145897,-19.576200>, <-0.428349,-0.289606,0.855947>
}
   smooth_triangle{ <44.258900,-66.027603,-19.830200>, <0.432809,0.292764,-0.852623>
 <44.172298,-65.145897,-19.576200>, <0.469045,0.328893,-0.819650>
 <44.913300,-66.010101,-19.499300>, <0.468906,0.330101,-0.819244>
}
   smooth_triangle{ <44.172298,-65.145897,-19.576200>, <0.469045,0.328893,-0.819650>
 <42.794800,-64.272102,-20.060900>, <0.495168,0.356625,-0.792230>
 <43.431599,-64.281502,-19.653700>, <0.469193,0.328142,-0.819867>
}
   smooth_triangle{ <44.172298,-65.145897,-19.576200>, <0.469045,0.328893,-0.819650>
 <43.552898,-65.135597,-19.976101>, <0.497424,0.359132,-0.789680>
 <42.794800,-64.272102,-20.060900>, <0.495168,0.356625,-0.792230>
}
   smooth_triangle{ <43.552898,-65.135597,-19.976101>, <0.497424,0.359132,-0.789680>
 <41.945702,-64.269600,-20.571800>, <0.479835,0.343832,-0.807179>
 <42.794800,-64.272102,-20.060900>, <0.495168,0.356625,-0.792230>
}
   smooth_triangle{ <43.552898,-65.135597,-19.976101>, <0.497424,0.359132,-0.789680>
 <42.725700,-65.132500,-20.475800>, <0.480721,0.344747,-0.806261>
 <41.945702,-64.269600,-20.571800>, <0.479835,0.343832,-0.807179>
}
   smooth_triangle{ <42.725700,-65.132500,-20.475800>, <0.480721,0.344747,-0.806261>
 <41.011002,-64.271301,-21.119801>, <0.473346,0.338100,-0.813408>
 <41.945702,-64.269600,-20.571800>, <0.479835,0.343832,-0.807179>
}
   smooth_triangle{ <42.725700,-65.132500,-20.475800>, <0.480721,0.344747,-0.806261>
 <41.814400,-65.134003,-21.010700>, <0.473600,0.338255,-0.813196>
 <41.011002,-64.271301,-21.119801>, <0.473346,0.338100,-0.813408>
}
   smooth_triangle{ <41.814400,-65.134003,-21.010700>, <0.473600,0.338255,-0.813196>
 <40.117199,-64.274696,-21.637899>, <0.469002,0.333448,-0.817832>
 <41.011002,-64.271301,-21.119801>, <0.473346,0.338100,-0.813408>
}
   smooth_triangle{ <41.814400,-65.134003,-21.010700>, <0.473600,0.338255,-0.813196>
 <40.942902,-65.137299,-21.516100>, <0.468818,0.333107,-0.818077>
 <40.117199,-64.274696,-21.637899>, <0.469002,0.333448,-0.817832>
}
   smooth_triangle{ <40.942902,-65.137299,-21.516100>, <0.468818,0.333107,-0.818077>
 <39.342602,-64.279800,-22.080299>, <0.460985,0.323559,-0.826319>
 <40.117199,-64.274696,-21.637899>, <0.469002,0.333448,-0.817832>
}
   smooth_triangle{ <40.942902,-65.137299,-21.516100>, <0.468818,0.333107,-0.818077>
 <40.187302,-65.142403,-21.947001>, <0.459939,0.322314,-0.827387>
 <39.342602,-64.279800,-22.080299>, <0.460985,0.323559,-0.826319>
}
   smooth_triangle{ <40.187302,-65.142403,-21.947001>, <0.459939,0.322314,-0.827387>
 <38.602501,-64.289101,-22.488400>, <0.449566,0.307873,-0.838514>
 <39.342602,-64.279800,-22.080299>, <0.460985,0.323559,-0.826319>
}
   smooth_triangle{ <40.187302,-65.142403,-21.947001>, <0.459939,0.322314,-0.827387>
 <39.464600,-65.152100,-22.343500>, <0.447238,0.305497,-0.840624>
 <38.602501,-64.289101,-22.488400>, <0.449566,0.307873,-0.838514>
}
   smooth_triangle{ <39.464600,-65.152100,-22.343500>, <0.447238,0.305497,-0.840624>
 <37.778500,-64.304604,-22.926399>, <0.440136,0.291995,-0.849128>
 <38.602501,-64.289101,-22.488400>, <0.449566,0.307873,-0.838514>
}
   smooth_triangle{ <39.464600,-65.152100,-22.343500>, <0.447238,0.305497,-0.840624>
 <38.659599,-65.168404,-22.767700>, <0.436691,0.288892,-0.851964>
 <37.778500,-64.304604,-22.926399>, <0.440136,0.291995,-0.849128>
}
   smooth_triangle{ <38.659599,-65.168404,-22.767700>, <0.436691,0.288892,-0.851964>
 <36.753101,-64.327904,-23.458300>, <0.466246,0.318178,-0.825456>
 <37.778500,-64.304604,-22.926399>, <0.440136,0.291995,-0.849128>
}
   smooth_triangle{ <38.659599,-65.168404,-22.767700>, <0.436691,0.288892,-0.851964>
 <37.656898,-65.193100,-23.281900>, <0.465515,0.319184,-0.825480>
 <36.753101,-64.327904,-23.458300>, <0.466246,0.318178,-0.825456>
}
   smooth_triangle{ <37.656898,-65.193100,-23.281900>, <-0.497828,-0.358265,0.789819>
 <37.642101,-64.336403,-22.904800>, <-0.493916,-0.348594,0.796573>
 <36.753101,-64.327904,-23.458300>, <-0.495771,-0.353423,0.793286>
}
   smooth_triangle{ <37.656898,-65.193100,-23.281900>, <0.465515,0.319184,-0.825480>
 <36.753101,-64.327904,-23.458300>, <0.466246,0.318178,-0.825456>
 <37.642101,-64.336403,-22.904800>, <0.493916,0.348594,-0.796573>
}
   smooth_triangle{ <37.656898,-65.193100,-23.281900>, <-0.497828,-0.358265,0.789819>
 <38.522202,-65.202499,-22.739300>, <-0.495569,-0.353251,0.793489>
 <37.642101,-64.336403,-22.904800>, <-0.493916,-0.348594,0.796573>
}
   smooth_triangle{ <37.656898,-65.193100,-23.281900>, <0.465515,0.319184,-0.825480>
 <37.642101,-64.336403,-22.904800>, <0.493916,0.348594,-0.796573>
 <38.522202,-65.202499,-22.739300>, <0.495569,0.353251,-0.793489>
}
   smooth_triangle{ <38.522202,-65.202499,-22.739300>, <-0.495569,-0.353251,0.793489>
 <38.450401,-64.341003,-22.411301>, <-0.486607,-0.336628,0.806161>
 <37.642101,-64.336403,-22.904800>, <-0.493916,-0.348594,0.796573>
}
   smooth_triangle{ <38.522202,-65.202499,-22.739300>, <0.495569,0.353251,-0.793489>
 <37.642101,-64.336403,-22.904800>, <0.493916,0.348594,-0.796573>
 <38.450401,-64.341003,-22.411301>, <0.486607,0.336628,-0.806161>
}
   smooth_triangle{ <38.522202,-65.202499,-22.739300>, <-0.495569,-0.353251,0.793489>
 <39.309299,-65.207802,-22.256001>, <-0.487483,-0.340662,0.803934>
 <38.450401,-64.341003,-22.411301>, <-0.486607,-0.336628,0.806161>
}
   smooth_triangle{ <38.522202,-65.202499,-22.739300>, <0.495569,0.353251,-0.793489>
 <38.450401,-64.341003,-22.411301>, <0.486607,0.336628,-0.806161>
 <39.309299,-65.207802,-22.256001>, <0.487483,0.340662,-0.803934>
}
   smooth_triangle{ <39.309299,-65.207802,-22.256001>, <-0.487483,-0.340662,0.803934>
 <39.229500,-64.341400,-21.948900>, <-0.476522,-0.323516,0.817474>
 <38.450401,-64.341003,-22.411301>, <-0.486607,-0.336628,0.806161>
}
   smooth_triangle{ <39.309299,-65.207802,-22.256001>, <0.487483,0.340662,-0.803934>
 <38.450401,-64.341003,-22.411301>, <0.486607,0.336628,-0.806161>
 <39.229500,-64.341400,-21.948900>, <0.476522,0.323516,-0.817474>
}
   smooth_triangle{ <39.309299,-65.207802,-22.256001>, <-0.487483,-0.340662,0.803934>
 <40.068600,-65.208504,-21.804199>, <-0.476305,-0.326523,0.816404>
 <39.229500,-64.341400,-21.948900>, <-0.476522,-0.323516,0.817474>
}
   smooth_triangle{ <39.309299,-65.207802,-22.256001>, <0.487483,0.340662,-0.803934>
 <39.229500,-64.341400,-21.948900>, <0.476522,0.323516,-0.817474>
 <40.068600,-65.208504,-21.804199>, <0.476305,0.326523,-0.816404>
}
   smooth_triangle{ <40.068600,-65.208504,-21.804199>, <-0.476305,-0.326523,0.816404>
 <40.031200,-64.336800,-21.488899>, <-0.465784,-0.311997,0.828071>
 <39.229500,-64.341400,-21.948900>, <-0.476522,-0.323516,0.817474>
}
   smooth_triangle{ <40.068600,-65.208504,-21.804199>, <0.476305,0.326523,-0.816404>
 <39.229500,-64.341400,-21.948900>, <0.476522,0.323516,-0.817474>
 <40.031200,-64.336800,-21.488899>, <0.465784,0.311997,-0.828071>
}
   smooth_triangle{ <40.068600,-65.208504,-21.804199>, <-0.476305,-0.326523,0.816404>
 <40.850498,-65.204002,-21.356001>, <-0.464516,-0.313802,0.828102>
 <40.031200,-64.336800,-21.488899>, <-0.465784,-0.311997,0.828071>
}
   smooth_triangle{ <40.068600,-65.208504,-21.804199>, <0.476305,0.326523,-0.816404>
 <40.031200,-64.336800,-21.488899>, <0.465784,0.311997,-0.828071>
 <40.850498,-65.204002,-21.356001>, <0.464516,0.313802,-0.828102>
}
   smooth_triangle{ <40.850498,-65.204002,-21.356001>, <-0.464516,-0.313802,0.828102>
 <40.930901,-64.326897,-20.987900>, <-0.456855,-0.304695,0.835730>
 <40.031200,-64.336800,-21.488899>, <-0.465784,-0.311997,0.828071>
}
   smooth_triangle{ <40.850498,-65.204002,-21.356001>, <0.464516,0.313802,-0.828102>
 <40.031200,-64.336800,-21.488899>, <0.465784,0.311997,-0.828071>
 <40.930901,-64.326897,-20.987900>, <0.456855,0.304695,-0.835730>
}
   smooth_triangle{ <40.850498,-65.204002,-21.356001>, <-0.464516,-0.313802,0.828102>
 <41.728802,-65.193703,-20.868799>, <-0.454747,-0.305354,0.836639>
 <40.930901,-64.326897,-20.987900>, <-0.456855,-0.304695,0.835730>
}
   smooth_triangle{ <40.850498,-65.204002,-21.356001>, <0.464516,0.313802,-0.828102>
 <40.930901,-64.326897,-20.987900>, <0.456855,0.304695,-0.835730>
 <41.728802,-65.193703,-20.868799>, <0.454747,0.305354,-0.836639>
}
   smooth_triangle{ <41.728802,-65.193703,-20.868799>, <-0.454747,-0.305354,0.836639>
 <41.874500,-64.313202,-20.473400>, <-0.449263,-0.300590,0.841314>
 <40.930901,-64.326897,-20.987900>, <-0.456855,-0.304695,0.835730>
}
   smooth_triangle{ <41.728802,-65.193703,-20.868799>, <0.454747,0.305354,-0.836639>
 <40.930901,-64.326897,-20.987900>, <0.456855,0.304695,-0.835730>
 <41.874500,-64.313202,-20.473400>, <0.449263,0.300590,-0.841314>
}
   smooth_triangle{ <41.728802,-65.193703,-20.868799>, <-0.454747,-0.305354,0.836639>
 <42.650299,-65.179398,-20.369499>, <-0.446459,-0.300128,0.842969>
 <41.874500,-64.313202,-20.473400>, <-0.449263,-0.300590,0.841314>
}
   smooth_triangle{ <41.728802,-65.193703,-20.868799>, <0.454747,0.305354,-0.836639>
 <41.874500,-64.313202,-20.473400>, <0.449263,0.300590,-0.841314>
 <42.650299,-65.179398,-20.369499>, <0.446459,0.300128,-0.842969>
}
   smooth_triangle{ <42.650299,-65.179398,-20.369499>, <-0.446459,-0.300128,0.842969>
 <42.746498,-64.297401,-20.007900>, <-0.439761,-0.295870,0.847981>
 <41.874500,-64.313202,-20.473400>, <-0.449263,-0.300590,0.841314>
}
   smooth_triangle{ <42.650299,-65.179398,-20.369499>, <0.446459,0.300128,-0.842969>
 <41.874500,-64.313202,-20.473400>, <0.449263,0.300590,-0.841314>
 <42.746498,-64.297401,-20.007900>, <0.439761,0.295870,-0.847981>
}
   smooth_triangle{ <42.650299,-65.179398,-20.369499>, <-0.446459,-0.300128,0.842969>
 <43.502300,-65.162804,-19.918501>, <-0.436105,-0.294019,0.850509>
 <42.746498,-64.297401,-20.007900>, <-0.439761,-0.295870,0.847981>
}
   smooth_triangle{ <42.650299,-65.179398,-20.369499>, <0.446459,0.300128,-0.842969>
 <42.746498,-64.297401,-20.007900>, <0.439761,0.295870,-0.847981>
 <43.502300,-65.162804,-19.918501>, <0.436105,0.294019,-0.850509>
}
   smooth_triangle{ <43.502300,-65.162804,-19.918501>, <-0.436105,-0.294019,0.850509>
 <43.431599,-64.281502,-19.653700>, <-0.432324,-0.292177,0.853070>
 <42.746498,-64.297401,-20.007900>, <-0.439761,-0.295870,0.847981>
}
   smooth_triangle{ <43.502300,-65.162804,-19.918501>, <0.436105,0.294019,-0.850509>
 <42.746498,-64.297401,-20.007900>, <0.439761,0.295870,-0.847981>
 <43.431599,-64.281502,-19.653700>, <0.469193,0.328142,-0.819867>
}
   smooth_triangle{ <43.502300,-65.162804,-19.918501>, <-0.436105,-0.294019,0.850509>
 <44.172298,-65.145897,-19.576200>, <-0.428349,-0.289606,0.855947>
 <43.431599,-64.281502,-19.653700>, <-0.432324,-0.292177,0.853070>
}
   smooth_triangle{ <43.502300,-65.162804,-19.918501>, <0.436105,0.294019,-0.850509>
 <43.431599,-64.281502,-19.653700>, <0.469193,0.328142,-0.819867>
 <44.172298,-65.145897,-19.576200>, <0.469045,0.328893,-0.819650>
}
   smooth_triangle{ <43.431599,-64.281502,-19.653700>, <0.469193,0.328142,-0.819867>
 <42.036800,-63.408600,-20.145700>, <0.493714,0.351695,-0.795335>
 <42.691299,-63.416801,-19.731800>, <0.470993,0.327700,-0.819011>
}
   smooth_triangle{ <43.431599,-64.281502,-19.653700>, <0.469193,0.328142,-0.819867>
 <42.794800,-64.272102,-20.060900>, <0.495168,0.356625,-0.792230>
 <42.036800,-63.408600,-20.145700>, <0.493714,0.351695,-0.795335>
}
   smooth_triangle{ <42.794800,-64.272102,-20.060900>, <0.495168,0.356625,-0.792230>
 <41.165600,-63.406700,-20.667700>, <0.479383,0.341245,-0.808544>
 <42.036800,-63.408600,-20.145700>, <0.493714,0.351695,-0.795335>
}
   smooth_triangle{ <42.794800,-64.272102,-20.060900>, <0.495168,0.356625,-0.792230>
 <41.945702,-64.269600,-20.571800>, <0.479835,0.343832,-0.807179>
 <41.165600,-63.406700,-20.667700>, <0.479383,0.341245,-0.808544>
}
   smooth_triangle{ <41.945702,-64.269600,-20.571800>, <0.479835,0.343832,-0.807179>
 <40.207199,-63.408699,-21.228600>, <0.473144,0.337584,-0.813740>
 <41.165600,-63.406700,-20.667700>, <0.479383,0.341245,-0.808544>
}
   smooth_triangle{ <41.945702,-64.269600,-20.571800>, <0.479835,0.343832,-0.807179>
 <41.011002,-64.271301,-21.119801>, <0.473346,0.338100,-0.813408>
 <40.207199,-63.408699,-21.228600>, <0.473144,0.337584,-0.813740>
}
   smooth_triangle{ <41.011002,-64.271301,-21.119801>, <0.473346,0.338100,-0.813408>
 <39.291302,-63.412300,-21.759600>, <0.468596,0.336078,-0.816988>
 <40.207199,-63.408699,-21.228600>, <0.473144,0.337584,-0.813740>
}
   smooth_triangle{ <41.011002,-64.271301,-21.119801>, <0.473346,0.338100,-0.813408>
 <40.117199,-64.274696,-21.637899>, <0.469002,0.333448,-0.817832>
 <39.291302,-63.412300,-21.759600>, <0.468596,0.336078,-0.816988>
}
   smooth_triangle{ <40.117199,-64.274696,-21.637899>, <0.469002,0.333448,-0.817832>
 <38.497799,-63.417198,-22.213400>, <0.459556,0.334734,-0.822655>
 <39.291302,-63.412300,-21.759600>, <0.468596,0.336078,-0.816988>
}
   smooth_triangle{ <40.117199,-64.274696,-21.637899>, <0.469002,0.333448,-0.817832>
 <39.342602,-64.279800,-22.080299>, <0.460985,0.323559,-0.826319>
 <38.497799,-63.417198,-22.213400>, <0.459556,0.334734,-0.822655>
}
   smooth_triangle{ <39.342602,-64.279800,-22.080299>, <0.460985,0.323559,-0.826319>
 <37.740200,-63.426102,-22.633400>, <0.446834,0.332720,-0.830444>
 <38.497799,-63.417198,-22.213400>, <0.459556,0.334734,-0.822655>
}
   smooth_triangle{ <39.342602,-64.279800,-22.080299>, <0.460985,0.323559,-0.826319>
 <38.602501,-64.289101,-22.488400>, <0.449566,0.307873,-0.838514>
 <37.740200,-63.426102,-22.633400>, <0.446834,0.332720,-0.830444>
}
   smooth_triangle{ <38.602501,-64.289101,-22.488400>, <0.449566,0.307873,-0.838514>
 <36.897800,-63.440601,-23.085600>, <0.436031,0.331243,-0.836753>
 <37.740200,-63.426102,-22.633400>, <0.446834,0.332720,-0.830444>
}
   smooth_triangle{ <38.602501,-64.289101,-22.488400>, <0.449566,0.307873,-0.838514>
 <37.778500,-64.304604,-22.926399>, <0.440136,0.291995,-0.849128>
 <36.897800,-63.440601,-23.085600>, <0.436031,0.331243,-0.836753>
}
   smooth_triangle{ <37.778500,-64.304604,-22.926399>, <0.440136,0.291995,-0.849128>
 <35.849899,-63.462299,-23.636000>, <0.468938,0.312778,-0.825995>
 <36.897800,-63.440601,-23.085600>, <0.436031,0.331243,-0.836753>
}
   smooth_triangle{ <37.778500,-64.304604,-22.926399>, <0.440136,0.291995,-0.849128>
 <36.753101,-64.327904,-23.458300>, <0.466246,0.318178,-0.825456>
 <35.849899,-63.462299,-23.636000>, <0.468938,0.312778,-0.825995>
}
   smooth_triangle{ <36.753101,-64.327904,-23.458300>, <-0.495771,-0.353423,0.793286>
 <36.762901,-63.469501,-23.072100>, <-0.496605,-0.323497,0.805439>
 <35.849899,-63.462299,-23.636000>, <-0.502375,-0.311201,0.806705>
}
   smooth_triangle{ <36.753101,-64.327904,-23.458300>, <0.466246,0.318178,-0.825456>
 <35.849899,-63.462299,-23.636000>, <0.468938,0.312778,-0.825995>
 <36.762901,-63.469501,-23.072100>, <0.496605,0.323497,-0.805439>
}
   smooth_triangle{ <36.753101,-64.327904,-23.458300>, <-0.495771,-0.353423,0.793286>
 <37.642101,-64.336403,-22.904800>, <-0.493916,-0.348594,0.796573>
 <36.762901,-63.469501,-23.072100>, <-0.496605,-0.323497,0.805439>
}
   smooth_triangle{ <36.753101,-64.327904,-23.458300>, <0.466246,0.318178,-0.825456>
 <36.762901,-63.469501,-23.072100>, <0.496605,0.323497,-0.805439>
 <37.642101,-64.336403,-22.904800>, <0.493916,0.348594,-0.796573>
}
   smooth_triangle{ <37.642101,-64.336403,-22.904800>, <-0.493916,-0.348594,0.796573>
 <37.592602,-63.473400,-22.568501>, <-0.487817,-0.322392,0.811232>
 <36.762901,-63.469501,-23.072100>, <-0.496605,-0.323497,0.805439>
}
   smooth_triangle{ <37.642101,-64.336403,-22.904800>, <0.493916,0.348594,-0.796573>
 <36.762901,-63.469501,-23.072100>, <0.496605,0.323497,-0.805439>
 <37.592602,-63.473400,-22.568501>, <0.487817,0.322392,-0.811232>
}
   smooth_triangle{ <37.642101,-64.336403,-22.904800>, <-0.493916,-0.348594,0.796573>
 <38.450401,-64.341003,-22.411301>, <-0.486607,-0.336628,0.806161>
 <37.592602,-63.473400,-22.568501>, <-0.487817,-0.322392,0.811232>
}
   smooth_triangle{ <37.642101,-64.336403,-22.904800>, <0.493916,0.348594,-0.796573>
 <37.592602,-63.473400,-22.568501>, <0.487817,0.322392,-0.811232>
 <38.450401,-64.341003,-22.411301>, <0.486607,0.336628,-0.806161>
}
   smooth_triangle{ <38.450401,-64.341003,-22.411301>, <-0.486607,-0.336628,0.806161>
 <38.391602,-63.473301,-22.095600>, <-0.476681,-0.319548,0.818941>
 <37.592602,-63.473400,-22.568501>, <-0.487817,-0.322392,0.811232>
}
   smooth_triangle{ <38.450401,-64.341003,-22.411301>, <0.486607,0.336628,-0.806161>
 <37.592602,-63.473400,-22.568501>, <0.487817,0.322392,-0.811232>
 <38.391602,-63.473301,-22.095600>, <0.476681,0.319548,-0.818941>
}
   smooth_triangle{ <38.450401,-64.341003,-22.411301>, <-0.486607,-0.336628,0.806161>
 <39.229500,-64.341400,-21.948900>, <-0.476522,-0.323516,0.817474>
 <38.391602,-63.473301,-22.095600>, <-0.476681,-0.319548,0.818941>
}
   smooth_triangle{ <38.450401,-64.341003,-22.411301>, <0.486607,0.336628,-0.806161>
 <38.391602,-63.473301,-22.095600>, <0.476681,0.319548,-0.818941>
 <39.229500,-64.341400,-21.948900>, <0.476522,0.323516,-0.817474>
}
   smooth_triangle{ <39.229500,-64.341400,-21.948900>, <-0.476522,-0.323516,0.817474>
 <39.213100,-63.468700,-21.623899>, <-0.465676,-0.315037,0.826981>
 <38.391602,-63.473301,-22.095600>, <-0.476681,-0.319548,0.818941>
}
   smooth_triangle{ <39.229500,-64.341400,-21.948900>, <0.476522,0.323516,-0.817474>
 <38.391602,-63.473301,-22.095600>, <0.476681,0.319548,-0.818941>
 <39.213100,-63.468700,-21.623899>, <0.465676,0.315037,-0.826981>
}
   smooth_triangle{ <39.229500,-64.341400,-21.948900>, <-0.476522,-0.323516,0.817474>
 <40.031200,-64.336800,-21.488899>, <-0.465784,-0.311997,0.828071>
 <39.213100,-63.468700,-21.623899>, <-0.465676,-0.315037,0.826981>
}
   smooth_triangle{ <39.229500,-64.341400,-21.948900>, <0.476522,0.323516,-0.817474>
 <39.213100,-63.468700,-21.623899>, <0.465676,0.315037,-0.826981>
 <40.031200,-64.336800,-21.488899>, <0.465784,0.311997,-0.828071>
}
   smooth_triangle{ <40.031200,-64.336800,-21.488899>, <-0.465784,-0.311997,0.828071>
 <40.134102,-63.459301,-21.108801>, <-0.457099,-0.310370,0.833505>
 <39.213100,-63.468700,-21.623899>, <-0.465676,-0.315037,0.826981>
}
   smooth_triangle{ <40.031200,-64.336800,-21.488899>, <0.465784,0.311997,-0.828071>
 <39.213100,-63.468700,-21.623899>, <0.465676,0.315037,-0.826981>
 <40.134102,-63.459301,-21.108801>, <0.457099,0.310370,-0.833505>
}
   smooth_triangle{ <40.031200,-64.336800,-21.488899>, <-0.465784,-0.311997,0.828071>
 <40.930901,-64.326897,-20.987900>, <-0.456855,-0.304695,0.835730>
 <40.134102,-63.459301,-21.108801>, <-0.457099,-0.310370,0.833505>
}
   smooth_triangle{ <40.031200,-64.336800,-21.488899>, <0.465784,0.311997,-0.828071>
 <40.134102,-63.459301,-21.108801>, <0.457099,0.310370,-0.833505>
 <40.930901,-64.326897,-20.987900>, <0.456855,0.304695,-0.835730>
}
   smooth_triangle{ <40.930901,-64.326897,-20.987900>, <-0.456855,-0.304695,0.835730>
 <41.099602,-63.446400,-20.578899>, <-0.450184,-0.305906,0.838902>
 <40.134102,-63.459301,-21.108801>, <-0.457099,-0.310370,0.833505>
}
   smooth_triangle{ <40.930901,-64.326897,-20.987900>, <0.456855,0.304695,-0.835730>
 <40.134102,-63.459301,-21.108801>, <0.457099,0.310370,-0.833505>
 <41.099602,-63.446400,-20.578899>, <0.450184,0.305906,-0.838902>
}
   smooth_triangle{ <40.930901,-64.326897,-20.987900>, <-0.456855,-0.304695,0.835730>
 <41.874500,-64.313202,-20.473400>, <-0.449263,-0.300590,0.841314>
 <41.099602,-63.446400,-20.578899>, <-0.450184,-0.305906,0.838902>
}
   smooth_triangle{ <40.930901,-64.326897,-20.987900>, <0.456855,0.304695,-0.835730>
 <41.099602,-63.446400,-20.578899>, <0.450184,0.305906,-0.838902>
 <41.874500,-64.313202,-20.473400>, <0.449263,0.300590,-0.841314>
}
   smooth_triangle{ <41.874500,-64.313202,-20.473400>, <-0.449263,-0.300590,0.841314>
 <41.991299,-63.431599,-20.098400>, <-0.441663,-0.299467,0.845727>
 <41.099602,-63.446400,-20.578899>, <-0.450184,-0.305906,0.838902>
}
   smooth_triangle{ <41.874500,-64.313202,-20.473400>, <0.449263,0.300590,-0.841314>
 <41.099602,-63.446400,-20.578899>, <0.450184,0.305906,-0.838902>
 <41.991299,-63.431599,-20.098400>, <0.441663,0.299467,-0.845727>
}
   smooth_triangle{ <41.874500,-64.313202,-20.473400>, <-0.449263,-0.300590,0.841314>
 <42.746498,-64.297401,-20.007900>, <-0.439761,-0.295870,0.847981>
 <41.991299,-63.431599,-20.098400>, <-0.441663,-0.299467,0.845727>
}
   smooth_triangle{ <41.874500,-64.313202,-20.473400>, <0.449263,0.300590,-0.841314>
 <41.991299,-63.431599,-20.098400>, <0.441663,0.299467,-0.845727>
 <42.746498,-64.297401,-20.007900>, <0.439761,0.295870,-0.847981>
}
   smooth_triangle{ <42.746498,-64.297401,-20.007900>, <-0.439761,-0.295870,0.847981>
 <42.691299,-63.416801,-19.731800>, <-0.436676,-0.295358,0.849752>
 <41.991299,-63.431599,-20.098400>, <-0.441663,-0.299467,0.845727>
}
   smooth_triangle{ <42.746498,-64.297401,-20.007900>, <0.439761,0.295870,-0.847981>
 <41.991299,-63.431599,-20.098400>, <0.441663,0.299467,-0.845727>
 <42.691299,-63.416801,-19.731800>, <0.470993,0.327700,-0.819011>
}
   smooth_triangle{ <42.746498,-64.297401,-20.007900>, <-0.439761,-0.295870,0.847981>
 <43.431599,-64.281502,-19.653700>, <-0.432324,-0.292177,0.853070>
 <42.691299,-63.416801,-19.731800>, <-0.436676,-0.295358,0.849752>
}
   smooth_triangle{ <42.746498,-64.297401,-20.007900>, <0.439761,0.295870,-0.847981>
 <42.691299,-63.416801,-19.731800>, <0.470993,0.327700,-0.819011>
 <43.431599,-64.281502,-19.653700>, <0.469193,0.328142,-0.819867>
}
   smooth_triangle{ <42.691299,-63.416801,-19.731800>, <0.470993,0.327700,-0.819011>
 <41.343201,-62.405899,-20.136000>, <0.495818,0.351806,-0.793975>
 <41.832401,-62.413300,-19.822599>, <0.472517,0.330733,-0.816911>
}
   smooth_triangle{ <42.691299,-63.416801,-19.731800>, <0.470993,0.327700,-0.819011>
 <42.036800,-63.408600,-20.145700>, <0.493714,0.351695,-0.795335>
 <41.343201,-62.405899,-20.136000>, <0.495818,0.351806,-0.793975>
}
   smooth_triangle{ <42.036800,-63.408600,-20.145700>, <0.493714,0.351695,-0.795335>
 <40.690601,-62.403900,-20.528900>, <0.480296,0.340569,-0.808287>
 <41.343201,-62.405899,-20.136000>, <0.495818,0.351806,-0.793975>
}
   smooth_triangle{ <42.036800,-63.408600,-20.145700>, <0.493714,0.351695,-0.795335>
 <41.165600,-63.406700,-20.667700>, <0.479383,0.341245,-0.808544>
 <40.690601,-62.403900,-20.528900>, <0.480296,0.340569,-0.808287>
}
   smooth_triangle{ <41.165600,-63.406700,-20.667700>, <0.479383,0.341245,-0.808544>
 <39.972198,-62.405201,-20.950199>, <0.473257,0.337811,-0.813579>
 <40.690601,-62.403900,-20.528900>, <0.480296,0.340569,-0.808287>
}
   smooth_triangle{ <41.165600,-63.406700,-20.667700>, <0.479383,0.341245,-0.808544>
 <40.207199,-63.408699,-21.228600>, <0.473144,0.337584,-0.813740>
 <39.972198,-62.405201,-20.950199>, <0.473257,0.337811,-0.813579>
}
   smooth_triangle{ <40.207199,-63.408699,-21.228600>, <0.473144,0.337584,-0.813740>
 <39.285301,-62.407799,-21.348400>, <0.467877,0.338212,-0.816519>
 <39.972198,-62.405201,-20.950199>, <0.473257,0.337811,-0.813579>
}
   smooth_triangle{ <40.207199,-63.408699,-21.228600>, <0.473144,0.337584,-0.813740>
 <39.291302,-63.412300,-21.759600>, <0.468596,0.336078,-0.816988>
 <39.285301,-62.407799,-21.348400>, <0.467877,0.338212,-0.816519>
}
   smooth_triangle{ <39.291302,-63.412300,-21.759600>, <0.468596,0.336078,-0.816988>
 <38.689899,-62.411701,-21.688400>, <0.456525,0.342661,-0.821078>
 <39.285301,-62.407799,-21.348400>, <0.467877,0.338212,-0.816519>
}
   smooth_triangle{ <39.291302,-63.412300,-21.759600>, <0.468596,0.336078,-0.816988>
 <38.497799,-63.417198,-22.213400>, <0.459556,0.334734,-0.822655>
 <38.689899,-62.411701,-21.688400>, <0.456525,0.342661,-0.821078>
}
   smooth_triangle{ <38.497799,-63.417198,-22.213400>, <0.459556,0.334734,-0.822655>
 <38.120800,-62.419102,-22.001900>, <0.440122,0.352388,-0.825903>
 <38.689899,-62.411701,-21.688400>, <0.456525,0.342661,-0.821078>
}
   smooth_triangle{ <38.497799,-63.417198,-22.213400>, <0.459556,0.334734,-0.822655>
 <37.740200,-63.426102,-22.633400>, <0.446834,0.332720,-0.830444>
 <38.120800,-62.419102,-22.001900>, <0.440122,0.352388,-0.825903>
}
   smooth_triangle{ <37.740200,-63.426102,-22.633400>, <0.446834,0.332720,-0.830444>
 <37.487301,-62.431099,-22.338100>, <0.425594,0.364815,-0.828118>
 <38.120800,-62.419102,-22.001900>, <0.440122,0.352388,-0.825903>
}
   smooth_triangle{ <37.740200,-63.426102,-22.633400>, <0.446834,0.332720,-0.830444>
 <36.897800,-63.440601,-23.085600>, <0.436031,0.331243,-0.836753>
 <37.487301,-62.431099,-22.338100>, <0.425594,0.364815,-0.828118>
}
   smooth_triangle{ <36.897800,-63.440601,-23.085600>, <0.436031,0.331243,-0.836753>
 <36.698799,-62.449299,-22.746300>, <0.467515,0.327721,-0.820992>
 <37.487301,-62.431099,-22.338100>, <0.425594,0.364815,-0.828118>
}
   smooth_triangle{ <36.897800,-63.440601,-23.085600>, <0.436031,0.331243,-0.836753>
 <35.849899,-63.462299,-23.636000>, <0.468938,0.312778,-0.825995>
 <36.698799,-62.449299,-22.746300>, <0.467515,0.327721,-0.820992>
}
   smooth_triangle{ <35.849899,-63.462299,-23.636000>, <-0.502375,-0.311201,0.806705>
 <37.381901,-62.455898,-22.320601>, <-0.503915,-0.292939,0.812562>
 <36.698799,-62.449299,-22.746300>, <-0.510964,-0.284269,0.811238>
}
   smooth_triangle{ <35.849899,-63.462299,-23.636000>, <0.468938,0.312778,-0.825995>
 <36.698799,-62.449299,-22.746300>, <0.467515,0.327721,-0.820992>
 <37.381901,-62.455898,-22.320601>, <0.503915,0.292939,-0.812562>
}
   smooth_triangle{ <35.849899,-63.462299,-23.636000>, <-0.502375,-0.311201,0.806705>
 <36.762901,-63.469501,-23.072100>, <-0.496605,-0.323497,0.805439>
 <37.381901,-62.455898,-22.320601>, <-0.503915,-0.292939,0.812562>
}
   smooth_triangle{ <35.849899,-63.462299,-23.636000>, <0.468938,0.312778,-0.825995>
 <37.381901,-62.455898,-22.320601>, <0.503915,0.292939,-0.812562>
 <36.762901,-63.469501,-23.072100>, <0.496605,0.323497,-0.805439>
}
   smooth_triangle{ <36.762901,-63.469501,-23.072100>, <-0.496605,-0.323497,0.805439>
 <38.002998,-62.459599,-21.940901>, <-0.492299,-0.303485,0.815805>
 <37.381901,-62.455898,-22.320601>, <-0.503915,-0.292939,0.812562>
}
   smooth_triangle{ <36.762901,-63.469501,-23.072100>, <0.496605,0.323497,-0.805439>
 <37.381901,-62.455898,-22.320601>, <0.503915,0.292939,-0.812562>
 <38.002998,-62.459599,-21.940901>, <0.492299,0.303485,-0.815805>
}
   smooth_triangle{ <36.762901,-63.469501,-23.072100>, <-0.496605,-0.323497,0.805439>
 <37.592602,-63.473400,-22.568501>, <-0.487817,-0.322392,0.811232>
 <38.002998,-62.459599,-21.940901>, <-0.492299,-0.303485,0.815805>
}
   smooth_triangle{ <36.762901,-63.469501,-23.072100>, <0.496605,0.323497,-0.805439>
 <38.002998,-62.459599,-21.940901>, <0.492299,0.303485,-0.815805>
 <37.592602,-63.473400,-22.568501>, <0.487817,0.322392,-0.811232>
}
   smooth_triangle{ <37.592602,-63.473400,-22.568501>, <-0.487817,-0.322392,0.811232>
 <38.601799,-62.459900,-21.585300>, <-0.477981,-0.311915,0.821123>
 <38.002998,-62.459599,-21.940901>, <-0.492299,-0.303485,0.815805>
}
   smooth_triangle{ <37.592602,-63.473400,-22.568501>, <0.487817,0.322392,-0.811232>
 <38.002998,-62.459599,-21.940901>, <0.492299,0.303485,-0.815805>
 <38.601799,-62.459900,-21.585300>, <0.477981,0.311915,-0.821123>
}
   smooth_triangle{ <37.592602,-63.473400,-22.568501>, <-0.487817,-0.322392,0.811232>
 <38.391602,-63.473301,-22.095600>, <-0.476681,-0.319548,0.818941>
 <38.601799,-62.459900,-21.585300>, <-0.477981,-0.311915,0.821123>
}
   smooth_triangle{ <37.592602,-63.473400,-22.568501>, <0.487817,0.322392,-0.811232>
 <38.601799,-62.459900,-21.585300>, <0.477981,0.311915,-0.821123>
 <38.391602,-63.473301,-22.095600>, <0.476681,0.319548,-0.818941>
}
   smooth_triangle{ <38.391602,-63.473301,-22.095600>, <-0.476681,-0.319548,0.818941>
 <39.217999,-62.456402,-21.231899>, <-0.464304,-0.315894,0.827425>
 <38.601799,-62.459900,-21.585300>, <-0.477981,-0.311915,0.821123>
}
   smooth_triangle{ <38.391602,-63.473301,-22.095600>, <0.476681,0.319548,-0.818941>
 <38.601799,-62.459900,-21.585300>, <0.477981,0.311915,-0.821123>
 <39.217999,-62.456402,-21.231899>, <0.464304,0.315894,-0.827425>
}
   smooth_triangle{ <38.391602,-63.473301,-22.095600>, <-0.476681,-0.319548,0.818941>
 <39.213100,-63.468700,-21.623899>, <-0.465676,-0.315037,0.826981>
 <39.217999,-62.456402,-21.231899>, <-0.464304,-0.315894,0.827425>
}
   smooth_triangle{ <38.391602,-63.473301,-22.095600>, <0.476681,0.319548,-0.818941>
 <39.217999,-62.456402,-21.231899>, <0.464304,0.315894,-0.827425>
 <39.213100,-63.468700,-21.623899>, <0.465676,0.315037,-0.826981>
}
   smooth_triangle{ <39.213100,-63.468700,-21.623899>, <-0.465676,-0.315037,0.826981>
 <39.909599,-62.448700,-20.847000>, <-0.454176,-0.314958,0.833382>
 <39.217999,-62.456402,-21.231899>, <-0.464304,-0.315894,0.827425>
}
   smooth_triangle{ <39.213100,-63.468700,-21.623899>, <0.465676,0.315037,-0.826981>
 <39.217999,-62.456402,-21.231899>, <0.464304,0.315894,-0.827425>
 <39.909599,-62.448700,-20.847000>, <0.454176,0.314958,-0.833382>
}
   smooth_triangle{ <39.213100,-63.468700,-21.623899>, <-0.465676,-0.315037,0.826981>
 <40.134102,-63.459301,-21.108801>, <-0.457099,-0.310370,0.833505>
 <39.909599,-62.448700,-20.847000>, <-0.454176,-0.314958,0.833382>
}
   smooth_triangle{ <39.213100,-63.468700,-21.623899>, <0.465676,0.315037,-0.826981>
 <39.909599,-62.448700,-20.847000>, <0.454176,0.314958,-0.833382>
 <40.134102,-63.459301,-21.108801>, <0.457099,0.310370,-0.833505>
}
   smooth_triangle{ <40.134102,-63.459301,-21.108801>, <-0.457099,-0.310370,0.833505>
 <40.635101,-62.438000,-20.451900>, <-0.446457,-0.310145,0.839337>
 <39.909599,-62.448700,-20.847000>, <-0.454176,-0.314958,0.833382>
}
   smooth_triangle{ <40.134102,-63.459301,-21.108801>, <0.457099,0.310370,-0.833505>
 <39.909599,-62.448700,-20.847000>, <0.454176,0.314958,-0.833382>
 <40.635101,-62.438000,-20.451900>, <0.446457,0.310145,-0.839337>
}
   smooth_triangle{ <40.134102,-63.459301,-21.108801>, <-0.457099,-0.310370,0.833505>
 <41.099602,-63.446400,-20.578899>, <-0.450184,-0.305906,0.838902>
 <40.635101,-62.438000,-20.451900>, <-0.446457,-0.310145,0.839337>
}
   smooth_triangle{ <40.134102,-63.459301,-21.108801>, <0.457099,0.310370,-0.833505>
 <40.635101,-62.438000,-20.451900>, <0.446457,0.310145,-0.839337>
 <41.099602,-63.446400,-20.578899>, <0.450184,0.305906,-0.838902>
}
   smooth_triangle{ <41.099602,-63.446400,-20.578899>, <-0.450184,-0.305906,0.838902>
 <41.305599,-62.425800,-20.094500>, <-0.437301,-0.300932,0.847471>
 <40.635101,-62.438000,-20.451900>, <-0.446457,-0.310145,0.839337>
}
   smooth_triangle{ <41.099602,-63.446400,-20.578899>, <0.450184,0.305906,-0.838902>
 <40.635101,-62.438000,-20.451900>, <0.446457,0.310145,-0.839337>
 <41.305599,-62.425800,-20.094500>, <0.437301,0.300932,-0.847471>
}
   smooth_triangle{ <41.099602,-63.446400,-20.578899>, <-0.450184,-0.305906,0.838902>
 <41.991299,-63.431599,-20.098400>, <-0.441663,-0.299467,0.845727>
 <41.305599,-62.425800,-20.094500>, <-0.437301,-0.300932,0.847471>
}
   smooth_triangle{ <41.099602,-63.446400,-20.578899>, <0.450184,0.305906,-0.838902>
 <41.305599,-62.425800,-20.094500>, <0.437301,0.300932,-0.847471>
 <41.991299,-63.431599,-20.098400>, <0.441663,0.299467,-0.845727>
}
   smooth_triangle{ <41.991299,-63.431599,-20.098400>, <-0.441663,-0.299467,0.845727>
 <41.832401,-62.413300,-19.822599>, <-0.434364,-0.296464,0.850551>
 <41.305599,-62.425800,-20.094500>, <-0.437301,-0.300932,0.847471>
}
   smooth_triangle{ <41.991299,-63.431599,-20.098400>, <0.441663,0.299467,-0.845727>
 <41.305599,-62.425800,-20.094500>, <0.437301,0.300932,-0.847471>
 <41.832401,-62.413300,-19.822599>, <0.472517,0.330733,-0.816911>
}
   smooth_triangle{ <41.991299,-63.431599,-20.098400>, <-0.441663,-0.299467,0.845727>
 <42.691299,-63.416801,-19.731800>, <-0.436676,-0.295358,0.849752>
 <41.832401,-62.413300,-19.822599>, <-0.434364,-0.296464,0.850551>
}
   smooth_triangle{ <41.991299,-63.431599,-20.098400>, <0.441663,0.299467,-0.845727>
 <41.832401,-62.413300,-19.822599>, <0.472517,0.330733,-0.816911>
 <42.691299,-63.416801,-19.731800>, <0.470993,0.327700,-0.819011>
}
   smooth_triangle{ <41.832401,-62.413300,-19.822599>, <0.472517,0.330733,-0.816911>
 <40.648998,-61.403702,-20.125299>, <0.500126,0.357030,-0.788926>
 <40.973499,-61.409801,-19.913500>, <0.473441,0.332315,-0.815733>
}
   smooth_triangle{ <41.832401,-62.413300,-19.822599>, <0.472517,0.330733,-0.816911>
 <41.343201,-62.405899,-20.136000>, <0.495818,0.351806,-0.793975>
 <40.648998,-61.403702,-20.125299>, <0.500126,0.357030,-0.788926>
}
   smooth_triangle{ <41.343201,-62.405899,-20.136000>, <0.495818,0.351806,-0.793975>
 <40.214802,-61.401798,-20.388599>, <0.481611,0.343887,-0.806097>
 <40.648998,-61.403702,-20.125299>, <0.500126,0.357030,-0.788926>
}
   smooth_triangle{ <41.343201,-62.405899,-20.136000>, <0.495818,0.351806,-0.793975>
 <40.690601,-62.403900,-20.528900>, <0.480296,0.340569,-0.808287>
 <40.214802,-61.401798,-20.388599>, <0.481611,0.343887,-0.806097>
}
   smooth_triangle{ <40.690601,-62.403900,-20.528900>, <0.480296,0.340569,-0.808287>
 <39.736099,-61.402401,-20.670000>, <0.473287,0.340742,-0.812339>
 <40.214802,-61.401798,-20.388599>, <0.481611,0.343887,-0.806097>
}
   smooth_triangle{ <40.690601,-62.403900,-20.528900>, <0.480296,0.340569,-0.808287>
 <39.972198,-62.405201,-20.950199>, <0.473257,0.337811,-0.813579>
 <39.736099,-61.402401,-20.670000>, <0.473287,0.340742,-0.812339>
}
   smooth_triangle{ <39.972198,-62.405201,-20.950199>, <0.473257,0.337811,-0.813579>
 <39.278198,-61.404202,-20.935499>, <0.466629,0.341252,-0.815968>
 <39.736099,-61.402401,-20.670000>, <0.473287,0.340742,-0.812339>
}
   smooth_triangle{ <39.972198,-62.405201,-20.950199>, <0.473257,0.337811,-0.813579>
 <39.285301,-62.407799,-21.348400>, <0.467877,0.338212,-0.816519>
 <39.278198,-61.404202,-20.935499>, <0.466629,0.341252,-0.815968>
}
   smooth_triangle{ <39.285301,-62.407799,-21.348400>, <0.467877,0.338212,-0.816519>
 <38.881100,-61.406898,-21.161800>, <0.453151,0.346532,-0.821322>
 <39.278198,-61.404202,-20.935499>, <0.466629,0.341252,-0.815968>
}
   smooth_triangle{ <39.285301,-62.407799,-21.348400>, <0.467877,0.338212,-0.816519>
 <38.689899,-62.411701,-21.688400>, <0.456525,0.342661,-0.821078>
 <38.881100,-61.406898,-21.161800>, <0.453151,0.346532,-0.821322>
}
   smooth_triangle{ <38.689899,-62.411701,-21.688400>, <0.456525,0.342661,-0.821078>
 <38.500801,-61.412399,-21.369301>, <0.433283,0.357858,-0.827166>
 <38.881100,-61.406898,-21.161800>, <0.453151,0.346532,-0.821322>
}
   smooth_triangle{ <38.689899,-62.411701,-21.688400>, <0.456525,0.342661,-0.821078>
 <38.120800,-62.419102,-22.001900>, <0.440122,0.352388,-0.825903>
 <38.500801,-61.412399,-21.369301>, <0.433283,0.357858,-0.827166>
}
   smooth_triangle{ <38.120800,-62.419102,-22.001900>, <0.440122,0.352388,-0.825903>
 <38.076900,-61.421600,-21.590500>, <0.415859,0.372102,-0.829820>
 <38.500801,-61.412399,-21.369301>, <0.433283,0.357858,-0.827166>
}
   smooth_triangle{ <38.120800,-62.419102,-22.001900>, <0.440122,0.352388,-0.825903>
 <37.487301,-62.431099,-22.338100>, <0.425594,0.364815,-0.828118>
 <38.076900,-61.421600,-21.590500>, <0.415859,0.372102,-0.829820>
}
   smooth_triangle{ <37.487301,-62.431099,-22.338100>, <0.425594,0.364815,-0.828118>
 <37.548500,-61.435699,-21.858200>, <0.467915,0.325649,-0.821589>
 <38.076900,-61.421600,-21.590500>, <0.415859,0.372102,-0.829820>
}
   smooth_triangle{ <37.487301,-62.431099,-22.338100>, <0.425594,0.364815,-0.828118>
 <36.698799,-62.449299,-22.746300>, <0.467515,0.327721,-0.820992>
 <37.548500,-61.435699,-21.858200>, <0.467915,0.325649,-0.821589>
}
   smooth_triangle{ <36.698799,-62.449299,-22.746300>, <-0.510964,-0.284269,0.811238>
 <38.002201,-61.441299,-21.571400>, <-0.510259,-0.284537,0.811588>
 <37.548500,-61.435699,-21.858200>, <-0.519721,-0.273147,0.809494>
}
   smooth_triangle{ <36.698799,-62.449299,-22.746300>, <0.467515,0.327721,-0.820992>
 <37.548500,-61.435699,-21.858200>, <0.467915,0.325649,-0.821589>
 <38.002201,-61.441299,-21.571400>, <0.510259,0.284537,-0.811588>
}
   smooth_triangle{ <36.698799,-62.449299,-22.746300>, <-0.510964,-0.284269,0.811238>
 <37.381901,-62.455898,-22.320601>, <-0.503915,-0.292939,0.812562>
 <38.002201,-61.441299,-21.571400>, <-0.510259,-0.284537,0.811588>
}
   smooth_triangle{ <36.698799,-62.449299,-22.746300>, <0.467515,0.327721,-0.820992>
 <38.002201,-61.441299,-21.571400>, <0.510259,0.284537,-0.811588>
 <37.381901,-62.455898,-22.320601>, <0.503915,0.292939,-0.812562>
}
   smooth_triangle{ <37.381901,-62.455898,-22.320601>, <-0.503915,-0.292939,0.812562>
 <38.415199,-61.444500,-21.316401>, <-0.496331,-0.297018,0.815742>
 <38.002201,-61.441299,-21.571400>, <-0.510259,-0.284537,0.811588>
}
   smooth_triangle{ <37.381901,-62.455898,-22.320601>, <0.503915,0.292939,-0.812562>
 <38.002201,-61.441299,-21.571400>, <0.510259,0.284537,-0.811588>
 <38.415199,-61.444500,-21.316401>, <0.496331,0.297018,-0.815742>
}
   smooth_triangle{ <37.381901,-62.455898,-22.320601>, <-0.503915,-0.292939,0.812562>
 <38.002998,-62.459599,-21.940901>, <-0.492299,-0.303485,0.815805>
 <38.415199,-61.444500,-21.316401>, <-0.496331,-0.297018,0.815742>
}
   smooth_triangle{ <37.381901,-62.455898,-22.320601>, <0.503915,0.292939,-0.812562>
 <38.415199,-61.444500,-21.316401>, <0.496331,0.297018,-0.815742>
 <38.002998,-62.459599,-21.940901>, <0.492299,0.303485,-0.815805>
}
   smooth_triangle{ <38.002998,-62.459599,-21.940901>, <-0.492299,-0.303485,0.815805>
 <38.813900,-61.445099,-21.078600>, <-0.479234,-0.306981,0.822251>
 <38.415199,-61.444500,-21.316401>, <-0.496331,-0.297018,0.815742>
}
   smooth_triangle{ <38.002998,-62.459599,-21.940901>, <0.492299,0.303485,-0.815805>
 <38.415199,-61.444500,-21.316401>, <0.496331,0.297018,-0.815742>
 <38.813900,-61.445099,-21.078600>, <0.479234,0.306981,-0.822251>
}
   smooth_triangle{ <38.002998,-62.459599,-21.940901>, <-0.492299,-0.303485,0.815805>
 <38.601799,-62.459900,-21.585300>, <-0.477981,-0.311915,0.821123>
 <38.813900,-61.445099,-21.078600>, <-0.479234,-0.306981,0.822251>
}
   smooth_triangle{ <38.002998,-62.459599,-21.940901>, <0.492299,0.303485,-0.815805>
 <38.813900,-61.445099,-21.078600>, <0.479234,0.306981,-0.822251>
 <38.601799,-62.459900,-21.585300>, <0.477981,0.311915,-0.821123>
}
   smooth_triangle{ <38.601799,-62.459900,-21.585300>, <-0.477981,-0.311915,0.821123>
 <39.224998,-61.442600,-20.843201>, <-0.462832,-0.311766,0.829813>
 <38.813900,-61.445099,-21.078600>, <-0.479234,-0.306981,0.822251>
}
   smooth_triangle{ <38.601799,-62.459900,-21.585300>, <0.477981,0.311915,-0.821123>
 <38.813900,-61.445099,-21.078600>, <0.479234,0.306981,-0.822251>
 <39.224998,-61.442600,-20.843201>, <0.462832,0.311766,-0.829813>
}
   smooth_triangle{ <38.601799,-62.459900,-21.585300>, <-0.477981,-0.311915,0.821123>
 <39.217999,-62.456402,-21.231899>, <-0.464304,-0.315894,0.827425>
 <39.224998,-61.442600,-20.843201>, <-0.462832,-0.311766,0.829813>
}
   smooth_triangle{ <38.601799,-62.459900,-21.585300>, <0.477981,0.311915,-0.821123>
 <39.224998,-61.442600,-20.843201>, <0.462832,0.311766,-0.829813>
 <39.217999,-62.456402,-21.231899>, <0.464304,0.315894,-0.827425>
}
   smooth_triangle{ <39.217999,-62.456402,-21.231899>, <-0.464304,-0.315894,0.827425>
 <39.686901,-61.436901,-20.587999>, <-0.450708,-0.310847,0.836801>
 <39.224998,-61.442600,-20.843201>, <-0.462832,-0.311766,0.829813>
}
   smooth_triangle{ <39.217999,-62.456402,-21.231899>, <0.464304,0.315894,-0.827425>
 <39.224998,-61.442600,-20.843201>, <0.462832,0.311766,-0.829813>
 <39.686901,-61.436901,-20.587999>, <0.450708,0.310847,-0.836801>
}
   smooth_triangle{ <39.217999,-62.456402,-21.231899>, <-0.464304,-0.315894,0.827425>
 <39.909599,-62.448700,-20.847000>, <-0.454176,-0.314958,0.833382>
 <39.686901,-61.436901,-20.587999>, <-0.450708,-0.310847,0.836801>
}
   smooth_triangle{ <39.217999,-62.456402,-21.231899>, <0.464304,0.315894,-0.827425>
 <39.686901,-61.436901,-20.587999>, <0.450708,0.310847,-0.836801>
 <39.909599,-62.448700,-20.847000>, <0.454176,0.314958,-0.833382>
}
   smooth_triangle{ <39.909599,-62.448700,-20.847000>, <-0.454176,-0.314958,0.833382>
 <40.171799,-61.428799,-20.327000>, <-0.441271,-0.305489,0.843775>
 <39.686901,-61.436901,-20.587999>, <-0.450708,-0.310847,0.836801>
}
   smooth_triangle{ <39.909599,-62.448700,-20.847000>, <0.454176,0.314958,-0.833382>
 <39.686901,-61.436901,-20.587999>, <0.450708,0.310847,-0.836801>
 <40.171799,-61.428799,-20.327000>, <0.441271,0.305489,-0.843775>
}
   smooth_triangle{ <39.909599,-62.448700,-20.847000>, <-0.454176,-0.314958,0.833382>
 <40.635101,-62.438000,-20.451900>, <-0.446457,-0.310145,0.839337>
 <40.171799,-61.428799,-20.327000>, <-0.441271,-0.305489,0.843775>
}
   smooth_triangle{ <39.909599,-62.448700,-20.847000>, <0.454176,0.314958,-0.833382>
 <40.171799,-61.428799,-20.327000>, <0.441271,0.305489,-0.843775>
 <40.635101,-62.438000,-20.451900>, <0.446457,0.310145,-0.839337>
}
   smooth_triangle{ <40.635101,-62.438000,-20.451900>, <-0.446457,-0.310145,0.839337>
 <40.620499,-61.419399,-20.091600>, <-0.430049,-0.294900,0.853283>
 <40.171799,-61.428799,-20.327000>, <-0.441271,-0.305489,0.843775>
}
   smooth_triangle{ <40.635101,-62.438000,-20.451900>, <0.446457,0.310145,-0.839337>
 <40.171799,-61.428799,-20.327000>, <0.441271,0.305489,-0.843775>
 <40.620499,-61.419399,-20.091600>, <0.433865,0.297680,-0.850381>
}
   smooth_triangle{ <40.635101,-62.438000,-20.451900>, <-0.446457,-0.310145,0.839337>
 <41.305599,-62.425800,-20.094500>, <-0.437301,-0.300932,0.847471>
 <40.620499,-61.419399,-20.091600>, <-0.430049,-0.294900,0.853283>
}
   smooth_triangle{ <40.635101,-62.438000,-20.451900>, <0.446457,0.310145,-0.839337>
 <40.620499,-61.419399,-20.091600>, <0.433865,0.297680,-0.850381>
 <41.305599,-62.425800,-20.094500>, <0.437301,0.300932,-0.847471>
}
   smooth_triangle{ <41.305599,-62.425800,-20.094500>, <-0.437301,-0.300932,0.847471>
 <40.973499,-61.409801,-19.913500>, <-0.427586,-0.290720,0.855951>
 <40.620499,-61.419399,-20.091600>, <-0.430049,-0.294900,0.853283>
}
   smooth_triangle{ <41.305599,-62.425800,-20.094500>, <0.437301,0.300932,-0.847471>
 <40.620499,-61.419399,-20.091600>, <0.433865,0.297680,-0.850381>
 <40.973499,-61.409801,-19.913500>, <0.473441,0.332315,-0.815733>
}
   smooth_triangle{ <41.305599,-62.425800,-20.094500>, <-0.437301,-0.300932,0.847471>
 <41.832401,-62.413300,-19.822599>, <-0.434364,-0.296464,0.850551>
 <40.973499,-61.409801,-19.913500>, <-0.427586,-0.290720,0.855951>
}
   smooth_triangle{ <41.305599,-62.425800,-20.094500>, <0.437301,0.300932,-0.847471>
 <40.973499,-61.409801,-19.913500>, <0.473441,0.332315,-0.815733>
 <41.832401,-62.413300,-19.822599>, <0.472517,0.330733,-0.816911>
}
   smooth_triangle{ <40.973499,-61.409801,-19.913500>, <0.473441,0.332315,-0.815733>
 <39.953300,-60.402599,-20.112000>, <0.508787,0.368693,-0.777947>
 <40.114101,-60.406700,-20.003500>, <0.492386,0.351241,-0.796358>
}
   smooth_triangle{ <40.973499,-61.409801,-19.913500>, <0.473441,0.332315,-0.815733>
 <40.648998,-61.403702,-20.125299>, <0.500126,0.357030,-0.788926>
 <39.953300,-60.402599,-20.112000>, <0.508787,0.368693,-0.777947>
}
   smooth_triangle{ <40.648998,-61.403702,-20.125299>, <0.500126,0.357030,-0.788926>
 <39.737000,-60.401001,-20.245001>, <0.484563,0.351827,-0.800885>
 <39.953300,-60.402599,-20.112000>, <0.508787,0.368693,-0.777947>
}
   smooth_triangle{ <40.648998,-61.403702,-20.125299>, <0.500126,0.357030,-0.788926>
 <40.214802,-61.401798,-20.388599>, <0.481611,0.343887,-0.806097>
 <39.737000,-60.401001,-20.245001>, <0.484563,0.351827,-0.800885>
}
   smooth_triangle{ <40.214802,-61.401798,-20.388599>, <0.481611,0.343887,-0.806097>
 <39.498001,-60.401199,-20.386200>, <0.473610,0.347633,-0.809225>
 <39.737000,-60.401001,-20.245001>, <0.484563,0.351827,-0.800885>
}
   smooth_triangle{ <40.214802,-61.401798,-20.388599>, <0.481611,0.343887,-0.806097>
 <39.736099,-61.402401,-20.670000>, <0.473287,0.340742,-0.812339>
 <39.498001,-60.401199,-20.386200>, <0.473610,0.347633,-0.809225>
}
   smooth_triangle{ <39.736099,-61.402401,-20.670000>, <0.473287,0.340742,-0.812339>
 <39.269100,-60.402000,-20.519100>, <0.465694,0.347893,-0.813695>
 <39.498001,-60.401199,-20.386200>, <0.473610,0.347633,-0.809225>
}
   smooth_triangle{ <39.736099,-61.402401,-20.670000>, <0.473287,0.340742,-0.812339>
 <39.278198,-61.404202,-20.935499>, <0.466629,0.341252,-0.815968>
 <39.269100,-60.402000,-20.519100>, <0.465694,0.347893,-0.813695>
}
   smooth_triangle{ <39.278198,-61.404202,-20.935499>, <0.466629,0.341252,-0.815968>
 <39.070202,-60.403599,-20.631701>, <0.451011,0.352825,-0.819819>
 <39.269100,-60.402000,-20.519100>, <0.465694,0.347893,-0.813695>
}
   smooth_triangle{ <39.278198,-61.404202,-20.935499>, <0.466629,0.341252,-0.815968>
 <38.881100,-61.406898,-21.161800>, <0.453151,0.346532,-0.821322>
 <39.070202,-60.403599,-20.631701>, <0.451011,0.352825,-0.819819>
}
   smooth_triangle{ <38.881100,-61.406898,-21.161800>, <0.453151,0.346532,-0.821322>
 <38.879398,-60.406799,-20.734100>, <0.427840,0.364457,-0.827118>
 <39.070202,-60.403599,-20.631701>, <0.451011,0.352825,-0.819819>
}
   smooth_triangle{ <38.881100,-61.406898,-21.161800>, <0.453151,0.346532,-0.821322>
 <38.500801,-61.412399,-21.369301>, <0.433283,0.357858,-0.827166>
 <38.879398,-60.406799,-20.734100>, <0.427840,0.364457,-0.827118>
}
   smooth_triangle{ <38.500801,-61.412399,-21.369301>, <0.433283,0.357858,-0.827166>
 <38.665901,-60.412498,-20.842199>, <0.406140,0.379380,-0.831337>
 <38.879398,-60.406799,-20.734100>, <0.427840,0.364457,-0.827118>
}
   smooth_triangle{ <38.500801,-61.412399,-21.369301>, <0.433283,0.357858,-0.827166>
 <38.076900,-61.421600,-21.590500>, <0.415859,0.372102,-0.829820>
 <38.665901,-60.412498,-20.842199>, <0.406140,0.379380,-0.831337>
}
   smooth_triangle{ <38.076900,-61.421600,-21.590500>, <0.415859,0.372102,-0.829820>
 <38.399300,-60.421299,-20.971901>, <0.452006,0.337490,-0.825706>
 <38.665901,-60.412498,-20.842199>, <0.406140,0.379380,-0.831337>
}
   smooth_triangle{ <38.076900,-61.421600,-21.590500>, <0.415859,0.372102,-0.829820>
 <37.548500,-61.435699,-21.858200>, <0.467915,0.325649,-0.821589>
 <38.399300,-60.421299,-20.971901>, <0.452006,0.337490,-0.825706>
}
   smooth_triangle{ <37.548500,-61.435699,-21.858200>, <-0.519721,-0.273147,0.809494>
 <38.624699,-60.425201,-20.825899>, <-0.520007,-0.269552,0.810515>
 <38.399300,-60.421299,-20.971901>, <-0.528150,-0.259843,0.808418>
}
   smooth_triangle{ <37.548500,-61.435699,-21.858200>, <0.467915,0.325649,-0.821589>
 <38.399300,-60.421299,-20.971901>, <0.452006,0.337490,-0.825706>
 <38.624699,-60.425201,-20.825899>, <0.520007,0.269552,-0.810515>
}
   smooth_triangle{ <37.548500,-61.435699,-21.858200>, <-0.519721,-0.273147,0.809494>
 <38.002201,-61.441299,-21.571400>, <-0.510259,-0.284537,0.811588>
 <38.624699,-60.425201,-20.825899>, <-0.520007,-0.269552,0.810515>
}
   smooth_triangle{ <37.548500,-61.435699,-21.858200>, <0.467915,0.325649,-0.821589>
 <38.624699,-60.425201,-20.825899>, <0.520007,0.269552,-0.810515>
 <38.002201,-61.441299,-21.571400>, <0.510259,0.284537,-0.811588>
}
   smooth_triangle{ <38.002201,-61.441299,-21.571400>, <-0.510259,-0.284537,0.811588>
 <38.830200,-60.427502,-20.696699>, <-0.504214,-0.283530,0.815708>
 <38.624699,-60.425201,-20.825899>, <-0.520007,-0.269552,0.810515>
}
   smooth_triangle{ <38.002201,-61.441299,-21.571400>, <0.510259,0.284537,-0.811588>
 <38.624699,-60.425201,-20.825899>, <0.520007,0.269552,-0.810515>
 <38.830200,-60.427502,-20.696699>, <0.504214,0.283530,-0.815708>
}
   smooth_triangle{ <38.002201,-61.441299,-21.571400>, <-0.510259,-0.284537,0.811588>
 <38.415199,-61.444500,-21.316401>, <-0.496331,-0.297018,0.815742>
 <38.830200,-60.427502,-20.696699>, <-0.504214,-0.283530,0.815708>
}
   smooth_triangle{ <38.002201,-61.441299,-21.571400>, <0.510259,0.284537,-0.811588>
 <38.830200,-60.427502,-20.696699>, <0.504214,0.283530,-0.815708>
 <38.415199,-61.444500,-21.316401>, <0.496331,0.297018,-0.815742>
}
   smooth_triangle{ <38.415199,-61.444500,-21.316401>, <-0.496331,-0.297018,0.815742>
 <39.029099,-60.428101,-20.577000>, <-0.484192,-0.295621,0.823508>
 <38.830200,-60.427502,-20.696699>, <-0.504214,-0.283530,0.815708>
}
   smooth_triangle{ <38.415199,-61.444500,-21.316401>, <0.496331,0.297018,-0.815742>
 <38.830200,-60.427502,-20.696699>, <0.504214,0.283530,-0.815708>
 <39.029099,-60.428101,-20.577000>, <0.484192,0.295621,-0.823508>
}
   smooth_triangle{ <38.415199,-61.444500,-21.316401>, <-0.496331,-0.297018,0.815742>
 <38.813900,-61.445099,-21.078600>, <-0.479234,-0.306981,0.822251>
 <39.029099,-60.428101,-20.577000>, <-0.484192,-0.295621,0.823508>
}
   smooth_triangle{ <38.415199,-61.444500,-21.316401>, <0.496331,0.297018,-0.815742>
 <39.029099,-60.428101,-20.577000>, <0.484192,0.295621,-0.823508>
 <38.813900,-61.445099,-21.078600>, <0.479234,0.306981,-0.822251>
}
   smooth_triangle{ <38.813900,-61.445099,-21.078600>, <-0.479234,-0.306981,0.822251>
 <39.234798,-60.426701,-20.459499>, <-0.463941,-0.302598,0.832582>
 <39.029099,-60.428101,-20.577000>, <-0.484192,-0.295621,0.823508>
}
   smooth_triangle{ <38.813900,-61.445099,-21.078600>, <0.479234,0.306981,-0.822251>
 <39.029099,-60.428101,-20.577000>, <0.484192,0.295621,-0.823508>
 <39.234798,-60.426701,-20.459499>, <0.463941,0.302598,-0.832582>
}
   smooth_triangle{ <38.813900,-61.445099,-21.078600>, <-0.479234,-0.306981,0.822251>
 <39.224998,-61.442600,-20.843201>, <-0.462832,-0.311766,0.829813>
 <39.234798,-60.426701,-20.459499>, <-0.463941,-0.302598,0.832582>
}
   smooth_triangle{ <38.813900,-61.445099,-21.078600>, <0.479234,0.306981,-0.822251>
 <39.234798,-60.426701,-20.459499>, <0.463941,0.302598,-0.832582>
 <39.224998,-61.442600,-20.843201>, <0.462832,0.311766,-0.829813>
}
   smooth_triangle{ <39.224998,-61.442600,-20.843201>, <-0.462832,-0.311766,0.829813>
 <39.466499,-60.423302,-20.333300>, <-0.448371,-0.303256,0.840832>
 <39.234798,-60.426701,-20.459499>, <-0.463941,-0.302598,0.832582>
}
   smooth_triangle{ <39.224998,-61.442600,-20.843201>, <0.462832,0.311766,-0.829813>
 <39.234798,-60.426701,-20.459499>, <0.463941,0.302598,-0.832582>
 <39.466499,-60.423302,-20.333300>, <0.448371,0.303256,-0.840832>
}
   smooth_triangle{ <39.224998,-61.442600,-20.843201>, <-0.462832,-0.311766,0.829813>
 <39.686901,-61.436901,-20.587999>, <-0.450708,-0.310847,0.836801>
 <39.466499,-60.423302,-20.333300>, <-0.448371,-0.303256,0.840832>
}
   smooth_triangle{ <39.224998,-61.442600,-20.843201>, <0.462832,0.311766,-0.829813>
 <39.466499,-60.423302,-20.333300>, <0.448371,0.303256,-0.840832>
 <39.686901,-61.436901,-20.587999>, <0.450708,0.310847,-0.836801>
}
   smooth_triangle{ <39.686901,-61.436901,-20.587999>, <-0.450708,-0.310847,0.836801>
 <39.710098,-60.418400,-20.204901>, <-0.436718,-0.298902,0.848490>
 <39.466499,-60.423302,-20.333300>, <-0.448371,-0.303256,0.840832>
}
   smooth_triangle{ <39.686901,-61.436901,-20.587999>, <0.450708,0.310847,-0.836801>
 <39.466499,-60.423302,-20.333300>, <0.448371,0.303256,-0.840832>
 <39.710098,-60.418400,-20.204901>, <0.436718,0.298902,-0.848490>
}
   smooth_triangle{ <39.686901,-61.436901,-20.587999>, <-0.450708,-0.310847,0.836801>
 <40.171799,-61.428799,-20.327000>, <-0.441271,-0.305489,0.843775>
 <39.710098,-60.418400,-20.204901>, <-0.436718,-0.298902,0.848490>
}
   smooth_triangle{ <39.686901,-61.436901,-20.587999>, <0.450708,0.310847,-0.836801>
 <39.710098,-60.418400,-20.204901>, <0.436718,0.298902,-0.848490>
 <40.171799,-61.428799,-20.327000>, <0.441271,0.305489,-0.843775>
}
   smooth_triangle{ <40.171799,-61.428799,-20.327000>, <-0.441271,-0.305489,0.843775>
 <39.935902,-60.412601,-20.089800>, <-0.423389,-0.288998,0.858616>
 <39.710098,-60.418400,-20.204901>, <-0.436718,-0.298902,0.848490>
}
   smooth_triangle{ <40.171799,-61.428799,-20.327000>, <0.441271,0.305489,-0.843775>
 <39.710098,-60.418400,-20.204901>, <0.436718,0.298902,-0.848490>
 <39.935902,-60.412601,-20.089800>, <0.431527,0.295638,-0.852281>
}
   smooth_triangle{ <40.171799,-61.428799,-20.327000>, <-0.441271,-0.305489,0.843775>
 <40.620499,-61.419399,-20.091600>, <-0.430049,-0.294900,0.853283>
 <39.935902,-60.412601,-20.089800>, <-0.423389,-0.288998,0.858616>
}
   smooth_triangle{ <40.171799,-61.428799,-20.327000>, <0.441271,0.305489,-0.843775>
 <39.935902,-60.412601,-20.089800>, <0.431527,0.295638,-0.852281>
 <40.620499,-61.419399,-20.091600>, <0.433865,0.297680,-0.850381>
}
   smooth_triangle{ <40.620499,-61.419399,-20.091600>, <-0.430049,-0.294900,0.853283>
 <40.114101,-60.406700,-20.003500>, <-0.415799,-0.281748,0.864713>
 <39.935902,-60.412601,-20.089800>, <-0.423389,-0.288998,0.858616>
}
   smooth_triangle{ <40.620499,-61.419399,-20.091600>, <-0.430049,-0.294900,0.853283>
 <40.973499,-61.409801,-19.913500>, <-0.427586,-0.290720,0.855951>
 <40.114101,-60.406700,-20.003500>, <-0.415799,-0.281748,0.864713>
}
   smooth_triangle{ <40.620499,-61.419399,-20.091600>, <0.433865,0.297680,-0.850381>
 <40.114101,-60.406700,-20.003500>, <0.492386,0.351241,-0.796358>
 <40.973499,-61.409801,-19.913500>, <0.473441,0.332315,-0.815733>
}
   smooth_triangle{ <40.114101,-60.406700,-20.003500>, <0.492386,0.351241,-0.796358>
 <39.953300,-60.402599,-20.112000>, <0.508787,0.368693,-0.777947>
 <39.253502,-59.404400,-20.091400>, <0.466903,0.328534,-0.821016>
}
   smooth_triangle{ <39.953300,-60.402599,-20.112000>, <0.508787,0.368693,-0.777947>
 <39.737000,-60.401001,-20.245001>, <0.484563,0.351827,-0.800885>
 <39.253502,-59.404400,-20.091400>, <0.466903,0.328534,-0.821016>
}
   smooth_triangle{ <39.737000,-60.401001,-20.245001>, <0.484563,0.351827,-0.800885>
 <39.498001,-60.401199,-20.386200>, <0.473610,0.347633,-0.809225>
 <39.253502,-59.404400,-20.091400>, <0.466903,0.328534,-0.821016>
}
   smooth_triangle{ <39.498001,-60.401199,-20.386200>, <0.473610,0.347633,-0.809225>
 <39.269100,-60.402000,-20.519100>, <0.465694,0.347893,-0.813695>
 <39.253502,-59.404400,-20.091400>, <0.466903,0.328534,-0.821016>
}
   smooth_triangle{ <39.269100,-60.402000,-20.519100>, <0.465694,0.347893,-0.813695>
 <39.070202,-60.403599,-20.631701>, <0.451011,0.352825,-0.819819>
 <39.253502,-59.404400,-20.091400>, <0.466903,0.328534,-0.821016>
}
   smooth_triangle{ <39.070202,-60.403599,-20.631701>, <0.451011,0.352825,-0.819819>
 <38.879398,-60.406799,-20.734100>, <0.427840,0.364457,-0.827118>
 <39.253502,-59.404400,-20.091400>, <0.466903,0.328534,-0.821016>
}
   smooth_triangle{ <38.879398,-60.406799,-20.734100>, <0.427840,0.364457,-0.827118>
 <38.665901,-60.412498,-20.842199>, <0.406140,0.379380,-0.831337>
 <39.253502,-59.404400,-20.091400>, <0.466903,0.328534,-0.821016>
}
   smooth_triangle{ <38.665901,-60.412498,-20.842199>, <0.406140,0.379380,-0.831337>
 <38.399300,-60.421299,-20.971901>, <0.452006,0.337490,-0.825706>
 <39.253502,-59.404400,-20.091400>, <0.466903,0.328534,-0.821016>
}
   smooth_triangle{ <38.399300,-60.421299,-20.971901>, <-0.528150,-0.259843,0.808418>
 <38.624699,-60.425201,-20.825899>, <-0.520007,-0.269552,0.810515>
 <39.253502,-59.404400,-20.091400>, <-0.468868,-0.281712,0.837139>
}
   smooth_triangle{ <38.399300,-60.421299,-20.971901>, <0.452006,0.337490,-0.825706>
 <39.253502,-59.404400,-20.091400>, <0.466903,0.328534,-0.821016>
 <38.624699,-60.425201,-20.825899>, <0.520007,0.269552,-0.810515>
}
   smooth_triangle{ <38.624699,-60.425201,-20.825899>, <-0.520007,-0.269552,0.810515>
 <38.830200,-60.427502,-20.696699>, <-0.504214,-0.283530,0.815708>
 <39.253502,-59.404400,-20.091400>, <-0.468868,-0.281712,0.837139>
}
   smooth_triangle{ <38.624699,-60.425201,-20.825899>, <0.520007,0.269552,-0.810515>
 <39.253502,-59.404400,-20.091400>, <0.466903,0.328534,-0.821016>
 <38.830200,-60.427502,-20.696699>, <0.504214,0.283530,-0.815708>
}
   smooth_triangle{ <38.830200,-60.427502,-20.696699>, <-0.504214,-0.283530,0.815708>
 <39.029099,-60.428101,-20.577000>, <-0.484192,-0.295621,0.823508>
 <39.253502,-59.404400,-20.091400>, <-0.468868,-0.281712,0.837139>
}
   smooth_triangle{ <38.830200,-60.427502,-20.696699>, <0.504214,0.283530,-0.815708>
 <39.253502,-59.404400,-20.091400>, <0.466903,0.328534,-0.821016>
 <39.029099,-60.428101,-20.577000>, <0.484192,0.295621,-0.823508>
}
   smooth_triangle{ <39.029099,-60.428101,-20.577000>, <-0.484192,-0.295621,0.823508>
 <39.234798,-60.426701,-20.459499>, <-0.463941,-0.302598,0.832582>
 <39.253502,-59.404400,-20.091400>, <-0.468868,-0.281712,0.837139>
}
   smooth_triangle{ <39.029099,-60.428101,-20.577000>, <0.484192,0.295621,-0.823508>
 <39.253502,-59.404400,-20.091400>, <0.466903,0.328534,-0.821016>
 <39.234798,-60.426701,-20.459499>, <0.463941,0.302598,-0.832582>
}
   smooth_triangle{ <39.234798,-60.426701,-20.459499>, <-0.463941,-0.302598,0.832582>
 <39.466499,-60.423302,-20.333300>, <-0.448371,-0.303256,0.840832>
 <39.253502,-59.404400,-20.091400>, <-0.468868,-0.281712,0.837139>
}
   smooth_triangle{ <39.234798,-60.426701,-20.459499>, <0.463941,0.302598,-0.832582>
 <39.253502,-59.404400,-20.091400>, <0.466903,0.328534,-0.821016>
 <39.466499,-60.423302,-20.333300>, <0.448371,0.303256,-0.840832>
}
   smooth_triangle{ <39.466499,-60.423302,-20.333300>, <-0.448371,-0.303256,0.840832>
 <39.710098,-60.418400,-20.204901>, <-0.436718,-0.298902,0.848490>
 <39.253502,-59.404400,-20.091400>, <-0.468868,-0.281712,0.837139>
}
   smooth_triangle{ <39.466499,-60.423302,-20.333300>, <0.448371,0.303256,-0.840832>
 <39.253502,-59.404400,-20.091400>, <0.466903,0.328534,-0.821016>
 <39.710098,-60.418400,-20.204901>, <0.436718,0.298902,-0.848490>
}
   smooth_triangle{ <39.710098,-60.418400,-20.204901>, <-0.436718,-0.298902,0.848490>
 <39.935902,-60.412601,-20.089800>, <-0.423389,-0.288998,0.858616>
 <39.253502,-59.404400,-20.091400>, <-0.468868,-0.281712,0.837139>
}
   smooth_triangle{ <39.710098,-60.418400,-20.204901>, <0.436718,0.298902,-0.848490>
 <39.253502,-59.404400,-20.091400>, <0.466903,0.328534,-0.821016>
 <39.935902,-60.412601,-20.089800>, <0.431527,0.295638,-0.852281>
}
   smooth_triangle{ <39.935902,-60.412601,-20.089800>, <-0.423389,-0.288998,0.858616>
 <40.114101,-60.406700,-20.003500>, <-0.415799,-0.281748,0.864713>
 <39.253502,-59.404400,-20.091400>, <-0.468868,-0.281712,0.837139>
}
}
texture
      { pigment{bozo colour_map{[0.2 red 0.74 green 0.74 blue 0.75][0.8 red 0.4 green 0.4 blue 0.5]}
     scale 4.5
}
      }
      finish
     {ambient 0.4 diffuse 0.5
     specular 0.2 roughness 0.1}
}
//  Object:  oznake la
object
{   union{
   smooth_triangle{ <23.710100,-58.623699,-29.071501>, <-0.772254,0.605555,-0.192166>
 <23.080999,-59.669201,-29.834499>, <-0.772021,0.605527,-0.193186>
 <22.747801,-59.909801,-29.257099>, <-0.772254,0.605555,-0.192166>
}
   smooth_triangle{ <23.710100,-58.623699,-29.071501>, <0.772254,-0.605555,0.192166>
 <22.747801,-59.909801,-29.257099>, <0.862581,-0.373434,0.341322>
 <23.080999,-59.669201,-29.834499>, <0.877474,-0.082675,0.472445>
}
   smooth_triangle{ <23.710100,-58.623699,-29.071501>, <-0.772254,0.605555,-0.192166>
 <22.747801,-59.909801,-29.257099>, <-0.772254,0.605555,-0.192166>
 <23.397100,-58.851700,-28.528900>, <-0.772486,0.605581,-0.191145>
}
   smooth_triangle{ <23.710100,-58.623699,-29.071501>, <0.772254,-0.605555,0.192166>
 <23.397100,-58.851700,-28.528900>, <0.772486,-0.605581,0.191145>
 <22.747801,-59.909801,-29.257099>, <0.862581,-0.373434,0.341322>
}
   smooth_triangle{ <23.080999,-59.669201,-29.834499>, <0.877474,-0.082675,0.472445>
 <22.316799,-57.507198,-29.448500>, <0.863717,-0.370202,0.341969>
 <22.025400,-57.721901,-28.943399>, <0.878087,-0.081070,0.471584>
}
   smooth_triangle{ <23.080999,-59.669201,-29.834499>, <0.877474,-0.082675,0.472445>
 <22.025400,-57.721901,-28.943399>, <0.878087,-0.081070,0.471584>
 <22.747801,-59.909801,-29.257099>, <0.862581,-0.373434,0.341322>
}
   smooth_triangle{ <22.316799,-57.507198,-29.448500>, <-0.775305,0.601345,-0.193095>
 <21.621799,-58.676998,-30.297001>, <-0.774976,0.601375,-0.194319>
 <21.307899,-58.905701,-29.752899>, <-0.775305,0.601345,-0.193095>
}
   smooth_triangle{ <22.316799,-57.507198,-29.448500>, <0.863717,-0.370202,0.341969>
 <21.307899,-58.905701,-29.752899>, <0.775305,-0.601345,0.193095>
 <21.621799,-58.676998,-30.297001>, <0.774976,-0.601375,0.194319>
}
   smooth_triangle{ <22.316799,-57.507198,-29.448500>, <-0.775305,0.601345,-0.193095>
 <21.307899,-58.905701,-29.752899>, <-0.775305,0.601345,-0.193095>
 <22.025400,-57.721901,-28.943399>, <-0.775632,0.601315,-0.191872>
}
   smooth_triangle{ <22.316799,-57.507198,-29.448500>, <0.863717,-0.370202,0.341969>
 <22.025400,-57.721901,-28.943399>, <0.878087,-0.081070,0.471584>
 <21.307899,-58.905701,-29.752899>, <0.775305,-0.601345,0.193095>
}
   smooth_triangle{ <21.621799,-58.676998,-30.297001>, <0.421859,0.722242,0.548090>
 <20.565001,-57.839298,-30.586399>, <0.421741,0.721681,0.548919>
 <20.267300,-58.057800,-30.070400>, <0.421859,0.722242,0.548090>
}
   smooth_triangle{ <21.621799,-58.676998,-30.297001>, <0.421859,0.722242,0.548090>
 <20.267300,-58.057800,-30.070400>, <0.421859,0.722242,0.548090>
 <21.307899,-58.905701,-29.752899>, <0.421976,0.722802,0.547260>
}
   smooth_triangle{ <20.565001,-57.839298,-30.586399>, <-0.775278,0.601362,-0.193151>
 <20.365801,-58.174702,-30.829700>, <-0.775335,0.601075,-0.193817>
 <20.061600,-58.397099,-30.302500>, <-0.775278,0.601362,-0.193151>
}
   smooth_triangle{ <20.565001,-57.839298,-30.586399>, <0.775278,-0.601362,0.193151>
 <20.061600,-58.397099,-30.302500>, <0.775278,-0.601362,0.193151>
 <20.365801,-58.174702,-30.829700>, <0.775335,-0.601075,0.193817>
}
   smooth_triangle{ <20.565001,-57.839298,-30.586399>, <-0.775278,0.601362,-0.193151>
 <20.061600,-58.397099,-30.302500>, <-0.775278,0.601362,-0.193151>
 <20.267300,-58.057800,-30.070400>, <-0.775221,0.601650,-0.192485>
}
   smooth_triangle{ <20.565001,-57.839298,-30.586399>, <0.775278,-0.601362,0.193151>
 <20.267300,-58.057800,-30.070400>, <0.775221,-0.601650,0.192485>
 <20.061600,-58.397099,-30.302500>, <0.775278,-0.601362,0.193151>
}
   smooth_triangle{ <20.365801,-58.174702,-30.829700>, <-0.422386,-0.722588,-0.547227>
 <21.633900,-59.180000,-30.482401>, <-0.423250,-0.722673,-0.546446>
 <21.310301,-59.414600,-29.921499>, <-0.422386,-0.722588,-0.547227>
}
   smooth_triangle{ <20.365801,-58.174702,-30.829700>, <0.422386,0.722588,0.547227>
 <21.310301,-59.414600,-29.921499>, <0.422386,0.722588,0.547227>
 <21.633900,-59.180000,-30.482401>, <0.423250,0.722673,0.546446>
}
   smooth_triangle{ <20.365801,-58.174702,-30.829700>, <-0.422386,-0.722588,-0.547227>
 <21.310301,-59.414600,-29.921499>, <-0.422386,-0.722588,-0.547227>
 <20.061600,-58.397099,-30.302500>, <-0.421522,-0.722501,-0.548007>
}
   smooth_triangle{ <20.365801,-58.174702,-30.829700>, <0.422386,0.722588,0.547227>
 <20.061600,-58.397099,-30.302500>, <0.421522,0.722501,0.548007>
 <21.310301,-59.414600,-29.921499>, <0.422386,0.722588,0.547227>
}
   smooth_triangle{ <21.633900,-59.180000,-30.482401>, <0.774782,-0.601694,0.194108>
 <22.271500,-58.106800,-29.704000>, <0.877738,-0.078639,0.472644>
 <21.968500,-58.328602,-29.178801>, <0.863595,-0.369435,0.343104>
}
   smooth_triangle{ <21.633900,-59.180000,-30.482401>, <0.774782,-0.601694,0.194108>
 <21.968500,-58.328602,-29.178801>, <0.863595,-0.369435,0.343104>
 <21.310301,-59.414600,-29.921499>, <0.774138,-0.602334,0.194691>
}
   smooth_triangle{ <22.271500,-58.106800,-29.704000>, <-0.812782,-0.192970,-0.549680>
 <23.049000,-60.286598,-30.089199>, <-0.813129,-0.192986,-0.549161>
 <22.703899,-60.534500,-29.491100>, <-0.812782,-0.192970,-0.549680>
}
   smooth_triangle{ <22.271500,-58.106800,-29.704000>, <0.877738,-0.078639,0.472644>
 <22.703899,-60.534500,-29.491100>, <0.877092,-0.079343,0.473723>
 <23.049000,-60.286598,-30.089199>, <0.863243,-0.369756,0.343644>
}
   smooth_triangle{ <22.271500,-58.106800,-29.704000>, <-0.812782,-0.192970,-0.549680>
 <22.703899,-60.534500,-29.491100>, <-0.812782,-0.192970,-0.549680>
 <21.968500,-58.328602,-29.178801>, <-0.812434,-0.192954,-0.550199>
}
   smooth_triangle{ <22.271500,-58.106800,-29.704000>, <0.877738,-0.078639,0.472644>
 <21.968500,-58.328602,-29.178801>, <0.863595,-0.369435,0.343104>
 <22.703899,-60.534500,-29.491100>, <0.877092,-0.079343,0.473723>
}
   smooth_triangle{ <23.049000,-60.286598,-30.089199>, <0.863243,-0.369756,0.343644>
 <23.932501,-58.799400,-29.010401>, <0.774859,-0.601450,0.194555>
 <23.616100,-59.029598,-28.461901>, <0.774064,-0.602196,0.195409>
}
   smooth_triangle{ <23.049000,-60.286598,-30.089199>, <0.863243,-0.369756,0.343644>
 <23.616100,-59.029598,-28.461901>, <0.774064,-0.602196,0.195409>
 <22.703899,-60.534500,-29.491100>, <0.877092,-0.079343,0.473723>
}
   smooth_triangle{ <23.932501,-58.799400,-29.010401>, <0.421055,0.723691,0.546794>
 <23.710100,-58.623699,-29.071501>, <0.421253,0.723431,0.546986>
 <23.397100,-58.851700,-28.528900>, <0.421055,0.723691,0.546794>
}
   smooth_triangle{ <23.932501,-58.799400,-29.010401>, <0.421055,0.723691,0.546794>
 <23.397100,-58.851700,-28.528900>, <0.421055,0.723691,0.546794>
 <23.616100,-59.029598,-28.461901>, <0.420857,0.723951,0.546602>
}
   smooth_triangle{ <20.649401,-60.646500,-31.611601>, <-0.758538,-0.317559,-0.569013>
 <20.663601,-60.789001,-31.657801>, <-0.862094,-0.021513,-0.506291>
 <20.309000,-61.042801,-31.043301>, <-0.870039,0.023162,-0.492439>
}
   smooth_triangle{ <20.649401,-60.646500,-31.611601>, <0.758538,0.317559,0.569013>
 <20.309000,-61.042801,-31.043301>, <0.870039,-0.023162,0.492439>
 <20.663601,-60.789001,-31.657801>, <0.862094,0.021513,0.506291>
}
   smooth_triangle{ <20.649401,-60.646500,-31.611601>, <-0.758538,-0.317559,-0.569013>
 <20.309000,-61.042801,-31.043301>, <-0.870039,0.023162,-0.492439>
 <20.297600,-60.898701,-31.001801>, <-0.429826,-0.719229,-0.545857>
}
   smooth_triangle{ <20.649401,-60.646500,-31.611601>, <0.758538,0.317559,0.569013>
 <20.297600,-60.898701,-31.001801>, <0.429826,0.719229,0.545857>
 <20.309000,-61.042801,-31.043301>, <0.870039,-0.023162,0.492439>
}
   smooth_triangle{ <20.663601,-60.789001,-31.657801>, <-0.862094,-0.021513,-0.506291>
 <20.696199,-60.931099,-31.693399>, <-0.826699,-0.155081,-0.540849>
 <20.338900,-61.186600,-31.073999>, <-0.840420,-0.110666,-0.530515>
}
   smooth_triangle{ <20.663601,-60.789001,-31.657801>, <0.862094,0.021513,0.506291>
 <20.338900,-61.186600,-31.073999>, <0.840420,0.110666,0.530515>
 <20.696199,-60.931099,-31.693399>, <0.826699,0.155081,0.540849>
}
   smooth_triangle{ <20.663601,-60.789001,-31.657801>, <-0.862094,-0.021513,-0.506291>
 <20.338900,-61.186600,-31.073999>, <-0.840420,-0.110666,-0.530515>
 <20.309000,-61.042801,-31.043301>, <-0.870039,0.023162,-0.492439>
}
   smooth_triangle{ <20.663601,-60.789001,-31.657801>, <0.862094,0.021513,0.506291>
 <20.309000,-61.042801,-31.043301>, <0.870039,-0.023162,0.492439>
 <20.338900,-61.186600,-31.073999>, <0.840420,0.110666,0.530515>
}
   smooth_triangle{ <20.696199,-60.931099,-31.693399>, <-0.826699,-0.155081,-0.540849>
 <20.746799,-61.070499,-31.717501>, <-0.774049,-0.286461,-0.564613>
 <20.386801,-61.327702,-31.093500>, <-0.793436,-0.243154,-0.557975>
}
   smooth_triangle{ <20.696199,-60.931099,-31.693399>, <0.826699,0.155081,0.540849>
 <20.386801,-61.327702,-31.093500>, <0.793436,0.243154,0.557975>
 <20.746799,-61.070499,-31.717501>, <0.774049,0.286461,0.564613>
}
   smooth_triangle{ <20.696199,-60.931099,-31.693399>, <-0.826699,-0.155081,-0.540849>
 <20.386801,-61.327702,-31.093500>, <-0.793436,-0.243154,-0.557975>
 <20.338900,-61.186600,-31.073999>, <-0.840420,-0.110666,-0.530515>
}
   smooth_triangle{ <20.696199,-60.931099,-31.693399>, <0.826699,0.155081,0.540849>
 <20.338900,-61.186600,-31.073999>, <0.840420,0.110666,0.530515>
 <20.386801,-61.327702,-31.093500>, <0.793436,0.243154,0.557975>
}
   smooth_triangle{ <20.746799,-61.070499,-31.717501>, <-0.774049,-0.286461,-0.564613>
 <20.814699,-61.204800,-31.729700>, <-0.704578,-0.413418,-0.576763>
 <20.452101,-61.463699,-31.101200>, <-0.729588,-0.371697,-0.574059>
}
   smooth_triangle{ <20.746799,-61.070499,-31.717501>, <0.774049,0.286461,0.564613>
 <20.452101,-61.463699,-31.101200>, <0.729588,0.371697,0.574059>
 <20.814699,-61.204800,-31.729700>, <0.704578,0.413418,0.576763>
}
   smooth_triangle{ <20.746799,-61.070499,-31.717501>, <-0.774049,-0.286461,-0.564613>
 <20.452101,-61.463699,-31.101200>, <-0.729588,-0.371697,-0.574059>
 <20.386801,-61.327702,-31.093500>, <-0.793436,-0.243154,-0.557975>
}
   smooth_triangle{ <20.746799,-61.070499,-31.717501>, <0.774049,0.286461,0.564613>
 <20.386801,-61.327702,-31.093500>, <0.793436,0.243154,0.557975>
 <20.452101,-61.463699,-31.101200>, <0.729588,0.371697,0.574059>
}
   smooth_triangle{ <20.814699,-61.204800,-31.729700>, <-0.704578,-0.413418,-0.576763>
 <20.899500,-61.331799,-31.729401>, <-0.619125,-0.533139,-0.576583>
 <20.534401,-61.592201,-31.096701>, <-0.649139,-0.494396,-0.578092>
}
   smooth_triangle{ <20.814699,-61.204800,-31.729700>, <0.704578,0.413418,0.576763>
 <20.534401,-61.592201,-31.096701>, <0.649139,0.494396,0.578092>
 <20.899500,-61.331799,-31.729401>, <0.619125,0.533139,0.576583>
}
   smooth_triangle{ <20.814699,-61.204800,-31.729700>, <-0.704578,-0.413418,-0.576763>
 <20.534401,-61.592201,-31.096701>, <-0.649139,-0.494396,-0.578092>
 <20.452101,-61.463699,-31.101200>, <-0.729588,-0.371697,-0.574059>
}
   smooth_triangle{ <20.814699,-61.204800,-31.729700>, <0.704578,0.413418,0.576763>
 <20.452101,-61.463699,-31.101200>, <0.729588,0.371697,0.574059>
 <20.534401,-61.592201,-31.096701>, <0.649139,0.494396,0.578092>
}
   smooth_triangle{ <20.899500,-61.331799,-31.729401>, <-0.619125,-0.533139,-0.576583>
 <21.000299,-61.449100,-31.716101>, <-0.518448,-0.643207,-0.563468>
 <20.632999,-61.710899,-31.079399>, <-0.553468,-0.607883,-0.569342>
}
   smooth_triangle{ <20.899500,-61.331799,-31.729401>, <0.619125,0.533139,0.576583>
 <20.632999,-61.710899,-31.079399>, <0.553468,0.607883,0.569342>
 <21.000299,-61.449100,-31.716101>, <0.518448,0.643207,0.563468>
}
   smooth_triangle{ <20.899500,-61.331799,-31.729401>, <-0.619125,-0.533139,-0.576583>
 <20.632999,-61.710899,-31.079399>, <-0.553468,-0.607883,-0.569342>
 <20.534401,-61.592201,-31.096701>, <-0.649139,-0.494396,-0.578092>
}
   smooth_triangle{ <20.899500,-61.331799,-31.729401>, <0.619125,0.533139,0.576583>
 <20.534401,-61.592201,-31.096701>, <0.649139,0.494396,0.578092>
 <20.632999,-61.710899,-31.079399>, <0.553468,0.607883,0.569342>
}
   smooth_triangle{ <21.000299,-61.449100,-31.716101>, <-0.518448,-0.643207,-0.563468>
 <21.116699,-61.554199,-31.689100>, <-0.384873,-0.754352,-0.531814>
 <20.747400,-61.817200,-31.048901>, <-0.434059,-0.717239,-0.545124>
}
   smooth_triangle{ <21.000299,-61.449100,-31.716101>, <0.518448,0.643207,0.563468>
 <20.747400,-61.817200,-31.048901>, <0.434059,0.717239,0.545124>
 <21.116699,-61.554199,-31.689100>, <0.384873,0.754352,0.531814>
}
   smooth_triangle{ <21.000299,-61.449100,-31.716101>, <-0.518448,-0.643207,-0.563468>
 <20.747400,-61.817200,-31.048901>, <-0.434059,-0.717239,-0.545124>
 <20.632999,-61.710899,-31.079399>, <-0.553468,-0.607883,-0.569342>
}
   smooth_triangle{ <21.000299,-61.449100,-31.716101>, <0.518448,0.643207,0.563468>
 <20.632999,-61.710899,-31.079399>, <0.553468,0.607883,0.569342>
 <20.747400,-61.817200,-31.048901>, <0.434059,0.717239,0.545124>
}
   smooth_triangle{ <21.116699,-61.554199,-31.689100>, <-0.384873,-0.754352,-0.531814>
 <21.312500,-61.679798,-31.624100>, <-0.206215,-0.857726,-0.470936>
 <20.940800,-61.944302,-30.979700>, <-0.270871,-0.825489,-0.495173>
}
   smooth_triangle{ <21.116699,-61.554199,-31.689100>, <0.384873,0.754352,0.531814>
 <20.940800,-61.944302,-30.979700>, <0.270871,0.825489,0.495173>
 <21.312500,-61.679798,-31.624100>, <0.206215,0.857726,0.470936>
}
   smooth_triangle{ <21.116699,-61.554199,-31.689100>, <-0.384873,-0.754352,-0.531814>
 <20.940800,-61.944302,-30.979700>, <-0.270871,-0.825489,-0.495173>
 <20.747400,-61.817200,-31.048901>, <-0.434059,-0.717239,-0.545124>
}
   smooth_triangle{ <21.116699,-61.554199,-31.689100>, <0.384873,0.754352,0.531814>
 <20.747400,-61.817200,-31.048901>, <0.434059,0.717239,0.545124>
 <20.940800,-61.944302,-30.979700>, <0.270871,0.825489,0.495173>
}
   smooth_triangle{ <21.312500,-61.679798,-31.624100>, <-0.206215,-0.857726,-0.470936>
 <21.515499,-61.756199,-31.536200>, <-0.009819,-0.923127,-0.384371>
 <21.142300,-62.021599,-30.889200>, <-0.075492,-0.906474,-0.415460>
}
   smooth_triangle{ <21.312500,-61.679798,-31.624100>, <0.206215,0.857726,0.470936>
 <21.142300,-62.021599,-30.889200>, <0.075492,0.906474,0.415460>
 <21.515499,-61.756199,-31.536200>, <0.009819,0.923127,0.384371>
}
   smooth_triangle{ <21.312500,-61.679798,-31.624100>, <-0.206215,-0.857726,-0.470936>
 <21.142300,-62.021599,-30.889200>, <-0.075492,-0.906474,-0.415460>
 <20.940800,-61.944302,-30.979700>, <-0.270871,-0.825489,-0.495173>
}
   smooth_triangle{ <21.312500,-61.679798,-31.624100>, <0.206215,0.857726,0.470936>
 <20.940800,-61.944302,-30.979700>, <0.270871,0.825489,0.495173>
 <21.142300,-62.021599,-30.889200>, <0.075492,0.906474,0.415460>
}
   smooth_triangle{ <21.515499,-61.756199,-31.536200>, <-0.009819,-0.923127,-0.384371>
 <21.718100,-61.784000,-31.430000>, <0.183142,-0.942111,-0.280868>
 <21.344200,-62.049900,-30.782000>, <0.119606,-0.940849,-0.317014>
}
   smooth_triangle{ <21.515499,-61.756199,-31.536200>, <0.009819,0.923127,0.384371>
 <21.344200,-62.049900,-30.782000>, <-0.119606,0.940849,0.317014>
 <21.718100,-61.784000,-31.430000>, <-0.183142,0.942111,0.280868>
}
   smooth_triangle{ <21.515499,-61.756199,-31.536200>, <-0.009819,-0.923127,-0.384371>
 <21.344200,-62.049900,-30.782000>, <0.119606,-0.940849,-0.317014>
 <21.142300,-62.021599,-30.889200>, <-0.075492,-0.906474,-0.415460>
}
   smooth_triangle{ <21.515499,-61.756199,-31.536200>, <0.009819,0.923127,0.384371>
 <21.142300,-62.021599,-30.889200>, <0.075492,0.906474,0.415460>
 <21.344200,-62.049900,-30.782000>, <-0.119606,0.940849,0.317014>
}
   smooth_triangle{ <21.718100,-61.784000,-31.430000>, <0.183142,-0.942111,-0.280868>
 <21.912600,-61.764301,-31.310101>, <0.365824,-0.915993,-0.164711>
 <21.539200,-62.029800,-30.662800>, <0.306211,-0.929689,-0.204727>
}
   smooth_triangle{ <21.718100,-61.784000,-31.430000>, <-0.183142,0.942111,0.280868>
 <21.539200,-62.029800,-30.662800>, <-0.306211,0.929689,0.204727>
 <21.912600,-61.764301,-31.310101>, <-0.365824,0.915993,0.164711>
}
   smooth_triangle{ <21.718100,-61.784000,-31.430000>, <0.183142,-0.942111,-0.280868>
 <21.539200,-62.029800,-30.662800>, <0.306211,-0.929689,-0.204727>
 <21.344200,-62.049900,-30.782000>, <0.119606,-0.940849,-0.317014>
}
   smooth_triangle{ <21.718100,-61.784000,-31.430000>, <-0.183142,0.942111,0.280868>
 <21.344200,-62.049900,-30.782000>, <-0.119606,0.940849,0.317014>
 <21.539200,-62.029800,-30.662800>, <-0.306211,0.929689,0.204727>
}
   smooth_triangle{ <21.912600,-61.764301,-31.310101>, <0.365824,-0.915993,-0.164711>
 <22.091700,-61.697601,-31.181299>, <0.533512,-0.844894,-0.038972>
 <21.719500,-61.962299,-30.536200>, <0.479405,-0.873765,-0.081892>
}
   smooth_triangle{ <21.912600,-61.764301,-31.310101>, <-0.365824,0.915993,0.164711>
 <21.719500,-61.962299,-30.536200>, <-0.479405,0.873765,0.081892>
 <22.091700,-61.697601,-31.181299>, <-0.533512,0.844894,0.038972>
}
   smooth_triangle{ <21.912600,-61.764301,-31.310101>, <0.365824,-0.915993,-0.164711>
 <21.719500,-61.962299,-30.536200>, <0.479405,-0.873765,-0.081892>
 <21.539200,-62.029800,-30.662800>, <0.306211,-0.929689,-0.204727>
}
   smooth_triangle{ <21.912600,-61.764301,-31.310101>, <-0.365824,0.915993,0.164711>
 <21.539200,-62.029800,-30.662800>, <-0.306211,0.929689,0.204727>
 <21.719500,-61.962299,-30.536200>, <-0.479405,0.873765,0.081892>
}
   smooth_triangle{ <22.091700,-61.697601,-31.181299>, <0.533512,-0.844894,-0.038972>
 <22.247499,-61.584702,-31.048100>, <0.677899,-0.729453,0.091390>
 <21.877501,-61.848099,-30.406799>, <0.632556,-0.773053,0.047555>
}
   smooth_triangle{ <22.091700,-61.697601,-31.181299>, <-0.533512,0.844894,0.038972>
 <21.877501,-61.848099,-30.406799>, <-0.632556,0.773053,-0.047555>
 <22.247499,-61.584702,-31.048100>, <-0.677899,0.729453,-0.091390>
}
   smooth_triangle{ <22.091700,-61.697601,-31.181299>, <0.533512,-0.844894,-0.038972>
 <21.877501,-61.848099,-30.406799>, <0.632556,-0.773053,0.047555>
 <21.719500,-61.962299,-30.536200>, <0.479405,-0.873765,-0.081892>
}
   smooth_triangle{ <22.091700,-61.697601,-31.181299>, <-0.533512,0.844894,0.038972>
 <21.719500,-61.962299,-30.536200>, <-0.479405,0.873765,0.081892>
 <21.877501,-61.848099,-30.406799>, <-0.632556,0.773053,-0.047555>
}
   smooth_triangle{ <22.247499,-61.584702,-31.048100>, <0.677899,-0.729453,0.091390>
 <22.372801,-61.426399,-30.915400>, <0.788636,-0.574717,0.218526>
 <22.005800,-61.688000,-30.279301>, <0.755662,-0.630666,0.176738>
}
   smooth_triangle{ <22.247499,-61.584702,-31.048100>, <-0.677899,0.729453,-0.091390>
 <22.005800,-61.688000,-30.279301>, <-0.718728,0.682198,-0.134295>
 <22.372801,-61.426399,-30.915400>, <-0.719040,0.681841,-0.134441>
}
   smooth_triangle{ <22.247499,-61.584702,-31.048100>, <0.677899,-0.729453,0.091390>
 <22.005800,-61.688000,-30.279301>, <0.755662,-0.630666,0.176738>
 <21.877501,-61.848099,-30.406799>, <0.632556,-0.773053,0.047555>
}
   smooth_triangle{ <22.247499,-61.584702,-31.048100>, <-0.677899,0.729453,-0.091390>
 <21.877501,-61.848099,-30.406799>, <-0.632556,0.773053,-0.047555>
 <22.005800,-61.688000,-30.279301>, <-0.718728,0.682198,-0.134295>
}
   smooth_triangle{ <22.372801,-61.426399,-30.915400>, <0.788636,-0.574717,0.218526>
 <22.455500,-61.234600,-30.794201>, <0.857992,-0.390036,0.334249>
 <22.092300,-61.493900,-30.164600>, <0.839581,-0.454747,0.297169>
}
   smooth_triangle{ <22.372801,-61.426399,-30.915400>, <0.788636,-0.574717,0.218526>
 <22.092300,-61.493900,-30.164600>, <0.839581,-0.454747,0.297169>
 <22.005800,-61.688000,-30.279301>, <0.755662,-0.630666,0.176738>
}
   smooth_triangle{ <22.455500,-61.234600,-30.794201>, <0.857992,-0.390036,0.334249>
 <22.490601,-61.026001,-30.694201>, <0.882314,-0.189148,0.430981>
 <22.131399,-61.282799,-30.071501>, <0.879150,-0.257393,0.401053>
}
   smooth_triangle{ <22.455500,-61.234600,-30.794201>, <0.857992,-0.390036,0.334249>
 <22.131399,-61.282799,-30.071501>, <0.879150,-0.257393,0.401053>
 <22.092300,-61.493900,-30.164600>, <0.839581,-0.454747,0.297169>
}
   smooth_triangle{ <22.490601,-61.026001,-30.694201>, <0.882314,-0.189148,0.430981>
 <22.480200,-60.809101,-30.617201>, <0.862992,0.016982,0.504932>
 <22.125099,-61.063301,-30.001801>, <0.874144,-0.052073,0.482867>
}
   smooth_triangle{ <22.490601,-61.026001,-30.694201>, <0.882314,-0.189148,0.430981>
 <22.125099,-61.063301,-30.001801>, <0.874144,-0.052073,0.482867>
 <22.131399,-61.282799,-30.071501>, <0.879150,-0.257393,0.401053>
}
   smooth_triangle{ <22.480200,-60.809101,-30.617201>, <0.862992,0.016982,0.504932>
 <22.426201,-60.592300,-30.565399>, <0.802244,0.221499,0.554385>
 <22.075399,-60.843899,-29.957199>, <0.827045,0.153779,0.540693>
}
   smooth_triangle{ <22.480200,-60.809101,-30.617201>, <0.862992,0.016982,0.504932>
 <22.075399,-60.843899,-29.957199>, <0.827045,0.153779,0.540693>
 <22.125099,-61.063301,-30.001801>, <0.874144,-0.052073,0.482867>
}
   smooth_triangle{ <22.426201,-60.592300,-30.565399>, <0.802244,0.221499,0.554385>
 <22.330799,-60.383999,-30.540800>, <0.701699,0.417133,0.577597>
 <21.983999,-60.632999,-29.939501>, <0.739578,0.353365,0.572850>
}
   smooth_triangle{ <22.426201,-60.592300,-30.565399>, <0.802244,0.221499,0.554385>
 <21.983999,-60.632999,-29.939501>, <0.739578,0.353365,0.572850>
 <22.075399,-60.843899,-29.957199>, <0.827045,0.153779,0.540693>
}
   smooth_triangle{ <22.330799,-60.383999,-30.540800>, <0.701699,0.417133,0.577597>
 <22.196199,-60.192600,-30.545300>, <0.563174,0.596091,0.572285>
 <21.853001,-60.439400,-29.950399>, <0.613448,0.538887,0.577306>
}
   smooth_triangle{ <22.330799,-60.383999,-30.540800>, <0.701699,0.417133,0.577597>
 <21.853001,-60.439400,-29.950399>, <0.613448,0.538887,0.577306>
 <21.983999,-60.632999,-29.939501>, <0.739578,0.353365,0.572850>
}
   smooth_triangle{ <22.196199,-60.192600,-30.545300>, <0.563174,0.596091,0.572285>
 <22.024300,-60.026699,-30.580999>, <0.414645,0.730460,0.542676>
 <21.684401,-60.271400,-29.991800>, <0.463015,0.691668,0.554268>
}
   smooth_triangle{ <22.196199,-60.192600,-30.545300>, <0.563174,0.596091,0.572285>
 <21.684401,-60.271400,-29.991800>, <0.463015,0.691668,0.554268>
 <21.853001,-60.439400,-29.950399>, <0.613448,0.538887,0.577306>
}
   smooth_triangle{ <22.024300,-60.026699,-30.580999>, <0.414645,0.730460,0.542676>
 <21.897600,-59.938999,-30.620600>, <0.281944,0.817341,0.502456>
 <21.559299,-60.182701,-30.034300>, <0.323592,0.792973,0.516219>
}
   smooth_triangle{ <22.024300,-60.026699,-30.580999>, <0.414645,0.730460,0.542676>
 <21.559299,-60.182701,-30.034300>, <0.323592,0.792973,0.516219>
 <21.684401,-60.271400,-29.991800>, <0.463015,0.691668,0.554268>
}
   smooth_triangle{ <21.897600,-59.938999,-30.620600>, <0.281944,0.817341,0.502456>
 <21.766600,-59.872501,-30.670799>, <0.154591,0.877419,0.454134>
 <21.429701,-60.115398,-30.086700>, <0.197106,0.859736,0.471173>
}
   smooth_triangle{ <21.897600,-59.938999,-30.620600>, <0.281944,0.817341,0.502456>
 <21.429701,-60.115398,-30.086700>, <0.197106,0.859736,0.471173>
 <21.559299,-60.182701,-30.034300>, <0.323592,0.792973,0.516219>
}
   smooth_triangle{ <21.766600,-59.872501,-30.670799>, <0.154591,0.877419,0.454134>
 <21.633600,-59.826900,-30.730000>, <0.026430,0.917431,0.397016>
 <21.297501,-60.069302,-30.147499>, <0.069080,0.906315,0.416918>
}
   smooth_triangle{ <21.766600,-59.872501,-30.670799>, <0.154591,0.877419,0.454134>
 <21.297501,-60.069302,-30.147499>, <0.069080,0.906315,0.416918>
 <21.429701,-60.115398,-30.086700>, <0.197106,0.859736,0.471173>
}
   smooth_triangle{ <21.633600,-59.826900,-30.730000>, <0.026430,0.917431,0.397016>
 <21.500601,-59.801998,-30.797199>, <-0.100589,0.937827,0.332208>
 <21.165100,-60.043999,-30.215599>, <-0.058539,0.933205,0.354546>
}
   smooth_triangle{ <21.633600,-59.826900,-30.730000>, <0.026430,0.917431,0.397016>
 <21.165100,-60.043999,-30.215599>, <-0.058539,0.933205,0.354546>
 <21.297501,-60.069302,-30.147499>, <0.069080,0.906315,0.416918>
}
   smooth_triangle{ <21.500601,-59.801998,-30.797199>, <-0.100589,0.937827,0.332208>
 <21.369900,-59.797501,-30.871000>, <-0.224654,0.938814,0.261072>
 <21.034300,-60.039501,-30.289499>, <-0.183676,0.940630,0.285444>
}
   smooth_triangle{ <21.500601,-59.801998,-30.797199>, <-0.100589,0.937827,0.332208>
 <21.034300,-60.039501,-30.289499>, <-0.183676,0.940630,0.285444>
 <21.165100,-60.043999,-30.215599>, <-0.058539,0.933205,0.354546>
}
   smooth_triangle{ <21.369900,-59.797501,-30.871000>, <-0.224654,0.938814,0.261072>
 <21.243299,-59.813400,-30.950100>, <-0.343446,0.920771,0.185003>
 <20.907600,-60.055599,-30.368099>, <-0.304476,0.928877,0.210905>
}
   smooth_triangle{ <21.369900,-59.797501,-30.871000>, <-0.224654,0.938814,0.261072>
 <20.907600,-60.055599,-30.368099>, <-0.304476,0.928877,0.210905>
 <21.034300,-60.039501,-30.289499>, <-0.183676,0.940630,0.285444>
}
   smooth_triangle{ <21.243299,-59.813400,-30.950100>, <-0.343446,0.920771,0.185003>
 <21.123199,-59.849300,-31.033199>, <0.418012,0.727183,0.544492>
 <20.786699,-60.091900,-30.450001>, <-0.027488,0.928446,0.370448>
}
   smooth_triangle{ <21.243299,-59.813400,-30.950100>, <-0.343446,0.920771,0.185003>
 <20.786699,-60.091900,-30.450001>, <-0.027488,0.928446,0.370448>
 <20.907600,-60.055599,-30.368099>, <-0.304476,0.928877,0.210905>
}
   smooth_triangle{ <21.123199,-59.849300,-31.033199>, <0.418012,0.727183,0.544492>
 <20.222300,-58.410198,-31.002600>, <0.874477,-0.304185,0.377837>
 <19.913700,-58.635502,-30.467501>, <0.844624,0.095864,0.526707>
}
   smooth_triangle{ <21.123199,-59.849300,-31.033199>, <0.418012,0.727183,0.544492>
 <19.913700,-58.635502,-30.467501>, <0.844624,0.095864,0.526707>
 <20.786699,-60.091900,-30.450001>, <-0.027488,0.928446,0.370448>
}
   smooth_triangle{ <20.222300,-58.410198,-31.002600>, <-0.774226,0.602110,-0.195030>
 <19.163000,-60.193199,-32.295799>, <-0.237875,0.938195,0.251409>
 <18.820000,-60.439701,-31.701401>, <-0.571364,0.820606,0.012193>
}
   smooth_triangle{ <20.222300,-58.410198,-31.002600>, <0.874477,-0.304185,0.377837>
 <18.820000,-60.439701,-31.701401>, <0.571364,-0.820606,-0.012193>
 <19.163000,-60.193199,-32.295799>, <0.237875,-0.938195,-0.251409>
}
   smooth_triangle{ <20.222300,-58.410198,-31.002600>, <-0.774226,0.602110,-0.195030>
 <18.820000,-60.439701,-31.701401>, <-0.571364,0.820606,0.012193>
 <19.913700,-58.635502,-30.467501>, <-0.774781,0.601927,-0.193386>
}
   smooth_triangle{ <20.222300,-58.410198,-31.002600>, <0.874477,-0.304185,0.377837>
 <19.913700,-58.635502,-30.467501>, <0.844624,0.095864,0.526707>
 <18.820000,-60.439701,-31.701401>, <0.571364,-0.820606,-0.012193>
}
   smooth_triangle{ <19.163000,-60.193199,-32.295799>, <0.237875,-0.938195,-0.251409>
 <20.649401,-60.646500,-31.611601>, <-0.758538,-0.317559,-0.569013>
 <20.297600,-60.898701,-31.001801>, <-0.429826,-0.719229,-0.545857>
}
   smooth_triangle{ <19.163000,-60.193199,-32.295799>, <-0.237875,0.938195,0.251409>
 <20.297600,-60.898701,-31.001801>, <0.429826,0.719229,0.545857>
 <20.649401,-60.646500,-31.611601>, <0.758538,0.317559,0.569013>
}
   smooth_triangle{ <19.163000,-60.193199,-32.295799>, <0.237875,-0.938195,-0.251409>
 <20.297600,-60.898701,-31.001801>, <-0.429826,-0.719229,-0.545857>
 <18.820000,-60.439701,-31.701401>, <0.571364,-0.820606,-0.012193>
}
   smooth_triangle{ <19.163000,-60.193199,-32.295799>, <-0.237875,0.938195,0.251409>
 <18.820000,-60.439701,-31.701401>, <-0.571364,0.820606,0.012193>
 <20.297600,-60.898701,-31.001801>, <0.429826,0.719229,0.545857>
}
   smooth_triangle{ <20.689400,-60.373299,-31.483999>, <-0.235908,0.938292,0.252894>
 <19.615000,-60.058498,-31.983500>, <0.071396,0.905926,0.417373>
 <19.274700,-60.303501,-31.393499>, <0.071380,0.906102,0.416994>
}
   smooth_triangle{ <20.689400,-60.373299,-31.483999>, <-0.235908,0.938292,0.252894>
 <19.274700,-60.303501,-31.393499>, <0.071380,0.906102,0.416994>
 <20.342800,-60.622101,-30.883400>, <-0.553938,0.832170,0.025416>
}
   smooth_triangle{ <19.615000,-60.058498,-31.983500>, <0.769929,-0.609208,0.189934>
 <20.270300,-58.983299,-31.194599>, <0.843381,0.100331,0.527866>
 <19.951000,-59.215302,-30.641001>, <0.873975,-0.307953,0.375942>
}
   smooth_triangle{ <19.615000,-60.058498,-31.983500>, <0.769929,-0.609208,0.189934>
 <19.951000,-59.215302,-30.641001>, <0.873975,-0.307953,0.375942>
 <19.274700,-60.303501,-31.393499>, <0.769302,-0.609829,0.190481>
}
   smooth_triangle{ <20.270300,-58.983299,-31.194599>, <-0.691198,-0.432354,-0.579064>
 <20.926100,-60.012299,-31.209900>, <-0.870923,0.326889,-0.366930>
 <20.587000,-60.256500,-30.622000>, <-0.845078,-0.092658,-0.526553>
}
   smooth_triangle{ <20.270300,-58.983299,-31.194599>, <0.843381,0.100331,0.527866>
 <20.587000,-60.256500,-30.622000>, <0.845078,0.092658,0.526553>
 <20.926100,-60.012299,-31.209900>, <0.870923,-0.326889,0.366930>
}
   smooth_triangle{ <20.270300,-58.983299,-31.194599>, <-0.691198,-0.432354,-0.579064>
 <20.587000,-60.256500,-30.622000>, <-0.845078,-0.092658,-0.526553>
 <19.951000,-59.215302,-30.641001>, <-0.690677,-0.432467,-0.579601>
}
   smooth_triangle{ <20.270300,-58.983299,-31.194599>, <0.843381,0.100331,0.527866>
 <19.951000,-59.215302,-30.641001>, <0.873975,-0.307953,0.375942>
 <20.587000,-60.256500,-30.622000>, <0.845078,0.092658,0.526553>
}
   smooth_triangle{ <20.926100,-60.012299,-31.209900>, <-0.870923,0.326889,-0.366930>
 <20.689400,-60.373299,-31.483999>, <-0.235908,0.938292,0.252894>
 <20.342800,-60.622101,-30.883400>, <-0.553938,0.832170,0.025416>
}
   smooth_triangle{ <20.926100,-60.012299,-31.209900>, <0.870923,-0.326889,0.366930>
 <20.342800,-60.622101,-30.883400>, <0.756630,-0.629925,0.175229>
 <20.689400,-60.373299,-31.483999>, <0.756703,-0.629667,0.175842>
}
   smooth_triangle{ <20.926100,-60.012299,-31.209900>, <-0.870923,0.326889,-0.366930>
 <20.342800,-60.622101,-30.883400>, <-0.553938,0.832170,0.025416>
 <20.587000,-60.256500,-30.622000>, <-0.845078,-0.092658,-0.526553>
}
   smooth_triangle{ <20.926100,-60.012299,-31.209900>, <0.870923,-0.326889,0.366930>
 <20.587000,-60.256500,-30.622000>, <0.845078,0.092658,0.526553>
 <20.342800,-60.622101,-30.883400>, <0.756630,-0.629925,0.175229>
}
   smooth_triangle{ <21.114100,-60.267601,-31.198400>, <0.617435,-0.786041,0.030229>
 <21.221500,-60.195702,-31.108900>, <0.465700,-0.879690,-0.096279>
 <20.878401,-60.442402,-30.514099>, <0.516686,-0.854325,-0.056251>
}
   smooth_triangle{ <21.114100,-60.267601,-31.198400>, <-0.617435,0.786041,-0.030229>
 <20.878401,-60.442402,-30.514099>, <-0.516686,0.854325,0.056251>
 <21.221500,-60.195702,-31.108900>, <-0.465700,0.879690,0.096279>
}
   smooth_triangle{ <21.114100,-60.267601,-31.198400>, <0.617435,-0.786041,0.030229>
 <20.878401,-60.442402,-30.514099>, <0.516686,-0.854325,-0.056251>
 <20.769600,-60.515202,-30.601200>, <0.665849,-0.742158,0.076465>
}
   smooth_triangle{ <21.114100,-60.267601,-31.198400>, <-0.617435,0.786041,-0.030229>
 <20.769600,-60.515202,-30.601200>, <-0.665849,0.742158,-0.076465>
 <20.878401,-60.442402,-30.514099>, <-0.516686,0.854325,0.056251>
}
   smooth_triangle{ <21.221500,-60.195702,-31.108900>, <0.465700,-0.879690,-0.096279>
 <21.347099,-60.151600,-31.019600>, <0.309552,-0.928173,-0.206573>
 <21.004801,-60.397800,-30.426300>, <0.361817,-0.916346,-0.171460>
}
   smooth_triangle{ <21.221500,-60.195702,-31.108900>, <-0.465700,0.879690,0.096279>
 <21.004801,-60.397800,-30.426300>, <-0.361817,0.916346,0.171460>
 <21.347099,-60.151600,-31.019600>, <-0.309552,0.928173,0.206573>
}
   smooth_triangle{ <21.221500,-60.195702,-31.108900>, <0.465700,-0.879690,-0.096279>
 <21.004801,-60.397800,-30.426300>, <0.361817,-0.916346,-0.171460>
 <20.878401,-60.442402,-30.514099>, <0.516686,-0.854325,-0.056251>
}
   smooth_triangle{ <21.221500,-60.195702,-31.108900>, <-0.465700,0.879690,0.096279>
 <20.878401,-60.442402,-30.514099>, <-0.516686,0.854325,0.056251>
 <21.004801,-60.397800,-30.426300>, <-0.361817,0.916346,0.171460>
}
   smooth_triangle{ <21.347099,-60.151600,-31.019600>, <0.309552,-0.928173,-0.206573>
 <21.483200,-60.136101,-30.935101>, <0.144947,-0.940693,-0.306737>
 <21.141199,-60.382099,-30.342300>, <0.201050,-0.940407,-0.274253>
}
   smooth_triangle{ <21.347099,-60.151600,-31.019600>, <-0.309552,0.928173,0.206573>
 <21.141199,-60.382099,-30.342300>, <-0.201050,0.940407,0.274253>
 <21.483200,-60.136101,-30.935101>, <-0.144947,0.940693,0.306737>
}
   smooth_triangle{ <21.347099,-60.151600,-31.019600>, <0.309552,-0.928173,-0.206573>
 <21.141199,-60.382099,-30.342300>, <0.201050,-0.940407,-0.274253>
 <21.004801,-60.397800,-30.426300>, <0.361817,-0.916346,-0.171460>
}
   smooth_triangle{ <21.347099,-60.151600,-31.019600>, <-0.309552,0.928173,0.206573>
 <21.004801,-60.397800,-30.426300>, <-0.361817,0.916346,0.171460>
 <21.141199,-60.382099,-30.342300>, <-0.201050,0.940407,0.274253>
}
   smooth_triangle{ <21.483200,-60.136101,-30.935101>, <0.144947,-0.940693,-0.306737>
 <21.622400,-60.150002,-30.860100>, <-0.036727,-0.915366,-0.400943>
 <21.280100,-60.396198,-30.266800>, <0.026264,-0.928588,-0.370181>
}
   smooth_triangle{ <21.483200,-60.136101,-30.935101>, <-0.144947,0.940693,0.306737>
 <21.280100,-60.396198,-30.266800>, <-0.026264,0.928588,0.370181>
 <21.622400,-60.150002,-30.860100>, <0.036727,0.915366,0.400943>
}
   smooth_triangle{ <21.483200,-60.136101,-30.935101>, <0.144947,-0.940693,-0.306737>
 <21.280100,-60.396198,-30.266800>, <0.026264,-0.928588,-0.370181>
 <21.141199,-60.382099,-30.342300>, <0.201050,-0.940407,-0.274253>
}
   smooth_triangle{ <21.483200,-60.136101,-30.935101>, <-0.144947,0.940693,0.306737>
 <21.141199,-60.382099,-30.342300>, <-0.201050,0.940407,0.274253>
 <21.280100,-60.396198,-30.266800>, <-0.026264,0.928588,0.370181>
}
   smooth_triangle{ <21.622400,-60.150002,-30.860100>, <-0.036727,-0.915366,-0.400943>
 <21.757200,-60.194099,-30.799200>, <-0.242999,-0.838455,-0.487795>
 <21.414101,-60.440800,-30.204300>, <-0.171182,-0.871210,-0.460098>
}
   smooth_triangle{ <21.622400,-60.150002,-30.860100>, <0.036727,0.915366,0.400943>
 <21.414101,-60.440800,-30.204300>, <0.171182,0.871210,0.460098>
 <21.757200,-60.194099,-30.799200>, <0.242999,0.838455,0.487795>
}
   smooth_triangle{ <21.622400,-60.150002,-30.860100>, <-0.036727,-0.915366,-0.400943>
 <21.414101,-60.440800,-30.204300>, <-0.171182,-0.871210,-0.460098>
 <21.280100,-60.396198,-30.266800>, <0.026264,-0.928588,-0.370181>
}
   smooth_triangle{ <21.622400,-60.150002,-30.860100>, <0.036727,0.915366,0.400943>
 <21.280100,-60.396198,-30.266800>, <-0.026264,0.928588,0.370181>
 <21.414101,-60.440800,-30.204300>, <0.171182,0.871210,0.460098>
}
   smooth_triangle{ <21.757200,-60.194099,-30.799200>, <-0.242999,-0.838455,-0.487795>
 <21.880199,-60.269199,-30.756901>, <-0.447285,-0.705117,-0.550223>
 <21.535601,-60.516800,-30.159500>, <-0.380797,-0.755655,-0.532898>
}
   smooth_triangle{ <21.757200,-60.194099,-30.799200>, <0.242999,0.838455,0.487795>
 <21.535601,-60.516800,-30.159500>, <0.380797,0.755655,0.532898>
 <21.880199,-60.269199,-30.756901>, <0.447285,0.705117,0.550223>
}
   smooth_triangle{ <21.757200,-60.194099,-30.799200>, <-0.242999,-0.838455,-0.487795>
 <21.535601,-60.516800,-30.159500>, <-0.380797,-0.755655,-0.532898>
 <21.414101,-60.440800,-30.204300>, <-0.171182,-0.871210,-0.460098>
}
   smooth_triangle{ <21.757200,-60.194099,-30.799200>, <0.242999,0.838455,0.487795>
 <21.414101,-60.440800,-30.204300>, <0.171182,0.871210,0.460098>
 <21.535601,-60.516800,-30.159500>, <0.380797,0.755655,0.532898>
}
   smooth_triangle{ <21.880199,-60.269199,-30.756901>, <-0.447285,-0.705117,-0.550223>
 <21.997499,-60.382401,-30.732500>, <-0.613679,-0.538747,-0.577191>
 <21.650700,-60.631401,-30.131399>, <-0.563194,-0.596353,-0.571993>
}
   smooth_triangle{ <21.880199,-60.269199,-30.756901>, <0.447285,0.705117,0.550223>
 <21.650700,-60.631401,-30.131399>, <0.563194,0.596353,0.571993>
 <21.997499,-60.382401,-30.732500>, <0.613679,0.538747,0.577191>
}
   smooth_triangle{ <21.880199,-60.269199,-30.756901>, <-0.447285,-0.705117,-0.550223>
 <21.650700,-60.631401,-30.131399>, <-0.563194,-0.596353,-0.571993>
 <21.535601,-60.516800,-30.159500>, <-0.380797,-0.755655,-0.532898>
}
   smooth_triangle{ <21.880199,-60.269199,-30.756901>, <0.447285,0.705117,0.550223>
 <21.535601,-60.516800,-30.159500>, <0.380797,0.755655,0.532898>
 <21.650700,-60.631401,-30.131399>, <0.563194,0.596353,0.571993>
}
   smooth_triangle{ <21.997499,-60.382401,-30.732500>, <-0.613679,-0.538747,-0.577191>
 <22.089399,-60.512901,-30.729500>, <-0.739699,-0.353016,-0.572909>
 <21.740000,-60.763500,-30.124001>, <-0.701700,-0.417140,-0.577591>
}
   smooth_triangle{ <21.997499,-60.382401,-30.732500>, <0.613679,0.538747,0.577191>
 <21.740000,-60.763500,-30.124001>, <0.701700,0.417140,0.577591>
 <22.089399,-60.512901,-30.729500>, <0.739699,0.353016,0.572909>
}
   smooth_triangle{ <21.997499,-60.382401,-30.732500>, <-0.613679,-0.538747,-0.577191>
 <21.740000,-60.763500,-30.124001>, <-0.701700,-0.417140,-0.577591>
 <21.650700,-60.631401,-30.131399>, <-0.563194,-0.596353,-0.571993>
}
   smooth_triangle{ <21.997499,-60.382401,-30.732500>, <0.613679,0.538747,0.577191>
 <21.650700,-60.631401,-30.131399>, <0.563194,0.596353,0.571993>
 <21.740000,-60.763500,-30.124001>, <0.701700,0.417140,0.577591>
}
   smooth_triangle{ <22.089399,-60.512901,-30.729500>, <-0.739699,-0.353016,-0.572909>
 <22.154499,-60.655102,-30.746300>, <-0.827037,-0.153648,-0.540743>
 <21.802299,-60.907398,-30.136000>, <-0.802178,-0.221436,-0.554505>
}
   smooth_triangle{ <22.089399,-60.512901,-30.729500>, <0.739699,0.353016,0.572909>
 <21.802299,-60.907398,-30.136000>, <0.802178,0.221436,0.554505>
 <22.154499,-60.655102,-30.746300>, <0.827037,0.153648,0.540743>
}
   smooth_triangle{ <22.089399,-60.512901,-30.729500>, <-0.739699,-0.353016,-0.572909>
 <21.802299,-60.907398,-30.136000>, <-0.802178,-0.221436,-0.554505>
 <21.740000,-60.763500,-30.124001>, <-0.701700,-0.417140,-0.577591>
}
   smooth_triangle{ <22.089399,-60.512901,-30.729500>, <0.739699,0.353016,0.572909>
 <21.740000,-60.763500,-30.124001>, <0.701700,0.417140,0.577591>
 <21.802299,-60.907398,-30.136000>, <0.802178,0.221436,0.554505>
}
   smooth_triangle{ <22.154499,-60.655102,-30.746300>, <-0.827037,-0.153648,-0.540743>
 <22.191299,-60.803101,-30.781700>, <-0.874105,0.051697,-0.482978>
 <21.836300,-61.057201,-30.166401>, <-0.862931,-0.017207,-0.505029>
}
   smooth_triangle{ <22.154499,-60.655102,-30.746300>, <0.827037,0.153648,0.540743>
 <21.836300,-61.057201,-30.166401>, <0.862931,0.017207,0.505029>
 <22.191299,-60.803101,-30.781700>, <0.874105,-0.051697,0.482978>
}
   smooth_triangle{ <22.154499,-60.655102,-30.746300>, <-0.827037,-0.153648,-0.540743>
 <21.836300,-61.057201,-30.166401>, <-0.862931,-0.017207,-0.505029>
 <21.802299,-60.907398,-30.136000>, <-0.802178,-0.221436,-0.554505>
}
   smooth_triangle{ <22.154499,-60.655102,-30.746300>, <0.827037,0.153648,0.540743>
 <21.802299,-60.907398,-30.136000>, <0.802178,0.221436,0.554505>
 <21.836300,-61.057201,-30.166401>, <0.862931,0.017207,0.505029>
}
   smooth_triangle{ <22.191299,-60.803101,-30.781700>, <-0.874105,0.051697,-0.482978>
 <22.198500,-60.951199,-30.834200>, <-0.879130,0.257469,-0.401049>
 <21.840700,-61.207001,-30.214001>, <-0.882310,0.189081,-0.431019>
}
   smooth_triangle{ <22.191299,-60.803101,-30.781700>, <0.874105,-0.051697,0.482978>
 <21.840700,-61.207001,-30.214001>, <0.882310,-0.189081,0.431019>
 <22.198500,-60.951199,-30.834200>, <0.879130,-0.257469,0.401049>
}
   smooth_triangle{ <22.191299,-60.803101,-30.781700>, <-0.874105,0.051697,-0.482978>
 <21.840700,-61.207001,-30.214001>, <-0.882310,0.189081,-0.431019>
 <21.836300,-61.057201,-30.166401>, <-0.862931,-0.017207,-0.505029>
}
   smooth_triangle{ <22.191299,-60.803101,-30.781700>, <0.874105,-0.051697,0.482978>
 <21.836300,-61.057201,-30.166401>, <0.862931,0.017207,0.505029>
 <21.840700,-61.207001,-30.214001>, <0.882310,-0.189081,0.431019>
}
   smooth_triangle{ <22.198500,-60.951199,-30.834200>, <-0.879130,0.257469,-0.401049>
 <22.174500,-61.093601,-30.902500>, <-0.839629,0.454671,-0.297149>
 <21.813900,-61.351101,-30.277500>, <-0.857880,0.390476,-0.334022>
}
   smooth_triangle{ <22.198500,-60.951199,-30.834200>, <0.879130,-0.257469,0.401049>
 <21.813900,-61.351101,-30.277500>, <0.857880,-0.390476,0.334022>
 <22.174500,-61.093601,-30.902500>, <0.839629,-0.454671,0.297149>
}
   smooth_triangle{ <22.198500,-60.951199,-30.834200>, <-0.879130,0.257469,-0.401049>
 <21.813900,-61.351101,-30.277500>, <-0.857880,0.390476,-0.334022>
 <21.840700,-61.207001,-30.214001>, <-0.882310,0.189081,-0.431019>
}
   smooth_triangle{ <22.198500,-60.951199,-30.834200>, <0.879130,-0.257469,0.401049>
 <21.840700,-61.207001,-30.214001>, <0.882310,-0.189081,0.431019>
 <21.813900,-61.351101,-30.277500>, <0.857880,-0.390476,0.334022>
}
   smooth_triangle{ <22.174500,-61.093601,-30.902500>, <-0.839629,0.454671,-0.297149>
 <22.118000,-61.224499,-30.985201>, <-0.755956,0.630329,-0.176679>
 <21.754900,-61.483601,-30.355801>, <-0.788622,0.574831,-0.218276>
}
   smooth_triangle{ <22.174500,-61.093601,-30.902500>, <0.839629,-0.454671,0.297149>
 <21.754900,-61.483601,-30.355801>, <0.816569,-0.516106,0.258553>
 <22.118000,-61.224499,-30.985201>, <0.816624,-0.515937,0.258716>
}
   smooth_triangle{ <22.174500,-61.093601,-30.902500>, <-0.839629,0.454671,-0.297149>
 <21.754900,-61.483601,-30.355801>, <-0.788622,0.574831,-0.218276>
 <21.813900,-61.351101,-30.277500>, <-0.857880,0.390476,-0.334022>
}
   smooth_triangle{ <22.174500,-61.093601,-30.902500>, <0.839629,-0.454671,0.297149>
 <21.813900,-61.351101,-30.277500>, <0.857880,-0.390476,0.334022>
 <21.754900,-61.483601,-30.355801>, <0.816569,-0.516106,0.258553>
}
   smooth_triangle{ <22.118000,-61.224499,-30.985201>, <-0.755956,0.630329,-0.176679>
 <22.032600,-61.332401,-31.075701>, <-0.632884,0.772805,-0.047231>
 <21.667400,-61.592899,-30.442900>, <-0.677892,0.729526,-0.090853>
}
   smooth_triangle{ <22.118000,-61.224499,-30.985201>, <-0.755956,0.630329,-0.176679>
 <21.667400,-61.592899,-30.442900>, <-0.677892,0.729526,-0.090853>
 <21.754900,-61.483601,-30.355801>, <-0.788622,0.574831,-0.218276>
}
   smooth_triangle{ <22.032600,-61.332401,-31.075701>, <-0.632884,0.772805,-0.047231>
 <21.926201,-61.409500,-31.166599>, <-0.479824,0.873501,0.082246>
 <21.559500,-61.670799,-30.531099>, <-0.533539,0.844847,0.039625>
}
   smooth_triangle{ <22.032600,-61.332401,-31.075701>, <-0.632884,0.772805,-0.047231>
 <21.559500,-61.670799,-30.531099>, <-0.533539,0.844847,0.039625>
 <21.667400,-61.592899,-30.442900>, <-0.677892,0.729526,-0.090853>
}
   smooth_triangle{ <21.926201,-61.409500,-31.166599>, <-0.479824,0.873501,0.082246>
 <21.804001,-61.455002,-31.254499>, <-0.306768,0.929454,0.204959>
 <21.436501,-61.716801,-30.617500>, <-0.366108,0.915791,0.165202>
}
   smooth_triangle{ <21.926201,-61.409500,-31.166599>, <-0.479824,0.873501,0.082246>
 <21.436501,-61.716801,-30.617500>, <-0.366108,0.915791,0.165202>
 <21.559500,-61.670799,-30.531099>, <-0.533539,0.844847,0.039625>
}
   smooth_triangle{ <21.804001,-61.455002,-31.254499>, <-0.306768,0.929454,0.204959>
 <21.671200,-61.468601,-31.336399>, <-0.119966,0.940688,0.317355>
 <21.303400,-61.730499,-30.698900>, <-0.183738,0.941949,0.281020>
}
   smooth_triangle{ <21.804001,-61.455002,-31.254499>, <-0.306768,0.929454,0.204959>
 <21.303400,-61.730499,-30.698900>, <-0.183738,0.941949,0.281020>
 <21.436501,-61.716801,-30.617500>, <-0.366108,0.915791,0.165202>
}
   smooth_triangle{ <21.671200,-61.468601,-31.336399>, <-0.119966,0.940688,0.317355>
 <21.532900,-61.449501,-31.408800>, <0.075074,0.906264,0.415992>
 <21.165600,-61.711300,-30.772100>, <0.009273,0.922976,0.384746>
}
   smooth_triangle{ <21.671200,-61.468601,-31.336399>, <-0.119966,0.940688,0.317355>
 <21.165600,-61.711300,-30.772100>, <0.009273,0.922976,0.384746>
 <21.303400,-61.730499,-30.698900>, <-0.183738,0.941949,0.281020>
}
   smooth_triangle{ <21.532900,-61.449501,-31.408800>, <0.075074,0.906264,0.415992>
 <21.394400,-61.397400,-31.468901>, <0.270603,0.825315,0.495610>
 <21.028099,-61.658600,-30.833900>, <0.205475,0.857709,0.471292>
}
   smooth_triangle{ <21.532900,-61.449501,-31.408800>, <0.075074,0.906264,0.415992>
 <21.028099,-61.658600,-30.833900>, <0.205475,0.857709,0.471292>
 <21.165600,-61.711300,-30.772100>, <0.009273,0.922976,0.384746>
}
   smooth_triangle{ <21.394400,-61.397400,-31.468901>, <0.270603,0.825315,0.495610>
 <21.260799,-61.311798,-31.513201>, <0.465745,0.690836,0.553017>
 <20.896000,-61.571800,-30.881100>, <0.400755,0.742539,0.536685>
}
   smooth_triangle{ <21.394400,-61.397400,-31.468901>, <0.270603,0.825315,0.495610>
 <20.896000,-61.571800,-30.881100>, <0.400755,0.742539,0.536685>
 <21.028099,-61.658600,-30.833900>, <0.205475,0.857709,0.471292>
}
   smooth_triangle{ <21.260799,-61.311798,-31.513201>, <0.465745,0.690836,0.553017>
 <21.155701,-61.206402,-31.533501>, <0.635802,0.511919,0.577662>
 <20.793100,-61.465302,-30.904900>, <0.583001,0.575673,0.573333>
}
   smooth_triangle{ <21.260799,-61.311798,-31.513201>, <0.465745,0.690836,0.553017>
 <20.793100,-61.465302,-30.904900>, <0.583001,0.575673,0.573333>
 <20.896000,-61.571800,-30.881100>, <0.400755,0.742539,0.536685>
}
   smooth_triangle{ <21.155701,-61.206402,-31.533501>, <0.635802,0.511919,0.577662>
 <21.071301,-61.077499,-31.532900>, <0.755673,0.323647,0.569395>
 <20.711201,-61.334801,-30.908701>, <0.721374,0.385808,0.575128>
}
   smooth_triangle{ <21.155701,-61.206402,-31.533501>, <0.635802,0.511919,0.577662>
 <20.711201,-61.334801,-30.908701>, <0.721374,0.385808,0.575128>
 <20.793100,-61.465302,-30.904900>, <0.583001,0.575673,0.573333>
}
   smooth_triangle{ <21.071301,-61.077499,-31.532900>, <0.755673,0.323647,0.569395>
 <21.009600,-60.933201,-31.513399>, <0.831189,0.141150,0.537775>
 <20.652201,-61.188801,-30.893900>, <0.810185,0.201429,0.550479>
}
   smooth_triangle{ <21.071301,-61.077499,-31.532900>, <0.755673,0.323647,0.569395>
 <20.652201,-61.188801,-30.893900>, <0.810185,0.201429,0.550479>
 <20.711201,-61.334801,-30.908701>, <0.721374,0.385808,0.575128>
}
   smooth_triangle{ <21.009600,-60.933201,-31.513399>, <0.831189,0.141150,0.537775>
 <20.972601,-60.781799,-31.476700>, <0.872737,-0.041305,0.486440>
 <20.618200,-61.035500,-30.862400>, <0.862446,0.019878,0.505759>
}
   smooth_triangle{ <21.009600,-60.933201,-31.513399>, <0.831189,0.141150,0.537775>
 <20.618200,-61.035500,-30.862400>, <0.862446,0.019878,0.505759>
 <20.652201,-61.188801,-30.893900>, <0.810185,0.201429,0.550479>
}
   smooth_triangle{ <20.972601,-60.781799,-31.476700>, <0.872737,-0.041305,0.486440>
 <20.962700,-60.631401,-31.424999>, <0.880987,-0.232139,0.412278>
 <20.611099,-60.883301,-30.815599>, <0.882322,-0.167446,0.439851>
}
   smooth_triangle{ <20.972601,-60.781799,-31.476700>, <0.872737,-0.041305,0.486440>
 <20.611099,-60.883301,-30.815599>, <0.882322,-0.167446,0.439851>
 <20.618200,-61.035500,-30.862400>, <0.862446,0.019878,0.505759>
}
   smooth_triangle{ <20.962700,-60.631401,-31.424999>, <0.880987,-0.232139,0.412278>
 <20.981800,-60.490299,-31.359900>, <0.846133,-0.434921,0.308063>
 <20.632999,-60.740501,-30.755301>, <0.863496,-0.366394,0.346598>
}
   smooth_triangle{ <20.962700,-60.631401,-31.424999>, <0.880987,-0.232139,0.412278>
 <20.632999,-60.740501,-30.755301>, <0.863496,-0.366394,0.346598>
 <20.611099,-60.883301,-30.815599>, <0.882322,-0.167446,0.439851>
}
   smooth_triangle{ <20.981800,-60.490299,-31.359900>, <0.846133,-0.434921,0.308063>
 <21.032101,-60.366600,-31.283600>, <0.753807,-0.634181,0.172019>
 <20.685699,-60.615398,-30.683100>, <0.791729,-0.569560,0.220831>
}
   smooth_triangle{ <20.981800,-60.490299,-31.359900>, <0.846133,-0.434921,0.308063>
 <20.685699,-60.615398,-30.683100>, <0.791729,-0.569560,0.220831>
 <20.632999,-60.740501,-30.755301>, <0.863496,-0.366394,0.346598>
}
   smooth_triangle{ <21.032101,-60.366600,-31.283600>, <0.753807,-0.634181,0.172019>
 <21.114100,-60.267601,-31.198400>, <0.617435,-0.786041,0.030229>
 <20.769600,-60.515202,-30.601200>, <0.665849,-0.742158,0.076465>
}
   smooth_triangle{ <21.032101,-60.366600,-31.283600>, <-0.709920,0.693628,-0.122040>
 <20.769600,-60.515202,-30.601200>, <-0.665849,0.742158,-0.076465>
 <21.114100,-60.267601,-31.198400>, <-0.617435,0.786041,-0.030229>
}
   smooth_triangle{ <21.032101,-60.366600,-31.283600>, <0.753807,-0.634181,0.172019>
 <20.769600,-60.515202,-30.601200>, <0.665849,-0.742158,0.076465>
 <20.685699,-60.615398,-30.683100>, <0.791729,-0.569560,0.220831>
}
   smooth_triangle{ <21.032101,-60.366600,-31.283600>, <-0.709920,0.693628,-0.122040>
 <20.685699,-60.615398,-30.683100>, <-0.709686,0.693893,-0.121893>
 <20.769600,-60.515202,-30.601200>, <-0.665849,0.742158,-0.076465>
}
   smooth_triangle{ <23.049000,-60.286598,-30.089199>, <0.474444,0.314575,-0.822159>
 <23.710100,-58.623699,-29.071501>, <0.474379,0.314589,-0.822191>
 <23.932501,-58.799400,-29.010401>, <0.474400,0.314577,-0.822184>
}
   smooth_triangle{ <23.049000,-60.286598,-30.089199>, <0.474444,0.314575,-0.822159>
 <23.080999,-59.669201,-29.834499>, <0.474466,0.314549,-0.822156>
 <23.710100,-58.623699,-29.071501>, <0.474379,0.314589,-0.822191>
}
   smooth_triangle{ <22.271500,-58.106800,-29.704000>, <0.474479,0.314505,-0.822166>
 <23.080999,-59.669201,-29.834499>, <0.474466,0.314549,-0.822156>
 <23.049000,-60.286598,-30.089199>, <0.474444,0.314575,-0.822159>
}
   smooth_triangle{ <22.271500,-58.106800,-29.704000>, <0.474479,0.314505,-0.822166>
 <22.316799,-57.507198,-29.448500>, <0.474442,0.314505,-0.822187>
 <23.080999,-59.669201,-29.834499>, <0.474466,0.314549,-0.822156>
}
   smooth_triangle{ <22.271500,-58.106800,-29.704000>, <0.474479,0.314505,-0.822166>
 <21.621799,-58.676998,-30.297001>, <0.474459,0.314502,-0.822179>
 <22.316799,-57.507198,-29.448500>, <0.474442,0.314505,-0.822187>
}
   smooth_triangle{ <21.633900,-59.180000,-30.482401>, <0.474463,0.314463,-0.822191>
 <21.621799,-58.676998,-30.297001>, <0.474459,0.314502,-0.822179>
 <22.271500,-58.106800,-29.704000>, <0.474479,0.314505,-0.822166>
}
   smooth_triangle{ <20.365801,-58.174702,-30.829700>, <0.474479,0.314516,-0.822161>
 <21.621799,-58.676998,-30.297001>, <0.474459,0.314502,-0.822179>
 <21.633900,-59.180000,-30.482401>, <0.474463,0.314463,-0.822191>
}
   smooth_triangle{ <20.365801,-58.174702,-30.829700>, <0.474479,0.314516,-0.822161>
 <20.565001,-57.839298,-30.586399>, <0.474490,0.314571,-0.822134>
 <21.621799,-58.676998,-30.297001>, <0.474459,0.314502,-0.822179>
}
   smooth_triangle{ <21.032101,-60.366600,-31.283600>, <0.475074,0.313528,-0.822195>
 <20.689400,-60.373299,-31.483999>, <0.474654,0.314072,-0.822230>
 <20.926100,-60.012299,-31.209900>, <0.475533,0.313880,-0.821795>
}
   smooth_triangle{ <20.926100,-60.012299,-31.209900>, <0.475533,0.313880,-0.821795>
 <21.114100,-60.267601,-31.198400>, <0.475608,0.313203,-0.822010>
 <21.032101,-60.366600,-31.283600>, <0.475074,0.313528,-0.822195>
}
   smooth_triangle{ <20.981800,-60.490299,-31.359900>, <0.474593,0.314537,-0.822088>
 <20.689400,-60.373299,-31.483999>, <0.474654,0.314072,-0.822230>
 <21.032101,-60.366600,-31.283600>, <0.475074,0.313528,-0.822195>
}
   smooth_triangle{ <20.649401,-60.646500,-31.611601>, <0.474530,0.314387,-0.822181>
 <19.615000,-60.058498,-31.983500>, <0.474076,0.314700,-0.822324>
 <20.689400,-60.373299,-31.483999>, <0.474654,0.314072,-0.822230>
}
   smooth_triangle{ <19.163000,-60.193199,-32.295799>, <0.474374,0.314505,-0.822226>
 <19.615000,-60.058498,-31.983500>, <0.474076,0.314700,-0.822324>
 <20.649401,-60.646500,-31.611601>, <0.474530,0.314387,-0.822181>
}
   smooth_triangle{ <20.222300,-58.410198,-31.002600>, <0.474277,0.314928,-0.822120>
 <19.615000,-60.058498,-31.983500>, <0.474076,0.314700,-0.822324>
 <19.163000,-60.193199,-32.295799>, <0.474374,0.314505,-0.822226>
}
   smooth_triangle{ <20.222300,-58.410198,-31.002600>, <0.474277,0.314928,-0.822120>
 <20.270300,-58.983299,-31.194599>, <0.474666,0.315178,-0.821800>
 <19.615000,-60.058498,-31.983500>, <0.474076,0.314700,-0.822324>
}
   smooth_triangle{ <21.123199,-59.849300,-31.033199>, <0.475190,0.314758,-0.821658>
 <20.270300,-58.983299,-31.194599>, <0.474666,0.315178,-0.821800>
 <20.222300,-58.410198,-31.002600>, <0.474277,0.314928,-0.822120>
}
   smooth_triangle{ <21.123199,-59.849300,-31.033199>, <0.475190,0.314758,-0.821658>
 <20.926100,-60.012299,-31.209900>, <0.475533,0.313880,-0.821795>
 <20.270300,-58.983299,-31.194599>, <0.474666,0.315178,-0.821800>
}
   smooth_triangle{ <20.981800,-60.490299,-31.359900>, <0.474593,0.314537,-0.822088>
 <20.649401,-60.646500,-31.611601>, <0.474530,0.314387,-0.822181>
 <20.689400,-60.373299,-31.483999>, <0.474654,0.314072,-0.822230>
}
   smooth_triangle{ <20.962700,-60.631401,-31.424999>, <0.474521,0.314474,-0.822153>
 <20.649401,-60.646500,-31.611601>, <0.474530,0.314387,-0.822181>
 <20.981800,-60.490299,-31.359900>, <0.474593,0.314537,-0.822088>
}
   smooth_triangle{ <20.972601,-60.781799,-31.476700>, <0.474496,0.314441,-0.822181>
 <20.649401,-60.646500,-31.611601>, <0.474530,0.314387,-0.822181>
 <20.962700,-60.631401,-31.424999>, <0.474521,0.314474,-0.822153>
}
   smooth_triangle{ <20.972601,-60.781799,-31.476700>, <0.474496,0.314441,-0.822181>
 <20.663601,-60.789001,-31.657801>, <0.474547,0.314344,-0.822188>
 <20.649401,-60.646500,-31.611601>, <0.474530,0.314387,-0.822181>
}
   smooth_triangle{ <20.972601,-60.781799,-31.476700>, <0.474496,0.314441,-0.822181>
 <20.696199,-60.931099,-31.693399>, <0.474366,0.314769,-0.822130>
 <20.663601,-60.789001,-31.657801>, <0.474547,0.314344,-0.822188>
}
   smooth_triangle{ <21.009600,-60.933201,-31.513399>, <0.474398,0.314520,-0.822207>
 <20.696199,-60.931099,-31.693399>, <0.474366,0.314769,-0.822130>
 <20.972601,-60.781799,-31.476700>, <0.474496,0.314441,-0.822181>
}
   smooth_triangle{ <21.009600,-60.933201,-31.513399>, <0.474398,0.314520,-0.822207>
 <20.746799,-61.070499,-31.717501>, <0.474474,0.314324,-0.822238>
 <20.696199,-60.931099,-31.693399>, <0.474366,0.314769,-0.822130>
}
   smooth_triangle{ <21.071301,-61.077499,-31.532900>, <0.474500,0.314500,-0.822156>
 <20.746799,-61.070499,-31.717501>, <0.474474,0.314324,-0.822238>
 <21.009600,-60.933201,-31.513399>, <0.474398,0.314520,-0.822207>
}
   smooth_triangle{ <21.071301,-61.077499,-31.532900>, <0.474500,0.314500,-0.822156>
 <20.814699,-61.204800,-31.729700>, <0.474418,0.314685,-0.822132>
 <20.746799,-61.070499,-31.717501>, <0.474474,0.314324,-0.822238>
}
   smooth_triangle{ <21.071301,-61.077499,-31.532900>, <0.474500,0.314500,-0.822156>
 <20.899500,-61.331799,-31.729401>, <0.474516,0.314667,-0.822082>
 <20.814699,-61.204800,-31.729700>, <0.474418,0.314685,-0.822132>
}
   smooth_triangle{ <21.155701,-61.206402,-31.533501>, <0.474541,0.314649,-0.822075>
 <20.899500,-61.331799,-31.729401>, <0.474516,0.314667,-0.822082>
 <21.071301,-61.077499,-31.532900>, <0.474500,0.314500,-0.822156>
}
   smooth_triangle{ <21.155701,-61.206402,-31.533501>, <0.474541,0.314649,-0.822075>
 <21.000299,-61.449100,-31.716101>, <0.474542,0.314599,-0.822093>
 <20.899500,-61.331799,-31.729401>, <0.474516,0.314667,-0.822082>
}
   smooth_triangle{ <21.260799,-61.311798,-31.513201>, <0.474453,0.314513,-0.822177>
 <21.000299,-61.449100,-31.716101>, <0.474542,0.314599,-0.822093>
 <21.155701,-61.206402,-31.533501>, <0.474541,0.314649,-0.822075>
}
   smooth_triangle{ <21.260799,-61.311798,-31.513201>, <0.474453,0.314513,-0.822177>
 <21.116699,-61.554199,-31.689100>, <0.474611,0.314431,-0.822118>
 <21.000299,-61.449100,-31.716101>, <0.474542,0.314599,-0.822093>
}
   smooth_triangle{ <21.260799,-61.311798,-31.513201>, <0.474453,0.314513,-0.822177>
 <21.312500,-61.679798,-31.624100>, <0.474380,0.314404,-0.822261>
 <21.116699,-61.554199,-31.689100>, <0.474611,0.314431,-0.822118>
}
   smooth_triangle{ <21.394400,-61.397400,-31.468901>, <0.474493,0.314416,-0.822192>
 <21.312500,-61.679798,-31.624100>, <0.474380,0.314404,-0.822261>
 <21.260799,-61.311798,-31.513201>, <0.474453,0.314513,-0.822177>
}
   smooth_triangle{ <21.394400,-61.397400,-31.468901>, <0.474493,0.314416,-0.822192>
 <21.515499,-61.756199,-31.536200>, <0.474505,0.314488,-0.822157>
 <21.312500,-61.679798,-31.624100>, <0.474380,0.314404,-0.822261>
}
   smooth_triangle{ <21.532900,-61.449501,-31.408800>, <0.474380,0.314560,-0.822202>
 <21.515499,-61.756199,-31.536200>, <0.474505,0.314488,-0.822157>
 <21.394400,-61.397400,-31.468901>, <0.474493,0.314416,-0.822192>
}
   smooth_triangle{ <21.532900,-61.449501,-31.408800>, <0.474380,0.314560,-0.822202>
 <21.718100,-61.784000,-31.430000>, <0.474340,0.314584,-0.822215>
 <21.515499,-61.756199,-31.536200>, <0.474505,0.314488,-0.822157>
}
   smooth_triangle{ <21.671200,-61.468601,-31.336399>, <0.474524,0.314518,-0.822134>
 <21.718100,-61.784000,-31.430000>, <0.474340,0.314584,-0.822215>
 <21.532900,-61.449501,-31.408800>, <0.474380,0.314560,-0.822202>
}
   smooth_triangle{ <21.671200,-61.468601,-31.336399>, <0.474524,0.314518,-0.822134>
 <21.912600,-61.764301,-31.310101>, <0.474630,0.314453,-0.822098>
 <21.718100,-61.784000,-31.430000>, <0.474340,0.314584,-0.822215>
}
   smooth_triangle{ <21.804001,-61.455002,-31.254499>, <0.474474,0.314424,-0.822199>
 <21.912600,-61.764301,-31.310101>, <0.474630,0.314453,-0.822098>
 <21.671200,-61.468601,-31.336399>, <0.474524,0.314518,-0.822134>
}
   smooth_triangle{ <21.804001,-61.455002,-31.254499>, <0.474474,0.314424,-0.822199>
 <22.091700,-61.697601,-31.181299>, <0.474467,0.314486,-0.822180>
 <21.912600,-61.764301,-31.310101>, <0.474630,0.314453,-0.822098>
}
   smooth_triangle{ <21.926201,-61.409500,-31.166599>, <0.474571,0.314472,-0.822125>
 <22.091700,-61.697601,-31.181299>, <0.474467,0.314486,-0.822180>
 <21.804001,-61.455002,-31.254499>, <0.474474,0.314424,-0.822199>
}
   smooth_triangle{ <21.926201,-61.409500,-31.166599>, <0.474571,0.314472,-0.822125>
 <22.247499,-61.584702,-31.048100>, <0.474549,0.314326,-0.822193>
 <22.091700,-61.697601,-31.181299>, <0.474467,0.314486,-0.822180>
}
   smooth_triangle{ <22.032600,-61.332401,-31.075701>, <0.474414,0.314212,-0.822315>
 <22.247499,-61.584702,-31.048100>, <0.474549,0.314326,-0.822193>
 <21.926201,-61.409500,-31.166599>, <0.474571,0.314472,-0.822125>
}
   smooth_triangle{ <22.032600,-61.332401,-31.075701>, <0.474414,0.314212,-0.822315>
 <22.372801,-61.426399,-30.915400>, <0.474410,0.314366,-0.822259>
 <22.247499,-61.584702,-31.048100>, <0.474549,0.314326,-0.822193>
}
   smooth_triangle{ <22.118000,-61.224499,-30.985201>, <0.474524,0.314531,-0.822130>
 <22.372801,-61.426399,-30.915400>, <0.474410,0.314366,-0.822259>
 <22.032600,-61.332401,-31.075701>, <0.474414,0.314212,-0.822315>
}
   smooth_triangle{ <22.118000,-61.224499,-30.985201>, <0.474524,0.314531,-0.822130>
 <22.455500,-61.234600,-30.794201>, <0.474610,0.314527,-0.822082>
 <22.372801,-61.426399,-30.915400>, <0.474410,0.314366,-0.822259>
}
   smooth_triangle{ <22.174500,-61.093601,-30.902500>, <0.474594,0.314386,-0.822145>
 <22.455500,-61.234600,-30.794201>, <0.474610,0.314527,-0.822082>
 <22.118000,-61.224499,-30.985201>, <0.474524,0.314531,-0.822130>
}
   smooth_triangle{ <22.174500,-61.093601,-30.902500>, <0.474594,0.314386,-0.822145>
 <22.490601,-61.026001,-30.694201>, <0.474570,0.314415,-0.822148>
 <22.455500,-61.234600,-30.794201>, <0.474610,0.314527,-0.822082>
}
   smooth_triangle{ <22.198500,-60.951199,-30.834200>, <0.474585,0.314484,-0.822113>
 <22.490601,-61.026001,-30.694201>, <0.474570,0.314415,-0.822148>
 <22.174500,-61.093601,-30.902500>, <0.474594,0.314386,-0.822145>
}
   smooth_triangle{ <22.198500,-60.951199,-30.834200>, <0.474585,0.314484,-0.822113>
 <22.480200,-60.809101,-30.617201>, <0.474601,0.314574,-0.822069>
 <22.490601,-61.026001,-30.694201>, <0.474570,0.314415,-0.822148>
}
   smooth_triangle{ <22.191299,-60.803101,-30.781700>, <0.474609,0.314588,-0.822058>
 <22.480200,-60.809101,-30.617201>, <0.474601,0.314574,-0.822069>
 <22.198500,-60.951199,-30.834200>, <0.474585,0.314484,-0.822113>
}
   smooth_triangle{ <22.191299,-60.803101,-30.781700>, <0.474609,0.314588,-0.822058>
 <22.426201,-60.592300,-30.565399>, <0.474619,0.314580,-0.822056>
 <22.480200,-60.809101,-30.617201>, <0.474601,0.314574,-0.822069>
}
   smooth_triangle{ <22.154499,-60.655102,-30.746300>, <0.474650,0.314517,-0.822063>
 <22.426201,-60.592300,-30.565399>, <0.474619,0.314580,-0.822056>
 <22.191299,-60.803101,-30.781700>, <0.474609,0.314588,-0.822058>
}
   smooth_triangle{ <22.154499,-60.655102,-30.746300>, <0.474650,0.314517,-0.822063>
 <22.330799,-60.383999,-30.540800>, <0.474674,0.314465,-0.822068>
 <22.426201,-60.592300,-30.565399>, <0.474619,0.314580,-0.822056>
}
   smooth_triangle{ <22.089399,-60.512901,-30.729500>, <0.474445,0.314596,-0.822150>
 <22.330799,-60.383999,-30.540800>, <0.474674,0.314465,-0.822068>
 <22.154499,-60.655102,-30.746300>, <0.474650,0.314517,-0.822063>
}
   smooth_triangle{ <22.089399,-60.512901,-30.729500>, <0.474445,0.314596,-0.822150>
 <22.196199,-60.192600,-30.545300>, <0.474309,0.314614,-0.822222>
 <22.330799,-60.383999,-30.540800>, <0.474674,0.314465,-0.822068>
}
   smooth_triangle{ <21.997499,-60.382401,-30.732500>, <0.474246,0.314599,-0.822264>
 <22.196199,-60.192600,-30.545300>, <0.474309,0.314614,-0.822222>
 <22.089399,-60.512901,-30.729500>, <0.474445,0.314596,-0.822150>
}
   smooth_triangle{ <21.997499,-60.382401,-30.732500>, <0.474246,0.314599,-0.822264>
 <22.024300,-60.026699,-30.580999>, <0.474447,0.314432,-0.822212>
 <22.196199,-60.192600,-30.545300>, <0.474309,0.314614,-0.822222>
}
   smooth_triangle{ <21.880199,-60.269199,-30.756901>, <0.474571,0.314383,-0.822159>
 <22.024300,-60.026699,-30.580999>, <0.474447,0.314432,-0.822212>
 <21.997499,-60.382401,-30.732500>, <0.474246,0.314599,-0.822264>
}
   smooth_triangle{ <21.880199,-60.269199,-30.756901>, <0.474571,0.314383,-0.822159>
 <21.897600,-59.938999,-30.620600>, <0.474617,0.314361,-0.822141>
 <22.024300,-60.026699,-30.580999>, <0.474447,0.314432,-0.822212>
}
   smooth_triangle{ <21.757200,-60.194099,-30.799200>, <0.474542,0.314384,-0.822176>
 <21.897600,-59.938999,-30.620600>, <0.474617,0.314361,-0.822141>
 <21.880199,-60.269199,-30.756901>, <0.474571,0.314383,-0.822159>
}
   smooth_triangle{ <21.757200,-60.194099,-30.799200>, <0.474542,0.314384,-0.822176>
 <21.766600,-59.872501,-30.670799>, <0.474310,0.314506,-0.822263>
 <21.897600,-59.938999,-30.620600>, <0.474617,0.314361,-0.822141>
}
   smooth_triangle{ <21.622400,-60.150002,-30.860100>, <0.474261,0.314603,-0.822254>
 <21.766600,-59.872501,-30.670799>, <0.474310,0.314506,-0.822263>
 <21.757200,-60.194099,-30.799200>, <0.474542,0.314384,-0.822176>
}
   smooth_triangle{ <21.622400,-60.150002,-30.860100>, <0.474261,0.314603,-0.822254>
 <21.633600,-59.826900,-30.730000>, <0.474149,0.314670,-0.822293>
 <21.766600,-59.872501,-30.670799>, <0.474310,0.314506,-0.822263>
}
   smooth_triangle{ <21.622400,-60.150002,-30.860100>, <0.474261,0.314603,-0.822254>
 <21.500601,-59.801998,-30.797199>, <0.474551,0.314592,-0.822091>
 <21.633600,-59.826900,-30.730000>, <0.474149,0.314670,-0.822293>
}
   smooth_triangle{ <21.483200,-60.136101,-30.935101>, <0.474642,0.314532,-0.822062>
 <21.500601,-59.801998,-30.797199>, <0.474551,0.314592,-0.822091>
 <21.622400,-60.150002,-30.860100>, <0.474261,0.314603,-0.822254>
}
   smooth_triangle{ <21.483200,-60.136101,-30.935101>, <0.474642,0.314532,-0.822062>
 <21.369900,-59.797501,-30.871000>, <0.474595,0.314497,-0.822102>
 <21.500601,-59.801998,-30.797199>, <0.474551,0.314592,-0.822091>
}
   smooth_triangle{ <21.347099,-60.151600,-31.019600>, <0.474471,0.314476,-0.822181>
 <21.369900,-59.797501,-30.871000>, <0.474595,0.314497,-0.822102>
 <21.483200,-60.136101,-30.935101>, <0.474642,0.314532,-0.822062>
}
   smooth_triangle{ <21.347099,-60.151600,-31.019600>, <0.474471,0.314476,-0.822181>
 <21.243299,-59.813400,-30.950100>, <0.474482,0.314576,-0.822137>
 <21.369900,-59.797501,-30.871000>, <0.474595,0.314497,-0.822102>
}
   smooth_triangle{ <21.347099,-60.151600,-31.019600>, <0.474471,0.314476,-0.822181>
 <21.123199,-59.849300,-31.033199>, <0.475190,0.314758,-0.821658>
 <21.243299,-59.813400,-30.950100>, <0.474482,0.314576,-0.822137>
}
   smooth_triangle{ <21.221500,-60.195702,-31.108900>, <0.475294,0.313994,-0.821890>
 <21.123199,-59.849300,-31.033199>, <0.475190,0.314758,-0.821658>
 <21.347099,-60.151600,-31.019600>, <0.474471,0.314476,-0.822181>
}
   smooth_triangle{ <21.221500,-60.195702,-31.108900>, <0.475294,0.313994,-0.821890>
 <20.926100,-60.012299,-31.209900>, <0.475533,0.313880,-0.821795>
 <21.123199,-59.849300,-31.033199>, <0.475190,0.314758,-0.821658>
}
   smooth_triangle{ <21.221500,-60.195702,-31.108900>, <0.475294,0.313994,-0.821890>
 <21.114100,-60.267601,-31.198400>, <0.475608,0.313203,-0.822010>
 <20.926100,-60.012299,-31.209900>, <0.475533,0.313880,-0.821795>
}
   smooth_triangle{ <22.703899,-60.534500,-29.491100>, <-0.480232,-0.277884,0.831960>
 <23.616100,-59.029598,-28.461901>, <-0.480245,-0.277872,0.831957>
 <23.397100,-58.851700,-28.528900>, <-0.480227,-0.277883,0.831963>
}
   smooth_triangle{ <22.703899,-60.534500,-29.491100>, <0.480232,0.277884,-0.831960>
 <23.397100,-58.851700,-28.528900>, <0.480227,0.277883,-0.831963>
 <23.616100,-59.029598,-28.461901>, <0.480245,0.277872,-0.831957>
}
   smooth_triangle{ <22.703899,-60.534500,-29.491100>, <-0.480232,-0.277884,0.831960>
 <23.397100,-58.851700,-28.528900>, <-0.480227,-0.277883,0.831963>
 <22.747801,-59.909801,-29.257099>, <-0.480180,-0.277866,0.831996>
}
   smooth_triangle{ <22.703899,-60.534500,-29.491100>, <0.480232,0.277884,-0.831960>
 <22.747801,-59.909801,-29.257099>, <0.480180,0.277866,-0.831996>
 <23.397100,-58.851700,-28.528900>, <0.480227,0.277883,-0.831963>
}
   smooth_triangle{ <21.968500,-58.328602,-29.178801>, <-0.480234,-0.277834,0.831975>
 <22.703899,-60.534500,-29.491100>, <-0.480232,-0.277884,0.831960>
 <22.747801,-59.909801,-29.257099>, <-0.480180,-0.277866,0.831996>
}
   smooth_triangle{ <21.968500,-58.328602,-29.178801>, <0.480234,0.277834,-0.831975>
 <22.747801,-59.909801,-29.257099>, <0.480180,0.277866,-0.831996>
 <22.703899,-60.534500,-29.491100>, <0.480232,0.277884,-0.831960>
}
   smooth_triangle{ <21.968500,-58.328602,-29.178801>, <-0.480234,-0.277834,0.831975>
 <22.747801,-59.909801,-29.257099>, <-0.480180,-0.277866,0.831996>
 <22.025400,-57.721901,-28.943399>, <-0.480226,-0.277779,0.831999>
}
   smooth_triangle{ <21.968500,-58.328602,-29.178801>, <0.480234,0.277834,-0.831975>
 <22.025400,-57.721901,-28.943399>, <0.480226,0.277779,-0.831999>
 <22.747801,-59.909801,-29.257099>, <0.480180,0.277866,-0.831996>
}
   smooth_triangle{ <21.968500,-58.328602,-29.178801>, <-0.480234,-0.277834,0.831975>
 <22.025400,-57.721901,-28.943399>, <-0.480226,-0.277779,0.831999>
 <21.307899,-58.905701,-29.752899>, <-0.480290,-0.277859,0.831935>
}
   smooth_triangle{ <21.968500,-58.328602,-29.178801>, <0.480234,0.277834,-0.831975>
 <21.307899,-58.905701,-29.752899>, <0.480290,0.277859,-0.831935>
 <22.025400,-57.721901,-28.943399>, <0.480226,0.277779,-0.831999>
}
   smooth_triangle{ <21.310301,-59.414600,-29.921499>, <-0.480259,-0.277891,0.831942>
 <21.968500,-58.328602,-29.178801>, <-0.480234,-0.277834,0.831975>
 <21.307899,-58.905701,-29.752899>, <-0.480290,-0.277859,0.831935>
}
   smooth_triangle{ <21.310301,-59.414600,-29.921499>, <0.480259,0.277891,-0.831942>
 <21.307899,-58.905701,-29.752899>, <0.480290,0.277859,-0.831935>
 <21.968500,-58.328602,-29.178801>, <0.480234,0.277834,-0.831975>
}
   smooth_triangle{ <20.061600,-58.397099,-30.302500>, <-0.480277,-0.277901,0.831928>
 <21.310301,-59.414600,-29.921499>, <-0.480259,-0.277891,0.831942>
 <21.307899,-58.905701,-29.752899>, <-0.480290,-0.277859,0.831935>
}
   smooth_triangle{ <20.061600,-58.397099,-30.302500>, <0.480277,0.277901,-0.831928>
 <21.307899,-58.905701,-29.752899>, <0.480290,0.277859,-0.831935>
 <21.310301,-59.414600,-29.921499>, <0.480259,0.277891,-0.831942>
}
   smooth_triangle{ <20.061600,-58.397099,-30.302500>, <-0.480277,-0.277901,0.831928>
 <21.307899,-58.905701,-29.752899>, <-0.480290,-0.277859,0.831935>
 <20.267300,-58.057800,-30.070400>, <-0.480280,-0.277913,0.831923>
}
   smooth_triangle{ <20.061600,-58.397099,-30.302500>, <0.480277,0.277901,-0.831928>
 <20.267300,-58.057800,-30.070400>, <0.480280,0.277913,-0.831923>
 <21.307899,-58.905701,-29.752899>, <0.480290,0.277859,-0.831935>
}
   smooth_triangle{ <20.685699,-60.615398,-30.683100>, <-0.481710,-0.275412,0.831928>
 <20.587000,-60.256500,-30.622000>, <-0.483088,-0.276197,0.830868>
 <20.342800,-60.622101,-30.883400>, <-0.480563,-0.276759,0.832144>
}
   smooth_triangle{ <20.685699,-60.615398,-30.683100>, <0.481710,0.275412,-0.831928>
 <20.342800,-60.622101,-30.883400>, <0.480563,0.276759,-0.832144>
 <20.587000,-60.256500,-30.622000>, <0.483088,0.276197,-0.830868>
}
   smooth_triangle{ <20.587000,-60.256500,-30.622000>, <-0.483088,-0.276197,0.830868>
 <20.685699,-60.615398,-30.683100>, <-0.481710,-0.275412,0.831928>
 <20.769600,-60.515202,-30.601200>, <-0.483136,-0.274160,0.831514>
}
   smooth_triangle{ <20.587000,-60.256500,-30.622000>, <0.483088,0.276197,-0.830868>
 <20.769600,-60.515202,-30.601200>, <0.483136,0.274160,-0.831514>
 <20.685699,-60.615398,-30.683100>, <0.481710,0.275412,-0.831928>
}
   smooth_triangle{ <20.632999,-60.740501,-30.755301>, <-0.480484,-0.277626,0.831901>
 <20.685699,-60.615398,-30.683100>, <-0.481710,-0.275412,0.831928>
 <20.342800,-60.622101,-30.883400>, <-0.480563,-0.276759,0.832144>
}
   smooth_triangle{ <20.632999,-60.740501,-30.755301>, <0.480484,0.277626,-0.831901>
 <20.342800,-60.622101,-30.883400>, <0.480563,0.276759,-0.832144>
 <20.685699,-60.615398,-30.683100>, <0.481710,0.275412,-0.831928>
}
   smooth_triangle{ <20.297600,-60.898701,-31.001801>, <-0.480328,-0.277736,0.831954>
 <20.342800,-60.622101,-30.883400>, <-0.480563,-0.276759,0.832144>
 <19.274700,-60.303501,-31.393499>, <-0.479293,-0.278351,0.832345>
}
   smooth_triangle{ <20.297600,-60.898701,-31.001801>, <0.480328,0.277736,-0.831954>
 <19.274700,-60.303501,-31.393499>, <0.479293,0.278351,-0.832345>
 <20.342800,-60.622101,-30.883400>, <0.480563,0.276759,-0.832144>
}
   smooth_triangle{ <18.820000,-60.439701,-31.701401>, <-0.480172,-0.277843,0.832008>
 <20.297600,-60.898701,-31.001801>, <-0.480328,-0.277736,0.831954>
 <19.274700,-60.303501,-31.393499>, <-0.479293,-0.278351,0.832345>
}
   smooth_triangle{ <18.820000,-60.439701,-31.701401>, <0.480172,0.277843,-0.832008>
 <19.274700,-60.303501,-31.393499>, <0.479293,0.278351,-0.832345>
 <20.297600,-60.898701,-31.001801>, <0.480328,0.277736,-0.831954>
}
   smooth_triangle{ <19.913700,-58.635502,-30.467501>, <-0.479850,-0.279133,0.831762>
 <18.820000,-60.439701,-31.701401>, <-0.480172,-0.277843,0.832008>
 <19.274700,-60.303501,-31.393499>, <-0.479293,-0.278351,0.832345>
}
   smooth_triangle{ <19.913700,-58.635502,-30.467501>, <0.479850,0.279133,-0.831762>
 <19.274700,-60.303501,-31.393499>, <0.479293,0.278351,-0.832345>
 <18.820000,-60.439701,-31.701401>, <0.480172,0.277843,-0.832008>
}
   smooth_triangle{ <19.913700,-58.635502,-30.467501>, <-0.479850,-0.279133,0.831762>
 <19.274700,-60.303501,-31.393499>, <-0.479293,-0.278351,0.832345>
 <19.951000,-59.215302,-30.641001>, <-0.480943,-0.279865,0.830884>
}
   smooth_triangle{ <19.913700,-58.635502,-30.467501>, <0.479850,0.279133,-0.831762>
 <19.951000,-59.215302,-30.641001>, <0.480943,0.279865,-0.830884>
 <19.274700,-60.303501,-31.393499>, <0.479293,0.278351,-0.832345>
}
   smooth_triangle{ <20.786699,-60.091900,-30.450001>, <-0.482209,-0.278734,0.830531>
 <19.913700,-58.635502,-30.467501>, <-0.479850,-0.279133,0.831762>
 <19.951000,-59.215302,-30.641001>, <-0.480943,-0.279865,0.830884>
}
   smooth_triangle{ <20.786699,-60.091900,-30.450001>, <0.482209,0.278734,-0.830531>
 <19.951000,-59.215302,-30.641001>, <0.480943,0.279865,-0.830884>
 <19.913700,-58.635502,-30.467501>, <0.479850,0.279133,-0.831762>
}
   smooth_triangle{ <20.786699,-60.091900,-30.450001>, <-0.482209,-0.278734,0.830531>
 <19.951000,-59.215302,-30.641001>, <-0.480943,-0.279865,0.830884>
 <20.587000,-60.256500,-30.622000>, <-0.483088,-0.276197,0.830868>
}
   smooth_triangle{ <20.786699,-60.091900,-30.450001>, <0.482209,0.278734,-0.830531>
 <20.587000,-60.256500,-30.622000>, <0.483088,0.276197,-0.830868>
 <19.951000,-59.215302,-30.641001>, <0.480943,0.279865,-0.830884>
}
   smooth_triangle{ <20.632999,-60.740501,-30.755301>, <-0.480484,-0.277626,0.831901>
 <20.342800,-60.622101,-30.883400>, <-0.480563,-0.276759,0.832144>
 <20.297600,-60.898701,-31.001801>, <-0.480328,-0.277736,0.831954>
}
   smooth_triangle{ <20.632999,-60.740501,-30.755301>, <0.480484,0.277626,-0.831901>
 <20.297600,-60.898701,-31.001801>, <0.480328,0.277736,-0.831954>
 <20.342800,-60.622101,-30.883400>, <0.480563,0.276759,-0.832144>
}
   smooth_triangle{ <20.611099,-60.883301,-30.815599>, <-0.480421,-0.277891,0.831849>
 <20.632999,-60.740501,-30.755301>, <-0.480484,-0.277626,0.831901>
 <20.297600,-60.898701,-31.001801>, <-0.480328,-0.277736,0.831954>
}
   smooth_triangle{ <20.611099,-60.883301,-30.815599>, <0.480421,0.277891,-0.831849>
 <20.297600,-60.898701,-31.001801>, <0.480328,0.277736,-0.831954>
 <20.632999,-60.740501,-30.755301>, <0.480484,0.277626,-0.831901>
}
   smooth_triangle{ <20.618200,-61.035500,-30.862400>, <-0.480283,-0.277696,0.831994>
 <20.611099,-60.883301,-30.815599>, <-0.480421,-0.277891,0.831849>
 <20.297600,-60.898701,-31.001801>, <-0.480328,-0.277736,0.831954>
}
   smooth_triangle{ <20.618200,-61.035500,-30.862400>, <0.480283,0.277696,-0.831994>
 <20.297600,-60.898701,-31.001801>, <0.480328,0.277736,-0.831954>
 <20.611099,-60.883301,-30.815599>, <0.480421,0.277891,-0.831849>
}
   smooth_triangle{ <20.618200,-61.035500,-30.862400>, <-0.480283,-0.277696,0.831994>
 <20.297600,-60.898701,-31.001801>, <-0.480328,-0.277736,0.831954>
 <20.309000,-61.042801,-31.043301>, <-0.480250,-0.277556,0.832059>
}
   smooth_triangle{ <20.618200,-61.035500,-30.862400>, <0.480283,0.277696,-0.831994>
 <20.309000,-61.042801,-31.043301>, <0.480250,0.277556,-0.832059>
 <20.297600,-60.898701,-31.001801>, <0.480328,0.277736,-0.831954>
}
   smooth_triangle{ <20.618200,-61.035500,-30.862400>, <-0.480283,-0.277696,0.831994>
 <20.309000,-61.042801,-31.043301>, <-0.480250,-0.277556,0.832059>
 <20.338900,-61.186600,-31.073999>, <-0.480239,-0.277658,0.832032>
}
   smooth_triangle{ <20.618200,-61.035500,-30.862400>, <0.480283,0.277696,-0.831994>
 <20.338900,-61.186600,-31.073999>, <0.480239,0.277658,-0.832032>
 <20.309000,-61.042801,-31.043301>, <0.480250,0.277556,-0.832059>
}
   smooth_triangle{ <20.652201,-61.188801,-30.893900>, <-0.480158,-0.277934,0.831986>
 <20.618200,-61.035500,-30.862400>, <-0.480283,-0.277696,0.831994>
 <20.338900,-61.186600,-31.073999>, <-0.480239,-0.277658,0.832032>
}
   smooth_triangle{ <20.652201,-61.188801,-30.893900>, <0.480158,0.277934,-0.831986>
 <20.338900,-61.186600,-31.073999>, <0.480239,0.277658,-0.832032>
 <20.618200,-61.035500,-30.862400>, <0.480283,0.277696,-0.831994>
}
   smooth_triangle{ <20.652201,-61.188801,-30.893900>, <-0.480158,-0.277934,0.831986>
 <20.338900,-61.186600,-31.073999>, <-0.480239,-0.277658,0.832032>
 <20.386801,-61.327702,-31.093500>, <-0.480104,-0.277983,0.832001>
}
   smooth_triangle{ <20.652201,-61.188801,-30.893900>, <0.480158,0.277934,-0.831986>
 <20.386801,-61.327702,-31.093500>, <0.480104,0.277983,-0.832001>
 <20.338900,-61.186600,-31.073999>, <0.480239,0.277658,-0.832032>
}
   smooth_triangle{ <20.711201,-61.334801,-30.908701>, <-0.480152,-0.277888,0.832005>
 <20.652201,-61.188801,-30.893900>, <-0.480158,-0.277934,0.831986>
 <20.386801,-61.327702,-31.093500>, <-0.480104,-0.277983,0.832001>
}
   smooth_triangle{ <20.711201,-61.334801,-30.908701>, <0.480152,0.277888,-0.832005>
 <20.386801,-61.327702,-31.093500>, <0.480104,0.277983,-0.832001>
 <20.652201,-61.188801,-30.893900>, <0.480158,0.277934,-0.831986>
}
   smooth_triangle{ <20.711201,-61.334801,-30.908701>, <-0.480152,-0.277888,0.832005>
 <20.386801,-61.327702,-31.093500>, <-0.480104,-0.277983,0.832001>
 <20.452101,-61.463699,-31.101200>, <-0.479964,-0.277905,0.832108>
}
   smooth_triangle{ <20.711201,-61.334801,-30.908701>, <0.480152,0.277888,-0.832005>
 <20.452101,-61.463699,-31.101200>, <0.479964,0.277905,-0.832108>
 <20.386801,-61.327702,-31.093500>, <0.480104,0.277983,-0.832001>
}
   smooth_triangle{ <20.711201,-61.334801,-30.908701>, <-0.480152,-0.277888,0.832005>
 <20.452101,-61.463699,-31.101200>, <-0.479964,-0.277905,0.832108>
 <20.534401,-61.592201,-31.096701>, <-0.480312,-0.277812,0.831938>
}
   smooth_triangle{ <20.711201,-61.334801,-30.908701>, <0.480152,0.277888,-0.832005>
 <20.534401,-61.592201,-31.096701>, <0.480312,0.277812,-0.831938>
 <20.452101,-61.463699,-31.101200>, <0.479964,0.277905,-0.832108>
}
   smooth_triangle{ <20.793100,-61.465302,-30.904900>, <-0.480437,-0.277773,0.831879>
 <20.711201,-61.334801,-30.908701>, <-0.480152,-0.277888,0.832005>
 <20.534401,-61.592201,-31.096701>, <-0.480312,-0.277812,0.831938>
}
   smooth_triangle{ <20.793100,-61.465302,-30.904900>, <0.480437,0.277773,-0.831879>
 <20.534401,-61.592201,-31.096701>, <0.480312,0.277812,-0.831938>
 <20.711201,-61.334801,-30.908701>, <0.480152,0.277888,-0.832005>
}
   smooth_triangle{ <20.793100,-61.465302,-30.904900>, <-0.480437,-0.277773,0.831879>
 <20.534401,-61.592201,-31.096701>, <-0.480312,-0.277812,0.831938>
 <20.632999,-61.710899,-31.079399>, <-0.480276,-0.277994,0.831898>
}
   smooth_triangle{ <20.793100,-61.465302,-30.904900>, <0.480437,0.277773,-0.831879>
 <20.632999,-61.710899,-31.079399>, <0.480276,0.277994,-0.831898>
 <20.534401,-61.592201,-31.096701>, <0.480312,0.277812,-0.831938>
}
   smooth_triangle{ <20.896000,-61.571800,-30.881100>, <-0.480168,-0.278021,0.831952>
 <20.793100,-61.465302,-30.904900>, <-0.480437,-0.277773,0.831879>
 <20.632999,-61.710899,-31.079399>, <-0.480276,-0.277994,0.831898>
}
   smooth_triangle{ <20.896000,-61.571800,-30.881100>, <0.480168,0.278021,-0.831952>
 <20.632999,-61.710899,-31.079399>, <0.480276,0.277994,-0.831898>
 <20.793100,-61.465302,-30.904900>, <0.480437,0.277773,-0.831879>
}
   smooth_triangle{ <20.896000,-61.571800,-30.881100>, <-0.480168,-0.278021,0.831952>
 <20.632999,-61.710899,-31.079399>, <-0.480276,-0.277994,0.831898>
 <20.747400,-61.817200,-31.048901>, <-0.480257,-0.278026,0.831899>
}
   smooth_triangle{ <20.896000,-61.571800,-30.881100>, <0.480168,0.278021,-0.831952>
 <20.747400,-61.817200,-31.048901>, <0.480257,0.278026,-0.831899>
 <20.632999,-61.710899,-31.079399>, <0.480276,0.277994,-0.831898>
}
   smooth_triangle{ <20.896000,-61.571800,-30.881100>, <-0.480168,-0.278021,0.831952>
 <20.747400,-61.817200,-31.048901>, <-0.480257,-0.278026,0.831899>
 <20.940800,-61.944302,-30.979700>, <-0.480178,-0.277923,0.831978>
}
   smooth_triangle{ <20.896000,-61.571800,-30.881100>, <0.480168,0.278021,-0.831952>
 <20.940800,-61.944302,-30.979700>, <0.480178,0.277923,-0.831978>
 <20.747400,-61.817200,-31.048901>, <0.480257,0.278026,-0.831899>
}
   smooth_triangle{ <21.028099,-61.658600,-30.833900>, <-0.480195,-0.277888,0.831980>
 <20.896000,-61.571800,-30.881100>, <-0.480168,-0.278021,0.831952>
 <20.940800,-61.944302,-30.979700>, <-0.480178,-0.277923,0.831978>
}
   smooth_triangle{ <21.028099,-61.658600,-30.833900>, <0.480195,0.277888,-0.831980>
 <20.940800,-61.944302,-30.979700>, <0.480178,0.277923,-0.831978>
 <20.896000,-61.571800,-30.881100>, <0.480168,0.278021,-0.831952>
}
   smooth_triangle{ <21.028099,-61.658600,-30.833900>, <-0.480195,-0.277888,0.831980>
 <20.940800,-61.944302,-30.979700>, <-0.480178,-0.277923,0.831978>
 <21.142300,-62.021599,-30.889200>, <-0.480404,-0.277833,0.831878>
}
   smooth_triangle{ <21.028099,-61.658600,-30.833900>, <0.480195,0.277888,-0.831980>
 <21.142300,-62.021599,-30.889200>, <0.480404,0.277833,-0.831878>
 <20.940800,-61.944302,-30.979700>, <0.480178,0.277923,-0.831978>
}
   smooth_triangle{ <21.165600,-61.711300,-30.772100>, <-0.480510,-0.277823,0.831820>
 <21.028099,-61.658600,-30.833900>, <-0.480195,-0.277888,0.831980>
 <21.142300,-62.021599,-30.889200>, <-0.480404,-0.277833,0.831878>
}
   smooth_triangle{ <21.165600,-61.711300,-30.772100>, <0.480510,0.277823,-0.831820>
 <21.142300,-62.021599,-30.889200>, <0.480404,0.277833,-0.831878>
 <21.028099,-61.658600,-30.833900>, <0.480195,0.277888,-0.831980>
}
   smooth_triangle{ <21.165600,-61.711300,-30.772100>, <-0.480510,-0.277823,0.831820>
 <21.142300,-62.021599,-30.889200>, <-0.480404,-0.277833,0.831878>
 <21.344200,-62.049900,-30.782000>, <-0.480387,-0.277805,0.831897>
}
   smooth_triangle{ <21.165600,-61.711300,-30.772100>, <0.480510,0.277823,-0.831820>
 <21.344200,-62.049900,-30.782000>, <0.480387,0.277805,-0.831897>
 <21.142300,-62.021599,-30.889200>, <0.480404,0.277833,-0.831878>
}
   smooth_triangle{ <21.303400,-61.730499,-30.698900>, <-0.480256,-0.277857,0.831955>
 <21.165600,-61.711300,-30.772100>, <-0.480510,-0.277823,0.831820>
 <21.344200,-62.049900,-30.782000>, <-0.480387,-0.277805,0.831897>
}
   smooth_triangle{ <21.303400,-61.730499,-30.698900>, <0.480256,0.277857,-0.831955>
 <21.344200,-62.049900,-30.782000>, <0.480387,0.277805,-0.831897>
 <21.165600,-61.711300,-30.772100>, <0.480510,0.277823,-0.831820>
}
   smooth_triangle{ <21.303400,-61.730499,-30.698900>, <-0.480256,-0.277857,0.831955>
 <21.344200,-62.049900,-30.782000>, <-0.480387,-0.277805,0.831897>
 <21.539200,-62.029800,-30.662800>, <-0.480115,-0.277908,0.832020>
}
   smooth_triangle{ <21.303400,-61.730499,-30.698900>, <0.480256,0.277857,-0.831955>
 <21.539200,-62.029800,-30.662800>, <0.480115,0.277908,-0.832020>
 <21.344200,-62.049900,-30.782000>, <0.480387,0.277805,-0.831897>
}
   smooth_triangle{ <21.436501,-61.716801,-30.617500>, <-0.480204,-0.278030,0.831928>
 <21.303400,-61.730499,-30.698900>, <-0.480256,-0.277857,0.831955>
 <21.539200,-62.029800,-30.662800>, <-0.480115,-0.277908,0.832020>
}
   smooth_triangle{ <21.436501,-61.716801,-30.617500>, <0.480204,0.278030,-0.831928>
 <21.539200,-62.029800,-30.662800>, <0.480115,0.277908,-0.832020>
 <21.303400,-61.730499,-30.698900>, <0.480256,0.277857,-0.831955>
}
   smooth_triangle{ <21.436501,-61.716801,-30.617500>, <-0.480204,-0.278030,0.831928>
 <21.539200,-62.029800,-30.662800>, <-0.480115,-0.277908,0.832020>
 <21.719500,-61.962299,-30.536200>, <-0.480221,-0.278093,0.831897>
}
   smooth_triangle{ <21.436501,-61.716801,-30.617500>, <0.480204,0.278030,-0.831928>
 <21.719500,-61.962299,-30.536200>, <0.480221,0.278093,-0.831897>
 <21.539200,-62.029800,-30.662800>, <0.480115,0.277908,-0.832020>
}
   smooth_triangle{ <21.559500,-61.670799,-30.531099>, <-0.480173,-0.277922,0.831982>
 <21.436501,-61.716801,-30.617500>, <-0.480204,-0.278030,0.831928>
 <21.719500,-61.962299,-30.536200>, <-0.480221,-0.278093,0.831897>
}
   smooth_triangle{ <21.559500,-61.670799,-30.531099>, <0.480173,0.277922,-0.831982>
 <21.719500,-61.962299,-30.536200>, <0.480221,0.278093,-0.831897>
 <21.436501,-61.716801,-30.617500>, <0.480204,0.278030,-0.831928>
}
   smooth_triangle{ <21.559500,-61.670799,-30.531099>, <-0.480173,-0.277922,0.831982>
 <21.719500,-61.962299,-30.536200>, <-0.480221,-0.278093,0.831897>
 <21.877501,-61.848099,-30.406799>, <-0.480168,-0.277764,0.832037>
}
   smooth_triangle{ <21.559500,-61.670799,-30.531099>, <0.480173,0.277922,-0.831982>
 <21.877501,-61.848099,-30.406799>, <0.480168,0.277764,-0.832037>
 <21.719500,-61.962299,-30.536200>, <0.480221,0.278093,-0.831897>
}
   smooth_triangle{ <21.667400,-61.592899,-30.442900>, <-0.480197,-0.277813,0.832004>
 <21.559500,-61.670799,-30.531099>, <-0.480173,-0.277922,0.831982>
 <21.877501,-61.848099,-30.406799>, <-0.480168,-0.277764,0.832037>
}
   smooth_triangle{ <21.667400,-61.592899,-30.442900>, <0.480197,0.277813,-0.832004>
 <21.877501,-61.848099,-30.406799>, <0.480168,0.277764,-0.832037>
 <21.559500,-61.670799,-30.531099>, <0.480173,0.277922,-0.831982>
}
   smooth_triangle{ <21.667400,-61.592899,-30.442900>, <-0.480197,-0.277813,0.832004>
 <21.877501,-61.848099,-30.406799>, <-0.480168,-0.277764,0.832037>
 <22.005800,-61.688000,-30.279301>, <-0.480208,-0.277934,0.831958>
}
   smooth_triangle{ <21.667400,-61.592899,-30.442900>, <0.480197,0.277813,-0.832004>
 <22.005800,-61.688000,-30.279301>, <0.480208,0.277934,-0.831958>
 <21.877501,-61.848099,-30.406799>, <0.480168,0.277764,-0.832037>
}
   smooth_triangle{ <21.754900,-61.483601,-30.355801>, <-0.480119,-0.278022,0.831979>
 <21.667400,-61.592899,-30.442900>, <-0.480197,-0.277813,0.832004>
 <22.005800,-61.688000,-30.279301>, <-0.480208,-0.277934,0.831958>
}
   smooth_triangle{ <21.754900,-61.483601,-30.355801>, <0.480119,0.278022,-0.831979>
 <22.005800,-61.688000,-30.279301>, <0.480208,0.277934,-0.831958>
 <21.667400,-61.592899,-30.442900>, <0.480197,0.277813,-0.832004>
}
   smooth_triangle{ <21.754900,-61.483601,-30.355801>, <-0.480119,-0.278022,0.831979>
 <22.005800,-61.688000,-30.279301>, <-0.480208,-0.277934,0.831958>
 <22.092300,-61.493900,-30.164600>, <-0.480018,-0.277934,0.832067>
}
   smooth_triangle{ <21.754900,-61.483601,-30.355801>, <0.480119,0.278022,-0.831979>
 <22.092300,-61.493900,-30.164600>, <0.480018,0.277934,-0.832067>
 <22.005800,-61.688000,-30.279301>, <0.480208,0.277934,-0.831958>
}
   smooth_triangle{ <21.813900,-61.351101,-30.277500>, <-0.480087,-0.277792,0.832075>
 <21.754900,-61.483601,-30.355801>, <-0.480119,-0.278022,0.831979>
 <22.092300,-61.493900,-30.164600>, <-0.480018,-0.277934,0.832067>
}
   smooth_triangle{ <21.813900,-61.351101,-30.277500>, <0.480087,0.277792,-0.832075>
 <22.092300,-61.493900,-30.164600>, <0.480018,0.277934,-0.832067>
 <21.754900,-61.483601,-30.355801>, <0.480119,0.278022,-0.831979>
}
   smooth_triangle{ <21.813900,-61.351101,-30.277500>, <-0.480087,-0.277792,0.832075>
 <22.092300,-61.493900,-30.164600>, <-0.480018,-0.277934,0.832067>
 <22.131399,-61.282799,-30.071501>, <-0.480177,-0.277787,0.832024>
}
   smooth_triangle{ <21.813900,-61.351101,-30.277500>, <0.480087,0.277792,-0.832075>
 <22.131399,-61.282799,-30.071501>, <0.480177,0.277787,-0.832024>
 <22.092300,-61.493900,-30.164600>, <0.480018,0.277934,-0.832067>
}
   smooth_triangle{ <21.840700,-61.207001,-30.214001>, <-0.480175,-0.277923,0.831980>
 <21.813900,-61.351101,-30.277500>, <-0.480087,-0.277792,0.832075>
 <22.131399,-61.282799,-30.071501>, <-0.480177,-0.277787,0.832024>
}
   smooth_triangle{ <21.840700,-61.207001,-30.214001>, <0.480175,0.277923,-0.831980>
 <22.131399,-61.282799,-30.071501>, <0.480177,0.277787,-0.832024>
 <21.813900,-61.351101,-30.277500>, <0.480087,0.277792,-0.832075>
}
   smooth_triangle{ <21.840700,-61.207001,-30.214001>, <-0.480175,-0.277923,0.831980>
 <22.131399,-61.282799,-30.071501>, <-0.480177,-0.277787,0.832024>
 <22.125099,-61.063301,-30.001801>, <-0.480128,-0.278096,0.831950>
}
   smooth_triangle{ <21.840700,-61.207001,-30.214001>, <0.480175,0.277923,-0.831980>
 <22.125099,-61.063301,-30.001801>, <0.480128,0.278096,-0.831950>
 <22.131399,-61.282799,-30.071501>, <0.480177,0.277787,-0.832024>
}
   smooth_triangle{ <21.836300,-61.057201,-30.166401>, <-0.480082,-0.278055,0.831990>
 <21.840700,-61.207001,-30.214001>, <-0.480175,-0.277923,0.831980>
 <22.125099,-61.063301,-30.001801>, <-0.480128,-0.278096,0.831950>
}
   smooth_triangle{ <21.836300,-61.057201,-30.166401>, <0.480082,0.278055,-0.831990>
 <22.125099,-61.063301,-30.001801>, <0.480128,0.278096,-0.831950>
 <21.840700,-61.207001,-30.214001>, <0.480175,0.277923,-0.831980>
}
   smooth_triangle{ <21.836300,-61.057201,-30.166401>, <-0.480082,-0.278055,0.831990>
 <22.125099,-61.063301,-30.001801>, <-0.480128,-0.278096,0.831950>
 <22.075399,-60.843899,-29.957199>, <-0.480115,-0.277873,0.832032>
}
   smooth_triangle{ <21.836300,-61.057201,-30.166401>, <0.480082,0.278055,-0.831990>
 <22.075399,-60.843899,-29.957199>, <0.480115,0.277873,-0.832032>
 <22.125099,-61.063301,-30.001801>, <0.480128,0.278096,-0.831950>
}
   smooth_triangle{ <21.802299,-60.907398,-30.136000>, <-0.480295,-0.277726,0.831977>
 <21.836300,-61.057201,-30.166401>, <-0.480082,-0.278055,0.831990>
 <22.075399,-60.843899,-29.957199>, <-0.480115,-0.277873,0.832032>
}
   smooth_triangle{ <21.802299,-60.907398,-30.136000>, <0.480295,0.277726,-0.831977>
 <22.075399,-60.843899,-29.957199>, <0.480115,0.277873,-0.832032>
 <21.836300,-61.057201,-30.166401>, <0.480082,0.278055,-0.831990>
}
   smooth_triangle{ <21.802299,-60.907398,-30.136000>, <-0.480295,-0.277726,0.831977>
 <22.075399,-60.843899,-29.957199>, <-0.480115,-0.277873,0.832032>
 <21.983999,-60.632999,-29.939501>, <-0.480333,-0.277827,0.831921>
}
   smooth_triangle{ <21.802299,-60.907398,-30.136000>, <0.480295,0.277726,-0.831977>
 <21.983999,-60.632999,-29.939501>, <0.480333,0.277827,-0.831921>
 <22.075399,-60.843899,-29.957199>, <0.480115,0.277873,-0.832032>
}
   smooth_triangle{ <21.740000,-60.763500,-30.124001>, <-0.480398,-0.277896,0.831860>
 <21.802299,-60.907398,-30.136000>, <-0.480295,-0.277726,0.831977>
 <21.983999,-60.632999,-29.939501>, <-0.480333,-0.277827,0.831921>
}
   smooth_triangle{ <21.740000,-60.763500,-30.124001>, <0.480398,0.277896,-0.831860>
 <21.983999,-60.632999,-29.939501>, <0.480333,0.277827,-0.831921>
 <21.802299,-60.907398,-30.136000>, <0.480295,0.277726,-0.831977>
}
   smooth_triangle{ <21.740000,-60.763500,-30.124001>, <-0.480398,-0.277896,0.831860>
 <21.983999,-60.632999,-29.939501>, <-0.480333,-0.277827,0.831921>
 <21.853001,-60.439400,-29.950399>, <-0.480449,-0.277921,0.831822>
}
   smooth_triangle{ <21.740000,-60.763500,-30.124001>, <0.480398,0.277896,-0.831860>
 <21.853001,-60.439400,-29.950399>, <0.480449,0.277921,-0.831822>
 <21.983999,-60.632999,-29.939501>, <0.480333,0.277827,-0.831921>
}
   smooth_triangle{ <21.650700,-60.631401,-30.131399>, <-0.480295,-0.277812,0.831948>
 <21.740000,-60.763500,-30.124001>, <-0.480398,-0.277896,0.831860>
 <21.853001,-60.439400,-29.950399>, <-0.480449,-0.277921,0.831822>
}
   smooth_triangle{ <21.650700,-60.631401,-30.131399>, <0.480295,0.277812,-0.831948>
 <21.853001,-60.439400,-29.950399>, <0.480449,0.277921,-0.831822>
 <21.740000,-60.763500,-30.124001>, <0.480398,0.277896,-0.831860>
}
   smooth_triangle{ <21.650700,-60.631401,-30.131399>, <-0.480295,-0.277812,0.831948>
 <21.853001,-60.439400,-29.950399>, <-0.480449,-0.277921,0.831822>
 <21.684401,-60.271400,-29.991800>, <-0.480104,-0.277728,0.832086>
}
   smooth_triangle{ <21.650700,-60.631401,-30.131399>, <0.480295,0.277812,-0.831948>
 <21.684401,-60.271400,-29.991800>, <0.480104,0.277728,-0.832086>
 <21.853001,-60.439400,-29.950399>, <0.480449,0.277921,-0.831822>
}
   smooth_triangle{ <21.535601,-60.516800,-30.159500>, <-0.479988,-0.277776,0.832137>
 <21.650700,-60.631401,-30.131399>, <-0.480295,-0.277812,0.831948>
 <21.684401,-60.271400,-29.991800>, <-0.480104,-0.277728,0.832086>
}
   smooth_triangle{ <21.535601,-60.516800,-30.159500>, <0.479988,0.277776,-0.832137>
 <21.684401,-60.271400,-29.991800>, <0.480104,0.277728,-0.832086>
 <21.650700,-60.631401,-30.131399>, <0.480295,0.277812,-0.831948>
}
   smooth_triangle{ <21.535601,-60.516800,-30.159500>, <-0.479988,-0.277776,0.832137>
 <21.684401,-60.271400,-29.991800>, <-0.480104,-0.277728,0.832086>
 <21.559299,-60.182701,-30.034300>, <-0.480231,-0.277710,0.832019>
}
   smooth_triangle{ <21.535601,-60.516800,-30.159500>, <0.479988,0.277776,-0.832137>
 <21.559299,-60.182701,-30.034300>, <0.480231,0.277710,-0.832019>
 <21.684401,-60.271400,-29.991800>, <0.480104,0.277728,-0.832086>
}
   smooth_triangle{ <21.414101,-60.440800,-30.204300>, <-0.480462,-0.277635,0.831910>
 <21.535601,-60.516800,-30.159500>, <-0.479988,-0.277776,0.832137>
 <21.559299,-60.182701,-30.034300>, <-0.480231,-0.277710,0.832019>
}
   smooth_triangle{ <21.414101,-60.440800,-30.204300>, <0.480462,0.277635,-0.831910>
 <21.559299,-60.182701,-30.034300>, <0.480231,0.277710,-0.832019>
 <21.535601,-60.516800,-30.159500>, <0.479988,0.277776,-0.832137>
}
   smooth_triangle{ <21.414101,-60.440800,-30.204300>, <-0.480462,-0.277635,0.831910>
 <21.559299,-60.182701,-30.034300>, <-0.480231,-0.277710,0.832019>
 <21.429701,-60.115398,-30.086700>, <-0.480220,-0.277799,0.831996>
}
   smooth_triangle{ <21.414101,-60.440800,-30.204300>, <0.480462,0.277635,-0.831910>
 <21.429701,-60.115398,-30.086700>, <0.480220,0.277799,-0.831996>
 <21.559299,-60.182701,-30.034300>, <0.480231,0.277710,-0.832019>
}
   smooth_triangle{ <21.280100,-60.396198,-30.266800>, <-0.480341,-0.277870,0.831902>
 <21.414101,-60.440800,-30.204300>, <-0.480462,-0.277635,0.831910>
 <21.429701,-60.115398,-30.086700>, <-0.480220,-0.277799,0.831996>
}
   smooth_triangle{ <21.280100,-60.396198,-30.266800>, <0.480341,0.277870,-0.831902>
 <21.429701,-60.115398,-30.086700>, <0.480220,0.277799,-0.831996>
 <21.414101,-60.440800,-30.204300>, <0.480462,0.277635,-0.831910>
}
   smooth_triangle{ <21.280100,-60.396198,-30.266800>, <-0.480341,-0.277870,0.831902>
 <21.429701,-60.115398,-30.086700>, <-0.480220,-0.277799,0.831996>
 <21.297501,-60.069302,-30.147499>, <-0.480274,-0.278032,0.831886>
}
   smooth_triangle{ <21.280100,-60.396198,-30.266800>, <0.480341,0.277870,-0.831902>
 <21.297501,-60.069302,-30.147499>, <0.480274,0.278032,-0.831886>
 <21.429701,-60.115398,-30.086700>, <0.480220,0.277799,-0.831996>
}
   smooth_triangle{ <21.280100,-60.396198,-30.266800>, <-0.480341,-0.277870,0.831902>
 <21.297501,-60.069302,-30.147499>, <-0.480274,-0.278032,0.831886>
 <21.165100,-60.043999,-30.215599>, <-0.480325,-0.277882,0.831908>
}
   smooth_triangle{ <21.280100,-60.396198,-30.266800>, <0.480341,0.277870,-0.831902>
 <21.165100,-60.043999,-30.215599>, <0.480325,0.277882,-0.831908>
 <21.297501,-60.069302,-30.147499>, <0.480274,0.278032,-0.831886>
}
   smooth_triangle{ <21.141199,-60.382099,-30.342300>, <-0.480140,-0.277938,0.831995>
 <21.280100,-60.396198,-30.266800>, <-0.480341,-0.277870,0.831902>
 <21.165100,-60.043999,-30.215599>, <-0.480325,-0.277882,0.831908>
}
   smooth_triangle{ <21.141199,-60.382099,-30.342300>, <0.480140,0.277938,-0.831995>
 <21.165100,-60.043999,-30.215599>, <0.480325,0.277882,-0.831908>
 <21.280100,-60.396198,-30.266800>, <0.480341,0.277870,-0.831902>
}
   smooth_triangle{ <21.141199,-60.382099,-30.342300>, <-0.480140,-0.277938,0.831995>
 <21.165100,-60.043999,-30.215599>, <-0.480325,-0.277882,0.831908>
 <21.034300,-60.039501,-30.289499>, <-0.480224,-0.278000,0.831926>
}
   smooth_triangle{ <21.141199,-60.382099,-30.342300>, <0.480140,0.277938,-0.831995>
 <21.034300,-60.039501,-30.289499>, <0.480224,0.278000,-0.831926>
 <21.165100,-60.043999,-30.215599>, <0.480325,0.277882,-0.831908>
}
   smooth_triangle{ <21.004801,-60.397800,-30.426300>, <-0.480275,-0.277924,0.831922>
 <21.141199,-60.382099,-30.342300>, <-0.480140,-0.277938,0.831995>
 <21.034300,-60.039501,-30.289499>, <-0.480224,-0.278000,0.831926>
}
   smooth_triangle{ <21.004801,-60.397800,-30.426300>, <0.480275,0.277924,-0.831922>
 <21.034300,-60.039501,-30.289499>, <0.480224,0.278000,-0.831926>
 <21.141199,-60.382099,-30.342300>, <0.480140,0.277938,-0.831995>
}
   smooth_triangle{ <21.004801,-60.397800,-30.426300>, <-0.480275,-0.277924,0.831922>
 <21.034300,-60.039501,-30.289499>, <-0.480224,-0.278000,0.831926>
 <20.907600,-60.055599,-30.368099>, <-0.480405,-0.277935,0.831843>
}
   smooth_triangle{ <21.004801,-60.397800,-30.426300>, <0.480275,0.277924,-0.831922>
 <20.907600,-60.055599,-30.368099>, <0.480405,0.277935,-0.831843>
 <21.034300,-60.039501,-30.289499>, <0.480224,0.278000,-0.831926>
}
   smooth_triangle{ <21.004801,-60.397800,-30.426300>, <-0.480275,-0.277924,0.831922>
 <20.907600,-60.055599,-30.368099>, <-0.480405,-0.277935,0.831843>
 <20.786699,-60.091900,-30.450001>, <-0.482209,-0.278734,0.830531>
}
   smooth_triangle{ <21.004801,-60.397800,-30.426300>, <0.480275,0.277924,-0.831922>
 <20.786699,-60.091900,-30.450001>, <0.482209,0.278734,-0.830531>
 <20.907600,-60.055599,-30.368099>, <0.480405,0.277935,-0.831843>
}
   smooth_triangle{ <20.878401,-60.442402,-30.514099>, <-0.482467,-0.276682,0.831067>
 <21.004801,-60.397800,-30.426300>, <-0.480275,-0.277924,0.831922>
 <20.786699,-60.091900,-30.450001>, <-0.482209,-0.278734,0.830531>
}
   smooth_triangle{ <20.878401,-60.442402,-30.514099>, <0.482467,0.276682,-0.831067>
 <20.786699,-60.091900,-30.450001>, <0.482209,0.278734,-0.830531>
 <21.004801,-60.397800,-30.426300>, <0.480275,0.277924,-0.831922>
}
   smooth_triangle{ <20.878401,-60.442402,-30.514099>, <-0.482467,-0.276682,0.831067>
 <20.786699,-60.091900,-30.450001>, <-0.482209,-0.278734,0.830531>
 <20.587000,-60.256500,-30.622000>, <-0.483088,-0.276197,0.830868>
}
   smooth_triangle{ <20.878401,-60.442402,-30.514099>, <0.482467,0.276682,-0.831067>
 <20.587000,-60.256500,-30.622000>, <0.483088,0.276197,-0.830868>
 <20.786699,-60.091900,-30.450001>, <0.482209,0.278734,-0.830531>
}
   smooth_triangle{ <20.878401,-60.442402,-30.514099>, <-0.482467,-0.276682,0.831067>
 <20.587000,-60.256500,-30.622000>, <-0.483088,-0.276197,0.830868>
 <20.769600,-60.515202,-30.601200>, <-0.483136,-0.274160,0.831514>
}
   smooth_triangle{ <20.878401,-60.442402,-30.514099>, <0.482467,0.276682,-0.831067>
 <20.769600,-60.515202,-30.601200>, <0.483136,0.274160,-0.831514>
 <20.587000,-60.256500,-30.622000>, <0.483088,0.276197,-0.830868>
}
   smooth_triangle{ <19.959801,-61.988800,-32.522900>, <0.772599,-0.603228,0.198004>
 <20.350401,-61.331299,-32.046001>, <0.773047,-0.602718,0.197811>
 <19.985500,-61.591702,-31.413401>, <0.772599,-0.603228,0.198004>
}
   smooth_triangle{ <19.959801,-61.988800,-32.522900>, <0.772599,-0.603228,0.198004>
 <19.985500,-61.591702,-31.413401>, <0.772599,-0.603228,0.198004>
 <19.582100,-62.257000,-31.868401>, <0.772152,-0.603738,0.198197>
}
   smooth_triangle{ <20.350401,-61.331299,-32.046001>, <0.424784,0.724192,0.543234>
 <20.081499,-61.118198,-32.119701>, <0.424885,0.724055,0.543339>
 <19.720600,-61.375801,-31.494200>, <0.424784,0.724192,0.543234>
}
   smooth_triangle{ <20.350401,-61.331299,-32.046001>, <0.424784,0.724192,0.543234>
 <19.720600,-61.375801,-31.494200>, <0.424784,0.724192,0.543234>
 <19.985500,-61.591702,-31.413401>, <0.424683,0.724330,0.543130>
}
   smooth_triangle{ <20.081499,-61.118198,-32.119701>, <-0.772711,0.603134,-0.197856>
 <19.690800,-61.775600,-32.596500>, <-0.772681,0.603029,-0.198294>
 <19.317400,-62.041199,-31.949200>, <-0.772711,0.603134,-0.197856>
}
   smooth_triangle{ <20.081499,-61.118198,-32.119701>, <0.772711,-0.603134,0.197856>
 <19.317400,-62.041199,-31.949200>, <0.772711,-0.603134,0.197856>
 <19.690800,-61.775600,-32.596500>, <0.772681,-0.603029,0.198294>
}
   smooth_triangle{ <20.081499,-61.118198,-32.119701>, <-0.772711,0.603134,-0.197856>
 <19.317400,-62.041199,-31.949200>, <-0.772711,0.603134,-0.197856>
 <19.720600,-61.375801,-31.494200>, <-0.772741,0.603240,-0.197418>
}
   smooth_triangle{ <20.081499,-61.118198,-32.119701>, <0.772711,-0.603134,0.197856>
 <19.720600,-61.375801,-31.494200>, <0.772741,-0.603240,0.197418>
 <19.317400,-62.041199,-31.949200>, <0.772711,-0.603134,0.197856>
}
   smooth_triangle{ <19.690800,-61.775600,-32.596500>, <-0.425367,-0.724422,-0.542472>
 <19.959801,-61.988800,-32.522900>, <-0.425636,-0.724296,-0.542429>
 <19.582100,-62.257000,-31.868401>, <-0.425367,-0.724422,-0.542472>
}
   smooth_triangle{ <19.690800,-61.775600,-32.596500>, <0.425367,0.724422,0.542472>
 <19.582100,-62.257000,-31.868401>, <0.425367,0.724422,0.542472>
 <19.959801,-61.988800,-32.522900>, <0.425636,0.724296,0.542429>
}
   smooth_triangle{ <19.690800,-61.775600,-32.596500>, <-0.425367,-0.724422,-0.542472>
 <19.582100,-62.257000,-31.868401>, <-0.425367,-0.724422,-0.542472>
 <19.317400,-62.041199,-31.949200>, <-0.425098,-0.724547,-0.542515>
}
   smooth_triangle{ <19.690800,-61.775600,-32.596500>, <0.425367,0.724422,0.542472>
 <19.317400,-62.041199,-31.949200>, <0.425098,0.724547,0.542515>
 <19.582100,-62.257000,-31.868401>, <0.425367,0.724422,0.542472>
}
   smooth_triangle{ <20.081499,-61.118198,-32.119701>, <0.474393,0.314480,-0.822225>
 <19.959801,-61.988800,-32.522900>, <0.474393,0.314480,-0.822225>
 <19.690800,-61.775600,-32.596500>, <0.474263,0.314525,-0.822283>
}
   smooth_triangle{ <20.081499,-61.118198,-32.119701>, <0.474393,0.314480,-0.822225>
 <20.350401,-61.331299,-32.046001>, <0.474522,0.314435,-0.822167>
 <19.959801,-61.988800,-32.522900>, <0.474393,0.314480,-0.822225>
}
   smooth_triangle{ <19.720600,-61.375801,-31.494200>, <-0.480300,-0.277797,0.831950>
 <19.317400,-62.041199,-31.949200>, <-0.480391,-0.277765,0.831908>
 <19.582100,-62.257000,-31.868401>, <-0.480300,-0.277797,0.831950>
}
   smooth_triangle{ <19.720600,-61.375801,-31.494200>, <0.480300,0.277797,-0.831950>
 <19.582100,-62.257000,-31.868401>, <0.480300,0.277797,-0.831950>
 <19.317400,-62.041199,-31.949200>, <0.480391,0.277765,-0.831908>
}
   smooth_triangle{ <19.720600,-61.375801,-31.494200>, <-0.480300,-0.277797,0.831950>
 <19.582100,-62.257000,-31.868401>, <-0.480300,-0.277797,0.831950>
 <19.985500,-61.591702,-31.413401>, <-0.480210,-0.277829,0.831991>
}
   smooth_triangle{ <19.720600,-61.375801,-31.494200>, <0.480300,0.277797,-0.831950>
 <19.985500,-61.591702,-31.413401>, <0.480210,0.277829,-0.831991>
 <19.582100,-62.257000,-31.868401>, <0.480300,0.277797,-0.831950>
}
texture
      {
      pigment
     {      colour rgb<1, 0.5, 0.0>
      }
      finish
     {
 }
      finish
     {ambient 0.9 diffuse 0.05}
}
}
no_shadow
}
//  Object:  vert.rep la1
object
{   union{
   smooth_triangle{ <29.824400,-84.581802,-35.925999>, <-0.077237,-0.987993,0.133808>
 <29.785601,-84.569000,-35.853802>, <-0.078595,-0.987841,0.134139>
 <28.220100,-84.574799,-36.856602>, <-0.084859,-0.987523,0.132653>
}
   smooth_triangle{ <29.824400,-84.581802,-35.925999>, <0.077237,0.987993,-0.133808>
 <28.220100,-84.574799,-36.856602>, <0.084859,0.987523,-0.132653>
 <29.785601,-84.569000,-35.853802>, <0.078595,0.987841,-0.134139>
}
   smooth_triangle{ <28.195601,-84.563004,-36.785099>, <-0.086678,-0.987373,0.132597>
 <28.220100,-84.574799,-36.856602>, <-0.084859,-0.987523,0.132653>
 <29.785601,-84.569000,-35.853802>, <-0.078595,-0.987841,0.134139>
}
   smooth_triangle{ <28.195601,-84.563004,-36.785099>, <0.086678,0.987373,-0.132597>
 <29.785601,-84.569000,-35.853802>, <0.078595,0.987841,-0.134139>
 <28.220100,-84.574799,-36.856602>, <0.084859,0.987523,-0.132653>
}
   smooth_triangle{ <29.785601,-84.569000,-35.853802>, <-0.078595,-0.987841,0.134139>
 <29.675699,-84.532501,-35.648998>, <-0.078599,-0.987839,0.134152>
 <28.195601,-84.563004,-36.785099>, <-0.086678,-0.987373,0.132597>
}
   smooth_triangle{ <29.785601,-84.569000,-35.853802>, <0.078595,0.987841,-0.134139>
 <28.195601,-84.563004,-36.785099>, <0.086678,0.987373,-0.132597>
 <29.675699,-84.532501,-35.648998>, <0.078599,0.987839,-0.134152>
}
   smooth_triangle{ <28.125601,-84.529503,-36.581501>, <-0.086810,-0.987387,0.132402>
 <28.195601,-84.563004,-36.785099>, <-0.086678,-0.987373,0.132597>
 <29.675699,-84.532501,-35.648998>, <-0.078599,-0.987839,0.134152>
}
   smooth_triangle{ <28.125601,-84.529503,-36.581501>, <0.086810,0.987387,-0.132402>
 <29.675699,-84.532501,-35.648998>, <0.078599,0.987839,-0.134152>
 <28.195601,-84.563004,-36.785099>, <0.086678,0.987373,-0.132597>
}
   smooth_triangle{ <29.675699,-84.532501,-35.648998>, <-0.078599,-0.987839,0.134152>
 <29.503901,-84.475601,-35.329102>, <-0.078581,-0.987862,0.133990>
 <28.125601,-84.529503,-36.581501>, <-0.086810,-0.987387,0.132402>
}
   smooth_triangle{ <29.675699,-84.532501,-35.648998>, <0.078599,0.987839,-0.134152>
 <28.125601,-84.529503,-36.581501>, <0.086810,0.987387,-0.132402>
 <29.503901,-84.475601,-35.329102>, <0.078581,0.987862,-0.133990>
}
   smooth_triangle{ <28.014900,-84.476799,-36.262001>, <-0.087088,-0.987391,0.132194>
 <28.125601,-84.529503,-36.581501>, <-0.086810,-0.987387,0.132402>
 <29.503901,-84.475601,-35.329102>, <-0.078581,-0.987862,0.133990>
}
   smooth_triangle{ <28.014900,-84.476799,-36.262001>, <0.087088,0.987391,-0.132194>
 <29.503901,-84.475601,-35.329102>, <0.078581,0.987862,-0.133990>
 <28.125601,-84.529503,-36.581501>, <0.086810,0.987387,-0.132402>
}
   smooth_triangle{ <29.503901,-84.475601,-35.329102>, <-0.078581,-0.987862,0.133990>
 <29.279800,-84.401497,-34.911900>, <-0.078544,-0.987878,0.133896>
 <28.014900,-84.476799,-36.262001>, <-0.087088,-0.987391,0.132194>
}
   smooth_triangle{ <29.503901,-84.475601,-35.329102>, <0.078581,0.987862,-0.133990>
 <28.014900,-84.476799,-36.262001>, <0.087088,0.987391,-0.132194>
 <29.279800,-84.401497,-34.911900>, <0.078544,0.987878,-0.133896>
}
   smooth_triangle{ <27.868299,-84.407600,-35.842701>, <-0.087807,-0.987359,0.131952>
 <28.014900,-84.476799,-36.262001>, <-0.087088,-0.987391,0.132194>
 <29.279800,-84.401497,-34.911900>, <-0.078544,-0.987878,0.133896>
}
   smooth_triangle{ <27.868299,-84.407600,-35.842701>, <0.087807,0.987359,-0.131952>
 <29.279800,-84.401497,-34.911900>, <0.078544,0.987878,-0.133896>
 <28.014900,-84.476799,-36.262001>, <0.087088,0.987391,-0.132194>
}
   smooth_triangle{ <28.220100,-84.574799,-36.856602>, <-0.084859,-0.987523,0.132653>
 <28.195601,-84.563004,-36.785099>, <-0.086678,-0.987373,0.132597>
 <26.757200,-84.553001,-37.707699>, <-0.094145,-0.986896,0.131049>
}
   smooth_triangle{ <28.220100,-84.574799,-36.856602>, <0.084859,0.987523,-0.132653>
 <26.757200,-84.553001,-37.707699>, <0.094145,0.986896,-0.131049>
 <28.195601,-84.563004,-36.785099>, <0.086678,0.987373,-0.132597>
}
   smooth_triangle{ <26.742201,-84.542297,-37.637901>, <-0.095392,-0.986853,0.130465>
 <26.757200,-84.553001,-37.707699>, <-0.094145,-0.986896,0.131049>
 <28.195601,-84.563004,-36.785099>, <-0.086678,-0.987373,0.132597>
}
   smooth_triangle{ <26.742201,-84.542297,-37.637901>, <0.095392,0.986853,-0.130465>
 <28.195601,-84.563004,-36.785099>, <0.086678,0.987373,-0.132597>
 <26.757200,-84.553001,-37.707699>, <0.094145,0.986896,-0.131049>
}
   smooth_triangle{ <28.195601,-84.563004,-36.785099>, <-0.086678,-0.987373,0.132597>
 <28.125601,-84.529503,-36.581501>, <-0.086810,-0.987387,0.132402>
 <26.742201,-84.542297,-37.637901>, <-0.095392,-0.986853,0.130465>
}
   smooth_triangle{ <28.195601,-84.563004,-36.785099>, <0.086678,0.987373,-0.132597>
 <26.742201,-84.542297,-37.637901>, <0.095392,0.986853,-0.130465>
 <28.125601,-84.529503,-36.581501>, <0.086810,0.987387,-0.132402>
}
   smooth_triangle{ <26.698601,-84.511597,-37.438301>, <-0.095480,-0.986826,0.130604>
 <26.742201,-84.542297,-37.637901>, <-0.095392,-0.986853,0.130465>
 <28.125601,-84.529503,-36.581501>, <-0.086810,-0.987387,0.132402>
}
   smooth_triangle{ <26.698601,-84.511597,-37.438301>, <0.095480,0.986826,-0.130604>
 <28.125601,-84.529503,-36.581501>, <0.086810,0.987387,-0.132402>
 <26.742201,-84.542297,-37.637901>, <0.095392,0.986853,-0.130465>
}
   smooth_triangle{ <28.125601,-84.529503,-36.581501>, <-0.086810,-0.987387,0.132402>
 <28.014900,-84.476799,-36.262001>, <-0.087088,-0.987391,0.132194>
 <26.698601,-84.511597,-37.438301>, <-0.095480,-0.986826,0.130604>
}
   smooth_triangle{ <28.125601,-84.529503,-36.581501>, <0.086810,0.987387,-0.132402>
 <26.698601,-84.511597,-37.438301>, <0.095480,0.986826,-0.130604>
 <28.014900,-84.476799,-36.262001>, <0.087088,0.987391,-0.132194>
}
   smooth_triangle{ <26.629299,-84.463303,-37.124100>, <-0.095368,-0.986859,0.130441>
 <26.698601,-84.511597,-37.438301>, <-0.095480,-0.986826,0.130604>
 <28.014900,-84.476799,-36.262001>, <-0.087088,-0.987391,0.132194>
}
   smooth_triangle{ <26.629299,-84.463303,-37.124100>, <0.095368,0.986859,-0.130441>
 <28.014900,-84.476799,-36.262001>, <0.087088,0.987391,-0.132194>
 <26.698601,-84.511597,-37.438301>, <0.095480,0.986826,-0.130604>
}
   smooth_triangle{ <28.014900,-84.476799,-36.262001>, <-0.087088,-0.987391,0.132194>
 <27.868299,-84.407600,-35.842701>, <-0.087807,-0.987359,0.131952>
 <26.629299,-84.463303,-37.124100>, <-0.095368,-0.986859,0.130441>
}
   smooth_triangle{ <28.014900,-84.476799,-36.262001>, <0.087088,0.987391,-0.132194>
 <26.629299,-84.463303,-37.124100>, <0.095368,0.986859,-0.130441>
 <27.868299,-84.407600,-35.842701>, <0.087807,0.987359,-0.131952>
}
   smooth_triangle{ <26.537001,-84.399597,-36.710499>, <-0.095163,-0.986900,0.130279>
 <26.629299,-84.463303,-37.124100>, <-0.095368,-0.986859,0.130441>
 <27.868299,-84.407600,-35.842701>, <-0.087807,-0.987359,0.131952>
}
   smooth_triangle{ <26.537001,-84.399597,-36.710499>, <0.095163,0.986900,-0.130279>
 <27.868299,-84.407600,-35.842701>, <0.087807,0.987359,-0.131952>
 <26.629299,-84.463303,-37.124100>, <0.095368,0.986859,-0.130441>
}
   smooth_triangle{ <29.279800,-84.401497,-34.911900>, <-0.078544,-0.987878,0.133896>
 <28.712000,-84.213799,-33.855701>, <-0.078992,-0.987887,0.133566>
 <27.868299,-84.407600,-35.842701>, <-0.087807,-0.987359,0.131952>
}
   smooth_triangle{ <29.279800,-84.401497,-34.911900>, <0.078544,0.987878,-0.133896>
 <27.868299,-84.407600,-35.842701>, <0.087807,0.987359,-0.131952>
 <28.712000,-84.213799,-33.855701>, <0.078992,0.987887,-0.133566>
}
   smooth_triangle{ <27.486401,-84.229698,-34.769901>, <-0.089131,-0.987327,0.131302>
 <27.868299,-84.407600,-35.842701>, <-0.087807,-0.987359,0.131952>
 <28.712000,-84.213799,-33.855701>, <-0.078992,-0.987887,0.133566>
}
   smooth_triangle{ <27.486401,-84.229698,-34.769901>, <0.089131,0.987327,-0.131302>
 <28.712000,-84.213799,-33.855701>, <0.078992,0.987887,-0.133566>
 <27.868299,-84.407600,-35.842701>, <0.087807,0.987359,-0.131952>
}
   smooth_triangle{ <28.712000,-84.213799,-33.855701>, <-0.078992,-0.987887,0.133566>
 <28.047501,-83.994904,-32.621498>, <-0.080552,-0.987903,0.132513>
 <27.486401,-84.229698,-34.769901>, <-0.089131,-0.987327,0.131302>
}
   smooth_triangle{ <28.712000,-84.213799,-33.855701>, <0.078992,0.987887,-0.133566>
 <27.486401,-84.229698,-34.769901>, <0.089131,0.987327,-0.131302>
 <28.047501,-83.994904,-32.621498>, <0.080552,0.987903,-0.132513>
}
   smooth_triangle{ <27.018700,-84.016701,-33.492901>, <-0.088778,-0.987601,0.129471>
 <27.486401,-84.229698,-34.769901>, <-0.089131,-0.987327,0.131302>
 <28.047501,-83.994904,-32.621498>, <-0.080552,-0.987903,0.132513>
}
   smooth_triangle{ <27.018700,-84.016701,-33.492901>, <0.088778,0.987601,-0.129471>
 <28.047501,-83.994904,-32.621498>, <0.080552,0.987903,-0.132513>
 <27.486401,-84.229698,-34.769901>, <0.089131,0.987327,-0.131302>
}
   smooth_triangle{ <27.868299,-84.407600,-35.842701>, <-0.087807,-0.987359,0.131952>
 <27.486401,-84.229698,-34.769901>, <-0.089131,-0.987327,0.131302>
 <26.537001,-84.399597,-36.710499>, <-0.095163,-0.986900,0.130279>
}
   smooth_triangle{ <27.868299,-84.407600,-35.842701>, <0.087807,0.987359,-0.131952>
 <26.537001,-84.399597,-36.710499>, <0.095163,0.986900,-0.130279>
 <27.486401,-84.229698,-34.769901>, <0.089131,0.987327,-0.131302>
}
   smooth_triangle{ <26.293600,-84.235802,-35.645500>, <-0.094342,-0.987029,0.129898>
 <26.537001,-84.399597,-36.710499>, <-0.095163,-0.986900,0.130279>
 <27.486401,-84.229698,-34.769901>, <-0.089131,-0.987327,0.131302>
}
   smooth_triangle{ <26.293600,-84.235802,-35.645500>, <0.094342,0.987029,-0.129898>
 <27.486401,-84.229698,-34.769901>, <0.089131,0.987327,-0.131302>
 <26.537001,-84.399597,-36.710499>, <0.095163,0.986900,-0.130279>
}
   smooth_triangle{ <27.486401,-84.229698,-34.769901>, <-0.089131,-0.987327,0.131302>
 <27.018700,-84.016701,-33.492901>, <-0.088778,-0.987601,0.129471>
 <26.293600,-84.235802,-35.645500>, <-0.094342,-0.987029,0.129898>
}
   smooth_triangle{ <27.486401,-84.229698,-34.769901>, <0.089131,0.987327,-0.131302>
 <26.293600,-84.235802,-35.645500>, <0.094342,0.987029,-0.129898>
 <27.018700,-84.016701,-33.492901>, <0.088778,0.987601,-0.129471>
}
   smooth_triangle{ <25.989799,-84.038696,-34.364300>, <-0.092762,-0.987361,0.128509>
 <26.293600,-84.235802,-35.645500>, <-0.094342,-0.987029,0.129898>
 <27.018700,-84.016701,-33.492901>, <-0.088778,-0.987601,0.129471>
}
   smooth_triangle{ <25.989799,-84.038696,-34.364300>, <0.092762,0.987361,-0.128509>
 <27.018700,-84.016701,-33.492901>, <0.088778,0.987601,-0.129471>
 <26.293600,-84.235802,-35.645500>, <0.094342,0.987029,-0.129898>
}
   smooth_triangle{ <26.757200,-84.553001,-37.707699>, <-0.094145,-0.986896,0.131049>
 <26.742201,-84.542297,-37.637901>, <-0.095392,-0.986853,0.130465>
 <25.458200,-84.521301,-38.465500>, <-0.101823,-0.986483,0.128390>
}
   smooth_triangle{ <26.757200,-84.553001,-37.707699>, <0.094145,0.986896,-0.131049>
 <25.458200,-84.521301,-38.465500>, <0.101823,0.986483,-0.128390>
 <26.742201,-84.542297,-37.637901>, <0.095392,0.986853,-0.130465>
}
   smooth_triangle{ <25.448200,-84.511497,-38.397800>, <-0.102846,-0.986449,0.127833>
 <25.458200,-84.521301,-38.465500>, <-0.101823,-0.986483,0.128390>
 <26.742201,-84.542297,-37.637901>, <-0.095392,-0.986853,0.130465>
}
   smooth_triangle{ <25.448200,-84.511497,-38.397800>, <0.102846,0.986449,-0.127833>
 <26.742201,-84.542297,-37.637901>, <0.095392,0.986853,-0.130465>
 <25.458200,-84.521301,-38.465500>, <0.101823,0.986483,-0.128390>
}
   smooth_triangle{ <26.742201,-84.542297,-37.637901>, <-0.095392,-0.986853,0.130465>
 <26.698601,-84.511597,-37.438301>, <-0.095480,-0.986826,0.130604>
 <25.448200,-84.511497,-38.397800>, <-0.102846,-0.986449,0.127833>
}
   smooth_triangle{ <26.742201,-84.542297,-37.637901>, <0.095392,0.986853,-0.130465>
 <25.448200,-84.511497,-38.397800>, <0.102846,0.986449,-0.127833>
 <26.698601,-84.511597,-37.438301>, <0.095480,0.986826,-0.130604>
}
   smooth_triangle{ <25.419001,-84.483101,-38.203701>, <-0.102883,-0.986383,0.128311>
 <25.448200,-84.511497,-38.397800>, <-0.102846,-0.986449,0.127833>
 <26.698601,-84.511597,-37.438301>, <-0.095480,-0.986826,0.130604>
}
   smooth_triangle{ <25.419001,-84.483101,-38.203701>, <0.102883,0.986383,-0.128311>
 <26.698601,-84.511597,-37.438301>, <0.095480,0.986826,-0.130604>
 <25.448200,-84.511497,-38.397800>, <0.102846,0.986449,-0.127833>
}
   smooth_triangle{ <26.698601,-84.511597,-37.438301>, <-0.095480,-0.986826,0.130604>
 <26.629299,-84.463303,-37.124100>, <-0.095368,-0.986859,0.130441>
 <25.419001,-84.483101,-38.203701>, <-0.102883,-0.986383,0.128311>
}
   smooth_triangle{ <26.698601,-84.511597,-37.438301>, <0.095480,0.986826,-0.130604>
 <25.419001,-84.483101,-38.203701>, <0.102883,0.986383,-0.128311>
 <26.629299,-84.463303,-37.124100>, <0.095368,0.986859,-0.130441>
}
   smooth_triangle{ <25.371799,-84.438301,-37.897301>, <-0.102338,-0.986464,0.128121>
 <25.419001,-84.483101,-38.203701>, <-0.102883,-0.986383,0.128311>
 <26.629299,-84.463303,-37.124100>, <-0.095368,-0.986859,0.130441>
}
   smooth_triangle{ <25.371799,-84.438301,-37.897301>, <0.102338,0.986464,-0.128121>
 <26.629299,-84.463303,-37.124100>, <0.095368,0.986859,-0.130441>
 <25.419001,-84.483101,-38.203701>, <0.102883,0.986383,-0.128311>
}
   smooth_triangle{ <26.629299,-84.463303,-37.124100>, <-0.095368,-0.986859,0.130441>
 <26.537001,-84.399597,-36.710499>, <-0.095163,-0.986900,0.130279>
 <25.371799,-84.438301,-37.897301>, <-0.102338,-0.986464,0.128121>
}
   smooth_triangle{ <26.629299,-84.463303,-37.124100>, <0.095368,0.986859,-0.130441>
 <25.371799,-84.438301,-37.897301>, <0.102338,0.986464,-0.128121>
 <26.537001,-84.399597,-36.710499>, <0.095163,0.986900,-0.130279>
}
   smooth_triangle{ <25.308001,-84.378998,-37.492401>, <-0.101558,-0.986571,0.127923>
 <25.371799,-84.438301,-37.897301>, <-0.102338,-0.986464,0.128121>
 <26.537001,-84.399597,-36.710499>, <-0.095163,-0.986900,0.130279>
}
   smooth_triangle{ <25.308001,-84.378998,-37.492401>, <0.101558,0.986571,-0.127923>
 <26.537001,-84.399597,-36.710499>, <0.095163,0.986900,-0.130279>
 <25.371799,-84.438301,-37.897301>, <0.102338,0.986464,-0.128121>
}
   smooth_triangle{ <25.458200,-84.521301,-38.465500>, <-0.101823,-0.986483,0.128390>
 <25.448200,-84.511497,-38.397800>, <-0.102846,-0.986449,0.127833>
 <24.345400,-84.484596,-39.116299>, <-0.108116,-0.986272,0.124815>
}
   smooth_triangle{ <25.458200,-84.521301,-38.465500>, <0.101823,0.986483,-0.128390>
 <24.345400,-84.484596,-39.116299>, <0.108116,0.986272,-0.124815>
 <25.448200,-84.511497,-38.397800>, <0.102846,0.986449,-0.127833>
}
   smooth_triangle{ <24.337200,-84.475502,-39.050999>, <-0.109013,-0.986226,0.124395>
 <24.345400,-84.484596,-39.116299>, <-0.108116,-0.986272,0.124815>
 <25.448200,-84.511497,-38.397800>, <-0.102846,-0.986449,0.127833>
}
   smooth_triangle{ <24.337200,-84.475502,-39.050999>, <0.109013,0.986226,-0.124395>
 <25.448200,-84.511497,-38.397800>, <0.102846,0.986449,-0.127833>
 <24.345400,-84.484596,-39.116299>, <0.108116,0.986272,-0.124815>
}
   smooth_triangle{ <25.448200,-84.511497,-38.397800>, <-0.102846,-0.986449,0.127833>
 <25.419001,-84.483101,-38.203701>, <-0.102883,-0.986383,0.128311>
 <24.337200,-84.475502,-39.050999>, <-0.109013,-0.986226,0.124395>
}
   smooth_triangle{ <25.448200,-84.511497,-38.397800>, <0.102846,0.986449,-0.127833>
 <24.337200,-84.475502,-39.050999>, <0.109013,0.986226,-0.124395>
 <25.419001,-84.483101,-38.203701>, <0.102883,0.986383,-0.128311>
}
   smooth_triangle{ <24.313400,-84.448997,-38.863300>, <-0.108708,-0.986196,0.124897>
 <24.337200,-84.475502,-39.050999>, <-0.109013,-0.986226,0.124395>
 <25.419001,-84.483101,-38.203701>, <-0.102883,-0.986383,0.128311>
}
   smooth_triangle{ <24.313400,-84.448997,-38.863300>, <0.108708,0.986196,-0.124897>
 <25.419001,-84.483101,-38.203701>, <0.102883,0.986383,-0.128311>
 <24.337200,-84.475502,-39.050999>, <0.109013,0.986226,-0.124395>
}
   smooth_triangle{ <25.419001,-84.483101,-38.203701>, <-0.102883,-0.986383,0.128311>
 <25.371799,-84.438301,-37.897301>, <-0.102338,-0.986464,0.128121>
 <24.313400,-84.448997,-38.863300>, <-0.108708,-0.986196,0.124897>
}
   smooth_triangle{ <25.419001,-84.483101,-38.203701>, <0.102883,0.986383,-0.128311>
 <24.313400,-84.448997,-38.863300>, <0.108708,0.986196,-0.124897>
 <25.371799,-84.438301,-37.897301>, <0.102338,0.986464,-0.128121>
}
   smooth_triangle{ <24.274599,-84.407097,-38.566101>, <-0.107563,-0.986348,0.124693>
 <24.313400,-84.448997,-38.863300>, <-0.108708,-0.986196,0.124897>
 <25.371799,-84.438301,-37.897301>, <-0.102338,-0.986464,0.128121>
}
   smooth_triangle{ <24.274599,-84.407097,-38.566101>, <0.107563,0.986348,-0.124693>
 <25.371799,-84.438301,-37.897301>, <0.102338,0.986464,-0.128121>
 <24.313400,-84.448997,-38.863300>, <0.108708,0.986196,-0.124897>
}
   smooth_triangle{ <25.371799,-84.438301,-37.897301>, <-0.102338,-0.986464,0.128121>
 <25.308001,-84.378998,-37.492401>, <-0.101558,-0.986571,0.127923>
 <24.274599,-84.407097,-38.566101>, <-0.107563,-0.986348,0.124693>
}
   smooth_triangle{ <25.371799,-84.438301,-37.897301>, <0.102338,0.986464,-0.128121>
 <24.274599,-84.407097,-38.566101>, <0.107563,0.986348,-0.124693>
 <25.308001,-84.378998,-37.492401>, <0.101558,0.986571,-0.127923>
}
   smooth_triangle{ <24.221901,-84.351402,-38.172001>, <-0.105931,-0.986529,0.124655>
 <24.274599,-84.407097,-38.566101>, <-0.107563,-0.986348,0.124693>
 <25.308001,-84.378998,-37.492401>, <-0.101558,-0.986571,0.127923>
}
   smooth_triangle{ <24.221901,-84.351402,-38.172001>, <0.105931,0.986529,-0.124655>
 <25.308001,-84.378998,-37.492401>, <0.101558,0.986571,-0.127923>
 <24.274599,-84.407097,-38.566101>, <0.107563,0.986348,-0.124693>
}
   smooth_triangle{ <26.537001,-84.399597,-36.710499>, <-0.095163,-0.986900,0.130279>
 <26.293600,-84.235802,-35.645500>, <-0.094342,-0.987029,0.129898>
 <25.308001,-84.378998,-37.492401>, <-0.101558,-0.986571,0.127923>
}
   smooth_triangle{ <26.537001,-84.399597,-36.710499>, <0.095163,0.986900,-0.130279>
 <25.308001,-84.378998,-37.492401>, <0.101558,0.986571,-0.127923>
 <26.293600,-84.235802,-35.645500>, <0.094342,0.987029,-0.129898>
}
   smooth_triangle{ <25.135700,-84.225098,-36.442600>, <-0.099807,-0.986805,0.127495>
 <25.308001,-84.378998,-37.492401>, <-0.101558,-0.986571,0.127923>
 <26.293600,-84.235802,-35.645500>, <-0.094342,-0.987029,0.129898>
}
   smooth_triangle{ <25.135700,-84.225098,-36.442600>, <0.099807,0.986805,-0.127495>
 <26.293600,-84.235802,-35.645500>, <0.094342,0.987029,-0.129898>
 <25.308001,-84.378998,-37.492401>, <0.101558,0.986571,-0.127923>
}
   smooth_triangle{ <26.293600,-84.235802,-35.645500>, <-0.094342,-0.987029,0.129898>
 <25.989799,-84.038696,-34.364300>, <-0.092762,-0.987361,0.128509>
 <25.135700,-84.225098,-36.442600>, <-0.099807,-0.986805,0.127495>
}
   smooth_triangle{ <26.293600,-84.235802,-35.645500>, <0.094342,0.987029,-0.129898>
 <25.135700,-84.225098,-36.442600>, <0.099807,0.986805,-0.127495>
 <25.989799,-84.038696,-34.364300>, <0.092762,0.987361,-0.128509>
}
   smooth_triangle{ <24.912600,-84.037804,-35.165600>, <-0.096850,-0.987202,0.126699>
 <25.135700,-84.225098,-36.442600>, <-0.099807,-0.986805,0.127495>
 <25.989799,-84.038696,-34.364300>, <-0.092762,-0.987361,0.128509>
}
   smooth_triangle{ <24.912600,-84.037804,-35.165600>, <0.096850,0.987202,-0.126699>
 <25.989799,-84.038696,-34.364300>, <0.092762,0.987361,-0.128509>
 <25.135700,-84.225098,-36.442600>, <0.099807,0.986805,-0.127495>
}
   smooth_triangle{ <25.308001,-84.378998,-37.492401>, <-0.101558,-0.986571,0.127923>
 <25.135700,-84.225098,-36.442600>, <-0.099807,-0.986805,0.127495>
 <24.221901,-84.351402,-38.172001>, <-0.105931,-0.986529,0.124655>
}
   smooth_triangle{ <25.308001,-84.378998,-37.492401>, <0.101558,0.986571,-0.127923>
 <24.221901,-84.351402,-38.172001>, <0.105931,0.986529,-0.124655>
 <25.135700,-84.225098,-36.442600>, <0.099807,0.986805,-0.127495>
}
   smooth_triangle{ <24.077801,-84.206200,-37.144600>, <-0.102644,-0.986900,0.124467>
 <24.221901,-84.351402,-38.172001>, <-0.105931,-0.986529,0.124655>
 <25.135700,-84.225098,-36.442600>, <-0.099807,-0.986805,0.127495>
}
   smooth_triangle{ <24.077801,-84.206200,-37.144600>, <0.102644,0.986900,-0.124467>
 <25.135700,-84.225098,-36.442600>, <0.099807,0.986805,-0.127495>
 <24.221901,-84.351402,-38.172001>, <0.105931,0.986529,-0.124655>
}
   smooth_triangle{ <25.135700,-84.225098,-36.442600>, <-0.099807,-0.986805,0.127495>
 <24.912600,-84.037804,-35.165600>, <-0.096850,-0.987202,0.126699>
 <24.077801,-84.206200,-37.144600>, <-0.102644,-0.986900,0.124467>
}
   smooth_triangle{ <25.135700,-84.225098,-36.442600>, <0.099807,0.986805,-0.127495>
 <24.077801,-84.206200,-37.144600>, <0.102644,0.986900,-0.124467>
 <24.912600,-84.037804,-35.165600>, <0.096850,0.987202,-0.126699>
}
   smooth_triangle{ <23.888100,-84.027603,-35.883099>, <-0.097968,-0.987414,0.124163>
 <24.077801,-84.206200,-37.144600>, <-0.102644,-0.986900,0.124467>
 <24.912600,-84.037804,-35.165600>, <-0.096850,-0.987202,0.126699>
}
   smooth_triangle{ <23.888100,-84.027603,-35.883099>, <0.097968,0.987414,-0.124163>
 <24.912600,-84.037804,-35.165600>, <0.096850,0.987202,-0.126699>
 <24.077801,-84.206200,-37.144600>, <0.102644,0.986900,-0.124467>
}
   smooth_triangle{ <28.047501,-83.994904,-32.621498>, <-0.080552,-0.987903,0.132513>
 <27.361500,-83.769699,-31.350300>, <-0.081199,-0.988095,0.130668>
 <27.018700,-84.016701,-33.492901>, <-0.088778,-0.987601,0.129471>
}
   smooth_triangle{ <28.047501,-83.994904,-32.621498>, <0.080552,0.987903,-0.132513>
 <27.018700,-84.016701,-33.492901>, <0.088778,0.987601,-0.129471>
 <27.361500,-83.769699,-31.350300>, <0.081199,0.988095,-0.130668>
}
   smooth_triangle{ <26.571100,-83.806099,-32.169201>, <-0.088510,-0.987835,0.127858>
 <27.018700,-84.016701,-33.492901>, <-0.088778,-0.987601,0.129471>
 <27.361500,-83.769699,-31.350300>, <-0.081199,-0.988095,0.130668>
}
   smooth_triangle{ <26.571100,-83.806099,-32.169201>, <0.088510,0.987835,-0.127858>
 <27.361500,-83.769699,-31.350300>, <0.081199,0.988095,-0.130668>
 <27.018700,-84.016701,-33.492901>, <0.088778,0.987601,-0.129471>
}
   smooth_triangle{ <27.018700,-84.016701,-33.492901>, <-0.088778,-0.987601,0.129471>
 <26.571100,-83.806099,-32.169201>, <-0.088510,-0.987835,0.127858>
 <25.989799,-84.038696,-34.364300>, <-0.092762,-0.987361,0.128509>
}
   smooth_triangle{ <27.018700,-84.016701,-33.492901>, <0.088778,0.987601,-0.129471>
 <25.989799,-84.038696,-34.364300>, <0.092762,0.987361,-0.128509>
 <26.571100,-83.806099,-32.169201>, <0.088510,0.987835,-0.127858>
}
   smooth_triangle{ <25.638201,-83.828796,-33.000999>, <-0.090870,-0.987577,0.128200>
 <25.989799,-84.038696,-34.364300>, <-0.092762,-0.987361,0.128509>
 <26.571100,-83.806099,-32.169201>, <-0.088510,-0.987835,0.127858>
}
   smooth_triangle{ <25.638201,-83.828796,-33.000999>, <0.090870,0.987577,-0.128200>
 <26.571100,-83.806099,-32.169201>, <0.088510,0.987835,-0.127858>
 <25.989799,-84.038696,-34.364300>, <0.092762,0.987361,-0.128509>
}
   smooth_triangle{ <27.361500,-83.769699,-31.350300>, <-0.081199,-0.988095,0.130668>
 <26.729401,-83.563698,-30.183001>, <-0.082989,-0.988127,0.129296>
 <26.571100,-83.806099,-32.169201>, <-0.088510,-0.987835,0.127858>
}
   smooth_triangle{ <27.361500,-83.769699,-31.350300>, <0.081199,0.988095,-0.130668>
 <26.571100,-83.806099,-32.169201>, <0.088510,0.987835,-0.127858>
 <26.729401,-83.563698,-30.183001>, <0.082989,0.988127,-0.129296>
}
   smooth_triangle{ <26.106701,-83.598900,-30.893801>, <-0.089719,-0.987844,0.126941>
 <26.571100,-83.806099,-32.169201>, <-0.088510,-0.987835,0.127858>
 <26.729401,-83.563698,-30.183001>, <-0.082989,-0.988127,0.129296>
}
   smooth_triangle{ <26.106701,-83.598900,-30.893801>, <0.089719,0.987844,-0.126941>
 <26.729401,-83.563698,-30.183001>, <0.082989,0.988127,-0.129296>
 <26.571100,-83.806099,-32.169201>, <0.088510,0.987835,-0.127858>
}
   smooth_triangle{ <26.571100,-83.806099,-32.169201>, <-0.088510,-0.987835,0.127858>
 <26.106701,-83.598900,-30.893801>, <-0.089719,-0.987844,0.126941>
 <25.638201,-83.828796,-33.000999>, <-0.090870,-0.987577,0.128200>
}
   smooth_triangle{ <26.571100,-83.806099,-32.169201>, <0.088510,0.987835,-0.127858>
 <25.638201,-83.828796,-33.000999>, <0.090870,0.987577,-0.128200>
 <26.106701,-83.598900,-30.893801>, <0.089719,0.987844,-0.126941>
}
   smooth_triangle{ <25.286501,-83.619003,-31.637600>, <-0.091640,-0.987723,0.126513>
 <25.638201,-83.828796,-33.000999>, <-0.090870,-0.987577,0.128200>
 <26.106701,-83.598900,-30.893801>, <-0.089719,-0.987844,0.126941>
}
   smooth_triangle{ <25.286501,-83.619003,-31.637600>, <0.091640,0.987723,-0.126513>
 <26.106701,-83.598900,-30.893801>, <0.089719,0.987844,-0.126941>
 <25.638201,-83.828796,-33.000999>, <0.090870,0.987577,-0.128200>
}
   smooth_triangle{ <25.989799,-84.038696,-34.364300>, <-0.092762,-0.987361,0.128509>
 <25.286501,-83.619003,-31.637600>, <-0.091640,-0.987723,0.126513>
 <24.912600,-84.037804,-35.165600>, <-0.096850,-0.987202,0.126699>
}
   smooth_triangle{ <25.989799,-84.038696,-34.364300>, <0.092762,0.987361,-0.128509>
 <24.912600,-84.037804,-35.165600>, <0.096850,0.987202,-0.126699>
 <25.286501,-83.619003,-31.637600>, <0.091640,0.987723,-0.126513>
}
   smooth_triangle{ <24.342600,-83.622704,-32.352200>, <-0.093618,-0.987612,0.125932>
 <24.912600,-84.037804,-35.165600>, <-0.096850,-0.987202,0.126699>
 <25.286501,-83.619003,-31.637600>, <-0.091640,-0.987723,0.126513>
}
   smooth_triangle{ <24.342600,-83.622704,-32.352200>, <0.093618,0.987612,-0.125932>
 <25.286501,-83.619003,-31.637600>, <0.091640,0.987723,-0.126513>
 <24.912600,-84.037804,-35.165600>, <0.096850,0.987202,-0.126699>
}
   smooth_triangle{ <24.912600,-84.037804,-35.165600>, <-0.096850,-0.987202,0.126699>
 <24.342600,-83.622704,-32.352200>, <-0.093618,-0.987612,0.125932>
 <23.888100,-84.027603,-35.883099>, <-0.097968,-0.987414,0.124163>
}
   smooth_triangle{ <24.912600,-84.037804,-35.165600>, <0.096850,0.987202,-0.126699>
 <23.888100,-84.027603,-35.883099>, <0.097968,0.987414,-0.124163>
 <24.342600,-83.622704,-32.352200>, <0.093618,0.987612,-0.125932>
}
   smooth_triangle{ <23.398899,-83.626503,-33.066601>, <-0.090806,-0.988143,0.123806>
 <23.888100,-84.027603,-35.883099>, <-0.097968,-0.987414,0.124163>
 <24.342600,-83.622704,-32.352200>, <-0.093618,-0.987612,0.125932>
}
   smooth_triangle{ <23.398899,-83.626503,-33.066601>, <0.090806,0.988143,-0.123806>
 <24.342600,-83.622704,-32.352200>, <0.093618,0.987612,-0.125932>
 <23.888100,-84.027603,-35.883099>, <0.097968,0.987414,-0.124163>
}
   smooth_triangle{ <26.729401,-83.563698,-30.183001>, <-0.082989,-0.988127,0.129296>
 <26.457001,-83.475601,-29.682600>, <-0.083845,-0.988301,0.127402>
 <26.106701,-83.598900,-30.893801>, <-0.089719,-0.987844,0.126941>
}
   smooth_triangle{ <26.729401,-83.563698,-30.183001>, <0.082989,0.988127,-0.129296>
 <26.106701,-83.598900,-30.893801>, <0.089719,0.987844,-0.126941>
 <26.457001,-83.475601,-29.682600>, <0.083845,0.988301,-0.127402>
}
   smooth_triangle{ <25.897200,-83.511002,-30.352800>, <-0.088497,-0.988125,0.125610>
 <26.106701,-83.598900,-30.893801>, <-0.089719,-0.987844,0.126941>
 <26.457001,-83.475601,-29.682600>, <-0.083845,-0.988301,0.127402>
}
   smooth_triangle{ <25.897200,-83.511002,-30.352800>, <0.088497,0.988125,-0.125610>
 <26.457001,-83.475601,-29.682600>, <0.083845,0.988301,-0.127402>
 <26.106701,-83.598900,-30.893801>, <0.089719,0.987844,-0.126941>
}
   smooth_triangle{ <26.457001,-83.475601,-29.682600>, <-0.083845,-0.988301,0.127402>
 <26.226400,-83.402000,-29.260900>, <-0.084879,-0.988458,0.125485>
 <25.897200,-83.511002,-30.352800>, <-0.088497,-0.988125,0.125610>
}
   smooth_triangle{ <26.457001,-83.475601,-29.682600>, <0.083845,0.988301,-0.127402>
 <25.897200,-83.511002,-30.352800>, <0.088497,0.988125,-0.125610>
 <26.226400,-83.402000,-29.260900>, <0.084879,0.988458,-0.125485>
}
   smooth_triangle{ <25.687700,-83.423103,-29.811701>, <-0.088507,-0.988266,0.124485>
 <25.897200,-83.511002,-30.352800>, <-0.088497,-0.988125,0.125610>
 <26.226400,-83.402000,-29.260900>, <-0.084879,-0.988458,0.125485>
}
   smooth_triangle{ <25.687700,-83.423103,-29.811701>, <0.088507,0.988266,-0.124485>
 <26.226400,-83.402000,-29.260900>, <0.084879,0.988458,-0.125485>
 <25.897200,-83.511002,-30.352800>, <0.088497,0.988125,-0.125610>
}
   smooth_triangle{ <26.106701,-83.598900,-30.893801>, <-0.089719,-0.987844,0.126941>
 <25.687700,-83.423103,-29.811701>, <-0.088507,-0.988266,0.124485>
 <25.286501,-83.619003,-31.637600>, <-0.091640,-0.987723,0.126513>
}
   smooth_triangle{ <26.106701,-83.598900,-30.893801>, <0.089719,0.987844,-0.126941>
 <25.286501,-83.619003,-31.637600>, <0.091640,0.987723,-0.126513>
 <25.687700,-83.423103,-29.811701>, <0.088507,0.988266,-0.124485>
}
   smooth_triangle{ <24.929399,-83.433701,-30.434200>, <-0.087880,-0.988437,0.123567>
 <25.286501,-83.619003,-31.637600>, <-0.091640,-0.987723,0.126513>
 <25.687700,-83.423103,-29.811701>, <-0.088507,-0.988266,0.124485>
}
   smooth_triangle{ <24.929399,-83.433701,-30.434200>, <0.087880,0.988437,-0.123567>
 <25.687700,-83.423103,-29.811701>, <0.088507,0.988266,-0.124485>
 <25.286501,-83.619003,-31.637600>, <0.091640,0.987723,-0.126513>
}
   smooth_triangle{ <26.226400,-83.402000,-29.260900>, <-0.084879,-0.988458,0.125485>
 <26.046700,-83.345596,-28.935801>, <-0.084683,-0.988896,0.122119>
 <25.687700,-83.423103,-29.811701>, <-0.088507,-0.988266,0.124485>
}
   smooth_triangle{ <26.226400,-83.402000,-29.260900>, <0.084879,0.988458,-0.125485>
 <25.687700,-83.423103,-29.811701>, <0.088507,0.988266,-0.124485>
 <26.046700,-83.345596,-28.935801>, <0.084683,0.988896,-0.122119>
}
   smooth_triangle{ <25.511101,-83.354797,-29.389200>, <-0.085575,-0.988890,0.121548>
 <25.687700,-83.423103,-29.811701>, <-0.088507,-0.988266,0.124485>
 <26.046700,-83.345596,-28.935801>, <-0.084683,-0.988896,0.122119>
}
   smooth_triangle{ <25.511101,-83.354797,-29.389200>, <0.085575,0.988890,-0.121548>
 <26.046700,-83.345596,-28.935801>, <0.084683,0.988896,-0.122119>
 <25.687700,-83.423103,-29.811701>, <0.088507,0.988266,-0.124485>
}
   smooth_triangle{ <26.046700,-83.345596,-28.935801>, <-0.084683,-0.988896,0.122119>
 <25.927601,-83.309799,-28.724701>, <-0.084171,-0.989171,0.120230>
 <25.511101,-83.354797,-29.389200>, <-0.085575,-0.988890,0.121548>
}
   smooth_triangle{ <26.046700,-83.345596,-28.935801>, <0.084683,0.988896,-0.122119>
 <25.511101,-83.354797,-29.389200>, <0.085575,0.988890,-0.121548>
 <25.927601,-83.309799,-28.724701>, <0.084171,0.989171,-0.120230>
}
   smooth_triangle{ <25.361900,-83.301300,-29.053900>, <-0.085451,-0.988985,0.120861>
 <25.511101,-83.354797,-29.389200>, <-0.085575,-0.988890,0.121548>
 <25.927601,-83.309799,-28.724701>, <-0.084171,-0.989171,0.120230>
}
   smooth_triangle{ <25.361900,-83.301300,-29.053900>, <0.085451,0.988985,-0.120861>
 <25.927601,-83.309799,-28.724701>, <0.084171,0.989171,-0.120230>
 <25.511101,-83.354797,-29.389200>, <0.085575,0.988890,-0.121548>
}
   smooth_triangle{ <25.687700,-83.423103,-29.811701>, <-0.088507,-0.988266,0.124485>
 <25.511101,-83.354797,-29.389200>, <-0.085575,-0.988890,0.121548>
 <24.929399,-83.433701,-30.434200>, <-0.087880,-0.988437,0.123567>
}
   smooth_triangle{ <25.687700,-83.423103,-29.811701>, <0.088507,0.988266,-0.124485>
 <24.929399,-83.433701,-30.434200>, <0.087880,0.988437,-0.123567>
 <25.511101,-83.354797,-29.389200>, <0.085575,0.988890,-0.121548>
}
   smooth_triangle{ <24.763300,-83.361603,-29.966600>, <-0.085153,-0.988935,0.121476>
 <24.929399,-83.433701,-30.434200>, <-0.087880,-0.988437,0.123567>
 <25.511101,-83.354797,-29.389200>, <-0.085575,-0.988890,0.121548>
}
   smooth_triangle{ <24.763300,-83.361603,-29.966600>, <0.085153,0.988935,-0.121476>
 <25.511101,-83.354797,-29.389200>, <0.085575,0.988890,-0.121548>
 <24.929399,-83.433701,-30.434200>, <0.087880,0.988437,-0.123567>
}
   smooth_triangle{ <25.511101,-83.354797,-29.389200>, <-0.085575,-0.988890,0.121548>
 <25.361900,-83.301300,-29.053900>, <-0.085451,-0.988985,0.120861>
 <24.763300,-83.361603,-29.966600>, <-0.085153,-0.988935,0.121476>
}
   smooth_triangle{ <25.511101,-83.354797,-29.389200>, <0.085575,0.988890,-0.121548>
 <24.763300,-83.361603,-29.966600>, <0.085153,0.988935,-0.121476>
 <25.361900,-83.301300,-29.053900>, <0.085451,0.988985,-0.120861>
}
   smooth_triangle{ <24.597200,-83.289497,-29.498800>, <-0.086264,-0.988820,0.121625>
 <24.763300,-83.361603,-29.966600>, <-0.085153,-0.988935,0.121476>
 <25.361900,-83.301300,-29.053900>, <-0.085451,-0.988985,0.120861>
}
   smooth_triangle{ <24.597200,-83.289497,-29.498800>, <0.086264,0.988820,-0.121625>
 <25.361900,-83.301300,-29.053900>, <0.085451,0.988985,-0.120861>
 <24.763300,-83.361603,-29.966600>, <0.085153,0.988935,-0.121476>
}
   smooth_triangle{ <25.286501,-83.619003,-31.637600>, <-0.091640,-0.987723,0.126513>
 <24.929399,-83.433701,-30.434200>, <-0.087880,-0.988437,0.123567>
 <23.398899,-83.626503,-33.066601>, <-0.090806,-0.988143,0.123806>
}
   smooth_triangle{ <25.286501,-83.619003,-31.637600>, <0.091640,0.987723,-0.126513>
 <23.398899,-83.626503,-33.066601>, <0.090806,0.988143,-0.123806>
 <24.929399,-83.433701,-30.434200>, <0.087880,0.988437,-0.123567>
}
   smooth_triangle{ <23.113199,-83.432404,-31.715799>, <-0.087273,-0.988680,0.122048>
 <23.398899,-83.626503,-33.066601>, <-0.090806,-0.988143,0.123806>
 <24.929399,-83.433701,-30.434200>, <-0.087880,-0.988437,0.123567>
}
   smooth_triangle{ <23.113199,-83.432404,-31.715799>, <0.087273,0.988680,-0.122048>
 <24.929399,-83.433701,-30.434200>, <0.087880,0.988437,-0.123567>
 <23.398899,-83.626503,-33.066601>, <0.090806,0.988143,-0.123806>
}
   smooth_triangle{ <24.929399,-83.433701,-30.434200>, <-0.087880,-0.988437,0.123567>
 <24.597200,-83.289497,-29.498800>, <-0.086264,-0.988820,0.121625>
 <23.113199,-83.432404,-31.715799>, <-0.087273,-0.988680,0.122048>
}
   smooth_triangle{ <24.929399,-83.433701,-30.434200>, <0.087880,0.988437,-0.123567>
 <23.113199,-83.432404,-31.715799>, <0.087273,0.988680,-0.122048>
 <24.597200,-83.289497,-29.498800>, <0.086264,0.988820,-0.121625>
}
   smooth_triangle{ <22.809401,-83.261803,-30.539200>, <-0.087200,-0.988624,0.122549>
 <23.113199,-83.432404,-31.715799>, <-0.087273,-0.988680,0.122048>
 <24.597200,-83.289497,-29.498800>, <-0.086264,-0.988820,0.121625>
}
   smooth_triangle{ <22.809401,-83.261803,-30.539200>, <0.087200,0.988624,-0.122549>
 <24.597200,-83.289497,-29.498800>, <0.086264,0.988820,-0.121625>
 <23.113199,-83.432404,-31.715799>, <0.087273,0.988680,-0.122048>
}
   smooth_triangle{ <24.345400,-84.484596,-39.116299>, <-0.108116,-0.986272,0.124815>
 <24.337200,-84.475502,-39.050999>, <-0.109013,-0.986226,0.124395>
 <23.440901,-84.447601,-39.646400>, <-0.113426,-0.986175,0.120804>
}
   smooth_triangle{ <24.345400,-84.484596,-39.116299>, <0.108116,0.986272,-0.124815>
 <23.440901,-84.447601,-39.646400>, <0.113426,0.986175,-0.120804>
 <24.337200,-84.475502,-39.050999>, <0.109013,0.986226,-0.124395>
}
   smooth_triangle{ <23.432501,-84.439003,-39.583500>, <-0.114117,-0.986146,0.120389>
 <23.440901,-84.447601,-39.646400>, <-0.113426,-0.986175,0.120804>
 <24.337200,-84.475502,-39.050999>, <-0.109013,-0.986226,0.124395>
}
   smooth_triangle{ <23.432501,-84.439003,-39.583500>, <0.114117,0.986146,-0.120389>
 <24.337200,-84.475502,-39.050999>, <0.109013,0.986226,-0.124395>
 <23.440901,-84.447601,-39.646400>, <0.113426,0.986175,-0.120804>
}
   smooth_triangle{ <24.337200,-84.475502,-39.050999>, <-0.109013,-0.986226,0.124395>
 <24.313400,-84.448997,-38.863300>, <-0.108708,-0.986196,0.124897>
 <23.432501,-84.439003,-39.583500>, <-0.114117,-0.986146,0.120389>
}
   smooth_triangle{ <24.337200,-84.475502,-39.050999>, <0.109013,0.986226,-0.124395>
 <23.432501,-84.439003,-39.583500>, <0.114117,0.986146,-0.120389>
 <24.313400,-84.448997,-38.863300>, <0.108708,0.986196,-0.124897>
}
   smooth_triangle{ <23.407900,-84.414001,-39.402199>, <-0.112799,-0.986343,0.120013>
 <23.432501,-84.439003,-39.583500>, <-0.114117,-0.986146,0.120389>
 <24.313400,-84.448997,-38.863300>, <-0.108708,-0.986196,0.124897>
}
   smooth_triangle{ <23.407900,-84.414001,-39.402199>, <0.112799,0.986343,-0.120013>
 <24.313400,-84.448997,-38.863300>, <0.108708,0.986196,-0.124897>
 <23.432501,-84.439003,-39.583500>, <0.114117,0.986146,-0.120389>
}
   smooth_triangle{ <24.313400,-84.448997,-38.863300>, <-0.108708,-0.986196,0.124897>
 <24.274599,-84.407097,-38.566101>, <-0.107563,-0.986348,0.124693>
 <23.407900,-84.414001,-39.402199>, <-0.112799,-0.986343,0.120013>
}
   smooth_triangle{ <24.313400,-84.448997,-38.863300>, <0.108708,0.986196,-0.124897>
 <23.407900,-84.414001,-39.402199>, <0.112799,0.986343,-0.120013>
 <24.274599,-84.407097,-38.566101>, <0.107563,0.986348,-0.124693>
}
   smooth_triangle{ <23.368200,-84.374496,-39.114399>, <-0.111203,-0.986509,0.120141>
 <23.407900,-84.414001,-39.402199>, <-0.112799,-0.986343,0.120013>
 <24.274599,-84.407097,-38.566101>, <-0.107563,-0.986348,0.124693>
}
   smooth_triangle{ <23.368200,-84.374496,-39.114399>, <0.111203,0.986509,-0.120141>
 <24.274599,-84.407097,-38.566101>, <0.107563,0.986348,-0.124693>
 <23.407900,-84.414001,-39.402199>, <0.112799,0.986343,-0.120013>
}
   smooth_triangle{ <24.274599,-84.407097,-38.566101>, <-0.107563,-0.986348,0.124693>
 <24.221901,-84.351402,-38.172001>, <-0.105931,-0.986529,0.124655>
 <23.368200,-84.374496,-39.114399>, <-0.111203,-0.986509,0.120141>
}
   smooth_triangle{ <24.274599,-84.407097,-38.566101>, <0.107563,0.986348,-0.124693>
 <23.368200,-84.374496,-39.114399>, <0.111203,0.986509,-0.120141>
 <24.221901,-84.351402,-38.172001>, <0.105931,0.986529,-0.124655>
}
   smooth_triangle{ <23.314600,-84.321800,-38.731701>, <-0.108867,-0.986743,0.120360>
 <23.368200,-84.374496,-39.114399>, <-0.111203,-0.986509,0.120141>
 <24.221901,-84.351402,-38.172001>, <-0.105931,-0.986529,0.124655>
}
   smooth_triangle{ <23.314600,-84.321800,-38.731701>, <0.108867,0.986743,-0.120360>
 <24.221901,-84.351402,-38.172001>, <0.105931,0.986529,-0.124655>
 <23.368200,-84.374496,-39.114399>, <0.111203,0.986509,-0.120141>
}
   smooth_triangle{ <23.440901,-84.447601,-39.646400>, <-0.113426,-0.986175,0.120804>
 <23.432501,-84.439003,-39.583500>, <-0.114117,-0.986146,0.120389>
 <22.767300,-84.415298,-40.042099>, <-0.118462,-0.985985,0.117473>
}
   smooth_triangle{ <23.440901,-84.447601,-39.646400>, <0.113426,0.986175,-0.120804>
 <22.767300,-84.415298,-40.042099>, <0.118462,0.985985,-0.117473>
 <23.432501,-84.439003,-39.583500>, <0.114117,0.986146,-0.120389>
}
   smooth_triangle{ <22.757401,-84.406898,-39.981201>, <-0.117868,-0.986291,0.115491>
 <22.767300,-84.415298,-40.042099>, <-0.118462,-0.985985,0.117473>
 <23.432501,-84.439003,-39.583500>, <-0.114117,-0.986146,0.120389>
}
   smooth_triangle{ <22.757401,-84.406898,-39.981201>, <0.117868,0.986291,-0.115491>
 <23.432501,-84.439003,-39.583500>, <0.114117,0.986146,-0.120389>
 <22.767300,-84.415298,-40.042099>, <0.118462,0.985985,-0.117473>
}
   smooth_triangle{ <23.432501,-84.439003,-39.583500>, <-0.114117,-0.986146,0.120389>
 <23.407900,-84.414001,-39.402199>, <-0.112799,-0.986343,0.120013>
 <22.757401,-84.406898,-39.981201>, <-0.117868,-0.986291,0.115491>
}
   smooth_triangle{ <23.432501,-84.439003,-39.583500>, <0.114117,0.986146,-0.120389>
 <22.757401,-84.406898,-39.981201>, <0.117868,0.986291,-0.115491>
 <23.407900,-84.414001,-39.402199>, <0.112799,0.986343,-0.120013>
}
   smooth_triangle{ <22.728901,-84.383202,-39.805401>, <-0.115920,-0.986615,0.114684>
 <22.757401,-84.406898,-39.981201>, <-0.117868,-0.986291,0.115491>
 <23.407900,-84.414001,-39.402199>, <-0.112799,-0.986343,0.120013>
}
   smooth_triangle{ <22.728901,-84.383202,-39.805401>, <0.115920,0.986615,-0.114684>
 <23.407900,-84.414001,-39.402199>, <0.112799,0.986343,-0.120013>
 <22.757401,-84.406898,-39.981201>, <0.117868,0.986291,-0.115491>
}
   smooth_triangle{ <23.407900,-84.414001,-39.402199>, <-0.112799,-0.986343,0.120013>
 <23.368200,-84.374496,-39.114399>, <-0.111203,-0.986509,0.120141>
 <22.728901,-84.383202,-39.805401>, <-0.115920,-0.986615,0.114684>
}
   smooth_triangle{ <23.407900,-84.414001,-39.402199>, <0.112799,0.986343,-0.120013>
 <22.728901,-84.383202,-39.805401>, <0.115920,0.986615,-0.114684>
 <23.368200,-84.374496,-39.114399>, <0.111203,0.986509,-0.120141>
}
   smooth_triangle{ <22.683300,-84.345299,-39.525902>, <-0.114071,-0.986758,0.115309>
 <22.728901,-84.383202,-39.805401>, <-0.115920,-0.986615,0.114684>
 <23.368200,-84.374496,-39.114399>, <-0.111203,-0.986509,0.120141>
}
   smooth_triangle{ <22.683300,-84.345299,-39.525902>, <0.114071,0.986758,-0.115309>
 <23.368200,-84.374496,-39.114399>, <0.111203,0.986509,-0.120141>
 <22.728901,-84.383202,-39.805401>, <0.115920,0.986615,-0.114684>
}
   smooth_triangle{ <23.368200,-84.374496,-39.114399>, <-0.111203,-0.986509,0.120141>
 <23.314600,-84.321800,-38.731701>, <-0.108867,-0.986743,0.120360>
 <22.683300,-84.345299,-39.525902>, <-0.114071,-0.986758,0.115309>
}
   smooth_triangle{ <23.368200,-84.374496,-39.114399>, <0.111203,0.986509,-0.120141>
 <22.683300,-84.345299,-39.525902>, <0.114071,0.986758,-0.115309>
 <23.314600,-84.321800,-38.731701>, <0.108867,0.986743,-0.120360>
}
   smooth_triangle{ <22.622000,-84.294701,-39.153599>, <-0.111044,-0.987039,0.115859>
 <22.683300,-84.345299,-39.525902>, <-0.114071,-0.986758,0.115309>
 <23.314600,-84.321800,-38.731701>, <-0.108867,-0.986743,0.120360>
}
   smooth_triangle{ <22.622000,-84.294701,-39.153599>, <0.111044,0.987039,-0.115859>
 <23.314600,-84.321800,-38.731701>, <0.108867,0.986743,-0.120360>
 <22.683300,-84.345299,-39.525902>, <0.114071,0.986758,-0.115309>
}
   smooth_triangle{ <22.767300,-84.415298,-40.042099>, <-0.118462,-0.985985,0.117473>
 <22.757401,-84.406898,-39.981201>, <-0.117868,-0.986291,0.115491>
 <22.346701,-84.392303,-40.289501>, <-0.121896,-0.986140,0.112554>
}
   smooth_triangle{ <22.767300,-84.415298,-40.042099>, <0.118462,0.985985,-0.117473>
 <22.346701,-84.392303,-40.289501>, <0.121896,0.986140,-0.112554>
 <22.757401,-84.406898,-39.981201>, <0.117868,0.986291,-0.115491>
}
   smooth_triangle{ <22.335199,-84.384201,-40.230000>, <-0.121055,-0.986475,0.110508>
 <22.346701,-84.392303,-40.289501>, <-0.121896,-0.986140,0.112554>
 <22.757401,-84.406898,-39.981201>, <-0.117868,-0.986291,0.115491>
}
   smooth_triangle{ <22.335199,-84.384201,-40.230000>, <0.121055,0.986475,-0.110508>
 <22.757401,-84.406898,-39.981201>, <0.117868,0.986291,-0.115491>
 <22.346701,-84.392303,-40.289501>, <0.121896,0.986140,-0.112554>
}
   smooth_triangle{ <22.757401,-84.406898,-39.981201>, <-0.117868,-0.986291,0.115491>
 <22.728901,-84.383202,-39.805401>, <-0.115920,-0.986615,0.114684>
 <22.335199,-84.384201,-40.230000>, <-0.121055,-0.986475,0.110508>
}
   smooth_triangle{ <22.757401,-84.406898,-39.981201>, <0.117868,0.986291,-0.115491>
 <22.335199,-84.384201,-40.230000>, <0.121055,0.986475,-0.110508>
 <22.728901,-84.383202,-39.805401>, <0.115920,0.986615,-0.114684>
}
   smooth_triangle{ <22.302299,-84.361099,-40.058300>, <-0.119128,-0.986726,0.110362>
 <22.335199,-84.384201,-40.230000>, <-0.121055,-0.986475,0.110508>
 <22.728901,-84.383202,-39.805401>, <-0.115920,-0.986615,0.114684>
}
   smooth_triangle{ <22.302299,-84.361099,-40.058300>, <0.119128,0.986726,-0.110362>
 <22.728901,-84.383202,-39.805401>, <0.115920,0.986615,-0.114684>
 <22.335199,-84.384201,-40.230000>, <0.121055,0.986475,-0.110508>
}
   smooth_triangle{ <22.346701,-84.392303,-40.289501>, <-0.121896,-0.986140,0.112554>
 <22.335199,-84.384201,-40.230000>, <-0.121055,-0.986475,0.110508>
 <22.201599,-84.383499,-40.375099>, <-0.123885,-0.986259,0.109296>
}
   smooth_triangle{ <22.346701,-84.392303,-40.289501>, <0.121896,0.986140,-0.112554>
 <22.201599,-84.383499,-40.375099>, <0.094567,0.988812,-0.115359>
 <22.335199,-84.384201,-40.230000>, <0.121055,0.986475,-0.110508>
}
   smooth_triangle{ <22.189400,-84.375504,-40.316200>, <-0.122241,-0.986557,0.108454>
 <22.201599,-84.383499,-40.375099>, <-0.123885,-0.986259,0.109296>
 <22.335199,-84.384201,-40.230000>, <-0.121055,-0.986475,0.110508>
}
   smooth_triangle{ <22.189400,-84.375504,-40.316200>, <0.078933,0.989906,-0.117710>
 <22.335199,-84.384201,-40.230000>, <0.121055,0.986475,-0.110508>
 <22.201599,-84.383499,-40.375099>, <0.094567,0.988812,-0.115359>
}
   smooth_triangle{ <22.335199,-84.384201,-40.230000>, <-0.121055,-0.986475,0.110508>
 <22.302299,-84.361099,-40.058300>, <-0.119128,-0.986726,0.110362>
 <22.189400,-84.375504,-40.316200>, <-0.122241,-0.986557,0.108454>
}
   smooth_triangle{ <22.335199,-84.384201,-40.230000>, <0.121055,0.986475,-0.110508>
 <22.189400,-84.375504,-40.316200>, <0.078933,0.989906,-0.117710>
 <22.302299,-84.361099,-40.058300>, <0.119128,0.986726,-0.110362>
}
   smooth_triangle{ <22.154301,-84.352600,-40.145802>, <-0.119453,-0.986891,0.108522>
 <22.189400,-84.375504,-40.316200>, <-0.122241,-0.986557,0.108454>
 <22.302299,-84.361099,-40.058300>, <-0.119128,-0.986726,0.110362>
}
   smooth_triangle{ <22.154301,-84.352600,-40.145802>, <0.077400,0.990085,-0.117222>
 <22.302299,-84.361099,-40.058300>, <0.119128,0.986726,-0.110362>
 <22.189400,-84.375504,-40.316200>, <0.078933,0.989906,-0.117710>
}
   smooth_triangle{ <22.728901,-84.383202,-39.805401>, <-0.115920,-0.986615,0.114684>
 <22.683300,-84.345299,-39.525902>, <-0.114071,-0.986758,0.115309>
 <22.302299,-84.361099,-40.058300>, <-0.119128,-0.986726,0.110362>
}
   smooth_triangle{ <22.728901,-84.383202,-39.805401>, <0.115920,0.986615,-0.114684>
 <22.302299,-84.361099,-40.058300>, <0.119128,0.986726,-0.110362>
 <22.683300,-84.345299,-39.525902>, <0.114071,0.986758,-0.115309>
}
   smooth_triangle{ <22.249901,-84.324303,-39.784801>, <-0.116349,-0.986977,0.111079>
 <22.302299,-84.361099,-40.058300>, <-0.119128,-0.986726,0.110362>
 <22.683300,-84.345299,-39.525902>, <-0.114071,-0.986758,0.115309>
}
   smooth_triangle{ <22.249901,-84.324303,-39.784801>, <0.116349,0.986977,-0.111079>
 <22.683300,-84.345299,-39.525902>, <0.114071,0.986758,-0.115309>
 <22.302299,-84.361099,-40.058300>, <0.119128,0.986726,-0.110362>
}
   smooth_triangle{ <22.683300,-84.345299,-39.525902>, <-0.114071,-0.986758,0.115309>
 <22.622000,-84.294701,-39.153599>, <-0.111044,-0.987039,0.115859>
 <22.249901,-84.324303,-39.784801>, <-0.116349,-0.986977,0.111079>
}
   smooth_triangle{ <22.683300,-84.345299,-39.525902>, <0.114071,0.986758,-0.115309>
 <22.249901,-84.324303,-39.784801>, <0.116349,0.986977,-0.111079>
 <22.622000,-84.294701,-39.153599>, <0.111044,0.987039,-0.115859>
}
   smooth_triangle{ <22.180201,-84.275002,-39.419899>, <-0.112620,-0.987290,0.112141>
 <22.249901,-84.324303,-39.784801>, <-0.116349,-0.986977,0.111079>
 <22.622000,-84.294701,-39.153599>, <-0.111044,-0.987039,0.115859>
}
   smooth_triangle{ <22.180201,-84.275002,-39.419899>, <0.112620,0.987290,-0.112141>
 <22.622000,-84.294701,-39.153599>, <0.111044,0.987039,-0.115859>
 <22.249901,-84.324303,-39.784801>, <0.116349,0.986977,-0.111079>
}
   smooth_triangle{ <22.302299,-84.361099,-40.058300>, <-0.119128,-0.986726,0.110362>
 <22.249901,-84.324303,-39.784801>, <-0.116349,-0.986977,0.111079>
 <22.154301,-84.352600,-40.145802>, <-0.119453,-0.986891,0.108522>
}
   smooth_triangle{ <22.302299,-84.361099,-40.058300>, <0.119128,0.986726,-0.110362>
 <22.154301,-84.352600,-40.145802>, <0.077400,0.990085,-0.117222>
 <22.249901,-84.324303,-39.784801>, <0.116349,0.986977,-0.111079>
}
   smooth_triangle{ <22.098700,-84.316299,-39.874599>, <-0.115921,-0.987185,0.109670>
 <22.154301,-84.352600,-40.145802>, <-0.119453,-0.986891,0.108522>
 <22.249901,-84.324303,-39.784801>, <-0.116349,-0.986977,0.111079>
}
   smooth_triangle{ <22.098700,-84.316299,-39.874599>, <0.075568,0.990146,-0.117900>
 <22.249901,-84.324303,-39.784801>, <0.116349,0.986977,-0.111079>
 <22.154301,-84.352600,-40.145802>, <0.077400,0.990085,-0.117222>
}
   smooth_triangle{ <22.249901,-84.324303,-39.784801>, <-0.116349,-0.986977,0.111079>
 <22.180201,-84.275002,-39.419899>, <-0.112620,-0.987290,0.112141>
 <22.098700,-84.316299,-39.874599>, <-0.115921,-0.987185,0.109670>
}
   smooth_triangle{ <22.249901,-84.324303,-39.784801>, <0.116349,0.986977,-0.111079>
 <22.098700,-84.316299,-39.874599>, <0.075568,0.990146,-0.117900>
 <22.180201,-84.275002,-39.419899>, <0.112620,0.987290,-0.112141>
}
   smooth_triangle{ <22.024799,-84.267502,-39.512501>, <-0.110989,-0.987627,0.110791>
 <22.098700,-84.316299,-39.874599>, <-0.115921,-0.987185,0.109670>
 <22.180201,-84.275002,-39.419899>, <-0.112620,-0.987290,0.112141>
}
   smooth_triangle{ <22.024799,-84.267502,-39.512501>, <0.073243,0.990227,-0.118685>
 <22.180201,-84.275002,-39.419899>, <0.112620,0.987290,-0.112141>
 <22.098700,-84.316299,-39.874599>, <0.075568,0.990146,-0.117900>
}
   smooth_triangle{ <24.221901,-84.351402,-38.172001>, <-0.105931,-0.986529,0.124655>
 <24.077801,-84.206200,-37.144600>, <-0.102644,-0.986900,0.124467>
 <23.314600,-84.321800,-38.731701>, <-0.108867,-0.986743,0.120360>
}
   smooth_triangle{ <24.221901,-84.351402,-38.172001>, <0.105931,0.986529,-0.124655>
 <23.314600,-84.321800,-38.731701>, <0.108867,0.986743,-0.120360>
 <24.077801,-84.206200,-37.144600>, <0.102644,0.986900,-0.124467>
}
   smooth_triangle{ <23.169201,-84.183601,-37.729500>, <-0.104407,-0.987186,0.120679>
 <23.314600,-84.321800,-38.731701>, <-0.108867,-0.986743,0.120360>
 <24.077801,-84.206200,-37.144600>, <-0.102644,-0.986900,0.124467>
}
   smooth_triangle{ <23.169201,-84.183601,-37.729500>, <0.104407,0.987186,-0.120679>
 <24.077801,-84.206200,-37.144600>, <0.102644,0.986900,-0.124467>
 <23.314600,-84.321800,-38.731701>, <0.108867,0.986743,-0.120360>
}
   smooth_triangle{ <23.314600,-84.321800,-38.731701>, <-0.108867,-0.986743,0.120360>
 <23.169201,-84.183601,-37.729500>, <-0.104407,-0.987186,0.120679>
 <22.622000,-84.294701,-39.153599>, <-0.111044,-0.987039,0.115859>
}
   smooth_triangle{ <23.314600,-84.321800,-38.731701>, <0.108867,0.986743,-0.120360>
 <22.622000,-84.294701,-39.153599>, <0.111044,0.987039,-0.115859>
 <23.169201,-84.183601,-37.729500>, <0.104407,0.987186,-0.120679>
}
   smooth_triangle{ <22.459101,-84.161697,-38.174801>, <-0.105431,-0.987552,0.116724>
 <22.622000,-84.294701,-39.153599>, <-0.111044,-0.987039,0.115859>
 <23.169201,-84.183601,-37.729500>, <-0.104407,-0.987186,0.120679>
}
   smooth_triangle{ <22.459101,-84.161697,-38.174801>, <0.105431,0.987552,-0.116724>
 <23.169201,-84.183601,-37.729500>, <0.104407,0.987186,-0.120679>
 <22.622000,-84.294701,-39.153599>, <0.111044,0.987039,-0.115859>
}
   smooth_triangle{ <24.077801,-84.206200,-37.144600>, <-0.102644,-0.986900,0.124467>
 <23.888100,-84.027603,-35.883099>, <-0.097968,-0.987414,0.124163>
 <23.169201,-84.183601,-37.729500>, <-0.104407,-0.987186,0.120679>
}
   smooth_triangle{ <24.077801,-84.206200,-37.144600>, <0.102644,0.986900,-0.124467>
 <23.169201,-84.183601,-37.729500>, <0.104407,0.987186,-0.120679>
 <23.888100,-84.027603,-35.883099>, <0.097968,0.987414,-0.124163>
}
   smooth_triangle{ <22.980200,-84.012100,-36.489498>, <-0.099132,-0.987694,0.120966>
 <23.169201,-84.183601,-37.729500>, <-0.104407,-0.987186,0.120679>
 <23.888100,-84.027603,-35.883099>, <-0.097968,-0.987414,0.124163>
}
   smooth_triangle{ <22.980200,-84.012100,-36.489498>, <0.099132,0.987694,-0.120966>
 <23.888100,-84.027603,-35.883099>, <0.097968,0.987414,-0.124163>
 <23.169201,-84.183601,-37.729500>, <0.104407,0.987186,-0.120679>
}
   smooth_triangle{ <23.169201,-84.183601,-37.729500>, <-0.104407,-0.987186,0.120679>
 <22.980200,-84.012100,-36.489498>, <-0.099132,-0.987694,0.120966>
 <22.459101,-84.161697,-38.174801>, <-0.105431,-0.987552,0.116724>
}
   smooth_triangle{ <23.169201,-84.183601,-37.729500>, <0.104407,0.987186,-0.120679>
 <22.459101,-84.161697,-38.174801>, <0.105431,0.987552,-0.116724>
 <22.980200,-84.012100,-36.489498>, <0.099132,0.987694,-0.120966>
}
   smooth_triangle{ <22.252701,-83.995796,-36.956799>, <-0.099174,-0.988072,0.117804>
 <22.459101,-84.161697,-38.174801>, <-0.105431,-0.987552,0.116724>
 <22.980200,-84.012100,-36.489498>, <-0.099132,-0.987694,0.120966>
}
   smooth_triangle{ <22.252701,-83.995796,-36.956799>, <0.099174,0.988072,-0.117804>
 <22.980200,-84.012100,-36.489498>, <0.099132,0.987694,-0.120966>
 <22.459101,-84.161697,-38.174801>, <0.105431,0.987552,-0.116724>
}
   smooth_triangle{ <22.622000,-84.294701,-39.153599>, <-0.111044,-0.987039,0.115859>
 <22.459101,-84.161697,-38.174801>, <-0.105431,-0.987552,0.116724>
 <22.180201,-84.275002,-39.419899>, <-0.112620,-0.987290,0.112141>
}
   smooth_triangle{ <22.622000,-84.294701,-39.153599>, <0.111044,0.987039,-0.115859>
 <22.180201,-84.275002,-39.419899>, <0.112620,0.987290,-0.112141>
 <22.459101,-84.161697,-38.174801>, <0.105431,0.987552,-0.116724>
}
   smooth_triangle{ <21.996901,-84.145203,-38.458302>, <-0.106299,-0.987817,0.113654>
 <22.180201,-84.275002,-39.419899>, <-0.112620,-0.987290,0.112141>
 <22.459101,-84.161697,-38.174801>, <-0.105431,-0.987552,0.116724>
}
   smooth_triangle{ <21.996901,-84.145203,-38.458302>, <0.106299,0.987817,-0.113654>
 <22.459101,-84.161697,-38.174801>, <0.105431,0.987552,-0.116724>
 <22.180201,-84.275002,-39.419899>, <0.112620,0.987290,-0.112141>
}
   smooth_triangle{ <22.180201,-84.275002,-39.419899>, <-0.112620,-0.987290,0.112141>
 <21.996901,-84.145203,-38.458302>, <-0.106299,-0.987817,0.113654>
 <22.102501,-84.271202,-39.466202>, <-0.111373,-0.987507,0.111476>
}
   smooth_triangle{ <22.180201,-84.275002,-39.419899>, <0.112620,0.987290,-0.112141>
 <22.102501,-84.271202,-39.466202>, <0.111373,0.987507,-0.111476>
 <21.996901,-84.145203,-38.458302>, <0.106299,0.987817,-0.113654>
}
   smooth_triangle{ <21.874100,-84.140404,-38.532501>, <-0.106479,-0.987941,0.112405>
 <22.102501,-84.271202,-39.466202>, <-0.111373,-0.987507,0.111476>
 <21.996901,-84.145203,-38.458302>, <-0.106299,-0.987817,0.113654>
}
   smooth_triangle{ <21.874100,-84.140404,-38.532501>, <0.106479,0.987941,-0.112405>
 <21.996901,-84.145203,-38.458302>, <0.106299,0.987817,-0.113654>
 <22.102501,-84.271202,-39.466202>, <0.111373,0.987507,-0.111476>
}
   smooth_triangle{ <22.102501,-84.271202,-39.466202>, <-0.111373,-0.987507,0.111476>
 <21.874100,-84.140404,-38.532501>, <-0.106479,-0.987941,0.112405>
 <22.024799,-84.267502,-39.512501>, <-0.110989,-0.987627,0.110791>
}
   smooth_triangle{ <22.102501,-84.271202,-39.466202>, <0.111373,0.987507,-0.111476>
 <22.024799,-84.267502,-39.512501>, <0.073243,0.990227,-0.118685>
 <21.874100,-84.140404,-38.532501>, <0.106479,0.987941,-0.112405>
}
   smooth_triangle{ <21.831900,-84.138702,-38.557800>, <-0.104287,-0.988157,0.112559>
 <22.024799,-84.267502,-39.512501>, <-0.110989,-0.987627,0.110791>
 <21.874100,-84.140404,-38.532501>, <-0.106479,-0.987941,0.112405>
}
   smooth_triangle{ <21.831900,-84.138702,-38.557800>, <0.070872,0.990315,-0.119387>
 <21.874100,-84.140404,-38.532501>, <0.106479,0.987941,-0.112405>
 <22.024799,-84.267502,-39.512501>, <0.073243,0.990227,-0.118685>
}
   smooth_triangle{ <22.459101,-84.161697,-38.174801>, <-0.105431,-0.987552,0.116724>
 <22.252701,-83.995796,-36.956799>, <-0.099174,-0.988072,0.117804>
 <21.996901,-84.145203,-38.458302>, <-0.106299,-0.987817,0.113654>
}
   smooth_triangle{ <22.459101,-84.161697,-38.174801>, <0.105431,0.987552,-0.116724>
 <21.996901,-84.145203,-38.458302>, <0.106299,0.987817,-0.113654>
 <22.252701,-83.995796,-36.956799>, <0.099174,0.988072,-0.117804>
}
   smooth_triangle{ <21.769300,-83.982803,-37.257401>, <-0.099173,-0.988358,0.115382>
 <21.996901,-84.145203,-38.458302>, <-0.106299,-0.987817,0.113654>
 <22.252701,-83.995796,-36.956799>, <-0.099174,-0.988072,0.117804>
}
   smooth_triangle{ <21.769300,-83.982803,-37.257401>, <0.099173,0.988358,-0.115382>
 <22.252701,-83.995796,-36.956799>, <0.099174,0.988072,-0.117804>
 <21.996901,-84.145203,-38.458302>, <0.106299,0.987817,-0.113654>
}
   smooth_triangle{ <21.996901,-84.145203,-38.458302>, <-0.106299,-0.987817,0.113654>
 <21.769300,-83.982803,-37.257401>, <-0.099173,-0.988358,0.115382>
 <21.874100,-84.140404,-38.532501>, <-0.106479,-0.987941,0.112405>
}
   smooth_triangle{ <21.996901,-84.145203,-38.458302>, <0.106299,0.987817,-0.113654>
 <21.874100,-84.140404,-38.532501>, <0.106479,0.987941,-0.112405>
 <21.769300,-83.982803,-37.257401>, <0.099173,0.988358,-0.115382>
}
   smooth_triangle{ <21.639099,-83.978996,-37.336700>, <-0.099209,-0.988473,0.114362>
 <21.874100,-84.140404,-38.532501>, <-0.106479,-0.987941,0.112405>
 <21.769300,-83.982803,-37.257401>, <-0.099173,-0.988358,0.115382>
}
   smooth_triangle{ <21.639099,-83.978996,-37.336700>, <0.099209,0.988473,-0.114362>
 <21.769300,-83.982803,-37.257401>, <0.099173,0.988358,-0.115382>
 <21.874100,-84.140404,-38.532501>, <0.106479,0.987941,-0.112405>
}
   smooth_triangle{ <21.874100,-84.140404,-38.532501>, <-0.106479,-0.987941,0.112405>
 <21.639099,-83.978996,-37.336700>, <-0.099209,-0.988473,0.114362>
 <21.831900,-84.138702,-38.557800>, <-0.104287,-0.988157,0.112559>
}
   smooth_triangle{ <21.874100,-84.140404,-38.532501>, <0.106479,0.987941,-0.112405>
 <21.831900,-84.138702,-38.557800>, <0.070872,0.990315,-0.119387>
 <21.639099,-83.978996,-37.336700>, <0.099209,0.988473,-0.114362>
}
   smooth_triangle{ <21.594000,-83.977600,-37.363800>, <-0.096996,-0.988656,0.114678>
 <21.831900,-84.138702,-38.557800>, <-0.104287,-0.988157,0.112559>
 <21.639099,-83.978996,-37.336700>, <-0.099209,-0.988473,0.114362>
}
   smooth_triangle{ <21.594000,-83.977600,-37.363800>, <0.068199,0.990379,-0.120411>
 <21.639099,-83.978996,-37.336700>, <0.099209,0.988473,-0.114362>
 <21.831900,-84.138702,-38.557800>, <0.070872,0.990315,-0.119387>
}
   smooth_triangle{ <23.888100,-84.027603,-35.883099>, <-0.097968,-0.987414,0.124163>
 <23.643499,-83.827003,-34.474899>, <-0.096216,-0.987726,0.123043>
 <22.980200,-84.012100,-36.489498>, <-0.099132,-0.987694,0.120966>
}
   smooth_triangle{ <23.888100,-84.027603,-35.883099>, <0.097968,0.987414,-0.124163>
 <22.980200,-84.012100,-36.489498>, <0.099132,0.987694,-0.120966>
 <23.643499,-83.827003,-34.474899>, <0.096216,0.987726,-0.123043>
}
   smooth_triangle{ <22.749100,-83.819000,-35.099800>, <-0.094382,-0.988093,0.121509>
 <22.980200,-84.012100,-36.489498>, <-0.099132,-0.987694,0.120966>
 <23.643499,-83.827003,-34.474899>, <-0.096216,-0.987726,0.123043>
}
   smooth_triangle{ <22.749100,-83.819000,-35.099800>, <0.094382,0.988093,-0.121509>
 <23.643499,-83.827003,-34.474899>, <0.096216,0.987726,-0.123043>
 <22.980200,-84.012100,-36.489498>, <0.099132,0.987694,-0.120966>
}
   smooth_triangle{ <22.980200,-84.012100,-36.489498>, <-0.099132,-0.987694,0.120966>
 <22.749100,-83.819000,-35.099800>, <-0.094382,-0.988093,0.121509>
 <22.252701,-83.995796,-36.956799>, <-0.099174,-0.988072,0.117804>
}
   smooth_triangle{ <22.980200,-84.012100,-36.489498>, <0.099132,0.987694,-0.120966>
 <22.252701,-83.995796,-36.956799>, <0.099174,0.988072,-0.117804>
 <22.749100,-83.819000,-35.099800>, <0.094382,0.988093,-0.121509>
}
   smooth_triangle{ <22.013100,-83.808296,-35.585800>, <-0.093695,-0.988470,0.118947>
 <22.252701,-83.995796,-36.956799>, <-0.099174,-0.988072,0.117804>
 <22.749100,-83.819000,-35.099800>, <-0.094382,-0.988093,0.121509>
}
   smooth_triangle{ <22.013100,-83.808296,-35.585800>, <0.093695,0.988470,-0.118947>
 <22.749100,-83.819000,-35.099800>, <0.094382,0.988093,-0.121509>
 <22.252701,-83.995796,-36.956799>, <0.099174,0.988072,-0.117804>
}
   smooth_triangle{ <22.252701,-83.995796,-36.956799>, <-0.099174,-0.988072,0.117804>
 <22.013100,-83.808296,-35.585800>, <-0.093695,-0.988470,0.118947>
 <21.769300,-83.982803,-37.257401>, <-0.099173,-0.988358,0.115382>
}
   smooth_triangle{ <22.252701,-83.995796,-36.956799>, <0.099174,0.988072,-0.117804>
 <21.769300,-83.982803,-37.257401>, <0.099173,0.988358,-0.115382>
 <22.013100,-83.808296,-35.585800>, <0.093695,0.988470,-0.118947>
}
   smooth_triangle{ <21.513800,-83.798798,-35.901100>, <-0.093082,-0.988750,0.117088>
 <21.769300,-83.982803,-37.257401>, <-0.099173,-0.988358,0.115382>
 <22.013100,-83.808296,-35.585800>, <-0.093695,-0.988470,0.118947>
}
   smooth_triangle{ <21.513800,-83.798798,-35.901100>, <0.093082,0.988750,-0.117088>
 <22.013100,-83.808296,-35.585800>, <0.093695,0.988470,-0.118947>
 <21.769300,-83.982803,-37.257401>, <0.099173,0.988358,-0.115382>
}
   smooth_triangle{ <21.769300,-83.982803,-37.257401>, <-0.099173,-0.988358,0.115382>
 <21.513800,-83.798798,-35.901100>, <-0.093082,-0.988750,0.117088>
 <21.639099,-83.978996,-37.336700>, <-0.099209,-0.988473,0.114362>
}
   smooth_triangle{ <21.769300,-83.982803,-37.257401>, <0.099173,0.988358,-0.115382>
 <21.639099,-83.978996,-37.336700>, <0.099209,0.988473,-0.114362>
 <21.513800,-83.798798,-35.901100>, <0.093082,0.988750,-0.117088>
}
   smooth_triangle{ <21.377600,-83.795898,-35.984501>, <-0.092965,-0.988850,0.116328>
 <21.639099,-83.978996,-37.336700>, <-0.099209,-0.988473,0.114362>
 <21.513800,-83.798798,-35.901100>, <-0.093082,-0.988750,0.117088>
}
   smooth_triangle{ <21.377600,-83.795898,-35.984501>, <0.092965,0.988850,-0.116328>
 <21.513800,-83.798798,-35.901100>, <0.093082,0.988750,-0.117088>
 <21.639099,-83.978996,-37.336700>, <0.099209,0.988473,-0.114362>
}
   smooth_triangle{ <21.639099,-83.978996,-37.336700>, <-0.099209,-0.988473,0.114362>
 <21.377600,-83.795898,-35.984501>, <-0.092965,-0.988850,0.116328>
 <21.594000,-83.977600,-37.363800>, <-0.096996,-0.988656,0.114678>
}
   smooth_triangle{ <21.639099,-83.978996,-37.336700>, <0.099209,0.988473,-0.114362>
 <21.594000,-83.977600,-37.363800>, <0.068199,0.990379,-0.120411>
 <21.377600,-83.795898,-35.984501>, <0.092965,0.988850,-0.116328>
}
   smooth_triangle{ <21.330000,-83.794800,-36.013199>, <-0.090851,-0.989007,0.116666>
 <21.594000,-83.977600,-37.363800>, <-0.096996,-0.988656,0.114678>
 <21.377600,-83.795898,-35.984501>, <-0.092965,-0.988850,0.116328>
}
   smooth_triangle{ <21.330000,-83.794800,-36.013199>, <0.066163,0.990391,-0.121442>
 <21.377600,-83.795898,-35.984501>, <0.092965,0.988850,-0.116328>
 <21.594000,-83.977600,-37.363800>, <0.068199,0.990379,-0.120411>
}
   smooth_triangle{ <23.643499,-83.827003,-34.474899>, <-0.096216,-0.987726,0.123043>
 <23.398899,-83.626503,-33.066601>, <-0.090806,-0.988143,0.123806>
 <22.749100,-83.819000,-35.099800>, <-0.094382,-0.988093,0.121509>
}
   smooth_triangle{ <23.643499,-83.827003,-34.474899>, <0.096216,0.987726,-0.123043>
 <22.749100,-83.819000,-35.099800>, <0.094382,0.988093,-0.121509>
 <23.398899,-83.626503,-33.066601>, <0.090806,0.988143,-0.123806>
}
   smooth_triangle{ <22.504700,-83.620300,-33.673199>, <-0.089897,-0.988495,0.121643>
 <22.749100,-83.819000,-35.099800>, <-0.094382,-0.988093,0.121509>
 <23.398899,-83.626503,-33.066601>, <-0.090806,-0.988143,0.123806>
}
   smooth_triangle{ <22.504700,-83.620300,-33.673199>, <0.089897,0.988495,-0.121643>
 <23.398899,-83.626503,-33.066601>, <0.090806,0.988143,-0.123806>
 <22.749100,-83.819000,-35.099800>, <0.094382,0.988093,-0.121509>
}
   smooth_triangle{ <22.749100,-83.819000,-35.099800>, <-0.094382,-0.988093,0.121509>
 <22.504700,-83.620300,-33.673199>, <-0.089897,-0.988495,0.121643>
 <22.013100,-83.808296,-35.585800>, <-0.093695,-0.988470,0.118947>
}
   smooth_triangle{ <22.749100,-83.819000,-35.099800>, <0.094382,0.988093,-0.121509>
 <22.013100,-83.808296,-35.585800>, <0.093695,0.988470,-0.118947>
 <22.504700,-83.620300,-33.673199>, <0.089897,0.988495,-0.121643>
}
   smooth_triangle{ <21.758801,-83.612000,-34.155201>, <-0.089134,-0.988786,0.119819>
 <22.013100,-83.808296,-35.585800>, <-0.093695,-0.988470,0.118947>
 <22.504700,-83.620300,-33.673199>, <-0.089897,-0.988495,0.121643>
}
   smooth_triangle{ <21.758801,-83.612000,-34.155201>, <0.089134,0.988786,-0.119819>
 <22.504700,-83.620300,-33.673199>, <0.089897,0.988495,-0.121643>
 <22.013100,-83.808296,-35.585800>, <0.093695,0.988470,-0.118947>
}
   smooth_triangle{ <22.013100,-83.808296,-35.585800>, <-0.093695,-0.988470,0.118947>
 <21.758801,-83.612000,-34.155201>, <-0.089134,-0.988786,0.119819>
 <21.513800,-83.798798,-35.901100>, <-0.093082,-0.988750,0.117088>
}
   smooth_triangle{ <22.013100,-83.808296,-35.585800>, <0.093695,0.988470,-0.118947>
 <21.513800,-83.798798,-35.901100>, <0.093082,0.988750,-0.117088>
 <21.758801,-83.612000,-34.155201>, <0.089134,0.988786,-0.119819>
}
   smooth_triangle{ <21.247999,-83.604599,-34.473301>, <-0.088535,-0.988991,0.118570>
 <21.513800,-83.798798,-35.901100>, <-0.093082,-0.988750,0.117088>
 <21.758801,-83.612000,-34.155201>, <-0.089134,-0.988786,0.119819>
}
   smooth_triangle{ <21.247999,-83.604599,-34.473301>, <0.088535,0.988991,-0.118570>
 <21.758801,-83.612000,-34.155201>, <0.089134,0.988786,-0.119819>
 <21.513800,-83.798798,-35.901100>, <0.093082,0.988750,-0.117088>
}
   smooth_triangle{ <21.513800,-83.798798,-35.901100>, <-0.093082,-0.988750,0.117088>
 <21.247999,-83.604599,-34.473301>, <-0.088535,-0.988991,0.118570>
 <21.377600,-83.795898,-35.984501>, <-0.092965,-0.988850,0.116328>
}
   smooth_triangle{ <21.513800,-83.798798,-35.901100>, <0.093082,0.988750,-0.117088>
 <21.377600,-83.795898,-35.984501>, <0.092965,0.988850,-0.116328>
 <21.247999,-83.604599,-34.473301>, <0.088535,0.988991,-0.118570>
}
   smooth_triangle{ <21.107500,-83.602303,-34.558601>, <-0.088151,-0.989077,0.118140>
 <21.377600,-83.795898,-35.984501>, <-0.092965,-0.988850,0.116328>
 <21.247999,-83.604599,-34.473301>, <-0.088535,-0.988991,0.118570>
}
   smooth_triangle{ <21.107500,-83.602303,-34.558601>, <0.088151,0.989077,-0.118140>
 <21.247999,-83.604599,-34.473301>, <0.088535,0.988991,-0.118570>
 <21.377600,-83.795898,-35.984501>, <0.092965,0.988850,-0.116328>
}
   smooth_triangle{ <21.377600,-83.795898,-35.984501>, <-0.092965,-0.988850,0.116328>
 <21.107500,-83.602303,-34.558601>, <-0.088151,-0.989077,0.118140>
 <21.330000,-83.794800,-36.013199>, <-0.090851,-0.989007,0.116666>
}
   smooth_triangle{ <21.377600,-83.795898,-35.984501>, <0.092965,0.988850,-0.116328>
 <21.330000,-83.794800,-36.013199>, <0.066163,0.990391,-0.121442>
 <21.107500,-83.602303,-34.558601>, <0.088151,0.989077,-0.118140>
}
   smooth_triangle{ <21.058399,-83.601501,-34.588100>, <-0.086340,-0.989187,0.118549>
 <21.330000,-83.794800,-36.013199>, <-0.090851,-0.989007,0.116666>
 <21.107500,-83.602303,-34.558601>, <-0.088151,-0.989077,0.118140>
}
   smooth_triangle{ <21.058399,-83.601501,-34.588100>, <0.064975,0.990341,-0.122488>
 <21.107500,-83.602303,-34.558601>, <0.088151,0.989077,-0.118140>
 <21.330000,-83.794800,-36.013199>, <0.066163,0.990391,-0.121442>
}
   smooth_triangle{ <23.398899,-83.626503,-33.066601>, <-0.090806,-0.988143,0.123806>
 <23.113199,-83.432404,-31.715799>, <-0.087273,-0.988680,0.122048>
 <22.504700,-83.620300,-33.673199>, <-0.089897,-0.988495,0.121643>
}
   smooth_triangle{ <23.398899,-83.626503,-33.066601>, <0.090806,0.988143,-0.123806>
 <22.504700,-83.620300,-33.673199>, <0.089897,0.988495,-0.121643>
 <23.113199,-83.432404,-31.715799>, <0.087273,0.988680,-0.122048>
}
   smooth_triangle{ <22.235001,-83.425499,-32.285301>, <-0.086788,-0.988835,0.121133>
 <22.504700,-83.620300,-33.673199>, <-0.089897,-0.988495,0.121643>
 <23.113199,-83.432404,-31.715799>, <-0.087273,-0.988680,0.122048>
}
   smooth_triangle{ <22.235001,-83.425499,-32.285301>, <0.086788,0.988835,-0.121133>
 <23.113199,-83.432404,-31.715799>, <0.087273,0.988680,-0.122048>
 <22.504700,-83.620300,-33.673199>, <0.089897,0.988495,-0.121643>
}
   smooth_triangle{ <22.504700,-83.620300,-33.673199>, <-0.089897,-0.988495,0.121643>
 <22.235001,-83.425499,-32.285301>, <-0.086788,-0.988835,0.121133>
 <21.758801,-83.612000,-34.155201>, <-0.089134,-0.988786,0.119819>
}
   smooth_triangle{ <22.504700,-83.620300,-33.673199>, <0.089897,0.988495,-0.121643>
 <21.758801,-83.612000,-34.155201>, <0.089134,0.988786,-0.119819>
 <22.235001,-83.425499,-32.285301>, <0.086788,0.988835,-0.121133>
}
   smooth_triangle{ <21.496401,-83.417603,-32.747501>, <-0.086455,-0.988954,0.120396>
 <21.758801,-83.612000,-34.155201>, <-0.089134,-0.988786,0.119819>
 <22.235001,-83.425499,-32.285301>, <-0.086788,-0.988835,0.121133>
}
   smooth_triangle{ <21.496401,-83.417603,-32.747501>, <0.086455,0.988954,-0.120396>
 <22.235001,-83.425499,-32.285301>, <0.086788,0.988835,-0.121133>
 <21.758801,-83.612000,-34.155201>, <0.089134,0.988786,-0.119819>
}
   smooth_triangle{ <23.113199,-83.432404,-31.715799>, <-0.087273,-0.988680,0.122048>
 <22.809401,-83.261803,-30.539200>, <-0.087200,-0.988624,0.122549>
 <22.235001,-83.425499,-32.285301>, <-0.086788,-0.988835,0.121133>
}
   smooth_triangle{ <23.113199,-83.432404,-31.715799>, <0.087273,0.988680,-0.122048>
 <22.235001,-83.425499,-32.285301>, <0.086788,0.988835,-0.121133>
 <22.809401,-83.261803,-30.539200>, <0.087200,0.988624,-0.122549>
}
   smooth_triangle{ <21.955200,-83.248398,-31.036301>, <-0.088075,-0.988409,0.123654>
 <22.235001,-83.425499,-32.285301>, <-0.086788,-0.988835,0.121133>
 <22.809401,-83.261803,-30.539200>, <-0.087200,-0.988624,0.122549>
}
   smooth_triangle{ <21.955200,-83.248398,-31.036301>, <0.088075,0.988409,-0.123654>
 <22.809401,-83.261803,-30.539200>, <0.087200,0.988624,-0.122549>
 <22.235001,-83.425499,-32.285301>, <0.086788,0.988835,-0.121133>
}
   smooth_triangle{ <22.235001,-83.425499,-32.285301>, <-0.086788,-0.988835,0.121133>
 <21.955200,-83.248398,-31.036301>, <-0.088075,-0.988409,0.123654>
 <21.496401,-83.417603,-32.747501>, <-0.086455,-0.988954,0.120396>
}
   smooth_triangle{ <22.235001,-83.425499,-32.285301>, <0.086788,0.988835,-0.121133>
 <21.496401,-83.417603,-32.747501>, <0.086455,0.988954,-0.120396>
 <21.955200,-83.248398,-31.036301>, <0.088075,0.988409,-0.123654>
}
   smooth_triangle{ <21.240400,-83.237198,-31.452299>, <-0.088371,-0.988299,0.124317>
 <21.496401,-83.417603,-32.747501>, <-0.086455,-0.988954,0.120396>
 <21.955200,-83.248398,-31.036301>, <-0.088075,-0.988409,0.123654>
}
   smooth_triangle{ <21.240400,-83.237198,-31.452299>, <0.088371,0.988299,-0.124317>
 <21.955200,-83.248398,-31.036301>, <0.088075,0.988409,-0.123654>
 <21.496401,-83.417603,-32.747501>, <0.086455,0.988954,-0.120396>
}
   smooth_triangle{ <21.758801,-83.612000,-34.155201>, <-0.089134,-0.988786,0.119819>
 <21.496401,-83.417603,-32.747501>, <-0.086455,-0.988954,0.120396>
 <21.247999,-83.604599,-34.473301>, <-0.088535,-0.988991,0.118570>
}
   smooth_triangle{ <21.758801,-83.612000,-34.155201>, <0.089134,0.988786,-0.119819>
 <21.247999,-83.604599,-34.473301>, <0.088535,0.988991,-0.118570>
 <21.496401,-83.417603,-32.747501>, <0.086455,0.988954,-0.120396>
}
   smooth_triangle{ <20.987499,-83.411102,-33.057701>, <-0.086250,-0.989031,0.119908>
 <21.247999,-83.604599,-34.473301>, <-0.088535,-0.988991,0.118570>
 <21.496401,-83.417603,-32.747501>, <-0.086455,-0.988954,0.120396>
}
   smooth_triangle{ <20.987499,-83.411102,-33.057701>, <0.086250,0.989031,-0.119908>
 <21.496401,-83.417603,-32.747501>, <0.086455,0.988954,-0.120396>
 <21.247999,-83.604599,-34.473301>, <0.088535,0.988991,-0.118570>
}
   smooth_triangle{ <21.247999,-83.604599,-34.473301>, <-0.088535,-0.988991,0.118570>
 <20.987499,-83.411102,-33.057701>, <-0.086250,-0.989031,0.119908>
 <21.107500,-83.602303,-34.558601>, <-0.088151,-0.989077,0.118140>
}
   smooth_triangle{ <21.247999,-83.604599,-34.473301>, <0.088535,0.988991,-0.118570>
 <21.107500,-83.602303,-34.558601>, <0.088151,0.989077,-0.118140>
 <20.987499,-83.411102,-33.057701>, <0.086250,0.989031,-0.119908>
}
   smooth_triangle{ <20.847099,-83.409103,-33.141800>, <-0.085830,-0.989079,0.119817>
 <21.107500,-83.602303,-34.558601>, <-0.088151,-0.989077,0.118140>
 <20.987499,-83.411102,-33.057701>, <-0.086250,-0.989031,0.119908>
}
   smooth_triangle{ <20.847099,-83.409103,-33.141800>, <0.085830,0.989079,-0.119817>
 <20.987499,-83.411102,-33.057701>, <0.086250,0.989031,-0.119908>
 <21.107500,-83.602303,-34.558601>, <0.088151,0.989077,-0.118140>
}
   smooth_triangle{ <21.107500,-83.602303,-34.558601>, <-0.088151,-0.989077,0.118140>
 <20.847099,-83.409103,-33.141800>, <-0.085830,-0.989079,0.119817>
 <21.058399,-83.601501,-34.588100>, <-0.086340,-0.989187,0.118549>
}
   smooth_triangle{ <21.107500,-83.602303,-34.558601>, <0.088151,0.989077,-0.118140>
 <21.058399,-83.601501,-34.588100>, <0.064975,0.990341,-0.122488>
 <20.847099,-83.409103,-33.141800>, <0.085830,0.989079,-0.119817>
}
   smooth_triangle{ <20.797800,-83.408401,-33.171001>, <-0.085097,-0.989101,0.120156>
 <21.058399,-83.601501,-34.588100>, <-0.086340,-0.989187,0.118549>
 <20.847099,-83.409103,-33.141800>, <-0.085830,-0.989079,0.119817>
}
   smooth_triangle{ <20.797800,-83.408401,-33.171001>, <0.065344,0.990179,-0.123592>
 <20.847099,-83.409103,-33.141800>, <0.085830,0.989079,-0.119817>
 <21.058399,-83.601501,-34.588100>, <0.064975,0.990341,-0.122488>
}
   smooth_triangle{ <21.496401,-83.417603,-32.747501>, <-0.086455,-0.988954,0.120396>
 <21.240400,-83.237198,-31.452299>, <-0.088371,-0.988299,0.124317>
 <20.987499,-83.411102,-33.057701>, <-0.086250,-0.989031,0.119908>
}
   smooth_triangle{ <21.496401,-83.417603,-32.747501>, <0.086455,0.988954,-0.120396>
 <20.987499,-83.411102,-33.057701>, <0.086250,0.989031,-0.119908>
 <21.240400,-83.237198,-31.452299>, <0.088371,0.988299,-0.124317>
}
   smooth_triangle{ <20.749500,-83.229500,-31.738001>, <-0.090210,-0.988012,0.125279>
 <20.987499,-83.411102,-33.057701>, <-0.086250,-0.989031,0.119908>
 <21.240400,-83.237198,-31.452299>, <-0.088371,-0.988299,0.124317>
}
   smooth_triangle{ <20.749500,-83.229500,-31.738001>, <0.090210,0.988012,-0.125279>
 <21.240400,-83.237198,-31.452299>, <0.088371,0.988299,-0.124317>
 <20.987499,-83.411102,-33.057701>, <0.086250,0.989031,-0.119908>
}
   smooth_triangle{ <20.987499,-83.411102,-33.057701>, <-0.086250,-0.989031,0.119908>
 <20.749500,-83.229500,-31.738001>, <-0.090210,-0.988012,0.125279>
 <20.847099,-83.409103,-33.141800>, <-0.085830,-0.989079,0.119817>
}
   smooth_triangle{ <20.987499,-83.411102,-33.057701>, <0.086250,0.989031,-0.119908>
 <20.847099,-83.409103,-33.141800>, <0.085830,0.989079,-0.119817>
 <20.749500,-83.229500,-31.738001>, <0.090210,0.988012,-0.125279>
}
   smooth_triangle{ <20.614401,-83.227402,-31.816601>, <-0.090630,-0.987911,0.125768>
 <20.847099,-83.409103,-33.141800>, <-0.085830,-0.989079,0.119817>
 <20.749500,-83.229500,-31.738001>, <-0.090210,-0.988012,0.125279>
}
   smooth_triangle{ <20.614401,-83.227402,-31.816601>, <0.090630,0.987911,-0.125768>
 <20.749500,-83.229500,-31.738001>, <0.090210,0.988012,-0.125279>
 <20.847099,-83.409103,-33.141800>, <0.085830,0.989079,-0.119817>
}
   smooth_triangle{ <20.847099,-83.409103,-33.141800>, <-0.085830,-0.989079,0.119817>
 <20.614401,-83.227402,-31.816601>, <-0.090630,-0.987911,0.125768>
 <20.797800,-83.408401,-33.171001>, <-0.085097,-0.989101,0.120156>
}
   smooth_triangle{ <20.847099,-83.409103,-33.141800>, <0.085830,0.989079,-0.119817>
 <20.797800,-83.408401,-33.171001>, <0.065344,0.990179,-0.123592>
 <20.614401,-83.227402,-31.816601>, <0.090630,0.987911,-0.125768>
}
   smooth_triangle{ <20.567101,-83.226700,-31.844200>, <-0.092959,-0.987435,0.127795>
 <20.797800,-83.408401,-33.171001>, <-0.085097,-0.989101,0.120156>
 <20.614401,-83.227402,-31.816601>, <-0.090630,-0.987911,0.125768>
}
   smooth_triangle{ <20.567101,-83.226700,-31.844200>, <0.068568,0.989690,-0.125743>
 <20.614401,-83.227402,-31.816601>, <0.090630,0.987911,-0.125768>
 <20.797800,-83.408401,-33.171001>, <0.065344,0.990179,-0.123592>
}
   smooth_triangle{ <22.201599,-84.383499,-40.375099>, <0.094567,0.988812,-0.115359>
 <22.189400,-84.375504,-40.316200>, <0.078933,0.989906,-0.117710>
 <22.348200,-84.377998,-40.291100>, <0.036461,0.991247,-0.126885>
}
   smooth_triangle{ <22.335699,-84.370003,-40.232201>, <0.036505,0.991374,-0.125878>
 <22.348200,-84.377998,-40.291100>, <0.036461,0.991247,-0.126885>
 <22.189400,-84.375504,-40.316200>, <0.078933,0.989906,-0.117710>
}
   smooth_triangle{ <22.189400,-84.375504,-40.316200>, <0.078933,0.989906,-0.117710>
 <22.154301,-84.352600,-40.145802>, <0.077400,0.990085,-0.117222>
 <22.335699,-84.370003,-40.232201>, <0.036505,0.991374,-0.125878>
}
   smooth_triangle{ <22.299700,-84.347198,-40.062302>, <0.036340,0.991445,-0.125368>
 <22.335699,-84.370003,-40.232201>, <0.036505,0.991374,-0.125878>
 <22.154301,-84.352600,-40.145802>, <0.077400,0.990085,-0.117222>
}
   smooth_triangle{ <22.348200,-84.377998,-40.291100>, <0.036461,0.991247,-0.126885>
 <22.335699,-84.370003,-40.232201>, <0.036505,0.991374,-0.125878>
 <22.776300,-84.363098,-40.045502>, <0.038738,0.991367,-0.125266>
}
   smooth_triangle{ <22.762899,-84.355202,-39.986900>, <0.038998,0.991462,-0.124428>
 <22.776300,-84.363098,-40.045502>, <0.038738,0.991367,-0.125266>
 <22.335699,-84.370003,-40.232201>, <0.036505,0.991374,-0.125878>
}
   smooth_triangle{ <22.335699,-84.370003,-40.232201>, <0.036505,0.991374,-0.125878>
 <22.299700,-84.347198,-40.062302>, <0.036340,0.991445,-0.125368>
 <22.762899,-84.355202,-39.986900>, <0.038998,0.991462,-0.124428>
}
   smooth_triangle{ <22.724199,-84.332397,-39.817402>, <0.039103,0.991498,-0.124104>
 <22.762899,-84.355202,-39.986900>, <0.038998,0.991462,-0.124428>
 <22.299700,-84.347198,-40.062302>, <0.036340,0.991445,-0.125368>
}
   smooth_triangle{ <22.154301,-84.352600,-40.145802>, <0.077400,0.990085,-0.117222>
 <22.098700,-84.316299,-39.874599>, <0.075568,0.990146,-0.117900>
 <22.299700,-84.347198,-40.062302>, <0.036340,0.991445,-0.125368>
}
   smooth_triangle{ <22.242701,-84.310799,-39.791401>, <0.036592,0.991409,-0.125579>
 <22.299700,-84.347198,-40.062302>, <0.036340,0.991445,-0.125368>
 <22.098700,-84.316299,-39.874599>, <0.075568,0.990146,-0.117900>
}
   smooth_triangle{ <22.098700,-84.316299,-39.874599>, <0.075568,0.990146,-0.117900>
 <22.024799,-84.267502,-39.512501>, <0.073243,0.990227,-0.118685>
 <22.242701,-84.310799,-39.791401>, <0.036592,0.991409,-0.125579>
}
   smooth_triangle{ <22.167000,-84.262100,-39.430199>, <0.037656,0.991361,-0.125638>
 <22.242701,-84.310799,-39.791401>, <0.036592,0.991409,-0.125579>
 <22.024799,-84.267502,-39.512501>, <0.073243,0.990227,-0.118685>
}
   smooth_triangle{ <22.299700,-84.347198,-40.062302>, <0.036340,0.991445,-0.125368>
 <22.242701,-84.310799,-39.791401>, <0.036592,0.991409,-0.125579>
 <22.724199,-84.332397,-39.817402>, <0.039103,0.991498,-0.124104>
}
   smooth_triangle{ <22.662800,-84.296303,-39.547699>, <0.039615,0.991474,-0.124137>
 <22.724199,-84.332397,-39.817402>, <0.039103,0.991498,-0.124104>
 <22.242701,-84.310799,-39.791401>, <0.036592,0.991409,-0.125579>
}
   smooth_triangle{ <22.242701,-84.310799,-39.791401>, <0.036592,0.991409,-0.125579>
 <22.167000,-84.262100,-39.430199>, <0.037656,0.991361,-0.125638>
 <22.662800,-84.296303,-39.547699>, <0.039615,0.991474,-0.124137>
}
   smooth_triangle{ <22.581301,-84.247902,-39.187901>, <0.040441,0.991429,-0.124232>
 <22.662800,-84.296303,-39.547699>, <0.039615,0.991474,-0.124137>
 <22.167000,-84.262100,-39.430199>, <0.037656,0.991361,-0.125638>
}
   smooth_triangle{ <22.776300,-84.363098,-40.045502>, <0.038738,0.991367,-0.125266>
 <22.762899,-84.355202,-39.986900>, <0.038998,0.991462,-0.124428>
 <23.468399,-84.341698,-39.648102>, <0.041550,0.991506,-0.123243>
}
   smooth_triangle{ <23.453199,-84.333801,-39.589500>, <0.041939,0.991582,-0.122502>
 <23.468399,-84.341698,-39.648102>, <0.041550,0.991506,-0.123243>
 <22.762899,-84.355202,-39.986900>, <0.038998,0.991462,-0.124428>
}
   smooth_triangle{ <22.762899,-84.355202,-39.986900>, <0.038998,0.991462,-0.124428>
 <22.724199,-84.332397,-39.817402>, <0.039103,0.991498,-0.124104>
 <23.453199,-84.333801,-39.589500>, <0.041939,0.991582,-0.122502>
}
   smooth_triangle{ <23.409800,-84.311096,-39.420502>, <0.042125,0.991580,-0.122456>
 <23.453199,-84.333801,-39.589500>, <0.041939,0.991582,-0.122502>
 <22.724199,-84.332397,-39.817402>, <0.039103,0.991498,-0.124104>
}
   smooth_triangle{ <22.724199,-84.332397,-39.817402>, <0.039103,0.991498,-0.124104>
 <22.662800,-84.296303,-39.547699>, <0.039615,0.991474,-0.124137>
 <23.409800,-84.311096,-39.420502>, <0.042125,0.991580,-0.122456>
}
   smooth_triangle{ <23.340900,-84.274902,-39.151699>, <0.042490,0.991549,-0.122580>
 <23.409800,-84.311096,-39.420502>, <0.042125,0.991580,-0.122456>
 <22.662800,-84.296303,-39.547699>, <0.039615,0.991474,-0.124137>
}
   smooth_triangle{ <22.662800,-84.296303,-39.547699>, <0.039615,0.991474,-0.124137>
 <22.581301,-84.247902,-39.187901>, <0.040441,0.991429,-0.124232>
 <23.340900,-84.274902,-39.151699>, <0.042490,0.991549,-0.122580>
}
   smooth_triangle{ <23.249399,-84.226700,-38.793301>, <0.043137,0.991522,-0.122566>
 <23.340900,-84.274902,-39.151699>, <0.042490,0.991549,-0.122580>
 <22.581301,-84.247902,-39.187901>, <0.040441,0.991429,-0.124232>
}
   smooth_triangle{ <23.468399,-84.341698,-39.648102>, <0.041550,0.991506,-0.123243>
 <23.453199,-84.333801,-39.589500>, <0.041939,0.991582,-0.122502>
 <24.406799,-84.316597,-39.108601>, <0.044462,0.991682,-0.120787>
}
   smooth_triangle{ <24.389299,-84.308701,-39.049900>, <0.045140,0.991674,-0.120599>
 <24.406799,-84.316597,-39.108601>, <0.044462,0.991682,-0.120787>
 <23.453199,-84.333801,-39.589500>, <0.041939,0.991582,-0.122502>
}
   smooth_triangle{ <23.453199,-84.333801,-39.589500>, <0.041939,0.991582,-0.122502>
 <23.409800,-84.311096,-39.420502>, <0.042125,0.991580,-0.122456>
 <24.389299,-84.308701,-39.049900>, <0.045140,0.991674,-0.120599>
}
   smooth_triangle{ <24.338699,-84.285797,-38.880501>, <0.045317,0.991664,-0.120620>
 <24.389299,-84.308701,-39.049900>, <0.045140,0.991674,-0.120599>
 <23.409800,-84.311096,-39.420502>, <0.042125,0.991580,-0.122456>
}
   smooth_triangle{ <23.409800,-84.311096,-39.420502>, <0.042125,0.991580,-0.122456>
 <23.340900,-84.274902,-39.151699>, <0.042490,0.991549,-0.122580>
 <24.338699,-84.285797,-38.880501>, <0.045317,0.991664,-0.120620>
}
   smooth_triangle{ <24.258801,-84.249397,-38.611500>, <0.045613,0.991645,-0.120666>
 <24.338699,-84.285797,-38.880501>, <0.045317,0.991664,-0.120620>
 <23.340900,-84.274902,-39.151699>, <0.042490,0.991549,-0.122580>
}
   smooth_triangle{ <23.340900,-84.274902,-39.151699>, <0.042490,0.991549,-0.122580>
 <23.249399,-84.226700,-38.793301>, <0.043137,0.991522,-0.122566>
 <24.258801,-84.249397,-38.611500>, <0.045613,0.991645,-0.120666>
}
   smooth_triangle{ <24.152901,-84.200996,-38.253502>, <0.046110,0.991606,-0.120798>
 <24.258801,-84.249397,-38.611500>, <0.045613,0.991645,-0.120666>
 <23.249399,-84.226700,-38.793301>, <0.043137,0.991522,-0.122566>
}
   smooth_triangle{ <22.024799,-84.267502,-39.512501>, <0.073243,0.990227,-0.118685>
 <21.831900,-84.138702,-38.557800>, <0.070872,0.990315,-0.119387>
 <22.167000,-84.262100,-39.430199>, <0.037656,0.991361,-0.125638>
}
   smooth_triangle{ <21.969200,-84.133797,-38.477402>, <0.039456,0.991318,-0.125430>
 <22.167000,-84.262100,-39.430199>, <0.037656,0.991361,-0.125638>
 <21.831900,-84.138702,-38.557800>, <0.070872,0.990315,-0.119387>
}
   smooth_triangle{ <22.167000,-84.262100,-39.430199>, <0.037656,0.991361,-0.125638>
 <21.969200,-84.133797,-38.477402>, <0.039456,0.991318,-0.125430>
 <22.581301,-84.247902,-39.187901>, <0.040441,0.991429,-0.124232>
}
   smooth_triangle{ <22.368401,-84.120201,-38.239700>, <0.041905,0.991362,-0.124278>
 <22.581301,-84.247902,-39.187901>, <0.040441,0.991429,-0.124232>
 <21.969200,-84.133797,-38.477402>, <0.039456,0.991318,-0.125430>
}
   smooth_triangle{ <21.831900,-84.138702,-38.557800>, <0.070872,0.990315,-0.119387>
 <21.594000,-83.977600,-37.363800>, <0.068199,0.990379,-0.120411>
 <21.969200,-84.133797,-38.477402>, <0.039456,0.991318,-0.125430>
}
   smooth_triangle{ <21.725100,-83.973000,-37.286201>, <0.041305,0.991230,-0.125527>
 <21.969200,-84.133797,-38.477402>, <0.039456,0.991318,-0.125430>
 <21.594000,-83.977600,-37.363800>, <0.068199,0.990379,-0.120411>
}
   smooth_triangle{ <21.969200,-84.133797,-38.477402>, <0.039456,0.991318,-0.125430>
 <21.725100,-83.973000,-37.286201>, <0.041305,0.991230,-0.125527>
 <22.368401,-84.120201,-38.239700>, <0.041905,0.991362,-0.124278>
}
   smooth_triangle{ <22.105801,-83.960297,-37.055500>, <0.043769,0.991261,-0.124444>
 <22.368401,-84.120201,-38.239700>, <0.041905,0.991362,-0.124278>
 <21.725100,-83.973000,-37.286201>, <0.041305,0.991230,-0.125527>
}
   smooth_triangle{ <22.581301,-84.247902,-39.187901>, <0.040441,0.991429,-0.124232>
 <22.368401,-84.120201,-38.239700>, <0.041905,0.991362,-0.124278>
 <23.249399,-84.226700,-38.793301>, <0.043137,0.991522,-0.122566>
}
   smooth_triangle{ <23.010700,-84.099503,-37.850300>, <0.044426,0.991436,-0.122801>
 <23.249399,-84.226700,-38.793301>, <0.043137,0.991522,-0.122566>
 <22.368401,-84.120201,-38.239700>, <0.041905,0.991362,-0.124278>
}
   smooth_triangle{ <23.249399,-84.226700,-38.793301>, <0.043137,0.991522,-0.122566>
 <23.010700,-84.099503,-37.850300>, <0.044426,0.991436,-0.122801>
 <24.152901,-84.200996,-38.253502>, <0.046110,0.991606,-0.120798>
}
   smooth_triangle{ <23.877100,-84.073402,-37.314098>, <0.047166,0.991515,-0.121137>
 <24.152901,-84.200996,-38.253502>, <0.046110,0.991606,-0.120798>
 <23.010700,-84.099503,-37.850300>, <0.044426,0.991436,-0.122801>
}
   smooth_triangle{ <22.368401,-84.120201,-38.239700>, <0.041905,0.991362,-0.124278>
 <22.105801,-83.960297,-37.055500>, <0.043769,0.991261,-0.124444>
 <23.010700,-84.099503,-37.850300>, <0.044426,0.991436,-0.122801>
}
   smooth_triangle{ <22.716900,-83.940399,-36.675201>, <0.046061,0.991316,-0.123168>
 <23.010700,-84.099503,-37.850300>, <0.044426,0.991436,-0.122801>
 <22.105801,-83.960297,-37.055500>, <0.043769,0.991261,-0.124444>
}
   smooth_triangle{ <23.010700,-84.099503,-37.850300>, <0.044426,0.991436,-0.122801>
 <22.716900,-83.940399,-36.675201>, <0.046061,0.991316,-0.123168>
 <23.877100,-84.073402,-37.314098>, <0.047166,0.991515,-0.121137>
}
   smooth_triangle{ <23.539000,-83.914597,-36.148602>, <0.048601,0.991369,-0.121763>
 <23.877100,-84.073402,-37.314098>, <0.047166,0.991515,-0.121137>
 <22.716900,-83.940399,-36.675201>, <0.046061,0.991316,-0.123168>
}
   smooth_triangle{ <21.594000,-83.977600,-37.363800>, <0.068199,0.990379,-0.120411>
 <21.330000,-83.794800,-36.013199>, <0.066163,0.990391,-0.121442>
 <21.725100,-83.973000,-37.286201>, <0.041305,0.991230,-0.125527>
}
   smooth_triangle{ <21.454100,-83.790604,-35.938702>, <0.043403,0.991124,-0.125659>
 <21.725100,-83.973000,-37.286201>, <0.041305,0.991230,-0.125527>
 <21.330000,-83.794800,-36.013199>, <0.066163,0.990391,-0.121442>
}
   smooth_triangle{ <21.725100,-83.973000,-37.286201>, <0.041305,0.991230,-0.125527>
 <21.454100,-83.790604,-35.938702>, <0.043403,0.991124,-0.125659>
 <22.105801,-83.960297,-37.055500>, <0.043769,0.991261,-0.124444>
}
   smooth_triangle{ <21.813801,-83.778503,-35.714802>, <0.045617,0.991139,-0.124752>
 <22.105801,-83.960297,-37.055500>, <0.043769,0.991261,-0.124444>
 <21.454100,-83.790604,-35.938702>, <0.043403,0.991124,-0.125659>
}
   smooth_triangle{ <22.105801,-83.960297,-37.055500>, <0.043769,0.991261,-0.124444>
 <21.813801,-83.778503,-35.714802>, <0.045617,0.991139,-0.124752>
 <22.716900,-83.940399,-36.675201>, <0.046061,0.991316,-0.123168>
}
   smooth_triangle{ <22.389700,-83.758598,-35.340900>, <0.047684,0.991181,-0.123636>
 <22.716900,-83.940399,-36.675201>, <0.046061,0.991316,-0.123168>
 <21.813801,-83.778503,-35.714802>, <0.045617,0.991139,-0.124752>
}
   smooth_triangle{ <22.716900,-83.940399,-36.675201>, <0.046061,0.991316,-0.123168>
 <22.389700,-83.758598,-35.340900>, <0.047684,0.991181,-0.123636>
 <23.539000,-83.914597,-36.148602>, <0.048601,0.991369,-0.121763>
}
   smooth_triangle{ <23.162500,-83.731400,-34.816799>, <0.049007,0.991215,-0.122848>
 <23.539000,-83.914597,-36.148602>, <0.048601,0.991369,-0.121763>
 <22.389700,-83.758598,-35.340900>, <0.047684,0.991181,-0.123636>
}
   smooth_triangle{ <21.330000,-83.794800,-36.013199>, <0.066163,0.990391,-0.121442>
 <21.058399,-83.601501,-34.588100>, <0.064975,0.990341,-0.122488>
 <21.454100,-83.790604,-35.938702>, <0.043403,0.991124,-0.125659>
}
   smooth_triangle{ <21.175301,-83.597801,-34.518200>, <0.045435,0.990988,-0.126011>
 <21.454100,-83.790604,-35.938702>, <0.043403,0.991124,-0.125659>
 <21.058399,-83.601501,-34.588100>, <0.064975,0.990341,-0.122488>
}
   smooth_triangle{ <21.454100,-83.790604,-35.938702>, <0.043403,0.991124,-0.125659>
 <21.175301,-83.597801,-34.518200>, <0.045435,0.990988,-0.126011>
 <21.813801,-83.778503,-35.714802>, <0.045617,0.991139,-0.124752>
}
   smooth_triangle{ <21.514200,-83.587402,-34.309898>, <0.047600,0.990990,-0.125194>
 <21.813801,-83.778503,-35.714802>, <0.045617,0.991139,-0.124752>
 <21.175301,-83.597801,-34.518200>, <0.045435,0.990988,-0.126011>
}
   smooth_triangle{ <21.813801,-83.778503,-35.714802>, <0.045617,0.991139,-0.124752>
 <21.514200,-83.587402,-34.309898>, <0.047600,0.990990,-0.125194>
 <22.389700,-83.758598,-35.340900>, <0.047684,0.991181,-0.123636>
}
   smooth_triangle{ <22.057100,-83.570702,-33.964802>, <0.049592,0.991021,-0.124170>
 <22.389700,-83.758598,-35.340900>, <0.047684,0.991181,-0.123636>
 <21.514200,-83.587402,-34.309898>, <0.047600,0.990990,-0.125194>
}
   smooth_triangle{ <22.389700,-83.758598,-35.340900>, <0.047684,0.991181,-0.123636>
 <22.057100,-83.570702,-33.964802>, <0.049592,0.991021,-0.124170>
 <23.162500,-83.731400,-34.816799>, <0.049007,0.991215,-0.122848>
}
   smooth_triangle{ <22.786200,-83.548103,-33.484798>, <0.051615,0.991072,-0.122932>
 <23.162500,-83.731400,-34.816799>, <0.049007,0.991215,-0.122848>
 <22.057100,-83.570702,-33.964802>, <0.049592,0.991021,-0.124170>
}
   smooth_triangle{ <21.058399,-83.601501,-34.588100>, <0.064975,0.990341,-0.122488>
 <20.797800,-83.408401,-33.171001>, <0.065344,0.990179,-0.123592>
 <21.175301,-83.597801,-34.518200>, <0.045435,0.990988,-0.126011>
}
   smooth_triangle{ <20.907499,-83.405197,-33.106201>, <0.047030,0.990808,-0.126838>
 <21.175301,-83.597801,-34.518200>, <0.045435,0.990988,-0.126011>
 <20.797800,-83.408401,-33.171001>, <0.065344,0.990179,-0.123592>
}
   smooth_triangle{ <21.175301,-83.597801,-34.518200>, <0.045435,0.990988,-0.126011>
 <20.907499,-83.405197,-33.106201>, <0.047030,0.990808,-0.126838>
 <21.514200,-83.587402,-34.309898>, <0.047600,0.990990,-0.125194>
}
   smooth_triangle{ <21.226200,-83.396103,-32.913700>, <0.049111,0.990767,-0.126368>
 <21.514200,-83.587402,-34.309898>, <0.047600,0.990990,-0.125194>
 <20.907499,-83.405197,-33.106201>, <0.047030,0.990808,-0.126838>
}
   smooth_triangle{ <21.514200,-83.587402,-34.309898>, <0.047600,0.990990,-0.125194>
 <21.226200,-83.396103,-32.913700>, <0.049111,0.990767,-0.126368>
 <22.057100,-83.570702,-33.964802>, <0.049592,0.991021,-0.124170>
}
   smooth_triangle{ <21.737801,-83.381897,-32.597000>, <0.051509,0.990734,-0.125671>
 <22.057100,-83.570702,-33.964802>, <0.049592,0.991021,-0.124170>
 <21.226200,-83.396103,-32.913700>, <0.049111,0.990767,-0.126368>
}
   smooth_triangle{ <22.057100,-83.570702,-33.964802>, <0.049592,0.991021,-0.124170>
 <21.737801,-83.381897,-32.597000>, <0.051509,0.990734,-0.125671>
 <22.786200,-83.548103,-33.484798>, <0.051615,0.991072,-0.122932>
}
   smooth_triangle{ <22.426800,-83.363297,-32.159100>, <0.053864,0.990715,-0.124833>
 <22.786200,-83.548103,-33.484798>, <0.051615,0.991072,-0.122932>
 <21.737801,-83.381897,-32.597000>, <0.051509,0.990734,-0.125671>
}
   smooth_triangle{ <20.797800,-83.408401,-33.171001>, <0.065344,0.990179,-0.123592>
 <20.567101,-83.226700,-31.844200>, <0.068568,0.989690,-0.125743>
 <20.907499,-83.405197,-33.106201>, <0.047030,0.990808,-0.126838>
}
   smooth_triangle{ <20.670000,-83.223900,-31.785000>, <0.042653,0.991685,-0.121411>
 <20.907499,-83.405197,-33.106201>, <0.047030,0.990808,-0.126838>
 <20.567101,-83.226700,-31.844200>, <0.068568,0.989690,-0.125743>
}
   smooth_triangle{ <20.907499,-83.405197,-33.106201>, <0.047030,0.990808,-0.126838>
 <20.670000,-83.223900,-31.785000>, <0.042653,0.991685,-0.121411>
 <21.226200,-83.396103,-32.913700>, <0.049111,0.990767,-0.126368>
}
   smooth_triangle{ <20.970699,-83.216202,-31.612000>, <0.046035,0.991453,-0.122075>
 <21.226200,-83.396103,-32.913700>, <0.049111,0.990767,-0.126368>
 <20.670000,-83.223900,-31.785000>, <0.042653,0.991685,-0.121411>
}
   smooth_triangle{ <21.226200,-83.396103,-32.913700>, <0.049111,0.990767,-0.126368>
 <20.970699,-83.216202,-31.612000>, <0.046035,0.991453,-0.122075>
 <21.737801,-83.381897,-32.597000>, <0.051509,0.990734,-0.125671>
}
   smooth_triangle{ <21.456600,-83.205399,-31.332300>, <0.049575,0.991214,-0.122629>
 <21.737801,-83.381897,-32.597000>, <0.051509,0.990734,-0.125671>
 <20.970699,-83.216202,-31.612000>, <0.046035,0.991453,-0.122075>
}
   smooth_triangle{ <21.737801,-83.381897,-32.597000>, <0.051509,0.990734,-0.125671>
 <21.456600,-83.205399,-31.332300>, <0.049575,0.991214,-0.122629>
 <22.426800,-83.363297,-32.159100>, <0.053864,0.990715,-0.124833>
}
   smooth_triangle{ <22.115801,-83.192497,-30.952600>, <0.052704,0.991001,-0.123043>
 <22.426800,-83.363297,-32.159100>, <0.053864,0.990715,-0.124833>
 <21.456600,-83.205399,-31.332300>, <0.049575,0.991214,-0.122629>
}
   smooth_triangle{ <24.406799,-84.316597,-39.108601>, <0.044462,0.991682,-0.120787>
 <24.389299,-84.308701,-39.049900>, <0.045140,0.991674,-0.120599>
 <25.573999,-84.290604,-38.436798>, <0.048299,0.991648,-0.119591>
}
   smooth_triangle{ <25.553101,-84.282402,-38.377399>, <0.048683,0.991724,-0.118800>
 <25.573999,-84.290604,-38.436798>, <0.048299,0.991648,-0.119591>
 <24.389299,-84.308701,-39.049900>, <0.045140,0.991674,-0.120599>
}
   smooth_triangle{ <24.389299,-84.308701,-39.049900>, <0.045140,0.991674,-0.120599>
 <24.338699,-84.285797,-38.880501>, <0.045317,0.991664,-0.120620>
 <25.553101,-84.282402,-38.377399>, <0.048683,0.991724,-0.118800>
}
   smooth_triangle{ <25.493200,-84.259102,-38.206600>, <0.048700,0.991746,-0.118611>
 <25.553101,-84.282402,-38.377399>, <0.048683,0.991724,-0.118800>
 <24.338699,-84.285797,-38.880501>, <0.045317,0.991664,-0.120620>
}
   smooth_triangle{ <24.338699,-84.285797,-38.880501>, <0.045317,0.991664,-0.120620>
 <24.258801,-84.249397,-38.611500>, <0.045613,0.991645,-0.120666>
 <25.493200,-84.259102,-38.206600>, <0.048700,0.991746,-0.118611>
}
   smooth_triangle{ <25.398600,-84.222000,-37.935902>, <0.048966,0.991703,-0.118856>
 <25.493200,-84.259102,-38.206600>, <0.048700,0.991746,-0.118611>
 <24.258801,-84.249397,-38.611500>, <0.045613,0.991645,-0.120666>
}
   smooth_triangle{ <24.258801,-84.249397,-38.611500>, <0.045613,0.991645,-0.120666>
 <24.152901,-84.200996,-38.253502>, <0.046110,0.991606,-0.120798>
 <25.398600,-84.222000,-37.935902>, <0.048966,0.991703,-0.118856>
}
   smooth_triangle{ <25.273500,-84.172798,-37.576401>, <0.049305,0.991671,-0.118986>
 <25.398600,-84.222000,-37.935902>, <0.048966,0.991703,-0.118856>
 <24.152901,-84.200996,-38.253502>, <0.046110,0.991606,-0.120798>
}
   smooth_triangle{ <25.573999,-84.290604,-38.436798>, <0.048299,0.991648,-0.119591>
 <25.553101,-84.282402,-38.377399>, <0.048683,0.991724,-0.118800>
 <26.952200,-84.266296,-37.642300>, <0.051726,0.991785,-0.116992>
}
   smooth_triangle{ <26.927200,-84.257896,-37.581699>, <0.052266,0.991827,-0.116395>
 <26.952200,-84.266296,-37.642300>, <0.051726,0.991785,-0.116992>
 <25.553101,-84.282402,-38.377399>, <0.048683,0.991724,-0.118800>
}
   smooth_triangle{ <25.553101,-84.282402,-38.377399>, <0.048683,0.991724,-0.118800>
 <25.493200,-84.259102,-38.206600>, <0.048700,0.991746,-0.118611>
 <26.927200,-84.257896,-37.581699>, <0.052266,0.991827,-0.116395>
}
   smooth_triangle{ <26.855400,-84.233704,-37.407799>, <0.052557,0.991752,-0.116897>
 <26.927200,-84.257896,-37.581699>, <0.052266,0.991827,-0.116395>
 <25.493200,-84.259102,-38.206600>, <0.048700,0.991746,-0.118611>
}
   smooth_triangle{ <25.493200,-84.259102,-38.206600>, <0.048700,0.991746,-0.118611>
 <25.398600,-84.222000,-37.935902>, <0.048966,0.991703,-0.118856>
 <26.855400,-84.233704,-37.407799>, <0.052557,0.991752,-0.116897>
}
   smooth_triangle{ <26.742201,-84.195198,-37.132900>, <0.052683,0.991728,-0.117044>
 <26.855400,-84.233704,-37.407799>, <0.052557,0.991752,-0.116897>
 <25.398600,-84.222000,-37.935902>, <0.048966,0.991703,-0.118856>
}
   smooth_triangle{ <25.398600,-84.222000,-37.935902>, <0.048966,0.991703,-0.118856>
 <25.273500,-84.172798,-37.576401>, <0.049305,0.991671,-0.118986>
 <26.742201,-84.195198,-37.132900>, <0.052683,0.991728,-0.117044>
}
   smooth_triangle{ <26.592800,-84.144402,-36.769100>, <0.052878,0.991700,-0.117199>
 <26.742201,-84.195198,-37.132900>, <0.052683,0.991728,-0.117044>
 <25.273500,-84.172798,-37.576401>, <0.049305,0.991671,-0.118986>
}
   smooth_triangle{ <24.152901,-84.200996,-38.253502>, <0.046110,0.991606,-0.120798>
 <23.877100,-84.073402,-37.314098>, <0.047166,0.991515,-0.121137>
 <25.273500,-84.172798,-37.576401>, <0.049305,0.991671,-0.118986>
}
   smooth_triangle{ <24.948900,-84.043701,-36.637100>, <0.050101,0.991581,-0.119403>
 <25.273500,-84.172798,-37.576401>, <0.049305,0.991671,-0.118986>
 <23.877100,-84.073402,-37.314098>, <0.047166,0.991515,-0.121137>
}
   smooth_triangle{ <23.877100,-84.073402,-37.314098>, <0.047166,0.991515,-0.121137>
 <23.539000,-83.914597,-36.148602>, <0.048601,0.991369,-0.121763>
 <24.948900,-84.043701,-36.637100>, <0.050101,0.991581,-0.119403>
}
   smooth_triangle{ <24.552999,-83.883904,-35.479401>, <0.051523,0.991419,-0.120143>
 <24.948900,-84.043701,-36.637100>, <0.050101,0.991581,-0.119403>
 <23.539000,-83.914597,-36.148602>, <0.048601,0.991369,-0.121763>
}
   smooth_triangle{ <25.273500,-84.172798,-37.576401>, <0.049305,0.991671,-0.118986>
 <24.948900,-84.043701,-36.637100>, <0.050101,0.991581,-0.119403>
 <26.592800,-84.144402,-36.769100>, <0.052878,0.991700,-0.117199>
}
   smooth_triangle{ <26.206900,-84.011902,-35.824100>, <0.053383,0.991617,-0.117668>
 <26.592800,-84.144402,-36.769100>, <0.052878,0.991700,-0.117199>
 <24.948900,-84.043701,-36.637100>, <0.050101,0.991581,-0.119403>
}
   smooth_triangle{ <24.948900,-84.043701,-36.637100>, <0.050101,0.991581,-0.119403>
 <24.552999,-83.883904,-35.479401>, <0.051523,0.991419,-0.120143>
 <26.206900,-84.011902,-35.824100>, <0.053383,0.991617,-0.117668>
}
   smooth_triangle{ <25.739799,-83.849602,-34.670300>, <0.054415,0.991461,-0.118508>
 <26.206900,-84.011902,-35.824100>, <0.053383,0.991617,-0.117668>
 <24.552999,-83.883904,-35.479401>, <0.051523,0.991419,-0.120143>
}
   smooth_triangle{ <26.952200,-84.266296,-37.642300>, <0.051726,0.991785,-0.116992>
 <26.927200,-84.257896,-37.581699>, <0.052266,0.991827,-0.116395>
 <28.524099,-84.246696,-36.734901>, <0.055827,0.991798,-0.114976>
}
   smooth_triangle{ <28.493799,-84.237701,-36.672199>, <0.056662,0.991764,-0.114866>
 <28.524099,-84.246696,-36.734901>, <0.055827,0.991798,-0.114976>
 <26.927200,-84.257896,-37.581699>, <0.052266,0.991827,-0.116395>
}
   smooth_triangle{ <26.927200,-84.257896,-37.581699>, <0.052266,0.991827,-0.116395>
 <26.855400,-84.233704,-37.407799>, <0.052557,0.991752,-0.116897>
 <28.493799,-84.237701,-36.672199>, <0.056662,0.991764,-0.114866>
}
   smooth_triangle{ <28.407400,-84.211998,-36.493099>, <0.056796,0.991722,-0.115161>
 <28.493799,-84.237701,-36.672199>, <0.056662,0.991764,-0.114866>
 <26.855400,-84.233704,-37.407799>, <0.052557,0.991752,-0.116897>
}
   smooth_triangle{ <26.855400,-84.233704,-37.407799>, <0.052557,0.991752,-0.116897>
 <26.742201,-84.195198,-37.132900>, <0.052683,0.991728,-0.117044>
 <28.407400,-84.211998,-36.493099>, <0.056796,0.991722,-0.115161>
}
   smooth_triangle{ <28.271400,-84.171501,-36.211102>, <0.056779,0.991715,-0.115225>
 <28.407400,-84.211998,-36.493099>, <0.056796,0.991722,-0.115161>
 <26.742201,-84.195198,-37.132900>, <0.052683,0.991728,-0.117044>
}
   smooth_triangle{ <26.742201,-84.195198,-37.132900>, <0.052683,0.991728,-0.117044>
 <26.592800,-84.144402,-36.769100>, <0.052878,0.991700,-0.117199>
 <28.271400,-84.171501,-36.211102>, <0.056779,0.991715,-0.115225>
}
   smooth_triangle{ <28.092501,-84.118103,-35.839298>, <0.056855,0.991679,-0.115496>
 <28.271400,-84.171501,-36.211102>, <0.056779,0.991715,-0.115225>
 <26.592800,-84.144402,-36.769100>, <0.052878,0.991700,-0.117199>
}
   smooth_triangle{ <26.592800,-84.144402,-36.769100>, <0.052878,0.991700,-0.117199>
 <26.206900,-84.011902,-35.824100>, <0.053383,0.991617,-0.117668>
 <28.092501,-84.118103,-35.839298>, <0.056855,0.991679,-0.115496>
}
   smooth_triangle{ <27.632401,-83.979897,-34.880901>, <0.057048,0.991607,-0.116019>
 <28.092501,-84.118103,-35.839298>, <0.056855,0.991679,-0.115496>
 <26.206900,-84.011902,-35.824100>, <0.053383,0.991617,-0.117668>
}
   smooth_triangle{ <26.206900,-84.011902,-35.824100>, <0.053383,0.991617,-0.117668>
 <25.739799,-83.849602,-34.670300>, <0.054415,0.991461,-0.118508>
 <27.632401,-83.979897,-34.880901>, <0.057048,0.991607,-0.116019>
}
   smooth_triangle{ <27.080099,-83.812698,-33.725399>, <0.057646,0.991469,-0.116899>
 <27.632401,-83.979897,-34.880901>, <0.057048,0.991607,-0.116019>
 <25.739799,-83.849602,-34.670300>, <0.054415,0.991461,-0.118508>
}
   smooth_triangle{ <28.524099,-84.246696,-36.734901>, <0.055827,0.991798,-0.114976>
 <28.493799,-84.237701,-36.672199>, <0.056662,0.991764,-0.114866>
 <30.271900,-84.234398,-35.724201>, <0.060374,0.991752,-0.113062>
}
   smooth_triangle{ <30.235500,-84.224701,-35.658600>, <0.061251,0.991717,-0.112899>
 <30.271900,-84.234398,-35.724201>, <0.060374,0.991752,-0.113062>
 <28.493799,-84.237701,-36.672199>, <0.056662,0.991764,-0.114866>
}
   smooth_triangle{ <28.493799,-84.237701,-36.672199>, <0.056662,0.991764,-0.114866>
 <28.407400,-84.211998,-36.493099>, <0.056796,0.991722,-0.115161>
 <30.235500,-84.224701,-35.658600>, <0.061251,0.991717,-0.112899>
}
   smooth_triangle{ <30.131500,-84.196899,-35.471600>, <0.061427,0.991659,-0.113306>
 <30.235500,-84.224701,-35.658600>, <0.061251,0.991717,-0.112899>
 <28.407400,-84.211998,-36.493099>, <0.056796,0.991722,-0.115161>
}
   smooth_triangle{ <28.407400,-84.211998,-36.493099>, <0.056796,0.991722,-0.115161>
 <28.271400,-84.171501,-36.211102>, <0.056779,0.991715,-0.115225>
 <30.131500,-84.196899,-35.471600>, <0.061427,0.991659,-0.113306>
}
   smooth_triangle{ <29.968300,-84.153198,-35.178501>, <0.061395,0.991652,-0.113388>
 <30.131500,-84.196899,-35.471600>, <0.061427,0.991659,-0.113306>
 <28.271400,-84.171501,-36.211102>, <0.056779,0.991715,-0.115225>
}
   smooth_triangle{ <28.271400,-84.171501,-36.211102>, <0.056779,0.991715,-0.115225>
 <28.092501,-84.118103,-35.839298>, <0.056855,0.991679,-0.115496>
 <29.968300,-84.153198,-35.178501>, <0.061395,0.991652,-0.113388>
}
   smooth_triangle{ <29.754200,-84.096001,-34.794102>, <0.061396,0.991627,-0.113607>
 <29.968300,-84.153198,-35.178501>, <0.061395,0.991652,-0.113388>
 <28.092501,-84.118103,-35.839298>, <0.056855,0.991679,-0.115496>
}
   smooth_triangle{ <28.092501,-84.118103,-35.839298>, <0.056855,0.991679,-0.115496>
 <27.632401,-83.979897,-34.880901>, <0.057048,0.991607,-0.116019>
 <29.754200,-84.096001,-34.794102>, <0.061396,0.991627,-0.113607>
}
   smooth_triangle{ <29.206499,-83.949303,-33.812500>, <0.061475,0.991573,-0.114038>
 <29.754200,-84.096001,-34.794102>, <0.061396,0.991627,-0.113607>
 <27.632401,-83.979897,-34.880901>, <0.057048,0.991607,-0.116019>
}
   smooth_triangle{ <27.632401,-83.979897,-34.880901>, <0.057048,0.991607,-0.116019>
 <27.080099,-83.812698,-33.725399>, <0.057646,0.991469,-0.116899>
 <29.206499,-83.949303,-33.812500>, <0.061475,0.991573,-0.114038>
}
   smooth_triangle{ <28.554899,-83.774597,-32.647701>, <0.061803,0.991487,-0.114602>
 <29.206499,-83.949303,-33.812500>, <0.061475,0.991573,-0.114038>
 <27.080099,-83.812698,-33.725399>, <0.057646,0.991469,-0.116899>
}
   smooth_triangle{ <23.539000,-83.914597,-36.148602>, <0.048601,0.991369,-0.121763>
 <22.786200,-83.548103,-33.484798>, <0.051615,0.991072,-0.122932>
 <24.552999,-83.883904,-35.479401>, <0.051523,0.991419,-0.120143>
}
   smooth_triangle{ <23.683300,-83.520401,-32.871700>, <0.053977,0.991115,-0.121560>
 <24.552999,-83.883904,-35.479401>, <0.051523,0.991419,-0.120143>
 <22.786200,-83.548103,-33.484798>, <0.051615,0.991072,-0.122932>
}
   smooth_triangle{ <24.552999,-83.883904,-35.479401>, <0.051523,0.991419,-0.120143>
 <23.683300,-83.520401,-32.871700>, <0.053977,0.991115,-0.121560>
 <25.739799,-83.849602,-34.670300>, <0.054415,0.991461,-0.118508>
}
   smooth_triangle{ <24.730900,-83.487999,-32.127300>, <0.056454,0.991153,-0.120117>
 <25.739799,-83.849602,-34.670300>, <0.054415,0.991461,-0.118508>
 <23.683300,-83.520401,-32.871700>, <0.053977,0.991115,-0.121560>
}
   smooth_triangle{ <22.786200,-83.548103,-33.484798>, <0.051615,0.991072,-0.122932>
 <22.426800,-83.363297,-32.159100>, <0.053864,0.990715,-0.124833>
 <23.683300,-83.520401,-32.871700>, <0.053977,0.991115,-0.121560>
}
   smooth_triangle{ <23.277300,-83.340897,-31.603399>, <0.056290,0.990700,-0.123874>
 <23.683300,-83.520401,-32.871700>, <0.053977,0.991115,-0.121560>
 <22.426800,-83.363297,-32.159100>, <0.053864,0.990715,-0.124833>
}
   smooth_triangle{ <23.683300,-83.520401,-32.871700>, <0.053977,0.991115,-0.121560>
 <23.277300,-83.340897,-31.603399>, <0.056290,0.990700,-0.123874>
 <24.730900,-83.487999,-32.127300>, <0.056454,0.991153,-0.120117>
}
   smooth_triangle{ <24.273500,-83.315399,-30.933300>, <0.058852,0.990706,-0.122627>
 <24.730900,-83.487999,-32.127300>, <0.056454,0.991153,-0.120117>
 <23.277300,-83.340897,-31.603399>, <0.056290,0.990700,-0.123874>
}
   smooth_triangle{ <22.426800,-83.363297,-32.159100>, <0.053864,0.990715,-0.124833>
 <22.115801,-83.192497,-30.952600>, <0.052704,0.991001,-0.123043>
 <23.277300,-83.340897,-31.603399>, <0.056290,0.990700,-0.123874>
}
   smooth_triangle{ <22.935600,-83.178902,-30.479900>, <0.056027,0.990796,-0.123226>
 <23.277300,-83.340897,-31.603399>, <0.056290,0.990700,-0.123874>
 <22.115801,-83.192497,-30.952600>, <0.052704,0.991001,-0.123043>
}
   smooth_triangle{ <23.277300,-83.340897,-31.603399>, <0.056290,0.990700,-0.123874>
 <22.935600,-83.178902,-30.479900>, <0.056027,0.990796,-0.123226>
 <24.273500,-83.315399,-30.933300>, <0.058852,0.990706,-0.122627>
}
   smooth_triangle{ <23.903900,-83.166000,-29.921000>, <0.059398,0.990623,-0.123034>
 <24.273500,-83.315399,-30.933300>, <0.058852,0.990706,-0.122627>
 <22.935600,-83.178902,-30.479900>, <0.056027,0.990796,-0.123226>
}
   smooth_triangle{ <25.739799,-83.849602,-34.670300>, <0.054415,0.991461,-0.118508>
 <24.730900,-83.487999,-32.127300>, <0.056454,0.991153,-0.120117>
 <27.080099,-83.812698,-33.725399>, <0.057646,0.991469,-0.116899>
}
   smooth_triangle{ <25.910801,-83.451500,-31.253401>, <0.059299,0.991178,-0.118534>
 <27.080099,-83.812698,-33.725399>, <0.057646,0.991469,-0.116899>
 <24.730900,-83.487999,-32.127300>, <0.056454,0.991153,-0.120117>
}
   smooth_triangle{ <27.080099,-83.812698,-33.725399>, <0.057646,0.991469,-0.116899>
 <26.495501,-83.632103,-32.489498>, <0.059785,0.991404,-0.116374>
 <28.554899,-83.774597,-32.647701>, <0.061803,0.991487,-0.114602>
}
   smooth_triangle{ <27.865601,-83.589500,-31.420500>, <0.062168,0.991397,-0.115182>
 <28.554899,-83.774597,-32.647701>, <0.061803,0.991487,-0.114602>
 <26.495501,-83.632103,-32.489498>, <0.059785,0.991404,-0.116374>
}
   smooth_triangle{ <26.495501,-83.632103,-32.489498>, <0.059785,0.991404,-0.116374>
 <25.910801,-83.451500,-31.253401>, <0.059299,0.991178,-0.118534>
 <27.865601,-83.589500,-31.420500>, <0.062168,0.991397,-0.115182>
}
   smooth_triangle{ <27.205200,-83.411499,-30.251801>, <0.062931,0.991184,-0.116592>
 <27.865601,-83.589500,-31.420500>, <0.062168,0.991397,-0.115182>
 <25.910801,-83.451500,-31.253401>, <0.059299,0.991178,-0.118534>
}
   smooth_triangle{ <24.730900,-83.487999,-32.127300>, <0.056454,0.991153,-0.120117>
 <24.273500,-83.315399,-30.933300>, <0.058852,0.990706,-0.122627>
 <25.910801,-83.451500,-31.253401>, <0.059299,0.991178,-0.118534>
}
   smooth_triangle{ <25.399599,-83.287697,-30.151800>, <0.061475,0.990730,-0.121136>
 <25.910801,-83.451500,-31.253401>, <0.059299,0.991178,-0.118534>
 <24.273500,-83.315399,-30.933300>, <0.058852,0.990706,-0.122627>
}
   smooth_triangle{ <24.273500,-83.315399,-30.933300>, <0.058852,0.990706,-0.122627>
 <23.903900,-83.166000,-29.921000>, <0.059398,0.990623,-0.123034>
 <25.399599,-83.287697,-30.151800>, <0.061475,0.990730,-0.121136>
}
   smooth_triangle{ <25.008200,-83.155098,-29.283001>, <0.063110,0.990398,-0.123002>
 <25.399599,-83.287697,-30.151800>, <0.061475,0.990730,-0.121136>
 <23.903900,-83.166000,-29.921000>, <0.059398,0.990623,-0.123034>
}
   smooth_triangle{ <25.910801,-83.451500,-31.253401>, <0.059299,0.991178,-0.118534>
 <25.399599,-83.287697,-30.151800>, <0.061475,0.990730,-0.121136>
 <27.205200,-83.411499,-30.251801>, <0.062931,0.991184,-0.116592>
}
   smooth_triangle{ <26.639900,-83.258202,-29.262300>, <0.064410,0.990865,-0.118483>
 <27.205200,-83.411499,-30.251801>, <0.062931,0.991184,-0.116592>
 <25.399599,-83.287697,-30.151800>, <0.061475,0.990730,-0.121136>
}
   smooth_triangle{ <25.399599,-83.287697,-30.151800>, <0.061475,0.990730,-0.121136>
 <25.203899,-83.221397,-29.717501>, <0.064124,0.990536,-0.121349>
 <26.639900,-83.258202,-29.262300>, <0.064410,0.990865,-0.118483>
}
   smooth_triangle{ <26.413799,-83.196602,-28.872601>, <0.065773,0.990541,-0.120428>
 <26.639900,-83.258202,-29.262300>, <0.064410,0.990865,-0.118483>
 <25.203899,-83.221397,-29.717501>, <0.064124,0.990536,-0.121349>
}
   smooth_triangle{ <25.203899,-83.221397,-29.717501>, <0.064124,0.990536,-0.121349>
 <25.008200,-83.155098,-29.283001>, <0.063110,0.990398,-0.123002>
 <26.413799,-83.196602,-28.872601>, <0.065773,0.990541,-0.120428>
}
   smooth_triangle{ <26.236401,-83.147697,-28.572701>, <0.066787,0.990220,-0.122489>
 <26.413799,-83.196602,-28.872601>, <0.065773,0.990541,-0.120428>
 <25.008200,-83.155098,-29.283001>, <0.063110,0.990398,-0.123002>
}
   smooth_triangle{ <30.271900,-84.234398,-35.724201>, <0.060374,0.991752,-0.113062>
 <30.235500,-84.224701,-35.658600>, <0.061251,0.991717,-0.112899>
 <31.921700,-84.232498,-34.768902>, <0.064912,0.991745,-0.110581>
}
   smooth_triangle{ <31.881100,-84.222900,-34.706699>, <0.065887,0.991684,-0.110554>
 <31.921700,-84.232498,-34.768902>, <0.064912,0.991745,-0.110581>
 <30.235500,-84.224701,-35.658600>, <0.061251,0.991717,-0.112899>
}
   smooth_triangle{ <30.235500,-84.224701,-35.658600>, <0.061251,0.991717,-0.112899>
 <30.131500,-84.196899,-35.471600>, <0.061427,0.991659,-0.113306>
 <31.881100,-84.222900,-34.706699>, <0.065887,0.991684,-0.110554>
}
   smooth_triangle{ <31.765400,-84.195396,-34.529202>, <0.065986,0.991656,-0.110742>
 <31.881100,-84.222900,-34.706699>, <0.065887,0.991684,-0.110554>
 <30.131500,-84.196899,-35.471600>, <0.061427,0.991659,-0.113306>
}
   smooth_triangle{ <30.131500,-84.196899,-35.471600>, <0.061427,0.991659,-0.113306>
 <29.968300,-84.153198,-35.178501>, <0.061395,0.991652,-0.113388>
 <31.765400,-84.195396,-34.529202>, <0.065986,0.991656,-0.110742>
}
   smooth_triangle{ <31.583799,-84.152199,-34.250801>, <0.066024,0.991641,-0.110859>
 <31.765400,-84.195396,-34.529202>, <0.065986,0.991656,-0.110742>
 <29.968300,-84.153198,-35.178501>, <0.061395,0.991652,-0.113388>
}
   smooth_triangle{ <29.968300,-84.153198,-35.178501>, <0.061395,0.991652,-0.113388>
 <29.754200,-84.096001,-34.794102>, <0.061396,0.991627,-0.113607>
 <31.583799,-84.152199,-34.250801>, <0.066024,0.991641,-0.110859>
}
   smooth_triangle{ <31.345600,-84.095497,-33.885700>, <0.066076,0.991609,-0.111115>
 <31.583799,-84.152199,-34.250801>, <0.066024,0.991641,-0.110859>
 <29.754200,-84.096001,-34.794102>, <0.061396,0.991627,-0.113607>
}
   smooth_triangle{ <31.921700,-84.232498,-34.768902>, <0.064912,0.991745,-0.110581>
 <31.881100,-84.222900,-34.706699>, <0.065887,0.991684,-0.110554>
 <33.367001,-84.239502,-33.930302>, <0.069631,0.991678,-0.108284>
}
   smooth_triangle{ <33.322800,-84.229897,-33.870998>, <0.070402,0.991666,-0.107900>
 <33.367001,-84.239502,-33.930302>, <0.069631,0.991678,-0.108284>
 <31.881100,-84.222900,-34.706699>, <0.065887,0.991684,-0.110554>
}
   smooth_triangle{ <31.881100,-84.222900,-34.706699>, <0.065887,0.991684,-0.110554>
 <31.765400,-84.195396,-34.529202>, <0.065986,0.991656,-0.110742>
 <33.322800,-84.229897,-33.870998>, <0.070402,0.991666,-0.107900>
}
   smooth_triangle{ <33.196800,-84.202599,-33.701698>, <0.070370,0.991662,-0.107958>
 <33.322800,-84.229897,-33.870998>, <0.070402,0.991666,-0.107900>
 <31.765400,-84.195396,-34.529202>, <0.065986,0.991656,-0.110742>
}
   smooth_triangle{ <31.765400,-84.195396,-34.529202>, <0.065986,0.991656,-0.110742>
 <31.583799,-84.152199,-34.250801>, <0.066024,0.991641,-0.110859>
 <33.196800,-84.202599,-33.701698>, <0.070370,0.991662,-0.107958>
}
   smooth_triangle{ <32.998901,-84.159599,-33.436100>, <0.070441,0.991613,-0.108360>
 <33.196800,-84.202599,-33.701698>, <0.070370,0.991662,-0.107958>
 <31.583799,-84.152199,-34.250801>, <0.066024,0.991641,-0.110859>
}
   smooth_triangle{ <31.583799,-84.152199,-34.250801>, <0.066024,0.991641,-0.110859>
 <31.345600,-84.095497,-33.885700>, <0.066076,0.991609,-0.111115>
 <32.998901,-84.159599,-33.436100>, <0.070441,0.991613,-0.108360>
}
   smooth_triangle{ <32.739201,-84.102997,-33.087399>, <0.070368,0.991591,-0.108606>
 <32.998901,-84.159599,-33.436100>, <0.070441,0.991613,-0.108360>
 <31.345600,-84.095497,-33.885700>, <0.066076,0.991609,-0.111115>
}
   smooth_triangle{ <29.754200,-84.096001,-34.794102>, <0.061396,0.991627,-0.113607>
 <29.206499,-83.949303,-33.812500>, <0.061475,0.991573,-0.114038>
 <31.345600,-84.095497,-33.885700>, <0.066076,0.991609,-0.111115>
}
   smooth_triangle{ <30.735399,-83.950203,-32.952000>, <0.066108,0.991571,-0.111432>
 <31.345600,-84.095497,-33.885700>, <0.066076,0.991609,-0.111115>
 <29.206499,-83.949303,-33.812500>, <0.061475,0.991573,-0.114038>
}
   smooth_triangle{ <29.206499,-83.949303,-33.812500>, <0.061475,0.991573,-0.114038>
 <28.554899,-83.774597,-32.647701>, <0.061803,0.991487,-0.114602>
 <30.735399,-83.950203,-32.952000>, <0.066108,0.991571,-0.111432>
}
   smooth_triangle{ <30.008200,-83.776703,-31.841499>, <0.066188,0.991494,-0.112064>
 <30.735399,-83.950203,-32.952000>, <0.066108,0.991571,-0.111432>
 <28.554899,-83.774597,-32.647701>, <0.061803,0.991487,-0.114602>
}
   smooth_triangle{ <31.345600,-84.095497,-33.885700>, <0.066076,0.991609,-0.111115>
 <30.735399,-83.950203,-32.952000>, <0.066108,0.991571,-0.111432>
 <32.739201,-84.102997,-33.087399>, <0.070368,0.991591,-0.108606>
}
   smooth_triangle{ <32.073601,-83.958000,-32.194801>, <0.070186,0.991549,-0.109107>
 <32.739201,-84.102997,-33.087399>, <0.070368,0.991591,-0.108606>
 <30.735399,-83.950203,-32.952000>, <0.066108,0.991571,-0.111432>
}
   smooth_triangle{ <30.735399,-83.950203,-32.952000>, <0.066108,0.991571,-0.111432>
 <30.008200,-83.776703,-31.841499>, <0.066188,0.991494,-0.112064>
 <32.073601,-83.958000,-32.194801>, <0.070186,0.991549,-0.109107>
}
   smooth_triangle{ <31.279800,-83.784500,-31.131001>, <0.070010,0.991466,-0.109976>
 <32.073601,-83.958000,-32.194801>, <0.070186,0.991549,-0.109107>
 <30.008200,-83.776703,-31.841499>, <0.066188,0.991494,-0.112064>
}
   smooth_triangle{ <33.367001,-84.239502,-33.930302>, <0.069631,0.991678,-0.108284>
 <33.322800,-84.229897,-33.870998>, <0.070402,0.991666,-0.107900>
 <34.603100,-84.252899,-33.211899>, <0.074026,0.991650,-0.105598>
}
   smooth_triangle{ <34.555801,-84.243301,-33.154999>, <0.074749,0.991626,-0.105307>
 <34.603100,-84.252899,-33.211899>, <0.074026,0.991650,-0.105598>
 <33.322800,-84.229897,-33.870998>, <0.070402,0.991666,-0.107900>
}
   smooth_triangle{ <33.322800,-84.229897,-33.870998>, <0.070402,0.991666,-0.107900>
 <33.196800,-84.202599,-33.701698>, <0.070370,0.991662,-0.107958>
 <34.555801,-84.243301,-33.154999>, <0.074749,0.991626,-0.105307>
}
   smooth_triangle{ <34.420799,-84.215897,-32.992699>, <0.074725,0.991600,-0.105576>
 <34.555801,-84.243301,-33.154999>, <0.074749,0.991626,-0.105307>
 <33.196800,-84.202599,-33.701698>, <0.070370,0.991662,-0.107958>
}
   smooth_triangle{ <33.196800,-84.202599,-33.701698>, <0.070370,0.991662,-0.107958>
 <32.998901,-84.159599,-33.436100>, <0.070441,0.991613,-0.108360>
 <34.420799,-84.215897,-32.992699>, <0.074725,0.991600,-0.105576>
}
   smooth_triangle{ <34.208801,-84.172699,-32.737701>, <0.074680,0.991573,-0.105858>
 <34.420799,-84.215897,-32.992699>, <0.074725,0.991600,-0.105576>
 <32.998901,-84.159599,-33.436100>, <0.070441,0.991613,-0.108360>
}
   smooth_triangle{ <32.998901,-84.159599,-33.436100>, <0.070441,0.991613,-0.108360>
 <32.739201,-84.102997,-33.087399>, <0.070368,0.991591,-0.108606>
 <34.208801,-84.172699,-32.737701>, <0.074680,0.991573,-0.105858>
}
   smooth_triangle{ <33.930599,-84.115997,-32.402699>, <0.074513,0.991560,-0.106099>
 <34.208801,-84.172699,-32.737701>, <0.074680,0.991573,-0.105858>
 <32.739201,-84.102997,-33.087399>, <0.070368,0.991591,-0.108606>
}
   smooth_triangle{ <34.603100,-84.252899,-33.211899>, <0.074026,0.991650,-0.105598>
 <34.555801,-84.243301,-33.154999>, <0.074749,0.991626,-0.105307>
 <35.625301,-84.269798,-32.616901>, <0.078359,0.991562,-0.103271>
}
   smooth_triangle{ <35.575401,-84.260101,-32.562000>, <0.078983,0.991563,-0.102786>
 <35.625301,-84.269798,-32.616901>, <0.078359,0.991562,-0.103271>
 <34.555801,-84.243301,-33.154999>, <0.074749,0.991626,-0.105307>
}
   smooth_triangle{ <34.555801,-84.243301,-33.154999>, <0.074749,0.991626,-0.105307>
 <34.420799,-84.215897,-32.992699>, <0.074725,0.991600,-0.105576>
 <35.575401,-84.260101,-32.562000>, <0.078983,0.991563,-0.102786>
}
   smooth_triangle{ <35.432999,-84.232498,-32.405201>, <0.078929,0.991543,-0.103017>
 <35.575401,-84.260101,-32.562000>, <0.078983,0.991563,-0.102786>
 <34.420799,-84.215897,-32.992699>, <0.074725,0.991600,-0.105576>
}
   smooth_triangle{ <34.420799,-84.215897,-32.992699>, <0.074725,0.991600,-0.105576>
 <34.208801,-84.172699,-32.737701>, <0.074680,0.991573,-0.105858>
 <35.432999,-84.232498,-32.405201>, <0.078929,0.991543,-0.103017>
}
   smooth_triangle{ <35.209202,-84.189102,-32.158699>, <0.078733,0.991549,-0.103112>
 <35.432999,-84.232498,-32.405201>, <0.078929,0.991543,-0.103017>
 <34.208801,-84.172699,-32.737701>, <0.074680,0.991573,-0.105858>
}
   smooth_triangle{ <34.208801,-84.172699,-32.737701>, <0.074680,0.991573,-0.105858>
 <33.930599,-84.115997,-32.402699>, <0.074513,0.991560,-0.106099>
 <35.209202,-84.189102,-32.158699>, <0.078733,0.991549,-0.103112>
}
   smooth_triangle{ <34.915401,-84.132103,-31.834900>, <0.078538,0.991505,-0.103680>
 <35.209202,-84.189102,-32.158699>, <0.078733,0.991549,-0.103112>
 <33.930599,-84.115997,-32.402699>, <0.074513,0.991560,-0.106099>
}
   smooth_triangle{ <32.739201,-84.102997,-33.087399>, <0.070368,0.991591,-0.108606>
 <32.073601,-83.958000,-32.194801>, <0.070186,0.991549,-0.109107>
 <33.930599,-84.115997,-32.402699>, <0.074513,0.991560,-0.106099>
}
   smooth_triangle{ <33.217400,-83.970398,-31.544500>, <0.074179,0.991501,-0.106876>
 <33.930599,-84.115997,-32.402699>, <0.074513,0.991560,-0.106099>
 <32.073601,-83.958000,-32.194801>, <0.070186,0.991549,-0.109107>
}
   smooth_triangle{ <33.930599,-84.115997,-32.402699>, <0.074513,0.991560,-0.106099>
 <33.217400,-83.970398,-31.544500>, <0.074179,0.991501,-0.106876>
 <34.915401,-84.132103,-31.834900>, <0.078538,0.991505,-0.103680>
}
   smooth_triangle{ <34.162399,-83.985397,-31.004601>, <0.078039,0.991452,-0.104556>
 <34.915401,-84.132103,-31.834900>, <0.078538,0.991505,-0.103680>
 <33.217400,-83.970398,-31.544500>, <0.074179,0.991501,-0.106876>
}
   smooth_triangle{ <32.073601,-83.958000,-32.194801>, <0.070186,0.991549,-0.109107>
 <31.279800,-83.784500,-31.131001>, <0.070010,0.991466,-0.109976>
 <33.217400,-83.970398,-31.544500>, <0.074179,0.991501,-0.106876>
}
   smooth_triangle{ <32.366100,-83.796097,-30.520399>, <0.073772,0.991425,-0.107857>
 <33.217400,-83.970398,-31.544500>, <0.074179,0.991501,-0.106876>
 <31.279800,-83.784500,-31.131001>, <0.070010,0.991466,-0.109976>
}
   smooth_triangle{ <33.217400,-83.970398,-31.544500>, <0.074179,0.991501,-0.106876>
 <32.366100,-83.796097,-30.520399>, <0.073772,0.991425,-0.107857>
 <34.162399,-83.985397,-31.004601>, <0.078039,0.991452,-0.104556>
}
   smooth_triangle{ <33.263302,-83.809898,-30.012600>, <0.077398,0.991365,-0.105855>
 <34.162399,-83.985397,-31.004601>, <0.078039,0.991452,-0.104556>
 <32.366100,-83.796097,-30.520399>, <0.073772,0.991425,-0.107857>
}
   smooth_triangle{ <35.625301,-84.269798,-32.616901>, <0.078359,0.991562,-0.103271>
 <35.575401,-84.260101,-32.562000>, <0.078983,0.991563,-0.102786>
 <36.428600,-84.287598,-32.148602>, <0.082219,0.991586,-0.099985>
}
   smooth_triangle{ <36.376598,-84.277901,-32.095100>, <0.083078,0.991508,-0.100048>
 <36.428600,-84.287598,-32.148602>, <0.082219,0.991586,-0.099985>
 <35.575401,-84.260101,-32.562000>, <0.078983,0.991563,-0.102786>
}
   smooth_triangle{ <35.575401,-84.260101,-32.562000>, <0.078983,0.991563,-0.102786>
 <35.432999,-84.232498,-32.405201>, <0.078929,0.991543,-0.103017>
 <36.376598,-84.277901,-32.095100>, <0.083078,0.991508,-0.100048>
}
   smooth_triangle{ <36.228199,-84.250000,-31.942499>, <0.082958,0.991482,-0.100403>
 <36.376598,-84.277901,-32.095100>, <0.083078,0.991508,-0.100048>
 <35.432999,-84.232498,-32.405201>, <0.078929,0.991543,-0.103017>
}
   smooth_triangle{ <35.432999,-84.232498,-32.405201>, <0.078929,0.991543,-0.103017>
 <35.209202,-84.189102,-32.158699>, <0.078733,0.991549,-0.103112>
 <36.228199,-84.250000,-31.942499>, <0.082958,0.991482,-0.100403>
}
   smooth_triangle{ <35.995098,-84.206299,-31.702700>, <0.082644,0.991490,-0.100585>
 <36.228199,-84.250000,-31.942499>, <0.082958,0.991482,-0.100403>
 <35.209202,-84.189102,-32.158699>, <0.078733,0.991549,-0.103112>
}
   smooth_triangle{ <35.209202,-84.189102,-32.158699>, <0.078733,0.991549,-0.103112>
 <34.915401,-84.132103,-31.834900>, <0.078538,0.991505,-0.103680>
 <35.995098,-84.206299,-31.702700>, <0.082644,0.991490,-0.100585>
}
   smooth_triangle{ <35.689098,-84.148697,-31.387501>, <0.082397,0.991444,-0.101237>
 <35.995098,-84.206299,-31.702700>, <0.082644,0.991490,-0.100585>
 <34.915401,-84.132103,-31.834900>, <0.078538,0.991505,-0.103680>
}
   smooth_triangle{ <36.428600,-84.287598,-32.148602>, <0.082219,0.991586,-0.099985>
 <36.376598,-84.277901,-32.095100>, <0.083078,0.991508,-0.100048>
 <37.008400,-84.303802,-31.809999>, <0.086415,0.991431,-0.097963>
}
   smooth_triangle{ <36.954899,-84.293900,-31.757601>, <0.087019,0.991411,-0.097630>
 <37.008400,-84.303802,-31.809999>, <0.086415,0.991431,-0.097963>
 <36.376598,-84.277901,-32.095100>, <0.083078,0.991508,-0.100048>
}
   smooth_triangle{ <36.376598,-84.277901,-32.095100>, <0.083078,0.991508,-0.100048>
 <36.228199,-84.250000,-31.942499>, <0.082958,0.991482,-0.100403>
 <36.954899,-84.293900,-31.757601>, <0.087019,0.991411,-0.097630>
}
   smooth_triangle{ <36.802200,-84.265701,-31.607901>, <0.086803,0.991423,-0.097706>
 <36.954899,-84.293900,-31.757601>, <0.087019,0.991411,-0.097630>
 <36.228199,-84.250000,-31.942499>, <0.082958,0.991482,-0.100403>
}
   smooth_triangle{ <36.228199,-84.250000,-31.942499>, <0.082958,0.991482,-0.100403>
 <35.995098,-84.206299,-31.702700>, <0.082644,0.991490,-0.100585>
 <36.802200,-84.265701,-31.607901>, <0.086803,0.991423,-0.097706>
}
   smooth_triangle{ <36.562199,-84.221603,-31.372700>, <0.086408,0.991440,-0.097879>
 <36.802200,-84.265701,-31.607901>, <0.086803,0.991423,-0.097706>
 <35.995098,-84.206299,-31.702700>, <0.082644,0.991490,-0.100585>
}
   smooth_triangle{ <35.995098,-84.206299,-31.702700>, <0.082644,0.991490,-0.100585>
 <35.689098,-84.148697,-31.387501>, <0.082397,0.991444,-0.101237>
 <36.562199,-84.221603,-31.372700>, <0.086408,0.991440,-0.097879>
}
   smooth_triangle{ <36.247200,-84.163597,-31.063601>, <0.086042,0.991409,-0.098509>
 <36.562199,-84.221603,-31.372700>, <0.086408,0.991440,-0.097879>
 <35.689098,-84.148697,-31.387501>, <0.082397,0.991444,-0.101237>
}
   smooth_triangle{ <37.008400,-84.303802,-31.809999>, <0.086415,0.991431,-0.097963>
 <36.954899,-84.293900,-31.757601>, <0.087019,0.991411,-0.097630>
 <37.359798,-84.315300,-31.604500>, <0.089532,0.991499,-0.094409>
}
   smooth_triangle{ <37.305302,-84.305496,-31.552799>, <0.090174,0.991448,-0.094341>
 <37.359798,-84.315300,-31.604500>, <0.089532,0.991499,-0.094409>
 <36.954899,-84.293900,-31.757601>, <0.087019,0.991411,-0.097630>
}
   smooth_triangle{ <36.954899,-84.293900,-31.757601>, <0.087019,0.991411,-0.097630>
 <36.802200,-84.265701,-31.607901>, <0.086803,0.991423,-0.097706>
 <37.305302,-84.305496,-31.552799>, <0.090174,0.991448,-0.094341>
}
   smooth_triangle{ <37.149899,-84.277100,-31.404800>, <0.090230,0.991389,-0.094904>
 <37.305302,-84.305496,-31.552799>, <0.090174,0.991448,-0.094341>
 <36.802200,-84.265701,-31.607901>, <0.086803,0.991423,-0.097706>
}
   smooth_triangle{ <37.359798,-84.315300,-31.604500>, <0.089532,0.991499,-0.094409>
 <37.305302,-84.305496,-31.552799>, <0.090174,0.991448,-0.094341>
 <37.478100,-84.319801,-31.535299>, <0.065378,0.990607,-0.120099>
}
   smooth_triangle{ <37.423199,-84.309898,-31.483700>, <0.052773,0.989498,-0.134572>
 <37.478100,-84.319801,-31.535299>, <0.065378,0.990607,-0.120099>
 <37.305302,-84.305496,-31.552799>, <0.090174,0.991448,-0.094341>
}
   smooth_triangle{ <37.305302,-84.305496,-31.552799>, <0.090174,0.991448,-0.094341>
 <37.149899,-84.277100,-31.404800>, <0.090230,0.991389,-0.094904>
 <37.423199,-84.309898,-31.483700>, <0.052773,0.989498,-0.134572>
}
   smooth_triangle{ <37.266899,-84.281502,-31.336399>, <0.052782,0.989515,-0.134439>
 <37.423199,-84.309898,-31.483700>, <0.052773,0.989498,-0.134572>
 <37.149899,-84.277100,-31.404800>, <0.090230,0.991389,-0.094904>
}
   smooth_triangle{ <36.802200,-84.265701,-31.607901>, <0.086803,0.991423,-0.097706>
 <36.562199,-84.221603,-31.372700>, <0.086408,0.991440,-0.097879>
 <37.149899,-84.277100,-31.404800>, <0.090230,0.991389,-0.094904>
}
   smooth_triangle{ <36.905899,-84.232697,-31.172400>, <0.089885,0.991410,-0.095008>
 <37.149899,-84.277100,-31.404800>, <0.090230,0.991389,-0.094904>
 <36.562199,-84.221603,-31.372700>, <0.086408,0.991440,-0.097879>
}
   smooth_triangle{ <37.149899,-84.277100,-31.404800>, <0.090230,0.991389,-0.094904>
 <36.905899,-84.232697,-31.172400>, <0.089885,0.991410,-0.095008>
 <37.266899,-84.281502,-31.336399>, <0.052782,0.989515,-0.134439>
}
   smooth_triangle{ <37.021400,-84.237000,-31.104799>, <0.052970,0.989543,-0.134161>
 <37.266899,-84.281502,-31.336399>, <0.052782,0.989515,-0.134439>
 <36.905899,-84.232697,-31.172400>, <0.089885,0.991410,-0.095008>
}
   smooth_triangle{ <36.562199,-84.221603,-31.372700>, <0.086408,0.991440,-0.097879>
 <36.247200,-84.163597,-31.063601>, <0.086042,0.991409,-0.098509>
 <36.905899,-84.232697,-31.172400>, <0.089885,0.991410,-0.095008>
}
   smooth_triangle{ <36.585400,-84.174301,-30.866800>, <0.089512,0.991386,-0.095608>
 <36.905899,-84.232697,-31.172400>, <0.089885,0.991410,-0.095008>
 <36.247200,-84.163597,-31.063601>, <0.086042,0.991409,-0.098509>
}
   smooth_triangle{ <36.905899,-84.232697,-31.172400>, <0.089885,0.991410,-0.095008>
 <36.585400,-84.174301,-30.866800>, <0.089512,0.991386,-0.095608>
 <37.021400,-84.237000,-31.104799>, <0.052970,0.989543,-0.134161>
}
   smooth_triangle{ <36.699100,-84.178497,-30.800400>, <0.053287,0.989545,-0.134018>
 <37.021400,-84.237000,-31.104799>, <0.052970,0.989543,-0.134161>
 <36.585400,-84.174301,-30.866800>, <0.089512,0.991386,-0.095608>
}
   smooth_triangle{ <34.915401,-84.132103,-31.834900>, <0.078538,0.991505,-0.103680>
 <34.162399,-83.985397,-31.004601>, <0.078039,0.991452,-0.104556>
 <35.689098,-84.148697,-31.387501>, <0.082397,0.991444,-0.101237>
}
   smooth_triangle{ <34.904499,-84.000801,-30.578699>, <0.081723,0.991405,-0.102166>
 <35.689098,-84.148697,-31.387501>, <0.082397,0.991444,-0.101237>
 <34.162399,-83.985397,-31.004601>, <0.078039,0.991452,-0.104556>
}
   smooth_triangle{ <35.689098,-84.148697,-31.387501>, <0.082397,0.991444,-0.101237>
 <34.904499,-84.000801,-30.578699>, <0.081723,0.991405,-0.102166>
 <36.247200,-84.163597,-31.063601>, <0.086042,0.991409,-0.098509>
}
   smooth_triangle{ <35.439701,-84.014503,-30.270100>, <0.085228,0.991362,-0.099685>
 <36.247200,-84.163597,-31.063601>, <0.086042,0.991409,-0.098509>
 <34.904499,-84.000801,-30.578699>, <0.081723,0.991405,-0.102166>
}
   smooth_triangle{ <36.247200,-84.163597,-31.063601>, <0.086042,0.991409,-0.098509>
 <35.439701,-84.014503,-30.270100>, <0.085228,0.991362,-0.099685>
 <36.585400,-84.174301,-30.866800>, <0.089512,0.991386,-0.095608>
}
   smooth_triangle{ <35.763802,-84.024300,-30.082399>, <0.088547,0.991341,-0.096965>
 <36.585400,-84.174301,-30.866800>, <0.089512,0.991386,-0.095608>
 <35.439701,-84.014503,-30.270100>, <0.085228,0.991362,-0.099685>
}
   smooth_triangle{ <36.585400,-84.174301,-30.866800>, <0.089512,0.991386,-0.095608>
 <35.763802,-84.024300,-30.082399>, <0.088547,0.991341,-0.096965>
 <36.699100,-84.178497,-30.800400>, <0.053287,0.989545,-0.134018>
}
   smooth_triangle{ <35.872799,-84.028099,-30.018999>, <0.053752,0.989543,-0.133847>
 <36.699100,-84.178497,-30.800400>, <0.053287,0.989545,-0.134018>
 <35.763802,-84.024300,-30.082399>, <0.088547,0.991341,-0.096965>
}
   smooth_triangle{ <34.162399,-83.985397,-31.004601>, <0.078039,0.991452,-0.104556>
 <33.263302,-83.809898,-30.012600>, <0.077398,0.991365,-0.105855>
 <34.904499,-84.000801,-30.578699>, <0.081723,0.991405,-0.102166>
}
   smooth_triangle{ <33.967701,-83.823700,-29.611500>, <0.080732,0.991307,-0.103886>
 <34.904499,-84.000801,-30.578699>, <0.081723,0.991405,-0.102166>
 <33.263302,-83.809898,-30.012600>, <0.077398,0.991365,-0.105855>
}
   smooth_triangle{ <34.904499,-84.000801,-30.578699>, <0.081723,0.991405,-0.102166>
 <33.967701,-83.823700,-29.611500>, <0.080732,0.991307,-0.103886>
 <35.439701,-84.014503,-30.270100>, <0.085228,0.991362,-0.099685>
}
   smooth_triangle{ <34.475498,-83.835899,-29.320700>, <0.084026,0.991275,-0.101556>
 <35.439701,-84.014503,-30.270100>, <0.085228,0.991362,-0.099685>
 <33.967701,-83.823700,-29.611500>, <0.080732,0.991307,-0.103886>
}
   smooth_triangle{ <35.439701,-84.014503,-30.270100>, <0.085228,0.991362,-0.099685>
 <34.475498,-83.835899,-29.320700>, <0.084026,0.991275,-0.101556>
 <35.763802,-84.024300,-30.082399>, <0.088547,0.991341,-0.096965>
}
   smooth_triangle{ <34.782902,-83.844597,-29.143499>, <0.088323,0.991348,-0.097096>
 <35.763802,-84.024300,-30.082399>, <0.088547,0.991341,-0.096965>
 <34.475498,-83.835899,-29.320700>, <0.084026,0.991275,-0.101556>
}
   smooth_triangle{ <35.763802,-84.024300,-30.082399>, <0.088547,0.991341,-0.096965>
 <34.782902,-83.844597,-29.143499>, <0.088323,0.991348,-0.097096>
 <35.872799,-84.028099,-30.018999>, <0.053752,0.989543,-0.133847>
}
   smooth_triangle{ <34.886200,-83.847900,-29.083599>, <0.048888,0.989104,-0.138862>
 <35.872799,-84.028099,-30.018999>, <0.053752,0.989543,-0.133847>
 <34.782902,-83.844597,-29.143499>, <0.088323,0.991348,-0.097096>
}
   smooth_triangle{ <28.554899,-83.774597,-32.647701>, <0.061803,0.991487,-0.114602>
 <27.865601,-83.589500,-31.420500>, <0.062168,0.991397,-0.115182>
 <30.008200,-83.776703,-31.841499>, <0.066188,0.991494,-0.112064>
}
   smooth_triangle{ <29.237200,-83.592102,-30.667700>, <0.066338,0.991379,-0.112987>
 <30.008200,-83.776703,-31.841499>, <0.066188,0.991494,-0.112064>
 <27.865601,-83.589500,-31.420500>, <0.062168,0.991397,-0.115182>
}
   smooth_triangle{ <27.865601,-83.589500,-31.420500>, <0.062168,0.991397,-0.115182>
 <27.205200,-83.411499,-30.251801>, <0.062931,0.991184,-0.116592>
 <29.237200,-83.592102,-30.667700>, <0.066338,0.991379,-0.112987>
}
   smooth_triangle{ <28.495899,-83.413902,-29.544100>, <0.066764,0.991195,-0.114346>
 <29.237200,-83.592102,-30.667700>, <0.066338,0.991379,-0.112987>
 <27.205200,-83.411499,-30.251801>, <0.062931,0.991184,-0.116592>
}
   smooth_triangle{ <30.008200,-83.776703,-31.841499>, <0.066188,0.991494,-0.112064>
 <29.237200,-83.592102,-30.667700>, <0.066338,0.991379,-0.112987>
 <31.279800,-83.784500,-31.131001>, <0.070010,0.991466,-0.109976>
}
   smooth_triangle{ <30.437099,-83.599503,-30.003799>, <0.069880,0.991354,-0.111059>
 <31.279800,-83.784500,-31.131001>, <0.070010,0.991466,-0.109976>
 <29.237200,-83.592102,-30.667700>, <0.066338,0.991379,-0.112987>
}
   smooth_triangle{ <29.237200,-83.592102,-30.667700>, <0.066338,0.991379,-0.112987>
 <28.495899,-83.413902,-29.544100>, <0.066764,0.991195,-0.114346>
 <30.437099,-83.599503,-30.003799>, <0.069880,0.991354,-0.111059>
}
   smooth_triangle{ <29.625099,-83.420303,-28.920000>, <0.070008,0.991174,-0.112576>
 <30.437099,-83.599503,-30.003799>, <0.069880,0.991354,-0.111059>
 <28.495899,-83.413902,-29.544100>, <0.066764,0.991195,-0.114346>
}
   smooth_triangle{ <27.205200,-83.411499,-30.251801>, <0.062931,0.991184,-0.116592>
 <26.639900,-83.258202,-29.262300>, <0.064410,0.990865,-0.118483>
 <28.495899,-83.413902,-29.544100>, <0.066764,0.991195,-0.114346>
}
   smooth_triangle{ <27.857700,-83.259201,-28.584200>, <0.067586,0.990903,-0.116374>
 <28.495899,-83.413902,-29.544100>, <0.066764,0.991195,-0.114346>
 <26.639900,-83.258202,-29.262300>, <0.064410,0.990865,-0.118483>
}
   smooth_triangle{ <26.639900,-83.258202,-29.262300>, <0.064410,0.990865,-0.118483>
 <26.413799,-83.196602,-28.872601>, <0.065773,0.990541,-0.120428>
 <27.857700,-83.259201,-28.584200>, <0.067586,0.990903,-0.116374>
}
   smooth_triangle{ <27.600000,-83.195999,-28.201200>, <0.068919,0.990492,-0.119063>
 <27.857700,-83.259201,-28.584200>, <0.067586,0.990903,-0.116374>
 <26.413799,-83.196602,-28.872601>, <0.065773,0.990541,-0.120428>
}
   smooth_triangle{ <26.413799,-83.196602,-28.872601>, <0.065773,0.990541,-0.120428>
 <26.236401,-83.147697,-28.572701>, <0.066787,0.990220,-0.122489>
 <27.600000,-83.195999,-28.201200>, <0.068919,0.990492,-0.119063>
}
   smooth_triangle{ <27.395700,-83.145103,-27.901501>, <0.069909,0.990212,-0.120802>
 <27.600000,-83.195999,-28.201200>, <0.068919,0.990492,-0.119063>
 <26.236401,-83.147697,-28.572701>, <0.066787,0.990220,-0.122489>
}
   smooth_triangle{ <28.495899,-83.413902,-29.544100>, <0.066764,0.991195,-0.114346>
 <27.857700,-83.259201,-28.584200>, <0.067586,0.990903,-0.116374>
 <29.625099,-83.420303,-28.920000>, <0.070008,0.991174,-0.112576>
}
   smooth_triangle{ <28.923401,-83.263802,-27.987101>, <0.070643,0.990896,-0.114602>
 <29.625099,-83.420303,-28.920000>, <0.070008,0.991174,-0.112576>
 <27.857700,-83.259201,-28.584200>, <0.067586,0.990903,-0.116374>
}
   smooth_triangle{ <27.857700,-83.259201,-28.584200>, <0.067586,0.990903,-0.116374>
 <27.600000,-83.195999,-28.201200>, <0.068919,0.990492,-0.119063>
 <28.923401,-83.263802,-27.987101>, <0.070643,0.990896,-0.114602>
}
   smooth_triangle{ <28.638800,-83.199501,-27.610901>, <0.071868,0.990522,-0.117051>
 <28.923401,-83.263802,-27.987101>, <0.070643,0.990896,-0.114602>
 <27.600000,-83.195999,-28.201200>, <0.068919,0.990492,-0.119063>
}
   smooth_triangle{ <27.600000,-83.195999,-28.201200>, <0.068919,0.990492,-0.119063>
 <27.395700,-83.145103,-27.901501>, <0.069909,0.990212,-0.120802>
 <28.638800,-83.199501,-27.610901>, <0.071868,0.990522,-0.117051>
}
   smooth_triangle{ <28.411501,-83.147202,-27.312599>, <0.072838,0.990251,-0.118732>
 <28.638800,-83.199501,-27.610901>, <0.071868,0.990522,-0.117051>
 <27.395700,-83.145103,-27.901501>, <0.069909,0.990212,-0.120802>
}
   smooth_triangle{ <31.279800,-83.784500,-31.131001>, <0.070010,0.991466,-0.109976>
 <30.437099,-83.599503,-30.003799>, <0.069880,0.991354,-0.111059>
 <32.366100,-83.796097,-30.520399>, <0.073772,0.991425,-0.107857>
}
   smooth_triangle{ <31.463900,-83.610397,-29.434601>, <0.073324,0.991307,-0.109241>
 <32.366100,-83.796097,-30.520399>, <0.073772,0.991425,-0.107857>
 <30.437099,-83.599503,-30.003799>, <0.069880,0.991354,-0.111059>
}
   smooth_triangle{ <32.366100,-83.796097,-30.520399>, <0.073772,0.991425,-0.107857>
 <31.463900,-83.610397,-29.434601>, <0.073324,0.991307,-0.109241>
 <33.263302,-83.809898,-30.012600>, <0.077398,0.991365,-0.105855>
}
   smooth_triangle{ <32.324501,-83.625000,-28.974199>, <0.074788,0.991253,-0.108736>
 <33.263302,-83.809898,-30.012600>, <0.077398,0.991365,-0.105855>
 <31.463900,-83.610397,-29.434601>, <0.073324,0.991307,-0.109241>
}
   smooth_triangle{ <30.437099,-83.599503,-30.003799>, <0.069880,0.991354,-0.111059>
 <29.625099,-83.420303,-28.920000>, <0.070008,0.991174,-0.112576>
 <31.463900,-83.610397,-29.434601>, <0.073324,0.991307,-0.109241>
}
   smooth_triangle{ <30.589500,-83.429398,-28.382900>, <0.073225,0.991156,-0.110667>
 <31.463900,-83.610397,-29.434601>, <0.073324,0.991307,-0.109241>
 <29.625099,-83.420303,-28.920000>, <0.070008,0.991174,-0.112576>
}
   smooth_triangle{ <31.463900,-83.610397,-29.434601>, <0.073324,0.991307,-0.109241>
 <30.589500,-83.429398,-28.382900>, <0.073225,0.991156,-0.110667>
 <32.324501,-83.625000,-28.974199>, <0.074788,0.991253,-0.108736>
}
   smooth_triangle{ <31.385700,-83.440102,-27.935900>, <0.076504,0.991143,-0.108547>
 <32.324501,-83.625000,-28.974199>, <0.074788,0.991253,-0.108736>
 <30.589500,-83.429398,-28.382900>, <0.073225,0.991156,-0.110667>
}
   smooth_triangle{ <29.625099,-83.420303,-28.920000>, <0.070008,0.991174,-0.112576>
 <28.923401,-83.263802,-27.987101>, <0.070643,0.990896,-0.114602>
 <30.589500,-83.429398,-28.382900>, <0.073225,0.991156,-0.110667>
}
   smooth_triangle{ <29.834000,-83.271202,-27.474100>, <0.073698,0.990892,-0.112701>
 <30.589500,-83.429398,-28.382900>, <0.073225,0.991156,-0.110667>
 <28.923401,-83.263802,-27.987101>, <0.070643,0.990896,-0.114602>
}
   smooth_triangle{ <30.589500,-83.429398,-28.382900>, <0.073225,0.991156,-0.110667>
 <29.834000,-83.271202,-27.474100>, <0.073698,0.990892,-0.112701>
 <31.385700,-83.440102,-27.935900>, <0.076504,0.991143,-0.108547>
}
   smooth_triangle{ <30.586201,-83.280098,-27.047800>, <0.076569,0.990890,-0.110791>
 <31.385700,-83.440102,-27.935900>, <0.076504,0.991143,-0.108547>
 <29.834000,-83.271202,-27.474100>, <0.073698,0.990892,-0.112701>
}
   smooth_triangle{ <28.923401,-83.263802,-27.987101>, <0.070643,0.990896,-0.114602>
 <28.638800,-83.199501,-27.610901>, <0.071868,0.990522,-0.117051>
 <29.834000,-83.271202,-27.474100>, <0.073698,0.990892,-0.112701>
}
   smooth_triangle{ <29.526600,-83.205803,-27.104601>, <0.074683,0.990564,-0.114916>
 <29.834000,-83.271202,-27.474100>, <0.073698,0.990892,-0.112701>
 <28.638800,-83.199501,-27.610901>, <0.071868,0.990522,-0.117051>
}
   smooth_triangle{ <28.638800,-83.199501,-27.610901>, <0.071868,0.990522,-0.117051>
 <28.411501,-83.147202,-27.312599>, <0.072838,0.990251,-0.118732>
 <29.526600,-83.205803,-27.104601>, <0.074683,0.990564,-0.114916>
}
   smooth_triangle{ <29.280399,-83.152397,-26.808300>, <0.075567,0.990324,-0.116398>
 <29.526600,-83.205803,-27.104601>, <0.074683,0.990564,-0.114916>
 <28.411501,-83.147202,-27.312599>, <0.072838,0.990251,-0.118732>
}
   smooth_triangle{ <29.834000,-83.271202,-27.474100>, <0.073698,0.990892,-0.112701>
 <29.526600,-83.205803,-27.104601>, <0.074683,0.990564,-0.114916>
 <30.586201,-83.280098,-27.047800>, <0.076569,0.990890,-0.110791>
}
   smooth_triangle{ <30.260500,-83.213898,-26.684299>, <0.077371,0.990597,-0.112833>
 <30.586201,-83.280098,-27.047800>, <0.076569,0.990890,-0.110791>
 <29.526600,-83.205803,-27.104601>, <0.074683,0.990564,-0.114916>
}
   smooth_triangle{ <29.526600,-83.205803,-27.104601>, <0.074683,0.990564,-0.114916>
 <29.280399,-83.152397,-26.808300>, <0.075567,0.990324,-0.116398>
 <30.260500,-83.213898,-26.684299>, <0.077371,0.990597,-0.112833>
}
   smooth_triangle{ <29.999100,-83.159599,-26.390900>, <0.078094,0.990394,-0.114112>
 <30.260500,-83.213898,-26.684299>, <0.077371,0.990597,-0.112833>
 <29.280399,-83.152397,-26.808300>, <0.075567,0.990324,-0.116398>
}
   smooth_triangle{ <33.263302,-83.809898,-30.012600>, <0.077398,0.991365,-0.105855>
 <31.385700,-83.440102,-27.935900>, <0.076504,0.991143,-0.108547>
 <33.967701,-83.823700,-29.611500>, <0.080732,0.991307,-0.103886>
}
   smooth_triangle{ <32.010601,-83.450600,-27.582600>, <0.079500,0.991119,-0.106601>
 <33.967701,-83.823700,-29.611500>, <0.080732,0.991307,-0.103886>
 <31.385700,-83.440102,-27.935900>, <0.076504,0.991143,-0.108547>
}
   smooth_triangle{ <33.967701,-83.823700,-29.611500>, <0.080732,0.991307,-0.103886>
 <32.010601,-83.450600,-27.582600>, <0.079500,0.991119,-0.106601>
 <34.475498,-83.835899,-29.320700>, <0.084026,0.991275,-0.101556>
}
   smooth_triangle{ <32.460999,-83.459900,-27.326099>, <0.085492,0.991204,-0.101026>
 <34.475498,-83.835899,-29.320700>, <0.084026,0.991275,-0.101556>
 <32.010601,-83.450600,-27.582600>, <0.079500,0.991119,-0.106601>
}
   smooth_triangle{ <34.475498,-83.835899,-29.320700>, <0.084026,0.991275,-0.101556>
 <32.460999,-83.459900,-27.326099>, <0.085492,0.991204,-0.101026>
 <34.782902,-83.844597,-29.143499>, <0.088323,0.991348,-0.097096>
}
   smooth_triangle{ <32.733299,-83.470596,-27.169300>, <0.060391,0.989891,-0.128332>
 <34.782902,-83.844597,-29.143499>, <0.088323,0.991348,-0.097096>
 <32.460999,-83.459900,-27.326099>, <0.085492,0.991204,-0.101026>
}
   smooth_triangle{ <34.782902,-83.844597,-29.143499>, <0.088323,0.991348,-0.097096>
 <32.733299,-83.470596,-27.169300>, <0.060391,0.989891,-0.128332>
 <34.886200,-83.847900,-29.083599>, <0.048888,0.989104,-0.138862>
}
   smooth_triangle{ <32.825199,-83.468903,-27.116899>, <0.051220,0.989103,-0.138031>
 <34.886200,-83.847900,-29.083599>, <0.048888,0.989104,-0.138862>
 <32.733299,-83.470596,-27.169300>, <0.060391,0.989891,-0.128332>
}
   smooth_triangle{ <31.385700,-83.440102,-27.935900>, <0.076504,0.991143,-0.108547>
 <30.586201,-83.280098,-27.047800>, <0.076569,0.990890,-0.110791>
 <32.010601,-83.450600,-27.582600>, <0.079500,0.991119,-0.106601>
}
   smooth_triangle{ <31.176901,-83.289200,-26.711399>, <0.079310,0.990886,-0.108881>
 <32.010601,-83.450600,-27.582600>, <0.079500,0.991119,-0.106601>
 <30.586201,-83.280098,-27.047800>, <0.076569,0.990890,-0.110791>
}
   smooth_triangle{ <32.010601,-83.450600,-27.582600>, <0.079500,0.991119,-0.106601>
 <31.176901,-83.289200,-26.711399>, <0.079310,0.990886,-0.108881>
 <32.460999,-83.459900,-27.326099>, <0.085492,0.991204,-0.101026>
}
   smooth_triangle{ <31.602699,-83.297203,-26.467400>, <0.086621,0.990984,-0.102213>
 <32.460999,-83.459900,-27.326099>, <0.085492,0.991204,-0.101026>
 <31.176901,-83.289200,-26.711399>, <0.079310,0.990886,-0.108881>
}
   smooth_triangle{ <32.460999,-83.459900,-27.326099>, <0.085492,0.991204,-0.101026>
 <31.602699,-83.297203,-26.467400>, <0.086621,0.990984,-0.102213>
 <32.733299,-83.470596,-27.169300>, <0.060391,0.989891,-0.128332>
}
   smooth_triangle{ <31.860300,-83.306602,-26.318501>, <0.058143,0.989584,-0.131691>
 <32.733299,-83.470596,-27.169300>, <0.060391,0.989891,-0.128332>
 <31.602699,-83.297203,-26.467400>, <0.086621,0.990984,-0.102213>
}
   smooth_triangle{ <31.860300,-83.306602,-26.318501>, <-0.043468,-0.988267,0.146418>
 <32.733299,-83.470596,-27.169300>, <-0.037453,-0.987532,0.152896>
 <32.825199,-83.468903,-27.116899>, <-0.048400,-0.988798,0.141192>
}
   smooth_triangle{ <31.860300,-83.306602,-26.318501>, <0.058143,0.989584,-0.131691>
 <32.825199,-83.468903,-27.116899>, <0.051220,0.989103,-0.138031>
 <32.733299,-83.470596,-27.169300>, <0.060391,0.989891,-0.128332>
}
   smooth_triangle{ <32.825199,-83.468903,-27.116899>, <-0.048400,-0.988798,0.141192>
 <31.947201,-83.305099,-26.268700>, <-0.058226,-0.989609,0.131468>
 <31.860300,-83.306602,-26.318501>, <-0.043468,-0.988267,0.146418>
}
   smooth_triangle{ <32.825199,-83.468903,-27.116899>, <0.051220,0.989103,-0.138031>
 <31.860300,-83.306602,-26.318501>, <0.058143,0.989584,-0.131691>
 <31.947201,-83.305099,-26.268700>, <0.058037,0.989593,-0.131673>
}
   smooth_triangle{ <30.586201,-83.280098,-27.047800>, <0.076569,0.990890,-0.110791>
 <30.260500,-83.213898,-26.684299>, <0.077371,0.990597,-0.112833>
 <31.176901,-83.289200,-26.711399>, <0.079310,0.990886,-0.108881>
}
   smooth_triangle{ <30.837000,-83.222198,-26.353201>, <0.079927,0.990642,-0.110632>
 <31.176901,-83.289200,-26.711399>, <0.079310,0.990886,-0.108881>
 <30.260500,-83.213898,-26.684299>, <0.077371,0.990597,-0.112833>
}
   smooth_triangle{ <30.260500,-83.213898,-26.684299>, <0.077371,0.990597,-0.112833>
 <29.999100,-83.159599,-26.390900>, <0.078094,0.990394,-0.114112>
 <30.837000,-83.222198,-26.353201>, <0.079927,0.990642,-0.110632>
}
   smooth_triangle{ <30.563900,-83.167397,-26.062401>, <0.080528,0.990482,-0.111631>
 <30.837000,-83.222198,-26.353201>, <0.079927,0.990642,-0.110632>
 <29.999100,-83.159599,-26.390900>, <0.078094,0.990394,-0.114112>
}
   smooth_triangle{ <31.176901,-83.289200,-26.711399>, <0.079310,0.990886,-0.108881>
 <30.837000,-83.222198,-26.353201>, <0.079927,0.990642,-0.110632>
 <31.602699,-83.297203,-26.467400>, <0.086621,0.990984,-0.102213>
}
   smooth_triangle{ <31.252701,-83.229797,-26.113300>, <0.086957,0.990775,-0.103944>
 <31.602699,-83.297203,-26.467400>, <0.086621,0.990984,-0.102213>
 <30.837000,-83.222198,-26.353201>, <0.079927,0.990642,-0.110632>
}
   smooth_triangle{ <30.837000,-83.222198,-26.353201>, <0.079927,0.990642,-0.110632>
 <30.563900,-83.167397,-26.062401>, <0.080528,0.990482,-0.111631>
 <31.252701,-83.229797,-26.113300>, <0.086957,0.990775,-0.103944>
}
   smooth_triangle{ <30.971701,-83.174500,-25.825001>, <0.087593,0.990658,-0.104516>
 <31.252701,-83.229797,-26.113300>, <0.086957,0.990775,-0.103944>
 <30.563900,-83.167397,-26.062401>, <0.080528,0.990482,-0.111631>
}
   smooth_triangle{ <31.602699,-83.297203,-26.467400>, <0.086621,0.990984,-0.102213>
 <31.252701,-83.229797,-26.113300>, <0.086957,0.990775,-0.103944>
 <31.860300,-83.306602,-26.318501>, <0.058143,0.989584,-0.131691>
}
   smooth_triangle{ <31.504400,-83.238800,-25.967199>, <0.058795,0.989498,-0.132047>
 <31.860300,-83.306602,-26.318501>, <0.058143,0.989584,-0.131691>
 <31.252701,-83.229797,-26.113300>, <0.086957,0.990775,-0.103944>
}
   smooth_triangle{ <31.860300,-83.306602,-26.318501>, <0.058143,0.989584,-0.131691>
 <31.504400,-83.238800,-25.967199>, <0.058795,0.989498,-0.132047>
 <31.947201,-83.305099,-26.268700>, <0.058037,0.989593,-0.131673>
}
   smooth_triangle{ <31.589300,-83.237297,-25.918501>, <0.058310,0.989476,-0.132429>
 <31.947201,-83.305099,-26.268700>, <0.058037,0.989593,-0.131673>
 <31.504400,-83.238800,-25.967199>, <0.058795,0.989498,-0.132047>
}
   smooth_triangle{ <31.252701,-83.229797,-26.113300>, <0.086957,0.990775,-0.103944>
 <30.971701,-83.174500,-25.825001>, <0.087593,0.990658,-0.104516>
 <31.504400,-83.238800,-25.967199>, <0.058795,0.989498,-0.132047>
}
   smooth_triangle{ <31.218399,-83.183502,-25.680500>, <0.059042,0.989423,-0.132499>
 <31.504400,-83.238800,-25.967199>, <0.058795,0.989498,-0.132047>
 <30.971701,-83.174500,-25.825001>, <0.087593,0.990658,-0.104516>
}
   smooth_triangle{ <31.218399,-83.183502,-25.680500>, <-0.044437,-0.988171,0.146777>
 <31.504400,-83.238800,-25.967199>, <-0.038681,-0.987651,0.151817>
 <31.589300,-83.237297,-25.918501>, <-0.058254,-0.989476,0.132450>
}
   smooth_triangle{ <31.218399,-83.183502,-25.680500>, <0.059042,0.989423,-0.132499>
 <31.589300,-83.237297,-25.918501>, <0.058310,0.989476,-0.132429>
 <31.504400,-83.238800,-25.967199>, <0.058795,0.989498,-0.132047>
}
   smooth_triangle{ <31.589300,-83.237297,-25.918501>, <-0.058254,-0.989476,0.132450>
 <31.301901,-83.181900,-25.632401>, <-0.057977,-0.989338,0.133603>
 <31.218399,-83.183502,-25.680500>, <-0.044437,-0.988171,0.146777>
}
   smooth_triangle{ <31.589300,-83.237297,-25.918501>, <0.058310,0.989476,-0.132429>
 <31.218399,-83.183502,-25.680500>, <0.059042,0.989423,-0.132499>
 <31.301901,-83.181900,-25.632401>, <0.058145,0.989354,-0.133405>
}
   smooth_triangle{ <37.478100,-84.319801,-31.535299>, <-0.012982,-0.984461,0.175125>
 <37.423199,-84.309898,-31.483700>, <-0.013579,-0.984416,0.175329>
 <37.358799,-84.330200,-31.602600>, <-0.015505,-0.984693,0.173608>
}
   smooth_triangle{ <37.478100,-84.319801,-31.535299>, <0.065378,0.990607,-0.120099>
 <37.358799,-84.330200,-31.602600>, <0.015505,0.984693,-0.173608>
 <37.423199,-84.309898,-31.483700>, <0.052773,0.989498,-0.134572>
}
   smooth_triangle{ <37.304298,-84.320198,-31.550900>, <-0.016611,-0.984850,0.172611>
 <37.358799,-84.330200,-31.602600>, <-0.015505,-0.984693,0.173608>
 <37.423199,-84.309898,-31.483700>, <-0.013579,-0.984416,0.175329>
}
   smooth_triangle{ <37.304298,-84.320198,-31.550900>, <0.016611,0.984850,-0.172611>
 <37.423199,-84.309898,-31.483700>, <0.052773,0.989498,-0.134572>
 <37.358799,-84.330200,-31.602600>, <0.015505,0.984693,-0.173608>
}
   smooth_triangle{ <37.423199,-84.309898,-31.483700>, <-0.013579,-0.984416,0.175329>
 <37.266899,-84.281502,-31.336399>, <-0.013623,-0.984456,0.175101>
 <37.304298,-84.320198,-31.550900>, <-0.016611,-0.984850,0.172611>
}
   smooth_triangle{ <37.423199,-84.309898,-31.483700>, <0.052773,0.989498,-0.134572>
 <37.304298,-84.320198,-31.550900>, <0.016611,0.984850,-0.172611>
 <37.266899,-84.281502,-31.336399>, <0.052782,0.989515,-0.134439>
}
   smooth_triangle{ <37.148998,-84.291702,-31.402901>, <-0.016910,-0.984911,0.172231>
 <37.304298,-84.320198,-31.550900>, <-0.016611,-0.984850,0.172611>
 <37.266899,-84.281502,-31.336399>, <-0.013623,-0.984456,0.175101>
}
   smooth_triangle{ <37.148998,-84.291702,-31.402901>, <0.016910,0.984911,-0.172231>
 <37.266899,-84.281502,-31.336399>, <0.052782,0.989515,-0.134439>
 <37.304298,-84.320198,-31.550900>, <0.016611,0.984850,-0.172611>
}
   smooth_triangle{ <37.358799,-84.330200,-31.602600>, <-0.015505,-0.984693,0.173608>
 <37.304298,-84.320198,-31.550900>, <-0.016611,-0.984850,0.172611>
 <37.004700,-84.357803,-31.803200>, <-0.021782,-0.985586,0.167764>
}
   smooth_triangle{ <37.358799,-84.330200,-31.602600>, <0.015505,0.984693,-0.173608>
 <37.004700,-84.357803,-31.803200>, <0.021782,0.985586,-0.167764>
 <37.304298,-84.320198,-31.550900>, <0.016611,0.984850,-0.172611>
}
   smooth_triangle{ <36.951199,-84.347702,-31.750799>, <-0.023084,-0.985739,0.166693>
 <37.004700,-84.357803,-31.803200>, <-0.021782,-0.985586,0.167764>
 <37.304298,-84.320198,-31.550900>, <-0.016611,-0.984850,0.172611>
}
   smooth_triangle{ <36.951199,-84.347702,-31.750799>, <0.023084,0.985739,-0.166693>
 <37.304298,-84.320198,-31.550900>, <0.016611,0.984850,-0.172611>
 <37.004700,-84.357803,-31.803200>, <0.021782,0.985586,-0.167764>
}
   smooth_triangle{ <37.304298,-84.320198,-31.550900>, <-0.016611,-0.984850,0.172611>
 <37.148998,-84.291702,-31.402901>, <-0.016910,-0.984911,0.172231>
 <36.951199,-84.347702,-31.750799>, <-0.023084,-0.985739,0.166693>
}
   smooth_triangle{ <37.304298,-84.320198,-31.550900>, <0.016611,0.984850,-0.172611>
 <36.951199,-84.347702,-31.750799>, <0.023084,0.985739,-0.166693>
 <37.148998,-84.291702,-31.402901>, <0.016910,0.984911,-0.172231>
}
   smooth_triangle{ <36.798599,-84.318703,-31.601299>, <-0.023953,-0.985674,0.166950>
 <36.951199,-84.347702,-31.750799>, <-0.023084,-0.985739,0.166693>
 <37.148998,-84.291702,-31.402901>, <-0.016910,-0.984911,0.172231>
}
   smooth_triangle{ <36.798599,-84.318703,-31.601299>, <0.023953,0.985674,-0.166950>
 <37.148998,-84.291702,-31.402901>, <0.016910,0.984911,-0.172231>
 <36.951199,-84.347702,-31.750799>, <0.023084,0.985739,-0.166693>
}
   smooth_triangle{ <37.266899,-84.281502,-31.336399>, <-0.013623,-0.984456,0.175101>
 <37.021400,-84.237000,-31.104799>, <-0.014254,-0.984577,0.174372>
 <37.148998,-84.291702,-31.402901>, <-0.016910,-0.984911,0.172231>
}
   smooth_triangle{ <37.266899,-84.281502,-31.336399>, <0.052782,0.989515,-0.134439>
 <37.148998,-84.291702,-31.402901>, <0.016910,0.984911,-0.172231>
 <37.021400,-84.237000,-31.104799>, <0.052970,0.989543,-0.134161>
}
   smooth_triangle{ <36.904900,-84.246902,-31.170601>, <-0.017822,-0.985041,0.171395>
 <37.148998,-84.291702,-31.402901>, <-0.016910,-0.984911,0.172231>
 <37.021400,-84.237000,-31.104799>, <-0.014254,-0.984577,0.174372>
}
   smooth_triangle{ <36.904900,-84.246902,-31.170601>, <0.017822,0.985041,-0.171395>
 <37.021400,-84.237000,-31.104799>, <0.052970,0.989543,-0.134161>
 <37.148998,-84.291702,-31.402901>, <0.016910,0.984911,-0.172231>
}
   smooth_triangle{ <37.148998,-84.291702,-31.402901>, <-0.016910,-0.984911,0.172231>
 <36.904900,-84.246902,-31.170601>, <-0.017822,-0.985041,0.171395>
 <36.798599,-84.318703,-31.601299>, <-0.023953,-0.985674,0.166950>
}
   smooth_triangle{ <37.148998,-84.291702,-31.402901>, <0.016910,0.984911,-0.172231>
 <36.798599,-84.318703,-31.601299>, <0.023953,0.985674,-0.166950>
 <36.904900,-84.246902,-31.170601>, <0.017822,0.985041,-0.171395>
}
   smooth_triangle{ <36.558800,-84.273102,-31.366199>, <-0.024480,-0.985796,0.166154>
 <36.798599,-84.318703,-31.601299>, <-0.023953,-0.985674,0.166950>
 <36.904900,-84.246902,-31.170601>, <-0.017822,-0.985041,0.171395>
}
   smooth_triangle{ <36.558800,-84.273102,-31.366199>, <0.024480,0.985796,-0.166154>
 <36.904900,-84.246902,-31.170601>, <0.017822,0.985041,-0.171395>
 <36.798599,-84.318703,-31.601299>, <0.023953,0.985674,-0.166950>
}
   smooth_triangle{ <37.021400,-84.237000,-31.104799>, <-0.014254,-0.984577,0.174372>
 <36.699100,-84.178497,-30.800400>, <-0.015455,-0.984757,0.173246>
 <36.904900,-84.246902,-31.170601>, <-0.017822,-0.985041,0.171395>
}
   smooth_triangle{ <37.021400,-84.237000,-31.104799>, <0.052970,0.989543,-0.134161>
 <36.904900,-84.246902,-31.170601>, <0.017822,0.985041,-0.171395>
 <36.699100,-84.178497,-30.800400>, <0.053287,0.989545,-0.134018>
}
   smooth_triangle{ <36.584400,-84.188004,-30.865101>, <-0.019103,-0.985236,0.170131>
 <36.904900,-84.246902,-31.170601>, <-0.017822,-0.985041,0.171395>
 <36.699100,-84.178497,-30.800400>, <-0.015455,-0.984757,0.173246>
}
   smooth_triangle{ <36.584400,-84.188004,-30.865101>, <0.019103,0.985236,-0.170131>
 <36.699100,-84.178497,-30.800400>, <0.053287,0.989545,-0.134018>
 <36.904900,-84.246902,-31.170601>, <0.017822,0.985041,-0.171395>
}
   smooth_triangle{ <36.904900,-84.246902,-31.170601>, <-0.017822,-0.985041,0.171395>
 <36.584400,-84.188004,-30.865101>, <-0.019103,-0.985236,0.170131>
 <36.558800,-84.273102,-31.366199>, <-0.024480,-0.985796,0.166154>
}
   smooth_triangle{ <36.904900,-84.246902,-31.170601>, <0.017822,0.985041,-0.171395>
 <36.558800,-84.273102,-31.366199>, <0.024480,0.985796,-0.166154>
 <36.584400,-84.188004,-30.865101>, <0.019103,0.985236,-0.170131>
}
   smooth_triangle{ <36.243900,-84.213303,-31.057301>, <-0.025427,-0.985939,0.165163>
 <36.558800,-84.273102,-31.366199>, <-0.024480,-0.985796,0.166154>
 <36.584400,-84.188004,-30.865101>, <-0.019103,-0.985236,0.170131>
}
   smooth_triangle{ <36.243900,-84.213303,-31.057301>, <0.025427,0.985939,-0.165163>
 <36.584400,-84.188004,-30.865101>, <0.019103,0.985236,-0.170131>
 <36.558800,-84.273102,-31.366199>, <0.024480,0.985796,-0.166154>
}
   smooth_triangle{ <37.004700,-84.357803,-31.803200>, <-0.021782,-0.985586,0.167764>
 <36.951199,-84.347702,-31.750799>, <-0.023084,-0.985739,0.166693>
 <36.421200,-84.397102,-32.134701>, <-0.028570,-0.986542,0.160993>
}
   smooth_triangle{ <37.004700,-84.357803,-31.803200>, <0.021782,0.985586,-0.167764>
 <36.421200,-84.397102,-32.134701>, <0.028570,0.986542,-0.160993>
 <36.951199,-84.347702,-31.750799>, <0.023084,0.985739,-0.166693>
}
   smooth_triangle{ <36.369202,-84.386902,-32.081402>, <-0.030963,-0.986381,0.161533>
 <36.421200,-84.397102,-32.134701>, <-0.028570,-0.986542,0.160993>
 <36.951199,-84.347702,-31.750799>, <-0.023084,-0.985739,0.166693>
}
   smooth_triangle{ <36.369202,-84.386902,-32.081402>, <0.030963,0.986381,-0.161533>
 <36.951199,-84.347702,-31.750799>, <0.023084,0.985739,-0.166693>
 <36.421200,-84.397102,-32.134701>, <0.028570,0.986542,-0.160993>
}
   smooth_triangle{ <36.951199,-84.347702,-31.750799>, <-0.023084,-0.985739,0.166693>
 <36.798599,-84.318703,-31.601299>, <-0.023953,-0.985674,0.166950>
 <36.369202,-84.386902,-32.081402>, <-0.030963,-0.986381,0.161533>
}
   smooth_triangle{ <36.951199,-84.347702,-31.750799>, <0.023084,0.985739,-0.166693>
 <36.369202,-84.386902,-32.081402>, <0.030963,0.986381,-0.161533>
 <36.798599,-84.318703,-31.601299>, <0.023953,0.985674,-0.166950>
}
   smooth_triangle{ <36.221001,-84.357101,-31.929001>, <-0.031525,-0.986355,0.161583>
 <36.369202,-84.386902,-32.081402>, <-0.030963,-0.986381,0.161533>
 <36.798599,-84.318703,-31.601299>, <-0.023953,-0.985674,0.166950>
}
   smooth_triangle{ <36.221001,-84.357101,-31.929001>, <0.031525,0.986355,-0.161583>
 <36.798599,-84.318703,-31.601299>, <0.023953,0.985674,-0.166950>
 <36.369202,-84.386902,-32.081402>, <0.030963,0.986381,-0.161533>
}
   smooth_triangle{ <36.798599,-84.318703,-31.601299>, <-0.023953,-0.985674,0.166950>
 <36.558800,-84.273102,-31.366199>, <-0.024480,-0.985796,0.166154>
 <36.221001,-84.357101,-31.929001>, <-0.031525,-0.986355,0.161583>
}
   smooth_triangle{ <36.798599,-84.318703,-31.601299>, <0.023953,0.985674,-0.166950>
 <36.221001,-84.357101,-31.929001>, <0.031525,0.986355,-0.161583>
 <36.558800,-84.273102,-31.366199>, <0.024480,0.985796,-0.166154>
}
   smooth_triangle{ <35.988098,-84.310501,-31.689501>, <-0.031895,-0.986451,0.160925>
 <36.221001,-84.357101,-31.929001>, <-0.031525,-0.986355,0.161583>
 <36.558800,-84.273102,-31.366199>, <-0.024480,-0.985796,0.166154>
}
   smooth_triangle{ <35.988098,-84.310501,-31.689501>, <0.031895,0.986451,-0.160925>
 <36.558800,-84.273102,-31.366199>, <0.024480,0.985796,-0.166154>
 <36.221001,-84.357101,-31.929001>, <0.031525,0.986355,-0.161583>
}
   smooth_triangle{ <36.558800,-84.273102,-31.366199>, <-0.024480,-0.985796,0.166154>
 <36.243900,-84.213303,-31.057301>, <-0.025427,-0.985939,0.165163>
 <35.988098,-84.310501,-31.689501>, <-0.031895,-0.986451,0.160925>
}
   smooth_triangle{ <36.558800,-84.273102,-31.366199>, <0.024480,0.985796,-0.166154>
 <35.988098,-84.310501,-31.689501>, <0.031895,0.986451,-0.160925>
 <36.243900,-84.213303,-31.057301>, <0.025427,0.985939,-0.165163>
}
   smooth_triangle{ <35.682201,-84.249298,-31.374701>, <-0.032748,-0.986564,0.160057>
 <35.988098,-84.310501,-31.689501>, <-0.031895,-0.986451,0.160925>
 <36.243900,-84.213303,-31.057301>, <-0.025427,-0.985939,0.165163>
}
   smooth_triangle{ <35.682201,-84.249298,-31.374701>, <0.032748,0.986564,-0.160057>
 <36.243900,-84.213303,-31.057301>, <0.025427,0.985939,-0.165163>
 <35.988098,-84.310501,-31.689501>, <0.031895,0.986451,-0.160925>
}
   smooth_triangle{ <36.421200,-84.397102,-32.134701>, <-0.028570,-0.986542,0.160993>
 <36.369202,-84.386902,-32.081402>, <-0.030963,-0.986381,0.161533>
 <35.613499,-84.443001,-32.595001>, <-0.037768,-0.986792,0.157528>
}
   smooth_triangle{ <36.421200,-84.397102,-32.134701>, <0.028570,0.986542,-0.160993>
 <35.613499,-84.443001,-32.595001>, <0.037768,0.986792,-0.157528>
 <36.369202,-84.386902,-32.081402>, <0.030963,0.986381,-0.161533>
}
   smooth_triangle{ <35.563599,-84.432198,-32.540199>, <-0.039420,-0.986835,0.156852>
 <35.613499,-84.443001,-32.595001>, <-0.037768,-0.986792,0.157528>
 <36.369202,-84.386902,-32.081402>, <-0.030963,-0.986381,0.161533>
}
   smooth_triangle{ <35.563599,-84.432198,-32.540199>, <0.039420,0.986835,-0.156852>
 <36.369202,-84.386902,-32.081402>, <0.030963,0.986381,-0.161533>
 <35.613499,-84.443001,-32.595001>, <0.037768,0.986792,-0.157528>
}
   smooth_triangle{ <36.369202,-84.386902,-32.081402>, <-0.030963,-0.986381,0.161533>
 <36.221001,-84.357101,-31.929001>, <-0.031525,-0.986355,0.161583>
 <35.563599,-84.432198,-32.540199>, <-0.039420,-0.986835,0.156852>
}
   smooth_triangle{ <36.369202,-84.386902,-32.081402>, <0.030963,0.986381,-0.161533>
 <35.563599,-84.432198,-32.540199>, <0.039420,0.986835,-0.156852>
 <36.221001,-84.357101,-31.929001>, <0.031525,0.986355,-0.161583>
}
   smooth_triangle{ <35.421398,-84.401802,-32.383701>, <-0.039420,-0.986927,0.156271>
 <35.563599,-84.432198,-32.540199>, <-0.039420,-0.986835,0.156852>
 <36.221001,-84.357101,-31.929001>, <-0.031525,-0.986355,0.161583>
}
   smooth_triangle{ <35.421398,-84.401802,-32.383701>, <0.039420,0.986927,-0.156271>
 <36.221001,-84.357101,-31.929001>, <0.031525,0.986355,-0.161583>
 <35.563599,-84.432198,-32.540199>, <0.039420,0.986835,-0.156852>
}
   smooth_triangle{ <36.221001,-84.357101,-31.929001>, <-0.031525,-0.986355,0.161583>
 <35.988098,-84.310501,-31.689501>, <-0.031895,-0.986451,0.160925>
 <35.421398,-84.401802,-32.383701>, <-0.039420,-0.986927,0.156271>
}
   smooth_triangle{ <36.221001,-84.357101,-31.929001>, <0.031525,0.986355,-0.161583>
 <35.421398,-84.401802,-32.383701>, <0.039420,0.986927,-0.156271>
 <35.988098,-84.310501,-31.689501>, <0.031895,0.986451,-0.160925>
}
   smooth_triangle{ <35.198002,-84.353897,-32.137798>, <-0.039853,-0.986973,0.155872>
 <35.421398,-84.401802,-32.383701>, <-0.039420,-0.986927,0.156271>
 <35.988098,-84.310501,-31.689501>, <-0.031895,-0.986451,0.160925>
}
   smooth_triangle{ <35.198002,-84.353897,-32.137798>, <0.039853,0.986973,-0.155872>
 <35.988098,-84.310501,-31.689501>, <0.031895,0.986451,-0.160925>
 <35.421398,-84.401802,-32.383701>, <0.039420,0.986927,-0.156271>
}
   smooth_triangle{ <35.988098,-84.310501,-31.689501>, <-0.031895,-0.986451,0.160925>
 <35.682201,-84.249298,-31.374701>, <-0.032748,-0.986564,0.160057>
 <35.198002,-84.353897,-32.137798>, <-0.039853,-0.986973,0.155872>
}
   smooth_triangle{ <35.988098,-84.310501,-31.689501>, <0.031895,0.986451,-0.160925>
 <35.198002,-84.353897,-32.137798>, <0.039853,0.986973,-0.155872>
 <35.682201,-84.249298,-31.374701>, <0.032748,0.986564,-0.160057>
}
   smooth_triangle{ <34.904598,-84.291100,-31.814899>, <-0.040530,-0.987058,0.155160>
 <35.198002,-84.353897,-32.137798>, <-0.039853,-0.986973,0.155872>
 <35.682201,-84.249298,-31.374701>, <-0.032748,-0.986564,0.160057>
}
   smooth_triangle{ <34.904598,-84.291100,-31.814899>, <0.040530,0.987058,-0.155160>
 <35.682201,-84.249298,-31.374701>, <0.032748,0.986564,-0.160057>
 <35.198002,-84.353897,-32.137798>, <0.039853,0.986973,-0.155872>
}
   smooth_triangle{ <36.699100,-84.178497,-30.800400>, <-0.015455,-0.984757,0.173246>
 <35.872799,-84.028099,-30.018999>, <-0.017813,-0.985100,0.171059>
 <36.584400,-84.188004,-30.865101>, <-0.019103,-0.985236,0.170131>
}
   smooth_triangle{ <36.699100,-84.178497,-30.800400>, <0.053287,0.989545,-0.134018>
 <36.584400,-84.188004,-30.865101>, <0.019103,0.985236,-0.170131>
 <35.872799,-84.028099,-30.018999>, <0.053752,0.989543,-0.133847>
}
   smooth_triangle{ <35.763000,-84.036697,-30.080900>, <-0.021242,-0.985549,0.168051>
 <36.584400,-84.188004,-30.865101>, <-0.019103,-0.985236,0.170131>
 <35.872799,-84.028099,-30.018999>, <-0.017813,-0.985100,0.171059>
}
   smooth_triangle{ <35.763000,-84.036697,-30.080900>, <0.021242,0.985549,-0.168051>
 <35.872799,-84.028099,-30.018999>, <0.053752,0.989543,-0.133847>
 <36.584400,-84.188004,-30.865101>, <0.019103,0.985236,-0.170131>
}
   smooth_triangle{ <36.584400,-84.188004,-30.865101>, <-0.019103,-0.985236,0.170131>
 <35.763000,-84.036697,-30.080900>, <-0.021242,-0.985549,0.168051>
 <36.243900,-84.213303,-31.057301>, <-0.025427,-0.985939,0.165163>
}
   smooth_triangle{ <36.584400,-84.188004,-30.865101>, <0.019103,0.985236,-0.170131>
 <36.243900,-84.213303,-31.057301>, <0.025427,0.985939,-0.165163>
 <35.763000,-84.036697,-30.080900>, <0.021242,0.985549,-0.168051>
}
   smooth_triangle{ <35.436600,-84.059700,-30.264400>, <-0.027415,-0.986208,0.163223>
 <36.243900,-84.213303,-31.057301>, <-0.025427,-0.985939,0.165163>
 <35.763000,-84.036697,-30.080900>, <-0.021242,-0.985549,0.168051>
}
   smooth_triangle{ <35.436600,-84.059700,-30.264400>, <0.027415,0.986208,-0.163223>
 <35.763000,-84.036697,-30.080900>, <0.021242,0.985549,-0.168051>
 <36.243900,-84.213303,-31.057301>, <0.025427,0.985939,-0.165163>
}
   smooth_triangle{ <36.243900,-84.213303,-31.057301>, <-0.025427,-0.985939,0.165163>
 <35.436600,-84.059700,-30.264400>, <-0.027415,-0.986208,0.163223>
 <35.682201,-84.249298,-31.374701>, <-0.032748,-0.986564,0.160057>
}
   smooth_triangle{ <36.243900,-84.213303,-31.057301>, <0.025427,0.985939,-0.165163>
 <35.682201,-84.249298,-31.374701>, <0.032748,0.986564,-0.160057>
 <35.436600,-84.059700,-30.264400>, <0.027415,0.986208,-0.163223>
}
   smooth_triangle{ <34.898201,-84.092300,-30.567200>, <-0.034427,-0.986776,0.158390>
 <35.682201,-84.249298,-31.374701>, <-0.032748,-0.986564,0.160057>
 <35.436600,-84.059700,-30.264400>, <-0.027415,-0.986208,0.163223>
}
   smooth_triangle{ <34.898201,-84.092300,-30.567200>, <0.034427,0.986776,-0.158390>
 <35.436600,-84.059700,-30.264400>, <0.027415,0.986208,-0.163223>
 <35.682201,-84.249298,-31.374701>, <0.032748,0.986564,-0.160057>
}
   smooth_triangle{ <35.682201,-84.249298,-31.374701>, <-0.032748,-0.986564,0.160057>
 <34.898201,-84.092300,-30.567200>, <-0.034427,-0.986776,0.158390>
 <34.904598,-84.291100,-31.814899>, <-0.040530,-0.987058,0.155160>
}
   smooth_triangle{ <35.682201,-84.249298,-31.374701>, <0.032748,0.986564,-0.160057>
 <34.904598,-84.291100,-31.814899>, <0.040530,0.987058,-0.155160>
 <34.898201,-84.092300,-30.567200>, <0.034427,0.986776,-0.158390>
}
   smooth_triangle{ <34.152599,-84.129997,-30.986401>, <-0.041839,-0.987222,0.153759>
 <34.904598,-84.291100,-31.814899>, <-0.040530,-0.987058,0.155160>
 <34.898201,-84.092300,-30.567200>, <-0.034427,-0.986776,0.158390>
}
   smooth_triangle{ <34.152599,-84.129997,-30.986401>, <0.041839,0.987222,-0.153759>
 <34.898201,-84.092300,-30.567200>, <0.034427,0.986776,-0.158390>
 <34.904598,-84.291100,-31.814899>, <0.040530,0.987058,-0.155160>
}
   smooth_triangle{ <35.872799,-84.028099,-30.018999>, <-0.017813,-0.985100,0.171059>
 <34.886200,-83.847900,-29.083599>, <-0.020075,-0.985437,0.168853>
 <35.763000,-84.036697,-30.080900>, <-0.021242,-0.985549,0.168051>
}
   smooth_triangle{ <35.872799,-84.028099,-30.018999>, <0.053752,0.989543,-0.133847>
 <35.763000,-84.036697,-30.080900>, <0.021242,0.985549,-0.168051>
 <34.886200,-83.847900,-29.083599>, <0.048888,0.989104,-0.138862>
}
   smooth_triangle{ <34.782200,-83.855698,-29.142099>, <-0.029506,-0.986594,0.160503>
 <35.763000,-84.036697,-30.080900>, <-0.021242,-0.985549,0.168051>
 <34.886200,-83.847900,-29.083599>, <-0.020075,-0.985437,0.168853>
}
   smooth_triangle{ <34.782200,-83.855698,-29.142099>, <0.029506,0.986594,-0.160503>
 <34.886200,-83.847900,-29.083599>, <0.048888,0.989104,-0.138862>
 <35.763000,-84.036697,-30.080900>, <0.021242,0.985549,-0.168051>
}
   smooth_triangle{ <35.763000,-84.036697,-30.080900>, <-0.021242,-0.985549,0.168051>
 <34.782200,-83.855698,-29.142099>, <-0.029506,-0.986594,0.160503>
 <35.436600,-84.059700,-30.264400>, <-0.027415,-0.986208,0.163223>
}
   smooth_triangle{ <35.763000,-84.036697,-30.080900>, <0.021242,0.985549,-0.168051>
 <35.436600,-84.059700,-30.264400>, <0.027415,0.986208,-0.163223>
 <34.782200,-83.855698,-29.142099>, <0.029506,0.986594,-0.160503>
}
   smooth_triangle{ <34.472801,-83.875999,-29.315500>, <-0.028905,-0.986348,0.162117>
 <35.436600,-84.059700,-30.264400>, <-0.027415,-0.986208,0.163223>
 <34.782200,-83.855698,-29.142099>, <-0.029506,-0.986594,0.160503>
}
   smooth_triangle{ <34.472801,-83.875999,-29.315500>, <0.028905,0.986348,-0.162117>
 <34.782200,-83.855698,-29.142099>, <0.029506,0.986594,-0.160503>
 <35.436600,-84.059700,-30.264400>, <0.027415,0.986208,-0.163223>
}
   smooth_triangle{ <35.436600,-84.059700,-30.264400>, <-0.027415,-0.986208,0.163223>
 <34.472801,-83.875999,-29.315500>, <-0.028905,-0.986348,0.162117>
 <34.898201,-84.092300,-30.567200>, <-0.034427,-0.986776,0.158390>
}
   smooth_triangle{ <35.436600,-84.059700,-30.264400>, <0.027415,0.986208,-0.163223>
 <34.898201,-84.092300,-30.567200>, <0.034427,0.986776,-0.158390>
 <34.472801,-83.875999,-29.315500>, <0.028905,0.986348,-0.162117>
}
   smooth_triangle{ <33.962200,-83.904800,-29.601200>, <-0.036923,-0.987094,0.155828>
 <34.898201,-84.092300,-30.567200>, <-0.034427,-0.986776,0.158390>
 <34.472801,-83.875999,-29.315500>, <-0.028905,-0.986348,0.162117>
}
   smooth_triangle{ <33.962200,-83.904800,-29.601200>, <0.036923,0.987094,-0.155828>
 <34.472801,-83.875999,-29.315500>, <0.028905,0.986348,-0.162117>
 <34.898201,-84.092300,-30.567200>, <0.034427,0.986776,-0.158390>
}
   smooth_triangle{ <34.898201,-84.092300,-30.567200>, <-0.034427,-0.986776,0.158390>
 <33.962200,-83.904800,-29.601200>, <-0.036923,-0.987094,0.155828>
 <34.152599,-84.129997,-30.986401>, <-0.041839,-0.987222,0.153759>
}
   smooth_triangle{ <34.898201,-84.092300,-30.567200>, <0.034427,0.986776,-0.158390>
 <34.152599,-84.129997,-30.986401>, <0.041839,0.987222,-0.153759>
 <33.962200,-83.904800,-29.601200>, <0.036923,0.987094,-0.155828>
}
   smooth_triangle{ <33.254700,-83.938004,-29.996300>, <-0.043843,-0.987472,0.151580>
 <34.152599,-84.129997,-30.986401>, <-0.041839,-0.987222,0.153759>
 <33.962200,-83.904800,-29.601200>, <-0.036923,-0.987094,0.155828>
}
   smooth_triangle{ <33.254700,-83.938004,-29.996300>, <0.043843,0.987472,-0.151580>
 <33.962200,-83.904800,-29.601200>, <0.036923,0.987094,-0.155828>
 <34.152599,-84.129997,-30.986401>, <0.041839,0.987222,-0.153759>
}
   smooth_triangle{ <35.613499,-84.443001,-32.595001>, <-0.037768,-0.986792,0.157528>
 <35.563599,-84.432198,-32.540199>, <-0.039420,-0.986835,0.156852>
 <34.587002,-84.489502,-33.181999>, <-0.045984,-0.987307,0.152021>
}
   smooth_triangle{ <35.613499,-84.443001,-32.595001>, <0.037768,0.986792,-0.157528>
 <34.587002,-84.489502,-33.181999>, <0.045984,0.987307,-0.152021>
 <35.563599,-84.432198,-32.540199>, <0.039420,0.986835,-0.156852>
}
   smooth_triangle{ <34.539799,-84.478600,-33.125301>, <-0.047538,-0.987358,0.151207>
 <34.587002,-84.489502,-33.181999>, <-0.045984,-0.987307,0.152021>
 <35.563599,-84.432198,-32.540199>, <-0.039420,-0.986835,0.156852>
}
   smooth_triangle{ <34.539799,-84.478600,-33.125301>, <0.047538,0.987358,-0.151207>
 <35.563599,-84.432198,-32.540199>, <0.039420,0.986835,-0.156852>
 <34.587002,-84.489502,-33.181999>, <0.045984,0.987307,-0.152021>
}
   smooth_triangle{ <35.563599,-84.432198,-32.540199>, <-0.039420,-0.986835,0.156852>
 <35.421398,-84.401802,-32.383701>, <-0.039420,-0.986927,0.156271>
 <34.539799,-84.478600,-33.125301>, <-0.047538,-0.987358,0.151207>
}
   smooth_triangle{ <35.563599,-84.432198,-32.540199>, <0.039420,0.986835,-0.156852>
 <34.539799,-84.478600,-33.125301>, <0.047538,0.987358,-0.151207>
 <35.421398,-84.401802,-32.383701>, <0.039420,0.986927,-0.156271>
}
   smooth_triangle{ <34.405102,-84.447197,-32.963402>, <-0.047939,-0.987323,0.151312>
 <34.539799,-84.478600,-33.125301>, <-0.047538,-0.987358,0.151207>
 <35.421398,-84.401802,-32.383701>, <-0.039420,-0.986927,0.156271>
}
   smooth_triangle{ <34.405102,-84.447197,-32.963402>, <0.047939,0.987323,-0.151312>
 <35.421398,-84.401802,-32.383701>, <0.039420,0.986927,-0.156271>
 <34.539799,-84.478600,-33.125301>, <0.047538,0.987358,-0.151207>
}
   smooth_triangle{ <35.421398,-84.401802,-32.383701>, <-0.039420,-0.986927,0.156271>
 <35.198002,-84.353897,-32.137798>, <-0.039853,-0.986973,0.155872>
 <34.405102,-84.447197,-32.963402>, <-0.047939,-0.987323,0.151312>
}
   smooth_triangle{ <35.421398,-84.401802,-32.383701>, <0.039420,0.986927,-0.156271>
 <34.405102,-84.447197,-32.963402>, <0.047939,0.987323,-0.151312>
 <35.198002,-84.353897,-32.137798>, <0.039853,0.986973,-0.155872>
}
   smooth_triangle{ <34.193501,-84.398003,-32.709202>, <-0.048165,-0.987376,0.150896>
 <34.405102,-84.447197,-32.963402>, <-0.047939,-0.987323,0.151312>
 <35.198002,-84.353897,-32.137798>, <-0.039853,-0.986973,0.155872>
}
   smooth_triangle{ <34.193501,-84.398003,-32.709202>, <0.048165,0.987376,-0.150896>
 <35.198002,-84.353897,-32.137798>, <0.039853,0.986973,-0.155872>
 <34.405102,-84.447197,-32.963402>, <0.047939,0.987323,-0.151312>
}
   smooth_triangle{ <35.198002,-84.353897,-32.137798>, <-0.039853,-0.986973,0.155872>
 <34.904598,-84.291100,-31.814899>, <-0.040530,-0.987058,0.155160>
 <34.193501,-84.398003,-32.709202>, <-0.048165,-0.987376,0.150896>
}
   smooth_triangle{ <35.198002,-84.353897,-32.137798>, <0.039853,0.986973,-0.155872>
 <34.193501,-84.398003,-32.709202>, <0.048165,0.987376,-0.150896>
 <34.904598,-84.291100,-31.814899>, <0.040530,0.987058,-0.155160>
}
   smooth_triangle{ <33.915699,-84.333397,-32.375198>, <-0.048688,-0.987430,0.150369>
 <34.193501,-84.398003,-32.709202>, <-0.048165,-0.987376,0.150896>
 <34.904598,-84.291100,-31.814899>, <-0.040530,-0.987058,0.155160>
}
   smooth_triangle{ <33.915699,-84.333397,-32.375198>, <0.048688,0.987430,-0.150369>
 <34.904598,-84.291100,-31.814899>, <0.040530,0.987058,-0.155160>
 <34.193501,-84.398003,-32.709202>, <0.048165,0.987376,-0.150896>
}
   smooth_triangle{ <34.587002,-84.489502,-33.181999>, <-0.045984,-0.987307,0.152021>
 <34.539799,-84.478600,-33.125301>, <-0.047538,-0.987358,0.151207>
 <33.347000,-84.531700,-33.893398>, <-0.054727,-0.987629,0.146949>
}
   smooth_triangle{ <34.587002,-84.489502,-33.181999>, <0.045984,0.987307,-0.152021>
 <33.347000,-84.531700,-33.893398>, <0.054727,0.987629,-0.146949>
 <34.539799,-84.478600,-33.125301>, <0.047538,0.987358,-0.151207>
}
   smooth_triangle{ <33.303001,-84.520401,-33.834301>, <-0.056585,-0.987580,0.146571>
 <33.347000,-84.531700,-33.893398>, <-0.054727,-0.987629,0.146949>
 <34.539799,-84.478600,-33.125301>, <-0.047538,-0.987358,0.151207>
}
   smooth_triangle{ <33.303001,-84.520401,-33.834301>, <0.056585,0.987580,-0.146571>
 <34.539799,-84.478600,-33.125301>, <0.047538,0.987358,-0.151207>
 <33.347000,-84.531700,-33.893398>, <0.054727,0.987629,-0.146949>
}
   smooth_triangle{ <34.539799,-84.478600,-33.125301>, <-0.047538,-0.987358,0.151207>
 <34.405102,-84.447197,-32.963402>, <-0.047939,-0.987323,0.151312>
 <33.303001,-84.520401,-33.834301>, <-0.056585,-0.987580,0.146571>
}
   smooth_triangle{ <34.539799,-84.478600,-33.125301>, <0.047538,0.987358,-0.151207>
 <33.303001,-84.520401,-33.834301>, <0.056585,0.987580,-0.146571>
 <34.405102,-84.447197,-32.963402>, <0.047939,0.987323,-0.151312>
}
   smooth_triangle{ <33.177299,-84.488197,-33.665600>, <-0.056561,-0.987635,0.146212>
 <33.303001,-84.520401,-33.834301>, <-0.056585,-0.987580,0.146571>
 <34.405102,-84.447197,-32.963402>, <-0.047939,-0.987323,0.151312>
}
   smooth_triangle{ <33.177299,-84.488197,-33.665600>, <0.056561,0.987635,-0.146212>
 <34.405102,-84.447197,-32.963402>, <0.047939,0.987323,-0.151312>
 <33.303001,-84.520401,-33.834301>, <0.056585,0.987580,-0.146571>
}
   smooth_triangle{ <34.405102,-84.447197,-32.963402>, <-0.047939,-0.987323,0.151312>
 <34.193501,-84.398003,-32.709202>, <-0.048165,-0.987376,0.150896>
 <33.177299,-84.488197,-33.665600>, <-0.056561,-0.987635,0.146212>
}
   smooth_triangle{ <34.405102,-84.447197,-32.963402>, <0.047939,0.987323,-0.151312>
 <33.177299,-84.488197,-33.665600>, <0.056561,0.987635,-0.146212>
 <34.193501,-84.398003,-32.709202>, <0.048165,0.987376,-0.150896>
}
   smooth_triangle{ <32.980000,-84.437698,-33.401001>, <-0.056799,-0.987646,0.146047>
 <33.177299,-84.488197,-33.665600>, <-0.056561,-0.987635,0.146212>
 <34.193501,-84.398003,-32.709202>, <-0.048165,-0.987376,0.150896>
}
   smooth_triangle{ <32.980000,-84.437698,-33.401001>, <0.056799,0.987646,-0.146047>
 <34.193501,-84.398003,-32.709202>, <0.048165,0.987376,-0.150896>
 <33.177299,-84.488197,-33.665600>, <0.056561,0.987635,-0.146212>
}
   smooth_triangle{ <34.193501,-84.398003,-32.709202>, <-0.048165,-0.987376,0.150896>
 <33.915699,-84.333397,-32.375198>, <-0.048688,-0.987430,0.150369>
 <32.980000,-84.437698,-33.401001>, <-0.056799,-0.987646,0.146047>
}
   smooth_triangle{ <34.193501,-84.398003,-32.709202>, <0.048165,0.987376,-0.150896>
 <32.980000,-84.437698,-33.401001>, <0.056799,0.987646,-0.146047>
 <33.915699,-84.333397,-32.375198>, <0.048688,0.987430,-0.150369>
}
   smooth_triangle{ <32.720901,-84.371399,-33.053600>, <-0.057102,-0.987693,0.145605>
 <32.980000,-84.437698,-33.401001>, <-0.056799,-0.987646,0.146047>
 <33.915699,-84.333397,-32.375198>, <-0.048688,-0.987430,0.150369>
}
   smooth_triangle{ <32.720901,-84.371399,-33.053600>, <0.057102,0.987693,-0.145605>
 <33.915699,-84.333397,-32.375198>, <0.048688,0.987430,-0.150369>
 <32.980000,-84.437698,-33.401001>, <0.056799,0.987646,-0.146047>
}
   smooth_triangle{ <34.904598,-84.291100,-31.814899>, <-0.040530,-0.987058,0.155160>
 <34.152599,-84.129997,-30.986401>, <-0.041839,-0.987222,0.153759>
 <33.915699,-84.333397,-32.375198>, <-0.048688,-0.987430,0.150369>
}
   smooth_triangle{ <34.904598,-84.291100,-31.814899>, <0.040530,0.987058,-0.155160>
 <33.915699,-84.333397,-32.375198>, <0.048688,0.987430,-0.150369>
 <34.152599,-84.129997,-30.986401>, <0.041839,0.987222,-0.153759>
}
   smooth_triangle{ <33.203899,-84.168098,-31.519600>, <-0.049626,-0.987557,0.149228>
 <33.915699,-84.333397,-32.375198>, <-0.048688,-0.987430,0.150369>
 <34.152599,-84.129997,-30.986401>, <-0.041839,-0.987222,0.153759>
}
   smooth_triangle{ <33.203899,-84.168098,-31.519600>, <0.049626,0.987557,-0.149228>
 <34.152599,-84.129997,-30.986401>, <0.041839,0.987222,-0.153759>
 <33.915699,-84.333397,-32.375198>, <0.048688,0.987430,-0.150369>
}
   smooth_triangle{ <33.915699,-84.333397,-32.375198>, <-0.048688,-0.987430,0.150369>
 <33.203899,-84.168098,-31.519600>, <-0.049626,-0.987557,0.149228>
 <32.720901,-84.371399,-33.053600>, <-0.057102,-0.987693,0.145605>
}
   smooth_triangle{ <33.915699,-84.333397,-32.375198>, <0.048688,0.987430,-0.150369>
 <32.720901,-84.371399,-33.053600>, <0.057102,0.987693,-0.145605>
 <33.203899,-84.168098,-31.519600>, <0.049626,0.987557,-0.149228>
}
   smooth_triangle{ <32.056999,-84.202003,-32.163898>, <-0.057626,-0.987793,0.144721>
 <32.720901,-84.371399,-33.053600>, <-0.057102,-0.987693,0.145605>
 <33.203899,-84.168098,-31.519600>, <-0.049626,-0.987557,0.149228>
}
   smooth_triangle{ <32.056999,-84.202003,-32.163898>, <0.057626,0.987793,-0.144721>
 <33.203899,-84.168098,-31.519600>, <0.049626,0.987557,-0.149228>
 <32.720901,-84.371399,-33.053600>, <0.057102,0.987693,-0.145605>
}
   smooth_triangle{ <34.152599,-84.129997,-30.986401>, <-0.041839,-0.987222,0.153759>
 <33.254700,-83.938004,-29.996300>, <-0.043843,-0.987472,0.151580>
 <33.203899,-84.168098,-31.519600>, <-0.049626,-0.987557,0.149228>
}
   smooth_triangle{ <34.152599,-84.129997,-30.986401>, <0.041839,0.987222,-0.153759>
 <33.203899,-84.168098,-31.519600>, <0.049626,0.987557,-0.149228>
 <33.254700,-83.938004,-29.996300>, <0.043843,0.987472,-0.151580>
}
   smooth_triangle{ <32.354198,-83.971199,-30.498100>, <-0.050848,-0.987719,0.147735>
 <33.203899,-84.168098,-31.519600>, <-0.049626,-0.987557,0.149228>
 <33.254700,-83.938004,-29.996300>, <-0.043843,-0.987472,0.151580>
}
   smooth_triangle{ <32.354198,-83.971199,-30.498100>, <0.050848,0.987719,-0.147735>
 <33.254700,-83.938004,-29.996300>, <0.043843,0.987472,-0.151580>
 <33.203899,-84.168098,-31.519600>, <0.049626,0.987557,-0.149228>
}
   smooth_triangle{ <33.203899,-84.168098,-31.519600>, <-0.049626,-0.987557,0.149228>
 <32.354198,-83.971199,-30.498100>, <-0.050848,-0.987719,0.147735>
 <32.056999,-84.202003,-32.163898>, <-0.057626,-0.987793,0.144721>
}
   smooth_triangle{ <33.203899,-84.168098,-31.519600>, <0.049626,0.987557,-0.149228>
 <32.056999,-84.202003,-32.163898>, <0.057626,0.987793,-0.144721>
 <32.354198,-83.971199,-30.498100>, <0.050848,0.987719,-0.147735>
}
   smooth_triangle{ <31.264999,-84.000702,-31.103701>, <-0.058381,-0.987906,0.143646>
 <32.056999,-84.202003,-32.163898>, <-0.057626,-0.987793,0.144721>
 <32.354198,-83.971199,-30.498100>, <-0.050848,-0.987719,0.147735>
}
   smooth_triangle{ <31.264999,-84.000702,-31.103701>, <0.058381,0.987906,-0.143646>
 <32.354198,-83.971199,-30.498100>, <0.050848,0.987719,-0.147735>
 <32.056999,-84.202003,-32.163898>, <0.057626,0.987793,-0.144721>
}
   smooth_triangle{ <33.347000,-84.531700,-33.893398>, <-0.054727,-0.987629,0.146949>
 <33.303001,-84.520401,-33.834301>, <-0.056585,-0.987580,0.146571>
 <31.899000,-84.563904,-34.727001>, <-0.064159,-0.987712,0.142505>
}
   smooth_triangle{ <33.347000,-84.531700,-33.893398>, <0.054727,0.987629,-0.146949>
 <31.899000,-84.563904,-34.727001>, <0.064159,0.987712,-0.142505>
 <33.303001,-84.520401,-33.834301>, <0.056585,0.987580,-0.146571>
}
   smooth_triangle{ <31.858601,-84.552299,-34.665001>, <-0.065513,-0.987796,0.141304>
 <31.899000,-84.563904,-34.727001>, <-0.064159,-0.987712,0.142505>
 <33.303001,-84.520401,-33.834301>, <-0.056585,-0.987580,0.146571>
}
   smooth_triangle{ <31.858601,-84.552299,-34.665001>, <0.065513,0.987796,-0.141304>
 <33.303001,-84.520401,-33.834301>, <0.056585,0.987580,-0.146571>
 <31.899000,-84.563904,-34.727001>, <0.064159,0.987712,-0.142505>
}
   smooth_triangle{ <33.303001,-84.520401,-33.834301>, <-0.056585,-0.987580,0.146571>
 <33.177299,-84.488197,-33.665600>, <-0.056561,-0.987635,0.146212>
 <31.858601,-84.552299,-34.665001>, <-0.065513,-0.987796,0.141304>
}
   smooth_triangle{ <33.303001,-84.520401,-33.834301>, <0.056585,0.987580,-0.146571>
 <31.858601,-84.552299,-34.665001>, <0.065513,0.987796,-0.141304>
 <33.177299,-84.488197,-33.665600>, <0.056561,0.987635,-0.146212>
}
   smooth_triangle{ <31.743299,-84.519402,-34.488300>, <-0.065566,-0.987806,0.141208>
 <31.858601,-84.552299,-34.665001>, <-0.065513,-0.987796,0.141304>
 <33.177299,-84.488197,-33.665600>, <-0.056561,-0.987635,0.146212>
}
   smooth_triangle{ <31.743299,-84.519402,-34.488300>, <0.065566,0.987806,-0.141208>
 <33.177299,-84.488197,-33.665600>, <0.056561,0.987635,-0.146212>
 <31.858601,-84.552299,-34.665001>, <0.065513,0.987796,-0.141304>
}
   smooth_triangle{ <33.177299,-84.488197,-33.665600>, <-0.056561,-0.987635,0.146212>
 <32.980000,-84.437698,-33.401001>, <-0.056799,-0.987646,0.146047>
 <31.743299,-84.519402,-34.488300>, <-0.065566,-0.987806,0.141208>
}
   smooth_triangle{ <33.177299,-84.488197,-33.665600>, <0.056561,0.987635,-0.146212>
 <31.743299,-84.519402,-34.488300>, <0.065566,0.987806,-0.141208>
 <32.980000,-84.437698,-33.401001>, <0.056799,0.987646,-0.146047>
}
   smooth_triangle{ <31.562201,-84.467697,-34.211102>, <-0.065664,-0.987816,0.141096>
 <31.743299,-84.519402,-34.488300>, <-0.065566,-0.987806,0.141208>
 <32.980000,-84.437698,-33.401001>, <-0.056799,-0.987646,0.146047>
}
   smooth_triangle{ <31.562201,-84.467697,-34.211102>, <0.065664,0.987816,-0.141096>
 <32.980000,-84.437698,-33.401001>, <0.056799,0.987646,-0.146047>
 <31.743299,-84.519402,-34.488300>, <0.065566,0.987806,-0.141208>
}
   smooth_triangle{ <32.980000,-84.437698,-33.401001>, <-0.056799,-0.987646,0.146047>
 <32.720901,-84.371399,-33.053600>, <-0.057102,-0.987693,0.145605>
 <31.562201,-84.467697,-34.211102>, <-0.065664,-0.987816,0.141096>
}
   smooth_triangle{ <32.980000,-84.437698,-33.401001>, <0.056799,0.987646,-0.146047>
 <31.562201,-84.467697,-34.211102>, <0.065664,0.987816,-0.141096>
 <32.720901,-84.371399,-33.053600>, <0.057102,0.987693,-0.145605>
}
   smooth_triangle{ <31.324699,-84.399902,-33.847301>, <-0.065712,-0.987863,0.140744>
 <31.562201,-84.467697,-34.211102>, <-0.065664,-0.987816,0.141096>
 <32.720901,-84.371399,-33.053600>, <-0.057102,-0.987693,0.145605>
}
   smooth_triangle{ <31.324699,-84.399902,-33.847301>, <0.065712,0.987863,-0.140744>
 <32.720901,-84.371399,-33.053600>, <0.057102,0.987693,-0.145605>
 <31.562201,-84.467697,-34.211102>, <0.065664,0.987816,-0.141096>
}
   smooth_triangle{ <31.899000,-84.563904,-34.727001>, <-0.064159,-0.987712,0.142505>
 <31.858601,-84.552299,-34.665001>, <-0.065513,-0.987796,0.141304>
 <30.248199,-84.580704,-35.680599>, <-0.071865,-0.987904,0.137407>
}
   smooth_triangle{ <31.899000,-84.563904,-34.727001>, <0.064159,0.987712,-0.142505>
 <30.248199,-84.580704,-35.680599>, <0.071865,0.987904,-0.137407>
 <31.858601,-84.552299,-34.665001>, <0.065513,0.987796,-0.141304>
}
   smooth_triangle{ <30.211800,-84.569000,-35.615299>, <-0.072801,-0.987915,0.136835>
 <30.248199,-84.580704,-35.680599>, <-0.071865,-0.987904,0.137407>
 <31.858601,-84.552299,-34.665001>, <-0.065513,-0.987796,0.141304>
}
   smooth_triangle{ <30.211800,-84.569000,-35.615299>, <0.072801,0.987915,-0.136835>
 <31.858601,-84.552299,-34.665001>, <0.065513,0.987796,-0.141304>
 <30.248199,-84.580704,-35.680599>, <0.071865,0.987904,-0.137407>
}
   smooth_triangle{ <31.858601,-84.552299,-34.665001>, <-0.065513,-0.987796,0.141304>
 <31.743299,-84.519402,-34.488300>, <-0.065566,-0.987806,0.141208>
 <30.211800,-84.569000,-35.615299>, <-0.072801,-0.987915,0.136835>
}
   smooth_triangle{ <31.858601,-84.552299,-34.665001>, <0.065513,0.987796,-0.141304>
 <30.211800,-84.569000,-35.615299>, <0.072801,0.987915,-0.136835>
 <31.743299,-84.519402,-34.488300>, <0.065566,0.987806,-0.141208>
}
   smooth_triangle{ <30.108200,-84.535400,-35.428902>, <-0.072926,-0.987861,0.137157>
 <30.211800,-84.569000,-35.615299>, <-0.072801,-0.987915,0.136835>
 <31.743299,-84.519402,-34.488300>, <-0.065566,-0.987806,0.141208>
}
   smooth_triangle{ <30.108200,-84.535400,-35.428902>, <0.072926,0.987861,-0.137157>
 <31.743299,-84.519402,-34.488300>, <0.065566,0.987806,-0.141208>
 <30.211800,-84.569000,-35.615299>, <0.072801,0.987915,-0.136835>
}
   smooth_triangle{ <31.743299,-84.519402,-34.488300>, <-0.065566,-0.987806,0.141208>
 <31.562201,-84.467697,-34.211102>, <-0.065664,-0.987816,0.141096>
 <30.108200,-84.535400,-35.428902>, <-0.072926,-0.987861,0.137157>
}
   smooth_triangle{ <31.743299,-84.519402,-34.488300>, <0.065566,0.987806,-0.141208>
 <30.108200,-84.535400,-35.428902>, <0.072926,0.987861,-0.137157>
 <31.562201,-84.467697,-34.211102>, <0.065664,0.987816,-0.141096>
}
   smooth_triangle{ <29.945601,-84.482903,-35.136902>, <-0.072703,-0.987902,0.136983>
 <30.108200,-84.535400,-35.428902>, <-0.072926,-0.987861,0.137157>
 <31.562201,-84.467697,-34.211102>, <-0.065664,-0.987816,0.141096>
}
   smooth_triangle{ <29.945601,-84.482903,-35.136902>, <0.072703,0.987902,-0.136983>
 <31.562201,-84.467697,-34.211102>, <0.065664,0.987816,-0.141096>
 <30.108200,-84.535400,-35.428902>, <0.072926,0.987861,-0.137157>
}
   smooth_triangle{ <31.562201,-84.467697,-34.211102>, <-0.065664,-0.987816,0.141096>
 <31.324699,-84.399902,-33.847301>, <-0.065712,-0.987863,0.140744>
 <29.945601,-84.482903,-35.136902>, <-0.072703,-0.987902,0.136983>
}
   smooth_triangle{ <31.562201,-84.467697,-34.211102>, <0.065664,0.987816,-0.141096>
 <29.945601,-84.482903,-35.136902>, <0.072703,0.987902,-0.136983>
 <31.324699,-84.399902,-33.847301>, <0.065712,0.987863,-0.140744>
}
   smooth_triangle{ <29.732300,-84.414101,-34.754002>, <-0.072473,-0.987937,0.136849>
 <29.945601,-84.482903,-35.136902>, <-0.072703,-0.987902,0.136983>
 <31.324699,-84.399902,-33.847301>, <-0.065712,-0.987863,0.140744>
}
   smooth_triangle{ <29.732300,-84.414101,-34.754002>, <0.072473,0.987937,-0.136849>
 <31.324699,-84.399902,-33.847301>, <0.065712,0.987863,-0.140744>
 <29.945601,-84.482903,-35.136902>, <0.072703,0.987902,-0.136983>
}
   smooth_triangle{ <32.720901,-84.371399,-33.053600>, <-0.057102,-0.987693,0.145605>
 <32.056999,-84.202003,-32.163898>, <-0.057626,-0.987793,0.144721>
 <31.324699,-84.399902,-33.847301>, <-0.065712,-0.987863,0.140744>
}
   smooth_triangle{ <32.720901,-84.371399,-33.053600>, <0.057102,0.987693,-0.145605>
 <31.324699,-84.399902,-33.847301>, <0.065712,0.987863,-0.140744>
 <32.056999,-84.202003,-32.163898>, <0.057626,0.987793,-0.144721>
}
   smooth_triangle{ <30.716400,-84.226997,-32.917000>, <-0.065898,-0.987936,0.140140>
 <31.324699,-84.399902,-33.847301>, <-0.065712,-0.987863,0.140744>
 <32.056999,-84.202003,-32.163898>, <-0.057626,-0.987793,0.144721>
}
   smooth_triangle{ <30.716400,-84.226997,-32.917000>, <0.065898,0.987936,-0.140140>
 <32.056999,-84.202003,-32.163898>, <0.057626,0.987793,-0.144721>
 <31.324699,-84.399902,-33.847301>, <0.065712,0.987863,-0.140744>
}
   smooth_triangle{ <32.056999,-84.202003,-32.163898>, <-0.057626,-0.987793,0.144721>
 <31.264999,-84.000702,-31.103701>, <-0.058381,-0.987906,0.143646>
 <30.716400,-84.226997,-32.917000>, <-0.065898,-0.987936,0.140140>
}
   smooth_triangle{ <32.056999,-84.202003,-32.163898>, <0.057626,0.987793,-0.144721>
 <30.716400,-84.226997,-32.917000>, <0.065898,0.987936,-0.140140>
 <31.264999,-84.000702,-31.103701>, <0.058381,0.987906,-0.143646>
}
   smooth_triangle{ <29.991400,-84.021797,-31.810499>, <-0.066125,-0.988028,0.139384>
 <30.716400,-84.226997,-32.917000>, <-0.065898,-0.987936,0.140140>
 <31.264999,-84.000702,-31.103701>, <-0.058381,-0.987906,0.143646>
}
   smooth_triangle{ <29.991400,-84.021797,-31.810499>, <0.066125,0.988028,-0.139384>
 <31.264999,-84.000702,-31.103701>, <0.058381,0.987906,-0.143646>
 <30.716400,-84.226997,-32.917000>, <0.065898,0.987936,-0.140140>
}
   smooth_triangle{ <31.324699,-84.399902,-33.847301>, <-0.065712,-0.987863,0.140744>
 <30.716400,-84.226997,-32.917000>, <-0.065898,-0.987936,0.140140>
 <29.732300,-84.414101,-34.754002>, <-0.072473,-0.987937,0.136849>
}
   smooth_triangle{ <31.324699,-84.399902,-33.847301>, <0.065712,0.987863,-0.140744>
 <29.732300,-84.414101,-34.754002>, <0.072473,0.987937,-0.136849>
 <30.716400,-84.226997,-32.917000>, <0.065898,0.987936,-0.140140>
}
   smooth_triangle{ <29.186600,-84.238602,-33.776100>, <-0.072456,-0.987978,0.136563>
 <29.732300,-84.414101,-34.754002>, <-0.072473,-0.987937,0.136849>
 <30.716400,-84.226997,-32.917000>, <-0.065898,-0.987936,0.140140>
}
   smooth_triangle{ <29.186600,-84.238602,-33.776100>, <0.072456,0.987978,-0.136563>
 <30.716400,-84.226997,-32.917000>, <0.065898,0.987936,-0.140140>
 <29.732300,-84.414101,-34.754002>, <0.072473,0.987937,-0.136849>
}
   smooth_triangle{ <30.716400,-84.226997,-32.917000>, <-0.065898,-0.987936,0.140140>
 <29.991400,-84.021797,-31.810499>, <-0.066125,-0.988028,0.139384>
 <29.186600,-84.238602,-33.776100>, <-0.072456,-0.987978,0.136563>
}
   smooth_triangle{ <30.716400,-84.226997,-32.917000>, <0.065898,0.987936,-0.140140>
 <29.186600,-84.238602,-33.776100>, <0.072456,0.987978,-0.136563>
 <29.991400,-84.021797,-31.810499>, <0.066125,0.988028,-0.139384>
}
   smooth_triangle{ <28.537300,-84.030800,-32.615398>, <-0.072477,-0.988063,0.135933>
 <29.186600,-84.238602,-33.776100>, <-0.072456,-0.987978,0.136563>
 <29.991400,-84.021797,-31.810499>, <-0.066125,-0.988028,0.139384>
}
   smooth_triangle{ <28.537300,-84.030800,-32.615398>, <0.072477,0.988063,-0.135933>
 <29.991400,-84.021797,-31.810499>, <0.066125,0.988028,-0.139384>
 <29.186600,-84.238602,-33.776100>, <0.072456,0.987978,-0.136563>
}
   smooth_triangle{ <34.886200,-83.847900,-29.083599>, <-0.020075,-0.985437,0.168853>
 <32.825199,-83.468903,-27.116899>, <-0.048400,-0.988798,0.141192>
 <34.782200,-83.855698,-29.142099>, <-0.029506,-0.986594,0.160503>
}
   smooth_triangle{ <34.886200,-83.847900,-29.083599>, <0.048888,0.989104,-0.138862>
 <34.782200,-83.855698,-29.142099>, <0.029506,0.986594,-0.160503>
 <32.825199,-83.468903,-27.116899>, <0.051220,0.989103,-0.138031>
}
   smooth_triangle{ <32.733299,-83.470596,-27.169300>, <-0.037453,-0.987532,0.152896>
 <34.782200,-83.855698,-29.142099>, <-0.029506,-0.986594,0.160503>
 <32.825199,-83.468903,-27.116899>, <-0.048400,-0.988798,0.141192>
}
   smooth_triangle{ <32.733299,-83.470596,-27.169300>, <0.060391,0.989891,-0.128332>
 <32.825199,-83.468903,-27.116899>, <0.051220,0.989103,-0.138031>
 <34.782200,-83.855698,-29.142099>, <0.029506,0.986594,-0.160503>
}
   smooth_triangle{ <34.782200,-83.855698,-29.142099>, <-0.029506,-0.986594,0.160503>
 <32.733299,-83.470596,-27.169300>, <-0.037453,-0.987532,0.152896>
 <34.472801,-83.875999,-29.315500>, <-0.028905,-0.986348,0.162117>
}
   smooth_triangle{ <34.782200,-83.855698,-29.142099>, <0.029506,0.986594,-0.160503>
 <34.472801,-83.875999,-29.315500>, <0.028905,0.986348,-0.162117>
 <32.733299,-83.470596,-27.169300>, <0.060391,0.989891,-0.128332>
}
   smooth_triangle{ <32.458900,-83.490303,-27.322300>, <-0.029878,-0.986517,0.160905>
 <34.472801,-83.875999,-29.315500>, <-0.028905,-0.986348,0.162117>
 <32.733299,-83.470596,-27.169300>, <-0.037453,-0.987532,0.152896>
}
   smooth_triangle{ <32.458900,-83.490303,-27.322300>, <0.029878,0.986517,-0.160905>
 <32.733299,-83.470596,-27.169300>, <0.060391,0.989891,-0.128332>
 <34.472801,-83.875999,-29.315500>, <0.028905,0.986348,-0.162117>
}
   smooth_triangle{ <34.472801,-83.875999,-29.315500>, <-0.028905,-0.986348,0.162117>
 <32.458900,-83.490303,-27.322300>, <-0.029878,-0.986517,0.160905>
 <33.962200,-83.904800,-29.601200>, <-0.036923,-0.987094,0.155828>
}
   smooth_triangle{ <34.472801,-83.875999,-29.315500>, <0.028905,0.986348,-0.162117>
 <33.962200,-83.904800,-29.601200>, <0.036923,0.987094,-0.155828>
 <32.458900,-83.490303,-27.322300>, <0.029878,0.986517,-0.160905>
}
   smooth_triangle{ <32.006401,-83.512100,-27.574800>, <-0.040539,-0.987527,0.152139>
 <33.962200,-83.904800,-29.601200>, <-0.036923,-0.987094,0.155828>
 <32.458900,-83.490303,-27.322300>, <-0.029878,-0.986517,0.160905>
}
   smooth_triangle{ <32.006401,-83.512100,-27.574800>, <0.040539,0.987527,-0.152139>
 <32.458900,-83.490303,-27.322300>, <0.029878,0.986517,-0.160905>
 <33.962200,-83.904800,-29.601200>, <0.036923,0.987094,-0.155828>
}
   smooth_triangle{ <33.962200,-83.904800,-29.601200>, <-0.036923,-0.987094,0.155828>
 <32.006401,-83.512100,-27.574800>, <-0.040539,-0.987527,0.152139>
 <33.254700,-83.938004,-29.996300>, <-0.043843,-0.987472,0.151580>
}
   smooth_triangle{ <33.962200,-83.904800,-29.601200>, <0.036923,0.987094,-0.155828>
 <33.254700,-83.938004,-29.996300>, <0.043843,0.987472,-0.151580>
 <32.006401,-83.512100,-27.574800>, <0.040539,0.987527,-0.152139>
}
   smooth_triangle{ <31.379101,-83.537201,-27.923599>, <-0.046891,-0.987873,0.148014>
 <33.254700,-83.938004,-29.996300>, <-0.043843,-0.987472,0.151580>
 <32.006401,-83.512100,-27.574800>, <-0.040539,-0.987527,0.152139>
}
   smooth_triangle{ <31.379101,-83.537201,-27.923599>, <0.046891,0.987873,-0.148014>
 <32.006401,-83.512100,-27.574800>, <0.040539,0.987527,-0.152139>
 <33.254700,-83.938004,-29.996300>, <0.043843,0.987472,-0.151580>
}
   smooth_triangle{ <31.947201,-83.305099,-26.268700>, <0.058037,0.989593,-0.131673>
 <32.825199,-83.468903,-27.116899>, <0.051220,0.989103,-0.138031>
 <32.733299,-83.470596,-27.169300>, <0.060391,0.989891,-0.128332>
}
   smooth_triangle{ <32.733299,-83.470596,-27.169300>, <0.060391,0.989891,-0.128332>
 <31.860300,-83.306602,-26.318501>, <0.058143,0.989584,-0.131691>
 <31.947201,-83.305099,-26.268700>, <0.058037,0.989593,-0.131673>
}
   smooth_triangle{ <32.733299,-83.470596,-27.169300>, <-0.037453,-0.987532,0.152896>
 <31.860300,-83.306602,-26.318501>, <-0.043468,-0.988267,0.146418>
 <32.458900,-83.490303,-27.322300>, <-0.029878,-0.986517,0.160905>
}
   smooth_triangle{ <32.733299,-83.470596,-27.169300>, <0.060391,0.989891,-0.128332>
 <32.458900,-83.490303,-27.322300>, <0.029878,0.986517,-0.160905>
 <31.860300,-83.306602,-26.318501>, <0.058143,0.989584,-0.131691>
}
   smooth_triangle{ <31.600901,-83.324402,-26.464001>, <-0.032221,-0.986794,0.158743>
 <32.458900,-83.490303,-27.322300>, <-0.029878,-0.986517,0.160905>
 <31.860300,-83.306602,-26.318501>, <-0.043468,-0.988267,0.146418>
}
   smooth_triangle{ <31.600901,-83.324402,-26.464001>, <0.032221,0.986794,-0.158743>
 <31.860300,-83.306602,-26.318501>, <0.058143,0.989584,-0.131691>
 <32.458900,-83.490303,-27.322300>, <0.029878,0.986517,-0.160905>
}
   smooth_triangle{ <32.458900,-83.490303,-27.322300>, <-0.029878,-0.986517,0.160905>
 <31.600901,-83.324402,-26.464001>, <-0.032221,-0.986794,0.158743>
 <32.006401,-83.512100,-27.574800>, <-0.040539,-0.987527,0.152139>
}
   smooth_triangle{ <32.458900,-83.490303,-27.322300>, <0.029878,0.986517,-0.160905>
 <32.006401,-83.512100,-27.574800>, <0.040539,0.987527,-0.152139>
 <31.600901,-83.324402,-26.464001>, <0.032221,0.986794,-0.158743>
}
   smooth_triangle{ <31.173100,-83.344200,-26.704399>, <-0.042169,-0.987758,0.150184>
 <32.006401,-83.512100,-27.574800>, <-0.040539,-0.987527,0.152139>
 <31.600901,-83.324402,-26.464001>, <-0.032221,-0.986794,0.158743>
}
   smooth_triangle{ <31.173100,-83.344200,-26.704399>, <0.042169,0.987758,-0.150184>
 <31.600901,-83.324402,-26.464001>, <0.032221,0.986794,-0.158743>
 <32.006401,-83.512100,-27.574800>, <0.040539,0.987527,-0.152139>
}
   smooth_triangle{ <32.006401,-83.512100,-27.574800>, <-0.040539,-0.987527,0.152139>
 <31.173100,-83.344200,-26.704399>, <-0.042169,-0.987758,0.150184>
 <31.379101,-83.537201,-27.923599>, <-0.046891,-0.987873,0.148014>
}
   smooth_triangle{ <32.006401,-83.512100,-27.574800>, <0.040539,0.987527,-0.152139>
 <31.379101,-83.537201,-27.923599>, <0.046891,0.987873,-0.148014>
 <31.173100,-83.344200,-26.704399>, <0.042169,0.987758,-0.150184>
}
   smooth_triangle{ <30.580400,-83.366997,-27.036800>, <-0.047525,-0.988112,0.146203>
 <31.379101,-83.537201,-27.923599>, <-0.046891,-0.987873,0.148014>
 <31.173100,-83.344200,-26.704399>, <-0.042169,-0.987758,0.150184>
}
   smooth_triangle{ <30.580400,-83.366997,-27.036800>, <0.047525,0.988112,-0.146203>
 <31.173100,-83.344200,-26.704399>, <0.042169,0.987758,-0.150184>
 <31.379101,-83.537201,-27.923599>, <0.046891,0.987873,-0.148014>
}
   smooth_triangle{ <31.947201,-83.305099,-26.268700>, <-0.058226,-0.989609,0.131468>
 <31.589300,-83.237297,-25.918501>, <-0.058254,-0.989476,0.132450>
 <31.860300,-83.306602,-26.318501>, <-0.043468,-0.988267,0.146418>
}
   smooth_triangle{ <31.947201,-83.305099,-26.268700>, <0.058037,0.989593,-0.131673>
 <31.860300,-83.306602,-26.318501>, <0.058143,0.989584,-0.131691>
 <31.589300,-83.237297,-25.918501>, <0.058310,0.989476,-0.132429>
}
   smooth_triangle{ <31.504400,-83.238800,-25.967199>, <-0.038681,-0.987651,0.151817>
 <31.860300,-83.306602,-26.318501>, <-0.043468,-0.988267,0.146418>
 <31.589300,-83.237297,-25.918501>, <-0.058254,-0.989476,0.132450>
}
   smooth_triangle{ <31.504400,-83.238800,-25.967199>, <0.058795,0.989498,-0.132047>
 <31.589300,-83.237297,-25.918501>, <0.058310,0.989476,-0.132429>
 <31.860300,-83.306602,-26.318501>, <0.058143,0.989584,-0.131691>
}
   smooth_triangle{ <31.860300,-83.306602,-26.318501>, <-0.043468,-0.988267,0.146418>
 <31.504400,-83.238800,-25.967199>, <-0.038681,-0.987651,0.151817>
 <31.600901,-83.324402,-26.464001>, <-0.032221,-0.986794,0.158743>
}
   smooth_triangle{ <31.860300,-83.306602,-26.318501>, <0.058143,0.989584,-0.131691>
 <31.600901,-83.324402,-26.464001>, <0.032221,0.986794,-0.158743>
 <31.504400,-83.238800,-25.967199>, <0.058795,0.989498,-0.132047>
}
   smooth_triangle{ <31.250900,-83.255997,-26.110001>, <-0.032867,-0.986874,0.158112>
 <31.600901,-83.324402,-26.464001>, <-0.032221,-0.986794,0.158743>
 <31.504400,-83.238800,-25.967199>, <-0.038681,-0.987651,0.151817>
}
   smooth_triangle{ <31.250900,-83.255997,-26.110001>, <0.032867,0.986874,-0.158112>
 <31.504400,-83.238800,-25.967199>, <0.058795,0.989498,-0.132047>
 <31.600901,-83.324402,-26.464001>, <0.032221,0.986794,-0.158743>
}
   smooth_triangle{ <31.301901,-83.181900,-25.632401>, <0.058145,0.989354,-0.133405>
 <31.589300,-83.237297,-25.918501>, <0.058310,0.989476,-0.132429>
 <31.504400,-83.238800,-25.967199>, <0.058795,0.989498,-0.132047>
}
   smooth_triangle{ <31.504400,-83.238800,-25.967199>, <0.058795,0.989498,-0.132047>
 <31.218399,-83.183502,-25.680500>, <0.059042,0.989423,-0.132499>
 <31.301901,-83.181900,-25.632401>, <0.058145,0.989354,-0.133405>
}
   smooth_triangle{ <31.504400,-83.238800,-25.967199>, <-0.038681,-0.987651,0.151817>
 <31.218399,-83.183502,-25.680500>, <-0.044437,-0.988171,0.146777>
 <31.250900,-83.255997,-26.110001>, <-0.032867,-0.986874,0.158112>
}
   smooth_triangle{ <31.504400,-83.238800,-25.967199>, <0.058795,0.989498,-0.132047>
 <31.250900,-83.255997,-26.110001>, <0.032867,0.986874,-0.158112>
 <31.218399,-83.183502,-25.680500>, <0.059042,0.989423,-0.132499>
}
   smooth_triangle{ <30.969801,-83.200500,-25.821699>, <-0.032662,-0.986883,0.158101>
 <31.250900,-83.255997,-26.110001>, <-0.032867,-0.986874,0.158112>
 <31.218399,-83.183502,-25.680500>, <-0.044437,-0.988171,0.146777>
}
   smooth_triangle{ <30.969801,-83.200500,-25.821699>, <0.032662,0.986883,-0.158101>
 <31.218399,-83.183502,-25.680500>, <0.059042,0.989423,-0.132499>
 <31.250900,-83.255997,-26.110001>, <0.032867,0.986874,-0.158112>
}
   smooth_triangle{ <31.600901,-83.324402,-26.464001>, <-0.032221,-0.986794,0.158743>
 <31.250900,-83.255997,-26.110001>, <-0.032867,-0.986874,0.158112>
 <31.173100,-83.344200,-26.704399>, <-0.042169,-0.987758,0.150184>
}
   smooth_triangle{ <31.600901,-83.324402,-26.464001>, <0.032221,0.986794,-0.158743>
 <31.173100,-83.344200,-26.704399>, <0.042169,0.987758,-0.150184>
 <31.250900,-83.255997,-26.110001>, <0.032867,0.986874,-0.158112>
}
   smooth_triangle{ <30.833401,-83.275398,-26.346500>, <-0.042187,-0.987887,0.149331>
 <31.173100,-83.344200,-26.704399>, <-0.042169,-0.987758,0.150184>
 <31.250900,-83.255997,-26.110001>, <-0.032867,-0.986874,0.158112>
}
   smooth_triangle{ <30.833401,-83.275398,-26.346500>, <0.042187,0.987887,-0.149331>
 <31.250900,-83.255997,-26.110001>, <0.032867,0.986874,-0.158112>
 <31.173100,-83.344200,-26.704399>, <0.042169,0.987758,-0.150184>
}
   smooth_triangle{ <31.250900,-83.255997,-26.110001>, <-0.032867,-0.986874,0.158112>
 <30.969801,-83.200500,-25.821699>, <-0.032662,-0.986883,0.158101>
 <30.833401,-83.275398,-26.346500>, <-0.042187,-0.987887,0.149331>
}
   smooth_triangle{ <31.250900,-83.255997,-26.110001>, <0.032867,0.986874,-0.158112>
 <30.833401,-83.275398,-26.346500>, <0.042187,0.987887,-0.149331>
 <30.969801,-83.200500,-25.821699>, <0.032662,0.986883,-0.158101>
}
   smooth_triangle{ <30.560400,-83.220001,-26.055700>, <-0.041811,-0.987958,0.148966>
 <30.833401,-83.275398,-26.346500>, <-0.042187,-0.987887,0.149331>
 <30.969801,-83.200500,-25.821699>, <-0.032662,-0.986883,0.158101>
}
   smooth_triangle{ <30.560400,-83.220001,-26.055700>, <0.041811,0.987958,-0.148966>
 <30.969801,-83.200500,-25.821699>, <0.032662,0.986883,-0.158101>
 <30.833401,-83.275398,-26.346500>, <0.042187,0.987887,-0.149331>
}
   smooth_triangle{ <31.173100,-83.344200,-26.704399>, <-0.042169,-0.987758,0.150184>
 <30.833401,-83.275398,-26.346500>, <-0.042187,-0.987887,0.149331>
 <30.580400,-83.366997,-27.036800>, <-0.047525,-0.988112,0.146203>
}
   smooth_triangle{ <31.173100,-83.344200,-26.704399>, <0.042169,0.987758,-0.150184>
 <30.580400,-83.366997,-27.036800>, <0.047525,0.988112,-0.146203>
 <30.833401,-83.275398,-26.346500>, <0.042187,0.987887,-0.149331>
}
   smooth_triangle{ <30.254801,-83.297997,-26.673599>, <-0.047287,-0.988311,0.144934>
 <30.580400,-83.366997,-27.036800>, <-0.047525,-0.988112,0.146203>
 <30.833401,-83.275398,-26.346500>, <-0.042187,-0.987887,0.149331>
}
   smooth_triangle{ <30.254801,-83.297997,-26.673599>, <0.047287,0.988311,-0.144934>
 <30.833401,-83.275398,-26.346500>, <0.042187,0.987887,-0.149331>
 <30.580400,-83.366997,-27.036800>, <0.047525,0.988112,-0.146203>
}
   smooth_triangle{ <30.833401,-83.275398,-26.346500>, <-0.042187,-0.987887,0.149331>
 <30.560400,-83.220001,-26.055700>, <-0.041811,-0.987958,0.148966>
 <30.254801,-83.297997,-26.673599>, <-0.047287,-0.988311,0.144934>
}
   smooth_triangle{ <30.833401,-83.275398,-26.346500>, <0.042187,0.987887,-0.149331>
 <30.254801,-83.297997,-26.673599>, <0.047287,0.988311,-0.144934>
 <30.560400,-83.220001,-26.055700>, <0.041811,0.987958,-0.148966>
}
   smooth_triangle{ <29.993401,-83.242699,-26.380400>, <-0.046769,-0.988456,0.144107>
 <30.254801,-83.297997,-26.673599>, <-0.047287,-0.988311,0.144934>
 <30.560400,-83.220001,-26.055700>, <-0.041811,-0.987958,0.148966>
}
   smooth_triangle{ <29.993401,-83.242699,-26.380400>, <0.046769,0.988456,-0.144107>
 <30.560400,-83.220001,-26.055700>, <0.041811,0.987958,-0.148966>
 <30.254801,-83.297997,-26.673599>, <0.047287,0.988311,-0.144934>
}
   smooth_triangle{ <33.254700,-83.938004,-29.996300>, <-0.043843,-0.987472,0.151580>
 <32.316898,-83.737602,-28.959999>, <-0.048090,-0.987773,0.148296>
 <32.354198,-83.971199,-30.498100>, <-0.050848,-0.987719,0.147735>
}
   smooth_triangle{ <33.254700,-83.938004,-29.996300>, <0.043843,0.987472,-0.151580>
 <32.354198,-83.971199,-30.498100>, <0.050848,0.987719,-0.147735>
 <32.316898,-83.737602,-28.959999>, <0.048090,0.987773,-0.148296>
}
   smooth_triangle{ <31.453501,-83.763100,-29.415199>, <-0.052161,-0.987889,0.146130>
 <32.354198,-83.971199,-30.498100>, <-0.050848,-0.987719,0.147735>
 <32.316898,-83.737602,-28.959999>, <-0.048090,-0.987773,0.148296>
}
   smooth_triangle{ <31.453501,-83.763100,-29.415199>, <0.052161,0.987889,-0.146130>
 <32.316898,-83.737602,-28.959999>, <0.048090,0.987773,-0.148296>
 <32.354198,-83.971199,-30.498100>, <0.050848,0.987719,-0.147735>
}
   smooth_triangle{ <32.354198,-83.971199,-30.498100>, <-0.050848,-0.987719,0.147735>
 <31.453501,-83.763100,-29.415199>, <-0.052161,-0.987889,0.146130>
 <31.264999,-84.000702,-31.103701>, <-0.058381,-0.987906,0.143646>
}
   smooth_triangle{ <32.354198,-83.971199,-30.498100>, <0.050848,0.987719,-0.147735>
 <31.264999,-84.000702,-31.103701>, <0.058381,0.987906,-0.143646>
 <31.453501,-83.763100,-29.415199>, <0.052161,0.987889,-0.146130>
}
   smooth_triangle{ <30.424200,-83.787804,-29.979900>, <-0.059094,-0.988055,0.142321>
 <31.264999,-84.000702,-31.103701>, <-0.058381,-0.987906,0.143646>
 <31.453501,-83.763100,-29.415199>, <-0.052161,-0.987889,0.146130>
}
   smooth_triangle{ <30.424200,-83.787804,-29.979900>, <0.059094,0.988055,-0.142321>
 <31.453501,-83.763100,-29.415199>, <0.052161,0.987889,-0.146130>
 <31.264999,-84.000702,-31.103701>, <0.058381,0.987906,-0.143646>
}
   smooth_triangle{ <32.316898,-83.737602,-28.959999>, <-0.048090,-0.987773,0.148296>
 <31.379101,-83.537201,-27.923599>, <-0.046891,-0.987873,0.148014>
 <31.453501,-83.763100,-29.415199>, <-0.052161,-0.987889,0.146130>
}
   smooth_triangle{ <32.316898,-83.737602,-28.959999>, <0.048090,0.987773,-0.148296>
 <31.453501,-83.763100,-29.415199>, <0.052161,0.987889,-0.146130>
 <31.379101,-83.537201,-27.923599>, <0.046891,0.987873,-0.148014>
}
   smooth_triangle{ <30.580500,-83.562302,-28.365999>, <-0.053030,-0.988112,0.144302>
 <31.453501,-83.763100,-29.415199>, <-0.052161,-0.987889,0.146130>
 <31.379101,-83.537201,-27.923599>, <-0.046891,-0.987873,0.148014>
}
   smooth_triangle{ <30.580500,-83.562302,-28.365999>, <0.053030,0.988112,-0.144302>
 <31.379101,-83.537201,-27.923599>, <0.046891,0.987873,-0.148014>
 <31.453501,-83.763100,-29.415199>, <0.052161,0.987889,-0.146130>
}
   smooth_triangle{ <31.453501,-83.763100,-29.415199>, <-0.052161,-0.987889,0.146130>
 <30.580500,-83.562302,-28.365999>, <-0.053030,-0.988112,0.144302>
 <30.424200,-83.787804,-29.979900>, <-0.059094,-0.988055,0.142321>
}
   smooth_triangle{ <31.453501,-83.763100,-29.415199>, <0.052161,0.987889,-0.146130>
 <30.424200,-83.787804,-29.979900>, <0.059094,0.988055,-0.142321>
 <30.580500,-83.562302,-28.365999>, <0.053030,0.988112,-0.144302>
}
   smooth_triangle{ <29.613899,-83.584198,-28.899200>, <-0.059492,-0.988272,0.140640>
 <30.424200,-83.787804,-29.979900>, <-0.059094,-0.988055,0.142321>
 <30.580500,-83.562302,-28.365999>, <-0.053030,-0.988112,0.144302>
}
   smooth_triangle{ <29.613899,-83.584198,-28.899200>, <0.059492,0.988272,-0.140640>
 <30.580500,-83.562302,-28.365999>, <0.053030,0.988112,-0.144302>
 <30.424200,-83.787804,-29.979900>, <0.059094,0.988055,-0.142321>
}
   smooth_triangle{ <31.379101,-83.537201,-27.923599>, <-0.046891,-0.987873,0.148014>
 <30.580400,-83.366997,-27.036800>, <-0.047525,-0.988112,0.146203>
 <30.580500,-83.562302,-28.365999>, <-0.053030,-0.988112,0.144302>
}
   smooth_triangle{ <31.379101,-83.537201,-27.923599>, <0.046891,0.987873,-0.148014>
 <30.580500,-83.562302,-28.365999>, <0.053030,0.988112,-0.144302>
 <30.580400,-83.366997,-27.036800>, <0.047525,0.988112,-0.146203>
}
   smooth_triangle{ <29.825899,-83.390099,-27.459101>, <-0.053270,-0.988383,0.142343>
 <30.580500,-83.562302,-28.365999>, <-0.053030,-0.988112,0.144302>
 <30.580400,-83.366997,-27.036800>, <-0.047525,-0.988112,0.146203>
}
   smooth_triangle{ <29.825899,-83.390099,-27.459101>, <0.053270,0.988383,-0.142343>
 <30.580400,-83.366997,-27.036800>, <0.047525,0.988112,-0.146203>
 <30.580500,-83.562302,-28.365999>, <0.053030,0.988112,-0.144302>
}
   smooth_triangle{ <30.580500,-83.562302,-28.365999>, <-0.053030,-0.988112,0.144302>
 <29.825899,-83.390099,-27.459101>, <-0.053270,-0.988383,0.142343>
 <29.613899,-83.584198,-28.899200>, <-0.059492,-0.988272,0.140640>
}
   smooth_triangle{ <30.580500,-83.562302,-28.365999>, <0.053030,0.988112,-0.144302>
 <29.613899,-83.584198,-28.899200>, <0.059492,0.988272,-0.140640>
 <29.825899,-83.390099,-27.459101>, <0.053270,0.988383,-0.142343>
}
   smooth_triangle{ <28.913401,-83.410500,-27.968599>, <-0.059256,-0.988571,0.138620>
 <29.613899,-83.584198,-28.899200>, <-0.059492,-0.988272,0.140640>
 <29.825899,-83.390099,-27.459101>, <-0.053270,-0.988383,0.142343>
}
   smooth_triangle{ <28.913401,-83.410500,-27.968599>, <0.059256,0.988571,-0.138620>
 <29.825899,-83.390099,-27.459101>, <0.053270,0.988383,-0.142343>
 <29.613899,-83.584198,-28.899200>, <0.059492,0.988272,-0.140640>
}
   smooth_triangle{ <30.580400,-83.366997,-27.036800>, <-0.047525,-0.988112,0.146203>
 <30.254801,-83.297997,-26.673599>, <-0.047287,-0.988311,0.144934>
 <29.825899,-83.390099,-27.459101>, <-0.053270,-0.988383,0.142343>
}
   smooth_triangle{ <30.580400,-83.366997,-27.036800>, <0.047525,0.988112,-0.146203>
 <29.825899,-83.390099,-27.459101>, <0.053270,0.988383,-0.142343>
 <30.254801,-83.297997,-26.673599>, <0.047287,0.988311,-0.144934>
}
   smooth_triangle{ <29.518900,-83.320801,-27.089899>, <-0.052758,-0.988653,0.140646>
 <29.825899,-83.390099,-27.459101>, <-0.053270,-0.988383,0.142343>
 <30.254801,-83.297997,-26.673599>, <-0.047287,-0.988311,0.144934>
}
   smooth_triangle{ <29.518900,-83.320801,-27.089899>, <0.052758,0.988653,-0.140646>
 <30.254801,-83.297997,-26.673599>, <0.047287,0.988311,-0.144934>
 <29.825899,-83.390099,-27.459101>, <0.053270,0.988383,-0.142343>
}
   smooth_triangle{ <30.254801,-83.297997,-26.673599>, <-0.047287,-0.988311,0.144934>
 <29.993401,-83.242699,-26.380400>, <-0.046769,-0.988456,0.144107>
 <29.518900,-83.320801,-27.089899>, <-0.052758,-0.988653,0.140646>
}
   smooth_triangle{ <30.254801,-83.297997,-26.673599>, <0.047287,0.988311,-0.144934>
 <29.518900,-83.320801,-27.089899>, <0.052758,0.988653,-0.140646>
 <29.993401,-83.242699,-26.380400>, <0.046769,0.988456,-0.144107>
}
   smooth_triangle{ <29.272699,-83.265999,-26.794001>, <-0.051861,-0.988893,0.139288>
 <29.518900,-83.320801,-27.089899>, <-0.052758,-0.988653,0.140646>
 <29.993401,-83.242699,-26.380400>, <-0.046769,-0.988456,0.144107>
}
   smooth_triangle{ <29.272699,-83.265999,-26.794001>, <0.051861,0.988893,-0.139288>
 <29.993401,-83.242699,-26.380400>, <0.046769,0.988456,-0.144107>
 <29.518900,-83.320801,-27.089899>, <0.052758,0.988653,-0.140646>
}
   smooth_triangle{ <29.825899,-83.390099,-27.459101>, <-0.053270,-0.988383,0.142343>
 <29.518900,-83.320801,-27.089899>, <-0.052758,-0.988653,0.140646>
 <28.913401,-83.410500,-27.968599>, <-0.059256,-0.988571,0.138620>
}
   smooth_triangle{ <29.825899,-83.390099,-27.459101>, <0.053270,0.988383,-0.142343>
 <28.913401,-83.410500,-27.968599>, <0.059256,0.988571,-0.138620>
 <29.518900,-83.320801,-27.089899>, <0.052758,0.988653,-0.140646>
}
   smooth_triangle{ <28.629101,-83.341301,-27.593000>, <-0.058257,-0.988936,0.136422>
 <28.913401,-83.410500,-27.968599>, <-0.059256,-0.988571,0.138620>
 <29.518900,-83.320801,-27.089899>, <-0.052758,-0.988653,0.140646>
}
   smooth_triangle{ <28.629101,-83.341301,-27.593000>, <0.058257,0.988936,-0.136422>
 <29.518900,-83.320801,-27.089899>, <0.052758,0.988653,-0.140646>
 <28.913401,-83.410500,-27.968599>, <0.059256,0.988571,-0.138620>
}
   smooth_triangle{ <29.518900,-83.320801,-27.089899>, <-0.052758,-0.988653,0.140646>
 <29.272699,-83.265999,-26.794001>, <-0.051861,-0.988893,0.139288>
 <28.629101,-83.341301,-27.593000>, <-0.058257,-0.988936,0.136422>
}
   smooth_triangle{ <29.518900,-83.320801,-27.089899>, <0.052758,0.988653,-0.140646>
 <28.629101,-83.341301,-27.593000>, <0.058257,0.988936,-0.136422>
 <29.272699,-83.265999,-26.794001>, <0.051861,0.988893,-0.139288>
}
   smooth_triangle{ <28.402000,-83.287399,-27.294901>, <-0.057313,-0.989211,0.134820>
 <28.629101,-83.341301,-27.593000>, <-0.058257,-0.988936,0.136422>
 <29.272699,-83.265999,-26.794001>, <-0.051861,-0.988893,0.139288>
}
   smooth_triangle{ <28.402000,-83.287399,-27.294901>, <0.057313,0.989211,-0.134820>
 <29.272699,-83.265999,-26.794001>, <0.051861,0.988893,-0.139288>
 <28.629101,-83.341301,-27.593000>, <0.058257,0.988936,-0.136422>
}
   smooth_triangle{ <31.264999,-84.000702,-31.103701>, <-0.058381,-0.987906,0.143646>
 <30.424200,-83.787804,-29.979900>, <-0.059094,-0.988055,0.142321>
 <29.991400,-84.021797,-31.810499>, <-0.066125,-0.988028,0.139384>
}
   smooth_triangle{ <31.264999,-84.000702,-31.103701>, <0.058381,0.987906,-0.143646>
 <29.991400,-84.021797,-31.810499>, <0.066125,0.988028,-0.139384>
 <30.424200,-83.787804,-29.979900>, <0.059094,0.988055,-0.142321>
}
   smooth_triangle{ <29.222601,-83.805702,-30.640699>, <-0.066271,-0.988157,0.138394>
 <29.991400,-84.021797,-31.810499>, <-0.066125,-0.988028,0.139384>
 <30.424200,-83.787804,-29.979900>, <-0.059094,-0.988055,0.142321>
}
   smooth_triangle{ <29.222601,-83.805702,-30.640699>, <0.066271,0.988157,-0.138394>
 <30.424200,-83.787804,-29.979900>, <0.059094,0.988055,-0.142321>
 <29.991400,-84.021797,-31.810499>, <0.066125,0.988028,-0.139384>
}
   smooth_triangle{ <30.424200,-83.787804,-29.979900>, <-0.059094,-0.988055,0.142321>
 <29.613899,-83.584198,-28.899200>, <-0.059492,-0.988272,0.140640>
 <29.222601,-83.805702,-30.640699>, <-0.066271,-0.988157,0.138394>
}
   smooth_triangle{ <30.424200,-83.787804,-29.979900>, <0.059094,0.988055,-0.142321>
 <29.222601,-83.805702,-30.640699>, <0.066271,0.988157,-0.138394>
 <29.613899,-83.584198,-28.899200>, <0.059492,0.988272,-0.140640>
}
   smooth_triangle{ <28.483299,-83.599701,-29.520599>, <-0.066076,-0.988376,0.136921>
 <29.222601,-83.805702,-30.640699>, <-0.066271,-0.988157,0.138394>
 <29.613899,-83.584198,-28.899200>, <-0.059492,-0.988272,0.140640>
}
   smooth_triangle{ <28.483299,-83.599701,-29.520599>, <0.066076,0.988376,-0.136921>
 <29.613899,-83.584198,-28.899200>, <0.059492,0.988272,-0.140640>
 <29.222601,-83.805702,-30.640699>, <0.066271,0.988157,-0.138394>
}
   smooth_triangle{ <29.991400,-84.021797,-31.810499>, <-0.066125,-0.988028,0.139384>
 <29.222601,-83.805702,-30.640699>, <-0.066271,-0.988157,0.138394>
 <28.537300,-84.030800,-32.615398>, <-0.072477,-0.988063,0.135933>
}
   smooth_triangle{ <29.991400,-84.021797,-31.810499>, <0.066125,0.988028,-0.139384>
 <28.537300,-84.030800,-32.615398>, <0.072477,0.988063,-0.135933>
 <29.222601,-83.805702,-30.640699>, <0.066271,0.988157,-0.138394>
}
   smooth_triangle{ <27.850300,-83.812500,-31.392500>, <-0.072552,-0.988191,0.134963>
 <28.537300,-84.030800,-32.615398>, <-0.072477,-0.988063,0.135933>
 <29.222601,-83.805702,-30.640699>, <-0.066271,-0.988157,0.138394>
}
   smooth_triangle{ <27.850300,-83.812500,-31.392500>, <0.072552,0.988191,-0.134963>
 <29.222601,-83.805702,-30.640699>, <0.066271,0.988157,-0.138394>
 <28.537300,-84.030800,-32.615398>, <0.072477,0.988063,-0.135933>
}
   smooth_triangle{ <29.222601,-83.805702,-30.640699>, <-0.066271,-0.988157,0.138394>
 <28.483299,-83.599701,-29.520599>, <-0.066076,-0.988376,0.136921>
 <27.850300,-83.812500,-31.392500>, <-0.072552,-0.988191,0.134963>
}
   smooth_triangle{ <29.222601,-83.805702,-30.640699>, <0.066271,0.988157,-0.138394>
 <27.850300,-83.812500,-31.392500>, <0.072552,0.988191,-0.134963>
 <28.483299,-83.599701,-29.520599>, <0.066076,0.988376,-0.136921>
}
   smooth_triangle{ <27.191799,-83.605797,-30.227301>, <-0.073060,-0.988405,0.133111>
 <27.850300,-83.812500,-31.392500>, <-0.072552,-0.988191,0.134963>
 <28.483299,-83.599701,-29.520599>, <-0.066076,-0.988376,0.136921>
}
   smooth_triangle{ <27.191799,-83.605797,-30.227301>, <0.073060,0.988405,-0.133111>
 <28.483299,-83.599701,-29.520599>, <0.066076,0.988376,-0.136921>
 <27.850300,-83.812500,-31.392500>, <0.072552,0.988191,-0.134963>
}
   smooth_triangle{ <29.613899,-83.584198,-28.899200>, <-0.059492,-0.988272,0.140640>
 <28.913401,-83.410500,-27.968599>, <-0.059256,-0.988571,0.138620>
 <28.483299,-83.599701,-29.520599>, <-0.066076,-0.988376,0.136921>
}
   smooth_triangle{ <29.613899,-83.584198,-28.899200>, <0.059492,0.988272,-0.140640>
 <28.483299,-83.599701,-29.520599>, <0.066076,0.988376,-0.136921>
 <28.913401,-83.410500,-27.968599>, <0.059256,0.988571,-0.138620>
}
   smooth_triangle{ <27.846300,-83.425499,-28.563200>, <-0.065402,-0.988696,0.134917>
 <28.483299,-83.599701,-29.520599>, <-0.066076,-0.988376,0.136921>
 <28.913401,-83.410500,-27.968599>, <-0.059256,-0.988571,0.138620>
}
   smooth_triangle{ <27.846300,-83.425499,-28.563200>, <0.065402,0.988696,-0.134917>
 <28.913401,-83.410500,-27.968599>, <0.059256,0.988571,-0.138620>
 <28.483299,-83.599701,-29.520599>, <0.066076,0.988376,-0.136921>
}
   smooth_triangle{ <28.913401,-83.410500,-27.968599>, <-0.059256,-0.988571,0.138620>
 <28.629101,-83.341301,-27.593000>, <-0.058257,-0.988936,0.136422>
 <27.846300,-83.425499,-28.563200>, <-0.065402,-0.988696,0.134917>
}
   smooth_triangle{ <28.913401,-83.410500,-27.968599>, <0.059256,0.988571,-0.138620>
 <27.846300,-83.425499,-28.563200>, <0.065402,0.988696,-0.134917>
 <28.629101,-83.341301,-27.593000>, <0.058257,0.988936,-0.136422>
}
   smooth_triangle{ <27.589100,-83.356903,-28.180799>, <-0.064186,-0.989109,0.132452>
 <27.846300,-83.425499,-28.563200>, <-0.065402,-0.988696,0.134917>
 <28.629101,-83.341301,-27.593000>, <-0.058257,-0.988936,0.136422>
}
   smooth_triangle{ <27.589100,-83.356903,-28.180799>, <0.064186,0.989109,-0.132452>
 <28.629101,-83.341301,-27.593000>, <0.058257,0.988936,-0.136422>
 <27.846300,-83.425499,-28.563200>, <0.065402,0.988696,-0.134917>
}
   smooth_triangle{ <28.629101,-83.341301,-27.593000>, <-0.058257,-0.988936,0.136422>
 <28.402000,-83.287399,-27.294901>, <-0.057313,-0.989211,0.134820>
 <27.589100,-83.356903,-28.180799>, <-0.064186,-0.989109,0.132452>
}
   smooth_triangle{ <28.629101,-83.341301,-27.593000>, <0.058257,0.988936,-0.136422>
 <27.589100,-83.356903,-28.180799>, <0.064186,0.989109,-0.132452>
 <28.402000,-83.287399,-27.294901>, <0.057313,0.989211,-0.134820>
}
   smooth_triangle{ <27.384899,-83.304100,-27.881500>, <-0.063168,-0.989411,0.130676>
 <27.589100,-83.356903,-28.180799>, <-0.064186,-0.989109,0.132452>
 <28.402000,-83.287399,-27.294901>, <-0.057313,-0.989211,0.134820>
}
   smooth_triangle{ <27.384899,-83.304100,-27.881500>, <0.063168,0.989411,-0.130676>
 <28.402000,-83.287399,-27.294901>, <0.057313,0.989211,-0.134820>
 <27.589100,-83.356903,-28.180799>, <0.064186,0.989109,-0.132452>
}
   smooth_triangle{ <28.483299,-83.599701,-29.520599>, <-0.066076,-0.988376,0.136921>
 <27.846300,-83.425499,-28.563200>, <-0.065402,-0.988696,0.134917>
 <27.191799,-83.605797,-30.227301>, <-0.073060,-0.988405,0.133111>
}
   smooth_triangle{ <28.483299,-83.599701,-29.520599>, <0.066076,0.988376,-0.136921>
 <27.191799,-83.605797,-30.227301>, <0.073060,0.988405,-0.133111>
 <27.846300,-83.425499,-28.563200>, <0.065402,0.988696,-0.134917>
}
   smooth_triangle{ <26.628000,-83.432098,-29.240299>, <-0.074293,-0.988760,0.129748>
 <27.191799,-83.605797,-30.227301>, <-0.073060,-0.988405,0.133111>
 <27.846300,-83.425499,-28.563200>, <-0.065402,-0.988696,0.134917>
}
   smooth_triangle{ <26.628000,-83.432098,-29.240299>, <0.074293,0.988760,-0.129748>
 <27.846300,-83.425499,-28.563200>, <0.065402,0.988696,-0.134917>
 <27.191799,-83.605797,-30.227301>, <0.073060,0.988405,-0.133111>
}
   smooth_triangle{ <27.846300,-83.425499,-28.563200>, <-0.065402,-0.988696,0.134917>
 <27.589100,-83.356903,-28.180799>, <-0.064186,-0.989109,0.132452>
 <26.628000,-83.432098,-29.240299>, <-0.074293,-0.988760,0.129748>
}
   smooth_triangle{ <27.846300,-83.425499,-28.563200>, <0.065402,0.988696,-0.134917>
 <26.628000,-83.432098,-29.240299>, <0.074293,0.988760,-0.129748>
 <27.589100,-83.356903,-28.180799>, <0.064186,0.989109,-0.132452>
}
   smooth_triangle{ <26.402201,-83.364700,-28.851299>, <-0.073944,-0.989173,0.126760>
 <26.628000,-83.432098,-29.240299>, <-0.074293,-0.988760,0.129748>
 <27.589100,-83.356903,-28.180799>, <-0.064186,-0.989109,0.132452>
}
   smooth_triangle{ <26.402201,-83.364700,-28.851299>, <0.073944,0.989173,-0.126760>
 <27.589100,-83.356903,-28.180799>, <0.064186,0.989109,-0.132452>
 <26.628000,-83.432098,-29.240299>, <0.074293,0.988760,-0.129748>
}
   smooth_triangle{ <27.589100,-83.356903,-28.180799>, <-0.064186,-0.989109,0.132452>
 <27.384899,-83.304100,-27.881500>, <-0.063168,-0.989411,0.130676>
 <26.402201,-83.364700,-28.851299>, <-0.073944,-0.989173,0.126760>
}
   smooth_triangle{ <27.589100,-83.356903,-28.180799>, <0.064186,0.989109,-0.132452>
 <26.402201,-83.364700,-28.851299>, <0.073944,0.989173,-0.126760>
 <27.384899,-83.304100,-27.881500>, <0.063168,0.989411,-0.130676>
}
   smooth_triangle{ <26.225000,-83.313698,-28.551800>, <-0.073791,-0.989446,0.124704>
 <26.402201,-83.364700,-28.851299>, <-0.073944,-0.989173,0.126760>
 <27.384899,-83.304100,-27.881500>, <-0.063168,-0.989411,0.130676>
}
   smooth_triangle{ <26.225000,-83.313698,-28.551800>, <0.073791,0.989446,-0.124704>
 <27.384899,-83.304100,-27.881500>, <0.063168,0.989411,-0.130676>
 <26.402201,-83.364700,-28.851299>, <0.073944,0.989173,-0.126760>
}
   smooth_triangle{ <30.248199,-84.580704,-35.680599>, <-0.071865,-0.987904,0.137407>
 <30.211800,-84.569000,-35.615299>, <-0.072801,-0.987915,0.136835>
 <29.824400,-84.581802,-35.925999>, <-0.077237,-0.987993,0.133808>
}
   smooth_triangle{ <30.248199,-84.580704,-35.680599>, <0.071865,0.987904,-0.137407>
 <29.824400,-84.581802,-35.925999>, <0.077237,0.987993,-0.133808>
 <30.211800,-84.569000,-35.615299>, <0.072801,0.987915,-0.136835>
}
   smooth_triangle{ <29.785601,-84.569000,-35.853802>, <-0.078595,-0.987841,0.134139>
 <29.824400,-84.581802,-35.925999>, <-0.077237,-0.987993,0.133808>
 <30.211800,-84.569000,-35.615299>, <-0.072801,-0.987915,0.136835>
}
   smooth_triangle{ <29.785601,-84.569000,-35.853802>, <0.078595,0.987841,-0.134139>
 <30.211800,-84.569000,-35.615299>, <0.072801,0.987915,-0.136835>
 <29.824400,-84.581802,-35.925999>, <0.077237,0.987993,-0.133808>
}
   smooth_triangle{ <30.211800,-84.569000,-35.615299>, <-0.072801,-0.987915,0.136835>
 <30.108200,-84.535400,-35.428902>, <-0.072926,-0.987861,0.137157>
 <29.785601,-84.569000,-35.853802>, <-0.078595,-0.987841,0.134139>
}
   smooth_triangle{ <30.211800,-84.569000,-35.615299>, <0.072801,0.987915,-0.136835>
 <29.785601,-84.569000,-35.853802>, <0.078595,0.987841,-0.134139>
 <30.108200,-84.535400,-35.428902>, <0.072926,0.987861,-0.137157>
}
   smooth_triangle{ <29.675699,-84.532501,-35.648998>, <-0.078599,-0.987839,0.134152>
 <29.785601,-84.569000,-35.853802>, <-0.078595,-0.987841,0.134139>
 <30.108200,-84.535400,-35.428902>, <-0.072926,-0.987861,0.137157>
}
   smooth_triangle{ <29.675699,-84.532501,-35.648998>, <0.078599,0.987839,-0.134152>
 <30.108200,-84.535400,-35.428902>, <0.072926,0.987861,-0.137157>
 <29.785601,-84.569000,-35.853802>, <0.078595,0.987841,-0.134139>
}
   smooth_triangle{ <30.108200,-84.535400,-35.428902>, <-0.072926,-0.987861,0.137157>
 <29.945601,-84.482903,-35.136902>, <-0.072703,-0.987902,0.136983>
 <29.675699,-84.532501,-35.648998>, <-0.078599,-0.987839,0.134152>
}
   smooth_triangle{ <30.108200,-84.535400,-35.428902>, <0.072926,0.987861,-0.137157>
 <29.675699,-84.532501,-35.648998>, <0.078599,0.987839,-0.134152>
 <29.945601,-84.482903,-35.136902>, <0.072703,0.987902,-0.136983>
}
   smooth_triangle{ <29.503901,-84.475601,-35.329102>, <-0.078581,-0.987862,0.133990>
 <29.675699,-84.532501,-35.648998>, <-0.078599,-0.987839,0.134152>
 <29.945601,-84.482903,-35.136902>, <-0.072703,-0.987902,0.136983>
}
   smooth_triangle{ <29.503901,-84.475601,-35.329102>, <0.078581,0.987862,-0.133990>
 <29.945601,-84.482903,-35.136902>, <0.072703,0.987902,-0.136983>
 <29.675699,-84.532501,-35.648998>, <0.078599,0.987839,-0.134152>
}
   smooth_triangle{ <29.945601,-84.482903,-35.136902>, <-0.072703,-0.987902,0.136983>
 <29.732300,-84.414101,-34.754002>, <-0.072473,-0.987937,0.136849>
 <29.503901,-84.475601,-35.329102>, <-0.078581,-0.987862,0.133990>
}
   smooth_triangle{ <29.945601,-84.482903,-35.136902>, <0.072703,0.987902,-0.136983>
 <29.503901,-84.475601,-35.329102>, <0.078581,0.987862,-0.133990>
 <29.732300,-84.414101,-34.754002>, <0.072473,0.987937,-0.136849>
}
   smooth_triangle{ <29.279800,-84.401497,-34.911900>, <-0.078544,-0.987878,0.133896>
 <29.503901,-84.475601,-35.329102>, <-0.078581,-0.987862,0.133990>
 <29.732300,-84.414101,-34.754002>, <-0.072473,-0.987937,0.136849>
}
   smooth_triangle{ <29.279800,-84.401497,-34.911900>, <0.078544,0.987878,-0.133896>
 <29.732300,-84.414101,-34.754002>, <0.072473,0.987937,-0.136849>
 <29.503901,-84.475601,-35.329102>, <0.078581,0.987862,-0.133990>
}
   smooth_triangle{ <29.732300,-84.414101,-34.754002>, <-0.072473,-0.987937,0.136849>
 <29.186600,-84.238602,-33.776100>, <-0.072456,-0.987978,0.136563>
 <29.506100,-84.407799,-34.833000>, <-0.074900,-0.987938,0.135534>
}
   smooth_triangle{ <29.732300,-84.414101,-34.754002>, <0.072473,0.987937,-0.136849>
 <29.506100,-84.407799,-34.833000>, <0.074900,0.987938,-0.135534>
 <29.186600,-84.238602,-33.776100>, <0.072456,0.987978,-0.136563>
}
   smooth_triangle{ <28.991501,-84.233200,-33.844799>, <-0.074605,-0.987978,0.135399>
 <29.506100,-84.407799,-34.833000>, <-0.074900,-0.987938,0.135534>
 <29.186600,-84.238602,-33.776100>, <-0.072456,-0.987978,0.136563>
}
   smooth_triangle{ <28.991501,-84.233200,-33.844799>, <0.074605,0.987978,-0.135399>
 <29.186600,-84.238602,-33.776100>, <0.072456,0.987978,-0.136563>
 <29.506100,-84.407799,-34.833000>, <0.074900,0.987938,-0.135534>
}
   smooth_triangle{ <29.506100,-84.407799,-34.833000>, <-0.074900,-0.987938,0.135534>
 <28.991501,-84.233200,-33.844799>, <-0.074605,-0.987978,0.135399>
 <29.279800,-84.401497,-34.911900>, <-0.078544,-0.987878,0.133896>
}
   smooth_triangle{ <29.506100,-84.407799,-34.833000>, <0.074900,0.987938,-0.135534>
 <29.279800,-84.401497,-34.911900>, <0.078544,0.987878,-0.133896>
 <28.991501,-84.233200,-33.844799>, <0.074605,0.987978,-0.135399>
}
   smooth_triangle{ <28.712000,-84.213799,-33.855701>, <-0.078992,-0.987887,0.133566>
 <29.279800,-84.401497,-34.911900>, <-0.078544,-0.987878,0.133896>
 <28.991501,-84.233200,-33.844799>, <-0.074605,-0.987978,0.135399>
}
   smooth_triangle{ <28.712000,-84.213799,-33.855701>, <0.078992,0.987887,-0.133566>
 <28.991501,-84.233200,-33.844799>, <0.074605,0.987978,-0.135399>
 <29.279800,-84.401497,-34.911900>, <0.078544,0.987878,-0.133896>
}
   smooth_triangle{ <29.186600,-84.238602,-33.776100>, <-0.072456,-0.987978,0.136563>
 <28.537300,-84.030800,-32.615398>, <-0.072477,-0.988063,0.135933>
 <28.991501,-84.233200,-33.844799>, <-0.074605,-0.987978,0.135399>
}
   smooth_triangle{ <29.186600,-84.238602,-33.776100>, <0.072456,0.987978,-0.136563>
 <28.991501,-84.233200,-33.844799>, <0.074605,0.987978,-0.135399>
 <28.537300,-84.030800,-32.615398>, <0.072477,0.988063,-0.135933>
}
   smooth_triangle{ <28.359800,-84.023499,-32.660801>, <-0.074402,-0.988056,0.134940>
 <28.991501,-84.233200,-33.844799>, <-0.074605,-0.987978,0.135399>
 <28.537300,-84.030800,-32.615398>, <-0.072477,-0.988063,0.135933>
}
   smooth_triangle{ <28.359800,-84.023499,-32.660801>, <0.074402,0.988056,-0.134940>
 <28.537300,-84.030800,-32.615398>, <0.072477,0.988063,-0.135933>
 <28.991501,-84.233200,-33.844799>, <0.074605,0.987978,-0.135399>
}
   smooth_triangle{ <28.991501,-84.233200,-33.844799>, <-0.074605,-0.987978,0.135399>
 <28.359800,-84.023499,-32.660801>, <-0.074402,-0.988056,0.134940>
 <28.712000,-84.213799,-33.855701>, <-0.078992,-0.987887,0.133566>
}
   smooth_triangle{ <28.991501,-84.233200,-33.844799>, <0.074605,0.987978,-0.135399>
 <28.712000,-84.213799,-33.855701>, <0.078992,0.987887,-0.133566>
 <28.359800,-84.023499,-32.660801>, <0.074402,0.988056,-0.134940>
}
   smooth_triangle{ <28.047501,-83.994904,-32.621498>, <-0.080552,-0.987903,0.132513>
 <28.712000,-84.213799,-33.855701>, <-0.078992,-0.987887,0.133566>
 <28.359800,-84.023499,-32.660801>, <-0.074402,-0.988056,0.134940>
}
   smooth_triangle{ <28.047501,-83.994904,-32.621498>, <0.080552,0.987903,-0.132513>
 <28.359800,-84.023499,-32.660801>, <0.074402,0.988056,-0.134940>
 <28.712000,-84.213799,-33.855701>, <0.078992,0.987887,-0.133566>
}
   smooth_triangle{ <28.537300,-84.030800,-32.615398>, <-0.072477,-0.988063,0.135933>
 <27.850300,-83.812500,-31.392500>, <-0.072552,-0.988191,0.134963>
 <28.359800,-84.023499,-32.660801>, <-0.074402,-0.988056,0.134940>
}
   smooth_triangle{ <28.537300,-84.030800,-32.615398>, <0.072477,0.988063,-0.135933>
 <28.359800,-84.023499,-32.660801>, <0.074402,0.988056,-0.134940>
 <27.850300,-83.812500,-31.392500>, <0.072552,0.988191,-0.134963>
}
   smooth_triangle{ <27.691099,-83.803703,-31.417400>, <-0.075234,-0.988171,0.133633>
 <28.359800,-84.023499,-32.660801>, <-0.074402,-0.988056,0.134940>
 <27.850300,-83.812500,-31.392500>, <-0.072552,-0.988191,0.134963>
}
   smooth_triangle{ <27.691099,-83.803703,-31.417400>, <0.075234,0.988171,-0.133633>
 <27.850300,-83.812500,-31.392500>, <0.072552,0.988191,-0.134963>
 <28.359800,-84.023499,-32.660801>, <0.074402,0.988056,-0.134940>
}
   smooth_triangle{ <28.359800,-84.023499,-32.660801>, <-0.074402,-0.988056,0.134940>
 <27.691099,-83.803703,-31.417400>, <-0.075234,-0.988171,0.133633>
 <28.047501,-83.994904,-32.621498>, <-0.080552,-0.987903,0.132513>
}
   smooth_triangle{ <28.359800,-84.023499,-32.660801>, <0.074402,0.988056,-0.134940>
 <28.047501,-83.994904,-32.621498>, <0.080552,0.987903,-0.132513>
 <27.691099,-83.803703,-31.417400>, <0.075234,0.988171,-0.133633>
}
   smooth_triangle{ <27.361500,-83.769699,-31.350300>, <-0.081199,-0.988095,0.130668>
 <28.047501,-83.994904,-32.621498>, <-0.080552,-0.987903,0.132513>
 <27.691099,-83.803703,-31.417400>, <-0.075234,-0.988171,0.133633>
}
   smooth_triangle{ <27.361500,-83.769699,-31.350300>, <0.081199,0.988095,-0.130668>
 <27.691099,-83.803703,-31.417400>, <0.075234,0.988171,-0.133633>
 <28.047501,-83.994904,-32.621498>, <0.080552,0.987903,-0.132513>
}
   smooth_triangle{ <27.850300,-83.812500,-31.392500>, <-0.072552,-0.988191,0.134963>
 <27.191799,-83.605797,-30.227301>, <-0.073060,-0.988405,0.133111>
 <27.691099,-83.803703,-31.417400>, <-0.075234,-0.988171,0.133633>
}
   smooth_triangle{ <27.850300,-83.812500,-31.392500>, <0.072552,0.988191,-0.134963>
 <27.691099,-83.803703,-31.417400>, <0.075234,0.988171,-0.133633>
 <27.191799,-83.605797,-30.227301>, <0.073060,0.988405,-0.133111>
}
   smooth_triangle{ <27.054001,-83.597000,-30.242599>, <-0.077641,-0.988315,0.131166>
 <27.691099,-83.803703,-31.417400>, <-0.075234,-0.988171,0.133633>
 <27.191799,-83.605797,-30.227301>, <-0.073060,-0.988405,0.133111>
}
   smooth_triangle{ <27.054001,-83.597000,-30.242599>, <0.077641,0.988315,-0.131166>
 <27.191799,-83.605797,-30.227301>, <0.073060,0.988405,-0.133111>
 <27.691099,-83.803703,-31.417400>, <0.075234,0.988171,-0.133633>
}
   smooth_triangle{ <27.691099,-83.803703,-31.417400>, <-0.075234,-0.988171,0.133633>
 <27.054001,-83.597000,-30.242599>, <-0.077641,-0.988315,0.131166>
 <27.361500,-83.769699,-31.350300>, <-0.081199,-0.988095,0.130668>
}
   smooth_triangle{ <27.691099,-83.803703,-31.417400>, <0.075234,0.988171,-0.133633>
 <27.361500,-83.769699,-31.350300>, <0.081199,0.988095,-0.130668>
 <27.054001,-83.597000,-30.242599>, <0.077641,0.988315,-0.131166>
}
   smooth_triangle{ <26.729401,-83.563698,-30.183001>, <-0.082989,-0.988127,0.129296>
 <27.361500,-83.769699,-31.350300>, <-0.081199,-0.988095,0.130668>
 <27.054001,-83.597000,-30.242599>, <-0.077641,-0.988315,0.131166>
}
   smooth_triangle{ <26.729401,-83.563698,-30.183001>, <0.082989,0.988127,-0.129296>
 <27.054001,-83.597000,-30.242599>, <0.077641,0.988315,-0.131166>
 <27.361500,-83.769699,-31.350300>, <0.081199,0.988095,-0.130668>
}
   smooth_triangle{ <27.191799,-83.605797,-30.227301>, <-0.073060,-0.988405,0.133111>
 <26.909800,-83.518898,-29.733801>, <-0.080147,-0.988456,0.128576>
 <27.054001,-83.597000,-30.242599>, <-0.077641,-0.988315,0.131166>
}
   smooth_triangle{ <27.191799,-83.605797,-30.227301>, <0.073060,0.988405,-0.133111>
 <27.054001,-83.597000,-30.242599>, <0.077641,0.988315,-0.131166>
 <26.909800,-83.518898,-29.733801>, <0.080147,0.988456,-0.128576>
}
   smooth_triangle{ <26.769800,-83.506104,-29.724100>, <-0.079744,-0.988440,0.128946>
 <27.054001,-83.597000,-30.242599>, <-0.077641,-0.988315,0.131166>
 <26.909800,-83.518898,-29.733801>, <-0.080147,-0.988456,0.128576>
}
   smooth_triangle{ <26.769800,-83.506104,-29.724100>, <0.079744,0.988440,-0.128946>
 <26.909800,-83.518898,-29.733801>, <0.080147,0.988456,-0.128576>
 <27.054001,-83.597000,-30.242599>, <0.077641,0.988315,-0.131166>
}
   smooth_triangle{ <27.054001,-83.597000,-30.242599>, <-0.077641,-0.988315,0.131166>
 <26.769800,-83.506104,-29.724100>, <-0.079744,-0.988440,0.128946>
 <26.729401,-83.563698,-30.183001>, <-0.082989,-0.988127,0.129296>
}
   smooth_triangle{ <27.054001,-83.597000,-30.242599>, <0.077641,0.988315,-0.131166>
 <26.729401,-83.563698,-30.183001>, <0.082989,0.988127,-0.129296>
 <26.769800,-83.506104,-29.724100>, <0.079744,0.988440,-0.128946>
}
   smooth_triangle{ <26.457001,-83.475601,-29.682600>, <-0.083845,-0.988301,0.127402>
 <26.729401,-83.563698,-30.183001>, <-0.082989,-0.988127,0.129296>
 <26.769800,-83.506104,-29.724100>, <-0.079744,-0.988440,0.128946>
}
   smooth_triangle{ <26.457001,-83.475601,-29.682600>, <0.083845,0.988301,-0.127402>
 <26.769800,-83.506104,-29.724100>, <0.079744,0.988440,-0.128946>
 <26.729401,-83.563698,-30.183001>, <0.082989,0.988127,-0.129296>
}
   smooth_triangle{ <26.909800,-83.518898,-29.733801>, <-0.080147,-0.988456,0.128576>
 <26.628000,-83.432098,-29.240299>, <-0.074293,-0.988760,0.129748>
 <26.769800,-83.506104,-29.724100>, <-0.079744,-0.988440,0.128946>
}
   smooth_triangle{ <26.909800,-83.518898,-29.733801>, <0.080147,0.988456,-0.128576>
 <26.769800,-83.506104,-29.724100>, <0.079744,0.988440,-0.128946>
 <26.628000,-83.432098,-29.240299>, <0.074293,0.988760,-0.129748>
}
   smooth_triangle{ <26.514299,-83.425797,-29.262501>, <-0.080471,-0.988695,0.126518>
 <26.769800,-83.506104,-29.724100>, <-0.079744,-0.988440,0.128946>
 <26.628000,-83.432098,-29.240299>, <-0.074293,-0.988760,0.129748>
}
   smooth_triangle{ <26.514299,-83.425797,-29.262501>, <0.080471,0.988695,-0.126518>
 <26.628000,-83.432098,-29.240299>, <0.074293,0.988760,-0.129748>
 <26.769800,-83.506104,-29.724100>, <0.079744,0.988440,-0.128946>
}
   smooth_triangle{ <26.769800,-83.506104,-29.724100>, <-0.079744,-0.988440,0.128946>
 <26.514299,-83.425797,-29.262501>, <-0.080471,-0.988695,0.126518>
 <26.457001,-83.475601,-29.682600>, <-0.083845,-0.988301,0.127402>
}
   smooth_triangle{ <26.769800,-83.506104,-29.724100>, <0.079744,0.988440,-0.128946>
 <26.457001,-83.475601,-29.682600>, <0.083845,0.988301,-0.127402>
 <26.514299,-83.425797,-29.262501>, <0.080471,0.988695,-0.126518>
}
   smooth_triangle{ <26.226400,-83.402000,-29.260900>, <-0.084879,-0.988458,0.125485>
 <26.457001,-83.475601,-29.682600>, <-0.083845,-0.988301,0.127402>
 <26.514299,-83.425797,-29.262501>, <-0.080471,-0.988695,0.126518>
}
   smooth_triangle{ <26.226400,-83.402000,-29.260900>, <0.084879,0.988458,-0.125485>
 <26.514299,-83.425797,-29.262501>, <0.080471,0.988695,-0.126518>
 <26.457001,-83.475601,-29.682600>, <0.083845,0.988301,-0.127402>
}
   smooth_triangle{ <26.628000,-83.432098,-29.240299>, <-0.074293,-0.988760,0.129748>
 <26.402201,-83.364700,-28.851299>, <-0.073944,-0.989173,0.126760>
 <26.514299,-83.425797,-29.262501>, <-0.080471,-0.988695,0.126518>
}
   smooth_triangle{ <26.628000,-83.432098,-29.240299>, <0.074293,0.988760,-0.129748>
 <26.514299,-83.425797,-29.262501>, <0.080471,0.988695,-0.126518>
 <26.402201,-83.364700,-28.851299>, <0.073944,0.989173,-0.126760>
}
   smooth_triangle{ <26.301399,-83.360497,-28.884600>, <-0.081815,-0.989064,0.122718>
 <26.514299,-83.425797,-29.262501>, <-0.080471,-0.988695,0.126518>
 <26.402201,-83.364700,-28.851299>, <-0.073944,-0.989173,0.126760>
}
   smooth_triangle{ <26.301399,-83.360497,-28.884600>, <0.081815,0.989064,-0.122718>
 <26.402201,-83.364700,-28.851299>, <0.073944,0.989173,-0.126760>
 <26.514299,-83.425797,-29.262501>, <0.080471,0.988695,-0.126518>
}
   smooth_triangle{ <26.514299,-83.425797,-29.262501>, <-0.080471,-0.988695,0.126518>
 <26.301399,-83.360497,-28.884600>, <-0.081815,-0.989064,0.122718>
 <26.226400,-83.402000,-29.260900>, <-0.084879,-0.988458,0.125485>
}
   smooth_triangle{ <26.514299,-83.425797,-29.262501>, <0.080471,0.988695,-0.126518>
 <26.226400,-83.402000,-29.260900>, <0.084879,0.988458,-0.125485>
 <26.301399,-83.360497,-28.884600>, <0.081815,0.989064,-0.122718>
}
   smooth_triangle{ <26.046700,-83.345596,-28.935801>, <-0.084683,-0.988896,0.122119>
 <26.226400,-83.402000,-29.260900>, <-0.084879,-0.988458,0.125485>
 <26.301399,-83.360497,-28.884600>, <-0.081815,-0.989064,0.122718>
}
   smooth_triangle{ <26.046700,-83.345596,-28.935801>, <0.084683,0.988896,-0.122119>
 <26.301399,-83.360497,-28.884600>, <0.081815,0.989064,-0.122718>
 <26.226400,-83.402000,-29.260900>, <0.084879,0.988458,-0.125485>
}
   smooth_triangle{ <26.402201,-83.364700,-28.851299>, <-0.073944,-0.989173,0.126760>
 <26.225000,-83.313698,-28.551800>, <-0.073791,-0.989446,0.124704>
 <26.301399,-83.360497,-28.884600>, <-0.081815,-0.989064,0.122718>
}
   smooth_triangle{ <26.402201,-83.364700,-28.851299>, <0.073944,0.989173,-0.126760>
 <26.301399,-83.360497,-28.884600>, <0.081815,0.989064,-0.122718>
 <26.225000,-83.313698,-28.551800>, <0.073791,0.989446,-0.124704>
}
   smooth_triangle{ <26.137600,-83.312698,-28.602600>, <-0.082276,-0.989270,0.120731>
 <26.301399,-83.360497,-28.884600>, <-0.081815,-0.989064,0.122718>
 <26.225000,-83.313698,-28.551800>, <-0.073791,-0.989446,0.124704>
}
   smooth_triangle{ <26.137600,-83.312698,-28.602600>, <0.082276,0.989270,-0.120731>
 <26.225000,-83.313698,-28.551800>, <0.073791,0.989446,-0.124704>
 <26.301399,-83.360497,-28.884600>, <0.081815,0.989064,-0.122718>
}
   smooth_triangle{ <26.301399,-83.360497,-28.884600>, <-0.081815,-0.989064,0.122718>
 <26.137600,-83.312698,-28.602600>, <-0.082276,-0.989270,0.120731>
 <26.046700,-83.345596,-28.935801>, <-0.084683,-0.988896,0.122119>
}
   smooth_triangle{ <26.301399,-83.360497,-28.884600>, <0.081815,0.989064,-0.122718>
 <26.046700,-83.345596,-28.935801>, <0.084683,0.988896,-0.122119>
 <26.137600,-83.312698,-28.602600>, <0.082276,0.989270,-0.120731>
}
   smooth_triangle{ <25.927601,-83.309799,-28.724701>, <-0.084171,-0.989171,0.120230>
 <26.046700,-83.345596,-28.935801>, <-0.084683,-0.988896,0.122119>
 <26.137600,-83.312698,-28.602600>, <-0.082276,-0.989270,0.120731>
}
   smooth_triangle{ <25.927601,-83.309799,-28.724701>, <0.084171,0.989171,-0.120230>
 <26.137600,-83.312698,-28.602600>, <0.082276,0.989270,-0.120731>
 <26.046700,-83.345596,-28.935801>, <0.084683,0.988896,-0.122119>
}
   smooth_triangle{ <25.927601,-83.309799,-28.724701>, <-0.084171,-0.989171,0.120230>
 <25.770399,-83.250198,-28.344200>, <-0.085726,-0.988784,0.122297>
 <25.361900,-83.301300,-29.053900>, <-0.085451,-0.988985,0.120861>
}
   smooth_triangle{ <25.927601,-83.309799,-28.724701>, <0.084171,0.989171,-0.120230>
 <25.361900,-83.301300,-29.053900>, <0.085451,0.988985,-0.120861>
 <25.770399,-83.250198,-28.344200>, <0.085726,0.988784,-0.122297>
}
   smooth_triangle{ <25.217400,-83.229500,-28.573000>, <-0.086604,-0.988732,0.122099>
 <25.361900,-83.301300,-29.053900>, <-0.085451,-0.988985,0.120861>
 <25.770399,-83.250198,-28.344200>, <-0.085726,-0.988784,0.122297>
}
   smooth_triangle{ <25.217400,-83.229500,-28.573000>, <0.086604,0.988732,-0.122099>
 <25.770399,-83.250198,-28.344200>, <0.085726,0.988784,-0.122297>
 <25.361900,-83.301300,-29.053900>, <0.085451,0.988985,-0.120861>
}
   smooth_triangle{ <25.770399,-83.250198,-28.344200>, <-0.085726,-0.988784,0.122297>
 <25.640100,-83.174500,-27.830999>, <-0.085197,-0.988480,0.125099>
 <25.217400,-83.229500,-28.573000>, <-0.086604,-0.988732,0.122099>
}
   smooth_triangle{ <25.770399,-83.250198,-28.344200>, <0.085726,0.988784,-0.122297>
 <25.217400,-83.229500,-28.573000>, <0.086604,0.988732,-0.122099>
 <25.640100,-83.174500,-27.830999>, <0.085197,0.988480,-0.125099>
}
   smooth_triangle{ <25.073000,-83.158096,-28.091999>, <-0.086238,-0.988562,0.123723>
 <25.217400,-83.229500,-28.573000>, <-0.086604,-0.988732,0.122099>
 <25.640100,-83.174500,-27.830999>, <-0.085197,-0.988480,0.125099>
}
   smooth_triangle{ <25.073000,-83.158096,-28.091999>, <0.086238,0.988562,-0.123723>
 <25.640100,-83.174500,-27.830999>, <0.085197,0.988480,-0.125099>
 <25.217400,-83.229500,-28.573000>, <0.086604,0.988732,-0.122099>
}
   smooth_triangle{ <25.361900,-83.301300,-29.053900>, <-0.085451,-0.988985,0.120861>
 <25.073000,-83.158096,-28.091999>, <-0.086238,-0.988562,0.123723>
 <24.597200,-83.289497,-29.498800>, <-0.086264,-0.988820,0.121625>
}
   smooth_triangle{ <25.361900,-83.301300,-29.053900>, <0.085451,0.988985,-0.120861>
 <24.597200,-83.289497,-29.498800>, <0.086264,0.988820,-0.121625>
 <25.073000,-83.158096,-28.091999>, <0.086238,0.988562,-0.123723>
}
   smooth_triangle{ <24.380199,-83.140198,-28.441000>, <-0.087490,-0.988498,0.123356>
 <24.597200,-83.289497,-29.498800>, <-0.086264,-0.988820,0.121625>
 <25.073000,-83.158096,-28.091999>, <-0.086238,-0.988562,0.123723>
}
   smooth_triangle{ <24.380199,-83.140198,-28.441000>, <0.087490,0.988498,-0.123356>
 <25.073000,-83.158096,-28.091999>, <0.086238,0.988562,-0.123723>
 <24.597200,-83.289497,-29.498800>, <0.086264,0.988820,-0.121625>
}
   smooth_triangle{ <25.640100,-83.174500,-27.830999>, <-0.085197,-0.988480,0.125099>
 <25.452700,-83.004601,-26.632999>, <-0.083142,-0.988280,0.128020>
 <25.073000,-83.158096,-28.091999>, <-0.086238,-0.988562,0.123723>
}
   smooth_triangle{ <25.640100,-83.174500,-27.830999>, <0.085197,0.988480,-0.125099>
 <25.073000,-83.158096,-28.091999>, <0.086238,0.988562,-0.123723>
 <25.452700,-83.004601,-26.632999>, <0.083142,0.988280,-0.128020>
}
   smooth_triangle{ <24.812099,-82.990196,-26.950800>, <-0.085572,-0.988465,0.124961>
 <25.073000,-83.158096,-28.091999>, <-0.086238,-0.988562,0.123723>
 <25.452700,-83.004601,-26.632999>, <-0.083142,-0.988280,0.128020>
}
   smooth_triangle{ <24.812099,-82.990196,-26.950800>, <0.085572,0.988465,-0.124961>
 <25.452700,-83.004601,-26.632999>, <0.083142,0.988280,-0.128020>
 <25.073000,-83.158096,-28.091999>, <0.086238,0.988562,-0.123723>
}
   smooth_triangle{ <25.073000,-83.158096,-28.091999>, <-0.086238,-0.988562,0.123723>
 <24.812099,-82.990196,-26.950800>, <-0.085572,-0.988465,0.124961>
 <24.380199,-83.140198,-28.441000>, <-0.087490,-0.988498,0.123356>
}
   smooth_triangle{ <25.073000,-83.158096,-28.091999>, <0.086238,0.988562,-0.123723>
 <24.380199,-83.140198,-28.441000>, <0.087490,0.988498,-0.123356>
 <24.812099,-82.990196,-26.950800>, <0.085572,0.988465,-0.124961>
}
   smooth_triangle{ <24.171301,-82.975899,-27.268499>, <-0.087229,-0.988396,0.124353>
 <24.380199,-83.140198,-28.441000>, <-0.087490,-0.988498,0.123356>
 <24.812099,-82.990196,-26.950800>, <-0.085572,-0.988465,0.124961>
}
   smooth_triangle{ <24.171301,-82.975899,-27.268499>, <0.087229,0.988396,-0.124353>
 <24.812099,-82.990196,-26.950800>, <0.085572,0.988465,-0.124961>
 <24.380199,-83.140198,-28.441000>, <0.087490,0.988498,-0.123356>
}
   smooth_triangle{ <25.452700,-83.004601,-26.632999>, <-0.083142,-0.988280,0.128020>
 <25.392099,-82.925003,-26.061399>, <-0.080932,-0.988392,0.128576>
 <24.171301,-82.975899,-27.268499>, <-0.087229,-0.988396,0.124353>
}
   smooth_triangle{ <25.452700,-83.004601,-26.632999>, <0.083142,0.988280,-0.128020>
 <24.171301,-82.975899,-27.268499>, <0.087229,0.988396,-0.124353>
 <25.392099,-82.925003,-26.061399>, <0.080932,0.988392,-0.128576>
}
   smooth_triangle{ <24.083700,-82.902802,-26.744499>, <-0.086419,-0.988464,0.124383>
 <24.171301,-82.975899,-27.268499>, <-0.087229,-0.988396,0.124353>
 <25.392099,-82.925003,-26.061399>, <-0.080932,-0.988392,0.128576>
}
   smooth_triangle{ <24.083700,-82.902802,-26.744499>, <0.086419,0.988464,-0.124383>
 <25.392099,-82.925003,-26.061399>, <0.080932,0.988392,-0.128576>
 <24.171301,-82.975899,-27.268499>, <0.087229,0.988396,-0.124353>
}
   smooth_triangle{ <25.392099,-82.925003,-26.061399>, <-0.080932,-0.988392,0.128576>
 <25.351101,-82.859100,-25.583000>, <-0.078987,-0.988461,0.129248>
 <24.083700,-82.902802,-26.744499>, <-0.086419,-0.988464,0.124383>
}
   smooth_triangle{ <25.392099,-82.925003,-26.061399>, <0.080932,0.988392,-0.128576>
 <24.083700,-82.902802,-26.744499>, <0.086419,0.988464,-0.124383>
 <25.351101,-82.859100,-25.583000>, <0.078987,0.988461,-0.129248>
}
   smooth_triangle{ <24.014299,-82.843201,-26.318100>, <-0.085817,-0.988432,0.125053>
 <24.083700,-82.902802,-26.744499>, <-0.086419,-0.988464,0.124383>
 <25.351101,-82.859100,-25.583000>, <-0.078987,-0.988461,0.129248>
}
   smooth_triangle{ <24.014299,-82.843201,-26.318100>, <0.085817,0.988432,-0.125053>
 <25.351101,-82.859100,-25.583000>, <0.078987,0.988461,-0.129248>
 <24.083700,-82.902802,-26.744499>, <0.086419,0.988464,-0.124383>
}
   smooth_triangle{ <25.351101,-82.859100,-25.583000>, <-0.078987,-0.988461,0.129248>
 <25.327801,-82.814003,-25.254499>, <-0.077625,-0.988540,0.129469>
 <24.014299,-82.843201,-26.318100>, <-0.085817,-0.988432,0.125053>
}
   smooth_triangle{ <25.351101,-82.859100,-25.583000>, <0.078987,0.988461,-0.129248>
 <24.014299,-82.843201,-26.318100>, <0.085817,0.988432,-0.125053>
 <25.327801,-82.814003,-25.254499>, <0.077625,0.988540,-0.129469>
}
   smooth_triangle{ <23.968700,-82.803101,-26.031401>, <-0.085066,-0.988519,0.124874>
 <24.014299,-82.843201,-26.318100>, <-0.085817,-0.988432,0.125053>
 <25.327801,-82.814003,-25.254499>, <-0.077625,-0.988540,0.129469>
}
   smooth_triangle{ <23.968700,-82.803101,-26.031401>, <0.085066,0.988519,-0.124874>
 <25.327801,-82.814003,-25.254499>, <0.077625,0.988540,-0.129469>
 <24.014299,-82.843201,-26.318100>, <0.085817,0.988432,-0.125053>
}
   smooth_triangle{ <25.327801,-82.814003,-25.254499>, <-0.077625,-0.988540,0.129469>
 <25.320400,-82.797401,-25.132401>, <-0.077722,-0.988725,0.127995>
 <23.968700,-82.803101,-26.031401>, <-0.085066,-0.988519,0.124874>
}
   smooth_triangle{ <25.327801,-82.814003,-25.254499>, <0.077625,0.988540,-0.129469>
 <23.968700,-82.803101,-26.031401>, <0.085066,0.988519,-0.124874>
 <25.320400,-82.797401,-25.132401>, <0.077722,0.988725,-0.127995>
}
   smooth_triangle{ <23.952400,-82.788597,-25.926500>, <-0.085633,-0.988718,0.122899>
 <23.968700,-82.803101,-26.031401>, <-0.085066,-0.988519,0.124874>
 <25.320400,-82.797401,-25.132401>, <-0.077722,-0.988725,0.127995>
}
   smooth_triangle{ <23.952400,-82.788597,-25.926500>, <0.085633,0.988718,-0.122899>
 <25.320400,-82.797401,-25.132401>, <0.077722,0.988725,-0.127995>
 <23.968700,-82.803101,-26.031401>, <0.085066,0.988519,-0.124874>
}
   smooth_triangle{ <24.597200,-83.289497,-29.498800>, <-0.086264,-0.988820,0.121625>
 <24.380199,-83.140198,-28.441000>, <-0.087490,-0.988498,0.123356>
 <22.809401,-83.261803,-30.539200>, <-0.087200,-0.988624,0.122549>
}
   smooth_triangle{ <24.597200,-83.289497,-29.498800>, <0.086264,0.988820,-0.121625>
 <22.809401,-83.261803,-30.539200>, <0.087200,0.988624,-0.122549>
 <24.380199,-83.140198,-28.441000>, <0.087490,0.988498,-0.123356>
}
   smooth_triangle{ <22.849001,-83.104301,-29.266500>, <-0.090730,-0.988023,0.124812>
 <22.809401,-83.261803,-30.539200>, <-0.087200,-0.988624,0.122549>
 <24.380199,-83.140198,-28.441000>, <-0.087490,-0.988498,0.123356>
}
   smooth_triangle{ <22.849001,-83.104301,-29.266500>, <0.090730,0.988023,-0.124812>
 <24.380199,-83.140198,-28.441000>, <0.087490,0.988498,-0.123356>
 <22.809401,-83.261803,-30.539200>, <0.087200,0.988624,-0.122549>
}
   smooth_triangle{ <24.380199,-83.140198,-28.441000>, <-0.087490,-0.988498,0.123356>
 <24.171301,-82.975899,-27.268499>, <-0.087229,-0.988396,0.124353>
 <22.849001,-83.104301,-29.266500>, <-0.090730,-0.988023,0.124812>
}
   smooth_triangle{ <24.380199,-83.140198,-28.441000>, <0.087490,0.988498,-0.123356>
 <22.849001,-83.104301,-29.266500>, <0.090730,0.988023,-0.124812>
 <24.171301,-82.975899,-27.268499>, <0.087229,0.988396,-0.124353>
}
   smooth_triangle{ <22.868799,-82.942703,-27.968599>, <-0.093581,-0.987813,0.124368>
 <22.849001,-83.104301,-29.266500>, <-0.090730,-0.988023,0.124812>
 <24.171301,-82.975899,-27.268499>, <-0.087229,-0.988396,0.124353>
}
   smooth_triangle{ <22.868799,-82.942703,-27.968599>, <0.093581,0.987813,-0.124368>
 <24.171301,-82.975899,-27.268499>, <0.087229,0.988396,-0.124353>
 <22.849001,-83.104301,-29.266500>, <0.090730,0.988023,-0.124812>
}
   smooth_triangle{ <24.171301,-82.975899,-27.268499>, <-0.087229,-0.988396,0.124353>
 <24.083700,-82.902802,-26.744499>, <-0.086419,-0.988464,0.124383>
 <23.520100,-82.959297,-27.618700>, <-0.090672,-0.988356,0.122197>
}
   smooth_triangle{ <24.171301,-82.975899,-27.268499>, <0.087229,0.988396,-0.124353>
 <23.520100,-82.959297,-27.618700>, <0.090672,0.988356,-0.122197>
 <24.083700,-82.902802,-26.744499>, <0.086419,0.988464,-0.124383>
}
   smooth_triangle{ <23.459400,-82.888000,-27.086000>, <-0.091512,-0.988208,0.122758>
 <23.520100,-82.959297,-27.618700>, <-0.090672,-0.988356,0.122197>
 <24.083700,-82.902802,-26.744499>, <-0.086419,-0.988464,0.124383>
}
   smooth_triangle{ <23.459400,-82.888000,-27.086000>, <0.091512,0.988208,-0.122758>
 <24.083700,-82.902802,-26.744499>, <0.086419,0.988464,-0.124383>
 <23.520100,-82.959297,-27.618700>, <0.090672,0.988356,-0.122197>
}
   smooth_triangle{ <24.083700,-82.902802,-26.744499>, <-0.086419,-0.988464,0.124383>
 <24.014299,-82.843201,-26.318100>, <-0.085817,-0.988432,0.125053>
 <23.459400,-82.888000,-27.086000>, <-0.091512,-0.988208,0.122758>
}
   smooth_triangle{ <24.083700,-82.902802,-26.744499>, <0.086419,0.988464,-0.124383>
 <23.459400,-82.888000,-27.086000>, <0.091512,0.988208,-0.122758>
 <24.014299,-82.843201,-26.318100>, <0.085817,0.988432,-0.125053>
}
   smooth_triangle{ <23.413000,-82.830399,-26.656000>, <-0.092352,-0.988087,0.123110>
 <23.459400,-82.888000,-27.086000>, <-0.091512,-0.988208,0.122758>
 <24.014299,-82.843201,-26.318100>, <-0.085817,-0.988432,0.125053>
}
   smooth_triangle{ <23.413000,-82.830399,-26.656000>, <0.092352,0.988087,-0.123110>
 <24.014299,-82.843201,-26.318100>, <0.085817,0.988432,-0.125053>
 <23.459400,-82.888000,-27.086000>, <0.091512,0.988208,-0.122758>
}
   smooth_triangle{ <24.014299,-82.843201,-26.318100>, <-0.085817,-0.988432,0.125053>
 <23.968700,-82.803101,-26.031401>, <-0.085066,-0.988519,0.124874>
 <23.413000,-82.830399,-26.656000>, <-0.092352,-0.988087,0.123110>
}
   smooth_triangle{ <24.014299,-82.843201,-26.318100>, <0.085817,0.988432,-0.125053>
 <23.413000,-82.830399,-26.656000>, <0.092352,0.988087,-0.123110>
 <23.968700,-82.803101,-26.031401>, <0.085066,0.988519,-0.124874>
}
   smooth_triangle{ <23.383301,-82.791901,-26.368700>, <-0.092292,-0.988179,0.122413>
 <23.413000,-82.830399,-26.656000>, <-0.092352,-0.988087,0.123110>
 <23.968700,-82.803101,-26.031401>, <-0.085066,-0.988519,0.124874>
}
   smooth_triangle{ <23.383301,-82.791901,-26.368700>, <0.092292,0.988179,-0.122413>
 <23.968700,-82.803101,-26.031401>, <0.085066,0.988519,-0.124874>
 <23.413000,-82.830399,-26.656000>, <0.092352,0.988087,-0.123110>
}
   smooth_triangle{ <23.968700,-82.803101,-26.031401>, <-0.085066,-0.988519,0.124874>
 <23.952400,-82.788597,-25.926500>, <-0.085633,-0.988718,0.122899>
 <23.383301,-82.791901,-26.368700>, <-0.092292,-0.988179,0.122413>
}
   smooth_triangle{ <23.968700,-82.803101,-26.031401>, <0.085066,0.988519,-0.124874>
 <23.383301,-82.791901,-26.368700>, <0.092292,0.988179,-0.122413>
 <23.952400,-82.788597,-25.926500>, <0.085633,0.988718,-0.122899>
}
   smooth_triangle{ <23.372801,-82.778099,-26.264000>, <-0.093295,-0.988147,0.121909>
 <23.383301,-82.791901,-26.368700>, <-0.092292,-0.988179,0.122413>
 <23.952400,-82.788597,-25.926500>, <-0.085633,-0.988718,0.122899>
}
   smooth_triangle{ <23.372801,-82.778099,-26.264000>, <0.093295,0.988147,-0.121909>
 <23.952400,-82.788597,-25.926500>, <0.085633,0.988718,-0.122899>
 <23.383301,-82.791901,-26.368700>, <0.092292,0.988179,-0.122413>
}
   smooth_triangle{ <23.520100,-82.959297,-27.618700>, <-0.090672,-0.988356,0.122197>
 <23.459400,-82.888000,-27.086000>, <-0.091512,-0.988208,0.122758>
 <22.868799,-82.942703,-27.968599>, <-0.093581,-0.987813,0.124368>
}
   smooth_triangle{ <23.520100,-82.959297,-27.618700>, <0.090672,0.988356,-0.122197>
 <22.868799,-82.942703,-27.968599>, <0.093581,0.987813,-0.124368>
 <23.459400,-82.888000,-27.086000>, <0.091512,0.988208,-0.122758>
}
   smooth_triangle{ <22.873400,-82.872704,-27.408600>, <-0.096148,-0.987577,0.124287>
 <22.868799,-82.942703,-27.968599>, <-0.093581,-0.987813,0.124368>
 <23.459400,-82.888000,-27.086000>, <-0.091512,-0.988208,0.122758>
}
   smooth_triangle{ <22.873400,-82.872704,-27.408600>, <0.096148,0.987577,-0.124287>
 <23.459400,-82.888000,-27.086000>, <0.091512,0.988208,-0.122758>
 <22.868799,-82.942703,-27.968599>, <0.093581,0.987813,-0.124368>
}
   smooth_triangle{ <23.459400,-82.888000,-27.086000>, <-0.091512,-0.988208,0.122758>
 <23.413000,-82.830399,-26.656000>, <-0.092352,-0.988087,0.123110>
 <22.873400,-82.872704,-27.408600>, <-0.096148,-0.987577,0.124287>
}
   smooth_triangle{ <23.459400,-82.888000,-27.086000>, <0.091512,0.988208,-0.122758>
 <22.873400,-82.872704,-27.408600>, <0.096148,0.987577,-0.124287>
 <23.413000,-82.830399,-26.656000>, <0.092352,0.988087,-0.123110>
}
   smooth_triangle{ <22.875601,-82.816498,-26.959700>, <-0.097939,-0.987414,0.124183>
 <22.873400,-82.872704,-27.408600>, <-0.096148,-0.987577,0.124287>
 <23.413000,-82.830399,-26.656000>, <-0.092352,-0.988087,0.123110>
}
   smooth_triangle{ <22.875601,-82.816498,-26.959700>, <0.097939,0.987414,-0.124183>
 <23.413000,-82.830399,-26.656000>, <0.092352,0.988087,-0.123110>
 <22.873400,-82.872704,-27.408600>, <0.096148,0.987577,-0.124287>
}
   smooth_triangle{ <23.413000,-82.830399,-26.656000>, <-0.092352,-0.988087,0.123110>
 <23.383301,-82.791901,-26.368700>, <-0.092292,-0.988179,0.122413>
 <22.875601,-82.816498,-26.959700>, <-0.097939,-0.987414,0.124183>
}
   smooth_triangle{ <23.413000,-82.830399,-26.656000>, <0.092352,0.988087,-0.123110>
 <22.875601,-82.816498,-26.959700>, <0.097939,0.987414,-0.124183>
 <23.383301,-82.791901,-26.368700>, <0.092292,0.988179,-0.122413>
}
   smooth_triangle{ <22.876200,-82.779198,-26.661699>, <-0.098972,-0.987381,0.123627>
 <22.875601,-82.816498,-26.959700>, <-0.097939,-0.987414,0.124183>
 <23.383301,-82.791901,-26.368700>, <-0.092292,-0.988179,0.122413>
}
   smooth_triangle{ <22.876200,-82.779198,-26.661699>, <0.098972,0.987381,-0.123627>
 <23.383301,-82.791901,-26.368700>, <0.092292,0.988179,-0.122413>
 <22.875601,-82.816498,-26.959700>, <0.097939,0.987414,-0.124183>
}
   smooth_triangle{ <23.383301,-82.791901,-26.368700>, <-0.092292,-0.988179,0.122413>
 <23.372801,-82.778099,-26.264000>, <-0.093295,-0.988147,0.121909>
 <22.876200,-82.779198,-26.661699>, <-0.098972,-0.987381,0.123627>
}
   smooth_triangle{ <23.383301,-82.791901,-26.368700>, <0.092292,0.988179,-0.122413>
 <22.876200,-82.779198,-26.661699>, <0.098972,0.987381,-0.123627>
 <23.372801,-82.778099,-26.264000>, <0.093295,0.988147,-0.121909>
}
   smooth_triangle{ <22.876301,-82.765701,-26.553699>, <-0.101461,-0.986971,0.124873>
 <22.876200,-82.779198,-26.661699>, <-0.098972,-0.987381,0.123627>
 <23.372801,-82.778099,-26.264000>, <-0.093295,-0.988147,0.121909>
}
   smooth_triangle{ <22.876301,-82.765701,-26.553699>, <0.101461,0.986971,-0.124873>
 <23.372801,-82.778099,-26.264000>, <0.093295,0.988147,-0.121909>
 <22.876200,-82.779198,-26.661699>, <0.098972,0.987381,-0.123627>
}
   smooth_triangle{ <22.809401,-83.261803,-30.539200>, <-0.087200,-0.988624,0.122549>
 <22.849001,-83.104301,-29.266500>, <-0.090730,-0.988023,0.124812>
 <21.955200,-83.248398,-31.036301>, <-0.088075,-0.988409,0.123654>
}
   smooth_triangle{ <22.809401,-83.261803,-30.539200>, <0.087200,0.988624,-0.122549>
 <21.955200,-83.248398,-31.036301>, <0.088075,0.988409,-0.123654>
 <22.849001,-83.104301,-29.266500>, <0.090730,0.988023,-0.124812>
}
   smooth_triangle{ <22.140200,-83.088600,-29.661900>, <-0.092632,-0.987597,0.126775>
 <21.955200,-83.248398,-31.036301>, <-0.088075,-0.988409,0.123654>
 <22.849001,-83.104301,-29.266500>, <-0.090730,-0.988023,0.124812>
}
   smooth_triangle{ <22.140200,-83.088600,-29.661900>, <0.092632,0.987597,-0.126775>
 <22.849001,-83.104301,-29.266500>, <0.090730,0.988023,-0.124812>
 <21.955200,-83.248398,-31.036301>, <0.088075,0.988409,-0.123654>
}
   smooth_triangle{ <21.955200,-83.248398,-31.036301>, <-0.088075,-0.988409,0.123654>
 <22.140200,-83.088600,-29.661900>, <-0.092632,-0.987597,0.126775>
 <21.240400,-83.237198,-31.452299>, <-0.088371,-0.988299,0.124317>
}
   smooth_triangle{ <21.955200,-83.248398,-31.036301>, <0.088075,0.988409,-0.123654>
 <21.240400,-83.237198,-31.452299>, <0.088371,0.988299,-0.124317>
 <22.140200,-83.088600,-29.661900>, <0.092632,0.987597,-0.126775>
}
   smooth_triangle{ <21.549101,-83.076103,-29.993601>, <-0.095299,-0.987125,0.128464>
 <21.240400,-83.237198,-31.452299>, <-0.088371,-0.988299,0.124317>
 <22.140200,-83.088600,-29.661900>, <-0.092632,-0.987597,0.126775>
}
   smooth_triangle{ <21.549101,-83.076103,-29.993601>, <0.095299,0.987125,-0.128464>
 <22.140200,-83.088600,-29.661900>, <0.092632,0.987597,-0.126775>
 <21.240400,-83.237198,-31.452299>, <0.088371,0.988299,-0.124317>
}
   smooth_triangle{ <22.849001,-83.104301,-29.266500>, <-0.090730,-0.988023,0.124812>
 <22.868799,-82.942703,-27.968599>, <-0.093581,-0.987813,0.124368>
 <22.140200,-83.088600,-29.661900>, <-0.092632,-0.987597,0.126775>
}
   smooth_triangle{ <22.849001,-83.104301,-29.266500>, <0.090730,0.988023,-0.124812>
 <22.140200,-83.088600,-29.661900>, <0.092632,0.987597,-0.126775>
 <22.868799,-82.942703,-27.968599>, <0.093581,0.987813,-0.124368>
}
   smooth_triangle{ <22.307400,-82.927498,-28.281000>, <-0.097447,-0.987123,0.126854>
 <22.140200,-83.088600,-29.661900>, <-0.092632,-0.987597,0.126775>
 <22.868799,-82.942703,-27.968599>, <-0.093581,-0.987813,0.124368>
}
   smooth_triangle{ <22.307400,-82.927498,-28.281000>, <0.097447,0.987123,-0.126854>
 <22.868799,-82.942703,-27.968599>, <0.093581,0.987813,-0.124368>
 <22.140200,-83.088600,-29.661900>, <0.092632,0.987597,-0.126775>
}
   smooth_triangle{ <22.140200,-83.088600,-29.661900>, <-0.092632,-0.987597,0.126775>
 <22.307400,-82.927498,-28.281000>, <-0.097447,-0.987123,0.126854>
 <21.549101,-83.076103,-29.993601>, <-0.095299,-0.987125,0.128464>
}
   smooth_triangle{ <22.140200,-83.088600,-29.661900>, <0.092632,0.987597,-0.126775>
 <21.549101,-83.076103,-29.993601>, <0.095299,0.987125,-0.128464>
 <22.307400,-82.927498,-28.281000>, <0.097447,0.987123,-0.126854>
}
   smooth_triangle{ <21.857901,-82.915001,-28.534800>, <-0.099815,-0.986548,0.129459>
 <21.549101,-83.076103,-29.993601>, <-0.095299,-0.987125,0.128464>
 <22.307400,-82.927498,-28.281000>, <-0.097447,-0.987123,0.126854>
}
   smooth_triangle{ <21.857901,-82.915001,-28.534800>, <0.099815,0.986548,-0.129459>
 <22.307400,-82.927498,-28.281000>, <0.097447,0.987123,-0.126854>
 <21.549101,-83.076103,-29.993601>, <0.095299,0.987125,-0.128464>
}
   smooth_triangle{ <21.240400,-83.237198,-31.452299>, <-0.088371,-0.988299,0.124317>
 <21.857901,-82.915001,-28.534800>, <-0.099815,-0.986548,0.129459>
 <20.749500,-83.229500,-31.738001>, <-0.090210,-0.988012,0.125279>
}
   smooth_triangle{ <21.240400,-83.237198,-31.452299>, <0.088371,0.988299,-0.124317>
 <20.749500,-83.229500,-31.738001>, <0.090210,0.988012,-0.125279>
 <21.857901,-82.915001,-28.534800>, <0.099815,0.986548,-0.129459>
}
   smooth_triangle{ <21.559500,-82.906700,-28.705299>, <-0.102343,-0.986003,0.131619>
 <20.749500,-83.229500,-31.738001>, <-0.090210,-0.988012,0.125279>
 <21.857901,-82.915001,-28.534800>, <-0.099815,-0.986548,0.129459>
}
   smooth_triangle{ <21.559500,-82.906700,-28.705299>, <0.102343,0.986003,-0.131619>
 <21.857901,-82.915001,-28.534800>, <0.099815,0.986548,-0.129459>
 <20.749500,-83.229500,-31.738001>, <0.090210,0.988012,-0.125279>
}
   smooth_triangle{ <20.749500,-83.229500,-31.738001>, <-0.090210,-0.988012,0.125279>
 <21.559500,-82.906700,-28.705299>, <-0.102343,-0.986003,0.131619>
 <20.614401,-83.227402,-31.816601>, <-0.090630,-0.987911,0.125768>
}
   smooth_triangle{ <20.749500,-83.229500,-31.738001>, <0.090210,0.988012,-0.125279>
 <20.614401,-83.227402,-31.816601>, <0.090630,0.987911,-0.125768>
 <21.559500,-82.906700,-28.705299>, <0.102343,0.986003,-0.131619>
}
   smooth_triangle{ <21.505501,-82.905098,-28.736601>, <-0.100240,-0.986135,0.132252>
 <20.614401,-83.227402,-31.816601>, <-0.090630,-0.987911,0.125768>
 <21.559500,-82.906700,-28.705299>, <-0.102343,-0.986003,0.131619>
}
   smooth_triangle{ <21.505501,-82.905098,-28.736601>, <0.100240,0.986135,-0.132252>
 <21.559500,-82.906700,-28.705299>, <0.102343,0.986003,-0.131619>
 <20.614401,-83.227402,-31.816601>, <0.090630,0.987911,-0.125768>
}
   smooth_triangle{ <20.614401,-83.227402,-31.816601>, <-0.090630,-0.987911,0.125768>
 <21.505501,-82.905098,-28.736601>, <-0.100240,-0.986135,0.132252>
 <20.567101,-83.226700,-31.844200>, <-0.092959,-0.987435,0.127795>
}
   smooth_triangle{ <20.614401,-83.227402,-31.816601>, <0.090630,0.987911,-0.125768>
 <20.567101,-83.226700,-31.844200>, <0.068568,0.989690,-0.125743>
 <21.505501,-82.905098,-28.736601>, <0.100240,0.986135,-0.132252>
}
   smooth_triangle{ <21.451401,-82.903603,-28.767599>, <-0.106438,-0.985353,0.133232>
 <20.567101,-83.226700,-31.844200>, <-0.092959,-0.987435,0.127795>
 <21.505501,-82.905098,-28.736601>, <-0.100240,-0.986135,0.132252>
}
   smooth_triangle{ <21.451401,-82.903603,-28.767599>, <0.069741,0.989897,-0.123447>
 <21.505501,-82.905098,-28.736601>, <0.100240,0.986135,-0.132252>
 <20.567101,-83.226700,-31.844200>, <0.068568,0.989690,-0.125743>
}
   smooth_triangle{ <22.868799,-82.942703,-27.968599>, <-0.093581,-0.987813,0.124368>
 <22.873400,-82.872704,-27.408600>, <-0.096148,-0.987577,0.124287>
 <22.307400,-82.927498,-28.281000>, <-0.097447,-0.987123,0.126854>
}
   smooth_triangle{ <22.868799,-82.942703,-27.968599>, <0.093581,0.987813,-0.124368>
 <22.307400,-82.927498,-28.281000>, <0.097447,0.987123,-0.126854>
 <22.873400,-82.872704,-27.408600>, <0.096148,0.987577,-0.124287>
}
   smooth_triangle{ <22.374599,-82.858299,-27.688999>, <-0.101025,-0.986771,0.126792>
 <22.307400,-82.927498,-28.281000>, <-0.097447,-0.987123,0.126854>
 <22.873400,-82.872704,-27.408600>, <-0.096148,-0.987577,0.124287>
}
   smooth_triangle{ <22.374599,-82.858299,-27.688999>, <0.101025,0.986771,-0.126792>
 <22.873400,-82.872704,-27.408600>, <0.096148,0.987577,-0.124287>
 <22.307400,-82.927498,-28.281000>, <0.097447,0.987123,-0.126854>
}
   smooth_triangle{ <22.873400,-82.872704,-27.408600>, <-0.096148,-0.987577,0.124287>
 <22.875601,-82.816498,-26.959700>, <-0.097939,-0.987414,0.124183>
 <22.374599,-82.858299,-27.688999>, <-0.101025,-0.986771,0.126792>
}
   smooth_triangle{ <22.873400,-82.872704,-27.408600>, <0.096148,0.987577,-0.124287>
 <22.374599,-82.858299,-27.688999>, <0.101025,0.986771,-0.126792>
 <22.875601,-82.816498,-26.959700>, <0.097939,0.987414,-0.124183>
}
   smooth_triangle{ <22.426901,-82.803001,-27.216200>, <-0.103897,-0.986478,0.126754>
 <22.374599,-82.858299,-27.688999>, <-0.101025,-0.986771,0.126792>
 <22.875601,-82.816498,-26.959700>, <-0.097939,-0.987414,0.124183>
}
   smooth_triangle{ <22.426901,-82.803001,-27.216200>, <0.103897,0.986478,-0.126754>
 <22.875601,-82.816498,-26.959700>, <0.097939,0.987414,-0.124183>
 <22.374599,-82.858299,-27.688999>, <0.101025,0.986771,-0.126792>
}
   smooth_triangle{ <22.307400,-82.927498,-28.281000>, <-0.097447,-0.987123,0.126854>
 <22.374599,-82.858299,-27.688999>, <-0.101025,-0.986771,0.126792>
 <21.857901,-82.915001,-28.534800>, <-0.099815,-0.986548,0.129459>
}
   smooth_triangle{ <22.307400,-82.927498,-28.281000>, <0.097447,0.987123,-0.126854>
 <21.857901,-82.915001,-28.534800>, <0.099815,0.986548,-0.129459>
 <22.374599,-82.858299,-27.688999>, <0.101025,0.986771,-0.126792>
}
   smooth_triangle{ <21.983900,-82.846199,-27.911301>, <-0.105132,-0.985951,0.129797>
 <21.857901,-82.915001,-28.534800>, <-0.099815,-0.986548,0.129459>
 <22.374599,-82.858299,-27.688999>, <-0.101025,-0.986771,0.126792>
}
   smooth_triangle{ <21.983900,-82.846199,-27.911301>, <0.105132,0.985951,-0.129797>
 <22.374599,-82.858299,-27.688999>, <0.101025,0.986771,-0.126792>
 <21.857901,-82.915001,-28.534800>, <0.099815,0.986548,-0.129459>
}
   smooth_triangle{ <22.374599,-82.858299,-27.688999>, <-0.101025,-0.986771,0.126792>
 <22.426901,-82.803001,-27.216200>, <-0.103897,-0.986478,0.126754>
 <21.983900,-82.846199,-27.911301>, <-0.105132,-0.985951,0.129797>
}
   smooth_triangle{ <22.374599,-82.858299,-27.688999>, <0.101025,0.986771,-0.126792>
 <21.983900,-82.846199,-27.911301>, <0.105132,0.985951,-0.129797>
 <22.426901,-82.803001,-27.216200>, <0.103897,0.986478,-0.126754>
}
   smooth_triangle{ <22.083401,-82.791397,-27.413799>, <-0.109526,-0.985407,0.130295>
 <21.983900,-82.846199,-27.911301>, <-0.105132,-0.985951,0.129797>
 <22.426901,-82.803001,-27.216200>, <-0.103897,-0.986478,0.126754>
}
   smooth_triangle{ <22.083401,-82.791397,-27.413799>, <0.109526,0.985407,-0.130295>
 <22.426901,-82.803001,-27.216200>, <0.103897,0.986478,-0.126754>
 <21.983900,-82.846199,-27.911301>, <0.105132,0.985951,-0.129797>
}
   smooth_triangle{ <22.875601,-82.816498,-26.959700>, <-0.097939,-0.987414,0.124183>
 <22.876200,-82.779198,-26.661699>, <-0.098972,-0.987381,0.123627>
 <22.426901,-82.803001,-27.216200>, <-0.103897,-0.986478,0.126754>
}
   smooth_triangle{ <22.875601,-82.816498,-26.959700>, <0.097939,0.987414,-0.124183>
 <22.426901,-82.803001,-27.216200>, <0.103897,0.986478,-0.126754>
 <22.876200,-82.779198,-26.661699>, <0.098972,0.987381,-0.123627>
}
   smooth_triangle{ <22.460699,-82.766403,-26.902901>, <-0.106618,-0.986133,0.127177>
 <22.426901,-82.803001,-27.216200>, <-0.103897,-0.986478,0.126754>
 <22.876200,-82.779198,-26.661699>, <-0.098972,-0.987381,0.123627>
}
   smooth_triangle{ <22.460699,-82.766403,-26.902901>, <0.106618,0.986133,-0.127177>
 <22.876200,-82.779198,-26.661699>, <0.098972,0.987381,-0.123627>
 <22.426901,-82.803001,-27.216200>, <0.103897,0.986478,-0.126754>
}
   smooth_triangle{ <22.876200,-82.779198,-26.661699>, <-0.098972,-0.987381,0.123627>
 <22.876301,-82.765701,-26.553699>, <-0.101461,-0.986971,0.124873>
 <22.460699,-82.766403,-26.902901>, <-0.106618,-0.986133,0.127177>
}
   smooth_triangle{ <22.876200,-82.779198,-26.661699>, <0.098972,0.987381,-0.123627>
 <22.460699,-82.766403,-26.902901>, <0.106618,0.986133,-0.127177>
 <22.876301,-82.765701,-26.553699>, <0.101461,0.986971,-0.124873>
}
   smooth_triangle{ <22.472601,-82.752998,-26.789499>, <-0.109430,-0.985624,0.128724>
 <22.460699,-82.766403,-26.902901>, <-0.106618,-0.986133,0.127177>
 <22.876301,-82.765701,-26.553699>, <-0.101461,-0.986971,0.124873>
}
   smooth_triangle{ <22.472601,-82.752998,-26.789499>, <0.109430,0.985624,-0.128724>
 <22.876301,-82.765701,-26.553699>, <0.101461,0.986971,-0.124873>
 <22.460699,-82.766403,-26.902901>, <0.106618,0.986133,-0.127177>
}
   smooth_triangle{ <22.426901,-82.803001,-27.216200>, <-0.103897,-0.986478,0.126754>
 <22.460699,-82.766403,-26.902901>, <-0.106618,-0.986133,0.127177>
 <22.083401,-82.791397,-27.413799>, <-0.109526,-0.985407,0.130295>
}
   smooth_triangle{ <22.426901,-82.803001,-27.216200>, <0.103897,0.986478,-0.126754>
 <22.083401,-82.791397,-27.413799>, <0.109526,0.985407,-0.130295>
 <22.460699,-82.766403,-26.902901>, <0.106618,0.986133,-0.127177>
}
   smooth_triangle{ <22.148600,-82.755096,-27.084600>, <-0.118984,-0.983895,0.133395>
 <22.083401,-82.791397,-27.413799>, <-0.109526,-0.985407,0.130295>
 <22.460699,-82.766403,-26.902901>, <-0.106618,-0.986133,0.127177>
}
   smooth_triangle{ <22.148600,-82.755096,-27.084600>, <0.118984,0.983895,-0.133395>
 <22.460699,-82.766403,-26.902901>, <0.106618,0.986133,-0.127177>
 <22.083401,-82.791397,-27.413799>, <0.109526,0.985407,-0.130295>
}
   smooth_triangle{ <22.460699,-82.766403,-26.902901>, <-0.106618,-0.986133,0.127177>
 <22.472601,-82.752998,-26.789499>, <-0.109430,-0.985624,0.128724>
 <22.148600,-82.755096,-27.084600>, <-0.118984,-0.983895,0.133395>
}
   smooth_triangle{ <22.460699,-82.766403,-26.902901>, <0.106618,0.986133,-0.127177>
 <22.148600,-82.755096,-27.084600>, <0.118984,0.983895,-0.133395>
 <22.472601,-82.752998,-26.789499>, <0.109430,0.985624,-0.128724>
}
   smooth_triangle{ <22.172001,-82.741997,-26.965500>, <-0.126301,-0.982832,0.134499>
 <22.148600,-82.755096,-27.084600>, <-0.118984,-0.983895,0.133395>
 <22.472601,-82.752998,-26.789499>, <-0.109430,-0.985624,0.128724>
}
   smooth_triangle{ <22.172001,-82.741997,-26.965500>, <0.126301,0.982832,-0.134499>
 <22.472601,-82.752998,-26.789499>, <0.109430,0.985624,-0.128724>
 <22.148600,-82.755096,-27.084600>, <0.118984,0.983895,-0.133395>
}
   smooth_triangle{ <21.857901,-82.915001,-28.534800>, <-0.099815,-0.986548,0.129459>
 <21.983900,-82.846199,-27.911301>, <-0.105132,-0.985951,0.129797>
 <21.559500,-82.906700,-28.705299>, <-0.102343,-0.986003,0.131619>
}
   smooth_triangle{ <21.857901,-82.915001,-28.534800>, <0.099815,0.986548,-0.129459>
 <21.559500,-82.906700,-28.705299>, <0.102343,0.986003,-0.131619>
 <21.983900,-82.846199,-27.911301>, <0.105132,0.985951,-0.129797>
}
   smooth_triangle{ <21.729000,-82.837997,-28.057600>, <-0.108920,-0.985170,0.132578>
 <21.559500,-82.906700,-28.705299>, <-0.102343,-0.986003,0.131619>
 <21.983900,-82.846199,-27.911301>, <-0.105132,-0.985951,0.129797>
}
   smooth_triangle{ <21.729000,-82.837997,-28.057600>, <0.108920,0.985170,-0.132578>
 <21.983900,-82.846199,-27.911301>, <0.105132,0.985951,-0.129797>
 <21.559500,-82.906700,-28.705299>, <0.102343,0.986003,-0.131619>
}
   smooth_triangle{ <21.559500,-82.906700,-28.705299>, <-0.102343,-0.986003,0.131619>
 <21.729000,-82.837997,-28.057600>, <-0.108920,-0.985170,0.132578>
 <21.451401,-82.903603,-28.767599>, <-0.106438,-0.985353,0.133232>
}
   smooth_triangle{ <21.559500,-82.906700,-28.705299>, <0.102343,0.986003,-0.131619>
 <21.451401,-82.903603,-28.767599>, <0.069741,0.989897,-0.123447>
 <21.729000,-82.837997,-28.057600>, <0.108920,0.985170,-0.132578>
}
   smooth_triangle{ <21.637899,-82.834900,-28.110399>, <-0.113499,-0.984395,0.134479>
 <21.451401,-82.903603,-28.767599>, <-0.106438,-0.985353,0.133232>
 <21.729000,-82.837997,-28.057600>, <-0.108920,-0.985170,0.132578>
}
   smooth_triangle{ <21.637899,-82.834900,-28.110399>, <0.074181,0.989497,-0.124071>
 <21.729000,-82.837997,-28.057600>, <0.108920,0.985170,-0.132578>
 <21.451401,-82.903603,-28.767599>, <0.069741,0.989897,-0.123447>
}
   smooth_triangle{ <21.983900,-82.846199,-27.911301>, <-0.105132,-0.985951,0.129797>
 <22.083401,-82.791397,-27.413799>, <-0.109526,-0.985407,0.130295>
 <21.729000,-82.837997,-28.057600>, <-0.108920,-0.985170,0.132578>
}
   smooth_triangle{ <21.983900,-82.846199,-27.911301>, <0.105132,0.985951,-0.129797>
 <21.729000,-82.837997,-28.057600>, <0.108920,0.985170,-0.132578>
 <22.083401,-82.791397,-27.413799>, <0.109526,0.985407,-0.130295>
}
   smooth_triangle{ <21.863600,-82.783401,-27.541100>, <-0.119003,-0.983374,0.137161>
 <21.729000,-82.837997,-28.057600>, <-0.108920,-0.985170,0.132578>
 <22.083401,-82.791397,-27.413799>, <-0.109526,-0.985407,0.130295>
}
   smooth_triangle{ <21.863600,-82.783401,-27.541100>, <0.119003,0.983374,-0.137161>
 <22.083401,-82.791397,-27.413799>, <0.109526,0.985407,-0.130295>
 <21.729000,-82.837997,-28.057600>, <0.108920,0.985170,-0.132578>
}
   smooth_triangle{ <21.729000,-82.837997,-28.057600>, <-0.108920,-0.985170,0.132578>
 <21.863600,-82.783401,-27.541100>, <-0.119003,-0.983374,0.137161>
 <21.637899,-82.834900,-28.110399>, <-0.113499,-0.984395,0.134479>
}
   smooth_triangle{ <21.729000,-82.837997,-28.057600>, <0.108920,0.985170,-0.132578>
 <21.637899,-82.834900,-28.110399>, <0.074181,0.989497,-0.124071>
 <21.863600,-82.783401,-27.541100>, <0.119003,0.983374,-0.137161>
}
   smooth_triangle{ <21.786200,-82.780296,-27.586100>, <-0.106917,-0.985085,0.134818>
 <21.637899,-82.834900,-28.110399>, <-0.113499,-0.984395,0.134479>
 <21.863600,-82.783401,-27.541100>, <-0.119003,-0.983374,0.137161>
}
   smooth_triangle{ <21.786200,-82.780296,-27.586100>, <0.070655,0.989756,-0.124058>
 <21.863600,-82.783401,-27.541100>, <0.119003,0.983374,-0.137161>
 <21.637899,-82.834900,-28.110399>, <0.074181,0.989497,-0.124071>
}
   smooth_triangle{ <22.083401,-82.791397,-27.413799>, <-0.109526,-0.985407,0.130295>
 <22.148600,-82.755096,-27.084600>, <-0.118984,-0.983895,0.133395>
 <21.863600,-82.783401,-27.541100>, <-0.119003,-0.983374,0.137161>
}
   smooth_triangle{ <22.083401,-82.791397,-27.413799>, <0.109526,0.985407,-0.130295>
 <21.863600,-82.783401,-27.541100>, <0.119003,0.983374,-0.137161>
 <22.148600,-82.755096,-27.084600>, <0.118984,0.983895,-0.133395>
}
   smooth_triangle{ <21.951200,-82.744698,-27.200399>, <-0.109363,-0.984929,0.133998>
 <21.863600,-82.783401,-27.541100>, <-0.119003,-0.983374,0.137161>
 <22.148600,-82.755096,-27.084600>, <-0.118984,-0.983895,0.133395>
}
   smooth_triangle{ <21.951200,-82.744698,-27.200399>, <0.082923,0.988646,-0.125309>
 <22.148600,-82.755096,-27.084600>, <0.118984,0.983895,-0.133395>
 <21.863600,-82.783401,-27.541100>, <0.119003,0.983374,-0.137161>
}
   smooth_triangle{ <21.863600,-82.783401,-27.541100>, <-0.119003,-0.983374,0.137161>
 <21.951200,-82.744698,-27.200399>, <-0.109363,-0.984929,0.133998>
 <21.786200,-82.780296,-27.586100>, <-0.106917,-0.985085,0.134818>
}
   smooth_triangle{ <21.863600,-82.783401,-27.541100>, <0.119003,0.983374,-0.137161>
 <21.786200,-82.780296,-27.586100>, <0.070655,0.989756,-0.124058>
 <21.951200,-82.744698,-27.200399>, <0.082923,0.988646,-0.125309>
}
   smooth_triangle{ <21.884100,-82.744202,-27.239100>, <-0.079443,-0.988962,0.125070>
 <21.786200,-82.780296,-27.586100>, <-0.106917,-0.985085,0.134818>
 <21.951200,-82.744698,-27.200399>, <-0.109363,-0.984929,0.133998>
}
   smooth_triangle{ <21.884100,-82.744202,-27.239100>, <0.071024,0.990046,-0.121507>
 <21.951200,-82.744698,-27.200399>, <0.082923,0.988646,-0.125309>
 <21.786200,-82.780296,-27.586100>, <0.070655,0.989756,-0.124058>
}
   smooth_triangle{ <22.148600,-82.755096,-27.084600>, <-0.118984,-0.983895,0.133395>
 <22.172001,-82.741997,-26.965500>, <-0.126301,-0.982832,0.134499>
 <21.951200,-82.744698,-27.200399>, <-0.109363,-0.984929,0.133998>
}
   smooth_triangle{ <22.148600,-82.755096,-27.084600>, <0.118984,0.983895,-0.133395>
 <21.951200,-82.744698,-27.200399>, <0.082923,0.988646,-0.125309>
 <22.172001,-82.741997,-26.965500>, <0.126301,0.982832,-0.134499>
}
   smooth_triangle{ <21.985600,-82.731697,-27.075300>, <-0.108037,-0.985331,0.132104>
 <21.951200,-82.744698,-27.200399>, <-0.109363,-0.984929,0.133998>
 <22.172001,-82.741997,-26.965500>, <-0.126301,-0.982832,0.134499>
}
   smooth_triangle{ <21.985600,-82.731697,-27.075300>, <0.069699,0.990062,-0.122145>
 <22.172001,-82.741997,-26.965500>, <0.126301,0.982832,-0.134499>
 <21.951200,-82.744698,-27.200399>, <0.082923,0.988646,-0.125309>
}
   smooth_triangle{ <21.985600,-82.731697,-27.075300>, <0.069699,0.990062,-0.122145>
 <21.951200,-82.744698,-27.200399>, <0.082923,0.988646,-0.125309>
 <21.884100,-82.744202,-27.239100>, <0.071024,0.990046,-0.121507>
}
   smooth_triangle{ <21.884100,-82.744202,-27.239100>, <0.071024,0.990046,-0.121507>
 <21.919500,-82.731201,-27.113600>, <0.079596,0.988981,-0.124821>
 <21.985600,-82.731697,-27.075300>, <0.069699,0.990062,-0.122145>
}
   smooth_triangle{ <20.567101,-83.226700,-31.844200>, <0.068568,0.989690,-0.125743>
 <21.009300,-83.065102,-30.306000>, <0.034182,0.992863,-0.114258>
 <20.670000,-83.223900,-31.785000>, <0.042653,0.991685,-0.121411>
}
   smooth_triangle{ <21.098499,-83.062202,-30.255899>, <0.035788,0.992744,-0.114802>
 <20.670000,-83.223900,-31.785000>, <0.042653,0.991685,-0.121411>
 <21.009300,-83.065102,-30.306000>, <0.034182,0.992863,-0.114258>
}
   smooth_triangle{ <20.670000,-83.223900,-31.785000>, <0.042653,0.991685,-0.121411>
 <21.098499,-83.062202,-30.255899>, <0.035788,0.992744,-0.114802>
 <20.970699,-83.216202,-31.612000>, <0.046035,0.991453,-0.122075>
}
   smooth_triangle{ <21.355801,-83.055298,-30.111900>, <0.041064,0.992345,-0.116471>
 <20.970699,-83.216202,-31.612000>, <0.046035,0.991453,-0.122075>
 <21.098499,-83.062202,-30.255899>, <0.035788,0.992744,-0.114802>
}
   smooth_triangle{ <20.970699,-83.216202,-31.612000>, <0.046035,0.991453,-0.122075>
 <21.355801,-83.055298,-30.111900>, <0.041064,0.992345,-0.116471>
 <21.456600,-83.205399,-31.332300>, <0.049575,0.991214,-0.122629>
}
   smooth_triangle{ <21.771999,-83.046303,-29.881800>, <0.045413,0.991984,-0.117919>
 <21.456600,-83.205399,-31.332300>, <0.049575,0.991214,-0.122629>
 <21.355801,-83.055298,-30.111900>, <0.041064,0.992345,-0.116471>
}
   smooth_triangle{ <21.456600,-83.205399,-31.332300>, <0.049575,0.991214,-0.122629>
 <21.771999,-83.046303,-29.881800>, <0.045413,0.991984,-0.117919>
 <22.115801,-83.192497,-30.952600>, <0.052704,0.991001,-0.123043>
}
   smooth_triangle{ <22.338699,-83.036301,-29.572599>, <0.049395,0.991647,-0.119151>
 <22.115801,-83.192497,-30.952600>, <0.052704,0.991001,-0.123043>
 <21.771999,-83.046303,-29.881800>, <0.045413,0.991984,-0.117919>
}
   smooth_triangle{ <21.009300,-83.065102,-30.306000>, <0.034182,0.992863,-0.114258>
 <21.451401,-82.903603,-28.767599>, <0.069741,0.989897,-0.123447>
 <21.098499,-83.062202,-30.255899>, <0.035788,0.992744,-0.114802>
}
   smooth_triangle{ <21.527000,-82.901299,-28.725000>, <0.035842,0.992821,-0.114111>
 <21.098499,-83.062202,-30.255899>, <0.035788,0.992744,-0.114802>
 <21.451401,-82.903603,-28.767599>, <0.069741,0.989897,-0.123447>
}
   smooth_triangle{ <21.098499,-83.062202,-30.255899>, <0.035788,0.992744,-0.114802>
 <21.527000,-82.901299,-28.725000>, <0.035842,0.992821,-0.114111>
 <21.355801,-83.055298,-30.111900>, <0.041064,0.992345,-0.116471>
}
   smooth_triangle{ <21.748501,-82.895302,-28.600901>, <0.039587,0.992565,-0.115098>
 <21.355801,-83.055298,-30.111900>, <0.041064,0.992345,-0.116471>
 <21.527000,-82.901299,-28.725000>, <0.035842,0.992821,-0.114111>
}
   smooth_triangle{ <21.355801,-83.055298,-30.111900>, <0.041064,0.992345,-0.116471>
 <21.748501,-82.895302,-28.600901>, <0.039587,0.992565,-0.115098>
 <21.771999,-83.046303,-29.881800>, <0.045413,0.991984,-0.117919>
}
   smooth_triangle{ <22.108101,-82.887199,-28.402300>, <0.043582,0.992264,-0.116248>
 <21.771999,-83.046303,-29.881800>, <0.045413,0.991984,-0.117919>
 <21.748501,-82.895302,-28.600901>, <0.039587,0.992565,-0.115098>
}
   smooth_triangle{ <21.771999,-83.046303,-29.881800>, <0.045413,0.991984,-0.117919>
 <22.108101,-82.887199,-28.402300>, <0.043582,0.992264,-0.116248>
 <22.338699,-83.036301,-29.572599>, <0.049395,0.991647,-0.119151>
}
   smooth_triangle{ <22.598000,-82.878304,-28.135599>, <0.047723,0.991956,-0.117246>
 <22.338699,-83.036301,-29.572599>, <0.049395,0.991647,-0.119151>
 <22.108101,-82.887199,-28.402300>, <0.043582,0.992264,-0.116248>
}
   smooth_triangle{ <21.451401,-82.903603,-28.767599>, <0.069741,0.989897,-0.123447>
 <21.637899,-82.834900,-28.110399>, <0.074181,0.989497,-0.124071>
 <21.527000,-82.901299,-28.725000>, <0.035842,0.992821,-0.114111>
}
   smooth_triangle{ <21.709101,-82.832802,-28.069901>, <0.035982,0.992859,-0.113740>
 <21.527000,-82.901299,-28.725000>, <0.035842,0.992821,-0.114111>
 <21.637899,-82.834900,-28.110399>, <0.074181,0.989497,-0.124071>
}
   smooth_triangle{ <21.527000,-82.901299,-28.725000>, <0.035842,0.992821,-0.114111>
 <21.709101,-82.832802,-28.069901>, <0.035982,0.992859,-0.113740>
 <21.748501,-82.895302,-28.600901>, <0.039587,0.992565,-0.115098>
}
   smooth_triangle{ <21.917601,-82.827103,-27.952400>, <0.039042,0.992648,-0.114566>
 <21.748501,-82.895302,-28.600901>, <0.039587,0.992565,-0.115098>
 <21.709101,-82.832802,-28.069901>, <0.035982,0.992859,-0.113740>
}
   smooth_triangle{ <21.637899,-82.834900,-28.110399>, <0.074181,0.989497,-0.124071>
 <21.786200,-82.780296,-27.586100>, <0.070655,0.989756,-0.124058>
 <21.709101,-82.832802,-28.069901>, <0.035982,0.992859,-0.113740>
}
   smooth_triangle{ <21.854200,-82.778198,-27.547300>, <0.041465,0.992775,-0.112595>
 <21.709101,-82.832802,-28.069901>, <0.035982,0.992859,-0.113740>
 <21.786200,-82.780296,-27.586100>, <0.070655,0.989756,-0.124058>
}
   smooth_triangle{ <21.709101,-82.832802,-28.069901>, <0.035982,0.992859,-0.113740>
 <21.854200,-82.778198,-27.547300>, <0.041465,0.992775,-0.112595>
 <21.917601,-82.827103,-27.952400>, <0.039042,0.992648,-0.114566>
}
   smooth_triangle{ <22.053101,-82.772697,-27.434299>, <0.035541,0.993064,-0.112074>
 <21.917601,-82.827103,-27.952400>, <0.039042,0.992648,-0.114566>
 <21.854200,-82.778198,-27.547300>, <0.041465,0.992775,-0.112595>
}
   smooth_triangle{ <21.786200,-82.780296,-27.586100>, <0.070655,0.989756,-0.124058>
 <21.884100,-82.744202,-27.239100>, <0.071024,0.990046,-0.121507>
 <21.854200,-82.778198,-27.547300>, <0.041465,0.992775,-0.112595>
}
   smooth_triangle{ <21.951200,-82.744698,-27.200399>, <0.082923,0.988646,-0.125309>
 <21.854200,-82.778198,-27.547300>, <0.041465,0.992775,-0.112595>
 <21.884100,-82.744202,-27.239100>, <0.071024,0.990046,-0.121507>
}
   smooth_triangle{ <21.854200,-82.778198,-27.547300>, <0.041465,0.992775,-0.112595>
 <21.951200,-82.744698,-27.200399>, <0.082923,0.988646,-0.125309>
 <22.053101,-82.772697,-27.434299>, <0.035541,0.993064,-0.112074>
}
   smooth_triangle{ <22.143101,-82.736801,-27.090799>, <0.031084,0.993233,-0.111899>
 <22.053101,-82.772697,-27.434299>, <0.035541,0.993064,-0.112074>
 <21.951200,-82.744698,-27.200399>, <0.082923,0.988646,-0.125309>
}
   smooth_triangle{ <21.919500,-82.731201,-27.113600>, <-0.079482,-0.988999,0.124751>
 <21.884100,-82.744202,-27.239100>, <-0.079443,-0.988962,0.125070>
 <21.951200,-82.744698,-27.200399>, <-0.109363,-0.984929,0.133998>
}
   smooth_triangle{ <21.919500,-82.731201,-27.113600>, <0.079596,0.988981,-0.124821>
 <21.951200,-82.744698,-27.200399>, <0.082923,0.988646,-0.125309>
 <21.884100,-82.744202,-27.239100>, <0.071024,0.990046,-0.121507>
}
   smooth_triangle{ <21.951200,-82.744698,-27.200399>, <-0.109363,-0.984929,0.133998>
 <21.985600,-82.731697,-27.075300>, <-0.108037,-0.985331,0.132104>
 <21.919500,-82.731201,-27.113600>, <-0.079482,-0.988999,0.124751>
}
   smooth_triangle{ <21.951200,-82.744698,-27.200399>, <0.082923,0.988646,-0.125309>
 <21.919500,-82.731201,-27.113600>, <0.079596,0.988981,-0.124821>
 <21.985600,-82.731697,-27.075300>, <0.069699,0.990062,-0.122145>
}
   smooth_triangle{ <21.951200,-82.744698,-27.200399>, <0.082923,0.988646,-0.125309>
 <21.985600,-82.731697,-27.075300>, <0.069699,0.990062,-0.122145>
 <22.143101,-82.736801,-27.090799>, <0.031084,0.993233,-0.111899>
}
   smooth_triangle{ <22.175699,-82.723801,-26.966400>, <0.034214,0.993041,-0.112691>
 <22.143101,-82.736801,-27.090799>, <0.031084,0.993233,-0.111899>
 <21.985600,-82.731697,-27.075300>, <0.069699,0.990062,-0.122145>
}
   smooth_triangle{ <21.748501,-82.895302,-28.600901>, <0.039587,0.992565,-0.115098>
 <21.917601,-82.827103,-27.952400>, <0.039042,0.992648,-0.114566>
 <22.108101,-82.887199,-28.402300>, <0.043582,0.992264,-0.116248>
}
   smooth_triangle{ <22.255800,-82.819099,-27.763700>, <0.042957,0.992379,-0.115497>
 <22.108101,-82.887199,-28.402300>, <0.043582,0.992264,-0.116248>
 <21.917601,-82.827103,-27.952400>, <0.039042,0.992648,-0.114566>
}
   smooth_triangle{ <21.917601,-82.827103,-27.952400>, <0.039042,0.992648,-0.114566>
 <22.053101,-82.772697,-27.434299>, <0.035541,0.993064,-0.112074>
 <22.255800,-82.819099,-27.763700>, <0.042957,0.992379,-0.115497>
}
   smooth_triangle{ <22.375200,-82.764900,-27.252100>, <0.042777,0.992442,-0.115015>
 <22.255800,-82.819099,-27.763700>, <0.042957,0.992379,-0.115497>
 <22.053101,-82.772697,-27.434299>, <0.035541,0.993064,-0.112074>
}
   smooth_triangle{ <22.108101,-82.887199,-28.402300>, <0.043582,0.992264,-0.116248>
 <22.255800,-82.819099,-27.763700>, <0.042957,0.992379,-0.115497>
 <22.598000,-82.878304,-28.135599>, <0.047723,0.991956,-0.117246>
}
   smooth_triangle{ <22.716101,-82.810303,-27.509399>, <0.047080,0.992094,-0.116332>
 <22.598000,-82.878304,-28.135599>, <0.047723,0.991956,-0.117246>
 <22.255800,-82.819099,-27.763700>, <0.042957,0.992379,-0.115497>
}
   smooth_triangle{ <22.255800,-82.819099,-27.763700>, <0.042957,0.992379,-0.115497>
 <22.375200,-82.764900,-27.252100>, <0.042777,0.992442,-0.115015>
 <22.716101,-82.810303,-27.509399>, <0.047080,0.992094,-0.116332>
}
   smooth_triangle{ <22.813000,-82.755997,-27.005800>, <0.046833,0.992144,-0.116006>
 <22.716101,-82.810303,-27.509399>, <0.047080,0.992094,-0.116332>
 <22.375200,-82.764900,-27.252100>, <0.042777,0.992442,-0.115015>
}
   smooth_triangle{ <22.053101,-82.772697,-27.434299>, <0.035541,0.993064,-0.112074>
 <22.143101,-82.736801,-27.090799>, <0.031084,0.993233,-0.111899>
 <22.375200,-82.764900,-27.252100>, <0.042777,0.992442,-0.115015>
}
   smooth_triangle{ <22.455000,-82.728996,-26.912300>, <0.042561,0.992469,-0.114860>
 <22.375200,-82.764900,-27.252100>, <0.042777,0.992442,-0.115015>
 <22.143101,-82.736801,-27.090799>, <0.031084,0.993233,-0.111899>
}
   smooth_triangle{ <22.143101,-82.736801,-27.090799>, <0.031084,0.993233,-0.111899>
 <22.175699,-82.723801,-26.966400>, <0.034214,0.993041,-0.112691>
 <22.455000,-82.728996,-26.912300>, <0.042561,0.992469,-0.114860>
}
   smooth_triangle{ <22.484200,-82.716003,-26.789000>, <0.042923,0.992491,-0.114535>
 <22.455000,-82.728996,-26.912300>, <0.042561,0.992469,-0.114860>
 <22.175699,-82.723801,-26.966400>, <0.034214,0.993041,-0.112691>
}
   smooth_triangle{ <22.375200,-82.764900,-27.252100>, <0.042777,0.992442,-0.115015>
 <22.455000,-82.728996,-26.912300>, <0.042561,0.992469,-0.114860>
 <22.813000,-82.755997,-27.005800>, <0.046833,0.992144,-0.116006>
}
   smooth_triangle{ <22.878500,-82.719803,-26.670300>, <0.046523,0.992209,-0.115572>
 <22.813000,-82.755997,-27.005800>, <0.046833,0.992144,-0.116006>
 <22.455000,-82.728996,-26.912300>, <0.042561,0.992469,-0.114860>
}
   smooth_triangle{ <22.455000,-82.728996,-26.912300>, <0.042561,0.992469,-0.114860>
 <22.484200,-82.716003,-26.789000>, <0.042923,0.992491,-0.114535>
 <22.878500,-82.719803,-26.670300>, <0.046523,0.992209,-0.115572>
}
   smooth_triangle{ <22.902599,-82.706802,-26.548201>, <0.046953,0.992230,-0.115214>
 <22.878500,-82.719803,-26.670300>, <0.046523,0.992209,-0.115572>
 <22.484200,-82.716003,-26.789000>, <0.042923,0.992491,-0.114535>
}
   smooth_triangle{ <22.115801,-83.192497,-30.952600>, <0.052704,0.991001,-0.123043>
 <22.338699,-83.036301,-29.572599>, <0.049395,0.991647,-0.119151>
 <22.935600,-83.178902,-30.479900>, <0.056027,0.990796,-0.123226>
}
   smooth_triangle{ <23.046900,-83.027100,-29.192301>, <0.053574,0.991309,-0.120150>
 <22.935600,-83.178902,-30.479900>, <0.056027,0.990796,-0.123226>
 <22.338699,-83.036301,-29.572599>, <0.049395,0.991647,-0.119151>
}
   smooth_triangle{ <22.935600,-83.178902,-30.479900>, <0.056027,0.990796,-0.123226>
 <23.046900,-83.027100,-29.192301>, <0.053574,0.991309,-0.120150>
 <23.903900,-83.166000,-29.921000>, <0.059398,0.990623,-0.123034>
}
   smooth_triangle{ <23.887699,-83.020302,-28.747900>, <0.057454,0.991044,-0.120541>
 <23.903900,-83.166000,-29.921000>, <0.059398,0.990623,-0.123034>
 <23.046900,-83.027100,-29.192301>, <0.053574,0.991309,-0.120150>
}
   smooth_triangle{ <22.338699,-83.036301,-29.572599>, <0.049395,0.991647,-0.119151>
 <22.598000,-82.878304,-28.135599>, <0.047723,0.991956,-0.117246>
 <23.046900,-83.027100,-29.192301>, <0.053574,0.991309,-0.120150>
}
   smooth_triangle{ <23.210501,-82.870003,-27.807199>, <0.051932,0.991651,-0.118031>
 <23.046900,-83.027100,-29.192301>, <0.053574,0.991309,-0.120150>
 <22.598000,-82.878304,-28.135599>, <0.047723,0.991956,-0.117246>
}
   smooth_triangle{ <23.046900,-83.027100,-29.192301>, <0.053574,0.991309,-0.120150>
 <23.210501,-82.870003,-27.807199>, <0.051932,0.991651,-0.118031>
 <23.887699,-83.020302,-28.747900>, <0.057454,0.991044,-0.120541>
}
   smooth_triangle{ <23.937700,-82.863899,-27.423901>, <0.056279,0.991348,-0.118583>
 <23.887699,-83.020302,-28.747900>, <0.057454,0.991044,-0.120541>
 <23.210501,-82.870003,-27.807199>, <0.051932,0.991651,-0.118031>
}
   smooth_triangle{ <22.598000,-82.878304,-28.135599>, <0.047723,0.991956,-0.117246>
 <22.716101,-82.810303,-27.509399>, <0.047080,0.992094,-0.116332>
 <23.210501,-82.870003,-27.807199>, <0.051932,0.991651,-0.118031>
}
   smooth_triangle{ <23.290600,-82.801804,-27.195700>, <0.051209,0.991807,-0.117029>
 <23.210501,-82.870003,-27.807199>, <0.051932,0.991651,-0.118031>
 <22.716101,-82.810303,-27.509399>, <0.047080,0.992094,-0.116332>
}
   smooth_triangle{ <22.716101,-82.810303,-27.509399>, <0.047080,0.992094,-0.116332>
 <22.813000,-82.755997,-27.005800>, <0.046833,0.992144,-0.116006>
 <23.290600,-82.801804,-27.195700>, <0.051209,0.991807,-0.117029>
}
   smooth_triangle{ <23.358400,-82.747101,-26.700701>, <0.050965,0.991854,-0.116743>
 <23.290600,-82.801804,-27.195700>, <0.051209,0.991807,-0.117029>
 <22.813000,-82.755997,-27.005800>, <0.046833,0.992144,-0.116006>
}
   smooth_triangle{ <22.813000,-82.755997,-27.005800>, <0.046833,0.992144,-0.116006>
 <22.878500,-82.719803,-26.670300>, <0.046523,0.992209,-0.115572>
 <23.358400,-82.747101,-26.700701>, <0.050965,0.991854,-0.116743>
}
   smooth_triangle{ <23.405300,-82.710503,-26.369400>, <0.050734,0.991903,-0.116421>
 <23.358400,-82.747101,-26.700701>, <0.050965,0.991854,-0.116743>
 <22.878500,-82.719803,-26.670300>, <0.046523,0.992209,-0.115572>
}
   smooth_triangle{ <22.878500,-82.719803,-26.670300>, <0.046523,0.992209,-0.115572>
 <22.902599,-82.706802,-26.548201>, <0.046953,0.992230,-0.115214>
 <23.405300,-82.710503,-26.369400>, <0.050734,0.991903,-0.116421>
}
   smooth_triangle{ <23.422800,-82.697197,-26.248400>, <0.051275,0.991888,-0.116318>
 <23.405300,-82.710503,-26.369400>, <0.050734,0.991903,-0.116421>
 <22.902599,-82.706802,-26.548201>, <0.046953,0.992230,-0.115214>
}
   smooth_triangle{ <23.210501,-82.870003,-27.807199>, <0.051932,0.991651,-0.118031>
 <23.290600,-82.801804,-27.195700>, <0.051209,0.991807,-0.117029>
 <23.937700,-82.863899,-27.423901>, <0.056279,0.991348,-0.118583>
}
   smooth_triangle{ <23.972000,-82.794899,-26.828100>, <0.055654,0.991502,-0.117582>
 <23.937700,-82.863899,-27.423901>, <0.056279,0.991348,-0.118583>
 <23.290600,-82.801804,-27.195700>, <0.051209,0.991807,-0.117029>
}
   smooth_triangle{ <23.290600,-82.801804,-27.195700>, <0.051209,0.991807,-0.117029>
 <23.358400,-82.747101,-26.700701>, <0.050965,0.991854,-0.116743>
 <23.972000,-82.794899,-26.828100>, <0.055654,0.991502,-0.117582>
}
   smooth_triangle{ <24.004200,-82.739197,-26.341900>, <0.055468,0.991565,-0.117145>
 <23.972000,-82.794899,-26.828100>, <0.055654,0.991502,-0.117582>
 <23.358400,-82.747101,-26.700701>, <0.050965,0.991854,-0.116743>
}
   smooth_triangle{ <23.358400,-82.747101,-26.700701>, <0.050965,0.991854,-0.116743>
 <23.405300,-82.710503,-26.369400>, <0.050734,0.991903,-0.116421>
 <24.004200,-82.739197,-26.341900>, <0.055468,0.991565,-0.117145>
}
   smooth_triangle{ <24.028000,-82.701797,-26.014099>, <0.055438,0.991626,-0.116638>
 <24.004200,-82.739197,-26.341900>, <0.055468,0.991565,-0.117145>
 <23.405300,-82.710503,-26.369400>, <0.050734,0.991903,-0.116421>
}
   smooth_triangle{ <23.405300,-82.710503,-26.369400>, <0.050734,0.991903,-0.116421>
 <23.422800,-82.697197,-26.248400>, <0.051275,0.991888,-0.116318>
 <24.028000,-82.701797,-26.014099>, <0.055438,0.991626,-0.116638>
}
   smooth_triangle{ <24.037300,-82.688202,-25.893801>, <0.055750,0.991808,-0.114926>
 <24.028000,-82.701797,-26.014099>, <0.055438,0.991626,-0.116638>
 <23.422800,-82.697197,-26.248400>, <0.051275,0.991888,-0.116318>
}
   smooth_triangle{ <23.903900,-83.166000,-29.921000>, <0.059398,0.990623,-0.123034>
 <23.895800,-83.093102,-29.334499>, <0.060581,0.990574,-0.122850>
 <25.008200,-83.155098,-29.283001>, <0.063110,0.990398,-0.123002>
}
   smooth_triangle{ <24.919001,-83.091400,-28.818600>, <0.062588,0.990481,-0.122593>
 <25.008200,-83.155098,-29.283001>, <0.063110,0.990398,-0.123002>
 <23.895800,-83.093102,-29.334499>, <0.060581,0.990574,-0.122850>
}
   smooth_triangle{ <23.895800,-83.093102,-29.334499>, <0.060581,0.990574,-0.122850>
 <23.887699,-83.020302,-28.747900>, <0.057454,0.991044,-0.120541>
 <24.919001,-83.091400,-28.818600>, <0.062588,0.990481,-0.122593>
}
   smooth_triangle{ <24.852600,-83.017303,-28.246901>, <0.061440,0.990851,-0.120164>
 <24.919001,-83.091400,-28.818600>, <0.062588,0.990481,-0.122593>
 <23.887699,-83.020302,-28.747900>, <0.057454,0.991044,-0.120541>
}
   smooth_triangle{ <23.887699,-83.020302,-28.747900>, <0.057454,0.991044,-0.120541>
 <23.937700,-82.863899,-27.423901>, <0.056279,0.991348,-0.118583>
 <24.852600,-83.017303,-28.246901>, <0.061440,0.990851,-0.120164>
}
   smooth_triangle{ <24.776699,-82.861397,-26.989401>, <0.060582,0.991091,-0.118614>
 <24.852600,-83.017303,-28.246901>, <0.061440,0.990851,-0.120164>
 <23.937700,-82.863899,-27.423901>, <0.056279,0.991348,-0.118583>
}
   smooth_triangle{ <25.008200,-83.155098,-29.283001>, <0.063110,0.990398,-0.123002>
 <24.919001,-83.091400,-28.818600>, <0.062588,0.990481,-0.122593>
 <26.236401,-83.147697,-28.572701>, <0.066787,0.990220,-0.122489>
}
   smooth_triangle{ <26.073900,-83.090599,-28.201300>, <0.066281,0.990366,-0.121584>
 <26.236401,-83.147697,-28.572701>, <0.066787,0.990220,-0.122489>
 <24.919001,-83.091400,-28.818600>, <0.062588,0.990481,-0.122593>
}
   smooth_triangle{ <24.919001,-83.091400,-28.818600>, <0.062588,0.990481,-0.122593>
 <24.852600,-83.017303,-28.246901>, <0.061440,0.990851,-0.120164>
 <26.073900,-83.090599,-28.201300>, <0.066281,0.990366,-0.121584>
}
   smooth_triangle{ <25.930799,-83.019897,-27.697701>, <0.065199,0.990686,-0.119541>
 <26.073900,-83.090599,-28.201300>, <0.066281,0.990366,-0.121584>
 <24.852600,-83.017303,-28.246901>, <0.061440,0.990851,-0.120164>
}
   smooth_triangle{ <24.852600,-83.017303,-28.246901>, <0.061440,0.990851,-0.120164>
 <24.776699,-82.861397,-26.989401>, <0.060582,0.991091,-0.118614>
 <25.930799,-83.019897,-27.697701>, <0.065199,0.990686,-0.119541>
}
   smooth_triangle{ <25.705200,-82.863701,-26.518700>, <0.064487,0.990867,-0.118423>
 <25.930799,-83.019897,-27.697701>, <0.065199,0.990686,-0.119541>
 <24.776699,-82.861397,-26.989401>, <0.060582,0.991091,-0.118614>
}
   smooth_triangle{ <23.937700,-82.863899,-27.423901>, <0.056279,0.991348,-0.118583>
 <23.972000,-82.794899,-26.828100>, <0.055654,0.991502,-0.117582>
 <24.776699,-82.861397,-26.989401>, <0.060582,0.991091,-0.118614>
}
   smooth_triangle{ <24.761900,-82.791199,-26.407101>, <0.059975,0.991245,-0.117626>
 <24.776699,-82.861397,-26.989401>, <0.060582,0.991091,-0.118614>
 <23.972000,-82.794899,-26.828100>, <0.055654,0.991502,-0.117582>
}
   smooth_triangle{ <23.972000,-82.794899,-26.828100>, <0.055654,0.991502,-0.117582>
 <24.004200,-82.739197,-26.341900>, <0.055468,0.991565,-0.117145>
 <24.761900,-82.791199,-26.407101>, <0.059975,0.991245,-0.117626>
}
   smooth_triangle{ <24.758900,-82.734100,-25.924601>, <0.059502,0.991359,-0.116908>
 <24.761900,-82.791199,-26.407101>, <0.059975,0.991245,-0.117626>
 <24.004200,-82.739197,-26.341900>, <0.055468,0.991565,-0.117145>
}
   smooth_triangle{ <24.004200,-82.739197,-26.341900>, <0.055468,0.991565,-0.117145>
 <24.028000,-82.701797,-26.014099>, <0.055438,0.991626,-0.116638>
 <24.758900,-82.734100,-25.924601>, <0.059502,0.991359,-0.116908>
}
   smooth_triangle{ <24.764900,-82.695702,-25.593700>, <0.058478,0.991634,-0.115077>
 <24.758900,-82.734100,-25.924601>, <0.059502,0.991359,-0.116908>
 <24.028000,-82.701797,-26.014099>, <0.055438,0.991626,-0.116638>
}
   smooth_triangle{ <24.028000,-82.701797,-26.014099>, <0.055438,0.991626,-0.116638>
 <24.037300,-82.688202,-25.893801>, <0.055750,0.991808,-0.114926>
 <24.764900,-82.695702,-25.593700>, <0.058478,0.991634,-0.115077>
}
   smooth_triangle{ <24.777399,-82.681999,-25.466101>, <0.057808,0.991811,-0.113883>
 <24.764900,-82.695702,-25.593700>, <0.058478,0.991634,-0.115077>
 <24.037300,-82.688202,-25.893801>, <0.055750,0.991808,-0.114926>
}
   smooth_triangle{ <24.776699,-82.861397,-26.989401>, <0.060582,0.991091,-0.118614>
 <24.761900,-82.791199,-26.407101>, <0.059975,0.991245,-0.117626>
 <25.705200,-82.863701,-26.518700>, <0.064487,0.990867,-0.118423>
}
   smooth_triangle{ <25.624201,-82.791199,-25.955000>, <0.063935,0.990989,-0.117701>
 <25.705200,-82.863701,-26.518700>, <0.064487,0.990867,-0.118423>
 <24.761900,-82.791199,-26.407101>, <0.059975,0.991245,-0.117626>
}
   smooth_triangle{ <24.761900,-82.791199,-26.407101>, <0.059975,0.991245,-0.117626>
 <24.758900,-82.734100,-25.924601>, <0.059502,0.991359,-0.116908>
 <25.624201,-82.791199,-25.955000>, <0.063935,0.990989,-0.117701>
}
   smooth_triangle{ <25.565500,-82.731400,-25.483101>, <0.063368,0.991086,-0.117192>
 <25.624201,-82.791199,-25.955000>, <0.063935,0.990989,-0.117701>
 <24.758900,-82.734100,-25.924601>, <0.059502,0.991359,-0.116908>
}
   smooth_triangle{ <24.758900,-82.734100,-25.924601>, <0.059502,0.991359,-0.116908>
 <24.764900,-82.695702,-25.593700>, <0.058478,0.991634,-0.115077>
 <25.565500,-82.731400,-25.483101>, <0.063368,0.991086,-0.117192>
}
   smooth_triangle{ <25.529600,-82.690804,-25.158899>, <0.062474,0.991253,-0.116254>
 <25.565500,-82.731400,-25.483101>, <0.063368,0.991086,-0.117192>
 <24.764900,-82.695702,-25.593700>, <0.058478,0.991634,-0.115077>
}
   smooth_triangle{ <24.764900,-82.695702,-25.593700>, <0.058478,0.991634,-0.115077>
 <24.777399,-82.681999,-25.466101>, <0.057808,0.991811,-0.113883>
 <25.529600,-82.690804,-25.158899>, <0.062474,0.991253,-0.116254>
}
   smooth_triangle{ <25.517599,-82.675797,-25.038300>, <0.063723,0.991078,-0.117066>
 <25.529600,-82.690804,-25.158899>, <0.062474,0.991253,-0.116254>
 <24.777399,-82.681999,-25.466101>, <0.057808,0.991811,-0.113883>
}
   smooth_triangle{ <26.236401,-83.147697,-28.572701>, <0.066787,0.990220,-0.122489>
 <26.073900,-83.090599,-28.201300>, <0.066281,0.990366,-0.121584>
 <27.395700,-83.145103,-27.901501>, <0.069909,0.990212,-0.120802>
}
   smooth_triangle{ <27.202999,-83.088303,-27.548300>, <0.069516,0.990336,-0.120007>
 <27.395700,-83.145103,-27.901501>, <0.069909,0.990212,-0.120802>
 <26.073900,-83.090599,-28.201300>, <0.066281,0.990366,-0.121584>
}
   smooth_triangle{ <26.073900,-83.090599,-28.201300>, <0.066281,0.990366,-0.121584>
 <25.930799,-83.019897,-27.697701>, <0.065199,0.990686,-0.119541>
 <27.202999,-83.088303,-27.548300>, <0.069516,0.990336,-0.120007>
}
   smooth_triangle{ <27.006100,-83.017899,-27.076200>, <0.068657,0.990596,-0.118347>
 <27.202999,-83.088303,-27.548300>, <0.069516,0.990336,-0.120007>
 <25.930799,-83.019897,-27.697701>, <0.065199,0.990686,-0.119541>
}
   smooth_triangle{ <25.930799,-83.019897,-27.697701>, <0.065199,0.990686,-0.119541>
 <25.705200,-82.863701,-26.518700>, <0.064487,0.990867,-0.118423>
 <27.006100,-83.017899,-27.076200>, <0.068657,0.990596,-0.118347>
}
   smooth_triangle{ <26.636900,-82.862000,-25.980200>, <0.068294,0.990728,-0.117445>
 <27.006100,-83.017899,-27.076200>, <0.068657,0.990596,-0.118347>
 <25.705200,-82.863701,-26.518700>, <0.064487,0.990867,-0.118423>
}
   smooth_triangle{ <27.395700,-83.145103,-27.901501>, <0.069909,0.990212,-0.120802>
 <27.202999,-83.088303,-27.548300>, <0.069516,0.990336,-0.120007>
 <28.411501,-83.147202,-27.312599>, <0.072838,0.990251,-0.118732>
}
   smooth_triangle{ <28.192200,-83.090401,-26.975500>, <0.072602,0.990346,-0.118081>
 <28.411501,-83.147202,-27.312599>, <0.072838,0.990251,-0.118732>
 <27.202999,-83.088303,-27.548300>, <0.069516,0.990336,-0.120007>
}
   smooth_triangle{ <27.202999,-83.088303,-27.548300>, <0.069516,0.990336,-0.120007>
 <27.006100,-83.017899,-27.076200>, <0.068657,0.990596,-0.118347>
 <28.192200,-83.090401,-26.975500>, <0.072602,0.990346,-0.118081>
}
   smooth_triangle{ <27.948299,-83.020103,-26.531000>, <0.071956,0.990558,-0.116690>
 <28.192200,-83.090401,-26.975500>, <0.072602,0.990346,-0.118081>
 <27.006100,-83.017899,-27.076200>, <0.068657,0.990596,-0.118347>
}
   smooth_triangle{ <27.006100,-83.017899,-27.076200>, <0.068657,0.990596,-0.118347>
 <26.636900,-82.862000,-25.980200>, <0.068294,0.990728,-0.117445>
 <27.948299,-83.020103,-26.531000>, <0.071956,0.990558,-0.116690>
}
   smooth_triangle{ <27.453199,-82.864098,-25.507700>, <0.071742,0.990662,-0.115935>
 <27.948299,-83.020103,-26.531000>, <0.071956,0.990558,-0.116690>
 <26.636900,-82.862000,-25.980200>, <0.068294,0.990728,-0.117445>
}
   smooth_triangle{ <25.705200,-82.863701,-26.518700>, <0.064487,0.990867,-0.118423>
 <25.624201,-82.791199,-25.955000>, <0.063935,0.990989,-0.117701>
 <26.636900,-82.862000,-25.980200>, <0.068294,0.990728,-0.117445>
}
   smooth_triangle{ <26.482800,-82.789803,-25.458599>, <0.068103,0.990799,-0.116960>
 <26.636900,-82.862000,-25.980200>, <0.068294,0.990728,-0.117445>
 <25.624201,-82.791199,-25.955000>, <0.063935,0.990989,-0.117701>
}
   smooth_triangle{ <25.624201,-82.791199,-25.955000>, <0.063935,0.990989,-0.117701>
 <25.565500,-82.731400,-25.483101>, <0.063368,0.991086,-0.117192>
 <26.482800,-82.789803,-25.458599>, <0.068103,0.990799,-0.116960>
}
   smooth_triangle{ <26.361500,-82.730003,-25.022600>, <0.067951,0.990860,-0.116534>
 <26.482800,-82.789803,-25.458599>, <0.068103,0.990799,-0.116960>
 <25.565500,-82.731400,-25.483101>, <0.063368,0.991086,-0.117192>
}
   smooth_triangle{ <25.565500,-82.731400,-25.483101>, <0.063368,0.991086,-0.117192>
 <25.529600,-82.690804,-25.158899>, <0.062474,0.991253,-0.116254>
 <26.361500,-82.730003,-25.022600>, <0.067951,0.990860,-0.116534>
}
   smooth_triangle{ <26.281799,-82.689400,-24.723400>, <0.067904,0.990882,-0.116370>
 <26.361500,-82.730003,-25.022600>, <0.067951,0.990860,-0.116534>
 <25.529600,-82.690804,-25.158899>, <0.062474,0.991253,-0.116254>
}
   smooth_triangle{ <25.529600,-82.690804,-25.158899>, <0.062474,0.991253,-0.116254>
 <25.517599,-82.675797,-25.038300>, <0.063723,0.991078,-0.117066>
 <26.281799,-82.689400,-24.723400>, <0.067904,0.990882,-0.116370>
}
   smooth_triangle{ <26.253300,-82.674400,-24.612400>, <0.068556,0.990874,-0.116060>
 <26.281799,-82.689400,-24.723400>, <0.067904,0.990882,-0.116370>
 <25.517599,-82.675797,-25.038300>, <0.063723,0.991078,-0.117066>
}
   smooth_triangle{ <26.636900,-82.862000,-25.980200>, <0.068294,0.990728,-0.117445>
 <26.482800,-82.789803,-25.458599>, <0.068103,0.990799,-0.116960>
 <27.453199,-82.864098,-25.507700>, <0.071742,0.990662,-0.115935>
}
   smooth_triangle{ <27.235201,-82.791702,-25.023001>, <0.071690,0.990736,-0.115335>
 <27.453199,-82.864098,-25.507700>, <0.071742,0.990662,-0.115935>
 <26.482800,-82.789803,-25.458599>, <0.068103,0.990799,-0.116960>
}
   smooth_triangle{ <26.482800,-82.789803,-25.458599>, <0.068103,0.990799,-0.116960>
 <26.361500,-82.730003,-25.022600>, <0.067951,0.990860,-0.116534>
 <27.235201,-82.791702,-25.023001>, <0.071690,0.990736,-0.115335>
}
   smooth_triangle{ <27.058901,-82.732002,-24.618401>, <0.071724,0.990776,-0.114972>
 <27.235201,-82.791702,-25.023001>, <0.071690,0.990736,-0.115335>
 <26.361500,-82.730003,-25.022600>, <0.067951,0.990860,-0.116534>
}
   smooth_triangle{ <26.361500,-82.730003,-25.022600>, <0.067951,0.990860,-0.116534>
 <26.281799,-82.689400,-24.723400>, <0.067904,0.990882,-0.116370>
 <27.058901,-82.732002,-24.618401>, <0.071724,0.990776,-0.114972>
}
   smooth_triangle{ <26.940901,-82.691299,-24.341400>, <0.071715,0.990794,-0.114825>
 <27.058901,-82.732002,-24.618401>, <0.071724,0.990776,-0.114972>
 <26.281799,-82.689400,-24.723400>, <0.067904,0.990882,-0.116370>
}
   smooth_triangle{ <26.281799,-82.689400,-24.723400>, <0.067904,0.990882,-0.116370>
 <26.253300,-82.674400,-24.612400>, <0.068556,0.990874,-0.116060>
 <26.940901,-82.691299,-24.341400>, <0.071715,0.990794,-0.114825>
}
   smooth_triangle{ <26.897900,-82.676300,-24.238501>, <0.072099,0.990862,-0.113991>
 <26.940901,-82.691299,-24.341400>, <0.071715,0.990794,-0.114825>
 <26.253300,-82.674400,-24.612400>, <0.068556,0.990874,-0.116060>
}
   smooth_triangle{ <28.411501,-83.147202,-27.312599>, <0.072838,0.990251,-0.118732>
 <28.192200,-83.090401,-26.975500>, <0.072602,0.990346,-0.118081>
 <29.280399,-83.152397,-26.808300>, <0.075567,0.990324,-0.116398>
}
   smooth_triangle{ <29.038401,-83.095802,-26.484900>, <0.075403,0.990395,-0.115895>
 <29.280399,-83.152397,-26.808300>, <0.075567,0.990324,-0.116398>
 <28.192200,-83.090401,-26.975500>, <0.072602,0.990346,-0.118081>
}
   smooth_triangle{ <28.192200,-83.090401,-26.975500>, <0.072602,0.990346,-0.118081>
 <27.948299,-83.020103,-26.531000>, <0.071956,0.990558,-0.116690>
 <29.038401,-83.095802,-26.484900>, <0.075403,0.990395,-0.115895>
}
   smooth_triangle{ <28.754299,-83.025299,-26.063999>, <0.074936,0.990568,-0.114718>
 <29.038401,-83.095802,-26.484900>, <0.075403,0.990395,-0.115895>
 <27.948299,-83.020103,-26.531000>, <0.071956,0.990558,-0.116690>
}
   smooth_triangle{ <29.280399,-83.152397,-26.808300>, <0.075567,0.990324,-0.116398>
 <29.038401,-83.095802,-26.484900>, <0.075403,0.990395,-0.115895>
 <29.999100,-83.159599,-26.390900>, <0.078094,0.990394,-0.114112>
}
   smooth_triangle{ <29.738199,-83.102898,-26.078699>, <0.078014,0.990465,-0.113549>
 <29.999100,-83.159599,-26.390900>, <0.078094,0.990394,-0.114112>
 <29.038401,-83.095802,-26.484900>, <0.075403,0.990395,-0.115895>
}
   smooth_triangle{ <29.038401,-83.095802,-26.484900>, <0.075403,0.990395,-0.115895>
 <28.754299,-83.025299,-26.063999>, <0.074936,0.990568,-0.114718>
 <29.738199,-83.102898,-26.078699>, <0.078014,0.990465,-0.113549>
}
   smooth_triangle{ <29.420799,-83.032303,-25.677099>, <0.077689,0.990633,-0.112297>
 <29.738199,-83.102898,-26.078699>, <0.078014,0.990465,-0.113549>
 <28.754299,-83.025299,-26.063999>, <0.074936,0.990568,-0.114718>
}
   smooth_triangle{ <27.948299,-83.020103,-26.531000>, <0.071956,0.990558,-0.116690>
 <27.453199,-82.864098,-25.507700>, <0.071742,0.990662,-0.115935>
 <28.754299,-83.025299,-26.063999>, <0.074936,0.990568,-0.114718>
}
   smooth_triangle{ <28.151501,-82.868896,-25.103100>, <0.074941,0.990673,-0.113803>
 <28.754299,-83.025299,-26.063999>, <0.074936,0.990568,-0.114718>
 <27.453199,-82.864098,-25.507700>, <0.071742,0.990662,-0.115935>
}
   smooth_triangle{ <28.754299,-83.025299,-26.063999>, <0.074936,0.990568,-0.114718>
 <28.151501,-82.868896,-25.103100>, <0.074941,0.990673,-0.113803>
 <29.420799,-83.032303,-25.677099>, <0.077689,0.990633,-0.112297>
}
   smooth_triangle{ <28.728901,-82.875397,-24.767900>, <0.077813,0.990725,-0.111401>
 <29.420799,-83.032303,-25.677099>, <0.077689,0.990633,-0.112297>
 <28.151501,-82.868896,-25.103100>, <0.074941,0.990673,-0.113803>
}
   smooth_triangle{ <27.453199,-82.864098,-25.507700>, <0.071742,0.990662,-0.115935>
 <27.235201,-82.791702,-25.023001>, <0.071690,0.990736,-0.115335>
 <28.151501,-82.868896,-25.103100>, <0.074941,0.990673,-0.113803>
}
   smooth_triangle{ <27.878599,-82.796402,-24.649799>, <0.074972,0.990738,-0.113218>
 <28.151501,-82.868896,-25.103100>, <0.074941,0.990673,-0.113803>
 <27.235201,-82.791702,-25.023001>, <0.071690,0.990736,-0.115335>
}
   smooth_triangle{ <27.235201,-82.791702,-25.023001>, <0.071690,0.990736,-0.115335>
 <27.058901,-82.732002,-24.618401>, <0.071724,0.990776,-0.114972>
 <27.878599,-82.796402,-24.649799>, <0.074972,0.990738,-0.113218>
}
   smooth_triangle{ <27.655399,-82.736397,-24.272400>, <0.075078,0.990747,-0.113068>
 <27.878599,-82.796402,-24.649799>, <0.074972,0.990738,-0.113218>
 <27.058901,-82.732002,-24.618401>, <0.071724,0.990776,-0.114972>
}
   smooth_triangle{ <27.058901,-82.732002,-24.618401>, <0.071724,0.990776,-0.114972>
 <26.940901,-82.691299,-24.341400>, <0.071715,0.990794,-0.114825>
 <27.655399,-82.736397,-24.272400>, <0.075078,0.990747,-0.113068>
}
   smooth_triangle{ <27.504700,-82.695503,-24.014200>, <0.075009,0.990810,-0.112559>
 <27.655399,-82.736397,-24.272400>, <0.075078,0.990747,-0.113068>
 <26.940901,-82.691299,-24.341400>, <0.071715,0.990794,-0.114825>
}
   smooth_triangle{ <26.940901,-82.691299,-24.341400>, <0.071715,0.990794,-0.114825>
 <26.897900,-82.676300,-24.238501>, <0.072099,0.990862,-0.113991>
 <27.504700,-82.695503,-24.014200>, <0.075009,0.990810,-0.112559>
}
   smooth_triangle{ <27.449301,-82.680496,-23.918400>, <0.075317,0.990895,-0.111601>
 <27.504700,-82.695503,-24.014200>, <0.075009,0.990810,-0.112559>
 <26.897900,-82.676300,-24.238501>, <0.072099,0.990862,-0.113991>
}
   smooth_triangle{ <28.151501,-82.868896,-25.103100>, <0.074941,0.990673,-0.113803>
 <27.878599,-82.796402,-24.649799>, <0.074972,0.990738,-0.113218>
 <28.728901,-82.875397,-24.767900>, <0.077813,0.990725,-0.111401>
}
   smooth_triangle{ <28.410801,-82.802498,-24.340799>, <0.077938,0.990769,-0.110914>
 <28.728901,-82.875397,-24.767900>, <0.077813,0.990725,-0.111401>
 <27.878599,-82.796402,-24.649799>, <0.074972,0.990738,-0.113218>
}
   smooth_triangle{ <27.878599,-82.796402,-24.649799>, <0.074972,0.990738,-0.113218>
 <27.655399,-82.736397,-24.272400>, <0.075078,0.990747,-0.113068>
 <28.410801,-82.802498,-24.340799>, <0.077938,0.990769,-0.110914>
}
   smooth_triangle{ <28.148701,-82.742203,-23.985800>, <0.078088,0.990786,-0.110660>
 <28.410801,-82.802498,-24.340799>, <0.077938,0.990769,-0.110914>
 <27.655399,-82.736397,-24.272400>, <0.075078,0.990747,-0.113068>
}
   smooth_triangle{ <27.655399,-82.736397,-24.272400>, <0.075078,0.990747,-0.113068>
 <27.504700,-82.695503,-24.014200>, <0.075009,0.990810,-0.112559>
 <28.148701,-82.742203,-23.985800>, <0.078088,0.990786,-0.110660>
}
   smooth_triangle{ <27.970800,-82.701103,-23.743200>, <0.078023,0.990856,-0.110074>
 <28.148701,-82.742203,-23.985800>, <0.078088,0.990786,-0.110660>
 <27.504700,-82.695503,-24.014200>, <0.075009,0.990810,-0.112559>
}
   smooth_triangle{ <27.504700,-82.695503,-24.014200>, <0.075009,0.990810,-0.112559>
 <27.449301,-82.680496,-23.918400>, <0.075317,0.990895,-0.111601>
 <27.970800,-82.701103,-23.743200>, <0.078023,0.990856,-0.110074>
}
   smooth_triangle{ <27.905300,-82.685997,-23.653299>, <0.078378,0.990921,-0.109231>
 <27.970800,-82.701103,-23.743200>, <0.078023,0.990856,-0.110074>
 <27.449301,-82.680496,-23.918400>, <0.075317,0.990895,-0.111601>
}
   smooth_triangle{ <29.999100,-83.159599,-26.390900>, <0.078094,0.990394,-0.114112>
 <29.738199,-83.102898,-26.078699>, <0.078014,0.990465,-0.113549>
 <30.563900,-83.167397,-26.062401>, <0.080528,0.990482,-0.111631>
}
   smooth_triangle{ <30.288099,-83.110703,-25.759001>, <0.080416,0.990564,-0.110981>
 <30.563900,-83.167397,-26.062401>, <0.080528,0.990482,-0.111631>
 <29.738199,-83.102898,-26.078699>, <0.078014,0.990465,-0.113549>
}
   smooth_triangle{ <29.738199,-83.102898,-26.078699>, <0.078014,0.990465,-0.113549>
 <29.420799,-83.032303,-25.677099>, <0.077689,0.990633,-0.112297>
 <30.288099,-83.110703,-25.759001>, <0.080416,0.990564,-0.110981>
}
   smooth_triangle{ <29.944500,-83.039902,-25.372801>, <0.080185,0.990713,-0.109812>
 <30.288099,-83.110703,-25.759001>, <0.080416,0.990564,-0.110981>
 <29.420799,-83.032303,-25.677099>, <0.077689,0.990633,-0.112297>
}
   smooth_triangle{ <30.563900,-83.167397,-26.062401>, <0.080528,0.990482,-0.111631>
 <30.288099,-83.110703,-25.759001>, <0.080416,0.990564,-0.110981>
 <30.971701,-83.174500,-25.825001>, <0.087593,0.990658,-0.104516>
}
   smooth_triangle{ <30.685101,-83.117798,-25.527901>, <0.087600,0.990737,-0.103762>
 <30.971701,-83.174500,-25.825001>, <0.087593,0.990658,-0.104516>
 <30.288099,-83.110703,-25.759001>, <0.080416,0.990564,-0.110981>
}
   smooth_triangle{ <30.288099,-83.110703,-25.759001>, <0.080416,0.990564,-0.110981>
 <29.944500,-83.039902,-25.372801>, <0.080185,0.990713,-0.109812>
 <30.685101,-83.117798,-25.527901>, <0.087600,0.990737,-0.103762>
}
   smooth_triangle{ <30.322599,-83.046799,-25.152700>, <0.087373,0.990877,-0.102606>
 <30.685101,-83.117798,-25.527901>, <0.087600,0.990737,-0.103762>
 <29.944500,-83.039902,-25.372801>, <0.080185,0.990713,-0.109812>
}
   smooth_triangle{ <30.971701,-83.174500,-25.825001>, <0.087593,0.990658,-0.104516>
 <30.685101,-83.117798,-25.527901>, <0.087600,0.990737,-0.103762>
 <31.218399,-83.183502,-25.680500>, <0.059042,0.989423,-0.132499>
}
   smooth_triangle{ <30.925501,-83.126602,-25.387199>, <0.058894,0.989459,-0.132294>
 <31.218399,-83.183502,-25.680500>, <0.059042,0.989423,-0.132499>
 <30.685101,-83.117798,-25.527901>, <0.087600,0.990737,-0.103762>
}
   smooth_triangle{ <31.218399,-83.183502,-25.680500>, <0.059042,0.989423,-0.132499>
 <30.925501,-83.126602,-25.387199>, <0.058894,0.989459,-0.132294>
 <31.301901,-83.181900,-25.632401>, <0.058145,0.989354,-0.133405>
}
   smooth_triangle{ <31.006701,-83.125099,-25.340500>, <0.058203,0.989401,-0.133031>
 <31.301901,-83.181900,-25.632401>, <0.058145,0.989354,-0.133405>
 <30.925501,-83.126602,-25.387199>, <0.058894,0.989459,-0.132294>
}
   smooth_triangle{ <30.685101,-83.117798,-25.527901>, <0.087600,0.990737,-0.103762>
 <30.322599,-83.046799,-25.152700>, <0.087373,0.990877,-0.102606>
 <30.925501,-83.126602,-25.387199>, <0.058894,0.989459,-0.132294>
}
   smooth_triangle{ <30.551600,-83.055298,-25.018801>, <0.058580,0.989564,-0.131648>
 <30.925501,-83.126602,-25.387199>, <0.058894,0.989459,-0.132294>
 <30.322599,-83.046799,-25.152700>, <0.087373,0.990877,-0.102606>
}
   smooth_triangle{ <30.551600,-83.055298,-25.018801>, <-0.043661,-0.988235,0.146580>
 <30.925501,-83.126602,-25.387199>, <-0.038576,-0.987569,0.152377>
 <31.006701,-83.125099,-25.340500>, <-0.058213,-0.989399,0.133043>
}
   smooth_triangle{ <30.551600,-83.055298,-25.018801>, <0.058580,0.989564,-0.131648>
 <31.006701,-83.125099,-25.340500>, <0.058203,0.989401,-0.133031>
 <30.925501,-83.126602,-25.387199>, <0.058894,0.989459,-0.132294>
}
   smooth_triangle{ <31.006701,-83.125099,-25.340500>, <-0.058213,-0.989399,0.133043>
 <30.628799,-83.053902,-24.974300>, <-0.058218,-0.989533,0.132044>
 <30.551600,-83.055298,-25.018801>, <-0.043661,-0.988235,0.146580>
}
   smooth_triangle{ <31.006701,-83.125099,-25.340500>, <0.058203,0.989401,-0.133031>
 <30.551600,-83.055298,-25.018801>, <0.058580,0.989564,-0.131648>
 <30.628799,-83.053902,-24.974300>, <0.058160,0.989525,-0.132124>
}
   smooth_triangle{ <29.420799,-83.032303,-25.677099>, <0.077689,0.990633,-0.112297>
 <28.728901,-82.875397,-24.767900>, <0.077813,0.990725,-0.111401>
 <29.944500,-83.039902,-25.372801>, <0.080185,0.990713,-0.109812>
}
   smooth_triangle{ <29.182699,-82.882401,-24.504101>, <0.080419,0.990795,-0.108896>
 <29.944500,-83.039902,-25.372801>, <0.080185,0.990713,-0.109812>
 <28.728901,-82.875397,-24.767900>, <0.077813,0.990725,-0.111401>
}
   smooth_triangle{ <29.944500,-83.039902,-25.372801>, <0.080185,0.990713,-0.109812>
 <29.182699,-82.882401,-24.504101>, <0.080419,0.990795,-0.108896>
 <30.322599,-83.046799,-25.152700>, <0.087373,0.990877,-0.102606>
}
   smooth_triangle{ <29.510300,-82.888702,-24.313400>, <0.087700,0.990956,-0.101563>
 <30.322599,-83.046799,-25.152700>, <0.087373,0.990877,-0.102606>
 <29.182699,-82.882401,-24.504101>, <0.080419,0.990795,-0.108896>
}
   smooth_triangle{ <30.322599,-83.046799,-25.152700>, <0.087373,0.990877,-0.102606>
 <29.510300,-82.888702,-24.313400>, <0.087700,0.990956,-0.101563>
 <30.551600,-83.055298,-25.018801>, <0.058580,0.989564,-0.131648>
}
   smooth_triangle{ <29.708599,-82.896301,-24.197300>, <0.058065,0.989600,-0.131609>
 <30.551600,-83.055298,-25.018801>, <0.058580,0.989564,-0.131648>
 <29.510300,-82.888702,-24.313400>, <0.087700,0.990956,-0.101563>
}
   smooth_triangle{ <30.551600,-83.055298,-25.018801>, <0.058580,0.989564,-0.131648>
 <29.708599,-82.896301,-24.197300>, <0.058065,0.989600,-0.131609>
 <30.628799,-83.053902,-24.974300>, <0.058160,0.989525,-0.132124>
}
   smooth_triangle{ <29.775600,-82.895103,-24.158800>, <0.057703,0.989551,-0.132133>
 <30.628799,-83.053902,-24.974300>, <0.058160,0.989525,-0.132124>
 <29.708599,-82.896301,-24.197300>, <0.058065,0.989600,-0.131609>
}
   smooth_triangle{ <28.728901,-82.875397,-24.767900>, <0.077813,0.990725,-0.111401>
 <28.410801,-82.802498,-24.340799>, <0.077938,0.990769,-0.110914>
 <29.182699,-82.882401,-24.504101>, <0.080419,0.990795,-0.108896>
}
   smooth_triangle{ <28.829000,-82.809097,-24.097601>, <0.080654,0.990833,-0.108370>
 <29.182699,-82.882401,-24.504101>, <0.080419,0.990795,-0.108896>
 <28.410801,-82.802498,-24.340799>, <0.077938,0.990769,-0.110914>
}
   smooth_triangle{ <29.182699,-82.882401,-24.504101>, <0.080419,0.990795,-0.108896>
 <28.829000,-82.809097,-24.097601>, <0.080654,0.990833,-0.108370>
 <29.510300,-82.888702,-24.313400>, <0.087700,0.990956,-0.101563>
}
   smooth_triangle{ <29.130800,-82.815102,-23.921900>, <0.088247,0.990998,-0.100673>
 <29.510300,-82.888702,-24.313400>, <0.087700,0.990956,-0.101563>
 <28.829000,-82.809097,-24.097601>, <0.080654,0.990833,-0.108370>
}
   smooth_triangle{ <28.410801,-82.802498,-24.340799>, <0.077938,0.990769,-0.110914>
 <28.148701,-82.742203,-23.985800>, <0.078088,0.990786,-0.110660>
 <28.829000,-82.809097,-24.097601>, <0.080654,0.990833,-0.108370>
}
   smooth_triangle{ <28.536400,-82.748398,-23.760300>, <0.080855,0.990858,-0.107991>
 <28.829000,-82.809097,-24.097601>, <0.080654,0.990833,-0.108370>
 <28.148701,-82.742203,-23.985800>, <0.078088,0.990786,-0.110660>
}
   smooth_triangle{ <28.829000,-82.809097,-24.097601>, <0.080654,0.990833,-0.108370>
 <28.536400,-82.748398,-23.760300>, <0.080855,0.990858,-0.107991>
 <29.130800,-82.815102,-23.921900>, <0.088247,0.990998,-0.100673>
}
   smooth_triangle{ <28.816299,-82.754097,-23.597200>, <0.088678,0.991020,-0.100079>
 <29.130800,-82.815102,-23.921900>, <0.088247,0.990998,-0.100673>
 <28.536400,-82.748398,-23.760300>, <0.080855,0.990858,-0.107991>
}
   smooth_triangle{ <29.510300,-82.888702,-24.313400>, <0.087700,0.990956,-0.101563>
 <29.130800,-82.815102,-23.921900>, <0.088247,0.990998,-0.100673>
 <29.708599,-82.896301,-24.197300>, <0.058065,0.989600,-0.131609>
}
   smooth_triangle{ <29.313601,-82.822403,-23.814800>, <0.057422,0.989568,-0.132127>
 <29.708599,-82.896301,-24.197300>, <0.058065,0.989600,-0.131609>
 <29.130800,-82.815102,-23.921900>, <0.088247,0.990998,-0.100673>
}
   smooth_triangle{ <29.313601,-82.822403,-23.814800>, <-0.041757,-0.988112,0.147957>
 <29.708599,-82.896301,-24.197300>, <-0.036814,-0.987548,0.152951>
 <29.775600,-82.895103,-24.158800>, <-0.057521,-0.989542,0.132279>
}
   smooth_triangle{ <29.313601,-82.822403,-23.814800>, <0.057422,0.989568,-0.132127>
 <29.775600,-82.895103,-24.158800>, <0.057703,0.989551,-0.132133>
 <29.708599,-82.896301,-24.197300>, <0.058065,0.989600,-0.131609>
}
   smooth_triangle{ <29.775600,-82.895103,-24.158800>, <-0.057521,-0.989542,0.132279>
 <29.375401,-82.821098,-23.779301>, <-0.055928,-0.989439,0.133725>
 <29.313601,-82.822403,-23.814800>, <-0.041757,-0.988112,0.147957>
}
   smooth_triangle{ <29.775600,-82.895103,-24.158800>, <0.057703,0.989551,-0.132133>
 <29.313601,-82.822403,-23.814800>, <0.057422,0.989568,-0.132127>
 <29.375401,-82.821098,-23.779301>, <0.056485,0.989489,-0.133119>
}
   smooth_triangle{ <29.130800,-82.815102,-23.921900>, <0.088247,0.990998,-0.100673>
 <28.816299,-82.754097,-23.597200>, <0.088678,0.991020,-0.100079>
 <29.313601,-82.822403,-23.814800>, <0.057422,0.989568,-0.132127>
}
   smooth_triangle{ <28.985701,-82.761002,-23.497999>, <0.057523,0.989588,-0.131933>
 <29.313601,-82.822403,-23.814800>, <0.057422,0.989568,-0.132127>
 <28.816299,-82.754097,-23.597200>, <0.088678,0.991020,-0.100079>
}
   smooth_triangle{ <29.313601,-82.822403,-23.814800>, <0.057422,0.989568,-0.132127>
 <28.985701,-82.761002,-23.497999>, <0.057523,0.989588,-0.131933>
 <29.375401,-82.821098,-23.779301>, <0.056485,0.989489,-0.133119>
}
   smooth_triangle{ <29.042900,-82.759903,-23.465000>, <0.057073,0.989560,-0.132343>
 <29.375401,-82.821098,-23.779301>, <0.056485,0.989489,-0.133119>
 <28.985701,-82.761002,-23.497999>, <0.057523,0.989588,-0.131933>
}
   smooth_triangle{ <28.148701,-82.742203,-23.985800>, <0.078088,0.990786,-0.110660>
 <27.970800,-82.701103,-23.743200>, <0.078023,0.990856,-0.110074>
 <28.536400,-82.748398,-23.760300>, <0.080855,0.990858,-0.107991>
}
   smooth_triangle{ <28.337200,-82.707100,-23.530001>, <0.080853,0.990931,-0.107325>
 <28.536400,-82.748398,-23.760300>, <0.080855,0.990858,-0.107991>
 <27.970800,-82.701103,-23.743200>, <0.078023,0.990856,-0.110074>
}
   smooth_triangle{ <27.970800,-82.701103,-23.743200>, <0.078023,0.990856,-0.110074>
 <27.905300,-82.685997,-23.653299>, <0.078378,0.990921,-0.109231>
 <28.337200,-82.707100,-23.530001>, <0.080853,0.990931,-0.107325>
}
   smooth_triangle{ <28.263700,-82.691902,-23.444700>, <0.081223,0.990994,-0.106458>
 <28.337200,-82.707100,-23.530001>, <0.080853,0.990931,-0.107325>
 <27.905300,-82.685997,-23.653299>, <0.078378,0.990921,-0.109231>
}
   smooth_triangle{ <28.536400,-82.748398,-23.760300>, <0.080855,0.990858,-0.107991>
 <28.337200,-82.707100,-23.530001>, <0.080853,0.990931,-0.107325>
 <28.816299,-82.754097,-23.597200>, <0.088678,0.991020,-0.100079>
}
   smooth_triangle{ <28.601700,-82.712601,-23.375900>, <0.088754,0.991081,-0.099400>
 <28.816299,-82.754097,-23.597200>, <0.088678,0.991020,-0.100079>
 <28.337200,-82.707100,-23.530001>, <0.080853,0.990931,-0.107325>
}
   smooth_triangle{ <28.337200,-82.707100,-23.530001>, <0.080853,0.990931,-0.107325>
 <28.263700,-82.691902,-23.444700>, <0.081223,0.990994,-0.106458>
 <28.601700,-82.712601,-23.375900>, <0.088754,0.991081,-0.099400>
}
   smooth_triangle{ <28.522400,-82.697304,-23.293900>, <0.090889,0.991139,-0.096860>
 <28.601700,-82.712601,-23.375900>, <0.088754,0.991081,-0.099400>
 <28.263700,-82.691902,-23.444700>, <0.081223,0.990994,-0.106458>
}
   smooth_triangle{ <28.816299,-82.754097,-23.597200>, <0.088678,0.991020,-0.100079>
 <28.601700,-82.712601,-23.375900>, <0.088754,0.991081,-0.099400>
 <28.985701,-82.761002,-23.497999>, <0.057523,0.989588,-0.131933>
}
   smooth_triangle{ <28.761801,-82.719200,-23.282000>, <0.057479,0.989635,-0.131604>
 <28.985701,-82.761002,-23.497999>, <0.057523,0.989588,-0.131933>
 <28.601700,-82.712601,-23.375900>, <0.088754,0.991081,-0.099400>
}
   smooth_triangle{ <28.761801,-82.719200,-23.282000>, <-0.041207,-0.988103,0.148168>
 <28.985701,-82.761002,-23.497999>, <-0.035220,-0.987366,0.154490>
 <29.042900,-82.759903,-23.465000>, <-0.057006,-0.989548,0.132460>
}
   smooth_triangle{ <28.761801,-82.719200,-23.282000>, <0.057479,0.989635,-0.131604>
 <29.042900,-82.759903,-23.465000>, <0.057073,0.989560,-0.132343>
 <28.985701,-82.761002,-23.497999>, <0.057523,0.989588,-0.131933>
}
   smooth_triangle{ <29.042900,-82.759903,-23.465000>, <-0.057006,-0.989548,0.132460>
 <28.816000,-82.718201,-23.250799>, <-0.057501,-0.989635,0.131589>
 <28.761801,-82.719200,-23.282000>, <-0.041207,-0.988103,0.148168>
}
   smooth_triangle{ <29.042900,-82.759903,-23.465000>, <0.057073,0.989560,-0.132343>
 <28.761801,-82.719200,-23.282000>, <0.057479,0.989635,-0.131604>
 <28.816000,-82.718201,-23.250799>, <0.057422,0.989628,-0.131677>
}
   smooth_triangle{ <28.601700,-82.712601,-23.375900>, <0.088754,0.991081,-0.099400>
 <28.522400,-82.697304,-23.293900>, <0.090889,0.991139,-0.096860>
 <28.761801,-82.719200,-23.282000>, <0.057479,0.989635,-0.131604>
}
   smooth_triangle{ <28.678900,-82.703796,-23.202200>, <0.050898,0.989143,-0.137864>
 <28.761801,-82.719200,-23.282000>, <0.057479,0.989635,-0.131604>
 <28.522400,-82.697304,-23.293900>, <0.090889,0.991139,-0.096860>
}
   smooth_triangle{ <28.761801,-82.719200,-23.282000>, <0.057479,0.989635,-0.131604>
 <28.678900,-82.703796,-23.202200>, <0.050898,0.989143,-0.137864>
 <28.816000,-82.718201,-23.250799>, <0.057422,0.989628,-0.131677>
}
   smooth_triangle{ <28.731899,-82.702797,-23.171600>, <0.057347,0.989650,-0.131542>
 <28.816000,-82.718201,-23.250799>, <0.057422,0.989628,-0.131677>
 <28.678900,-82.703796,-23.202200>, <0.050898,0.989143,-0.137864>
}
   smooth_triangle{ <31.301901,-83.181900,-25.632401>, <-0.057977,-0.989338,0.133603>
 <31.006701,-83.125099,-25.340500>, <-0.058213,-0.989399,0.133043>
 <31.218399,-83.183502,-25.680500>, <-0.044437,-0.988171,0.146777>
}
   smooth_triangle{ <31.301901,-83.181900,-25.632401>, <0.058145,0.989354,-0.133405>
 <31.218399,-83.183502,-25.680500>, <0.059042,0.989423,-0.132499>
 <31.006701,-83.125099,-25.340500>, <0.058203,0.989401,-0.133031>
}
   smooth_triangle{ <30.925501,-83.126602,-25.387199>, <-0.038576,-0.987569,0.152377>
 <31.218399,-83.183502,-25.680500>, <-0.044437,-0.988171,0.146777>
 <31.006701,-83.125099,-25.340500>, <-0.058213,-0.989399,0.133043>
}
   smooth_triangle{ <30.925501,-83.126602,-25.387199>, <0.058894,0.989459,-0.132294>
 <31.006701,-83.125099,-25.340500>, <0.058203,0.989401,-0.133031>
 <31.218399,-83.183502,-25.680500>, <0.059042,0.989423,-0.132499>
}
   smooth_triangle{ <31.218399,-83.183502,-25.680500>, <-0.044437,-0.988171,0.146777>
 <30.925501,-83.126602,-25.387199>, <-0.038576,-0.987569,0.152377>
 <30.969801,-83.200500,-25.821699>, <-0.032662,-0.986883,0.158101>
}
   smooth_triangle{ <31.218399,-83.183502,-25.680500>, <0.059042,0.989423,-0.132499>
 <30.969801,-83.200500,-25.821699>, <0.032662,0.986883,-0.158101>
 <30.925501,-83.126602,-25.387199>, <0.058894,0.989459,-0.132294>
}
   smooth_triangle{ <30.683399,-83.143501,-25.524700>, <-0.031880,-0.986860,0.158400>
 <30.969801,-83.200500,-25.821699>, <-0.032662,-0.986883,0.158101>
 <30.925501,-83.126602,-25.387199>, <-0.038576,-0.987569,0.152377>
}
   smooth_triangle{ <30.683399,-83.143501,-25.524700>, <0.031880,0.986860,-0.158400>
 <30.925501,-83.126602,-25.387199>, <0.058894,0.989459,-0.132294>
 <30.969801,-83.200500,-25.821699>, <0.032662,0.986883,-0.158101>
}
   smooth_triangle{ <30.628799,-83.053902,-24.974300>, <0.058160,0.989525,-0.132124>
 <31.006701,-83.125099,-25.340500>, <0.058203,0.989401,-0.133031>
 <30.925501,-83.126602,-25.387199>, <0.058894,0.989459,-0.132294>
}
   smooth_triangle{ <30.925501,-83.126602,-25.387199>, <0.058894,0.989459,-0.132294>
 <30.551600,-83.055298,-25.018801>, <0.058580,0.989564,-0.131648>
 <30.628799,-83.053902,-24.974300>, <0.058160,0.989525,-0.132124>
}
   smooth_triangle{ <30.925501,-83.126602,-25.387199>, <-0.038576,-0.987569,0.152377>
 <30.551600,-83.055298,-25.018801>, <-0.043661,-0.988235,0.146580>
 <30.683399,-83.143501,-25.524700>, <-0.031880,-0.986860,0.158400>
}
   smooth_triangle{ <30.925501,-83.126602,-25.387199>, <0.058894,0.989459,-0.132294>
 <30.683399,-83.143501,-25.524700>, <0.031880,0.986860,-0.158400>
 <30.551600,-83.055298,-25.018801>, <0.058580,0.989564,-0.131648>
}
   smooth_triangle{ <30.320999,-83.071701,-25.149599>, <-0.030938,-0.986798,0.158974>
 <30.683399,-83.143501,-25.524700>, <-0.031880,-0.986860,0.158400>
 <30.551600,-83.055298,-25.018801>, <-0.043661,-0.988235,0.146580>
}
   smooth_triangle{ <30.320999,-83.071701,-25.149599>, <0.030938,0.986798,-0.158974>
 <30.551600,-83.055298,-25.018801>, <0.058580,0.989564,-0.131648>
 <30.683399,-83.143501,-25.524700>, <0.031880,0.986860,-0.158400>
}
   smooth_triangle{ <30.969801,-83.200500,-25.821699>, <-0.032662,-0.986883,0.158101>
 <30.683399,-83.143501,-25.524700>, <-0.031880,-0.986860,0.158400>
 <30.560400,-83.220001,-26.055700>, <-0.041811,-0.987958,0.148966>
}
   smooth_triangle{ <30.969801,-83.200500,-25.821699>, <0.032662,0.986883,-0.158101>
 <30.560400,-83.220001,-26.055700>, <0.041811,0.987958,-0.148966>
 <30.683399,-83.143501,-25.524700>, <0.031880,0.986860,-0.158400>
}
   smooth_triangle{ <30.284599,-83.162697,-25.752501>, <-0.041273,-0.987994,0.148880>
 <30.560400,-83.220001,-26.055700>, <-0.041811,-0.987958,0.148966>
 <30.683399,-83.143501,-25.524700>, <-0.031880,-0.986860,0.158400>
}
   smooth_triangle{ <30.284599,-83.162697,-25.752501>, <0.041273,0.987994,-0.148880>
 <30.683399,-83.143501,-25.524700>, <0.031880,0.986860,-0.158400>
 <30.560400,-83.220001,-26.055700>, <0.041811,0.987958,-0.148966>
}
   smooth_triangle{ <30.683399,-83.143501,-25.524700>, <-0.031880,-0.986860,0.158400>
 <30.320999,-83.071701,-25.149599>, <-0.030938,-0.986798,0.158974>
 <30.284599,-83.162697,-25.752501>, <-0.041273,-0.987994,0.148880>
}
   smooth_triangle{ <30.683399,-83.143501,-25.524700>, <0.031880,0.986860,-0.158400>
 <30.284599,-83.162697,-25.752501>, <0.041273,0.987994,-0.148880>
 <30.320999,-83.071701,-25.149599>, <0.030938,0.986798,-0.158974>
}
   smooth_triangle{ <29.941099,-83.090202,-25.366400>, <-0.040604,-0.987964,0.149261>
 <30.284599,-83.162697,-25.752501>, <-0.041273,-0.987994,0.148880>
 <30.320999,-83.071701,-25.149599>, <-0.030938,-0.986798,0.158974>
}
   smooth_triangle{ <29.941099,-83.090202,-25.366400>, <0.040604,0.987964,-0.149261>
 <30.320999,-83.071701,-25.149599>, <0.030938,0.986798,-0.158974>
 <30.284599,-83.162697,-25.752501>, <0.041273,0.987994,-0.148880>
}
   smooth_triangle{ <30.560400,-83.220001,-26.055700>, <-0.041811,-0.987958,0.148966>
 <30.284599,-83.162697,-25.752501>, <-0.041273,-0.987994,0.148880>
 <29.993401,-83.242699,-26.380400>, <-0.046769,-0.988456,0.144107>
}
   smooth_triangle{ <30.560400,-83.220001,-26.055700>, <0.041811,0.987958,-0.148966>
 <29.993401,-83.242699,-26.380400>, <0.046769,0.988456,-0.144107>
 <30.284599,-83.162697,-25.752501>, <0.041273,0.987994,-0.148880>
}
   smooth_triangle{ <29.732599,-83.185097,-26.068199>, <-0.046144,-0.988522,0.143856>
 <29.993401,-83.242699,-26.380400>, <-0.046769,-0.988456,0.144107>
 <30.284599,-83.162697,-25.752501>, <-0.041273,-0.987994,0.148880>
}
   smooth_triangle{ <29.732599,-83.185097,-26.068199>, <0.046144,0.988522,-0.143856>
 <30.284599,-83.162697,-25.752501>, <0.041273,0.987994,-0.148880>
 <29.993401,-83.242699,-26.380400>, <0.046769,0.988456,-0.144107>
}
   smooth_triangle{ <30.284599,-83.162697,-25.752501>, <-0.041273,-0.987994,0.148880>
 <29.941099,-83.090202,-25.366400>, <-0.040604,-0.987964,0.149261>
 <29.732599,-83.185097,-26.068199>, <-0.046144,-0.988522,0.143856>
}
   smooth_triangle{ <30.284599,-83.162697,-25.752501>, <0.041273,0.987994,-0.148880>
 <29.732599,-83.185097,-26.068199>, <0.046144,0.988522,-0.143856>
 <29.941099,-83.090202,-25.366400>, <0.040604,0.987964,-0.149261>
}
   smooth_triangle{ <29.415300,-83.111900,-25.667101>, <-0.045718,-0.988479,0.144288>
 <29.732599,-83.185097,-26.068199>, <-0.046144,-0.988522,0.143856>
 <29.941099,-83.090202,-25.366400>, <-0.040604,-0.987964,0.149261>
}
   smooth_triangle{ <29.415300,-83.111900,-25.667101>, <0.045718,0.988479,-0.144288>
 <29.941099,-83.090202,-25.366400>, <0.040604,0.987964,-0.149261>
 <29.732599,-83.185097,-26.068199>, <0.046144,0.988522,-0.143856>
}
   smooth_triangle{ <30.628799,-83.053902,-24.974300>, <-0.058218,-0.989533,0.132044>
 <29.775600,-82.895103,-24.158800>, <-0.057521,-0.989542,0.132279>
 <30.551600,-83.055298,-25.018801>, <-0.043661,-0.988235,0.146580>
}
   smooth_triangle{ <30.628799,-83.053902,-24.974300>, <0.058160,0.989525,-0.132124>
 <30.551600,-83.055298,-25.018801>, <0.058580,0.989564,-0.131648>
 <29.775600,-82.895103,-24.158800>, <0.057703,0.989551,-0.132133>
}
   smooth_triangle{ <29.708599,-82.896301,-24.197300>, <-0.036814,-0.987548,0.152951>
 <30.551600,-83.055298,-25.018801>, <-0.043661,-0.988235,0.146580>
 <29.775600,-82.895103,-24.158800>, <-0.057521,-0.989542,0.132279>
}
   smooth_triangle{ <29.708599,-82.896301,-24.197300>, <0.058065,0.989600,-0.131609>
 <29.775600,-82.895103,-24.158800>, <0.057703,0.989551,-0.132133>
 <30.551600,-83.055298,-25.018801>, <0.058580,0.989564,-0.131648>
}
   smooth_triangle{ <30.551600,-83.055298,-25.018801>, <-0.043661,-0.988235,0.146580>
 <29.708599,-82.896301,-24.197300>, <-0.036814,-0.987548,0.152951>
 <30.320999,-83.071701,-25.149599>, <-0.030938,-0.986798,0.158974>
}
   smooth_triangle{ <30.551600,-83.055298,-25.018801>, <0.058580,0.989564,-0.131648>
 <30.320999,-83.071701,-25.149599>, <0.030938,0.986798,-0.158974>
 <29.708599,-82.896301,-24.197300>, <0.058065,0.989600,-0.131609>
}
   smooth_triangle{ <29.508801,-82.911102,-24.310600>, <-0.029652,-0.986666,0.160036>
 <30.320999,-83.071701,-25.149599>, <-0.030938,-0.986798,0.158974>
 <29.708599,-82.896301,-24.197300>, <-0.036814,-0.987548,0.152951>
}
   smooth_triangle{ <29.508801,-82.911102,-24.310600>, <0.029652,0.986666,-0.160036>
 <29.708599,-82.896301,-24.197300>, <0.058065,0.989600,-0.131609>
 <30.320999,-83.071701,-25.149599>, <0.030938,0.986798,-0.158974>
}
   smooth_triangle{ <30.320999,-83.071701,-25.149599>, <-0.030938,-0.986798,0.158974>
 <29.508801,-82.911102,-24.310600>, <-0.029652,-0.986666,0.160036>
 <29.941099,-83.090202,-25.366400>, <-0.040604,-0.987964,0.149261>
}
   smooth_triangle{ <30.320999,-83.071701,-25.149599>, <0.030938,0.986798,-0.158974>
 <29.941099,-83.090202,-25.366400>, <0.040604,0.987964,-0.149261>
 <29.508801,-82.911102,-24.310600>, <0.029652,0.986666,-0.160036>
}
   smooth_triangle{ <29.179701,-82.927803,-24.498400>, <-0.039642,-0.987882,0.150061>
 <29.941099,-83.090202,-25.366400>, <-0.040604,-0.987964,0.149261>
 <29.508801,-82.911102,-24.310600>, <-0.029652,-0.986666,0.160036>
}
   smooth_triangle{ <29.179701,-82.927803,-24.498400>, <0.039642,0.987882,-0.150061>
 <29.508801,-82.911102,-24.310600>, <0.029652,0.986666,-0.160036>
 <29.941099,-83.090202,-25.366400>, <0.040604,0.987964,-0.149261>
}
   smooth_triangle{ <29.941099,-83.090202,-25.366400>, <-0.040604,-0.987964,0.149261>
 <29.179701,-82.927803,-24.498400>, <-0.039642,-0.987882,0.150061>
 <29.415300,-83.111900,-25.667101>, <-0.045718,-0.988479,0.144288>
}
   smooth_triangle{ <29.941099,-83.090202,-25.366400>, <0.040604,0.987964,-0.149261>
 <29.415300,-83.111900,-25.667101>, <0.045718,0.988479,-0.144288>
 <29.179701,-82.927803,-24.498400>, <0.039642,0.987882,-0.150061>
}
   smooth_triangle{ <28.724001,-82.947197,-24.758699>, <-0.044969,-0.988416,0.144950>
 <29.415300,-83.111900,-25.667101>, <-0.045718,-0.988479,0.144288>
 <29.179701,-82.927803,-24.498400>, <-0.039642,-0.987882,0.150061>
}
   smooth_triangle{ <28.724001,-82.947197,-24.758699>, <0.044969,0.988416,-0.144950>
 <29.179701,-82.927803,-24.498400>, <0.039642,0.987882,-0.150061>
 <29.415300,-83.111900,-25.667101>, <0.045718,0.988479,-0.144288>
}
   smooth_triangle{ <29.375401,-82.821098,-23.779301>, <0.056485,0.989489,-0.133119>
 <29.775600,-82.895103,-24.158800>, <0.057703,0.989551,-0.132133>
 <29.708599,-82.896301,-24.197300>, <0.058065,0.989600,-0.131609>
}
   smooth_triangle{ <29.708599,-82.896301,-24.197300>, <0.058065,0.989600,-0.131609>
 <29.313601,-82.822403,-23.814800>, <0.057422,0.989568,-0.132127>
 <29.375401,-82.821098,-23.779301>, <0.056485,0.989489,-0.133119>
}
   smooth_triangle{ <29.708599,-82.896301,-24.197300>, <-0.036814,-0.987548,0.152951>
 <29.313601,-82.822403,-23.814800>, <-0.041757,-0.988112,0.147957>
 <29.508801,-82.911102,-24.310600>, <-0.029652,-0.986666,0.160036>
}
   smooth_triangle{ <29.708599,-82.896301,-24.197300>, <0.058065,0.989600,-0.131609>
 <29.508801,-82.911102,-24.310600>, <0.029652,0.986666,-0.160036>
 <29.313601,-82.822403,-23.814800>, <0.057422,0.989568,-0.132127>
}
   smooth_triangle{ <29.129400,-82.836197,-23.919201>, <-0.028745,-0.986560,0.160853>
 <29.508801,-82.911102,-24.310600>, <-0.029652,-0.986666,0.160036>
 <29.313601,-82.822403,-23.814800>, <-0.041757,-0.988112,0.147957>
}
   smooth_triangle{ <29.129400,-82.836197,-23.919201>, <0.028745,0.986560,-0.160853>
 <29.313601,-82.822403,-23.814800>, <0.057422,0.989568,-0.132127>
 <29.508801,-82.911102,-24.310600>, <0.029652,0.986666,-0.160036>
}
   smooth_triangle{ <29.375401,-82.821098,-23.779301>, <-0.055928,-0.989439,0.133725>
 <29.042900,-82.759903,-23.465000>, <-0.057006,-0.989548,0.132460>
 <29.313601,-82.822403,-23.814800>, <-0.041757,-0.988112,0.147957>
}
   smooth_triangle{ <29.375401,-82.821098,-23.779301>, <0.056485,0.989489,-0.133119>
 <29.313601,-82.822403,-23.814800>, <0.057422,0.989568,-0.132127>
 <29.042900,-82.759903,-23.465000>, <0.057073,0.989560,-0.132343>
}
   smooth_triangle{ <28.985701,-82.761002,-23.497999>, <-0.035220,-0.987366,0.154490>
 <29.313601,-82.822403,-23.814800>, <-0.041757,-0.988112,0.147957>
 <29.042900,-82.759903,-23.465000>, <-0.057006,-0.989548,0.132460>
}
   smooth_triangle{ <28.985701,-82.761002,-23.497999>, <0.057523,0.989588,-0.131933>
 <29.042900,-82.759903,-23.465000>, <0.057073,0.989560,-0.132343>
 <29.313601,-82.822403,-23.814800>, <0.057422,0.989568,-0.132127>
}
   smooth_triangle{ <29.313601,-82.822403,-23.814800>, <-0.041757,-0.988112,0.147957>
 <28.985701,-82.761002,-23.497999>, <-0.035220,-0.987366,0.154490>
 <29.129400,-82.836197,-23.919201>, <-0.028745,-0.986560,0.160853>
}
   smooth_triangle{ <29.313601,-82.822403,-23.814800>, <0.057422,0.989568,-0.132127>
 <29.129400,-82.836197,-23.919201>, <0.028745,0.986560,-0.160853>
 <28.985701,-82.761002,-23.497999>, <0.057523,0.989588,-0.131933>
}
   smooth_triangle{ <28.814899,-82.774200,-23.594700>, <-0.027840,-0.986445,0.161712>
 <29.129400,-82.836197,-23.919201>, <-0.028745,-0.986560,0.160853>
 <28.985701,-82.761002,-23.497999>, <-0.035220,-0.987366,0.154490>
}
   smooth_triangle{ <28.814899,-82.774200,-23.594700>, <0.027840,0.986445,-0.161712>
 <28.985701,-82.761002,-23.497999>, <0.057523,0.989588,-0.131933>
 <29.129400,-82.836197,-23.919201>, <0.028745,0.986560,-0.160853>
}
   smooth_triangle{ <29.508801,-82.911102,-24.310600>, <-0.029652,-0.986666,0.160036>
 <29.129400,-82.836197,-23.919201>, <-0.028745,-0.986560,0.160853>
 <29.179701,-82.927803,-24.498400>, <-0.039642,-0.987882,0.150061>
}
   smooth_triangle{ <29.508801,-82.911102,-24.310600>, <0.029652,0.986666,-0.160036>
 <29.179701,-82.927803,-24.498400>, <0.039642,0.987882,-0.150061>
 <29.129400,-82.836197,-23.919201>, <0.028745,0.986560,-0.160853>
}
   smooth_triangle{ <28.826099,-82.851898,-24.092199>, <-0.038901,-0.987831,0.150585>
 <29.179701,-82.927803,-24.498400>, <-0.039642,-0.987882,0.150061>
 <29.129400,-82.836197,-23.919201>, <-0.028745,-0.986560,0.160853>
}
   smooth_triangle{ <28.826099,-82.851898,-24.092199>, <0.038901,0.987831,-0.150585>
 <29.129400,-82.836197,-23.919201>, <0.028745,0.986560,-0.160853>
 <29.179701,-82.927803,-24.498400>, <0.039642,0.987882,-0.150061>
}
   smooth_triangle{ <29.179701,-82.927803,-24.498400>, <-0.039642,-0.987882,0.150061>
 <28.826099,-82.851898,-24.092199>, <-0.038901,-0.987831,0.150585>
 <28.724001,-82.947197,-24.758699>, <-0.044969,-0.988416,0.144950>
}
   smooth_triangle{ <29.179701,-82.927803,-24.498400>, <0.039642,0.987882,-0.150061>
 <28.724001,-82.947197,-24.758699>, <0.044969,0.988416,-0.144950>
 <28.826099,-82.851898,-24.092199>, <0.038901,0.987831,-0.150585>
}
   smooth_triangle{ <28.406200,-82.870201,-24.332199>, <-0.044279,-0.988381,0.145405>
 <28.724001,-82.947197,-24.758699>, <-0.044969,-0.988416,0.144950>
 <28.826099,-82.851898,-24.092199>, <-0.038901,-0.987831,0.150585>
}
   smooth_triangle{ <28.406200,-82.870201,-24.332199>, <0.044279,0.988381,-0.145405>
 <28.826099,-82.851898,-24.092199>, <0.038901,0.987831,-0.150585>
 <28.724001,-82.947197,-24.758699>, <0.044969,0.988416,-0.144950>
}
   smooth_triangle{ <29.129400,-82.836197,-23.919201>, <-0.028745,-0.986560,0.160853>
 <28.814899,-82.774200,-23.594700>, <-0.027840,-0.986445,0.161712>
 <28.826099,-82.851898,-24.092199>, <-0.038901,-0.987831,0.150585>
}
   smooth_triangle{ <29.129400,-82.836197,-23.919201>, <0.028745,0.986560,-0.160853>
 <28.826099,-82.851898,-24.092199>, <0.038901,0.987831,-0.150585>
 <28.814899,-82.774200,-23.594700>, <0.027840,0.986445,-0.161712>
}
   smooth_triangle{ <28.533701,-82.789001,-23.755100>, <-0.038393,-0.987762,0.151170>
 <28.826099,-82.851898,-24.092199>, <-0.038901,-0.987831,0.150585>
 <28.814899,-82.774200,-23.594700>, <-0.027840,-0.986445,0.161712>
}
   smooth_triangle{ <28.533701,-82.789001,-23.755100>, <0.038393,0.987762,-0.151170>
 <28.814899,-82.774200,-23.594700>, <0.027840,0.986445,-0.161712>
 <28.826099,-82.851898,-24.092199>, <0.038901,0.987831,-0.150585>
}
   smooth_triangle{ <28.826099,-82.851898,-24.092199>, <-0.038901,-0.987831,0.150585>
 <28.533701,-82.789001,-23.755100>, <-0.038393,-0.987762,0.151170>
 <28.406200,-82.870201,-24.332199>, <-0.044279,-0.988381,0.145405>
}
   smooth_triangle{ <28.826099,-82.851898,-24.092199>, <0.038901,0.987831,-0.150585>
 <28.406200,-82.870201,-24.332199>, <0.044279,0.988381,-0.145405>
 <28.533701,-82.789001,-23.755100>, <0.038393,0.987762,-0.151170>
}
   smooth_triangle{ <28.144400,-82.806297,-23.977699>, <-0.043806,-0.988335,0.145858>
 <28.406200,-82.870201,-24.332199>, <-0.044279,-0.988381,0.145405>
 <28.533701,-82.789001,-23.755100>, <-0.038393,-0.987762,0.151170>
}
   smooth_triangle{ <28.144400,-82.806297,-23.977699>, <0.043806,0.988335,-0.145858>
 <28.533701,-82.789001,-23.755100>, <0.038393,0.987762,-0.151170>
 <28.406200,-82.870201,-24.332199>, <0.044279,0.988381,-0.145405>
}
   smooth_triangle{ <28.816000,-82.718201,-23.250799>, <0.057422,0.989628,-0.131677>
 <29.042900,-82.759903,-23.465000>, <0.057073,0.989560,-0.132343>
 <28.985701,-82.761002,-23.497999>, <0.057523,0.989588,-0.131933>
}
   smooth_triangle{ <28.985701,-82.761002,-23.497999>, <0.057523,0.989588,-0.131933>
 <28.761801,-82.719200,-23.282000>, <0.057479,0.989635,-0.131604>
 <28.816000,-82.718201,-23.250799>, <0.057422,0.989628,-0.131677>
}
   smooth_triangle{ <28.985701,-82.761002,-23.497999>, <-0.035220,-0.987366,0.154490>
 <28.761801,-82.719200,-23.282000>, <-0.041207,-0.988103,0.148168>
 <28.814899,-82.774200,-23.594700>, <-0.027840,-0.986445,0.161712>
}
   smooth_triangle{ <28.985701,-82.761002,-23.497999>, <0.057523,0.989588,-0.131933>
 <28.814899,-82.774200,-23.594700>, <0.027840,0.986445,-0.161712>
 <28.761801,-82.719200,-23.282000>, <0.057479,0.989635,-0.131604>
}
   smooth_triangle{ <28.600401,-82.731796,-23.373400>, <-0.027258,-0.986410,0.162027>
 <28.814899,-82.774200,-23.594700>, <-0.027840,-0.986445,0.161712>
 <28.761801,-82.719200,-23.282000>, <-0.041207,-0.988103,0.148168>
}
   smooth_triangle{ <28.600401,-82.731796,-23.373400>, <0.027258,0.986410,-0.162027>
 <28.761801,-82.719200,-23.282000>, <0.057479,0.989635,-0.131604>
 <28.814899,-82.774200,-23.594700>, <0.027840,0.986445,-0.161712>
}
   smooth_triangle{ <28.816000,-82.718201,-23.250799>, <-0.057501,-0.989635,0.131589>
 <28.731899,-82.702797,-23.171600>, <-0.057359,-0.989654,0.131508>
 <28.761801,-82.719200,-23.282000>, <-0.041207,-0.988103,0.148168>
}
   smooth_triangle{ <28.816000,-82.718201,-23.250799>, <0.057422,0.989628,-0.131677>
 <28.761801,-82.719200,-23.282000>, <0.057479,0.989635,-0.131604>
 <28.731899,-82.702797,-23.171600>, <0.057347,0.989650,-0.131542>
}
   smooth_triangle{ <28.678900,-82.703796,-23.202200>, <-0.031746,-0.987069,0.157122>
 <28.761801,-82.719200,-23.282000>, <-0.041207,-0.988103,0.148168>
 <28.731899,-82.702797,-23.171600>, <-0.057359,-0.989654,0.131508>
}
   smooth_triangle{ <28.678900,-82.703796,-23.202200>, <0.050898,0.989143,-0.137864>
 <28.731899,-82.702797,-23.171600>, <0.057347,0.989650,-0.131542>
 <28.761801,-82.719200,-23.282000>, <0.057479,0.989635,-0.131604>
}
   smooth_triangle{ <28.761801,-82.719200,-23.282000>, <-0.041207,-0.988103,0.148168>
 <28.678900,-82.703796,-23.202200>, <-0.031746,-0.987069,0.157122>
 <28.600401,-82.731796,-23.373400>, <-0.027258,-0.986410,0.162027>
}
   smooth_triangle{ <28.761801,-82.719200,-23.282000>, <0.057479,0.989635,-0.131604>
 <28.600401,-82.731796,-23.373400>, <0.027258,0.986410,-0.162027>
 <28.678900,-82.703796,-23.202200>, <0.050898,0.989143,-0.137864>
}
   smooth_triangle{ <28.521000,-82.716202,-23.291500>, <-0.029358,-0.986829,0.159081>
 <28.600401,-82.731796,-23.373400>, <-0.027258,-0.986410,0.162027>
 <28.678900,-82.703796,-23.202200>, <-0.031746,-0.987069,0.157122>
}
   smooth_triangle{ <28.521000,-82.716202,-23.291500>, <0.029358,0.986829,-0.159081>
 <28.678900,-82.703796,-23.202200>, <0.050898,0.989143,-0.137864>
 <28.600401,-82.731796,-23.373400>, <0.027258,0.986410,-0.162027>
}
   smooth_triangle{ <28.814899,-82.774200,-23.594700>, <-0.027840,-0.986445,0.161712>
 <28.600401,-82.731796,-23.373400>, <-0.027258,-0.986410,0.162027>
 <28.533701,-82.789001,-23.755100>, <-0.038393,-0.987762,0.151170>
}
   smooth_triangle{ <28.814899,-82.774200,-23.594700>, <0.027840,0.986445,-0.161712>
 <28.533701,-82.789001,-23.755100>, <0.038393,0.987762,-0.151170>
 <28.600401,-82.731796,-23.373400>, <0.027258,0.986410,-0.162027>
}
   smooth_triangle{ <28.334600,-82.746002,-23.525000>, <-0.037690,-0.987770,0.151291>
 <28.533701,-82.789001,-23.755100>, <-0.038393,-0.987762,0.151170>
 <28.600401,-82.731796,-23.373400>, <-0.027258,-0.986410,0.162027>
}
   smooth_triangle{ <28.334600,-82.746002,-23.525000>, <0.037690,0.987770,-0.151291>
 <28.600401,-82.731796,-23.373400>, <0.027258,0.986410,-0.162027>
 <28.533701,-82.789001,-23.755100>, <0.038393,0.987762,-0.151170>
}
   smooth_triangle{ <28.600401,-82.731796,-23.373400>, <-0.027258,-0.986410,0.162027>
 <28.521000,-82.716202,-23.291500>, <-0.029358,-0.986829,0.159081>
 <28.334600,-82.746002,-23.525000>, <-0.037690,-0.987770,0.151291>
}
   smooth_triangle{ <28.600401,-82.731796,-23.373400>, <0.027258,0.986410,-0.162027>
 <28.334600,-82.746002,-23.525000>, <0.037690,0.987770,-0.151291>
 <28.521000,-82.716202,-23.291500>, <0.029358,0.986829,-0.159081>
}
   smooth_triangle{ <28.261000,-82.730202,-23.439899>, <-0.038126,-0.987925,0.150166>
 <28.334600,-82.746002,-23.525000>, <-0.037690,-0.987770,0.151291>
 <28.521000,-82.716202,-23.291500>, <-0.029358,-0.986829,0.159081>
}
   smooth_triangle{ <28.261000,-82.730202,-23.439899>, <0.038126,0.987925,-0.150166>
 <28.521000,-82.716202,-23.291500>, <0.029358,0.986829,-0.159081>
 <28.334600,-82.746002,-23.525000>, <0.037690,0.987770,-0.151291>
}
   smooth_triangle{ <28.533701,-82.789001,-23.755100>, <-0.038393,-0.987762,0.151170>
 <28.334600,-82.746002,-23.525000>, <-0.037690,-0.987770,0.151291>
 <28.144400,-82.806297,-23.977699>, <-0.043806,-0.988335,0.145858>
}
   smooth_triangle{ <28.533701,-82.789001,-23.755100>, <0.038393,0.987762,-0.151170>
 <28.144400,-82.806297,-23.977699>, <0.043806,0.988335,-0.145858>
 <28.334600,-82.746002,-23.525000>, <0.037690,0.987770,-0.151291>
}
   smooth_triangle{ <27.966700,-82.762703,-23.735399>, <-0.043271,-0.988353,0.145898>
 <28.144400,-82.806297,-23.977699>, <-0.043806,-0.988335,0.145858>
 <28.334600,-82.746002,-23.525000>, <-0.037690,-0.987770,0.151291>
}
   smooth_triangle{ <27.966700,-82.762703,-23.735399>, <0.043271,0.988353,-0.145898>
 <28.334600,-82.746002,-23.525000>, <0.037690,0.987770,-0.151291>
 <28.144400,-82.806297,-23.977699>, <0.043806,0.988335,-0.145858>
}
   smooth_triangle{ <28.334600,-82.746002,-23.525000>, <-0.037690,-0.987770,0.151291>
 <28.261000,-82.730202,-23.439899>, <-0.038126,-0.987925,0.150166>
 <27.966700,-82.762703,-23.735399>, <-0.043271,-0.988353,0.145898>
}
   smooth_triangle{ <28.334600,-82.746002,-23.525000>, <0.037690,0.987770,-0.151291>
 <27.966700,-82.762703,-23.735399>, <0.043271,0.988353,-0.145898>
 <28.261000,-82.730202,-23.439899>, <0.038126,0.987925,-0.150166>
}
   smooth_triangle{ <27.901199,-82.746597,-23.645599>, <-0.044135,-0.988459,0.144920>
 <27.966700,-82.762703,-23.735399>, <-0.043271,-0.988353,0.145898>
 <28.261000,-82.730202,-23.439899>, <-0.038126,-0.987925,0.150166>
}
   smooth_triangle{ <27.901199,-82.746597,-23.645599>, <0.044135,0.988459,-0.144920>
 <28.261000,-82.730202,-23.439899>, <0.038126,0.987925,-0.150166>
 <27.966700,-82.762703,-23.735399>, <0.043271,0.988353,-0.145898>
}
   smooth_triangle{ <29.993401,-83.242699,-26.380400>, <-0.046769,-0.988456,0.144107>
 <29.732599,-83.185097,-26.068199>, <-0.046144,-0.988522,0.143856>
 <29.272699,-83.265999,-26.794001>, <-0.051861,-0.988893,0.139288>
}
   smooth_triangle{ <29.993401,-83.242699,-26.380400>, <0.046769,0.988456,-0.144107>
 <29.272699,-83.265999,-26.794001>, <0.051861,0.988893,-0.139288>
 <29.732599,-83.185097,-26.068199>, <0.046144,0.988522,-0.143856>
}
   smooth_triangle{ <29.030701,-83.208000,-26.470699>, <-0.051434,-0.988943,0.139091>
 <29.272699,-83.265999,-26.794001>, <-0.051861,-0.988893,0.139288>
 <29.732599,-83.185097,-26.068199>, <-0.046144,-0.988522,0.143856>
}
   smooth_triangle{ <29.030701,-83.208000,-26.470699>, <0.051434,0.988943,-0.139091>
 <29.732599,-83.185097,-26.068199>, <0.046144,0.988522,-0.143856>
 <29.272699,-83.265999,-26.794001>, <0.051861,0.988893,-0.139288>
}
   smooth_triangle{ <29.732599,-83.185097,-26.068199>, <-0.046144,-0.988522,0.143856>
 <29.415300,-83.111900,-25.667101>, <-0.045718,-0.988479,0.144288>
 <29.030701,-83.208000,-26.470699>, <-0.051434,-0.988943,0.139091>
}
   smooth_triangle{ <29.732599,-83.185097,-26.068199>, <0.046144,0.988522,-0.143856>
 <29.030701,-83.208000,-26.470699>, <0.051434,0.988943,-0.139091>
 <29.415300,-83.111900,-25.667101>, <0.045718,0.988479,-0.144288>
}
   smooth_triangle{ <28.746901,-83.134003,-26.050200>, <-0.051190,-0.988879,0.139637>
 <29.030701,-83.208000,-26.470699>, <-0.051434,-0.988943,0.139091>
 <29.415300,-83.111900,-25.667101>, <-0.045718,-0.988479,0.144288>
}
   smooth_triangle{ <28.746901,-83.134003,-26.050200>, <0.051190,0.988879,-0.139637>
 <29.415300,-83.111900,-25.667101>, <0.045718,0.988479,-0.144288>
 <29.030701,-83.208000,-26.470699>, <0.051434,0.988943,-0.139091>
}
   smooth_triangle{ <29.272699,-83.265999,-26.794001>, <-0.051861,-0.988893,0.139288>
 <29.030701,-83.208000,-26.470699>, <-0.051434,-0.988943,0.139091>
 <28.402000,-83.287399,-27.294901>, <-0.057313,-0.989211,0.134820>
}
   smooth_triangle{ <29.272699,-83.265999,-26.794001>, <0.051861,0.988893,-0.139288>
 <28.402000,-83.287399,-27.294901>, <0.057313,0.989211,-0.134820>
 <29.030701,-83.208000,-26.470699>, <0.051434,0.988943,-0.139091>
}
   smooth_triangle{ <28.182800,-83.228996,-26.958000>, <-0.056992,-0.989246,0.134700>
 <28.402000,-83.287399,-27.294901>, <-0.057313,-0.989211,0.134820>
 <29.030701,-83.208000,-26.470699>, <-0.051434,-0.988943,0.139091>
}
   smooth_triangle{ <28.182800,-83.228996,-26.958000>, <0.056992,0.989246,-0.134700>
 <29.030701,-83.208000,-26.470699>, <0.051434,0.988943,-0.139091>
 <28.402000,-83.287399,-27.294901>, <0.057313,0.989211,-0.134820>
}
   smooth_triangle{ <29.030701,-83.208000,-26.470699>, <-0.051434,-0.988943,0.139091>
 <28.746901,-83.134003,-26.050200>, <-0.051190,-0.988879,0.139637>
 <28.182800,-83.228996,-26.958000>, <-0.056992,-0.989246,0.134700>
}
   smooth_triangle{ <29.030701,-83.208000,-26.470699>, <0.051434,0.988943,-0.139091>
 <28.182800,-83.228996,-26.958000>, <0.056992,0.989246,-0.134700>
 <28.746901,-83.134003,-26.050200>, <0.051190,0.988879,-0.139637>
}
   smooth_triangle{ <27.939199,-83.154297,-26.514000>, <-0.057098,-0.989122,0.135563>
 <28.182800,-83.228996,-26.958000>, <-0.056992,-0.989246,0.134700>
 <28.746901,-83.134003,-26.050200>, <-0.051190,-0.988879,0.139637>
}
   smooth_triangle{ <27.939199,-83.154297,-26.514000>, <0.057098,0.989122,-0.135563>
 <28.746901,-83.134003,-26.050200>, <0.051190,0.988879,-0.139637>
 <28.182800,-83.228996,-26.958000>, <0.056992,0.989246,-0.134700>
}
   smooth_triangle{ <29.415300,-83.111900,-25.667101>, <-0.045718,-0.988479,0.144288>
 <28.724001,-82.947197,-24.758699>, <-0.044969,-0.988416,0.144950>
 <28.746901,-83.134003,-26.050200>, <-0.051190,-0.988879,0.139637>
}
   smooth_triangle{ <29.415300,-83.111900,-25.667101>, <0.045718,0.988479,-0.144288>
 <28.746901,-83.134003,-26.050200>, <0.051190,0.988879,-0.139637>
 <28.724001,-82.947197,-24.758699>, <0.044969,0.988416,-0.144950>
}
   smooth_triangle{ <28.144899,-82.967102,-25.090599>, <-0.050604,-0.988823,0.140246>
 <28.746901,-83.134003,-26.050200>, <-0.051190,-0.988879,0.139637>
 <28.724001,-82.947197,-24.758699>, <-0.044969,-0.988416,0.144950>
}
   smooth_triangle{ <28.144899,-82.967102,-25.090599>, <0.050604,0.988823,-0.140246>
 <28.724001,-82.947197,-24.758699>, <0.044969,0.988416,-0.144950>
 <28.746901,-83.134003,-26.050200>, <0.051190,0.988879,-0.139637>
}
   smooth_triangle{ <28.746901,-83.134003,-26.050200>, <-0.051190,-0.988879,0.139637>
 <28.144899,-82.967102,-25.090599>, <-0.050604,-0.988823,0.140246>
 <27.939199,-83.154297,-26.514000>, <-0.057098,-0.989122,0.135563>
}
   smooth_triangle{ <28.746901,-83.134003,-26.050200>, <0.051190,0.988879,-0.139637>
 <27.939199,-83.154297,-26.514000>, <0.057098,0.989122,-0.135563>
 <28.144899,-82.967102,-25.090599>, <0.050604,0.988823,-0.140246>
}
   smooth_triangle{ <27.445000,-82.985298,-25.492399>, <-0.056952,-0.989038,0.136240>
 <27.939199,-83.154297,-26.514000>, <-0.057098,-0.989122,0.135563>
 <28.144899,-82.967102,-25.090599>, <-0.050604,-0.988823,0.140246>
}
   smooth_triangle{ <27.445000,-82.985298,-25.492399>, <0.056952,0.989038,-0.136240>
 <28.144899,-82.967102,-25.090599>, <0.050604,0.988823,-0.140246>
 <27.939199,-83.154297,-26.514000>, <0.057098,0.989122,-0.135563>
}
   smooth_triangle{ <28.724001,-82.947197,-24.758699>, <-0.044969,-0.988416,0.144950>
 <28.406200,-82.870201,-24.332199>, <-0.044279,-0.988381,0.145405>
 <28.144899,-82.967102,-25.090599>, <-0.050604,-0.988823,0.140246>
}
   smooth_triangle{ <28.724001,-82.947197,-24.758699>, <0.044969,0.988416,-0.144950>
 <28.144899,-82.967102,-25.090599>, <0.050604,0.988823,-0.140246>
 <28.406200,-82.870201,-24.332199>, <0.044279,0.988381,-0.145405>
}
   smooth_triangle{ <27.872400,-82.889000,-24.638100>, <-0.050228,-0.988780,0.140680>
 <28.144899,-82.967102,-25.090599>, <-0.050604,-0.988823,0.140246>
 <28.406200,-82.870201,-24.332199>, <-0.044279,-0.988381,0.145405>
}
   smooth_triangle{ <27.872400,-82.889000,-24.638100>, <0.050228,0.988780,-0.140680>
 <28.406200,-82.870201,-24.332199>, <0.044279,0.988381,-0.145405>
 <28.144899,-82.967102,-25.090599>, <0.050604,0.988823,-0.140246>
}
   smooth_triangle{ <28.406200,-82.870201,-24.332199>, <-0.044279,-0.988381,0.145405>
 <28.144400,-82.806297,-23.977699>, <-0.043806,-0.988335,0.145858>
 <27.872400,-82.889000,-24.638100>, <-0.050228,-0.988780,0.140680>
}
   smooth_triangle{ <28.406200,-82.870201,-24.332199>, <0.044279,0.988381,-0.145405>
 <27.872400,-82.889000,-24.638100>, <0.050228,0.988780,-0.140680>
 <28.144400,-82.806297,-23.977699>, <0.043806,0.988335,-0.145858>
}
   smooth_triangle{ <27.649500,-82.823997,-24.261400>, <-0.049936,-0.988749,0.141004>
 <27.872400,-82.889000,-24.638100>, <-0.050228,-0.988780,0.140680>
 <28.144400,-82.806297,-23.977699>, <-0.043806,-0.988335,0.145858>
}
   smooth_triangle{ <27.649500,-82.823997,-24.261400>, <0.049936,0.988749,-0.141004>
 <28.144400,-82.806297,-23.977699>, <0.043806,0.988335,-0.145858>
 <27.872400,-82.889000,-24.638100>, <0.050228,0.988780,-0.140680>
}
   smooth_triangle{ <28.144400,-82.806297,-23.977699>, <-0.043806,-0.988335,0.145858>
 <27.966700,-82.762703,-23.735399>, <-0.043271,-0.988353,0.145898>
 <27.649500,-82.823997,-24.261400>, <-0.049936,-0.988749,0.141004>
}
   smooth_triangle{ <28.144400,-82.806297,-23.977699>, <0.043806,0.988335,-0.145858>
 <27.649500,-82.823997,-24.261400>, <0.049936,0.988749,-0.141004>
 <27.966700,-82.762703,-23.735399>, <0.043271,0.988353,-0.145898>
}
   smooth_triangle{ <27.498899,-82.779602,-24.003500>, <-0.049539,-0.988758,0.141077>
 <27.649500,-82.823997,-24.261400>, <-0.049936,-0.988749,0.141004>
 <27.966700,-82.762703,-23.735399>, <-0.043271,-0.988353,0.145898>
}
   smooth_triangle{ <27.498899,-82.779602,-24.003500>, <0.049539,0.988758,-0.141077>
 <27.966700,-82.762703,-23.735399>, <0.043271,0.988353,-0.145898>
 <27.649500,-82.823997,-24.261400>, <0.049936,0.988749,-0.141004>
}
   smooth_triangle{ <27.966700,-82.762703,-23.735399>, <-0.043271,-0.988353,0.145898>
 <27.901199,-82.746597,-23.645599>, <-0.044135,-0.988459,0.144920>
 <27.498899,-82.779602,-24.003500>, <-0.049539,-0.988758,0.141077>
}
   smooth_triangle{ <27.966700,-82.762703,-23.735399>, <0.043271,0.988353,-0.145898>
 <27.498899,-82.779602,-24.003500>, <0.049539,0.988758,-0.141077>
 <27.901199,-82.746597,-23.645599>, <0.044135,0.988459,-0.144920>
}
   smooth_triangle{ <27.443701,-82.763199,-23.908001>, <-0.050490,-0.988795,0.140482>
 <27.498899,-82.779602,-24.003500>, <-0.049539,-0.988758,0.141077>
 <27.901199,-82.746597,-23.645599>, <-0.044135,-0.988459,0.144920>
}
   smooth_triangle{ <27.443701,-82.763199,-23.908001>, <0.050490,0.988795,-0.140482>
 <27.901199,-82.746597,-23.645599>, <0.044135,0.988459,-0.144920>
 <27.498899,-82.779602,-24.003500>, <0.049539,0.988758,-0.141077>
}
   smooth_triangle{ <28.144899,-82.967102,-25.090599>, <-0.050604,-0.988823,0.140246>
 <27.872400,-82.889000,-24.638100>, <-0.050228,-0.988780,0.140680>
 <27.445000,-82.985298,-25.492399>, <-0.056952,-0.989038,0.136240>
}
   smooth_triangle{ <28.144899,-82.967102,-25.090599>, <0.050604,0.988823,-0.140246>
 <27.445000,-82.985298,-25.492399>, <0.056952,0.989038,-0.136240>
 <27.872400,-82.889000,-24.638100>, <0.050228,0.988780,-0.140680>
}
   smooth_triangle{ <27.227301,-82.905998,-25.008499>, <-0.056770,-0.988992,0.136645>
 <27.445000,-82.985298,-25.492399>, <-0.056952,-0.989038,0.136240>
 <27.872400,-82.889000,-24.638100>, <-0.050228,-0.988780,0.140680>
}
   smooth_triangle{ <27.227301,-82.905998,-25.008499>, <0.056770,0.988992,-0.136645>
 <27.872400,-82.889000,-24.638100>, <0.050228,0.988780,-0.140680>
 <27.445000,-82.985298,-25.492399>, <0.056952,0.989038,-0.136240>
}
   smooth_triangle{ <27.872400,-82.889000,-24.638100>, <-0.050228,-0.988780,0.140680>
 <27.649500,-82.823997,-24.261400>, <-0.049936,-0.988749,0.141004>
 <27.227301,-82.905998,-25.008499>, <-0.056770,-0.988992,0.136645>
}
   smooth_triangle{ <27.872400,-82.889000,-24.638100>, <0.050228,0.988780,-0.140680>
 <27.227301,-82.905998,-25.008499>, <0.056770,0.988992,-0.136645>
 <27.649500,-82.823997,-24.261400>, <0.049936,0.988749,-0.141004>
}
   smooth_triangle{ <27.051500,-82.840103,-24.604799>, <-0.056399,-0.988990,0.136813>
 <27.227301,-82.905998,-25.008499>, <-0.056770,-0.988992,0.136645>
 <27.649500,-82.823997,-24.261400>, <-0.049936,-0.988749,0.141004>
}
   smooth_triangle{ <27.051500,-82.840103,-24.604799>, <0.056399,0.988990,-0.136813>
 <27.649500,-82.823997,-24.261400>, <0.049936,0.988749,-0.141004>
 <27.227301,-82.905998,-25.008499>, <0.056770,0.988992,-0.136645>
}
   smooth_triangle{ <27.649500,-82.823997,-24.261400>, <-0.049936,-0.988749,0.141004>
 <27.498899,-82.779602,-24.003500>, <-0.049539,-0.988758,0.141077>
 <27.051500,-82.840103,-24.604799>, <-0.056399,-0.988990,0.136813>
}
   smooth_triangle{ <27.649500,-82.823997,-24.261400>, <0.049936,0.988749,-0.141004>
 <27.051500,-82.840103,-24.604799>, <0.056399,0.988990,-0.136813>
 <27.498899,-82.779602,-24.003500>, <0.049539,0.988758,-0.141077>
}
   smooth_triangle{ <26.933800,-82.795197,-24.328199>, <-0.056243,-0.988963,0.137071>
 <27.051500,-82.840103,-24.604799>, <-0.056399,-0.988990,0.136813>
 <27.498899,-82.779602,-24.003500>, <-0.049539,-0.988758,0.141077>
}
   smooth_triangle{ <26.933800,-82.795197,-24.328199>, <0.056243,0.988963,-0.137071>
 <27.498899,-82.779602,-24.003500>, <0.049539,0.988758,-0.141077>
 <27.051500,-82.840103,-24.604799>, <0.056399,0.988990,-0.136813>
}
   smooth_triangle{ <27.498899,-82.779602,-24.003500>, <-0.049539,-0.988758,0.141077>
 <27.443701,-82.763199,-23.908001>, <-0.050490,-0.988795,0.140482>
 <26.933800,-82.795197,-24.328199>, <-0.056243,-0.988963,0.137071>
}
   smooth_triangle{ <27.498899,-82.779602,-24.003500>, <0.049539,0.988758,-0.141077>
 <26.933800,-82.795197,-24.328199>, <0.056243,0.988963,-0.137071>
 <27.443701,-82.763199,-23.908001>, <0.050490,0.988795,-0.140482>
}
   smooth_triangle{ <26.891001,-82.778503,-24.225599>, <-0.057555,-0.988941,0.136690>
 <26.933800,-82.795197,-24.328199>, <-0.056243,-0.988963,0.137071>
 <27.443701,-82.763199,-23.908001>, <-0.050490,-0.988795,0.140482>
}
   smooth_triangle{ <26.891001,-82.778503,-24.225599>, <0.057555,0.988941,-0.136690>
 <27.443701,-82.763199,-23.908001>, <0.050490,0.988795,-0.140482>
 <26.933800,-82.795197,-24.328199>, <0.056243,0.988963,-0.137071>
}
   smooth_triangle{ <28.402000,-83.287399,-27.294901>, <-0.057313,-0.989211,0.134820>
 <28.182800,-83.228996,-26.958000>, <-0.056992,-0.989246,0.134700>
 <27.384899,-83.304100,-27.881500>, <-0.063168,-0.989411,0.130676>
}
   smooth_triangle{ <28.402000,-83.287399,-27.294901>, <0.057313,0.989211,-0.134820>
 <27.384899,-83.304100,-27.881500>, <0.063168,0.989411,-0.130676>
 <28.182800,-83.228996,-26.958000>, <0.056992,0.989246,-0.134700>
}
   smooth_triangle{ <27.192200,-83.245499,-27.528500>, <-0.063155,-0.989386,0.130868>
 <27.384899,-83.304100,-27.881500>, <-0.063168,-0.989411,0.130676>
 <28.182800,-83.228996,-26.958000>, <-0.056992,-0.989246,0.134700>
}
   smooth_triangle{ <27.192200,-83.245499,-27.528500>, <0.063155,0.989386,-0.130868>
 <28.182800,-83.228996,-26.958000>, <0.056992,0.989246,-0.134700>
 <27.384899,-83.304100,-27.881500>, <0.063168,0.989411,-0.130676>
}
   smooth_triangle{ <28.182800,-83.228996,-26.958000>, <-0.056992,-0.989246,0.134700>
 <27.939199,-83.154297,-26.514000>, <-0.057098,-0.989122,0.135563>
 <27.192200,-83.245499,-27.528500>, <-0.063155,-0.989386,0.130868>
}
   smooth_triangle{ <28.182800,-83.228996,-26.958000>, <0.056992,0.989246,-0.134700>
 <27.192200,-83.245499,-27.528500>, <0.063155,0.989386,-0.130868>
 <27.939199,-83.154297,-26.514000>, <0.057098,0.989122,-0.135563>
}
   smooth_triangle{ <26.995701,-83.170097,-27.056999>, <-0.063747,-0.989171,0.132202>
 <27.192200,-83.245499,-27.528500>, <-0.063155,-0.989386,0.130868>
 <27.939199,-83.154297,-26.514000>, <-0.057098,-0.989122,0.135563>
}
   smooth_triangle{ <26.995701,-83.170097,-27.056999>, <0.063747,0.989171,-0.132202>
 <27.939199,-83.154297,-26.514000>, <0.057098,0.989122,-0.135563>
 <27.192200,-83.245499,-27.528500>, <0.063155,0.989386,-0.130868>
}
   smooth_triangle{ <27.939199,-83.154297,-26.514000>, <-0.057098,-0.989122,0.135563>
 <27.445000,-82.985298,-25.492399>, <-0.056952,-0.989038,0.136240>
 <26.995701,-83.170097,-27.056999>, <-0.063747,-0.989171,0.132202>
}
   smooth_triangle{ <27.939199,-83.154297,-26.514000>, <0.057098,0.989122,-0.135563>
 <26.995701,-83.170097,-27.056999>, <0.063747,0.989171,-0.132202>
 <27.445000,-82.985298,-25.492399>, <0.056952,0.989038,-0.136240>
}
   smooth_triangle{ <26.627501,-82.999397,-25.962900>, <-0.063886,-0.989045,0.133072>
 <26.995701,-83.170097,-27.056999>, <-0.063747,-0.989171,0.132202>
 <27.445000,-82.985298,-25.492399>, <-0.056952,-0.989038,0.136240>
}
   smooth_triangle{ <26.627501,-82.999397,-25.962900>, <0.063886,0.989045,-0.133072>
 <27.445000,-82.985298,-25.492399>, <0.056952,0.989038,-0.136240>
 <26.995701,-83.170097,-27.056999>, <0.063747,0.989171,-0.132202>
}
   smooth_triangle{ <27.384899,-83.304100,-27.881500>, <-0.063168,-0.989411,0.130676>
 <27.192200,-83.245499,-27.528500>, <-0.063155,-0.989386,0.130868>
 <26.225000,-83.313698,-28.551800>, <-0.073791,-0.989446,0.124704>
}
   smooth_triangle{ <27.384899,-83.304100,-27.881500>, <0.063168,0.989411,-0.130676>
 <26.225000,-83.313698,-28.551800>, <0.073791,0.989446,-0.124704>
 <27.192200,-83.245499,-27.528500>, <0.063155,0.989386,-0.130868>
}
   smooth_triangle{ <26.062599,-83.254700,-28.180599>, <-0.074334,-0.989225,0.126125>
 <26.225000,-83.313698,-28.551800>, <-0.073791,-0.989446,0.124704>
 <27.192200,-83.245499,-27.528500>, <-0.063155,-0.989386,0.130868>
}
   smooth_triangle{ <26.062599,-83.254700,-28.180599>, <0.074334,0.989225,-0.126125>
 <27.192200,-83.245499,-27.528500>, <0.063155,0.989386,-0.130868>
 <26.225000,-83.313698,-28.551800>, <0.073791,0.989446,-0.124704>
}
   smooth_triangle{ <27.192200,-83.245499,-27.528500>, <-0.063155,-0.989386,0.130868>
 <26.995701,-83.170097,-27.056999>, <-0.063747,-0.989171,0.132202>
 <26.062599,-83.254700,-28.180599>, <-0.074334,-0.989225,0.126125>
}
   smooth_triangle{ <27.192200,-83.245499,-27.528500>, <0.063155,0.989386,-0.130868>
 <26.062599,-83.254700,-28.180599>, <0.074334,0.989225,-0.126125>
 <26.995701,-83.170097,-27.056999>, <0.063747,0.989171,-0.132202>
}
   smooth_triangle{ <25.919800,-83.179001,-27.677700>, <-0.075276,-0.988841,0.128558>
 <26.062599,-83.254700,-28.180599>, <-0.074334,-0.989225,0.126125>
 <26.995701,-83.170097,-27.056999>, <-0.063747,-0.989171,0.132202>
}
   smooth_triangle{ <25.919800,-83.179001,-27.677700>, <0.075276,0.988841,-0.128558>
 <26.995701,-83.170097,-27.056999>, <0.063747,0.989171,-0.132202>
 <26.062599,-83.254700,-28.180599>, <0.074334,0.989225,-0.126125>
}
   smooth_triangle{ <26.995701,-83.170097,-27.056999>, <-0.063747,-0.989171,0.132202>
 <26.627501,-82.999397,-25.962900>, <-0.063886,-0.989045,0.133072>
 <25.919800,-83.179001,-27.677700>, <-0.075276,-0.988841,0.128558>
}
   smooth_triangle{ <26.995701,-83.170097,-27.056999>, <0.063747,0.989171,-0.132202>
 <25.919800,-83.179001,-27.677700>, <0.075276,0.988841,-0.128558>
 <26.627501,-82.999397,-25.962900>, <0.063886,0.989045,-0.133072>
}
   smooth_triangle{ <25.695299,-83.007401,-26.500601>, <-0.075289,-0.988604,0.130360>
 <25.919800,-83.179001,-27.677700>, <-0.075276,-0.988841,0.128558>
 <26.627501,-82.999397,-25.962900>, <-0.063886,-0.989045,0.133072>
}
   smooth_triangle{ <25.695299,-83.007401,-26.500601>, <0.075289,0.988604,-0.130360>
 <26.627501,-82.999397,-25.962900>, <0.063886,0.989045,-0.133072>
 <25.919800,-83.179001,-27.677700>, <0.075276,0.988841,-0.128558>
}
   smooth_triangle{ <27.445000,-82.985298,-25.492399>, <-0.056952,-0.989038,0.136240>
 <27.227301,-82.905998,-25.008499>, <-0.056770,-0.988992,0.136645>
 <26.627501,-82.999397,-25.962900>, <-0.063886,-0.989045,0.133072>
}
   smooth_triangle{ <27.445000,-82.985298,-25.492399>, <0.056952,0.989038,-0.136240>
 <26.627501,-82.999397,-25.962900>, <0.063886,0.989045,-0.133072>
 <27.227301,-82.905998,-25.008499>, <0.056770,0.988992,-0.136645>
}
   smooth_triangle{ <26.473900,-82.919296,-25.442200>, <-0.063961,-0.988976,0.133549>
 <26.627501,-82.999397,-25.962900>, <-0.063886,-0.989045,0.133072>
 <27.227301,-82.905998,-25.008499>, <-0.056770,-0.988992,0.136645>
}
   smooth_triangle{ <26.473900,-82.919296,-25.442200>, <0.063961,0.988976,-0.133549>
 <27.227301,-82.905998,-25.008499>, <0.056770,0.988992,-0.136645>
 <26.627501,-82.999397,-25.962900>, <0.063886,0.989045,-0.133072>
}
   smooth_triangle{ <27.227301,-82.905998,-25.008499>, <-0.056770,-0.988992,0.136645>
 <27.051500,-82.840103,-24.604799>, <-0.056399,-0.988990,0.136813>
 <26.473900,-82.919296,-25.442200>, <-0.063961,-0.988976,0.133549>
}
   smooth_triangle{ <27.227301,-82.905998,-25.008499>, <0.056770,0.988992,-0.136645>
 <26.473900,-82.919296,-25.442200>, <0.063961,0.988976,-0.133549>
 <27.051500,-82.840103,-24.604799>, <0.056399,0.988990,-0.136813>
}
   smooth_triangle{ <26.353001,-82.852699,-25.007099>, <-0.063902,-0.988960,0.133697>
 <26.473900,-82.919296,-25.442200>, <-0.063961,-0.988976,0.133549>
 <27.051500,-82.840103,-24.604799>, <-0.056399,-0.988990,0.136813>
}
   smooth_triangle{ <26.353001,-82.852699,-25.007099>, <0.063902,0.988960,-0.133697>
 <27.051500,-82.840103,-24.604799>, <0.056399,0.988990,-0.136813>
 <26.473900,-82.919296,-25.442200>, <0.063961,0.988976,-0.133549>
}
   smooth_triangle{ <27.051500,-82.840103,-24.604799>, <-0.056399,-0.988990,0.136813>
 <26.933800,-82.795197,-24.328199>, <-0.056243,-0.988963,0.137071>
 <26.353001,-82.852699,-25.007099>, <-0.063902,-0.988960,0.133697>
}
   smooth_triangle{ <27.051500,-82.840103,-24.604799>, <0.056399,0.988990,-0.136813>
 <26.353001,-82.852699,-25.007099>, <0.063902,0.988960,-0.133697>
 <26.933800,-82.795197,-24.328199>, <0.056243,0.988963,-0.137071>
}
   smooth_triangle{ <26.273800,-82.807198,-24.708599>, <-0.064023,-0.988904,0.134055>
 <26.353001,-82.852699,-25.007099>, <-0.063902,-0.988960,0.133697>
 <26.933800,-82.795197,-24.328199>, <-0.056243,-0.988963,0.137071>
}
   smooth_triangle{ <26.273800,-82.807198,-24.708599>, <0.064023,0.988904,-0.134055>
 <26.933800,-82.795197,-24.328199>, <0.056243,0.988963,-0.137071>
 <26.353001,-82.852699,-25.007099>, <0.063902,0.988960,-0.133697>
}
   smooth_triangle{ <26.933800,-82.795197,-24.328199>, <-0.056243,-0.988963,0.137071>
 <26.891001,-82.778503,-24.225599>, <-0.057555,-0.988941,0.136690>
 <26.273800,-82.807198,-24.708599>, <-0.064023,-0.988904,0.134055>
}
   smooth_triangle{ <26.933800,-82.795197,-24.328199>, <0.056243,0.988963,-0.137071>
 <26.273800,-82.807198,-24.708599>, <0.064023,0.988904,-0.134055>
 <26.891001,-82.778503,-24.225599>, <0.057555,0.988941,-0.136690>
}
   smooth_triangle{ <26.245300,-82.790298,-24.597700>, <-0.065239,-0.988891,0.133559>
 <26.273800,-82.807198,-24.708599>, <-0.064023,-0.988904,0.134055>
 <26.891001,-82.778503,-24.225599>, <-0.057555,-0.988941,0.136690>
}
   smooth_triangle{ <26.245300,-82.790298,-24.597700>, <0.065239,0.988891,-0.133559>
 <26.891001,-82.778503,-24.225599>, <0.057555,0.988941,-0.136690>
 <26.273800,-82.807198,-24.708599>, <0.064023,0.988904,-0.134055>
}
   smooth_triangle{ <26.627501,-82.999397,-25.962900>, <-0.063886,-0.989045,0.133072>
 <26.473900,-82.919296,-25.442200>, <-0.063961,-0.988976,0.133549>
 <25.695299,-83.007401,-26.500601>, <-0.075289,-0.988604,0.130360>
}
   smooth_triangle{ <26.627501,-82.999397,-25.962900>, <0.063886,0.989045,-0.133072>
 <25.695299,-83.007401,-26.500601>, <0.075289,0.988604,-0.130360>
 <26.473900,-82.919296,-25.442200>, <0.063961,0.988976,-0.133549>
}
   smooth_triangle{ <25.614799,-82.926598,-25.937901>, <-0.074093,-0.988583,0.131202>
 <25.695299,-83.007401,-26.500601>, <-0.075289,-0.988604,0.130360>
 <26.473900,-82.919296,-25.442200>, <-0.063961,-0.988976,0.133549>
}
   smooth_triangle{ <25.614799,-82.926598,-25.937901>, <0.074093,0.988583,-0.131202>
 <26.473900,-82.919296,-25.442200>, <0.063961,0.988976,-0.133549>
 <25.695299,-83.007401,-26.500601>, <0.075289,0.988604,-0.130360>
}
   smooth_triangle{ <26.473900,-82.919296,-25.442200>, <-0.063961,-0.988976,0.133549>
 <26.353001,-82.852699,-25.007099>, <-0.063902,-0.988960,0.133697>
 <25.614799,-82.926598,-25.937901>, <-0.074093,-0.988583,0.131202>
}
   smooth_triangle{ <26.473900,-82.919296,-25.442200>, <0.063961,0.988976,-0.133549>
 <25.614799,-82.926598,-25.937901>, <0.074093,0.988583,-0.131202>
 <26.353001,-82.852699,-25.007099>, <0.063902,0.988960,-0.133697>
}
   smooth_triangle{ <25.556700,-82.859596,-25.466900>, <-0.072609,-0.988642,0.131587>
 <25.614799,-82.926598,-25.937901>, <-0.074093,-0.988583,0.131202>
 <26.353001,-82.852699,-25.007099>, <-0.063902,-0.988960,0.133697>
}
   smooth_triangle{ <25.556700,-82.859596,-25.466900>, <0.072609,0.988642,-0.131587>
 <26.353001,-82.852699,-25.007099>, <0.063902,0.988960,-0.133697>
 <25.614799,-82.926598,-25.937901>, <0.074093,0.988583,-0.131202>
}
   smooth_triangle{ <26.353001,-82.852699,-25.007099>, <-0.063902,-0.988960,0.133697>
 <26.273800,-82.807198,-24.708599>, <-0.064023,-0.988904,0.134055>
 <25.556700,-82.859596,-25.466900>, <-0.072609,-0.988642,0.131587>
}
   smooth_triangle{ <26.353001,-82.852699,-25.007099>, <0.063902,0.988960,-0.133697>
 <25.556700,-82.859596,-25.466900>, <0.072609,0.988642,-0.131587>
 <26.273800,-82.807198,-24.708599>, <0.064023,0.988904,-0.134055>
}
   smooth_triangle{ <25.521200,-82.813797,-25.143400>, <-0.071459,-0.988684,0.131901>
 <25.556700,-82.859596,-25.466900>, <-0.072609,-0.988642,0.131587>
 <26.273800,-82.807198,-24.708599>, <-0.064023,-0.988904,0.134055>
}
   smooth_triangle{ <25.521200,-82.813797,-25.143400>, <0.071459,0.988684,-0.131901>
 <26.273800,-82.807198,-24.708599>, <0.064023,0.988904,-0.134055>
 <25.556700,-82.859596,-25.466900>, <0.072609,0.988642,-0.131587>
}
   smooth_triangle{ <26.273800,-82.807198,-24.708599>, <-0.064023,-0.988904,0.134055>
 <26.245300,-82.790298,-24.597700>, <-0.065239,-0.988891,0.133559>
 <25.521200,-82.813797,-25.143400>, <-0.071459,-0.988684,0.131901>
}
   smooth_triangle{ <26.273800,-82.807198,-24.708599>, <0.064023,0.988904,-0.134055>
 <25.521200,-82.813797,-25.143400>, <0.071459,0.988684,-0.131901>
 <26.245300,-82.790298,-24.597700>, <0.065239,0.988891,-0.133559>
}
   smooth_triangle{ <25.509300,-82.796898,-25.023100>, <-0.071554,-0.988762,0.131260>
 <25.521200,-82.813797,-25.143400>, <-0.071459,-0.988684,0.131901>
 <26.245300,-82.790298,-24.597700>, <-0.065239,-0.988891,0.133559>
}
   smooth_triangle{ <25.509300,-82.796898,-25.023100>, <0.071554,0.988762,-0.131260>
 <26.245300,-82.790298,-24.597700>, <0.065239,0.988891,-0.133559>
 <25.521200,-82.813797,-25.143400>, <0.071459,0.988684,-0.131901>
}
   smooth_triangle{ <26.225000,-83.313698,-28.551800>, <-0.073791,-0.989446,0.124704>
 <26.062599,-83.254700,-28.180599>, <-0.074334,-0.989225,0.126125>
 <26.137600,-83.312698,-28.602600>, <-0.082276,-0.989270,0.120731>
}
   smooth_triangle{ <26.225000,-83.313698,-28.551800>, <0.073791,0.989446,-0.124704>
 <26.137600,-83.312698,-28.602600>, <0.082276,0.989270,-0.120731>
 <26.062599,-83.254700,-28.180599>, <0.074334,0.989225,-0.126125>
}
   smooth_triangle{ <25.974800,-83.253601,-28.230200>, <-0.083311,-0.988921,0.122861>
 <26.137600,-83.312698,-28.602600>, <-0.082276,-0.989270,0.120731>
 <26.062599,-83.254700,-28.180599>, <-0.074334,-0.989225,0.126125>
}
   smooth_triangle{ <25.974800,-83.253601,-28.230200>, <0.083311,0.988921,-0.122861>
 <26.062599,-83.254700,-28.180599>, <0.074334,0.989225,-0.126125>
 <26.137600,-83.312698,-28.602600>, <0.082276,0.989270,-0.120731>
}
   smooth_triangle{ <26.137600,-83.312698,-28.602600>, <-0.082276,-0.989270,0.120731>
 <25.974800,-83.253601,-28.230200>, <-0.083311,-0.988921,0.122861>
 <25.927601,-83.309799,-28.724701>, <-0.084171,-0.989171,0.120230>
}
   smooth_triangle{ <26.137600,-83.312698,-28.602600>, <0.082276,0.989270,-0.120731>
 <25.927601,-83.309799,-28.724701>, <0.084171,0.989171,-0.120230>
 <25.974800,-83.253601,-28.230200>, <0.083311,0.988921,-0.122861>
}
   smooth_triangle{ <25.770399,-83.250198,-28.344200>, <-0.085726,-0.988784,0.122297>
 <25.927601,-83.309799,-28.724701>, <-0.084171,-0.989171,0.120230>
 <25.974800,-83.253601,-28.230200>, <-0.083311,-0.988921,0.122861>
}
   smooth_triangle{ <25.770399,-83.250198,-28.344200>, <0.085726,0.988784,-0.122297>
 <25.974800,-83.253601,-28.230200>, <0.083311,0.988921,-0.122861>
 <25.927601,-83.309799,-28.724701>, <0.084171,0.989171,-0.120230>
}
   smooth_triangle{ <26.062599,-83.254700,-28.180599>, <-0.074334,-0.989225,0.126125>
 <25.919800,-83.179001,-27.677700>, <-0.075276,-0.988841,0.128558>
 <25.974800,-83.253601,-28.230200>, <-0.083311,-0.988921,0.122861>
}
   smooth_triangle{ <26.062599,-83.254700,-28.180599>, <0.074334,0.989225,-0.126125>
 <25.974800,-83.253601,-28.230200>, <0.083311,0.988921,-0.122861>
 <25.919800,-83.179001,-27.677700>, <0.075276,0.988841,-0.128558>
}
   smooth_triangle{ <25.827999,-83.177803,-27.728800>, <-0.084392,-0.988406,0.126224>
 <25.974800,-83.253601,-28.230200>, <-0.083311,-0.988921,0.122861>
 <25.919800,-83.179001,-27.677700>, <-0.075276,-0.988841,0.128558>
}
   smooth_triangle{ <25.827999,-83.177803,-27.728800>, <0.084392,0.988406,-0.126224>
 <25.919800,-83.179001,-27.677700>, <0.075276,0.988841,-0.128558>
 <25.974800,-83.253601,-28.230200>, <0.083311,0.988921,-0.122861>
}
   smooth_triangle{ <25.974800,-83.253601,-28.230200>, <-0.083311,-0.988921,0.122861>
 <25.827999,-83.177803,-27.728800>, <-0.084392,-0.988406,0.126224>
 <25.770399,-83.250198,-28.344200>, <-0.085726,-0.988784,0.122297>
}
   smooth_triangle{ <25.974800,-83.253601,-28.230200>, <0.083311,0.988921,-0.122861>
 <25.770399,-83.250198,-28.344200>, <0.085726,0.988784,-0.122297>
 <25.827999,-83.177803,-27.728800>, <0.084392,0.988406,-0.126224>
}
   smooth_triangle{ <25.640100,-83.174500,-27.830999>, <-0.085197,-0.988480,0.125099>
 <25.770399,-83.250198,-28.344200>, <-0.085726,-0.988784,0.122297>
 <25.827999,-83.177803,-27.728800>, <-0.084392,-0.988406,0.126224>
}
   smooth_triangle{ <25.640100,-83.174500,-27.830999>, <0.085197,0.988480,-0.125099>
 <25.827999,-83.177803,-27.728800>, <0.084392,0.988406,-0.126224>
 <25.770399,-83.250198,-28.344200>, <0.085726,0.988784,-0.122297>
}
   smooth_triangle{ <25.919800,-83.179001,-27.677700>, <-0.075276,-0.988841,0.128558>
 <25.695299,-83.007401,-26.500601>, <-0.075289,-0.988604,0.130360>
 <25.827999,-83.177803,-27.728800>, <-0.084392,-0.988406,0.126224>
}
   smooth_triangle{ <25.919800,-83.179001,-27.677700>, <0.075276,0.988841,-0.128558>
 <25.827999,-83.177803,-27.728800>, <0.084392,0.988406,-0.126224>
 <25.695299,-83.007401,-26.500601>, <0.075289,0.988604,-0.130360>
}
   smooth_triangle{ <25.573999,-83.005898,-26.566799>, <-0.083017,-0.988331,0.127712>
 <25.827999,-83.177803,-27.728800>, <-0.084392,-0.988406,0.126224>
 <25.695299,-83.007401,-26.500601>, <-0.075289,-0.988604,0.130360>
}
   smooth_triangle{ <25.573999,-83.005898,-26.566799>, <0.083017,0.988331,-0.127712>
 <25.695299,-83.007401,-26.500601>, <0.075289,0.988604,-0.130360>
 <25.827999,-83.177803,-27.728800>, <0.084392,0.988406,-0.126224>
}
   smooth_triangle{ <25.827999,-83.177803,-27.728800>, <-0.084392,-0.988406,0.126224>
 <25.573999,-83.005898,-26.566799>, <-0.083017,-0.988331,0.127712>
 <25.640100,-83.174500,-27.830999>, <-0.085197,-0.988480,0.125099>
}
   smooth_triangle{ <25.827999,-83.177803,-27.728800>, <0.084392,0.988406,-0.126224>
 <25.640100,-83.174500,-27.830999>, <0.085197,0.988480,-0.125099>
 <25.573999,-83.005898,-26.566799>, <0.083017,0.988331,-0.127712>
}
   smooth_triangle{ <25.452700,-83.004601,-26.632999>, <-0.083142,-0.988280,0.128020>
 <25.640100,-83.174500,-27.830999>, <-0.085197,-0.988480,0.125099>
 <25.573999,-83.005898,-26.566799>, <-0.083017,-0.988331,0.127712>
}
   smooth_triangle{ <25.452700,-83.004601,-26.632999>, <0.083142,0.988280,-0.128020>
 <25.573999,-83.005898,-26.566799>, <0.083017,0.988331,-0.127712>
 <25.640100,-83.174500,-27.830999>, <0.085197,0.988480,-0.125099>
}
   smooth_triangle{ <25.695299,-83.007401,-26.500601>, <-0.075289,-0.988604,0.130360>
 <25.614799,-82.926598,-25.937901>, <-0.074093,-0.988583,0.131202>
 <25.452700,-83.004601,-26.632999>, <-0.083142,-0.988280,0.128020>
}
   smooth_triangle{ <25.695299,-83.007401,-26.500601>, <0.075289,0.988604,-0.130360>
 <25.452700,-83.004601,-26.632999>, <0.083142,0.988280,-0.128020>
 <25.614799,-82.926598,-25.937901>, <0.074093,0.988583,-0.131202>
}
   smooth_triangle{ <25.392099,-82.925003,-26.061399>, <-0.080932,-0.988392,0.128576>
 <25.452700,-83.004601,-26.632999>, <-0.083142,-0.988280,0.128020>
 <25.614799,-82.926598,-25.937901>, <-0.074093,-0.988583,0.131202>
}
   smooth_triangle{ <25.392099,-82.925003,-26.061399>, <0.080932,0.988392,-0.128576>
 <25.614799,-82.926598,-25.937901>, <0.074093,0.988583,-0.131202>
 <25.452700,-83.004601,-26.632999>, <0.083142,0.988280,-0.128020>
}
   smooth_triangle{ <25.614799,-82.926598,-25.937901>, <-0.074093,-0.988583,0.131202>
 <25.556700,-82.859596,-25.466900>, <-0.072609,-0.988642,0.131587>
 <25.392099,-82.925003,-26.061399>, <-0.080932,-0.988392,0.128576>
}
   smooth_triangle{ <25.614799,-82.926598,-25.937901>, <0.074093,0.988583,-0.131202>
 <25.392099,-82.925003,-26.061399>, <0.080932,0.988392,-0.128576>
 <25.556700,-82.859596,-25.466900>, <0.072609,0.988642,-0.131587>
}
   smooth_triangle{ <25.351101,-82.859100,-25.583000>, <-0.078987,-0.988461,0.129248>
 <25.392099,-82.925003,-26.061399>, <-0.080932,-0.988392,0.128576>
 <25.556700,-82.859596,-25.466900>, <-0.072609,-0.988642,0.131587>
}
   smooth_triangle{ <25.351101,-82.859100,-25.583000>, <0.078987,0.988461,-0.129248>
 <25.556700,-82.859596,-25.466900>, <0.072609,0.988642,-0.131587>
 <25.392099,-82.925003,-26.061399>, <0.080932,0.988392,-0.128576>
}
   smooth_triangle{ <25.556700,-82.859596,-25.466900>, <-0.072609,-0.988642,0.131587>
 <25.521200,-82.813797,-25.143400>, <-0.071459,-0.988684,0.131901>
 <25.351101,-82.859100,-25.583000>, <-0.078987,-0.988461,0.129248>
}
   smooth_triangle{ <25.556700,-82.859596,-25.466900>, <0.072609,0.988642,-0.131587>
 <25.351101,-82.859100,-25.583000>, <0.078987,0.988461,-0.129248>
 <25.521200,-82.813797,-25.143400>, <0.071459,0.988684,-0.131901>
}
   smooth_triangle{ <25.327801,-82.814003,-25.254499>, <-0.077625,-0.988540,0.129469>
 <25.351101,-82.859100,-25.583000>, <-0.078987,-0.988461,0.129248>
 <25.521200,-82.813797,-25.143400>, <-0.071459,-0.988684,0.131901>
}
   smooth_triangle{ <25.327801,-82.814003,-25.254499>, <0.077625,0.988540,-0.129469>
 <25.521200,-82.813797,-25.143400>, <0.071459,0.988684,-0.131901>
 <25.351101,-82.859100,-25.583000>, <0.078987,0.988461,-0.129248>
}
   smooth_triangle{ <25.521200,-82.813797,-25.143400>, <-0.071459,-0.988684,0.131901>
 <25.509300,-82.796898,-25.023100>, <-0.071554,-0.988762,0.131260>
 <25.327801,-82.814003,-25.254499>, <-0.077625,-0.988540,0.129469>
}
   smooth_triangle{ <25.521200,-82.813797,-25.143400>, <0.071459,0.988684,-0.131901>
 <25.327801,-82.814003,-25.254499>, <0.077625,0.988540,-0.129469>
 <25.509300,-82.796898,-25.023100>, <0.071554,0.988762,-0.131260>
}
   smooth_triangle{ <25.320400,-82.797401,-25.132401>, <-0.077722,-0.988725,0.127995>
 <25.327801,-82.814003,-25.254499>, <-0.077625,-0.988540,0.129469>
 <25.509300,-82.796898,-25.023100>, <-0.071554,-0.988762,0.131260>
}
   smooth_triangle{ <25.320400,-82.797401,-25.132401>, <0.077722,0.988725,-0.127995>
 <25.509300,-82.796898,-25.023100>, <0.071554,0.988762,-0.131260>
 <25.327801,-82.814003,-25.254499>, <0.077625,0.988540,-0.129469>
}
   smooth_triangle{ <37.359798,-84.315300,-31.604500>, <0.496279,-0.140721,-0.856682>
 <37.478100,-84.319801,-31.535299>, <0.495716,-0.142479,-0.856718>
 <37.358799,-84.330200,-31.602600>, <0.496124,-0.143305,-0.856344>
}
   smooth_triangle{ <37.359798,-84.315300,-31.604500>, <-0.496279,0.140721,0.856682>
 <37.358799,-84.330200,-31.602600>, <-0.496124,0.143305,0.856344>
 <37.478100,-84.319801,-31.535299>, <-0.495716,0.142479,0.856718>
}
   smooth_triangle{ <37.358799,-84.330200,-31.602600>, <0.496124,-0.143305,-0.856344>
 <36.853901,-84.327797,-31.895700>, <0.496357,-0.141248,-0.856551>
 <37.359798,-84.315300,-31.604500>, <0.496279,-0.140721,-0.856682>
}
   smooth_triangle{ <37.358799,-84.330200,-31.602600>, <-0.496124,0.143305,0.856344>
 <37.359798,-84.315300,-31.604500>, <-0.496279,0.140721,0.856682>
 <36.853901,-84.327797,-31.895700>, <-0.496357,0.141248,0.856551>
}
   smooth_triangle{ <36.853901,-84.327797,-31.895700>, <0.496357,-0.141248,-0.856551>
 <37.358799,-84.330200,-31.602600>, <0.496124,-0.143305,-0.856344>
 <37.004700,-84.357803,-31.803200>, <0.496114,-0.144980,-0.856068>
}
   smooth_triangle{ <36.853901,-84.327797,-31.895700>, <-0.496357,0.141248,0.856551>
 <37.004700,-84.357803,-31.803200>, <-0.496114,0.144980,0.856068>
 <37.358799,-84.330200,-31.602600>, <-0.496124,0.143305,0.856344>
}
   smooth_triangle{ <37.004700,-84.357803,-31.803200>, <0.496114,-0.144980,-0.856068>
 <36.162399,-84.355797,-32.291599>, <0.496186,-0.142868,-0.856381>
 <36.853901,-84.327797,-31.895700>, <0.496357,-0.141248,-0.856551>
}
   smooth_triangle{ <37.004700,-84.357803,-31.803200>, <-0.496114,0.144980,0.856068>
 <36.853901,-84.327797,-31.895700>, <-0.496357,0.141248,0.856551>
 <36.162399,-84.355797,-32.291599>, <-0.496186,0.142868,0.856381>
}
   smooth_triangle{ <37.008400,-84.303802,-31.809999>, <0.496537,-0.138059,-0.856966>
 <37.359798,-84.315300,-31.604500>, <0.496279,-0.140721,-0.856682>
 <36.853901,-84.327797,-31.895700>, <0.496357,-0.141248,-0.856551>
}
   smooth_triangle{ <37.008400,-84.303802,-31.809999>, <-0.496537,0.138059,0.856966>
 <36.853901,-84.327797,-31.895700>, <-0.496357,0.141248,0.856551>
 <37.359798,-84.315300,-31.604500>, <-0.496279,0.140721,0.856682>
}
   smooth_triangle{ <36.853901,-84.327797,-31.895700>, <0.496357,-0.141248,-0.856551>
 <36.163700,-84.317200,-32.297199>, <0.496340,-0.140367,-0.856705>
 <37.008400,-84.303802,-31.809999>, <0.496537,-0.138059,-0.856966>
}
   smooth_triangle{ <36.853901,-84.327797,-31.895700>, <-0.496357,0.141248,0.856551>
 <37.008400,-84.303802,-31.809999>, <-0.496537,0.138059,0.856966>
 <36.163700,-84.317200,-32.297199>, <-0.496340,0.140367,0.856705>
}
   smooth_triangle{ <36.163700,-84.317200,-32.297199>, <0.496340,-0.140367,-0.856705>
 <36.853901,-84.327797,-31.895700>, <0.496357,-0.141248,-0.856551>
 <36.162399,-84.355797,-32.291599>, <0.496186,-0.142868,-0.856381>
}
   smooth_triangle{ <36.163700,-84.317200,-32.297199>, <-0.496340,0.140367,0.856705>
 <36.162399,-84.355797,-32.291599>, <-0.496186,0.142868,0.856381>
 <36.853901,-84.327797,-31.895700>, <-0.496357,0.141248,0.856551>
}
   smooth_triangle{ <36.162399,-84.355797,-32.291599>, <0.496186,-0.142868,-0.856381>
 <35.186901,-84.345596,-32.858501>, <0.496269,-0.141731,-0.856522>
 <36.163700,-84.317200,-32.297199>, <0.496340,-0.140367,-0.856705>
}
   smooth_triangle{ <36.162399,-84.355797,-32.291599>, <-0.496186,0.142868,0.856381>
 <36.163700,-84.317200,-32.297199>, <-0.496340,0.140367,0.856705>
 <35.186901,-84.345596,-32.858501>, <-0.496269,0.141731,0.856522>
}
   smooth_triangle{ <36.162399,-84.355797,-32.291599>, <0.496186,-0.142868,-0.856381>
 <37.004700,-84.357803,-31.803200>, <0.496114,-0.144980,-0.856068>
 <36.421200,-84.397102,-32.134701>, <0.496154,-0.144041,-0.856203>
}
   smooth_triangle{ <36.162399,-84.355797,-32.291599>, <-0.496186,0.142868,0.856381>
 <36.421200,-84.397102,-32.134701>, <-0.496154,0.144041,0.856203>
 <37.004700,-84.357803,-31.803200>, <-0.496114,0.144980,0.856068>
}
   smooth_triangle{ <36.421200,-84.397102,-32.134701>, <0.496154,-0.144041,-0.856203>
 <35.290100,-84.393402,-32.790798>, <0.496197,-0.143017,-0.856349>
 <36.162399,-84.355797,-32.291599>, <0.496186,-0.142868,-0.856381>
}
   smooth_triangle{ <36.421200,-84.397102,-32.134701>, <-0.496154,0.144041,0.856203>
 <36.162399,-84.355797,-32.291599>, <-0.496186,0.142868,0.856381>
 <35.290100,-84.393402,-32.790798>, <-0.496197,0.143017,0.856349>
}
   smooth_triangle{ <35.290100,-84.393402,-32.790798>, <0.496197,-0.143017,-0.856349>
 <36.421200,-84.397102,-32.134701>, <0.496154,-0.144041,-0.856203>
 <35.613499,-84.443001,-32.595001>, <0.496130,-0.144326,-0.856169>
}
   smooth_triangle{ <35.290100,-84.393402,-32.790798>, <-0.496197,0.143017,0.856349>
 <35.613499,-84.443001,-32.595001>, <-0.496130,0.144326,0.856169>
 <36.421200,-84.397102,-32.134701>, <-0.496154,0.144041,0.856203>
}
   smooth_triangle{ <35.613499,-84.443001,-32.595001>, <0.496130,-0.144326,-0.856169>
 <34.242001,-84.435204,-33.391102>, <0.496211,-0.142583,-0.856414>
 <35.290100,-84.393402,-32.790798>, <0.496197,-0.143017,-0.856349>
}
   smooth_triangle{ <35.613499,-84.443001,-32.595001>, <-0.496130,0.144326,0.856169>
 <35.290100,-84.393402,-32.790798>, <-0.496197,0.143017,0.856349>
 <34.242001,-84.435204,-33.391102>, <-0.496211,0.142583,0.856414>
}
   smooth_triangle{ <35.186901,-84.345596,-32.858501>, <0.496269,-0.141731,-0.856522>
 <36.162399,-84.355797,-32.291599>, <0.496186,-0.142868,-0.856381>
 <35.290100,-84.393402,-32.790798>, <0.496197,-0.143017,-0.856349>
}
   smooth_triangle{ <35.186901,-84.345596,-32.858501>, <-0.496269,0.141731,0.856522>
 <35.290100,-84.393402,-32.790798>, <-0.496197,0.143017,0.856349>
 <36.162399,-84.355797,-32.291599>, <-0.496186,0.142868,0.856381>
}
   smooth_triangle{ <35.290100,-84.393402,-32.790798>, <0.496197,-0.143017,-0.856349>
 <34.086300,-84.383797,-33.489799>, <0.496224,-0.142294,-0.856454>
 <35.186901,-84.345596,-32.858501>, <0.496269,-0.141731,-0.856522>
}
   smooth_triangle{ <35.290100,-84.393402,-32.790798>, <-0.496197,0.143017,0.856349>
 <35.186901,-84.345596,-32.858501>, <-0.496269,0.141731,0.856522>
 <34.086300,-84.383797,-33.489799>, <-0.496224,0.142294,0.856454>
}
   smooth_triangle{ <34.086300,-84.383797,-33.489799>, <0.496224,-0.142294,-0.856454>
 <35.290100,-84.393402,-32.790798>, <0.496197,-0.143017,-0.856349>
 <34.242001,-84.435204,-33.391102>, <0.496211,-0.142583,-0.856414>
}
   smooth_triangle{ <34.086300,-84.383797,-33.489799>, <-0.496224,0.142294,0.856454>
 <34.242001,-84.435204,-33.391102>, <-0.496211,0.142583,0.856414>
 <35.290100,-84.393402,-32.790798>, <-0.496197,0.143017,0.856349>
}
   smooth_triangle{ <34.242001,-84.435204,-33.391102>, <0.496211,-0.142583,-0.856414>
 <32.870499,-84.427399,-34.187000>, <0.496195,-0.142673,-0.856408>
 <34.086300,-84.383797,-33.489799>, <0.496224,-0.142294,-0.856454>
}
   smooth_triangle{ <34.242001,-84.435204,-33.391102>, <-0.496211,0.142583,0.856414>
 <34.086300,-84.383797,-33.489799>, <-0.496224,0.142294,0.856454>
 <32.870499,-84.427399,-34.187000>, <-0.496195,0.142673,0.856408>
}
   smooth_triangle{ <36.428600,-84.287598,-32.148602>, <0.496362,-0.140474,-0.856675>
 <37.008400,-84.303802,-31.809999>, <0.496537,-0.138059,-0.856966>
 <36.163700,-84.317200,-32.297199>, <0.496340,-0.140367,-0.856705>
}
   smooth_triangle{ <36.428600,-84.287598,-32.148602>, <-0.496362,0.140474,0.856675>
 <36.163700,-84.317200,-32.297199>, <-0.496340,0.140367,0.856705>
 <37.008400,-84.303802,-31.809999>, <-0.496537,0.138059,0.856966>
}
   smooth_triangle{ <36.163700,-84.317200,-32.297199>, <0.496340,-0.140367,-0.856705>
 <35.292702,-84.302002,-32.804401>, <0.496376,-0.140268,-0.856701>
 <36.428600,-84.287598,-32.148602>, <0.496362,-0.140474,-0.856675>
}
   smooth_triangle{ <36.163700,-84.317200,-32.297199>, <-0.496340,0.140367,0.856705>
 <36.428600,-84.287598,-32.148602>, <-0.496362,0.140474,0.856675>
 <35.292702,-84.302002,-32.804401>, <-0.496376,0.140268,0.856701>
}
   smooth_triangle{ <35.625301,-84.269798,-32.616901>, <0.496457,-0.138938,-0.856870>
 <36.428600,-84.287598,-32.148602>, <0.496362,-0.140474,-0.856675>
 <35.292702,-84.302002,-32.804401>, <0.496376,-0.140268,-0.856701>
}
   smooth_triangle{ <35.625301,-84.269798,-32.616901>, <-0.496457,0.138938,0.856870>
 <35.292702,-84.302002,-32.804401>, <-0.496376,0.140268,0.856701>
 <36.428600,-84.287598,-32.148602>, <-0.496362,0.140474,0.856675>
}
   smooth_triangle{ <35.292702,-84.302002,-32.804401>, <0.496376,-0.140268,-0.856701>
 <34.239498,-84.289101,-33.416698>, <0.496410,-0.139426,-0.856818>
 <35.625301,-84.269798,-32.616901>, <0.496457,-0.138938,-0.856870>
}
   smooth_triangle{ <35.292702,-84.302002,-32.804401>, <-0.496376,0.140268,0.856701>
 <35.625301,-84.269798,-32.616901>, <-0.496457,0.138938,0.856870>
 <34.239498,-84.289101,-33.416698>, <-0.496410,0.139426,0.856818>
}
   smooth_triangle{ <35.292702,-84.302002,-32.804401>, <0.496376,-0.140268,-0.856701>
 <36.163700,-84.317200,-32.297199>, <0.496340,-0.140367,-0.856705>
 <35.186901,-84.345596,-32.858501>, <0.496269,-0.141731,-0.856522>
}
   smooth_triangle{ <35.292702,-84.302002,-32.804401>, <-0.496376,0.140268,0.856701>
 <35.186901,-84.345596,-32.858501>, <-0.496269,0.141731,0.856522>
 <36.163700,-84.317200,-32.297199>, <-0.496340,0.140367,0.856705>
}
   smooth_triangle{ <35.186901,-84.345596,-32.858501>, <0.496269,-0.141731,-0.856522>
 <34.078999,-84.328201,-33.503300>, <0.496282,-0.141362,-0.856575>
 <35.292702,-84.302002,-32.804401>, <0.496376,-0.140268,-0.856701>
}
   smooth_triangle{ <35.186901,-84.345596,-32.858501>, <-0.496269,0.141731,0.856522>
 <35.292702,-84.302002,-32.804401>, <-0.496376,0.140268,0.856701>
 <34.078999,-84.328201,-33.503300>, <-0.496282,0.141362,0.856575>
}
   smooth_triangle{ <34.239498,-84.289101,-33.416698>, <0.496410,-0.139426,-0.856818>
 <35.292702,-84.302002,-32.804401>, <0.496376,-0.140268,-0.856701>
 <34.078999,-84.328201,-33.503300>, <0.496282,-0.141362,-0.856575>
}
   smooth_triangle{ <34.239498,-84.289101,-33.416698>, <-0.496410,0.139426,0.856818>
 <34.078999,-84.328201,-33.503300>, <-0.496282,0.141362,0.856575>
 <35.292702,-84.302002,-32.804401>, <-0.496376,0.140268,0.856701>
}
   smooth_triangle{ <34.078999,-84.328201,-33.503300>, <0.496282,-0.141362,-0.856575>
 <32.853699,-84.308403,-34.216400>, <0.496307,-0.140786,-0.856656>
 <34.239498,-84.289101,-33.416698>, <0.496410,-0.139426,-0.856818>
}
   smooth_triangle{ <34.078999,-84.328201,-33.503300>, <-0.496282,0.141362,0.856575>
 <34.239498,-84.289101,-33.416698>, <-0.496410,0.139426,0.856818>
 <32.853699,-84.308403,-34.216400>, <-0.496307,0.140786,0.856656>
}
   smooth_triangle{ <34.078999,-84.328201,-33.503300>, <0.496282,-0.141362,-0.856575>
 <35.186901,-84.345596,-32.858501>, <0.496269,-0.141731,-0.856522>
 <34.086300,-84.383797,-33.489799>, <0.496224,-0.142294,-0.856454>
}
   smooth_triangle{ <34.078999,-84.328201,-33.503300>, <-0.496282,0.141362,0.856575>
 <34.086300,-84.383797,-33.489799>, <-0.496224,0.142294,0.856454>
 <35.186901,-84.345596,-32.858501>, <-0.496269,0.141731,0.856522>
}
   smooth_triangle{ <34.086300,-84.383797,-33.489799>, <0.496224,-0.142294,-0.856454>
 <32.759701,-84.365898,-34.261501>, <0.496161,-0.143271,-0.856328>
 <34.078999,-84.328201,-33.503300>, <0.496282,-0.141362,-0.856575>
}
   smooth_triangle{ <34.086300,-84.383797,-33.489799>, <-0.496224,0.142294,0.856454>
 <34.078999,-84.328201,-33.503300>, <-0.496282,0.141362,0.856575>
 <32.759701,-84.365898,-34.261501>, <-0.496161,0.143271,0.856328>
}
   smooth_triangle{ <32.759701,-84.365898,-34.261501>, <0.496161,-0.143271,-0.856328>
 <34.086300,-84.383797,-33.489799>, <0.496224,-0.142294,-0.856454>
 <32.870499,-84.427399,-34.187000>, <0.496195,-0.142673,-0.856408>
}
   smooth_triangle{ <32.759701,-84.365898,-34.261501>, <-0.496161,0.143271,0.856328>
 <32.870499,-84.427399,-34.187000>, <-0.496195,0.142673,0.856408>
 <34.086300,-84.383797,-33.489799>, <-0.496224,0.142294,0.856454>
}
   smooth_triangle{ <32.870499,-84.427399,-34.187000>, <0.496195,-0.142673,-0.856408>
 <31.440300,-84.403603,-35.019501>, <0.496218,-0.141828,-0.856535>
 <32.759701,-84.365898,-34.261501>, <0.496161,-0.143271,-0.856328>
}
   smooth_triangle{ <32.870499,-84.427399,-34.187000>, <-0.496195,0.142673,0.856408>
 <32.759701,-84.365898,-34.261501>, <-0.496161,0.143271,0.856328>
 <31.440300,-84.403603,-35.019501>, <-0.496218,0.141828,0.856535>
}
   smooth_triangle{ <32.853699,-84.308403,-34.216400>, <0.496307,-0.140786,-0.856656>
 <34.078999,-84.328201,-33.503300>, <0.496282,-0.141362,-0.856575>
 <31.440300,-84.403603,-35.019501>, <0.496218,-0.141828,-0.856535>
}
   smooth_triangle{ <32.853699,-84.308403,-34.216400>, <-0.496307,0.140786,0.856656>
 <31.440300,-84.403603,-35.019501>, <-0.496218,0.141828,0.856535>
 <34.078999,-84.328201,-33.503300>, <-0.496282,0.141362,0.856575>
}
   smooth_triangle{ <31.440300,-84.403603,-35.019501>, <0.496218,-0.141828,-0.856535>
 <30.010201,-84.379799,-35.852001>, <0.496233,-0.141952,-0.856506>
 <32.853699,-84.308403,-34.216400>, <0.496307,-0.140786,-0.856656>
}
   smooth_triangle{ <31.440300,-84.403603,-35.019501>, <-0.496218,0.141828,0.856535>
 <32.853699,-84.308403,-34.216400>, <-0.496307,0.140786,0.856656>
 <30.010201,-84.379799,-35.852001>, <-0.496233,0.141952,0.856506>
}
   smooth_triangle{ <34.603100,-84.252899,-33.211899>, <0.496357,-0.140349,-0.856698>
 <35.625301,-84.269798,-32.616901>, <0.496457,-0.138938,-0.856870>
 <32.853699,-84.308403,-34.216400>, <0.496307,-0.140786,-0.856656>
}
   smooth_triangle{ <34.603100,-84.252899,-33.211899>, <-0.496357,0.140349,0.856698>
 <32.853699,-84.308403,-34.216400>, <-0.496307,0.140786,0.856656>
 <35.625301,-84.269798,-32.616901>, <-0.496457,0.138938,0.856870>
}
   smooth_triangle{ <32.853699,-84.308403,-34.216400>, <0.496307,-0.140786,-0.856656>
 <31.518101,-84.288902,-34.993401>, <0.496278,-0.141531,-0.856550>
 <34.603100,-84.252899,-33.211899>, <0.496357,-0.140349,-0.856698>
}
   smooth_triangle{ <32.853699,-84.308403,-34.216400>, <-0.496307,0.140786,0.856656>
 <34.603100,-84.252899,-33.211899>, <-0.496357,0.140349,0.856698>
 <31.518101,-84.288902,-34.993401>, <-0.496278,0.141531,0.856550>
}
   smooth_triangle{ <33.367001,-84.239502,-33.930302>, <0.496340,-0.140893,-0.856619>
 <34.603100,-84.252899,-33.211899>, <0.496357,-0.140349,-0.856698>
 <31.518101,-84.288902,-34.993401>, <0.496278,-0.141531,-0.856550>
}
   smooth_triangle{ <33.367001,-84.239502,-33.930302>, <-0.496340,0.140893,0.856619>
 <31.518101,-84.288902,-34.993401>, <-0.496278,0.141531,0.856550>
 <34.603100,-84.252899,-33.211899>, <-0.496357,0.140349,0.856698>
}
   smooth_triangle{ <31.518101,-84.288902,-34.993401>, <0.496278,-0.141531,-0.856550>
 <30.082899,-84.273102,-35.827599>, <0.496292,-0.140855,-0.856653>
 <33.367001,-84.239502,-33.930302>, <0.496340,-0.140893,-0.856619>
}
   smooth_triangle{ <31.518101,-84.288902,-34.993401>, <-0.496278,0.141531,0.856550>
 <33.367001,-84.239502,-33.930302>, <-0.496340,0.140893,0.856619>
 <30.082899,-84.273102,-35.827599>, <-0.496292,0.140855,0.856653>
}
   smooth_triangle{ <31.921700,-84.232498,-34.768902>, <0.496808,-0.133328,-0.857558>
 <33.367001,-84.239502,-33.930302>, <0.496340,-0.140893,-0.856619>
 <31.725000,-84.256302,-34.879002>, <0.496424,-0.139326,-0.856827>
}
   smooth_triangle{ <31.921700,-84.232498,-34.768902>, <-0.496808,0.133328,0.857558>
 <31.725000,-84.256302,-34.879002>, <-0.496424,0.139326,0.856827>
 <33.367001,-84.239502,-33.930302>, <-0.496340,0.140893,0.856619>
}
   smooth_triangle{ <31.725000,-84.256302,-34.879002>, <0.496424,-0.139326,-0.856827>
 <30.181999,-84.244797,-35.774799>, <0.496748,-0.133831,-0.857514>
 <31.921700,-84.232498,-34.768902>, <0.496808,-0.133328,-0.857558>
}
   smooth_triangle{ <31.725000,-84.256302,-34.879002>, <-0.496424,0.139326,0.856827>
 <31.921700,-84.232498,-34.768902>, <-0.496808,0.133328,0.857558>
 <30.181999,-84.244797,-35.774799>, <-0.496748,0.133831,0.857514>
}
   smooth_triangle{ <30.271900,-84.234398,-35.724201>, <0.497486,-0.121889,-0.858866>
 <31.921700,-84.232498,-34.768902>, <0.496808,-0.133328,-0.857558>
 <30.181999,-84.244797,-35.774799>, <0.496748,-0.133831,-0.857514>
}
   smooth_triangle{ <30.271900,-84.234398,-35.724201>, <-0.497486,0.121889,0.858866>
 <30.181999,-84.244797,-35.774799>, <-0.496748,0.133831,0.857514>
 <31.921700,-84.232498,-34.768902>, <-0.496808,0.133328,0.857558>
}
   smooth_triangle{ <30.181999,-84.244797,-35.774799>, <0.496748,-0.133831,-0.857514>
 <28.524099,-84.246696,-36.734901>, <0.496683,-0.134853,-0.857392>
 <30.271900,-84.234398,-35.724201>, <0.497486,-0.121889,-0.858866>
}
   smooth_triangle{ <30.181999,-84.244797,-35.774799>, <-0.496748,0.133831,0.857514>
 <30.271900,-84.234398,-35.724201>, <-0.497486,0.121889,0.858866>
 <28.524099,-84.246696,-36.734901>, <-0.496683,0.134853,0.857392>
}
   smooth_triangle{ <30.181999,-84.244797,-35.774799>, <0.496748,-0.133831,-0.857514>
 <31.725000,-84.256302,-34.879002>, <0.496424,-0.139326,-0.856827>
 <30.082899,-84.273102,-35.827599>, <0.496292,-0.140855,-0.856653>
}
   smooth_triangle{ <30.181999,-84.244797,-35.774799>, <-0.496748,0.133831,0.857514>
 <30.082899,-84.273102,-35.827599>, <-0.496292,0.140855,0.856653>
 <31.725000,-84.256302,-34.879002>, <-0.496424,0.139326,0.856827>
}
   smooth_triangle{ <30.082899,-84.273102,-35.827599>, <0.496292,-0.140855,-0.856653>
 <28.557699,-84.264503,-36.712502>, <0.496325,-0.140041,-0.856767>
 <30.181999,-84.244797,-35.774799>, <0.496748,-0.133831,-0.857514>
}
   smooth_triangle{ <30.082899,-84.273102,-35.827599>, <-0.496292,0.140855,0.856653>
 <30.181999,-84.244797,-35.774799>, <-0.496748,0.133831,0.857514>
 <28.557699,-84.264503,-36.712502>, <-0.496325,0.140041,0.856767>
}
   smooth_triangle{ <28.524099,-84.246696,-36.734901>, <0.496683,-0.134853,-0.857392>
 <30.181999,-84.244797,-35.774799>, <0.496748,-0.133831,-0.857514>
 <28.557699,-84.264503,-36.712502>, <0.496325,-0.140041,-0.856767>
}
   smooth_triangle{ <28.524099,-84.246696,-36.734901>, <-0.496683,0.134853,0.857392>
 <28.557699,-84.264503,-36.712502>, <-0.496325,0.140041,0.856767>
 <30.181999,-84.244797,-35.774799>, <-0.496748,0.133831,0.857514>
}
   smooth_triangle{ <28.557699,-84.264503,-36.712502>, <0.496325,-0.140041,-0.856767>
 <26.952200,-84.266296,-37.642300>, <0.496360,-0.139762,-0.856793>
 <28.524099,-84.246696,-36.734901>, <0.496683,-0.134853,-0.857392>
}
   smooth_triangle{ <28.557699,-84.264503,-36.712502>, <-0.496325,0.140041,0.856767>
 <28.524099,-84.246696,-36.734901>, <-0.496683,0.134853,0.857392>
 <26.952200,-84.266296,-37.642300>, <-0.496360,0.139762,0.856793>
}
   smooth_triangle{ <31.518101,-84.288902,-34.993401>, <0.496278,-0.141531,-0.856550>
 <32.853699,-84.308403,-34.216400>, <0.496307,-0.140786,-0.856656>
 <31.431900,-84.344101,-35.034199>, <0.496251,-0.141738,-0.856531>
}
   smooth_triangle{ <31.518101,-84.288902,-34.993401>, <-0.496278,0.141531,0.856550>
 <31.431900,-84.344101,-35.034199>, <-0.496251,0.141738,0.856531>
 <32.853699,-84.308403,-34.216400>, <-0.496307,0.140786,0.856656>
}
   smooth_triangle{ <31.431900,-84.344101,-35.034199>, <0.496251,-0.141738,-0.856531>
 <29.998400,-84.322800,-35.868301>, <0.496227,-0.142133,-0.856479>
 <31.518101,-84.288902,-34.993401>, <0.496278,-0.141531,-0.856550>
}
   smooth_triangle{ <31.431900,-84.344101,-35.034199>, <-0.496251,0.141738,0.856531>
 <31.518101,-84.288902,-34.993401>, <-0.496278,0.141531,0.856550>
 <29.998400,-84.322800,-35.868301>, <-0.496227,0.142133,0.856479>
}
   smooth_triangle{ <30.082899,-84.273102,-35.827599>, <0.496292,-0.140855,-0.856653>
 <31.518101,-84.288902,-34.993401>, <0.496278,-0.141531,-0.856550>
 <29.998400,-84.322800,-35.868301>, <0.496227,-0.142133,-0.856479>
}
   smooth_triangle{ <30.082899,-84.273102,-35.827599>, <-0.496292,0.140855,0.856653>
 <29.998400,-84.322800,-35.868301>, <-0.496227,0.142133,0.856479>
 <31.518101,-84.288902,-34.993401>, <-0.496278,0.141531,0.856550>
}
   smooth_triangle{ <29.998400,-84.322800,-35.868301>, <0.496227,-0.142133,-0.856479>
 <28.564899,-84.301498,-36.702301>, <0.496283,-0.140881,-0.856654>
 <30.082899,-84.273102,-35.827599>, <0.496292,-0.140855,-0.856653>
}
   smooth_triangle{ <29.998400,-84.322800,-35.868301>, <-0.496227,0.142133,0.856479>
 <30.082899,-84.273102,-35.827599>, <-0.496292,0.140855,0.856653>
 <28.564899,-84.301498,-36.702301>, <-0.496283,0.140881,0.856654>
}
   smooth_triangle{ <28.564899,-84.301498,-36.702301>, <0.496283,-0.140881,-0.856654>
 <31.431900,-84.344101,-35.034199>, <0.496251,-0.141738,-0.856531>
 <30.010201,-84.379799,-35.852001>, <0.496233,-0.141952,-0.856506>
}
   smooth_triangle{ <28.564899,-84.301498,-36.702301>, <-0.496283,0.140881,0.856654>
 <30.010201,-84.379799,-35.852001>, <-0.496233,0.141952,0.856506>
 <31.431900,-84.344101,-35.034199>, <-0.496251,0.141738,0.856531>
}
   smooth_triangle{ <30.010201,-84.379799,-35.852001>, <0.496233,-0.141952,-0.856506>
 <27.149900,-84.332199,-37.516998>, <0.496255,-0.141346,-0.856594>
 <28.564899,-84.301498,-36.702301>, <0.496283,-0.140881,-0.856654>
}
   smooth_triangle{ <30.010201,-84.379799,-35.852001>, <-0.496233,0.141952,0.856506>
 <28.564899,-84.301498,-36.702301>, <-0.496283,0.140881,0.856654>
 <27.149900,-84.332199,-37.516998>, <-0.496255,0.141346,0.856594>
}
   smooth_triangle{ <28.557699,-84.264503,-36.712502>, <0.496325,-0.140041,-0.856767>
 <30.082899,-84.273102,-35.827599>, <0.496292,-0.140855,-0.856653>
 <28.564899,-84.301498,-36.702301>, <0.496283,-0.140881,-0.856654>
}
   smooth_triangle{ <28.557699,-84.264503,-36.712502>, <-0.496325,0.140041,0.856767>
 <28.564899,-84.301498,-36.702301>, <-0.496283,0.140881,0.856654>
 <30.082899,-84.273102,-35.827599>, <-0.496292,0.140855,0.856653>
}
   smooth_triangle{ <28.564899,-84.301498,-36.702301>, <0.496283,-0.140881,-0.856654>
 <27.081301,-84.291000,-37.563499>, <0.496339,-0.140052,-0.856757>
 <28.557699,-84.264503,-36.712502>, <0.496325,-0.140041,-0.856767>
}
   smooth_triangle{ <28.564899,-84.301498,-36.702301>, <-0.496283,0.140881,0.856654>
 <28.557699,-84.264503,-36.712502>, <-0.496325,0.140041,0.856767>
 <27.081301,-84.291000,-37.563499>, <-0.496339,0.140052,0.856757>
}
   smooth_triangle{ <27.081301,-84.291000,-37.563499>, <0.496339,-0.140052,-0.856757>
 <28.564899,-84.301498,-36.702301>, <0.496283,-0.140881,-0.856654>
 <27.149900,-84.332199,-37.516998>, <0.496255,-0.141346,-0.856594>
}
   smooth_triangle{ <27.081301,-84.291000,-37.563499>, <-0.496339,0.140052,0.856757>
 <27.149900,-84.332199,-37.516998>, <-0.496255,0.141346,0.856594>
 <28.564899,-84.301498,-36.702301>, <-0.496283,0.140881,0.856654>
}
   smooth_triangle{ <27.149900,-84.332199,-37.516998>, <0.496255,-0.141346,-0.856594>
 <25.778400,-84.324402,-38.312801>, <0.496321,-0.140137,-0.856754>
 <27.081301,-84.291000,-37.563499>, <0.496339,-0.140052,-0.856757>
}
   smooth_triangle{ <27.149900,-84.332199,-37.516998>, <-0.496255,0.141346,0.856594>
 <27.081301,-84.291000,-37.563499>, <-0.496339,0.140052,0.856757>
 <25.778400,-84.324402,-38.312801>, <-0.496321,0.140137,0.856754>
}
   smooth_triangle{ <26.952200,-84.266296,-37.642300>, <0.496360,-0.139762,-0.856793>
 <28.557699,-84.264503,-36.712502>, <0.496325,-0.140041,-0.856767>
 <27.081301,-84.291000,-37.563499>, <0.496339,-0.140052,-0.856757>
}
   smooth_triangle{ <26.952200,-84.266296,-37.642300>, <-0.496360,0.139762,0.856793>
 <27.081301,-84.291000,-37.563499>, <-0.496339,0.140052,0.856757>
 <28.557699,-84.264503,-36.712502>, <-0.496325,0.140041,0.856767>
}
   smooth_triangle{ <27.081301,-84.291000,-37.563499>, <0.496339,-0.140052,-0.856757>
 <25.573999,-84.290604,-38.436798>, <0.496280,-0.140751,-0.856677>
 <26.952200,-84.266296,-37.642300>, <0.496360,-0.139762,-0.856793>
}
   smooth_triangle{ <27.081301,-84.291000,-37.563499>, <-0.496339,0.140052,0.856757>
 <26.952200,-84.266296,-37.642300>, <-0.496360,0.139762,0.856793>
 <25.573999,-84.290604,-38.436798>, <-0.496280,0.140751,0.856677>
}
   smooth_triangle{ <25.573999,-84.290604,-38.436798>, <0.496280,-0.140751,-0.856677>
 <27.081301,-84.291000,-37.563499>, <0.496339,-0.140052,-0.856757>
 <25.778400,-84.324402,-38.312801>, <0.496321,-0.140137,-0.856754>
}
   smooth_triangle{ <25.573999,-84.290604,-38.436798>, <-0.496280,0.140751,0.856677>
 <25.778400,-84.324402,-38.312801>, <-0.496321,0.140137,0.856754>
 <27.081301,-84.291000,-37.563499>, <-0.496339,0.140052,0.856757>
}
   smooth_triangle{ <25.778400,-84.324402,-38.312801>, <0.496321,-0.140137,-0.856754>
 <24.406799,-84.316597,-39.108601>, <0.496351,-0.139270,-0.856878>
 <25.573999,-84.290604,-38.436798>, <0.496280,-0.140751,-0.856677>
}
   smooth_triangle{ <25.778400,-84.324402,-38.312801>, <-0.496321,0.140137,0.856754>
 <25.573999,-84.290604,-38.436798>, <-0.496280,0.140751,0.856677>
 <24.406799,-84.316597,-39.108601>, <-0.496351,0.139270,0.856878>
}
   smooth_triangle{ <32.870499,-84.427399,-34.187000>, <0.496195,-0.142673,-0.856408>
 <35.613499,-84.443001,-32.595001>, <0.496130,-0.144326,-0.856169>
 <34.587002,-84.489502,-33.181999>, <0.496159,-0.143584,-0.856277>
}
   smooth_triangle{ <32.870499,-84.427399,-34.187000>, <-0.496195,0.142673,0.856408>
 <34.587002,-84.489502,-33.181999>, <-0.496159,0.143584,0.856277>
 <35.613499,-84.443001,-32.595001>, <-0.496130,0.144326,0.856169>
}
   smooth_triangle{ <34.587002,-84.489502,-33.181999>, <0.496159,-0.143584,-0.856277>
 <31.547600,-84.471298,-34.946201>, <0.496186,-0.142605,-0.856425>
 <32.870499,-84.427399,-34.187000>, <0.496195,-0.142673,-0.856408>
}
   smooth_triangle{ <34.587002,-84.489502,-33.181999>, <-0.496159,0.143584,0.856277>
 <32.870499,-84.427399,-34.187000>, <-0.496195,0.142673,0.856408>
 <31.547600,-84.471298,-34.946201>, <-0.496186,0.142605,0.856425>
}
   smooth_triangle{ <31.547600,-84.471298,-34.946201>, <0.496186,-0.142605,-0.856425>
 <34.587002,-84.489502,-33.181999>, <0.496159,-0.143584,-0.856277>
 <33.347000,-84.531700,-33.893398>, <0.496097,-0.144308,-0.856191>
}
   smooth_triangle{ <31.547600,-84.471298,-34.946201>, <-0.496186,0.142605,0.856425>
 <33.347000,-84.531700,-33.893398>, <-0.496097,0.144308,0.856191>
 <34.587002,-84.489502,-33.181999>, <-0.496159,0.143584,0.856277>
}
   smooth_triangle{ <33.347000,-84.531700,-33.893398>, <0.496097,-0.144308,-0.856191>
 <30.126301,-84.510902,-35.763000>, <0.496127,-0.143188,-0.856362>
 <31.547600,-84.471298,-34.946201>, <0.496186,-0.142605,-0.856425>
}
   smooth_triangle{ <33.347000,-84.531700,-33.893398>, <-0.496097,0.144308,0.856191>
 <31.547600,-84.471298,-34.946201>, <-0.496186,0.142605,0.856425>
 <30.126301,-84.510902,-35.763000>, <-0.496127,0.143188,0.856362>
}
   smooth_triangle{ <31.736700,-84.521301,-34.828201>, <0.496123,-0.143824,-0.856257>
 <33.347000,-84.531700,-33.893398>, <0.496097,-0.144308,-0.856191>
 <31.899000,-84.563904,-34.727001>, <0.496060,-0.144690,-0.856148>
}
   smooth_triangle{ <31.736700,-84.521301,-34.828201>, <-0.496123,0.143824,0.856257>
 <31.899000,-84.563904,-34.727001>, <-0.496060,0.144690,0.856148>
 <33.347000,-84.531700,-33.893398>, <-0.496097,0.144308,0.856191>
}
   smooth_triangle{ <31.899000,-84.563904,-34.727001>, <0.496060,-0.144690,-0.856148>
 <30.211100,-84.559601,-35.705700>, <0.496031,-0.144624,-0.856176>
 <31.736700,-84.521301,-34.828201>, <0.496123,-0.143824,-0.856257>
}
   smooth_triangle{ <31.899000,-84.563904,-34.727001>, <-0.496060,0.144690,0.856148>
 <31.736700,-84.521301,-34.828201>, <-0.496123,0.143824,0.856257>
 <30.211100,-84.559601,-35.705700>, <-0.496031,0.144624,0.856176>
}
   smooth_triangle{ <30.211100,-84.559601,-35.705700>, <0.496031,-0.144624,-0.856176>
 <31.899000,-84.563904,-34.727001>, <0.496060,-0.144690,-0.856148>
 <30.248199,-84.580704,-35.680599>, <0.495916,-0.146277,-0.855962>
}
   smooth_triangle{ <30.211100,-84.559601,-35.705700>, <-0.496031,0.144624,0.856176>
 <30.248199,-84.580704,-35.680599>, <-0.495916,0.146277,0.855962>
 <31.899000,-84.563904,-34.727001>, <-0.496060,0.144690,0.856148>
}
   smooth_triangle{ <30.248199,-84.580704,-35.680599>, <0.495916,-0.146277,-0.855962>
 <28.562300,-84.577797,-36.657799>, <0.496006,-0.144665,-0.856184>
 <30.211100,-84.559601,-35.705700>, <0.496031,-0.144624,-0.856176>
}
   smooth_triangle{ <30.248199,-84.580704,-35.680599>, <-0.495916,0.146277,0.855962>
 <30.211100,-84.559601,-35.705700>, <-0.496031,0.144624,0.856176>
 <28.562300,-84.577797,-36.657799>, <-0.496006,0.144665,0.856184>
}
   smooth_triangle{ <30.126301,-84.510902,-35.763000>, <0.496127,-0.143188,-0.856362>
 <31.736700,-84.521301,-34.828201>, <0.496123,-0.143824,-0.856257>
 <30.211100,-84.559601,-35.705700>, <0.496031,-0.144624,-0.856176>
}
   smooth_triangle{ <30.126301,-84.510902,-35.763000>, <-0.496127,0.143188,0.856362>
 <30.211100,-84.559601,-35.705700>, <-0.496031,0.144624,0.856176>
 <31.736700,-84.521301,-34.828201>, <-0.496123,0.143824,0.856257>
}
   smooth_triangle{ <30.211100,-84.559601,-35.705700>, <0.496031,-0.144624,-0.856176>
 <28.614799,-84.541397,-36.633499>, <0.496052,-0.144055,-0.856260>
 <30.126301,-84.510902,-35.763000>, <0.496127,-0.143188,-0.856362>
}
   smooth_triangle{ <30.211100,-84.559601,-35.705700>, <-0.496031,0.144624,0.856176>
 <30.126301,-84.510902,-35.763000>, <-0.496127,0.143188,0.856362>
 <28.614799,-84.541397,-36.633499>, <-0.496052,0.144055,0.856260>
}
   smooth_triangle{ <28.614799,-84.541397,-36.633499>, <0.496052,-0.144055,-0.856260>
 <30.211100,-84.559601,-35.705700>, <0.496031,-0.144624,-0.856176>
 <28.562300,-84.577797,-36.657799>, <0.496006,-0.144665,-0.856184>
}
   smooth_triangle{ <28.614799,-84.541397,-36.633499>, <-0.496052,0.144055,0.856260>
 <28.562300,-84.577797,-36.657799>, <-0.496006,0.144665,0.856184>
 <30.211100,-84.559601,-35.705700>, <-0.496031,0.144624,0.856176>
}
   smooth_triangle{ <28.562300,-84.577797,-36.657799>, <0.496006,-0.144665,-0.856184>
 <27.021700,-84.558197,-37.553600>, <0.496009,-0.144588,-0.856195>
 <28.614799,-84.541397,-36.633499>, <0.496052,-0.144055,-0.856260>
}
   smooth_triangle{ <28.562300,-84.577797,-36.657799>, <-0.496006,0.144665,0.856184>
 <28.614799,-84.541397,-36.633499>, <-0.496052,0.144055,0.856260>
 <27.021700,-84.558197,-37.553600>, <-0.496009,0.144588,0.856195>
}
   smooth_triangle{ <31.440300,-84.403603,-35.019501>, <0.496218,-0.141828,-0.856535>
 <32.870499,-84.427399,-34.187000>, <0.496195,-0.142673,-0.856408>
 <31.547600,-84.471298,-34.946201>, <0.496186,-0.142605,-0.856425>
}
   smooth_triangle{ <31.440300,-84.403603,-35.019501>, <-0.496218,0.141828,0.856535>
 <31.547600,-84.471298,-34.946201>, <-0.496186,0.142605,0.856425>
 <32.870499,-84.427399,-34.187000>, <-0.496195,0.142673,0.856408>
}
   smooth_triangle{ <31.547600,-84.471298,-34.946201>, <0.496186,-0.142605,-0.856425>
 <30.025400,-84.443398,-35.832600>, <0.496248,-0.141274,-0.856610>
 <31.440300,-84.403603,-35.019501>, <0.496218,-0.141828,-0.856535>
}
   smooth_triangle{ <31.547600,-84.471298,-34.946201>, <-0.496186,0.142605,0.856425>
 <31.440300,-84.403603,-35.019501>, <-0.496218,0.141828,0.856535>
 <30.025400,-84.443398,-35.832600>, <-0.496248,0.141274,0.856610>
}
   smooth_triangle{ <30.025400,-84.443398,-35.832600>, <0.496248,-0.141274,-0.856610>
 <31.547600,-84.471298,-34.946201>, <0.496186,-0.142605,-0.856425>
 <30.126301,-84.510902,-35.763000>, <0.496127,-0.143188,-0.856362>
}
   smooth_triangle{ <30.025400,-84.443398,-35.832600>, <-0.496248,0.141274,0.856610>
 <30.126301,-84.510902,-35.763000>, <-0.496127,0.143188,0.856362>
 <31.547600,-84.471298,-34.946201>, <-0.496186,0.142605,0.856425>
}
   smooth_triangle{ <30.126301,-84.510902,-35.763000>, <0.496127,-0.143188,-0.856362>
 <28.610600,-84.483299,-36.645699>, <0.496158,-0.142901,-0.856392>
 <30.025400,-84.443398,-35.832600>, <0.496248,-0.141274,-0.856610>
}
   smooth_triangle{ <30.126301,-84.510902,-35.763000>, <-0.496127,0.143188,0.856362>
 <30.025400,-84.443398,-35.832600>, <-0.496248,0.141274,0.856610>
 <28.610600,-84.483299,-36.645699>, <-0.496158,0.142901,0.856392>
}
   smooth_triangle{ <30.010201,-84.379799,-35.852001>, <0.496233,-0.141952,-0.856506>
 <31.440300,-84.403603,-35.019501>, <0.496218,-0.141828,-0.856535>
 <28.610600,-84.483299,-36.645699>, <0.496158,-0.142901,-0.856392>
}
   smooth_triangle{ <30.010201,-84.379799,-35.852001>, <-0.496233,0.141952,0.856506>
 <28.610600,-84.483299,-36.645699>, <-0.496158,0.142901,0.856392>
 <31.440300,-84.403603,-35.019501>, <-0.496218,0.141828,0.856535>
}
   smooth_triangle{ <28.610600,-84.483299,-36.645699>, <0.496158,-0.142901,-0.856392>
 <27.186600,-84.451103,-37.476101>, <0.496134,-0.142994,-0.856390>
 <30.010201,-84.379799,-35.852001>, <0.496233,-0.141952,-0.856506>
}
   smooth_triangle{ <28.610600,-84.483299,-36.645699>, <-0.496158,0.142901,0.856392>
 <30.010201,-84.379799,-35.852001>, <-0.496233,0.141952,0.856506>
 <27.186600,-84.451103,-37.476101>, <-0.496134,0.142994,0.856390>
}
   smooth_triangle{ <28.610600,-84.483299,-36.645699>, <0.496158,-0.142901,-0.856392>
 <30.126301,-84.510902,-35.763000>, <0.496127,-0.143188,-0.856362>
 <28.614799,-84.541397,-36.633499>, <0.496052,-0.144055,-0.856260>
}
   smooth_triangle{ <28.610600,-84.483299,-36.645699>, <-0.496158,0.142901,0.856392>
 <28.614799,-84.541397,-36.633499>, <-0.496052,0.144055,0.856260>
 <30.126301,-84.510902,-35.763000>, <-0.496127,0.143188,0.856362>
}
   smooth_triangle{ <28.614799,-84.541397,-36.633499>, <0.496052,-0.144055,-0.856260>
 <27.144100,-84.510902,-37.490700>, <0.496049,-0.143977,-0.856275>
 <28.610600,-84.483299,-36.645699>, <0.496158,-0.142901,-0.856392>
}
   smooth_triangle{ <28.614799,-84.541397,-36.633499>, <-0.496052,0.144055,0.856260>
 <28.610600,-84.483299,-36.645699>, <-0.496158,0.142901,0.856392>
 <27.144100,-84.510902,-37.490700>, <-0.496049,0.143977,0.856275>
}
   smooth_triangle{ <27.186600,-84.451103,-37.476101>, <0.496134,-0.142994,-0.856390>
 <28.610600,-84.483299,-36.645699>, <0.496158,-0.142901,-0.856392>
 <27.144100,-84.510902,-37.490700>, <0.496049,-0.143977,-0.856275>
}
   smooth_triangle{ <27.186600,-84.451103,-37.476101>, <-0.496134,0.142994,0.856390>
 <27.144100,-84.510902,-37.490700>, <-0.496049,0.143977,0.856275>
 <28.610600,-84.483299,-36.645699>, <-0.496158,0.142901,0.856392>
}
   smooth_triangle{ <27.144100,-84.510902,-37.490700>, <0.496049,-0.143977,-0.856275>
 <25.830500,-84.470299,-38.258400>, <0.496026,-0.144024,-0.856280>
 <27.186600,-84.451103,-37.476101>, <0.496134,-0.142994,-0.856390>
}
   smooth_triangle{ <27.144100,-84.510902,-37.490700>, <-0.496049,0.143977,0.856275>
 <27.186600,-84.451103,-37.476101>, <-0.496134,0.142994,0.856390>
 <25.830500,-84.470299,-38.258400>, <-0.496026,0.144024,0.856280>
}
   smooth_triangle{ <27.144100,-84.510902,-37.490700>, <0.496049,-0.143977,-0.856275>
 <28.614799,-84.541397,-36.633499>, <0.496052,-0.144055,-0.856260>
 <27.021700,-84.558197,-37.553600>, <0.496009,-0.144588,-0.856195>
}
   smooth_triangle{ <27.144100,-84.510902,-37.490700>, <-0.496049,0.143977,0.856275>
 <27.021700,-84.558197,-37.553600>, <-0.496009,0.144588,0.856195>
 <28.614799,-84.541397,-36.633499>, <-0.496052,0.144055,0.856260>
}
   smooth_triangle{ <27.021700,-84.558197,-37.553600>, <0.496009,-0.144588,-0.856195>
 <25.650900,-84.526802,-38.353001>, <0.496051,-0.143653,-0.856328>
 <27.144100,-84.510902,-37.490700>, <0.496049,-0.143977,-0.856275>
}
   smooth_triangle{ <27.021700,-84.558197,-37.553600>, <-0.496009,0.144588,0.856195>
 <27.144100,-84.510902,-37.490700>, <-0.496049,0.143977,0.856275>
 <25.650900,-84.526802,-38.353001>, <-0.496051,0.143653,0.856328>
}
   smooth_triangle{ <25.830500,-84.470299,-38.258400>, <0.496026,-0.144024,-0.856280>
 <27.144100,-84.510902,-37.490700>, <0.496049,-0.143977,-0.856275>
 <25.650900,-84.526802,-38.353001>, <0.496051,-0.143653,-0.856328>
}
   smooth_triangle{ <25.830500,-84.470299,-38.258400>, <-0.496026,0.144024,0.856280>
 <25.650900,-84.526802,-38.353001>, <-0.496051,0.143653,0.856328>
 <27.144100,-84.510902,-37.490700>, <-0.496049,0.143977,0.856275>
}
   smooth_triangle{ <25.650900,-84.526802,-38.353001>, <0.496051,-0.143653,-0.856328>
 <24.474501,-84.489502,-39.040699>, <0.496021,-0.144237,-0.856247>
 <25.830500,-84.470299,-38.258400>, <0.496026,-0.144024,-0.856280>
}
   smooth_triangle{ <25.650900,-84.526802,-38.353001>, <-0.496051,0.143653,0.856328>
 <25.830500,-84.470299,-38.258400>, <-0.496026,0.144024,0.856280>
 <24.474501,-84.489502,-39.040699>, <-0.496021,0.144237,0.856247>
}
   smooth_triangle{ <28.580099,-84.356003,-36.684502>, <0.496204,-0.142155,-0.856489>
 <30.010201,-84.379799,-35.852001>, <0.496233,-0.141952,-0.856506>
 <27.186600,-84.451103,-37.476101>, <0.496134,-0.142994,-0.856390>
}
   smooth_triangle{ <28.580099,-84.356003,-36.684502>, <-0.496204,0.142155,0.856489>
 <27.186600,-84.451103,-37.476101>, <-0.496134,0.142994,0.856390>
 <30.010201,-84.379799,-35.852001>, <-0.496233,0.141952,0.856506>
}
   smooth_triangle{ <27.186600,-84.451103,-37.476101>, <0.496134,-0.142994,-0.856390>
 <25.871901,-84.418404,-38.243198>, <0.496148,-0.142534,-0.856459>
 <28.580099,-84.356003,-36.684502>, <0.496204,-0.142155,-0.856489>
}
   smooth_triangle{ <27.186600,-84.451103,-37.476101>, <-0.496134,0.142994,0.856390>
 <28.580099,-84.356003,-36.684502>, <-0.496204,0.142155,0.856489>
 <25.871901,-84.418404,-38.243198>, <-0.496148,0.142534,0.856459>
}
   smooth_triangle{ <27.149900,-84.332199,-37.516998>, <0.496255,-0.141346,-0.856594>
 <28.580099,-84.356003,-36.684502>, <0.496204,-0.142155,-0.856489>
 <27.225901,-84.387199,-37.463799>, <0.496216,-0.142308,-0.856457>
}
   smooth_triangle{ <27.149900,-84.332199,-37.516998>, <-0.496255,0.141346,0.856594>
 <27.225901,-84.387199,-37.463799>, <-0.496216,0.142308,0.856457>
 <28.580099,-84.356003,-36.684502>, <-0.496204,0.142155,0.856489>
}
   smooth_triangle{ <27.225901,-84.387199,-37.463799>, <0.496216,-0.142308,-0.856457>
 <25.851500,-84.362801,-38.264198>, <0.496245,-0.141401,-0.856590>
 <27.149900,-84.332199,-37.516998>, <0.496255,-0.141346,-0.856594>
}
   smooth_triangle{ <27.225901,-84.387199,-37.463799>, <-0.496216,0.142308,0.856457>
 <27.149900,-84.332199,-37.516998>, <-0.496255,0.141346,0.856594>
 <25.851500,-84.362801,-38.264198>, <-0.496245,0.141401,0.856590>
}
   smooth_triangle{ <25.851500,-84.362801,-38.264198>, <0.496245,-0.141401,-0.856590>
 <27.225901,-84.387199,-37.463799>, <0.496216,-0.142308,-0.856457>
 <25.871901,-84.418404,-38.243198>, <0.496148,-0.142534,-0.856459>
}
   smooth_triangle{ <25.851500,-84.362801,-38.264198>, <-0.496245,0.141401,0.856590>
 <25.871901,-84.418404,-38.243198>, <-0.496148,0.142534,0.856459>
 <27.225901,-84.387199,-37.463799>, <-0.496216,0.142308,0.856457>
}
   smooth_triangle{ <25.871901,-84.418404,-38.243198>, <0.496148,-0.142534,-0.856459>
 <24.684401,-84.389397,-38.935799>, <0.496194,-0.141743,-0.856563>
 <25.851500,-84.362801,-38.264198>, <0.496245,-0.141401,-0.856590>
}
   smooth_triangle{ <25.871901,-84.418404,-38.243198>, <-0.496148,0.142534,0.856459>
 <25.851500,-84.362801,-38.264198>, <-0.496245,0.141401,0.856590>
 <24.684401,-84.389397,-38.935799>, <-0.496194,0.141743,0.856563>
}
   smooth_triangle{ <25.871901,-84.418404,-38.243198>, <0.496148,-0.142534,-0.856459>
 <27.186600,-84.451103,-37.476101>, <0.496134,-0.142994,-0.856390>
 <25.830500,-84.470299,-38.258400>, <0.496026,-0.144024,-0.856280>
}
   smooth_triangle{ <25.871901,-84.418404,-38.243198>, <-0.496148,0.142534,0.856459>
 <25.830500,-84.470299,-38.258400>, <-0.496026,0.144024,0.856280>
 <27.186600,-84.451103,-37.476101>, <-0.496134,0.142994,0.856390>
}
   smooth_triangle{ <25.830500,-84.470299,-38.258400>, <0.496026,-0.144024,-0.856280>
 <24.646500,-84.439598,-38.949501>, <0.496092,-0.143292,-0.856364>
 <25.871901,-84.418404,-38.243198>, <0.496148,-0.142534,-0.856459>
}
   smooth_triangle{ <25.830500,-84.470299,-38.258400>, <-0.496026,0.144024,0.856280>
 <25.871901,-84.418404,-38.243198>, <-0.496148,0.142534,0.856459>
 <24.646500,-84.439598,-38.949501>, <-0.496092,0.143292,0.856364>
}
   smooth_triangle{ <24.684401,-84.389397,-38.935799>, <0.496194,-0.141743,-0.856563>
 <25.871901,-84.418404,-38.243198>, <0.496148,-0.142534,-0.856459>
 <24.646500,-84.439598,-38.949501>, <0.496092,-0.143292,-0.856364>
}
   smooth_triangle{ <24.684401,-84.389397,-38.935799>, <-0.496194,0.141743,0.856563>
 <24.646500,-84.439598,-38.949501>, <-0.496092,0.143292,0.856364>
 <25.871901,-84.418404,-38.243198>, <-0.496148,0.142534,0.856459>
}
   smooth_triangle{ <24.646500,-84.439598,-38.949501>, <0.496092,-0.143292,-0.856364>
 <23.663200,-84.408600,-39.524300>, <0.496176,-0.142305,-0.856481>
 <24.684401,-84.389397,-38.935799>, <0.496194,-0.141743,-0.856563>
}
   smooth_triangle{ <24.646500,-84.439598,-38.949501>, <-0.496092,0.143292,0.856364>
 <24.684401,-84.389397,-38.935799>, <-0.496194,0.141743,0.856563>
 <23.663200,-84.408600,-39.524300>, <-0.496176,0.142305,0.856481>
}
   smooth_triangle{ <24.646500,-84.439598,-38.949501>, <0.496092,-0.143292,-0.856364>
 <25.830500,-84.470299,-38.258400>, <0.496026,-0.144024,-0.856280>
 <24.474501,-84.489502,-39.040699>, <0.496021,-0.144237,-0.856247>
}
   smooth_triangle{ <24.646500,-84.439598,-38.949501>, <-0.496092,0.143292,0.856364>
 <24.474501,-84.489502,-39.040699>, <-0.496021,0.144237,0.856247>
 <25.830500,-84.470299,-38.258400>, <-0.496026,0.144024,0.856280>
}
   smooth_triangle{ <24.474501,-84.489502,-39.040699>, <0.496021,-0.144237,-0.856247>
 <23.516800,-84.450996,-39.602001>, <0.496024,-0.143872,-0.856307>
 <24.646500,-84.439598,-38.949501>, <0.496092,-0.143292,-0.856364>
}
   smooth_triangle{ <24.474501,-84.489502,-39.040699>, <-0.496021,0.144237,0.856247>
 <24.646500,-84.439598,-38.949501>, <-0.496092,0.143292,0.856364>
 <23.516800,-84.450996,-39.602001>, <-0.496024,0.143872,0.856307>
}
   smooth_triangle{ <23.663200,-84.408600,-39.524300>, <0.496176,-0.142305,-0.856481>
 <24.646500,-84.439598,-38.949501>, <0.496092,-0.143292,-0.856364>
 <23.516800,-84.450996,-39.602001>, <0.496024,-0.143872,-0.856307>
}
   smooth_triangle{ <23.663200,-84.408600,-39.524300>, <-0.496176,0.142305,0.856481>
 <23.516800,-84.450996,-39.602001>, <-0.496024,0.143872,0.856307>
 <24.646500,-84.439598,-38.949501>, <-0.496092,0.143292,0.856364>
}
   smooth_triangle{ <23.516800,-84.450996,-39.602001>, <0.496024,-0.143872,-0.856307>
 <22.802500,-84.417099,-40.021400>, <0.495867,-0.145089,-0.856192>
 <23.663200,-84.408600,-39.524300>, <0.496176,-0.142305,-0.856481>
}
   smooth_triangle{ <23.516800,-84.450996,-39.602001>, <-0.496024,0.143872,0.856307>
 <23.663200,-84.408600,-39.524300>, <-0.496176,0.142305,0.856481>
 <22.802500,-84.417099,-40.021400>, <-0.495867,0.145089,0.856192>
}
   smooth_triangle{ <25.778400,-84.324402,-38.312801>, <0.496321,-0.140137,-0.856754>
 <27.149900,-84.332199,-37.516998>, <0.496255,-0.141346,-0.856594>
 <25.851500,-84.362801,-38.264198>, <0.496245,-0.141401,-0.856590>
}
   smooth_triangle{ <25.778400,-84.324402,-38.312801>, <-0.496321,0.140137,0.856754>
 <25.851500,-84.362801,-38.264198>, <-0.496245,0.141401,0.856590>
 <27.149900,-84.332199,-37.516998>, <-0.496255,0.141346,0.856594>
}
   smooth_triangle{ <25.851500,-84.362801,-38.264198>, <0.496245,-0.141401,-0.856590>
 <24.616199,-84.348297,-38.982201>, <0.496257,-0.140674,-0.856703>
 <25.778400,-84.324402,-38.312801>, <0.496321,-0.140137,-0.856754>
}
   smooth_triangle{ <25.851500,-84.362801,-38.264198>, <-0.496245,0.141401,0.856590>
 <25.778400,-84.324402,-38.312801>, <-0.496321,0.140137,0.856754>
 <24.616199,-84.348297,-38.982201>, <-0.496257,0.140674,0.856703>
}
   smooth_triangle{ <24.616199,-84.348297,-38.982201>, <0.496257,-0.140674,-0.856703>
 <25.851500,-84.362801,-38.264198>, <0.496245,-0.141401,-0.856590>
 <24.684401,-84.389397,-38.935799>, <0.496194,-0.141743,-0.856563>
}
   smooth_triangle{ <24.616199,-84.348297,-38.982201>, <-0.496257,0.140674,0.856703>
 <24.684401,-84.389397,-38.935799>, <-0.496194,0.141743,0.856563>
 <25.851500,-84.362801,-38.264198>, <-0.496245,0.141401,0.856590>
}
   smooth_triangle{ <24.684401,-84.389397,-38.935799>, <0.496194,-0.141743,-0.856563>
 <23.649000,-84.370201,-39.538799>, <0.496334,-0.140082,-0.856756>
 <24.616199,-84.348297,-38.982201>, <0.496257,-0.140674,-0.856703>
}
   smooth_triangle{ <24.684401,-84.389397,-38.935799>, <-0.496194,0.141743,0.856563>
 <24.616199,-84.348297,-38.982201>, <-0.496257,0.140674,0.856703>
 <23.649000,-84.370201,-39.538799>, <-0.496334,0.140082,0.856756>
}
   smooth_triangle{ <24.406799,-84.316597,-39.108601>, <0.496351,-0.139270,-0.856878>
 <25.778400,-84.324402,-38.312801>, <0.496321,-0.140137,-0.856754>
 <24.616199,-84.348297,-38.982201>, <0.496257,-0.140674,-0.856703>
}
   smooth_triangle{ <24.406799,-84.316597,-39.108601>, <-0.496351,0.139270,0.856878>
 <24.616199,-84.348297,-38.982201>, <-0.496257,0.140674,0.856703>
 <25.778400,-84.324402,-38.312801>, <-0.496321,0.140137,0.856754>
}
   smooth_triangle{ <24.616199,-84.348297,-38.982201>, <0.496257,-0.140674,-0.856703>
 <23.468399,-84.341698,-39.648102>, <0.496285,-0.140035,-0.856791>
 <24.406799,-84.316597,-39.108601>, <0.496351,-0.139270,-0.856878>
}
   smooth_triangle{ <24.616199,-84.348297,-38.982201>, <-0.496257,0.140674,0.856703>
 <24.406799,-84.316597,-39.108601>, <-0.496351,0.139270,0.856878>
 <23.468399,-84.341698,-39.648102>, <-0.496285,0.140035,0.856791>
}
   smooth_triangle{ <23.468399,-84.341698,-39.648102>, <0.496285,-0.140035,-0.856791>
 <24.616199,-84.348297,-38.982201>, <0.496257,-0.140674,-0.856703>
 <23.649000,-84.370201,-39.538799>, <0.496334,-0.140082,-0.856756>
}
   smooth_triangle{ <23.468399,-84.341698,-39.648102>, <-0.496285,0.140035,0.856791>
 <23.649000,-84.370201,-39.538799>, <-0.496334,0.140082,0.856756>
 <24.616199,-84.348297,-38.982201>, <-0.496257,0.140674,0.856703>
}
   smooth_triangle{ <23.649000,-84.370201,-39.538799>, <0.496334,-0.140082,-0.856756>
 <22.776300,-84.363098,-40.045502>, <0.496510,-0.137119,-0.857133>
 <23.468399,-84.341698,-39.648102>, <0.496285,-0.140035,-0.856791>
}
   smooth_triangle{ <23.649000,-84.370201,-39.538799>, <-0.496334,0.140082,0.856756>
 <23.468399,-84.341698,-39.648102>, <-0.496285,0.140035,0.856791>
 <22.776300,-84.363098,-40.045502>, <-0.496510,0.137119,0.857133>
}
   smooth_triangle{ <23.649000,-84.370201,-39.538799>, <0.496334,-0.140082,-0.856756>
 <24.684401,-84.389397,-38.935799>, <0.496194,-0.141743,-0.856563>
 <23.663200,-84.408600,-39.524300>, <0.496176,-0.142305,-0.856481>
}
   smooth_triangle{ <23.649000,-84.370201,-39.538799>, <-0.496334,0.140082,0.856756>
 <23.663200,-84.408600,-39.524300>, <-0.496176,0.142305,0.856481>
 <24.684401,-84.389397,-38.935799>, <-0.496194,0.141743,0.856563>
}
   smooth_triangle{ <23.663200,-84.408600,-39.524300>, <0.496176,-0.142305,-0.856481>
 <22.891001,-84.386299,-39.975399>, <0.496175,-0.141339,-0.856641>
 <23.649000,-84.370201,-39.538799>, <0.496334,-0.140082,-0.856756>
}
   smooth_triangle{ <23.663200,-84.408600,-39.524300>, <-0.496176,0.142305,0.856481>
 <23.649000,-84.370201,-39.538799>, <-0.496334,0.140082,0.856756>
 <22.891001,-84.386299,-39.975399>, <-0.496175,0.141339,0.856641>
}
   smooth_triangle{ <22.891001,-84.386299,-39.975399>, <0.496175,-0.141339,-0.856641>
 <23.663200,-84.408600,-39.524300>, <0.496176,-0.142305,-0.856481>
 <22.802500,-84.417099,-40.021400>, <0.495867,-0.145089,-0.856192>
}
   smooth_triangle{ <22.891001,-84.386299,-39.975399>, <-0.496175,0.141339,0.856641>
 <22.802500,-84.417099,-40.021400>, <-0.495867,0.145089,0.856192>
 <23.663200,-84.408600,-39.524300>, <-0.496176,0.142305,0.856481>
}
   smooth_triangle{ <22.802500,-84.417099,-40.021400>, <0.495867,-0.145089,-0.856192>
 <22.355801,-84.392700,-40.284199>, <0.495815,-0.145569,-0.856141>
 <22.891001,-84.386299,-39.975399>, <0.496175,-0.141339,-0.856641>
}
   smooth_triangle{ <22.802500,-84.417099,-40.021400>, <-0.495867,0.145089,0.856192>
 <22.891001,-84.386299,-39.975399>, <-0.496175,0.141339,0.856641>
 <22.355801,-84.392700,-40.284199>, <-0.495815,0.145569,0.856141>
}
   smooth_triangle{ <22.776300,-84.363098,-40.045502>, <0.496510,-0.137119,-0.857133>
 <23.649000,-84.370201,-39.538799>, <0.496334,-0.140082,-0.856756>
 <22.891001,-84.386299,-39.975399>, <0.496175,-0.141339,-0.856641>
}
   smooth_triangle{ <22.776300,-84.363098,-40.045502>, <-0.496510,0.137119,0.857133>
 <22.891001,-84.386299,-39.975399>, <-0.496175,0.141339,0.856641>
 <23.649000,-84.370201,-39.538799>, <-0.496334,0.140082,0.856756>
}
   smooth_triangle{ <22.891001,-84.386299,-39.975399>, <0.496175,-0.141339,-0.856641>
 <22.348200,-84.377998,-40.291100>, <0.496100,-0.142190,-0.856544>
 <22.776300,-84.363098,-40.045502>, <0.496510,-0.137119,-0.857133>
}
   smooth_triangle{ <22.891001,-84.386299,-39.975399>, <-0.496175,0.141339,0.856641>
 <22.776300,-84.363098,-40.045502>, <-0.496510,0.137119,0.857133>
 <22.348200,-84.377998,-40.291100>, <-0.496100,0.142190,0.856544>
}
   smooth_triangle{ <22.348200,-84.377998,-40.291100>, <0.496100,-0.142190,-0.856544>
 <22.891001,-84.386299,-39.975399>, <0.496175,-0.141339,-0.856641>
 <22.355801,-84.392700,-40.284199>, <0.495815,-0.145569,-0.856141>
}
   smooth_triangle{ <22.348200,-84.377998,-40.291100>, <-0.496100,0.142190,0.856544>
 <22.355801,-84.392700,-40.284199>, <-0.495815,0.145569,0.856141>
 <22.891001,-84.386299,-39.975399>, <-0.496175,0.141339,0.856641>
}
   smooth_triangle{ <22.355801,-84.392700,-40.284199>, <0.495815,-0.145569,-0.856141>
 <22.201599,-84.383499,-40.375099>, <0.495973,-0.145412,-0.856076>
 <22.348200,-84.377998,-40.291100>, <0.496100,-0.142190,-0.856544>
}
   smooth_triangle{ <22.355801,-84.392700,-40.284199>, <-0.495815,0.145569,0.856141>
 <22.348200,-84.377998,-40.291100>, <-0.496100,0.142190,0.856544>
 <22.201599,-84.383499,-40.375099>, <-0.495973,0.145412,0.856076>
}
   smooth_triangle{ <28.678900,-82.703796,-23.202200>, <-0.495824,0.145000,0.856232>
 <28.522400,-82.697304,-23.293900>, <-0.496118,0.143612,0.856296>
 <28.445499,-82.705902,-23.337000>, <-0.495973,0.145310,0.856094>
}
   smooth_triangle{ <28.113300,-82.709702,-23.528900>, <-0.496122,0.145620,0.855955>
 <28.445499,-82.705902,-23.337000>, <-0.495973,0.145310,0.856094>
 <28.522400,-82.697304,-23.293900>, <-0.496118,0.143612,0.856296>
}
   smooth_triangle{ <28.678900,-82.703796,-23.202200>, <-0.495824,0.145000,0.856232>
 <28.445499,-82.705902,-23.337000>, <-0.495973,0.145310,0.856094>
 <28.521000,-82.716202,-23.291500>, <-0.496112,0.144103,0.856217>
}
   smooth_triangle{ <28.113300,-82.709702,-23.528900>, <-0.496122,0.145620,0.855955>
 <28.521000,-82.716202,-23.291500>, <-0.496112,0.144103,0.856217>
 <28.445499,-82.705902,-23.337000>, <-0.495973,0.145310,0.856094>
}
   smooth_triangle{ <28.521000,-82.716202,-23.291500>, <-0.496112,0.144103,0.856217>
 <27.705000,-82.712700,-23.764999>, <-0.496292,0.140756,0.856669>
 <28.261000,-82.730202,-23.439899>, <-0.496121,0.143589,0.856298>
}
   smooth_triangle{ <27.178200,-82.724602,-24.068100>, <-0.496093,0.143508,0.856328>
 <28.261000,-82.730202,-23.439899>, <-0.496121,0.143589,0.856298>
 <27.705000,-82.712700,-23.764999>, <-0.496292,0.140756,0.856669>
}
   smooth_triangle{ <28.261000,-82.730202,-23.439899>, <-0.496121,0.143589,0.856298>
 <27.178200,-82.724602,-24.068100>, <-0.496093,0.143508,0.856328>
 <27.901199,-82.746597,-23.645599>, <-0.496354,0.140332,0.856703>
}
   smooth_triangle{ <26.651501,-82.736702,-24.371300>, <-0.496341,0.140127,0.856744>
 <27.901199,-82.746597,-23.645599>, <-0.496354,0.140332,0.856703>
 <27.178200,-82.724602,-24.068100>, <-0.496093,0.143508,0.856328>
}
   smooth_triangle{ <28.522400,-82.697304,-23.293900>, <-0.496118,0.143612,0.856296>
 <28.263700,-82.691902,-23.444700>, <-0.496348,0.139591,0.856827>
 <27.705000,-82.712700,-23.764999>, <-0.496292,0.140756,0.856669>
}
   smooth_triangle{ <27.179199,-82.709503,-24.070000>, <-0.496267,0.140380,0.856745>
 <27.705000,-82.712700,-23.764999>, <-0.496292,0.140756,0.856669>
 <28.263700,-82.691902,-23.444700>, <-0.496348,0.139591,0.856827>
}
   smooth_triangle{ <28.263700,-82.691902,-23.444700>, <-0.496348,0.139591,0.856827>
 <27.905300,-82.685997,-23.653299>, <-0.496081,0.143618,0.856316>
 <27.179199,-82.709503,-24.070000>, <-0.496267,0.140380,0.856745>
}
   smooth_triangle{ <26.653500,-82.706299,-24.375099>, <-0.496116,0.143527,0.856311>
 <27.179199,-82.709503,-24.070000>, <-0.496267,0.140380,0.856745>
 <27.905300,-82.685997,-23.653299>, <-0.496081,0.143618,0.856316>
}
   smooth_triangle{ <27.705000,-82.712700,-23.764999>, <-0.496292,0.140756,0.856669>
 <26.653500,-82.706299,-24.375099>, <-0.496116,0.143527,0.856311>
 <26.651501,-82.736702,-24.371300>, <-0.496341,0.140127,0.856744>
}
   smooth_triangle{ <25.401800,-82.726700,-25.096901>, <-0.496199,0.142290,0.856469>
 <26.651501,-82.736702,-24.371300>, <-0.496341,0.140127,0.856744>
 <26.653500,-82.706299,-24.375099>, <-0.496116,0.143527,0.856311>
}
   smooth_triangle{ <27.905300,-82.685997,-23.653299>, <-0.496081,0.143618,0.856316>
 <27.449301,-82.680496,-23.918400>, <-0.496207,0.142713,0.856395>
 <26.653500,-82.706299,-24.375099>, <-0.496116,0.143527,0.856311>
}
   smooth_triangle{ <26.044201,-82.698502,-24.729601>, <-0.496468,0.138864,0.856876>
 <26.653500,-82.706299,-24.375099>, <-0.496116,0.143527,0.856311>
 <27.449301,-82.680496,-23.918400>, <-0.496207,0.142713,0.856395>
}
   smooth_triangle{ <27.449301,-82.680496,-23.918400>, <-0.496207,0.142713,0.856395>
 <26.897900,-82.676300,-24.238501>, <-0.496383,0.139906,0.856756>
 <26.044201,-82.698502,-24.729601>, <-0.496468,0.138864,0.856876>
}
   smooth_triangle{ <25.434799,-82.690804,-25.083799>, <-0.496229,0.141977,0.856504>
 <26.044201,-82.698502,-24.729601>, <-0.496468,0.138864,0.856876>
 <26.897900,-82.676300,-24.238501>, <-0.496383,0.139906,0.856756>
}
   smooth_triangle{ <26.897900,-82.676300,-24.238501>, <-0.496383,0.139906,0.856756>
 <26.253300,-82.674400,-24.612400>, <-0.496056,0.144237,0.856227>
 <25.434799,-82.690804,-25.083799>, <-0.496229,0.141977,0.856504>
}
   smooth_triangle{ <24.736099,-82.689499,-25.488800>, <-0.496377,0.139003,0.856906>
 <25.434799,-82.690804,-25.083799>, <-0.496229,0.141977,0.856504>
 <26.253300,-82.674400,-24.612400>, <-0.496056,0.144237,0.856227>
}
   smooth_triangle{ <26.253300,-82.674400,-24.612400>, <-0.496056,0.144237,0.856227>
 <25.517599,-82.675797,-25.038300>, <-0.496576,0.135847,0.857297>
 <24.736099,-82.689499,-25.488800>, <-0.496377,0.139003,0.856906>
}
   smooth_triangle{ <24.037300,-82.688202,-25.893801>, <-0.496683,0.134943,0.857377>
 <24.736099,-82.689499,-25.488800>, <-0.496377,0.139003,0.856906>
 <25.517599,-82.675797,-25.038300>, <-0.496576,0.135847,0.857297>
}
   smooth_triangle{ <26.653500,-82.706299,-24.375099>, <-0.496116,0.143527,0.856311>
 <25.434799,-82.690804,-25.083799>, <-0.496229,0.141977,0.856504>
 <25.401800,-82.726700,-25.096901>, <-0.496199,0.142290,0.856469>
}
   smooth_triangle{ <24.152100,-82.716698,-25.822599>, <-0.496157,0.142965,0.856381>
 <25.401800,-82.726700,-25.096901>, <-0.496199,0.142290,0.856469>
 <25.434799,-82.690804,-25.083799>, <-0.496229,0.141977,0.856504>
}
   smooth_triangle{ <25.434799,-82.690804,-25.083799>, <-0.496229,0.141977,0.856504>
 <24.037300,-82.688202,-25.893801>, <-0.496683,0.134943,0.857377>
 <24.793501,-82.703697,-25.453300>, <-0.496458,0.138150,0.856997>
}
   smooth_triangle{ <23.422800,-82.697197,-26.248400>, <-0.496269,0.141062,0.856632>
 <24.793501,-82.703697,-25.453300>, <-0.496458,0.138150,0.856997>
 <24.037300,-82.688202,-25.893801>, <-0.496683,0.134943,0.857377>
}
   smooth_triangle{ <24.793501,-82.703697,-25.453300>, <-0.496458,0.138150,0.856997>
 <23.422800,-82.697197,-26.248400>, <-0.496269,0.141062,0.856632>
 <24.152100,-82.716698,-25.822599>, <-0.496157,0.142965,0.856381>
}
   smooth_triangle{ <22.902599,-82.706802,-26.548201>, <-0.496117,0.143454,0.856323>
 <24.152100,-82.716698,-25.822599>, <-0.496157,0.142965,0.856381>
 <23.422800,-82.697197,-26.248400>, <-0.496269,0.141062,0.856632>
}
   smooth_triangle{ <27.901199,-82.746597,-23.645599>, <-0.496354,0.140332,0.856703>
 <26.651501,-82.736702,-24.371300>, <-0.496341,0.140127,0.856744>
 <27.443701,-82.763199,-23.908001>, <-0.496284,0.141170,0.856606>
}
   smooth_triangle{ <26.052900,-82.753799,-24.715300>, <-0.496057,0.143824,0.856295>
 <27.443701,-82.763199,-23.908001>, <-0.496284,0.141170,0.856606>
 <26.651501,-82.736702,-24.371300>, <-0.496341,0.140127,0.856744>
}
   smooth_triangle{ <27.443701,-82.763199,-23.908001>, <-0.496284,0.141170,0.856606>
 <26.052900,-82.753799,-24.715300>, <-0.496057,0.143824,0.856295>
 <26.891001,-82.778503,-24.225599>, <-0.496019,0.144167,0.856260>
}
   smooth_triangle{ <25.454300,-82.771004,-25.059099>, <-0.496199,0.142324,0.856464>
 <26.891001,-82.778503,-24.225599>, <-0.496019,0.144167,0.856260>
 <26.052900,-82.753799,-24.715300>, <-0.496057,0.143824,0.856295>
}
   smooth_triangle{ <26.891001,-82.778503,-24.225599>, <-0.496019,0.144167,0.856260>
 <25.454300,-82.771004,-25.059099>, <-0.496199,0.142324,0.856464>
 <26.245300,-82.790298,-24.597700>, <-0.496502,0.138281,0.856951>
}
   smooth_triangle{ <24.762199,-82.780602,-25.458599>, <-0.496520,0.138156,0.856960>
 <26.245300,-82.790298,-24.597700>, <-0.496502,0.138281,0.856951>
 <25.454300,-82.771004,-25.059099>, <-0.496199,0.142324,0.856464>
}
   smooth_triangle{ <26.245300,-82.790298,-24.597700>, <-0.496502,0.138281,0.856951>
 <24.762199,-82.780602,-25.458599>, <-0.496520,0.138156,0.856960>
 <25.509300,-82.796898,-25.023100>, <-0.496442,0.139096,0.856853>
}
   smooth_triangle{ <24.070200,-82.790298,-25.857901>, <-0.496216,0.142294,0.856459>
 <25.509300,-82.796898,-25.023100>, <-0.496442,0.139096,0.856853>
 <24.762199,-82.780602,-25.458599>, <-0.496520,0.138156,0.856960>
}
   smooth_triangle{ <26.651501,-82.736702,-24.371300>, <-0.496341,0.140127,0.856744>
 <25.401800,-82.726700,-25.096901>, <-0.496199,0.142290,0.856469>
 <25.454300,-82.771004,-25.059099>, <-0.496199,0.142324,0.856464>
}
   smooth_triangle{ <24.167801,-82.747002,-25.808500>, <-0.496288,0.141201,0.856598>
 <25.454300,-82.771004,-25.059099>, <-0.496199,0.142324,0.856464>
 <25.401800,-82.726700,-25.096901>, <-0.496199,0.142290,0.856469>
}
   smooth_triangle{ <25.454300,-82.771004,-25.059099>, <-0.496199,0.142324,0.856464>
 <24.811001,-82.759003,-25.433901>, <-0.496211,0.142350,0.856452>
 <24.070200,-82.790298,-25.857901>, <-0.496216,0.142294,0.856459>
}
   smooth_triangle{ <23.458700,-82.779800,-26.213900>, <-0.496244,0.141649,0.856550>
 <24.070200,-82.790298,-25.857901>, <-0.496216,0.142294,0.856459>
 <24.811001,-82.759003,-25.433901>, <-0.496211,0.142350,0.856452>
}
   smooth_triangle{ <24.811001,-82.759003,-25.433901>, <-0.496211,0.142350,0.856452>
 <24.167801,-82.747002,-25.808500>, <-0.496288,0.141201,0.856598>
 <23.458700,-82.779800,-26.213900>, <-0.496244,0.141649,0.856550>
}
   smooth_triangle{ <22.933800,-82.767303,-26.520100>, <-0.496384,0.139534,0.856816>
 <23.458700,-82.779800,-26.213900>, <-0.496244,0.141649,0.856550>
 <24.167801,-82.747002,-25.808500>, <-0.496288,0.141201,0.856598>
}
   smooth_triangle{ <25.401800,-82.726700,-25.096901>, <-0.496199,0.142290,0.856469>
 <24.152100,-82.716698,-25.822599>, <-0.496157,0.142965,0.856381>
 <24.167801,-82.747002,-25.808500>, <-0.496288,0.141201,0.856598>
}
   smooth_triangle{ <23.033100,-82.732201,-26.468399>, <-0.496280,0.140632,0.856696>
 <24.167801,-82.747002,-25.808500>, <-0.496288,0.141201,0.856598>
 <24.152100,-82.716698,-25.822599>, <-0.496157,0.142965,0.856381>
}
   smooth_triangle{ <24.167801,-82.747002,-25.808500>, <-0.496288,0.141201,0.856598>
 <23.600401,-82.739601,-26.138399>, <-0.496269,0.141322,0.856589>
 <22.933800,-82.767303,-26.520100>, <-0.496384,0.139534,0.856816>
}
   smooth_triangle{ <22.506399,-82.754204,-26.769800>, <-0.496144,0.142681,0.856436>
 <22.933800,-82.767303,-26.520100>, <-0.496384,0.139534,0.856816>
 <23.600401,-82.739601,-26.138399>, <-0.496269,0.141322,0.856589>
}
   smooth_triangle{ <23.600401,-82.739601,-26.138399>, <-0.496269,0.141322,0.856589>
 <23.033100,-82.732201,-26.468399>, <-0.496280,0.140632,0.856696>
 <22.506399,-82.754204,-26.769800>, <-0.496144,0.142681,0.856436>
}
   smooth_triangle{ <22.187700,-82.742699,-26.956301>, <-0.496328,0.140500,0.856690>
 <22.506399,-82.754204,-26.769800>, <-0.496144,0.142681,0.856436>
 <23.033100,-82.732201,-26.468399>, <-0.496280,0.140632,0.856696>
}
   smooth_triangle{ <24.152100,-82.716698,-25.822599>, <-0.496157,0.142965,0.856381>
 <22.902599,-82.706802,-26.548201>, <-0.496117,0.143454,0.856323>
 <23.592600,-82.724403,-26.145500>, <-0.496238,0.141646,0.856553>
}
   smooth_triangle{ <22.484200,-82.716003,-26.789000>, <-0.496207,0.141505,0.856595>
 <23.592600,-82.724403,-26.145500>, <-0.496238,0.141646,0.856553>
 <22.902599,-82.706802,-26.548201>, <-0.496117,0.143454,0.856323>
}
   smooth_triangle{ <23.592600,-82.724403,-26.145500>, <-0.496238,0.141646,0.856553>
 <22.484200,-82.716003,-26.789000>, <-0.496207,0.141505,0.856595>
 <23.033100,-82.732201,-26.468399>, <-0.496280,0.140632,0.856696>
}
   smooth_triangle{ <22.175699,-82.723801,-26.966400>, <-0.496107,0.144343,0.856179>
 <23.033100,-82.732201,-26.468399>, <-0.496280,0.140632,0.856696>
 <22.484200,-82.716003,-26.789000>, <-0.496207,0.141505,0.856595>
}
   smooth_triangle{ <23.033100,-82.732201,-26.468399>, <-0.496280,0.140632,0.856696>
 <22.604300,-82.727997,-26.717400>, <-0.496359,0.138448,0.857006>
 <22.610399,-82.737396,-26.712400>, <-0.496531,0.135213,0.857423>
}
   smooth_triangle{ <22.236500,-82.731796,-26.929800>, <-0.496338,0.140928,0.856614>
 <22.610399,-82.737396,-26.712400>, <-0.496531,0.135213,0.857423>
 <22.604300,-82.727997,-26.717400>, <-0.496359,0.138448,0.857006>
}
   smooth_triangle{ <22.610399,-82.737396,-26.712400>, <-0.496531,0.135213,0.857423>
 <22.236500,-82.731796,-26.929800>, <-0.496338,0.140928,0.856614>
 <22.187700,-82.742699,-26.956301>, <-0.496328,0.140500,0.856690>
}
   smooth_triangle{ <21.985600,-82.731697,-27.075300>, <-0.496497,0.142537,0.856256>
 <22.187700,-82.742699,-26.956301>, <-0.496328,0.140500,0.856690>
 <22.236500,-82.731796,-26.929800>, <-0.496338,0.140928,0.856614>
}
   smooth_triangle{ <22.604300,-82.727997,-26.717400>, <-0.496359,0.138448,0.857006>
 <22.175699,-82.723801,-26.966400>, <-0.496107,0.144343,0.856179>
 <22.236500,-82.731796,-26.929800>, <-0.496338,0.140928,0.856614>
}
   smooth_triangle{ <21.985600,-82.731697,-27.075300>, <-0.496497,0.142537,0.856256>
 <22.236500,-82.731796,-26.929800>, <-0.496338,0.140928,0.856614>
 <22.175699,-82.723801,-26.966400>, <-0.496107,0.144343,0.856179>
}
}
texture
      { pigment{bozo colour_map{[0.2 red 0.74 green 0.74 blue 0.75][0.8 red 0.4 green 0.4 blue 0.5]}
     scale 4.5
}
      }
      finish
     {ambient 0.4 diffuse 0.5
     specular 0.2 roughness 0.1}
}
//  Object:  vert. rep la2
object
{   union{
   smooth_triangle{ <26.704901,-67.799202,-30.650801>, <-0.381620,0.661130,0.645966>
 <26.729900,-67.737000,-30.699699>, <-0.380783,0.661013,0.646580>
 <25.129801,-67.752998,-31.637501>, <-0.387544,0.659727,0.643871>
}
   smooth_triangle{ <25.129801,-67.752998,-31.637501>, <-0.387544,0.659727,0.643871>
 <25.117800,-67.809303,-31.587099>, <-0.389100,0.659288,0.643382>
 <26.704901,-67.799202,-30.650801>, <-0.381620,0.661130,0.645966>
}
   smooth_triangle{ <26.634100,-67.975502,-30.511999>, <-0.381668,0.661174,0.645893>
 <26.704901,-67.799202,-30.650801>, <-0.381620,0.661130,0.645966>
 <25.117800,-67.809303,-31.587099>, <-0.389100,0.659288,0.643382>
}
   smooth_triangle{ <25.117800,-67.809303,-31.587099>, <-0.389100,0.659288,0.643382>
 <25.083500,-67.969704,-31.443701>, <-0.389386,0.659065,0.643438>
 <26.634100,-67.975502,-30.511999>, <-0.381668,0.661174,0.645893>
}
   smooth_triangle{ <26.523399,-68.250801,-30.295300>, <-0.381640,0.661376,0.645703>
 <26.634100,-67.975502,-30.511999>, <-0.381668,0.661174,0.645893>
 <25.083500,-67.969704,-31.443701>, <-0.389386,0.659065,0.643438>
}
   smooth_triangle{ <25.083500,-67.969704,-31.443701>, <-0.389386,0.659065,0.643438>
 <25.028799,-68.221703,-31.218700>, <-0.389593,0.659248,0.643124>
 <26.523399,-68.250801,-30.295300>, <-0.381640,0.661376,0.645703>
}
   smooth_triangle{ <26.378901,-68.609901,-30.012400>, <-0.381666,0.661397,0.645667>
 <26.523399,-68.250801,-30.295300>, <-0.381640,0.661376,0.645703>
 <25.028799,-68.221703,-31.218700>, <-0.389593,0.659248,0.643124>
}
   smooth_triangle{ <25.028799,-68.221703,-31.218700>, <-0.389593,0.659248,0.643124>
 <24.955700,-68.553001,-30.923700>, <-0.390305,0.659058,0.642887>
 <26.378901,-68.609901,-30.012400>, <-0.381666,0.661397,0.645667>
}
   smooth_triangle{ <25.117800,-67.809303,-31.587099>, <-0.389100,0.659288,0.643382>
 <25.129801,-67.752998,-31.637501>, <-0.387544,0.659727,0.643871>
 <23.675600,-67.778099,-32.503101>, <-0.395895,0.657845,0.640708>
}
   smooth_triangle{ <23.675600,-67.778099,-32.503101>, <-0.395895,0.657845,0.640708>
 <23.671900,-67.829498,-32.452599>, <-0.397473,0.656943,0.640656>
 <25.117800,-67.809303,-31.587099>, <-0.389100,0.659288,0.643382>
}
   smooth_triangle{ <25.083500,-67.969704,-31.443701>, <-0.389386,0.659065,0.643438>
 <25.117800,-67.809303,-31.587099>, <-0.389100,0.659288,0.643382>
 <23.671900,-67.829498,-32.452599>, <-0.397473,0.656943,0.640656>
}
   smooth_triangle{ <23.671900,-67.829498,-32.452599>, <-0.397473,0.656943,0.640656>
 <23.661100,-67.976997,-32.308300>, <-0.397513,0.656867,0.640710>
 <25.083500,-67.969704,-31.443701>, <-0.389386,0.659065,0.643438>
}
   smooth_triangle{ <25.028799,-68.221703,-31.218700>, <-0.389593,0.659248,0.643124>
 <25.083500,-67.969704,-31.443701>, <-0.389386,0.659065,0.643438>
 <23.661100,-67.976997,-32.308300>, <-0.397513,0.656867,0.640710>
}
   smooth_triangle{ <23.661100,-67.976997,-32.308300>, <-0.397513,0.656867,0.640710>
 <23.643299,-68.209198,-32.081200>, <-0.397417,0.657083,0.640547>
 <25.028799,-68.221703,-31.218700>, <-0.389593,0.659248,0.643124>
}
   smooth_triangle{ <24.955700,-68.553001,-30.923700>, <-0.390305,0.659058,0.642887>
 <25.028799,-68.221703,-31.218700>, <-0.389593,0.659248,0.643124>
 <23.643299,-68.209198,-32.081200>, <-0.397417,0.657083,0.640547>
}
   smooth_triangle{ <23.643299,-68.209198,-32.081200>, <-0.397417,0.657083,0.640547>
 <23.618900,-68.515404,-31.782301>, <-0.397267,0.657263,0.640457>
 <24.955700,-68.553001,-30.923700>, <-0.390305,0.659058,0.642887>
}
   smooth_triangle{ <26.012600,-69.519096,-29.296700>, <-0.382145,0.661436,0.645343>
 <26.378901,-68.609901,-30.012400>, <-0.381666,0.661397,0.645667>
 <24.955700,-68.553001,-30.923700>, <-0.390305,0.659058,0.642887>
}
   smooth_triangle{ <24.955700,-68.553001,-30.923700>, <-0.390305,0.659058,0.642887>
 <24.762699,-69.403397,-30.170000>, <-0.391584,0.658971,0.642198>
 <26.012600,-69.519096,-29.296700>, <-0.382145,0.661436,0.645343>
}
   smooth_triangle{ <25.583500,-70.581596,-28.460100>, <-0.383622,0.661552,0.644347>
 <26.012600,-69.519096,-29.296700>, <-0.382145,0.661436,0.645343>
 <24.762699,-69.403397,-30.170000>, <-0.391584,0.658971,0.642198>
}
   smooth_triangle{ <24.762699,-69.403397,-30.170000>, <-0.391584,0.658971,0.642198>
 <24.521099,-70.420601,-29.274799>, <-0.391541,0.660322,0.640836>
 <25.583500,-70.581596,-28.460100>, <-0.383622,0.661552,0.644347>
}
   smooth_triangle{ <24.762699,-69.403397,-30.170000>, <-0.391584,0.658971,0.642198>
 <24.955700,-68.553001,-30.923700>, <-0.390305,0.659058,0.642887>
 <23.618900,-68.515404,-31.782301>, <-0.397267,0.657263,0.640457>
}
   smooth_triangle{ <23.618900,-68.515404,-31.782301>, <-0.397267,0.657263,0.640457>
 <23.550900,-69.305603,-31.013399>, <-0.396597,0.657790,0.640331>
 <24.762699,-69.403397,-30.170000>, <-0.391584,0.658971,0.642198>
}
   smooth_triangle{ <24.521099,-70.420601,-29.274799>, <-0.391541,0.660322,0.640836>
 <24.762699,-69.403397,-30.170000>, <-0.391584,0.658971,0.642198>
 <23.550900,-69.305603,-31.013399>, <-0.396597,0.657790,0.640331>
}
   smooth_triangle{ <23.550900,-69.305603,-31.013399>, <-0.396597,0.657790,0.640331>
 <23.458700,-70.259804,-30.089500>, <-0.395345,0.659343,0.639507>
 <24.521099,-70.420601,-29.274799>, <-0.391541,0.660322,0.640836>
}
   smooth_triangle{ <23.671900,-67.829498,-32.452599>, <-0.397473,0.656943,0.640656>
 <23.675600,-67.778099,-32.503101>, <-0.395895,0.657845,0.640708>
 <22.388000,-67.808601,-33.280201>, <-0.403830,0.655209,0.638453>
}
   smooth_triangle{ <22.388000,-67.808601,-33.280201>, <-0.403830,0.655209,0.638453>
 <22.388599,-67.856697,-33.230499>, <-0.404840,0.655182,0.637841>
 <23.671900,-67.829498,-32.452599>, <-0.397473,0.656943,0.640656>
}
   smooth_triangle{ <23.661100,-67.976997,-32.308300>, <-0.397513,0.656867,0.640710>
 <23.671900,-67.829498,-32.452599>, <-0.397473,0.656943,0.640656>
 <22.388599,-67.856697,-33.230499>, <-0.404840,0.655182,0.637841>
}
   smooth_triangle{ <22.388599,-67.856697,-33.230499>, <-0.404840,0.655182,0.637841>
 <22.389900,-67.994598,-33.088100>, <-0.404593,0.655339,0.637836>
 <23.661100,-67.976997,-32.308300>, <-0.397513,0.656867,0.640710>
}
   smooth_triangle{ <23.643299,-68.209198,-32.081200>, <-0.397417,0.657083,0.640547>
 <23.661100,-67.976997,-32.308300>, <-0.397513,0.656867,0.640710>
 <22.389900,-67.994598,-33.088100>, <-0.404593,0.655339,0.637836>
}
   smooth_triangle{ <22.389900,-67.994598,-33.088100>, <-0.404593,0.655339,0.637836>
 <22.391100,-68.212799,-32.863300>, <-0.404087,0.655759,0.637726>
 <23.643299,-68.209198,-32.081200>, <-0.397417,0.657083,0.640547>
}
   smooth_triangle{ <23.618900,-68.515404,-31.782301>, <-0.397267,0.657263,0.640457>
 <23.643299,-68.209198,-32.081200>, <-0.397417,0.657083,0.640547>
 <22.391100,-68.212799,-32.863300>, <-0.404087,0.655759,0.637726>
}
   smooth_triangle{ <22.391100,-68.212799,-32.863300>, <-0.404087,0.655759,0.637726>
 <22.391300,-68.501602,-32.566299>, <-0.403364,0.656242,0.637686>
 <23.618900,-68.515404,-31.782301>, <-0.397267,0.657263,0.640457>
}
   smooth_triangle{ <22.388599,-67.856697,-33.230499>, <-0.404840,0.655182,0.637841>
 <22.388000,-67.808601,-33.280201>, <-0.403830,0.655209,0.638453>
 <21.287901,-67.841400,-33.952599>, <-0.410150,0.654779,0.634856>
}
   smooth_triangle{ <21.287901,-67.841400,-33.952599>, <-0.410150,0.654779,0.634856>
 <21.289801,-67.886902,-33.904301>, <-0.410878,0.655040,0.634115>
 <22.388599,-67.856697,-33.230499>, <-0.404840,0.655182,0.637841>
}
   smooth_triangle{ <22.389900,-67.994598,-33.088100>, <-0.404593,0.655339,0.637836>
 <22.388599,-67.856697,-33.230499>, <-0.404840,0.655182,0.637841>
 <21.289801,-67.886902,-33.904301>, <-0.410878,0.655040,0.634115>
}
   smooth_triangle{ <21.289801,-67.886902,-33.904301>, <-0.410878,0.655040,0.634115>
 <21.295000,-68.018204,-33.765499>, <-0.410251,0.655365,0.634185>
 <22.389900,-67.994598,-33.088100>, <-0.404593,0.655339,0.637836>
}
   smooth_triangle{ <22.391100,-68.212799,-32.863300>, <-0.404087,0.655759,0.637726>
 <22.389900,-67.994598,-33.088100>, <-0.404593,0.655339,0.637836>
 <21.295000,-68.018204,-33.765499>, <-0.410251,0.655365,0.634185>
}
   smooth_triangle{ <21.295000,-68.018204,-33.765499>, <-0.410251,0.655365,0.634185>
 <21.302200,-68.226196,-33.545799>, <-0.409237,0.655932,0.634254>
 <22.391100,-68.212799,-32.863300>, <-0.404087,0.655759,0.637726>
}
   smooth_triangle{ <22.391300,-68.501602,-32.566299>, <-0.403364,0.656242,0.637686>
 <22.391100,-68.212799,-32.863300>, <-0.404087,0.655759,0.637726>
 <21.302200,-68.226196,-33.545799>, <-0.409237,0.655932,0.634254>
}
   smooth_triangle{ <21.302200,-68.226196,-33.545799>, <-0.409237,0.655932,0.634254>
 <21.310400,-68.502701,-33.254799>, <-0.407838,0.656545,0.634521>
 <22.391300,-68.501602,-32.566299>, <-0.403364,0.656242,0.637686>
}
   smooth_triangle{ <23.550900,-69.305603,-31.013399>, <-0.396597,0.657790,0.640331>
 <23.618900,-68.515404,-31.782301>, <-0.397267,0.657263,0.640457>
 <22.391300,-68.501602,-32.566299>, <-0.403364,0.656242,0.637686>
}
   smooth_triangle{ <22.391300,-68.501602,-32.566299>, <-0.403364,0.656242,0.637686>
 <22.385201,-69.252602,-31.797300>, <-0.401850,0.657190,0.637666>
 <23.550900,-69.305603,-31.013399>, <-0.396597,0.657790,0.640331>
}
   smooth_triangle{ <23.458700,-70.259804,-30.089500>, <-0.395345,0.659343,0.639507>
 <23.550900,-69.305603,-31.013399>, <-0.396597,0.657790,0.640331>
 <22.385201,-69.252602,-31.797300>, <-0.401850,0.657190,0.637666>
}
   smooth_triangle{ <22.385201,-69.252602,-31.797300>, <-0.401850,0.657190,0.637666>
 <22.365299,-70.170700,-30.863300>, <-0.399285,0.658888,0.637525>
 <23.458700,-70.259804,-30.089500>, <-0.395345,0.659343,0.639507>
}
   smooth_triangle{ <22.385201,-69.252602,-31.797300>, <-0.401850,0.657190,0.637666>
 <22.391300,-68.501602,-32.566299>, <-0.403364,0.656242,0.637686>
 <21.310400,-68.502701,-33.254799>, <-0.407838,0.656545,0.634521>
}
   smooth_triangle{ <21.310400,-68.502701,-33.254799>, <-0.407838,0.656545,0.634521>
 <21.325800,-69.225601,-32.496899>, <-0.404929,0.657954,0.634924>
 <22.385201,-69.252602,-31.797300>, <-0.401850,0.657190,0.637666>
}
   smooth_triangle{ <22.365299,-70.170700,-30.863300>, <-0.399285,0.658888,0.637525>
 <22.385201,-69.252602,-31.797300>, <-0.401850,0.657190,0.637666>
 <21.325800,-69.225601,-32.496899>, <-0.404929,0.657954,0.634924>
}
   smooth_triangle{ <21.325800,-69.225601,-32.496899>, <-0.404929,0.657954,0.634924>
 <21.332899,-70.117599,-31.567600>, <-0.400732,0.660059,0.635402>
 <22.365299,-70.170700,-30.863300>, <-0.399285,0.658888,0.637525>
}
   smooth_triangle{ <25.139999,-71.676102,-27.598400>, <-0.384321,0.662512,0.642943>
 <25.583500,-70.581596,-28.460100>, <-0.383622,0.661552,0.644347>
 <24.521099,-70.420601,-29.274799>, <-0.391541,0.660322,0.640836>
}
   smooth_triangle{ <24.521099,-70.420601,-29.274799>, <-0.391541,0.660322,0.640836>
 <24.302299,-71.455299,-28.337500>, <-0.391536,0.661460,0.639664>
 <25.139999,-71.676102,-27.598400>, <-0.384321,0.662512,0.642943>
}
   smooth_triangle{ <24.302299,-71.455299,-28.337500>, <-0.391536,0.661460,0.639664>
 <24.521099,-70.420601,-29.274799>, <-0.391541,0.660322,0.640836>
 <23.458700,-70.259804,-30.089500>, <-0.395345,0.659343,0.639507>
}
   smooth_triangle{ <23.458700,-70.259804,-30.089500>, <-0.395345,0.659343,0.639507>
 <23.333799,-71.284302,-29.109301>, <-0.393693,0.660289,0.639550>
 <24.302299,-71.455299,-28.337500>, <-0.391536,0.661460,0.639664>
}
   smooth_triangle{ <24.730400,-72.681297,-26.807100>, <-0.386311,0.662682,0.641573>
 <25.139999,-71.676102,-27.598400>, <-0.384321,0.662512,0.642943>
 <24.302299,-71.455299,-28.337500>, <-0.391536,0.661460,0.639664>
}
   smooth_triangle{ <24.302299,-71.455299,-28.337500>, <-0.391536,0.661460,0.639664>
 <24.061800,-72.466301,-27.440100>, <-0.392835,0.661518,0.638808>
 <24.730400,-72.681297,-26.807100>, <-0.386311,0.662682,0.641573>
}
   smooth_triangle{ <24.061800,-72.466301,-27.440100>, <-0.392835,0.661518,0.638808>
 <24.302299,-71.455299,-28.337500>, <-0.391536,0.661460,0.639664>
 <23.333799,-71.284302,-29.109301>, <-0.393693,0.660289,0.639550>
}
   smooth_triangle{ <23.333799,-71.284302,-29.109301>, <-0.393693,0.660289,0.639550>
 <23.209000,-72.309097,-28.129000>, <-0.394649,0.661051,0.638172>
 <24.061800,-72.466301,-27.440100>, <-0.392835,0.661518,0.638808>
}
   smooth_triangle{ <23.209000,-72.309097,-28.129000>, <-0.394649,0.661051,0.638172>
 <23.458700,-70.259804,-30.089500>, <-0.395345,0.659343,0.639507>
 <22.365299,-70.170700,-30.863300>, <-0.399285,0.658888,0.637525>
}
   smooth_triangle{ <22.365299,-70.170700,-30.863300>, <-0.399285,0.658888,0.637525>
 <22.248199,-72.220703,-28.814899>, <-0.396498,0.660669,0.637421>
 <23.209000,-72.309097,-28.129000>, <-0.394649,0.661051,0.638172>
}
   smooth_triangle{ <22.248199,-72.220703,-28.814899>, <-0.396498,0.660669,0.637421>
 <22.365299,-70.170700,-30.863300>, <-0.399285,0.658888,0.637525>
 <21.332899,-70.117599,-31.567600>, <-0.400732,0.660059,0.635402>
}
   smooth_triangle{ <21.332899,-70.117599,-31.567600>, <-0.400732,0.660059,0.635402>
 <21.287600,-72.132401,-29.500799>, <-0.394206,0.663171,0.636243>
 <22.248199,-72.220703,-28.814899>, <-0.396498,0.660669,0.637421>
}
   smooth_triangle{ <24.553499,-73.112503,-26.467800>, <-0.387445,0.663449,0.640095>
 <24.730400,-72.681297,-26.807100>, <-0.386311,0.662682,0.641573>
 <24.061800,-72.466301,-27.440100>, <-0.392835,0.661518,0.638808>
}
   smooth_triangle{ <24.061800,-72.466301,-27.440100>, <-0.392835,0.661518,0.638808>
 <23.948000,-72.899300,-27.060801>, <-0.391919,0.662808,0.638032>
 <24.553499,-73.112503,-26.467800>, <-0.387445,0.663449,0.640095>
}
   smooth_triangle{ <24.403099,-73.475899,-26.181801>, <-0.388645,0.664385,0.638395>
 <24.553499,-73.112503,-26.467800>, <-0.387445,0.663449,0.640095>
 <23.948000,-72.899300,-27.060801>, <-0.391919,0.662808,0.638032>
}
   smooth_triangle{ <23.948000,-72.899300,-27.060801>, <-0.391919,0.662808,0.638032>
 <23.834101,-73.332298,-26.681299>, <-0.391945,0.663682,0.637107>
 <24.403099,-73.475899,-26.181801>, <-0.388645,0.664385,0.638395>
}
   smooth_triangle{ <23.834101,-73.332298,-26.681299>, <-0.391945,0.663682,0.637107>
 <24.061800,-72.466301,-27.440100>, <-0.392835,0.661518,0.638808>
 <23.209000,-72.309097,-28.129000>, <-0.394649,0.661051,0.638172>
}
   smooth_triangle{ <23.209000,-72.309097,-28.129000>, <-0.394649,0.661051,0.638172>
 <23.054899,-73.228897,-27.268499>, <-0.391583,0.664536,0.636439>
 <23.834101,-73.332298,-26.681299>, <-0.391945,0.663682,0.637107>
}
   smooth_triangle{ <24.285400,-73.756302,-25.961100>, <-0.388865,0.666716,0.635825>
 <24.403099,-73.475899,-26.181801>, <-0.388645,0.664385,0.638395>
 <23.834101,-73.332298,-26.681299>, <-0.391945,0.663682,0.637107>
}
   smooth_triangle{ <23.834101,-73.332298,-26.681299>, <-0.391945,0.663682,0.637107>
 <23.732901,-73.674202,-26.386200>, <-0.389763,0.666606,0.635391>
 <24.285400,-73.756302,-25.961100>, <-0.388865,0.666716,0.635825>
}
   smooth_triangle{ <24.206301,-73.938499,-25.817699>, <-0.388745,0.668105,0.634439>
 <24.285400,-73.756302,-25.961100>, <-0.388865,0.666716,0.635825>
 <23.732901,-73.674202,-26.386200>, <-0.389763,0.666606,0.635391>
}
   smooth_triangle{ <23.732901,-73.674202,-26.386200>, <-0.389763,0.666606,0.635391>
 <23.643999,-73.948196,-26.152599>, <-0.389749,0.667122,0.634857>
 <24.206301,-73.938499,-25.817699>, <-0.388745,0.668105,0.634439>
}
   smooth_triangle{ <23.732901,-73.674202,-26.386200>, <-0.389763,0.666606,0.635391>
 <23.834101,-73.332298,-26.681299>, <-0.391945,0.663682,0.637107>
 <23.054899,-73.228897,-27.268499>, <-0.391583,0.664536,0.636439>
}
   smooth_triangle{ <23.054899,-73.228897,-27.268499>, <-0.391583,0.664536,0.636439>
 <22.969299,-73.595100,-26.936899>, <-0.389422,0.666801,0.635395>
 <23.732901,-73.674202,-26.386200>, <-0.389763,0.666606,0.635391>
}
   smooth_triangle{ <23.643999,-73.948196,-26.152599>, <-0.389749,0.667122,0.634857>
 <23.732901,-73.674202,-26.386200>, <-0.389763,0.666606,0.635391>
 <22.969299,-73.595100,-26.936899>, <-0.389422,0.666801,0.635395>
}
   smooth_triangle{ <22.969299,-73.595100,-26.936899>, <-0.389422,0.666801,0.635395>
 <22.883900,-73.961502,-26.605200>, <-0.390281,0.666395,0.635294>
 <23.643999,-73.948196,-26.152599>, <-0.389749,0.667122,0.634857>
}
   smooth_triangle{ <23.054899,-73.228897,-27.268499>, <-0.391583,0.664536,0.636439>
 <23.209000,-72.309097,-28.129000>, <-0.394649,0.661051,0.638172>
 <21.287600,-72.132401,-29.500799>, <-0.394206,0.663171,0.636243>
}
   smooth_triangle{ <21.287600,-72.132401,-29.500799>, <-0.394206,0.663171,0.636243>
 <21.218399,-73.116501,-28.515600>, <-0.391190,0.665748,0.635413>
 <23.054899,-73.228897,-27.268499>, <-0.391583,0.664536,0.636439>
}
   smooth_triangle{ <22.883900,-73.961502,-26.605200>, <-0.390281,0.666395,0.635294>
 <23.054899,-73.228897,-27.268499>, <-0.391583,0.664536,0.636439>
 <21.218399,-73.116501,-28.515600>, <-0.391190,0.665748,0.635413>
}
   smooth_triangle{ <21.218399,-73.116501,-28.515600>, <-0.391190,0.665748,0.635413>
 <21.106800,-73.992798,-27.663900>, <-0.391131,0.665389,0.635826>
 <22.883900,-73.961502,-26.605200>, <-0.390281,0.666395,0.635294>
}
   smooth_triangle{ <21.289801,-67.886902,-33.904301>, <-0.410878,0.655040,0.634115>
 <21.287901,-67.841400,-33.952599>, <-0.410150,0.654779,0.634856>
 <20.396000,-67.872902,-34.504002>, <-0.415650,0.654938,0.631103>
}
   smooth_triangle{ <20.396000,-67.872902,-34.504002>, <-0.415650,0.654938,0.631103>
 <20.397301,-67.916901,-34.457401>, <-0.415796,0.655955,0.629950>
 <21.289801,-67.886902,-33.904301>, <-0.410878,0.655040,0.634115>
}
   smooth_triangle{ <21.295000,-68.018204,-33.765499>, <-0.410251,0.655365,0.634185>
 <21.289801,-67.886902,-33.904301>, <-0.410878,0.655040,0.634115>
 <20.397301,-67.916901,-34.457401>, <-0.415796,0.655955,0.629950>
}
   smooth_triangle{ <20.397301,-67.916901,-34.457401>, <-0.415796,0.655955,0.629950>
 <20.400600,-68.043602,-34.323101>, <-0.414576,0.656921,0.629747>
 <21.295000,-68.018204,-33.765499>, <-0.410251,0.655365,0.634185>
}
   smooth_triangle{ <21.302200,-68.226196,-33.545799>, <-0.409237,0.655932,0.634254>
 <21.295000,-68.018204,-33.765499>, <-0.410251,0.655365,0.634185>
 <20.400600,-68.043602,-34.323101>, <-0.414576,0.656921,0.629747>
}
   smooth_triangle{ <20.400600,-68.043602,-34.323101>, <-0.414576,0.656921,0.629747>
 <20.405199,-68.245003,-34.110100>, <-0.413305,0.657219,0.630272>
 <21.302200,-68.226196,-33.545799>, <-0.409237,0.655932,0.634254>
}
   smooth_triangle{ <21.310400,-68.502701,-33.254799>, <-0.407838,0.656545,0.634521>
 <21.302200,-68.226196,-33.545799>, <-0.409237,0.655932,0.634254>
 <20.405199,-68.245003,-34.110100>, <-0.413305,0.657219,0.630272>
}
   smooth_triangle{ <20.405199,-68.245003,-34.110100>, <-0.413305,0.657219,0.630272>
 <20.410400,-68.513199,-33.827000>, <-0.411132,0.658104,0.630769>
 <21.310400,-68.502701,-33.254799>, <-0.407838,0.656545,0.634521>
}
   smooth_triangle{ <20.397301,-67.916901,-34.457401>, <-0.415796,0.655955,0.629950>
 <20.396000,-67.872902,-34.504002>, <-0.415650,0.654938,0.631103>
 <19.733299,-67.899498,-34.917999>, <-0.419874,0.656530,0.626637>
}
   smooth_triangle{ <19.733299,-67.899498,-34.917999>, <-0.419874,0.656530,0.626637>
 <19.732800,-67.942596,-34.873001>, <-0.419585,0.658153,0.625127>
 <20.397301,-67.916901,-34.457401>, <-0.415796,0.655955,0.629950>
}
   smooth_triangle{ <20.400600,-68.043602,-34.323101>, <-0.414576,0.656921,0.629747>
 <20.397301,-67.916901,-34.457401>, <-0.415796,0.655955,0.629950>
 <19.732800,-67.942596,-34.873001>, <-0.419585,0.658153,0.625127>
}
   smooth_triangle{ <19.732800,-67.942596,-34.873001>, <-0.419585,0.658153,0.625127>
 <19.731501,-68.066597,-34.743099>, <-0.418273,0.658787,0.625338>
 <20.400600,-68.043602,-34.323101>, <-0.414576,0.656921,0.629747>
}
   smooth_triangle{ <20.405199,-68.245003,-34.110100>, <-0.413305,0.657219,0.630272>
 <20.400600,-68.043602,-34.323101>, <-0.414576,0.656921,0.629747>
 <19.731501,-68.066597,-34.743099>, <-0.418273,0.658787,0.625338>
}
   smooth_triangle{ <19.731501,-68.066597,-34.743099>, <-0.418273,0.658787,0.625338>
 <19.729099,-68.264198,-34.536701>, <-0.416572,0.659087,0.626157>
 <20.405199,-68.245003,-34.110100>, <-0.413305,0.657219,0.630272>
}
   smooth_triangle{ <20.410400,-68.513199,-33.827000>, <-0.411132,0.658104,0.630769>
 <20.405199,-68.245003,-34.110100>, <-0.413305,0.657219,0.630272>
 <19.729099,-68.264198,-34.536701>, <-0.416572,0.659087,0.626157>
}
   smooth_triangle{ <19.729099,-68.264198,-34.536701>, <-0.416572,0.659087,0.626157>
 <19.725599,-68.527496,-34.261799>, <-0.413641,0.660168,0.626960>
 <20.410400,-68.513199,-33.827000>, <-0.411132,0.658104,0.630769>
}
   smooth_triangle{ <19.732800,-67.942596,-34.873001>, <-0.419585,0.658153,0.625127>
 <19.733299,-67.899498,-34.917999>, <-0.419874,0.656530,0.626637>
 <19.320299,-67.918098,-35.178299>, <-0.423463,0.658505,0.622134>
}
   smooth_triangle{ <19.320299,-67.918098,-35.178299>, <-0.423463,0.658505,0.622134>
 <19.318199,-67.960701,-35.134499>, <-0.423054,0.659793,0.621046>
 <19.732800,-67.942596,-34.873001>, <-0.419585,0.658153,0.625127>
}
   smooth_triangle{ <19.731501,-68.066597,-34.743099>, <-0.418273,0.658787,0.625338>
 <19.732800,-67.942596,-34.873001>, <-0.419585,0.658153,0.625127>
 <19.318199,-67.960701,-35.134499>, <-0.423054,0.659793,0.621046>
}
   smooth_triangle{ <19.318199,-67.960701,-35.134499>, <-0.423054,0.659793,0.621046>
 <19.312000,-68.083504,-35.007999>, <-0.421682,0.660207,0.621539>
 <19.731501,-68.066597,-34.743099>, <-0.418273,0.658787,0.625338>
}
   smooth_triangle{ <19.318199,-67.960701,-35.134499>, <-0.423054,0.659793,0.621046>
 <19.320299,-67.918098,-35.178299>, <-0.423463,0.658505,0.622134>
 <19.178101,-67.925003,-35.268700>, <-0.398156,0.667795,0.628905>
}
   smooth_triangle{ <19.178101,-67.925003,-35.268700>, <-0.398156,0.667795,0.628905>
 <19.175100,-67.967499,-35.225399>, <-0.383737,0.672009,0.633364>
 <19.318199,-67.960701,-35.134499>, <-0.423054,0.659793,0.621046>
}
   smooth_triangle{ <19.312000,-68.083504,-35.007999>, <-0.421682,0.660207,0.621539>
 <19.318199,-67.960701,-35.134499>, <-0.423054,0.659793,0.621046>
 <19.175100,-67.967499,-35.225399>, <-0.383737,0.672009,0.633364>
}
   smooth_triangle{ <19.175100,-67.967499,-35.225399>, <-0.383737,0.672009,0.633364>
 <19.166800,-68.090103,-35.100201>, <-0.382753,0.672510,0.633427>
 <19.312000,-68.083504,-35.007999>, <-0.421682,0.660207,0.621539>
}
   smooth_triangle{ <19.729099,-68.264198,-34.536701>, <-0.416572,0.659087,0.626157>
 <19.731501,-68.066597,-34.743099>, <-0.418273,0.658787,0.625338>
 <19.312000,-68.083504,-35.007999>, <-0.421682,0.660207,0.621539>
}
   smooth_triangle{ <19.312000,-68.083504,-35.007999>, <-0.421682,0.660207,0.621539>
 <19.302299,-68.279198,-34.806702>, <-0.419159,0.660849,0.622562>
 <19.729099,-68.264198,-34.536701>, <-0.416572,0.659087,0.626157>
}
   smooth_triangle{ <19.725599,-68.527496,-34.261799>, <-0.413641,0.660168,0.626960>
 <19.729099,-68.264198,-34.536701>, <-0.416572,0.659087,0.626157>
 <19.302299,-68.279198,-34.806702>, <-0.419159,0.660849,0.622562>
}
   smooth_triangle{ <19.302299,-68.279198,-34.806702>, <-0.419159,0.660849,0.622562>
 <19.289600,-68.540100,-34.538101>, <-0.415525,0.661908,0.623872>
 <19.725599,-68.527496,-34.261799>, <-0.413641,0.660168,0.626960>
}
   smooth_triangle{ <19.302299,-68.279198,-34.806702>, <-0.419159,0.660849,0.622562>
 <19.312000,-68.083504,-35.007999>, <-0.421682,0.660207,0.621539>
 <19.166800,-68.090103,-35.100201>, <-0.382753,0.672510,0.633427>
}
   smooth_triangle{ <19.166800,-68.090103,-35.100201>, <-0.382753,0.672510,0.633427>
 <19.153700,-68.285202,-34.900799>, <-0.380983,0.672831,0.634154>
 <19.302299,-68.279198,-34.806702>, <-0.419159,0.660849,0.622562>
}
   smooth_triangle{ <19.289600,-68.540100,-34.538101>, <-0.415525,0.661908,0.623872>
 <19.302299,-68.279198,-34.806702>, <-0.419159,0.660849,0.622562>
 <19.153700,-68.285202,-34.900799>, <-0.380983,0.672831,0.634154>
}
   smooth_triangle{ <19.153700,-68.285202,-34.900799>, <-0.380983,0.672831,0.634154>
 <19.136700,-68.545601,-34.634701>, <-0.379366,0.673227,0.634703>
 <19.289600,-68.540100,-34.538101>, <-0.415525,0.661908,0.623872>
}
   smooth_triangle{ <21.325800,-69.225601,-32.496899>, <-0.404929,0.657954,0.634924>
 <21.310400,-68.502701,-33.254799>, <-0.407838,0.656545,0.634521>
 <20.410400,-68.513199,-33.827000>, <-0.411132,0.658104,0.630769>
}
   smooth_triangle{ <20.410400,-68.513199,-33.827000>, <-0.411132,0.658104,0.630769>
 <20.419800,-69.217300,-33.086201>, <-0.407000,0.659723,0.631757>
 <21.325800,-69.225601,-32.496899>, <-0.404929,0.657954,0.634924>
}
   smooth_triangle{ <20.419800,-69.217300,-33.086201>, <-0.407000,0.659723,0.631757>
 <20.410400,-68.513199,-33.827000>, <-0.411132,0.658104,0.630769>
 <19.725599,-68.527496,-34.261799>, <-0.413641,0.660168,0.626960>
}
   smooth_triangle{ <19.725599,-68.527496,-34.261799>, <-0.413641,0.660168,0.626960>
 <19.714399,-69.220398,-33.539200>, <-0.408497,0.661842,0.628565>
 <20.419800,-69.217300,-33.086201>, <-0.407000,0.659723,0.631757>
}
   smooth_triangle{ <21.332899,-70.117599,-31.567600>, <-0.400732,0.660059,0.635402>
 <21.325800,-69.225601,-32.496899>, <-0.404929,0.657954,0.634924>
 <20.419800,-69.217300,-33.086201>, <-0.407000,0.659723,0.631757>
}
   smooth_triangle{ <20.419800,-69.217300,-33.086201>, <-0.407000,0.659723,0.631757>
 <20.423100,-70.091797,-32.170799>, <-0.402174,0.661674,0.632807>
 <21.332899,-70.117599,-31.567600>, <-0.400732,0.660059,0.635402>
}
   smooth_triangle{ <20.423100,-70.091797,-32.170799>, <-0.402174,0.661674,0.632807>
 <20.419800,-69.217300,-33.086201>, <-0.407000,0.659723,0.631757>
 <19.714399,-69.220398,-33.539200>, <-0.408497,0.661842,0.628565>
}
   smooth_triangle{ <19.714399,-69.220398,-33.539200>, <-0.408497,0.661842,0.628565>
 <19.697100,-70.084297,-32.640800>, <-0.402670,0.663687,0.630378>
 <20.423100,-70.091797,-32.170799>, <-0.402174,0.661674,0.632807>
}
   smooth_triangle{ <19.714399,-69.220398,-33.539200>, <-0.408497,0.661842,0.628565>
 <19.725599,-68.527496,-34.261799>, <-0.413641,0.660168,0.626960>
 <19.289600,-68.540100,-34.538101>, <-0.415525,0.661908,0.623872>
}
   smooth_triangle{ <19.289600,-68.540100,-34.538101>, <-0.415525,0.661908,0.623872>
 <19.256500,-69.227798,-33.830200>, <-0.409516,0.663484,0.626167>
 <19.714399,-69.220398,-33.539200>, <-0.408497,0.661842,0.628565>
}
   smooth_triangle{ <19.256500,-69.227798,-33.830200>, <-0.409516,0.663484,0.626167>
 <19.289600,-68.540100,-34.538101>, <-0.415525,0.661908,0.623872>
 <19.213100,-68.542801,-34.586399>, <-0.414715,0.662699,0.623571>
}
   smooth_triangle{ <19.213100,-68.542801,-34.586399>, <-0.414715,0.662699,0.623571>
 <19.135201,-69.230598,-33.906700>, <-0.410466,0.664037,0.624958>
 <19.256500,-69.227798,-33.830200>, <-0.409516,0.663484,0.626167>
}
   smooth_triangle{ <19.135201,-69.230598,-33.906700>, <-0.410466,0.664037,0.624958>
 <19.213100,-68.542801,-34.586399>, <-0.414715,0.662699,0.623571>
 <19.136700,-68.545601,-34.634701>, <-0.379366,0.673227,0.634703>
}
   smooth_triangle{ <19.136700,-68.545601,-34.634701>, <-0.379366,0.673227,0.634703>
 <19.093500,-69.231796,-33.932899>, <-0.376942,0.673673,0.635673>
 <19.135201,-69.230598,-33.906700>, <-0.410466,0.664037,0.624958>
}
   smooth_triangle{ <19.697100,-70.084297,-32.640800>, <-0.402670,0.663687,0.630378>
 <19.714399,-69.220398,-33.539200>, <-0.408497,0.661842,0.628565>
 <19.256500,-69.227798,-33.830200>, <-0.409516,0.663484,0.626167>
}
   smooth_triangle{ <19.256500,-69.227798,-33.830200>, <-0.409516,0.663484,0.626167>
 <19.216600,-70.086304,-32.946098>, <-0.403004,0.665248,0.628516>
 <19.697100,-70.084297,-32.640800>, <-0.402670,0.663687,0.630378>
}
   smooth_triangle{ <19.216600,-70.086304,-32.946098>, <-0.403004,0.665248,0.628516>
 <19.256500,-69.227798,-33.830200>, <-0.409516,0.663484,0.626167>
 <19.135201,-69.230598,-33.906700>, <-0.410466,0.664037,0.624958>
}
   smooth_triangle{ <19.135201,-69.230598,-33.906700>, <-0.410466,0.664037,0.624958>
 <19.087400,-70.088097,-33.027100>, <-0.403192,0.665866,0.627741>
 <19.216600,-70.086304,-32.946098>, <-0.403004,0.665248,0.628516>
}
   smooth_triangle{ <19.087400,-70.088097,-33.027100>, <-0.403192,0.665866,0.627741>
 <19.135201,-69.230598,-33.906700>, <-0.410466,0.664037,0.624958>
 <19.093500,-69.231796,-33.932899>, <-0.376942,0.673673,0.635673>
}
   smooth_triangle{ <19.093500,-69.231796,-33.932899>, <-0.376942,0.673673,0.635673>
 <19.042700,-70.088898,-33.054901>, <-0.373787,0.674161,0.637017>
 <19.087400,-70.088097,-33.027100>, <-0.403192,0.665866,0.627741>
}
   smooth_triangle{ <21.310200,-71.125000,-30.534201>, <-0.399286,0.661489,0.634825>
 <21.332899,-70.117599,-31.567600>, <-0.400732,0.660059,0.635402>
 <20.423100,-70.091797,-32.170799>, <-0.402174,0.661674,0.632807>
}
   smooth_triangle{ <20.423100,-70.091797,-32.170799>, <-0.402174,0.661674,0.632807>
 <20.408800,-71.078796,-31.147301>, <-0.397752,0.663250,0.633950>
 <21.310200,-71.125000,-30.534201>, <-0.399286,0.661489,0.634825>
}
   smooth_triangle{ <20.408800,-71.078796,-31.147301>, <-0.397752,0.663250,0.633950>
 <20.423100,-70.091797,-32.170799>, <-0.402174,0.661674,0.632807>
 <19.697100,-70.084297,-32.640800>, <-0.402670,0.663687,0.630378>
}
   smooth_triangle{ <19.697100,-70.084297,-32.640800>, <-0.402670,0.663687,0.630378>
 <19.671200,-71.059402,-31.630600>, <-0.397532,0.665147,0.632098>
 <20.408800,-71.078796,-31.147301>, <-0.397752,0.663250,0.633950>
}
   smooth_triangle{ <19.671200,-71.059402,-31.630600>, <-0.397532,0.665147,0.632098>
 <19.697100,-70.084297,-32.640800>, <-0.402670,0.663687,0.630378>
 <19.216600,-70.086304,-32.946098>, <-0.403004,0.665248,0.628516>
}
   smooth_triangle{ <19.216600,-70.086304,-32.946098>, <-0.403004,0.665248,0.628516>
 <19.173000,-71.056000,-31.947701>, <-0.397350,0.666554,0.630729>
 <19.671200,-71.059402,-31.630600>, <-0.397532,0.665147,0.632098>
}
   smooth_triangle{ <19.173000,-71.056000,-31.947701>, <-0.397350,0.666554,0.630729>
 <19.216600,-70.086304,-32.946098>, <-0.403004,0.665248,0.628516>
 <19.087400,-70.088097,-33.027100>, <-0.403192,0.665866,0.627741>
}
   smooth_triangle{ <19.087400,-70.088097,-33.027100>, <-0.403192,0.665866,0.627741>
 <19.037500,-71.056702,-32.032299>, <-0.397287,0.667113,0.630177>
 <19.173000,-71.056000,-31.947701>, <-0.397350,0.666554,0.630729>
}
   smooth_triangle{ <19.037500,-71.056702,-32.032299>, <-0.397287,0.667113,0.630177>
 <19.087400,-70.088097,-33.027100>, <-0.403192,0.665866,0.627741>
 <19.042700,-70.088898,-33.054901>, <-0.373787,0.674161,0.637017>
}
   smooth_triangle{ <19.042700,-70.088898,-33.054901>, <-0.373787,0.674161,0.637017>
 <18.990200,-71.057297,-32.061501>, <-0.372431,0.674110,0.637864>
 <19.037500,-71.056702,-32.032299>, <-0.397287,0.667113,0.630177>
}
   smooth_triangle{ <21.287600,-72.132401,-29.500799>, <-0.394206,0.663171,0.636243>
 <21.310200,-71.125000,-30.534201>, <-0.399286,0.661489,0.634825>
 <20.408800,-71.078796,-31.147301>, <-0.397752,0.663250,0.633950>
}
   smooth_triangle{ <20.408800,-71.078796,-31.147301>, <-0.397752,0.663250,0.633950>
 <20.387600,-72.094704,-30.097601>, <-0.393681,0.664926,0.634735>
 <21.287600,-72.132401,-29.500799>, <-0.394206,0.663171,0.636243>
}
   smooth_triangle{ <20.387600,-72.094704,-30.097601>, <-0.393681,0.664926,0.634735>
 <20.408800,-71.078796,-31.147301>, <-0.397752,0.663250,0.633950>
 <19.671200,-71.059402,-31.630600>, <-0.397532,0.665147,0.632098>
}
   smooth_triangle{ <19.671200,-71.059402,-31.630600>, <-0.397532,0.665147,0.632098>
 <19.640400,-72.079002,-30.577299>, <-0.393234,0.666395,0.633470>
 <20.387600,-72.094704,-30.097601>, <-0.393681,0.664926,0.634735>
}
   smooth_triangle{ <19.640400,-72.079002,-30.577299>, <-0.393234,0.666395,0.633470>
 <19.671200,-71.059402,-31.630600>, <-0.397532,0.665147,0.632098>
 <19.173000,-71.056000,-31.947701>, <-0.397350,0.666554,0.630729>
}
   smooth_triangle{ <19.173000,-71.056000,-31.947701>, <-0.397350,0.666554,0.630729>
 <19.130301,-72.075996,-30.896799>, <-0.392917,0.667428,0.632579>
 <19.640400,-72.079002,-30.577299>, <-0.393234,0.666395,0.633470>
}
   smooth_triangle{ <19.130301,-72.075996,-30.896799>, <-0.392917,0.667428,0.632579>
 <19.173000,-71.056000,-31.947701>, <-0.397350,0.666554,0.630729>
 <19.037500,-71.056702,-32.032299>, <-0.397287,0.667113,0.630177>
}
   smooth_triangle{ <19.037500,-71.056702,-32.032299>, <-0.397287,0.667113,0.630177>
 <18.990400,-72.076599,-30.983000>, <-0.392949,0.667765,0.632203>
 <19.130301,-72.075996,-30.896799>, <-0.392917,0.667428,0.632579>
}
   smooth_triangle{ <18.990400,-72.076599,-30.983000>, <-0.392949,0.667765,0.632203>
 <19.037500,-71.056702,-32.032299>, <-0.397287,0.667113,0.630177>
 <18.990200,-71.057297,-32.061501>, <-0.372431,0.674110,0.637864>
}
   smooth_triangle{ <18.990200,-71.057297,-32.061501>, <-0.372431,0.674110,0.637864>
 <18.941401,-72.077103,-31.012899>, <-0.371606,0.673760,0.638715>
 <18.990400,-72.076599,-30.983000>, <-0.392949,0.667765,0.632203>
}
   smooth_triangle{ <21.218399,-73.116501,-28.515600>, <-0.391190,0.665748,0.635413>
 <21.287600,-72.132401,-29.500799>, <-0.394206,0.663171,0.636243>
 <20.387600,-72.094704,-30.097601>, <-0.393681,0.664926,0.634735>
}
   smooth_triangle{ <20.387600,-72.094704,-30.097601>, <-0.393681,0.664926,0.634735>
 <20.337400,-73.094704,-29.080400>, <-0.390960,0.666475,0.634792>
 <21.218399,-73.116501,-28.515600>, <-0.391190,0.665748,0.635413>
}
   smooth_triangle{ <20.337400,-73.094704,-29.080400>, <-0.390960,0.666475,0.634792>
 <20.387600,-72.094704,-30.097601>, <-0.393681,0.664926,0.634735>
 <19.640400,-72.079002,-30.577299>, <-0.393234,0.666395,0.633470>
}
   smooth_triangle{ <19.640400,-72.079002,-30.577299>, <-0.393234,0.666395,0.633470>
 <19.598900,-73.086998,-29.542801>, <-0.390692,0.667102,0.634298>
 <20.337400,-73.094704,-29.080400>, <-0.390960,0.666475,0.634792>
}
   smooth_triangle{ <21.106800,-73.992798,-27.663900>, <-0.391131,0.665389,0.635826>
 <21.218399,-73.116501,-28.515600>, <-0.391190,0.665748,0.635413>
 <20.337400,-73.094704,-29.080400>, <-0.390960,0.666475,0.634792>
}
   smooth_triangle{ <20.337400,-73.094704,-29.080400>, <-0.390960,0.666475,0.634792>
 <20.257900,-74.007896,-28.169901>, <-0.391761,0.664340,0.636534>
 <21.106800,-73.992798,-27.663900>, <-0.391131,0.665389,0.635826>
}
   smooth_triangle{ <20.257900,-74.007896,-28.169901>, <-0.391761,0.664340,0.636534>
 <20.337400,-73.094704,-29.080400>, <-0.390960,0.666475,0.634792>
 <19.598900,-73.086998,-29.542801>, <-0.390692,0.667102,0.634298>
}
   smooth_triangle{ <19.598900,-73.086998,-29.542801>, <-0.390692,0.667102,0.634298>
 <19.547501,-74.020500,-28.593201>, <-0.391929,0.663807,0.636986>
 <20.257900,-74.007896,-28.169901>, <-0.391761,0.664340,0.636534>
}
   smooth_triangle{ <19.598900,-73.086998,-29.542801>, <-0.390692,0.667102,0.634298>
 <19.640400,-72.079002,-30.577299>, <-0.393234,0.666395,0.633470>
 <19.130301,-72.075996,-30.896799>, <-0.392917,0.667428,0.632579>
}
   smooth_triangle{ <19.130301,-72.075996,-30.896799>, <-0.392917,0.667428,0.632579>
 <19.091200,-73.087196,-29.855000>, <-0.390577,0.667477,0.633975>
 <19.598900,-73.086998,-29.542801>, <-0.390692,0.667102,0.634298>
}
   smooth_triangle{ <19.091200,-73.087196,-29.855000>, <-0.390577,0.667477,0.633975>
 <19.130301,-72.075996,-30.896799>, <-0.392917,0.667428,0.632579>
 <18.990400,-72.076599,-30.983000>, <-0.392949,0.667765,0.632203>
}
   smooth_triangle{ <18.990400,-72.076599,-30.983000>, <-0.392949,0.667765,0.632203>
 <18.951300,-73.088203,-29.940001>, <-0.390628,0.667597,0.633817>
 <19.091200,-73.087196,-29.855000>, <-0.390577,0.667477,0.633975>
}
   smooth_triangle{ <18.951300,-73.088203,-29.940001>, <-0.390628,0.667597,0.633817>
 <18.990400,-72.076599,-30.983000>, <-0.392949,0.667765,0.632203>
 <18.941401,-72.077103,-31.012899>, <-0.371606,0.673760,0.638715>
}
   smooth_triangle{ <18.941401,-72.077103,-31.012899>, <-0.371606,0.673760,0.638715>
 <18.902300,-73.088699,-29.969700>, <-0.372086,0.672831,0.639414>
 <18.951300,-73.088203,-29.940001>, <-0.390628,0.667597,0.633817>
}
   smooth_triangle{ <19.547501,-74.020500,-28.593201>, <-0.391929,0.663807,0.636986>
 <19.598900,-73.086998,-29.542801>, <-0.390692,0.667102,0.634298>
 <19.091200,-73.087196,-29.855000>, <-0.390577,0.667477,0.633975>
}
   smooth_triangle{ <19.091200,-73.087196,-29.855000>, <-0.390577,0.667477,0.633975>
 <19.059601,-74.029198,-28.884001>, <-0.393241,0.662546,0.637491>
 <19.547501,-74.020500,-28.593201>, <-0.391929,0.663807,0.636986>
}
   smooth_triangle{ <19.059601,-74.029198,-28.884001>, <-0.393241,0.662546,0.637491>
 <19.091200,-73.087196,-29.855000>, <-0.390577,0.667477,0.633975>
 <18.951300,-73.088203,-29.940001>, <-0.390628,0.667597,0.633817>
}
   smooth_triangle{ <18.951300,-73.088203,-29.940001>, <-0.390628,0.667597,0.633817>
 <18.925301,-74.031502,-28.963900>, <-0.394360,0.661761,0.637615>
 <19.059601,-74.029198,-28.884001>, <-0.393241,0.662546,0.637491>
}
   smooth_triangle{ <18.925301,-74.031502,-28.963900>, <-0.394360,0.661761,0.637615>
 <18.951300,-73.088203,-29.940001>, <-0.390628,0.667597,0.633817>
 <18.902300,-73.088699,-29.969700>, <-0.372086,0.672831,0.639414>
}
   smooth_triangle{ <18.902300,-73.088699,-29.969700>, <-0.372086,0.672831,0.639414>
 <18.878300,-74.032402,-28.992001>, <-0.374939,0.669874,0.640850>
 <18.925301,-74.031502,-28.963900>, <-0.394360,0.661761,0.637615>
}
   smooth_triangle{ <19.175100,-67.967499,-35.225399>, <0.342400,-0.682132,-0.646110>
 <19.178101,-67.925003,-35.268700>, <0.342569,-0.682282,-0.645863>
 <19.326200,-67.927696,-35.187302>, <0.343564,-0.681542,-0.646114>
}
   smooth_triangle{ <19.175100,-67.967499,-35.225399>, <-0.383737,0.672009,0.633364>
 <19.326200,-67.927696,-35.187302>, <-0.343564,0.681542,0.646114>
 <19.178101,-67.925003,-35.268700>, <-0.398156,0.667795,0.628905>
}
   smooth_triangle{ <19.326200,-67.927696,-35.187302>, <0.343564,-0.681542,-0.646114>
 <19.323000,-67.970299,-35.144100>, <0.343784,-0.682225,-0.645277>
 <19.175100,-67.967499,-35.225399>, <0.342400,-0.682132,-0.646110>
}
   smooth_triangle{ <19.326200,-67.927696,-35.187302>, <-0.343564,0.681542,0.646114>
 <19.175100,-67.967499,-35.225399>, <-0.383737,0.672009,0.633364>
 <19.323000,-67.970299,-35.144100>, <-0.343784,0.682225,0.645277>
}
   smooth_triangle{ <19.166800,-68.090103,-35.100201>, <0.342400,-0.682745,-0.645463>
 <19.175100,-67.967499,-35.225399>, <0.342400,-0.682132,-0.646110>
 <19.323000,-67.970299,-35.144100>, <0.343784,-0.682225,-0.645277>
}
   smooth_triangle{ <19.166800,-68.090103,-35.100201>, <-0.382753,0.672510,0.633427>
 <19.323000,-67.970299,-35.144100>, <-0.343784,0.682225,0.645277>
 <19.175100,-67.967499,-35.225399>, <-0.383737,0.672009,0.633364>
}
   smooth_triangle{ <19.323000,-67.970299,-35.144100>, <0.343784,-0.682225,-0.645277>
 <19.313801,-68.092903,-35.019199>, <0.343870,-0.682479,-0.644962>
 <19.166800,-68.090103,-35.100201>, <0.342400,-0.682745,-0.645463>
}
   smooth_triangle{ <19.323000,-67.970299,-35.144100>, <-0.343784,0.682225,0.645277>
 <19.166800,-68.090103,-35.100201>, <-0.382753,0.672510,0.633427>
 <19.313801,-68.092903,-35.019199>, <-0.343870,0.682479,0.644962>
}
   smooth_triangle{ <19.323000,-67.970299,-35.144100>, <0.343784,-0.682225,-0.645277>
 <19.326200,-67.927696,-35.187302>, <0.343564,-0.681542,-0.646114>
 <19.758301,-67.934898,-34.948502>, <0.346055,-0.682114,-0.644179>
}
   smooth_triangle{ <19.323000,-67.970299,-35.144100>, <-0.343784,0.682225,0.645277>
 <19.758301,-67.934898,-34.948502>, <-0.346055,0.682114,0.644179>
 <19.326200,-67.927696,-35.187302>, <-0.343564,0.681542,0.646114>
}
   smooth_triangle{ <19.758301,-67.934898,-34.948502>, <0.346055,-0.682114,-0.644179>
 <19.754200,-67.977501,-34.905499>, <0.346414,-0.682610,-0.643460>
 <19.323000,-67.970299,-35.144100>, <0.343784,-0.682225,-0.645277>
}
   smooth_triangle{ <19.758301,-67.934898,-34.948502>, <-0.346055,0.682114,0.644179>
 <19.323000,-67.970299,-35.144100>, <-0.343784,0.682225,0.645277>
 <19.754200,-67.977501,-34.905499>, <-0.346414,0.682610,0.643460>
}
   smooth_triangle{ <19.313801,-68.092903,-35.019199>, <0.343870,-0.682479,-0.644962>
 <19.323000,-67.970299,-35.144100>, <0.343784,-0.682225,-0.645277>
 <19.754200,-67.977501,-34.905499>, <0.346414,-0.682610,-0.643460>
}
   smooth_triangle{ <19.313801,-68.092903,-35.019199>, <-0.343870,0.682479,0.644962>
 <19.754200,-67.977501,-34.905499>, <-0.346414,0.682610,0.643460>
 <19.323000,-67.970299,-35.144100>, <-0.343784,0.682225,0.645277>
}
   smooth_triangle{ <19.754200,-67.977501,-34.905499>, <0.346414,-0.682610,-0.643460>
 <19.742300,-68.100601,-34.781399>, <0.346791,-0.682292,-0.643595>
 <19.313801,-68.092903,-35.019199>, <0.343870,-0.682479,-0.644962>
}
   smooth_triangle{ <19.754200,-67.977501,-34.905499>, <-0.346414,0.682610,0.643460>
 <19.313801,-68.092903,-35.019199>, <-0.343870,0.682479,0.644962>
 <19.742300,-68.100601,-34.781399>, <-0.346791,0.682292,0.643595>
}
   smooth_triangle{ <19.153700,-68.285202,-34.900799>, <0.342308,-0.682527,-0.645742>
 <19.166800,-68.090103,-35.100201>, <0.342400,-0.682745,-0.645463>
 <19.313801,-68.092903,-35.019199>, <0.343870,-0.682479,-0.644962>
}
   smooth_triangle{ <19.153700,-68.285202,-34.900799>, <-0.380983,0.672831,0.634154>
 <19.313801,-68.092903,-35.019199>, <-0.343870,0.682479,0.644962>
 <19.166800,-68.090103,-35.100201>, <-0.382753,0.672510,0.633427>
}
   smooth_triangle{ <19.313801,-68.092903,-35.019199>, <0.343870,-0.682479,-0.644962>
 <19.299299,-68.288300,-34.820400>, <0.344176,-0.682260,-0.645030>
 <19.153700,-68.285202,-34.900799>, <0.342308,-0.682527,-0.645742>
}
   smooth_triangle{ <19.313801,-68.092903,-35.019199>, <-0.343870,0.682479,0.644962>
 <19.153700,-68.285202,-34.900799>, <-0.380983,0.672831,0.634154>
 <19.299299,-68.288300,-34.820400>, <-0.344176,0.682260,0.645030>
}
   smooth_triangle{ <19.136700,-68.545601,-34.634701>, <0.342918,-0.682325,-0.645631>
 <19.153700,-68.285202,-34.900799>, <0.342308,-0.682527,-0.645742>
 <19.299299,-68.288300,-34.820400>, <0.344176,-0.682260,-0.645030>
}
   smooth_triangle{ <19.136700,-68.545601,-34.634701>, <-0.379366,0.673227,0.634703>
 <19.299299,-68.288300,-34.820400>, <-0.344176,0.682260,0.645030>
 <19.153700,-68.285202,-34.900799>, <-0.380983,0.672831,0.634154>
}
   smooth_triangle{ <19.299299,-68.288300,-34.820400>, <0.344176,-0.682260,-0.645030>
 <19.280399,-68.548698,-34.555000>, <0.345262,-0.681991,-0.644735>
 <19.136700,-68.545601,-34.634701>, <0.342918,-0.682325,-0.645631>
}
   smooth_triangle{ <19.299299,-68.288300,-34.820400>, <-0.344176,0.682260,0.645030>
 <19.136700,-68.545601,-34.634701>, <-0.379366,0.673227,0.634703>
 <19.280399,-68.548698,-34.555000>, <-0.345262,0.681991,0.644735>
}
   smooth_triangle{ <19.299299,-68.288300,-34.820400>, <0.344176,-0.682260,-0.645030>
 <19.313801,-68.092903,-35.019199>, <0.343870,-0.682479,-0.644962>
 <19.742300,-68.100601,-34.781399>, <0.346791,-0.682292,-0.643595>
}
   smooth_triangle{ <19.299299,-68.288300,-34.820400>, <-0.344176,0.682260,0.645030>
 <19.742300,-68.100601,-34.781399>, <-0.346791,0.682292,0.643595>
 <19.313801,-68.092903,-35.019199>, <-0.343870,0.682479,0.644962>
}
   smooth_triangle{ <19.742300,-68.100601,-34.781399>, <0.346791,-0.682292,-0.643595>
 <19.723600,-68.296600,-34.583698>, <0.347262,-0.682143,-0.643498>
 <19.299299,-68.288300,-34.820400>, <0.344176,-0.682260,-0.645030>
}
   smooth_triangle{ <19.742300,-68.100601,-34.781399>, <-0.346791,0.682292,0.643595>
 <19.299299,-68.288300,-34.820400>, <-0.344176,0.682260,0.645030>
 <19.723600,-68.296600,-34.583698>, <-0.347262,0.682143,0.643498>
}
   smooth_triangle{ <19.280399,-68.548698,-34.555000>, <0.345262,-0.681991,-0.644735>
 <19.299299,-68.288300,-34.820400>, <0.344176,-0.682260,-0.645030>
 <19.723600,-68.296600,-34.583698>, <0.347262,-0.682143,-0.643498>
}
   smooth_triangle{ <19.280399,-68.548698,-34.555000>, <-0.345262,0.681991,0.644735>
 <19.723600,-68.296600,-34.583698>, <-0.347262,0.682143,0.643498>
 <19.299299,-68.288300,-34.820400>, <-0.344176,0.682260,0.645030>
}
   smooth_triangle{ <19.723600,-68.296600,-34.583698>, <0.347262,-0.682143,-0.643498>
 <19.698999,-68.557999,-34.320000>, <0.347899,-0.681812,-0.643506>
 <19.280399,-68.548698,-34.555000>, <0.345262,-0.681991,-0.644735>
}
   smooth_triangle{ <19.723600,-68.296600,-34.583698>, <-0.347262,0.682143,0.643498>
 <19.280399,-68.548698,-34.555000>, <-0.345262,0.681991,0.644735>
 <19.698999,-68.557999,-34.320000>, <-0.347899,0.681812,0.643506>
}
   smooth_triangle{ <19.754200,-67.977501,-34.905499>, <0.346414,-0.682610,-0.643460>
 <19.758301,-67.934898,-34.948502>, <0.346055,-0.682114,-0.644179>
 <20.456200,-67.944504,-34.560799>, <0.348819,-0.682623,-0.642145>
}
   smooth_triangle{ <19.754200,-67.977501,-34.905499>, <-0.346414,0.682610,0.643460>
 <20.456200,-67.944504,-34.560799>, <-0.348819,0.682623,0.642145>
 <19.758301,-67.934898,-34.948502>, <-0.346055,0.682114,0.644179>
}
   smooth_triangle{ <20.456200,-67.944504,-34.560799>, <0.348819,-0.682623,-0.642145>
 <20.450399,-67.987701,-34.518002>, <0.349555,-0.682287,-0.642103>
 <19.754200,-67.977501,-34.905499>, <0.346414,-0.682610,-0.643460>
}
   smooth_triangle{ <20.456200,-67.944504,-34.560799>, <-0.348819,0.682623,0.642145>
 <19.754200,-67.977501,-34.905499>, <-0.346414,0.682610,0.643460>
 <20.450399,-67.987701,-34.518002>, <-0.349555,0.682287,0.642103>
}
   smooth_triangle{ <19.742300,-68.100601,-34.781399>, <0.346791,-0.682292,-0.643595>
 <19.754200,-67.977501,-34.905499>, <0.346414,-0.682610,-0.643460>
 <20.450399,-67.987701,-34.518002>, <0.349555,-0.682287,-0.642103>
}
   smooth_triangle{ <19.742300,-68.100601,-34.781399>, <-0.346791,0.682292,0.643595>
 <20.450399,-67.987701,-34.518002>, <-0.349555,0.682287,0.642103>
 <19.754200,-67.977501,-34.905499>, <-0.346414,0.682610,0.643460>
}
   smooth_triangle{ <20.450399,-67.987701,-34.518002>, <0.349555,-0.682287,-0.642103>
 <20.433901,-68.112198,-34.394600>, <0.349641,-0.682471,-0.641861>
 <19.742300,-68.100601,-34.781399>, <0.346791,-0.682292,-0.643595>
}
   smooth_triangle{ <20.450399,-67.987701,-34.518002>, <-0.349555,0.682287,0.642103>
 <19.742300,-68.100601,-34.781399>, <-0.346791,0.682292,0.643595>
 <20.433901,-68.112198,-34.394600>, <-0.349641,0.682471,0.641861>
}
   smooth_triangle{ <19.723600,-68.296600,-34.583698>, <0.347262,-0.682143,-0.643498>
 <19.742300,-68.100601,-34.781399>, <0.346791,-0.682292,-0.643595>
 <20.433901,-68.112198,-34.394600>, <0.349641,-0.682471,-0.641861>
}
   smooth_triangle{ <19.723600,-68.296600,-34.583698>, <-0.347262,0.682143,0.643498>
 <20.433901,-68.112198,-34.394600>, <-0.349641,0.682471,0.641861>
 <19.742300,-68.100601,-34.781399>, <-0.346791,0.682292,0.643595>
}
   smooth_triangle{ <20.433901,-68.112198,-34.394600>, <0.349641,-0.682471,-0.641861>
 <20.408100,-68.309998,-34.198399>, <0.350045,-0.682166,-0.641965>
 <19.723600,-68.296600,-34.583698>, <0.347262,-0.682143,-0.643498>
}
   smooth_triangle{ <20.433901,-68.112198,-34.394600>, <-0.349641,0.682471,0.641861>
 <19.723600,-68.296600,-34.583698>, <-0.347262,0.682143,0.643498>
 <20.408100,-68.309998,-34.198399>, <-0.350045,0.682166,0.641965>
}
   smooth_triangle{ <19.698999,-68.557999,-34.320000>, <0.347899,-0.681812,-0.643506>
 <19.723600,-68.296600,-34.583698>, <0.347262,-0.682143,-0.643498>
 <20.408100,-68.309998,-34.198399>, <0.350045,-0.682166,-0.641965>
}
   smooth_triangle{ <19.698999,-68.557999,-34.320000>, <-0.347899,0.681812,0.643506>
 <20.408100,-68.309998,-34.198399>, <-0.350045,0.682166,0.641965>
 <19.723600,-68.296600,-34.583698>, <-0.347262,0.682143,0.643498>
}
   smooth_triangle{ <20.408100,-68.309998,-34.198399>, <0.350045,-0.682166,-0.641965>
 <20.373899,-68.573799,-33.936798>, <0.350641,-0.681863,-0.641961>
 <19.698999,-68.557999,-34.320000>, <0.347899,-0.681812,-0.643506>
}
   smooth_triangle{ <20.408100,-68.309998,-34.198399>, <-0.350045,0.682166,0.641965>
 <19.698999,-68.557999,-34.320000>, <-0.347899,0.681812,0.643506>
 <20.373899,-68.573799,-33.936798>, <-0.350641,0.681863,0.641961>
}
   smooth_triangle{ <20.450399,-67.987701,-34.518002>, <0.349555,-0.682287,-0.642103>
 <20.456200,-67.944504,-34.560799>, <0.348819,-0.682623,-0.642145>
 <21.401100,-67.954903,-34.032200>, <0.352676,-0.681348,-0.641393>
}
   smooth_triangle{ <20.450399,-67.987701,-34.518002>, <-0.349555,0.682287,0.642103>
 <21.401100,-67.954903,-34.032200>, <-0.352676,0.681348,0.641393>
 <20.456200,-67.944504,-34.560799>, <-0.348819,0.682623,0.642145>
}
   smooth_triangle{ <21.401100,-67.954903,-34.032200>, <0.352676,-0.681348,-0.641393>
 <21.393101,-67.999100,-33.989700>, <0.352982,-0.681934,-0.640600>
 <20.450399,-67.987701,-34.518002>, <0.349555,-0.682287,-0.642103>
}
   smooth_triangle{ <21.401100,-67.954903,-34.032200>, <-0.352676,0.681348,0.641393>
 <20.450399,-67.987701,-34.518002>, <-0.349555,0.682287,0.642103>
 <21.393101,-67.999100,-33.989700>, <-0.352982,0.681934,0.640600>
}
   smooth_triangle{ <20.433901,-68.112198,-34.394600>, <0.349641,-0.682471,-0.641861>
 <20.450399,-67.987701,-34.518002>, <0.349555,-0.682287,-0.642103>
 <21.393101,-67.999100,-33.989700>, <0.352982,-0.681934,-0.640600>
}
   smooth_triangle{ <20.433901,-68.112198,-34.394600>, <-0.349641,0.682471,0.641861>
 <21.393101,-67.999100,-33.989700>, <-0.352982,0.681934,0.640600>
 <20.450399,-67.987701,-34.518002>, <-0.349555,0.682287,0.642103>
}
   smooth_triangle{ <21.393101,-67.999100,-33.989700>, <0.352982,-0.681934,-0.640600>
 <21.370199,-68.126099,-33.866798>, <0.352837,-0.682521,-0.640056>
 <20.433901,-68.112198,-34.394600>, <0.349641,-0.682471,-0.641861>
}
   smooth_triangle{ <21.393101,-67.999100,-33.989700>, <-0.352982,0.681934,0.640600>
 <20.433901,-68.112198,-34.394600>, <-0.349641,0.682471,0.641861>
 <21.370199,-68.126099,-33.866798>, <-0.352837,0.682521,0.640056>
}
   smooth_triangle{ <20.408100,-68.309998,-34.198399>, <0.350045,-0.682166,-0.641965>
 <20.433901,-68.112198,-34.394600>, <0.349641,-0.682471,-0.641861>
 <21.370199,-68.126099,-33.866798>, <0.352837,-0.682521,-0.640056>
}
   smooth_triangle{ <20.408100,-68.309998,-34.198399>, <-0.350045,0.682166,0.641965>
 <21.370199,-68.126099,-33.866798>, <-0.352837,0.682521,0.640056>
 <20.433901,-68.112198,-34.394600>, <-0.349641,0.682471,0.641861>
}
   smooth_triangle{ <21.370199,-68.126099,-33.866798>, <0.352837,-0.682521,-0.640056>
 <21.334000,-68.327904,-33.671700>, <0.353165,-0.682248,-0.640166>
 <20.408100,-68.309998,-34.198399>, <0.350045,-0.682166,-0.641965>
}
   smooth_triangle{ <21.370199,-68.126099,-33.866798>, <-0.352837,0.682521,0.640056>
 <20.408100,-68.309998,-34.198399>, <-0.350045,0.682166,0.641965>
 <21.334000,-68.327904,-33.671700>, <-0.353165,0.682248,0.640166>
}
   smooth_triangle{ <20.373899,-68.573799,-33.936798>, <0.350641,-0.681863,-0.641961>
 <20.408100,-68.309998,-34.198399>, <0.350045,-0.682166,-0.641965>
 <21.334000,-68.327904,-33.671700>, <0.353165,-0.682248,-0.640166>
}
   smooth_triangle{ <20.373899,-68.573799,-33.936798>, <-0.350641,0.681863,0.641961>
 <21.334000,-68.327904,-33.671700>, <-0.353165,0.682248,0.640166>
 <20.408100,-68.309998,-34.198399>, <-0.350045,0.682166,0.641965>
}
   smooth_triangle{ <21.334000,-68.327904,-33.671700>, <0.353165,-0.682248,-0.640166>
 <21.286301,-68.596199,-33.412102>, <0.353652,-0.681970,-0.640194>
 <20.373899,-68.573799,-33.936798>, <0.350641,-0.681863,-0.641961>
}
   smooth_triangle{ <21.334000,-68.327904,-33.671700>, <-0.353165,0.682248,0.640166>
 <20.373899,-68.573799,-33.936798>, <-0.350641,0.681863,0.641961>
 <21.286301,-68.596199,-33.412102>, <-0.353652,0.681970,0.640194>
}
   smooth_triangle{ <19.093500,-69.231796,-33.932899>, <0.345110,-0.681679,-0.645145>
 <19.136700,-68.545601,-34.634701>, <0.342918,-0.682325,-0.645631>
 <19.280399,-68.548698,-34.555000>, <0.345262,-0.681991,-0.644735>
}
   smooth_triangle{ <19.093500,-69.231796,-33.932899>, <-0.376942,0.673673,0.635673>
 <19.280399,-68.548698,-34.555000>, <-0.345262,0.681991,0.644735>
 <19.136700,-68.545601,-34.634701>, <-0.379366,0.673227,0.634703>
}
   smooth_triangle{ <19.280399,-68.548698,-34.555000>, <0.345262,-0.681991,-0.644735>
 <19.232201,-69.235100,-33.855000>, <0.346814,-0.681402,-0.644524>
 <19.093500,-69.231796,-33.932899>, <0.345110,-0.681679,-0.645145>
}
   smooth_triangle{ <19.280399,-68.548698,-34.555000>, <-0.345262,0.681991,0.644735>
 <19.093500,-69.231796,-33.932899>, <-0.376942,0.673673,0.635673>
 <19.232201,-69.235100,-33.855000>, <-0.346814,0.681402,0.644524>
}
   smooth_triangle{ <19.232201,-69.235100,-33.855000>, <0.346814,-0.681402,-0.644524>
 <19.280399,-68.548698,-34.555000>, <0.345262,-0.681991,-0.644735>
 <19.698999,-68.557999,-34.320000>, <0.347899,-0.681812,-0.643506>
}
   smooth_triangle{ <19.232201,-69.235100,-33.855000>, <-0.346814,0.681402,0.644524>
 <19.698999,-68.557999,-34.320000>, <-0.347899,0.681812,0.643506>
 <19.280399,-68.548698,-34.555000>, <-0.345262,0.681991,0.644735>
}
   smooth_triangle{ <19.698999,-68.557999,-34.320000>, <0.347899,-0.681812,-0.643506>
 <19.636000,-69.246300,-33.625099>, <0.349204,-0.681273,-0.643369>
 <19.232201,-69.235100,-33.855000>, <0.346814,-0.681402,-0.644524>
}
   smooth_triangle{ <19.698999,-68.557999,-34.320000>, <-0.347899,0.681812,0.643506>
 <19.232201,-69.235100,-33.855000>, <-0.346814,0.681402,0.644524>
 <19.636000,-69.246300,-33.625099>, <-0.349204,0.681273,0.643369>
}
   smooth_triangle{ <19.042700,-70.088898,-33.054901>, <0.346579,-0.681053,-0.645019>
 <19.093500,-69.231796,-33.932899>, <0.345110,-0.681679,-0.645145>
 <19.232201,-69.235100,-33.855000>, <0.346814,-0.681402,-0.644524>
}
   smooth_triangle{ <19.042700,-70.088898,-33.054901>, <-0.373787,0.674161,0.637017>
 <19.232201,-69.235100,-33.855000>, <-0.346814,0.681402,0.644524>
 <19.093500,-69.231796,-33.932899>, <-0.376942,0.673673,0.635673>
}
   smooth_triangle{ <19.232201,-69.235100,-33.855000>, <0.346814,-0.681402,-0.644524>
 <19.175301,-70.092400,-32.979900>, <0.348512,-0.680696,-0.644355>
 <19.042700,-70.088898,-33.054901>, <0.346579,-0.681053,-0.645019>
}
   smooth_triangle{ <19.232201,-69.235100,-33.855000>, <-0.346814,0.681402,0.644524>
 <19.042700,-70.088898,-33.054901>, <-0.373787,0.674161,0.637017>
 <19.175301,-70.092400,-32.979900>, <-0.348512,0.680696,0.644355>
}
   smooth_triangle{ <19.175301,-70.092400,-32.979900>, <0.348512,-0.680696,-0.644355>
 <19.232201,-69.235100,-33.855000>, <0.346814,-0.681402,-0.644524>
 <19.636000,-69.246300,-33.625099>, <0.349204,-0.681273,-0.643369>
}
   smooth_triangle{ <19.175301,-70.092400,-32.979900>, <-0.348512,0.680696,0.644355>
 <19.636000,-69.246300,-33.625099>, <-0.349204,0.681273,0.643369>
 <19.232201,-69.235100,-33.855000>, <-0.346814,0.681402,0.644524>
}
   smooth_triangle{ <19.636000,-69.246300,-33.625099>, <0.349204,-0.681273,-0.643369>
 <19.560600,-70.105103,-32.757099>, <0.350947,-0.680546,-0.643190>
 <19.175301,-70.092400,-32.979900>, <0.348512,-0.680696,-0.644355>
}
   smooth_triangle{ <19.636000,-69.246300,-33.625099>, <-0.349204,0.681273,0.643369>
 <19.175301,-70.092400,-32.979900>, <-0.348512,0.680696,0.644355>
 <19.560600,-70.105103,-32.757099>, <-0.350947,0.680546,0.643190>
}
   smooth_triangle{ <19.636000,-69.246300,-33.625099>, <0.349204,-0.681273,-0.643369>
 <19.698999,-68.557999,-34.320000>, <0.347899,-0.681812,-0.643506>
 <20.373899,-68.573799,-33.936798>, <0.350641,-0.681863,-0.641961>
}
   smooth_triangle{ <19.636000,-69.246300,-33.625099>, <-0.349204,0.681273,0.643369>
 <20.373899,-68.573799,-33.936798>, <-0.350641,0.681863,0.641961>
 <19.698999,-68.557999,-34.320000>, <-0.347899,0.681812,0.643506>
}
   smooth_triangle{ <20.373899,-68.573799,-33.936798>, <0.350641,-0.681863,-0.641961>
 <20.285999,-69.267197,-33.248600>, <0.351791,-0.681331,-0.641897>
 <19.636000,-69.246300,-33.625099>, <0.349204,-0.681273,-0.643369>
}
   smooth_triangle{ <20.373899,-68.573799,-33.936798>, <-0.350641,0.681863,0.641961>
 <19.636000,-69.246300,-33.625099>, <-0.349204,0.681273,0.643369>
 <20.285999,-69.267197,-33.248600>, <-0.351791,0.681331,0.641897>
}
   smooth_triangle{ <20.285999,-69.267197,-33.248600>, <0.351791,-0.681331,-0.641897>
 <20.373899,-68.573799,-33.936798>, <0.350641,-0.681863,-0.641961>
 <21.286301,-68.596199,-33.412102>, <0.353652,-0.681970,-0.640194>
}
   smooth_triangle{ <20.285999,-69.267197,-33.248600>, <-0.351791,0.681331,0.641897>
 <21.286301,-68.596199,-33.412102>, <-0.353652,0.681970,0.640194>
 <20.373899,-68.573799,-33.936798>, <-0.350641,0.681863,0.641961>
}
   smooth_triangle{ <21.286301,-68.596199,-33.412102>, <0.353652,-0.681970,-0.640194>
 <21.163200,-69.300003,-32.730701>, <0.354567,-0.681434,-0.640258>
 <20.285999,-69.267197,-33.248600>, <0.351791,-0.681331,-0.641897>
}
   smooth_triangle{ <21.286301,-68.596199,-33.412102>, <-0.353652,0.681970,0.640194>
 <20.285999,-69.267197,-33.248600>, <-0.351791,0.681331,0.641897>
 <21.163200,-69.300003,-32.730701>, <-0.354567,0.681434,0.640258>
}
   smooth_triangle{ <19.560600,-70.105103,-32.757099>, <0.350947,-0.680546,-0.643190>
 <19.636000,-69.246300,-33.625099>, <0.349204,-0.681273,-0.643369>
 <20.285999,-69.267197,-33.248600>, <0.351791,-0.681331,-0.641897>
}
   smooth_triangle{ <19.560600,-70.105103,-32.757099>, <-0.350947,0.680546,0.643190>
 <20.285999,-69.267197,-33.248600>, <-0.351791,0.681331,0.641897>
 <19.636000,-69.246300,-33.625099>, <-0.349204,0.681273,0.643369>
}
   smooth_triangle{ <20.285999,-69.267197,-33.248600>, <0.351791,-0.681331,-0.641897>
 <20.180000,-70.130600,-32.390800>, <0.353238,-0.680530,-0.641951>
 <19.560600,-70.105103,-32.757099>, <0.350947,-0.680546,-0.643190>
}
   smooth_triangle{ <20.285999,-69.267197,-33.248600>, <-0.351791,0.681331,0.641897>
 <19.560600,-70.105103,-32.757099>, <-0.350947,0.680546,0.643190>
 <20.180000,-70.130600,-32.390800>, <-0.353238,0.680530,0.641951>
}
   smooth_triangle{ <20.180000,-70.130600,-32.390800>, <0.353238,-0.680530,-0.641951>
 <20.285999,-69.267197,-33.248600>, <0.351791,-0.681331,-0.641897>
 <21.163200,-69.300003,-32.730701>, <0.354567,-0.681434,-0.640258>
}
   smooth_triangle{ <20.180000,-70.130600,-32.390800>, <-0.353238,0.680530,0.641951>
 <21.163200,-69.300003,-32.730701>, <-0.354567,0.681434,0.640258>
 <20.285999,-69.267197,-33.248600>, <-0.351791,0.681331,0.641897>
}
   smooth_triangle{ <21.163200,-69.300003,-32.730701>, <0.354567,-0.681434,-0.640258>
 <21.014601,-70.172302,-31.885099>, <0.355800,-0.680506,-0.640561>
 <20.180000,-70.130600,-32.390800>, <0.353238,-0.680530,-0.641951>
}
   smooth_triangle{ <21.163200,-69.300003,-32.730701>, <-0.354567,0.681434,0.640258>
 <20.180000,-70.130600,-32.390800>, <-0.353238,0.680530,0.641951>
 <21.014601,-70.172302,-31.885099>, <-0.355800,0.680506,0.640561>
}
   smooth_triangle{ <18.990200,-71.057297,-32.061501>, <0.348916,-0.680175,-0.644685>
 <19.042700,-70.088898,-33.054901>, <0.346579,-0.681053,-0.645019>
 <19.175301,-70.092400,-32.979900>, <0.348512,-0.680696,-0.644355>
}
   smooth_triangle{ <18.990200,-71.057297,-32.061501>, <-0.372431,0.674110,0.637864>
 <19.175301,-70.092400,-32.979900>, <-0.348512,0.680696,0.644355>
 <19.042700,-70.088898,-33.054901>, <-0.373787,0.674161,0.637017>
}
   smooth_triangle{ <19.175301,-70.092400,-32.979900>, <0.348512,-0.680696,-0.644355>
 <19.115801,-71.060997,-31.989401>, <0.350751,-0.679806,-0.644079>
 <18.990200,-71.057297,-32.061501>, <0.348916,-0.680175,-0.644685>
}
   smooth_triangle{ <19.175301,-70.092400,-32.979900>, <-0.348512,0.680696,0.644355>
 <18.990200,-71.057297,-32.061501>, <-0.372431,0.674110,0.637864>
 <19.115801,-71.060997,-31.989401>, <-0.350751,0.679806,0.644079>
}
   smooth_triangle{ <19.115801,-71.060997,-31.989401>, <0.350751,-0.679806,-0.644079>
 <19.175301,-70.092400,-32.979900>, <0.348512,-0.680696,-0.644355>
 <19.560600,-70.105103,-32.757099>, <0.350947,-0.680546,-0.643190>
}
   smooth_triangle{ <19.115801,-71.060997,-31.989401>, <-0.350751,0.679806,0.644079>
 <19.560600,-70.105103,-32.757099>, <-0.350947,0.680546,0.643190>
 <19.175301,-70.092400,-32.979900>, <-0.348512,0.680696,0.644355>
}
   smooth_triangle{ <19.560600,-70.105103,-32.757099>, <0.350947,-0.680546,-0.643190>
 <19.480499,-71.076302,-31.774000>, <0.352564,-0.679664,-0.643239>
 <19.115801,-71.060997,-31.989401>, <0.350751,-0.679806,-0.644079>
}
   smooth_triangle{ <19.560600,-70.105103,-32.757099>, <-0.350947,0.680546,0.643190>
 <19.115801,-71.060997,-31.989401>, <-0.350751,0.679806,0.644079>
 <19.480499,-71.076302,-31.774000>, <-0.352564,0.679664,0.643239>
}
   smooth_triangle{ <19.480499,-71.076302,-31.774000>, <0.352564,-0.679664,-0.643239>
 <19.560600,-70.105103,-32.757099>, <0.350947,-0.680546,-0.643190>
 <20.180000,-70.130600,-32.390800>, <0.353238,-0.680530,-0.641951>
}
   smooth_triangle{ <19.480499,-71.076302,-31.774000>, <-0.352564,0.679664,0.643239>
 <20.180000,-70.130600,-32.390800>, <-0.353238,0.680530,0.641951>
 <19.560600,-70.105103,-32.757099>, <-0.350947,0.680546,0.643190>
}
   smooth_triangle{ <20.180000,-70.130600,-32.390800>, <0.353238,-0.680530,-0.641951>
 <20.066200,-71.109703,-31.416800>, <0.354628,-0.679611,-0.642159>
 <19.480499,-71.076302,-31.774000>, <0.352564,-0.679664,-0.643239>
}
   smooth_triangle{ <20.180000,-70.130600,-32.390800>, <-0.353238,0.680530,0.641951>
 <19.480499,-71.076302,-31.774000>, <-0.352564,0.679664,0.643239>
 <20.066200,-71.109703,-31.416800>, <-0.354628,0.679611,0.642159>
}
   smooth_triangle{ <20.066200,-71.109703,-31.416800>, <0.354628,-0.679611,-0.642159>
 <20.180000,-70.130600,-32.390800>, <0.353238,-0.680530,-0.641951>
 <21.014601,-70.172302,-31.885099>, <0.355800,-0.680506,-0.640561>
}
   smooth_triangle{ <20.066200,-71.109703,-31.416800>, <-0.354628,0.679611,0.642159>
 <21.014601,-70.172302,-31.885099>, <-0.355800,0.680506,0.640561>
 <20.180000,-70.130600,-32.390800>, <-0.353238,0.680530,0.641951>
}
   smooth_triangle{ <21.014601,-70.172302,-31.885099>, <0.355800,-0.680506,-0.640561>
 <20.854601,-71.167198,-30.918900>, <0.356095,-0.679633,-0.641323>
 <20.066200,-71.109703,-31.416800>, <0.354628,-0.679611,-0.642159>
}
   smooth_triangle{ <21.014601,-70.172302,-31.885099>, <-0.355800,0.680506,0.640561>
 <20.066200,-71.109703,-31.416800>, <-0.354628,0.679611,0.642159>
 <20.854601,-71.167198,-30.918900>, <-0.356095,0.679633,0.641323>
}
   smooth_triangle{ <18.941401,-72.077103,-31.012899>, <0.351074,-0.679188,-0.644555>
 <18.990200,-71.057297,-32.061501>, <0.348916,-0.680175,-0.644685>
 <19.115801,-71.060997,-31.989401>, <0.350751,-0.679806,-0.644079>
}
   smooth_triangle{ <18.941401,-72.077103,-31.012899>, <-0.371606,0.673760,0.638715>
 <19.115801,-71.060997,-31.989401>, <-0.350751,0.679806,0.644079>
 <18.990200,-71.057297,-32.061501>, <-0.372431,0.674110,0.637864>
}
   smooth_triangle{ <19.115801,-71.060997,-31.989401>, <0.350751,-0.679806,-0.644079>
 <19.059700,-72.080200,-30.945101>, <0.352525,-0.678822,-0.644149>
 <18.941401,-72.077103,-31.012899>, <0.351074,-0.679188,-0.644555>
}
   smooth_triangle{ <19.115801,-71.060997,-31.989401>, <-0.350751,0.679806,0.644079>
 <18.941401,-72.077103,-31.012899>, <-0.371606,0.673760,0.638715>
 <19.059700,-72.080200,-30.945101>, <-0.352525,0.678822,0.644149>
}
   smooth_triangle{ <19.059700,-72.080200,-30.945101>, <0.352525,-0.678822,-0.644149>
 <19.115801,-71.060997,-31.989401>, <0.350751,-0.679806,-0.644079>
 <19.480499,-71.076302,-31.774000>, <0.352564,-0.679664,-0.643239>
}
   smooth_triangle{ <19.059700,-72.080200,-30.945101>, <-0.352525,0.678822,0.644149>
 <19.480499,-71.076302,-31.774000>, <-0.352564,0.679664,0.643239>
 <19.115801,-71.060997,-31.989401>, <-0.350751,0.679806,0.644079>
}
   smooth_triangle{ <19.480499,-71.076302,-31.774000>, <0.352564,-0.679664,-0.643239>
 <19.402700,-72.092499,-30.743799>, <0.354283,-0.678656,-0.643359>
 <19.059700,-72.080200,-30.945101>, <0.352525,-0.678822,-0.644149>
}
   smooth_triangle{ <19.480499,-71.076302,-31.774000>, <-0.352564,0.679664,0.643239>
 <19.059700,-72.080200,-30.945101>, <-0.352525,0.678822,0.644149>
 <19.402700,-72.092499,-30.743799>, <-0.354283,0.678656,0.643359>
}
   smooth_triangle{ <19.402700,-72.092499,-30.743799>, <0.354283,-0.678656,-0.643359>
 <19.480499,-71.076302,-31.774000>, <0.352564,-0.679664,-0.643239>
 <20.066200,-71.109703,-31.416800>, <0.354628,-0.679611,-0.642159>
}
   smooth_triangle{ <19.402700,-72.092499,-30.743799>, <-0.354283,0.678656,0.643359>
 <20.066200,-71.109703,-31.416800>, <-0.354628,0.679611,0.642159>
 <19.480499,-71.076302,-31.774000>, <-0.352564,0.679664,0.643239>
}
   smooth_triangle{ <20.066200,-71.109703,-31.416800>, <0.354628,-0.679611,-0.642159>
 <19.953400,-72.118401,-30.412001>, <0.356378,-0.678605,-0.642253>
 <19.402700,-72.092499,-30.743799>, <0.354283,-0.678656,-0.643359>
}
   smooth_triangle{ <20.066200,-71.109703,-31.416800>, <-0.354628,0.679611,0.642159>
 <19.402700,-72.092499,-30.743799>, <-0.354283,0.678656,0.643359>
 <19.953400,-72.118401,-30.412001>, <-0.356378,0.678605,0.642253>
}
   smooth_triangle{ <19.953400,-72.118401,-30.412001>, <0.356378,-0.678605,-0.642253>
 <20.066200,-71.109703,-31.416800>, <0.354628,-0.679611,-0.642159>
 <20.854601,-71.167198,-30.918900>, <0.356095,-0.679633,-0.641323>
}
   smooth_triangle{ <19.953400,-72.118401,-30.412001>, <-0.356378,0.678605,0.642253>
 <20.854601,-71.167198,-30.918900>, <-0.356095,0.679633,0.641323>
 <20.066200,-71.109703,-31.416800>, <-0.354628,0.679611,0.642159>
}
   smooth_triangle{ <20.854601,-71.167198,-30.918900>, <0.356095,-0.679633,-0.641323>
 <20.694700,-72.162201,-29.952499>, <0.358419,-0.678649,-0.641070>
 <19.953400,-72.118401,-30.412001>, <0.356378,-0.678605,-0.642253>
}
   smooth_triangle{ <20.854601,-71.167198,-30.918900>, <-0.356095,0.679633,0.641323>
 <19.953400,-72.118401,-30.412001>, <-0.356378,0.678605,0.642253>
 <20.694700,-72.162201,-29.952499>, <-0.358419,0.678649,0.641070>
}
   smooth_triangle{ <18.902300,-73.088699,-29.969700>, <0.352840,-0.678076,-0.644761>
 <18.941401,-72.077103,-31.012899>, <0.351074,-0.679188,-0.644555>
 <19.059700,-72.080200,-30.945101>, <0.352525,-0.678822,-0.644149>
}
   smooth_triangle{ <18.902300,-73.088699,-29.969700>, <-0.372086,0.672831,0.639414>
 <19.059700,-72.080200,-30.945101>, <-0.352525,0.678822,0.644149>
 <18.941401,-72.077103,-31.012899>, <-0.371606,0.673760,0.638715>
}
   smooth_triangle{ <19.059700,-72.080200,-30.945101>, <0.352525,-0.678822,-0.644149>
 <19.013000,-73.091103,-29.906500>, <0.353840,-0.677727,-0.644581>
 <18.902300,-73.088699,-29.969700>, <0.352840,-0.678076,-0.644761>
}
   smooth_triangle{ <19.059700,-72.080200,-30.945101>, <-0.352525,0.678822,0.644149>
 <18.902300,-73.088699,-29.969700>, <-0.372086,0.672831,0.639414>
 <19.013000,-73.091103,-29.906500>, <-0.353840,0.677727,0.644581>
}
   smooth_triangle{ <19.013000,-73.091103,-29.906500>, <0.353840,-0.677727,-0.644581>
 <19.059700,-72.080200,-30.945101>, <0.352525,-0.678822,-0.644149>
 <19.402700,-72.092499,-30.743799>, <0.354283,-0.678656,-0.643359>
}
   smooth_triangle{ <19.013000,-73.091103,-29.906500>, <-0.353840,0.677727,0.644581>
 <19.402700,-72.092499,-30.743799>, <-0.354283,0.678656,0.643359>
 <19.059700,-72.080200,-30.945101>, <-0.352525,0.678822,0.644149>
}
   smooth_triangle{ <19.402700,-72.092499,-30.743799>, <0.354283,-0.678656,-0.643359>
 <19.334900,-73.100197,-29.719700>, <0.355612,-0.677349,-0.644001>
 <19.013000,-73.091103,-29.906500>, <0.353840,-0.677727,-0.644581>
}
   smooth_triangle{ <19.402700,-72.092499,-30.743799>, <-0.354283,0.678656,0.643359>
 <19.013000,-73.091103,-29.906500>, <-0.353840,0.677727,0.644581>
 <19.334900,-73.100197,-29.719700>, <-0.355612,0.677349,0.644001>
}
   smooth_triangle{ <19.334900,-73.100197,-29.719700>, <0.355612,-0.677349,-0.644001>
 <19.402700,-72.092499,-30.743799>, <0.354283,-0.678656,-0.643359>
 <19.953400,-72.118401,-30.412001>, <0.356378,-0.678605,-0.642253>
}
   smooth_triangle{ <19.334900,-73.100197,-29.719700>, <-0.355612,0.677349,0.644001>
 <19.953400,-72.118401,-30.412001>, <-0.356378,0.678605,0.642253>
 <19.402700,-72.092499,-30.743799>, <-0.354283,0.678656,0.643359>
}
   smooth_triangle{ <19.953400,-72.118401,-30.412001>, <0.356378,-0.678605,-0.642253>
 <19.852600,-73.118698,-29.413099>, <0.357934,-0.676921,-0.643166>
 <19.334900,-73.100197,-29.719700>, <0.355612,-0.677349,-0.644001>
}
   smooth_triangle{ <19.953400,-72.118401,-30.412001>, <-0.356378,0.678605,0.642253>
 <19.334900,-73.100197,-29.719700>, <-0.355612,0.677349,0.644001>
 <19.852600,-73.118698,-29.413099>, <-0.357934,0.676921,0.643166>
}
   smooth_triangle{ <19.852600,-73.118698,-29.413099>, <0.357934,-0.676921,-0.643166>
 <19.953400,-72.118401,-30.412001>, <0.356378,-0.678605,-0.642253>
 <20.694700,-72.162201,-29.952499>, <0.358419,-0.678649,-0.641070>
}
   smooth_triangle{ <19.852600,-73.118698,-29.413099>, <-0.357934,0.676921,0.643166>
 <20.694700,-72.162201,-29.952499>, <-0.358419,0.678649,0.641070>
 <19.953400,-72.118401,-30.412001>, <-0.356378,0.678605,0.642253>
}
   smooth_triangle{ <20.694700,-72.162201,-29.952499>, <0.358419,-0.678649,-0.641070>
 <20.550699,-73.149498,-28.990499>, <0.360166,-0.676585,-0.642271>
 <19.852600,-73.118698,-29.413099>, <0.357934,-0.676921,-0.643166>
}
   smooth_triangle{ <20.694700,-72.162201,-29.952499>, <-0.358419,0.678649,0.641070>
 <19.852600,-73.118698,-29.413099>, <-0.357934,0.676921,0.643166>
 <20.550699,-73.149498,-28.990499>, <-0.360166,0.676585,0.642271>
}
   smooth_triangle{ <18.878300,-74.032402,-28.992001>, <0.351675,-0.680850,-0.642470>
 <18.902300,-73.088699,-29.969700>, <0.352840,-0.678076,-0.644761>
 <19.013000,-73.091103,-29.906500>, <0.353840,-0.677727,-0.644581>
}
   smooth_triangle{ <18.878300,-74.032402,-28.992001>, <-0.374939,0.669874,0.640850>
 <19.013000,-73.091103,-29.906500>, <-0.353840,0.677727,0.644581>
 <18.902300,-73.088699,-29.969700>, <-0.372086,0.672831,0.639414>
}
   smooth_triangle{ <19.013000,-73.091103,-29.906500>, <0.353840,-0.677727,-0.644581>
 <18.982000,-74.033600,-28.934000>, <0.350305,-0.682916,-0.641025>
 <18.878300,-74.032402,-28.992001>, <0.351675,-0.680850,-0.642470>
}
   smooth_triangle{ <19.013000,-73.091103,-29.906500>, <-0.353840,0.677727,0.644581>
 <18.878300,-74.032402,-28.992001>, <-0.374939,0.669874,0.640850>
 <18.982000,-74.033600,-28.934000>, <-0.350305,0.682916,0.641025>
}
   smooth_triangle{ <18.982000,-74.033600,-28.934000>, <0.350305,-0.682916,-0.641025>
 <19.013000,-73.091103,-29.906500>, <0.353840,-0.677727,-0.644581>
 <19.334900,-73.100197,-29.719700>, <0.355612,-0.677349,-0.644001>
}
   smooth_triangle{ <18.982000,-74.033600,-28.934000>, <-0.350305,0.682916,0.641025>
 <19.334900,-73.100197,-29.719700>, <-0.355612,0.677349,0.644001>
 <19.013000,-73.091103,-29.906500>, <-0.353840,0.677727,0.644581>
}
   smooth_triangle{ <19.334900,-73.100197,-29.719700>, <0.355612,-0.677349,-0.644001>
 <19.284599,-74.036598,-28.764500>, <0.353385,-0.681217,-0.641141>
 <18.982000,-74.033600,-28.934000>, <0.350305,-0.682916,-0.641025>
}
   smooth_triangle{ <19.334900,-73.100197,-29.719700>, <-0.355612,0.677349,0.644001>
 <18.982000,-74.033600,-28.934000>, <-0.350305,0.682916,0.641025>
 <19.284599,-74.036598,-28.764500>, <-0.353385,0.681217,0.641141>
}
   smooth_triangle{ <19.284599,-74.036598,-28.764500>, <0.353385,-0.681217,-0.641141>
 <19.334900,-73.100197,-29.719700>, <0.355612,-0.677349,-0.644001>
 <19.852600,-73.118698,-29.413099>, <0.357934,-0.676921,-0.643166>
}
   smooth_triangle{ <19.284599,-74.036598,-28.764500>, <-0.353385,0.681217,0.641141>
 <19.852600,-73.118698,-29.413099>, <-0.357934,0.676921,0.643166>
 <19.334900,-73.100197,-29.719700>, <-0.355612,0.677349,0.644001>
}
   smooth_triangle{ <19.852600,-73.118698,-29.413099>, <0.357934,-0.676921,-0.643166>
 <19.773300,-74.040604,-28.489300>, <0.356538,-0.679586,-0.641127>
 <19.284599,-74.036598,-28.764500>, <0.353385,-0.681217,-0.641141>
}
   smooth_triangle{ <19.852600,-73.118698,-29.413099>, <-0.357934,0.676921,0.643166>
 <19.284599,-74.036598,-28.764500>, <-0.353385,0.681217,0.641141>
 <19.773300,-74.040604,-28.489300>, <-0.356538,0.679586,0.641127>
}
   smooth_triangle{ <19.773300,-74.040604,-28.489300>, <0.356538,-0.679586,-0.641127>
 <19.852600,-73.118698,-29.413099>, <0.357934,-0.676921,-0.643166>
 <20.550699,-73.149498,-28.990499>, <0.360166,-0.676585,-0.642271>
}
   smooth_triangle{ <19.773300,-74.040604,-28.489300>, <-0.356538,0.679586,0.641127>
 <20.550699,-73.149498,-28.990499>, <-0.360166,0.676585,0.642271>
 <19.852600,-73.118698,-29.413099>, <-0.357934,0.676921,0.643166>
}
   smooth_triangle{ <20.550699,-73.149498,-28.990499>, <0.360166,-0.676585,-0.642271>
 <20.435600,-74.044701,-28.114901>, <0.359391,-0.678185,-0.641018>
 <19.773300,-74.040604,-28.489300>, <0.356538,-0.679586,-0.641127>
}
   smooth_triangle{ <20.550699,-73.149498,-28.990499>, <-0.360166,0.676585,0.642271>
 <19.773300,-74.040604,-28.489300>, <-0.356538,0.679586,0.641127>
 <20.435600,-74.044701,-28.114901>, <-0.359391,0.678185,0.641018>
}
   smooth_triangle{ <21.393101,-67.999100,-33.989700>, <0.352982,-0.681934,-0.640600>
 <21.401100,-67.954903,-34.032200>, <0.352676,-0.681348,-0.641393>
 <22.574699,-67.964500,-33.371498>, <0.356092,-0.681391,-0.639456>
}
   smooth_triangle{ <21.393101,-67.999100,-33.989700>, <-0.352982,0.681934,0.640600>
 <22.574699,-67.964500,-33.371498>, <-0.356092,0.681391,0.639456>
 <21.401100,-67.954903,-34.032200>, <-0.352676,0.681348,0.641393>
}
   smooth_triangle{ <22.574699,-67.964500,-33.371498>, <0.356092,-0.681391,-0.639456>
 <22.563801,-68.010201,-33.328800>, <0.356363,-0.682209,-0.638433>
 <21.393101,-67.999100,-33.989700>, <0.352982,-0.681934,-0.640600>
}
   smooth_triangle{ <22.574699,-67.964500,-33.371498>, <-0.356092,0.681391,0.639456>
 <21.393101,-67.999100,-33.989700>, <-0.352982,0.681934,0.640600>
 <22.563801,-68.010201,-33.328800>, <-0.356363,0.682209,0.638433>
}
   smooth_triangle{ <21.370199,-68.126099,-33.866798>, <0.352837,-0.682521,-0.640056>
 <21.393101,-67.999100,-33.989700>, <0.352982,-0.681934,-0.640600>
 <22.563801,-68.010201,-33.328800>, <0.356363,-0.682209,-0.638433>
}
   smooth_triangle{ <21.370199,-68.126099,-33.866798>, <-0.352837,0.682521,0.640056>
 <22.563801,-68.010201,-33.328800>, <-0.356363,0.682209,0.638433>
 <21.393101,-67.999100,-33.989700>, <-0.352982,0.681934,0.640600>
}
   smooth_triangle{ <22.563801,-68.010201,-33.328800>, <0.356363,-0.682209,-0.638433>
 <22.532301,-68.141403,-33.206001>, <0.356288,-0.682544,-0.638117>
 <21.370199,-68.126099,-33.866798>, <0.352837,-0.682521,-0.640056>
}
   smooth_triangle{ <22.563801,-68.010201,-33.328800>, <-0.356363,0.682209,0.638433>
 <21.370199,-68.126099,-33.866798>, <-0.352837,0.682521,0.640056>
 <22.532301,-68.141403,-33.206001>, <-0.356288,0.682544,0.638117>
}
   smooth_triangle{ <21.334000,-68.327904,-33.671700>, <0.353165,-0.682248,-0.640166>
 <21.370199,-68.126099,-33.866798>, <0.352837,-0.682521,-0.640056>
 <22.532301,-68.141403,-33.206001>, <0.356288,-0.682544,-0.638117>
}
   smooth_triangle{ <21.334000,-68.327904,-33.671700>, <-0.353165,0.682248,0.640166>
 <22.532301,-68.141403,-33.206001>, <-0.356288,0.682544,0.638117>
 <21.370199,-68.126099,-33.866798>, <-0.352837,0.682521,0.640056>
}
   smooth_triangle{ <22.532301,-68.141403,-33.206001>, <0.356288,-0.682544,-0.638117>
 <22.482700,-68.349403,-33.011200>, <0.356519,-0.682325,-0.638221>
 <21.334000,-68.327904,-33.671700>, <0.353165,-0.682248,-0.640166>
}
   smooth_triangle{ <22.532301,-68.141403,-33.206001>, <-0.356288,0.682544,0.638117>
 <21.334000,-68.327904,-33.671700>, <-0.353165,0.682248,0.640166>
 <22.482700,-68.349403,-33.011200>, <-0.356519,0.682325,0.638221>
}
   smooth_triangle{ <21.286301,-68.596199,-33.412102>, <0.353652,-0.681970,-0.640194>
 <21.334000,-68.327904,-33.671700>, <0.353165,-0.682248,-0.640166>
 <22.482700,-68.349403,-33.011200>, <0.356519,-0.682325,-0.638221>
}
   smooth_triangle{ <21.286301,-68.596199,-33.412102>, <-0.353652,0.681970,0.640194>
 <22.482700,-68.349403,-33.011200>, <-0.356519,0.682325,0.638221>
 <21.334000,-68.327904,-33.671700>, <-0.353165,0.682248,0.640166>
}
   smooth_triangle{ <22.482700,-68.349403,-33.011200>, <0.356519,-0.682325,-0.638221>
 <22.417500,-68.625298,-32.752701>, <0.356875,-0.681984,-0.638387>
 <21.286301,-68.596199,-33.412102>, <0.353652,-0.681970,-0.640194>
}
   smooth_triangle{ <22.482700,-68.349403,-33.011200>, <-0.356519,0.682325,0.638221>
 <21.286301,-68.596199,-33.412102>, <-0.353652,0.681970,0.640194>
 <22.417500,-68.625298,-32.752701>, <-0.356875,0.681984,0.638387>
}
   smooth_triangle{ <22.563801,-68.010201,-33.328800>, <0.356363,-0.682209,-0.638433>
 <22.574699,-67.964500,-33.371498>, <0.356092,-0.681391,-0.639456>
 <23.958799,-67.971199,-32.586601>, <0.359758,-0.681542,-0.637239>
}
   smooth_triangle{ <22.563801,-68.010201,-33.328800>, <-0.356363,0.682209,0.638433>
 <23.958799,-67.971199,-32.586601>, <-0.359758,0.681542,0.637239>
 <22.574699,-67.964500,-33.371498>, <-0.356092,0.681391,0.639456>
}
   smooth_triangle{ <23.958799,-67.971199,-32.586601>, <0.359758,-0.681542,-0.637239>
 <23.944000,-68.019302,-32.543499>, <0.360130,-0.682169,-0.636358>
 <22.563801,-68.010201,-33.328800>, <0.356363,-0.682209,-0.638433>
}
   smooth_triangle{ <23.958799,-67.971199,-32.586601>, <-0.359758,0.681542,0.637239>
 <22.563801,-68.010201,-33.328800>, <-0.356363,0.682209,0.638433>
 <23.944000,-68.019302,-32.543499>, <-0.360130,0.682169,0.636358>
}
   smooth_triangle{ <22.532301,-68.141403,-33.206001>, <0.356288,-0.682544,-0.638117>
 <22.563801,-68.010201,-33.328800>, <0.356363,-0.682209,-0.638433>
 <23.944000,-68.019302,-32.543499>, <0.360130,-0.682169,-0.636358>
}
   smooth_triangle{ <22.532301,-68.141403,-33.206001>, <-0.356288,0.682544,0.638117>
 <23.944000,-68.019302,-32.543499>, <-0.360130,0.682169,0.636358>
 <22.563801,-68.010201,-33.328800>, <-0.356363,0.682209,0.638433>
}
   smooth_triangle{ <23.944000,-68.019302,-32.543499>, <0.360130,-0.682169,-0.636358>
 <23.902000,-68.156700,-32.419800>, <0.360081,-0.682285,-0.636262>
 <22.532301,-68.141403,-33.206001>, <0.356288,-0.682544,-0.638117>
}
   smooth_triangle{ <23.944000,-68.019302,-32.543499>, <-0.360130,0.682169,0.636358>
 <22.532301,-68.141403,-33.206001>, <-0.356288,0.682544,0.638117>
 <23.902000,-68.156700,-32.419800>, <-0.360081,0.682285,0.636262>
}
   smooth_triangle{ <22.482700,-68.349403,-33.011200>, <0.356519,-0.682325,-0.638221>
 <22.532301,-68.141403,-33.206001>, <0.356288,-0.682544,-0.638117>
 <23.902000,-68.156700,-32.419800>, <0.360081,-0.682285,-0.636262>
}
   smooth_triangle{ <22.482700,-68.349403,-33.011200>, <-0.356519,0.682325,0.638221>
 <23.902000,-68.156700,-32.419800>, <-0.360081,0.682285,0.636262>
 <22.532301,-68.141403,-33.206001>, <-0.356288,0.682544,0.638117>
}
   smooth_triangle{ <23.902000,-68.156700,-32.419800>, <0.360081,-0.682285,-0.636262>
 <23.835800,-68.374001,-32.224300>, <0.360174,-0.682142,-0.636362>
 <22.482700,-68.349403,-33.011200>, <0.356519,-0.682325,-0.638221>
}
   smooth_triangle{ <23.902000,-68.156700,-32.419800>, <-0.360081,0.682285,0.636262>
 <22.482700,-68.349403,-33.011200>, <-0.356519,0.682325,0.638221>
 <23.835800,-68.374001,-32.224300>, <-0.360174,0.682142,0.636362>
}
   smooth_triangle{ <22.417500,-68.625298,-32.752701>, <0.356875,-0.681984,-0.638387>
 <22.482700,-68.349403,-33.011200>, <0.356519,-0.682325,-0.638221>
 <23.835800,-68.374001,-32.224300>, <0.360174,-0.682142,-0.636362>
}
   smooth_triangle{ <22.417500,-68.625298,-32.752701>, <-0.356875,0.681984,0.638387>
 <23.835800,-68.374001,-32.224300>, <-0.360174,0.682142,0.636362>
 <22.482700,-68.349403,-33.011200>, <-0.356519,0.682325,0.638221>
}
   smooth_triangle{ <23.835800,-68.374001,-32.224300>, <0.360174,-0.682142,-0.636362>
 <23.748600,-68.661499,-31.965500>, <0.360403,-0.681832,-0.636565>
 <22.417500,-68.625298,-32.752701>, <0.356875,-0.681984,-0.638387>
}
   smooth_triangle{ <23.835800,-68.374001,-32.224300>, <-0.360174,0.682142,0.636362>
 <22.417500,-68.625298,-32.752701>, <-0.356875,0.681984,0.638387>
 <23.748600,-68.661499,-31.965500>, <-0.360403,0.681832,0.636565>
}
   smooth_triangle{ <21.163200,-69.300003,-32.730701>, <0.354567,-0.681434,-0.640258>
 <21.286301,-68.596199,-33.412102>, <0.353652,-0.681970,-0.640194>
 <22.417500,-68.625298,-32.752701>, <0.356875,-0.681984,-0.638387>
}
   smooth_triangle{ <21.163200,-69.300003,-32.730701>, <-0.354567,0.681434,0.640258>
 <22.417500,-68.625298,-32.752701>, <-0.356875,0.681984,0.638387>
 <21.286301,-68.596199,-33.412102>, <-0.353652,0.681970,0.640194>
}
   smooth_triangle{ <22.417500,-68.625298,-32.752701>, <0.356875,-0.681984,-0.638387>
 <22.248899,-69.346199,-32.077202>, <0.357530,-0.681476,-0.638563>
 <21.163200,-69.300003,-32.730701>, <0.354567,-0.681434,-0.640258>
}
   smooth_triangle{ <22.417500,-68.625298,-32.752701>, <-0.356875,0.681984,0.638387>
 <21.163200,-69.300003,-32.730701>, <-0.354567,0.681434,0.640258>
 <22.248899,-69.346199,-32.077202>, <-0.357530,0.681476,0.638563>
}
   smooth_triangle{ <21.014601,-70.172302,-31.885099>, <0.355800,-0.680506,-0.640561>
 <21.163200,-69.300003,-32.730701>, <0.354567,-0.681434,-0.640258>
 <22.248899,-69.346199,-32.077202>, <0.357530,-0.681476,-0.638563>
}
   smooth_triangle{ <21.014601,-70.172302,-31.885099>, <-0.355800,0.680506,0.640561>
 <22.248899,-69.346199,-32.077202>, <-0.357530,0.681476,0.638563>
 <21.163200,-69.300003,-32.730701>, <-0.354567,0.681434,0.640258>
}
   smooth_triangle{ <22.248899,-69.346199,-32.077202>, <0.357530,-0.681476,-0.638563>
 <22.045500,-70.233803,-31.244400>, <0.358714,-0.680470,-0.638972>
 <21.014601,-70.172302,-31.885099>, <0.355800,-0.680506,-0.640561>
}
   smooth_triangle{ <22.248899,-69.346199,-32.077202>, <-0.357530,0.681476,0.638563>
 <21.014601,-70.172302,-31.885099>, <-0.355800,0.680506,0.640561>
 <22.045500,-70.233803,-31.244400>, <-0.358714,0.680470,0.638972>
}
   smooth_triangle{ <22.248899,-69.346199,-32.077202>, <0.357530,-0.681476,-0.638563>
 <22.417500,-68.625298,-32.752701>, <0.356875,-0.681984,-0.638387>
 <23.748600,-68.661499,-31.965500>, <0.360403,-0.681832,-0.636565>
}
   smooth_triangle{ <22.248899,-69.346199,-32.077202>, <-0.357530,0.681476,0.638563>
 <23.748600,-68.661499,-31.965500>, <-0.360403,0.681832,0.636565>
 <22.417500,-68.625298,-32.752701>, <-0.356875,0.681984,0.638387>
}
   smooth_triangle{ <23.748600,-68.661499,-31.965500>, <0.360403,-0.681832,-0.636565>
 <23.524099,-69.407997,-31.293200>, <0.360786,-0.681399,-0.636812>
 <22.248899,-69.346199,-32.077202>, <0.357530,-0.681476,-0.638563>
}
   smooth_triangle{ <23.748600,-68.661499,-31.965500>, <-0.360403,0.681832,0.636565>
 <22.248899,-69.346199,-32.077202>, <-0.357530,0.681476,0.638563>
 <23.524099,-69.407997,-31.293200>, <-0.360786,0.681399,0.636812>
}
   smooth_triangle{ <22.045500,-70.233803,-31.244400>, <0.358714,-0.680470,-0.638972>
 <22.248899,-69.346199,-32.077202>, <0.357530,-0.681476,-0.638563>
 <23.524099,-69.407997,-31.293200>, <0.360786,-0.681399,-0.636812>
}
   smooth_triangle{ <22.045500,-70.233803,-31.244400>, <-0.358714,0.680470,0.638972>
 <23.524099,-69.407997,-31.293200>, <-0.360786,0.681399,0.636812>
 <22.248899,-69.346199,-32.077202>, <-0.357530,0.681476,0.638563>
}
   smooth_triangle{ <23.524099,-69.407997,-31.293200>, <0.360786,-0.681399,-0.636812>
 <23.254200,-70.318497,-30.472401>, <0.361646,-0.680440,-0.637349>
 <22.045500,-70.233803,-31.244400>, <0.358714,-0.680470,-0.638972>
}
   smooth_triangle{ <23.524099,-69.407997,-31.293200>, <-0.360786,0.681399,0.636812>
 <22.045500,-70.233803,-31.244400>, <-0.358714,0.680470,0.638972>
 <23.254200,-70.318497,-30.472401>, <-0.361646,0.680440,0.637349>
}
   smooth_triangle{ <23.944000,-68.019302,-32.543499>, <0.360130,-0.682169,-0.636358>
 <23.958799,-67.971199,-32.586601>, <0.359758,-0.681542,-0.637239>
 <25.534700,-67.973602,-31.686001>, <0.363551,-0.681893,-0.634707>
}
   smooth_triangle{ <23.944000,-68.019302,-32.543499>, <-0.360130,0.682169,0.636358>
 <25.534700,-67.973602,-31.686001>, <-0.363551,0.681893,0.634707>
 <23.958799,-67.971199,-32.586601>, <-0.359758,0.681542,0.637239>
}
   smooth_triangle{ <25.534700,-67.973602,-31.686001>, <0.363551,-0.681893,-0.634707>
 <25.515400,-68.024803,-31.642000>, <0.364206,-0.681960,-0.634259>
 <23.944000,-68.019302,-32.543499>, <0.360130,-0.682169,-0.636358>
}
   smooth_triangle{ <25.534700,-67.973602,-31.686001>, <-0.363551,0.681893,0.634707>
 <23.944000,-68.019302,-32.543499>, <-0.360130,0.682169,0.636358>
 <25.515400,-68.024803,-31.642000>, <-0.364206,0.681960,0.634259>
}
   smooth_triangle{ <23.902000,-68.156700,-32.419800>, <0.360081,-0.682285,-0.636262>
 <23.944000,-68.019302,-32.543499>, <0.360130,-0.682169,-0.636358>
 <25.515400,-68.024803,-31.642000>, <0.364206,-0.681960,-0.634259>
}
   smooth_triangle{ <23.902000,-68.156700,-32.419800>, <-0.360081,0.682285,0.636262>
 <25.515400,-68.024803,-31.642000>, <-0.364206,0.681960,0.634259>
 <23.944000,-68.019302,-32.543499>, <-0.360130,0.682169,0.636358>
}
   smooth_triangle{ <25.515400,-68.024803,-31.642000>, <0.364206,-0.681960,-0.634259>
 <25.460600,-68.171097,-31.516300>, <0.364249,-0.681800,-0.634406>
 <23.902000,-68.156700,-32.419800>, <0.360081,-0.682285,-0.636262>
}
   smooth_triangle{ <25.515400,-68.024803,-31.642000>, <-0.364206,0.681960,0.634259>
 <23.902000,-68.156700,-32.419800>, <-0.360081,0.682285,0.636262>
 <25.460600,-68.171097,-31.516300>, <-0.364249,0.681800,0.634406>
}
   smooth_triangle{ <23.835800,-68.374001,-32.224300>, <0.360174,-0.682142,-0.636362>
 <23.902000,-68.156700,-32.419800>, <0.360081,-0.682285,-0.636262>
 <25.460600,-68.171097,-31.516300>, <0.364249,-0.681800,-0.634406>
}
   smooth_triangle{ <23.835800,-68.374001,-32.224300>, <-0.360174,0.682142,0.636362>
 <25.460600,-68.171097,-31.516300>, <-0.364249,0.681800,0.634406>
 <23.902000,-68.156700,-32.419800>, <-0.360081,0.682285,0.636262>
}
   smooth_triangle{ <25.460600,-68.171097,-31.516300>, <0.364249,-0.681800,-0.634406>
 <25.374399,-68.401299,-31.318199>, <0.364230,-0.681727,-0.634496>
 <23.835800,-68.374001,-32.224300>, <0.360174,-0.682142,-0.636362>
}
   smooth_triangle{ <25.460600,-68.171097,-31.516300>, <-0.364249,0.681800,0.634406>
 <23.835800,-68.374001,-32.224300>, <-0.360174,0.682142,0.636362>
 <25.374399,-68.401299,-31.318199>, <-0.364230,0.681727,0.634496>
}
   smooth_triangle{ <23.748600,-68.661499,-31.965500>, <0.360403,-0.681832,-0.636565>
 <23.835800,-68.374001,-32.224300>, <0.360174,-0.682142,-0.636362>
 <25.374399,-68.401299,-31.318199>, <0.364230,-0.681727,-0.634496>
}
   smooth_triangle{ <23.748600,-68.661499,-31.965500>, <-0.360403,0.681832,0.636565>
 <25.374399,-68.401299,-31.318199>, <-0.364230,0.681727,0.634496>
 <23.835800,-68.374001,-32.224300>, <-0.360174,0.682142,0.636362>
}
   smooth_triangle{ <25.374399,-68.401299,-31.318199>, <0.364230,-0.681727,-0.634496>
 <25.261000,-68.704803,-31.057301>, <0.364286,-0.681452,-0.634759>
 <23.748600,-68.661499,-31.965500>, <0.360403,-0.681832,-0.636565>
}
   smooth_triangle{ <25.374399,-68.401299,-31.318199>, <-0.364230,0.681727,0.634496>
 <23.748600,-68.661499,-31.965500>, <-0.360403,0.681832,0.636565>
 <25.261000,-68.704803,-31.057301>, <-0.364286,0.681452,0.634759>
}
   smooth_triangle{ <23.524099,-69.407997,-31.293200>, <0.360786,-0.681399,-0.636812>
 <23.748600,-68.661499,-31.965500>, <0.360403,-0.681832,-0.636565>
 <25.261000,-68.704803,-31.057301>, <0.364286,-0.681452,-0.634759>
}
   smooth_triangle{ <23.524099,-69.407997,-31.293200>, <-0.360786,0.681399,0.636812>
 <25.261000,-68.704803,-31.057301>, <-0.364286,0.681452,0.634759>
 <23.748600,-68.661499,-31.965500>, <-0.360403,0.681832,0.636565>
}
   smooth_triangle{ <25.261000,-68.704803,-31.057301>, <0.364286,-0.681452,-0.634759>
 <24.970100,-69.487099,-30.384501>, <0.364362,-0.681113,-0.635079>
 <23.524099,-69.407997,-31.293200>, <0.360786,-0.681399,-0.636812>
}
   smooth_triangle{ <25.261000,-68.704803,-31.057301>, <-0.364286,0.681452,0.634759>
 <23.524099,-69.407997,-31.293200>, <-0.360786,0.681399,0.636812>
 <24.970100,-69.487099,-30.384501>, <-0.364362,0.681113,0.635079>
}
   smooth_triangle{ <23.254200,-70.318497,-30.472401>, <0.361646,-0.680440,-0.637349>
 <23.524099,-69.407997,-31.293200>, <0.360786,-0.681399,-0.636812>
 <24.970100,-69.487099,-30.384501>, <0.364362,-0.681113,-0.635079>
}
   smooth_triangle{ <23.254200,-70.318497,-30.472401>, <-0.361646,0.680440,0.637349>
 <24.970100,-69.487099,-30.384501>, <-0.364362,0.681113,0.635079>
 <23.524099,-69.407997,-31.293200>, <-0.360786,0.681399,0.636812>
}
   smooth_triangle{ <24.970100,-69.487099,-30.384501>, <0.364362,-0.681113,-0.635079>
 <24.621700,-70.430000,-29.573500>, <0.364813,-0.680294,-0.635698>
 <23.254200,-70.318497,-30.472401>, <0.361646,-0.680440,-0.637349>
}
   smooth_triangle{ <24.970100,-69.487099,-30.384501>, <-0.364362,0.681113,0.635079>
 <23.254200,-70.318497,-30.472401>, <-0.361646,0.680440,0.637349>
 <24.621700,-70.430000,-29.573500>, <-0.364813,0.680294,0.635698>
}
   smooth_triangle{ <25.515400,-68.024803,-31.642000>, <0.364206,-0.681960,-0.634259>
 <25.534700,-67.973602,-31.686001>, <0.363551,-0.681893,-0.634707>
 <27.284100,-67.969704,-30.677999>, <0.367841,-0.681780,-0.632352>
}
   smooth_triangle{ <25.515400,-68.024803,-31.642000>, <-0.364206,0.681960,0.634259>
 <27.284100,-67.969704,-30.677999>, <-0.367841,0.681780,0.632352>
 <25.534700,-67.973602,-31.686001>, <-0.363551,0.681893,0.634707>
}
   smooth_triangle{ <27.284100,-67.969704,-30.677999>, <0.367841,-0.681780,-0.632352>
 <27.259501,-68.025101,-30.632601>, <0.368674,-0.681574,-0.632089>
 <25.515400,-68.024803,-31.642000>, <0.364206,-0.681960,-0.634259>
}
   smooth_triangle{ <27.284100,-67.969704,-30.677999>, <-0.367841,0.681780,0.632352>
 <25.515400,-68.024803,-31.642000>, <-0.364206,0.681960,0.634259>
 <27.259501,-68.025101,-30.632601>, <-0.368674,0.681574,0.632089>
}
   smooth_triangle{ <25.460600,-68.171097,-31.516300>, <0.364249,-0.681800,-0.634406>
 <25.515400,-68.024803,-31.642000>, <0.364206,-0.681960,-0.634259>
 <27.259501,-68.025101,-30.632601>, <0.368674,-0.681574,-0.632089>
}
   smooth_triangle{ <25.460600,-68.171097,-31.516300>, <-0.364249,0.681800,0.634406>
 <27.259501,-68.025101,-30.632601>, <-0.368674,0.681574,0.632089>
 <25.515400,-68.024803,-31.642000>, <-0.364206,0.681960,0.634259>
}
   smooth_triangle{ <27.259501,-68.025101,-30.632601>, <0.368674,-0.681574,-0.632089>
 <27.189699,-68.182999,-30.503201>, <0.368785,-0.681226,-0.632400>
 <25.460600,-68.171097,-31.516300>, <0.364249,-0.681800,-0.634406>
}
   smooth_triangle{ <27.259501,-68.025101,-30.632601>, <-0.368674,0.681574,0.632089>
 <25.460600,-68.171097,-31.516300>, <-0.364249,0.681800,0.634406>
 <27.189699,-68.182999,-30.503201>, <-0.368785,0.681226,0.632400>
}
   smooth_triangle{ <25.374399,-68.401299,-31.318199>, <0.364230,-0.681727,-0.634496>
 <25.460600,-68.171097,-31.516300>, <0.364249,-0.681800,-0.634406>
 <27.189699,-68.182999,-30.503201>, <0.368785,-0.681226,-0.632400>
}
   smooth_triangle{ <25.374399,-68.401299,-31.318199>, <-0.364230,0.681727,0.634496>
 <27.189699,-68.182999,-30.503201>, <-0.368785,0.681226,0.632400>
 <25.460600,-68.171097,-31.516300>, <-0.364249,0.681800,0.634406>
}
   smooth_triangle{ <27.189699,-68.182999,-30.503201>, <0.368785,-0.681226,-0.632400>
 <27.080000,-68.430702,-30.300501>, <0.368762,-0.681103,-0.632545>
 <25.374399,-68.401299,-31.318199>, <0.364230,-0.681727,-0.634496>
}
   smooth_triangle{ <27.189699,-68.182999,-30.503201>, <-0.368785,0.681226,0.632400>
 <25.374399,-68.401299,-31.318199>, <-0.364230,0.681727,0.634496>
 <27.080000,-68.430702,-30.300501>, <-0.368762,0.681103,0.632545>
}
   smooth_triangle{ <25.261000,-68.704803,-31.057301>, <0.364286,-0.681452,-0.634759>
 <25.374399,-68.401299,-31.318199>, <0.364230,-0.681727,-0.634496>
 <27.080000,-68.430702,-30.300501>, <0.368762,-0.681103,-0.632545>
}
   smooth_triangle{ <25.261000,-68.704803,-31.057301>, <-0.364286,0.681452,0.634759>
 <27.080000,-68.430702,-30.300501>, <-0.368762,0.681103,0.632545>
 <25.374399,-68.401299,-31.318199>, <-0.364230,0.681727,0.634496>
}
   smooth_triangle{ <27.080000,-68.430702,-30.300501>, <0.368762,-0.681103,-0.632545>
 <26.936100,-68.755501,-30.034700>, <0.368729,-0.681032,-0.632641>
 <25.261000,-68.704803,-31.057301>, <0.364286,-0.681452,-0.634759>
}
   smooth_triangle{ <27.080000,-68.430702,-30.300501>, <-0.368762,0.681103,0.632545>
 <25.261000,-68.704803,-31.057301>, <-0.364286,0.681452,0.634759>
 <26.936100,-68.755501,-30.034700>, <-0.368729,0.681032,0.632641>
}
   smooth_triangle{ <24.970100,-69.487099,-30.384501>, <0.364362,-0.681113,-0.635079>
 <25.261000,-68.704803,-31.057301>, <0.364286,-0.681452,-0.634759>
 <26.936100,-68.755501,-30.034700>, <0.368729,-0.681032,-0.632641>
}
   smooth_triangle{ <24.970100,-69.487099,-30.384501>, <-0.364362,0.681113,0.635079>
 <26.936100,-68.755501,-30.034700>, <-0.368729,0.681032,0.632641>
 <25.261000,-68.704803,-31.057301>, <-0.364286,0.681452,0.634759>
}
   smooth_triangle{ <26.936100,-68.755501,-30.034700>, <0.368729,-0.681032,-0.632641>
 <26.567900,-69.585602,-29.356199>, <0.368740,-0.680709,-0.632982>
 <24.970100,-69.487099,-30.384501>, <0.364362,-0.681113,-0.635079>
}
   smooth_triangle{ <26.936100,-68.755501,-30.034700>, <-0.368729,0.681032,0.632641>
 <24.970100,-69.487099,-30.384501>, <-0.364362,0.681113,0.635079>
 <26.567900,-69.585602,-29.356199>, <-0.368740,0.680709,0.632982>
}
   smooth_triangle{ <24.621700,-70.430000,-29.573500>, <0.364813,-0.680294,-0.635698>
 <24.970100,-69.487099,-30.384501>, <0.364362,-0.681113,-0.635079>
 <26.567900,-69.585602,-29.356199>, <0.368740,-0.680709,-0.632982>
}
   smooth_triangle{ <24.621700,-70.430000,-29.573500>, <-0.364813,0.680294,0.635698>
 <26.567900,-69.585602,-29.356199>, <-0.368740,0.680709,0.632982>
 <24.970100,-69.487099,-30.384501>, <-0.364362,0.681113,0.635079>
}
   smooth_triangle{ <26.567900,-69.585602,-29.356199>, <0.368740,-0.680709,-0.632982>
 <26.129601,-70.571800,-28.551600>, <0.368947,-0.680202,-0.633407>
 <24.621700,-70.430000,-29.573500>, <0.364813,-0.680294,-0.635698>
}
   smooth_triangle{ <26.567900,-69.585602,-29.356199>, <-0.368740,0.680709,0.632982>
 <24.621700,-70.430000,-29.573500>, <-0.364813,0.680294,0.635698>
 <26.129601,-70.571800,-28.551600>, <-0.368947,0.680202,0.633407>
}
   smooth_triangle{ <20.694700,-72.162201,-29.952499>, <0.358419,-0.678649,-0.641070>
 <21.014601,-70.172302,-31.885099>, <0.355800,-0.680506,-0.640561>
 <22.045500,-70.233803,-31.244400>, <0.358714,-0.680470,-0.638972>
}
   smooth_triangle{ <20.694700,-72.162201,-29.952499>, <-0.358419,0.678649,0.641070>
 <22.045500,-70.233803,-31.244400>, <-0.358714,0.680470,0.638972>
 <21.014601,-70.172302,-31.885099>, <-0.355800,0.680506,0.640561>
}
   smooth_triangle{ <22.045500,-70.233803,-31.244400>, <0.358714,-0.680470,-0.638972>
 <21.609200,-72.228600,-29.368700>, <0.360741,-0.678661,-0.639754>
 <20.694700,-72.162201,-29.952499>, <0.358419,-0.678649,-0.641070>
}
   smooth_triangle{ <22.045500,-70.233803,-31.244400>, <-0.358714,0.680470,0.638972>
 <20.694700,-72.162201,-29.952499>, <-0.358419,0.678649,0.641070>
 <21.609200,-72.228600,-29.368700>, <-0.360741,0.678661,0.639754>
}
   smooth_triangle{ <21.609200,-72.228600,-29.368700>, <0.360741,-0.678661,-0.639754>
 <22.045500,-70.233803,-31.244400>, <0.358714,-0.680470,-0.638972>
 <23.254200,-70.318497,-30.472401>, <0.361646,-0.680440,-0.637349>
}
   smooth_triangle{ <21.609200,-72.228600,-29.368700>, <-0.360741,0.678661,0.639754>
 <23.254200,-70.318497,-30.472401>, <-0.361646,0.680440,0.637349>
 <22.045500,-70.233803,-31.244400>, <-0.358714,0.680470,0.638972>
}
   smooth_triangle{ <23.254200,-70.318497,-30.472401>, <0.361646,-0.680440,-0.637349>
 <22.679800,-72.321701,-28.663200>, <0.363316,-0.678687,-0.638268>
 <21.609200,-72.228600,-29.368700>, <0.360741,-0.678661,-0.639754>
}
   smooth_triangle{ <23.254200,-70.318497,-30.472401>, <-0.361646,0.680440,0.637349>
 <21.609200,-72.228600,-29.368700>, <-0.360741,0.678661,0.639754>
 <22.679800,-72.321701,-28.663200>, <-0.363316,0.678687,0.638268>
}
   smooth_triangle{ <20.550699,-73.149498,-28.990499>, <0.360166,-0.676585,-0.642271>
 <20.694700,-72.162201,-29.952499>, <0.358419,-0.678649,-0.641070>
 <21.609200,-72.228600,-29.368700>, <0.360741,-0.678661,-0.639754>
}
   smooth_triangle{ <20.550699,-73.149498,-28.990499>, <-0.360166,0.676585,0.642271>
 <21.609200,-72.228600,-29.368700>, <-0.360741,0.678661,0.639754>
 <20.694700,-72.162201,-29.952499>, <-0.358419,0.678649,0.641070>
}
   smooth_triangle{ <21.609200,-72.228600,-29.368700>, <0.360741,-0.678661,-0.639754>
 <21.413700,-73.195396,-28.456100>, <0.362591,-0.676342,-0.641162>
 <20.550699,-73.149498,-28.990499>, <0.360166,-0.676585,-0.642271>
}
   smooth_triangle{ <21.609200,-72.228600,-29.368700>, <-0.360741,0.678661,0.639754>
 <20.550699,-73.149498,-28.990499>, <-0.360166,0.676585,0.642271>
 <21.413700,-73.195396,-28.456100>, <-0.362591,0.676342,0.641162>
}
   smooth_triangle{ <21.413700,-73.195396,-28.456100>, <0.362591,-0.676342,-0.641162>
 <21.609200,-72.228600,-29.368700>, <0.360741,-0.678661,-0.639754>
 <22.679800,-72.321701,-28.663200>, <0.363316,-0.678687,-0.638268>
}
   smooth_triangle{ <21.413700,-73.195396,-28.456100>, <-0.362591,0.676342,0.641162>
 <22.679800,-72.321701,-28.663200>, <-0.363316,0.678687,0.638268>
 <21.609200,-72.228600,-29.368700>, <-0.360741,0.678661,0.639754>
}
   smooth_triangle{ <22.679800,-72.321701,-28.663200>, <0.363316,-0.678687,-0.638268>
 <22.426300,-73.259003,-27.813601>, <0.365149,-0.676184,-0.639876>
 <21.413700,-73.195396,-28.456100>, <0.362591,-0.676342,-0.641162>
}
   smooth_triangle{ <22.679800,-72.321701,-28.663200>, <-0.363316,0.678687,0.638268>
 <21.413700,-73.195396,-28.456100>, <-0.362591,0.676342,0.641162>
 <22.426300,-73.259003,-27.813601>, <-0.365149,0.676184,0.639876>
}
   smooth_triangle{ <20.435600,-74.044701,-28.114901>, <0.359391,-0.678185,-0.641018>
 <20.550699,-73.149498,-28.990499>, <0.360166,-0.676585,-0.642271>
 <21.413700,-73.195396,-28.456100>, <0.362591,-0.676342,-0.641162>
}
   smooth_triangle{ <20.435600,-74.044701,-28.114901>, <-0.359391,0.678185,0.641018>
 <21.413700,-73.195396,-28.456100>, <-0.362591,0.676342,0.641162>
 <20.550699,-73.149498,-28.990499>, <-0.360166,0.676585,0.642271>
}
   smooth_triangle{ <21.413700,-73.195396,-28.456100>, <0.362591,-0.676342,-0.641162>
 <21.258499,-74.048203,-27.647499>, <0.362456,-0.676850,-0.640703>
 <20.435600,-74.044701,-28.114901>, <0.359391,-0.678185,-0.641018>
}
   smooth_triangle{ <21.413700,-73.195396,-28.456100>, <-0.362591,0.676342,0.641162>
 <20.435600,-74.044701,-28.114901>, <-0.359391,0.678185,0.641018>
 <21.258499,-74.048203,-27.647499>, <-0.362456,0.676850,0.640703>
}
   smooth_triangle{ <21.258499,-74.048203,-27.647499>, <0.362456,-0.676850,-0.640703>
 <21.413700,-73.195396,-28.456100>, <0.362591,-0.676342,-0.641162>
 <22.426300,-73.259003,-27.813601>, <0.365149,-0.676184,-0.639876>
}
   smooth_triangle{ <21.258499,-74.048203,-27.647499>, <-0.362456,0.676850,0.640703>
 <22.426300,-73.259003,-27.813601>, <-0.365149,0.676184,0.639876>
 <21.413700,-73.195396,-28.456100>, <-0.362591,0.676342,0.641162>
}
   smooth_triangle{ <22.426300,-73.259003,-27.813601>, <0.365149,-0.676184,-0.639876>
 <22.229500,-74.050201,-27.093201>, <0.365543,-0.675694,-0.640169>
 <21.258499,-74.048203,-27.647499>, <0.362456,-0.676850,-0.640703>
}
   smooth_triangle{ <22.426300,-73.259003,-27.813601>, <-0.365149,0.676184,0.639876>
 <21.258499,-74.048203,-27.647499>, <-0.362456,0.676850,0.640703>
 <22.229500,-74.050201,-27.093201>, <-0.365543,0.675694,0.640169>
}
   smooth_triangle{ <22.679800,-72.321701,-28.663200>, <0.363316,-0.678687,-0.638268>
 <23.254200,-70.318497,-30.472401>, <0.361646,-0.680440,-0.637349>
 <24.621700,-70.430000,-29.573500>, <0.364813,-0.680294,-0.635698>
}
   smooth_triangle{ <22.679800,-72.321701,-28.663200>, <-0.363316,0.678687,0.638268>
 <24.621700,-70.430000,-29.573500>, <-0.364813,0.680294,0.635698>
 <23.254200,-70.318497,-30.472401>, <-0.361646,0.680440,0.637349>
}
   smooth_triangle{ <24.621700,-70.430000,-29.573500>, <0.364813,-0.680294,-0.635698>
 <23.889200,-72.445999,-27.839199>, <0.366093,-0.678637,-0.636732>
 <22.679800,-72.321701,-28.663200>, <0.363316,-0.678687,-0.638268>
}
   smooth_triangle{ <24.621700,-70.430000,-29.573500>, <-0.364813,0.680294,0.635698>
 <22.679800,-72.321701,-28.663200>, <-0.363316,0.678687,0.638268>
 <23.889200,-72.445999,-27.839199>, <-0.366093,0.678637,0.636732>
}
   smooth_triangle{ <24.255501,-71.438004,-28.706400>, <0.366813,-0.679841,-0.635031>
 <24.621700,-70.430000,-29.573500>, <0.364813,-0.680294,-0.635698>
 <26.129601,-70.571800,-28.551600>, <0.368947,-0.680202,-0.633407>
}
   smooth_triangle{ <24.255501,-71.438004,-28.706400>, <-0.366813,0.679841,0.635031>
 <26.129601,-70.571800,-28.551600>, <-0.368947,0.680202,0.633407>
 <24.621700,-70.430000,-29.573500>, <-0.364813,0.680294,0.635698>
}
   smooth_triangle{ <26.129601,-70.571800,-28.551600>, <0.368947,-0.680202,-0.633407>
 <25.665501,-71.612396,-27.704800>, <0.369199,-0.679720,-0.633776>
 <24.255501,-71.438004,-28.706400>, <0.366813,-0.679841,-0.635031>
}
   smooth_triangle{ <26.129601,-70.571800,-28.551600>, <-0.368947,0.680202,0.633407>
 <24.255501,-71.438004,-28.706400>, <-0.366813,0.679841,0.635031>
 <25.665501,-71.612396,-27.704800>, <-0.369199,0.679720,0.633776>
}
   smooth_triangle{ <23.889200,-72.445999,-27.839199>, <0.366093,-0.678637,-0.636732>
 <24.255501,-71.438004,-28.706400>, <0.366813,-0.679841,-0.635031>
 <25.665501,-71.612396,-27.704800>, <0.369199,-0.679720,-0.633776>
}
   smooth_triangle{ <23.889200,-72.445999,-27.839199>, <-0.366093,0.678637,0.636732>
 <25.665501,-71.612396,-27.704800>, <-0.369199,0.679720,0.633776>
 <24.255501,-71.438004,-28.706400>, <-0.366813,0.679841,0.635031>
}
   smooth_triangle{ <25.665501,-71.612396,-27.704800>, <0.369199,-0.679720,-0.633776>
 <25.220400,-72.606102,-26.899700>, <0.369694,-0.678549,-0.634742>
 <23.889200,-72.445999,-27.839199>, <0.366093,-0.678637,-0.636732>
}
   smooth_triangle{ <25.665501,-71.612396,-27.704800>, <-0.369199,0.679720,0.633776>
 <23.889200,-72.445999,-27.839199>, <-0.366093,0.678637,0.636732>
 <25.220400,-72.606102,-26.899700>, <-0.369694,0.678549,0.634742>
}
   smooth_triangle{ <22.426300,-73.259003,-27.813601>, <0.365149,-0.676184,-0.639876>
 <22.679800,-72.321701,-28.663200>, <0.363316,-0.678687,-0.638268>
 <23.889200,-72.445999,-27.839199>, <0.366093,-0.678637,-0.636732>
}
   smooth_triangle{ <22.426300,-73.259003,-27.813601>, <-0.365149,0.676184,0.639876>
 <23.889200,-72.445999,-27.839199>, <-0.366093,0.678637,0.636732>
 <22.679800,-72.321701,-28.663200>, <-0.363316,0.678687,0.638268>
}
   smooth_triangle{ <23.889200,-72.445999,-27.839199>, <0.366093,-0.678637,-0.636732>
 <23.573000,-73.343399,-27.066900>, <0.367745,-0.676141,-0.638433>
 <22.426300,-73.259003,-27.813601>, <0.365149,-0.676184,-0.639876>
}
   smooth_triangle{ <23.889200,-72.445999,-27.839199>, <-0.366093,0.678637,0.636732>
 <22.426300,-73.259003,-27.813601>, <-0.365149,0.676184,0.639876>
 <23.573000,-73.343399,-27.066900>, <-0.367745,0.676141,0.638433>
}
   smooth_triangle{ <22.229500,-74.050201,-27.093201>, <0.365543,-0.675694,-0.640169>
 <22.426300,-73.259003,-27.813601>, <0.365149,-0.676184,-0.639876>
 <23.573000,-73.343399,-27.066900>, <0.367745,-0.676141,-0.638433>
}
   smooth_triangle{ <22.229500,-74.050201,-27.093201>, <-0.365543,0.675694,0.640169>
 <23.573000,-73.343399,-27.066900>, <-0.367745,0.676141,0.638433>
 <22.426300,-73.259003,-27.813601>, <-0.365149,0.676184,0.639876>
}
   smooth_triangle{ <23.573000,-73.343399,-27.066900>, <0.367745,-0.676141,-0.638433>
 <23.335800,-74.049896,-26.458599>, <0.368949,-0.674352,-0.639630>
 <22.229500,-74.050201,-27.093201>, <0.365543,-0.675694,-0.640169>
}
   smooth_triangle{ <23.573000,-73.343399,-27.066900>, <-0.367745,0.676141,0.638433>
 <22.229500,-74.050201,-27.093201>, <-0.365543,0.675694,0.640169>
 <23.335800,-74.049896,-26.458599>, <-0.368949,0.674352,0.639630>
}
   smooth_triangle{ <23.573000,-73.343399,-27.066900>, <0.367745,-0.676141,-0.638433>
 <23.889200,-72.445999,-27.839199>, <0.366093,-0.678637,-0.636732>
 <25.220400,-72.606102,-26.899700>, <0.369694,-0.678549,-0.634742>
}
   smooth_triangle{ <23.573000,-73.343399,-27.066900>, <-0.367745,0.676141,0.638433>
 <25.220400,-72.606102,-26.899700>, <-0.369694,0.678549,0.634742>
 <23.889200,-72.445999,-27.839199>, <-0.366093,0.678637,0.636732>
}
   smooth_triangle{ <25.220400,-72.606102,-26.899700>, <0.369694,-0.678549,-0.634742>
 <24.838499,-73.451202,-26.219999>, <0.370829,-0.676688,-0.636065>
 <23.573000,-73.343399,-27.066900>, <0.367745,-0.676141,-0.638433>
}
   smooth_triangle{ <25.220400,-72.606102,-26.899700>, <-0.369694,0.678549,0.634742>
 <23.573000,-73.343399,-27.066900>, <-0.367745,0.676141,0.638433>
 <24.838499,-73.451202,-26.219999>, <-0.370829,0.676688,0.636065>
}
   smooth_triangle{ <23.454399,-73.696701,-26.762800>, <0.370258,-0.674896,-0.638298>
 <23.573000,-73.343399,-27.066900>, <0.367745,-0.676141,-0.638433>
 <24.838499,-73.451202,-26.219999>, <0.370829,-0.676688,-0.636065>
}
   smooth_triangle{ <23.454399,-73.696701,-26.762800>, <-0.370258,0.674896,0.638298>
 <24.838499,-73.451202,-26.219999>, <-0.370829,0.676688,0.636065>
 <23.573000,-73.343399,-27.066900>, <-0.367745,0.676141,0.638433>
}
   smooth_triangle{ <24.838499,-73.451202,-26.219999>, <0.370829,-0.676688,-0.636065>
 <24.685301,-73.786400,-25.953400>, <0.371826,-0.674866,-0.637418>
 <23.454399,-73.696701,-26.762800>, <0.370258,-0.674896,-0.638298>
}
   smooth_triangle{ <24.838499,-73.451202,-26.219999>, <-0.370829,0.676688,0.636065>
 <23.454399,-73.696701,-26.762800>, <-0.370258,0.674896,0.638298>
 <24.685301,-73.786400,-25.953400>, <-0.371826,0.674866,0.637418>
}
   smooth_triangle{ <23.335800,-74.049896,-26.458599>, <0.368949,-0.674352,-0.639630>
 <23.454399,-73.696701,-26.762800>, <0.370258,-0.674896,-0.638298>
 <24.685301,-73.786400,-25.953400>, <0.371826,-0.674866,-0.637418>
}
   smooth_triangle{ <23.335800,-74.049896,-26.458599>, <-0.368949,0.674352,0.639630>
 <24.685301,-73.786400,-25.953400>, <-0.371826,0.674866,0.637418>
 <23.454399,-73.696701,-26.762800>, <-0.370258,0.674896,0.638298>
}
   smooth_triangle{ <24.685301,-73.786400,-25.953400>, <0.371826,-0.674866,-0.637418>
 <24.564699,-74.046402,-25.749500>, <0.372419,-0.673346,-0.638678>
 <23.335800,-74.049896,-26.458599>, <0.368949,-0.674352,-0.639630>
}
   smooth_triangle{ <24.685301,-73.786400,-25.953400>, <-0.371826,0.674866,0.637418>
 <23.335800,-74.049896,-26.458599>, <-0.368949,0.674352,0.639630>
 <24.564699,-74.046402,-25.749500>, <-0.372419,0.673346,0.638678>
}
   smooth_triangle{ <27.259501,-68.025101,-30.632601>, <0.368674,-0.681574,-0.632089>
 <27.284100,-67.969704,-30.677999>, <0.367841,-0.681780,-0.632352>
 <28.932199,-67.959503,-29.719999>, <0.372230,-0.681987,-0.629554>
}
   smooth_triangle{ <27.259501,-68.025101,-30.632601>, <-0.368674,0.681574,0.632089>
 <28.932199,-67.959503,-29.719999>, <-0.372230,0.681987,0.629554>
 <27.284100,-67.969704,-30.677999>, <-0.367841,0.681780,0.632352>
}
   smooth_triangle{ <28.932199,-67.959503,-29.719999>, <0.372230,-0.681987,-0.629554>
 <28.903500,-68.014099,-29.677799>, <0.373278,-0.681293,-0.629686>
 <27.259501,-68.025101,-30.632601>, <0.368674,-0.681574,-0.632089>
}
   smooth_triangle{ <28.932199,-67.959503,-29.719999>, <-0.372230,0.681987,0.629554>
 <27.259501,-68.025101,-30.632601>, <-0.368674,0.681574,0.632089>
 <28.903500,-68.014099,-29.677799>, <-0.373278,0.681293,0.629686>
}
   smooth_triangle{ <27.189699,-68.182999,-30.503201>, <0.368785,-0.681226,-0.632400>
 <27.259501,-68.025101,-30.632601>, <0.368674,-0.681574,-0.632089>
 <28.903500,-68.014099,-29.677799>, <0.373278,-0.681293,-0.629686>
}
   smooth_triangle{ <27.189699,-68.182999,-30.503201>, <-0.368785,0.681226,0.632400>
 <28.903500,-68.014099,-29.677799>, <-0.373278,0.681293,0.629686>
 <27.259501,-68.025101,-30.632601>, <-0.368674,0.681574,0.632089>
}
   smooth_triangle{ <28.903500,-68.014099,-29.677799>, <0.373278,-0.681293,-0.629686>
 <28.821600,-68.170403,-29.557400>, <0.373374,-0.681039,-0.629903>
 <27.189699,-68.182999,-30.503201>, <0.368785,-0.681226,-0.632400>
}
   smooth_triangle{ <28.903500,-68.014099,-29.677799>, <-0.373278,0.681293,0.629686>
 <27.189699,-68.182999,-30.503201>, <-0.368785,0.681226,0.632400>
 <28.821600,-68.170403,-29.557400>, <-0.373374,0.681039,0.629903>
}
   smooth_triangle{ <27.080000,-68.430702,-30.300501>, <0.368762,-0.681103,-0.632545>
 <27.189699,-68.182999,-30.503201>, <0.368785,-0.681226,-0.632400>
 <28.821600,-68.170403,-29.557400>, <0.373374,-0.681039,-0.629903>
}
   smooth_triangle{ <27.080000,-68.430702,-30.300501>, <-0.368762,0.681103,0.632545>
 <28.821600,-68.170403,-29.557400>, <-0.373374,0.681039,0.629903>
 <27.189699,-68.182999,-30.503201>, <-0.368785,0.681226,0.632400>
}
   smooth_triangle{ <28.821600,-68.170403,-29.557400>, <0.373374,-0.681039,-0.629903>
 <28.693001,-68.415604,-29.368500>, <0.373350,-0.681077,-0.629876>
 <27.080000,-68.430702,-30.300501>, <0.368762,-0.681103,-0.632545>
}
   smooth_triangle{ <28.821600,-68.170403,-29.557400>, <-0.373374,0.681039,0.629903>
 <27.080000,-68.430702,-30.300501>, <-0.368762,0.681103,0.632545>
 <28.693001,-68.415604,-29.368500>, <-0.373350,0.681077,0.629876>
}
   smooth_triangle{ <26.936100,-68.755501,-30.034700>, <0.368729,-0.681032,-0.632641>
 <27.080000,-68.430702,-30.300501>, <0.368762,-0.681103,-0.632545>
 <28.693001,-68.415604,-29.368500>, <0.373350,-0.681077,-0.629876>
}
   smooth_triangle{ <26.936100,-68.755501,-30.034700>, <-0.368729,0.681032,0.632641>
 <28.693001,-68.415604,-29.368500>, <-0.373350,0.681077,0.629876>
 <27.080000,-68.430702,-30.300501>, <-0.368762,0.681103,0.632545>
}
   smooth_triangle{ <28.693001,-68.415604,-29.368500>, <0.373350,-0.681077,-0.629876>
 <28.524200,-68.737198,-29.120701>, <0.373354,-0.680917,-0.630047>
 <26.936100,-68.755501,-30.034700>, <0.368729,-0.681032,-0.632641>
}
   smooth_triangle{ <28.693001,-68.415604,-29.368500>, <-0.373350,0.681077,0.629876>
 <26.936100,-68.755501,-30.034700>, <-0.368729,0.681032,0.632641>
 <28.524200,-68.737198,-29.120701>, <-0.373354,0.680917,0.630047>
}
   smooth_triangle{ <28.903500,-68.014099,-29.677799>, <0.373278,-0.681293,-0.629686>
 <28.932199,-67.959503,-29.719999>, <0.372230,-0.681987,-0.629554>
 <30.373600,-67.944504,-28.874599>, <0.377124,-0.681090,-0.627610>
}
   smooth_triangle{ <28.903500,-68.014099,-29.677799>, <-0.373278,0.681293,0.629686>
 <30.373600,-67.944504,-28.874599>, <-0.377124,0.681090,0.627610>
 <28.932199,-67.959503,-29.719999>, <-0.372230,0.681987,0.629554>
}
   smooth_triangle{ <30.373600,-67.944504,-28.874599>, <0.377124,-0.681090,-0.627610>
 <30.341101,-67.998901,-28.835199>, <0.377927,-0.680902,-0.627330>
 <28.903500,-68.014099,-29.677799>, <0.373278,-0.681293,-0.629686>
}
   smooth_triangle{ <30.373600,-67.944504,-28.874599>, <-0.377124,0.681090,0.627610>
 <28.903500,-68.014099,-29.677799>, <-0.373278,0.681293,0.629686>
 <30.341101,-67.998901,-28.835199>, <-0.377927,0.680902,0.627330>
}
   smooth_triangle{ <28.821600,-68.170403,-29.557400>, <0.373374,-0.681039,-0.629903>
 <28.903500,-68.014099,-29.677799>, <0.373278,-0.681293,-0.629686>
 <30.341101,-67.998901,-28.835199>, <0.377927,-0.680902,-0.627330>
}
   smooth_triangle{ <28.821600,-68.170403,-29.557400>, <-0.373374,0.681039,0.629903>
 <30.341101,-67.998901,-28.835199>, <-0.377927,0.680902,0.627330>
 <28.903500,-68.014099,-29.677799>, <-0.373278,0.681293,0.629686>
}
   smooth_triangle{ <30.341101,-67.998901,-28.835199>, <0.377927,-0.680902,-0.627330>
 <30.248501,-68.153900,-28.722500>, <0.377755,-0.681178,-0.627135>
 <28.821600,-68.170403,-29.557400>, <0.373374,-0.681039,-0.629903>
}
   smooth_triangle{ <30.341101,-67.998901,-28.835199>, <-0.377927,0.680902,0.627330>
 <28.821600,-68.170403,-29.557400>, <-0.373374,0.681039,0.629903>
 <30.248501,-68.153900,-28.722500>, <-0.377755,0.681178,0.627135>
}
   smooth_triangle{ <28.693001,-68.415604,-29.368500>, <0.373350,-0.681077,-0.629876>
 <28.821600,-68.170403,-29.557400>, <0.373374,-0.681039,-0.629903>
 <30.248501,-68.153900,-28.722500>, <0.377755,-0.681178,-0.627135>
}
   smooth_triangle{ <28.693001,-68.415604,-29.368500>, <-0.373350,0.681077,0.629876>
 <30.248501,-68.153900,-28.722500>, <-0.377755,0.681178,0.627135>
 <28.821600,-68.170403,-29.557400>, <-0.373374,0.681039,0.629903>
}
   smooth_triangle{ <30.248501,-68.153900,-28.722500>, <0.377755,-0.681178,-0.627135>
 <30.103399,-68.397102,-28.545799>, <0.377721,-0.681023,-0.627324>
 <28.693001,-68.415604,-29.368500>, <0.373350,-0.681077,-0.629876>
}
   smooth_triangle{ <30.248501,-68.153900,-28.722500>, <-0.377755,0.681178,0.627135>
 <28.693001,-68.415604,-29.368500>, <-0.373350,0.681077,0.629876>
 <30.103399,-68.397102,-28.545799>, <-0.377721,0.681023,0.627324>
}
   smooth_triangle{ <28.524200,-68.737198,-29.120701>, <0.373354,-0.680917,-0.630047>
 <28.693001,-68.415604,-29.368500>, <0.373350,-0.681077,-0.629876>
 <30.103399,-68.397102,-28.545799>, <0.377721,-0.681023,-0.627324>
}
   smooth_triangle{ <28.524200,-68.737198,-29.120701>, <-0.373354,0.680917,0.630047>
 <30.103399,-68.397102,-28.545799>, <-0.377721,0.681023,0.627324>
 <28.693001,-68.415604,-29.368500>, <-0.373350,0.681077,0.629876>
}
   smooth_triangle{ <30.103399,-68.397102,-28.545799>, <0.377721,-0.681023,-0.627324>
 <29.912701,-68.716698,-28.313801>, <0.377644,-0.680766,-0.627648>
 <28.524200,-68.737198,-29.120701>, <0.373354,-0.680917,-0.630047>
}
   smooth_triangle{ <30.103399,-68.397102,-28.545799>, <-0.377721,0.681023,0.627324>
 <28.524200,-68.737198,-29.120701>, <-0.373354,0.680917,0.630047>
 <29.912701,-68.716698,-28.313801>, <-0.377644,0.680766,0.627648>
}
   smooth_triangle{ <26.567900,-69.585602,-29.356199>, <0.368740,-0.680709,-0.632982>
 <26.936100,-68.755501,-30.034700>, <0.368729,-0.681032,-0.632641>
 <28.524200,-68.737198,-29.120701>, <0.373354,-0.680917,-0.630047>
}
   smooth_triangle{ <26.567900,-69.585602,-29.356199>, <-0.368740,0.680709,0.632982>
 <28.524200,-68.737198,-29.120701>, <-0.373354,0.680917,0.630047>
 <26.936100,-68.755501,-30.034700>, <-0.368729,0.681032,0.632641>
}
   smooth_triangle{ <28.524200,-68.737198,-29.120701>, <0.373354,-0.680917,-0.630047>
 <28.091999,-69.560303,-28.487499>, <0.373354,-0.680581,-0.630409>
 <26.567900,-69.585602,-29.356199>, <0.368740,-0.680709,-0.632982>
}
   smooth_triangle{ <28.524200,-68.737198,-29.120701>, <-0.373354,0.680917,0.630047>
 <26.567900,-69.585602,-29.356199>, <-0.368740,0.680709,0.632982>
 <28.091999,-69.560303,-28.487499>, <-0.373354,0.680581,0.630409>
}
   smooth_triangle{ <26.129601,-70.571800,-28.551600>, <0.368947,-0.680202,-0.633407>
 <26.567900,-69.585602,-29.356199>, <0.368740,-0.680709,-0.632982>
 <28.091999,-69.560303,-28.487499>, <0.373354,-0.680581,-0.630409>
}
   smooth_triangle{ <26.129601,-70.571800,-28.551600>, <-0.368947,0.680202,0.633407>
 <28.091999,-69.560303,-28.487499>, <-0.373354,0.680581,0.630409>
 <26.567900,-69.585602,-29.356199>, <-0.368740,0.680709,0.632982>
}
   smooth_triangle{ <28.091999,-69.560303,-28.487499>, <0.373354,-0.680581,-0.630409>
 <27.576700,-70.540398,-27.735001>, <0.373345,-0.680195,-0.630831>
 <26.129601,-70.571800,-28.551600>, <0.368947,-0.680202,-0.633407>
}
   smooth_triangle{ <28.091999,-69.560303,-28.487499>, <-0.373354,0.680581,0.630409>
 <26.129601,-70.571800,-28.551600>, <-0.368947,0.680202,0.633407>
 <27.576700,-70.540398,-27.735001>, <-0.373345,0.680195,0.630831>
}
   smooth_triangle{ <28.091999,-69.560303,-28.487499>, <0.373354,-0.680581,-0.630409>
 <28.524200,-68.737198,-29.120701>, <0.373354,-0.680917,-0.630047>
 <29.912701,-68.716698,-28.313801>, <0.377644,-0.680766,-0.627648>
}
   smooth_triangle{ <28.091999,-69.560303,-28.487499>, <-0.373354,0.680581,0.630409>
 <29.912701,-68.716698,-28.313801>, <-0.377644,0.680766,0.627648>
 <28.524200,-68.737198,-29.120701>, <-0.373354,0.680917,0.630047>
}
   smooth_triangle{ <29.912701,-68.716698,-28.313801>, <0.377644,-0.680766,-0.627648>
 <29.424200,-69.535103,-27.720100>, <0.377423,-0.680551,-0.628014>
 <28.091999,-69.560303,-28.487499>, <0.373354,-0.680581,-0.630409>
}
   smooth_triangle{ <29.912701,-68.716698,-28.313801>, <-0.377644,0.680766,0.627648>
 <28.091999,-69.560303,-28.487499>, <-0.373354,0.680581,0.630409>
 <29.424200,-69.535103,-27.720100>, <-0.377423,0.680551,0.628014>
}
   smooth_triangle{ <27.576700,-70.540398,-27.735001>, <0.373345,-0.680195,-0.630831>
 <28.091999,-69.560303,-28.487499>, <0.373354,-0.680581,-0.630409>
 <29.424200,-69.535103,-27.720100>, <0.377423,-0.680551,-0.628014>
}
   smooth_triangle{ <27.576700,-70.540398,-27.735001>, <-0.373345,0.680195,0.630831>
 <29.424200,-69.535103,-27.720100>, <-0.377423,0.680551,0.628014>
 <28.091999,-69.560303,-28.487499>, <-0.373354,0.680581,0.630409>
}
   smooth_triangle{ <29.424200,-69.535103,-27.720100>, <0.377423,-0.680551,-0.628014>
 <28.841499,-70.511002,-27.013000>, <0.377154,-0.680095,-0.628669>
 <27.576700,-70.540398,-27.735001>, <0.373345,-0.680195,-0.630831>
}
   smooth_triangle{ <29.424200,-69.535103,-27.720100>, <-0.377423,0.680551,0.628014>
 <27.576700,-70.540398,-27.735001>, <-0.373345,0.680195,0.630831>
 <28.841499,-70.511002,-27.013000>, <-0.377154,0.680095,0.628669>
}
   smooth_triangle{ <30.341101,-67.998901,-28.835199>, <0.377927,-0.680902,-0.627330>
 <30.373600,-67.944504,-28.874599>, <0.377124,-0.681090,-0.627610>
 <31.604000,-67.926804,-28.146601>, <0.381660,-0.680745,-0.625238>
}
   smooth_triangle{ <30.341101,-67.998901,-28.835199>, <-0.377927,0.680902,0.627330>
 <31.604000,-67.926804,-28.146601>, <-0.381660,0.680745,0.625238>
 <30.373600,-67.944504,-28.874599>, <-0.377124,0.681090,0.627610>
}
   smooth_triangle{ <31.604000,-67.926804,-28.146601>, <0.381660,-0.680745,-0.625238>
 <31.568300,-67.980904,-28.109501>, <0.382217,-0.681000,-0.624620>
 <30.341101,-67.998901,-28.835199>, <0.377927,-0.680902,-0.627330>
}
   smooth_triangle{ <31.604000,-67.926804,-28.146601>, <-0.381660,0.680745,0.625238>
 <30.341101,-67.998901,-28.835199>, <-0.377927,0.680902,0.627330>
 <31.568300,-67.980904,-28.109501>, <-0.382217,0.681000,0.624620>
}
   smooth_triangle{ <30.248501,-68.153900,-28.722500>, <0.377755,-0.681178,-0.627135>
 <30.341101,-67.998901,-28.835199>, <0.377927,-0.680902,-0.627330>
 <31.568300,-67.980904,-28.109501>, <0.382217,-0.681000,-0.624620>
}
   smooth_triangle{ <30.248501,-68.153900,-28.722500>, <-0.377755,0.681178,0.627135>
 <31.568300,-67.980904,-28.109501>, <-0.382217,0.681000,0.624620>
 <30.341101,-67.998901,-28.835199>, <-0.377927,0.680902,0.627330>
}
   smooth_triangle{ <31.568300,-67.980904,-28.109501>, <0.382217,-0.681000,-0.624620>
 <31.466700,-68.135101,-28.003500>, <0.382055,-0.681127,-0.624579>
 <30.248501,-68.153900,-28.722500>, <0.377755,-0.681178,-0.627135>
}
   smooth_triangle{ <31.568300,-67.980904,-28.109501>, <-0.382217,0.681000,0.624620>
 <30.248501,-68.153900,-28.722500>, <-0.377755,0.681178,0.627135>
 <31.466700,-68.135101,-28.003500>, <-0.382055,0.681127,0.624579>
}
   smooth_triangle{ <30.103399,-68.397102,-28.545799>, <0.377721,-0.681023,-0.627324>
 <30.248501,-68.153900,-28.722500>, <0.377755,-0.681178,-0.627135>
 <31.466700,-68.135101,-28.003500>, <0.382055,-0.681127,-0.624579>
}
   smooth_triangle{ <30.103399,-68.397102,-28.545799>, <-0.377721,0.681023,0.627324>
 <31.466700,-68.135101,-28.003500>, <-0.382055,0.681127,0.624579>
 <30.248501,-68.153900,-28.722500>, <-0.377755,0.681178,0.627135>
}
   smooth_triangle{ <31.466700,-68.135101,-28.003500>, <0.382055,-0.681127,-0.624579>
 <31.307199,-68.377197,-27.837000>, <0.381974,-0.680947,-0.624826>
 <30.103399,-68.397102,-28.545799>, <0.377721,-0.681023,-0.627324>
}
   smooth_triangle{ <31.466700,-68.135101,-28.003500>, <-0.382055,0.681127,0.624579>
 <30.103399,-68.397102,-28.545799>, <-0.377721,0.681023,0.627324>
 <31.307199,-68.377197,-27.837000>, <-0.381974,0.680947,0.624826>
}
   smooth_triangle{ <29.912701,-68.716698,-28.313801>, <0.377644,-0.680766,-0.627648>
 <30.103399,-68.397102,-28.545799>, <0.377721,-0.681023,-0.627324>
 <31.307199,-68.377197,-27.837000>, <0.381974,-0.680947,-0.624826>
}
   smooth_triangle{ <29.912701,-68.716698,-28.313801>, <-0.377644,0.680766,0.627648>
 <31.307199,-68.377197,-27.837000>, <-0.381974,0.680947,0.624826>
 <30.103399,-68.397102,-28.545799>, <-0.377721,0.681023,0.627324>
}
   smooth_triangle{ <31.307199,-68.377197,-27.837000>, <0.381974,-0.680947,-0.624826>
 <31.097799,-68.695396,-27.618401>, <0.381821,-0.680740,-0.625144>
 <29.912701,-68.716698,-28.313801>, <0.377644,-0.680766,-0.627648>
}
   smooth_triangle{ <31.307199,-68.377197,-27.837000>, <-0.381974,0.680947,0.624826>
 <29.912701,-68.716698,-28.313801>, <-0.377644,0.680766,0.627648>
 <31.097799,-68.695396,-27.618401>, <-0.381821,0.680740,0.625144>
}
   smooth_triangle{ <31.568300,-67.980904,-28.109501>, <0.382217,-0.681000,-0.624620>
 <31.604000,-67.926804,-28.146601>, <0.381660,-0.680745,-0.625238>
 <32.619598,-67.908203,-27.540600>, <0.385782,-0.680975,-0.622452>
}
   smooth_triangle{ <31.568300,-67.980904,-28.109501>, <-0.382217,0.681000,0.624620>
 <32.619598,-67.908203,-27.540600>, <-0.385782,0.680975,0.622452>
 <31.604000,-67.926804,-28.146601>, <-0.381660,0.680745,0.625238>
}
   smooth_triangle{ <32.619598,-67.908203,-27.540600>, <0.385782,-0.680975,-0.622452>
 <32.581299,-67.962097,-27.505400>, <0.386391,-0.681085,-0.621953>
 <31.568300,-67.980904,-28.109501>, <0.382217,-0.681000,-0.624620>
}
   smooth_triangle{ <32.619598,-67.908203,-27.540600>, <-0.385782,0.680975,0.622452>
 <31.568300,-67.980904,-28.109501>, <-0.382217,0.681000,0.624620>
 <32.581299,-67.962097,-27.505400>, <-0.386391,0.681085,0.621953>
}
   smooth_triangle{ <31.466700,-68.135101,-28.003500>, <0.382055,-0.681127,-0.624579>
 <31.568300,-67.980904,-28.109501>, <0.382217,-0.681000,-0.624620>
 <32.581299,-67.962097,-27.505400>, <0.386391,-0.681085,-0.621953>
}
   smooth_triangle{ <31.466700,-68.135101,-28.003500>, <-0.382055,0.681127,0.624579>
 <32.581299,-67.962097,-27.505400>, <-0.386391,0.681085,0.621953>
 <31.568300,-67.980904,-28.109501>, <-0.382217,0.681000,0.624620>
}
   smooth_triangle{ <32.581299,-67.962097,-27.505400>, <0.386391,-0.681085,-0.621953>
 <32.472198,-68.115799,-27.404800>, <0.386218,-0.681119,-0.622022>
 <31.466700,-68.135101,-28.003500>, <0.382055,-0.681127,-0.624579>
}
   smooth_triangle{ <32.581299,-67.962097,-27.505400>, <-0.386391,0.681085,0.621953>
 <31.466700,-68.135101,-28.003500>, <-0.382055,0.681127,0.624579>
 <32.472198,-68.115799,-27.404800>, <-0.386218,0.681119,0.622022>
}
   smooth_triangle{ <31.307199,-68.377197,-27.837000>, <0.381974,-0.680947,-0.624826>
 <31.466700,-68.135101,-28.003500>, <0.382055,-0.681127,-0.624579>
 <32.472198,-68.115799,-27.404800>, <0.386218,-0.681119,-0.622022>
}
   smooth_triangle{ <31.307199,-68.377197,-27.837000>, <-0.381974,0.680947,0.624826>
 <32.472198,-68.115799,-27.404800>, <-0.386218,0.681119,0.622022>
 <31.466700,-68.135101,-28.003500>, <-0.382055,0.681127,0.624579>
}
   smooth_triangle{ <32.472198,-68.115799,-27.404800>, <0.386218,-0.681119,-0.622022>
 <32.300800,-68.357300,-27.246799>, <0.386062,-0.680975,-0.622277>
 <31.307199,-68.377197,-27.837000>, <0.381974,-0.680947,-0.624826>
}
   smooth_triangle{ <32.472198,-68.115799,-27.404800>, <-0.386218,0.681119,0.622022>
 <31.307199,-68.377197,-27.837000>, <-0.381974,0.680947,0.624826>
 <32.300800,-68.357300,-27.246799>, <-0.386062,0.680975,0.622277>
}
   smooth_triangle{ <31.097799,-68.695396,-27.618401>, <0.381821,-0.680740,-0.625144>
 <31.307199,-68.377197,-27.837000>, <0.381974,-0.680947,-0.624826>
 <32.300800,-68.357300,-27.246799>, <0.386062,-0.680975,-0.622277>
}
   smooth_triangle{ <31.097799,-68.695396,-27.618401>, <-0.381821,0.680740,0.625144>
 <32.300800,-68.357300,-27.246799>, <-0.386062,0.680975,0.622277>
 <31.307199,-68.377197,-27.837000>, <-0.381974,0.680947,0.624826>
}
   smooth_triangle{ <32.300800,-68.357300,-27.246799>, <0.386062,-0.680975,-0.622277>
 <32.075802,-68.674599,-27.039200>, <0.385815,-0.680798,-0.622624>
 <31.097799,-68.695396,-27.618401>, <0.381821,-0.680740,-0.625144>
}
   smooth_triangle{ <32.300800,-68.357300,-27.246799>, <-0.386062,0.680975,0.622277>
 <31.097799,-68.695396,-27.618401>, <-0.381821,0.680740,0.625144>
 <32.075802,-68.674599,-27.039200>, <-0.385815,0.680798,0.622624>
}
   smooth_triangle{ <29.424200,-69.535103,-27.720100>, <0.377423,-0.680551,-0.628014>
 <29.912701,-68.716698,-28.313801>, <0.377644,-0.680766,-0.627648>
 <31.097799,-68.695396,-27.618401>, <0.381821,-0.680740,-0.625144>
}
   smooth_triangle{ <29.424200,-69.535103,-27.720100>, <-0.377423,0.680551,0.628014>
 <31.097799,-68.695396,-27.618401>, <-0.381821,0.680740,0.625144>
 <29.912701,-68.716698,-28.313801>, <-0.377644,0.680766,0.627648>
}
   smooth_triangle{ <31.097799,-68.695396,-27.618401>, <0.381821,-0.680740,-0.625144>
 <30.561100,-69.510696,-27.058399>, <0.381395,-0.680484,-0.625683>
 <29.424200,-69.535103,-27.720100>, <0.377423,-0.680551,-0.628014>
}
   smooth_triangle{ <31.097799,-68.695396,-27.618401>, <-0.381821,0.680740,0.625144>
 <29.424200,-69.535103,-27.720100>, <-0.377423,0.680551,0.628014>
 <30.561100,-69.510696,-27.058399>, <-0.381395,0.680484,0.625683>
}
   smooth_triangle{ <30.561100,-69.510696,-27.058399>, <0.381395,-0.680484,-0.625683>
 <31.097799,-68.695396,-27.618401>, <0.381821,-0.680740,-0.625144>
 <32.075802,-68.674599,-27.039200>, <0.385815,-0.680798,-0.622624>
}
   smooth_triangle{ <30.561100,-69.510696,-27.058399>, <-0.381395,0.680484,0.625683>
 <32.075802,-68.674599,-27.039200>, <-0.385815,0.680798,0.622624>
 <31.097799,-68.695396,-27.618401>, <-0.381821,0.680740,0.625144>
}
   smooth_triangle{ <32.075802,-68.674599,-27.039200>, <0.385815,-0.680798,-0.622624>
 <31.499201,-69.488297,-26.507000>, <0.385240,-0.680437,-0.623374>
 <30.561100,-69.510696,-27.058399>, <0.381395,-0.680484,-0.625683>
}
   smooth_triangle{ <32.075802,-68.674599,-27.039200>, <-0.385815,0.680798,0.622624>
 <30.561100,-69.510696,-27.058399>, <-0.381395,0.680484,0.625683>
 <31.499201,-69.488297,-26.507000>, <-0.385240,0.680437,0.623374>
}
   smooth_triangle{ <28.841499,-70.511002,-27.013000>, <0.377154,-0.680095,-0.628669>
 <29.424200,-69.535103,-27.720100>, <0.377423,-0.680551,-0.628014>
 <30.561100,-69.510696,-27.058399>, <0.381395,-0.680484,-0.625683>
}
   smooth_triangle{ <28.841499,-70.511002,-27.013000>, <-0.377154,0.680095,0.628669>
 <30.561100,-69.510696,-27.058399>, <-0.381395,0.680484,0.625683>
 <29.424200,-69.535103,-27.720100>, <-0.377423,0.680551,0.628014>
}
   smooth_triangle{ <30.561100,-69.510696,-27.058399>, <0.381395,-0.680484,-0.625683>
 <29.920799,-70.484100,-26.390499>, <0.380874,-0.679982,-0.626546>
 <28.841499,-70.511002,-27.013000>, <0.377154,-0.680095,-0.628669>
}
   smooth_triangle{ <30.561100,-69.510696,-27.058399>, <-0.381395,0.680484,0.625683>
 <28.841499,-70.511002,-27.013000>, <-0.377154,0.680095,0.628669>
 <29.920799,-70.484100,-26.390499>, <-0.380874,0.679982,0.626546>
}
   smooth_triangle{ <29.920799,-70.484100,-26.390499>, <0.380874,-0.679982,-0.626546>
 <30.561100,-69.510696,-27.058399>, <0.381395,-0.680484,-0.625683>
 <31.499201,-69.488297,-26.507000>, <0.385240,-0.680437,-0.623374>
}
   smooth_triangle{ <29.920799,-70.484100,-26.390499>, <-0.380874,0.679982,0.626546>
 <31.499201,-69.488297,-26.507000>, <-0.385240,0.680437,0.623374>
 <30.561100,-69.510696,-27.058399>, <-0.381395,0.680484,0.625683>
}
   smooth_triangle{ <31.499201,-69.488297,-26.507000>, <0.385240,-0.680437,-0.623374>
 <30.811100,-70.460701,-25.871201>, <0.384477,-0.679851,-0.624484>
 <29.920799,-70.484100,-26.390499>, <0.380874,-0.679982,-0.626546>
}
   smooth_triangle{ <31.499201,-69.488297,-26.507000>, <-0.385240,0.680437,0.623374>
 <29.920799,-70.484100,-26.390499>, <-0.380874,0.679982,0.626546>
 <30.811100,-70.460701,-25.871201>, <-0.384477,0.679851,0.624484>
}
   smooth_triangle{ <32.581299,-67.962097,-27.505400>, <0.386391,-0.681085,-0.621953>
 <32.619598,-67.908203,-27.540600>, <0.385782,-0.680975,-0.622452>
 <33.416401,-67.890503,-27.061199>, <0.389819,-0.681230,-0.619651>
}
   smooth_triangle{ <32.581299,-67.962097,-27.505400>, <-0.386391,0.681085,0.621953>
 <33.416401,-67.890503,-27.061199>, <-0.389819,0.681230,0.619651>
 <32.619598,-67.908203,-27.540600>, <-0.385782,0.680975,0.622452>
}
   smooth_triangle{ <33.416401,-67.890503,-27.061199>, <0.389819,-0.681230,-0.619651>
 <33.375999,-67.944298,-27.027500>, <0.390415,-0.681360,-0.619132>
 <32.581299,-67.962097,-27.505400>, <0.386391,-0.681085,-0.621953>
}
   smooth_triangle{ <33.416401,-67.890503,-27.061199>, <-0.389819,0.681230,0.619651>
 <32.581299,-67.962097,-27.505400>, <-0.386391,0.681085,0.621953>
 <33.375999,-67.944298,-27.027500>, <-0.390415,0.681360,0.619132>
}
   smooth_triangle{ <32.472198,-68.115799,-27.404800>, <0.386218,-0.681119,-0.622022>
 <32.581299,-67.962097,-27.505400>, <0.386391,-0.681085,-0.621953>
 <33.375999,-67.944298,-27.027500>, <0.390415,-0.681360,-0.619132>
}
   smooth_triangle{ <32.472198,-68.115799,-27.404800>, <-0.386218,0.681119,0.622022>
 <33.375999,-67.944298,-27.027500>, <-0.390415,0.681360,0.619132>
 <32.581299,-67.962097,-27.505400>, <-0.386391,0.681085,0.621953>
}
   smooth_triangle{ <33.375999,-67.944298,-27.027500>, <0.390415,-0.681360,-0.619132>
 <33.261002,-68.097801,-26.931200>, <0.390321,-0.681128,-0.619446>
 <32.472198,-68.115799,-27.404800>, <0.386218,-0.681119,-0.622022>
}
   smooth_triangle{ <33.375999,-67.944298,-27.027500>, <-0.390415,0.681360,0.619132>
 <32.472198,-68.115799,-27.404800>, <-0.386218,0.681119,0.622022>
 <33.261002,-68.097801,-26.931200>, <-0.390321,0.681128,0.619446>
}
   smooth_triangle{ <32.300800,-68.357300,-27.246799>, <0.386062,-0.680975,-0.622277>
 <32.472198,-68.115799,-27.404800>, <0.386218,-0.681119,-0.622022>
 <33.261002,-68.097801,-26.931200>, <0.390321,-0.681128,-0.619446>
}
   smooth_triangle{ <32.300800,-68.357300,-27.246799>, <-0.386062,0.680975,0.622277>
 <33.261002,-68.097801,-26.931200>, <-0.390321,0.681128,0.619446>
 <32.472198,-68.115799,-27.404800>, <-0.386218,0.681119,0.622022>
}
   smooth_triangle{ <33.261002,-68.097801,-26.931200>, <0.390321,-0.681128,-0.619446>
 <33.080200,-68.338997,-26.779800>, <0.390005,-0.681115,-0.619660>
 <32.300800,-68.357300,-27.246799>, <0.386062,-0.680975,-0.622277>
}
   smooth_triangle{ <33.261002,-68.097801,-26.931200>, <-0.390321,0.681128,0.619446>
 <32.300800,-68.357300,-27.246799>, <-0.386062,0.680975,0.622277>
 <33.080200,-68.338997,-26.779800>, <-0.390005,0.681115,0.619660>
}
   smooth_triangle{ <32.075802,-68.674599,-27.039200>, <0.385815,-0.680798,-0.622624>
 <32.300800,-68.357300,-27.246799>, <0.386062,-0.680975,-0.622277>
 <33.080200,-68.338997,-26.779800>, <0.390005,-0.681115,-0.619660>
}
   smooth_triangle{ <32.075802,-68.674599,-27.039200>, <-0.385815,0.680798,0.622624>
 <33.080200,-68.338997,-26.779800>, <-0.390005,0.681115,0.619660>
 <32.300800,-68.357300,-27.246799>, <-0.386062,0.680975,0.622277>
}
   smooth_triangle{ <33.080200,-68.338997,-26.779800>, <0.390005,-0.681115,-0.619660>
 <32.842999,-68.655899,-26.580799>, <0.389633,-0.680884,-0.620148>
 <32.075802,-68.674599,-27.039200>, <0.385815,-0.680798,-0.622624>
}
   smooth_triangle{ <33.080200,-68.338997,-26.779800>, <-0.390005,0.681115,0.619660>
 <32.075802,-68.674599,-27.039200>, <-0.385815,0.680798,0.622624>
 <32.842999,-68.655899,-26.580799>, <-0.389633,0.680884,0.620148>
}
   smooth_triangle{ <33.375999,-67.944298,-27.027500>, <0.390415,-0.681360,-0.619132>
 <33.416401,-67.890503,-27.061199>, <0.389819,-0.681230,-0.619651>
 <33.990501,-67.875504,-26.712999>, <0.393473,-0.682137,-0.616334>
}
   smooth_triangle{ <33.375999,-67.944298,-27.027500>, <-0.390415,0.681360,0.619132>
 <33.990501,-67.875504,-26.712999>, <-0.393473,0.682137,0.616334>
 <33.416401,-67.890503,-27.061199>, <-0.389819,0.681230,0.619651>
}
   smooth_triangle{ <33.990501,-67.875504,-26.712999>, <0.393473,-0.682137,-0.616334>
 <33.948601,-67.929199,-26.680300>, <0.394230,-0.681575,-0.616472>
 <33.375999,-67.944298,-27.027500>, <0.390415,-0.681360,-0.619132>
}
   smooth_triangle{ <33.990501,-67.875504,-26.712999>, <-0.393473,0.682137,0.616334>
 <33.375999,-67.944298,-27.027500>, <-0.390415,0.681360,0.619132>
 <33.948601,-67.929199,-26.680300>, <-0.394230,0.681575,0.616472>
}
   smooth_triangle{ <33.261002,-68.097801,-26.931200>, <0.390321,-0.681128,-0.619446>
 <33.375999,-67.944298,-27.027500>, <0.390415,-0.681360,-0.619132>
 <33.948601,-67.929199,-26.680300>, <0.394230,-0.681575,-0.616472>
}
   smooth_triangle{ <33.261002,-68.097801,-26.931200>, <-0.390321,0.681128,0.619446>
 <33.948601,-67.929199,-26.680300>, <-0.394230,0.681575,0.616472>
 <33.375999,-67.944298,-27.027500>, <-0.390415,0.681360,0.619132>
}
   smooth_triangle{ <33.948601,-67.929199,-26.680300>, <0.394230,-0.681575,-0.616472>
 <33.829300,-68.082802,-26.587000>, <0.394129,-0.681282,-0.616861>
 <33.261002,-68.097801,-26.931200>, <0.390321,-0.681128,-0.619446>
}
   smooth_triangle{ <33.948601,-67.929199,-26.680300>, <-0.394230,0.681575,0.616472>
 <33.261002,-68.097801,-26.931200>, <-0.390321,0.681128,0.619446>
 <33.829300,-68.082802,-26.587000>, <-0.394129,0.681282,0.616861>
}
   smooth_triangle{ <33.080200,-68.338997,-26.779800>, <0.390005,-0.681115,-0.619660>
 <33.261002,-68.097801,-26.931200>, <0.390321,-0.681128,-0.619446>
 <33.829300,-68.082802,-26.587000>, <0.394129,-0.681282,-0.616861>
}
   smooth_triangle{ <33.080200,-68.338997,-26.779800>, <-0.390005,0.681115,0.619660>
 <33.829300,-68.082802,-26.587000>, <-0.394129,0.681282,0.616861>
 <33.261002,-68.097801,-26.931200>, <-0.390321,0.681128,0.619446>
}
   smooth_triangle{ <33.829300,-68.082802,-26.587000>, <0.394129,-0.681282,-0.616861>
 <33.641800,-68.323997,-26.440399>, <0.393788,-0.681278,-0.617082>
 <33.080200,-68.338997,-26.779800>, <0.390005,-0.681115,-0.619660>
}
   smooth_triangle{ <33.829300,-68.082802,-26.587000>, <-0.394129,0.681282,0.616861>
 <33.080200,-68.338997,-26.779800>, <-0.390005,0.681115,0.619660>
 <33.641800,-68.323997,-26.440399>, <-0.393788,0.681278,0.617082>
}
   smooth_triangle{ <32.842999,-68.655899,-26.580799>, <0.389633,-0.680884,-0.620148>
 <33.080200,-68.338997,-26.779800>, <0.390005,-0.681115,-0.619660>
 <33.641800,-68.323997,-26.440399>, <0.393788,-0.681278,-0.617082>
}
   smooth_triangle{ <32.842999,-68.655899,-26.580799>, <-0.389633,0.680884,0.620148>
 <33.641800,-68.323997,-26.440399>, <-0.393788,0.681278,0.617082>
 <33.080200,-68.338997,-26.779800>, <-0.390005,0.681115,0.619660>
}
   smooth_triangle{ <33.641800,-68.323997,-26.440399>, <0.393788,-0.681278,-0.617082>
 <33.395699,-68.640900,-26.247601>, <0.393333,-0.681125,-0.617542>
 <32.842999,-68.655899,-26.580799>, <0.389633,-0.680884,-0.620148>
}
   smooth_triangle{ <33.641800,-68.323997,-26.440399>, <-0.393788,0.681278,0.617082>
 <32.842999,-68.655899,-26.580799>, <-0.389633,0.680884,0.620148>
 <33.395699,-68.640900,-26.247601>, <-0.393333,0.681125,0.617542>
}
   smooth_triangle{ <33.948601,-67.929199,-26.680300>, <0.394230,-0.681575,-0.616472>
 <33.990501,-67.875504,-26.712999>, <0.393473,-0.682137,-0.616334>
 <34.337898,-67.865097,-26.500700>, <0.397057,-0.681880,-0.614318>
}
   smooth_triangle{ <33.948601,-67.929199,-26.680300>, <-0.394230,0.681575,0.616472>
 <34.337898,-67.865097,-26.500700>, <-0.397057,0.681880,0.614318>
 <33.990501,-67.875504,-26.712999>, <-0.393473,0.682137,0.616334>
}
   smooth_triangle{ <34.337898,-67.865097,-26.500700>, <0.397057,-0.681880,-0.614318>
 <34.294998,-67.918900,-26.468800>, <0.397710,-0.681778,-0.614007>
 <33.948601,-67.929199,-26.680300>, <0.394230,-0.681575,-0.616472>
}
   smooth_triangle{ <34.337898,-67.865097,-26.500700>, <-0.397057,0.681880,0.614318>
 <33.948601,-67.929199,-26.680300>, <-0.394230,0.681575,0.616472>
 <34.294998,-67.918900,-26.468800>, <-0.397710,0.681778,0.614007>
}
   smooth_triangle{ <33.829300,-68.082802,-26.587000>, <0.394129,-0.681282,-0.616861>
 <33.948601,-67.929199,-26.680300>, <0.394230,-0.681575,-0.616472>
 <34.294998,-67.918900,-26.468800>, <0.397710,-0.681778,-0.614007>
}
   smooth_triangle{ <33.829300,-68.082802,-26.587000>, <-0.394129,0.681282,0.616861>
 <34.294998,-67.918900,-26.468800>, <-0.397710,0.681778,0.614007>
 <33.948601,-67.929199,-26.680300>, <-0.394230,0.681575,0.616472>
}
   smooth_triangle{ <34.294998,-67.918900,-26.468800>, <0.397710,-0.681778,-0.614007>
 <34.173100,-68.072403,-26.377300>, <0.397478,-0.681693,-0.614253>
 <33.829300,-68.082802,-26.587000>, <0.394129,-0.681282,-0.616861>
}
   smooth_triangle{ <34.294998,-67.918900,-26.468800>, <-0.397710,0.681778,0.614007>
 <33.829300,-68.082802,-26.587000>, <-0.394129,0.681282,0.616861>
 <34.173100,-68.072403,-26.377300>, <-0.397478,0.681693,0.614253>
}
   smooth_triangle{ <34.294998,-67.918900,-26.468800>, <0.397710,-0.681778,-0.614007>
 <34.337898,-67.865097,-26.500700>, <0.397057,-0.681880,-0.614318>
 <34.454498,-67.861298,-26.429001>, <0.399222,-0.682273,-0.612475>
}
   smooth_triangle{ <34.294998,-67.918900,-26.468800>, <-0.397710,0.681778,0.614007>
 <34.454498,-67.861298,-26.429001>, <-0.371515,0.675059,0.637394>
 <34.337898,-67.865097,-26.500700>, <-0.397057,0.681880,0.614318>
}
   smooth_triangle{ <34.454498,-67.861298,-26.429001>, <0.399222,-0.682273,-0.612475>
 <34.411400,-67.915001,-26.397200>, <0.399234,-0.682183,-0.612567>
 <34.294998,-67.918900,-26.468800>, <0.397710,-0.681778,-0.614007>
}
   smooth_triangle{ <34.454498,-67.861298,-26.429001>, <-0.371515,0.675059,0.637394>
 <34.294998,-67.918900,-26.468800>, <-0.397710,0.681778,0.614007>
 <34.411400,-67.915001,-26.397200>, <-0.357742,0.670784,0.649669>
}
   smooth_triangle{ <34.173100,-68.072403,-26.377300>, <0.397478,-0.681693,-0.614253>
 <34.294998,-67.918900,-26.468800>, <0.397710,-0.681778,-0.614007>
 <34.411400,-67.915001,-26.397200>, <0.399234,-0.682183,-0.612567>
}
   smooth_triangle{ <34.173100,-68.072403,-26.377300>, <-0.397478,0.681693,0.614253>
 <34.411400,-67.915001,-26.397200>, <-0.357742,0.670784,0.649669>
 <34.294998,-67.918900,-26.468800>, <-0.397710,0.681778,0.614007>
}
   smooth_triangle{ <34.411400,-67.915001,-26.397200>, <0.399234,-0.682183,-0.612567>
 <34.288601,-68.068703,-26.306299>, <0.398915,-0.681933,-0.613053>
 <34.173100,-68.072403,-26.377300>, <0.397478,-0.681693,-0.614253>
}
   smooth_triangle{ <34.411400,-67.915001,-26.397200>, <-0.357742,0.670784,0.649669>
 <34.173100,-68.072403,-26.377300>, <-0.397478,0.681693,0.614253>
 <34.288601,-68.068703,-26.306299>, <-0.357411,0.670626,0.650014>
}
   smooth_triangle{ <33.641800,-68.323997,-26.440399>, <0.393788,-0.681278,-0.617082>
 <33.829300,-68.082802,-26.587000>, <0.394129,-0.681282,-0.616861>
 <34.173100,-68.072403,-26.377300>, <0.397478,-0.681693,-0.614253>
}
   smooth_triangle{ <33.641800,-68.323997,-26.440399>, <-0.393788,0.681278,0.617082>
 <34.173100,-68.072403,-26.377300>, <-0.397478,0.681693,0.614253>
 <33.829300,-68.082802,-26.587000>, <-0.394129,0.681282,0.616861>
}
   smooth_triangle{ <34.173100,-68.072403,-26.377300>, <0.397478,-0.681693,-0.614253>
 <33.981499,-68.313698,-26.233500>, <0.397261,-0.681756,-0.614323>
 <33.641800,-68.323997,-26.440399>, <0.393788,-0.681278,-0.617082>
}
   smooth_triangle{ <34.173100,-68.072403,-26.377300>, <-0.397478,0.681693,0.614253>
 <33.641800,-68.323997,-26.440399>, <-0.393788,0.681278,0.617082>
 <33.981499,-68.313698,-26.233500>, <-0.397261,0.681756,0.614323>
}
   smooth_triangle{ <33.981499,-68.313698,-26.233500>, <0.397261,-0.681756,-0.614323>
 <34.173100,-68.072403,-26.377300>, <0.397478,-0.681693,-0.614253>
 <34.288601,-68.068703,-26.306299>, <0.398915,-0.681933,-0.613053>
}
   smooth_triangle{ <33.981499,-68.313698,-26.233500>, <-0.397261,0.681756,0.614323>
 <34.288601,-68.068703,-26.306299>, <-0.357411,0.670626,0.650014>
 <34.173100,-68.072403,-26.377300>, <-0.397478,0.681693,0.614253>
}
   smooth_triangle{ <34.288601,-68.068703,-26.306299>, <0.398915,-0.681933,-0.613053>
 <34.095600,-68.309898,-26.163401>, <0.398932,-0.682070,-0.612890>
 <33.981499,-68.313698,-26.233500>, <0.397261,-0.681756,-0.614323>
}
   smooth_triangle{ <34.288601,-68.068703,-26.306299>, <-0.357411,0.670626,0.650014>
 <33.981499,-68.313698,-26.233500>, <-0.397261,0.681756,0.614323>
 <34.095600,-68.309898,-26.163401>, <-0.357949,0.670805,0.649533>
}
   smooth_triangle{ <33.395699,-68.640900,-26.247601>, <0.393333,-0.681125,-0.617542>
 <33.641800,-68.323997,-26.440399>, <0.393788,-0.681278,-0.617082>
 <33.981499,-68.313698,-26.233500>, <0.397261,-0.681756,-0.614323>
}
   smooth_triangle{ <33.395699,-68.640900,-26.247601>, <-0.393333,0.681125,0.617542>
 <33.981499,-68.313698,-26.233500>, <-0.397261,0.681756,0.614323>
 <33.641800,-68.323997,-26.440399>, <-0.393788,0.681278,0.617082>
}
   smooth_triangle{ <33.981499,-68.313698,-26.233500>, <0.397261,-0.681756,-0.614323>
 <33.730000,-68.630699,-26.044399>, <0.396832,-0.681554,-0.614824>
 <33.395699,-68.640900,-26.247601>, <0.393333,-0.681125,-0.617542>
}
   smooth_triangle{ <33.981499,-68.313698,-26.233500>, <-0.397261,0.681756,0.614323>
 <33.395699,-68.640900,-26.247601>, <-0.393333,0.681125,0.617542>
 <33.730000,-68.630699,-26.044399>, <-0.396832,0.681554,0.614824>
}
   smooth_triangle{ <33.730000,-68.630699,-26.044399>, <0.396832,-0.681554,-0.614824>
 <33.981499,-68.313698,-26.233500>, <0.397261,-0.681756,-0.614323>
 <34.095600,-68.309898,-26.163401>, <0.398932,-0.682070,-0.612890>
}
   smooth_triangle{ <33.730000,-68.630699,-26.044399>, <-0.396832,0.681554,0.614824>
 <34.095600,-68.309898,-26.163401>, <-0.357949,0.670805,0.649533>
 <33.981499,-68.313698,-26.233500>, <-0.397261,0.681756,0.614323>
}
   smooth_triangle{ <34.095600,-68.309898,-26.163401>, <0.398932,-0.682070,-0.612890>
 <33.842201,-68.626999,-25.975599>, <0.398129,-0.681679,-0.613846>
 <33.730000,-68.630699,-26.044399>, <0.396832,-0.681554,-0.614824>
}
   smooth_triangle{ <34.095600,-68.309898,-26.163401>, <-0.357949,0.670805,0.649533>
 <33.730000,-68.630699,-26.044399>, <-0.396832,0.681554,0.614824>
 <33.842201,-68.626999,-25.975599>, <-0.358209,0.670762,0.649434>
}
   smooth_triangle{ <31.499201,-69.488297,-26.507000>, <0.385240,-0.680437,-0.623374>
 <32.075802,-68.674599,-27.039200>, <0.385815,-0.680798,-0.622624>
 <32.842999,-68.655899,-26.580799>, <0.389633,-0.680884,-0.620148>
}
   smooth_triangle{ <31.499201,-69.488297,-26.507000>, <-0.385240,0.680437,0.623374>
 <32.842999,-68.655899,-26.580799>, <-0.389633,0.680884,0.620148>
 <32.075802,-68.674599,-27.039200>, <-0.385815,0.680798,0.622624>
}
   smooth_triangle{ <32.842999,-68.655899,-26.580799>, <0.389633,-0.680884,-0.620148>
 <32.235001,-69.469002,-26.070299>, <0.388916,-0.680517,-0.621000>
 <31.499201,-69.488297,-26.507000>, <0.385240,-0.680437,-0.623374>
}
   smooth_triangle{ <32.842999,-68.655899,-26.580799>, <-0.389633,0.680884,0.620148>
 <31.499201,-69.488297,-26.507000>, <-0.385240,0.680437,0.623374>
 <32.235001,-69.469002,-26.070299>, <-0.388916,0.680517,0.621000>
}
   smooth_triangle{ <32.235001,-69.469002,-26.070299>, <0.388916,-0.680517,-0.621000>
 <32.842999,-68.655899,-26.580799>, <0.389633,-0.680884,-0.620148>
 <33.395699,-68.640900,-26.247601>, <0.393333,-0.681125,-0.617542>
}
   smooth_triangle{ <32.235001,-69.469002,-26.070299>, <-0.388916,0.680517,0.621000>
 <33.395699,-68.640900,-26.247601>, <-0.393333,0.681125,0.617542>
 <32.842999,-68.655899,-26.580799>, <-0.389633,0.680884,0.620148>
}
   smooth_triangle{ <33.395699,-68.640900,-26.247601>, <0.393333,-0.681125,-0.617542>
 <32.764900,-69.454002,-25.752701>, <0.392427,-0.680732,-0.618550>
 <32.235001,-69.469002,-26.070299>, <0.388916,-0.680517,-0.621000>
}
   smooth_triangle{ <33.395699,-68.640900,-26.247601>, <-0.393333,0.681125,0.617542>
 <32.235001,-69.469002,-26.070299>, <-0.388916,0.680517,0.621000>
 <32.764900,-69.454002,-25.752701>, <-0.392427,0.680732,0.618550>
}
   smooth_triangle{ <32.764900,-69.454002,-25.752701>, <0.392427,-0.680732,-0.618550>
 <33.395699,-68.640900,-26.247601>, <0.393333,-0.681125,-0.617542>
 <33.730000,-68.630699,-26.044399>, <0.396832,-0.681554,-0.614824>
}
   smooth_triangle{ <32.764900,-69.454002,-25.752701>, <-0.392427,0.680732,0.618550>
 <33.730000,-68.630699,-26.044399>, <-0.396832,0.681554,0.614824>
 <33.395699,-68.640900,-26.247601>, <-0.393333,0.681125,0.617542>
}
   smooth_triangle{ <33.730000,-68.630699,-26.044399>, <0.396832,-0.681554,-0.614824>
 <33.085400,-69.444099,-25.559000>, <0.395698,-0.681106,-0.616050>
 <32.764900,-69.454002,-25.752701>, <0.392427,-0.680732,-0.618550>
}
   smooth_triangle{ <33.730000,-68.630699,-26.044399>, <-0.396832,0.681554,0.614824>
 <32.764900,-69.454002,-25.752701>, <-0.392427,0.680732,0.618550>
 <33.085400,-69.444099,-25.559000>, <-0.395698,0.681106,0.616050>
}
   smooth_triangle{ <33.085400,-69.444099,-25.559000>, <0.395698,-0.681106,-0.616050>
 <33.730000,-68.630699,-26.044399>, <0.396832,-0.681554,-0.614824>
 <33.842201,-68.626999,-25.975599>, <0.398129,-0.681679,-0.613846>
}
   smooth_triangle{ <33.085400,-69.444099,-25.559000>, <-0.395698,0.681106,0.616050>
 <33.842201,-68.626999,-25.975599>, <-0.358209,0.670762,0.649434>
 <33.730000,-68.630699,-26.044399>, <-0.396832,0.681554,0.614824>
}
   smooth_triangle{ <33.842201,-68.626999,-25.975599>, <0.398129,-0.681679,-0.613846>
 <33.193100,-69.440598,-25.493299>, <0.396559,-0.681121,-0.615480>
 <33.085400,-69.444099,-25.559000>, <0.395698,-0.681106,-0.616050>
}
   smooth_triangle{ <33.842201,-68.626999,-25.975599>, <-0.358209,0.670762,0.649434>
 <33.085400,-69.444099,-25.559000>, <-0.395698,0.681106,0.616050>
 <33.193100,-69.440598,-25.493299>, <-0.358567,0.670754,0.649245>
}
   smooth_triangle{ <30.811100,-70.460701,-25.871201>, <0.384477,-0.679851,-0.624484>
 <31.499201,-69.488297,-26.507000>, <0.385240,-0.680437,-0.623374>
 <32.235001,-69.469002,-26.070299>, <0.388916,-0.680517,-0.621000>
}
   smooth_triangle{ <30.811100,-70.460701,-25.871201>, <-0.384477,0.679851,0.624484>
 <32.235001,-69.469002,-26.070299>, <-0.388916,0.680517,0.621000>
 <31.499201,-69.488297,-26.507000>, <-0.385240,0.680437,0.623374>
}
   smooth_triangle{ <32.235001,-69.469002,-26.070299>, <0.388916,-0.680517,-0.621000>
 <31.509399,-70.441200,-25.459700>, <0.387841,-0.679838,-0.622414>
 <30.811100,-70.460701,-25.871201>, <0.384477,-0.679851,-0.624484>
}
   smooth_triangle{ <32.235001,-69.469002,-26.070299>, <-0.388916,0.680517,0.621000>
 <30.811100,-70.460701,-25.871201>, <-0.384477,0.679851,0.624484>
 <31.509399,-70.441200,-25.459700>, <-0.387841,0.679838,0.622414>
}
   smooth_triangle{ <31.509399,-70.441200,-25.459700>, <0.387841,-0.679838,-0.622414>
 <32.235001,-69.469002,-26.070299>, <0.388916,-0.680517,-0.621000>
 <32.764900,-69.454002,-25.752701>, <0.392427,-0.680732,-0.618550>
}
   smooth_triangle{ <31.509399,-70.441200,-25.459700>, <-0.387841,0.679838,0.622414>
 <32.764900,-69.454002,-25.752701>, <-0.392427,0.680732,0.618550>
 <32.235001,-69.469002,-26.070299>, <-0.388916,0.680517,0.621000>
}
   smooth_triangle{ <32.764900,-69.454002,-25.752701>, <0.392427,-0.680732,-0.618550>
 <32.012199,-70.426399,-25.160500>, <0.391118,-0.680021,-0.620159>
 <31.509399,-70.441200,-25.459700>, <0.387841,-0.679838,-0.622414>
}
   smooth_triangle{ <32.764900,-69.454002,-25.752701>, <-0.392427,0.680732,0.618550>
 <31.509399,-70.441200,-25.459700>, <-0.387841,0.679838,0.622414>
 <32.012199,-70.426399,-25.160500>, <-0.391118,0.680021,0.620159>
}
   smooth_triangle{ <32.012199,-70.426399,-25.160500>, <0.391118,-0.680021,-0.620159>
 <32.764900,-69.454002,-25.752701>, <0.392427,-0.680732,-0.618550>
 <33.085400,-69.444099,-25.559000>, <0.395698,-0.681106,-0.616050>
}
   smooth_triangle{ <32.012199,-70.426399,-25.160500>, <-0.391118,0.680021,0.620159>
 <33.085400,-69.444099,-25.559000>, <-0.395698,0.681106,0.616050>
 <32.764900,-69.454002,-25.752701>, <-0.392427,0.680732,0.618550>
}
   smooth_triangle{ <33.085400,-69.444099,-25.559000>, <0.395698,-0.681106,-0.616050>
 <32.316299,-70.417000,-24.977699>, <0.395472,-0.681088,-0.616215>
 <32.012199,-70.426399,-25.160500>, <0.391118,-0.680021,-0.620159>
}
   smooth_triangle{ <33.085400,-69.444099,-25.559000>, <-0.395698,0.681106,0.616050>
 <32.012199,-70.426399,-25.160500>, <-0.391118,0.680021,0.620159>
 <32.316299,-70.417000,-24.977699>, <-0.395472,0.681088,0.616215>
}
   smooth_triangle{ <32.316299,-70.417000,-24.977699>, <0.395472,-0.681088,-0.616215>
 <33.085400,-69.444099,-25.559000>, <0.395698,-0.681106,-0.616050>
 <33.193100,-69.440598,-25.493299>, <0.396559,-0.681121,-0.615480>
}
   smooth_triangle{ <32.316299,-70.417000,-24.977699>, <-0.395472,0.681088,0.616215>
 <33.193100,-69.440598,-25.493299>, <-0.358567,0.670754,0.649245>
 <33.085400,-69.444099,-25.559000>, <-0.395698,0.681106,0.616050>
}
   smooth_triangle{ <33.193100,-69.440598,-25.493299>, <0.396559,-0.681121,-0.615480>
 <32.418400,-70.413803,-24.915800>, <0.384273,-0.678023,-0.626593>
 <32.316299,-70.417000,-24.977699>, <0.395472,-0.681088,-0.616215>
}
   smooth_triangle{ <33.193100,-69.440598,-25.493299>, <-0.358567,0.670754,0.649245>
 <32.316299,-70.417000,-24.977699>, <-0.395472,0.681088,0.616215>
 <32.418400,-70.413803,-24.915800>, <-0.353659,0.669296,0.653428>
}
   smooth_triangle{ <25.665501,-71.612396,-27.704800>, <0.369199,-0.679720,-0.633776>
 <26.129601,-70.571800,-28.551600>, <0.368947,-0.680202,-0.633407>
 <27.576700,-70.540398,-27.735001>, <0.373345,-0.680195,-0.630831>
}
   smooth_triangle{ <25.665501,-71.612396,-27.704800>, <-0.369199,0.679720,0.633776>
 <27.576700,-70.540398,-27.735001>, <-0.373345,0.680195,0.630831>
 <26.129601,-70.571800,-28.551600>, <-0.368947,0.680202,0.633407>
}
   smooth_triangle{ <27.576700,-70.540398,-27.735001>, <0.373345,-0.680195,-0.630831>
 <27.030300,-71.577797,-26.940399>, <0.373363,-0.679533,-0.631534>
 <25.665501,-71.612396,-27.704800>, <0.369199,-0.679720,-0.633776>
}
   smooth_triangle{ <27.576700,-70.540398,-27.735001>, <-0.373345,0.680195,0.630831>
 <25.665501,-71.612396,-27.704800>, <-0.369199,0.679720,0.633776>
 <27.030300,-71.577797,-26.940399>, <-0.373363,0.679533,0.631534>
}
   smooth_triangle{ <25.220400,-72.606102,-26.899700>, <0.369694,-0.678549,-0.634742>
 <25.665501,-71.612396,-27.704800>, <0.369199,-0.679720,-0.633776>
 <27.030300,-71.577797,-26.940399>, <0.373363,-0.679533,-0.631534>
}
   smooth_triangle{ <25.220400,-72.606102,-26.899700>, <-0.369694,0.678549,0.634742>
 <27.030300,-71.577797,-26.940399>, <-0.373363,0.679533,0.631534>
 <25.665501,-71.612396,-27.704800>, <-0.369199,0.679720,0.633776>
}
   smooth_triangle{ <27.030300,-71.577797,-26.940399>, <0.373363,-0.679533,-0.631534>
 <26.504700,-72.573196,-26.181101>, <0.373547,-0.678531,-0.632501>
 <25.220400,-72.606102,-26.899700>, <0.369694,-0.678549,-0.634742>
}
   smooth_triangle{ <27.030300,-71.577797,-26.940399>, <-0.373363,0.679533,0.631534>
 <25.220400,-72.606102,-26.899700>, <-0.369694,0.678549,0.634742>
 <26.504700,-72.573196,-26.181101>, <-0.373547,0.678531,0.632501>
}
   smooth_triangle{ <27.030300,-71.577797,-26.940399>, <0.373363,-0.679533,-0.631534>
 <27.576700,-70.540398,-27.735001>, <0.373345,-0.680195,-0.630831>
 <28.841499,-70.511002,-27.013000>, <0.377154,-0.680095,-0.628669>
}
   smooth_triangle{ <27.030300,-71.577797,-26.940399>, <-0.373363,0.679533,0.631534>
 <28.841499,-70.511002,-27.013000>, <-0.377154,0.680095,0.628669>
 <27.576700,-70.540398,-27.735001>, <-0.373345,0.680195,0.630831>
}
   smooth_triangle{ <28.841499,-70.511002,-27.013000>, <0.377154,-0.680095,-0.628669>
 <28.223101,-71.546501,-26.264601>, <0.376907,-0.679438,-0.629528>
 <27.030300,-71.577797,-26.940399>, <0.373363,-0.679533,-0.631534>
}
   smooth_triangle{ <28.841499,-70.511002,-27.013000>, <-0.377154,0.680095,0.628669>
 <27.030300,-71.577797,-26.940399>, <-0.373363,0.679533,0.631534>
 <28.223101,-71.546501,-26.264601>, <-0.376907,0.679438,0.629528>
}
   smooth_triangle{ <26.504700,-72.573196,-26.181101>, <0.373547,-0.678531,-0.632501>
 <27.030300,-71.577797,-26.940399>, <0.373363,-0.679533,-0.631534>
 <28.223101,-71.546501,-26.264601>, <0.376907,-0.679438,-0.629528>
}
   smooth_triangle{ <26.504700,-72.573196,-26.181101>, <-0.373547,0.678531,0.632501>
 <28.223101,-71.546501,-26.264601>, <-0.376907,0.679438,0.629528>
 <27.030300,-71.577797,-26.940399>, <-0.373363,0.679533,0.631534>
}
   smooth_triangle{ <28.223101,-71.546501,-26.264601>, <0.376907,-0.679438,-0.629528>
 <27.627199,-72.543800,-25.545799>, <0.376848,-0.678423,-0.630656>
 <26.504700,-72.573196,-26.181101>, <0.373547,-0.678531,-0.632501>
}
   smooth_triangle{ <28.223101,-71.546501,-26.264601>, <-0.376907,0.679438,0.629528>
 <26.504700,-72.573196,-26.181101>, <-0.373547,0.678531,0.632501>
 <27.627199,-72.543800,-25.545799>, <-0.376848,0.678423,0.630656>
}
   smooth_triangle{ <24.838499,-73.451202,-26.219999>, <0.370829,-0.676688,-0.636065>
 <25.220400,-72.606102,-26.899700>, <0.369694,-0.678549,-0.634742>
 <26.504700,-72.573196,-26.181101>, <0.373547,-0.678531,-0.632501>
}
   smooth_triangle{ <24.838499,-73.451202,-26.219999>, <-0.370829,0.676688,0.636065>
 <26.504700,-72.573196,-26.181101>, <-0.373547,0.678531,0.632501>
 <25.220400,-72.606102,-26.899700>, <-0.369694,0.678549,0.634742>
}
   smooth_triangle{ <26.504700,-72.573196,-26.181101>, <0.373547,-0.678531,-0.632501>
 <26.051701,-73.427002,-25.534201>, <0.374022,-0.676867,-0.634002>
 <24.838499,-73.451202,-26.219999>, <0.370829,-0.676688,-0.636065>
}
   smooth_triangle{ <26.504700,-72.573196,-26.181101>, <-0.373547,0.678531,0.632501>
 <24.838499,-73.451202,-26.219999>, <-0.370829,0.676688,0.636065>
 <26.051701,-73.427002,-25.534201>, <-0.374022,0.676867,0.634002>
}
   smooth_triangle{ <24.685301,-73.786400,-25.953400>, <0.371826,-0.674866,-0.637418>
 <24.838499,-73.451202,-26.219999>, <0.370829,-0.676688,-0.636065>
 <26.051701,-73.427002,-25.534201>, <0.374022,-0.676867,-0.634002>
}
   smooth_triangle{ <24.685301,-73.786400,-25.953400>, <-0.371826,0.674866,0.637418>
 <26.051701,-73.427002,-25.534201>, <-0.374022,0.676867,0.634002>
 <24.838499,-73.451202,-26.219999>, <-0.370829,0.676688,0.636065>
}
   smooth_triangle{ <26.051701,-73.427002,-25.534201>, <0.374022,-0.676867,-0.634002>
 <25.868601,-73.769798,-25.277201>, <0.374880,-0.674772,-0.635726>
 <24.685301,-73.786400,-25.953400>, <0.371826,-0.674866,-0.637418>
}
   smooth_triangle{ <26.051701,-73.427002,-25.534201>, <-0.374022,0.676867,0.634002>
 <24.685301,-73.786400,-25.953400>, <-0.371826,0.674866,0.637418>
 <25.868601,-73.769798,-25.277201>, <-0.374880,0.674772,0.635726>
}
   smooth_triangle{ <24.564699,-74.046402,-25.749500>, <0.372419,-0.673346,-0.638678>
 <24.685301,-73.786400,-25.953400>, <0.371826,-0.674866,-0.637418>
 <25.868601,-73.769798,-25.277201>, <0.374880,-0.674772,-0.635726>
}
   smooth_triangle{ <24.564699,-74.046402,-25.749500>, <-0.372419,0.673346,0.638678>
 <25.868601,-73.769798,-25.277201>, <-0.374880,0.674772,0.635726>
 <24.685301,-73.786400,-25.953400>, <-0.371826,0.674866,0.637418>
}
   smooth_triangle{ <25.868601,-73.769798,-25.277201>, <0.374880,-0.674772,-0.635726>
 <25.723301,-74.040001,-25.077000>, <0.375546,-0.673294,-0.636899>
 <24.564699,-74.046402,-25.749500>, <0.372419,-0.673346,-0.638678>
}
   smooth_triangle{ <25.868601,-73.769798,-25.277201>, <-0.374880,0.674772,0.635726>
 <24.564699,-74.046402,-25.749500>, <-0.372419,0.673346,0.638678>
 <25.723301,-74.040001,-25.077000>, <-0.375546,0.673294,0.636899>
}
   smooth_triangle{ <26.051701,-73.427002,-25.534201>, <0.374022,-0.676867,-0.634002>
 <26.504700,-72.573196,-26.181101>, <0.373547,-0.678531,-0.632501>
 <27.627199,-72.543800,-25.545799>, <0.376848,-0.678423,-0.630656>
}
   smooth_triangle{ <26.051701,-73.427002,-25.534201>, <-0.374022,0.676867,0.634002>
 <27.627199,-72.543800,-25.545799>, <-0.376848,0.678423,0.630656>
 <26.504700,-72.573196,-26.181101>, <-0.373547,0.678531,0.632501>
}
   smooth_triangle{ <27.627199,-72.543800,-25.545799>, <0.376848,-0.678423,-0.630656>
 <27.112499,-73.404800,-24.928801>, <0.377139,-0.676938,-0.632077>
 <26.051701,-73.427002,-25.534201>, <0.374022,-0.676867,-0.634002>
}
   smooth_triangle{ <27.627199,-72.543800,-25.545799>, <-0.376848,0.678423,0.630656>
 <26.051701,-73.427002,-25.534201>, <-0.374022,0.676867,0.634002>
 <27.112499,-73.404800,-24.928801>, <-0.377139,0.676938,0.632077>
}
   smooth_triangle{ <25.868601,-73.769798,-25.277201>, <0.374880,-0.674772,-0.635726>
 <26.051701,-73.427002,-25.534201>, <0.374022,-0.676867,-0.634002>
 <27.112499,-73.404800,-24.928801>, <0.377139,-0.676938,-0.632077>
}
   smooth_triangle{ <25.868601,-73.769798,-25.277201>, <-0.374880,0.674772,0.635726>
 <27.112499,-73.404800,-24.928801>, <-0.377139,0.676938,0.632077>
 <26.051701,-73.427002,-25.534201>, <-0.374022,0.676867,0.634002>
}
   smooth_triangle{ <27.112499,-73.404800,-24.928801>, <0.377139,-0.676938,-0.632077>
 <26.903700,-73.753403,-24.680700>, <0.377893,-0.674917,-0.633786>
 <25.868601,-73.769798,-25.277201>, <0.374880,-0.674772,-0.635726>
}
   smooth_triangle{ <27.112499,-73.404800,-24.928801>, <-0.377139,0.676938,0.632077>
 <25.868601,-73.769798,-25.277201>, <-0.374880,0.674772,0.635726>
 <26.903700,-73.753403,-24.680700>, <-0.377893,0.674917,0.633786>
}
   smooth_triangle{ <25.723301,-74.040001,-25.077000>, <0.375546,-0.673294,-0.636899>
 <25.868601,-73.769798,-25.277201>, <0.374880,-0.674772,-0.635726>
 <26.903700,-73.753403,-24.680700>, <0.377893,-0.674917,-0.633786>
}
   smooth_triangle{ <25.723301,-74.040001,-25.077000>, <-0.375546,0.673294,0.636899>
 <26.903700,-73.753403,-24.680700>, <-0.377893,0.674917,0.633786>
 <25.868601,-73.769798,-25.277201>, <-0.374880,0.674772,0.635726>
}
   smooth_triangle{ <26.903700,-73.753403,-24.680700>, <0.377893,-0.674917,-0.633786>
 <26.737200,-74.031403,-24.484900>, <0.378511,-0.673457,-0.634968>
 <25.723301,-74.040001,-25.077000>, <0.375546,-0.673294,-0.636899>
}
   smooth_triangle{ <26.903700,-73.753403,-24.680700>, <-0.377893,0.674917,0.633786>
 <25.723301,-74.040001,-25.077000>, <-0.375546,0.673294,0.636899>
 <26.737200,-74.031403,-24.484900>, <-0.378511,0.673457,0.634968>
}
   smooth_triangle{ <28.223101,-71.546501,-26.264601>, <0.376907,-0.679438,-0.629528>
 <28.841499,-70.511002,-27.013000>, <0.377154,-0.680095,-0.628669>
 <29.920799,-70.484100,-26.390499>, <0.380874,-0.679982,-0.626546>
}
   smooth_triangle{ <28.223101,-71.546501,-26.264601>, <-0.376907,0.679438,0.629528>
 <29.920799,-70.484100,-26.390499>, <-0.380874,0.679982,0.626546>
 <28.841499,-70.511002,-27.013000>, <-0.377154,0.680095,0.628669>
}
   smooth_triangle{ <29.920799,-70.484100,-26.390499>, <0.380874,-0.679982,-0.626546>
 <29.242399,-71.516800,-25.682699>, <0.380252,-0.679294,-0.627669>
 <28.223101,-71.546501,-26.264601>, <0.376907,-0.679438,-0.629528>
}
   smooth_triangle{ <29.920799,-70.484100,-26.390499>, <-0.380874,0.679982,0.626546>
 <28.223101,-71.546501,-26.264601>, <-0.376907,0.679438,0.629528>
 <29.242399,-71.516800,-25.682699>, <-0.380252,0.679294,0.627669>
}
   smooth_triangle{ <29.242399,-71.516800,-25.682699>, <0.380252,-0.679294,-0.627669>
 <29.920799,-70.484100,-26.390499>, <0.380874,-0.679982,-0.626546>
 <30.811100,-70.460701,-25.871201>, <0.384477,-0.679851,-0.624484>
}
   smooth_triangle{ <29.242399,-71.516800,-25.682699>, <-0.380252,0.679294,0.627669>
 <30.811100,-70.460701,-25.871201>, <-0.384477,0.679851,0.624484>
 <29.920799,-70.484100,-26.390499>, <-0.380874,0.679982,0.626546>
}
   smooth_triangle{ <30.811100,-70.460701,-25.871201>, <0.384477,-0.679851,-0.624484>
 <30.093300,-71.478600,-25.206100>, <0.381575,-0.679040,-0.627140>
 <29.242399,-71.516800,-25.682699>, <0.380252,-0.679294,-0.627669>
}
   smooth_triangle{ <30.811100,-70.460701,-25.871201>, <-0.384477,0.679851,0.624484>
 <29.242399,-71.516800,-25.682699>, <-0.380252,0.679294,0.627669>
 <30.093300,-71.478600,-25.206100>, <-0.381575,0.679040,0.627140>
}
   smooth_triangle{ <27.627199,-72.543800,-25.545799>, <0.376848,-0.678423,-0.630656>
 <28.223101,-71.546501,-26.264601>, <0.376907,-0.679438,-0.629528>
 <29.242399,-71.516800,-25.682699>, <0.380252,-0.679294,-0.627669>
}
   smooth_triangle{ <27.627199,-72.543800,-25.545799>, <-0.376848,0.678423,0.630656>
 <29.242399,-71.516800,-25.682699>, <-0.380252,0.679294,0.627669>
 <28.223101,-71.546501,-26.264601>, <-0.376907,0.679438,0.629528>
}
   smooth_triangle{ <29.242399,-71.516800,-25.682699>, <0.380252,-0.679294,-0.627669>
 <28.585199,-72.518097,-24.997900>, <0.379989,-0.678413,-0.628780>
 <27.627199,-72.543800,-25.545799>, <0.376848,-0.678423,-0.630656>
}
   smooth_triangle{ <29.242399,-71.516800,-25.682699>, <-0.380252,0.679294,0.627669>
 <27.627199,-72.543800,-25.545799>, <-0.376848,0.678423,0.630656>
 <28.585199,-72.518097,-24.997900>, <-0.379989,0.678413,0.628780>
}
   smooth_triangle{ <28.585199,-72.518097,-24.997900>, <0.379989,-0.678413,-0.628780>
 <29.242399,-71.516800,-25.682699>, <0.380252,-0.679294,-0.627669>
 <30.093300,-71.478600,-25.206100>, <0.381575,-0.679040,-0.627140>
}
   smooth_triangle{ <28.585199,-72.518097,-24.997900>, <-0.379989,0.678413,0.628780>
 <30.093300,-71.478600,-25.206100>, <-0.381575,0.679040,0.627140>
 <29.242399,-71.516800,-25.682699>, <-0.380252,0.679294,0.627669>
}
   smooth_triangle{ <30.093300,-71.478600,-25.206100>, <0.381575,-0.679040,-0.627140>
 <29.375500,-72.496399,-24.541000>, <0.383299,-0.678526,-0.626645>
 <28.585199,-72.518097,-24.997900>, <0.379989,-0.678413,-0.628780>
}
   smooth_triangle{ <30.093300,-71.478600,-25.206100>, <-0.381575,0.679040,0.627140>
 <28.585199,-72.518097,-24.997900>, <-0.379989,0.678413,0.628780>
 <29.375500,-72.496399,-24.541000>, <-0.383299,0.678526,0.626645>
}
   smooth_triangle{ <27.112499,-73.404800,-24.928801>, <0.377139,-0.676938,-0.632077>
 <27.627199,-72.543800,-25.545799>, <0.376848,-0.678423,-0.630656>
 <28.585199,-72.518097,-24.997900>, <0.379989,-0.678413,-0.628780>
}
   smooth_triangle{ <27.112499,-73.404800,-24.928801>, <-0.377139,0.676938,0.632077>
 <28.585199,-72.518097,-24.997900>, <-0.379989,0.678413,0.628780>
 <27.627199,-72.543800,-25.545799>, <-0.376848,0.678423,0.630656>
}
   smooth_triangle{ <28.585199,-72.518097,-24.997900>, <0.379989,-0.678413,-0.628780>
 <28.018000,-73.384598,-24.407200>, <0.380161,-0.676941,-0.630261>
 <27.112499,-73.404800,-24.928801>, <0.377139,-0.676938,-0.632077>
}
   smooth_triangle{ <28.585199,-72.518097,-24.997900>, <-0.379989,0.678413,0.628780>
 <27.112499,-73.404800,-24.928801>, <-0.377139,0.676938,0.632077>
 <28.018000,-73.384598,-24.407200>, <-0.380161,0.676941,0.630261>
}
   smooth_triangle{ <28.018000,-73.384598,-24.407200>, <0.380161,-0.676941,-0.630261>
 <28.585199,-72.518097,-24.997900>, <0.379989,-0.678413,-0.628780>
 <29.375500,-72.496399,-24.541000>, <0.383299,-0.678526,-0.626645>
}
   smooth_triangle{ <28.018000,-73.384598,-24.407200>, <-0.380161,0.676941,0.630261>
 <29.375500,-72.496399,-24.541000>, <-0.383299,0.678526,0.626645>
 <28.585199,-72.518097,-24.997900>, <-0.379989,0.678413,0.628780>
}
   smooth_triangle{ <29.375500,-72.496399,-24.541000>, <0.383299,-0.678526,-0.626645>
 <28.765400,-73.367401,-23.972700>, <0.383039,-0.676991,-0.628462>
 <28.018000,-73.384598,-24.407200>, <0.380161,-0.676941,-0.630261>
}
   smooth_triangle{ <29.375500,-72.496399,-24.541000>, <-0.383299,0.678526,0.626645>
 <28.018000,-73.384598,-24.407200>, <-0.380161,0.676941,0.630261>
 <28.765400,-73.367401,-23.972700>, <-0.383039,0.676991,0.628462>
}
   smooth_triangle{ <26.903700,-73.753403,-24.680700>, <0.377893,-0.674917,-0.633786>
 <27.112499,-73.404800,-24.928801>, <0.377139,-0.676938,-0.632077>
 <28.018000,-73.384598,-24.407200>, <0.380161,-0.676941,-0.630261>
}
   smooth_triangle{ <26.903700,-73.753403,-24.680700>, <-0.377893,0.674917,0.633786>
 <28.018000,-73.384598,-24.407200>, <-0.380161,0.676941,0.630261>
 <27.112499,-73.404800,-24.928801>, <-0.377139,0.676938,0.632077>
}
   smooth_triangle{ <28.018000,-73.384598,-24.407200>, <0.380161,-0.676941,-0.630261>
 <27.787600,-73.737900,-24.167601>, <0.380747,-0.675074,-0.631908>
 <26.903700,-73.753403,-24.680700>, <0.377893,-0.674917,-0.633786>
}
   smooth_triangle{ <28.018000,-73.384598,-24.407200>, <-0.380161,0.676941,0.630261>
 <26.903700,-73.753403,-24.680700>, <-0.377893,0.674917,0.633786>
 <27.787600,-73.737900,-24.167601>, <-0.380747,0.675074,0.631908>
}
   smooth_triangle{ <26.737200,-74.031403,-24.484900>, <0.378511,-0.673457,-0.634968>
 <26.903700,-73.753403,-24.680700>, <0.377893,-0.674917,-0.633786>
 <27.787600,-73.737900,-24.167601>, <0.380747,-0.675074,-0.631908>
}
   smooth_triangle{ <26.737200,-74.031403,-24.484900>, <-0.378511,0.673457,0.634968>
 <27.787600,-73.737900,-24.167601>, <-0.380747,0.675074,0.631908>
 <26.903700,-73.753403,-24.680700>, <-0.377893,0.674917,0.633786>
}
   smooth_triangle{ <27.787600,-73.737900,-24.167601>, <0.380747,-0.675074,-0.631908>
 <27.603399,-74.021797,-23.976000>, <0.381329,-0.673907,-0.632801>
 <26.737200,-74.031403,-24.484900>, <0.378511,-0.673457,-0.634968>
}
   smooth_triangle{ <27.787600,-73.737900,-24.167601>, <-0.380747,0.675074,0.631908>
 <26.737200,-74.031403,-24.484900>, <-0.378511,0.673457,0.634968>
 <27.603399,-74.021797,-23.976000>, <-0.381329,0.673907,0.632801>
}
   smooth_triangle{ <27.787600,-73.737900,-24.167601>, <0.380747,-0.675074,-0.631908>
 <28.018000,-73.384598,-24.407200>, <0.380161,-0.676941,-0.630261>
 <28.765400,-73.367401,-23.972700>, <0.383039,-0.676991,-0.628462>
}
   smooth_triangle{ <27.787600,-73.737900,-24.167601>, <-0.380747,0.675074,0.631908>
 <28.765400,-73.367401,-23.972700>, <-0.383039,0.676991,0.628462>
 <28.018000,-73.384598,-24.407200>, <-0.380161,0.676941,0.630261>
}
   smooth_triangle{ <28.765400,-73.367401,-23.972700>, <0.383039,-0.676991,-0.628462>
 <28.517401,-73.723900,-23.740499>, <0.383502,-0.675517,-0.629764>
 <27.787600,-73.737900,-24.167601>, <0.380747,-0.675074,-0.631908>
}
   smooth_triangle{ <28.765400,-73.367401,-23.972700>, <-0.383039,0.676991,0.628462>
 <27.787600,-73.737900,-24.167601>, <-0.380747,0.675074,0.631908>
 <28.517401,-73.723900,-23.740499>, <-0.383502,0.675517,0.629764>
}
   smooth_triangle{ <27.603399,-74.021797,-23.976000>, <0.381329,-0.673907,-0.632801>
 <27.787600,-73.737900,-24.167601>, <0.380747,-0.675074,-0.631908>
 <28.517401,-73.723900,-23.740499>, <0.383502,-0.675517,-0.629764>
}
   smooth_triangle{ <27.603399,-74.021797,-23.976000>, <-0.381329,0.673907,0.632801>
 <28.517401,-73.723900,-23.740499>, <-0.383502,0.675517,0.629764>
 <27.787600,-73.737900,-24.167601>, <-0.380747,0.675074,0.631908>
}
   smooth_triangle{ <28.517401,-73.723900,-23.740499>, <0.383502,-0.675517,-0.629764>
 <28.318800,-74.011803,-23.553200>, <0.384007,-0.674411,-0.630641>
 <27.603399,-74.021797,-23.976000>, <0.381329,-0.673907,-0.632801>
}
   smooth_triangle{ <28.517401,-73.723900,-23.740499>, <-0.383502,0.675517,0.629764>
 <27.603399,-74.021797,-23.976000>, <-0.381329,0.673907,0.632801>
 <28.318800,-74.011803,-23.553200>, <-0.384007,0.674411,0.630641>
}
   smooth_triangle{ <29.375500,-72.496399,-24.541000>, <0.383299,-0.678526,-0.626645>
 <30.811100,-70.460701,-25.871201>, <0.384477,-0.679851,-0.624484>
 <31.509399,-70.441200,-25.459700>, <0.387841,-0.679838,-0.622414>
}
   smooth_triangle{ <29.375500,-72.496399,-24.541000>, <-0.383299,0.678526,0.626645>
 <31.509399,-70.441200,-25.459700>, <-0.387841,0.679838,0.622414>
 <30.811100,-70.460701,-25.871201>, <-0.384477,0.679851,0.624484>
}
   smooth_triangle{ <31.509399,-70.441200,-25.459700>, <0.387841,-0.679838,-0.622414>
 <29.995300,-72.479103,-24.179001>, <0.386306,-0.678565,-0.624754>
 <29.375500,-72.496399,-24.541000>, <0.383299,-0.678526,-0.626645>
}
   smooth_triangle{ <31.509399,-70.441200,-25.459700>, <-0.387841,0.679838,0.622414>
 <29.375500,-72.496399,-24.541000>, <-0.383299,0.678526,0.626645>
 <29.995300,-72.479103,-24.179001>, <-0.386306,0.678565,0.624754>
}
   smooth_triangle{ <29.995300,-72.479103,-24.179001>, <0.386306,-0.678565,-0.624754>
 <31.509399,-70.441200,-25.459700>, <0.387841,-0.679838,-0.622414>
 <32.012199,-70.426399,-25.160500>, <0.391118,-0.680021,-0.620159>
}
   smooth_triangle{ <29.995300,-72.479103,-24.179001>, <-0.386306,0.678565,0.624754>
 <32.012199,-70.426399,-25.160500>, <-0.391118,0.680021,0.620159>
 <31.509399,-70.441200,-25.459700>, <-0.387841,0.679838,0.622414>
}
   smooth_triangle{ <32.012199,-70.426399,-25.160500>, <0.391118,-0.680021,-0.620159>
 <30.441601,-72.466400,-23.915701>, <0.392468,-0.679720,-0.619636>
 <29.995300,-72.479103,-24.179001>, <0.386306,-0.678565,-0.624754>
}
   smooth_triangle{ <32.012199,-70.426399,-25.160500>, <-0.391118,0.680021,0.620159>
 <29.995300,-72.479103,-24.179001>, <-0.386306,0.678565,0.624754>
 <30.441601,-72.466400,-23.915701>, <-0.392468,0.679720,0.619636>
}
   smooth_triangle{ <30.441601,-72.466400,-23.915701>, <0.392468,-0.679720,-0.619636>
 <32.012199,-70.426399,-25.160500>, <0.391118,-0.680021,-0.620159>
 <32.316299,-70.417000,-24.977699>, <0.395472,-0.681088,-0.616215>
}
   smooth_triangle{ <30.441601,-72.466400,-23.915701>, <-0.392468,0.679720,0.619636>
 <32.316299,-70.417000,-24.977699>, <-0.395472,0.681088,0.616215>
 <32.012199,-70.426399,-25.160500>, <-0.391118,0.680021,0.620159>
}
   smooth_triangle{ <32.316299,-70.417000,-24.977699>, <0.395472,-0.681088,-0.616215>
 <30.709999,-72.455803,-23.752300>, <0.383265,-0.677056,-0.628254>
 <30.441601,-72.466400,-23.915701>, <0.392468,-0.679720,-0.619636>
}
   smooth_triangle{ <32.316299,-70.417000,-24.977699>, <-0.395472,0.681088,0.616215>
 <30.441601,-72.466400,-23.915701>, <-0.392468,0.679720,0.619636>
 <30.709999,-72.455803,-23.752300>, <-0.365875,0.671948,0.643911>
}
   smooth_triangle{ <30.709999,-72.455803,-23.752300>, <0.383265,-0.677056,-0.628254>
 <32.316299,-70.417000,-24.977699>, <0.395472,-0.681088,-0.616215>
 <32.418400,-70.413803,-24.915800>, <0.384273,-0.678023,-0.626593>
}
   smooth_triangle{ <30.709999,-72.455803,-23.752300>, <-0.365875,0.671948,0.643911>
 <32.418400,-70.413803,-24.915800>, <-0.353659,0.669296,0.653428>
 <32.316299,-70.417000,-24.977699>, <-0.395472,0.681088,0.616215>
}
   smooth_triangle{ <32.418400,-70.413803,-24.915800>, <0.384273,-0.678023,-0.626593>
 <30.802200,-72.456001,-23.700399>, <0.362536,-0.671169,-0.646606>
 <30.709999,-72.455803,-23.752300>, <0.383265,-0.677056,-0.628254>
}
   smooth_triangle{ <32.418400,-70.413803,-24.915800>, <-0.353659,0.669296,0.653428>
 <30.709999,-72.455803,-23.752300>, <-0.365875,0.671948,0.643911>
 <30.802200,-72.456001,-23.700399>, <-0.356303,0.669075,0.652217>
}
   smooth_triangle{ <28.765400,-73.367401,-23.972700>, <0.383039,-0.676991,-0.628462>
 <29.375500,-72.496399,-24.541000>, <0.383299,-0.678526,-0.626645>
 <29.995300,-72.479103,-24.179001>, <0.386306,-0.678565,-0.624754>
}
   smooth_triangle{ <28.765400,-73.367401,-23.972700>, <-0.383039,0.676991,0.628462>
 <29.995300,-72.479103,-24.179001>, <-0.386306,0.678565,0.624754>
 <29.375500,-72.496399,-24.541000>, <-0.383299,0.678526,0.626645>
}
   smooth_triangle{ <29.995300,-72.479103,-24.179001>, <0.386306,-0.678565,-0.624754>
 <29.351700,-73.353104,-23.629101>, <0.385819,-0.677225,-0.626507>
 <28.765400,-73.367401,-23.972700>, <0.383039,-0.676991,-0.628462>
}
   smooth_triangle{ <29.995300,-72.479103,-24.179001>, <-0.386306,0.678565,0.624754>
 <28.765400,-73.367401,-23.972700>, <-0.383039,0.676991,0.628462>
 <29.351700,-73.353104,-23.629101>, <-0.385819,0.677225,0.626507>
}
   smooth_triangle{ <29.351700,-73.353104,-23.629101>, <0.385819,-0.677225,-0.626507>
 <29.995300,-72.479103,-24.179001>, <0.386306,-0.678565,-0.624754>
 <30.441601,-72.466400,-23.915701>, <0.392468,-0.679720,-0.619636>
}
   smooth_triangle{ <29.351700,-73.353104,-23.629101>, <-0.385819,0.677225,0.626507>
 <30.441601,-72.466400,-23.915701>, <-0.392468,0.679720,0.619636>
 <29.995300,-72.479103,-24.179001>, <-0.386306,0.678565,0.624754>
}
   smooth_triangle{ <30.441601,-72.466400,-23.915701>, <0.392468,-0.679720,-0.619636>
 <29.774200,-73.342400,-23.379299>, <0.393329,-0.678622,-0.620294>
 <29.351700,-73.353104,-23.629101>, <0.385819,-0.677225,-0.626507>
}
   smooth_triangle{ <30.441601,-72.466400,-23.915701>, <-0.392468,0.679720,0.619636>
 <29.351700,-73.353104,-23.629101>, <-0.385819,0.677225,0.626507>
 <29.774200,-73.342400,-23.379299>, <-0.393329,0.678622,0.620294>
}
   smooth_triangle{ <29.774200,-73.342400,-23.379299>, <0.393329,-0.678622,-0.620294>
 <30.441601,-72.466400,-23.915701>, <0.392468,-0.679720,-0.619636>
 <30.709999,-72.455803,-23.752300>, <0.383265,-0.677056,-0.628254>
}
   smooth_triangle{ <29.774200,-73.342400,-23.379299>, <-0.393329,0.678622,0.620294>
 <30.709999,-72.455803,-23.752300>, <-0.365875,0.671948,0.643911>
 <30.441601,-72.466400,-23.915701>, <-0.392468,0.679720,0.619636>
}
   smooth_triangle{ <30.709999,-72.455803,-23.752300>, <0.383265,-0.677056,-0.628254>
 <30.028400,-73.333199,-23.224600>, <0.384878,-0.676216,-0.628173>
 <29.774200,-73.342400,-23.379299>, <0.393329,-0.678622,-0.620294>
}
   smooth_triangle{ <30.709999,-72.455803,-23.752300>, <-0.365875,0.671948,0.643911>
 <29.774200,-73.342400,-23.379299>, <-0.393329,0.678622,0.620294>
 <30.028400,-73.333199,-23.224600>, <-0.363223,0.670652,0.646757>
}
   smooth_triangle{ <30.709999,-72.455803,-23.752300>, <-0.365875,0.671948,0.643911>
 <30.028400,-73.333199,-23.224600>, <-0.363223,0.670652,0.646757>
 <30.802200,-72.456001,-23.700399>, <-0.356303,0.669075,0.652217>
}
   smooth_triangle{ <30.115601,-73.333397,-23.175400>, <-0.363193,0.670715,0.646709>
 <30.802200,-72.456001,-23.700399>, <-0.356303,0.669075,0.652217>
 <30.028400,-73.333199,-23.224600>, <-0.363223,0.670652,0.646757>
}
   smooth_triangle{ <28.517401,-73.723900,-23.740499>, <0.383502,-0.675517,-0.629764>
 <28.765400,-73.367401,-23.972700>, <0.383039,-0.676991,-0.628462>
 <29.351700,-73.353104,-23.629101>, <0.385819,-0.677225,-0.626507>
}
   smooth_triangle{ <28.517401,-73.723900,-23.740499>, <-0.383502,0.675517,0.629764>
 <29.351700,-73.353104,-23.629101>, <-0.385819,0.677225,0.626507>
 <28.765400,-73.367401,-23.972700>, <-0.383039,0.676991,0.628462>
}
   smooth_triangle{ <29.351700,-73.353104,-23.629101>, <0.385819,-0.677225,-0.626507>
 <29.090099,-73.711800,-23.403000>, <0.386148,-0.675944,-0.627686>
 <28.517401,-73.723900,-23.740499>, <0.383502,-0.675517,-0.629764>
}
   smooth_triangle{ <29.351700,-73.353104,-23.629101>, <-0.385819,0.677225,0.626507>
 <28.517401,-73.723900,-23.740499>, <-0.383502,0.675517,0.629764>
 <29.090099,-73.711800,-23.403000>, <-0.386148,0.675944,0.627686>
}
   smooth_triangle{ <28.318800,-74.011803,-23.553200>, <0.384007,-0.674411,-0.630641>
 <28.517401,-73.723900,-23.740499>, <0.383502,-0.675517,-0.629764>
 <29.090099,-73.711800,-23.403000>, <0.386148,-0.675944,-0.627686>
}
   smooth_triangle{ <28.318800,-74.011803,-23.553200>, <-0.384007,0.674411,0.630641>
 <29.090099,-73.711800,-23.403000>, <-0.386148,0.675944,0.627686>
 <28.517401,-73.723900,-23.740499>, <-0.383502,0.675517,0.629764>
}
   smooth_triangle{ <29.090099,-73.711800,-23.403000>, <0.386148,-0.675944,-0.627686>
 <28.880501,-74.002602,-23.219400>, <0.386536,-0.674978,-0.628486>
 <28.318800,-74.011803,-23.553200>, <0.384007,-0.674411,-0.630641>
}
   smooth_triangle{ <29.090099,-73.711800,-23.403000>, <-0.386148,0.675944,0.627686>
 <28.318800,-74.011803,-23.553200>, <-0.384007,0.674411,0.630641>
 <28.880501,-74.002602,-23.219400>, <-0.386536,0.674978,0.628486>
}
   smooth_triangle{ <29.090099,-73.711800,-23.403000>, <0.386148,-0.675944,-0.627686>
 <29.351700,-73.353104,-23.629101>, <0.385819,-0.677225,-0.626507>
 <29.774200,-73.342400,-23.379299>, <0.393329,-0.678622,-0.620294>
}
   smooth_triangle{ <29.090099,-73.711800,-23.403000>, <-0.386148,0.675944,0.627686>
 <29.774200,-73.342400,-23.379299>, <-0.393329,0.678622,0.620294>
 <29.351700,-73.353104,-23.629101>, <-0.385819,0.677225,0.626507>
}
   smooth_triangle{ <29.774200,-73.342400,-23.379299>, <0.393329,-0.678622,-0.620294>
 <29.502701,-73.702599,-23.157801>, <0.393443,-0.677353,-0.621607>
 <29.090099,-73.711800,-23.403000>, <0.386148,-0.675944,-0.627686>
}
   smooth_triangle{ <29.774200,-73.342400,-23.379299>, <-0.393329,0.678622,0.620294>
 <29.090099,-73.711800,-23.403000>, <-0.386148,0.675944,0.627686>
 <29.502701,-73.702599,-23.157801>, <-0.393443,0.677353,0.621607>
}
   smooth_triangle{ <28.880501,-74.002602,-23.219400>, <0.386536,-0.674978,-0.628486>
 <29.090099,-73.711800,-23.403000>, <0.386148,-0.675944,-0.627686>
 <29.502701,-73.702599,-23.157801>, <0.393443,-0.677353,-0.621607>
}
   smooth_triangle{ <28.880501,-74.002602,-23.219400>, <-0.386536,0.674978,0.628486>
 <29.502701,-73.702599,-23.157801>, <-0.393443,0.677353,0.621607>
 <29.090099,-73.711800,-23.403000>, <-0.386148,0.675944,0.627686>
}
   smooth_triangle{ <29.502701,-73.702599,-23.157801>, <0.393443,-0.677353,-0.621607>
 <29.285601,-73.994904,-22.977400>, <0.393927,-0.676734,-0.621975>
 <28.880501,-74.002602,-23.219400>, <0.386536,-0.674978,-0.628486>
}
   smooth_triangle{ <29.502701,-73.702599,-23.157801>, <-0.393443,0.677353,0.621607>
 <28.880501,-74.002602,-23.219400>, <-0.386536,0.674978,0.628486>
 <29.285601,-73.994904,-22.977400>, <-0.393927,0.676734,0.621975>
}
   smooth_triangle{ <29.502701,-73.702599,-23.157801>, <0.393443,-0.677353,-0.621607>
 <29.774200,-73.342400,-23.379299>, <0.393329,-0.678622,-0.620294>
 <30.028400,-73.333199,-23.224600>, <0.384878,-0.676216,-0.628173>
}
   smooth_triangle{ <29.502701,-73.702599,-23.157801>, <-0.393443,0.677353,0.621607>
 <30.028400,-73.333199,-23.224600>, <-0.363223,0.670652,0.646757>
 <29.774200,-73.342400,-23.379299>, <-0.393329,0.678622,0.620294>
}
   smooth_triangle{ <30.028400,-73.333199,-23.224600>, <0.384878,-0.676216,-0.628173>
 <29.751200,-73.694099,-23.006201>, <0.378944,-0.673839,-0.634304>
 <29.502701,-73.702599,-23.157801>, <0.393443,-0.677353,-0.621607>
}
   smooth_triangle{ <30.028400,-73.333199,-23.224600>, <-0.363223,0.670652,0.646757>
 <29.502701,-73.702599,-23.157801>, <-0.393443,0.677353,0.621607>
 <29.751200,-73.694099,-23.006201>, <-0.363769,0.670093,0.647029>
}
   smooth_triangle{ <29.751200,-73.694099,-23.006201>, <0.378944,-0.673839,-0.634304>
 <30.028400,-73.333199,-23.224600>, <0.384878,-0.676216,-0.628173>
 <30.115601,-73.333397,-23.175400>, <0.363137,-0.670699,-0.646757>
}
   smooth_triangle{ <29.751200,-73.694099,-23.006201>, <-0.363769,0.670093,0.647029>
 <30.115601,-73.333397,-23.175400>, <-0.363193,0.670715,0.646709>
 <30.028400,-73.333199,-23.224600>, <-0.363223,0.670652,0.646757>
}
   smooth_triangle{ <30.115601,-73.333397,-23.175400>, <0.363137,-0.670699,-0.646757>
 <29.836500,-73.694298,-22.958099>, <0.363453,-0.670012,-0.647291>
 <29.751200,-73.694099,-23.006201>, <0.378944,-0.673839,-0.634304>
}
   smooth_triangle{ <30.115601,-73.333397,-23.175400>, <-0.363193,0.670715,0.646709>
 <29.751200,-73.694099,-23.006201>, <-0.363769,0.670093,0.647029>
 <29.836500,-73.694298,-22.958099>, <-0.363309,0.670020,0.647363>
}
   smooth_triangle{ <29.285601,-73.994904,-22.977400>, <0.393927,-0.676734,-0.621975>
 <29.502701,-73.702599,-23.157801>, <0.393443,-0.677353,-0.621607>
 <29.751200,-73.694099,-23.006201>, <0.378944,-0.673839,-0.634304>
}
   smooth_triangle{ <29.285601,-73.994904,-22.977400>, <-0.393927,0.676734,0.621975>
 <29.751200,-73.694099,-23.006201>, <-0.363769,0.670093,0.647029>
 <29.502701,-73.702599,-23.157801>, <-0.393443,0.677353,0.621607>
}
   smooth_triangle{ <29.751200,-73.694099,-23.006201>, <0.378944,-0.673839,-0.634304>
 <29.529301,-73.987099,-22.827700>, <0.385377,-0.674900,-0.629281>
 <29.285601,-73.994904,-22.977400>, <0.393927,-0.676734,-0.621975>
}
   smooth_triangle{ <29.751200,-73.694099,-23.006201>, <-0.363769,0.670093,0.647029>
 <29.285601,-73.994904,-22.977400>, <-0.393927,0.676734,0.621975>
 <29.529301,-73.987099,-22.827700>, <-0.363860,0.669691,0.647395>
}
   smooth_triangle{ <29.751200,-73.694099,-23.006201>, <-0.363769,0.670093,0.647029>
 <29.529301,-73.987099,-22.827700>, <-0.363860,0.669691,0.647395>
 <29.836500,-73.694298,-22.958099>, <-0.363309,0.670020,0.647363>
}
   smooth_triangle{ <29.613100,-73.987602,-22.780300>, <-0.362992,0.669452,0.648129>
 <29.836500,-73.694298,-22.958099>, <-0.363309,0.670020,0.647363>
 <29.529301,-73.987099,-22.827700>, <-0.363860,0.669691,0.647395>
}
   smooth_triangle{ <34.411400,-67.915001,-26.397200>, <-0.357742,0.670784,0.649669>
 <34.454498,-67.861298,-26.429001>, <-0.371515,0.675059,0.637394>
 <34.332298,-67.855103,-26.491100>, <-0.317020,0.657865,0.683163>
}
   smooth_triangle{ <34.332298,-67.855103,-26.491100>, <-0.317020,0.657865,0.683163>
 <34.289501,-67.908897,-26.459200>, <-0.318212,0.657920,0.682556>
 <34.411400,-67.915001,-26.397200>, <-0.357742,0.670784,0.649669>
}
   smooth_triangle{ <34.288601,-68.068703,-26.306299>, <-0.357411,0.670626,0.650014>
 <34.411400,-67.915001,-26.397200>, <-0.357742,0.670784,0.649669>
 <34.289501,-67.908897,-26.459200>, <-0.318212,0.657920,0.682556>
}
   smooth_triangle{ <34.289501,-67.908897,-26.459200>, <-0.318212,0.657920,0.682556>
 <34.167599,-68.062500,-26.367800>, <-0.318673,0.658013,0.682250>
 <34.288601,-68.068703,-26.306299>, <-0.357411,0.670626,0.650014>
}
   smooth_triangle{ <34.289501,-67.908897,-26.459200>, <-0.318212,0.657920,0.682556>
 <34.332298,-67.855103,-26.491100>, <-0.317020,0.657865,0.683163>
 <33.970100,-67.838699,-26.677999>, <-0.324025,0.659142,0.678630>
}
   smooth_triangle{ <33.970100,-67.838699,-26.677999>, <-0.324025,0.659142,0.678630>
 <33.928398,-67.892700,-26.645500>, <-0.325712,0.659193,0.677773>
 <34.289501,-67.908897,-26.459200>, <-0.318212,0.657920,0.682556>
}
   smooth_triangle{ <34.167599,-68.062500,-26.367800>, <-0.318673,0.658013,0.682250>
 <34.289501,-67.908897,-26.459200>, <-0.318212,0.657920,0.682556>
 <33.928398,-67.892700,-26.645500>, <-0.325712,0.659193,0.677773>
}
   smooth_triangle{ <33.928398,-67.892700,-26.645500>, <-0.325712,0.659193,0.677773>
 <33.809399,-68.046898,-26.552900>, <-0.326257,0.659244,0.677462>
 <34.167599,-68.062500,-26.367800>, <-0.318673,0.658013,0.682250>
}
   smooth_triangle{ <34.095600,-68.309898,-26.163401>, <-0.357949,0.670805,0.649533>
 <34.288601,-68.068703,-26.306299>, <-0.357411,0.670626,0.650014>
 <34.167599,-68.062500,-26.367800>, <-0.318673,0.658013,0.682250>
}
   smooth_triangle{ <34.167599,-68.062500,-26.367800>, <-0.318673,0.658013,0.682250>
 <33.976101,-68.304100,-26.224300>, <-0.319835,0.658329,0.681402>
 <34.095600,-68.309898,-26.163401>, <-0.357949,0.670805,0.649533>
}
   smooth_triangle{ <33.976101,-68.304100,-26.224300>, <-0.319835,0.658329,0.681402>
 <34.167599,-68.062500,-26.367800>, <-0.318673,0.658013,0.682250>
 <33.809399,-68.046898,-26.552900>, <-0.326257,0.659244,0.677462>
}
   smooth_triangle{ <33.809399,-68.046898,-26.552900>, <-0.326257,0.659244,0.677462>
 <33.622398,-68.289001,-26.407101>, <-0.326733,0.659668,0.676819>
 <33.976101,-68.304100,-26.224300>, <-0.319835,0.658329,0.681402>
}
   smooth_triangle{ <33.842201,-68.626999,-25.975599>, <-0.358209,0.670762,0.649434>
 <34.095600,-68.309898,-26.163401>, <-0.357949,0.670805,0.649533>
 <33.976101,-68.304100,-26.224300>, <-0.319835,0.658329,0.681402>
}
   smooth_triangle{ <33.976101,-68.304100,-26.224300>, <-0.319835,0.658329,0.681402>
 <33.724800,-68.621399,-26.035601>, <-0.321073,0.658757,0.680405>
 <33.842201,-68.626999,-25.975599>, <-0.358209,0.670762,0.649434>
}
   smooth_triangle{ <33.724800,-68.621399,-26.035601>, <-0.321073,0.658757,0.680405>
 <33.976101,-68.304100,-26.224300>, <-0.319835,0.658329,0.681402>
 <33.622398,-68.289001,-26.407101>, <-0.326733,0.659668,0.676819>
}
   smooth_triangle{ <33.622398,-68.289001,-26.407101>, <-0.326733,0.659668,0.676819>
 <33.376999,-68.607101,-26.215500>, <-0.327810,0.659991,0.675983>
 <33.724800,-68.621399,-26.035601>, <-0.321073,0.658757,0.680405>
}
   smooth_triangle{ <33.928398,-67.892700,-26.645500>, <-0.325712,0.659193,0.677773>
 <33.970100,-67.838699,-26.677999>, <-0.324025,0.659142,0.678630>
 <33.375198,-67.816101,-26.990299>, <-0.332035,0.660519,0.673400>
}
   smooth_triangle{ <33.375198,-67.816101,-26.990299>, <-0.332035,0.660519,0.673400>
 <33.334999,-67.870300,-26.957001>, <-0.333692,0.660234,0.672860>
 <33.928398,-67.892700,-26.645500>, <-0.325712,0.659193,0.677773>
}
   smooth_triangle{ <33.809399,-68.046898,-26.552900>, <-0.326257,0.659244,0.677462>
 <33.928398,-67.892700,-26.645500>, <-0.325712,0.659193,0.677773>
 <33.334999,-67.870300,-26.957001>, <-0.333692,0.660234,0.672860>
}
   smooth_triangle{ <33.334999,-67.870300,-26.957001>, <-0.333692,0.660234,0.672860>
 <33.220699,-68.025101,-26.861799>, <-0.333983,0.660371,0.672582>
 <33.809399,-68.046898,-26.552900>, <-0.326257,0.659244,0.677462>
}
   smooth_triangle{ <33.622398,-68.289001,-26.407101>, <-0.326733,0.659668,0.676819>
 <33.809399,-68.046898,-26.552900>, <-0.326257,0.659244,0.677462>
 <33.220699,-68.025101,-26.861799>, <-0.333983,0.660371,0.672582>
}
   smooth_triangle{ <33.220699,-68.025101,-26.861799>, <-0.333983,0.660371,0.672582>
 <33.041100,-68.268204,-26.712299>, <-0.334526,0.660587,0.672099>
 <33.622398,-68.289001,-26.407101>, <-0.326733,0.659668,0.676819>
}
   smooth_triangle{ <33.376999,-68.607101,-26.215500>, <-0.327810,0.659991,0.675983>
 <33.622398,-68.289001,-26.407101>, <-0.326733,0.659668,0.676819>
 <33.041100,-68.268204,-26.712299>, <-0.334526,0.660587,0.672099>
}
   smooth_triangle{ <33.041100,-68.268204,-26.712299>, <-0.334526,0.660587,0.672099>
 <32.805199,-68.587700,-26.515600>, <-0.335443,0.660898,0.671336>
 <33.376999,-68.607101,-26.215500>, <-0.327810,0.659991,0.675983>
}
   smooth_triangle{ <33.334999,-67.870300,-26.957001>, <-0.333692,0.660234,0.672860>
 <33.375198,-67.816101,-26.990299>, <-0.332035,0.660519,0.673400>
 <32.554401,-67.790802,-27.428499>, <-0.340408,0.661077,0.668655>
}
   smooth_triangle{ <32.554401,-67.790802,-27.428499>, <-0.340408,0.661077,0.668655>
 <32.516499,-67.845299,-27.393999>, <-0.342007,0.660997,0.667918>
 <33.334999,-67.870300,-26.957001>, <-0.333692,0.660234,0.672860>
}
   smooth_triangle{ <33.220699,-68.025101,-26.861799>, <-0.333983,0.660371,0.672582>
 <33.334999,-67.870300,-26.957001>, <-0.333692,0.660234,0.672860>
 <32.516499,-67.845299,-27.393999>, <-0.342007,0.660997,0.667918>
}
   smooth_triangle{ <32.516499,-67.845299,-27.393999>, <-0.342007,0.660997,0.667918>
 <32.408501,-68.000999,-27.295200>, <-0.342281,0.661048,0.667728>
 <33.220699,-68.025101,-26.861799>, <-0.333983,0.660371,0.672582>
}
   smooth_triangle{ <33.041100,-68.268204,-26.712299>, <-0.334526,0.660587,0.672099>
 <33.220699,-68.025101,-26.861799>, <-0.333983,0.660371,0.672582>
 <32.408501,-68.000999,-27.295200>, <-0.342281,0.661048,0.667728>
}
   smooth_triangle{ <32.408501,-68.000999,-27.295200>, <-0.342281,0.661048,0.667728>
 <32.238800,-68.245499,-27.140100>, <-0.342724,0.661194,0.667356>
 <33.041100,-68.268204,-26.712299>, <-0.334526,0.660587,0.672099>
}
   smooth_triangle{ <32.805199,-68.587700,-26.515600>, <-0.335443,0.660898,0.671336>
 <33.041100,-68.268204,-26.712299>, <-0.334526,0.660587,0.672099>
 <32.238800,-68.245499,-27.140100>, <-0.342724,0.661194,0.667356>
}
   smooth_triangle{ <32.238800,-68.245499,-27.140100>, <-0.342724,0.661194,0.667356>
 <32.015999,-68.566704,-26.936300>, <-0.343444,0.661444,0.666737>
 <32.805199,-68.587700,-26.515600>, <-0.335443,0.660898,0.671336>
}
   smooth_triangle{ <33.193100,-69.440598,-25.493299>, <-0.358567,0.670754,0.649245>
 <33.842201,-68.626999,-25.975599>, <-0.358209,0.670762,0.649434>
 <33.724800,-68.621399,-26.035601>, <-0.321073,0.658757,0.680405>
}
   smooth_triangle{ <33.724800,-68.621399,-26.035601>, <-0.321073,0.658757,0.680405>
 <33.080700,-69.435699,-25.551001>, <-0.323455,0.659509,0.678546>
 <33.193100,-69.440598,-25.493299>, <-0.358567,0.670754,0.649245>
}
   smooth_triangle{ <33.080700,-69.435699,-25.551001>, <-0.323455,0.659509,0.678546>
 <33.724800,-68.621399,-26.035601>, <-0.321073,0.658757,0.680405>
 <33.376999,-68.607101,-26.215500>, <-0.327810,0.659991,0.675983>
}
   smooth_triangle{ <33.376999,-68.607101,-26.215500>, <-0.327810,0.659991,0.675983>
 <32.747898,-69.423302,-25.723499>, <-0.330008,0.660637,0.674280>
 <33.080700,-69.435699,-25.551001>, <-0.323455,0.659509,0.678546>
}
   smooth_triangle{ <32.747898,-69.423302,-25.723499>, <-0.330008,0.660637,0.674280>
 <33.376999,-68.607101,-26.215500>, <-0.327810,0.659991,0.675983>
 <32.805199,-68.587700,-26.515600>, <-0.335443,0.660898,0.671336>
}
   smooth_triangle{ <32.805199,-68.587700,-26.515600>, <-0.335443,0.660898,0.671336>
 <32.200500,-69.406998,-26.011101>, <-0.337298,0.661433,0.669878>
 <32.747898,-69.423302,-25.723499>, <-0.330008,0.660637,0.674280>
}
   smooth_triangle{ <32.200500,-69.406998,-26.011101>, <-0.337298,0.661433,0.669878>
 <32.805199,-68.587700,-26.515600>, <-0.335443,0.660898,0.671336>
 <32.015999,-68.566704,-26.936300>, <-0.343444,0.661444,0.666737>
}
   smooth_triangle{ <32.015999,-68.566704,-26.936300>, <-0.343444,0.661444,0.666737>
 <31.444901,-69.390198,-26.413500>, <-0.344852,0.661909,0.665547>
 <32.200500,-69.406998,-26.011101>, <-0.337298,0.661433,0.669878>
}
   smooth_triangle{ <32.418400,-70.413803,-24.915800>, <-0.353659,0.669296,0.653428>
 <33.193100,-69.440598,-25.493299>, <-0.358567,0.670754,0.649245>
 <33.080700,-69.435699,-25.551001>, <-0.323455,0.659509,0.678546>
}
   smooth_triangle{ <33.080700,-69.435699,-25.551001>, <-0.323455,0.659509,0.678546>
 <32.312199,-70.409500,-24.970600>, <-0.332647,0.661821,0.671818>
 <32.418400,-70.413803,-24.915800>, <-0.353659,0.669296,0.653428>
}
   smooth_triangle{ <32.312199,-70.409500,-24.970600>, <-0.332647,0.661821,0.671818>
 <33.080700,-69.435699,-25.551001>, <-0.323455,0.659509,0.678546>
 <32.747898,-69.423302,-25.723499>, <-0.330008,0.660637,0.674280>
}
   smooth_triangle{ <32.747898,-69.423302,-25.723499>, <-0.330008,0.660637,0.674280>
 <31.997200,-70.399300,-25.134600>, <-0.331619,0.660861,0.673269>
 <32.312199,-70.409500,-24.970600>, <-0.332647,0.661821,0.671818>
}
   smooth_triangle{ <31.997200,-70.399300,-25.134600>, <-0.331619,0.660861,0.673269>
 <32.747898,-69.423302,-25.723499>, <-0.330008,0.660637,0.674280>
 <32.200500,-69.406998,-26.011101>, <-0.337298,0.661433,0.669878>
}
   smooth_triangle{ <32.200500,-69.406998,-26.011101>, <-0.337298,0.661433,0.669878>
 <31.478901,-70.386200,-25.407301>, <-0.339972,0.662280,0.667686>
 <31.997200,-70.399300,-25.134600>, <-0.331619,0.660861,0.673269>
}
   smooth_triangle{ <31.478901,-70.386200,-25.407301>, <-0.339972,0.662280,0.667686>
 <32.200500,-69.406998,-26.011101>, <-0.337298,0.661433,0.669878>
 <31.444901,-69.390198,-26.413500>, <-0.344852,0.661909,0.665547>
}
   smooth_triangle{ <31.444901,-69.390198,-26.413500>, <-0.344852,0.661909,0.665547>
 <30.763000,-70.373802,-25.788200>, <-0.346992,0.662666,0.663679>
 <31.478901,-70.386200,-25.407301>, <-0.339972,0.662280,0.667686>
}
   smooth_triangle{ <32.516499,-67.845299,-27.393999>, <-0.342007,0.660997,0.667918>
 <32.554401,-67.790802,-27.428499>, <-0.340408,0.661077,0.668655>
 <31.514900,-67.766296,-27.993500>, <-0.348897,0.661719,0.663625>
}
   smooth_triangle{ <31.514900,-67.766296,-27.993500>, <-0.348897,0.661719,0.663625>
 <31.479700,-67.821297,-27.957199>, <-0.350575,0.661445,0.663014>
 <32.516499,-67.845299,-27.393999>, <-0.342007,0.660997,0.667918>
}
   smooth_triangle{ <32.408501,-68.000999,-27.295200>, <-0.342281,0.661048,0.667728>
 <32.516499,-67.845299,-27.393999>, <-0.342007,0.660997,0.667918>
 <31.479700,-67.821297,-27.957199>, <-0.350575,0.661445,0.663014>
}
   smooth_triangle{ <31.479700,-67.821297,-27.957199>, <-0.350575,0.661445,0.663014>
 <31.379601,-67.978104,-27.853800>, <-0.350875,0.661340,0.662960>
 <32.408501,-68.000999,-27.295200>, <-0.342281,0.661048,0.667728>
}
   smooth_triangle{ <32.238800,-68.245499,-27.140100>, <-0.342724,0.661194,0.667356>
 <32.408501,-68.000999,-27.295200>, <-0.342281,0.661048,0.667728>
 <31.379601,-67.978104,-27.853800>, <-0.350875,0.661340,0.662960>
}
   smooth_triangle{ <31.379601,-67.978104,-27.853800>, <-0.350875,0.661340,0.662960>
 <31.222401,-68.224403,-27.691299>, <-0.351129,0.661564,0.662602>
 <32.238800,-68.245499,-27.140100>, <-0.342724,0.661194,0.667356>
}
   smooth_triangle{ <32.015999,-68.566704,-26.936300>, <-0.343444,0.661444,0.666737>
 <32.238800,-68.245499,-27.140100>, <-0.342724,0.661194,0.667356>
 <31.222401,-68.224403,-27.691299>, <-0.351129,0.661564,0.662602>
}
   smooth_triangle{ <31.222401,-68.224403,-27.691299>, <-0.351129,0.661564,0.662602>
 <31.015900,-68.547798,-27.477699>, <-0.351651,0.661764,0.662125>
 <32.015999,-68.566704,-26.936300>, <-0.343444,0.661444,0.666737>
}
   smooth_triangle{ <31.479700,-67.821297,-27.957199>, <-0.350575,0.661445,0.663014>
 <31.514900,-67.766296,-27.993500>, <-0.348897,0.661719,0.663625>
 <30.263500,-67.746300,-28.685600>, <-0.357817,0.661738,0.658840>
}
   smooth_triangle{ <30.263500,-67.746300,-28.685600>, <-0.357817,0.661738,0.658840>
 <30.231701,-67.801903,-28.647100>, <-0.359535,0.661434,0.658209>
 <31.479700,-67.821297,-27.957199>, <-0.350575,0.661445,0.663014>
}
   smooth_triangle{ <31.379601,-67.978104,-27.853800>, <-0.350875,0.661340,0.662960>
 <31.479700,-67.821297,-27.957199>, <-0.350575,0.661445,0.663014>
 <30.231701,-67.801903,-28.647100>, <-0.359535,0.661434,0.658209>
}
   smooth_triangle{ <30.231701,-67.801903,-28.647100>, <-0.359535,0.661434,0.658209>
 <30.141001,-67.960098,-28.537701>, <-0.359651,0.661509,0.658071>
 <31.379601,-67.978104,-27.853800>, <-0.350875,0.661340,0.662960>
}
   smooth_triangle{ <31.222401,-68.224403,-27.691299>, <-0.351129,0.661564,0.662602>
 <31.379601,-67.978104,-27.853800>, <-0.350875,0.661340,0.662960>
 <30.141001,-67.960098,-28.537701>, <-0.359651,0.661509,0.658071>
}
   smooth_triangle{ <30.141001,-67.960098,-28.537701>, <-0.359651,0.661509,0.658071>
 <29.998600,-68.208504,-28.365801>, <-0.359830,0.661666,0.657815>
 <31.222401,-68.224403,-27.691299>, <-0.351129,0.661564,0.662602>
}
   smooth_triangle{ <31.015900,-68.547798,-27.477699>, <-0.351651,0.661764,0.662125>
 <31.222401,-68.224403,-27.691299>, <-0.351129,0.661564,0.662602>
 <29.998600,-68.208504,-28.365801>, <-0.359830,0.661666,0.657815>
}
   smooth_triangle{ <29.998600,-68.208504,-28.365801>, <-0.359830,0.661666,0.657815>
 <29.811600,-68.534698,-28.140100>, <-0.360189,0.661815,0.657469>
 <31.015900,-68.547798,-27.477699>, <-0.351651,0.661764,0.662125>
}
   smooth_triangle{ <31.444901,-69.390198,-26.413500>, <-0.344852,0.661909,0.665547>
 <32.015999,-68.566704,-26.936300>, <-0.343444,0.661444,0.666737>
 <31.015900,-68.547798,-27.477699>, <-0.351651,0.661764,0.662125>
}
   smooth_triangle{ <31.015900,-68.547798,-27.477699>, <-0.351651,0.661764,0.662125>
 <30.486700,-69.376503,-26.930500>, <-0.352718,0.662131,0.661191>
 <31.444901,-69.390198,-26.413500>, <-0.344852,0.661909,0.665547>
}
   smooth_triangle{ <30.486700,-69.376503,-26.930500>, <-0.352718,0.662131,0.661191>
 <31.015900,-68.547798,-27.477699>, <-0.351651,0.661764,0.662125>
 <29.811600,-68.534698,-28.140100>, <-0.360189,0.661815,0.657469>
}
   smooth_triangle{ <29.811600,-68.534698,-28.140100>, <-0.360189,0.661815,0.657469>
 <29.332300,-69.369598,-27.562099>, <-0.360827,0.662176,0.656755>
 <30.486700,-69.376503,-26.930500>, <-0.352718,0.662131,0.661191>
}
   smooth_triangle{ <30.763000,-70.373802,-25.788200>, <-0.346992,0.662666,0.663679>
 <31.444901,-69.390198,-26.413500>, <-0.344852,0.661909,0.665547>
 <30.486700,-69.376503,-26.930500>, <-0.352718,0.662131,0.661191>
}
   smooth_triangle{ <30.486700,-69.376503,-26.930500>, <-0.352718,0.662131,0.661191>
 <29.854799,-70.365402,-26.277000>, <-0.354099,0.662676,0.659905>
 <30.763000,-70.373802,-25.788200>, <-0.346992,0.662666,0.663679>
}
   smooth_triangle{ <29.854799,-70.365402,-26.277000>, <-0.354099,0.662676,0.659905>
 <30.486700,-69.376503,-26.930500>, <-0.352718,0.662131,0.661191>
 <29.332300,-69.369598,-27.562099>, <-0.360827,0.662176,0.656755>
}
   smooth_triangle{ <29.332300,-69.369598,-27.562099>, <-0.360827,0.662176,0.656755>
 <28.760000,-70.364403,-26.873199>, <-0.361644,0.662639,0.655837>
 <29.854799,-70.365402,-26.277000>, <-0.354099,0.662676,0.659905>
}
   smooth_triangle{ <30.231701,-67.801903,-28.647100>, <-0.359535,0.661434,0.658209>
 <30.263500,-67.746300,-28.685600>, <-0.357817,0.661738,0.658840>
 <28.807400,-67.734703,-29.505600>, <-0.367016,0.661552,0.653947>
}
   smooth_triangle{ <28.807400,-67.734703,-29.505600>, <-0.367016,0.661552,0.653947>
 <28.779400,-67.790802,-29.464600>, <-0.368652,0.661368,0.653214>
 <30.231701,-67.801903,-28.647100>, <-0.359535,0.661434,0.658209>
}
   smooth_triangle{ <30.141001,-67.960098,-28.537701>, <-0.359651,0.661509,0.658071>
 <30.231701,-67.801903,-28.647100>, <-0.359535,0.661434,0.658209>
 <28.779400,-67.790802,-29.464600>, <-0.368652,0.661368,0.653214>
}
   smooth_triangle{ <28.779400,-67.790802,-29.464600>, <-0.368652,0.661368,0.653214>
 <28.699499,-67.950699,-29.347799>, <-0.368607,0.661612,0.652992>
 <30.141001,-67.960098,-28.537701>, <-0.359651,0.661509,0.658071>
}
   smooth_triangle{ <29.998600,-68.208504,-28.365801>, <-0.359830,0.661666,0.657815>
 <30.141001,-67.960098,-28.537701>, <-0.359651,0.661509,0.658071>
 <28.699499,-67.950699,-29.347799>, <-0.368607,0.661612,0.652992>
}
   smooth_triangle{ <28.699499,-67.950699,-29.347799>, <-0.368607,0.661612,0.652992>
 <28.574100,-68.201599,-29.164400>, <-0.368678,0.661677,0.652886>
 <29.998600,-68.208504,-28.365801>, <-0.359830,0.661666,0.657815>
}
   smooth_triangle{ <29.811600,-68.534698,-28.140100>, <-0.360189,0.661815,0.657469>
 <29.998600,-68.208504,-28.365801>, <-0.359830,0.661666,0.657815>
 <28.574100,-68.201599,-29.164400>, <-0.368678,0.661677,0.652886>
}
   smooth_triangle{ <28.574100,-68.201599,-29.164400>, <-0.368678,0.661677,0.652886>
 <28.409500,-68.530701,-28.923800>, <-0.368779,0.661866,0.652638>
 <29.811600,-68.534698,-28.140100>, <-0.360189,0.661815,0.657469>
}
   smooth_triangle{ <28.779400,-67.790802,-29.464600>, <-0.368652,0.661368,0.653214>
 <28.807400,-67.734703,-29.505600>, <-0.367016,0.661552,0.653947>
 <27.153500,-67.734802,-30.454000>, <-0.375220,0.661046,0.649791>
}
   smooth_triangle{ <27.153500,-67.734802,-30.454000>, <-0.375220,0.661046,0.649791>
 <27.129700,-67.791603,-30.410000>, <-0.376042,0.661293,0.649063>
 <28.779400,-67.790802,-29.464600>, <-0.368652,0.661368,0.653214>
}
   smooth_triangle{ <28.699499,-67.950699,-29.347799>, <-0.368607,0.661612,0.652992>
 <28.779400,-67.790802,-29.464600>, <-0.368652,0.661368,0.653214>
 <27.129700,-67.791603,-30.410000>, <-0.376042,0.661293,0.649063>
}
   smooth_triangle{ <27.129700,-67.791603,-30.410000>, <-0.376042,0.661293,0.649063>
 <27.062000,-67.953400,-30.284201>, <-0.375893,0.661613,0.648824>
 <28.699499,-67.950699,-29.347799>, <-0.368607,0.661612,0.652992>
}
   smooth_triangle{ <28.574100,-68.201599,-29.164400>, <-0.368678,0.661677,0.652886>
 <28.699499,-67.950699,-29.347799>, <-0.368607,0.661612,0.652992>
 <27.062000,-67.953400,-30.284201>, <-0.375893,0.661613,0.648824>
}
   smooth_triangle{ <27.062000,-67.953400,-30.284201>, <-0.375893,0.661613,0.648824>
 <26.955700,-68.207100,-30.087200>, <-0.375827,0.661660,0.648814>
 <28.574100,-68.201599,-29.164400>, <-0.368678,0.661677,0.652886>
}
   smooth_triangle{ <28.409500,-68.530701,-28.923800>, <-0.368779,0.661866,0.652638>
 <28.574100,-68.201599,-29.164400>, <-0.368678,0.661677,0.652886>
 <26.955700,-68.207100,-30.087200>, <-0.375827,0.661660,0.648814>
}
   smooth_triangle{ <26.955700,-68.207100,-30.087200>, <-0.375827,0.661660,0.648814>
 <26.816099,-68.539703,-29.828800>, <-0.375674,0.661810,0.648750>
 <28.409500,-68.530701,-28.923800>, <-0.368779,0.661866,0.652638>
}
   smooth_triangle{ <29.332300,-69.369598,-27.562099>, <-0.360827,0.662176,0.656755>
 <29.811600,-68.534698,-28.140100>, <-0.360189,0.661815,0.657469>
 <28.409500,-68.530701,-28.923800>, <-0.368779,0.661866,0.652638>
}
   smooth_triangle{ <28.409500,-68.530701,-28.923800>, <-0.368779,0.661866,0.652638>
 <27.987600,-69.372597,-28.308500>, <-0.369095,0.662100,0.652222>
 <29.332300,-69.369598,-27.562099>, <-0.360827,0.662176,0.656755>
}
   smooth_triangle{ <28.760000,-70.364403,-26.873199>, <-0.361644,0.662639,0.655837>
 <29.332300,-69.369598,-27.562099>, <-0.360827,0.662176,0.656755>
 <27.987600,-69.372597,-28.308500>, <-0.369095,0.662100,0.652222>
}
   smooth_triangle{ <27.987600,-69.372597,-28.308500>, <-0.369095,0.662100,0.652222>
 <27.484301,-70.374100,-27.576300>, <-0.369388,0.662561,0.651587>
 <28.760000,-70.364403,-26.873199>, <-0.361644,0.662639,0.655837>
}
   smooth_triangle{ <27.987600,-69.372597,-28.308500>, <-0.369095,0.662100,0.652222>
 <28.409500,-68.530701,-28.923800>, <-0.368779,0.661866,0.652638>
 <26.816099,-68.539703,-29.828800>, <-0.375674,0.661810,0.648750>
}
   smooth_triangle{ <26.816099,-68.539703,-29.828800>, <-0.375674,0.661810,0.648750>
 <26.458799,-69.389503,-29.169100>, <-0.375560,0.661985,0.648637>
 <27.987600,-69.372597,-28.308500>, <-0.369095,0.662100,0.652222>
}
   smooth_triangle{ <27.484301,-70.374100,-27.576300>, <-0.369388,0.662561,0.651587>
 <27.987600,-69.372597,-28.308500>, <-0.369095,0.662100,0.652222>
 <26.458799,-69.389503,-29.169100>, <-0.375560,0.661985,0.648637>
}
   smooth_triangle{ <26.458799,-69.389503,-29.169100>, <-0.375560,0.661985,0.648637>
 <26.032900,-70.397903,-28.385900>, <-0.375664,0.662445,0.648108>
 <27.484301,-70.374100,-27.576300>, <-0.369388,0.662561,0.651587>
}
   smooth_triangle{ <30.802200,-72.456001,-23.700399>, <-0.356303,0.669075,0.652217>
 <32.418400,-70.413803,-24.915800>, <-0.353659,0.669296,0.653428>
 <32.312199,-70.409500,-24.970600>, <-0.332647,0.661821,0.671818>
}
   smooth_triangle{ <32.312199,-70.409500,-24.970600>, <-0.332647,0.661821,0.671818>
 <30.709999,-72.455803,-23.752300>, <-0.365875,0.671948,0.643911>
 <30.802200,-72.456001,-23.700399>, <-0.356303,0.669075,0.652217>
}
   smooth_triangle{ <30.709999,-72.455803,-23.752300>, <-0.365875,0.671948,0.643911>
 <32.312199,-70.409500,-24.970600>, <-0.332647,0.661821,0.671818>
 <31.997200,-70.399300,-25.134600>, <-0.331619,0.660861,0.673269>
}
   smooth_triangle{ <31.997200,-70.399300,-25.134600>, <-0.331619,0.660861,0.673269>
 <30.430201,-72.445801,-23.896099>, <-0.332626,0.661354,0.672288>
 <30.709999,-72.455803,-23.752300>, <-0.365875,0.671948,0.643911>
}
   smooth_triangle{ <30.430201,-72.445801,-23.896099>, <-0.332626,0.661354,0.672288>
 <31.997200,-70.399300,-25.134600>, <-0.331619,0.660861,0.673269>
 <31.478901,-70.386200,-25.407301>, <-0.339972,0.662280,0.667686>
}
   smooth_triangle{ <31.478901,-70.386200,-25.407301>, <-0.339972,0.662280,0.667686>
 <29.972099,-72.437500,-24.139200>, <-0.343881,0.663462,0.664503>
 <30.430201,-72.445801,-23.896099>, <-0.332626,0.661354,0.672288>
}
   smooth_triangle{ <29.972099,-72.437500,-24.139200>, <-0.343881,0.663462,0.664503>
 <31.478901,-70.386200,-25.407301>, <-0.339972,0.662280,0.667686>
 <30.763000,-70.373802,-25.788200>, <-0.346992,0.662666,0.663679>
}
   smoot